<%
/**
 *  File         : 	EgDefault.jsp
 *  Purpose      : 	To get the default thresholds for a particular test 
 *  Version      : 	0.1
 *  Creation Date: 	21/11/2000
 *  Last Modified:	
 *		25/03/2006	Thirumal Azhagan - UI changes for MIX policy.
 *		23/07/2004	Arun	Allows factors of SQC to be set for relative thresholds
 *		21/07/2004	Arun	Optimise use of EgThresholdInfo, allows SQC to have factors
		11/12/2003 //Saravanan - Medium priority Added for Single thresholds
		28/10/2003 //Saravanan - Multiple threshold changes
		30/11/2001  - 	Bharath G Display of server type 
		18/06/2001 //Sandhya - To check for space in absolute values.	
		12/06/2001 kk to check validity of numbers.
		21/12/2000 
 *  Author       :	Lavanya.T.K 
 *	Design Changes	:	Jaiwin
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgTesterInfo testerInfo=new EgTesterInfo("manager");
	EgThresholdInfo egThresh = new EgThresholdInfo("manager");
	String[] threshPol = new String[] 
		{
			"absolute",
			"relative",
			"none"
		};

	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String[] priorArr = new String[] 
		{
			ui.getStateDisplayLabel("LOW"),
			ui.getStateDisplayLabel("INTERMEDIATE"),
			ui.getStateDisplayLabel("HIGH")
		};
%>

<%
	ArrayList globalThresholdsTest=testerInfo.getGlobalThresholds();
	String pg = request.getParameter("page");
	String backUrl = null;
	String updateParam = "";
	if (pg == null)
		backUrl="Javascript:call()";
	else
	{
		updateParam = "EgUDTest.jsp";
		backUrl="EgUDTest.jsp";
	}

	String testName = request.getParameter("t_name");
	boolean isGlobalThresholds=false;
	if (globalThresholdsTest!=null && globalThresholdsTest.contains(testName))
	{
		isGlobalThresholds=true;
		threshPol = new String[] 
		{
			"absolute",
   			"none"
		};
		isGlobalThresholds=true;
	}else
	{
		isGlobalThresholds=false;
		threshPol = new String[] 
		{
			"absolute",
			"relative",
			"none"
		};
	}
	StringTokenizer st = null;
	StringTokenizer st2 = null;
	String strIniVar[];
	String strIniVal = null;
	String measure = "";
	String policy = "";
	String min = "";
	String max = ""; 
	String minimum = "";
	String maximum = ""; 
	String priority = ""; 
	String alarmString = ""; 
	String alarmpolicy = "";
	String pol="";
	String prior = "";
	String temp = "";
	String wholeStr = "";
	int count=0;
	Vector v_abs = new Vector();
	Vector v_temp = new Vector();
	String alarm_type="";
//*Monday, March 13, 2006*
	String absA = "";
	String absB = "";
	String relA = "";
	String relB = "";
	String absoluteA = "";
	String absoluteB = "";
	String relativeA = "";
	String relativeB = "";
	String strTok = "";
//************************

	List defaultPolicies=new ArrayList();
	defaultPolicies.add("immediate");
	defaultPolicies.add("shortterm");
	defaultPolicies.add("standard");
	defaultPolicies.add("longterm");

	String q_ctr=request.getParameter("qctr");
	String serverName=request.getParameter("server");
	session.setAttribute("server",serverName);
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String updateDefaultThreshToDb = servicesIniFile.getValue("MISC_ARGS","updateDefaultThreshToDb");
%>


<html>
<head>
<title>Default Thresholds For Tests</title>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui="admin"/>
<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

function check(fieldvalue)
{
	var dot_count = 0;
	var slash_count = 0;
	s_val = fieldvalue;
	for(var i=0;i < s_val.length;i++)
	{
		if(s_val.charAt(i) == '.')
		{
			dot_count = dot_count + 1;
		}
		else if (s_val.charAt(i) == '/')
		{
			slash_count++;
		}

		else
		{
			continue;
		}
	}
	if(dot_count > 1 && slash_count != 2)
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}
	if(s_val.charAt(s_val.length - 1) == '.')
	{
		alert('<egui:intnl text="admin.threshold.Invalid number"/>.');
		return false;
	}
	return true;
}

//validation for space
function checkspace(fieldvalue)
{
	s_val = fieldvalue;
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			alert('<egui:intnl text="admin.threshold.Space not allowed"/>.');
			return false;
		}
	}
	return true;
}

function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}

function isIE() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for IE ver 4+. 
   if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
   return false;
}

function populateNEW()
{
	var res = true;
	var num = document.testconfig.measNum.value;

	for(var i=0; i < num; i++)
	{
		var absA = "absA"+i;
		var absB = "absB"+i;
		var relA = "relA"+i;
		var relB = "relB"+i;

		var absoluteA = document.testconfig[absA].value;
		var absoluteB = document.testconfig[absB].value;
		var relativeA = document.testconfig[relA].value;
		var relativeB = document.testconfig[relB].value;

		// Negative value check
		var description = document.getElementById("ANV"+i).value;
		var arr = description.split(":");
		var measurement = arr[0];
		var isNegativeValuesAllowed = arr[1];


		// Absolute minimum - start
		if(!checkWithRegExp(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.testconfig[absA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteA.toLowerCase() != "none" && checkNegativeVal(absoluteA))
			{
				alert("<egui:intnl text='admin.threshold.Absolute minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[absA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(absoluteA.toLowerCase() != "none" && !checkAscendingOrder(absoluteA,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.testconfig[absA].focus();
			res=false;
			break;
		}
		// end

		//Relative minimum - start
		if(!checkWithRegExp(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1<n2<n3'/>"+".");
			document.testconfig[relA].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeA.toLowerCase() != "none" && checkNegativeVal(relativeA))
			{
				alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[relA].focus();
				res=false;
				break;
			}
		}

		//check ascending order
		if(relativeA.toLowerCase() != "none" && !checkAscendingOrder(relativeA,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Minimum threshold values representing Critical/Major/Minor should be in ascending order"/>');
			document.testconfig[relA].focus();
			res=false;
			break;
		}
		//end



		//Absolute maximum -start
		if(!checkWithRegExp(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".");
			document.testconfig[absB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(absoluteB.toLowerCase() != "none" && checkNegativeVal(absoluteB))
			{
				alert("<egui:intnl text='admin.threshold.Absolute maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[absB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(absoluteB.toLowerCase() != "none" && !checkDescendingOrder(absoluteB,0))
		{
			alert('<egui:intnl text="admin.threshold.Absolute Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.testconfig[absB].focus();
			res=false;
			break;
		}
		//end

		//Relative maximum - start
		if(!checkWithRegExp(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Invalid threshold entry"/>'+".\n"+'<egui:intnl text="admin.threshold.Possible reasons could be"/>'+" : \n"+
			"1) "+'<egui:intnl text="admin.threshold.Threshold values are not set for one/more measures"/>'+".\n"+
			"2) "+"<egui:intnl text='admin.threshold.Threshold specifications are not in the \'Critical/Major/Minor\' format'/>"+".\n"+
			"3) "+'<egui:intnl text="admin.threshold.One/more threshold entries contain special characters"/>'+".\n"+
			"4) "+"<egui:intnl text='admin.threshold.Relative threshold specifications are not in \'n1*sqc/n2*sqc/n3*sqc\' format where n1>n2>n3'/>"+".");
			document.testconfig[relB].focus();
			res=false;
			break;
		}

		// Negative value check
		if(isNegativeValuesAllowed == "false")
		{
			if(relativeB.toLowerCase() != "none" && checkNegativeVal(relativeB))
			{
				alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
				document.testconfig[relB].focus();
				res=false;
				break;
			}
		}

		//check descending order
		if(relativeB.toLowerCase() != "none" && !checkDescendingOrder(relativeB,1))
		{
			alert('<egui:intnl text="admin.threshold.Relative Maximum threshold values representing Critical/Major/Minor should be in descending order"/>');
			document.testconfig[relB].focus();
			res=false;
			break;
		}
		//end
	}

	if(res)
	{
		if (isNetscape()) targetObj = document.testconfig.update;
		if (isIE()) targetObj = document.testconfig.update;
		targetObj.disabled = true;
		var updateDefaultThreshToDb = '<%=updateDefaultThreshToDb%>';
		if (updateDefaultThreshToDb == 'true')
		{
			alert("<egui:intnl text='admin.threshold.This operation might take some time,please wait'/>....");
		}
		document.testconfig.submit();
	}
}

function checkWithRegExp(val,c)
{
	var regExp;
	if(c==0)
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))\/(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	}
	else
	{
		regExp = /^(none)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)\/(\-|\-?(([0-9]+\.|\.)?[0-9]+\*)?sqc)$/i;
	}
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeVal(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];

	if (Cri == "-")
	{
		Cri = "0";
	}

	if (Maj == "-")
	{
		Maj = "0";
	}

	if (Min == "-")
	{
		Min = "0";
	}

	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(Cri);
	if(!ret)
	{
		ret = regExp.test(Maj);
	}
	if(!ret)
	{
		ret = regExp.test(Min);
	}
	return ret;
}

function checkAscendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) >= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}

function checkDescendingOrder(val,c)
{
	var arr = val.split("/");
	var Cri,Maj,Min;
	Cri = arr[0];
	Maj = arr[1];
	Min = arr[2];
	if (c==1)
	{
		Cri = Cri.replace(/(\*sqc)/gi,"");
		Cri = Cri.replace(/sqc/g,"1");
		Maj = Maj.replace(/(\*sqc)/gi,"");
		Maj = Maj.replace(/sqc/g,"1");
		Min = Min.replace(/(\*sqc)/gi,"");
		Min = Min.replace(/sqc/g,"1");
	}

	var ret = true;
	if (Cri != "-" && Maj != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Maj))
		{
			ret = false;
		}
	}
	if (Maj != "-" && Min != "-")
	{
		if (parseFloat(Maj) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	if (Cri != "-" && Min != "-")
	{
		if (parseFloat(Cri) <= parseFloat(Min))
		{
			ret = false;
		}
	}
	return ret;
}
function populate()
{
	var threshSeries = '<%=ui.getStateDisplayLabel("HIGH")%>' + "/" + '<%=ui.getStateDisplayLabel("INTERMEDIATE")%>' + "/" + '<%=ui.getStateDisplayLabel("LOW")%>';
	var minArr = "";
	var maxArr = "";
	var relAArr = "";
	var relBArr = "";
	var absAArr = "";
	var absBArr = "";
<%
	boolean isConfigTest = EgInstallInfo.isConfigTest(testName);
%>
	var num = document.testconfig.measNum.value;
	var temp="false";
<%
	if(!isConfigTest)
	{
%>
	for(var i=0; i < num ; i++)
	{
		var absA = "absA"+i;
		var absB = "absB"+i;
		var relA = "relA"+i;
		var relB = "relB"+i;

//		var nam1 ="min"+i;
//		var nam2 ="max"+i;
		var nam3 ="pol"+i;

		var absoluteA = document.testconfig[absA].value;
		var absoluteB = document.testconfig[absB].value;
		var relativeA = document.testconfig[relA].value;
		var relativeB = document.testconfig[relB].value;
//*****************************************************************************
		if(!check(absoluteA))
		{
			temp="true";
			document.testconfig[absA].focus();
			break;
		}
		if(!check(absoluteB))
		{
			temp="true";
			document.testconfig[absB].focus();
			break;
		}
		if(!check(relativeA))
		{
			temp="true";
			document.testconfig[relA].focus();
			break;
		}
		if(!check(relativeB))
		{
			temp="true";
			document.testconfig[relB].focus();
			break;
		}
		
		var splChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()_+=[]{}|\\:;\"\'<>,\?"; 
		var threshType = document.testconfig.threshType.value;
//		alert("threshType    ------->"+threshType);
/*		if (relativeB != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		{
			alert("Multiple thresholds should be given in "+ threshSeries +" format");
			document.testconfig[relB].focus();
			temp = "true";
			break;
		}
		if (absoluteB != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		{
			alert("Multiple thresholds should be given in "+ threshSeries +" format");
			document.testconfig[absB].focus();
			temp = "true";
			break;
		}
		if (absoluteA != 'none' && threshType != null && threshType == 'Multiple' && maxArr.length != 3)
		{
			alert("Multiple thresholds should be given in "+ threshSeries +" format");
			document.testconfig[absA].focus();
			temp = "true";
			break;
		}
		if (relativeA != 'none' && threshType != null && threshType == 'Multiple' && minArr.length != 3)
		{
			alert("Multiple thresholds should be given in "+ threshSeries +" format");
			document.testconfig[relA].focus();
			temp = "true";
			break;
		}	*/

		var description = document.getElementById("ANV"+i).value;
		var desc = description.split(":");
		var measurement = desc[0];
		var isNegativeValuesAllowed = desc[1];
		
		if (relativeA.length != 0 && !(relativeA == 'none'))
		{
			relAArr = relativeA.split("/");
			if(relAArr.length == 3)
			{
				if(trim(relAArr[0]) == '' || trim(relAArr[1]) == '' || trim(relAArr[2]) == '')
				{
					alert('<egui:intnl text="admin.threshold.Empty values are not allowed"/>');
					document.testconfig[relA].focus();
					temp = "true";
					break;
				}
				else 
				{
					if (isNegativeValuesAllowed == 'false')
					{
						if(!(isValidSqcFactor(relAArr[0],false) && isValidSqcFactor(relAArr[1],false) && isValidSqcFactor(relAArr[2],false)))
						{
							alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\',\'none\' and \'sqc with a positive value\''/>.");
							document.testconfig[relA].focus();
							temp = "true";
							break;
						}
					}
					else
					{
						if(!(isValidSqcFactor(relAArr[0],true) && isValidSqcFactor(relAArr[1],true) && isValidSqcFactor(relAArr[2],true)))
						{
							alert("<egui:intnl text='admin.threshold.Relative minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\' and \'none\' values'/>.");
							document.testconfig[relA].focus();
							temp = "true";
							break;
						}
					}
					
				}
				if(!isRelativeAscending(relAArr[0],relAArr[1],relAArr[2])){
					alert("<egui:intnl text='admin.threshold.Min Relative threshold policy should be in ascendiing order'/>");
					document.testconfig[relA].focus();
					temp = "true";
					break;
				}
				
			}else
			{
				alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
				document.testconfig[relA].focus();
				temp = "true";
				break;
			}
		}
		if (relativeB.length != 0 && !(relativeB == 'none'))
		{
			relBArr = relativeB.split("/");
			if(relBArr.length == 3)
			{
				if(trim(relBArr[0]) == '' || trim(relBArr[1]) == '' || trim(relBArr[2]) == '')
				{
					alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
					document.testconfig[relB].focus();
					temp = "true";
					break;
				}
				else 
				{
					if (isNegativeValuesAllowed == 'false')
					{
						if(!(isValidSqcFactor(relBArr[0],false) && isValidSqcFactor(relBArr[1],false) && isValidSqcFactor(relBArr[2],false)))
						{
							alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\',\'none\' and \'sqc with a positive value\''/>.");
							document.testconfig[relB].focus();
							temp = "true";
							break;
						}
					}
					else
					{
					
						if(!(isValidSqcFactor(relBArr[0],true) && isValidSqcFactor(relBArr[1],true) && isValidSqcFactor(relBArr[2],true)))
							{
								alert("<egui:intnl text='admin.threshold.Relative maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.can have only \'sqc\',\'-\' and \'none\' values'/>.");
								document.testconfig[relB].focus();
								temp = "true";
								break;
							}
					}
					
				}

				if(!isRelativeDescending(relBArr[0],relBArr[1],relBArr[2])){
					alert("<egui:intnl text='admin.threshold.Max Relative threshold policy should be in descending order'/>");
					document.testconfig[relB].focus();
					temp = "true";
					break;
				}
			}else
			{
				alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
				document.testconfig[relB].focus();
				temp = "true";
				break;
			}
		}

		if (absoluteA.length != 0 && !(absoluteA == 'none'))
		{
			var str_temp="true";
			for(var x=0; x<splChar.length; x++)
			{
				check_char = absoluteA.indexOf(splChar.charAt(x));
				if(check_char >= 0)
				{
					str_temp="false";
				}
			}

			if(str_temp == "true")
			{
				absAArr = absoluteA.split("/");
				if(absAArr.length != 3)// && absAArr.length != 1)
				{
					alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
					document.testconfig[absA].focus();
					temp = "true";
					break;
				}

				if(absAArr.length == 3)
				{
					if(trim(absAArr[0]) == '' || trim(absAArr[1]) == '' || trim(absAArr[2]) == '')
					{
						alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
						document.testconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if ((absAArr[0] != '-' && trim(absAArr[0]) != '') &&
					(absAArr[1] != '-' && trim(absAArr[1]) != ''))
				{
					if(eval(absAArr[0]) >= eval(absAArr[1]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//	alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
	
						document.testconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if ((absAArr[1] != '-' && trim(absAArr[1]) != '') &&
					(absAArr[2] != '-' && trim(absAArr[2]) != ''))
				{
					if(eval(absAArr[1]) >= eval(absAArr[2]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
						document.testconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if((absAArr[0] != '-' && trim(absAArr[0]) != '') &&
					(absAArr[2] != '-' && trim(absAArr[2]) != ''))
				{
					if(eval(absAArr[0]) >= eval(absAArr[2]))
					{
						//alert("Threshold values representing High/Medium/Low should be in ascending order");
						//alert("Minimum threshold values representing "+threshSeries+" should be in ascending order");
						alert("<egui:intnl text='admin.threshold.Minimum threshold values representing Critical/Major/Minor should be in ascending order'/>");
						document.testconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if (isNegativeValuesAllowed == 'false')
				{
					if (isNegative(absAArr[0],absAArr[1],absAArr[2]))
					{
						alert("<egui:intnl text='admin.threshold.Absolute minimum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
						document.testconfig[absA].focus();
						temp = "true";
						break;
					}
				}

				if(str_temp == "false")
				{
					temp = "true";
					break;
				}
			}
			if(str_temp == "false")
			{
				alert("<egui:intnl text='admin.threshold.Alphabets,special characters and \'sqc\' values are not allowed for Absolute threshold policy!'/>");
				//document.testconfig[nam1].value="";
				document.testconfig[absA].focus();
				temp="true";
				break;
			}
		}

		if (absoluteB.length != 0 && !(absoluteB == 'none'))
		{
			var str_tem="true";
			for(var k=0; k<splChar.length; k++)
			{
				check_cha = absoluteB.indexOf(splChar.charAt(k));
				if(check_cha >= 0)
				{
						str_tem="false";
				}
			}
			if(str_tem == "true")
			{
				absBArr = absoluteB.split("/");
				if(absBArr.length != 3) //&& absBArr.length != 1)
				{
					alert("<egui:intnl text='admin.threshold.Please provide the threshold values in Critical/Major/Minor format'/>");
					document.testconfig[absB].focus();
					temp = "true";
					break;
				}
				if(absBArr.length == 3)
				{
					if(absBArr[0] == '' || absBArr[1] == '' || absBArr[2] == '')
					{
						alert("<egui:intnl text='admin.threshold.Empty values are not allowed'/>");
						document.testconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if(isNegativeValuesAllowed == 'false')
				{
					if(isNegative(absBArr[0],absBArr[1],absBArr[2]))
					{
						alert("<egui:intnl text='admin.threshold.Absolute maximum'/> <egui:intnl text='admin.threshold.for'/>"+" \'"+measurement+"\' "+"<egui:intnl text='admin.threshold.should not contain negative values'/>.");
						document.testconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if ((absBArr[0] != '-' && trim(absBArr[0]) != '') &&
					(absBArr[1] != '-' && trim(absBArr[1]) != ''))
				{
					if(eval(absBArr[1]) >= eval(absBArr[0]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						//	alert("Maximum threshold values representing "+threshSeries+" should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.testconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if ((absBArr[1] != '-' && trim(absBArr[1]) != '') && (absBArr[2] != '-' && trim(absBArr[2]) != ''))
				{
					if(eval(absBArr[2]) >= eval(absBArr[1]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						//	alert("Maximum threshold values representing "+threshSeries+" should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.testconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if ((absBArr[0] != '-' && trim(absBArr[0]) != '') && (absBArr[2] != '-' && trim(absBArr[2]) != ''))
				{
					if(eval(absBArr[2]) >= eval(absBArr[0]))
					{
						//alert("Threshold values representing High/Medium/Low should be in descending order");
						//	alert("Maximum threshold values representing "+threshSeries+" should be in descending order");
						alert("<egui:intnl text='admin.threshold.Maximum threshold values representing Critical/Major/Minor should be in descending order'/>");
						document.testconfig[absB].focus();
						temp = "true";
						break;
					}
				}

				if(str_tem == "false")
				{
					temp = "true";
					break;
				}
			}

			if(str_tem == "false")
			{
				alert("<egui:intnl text='admin.threshold.Alphabets,special characters and \'sqc\' values are not allowed for Absolute threshold policy!'/>");
				//document.testconfig[nam2].value="";
				document.testconfig[absB].focus();
				temp="true";
				break;
			}
		}
//		alert("rwwwelativeA  :"+absoluteA);
//		alert("rwwwelativeA  :"+absoluteB);

		if(absoluteA != 'none' && absoluteB != 'none')
		{
//		if(true) return;
			absAArr = absoluteA.split("/");
			absBArr = absoluteB.split("/");
			if(absAArr.length == 3 && absBArr.length == 3)
			{
/*				if(eval(absAArr[0]) < eval(absBArr[0]))
				{
					document.testconfig[absA].focus();
					temp="true";
					alert("Maximum wwwvalue should be greater than the minimum value.");
					break;
				}*/
			}
		}
		if((absoluteA == 'sqc' || absoluteB == 'sqc'))
		{
			if(absoluteA == 'sqc')// || minimum == 'none')
			{
				alert("<egui:intnl text='admin.threshold.Absolute threshold policy cannot have \'sqc\' values!'/>");
				document.testconfig[absA].focus();
				temp="true";
				break;
			}
			if(absoluteB == 'sqc')// || minimum == 'none')
			{
				alert("<egui:intnl text='admin.threshold.Absolute threshold policy cannot have \'sqc\' values!'/>");
				document.testconfig[absB].focus();
				temp="true";
				break;
			}
		}
		else if(absoluteA != 'none' || absoluteA != 'sqc')
		{
			if(!checkspace(absoluteA))
			{
				document.testconfig[nam2].focus();
				temp = "true";
				break;
			}
		}
		else if(absoluteB != 'none' || absoluteB != 'sqc')
		{
			if(!checkspace(absoluteB))
			{
				document.testconfig[absB].focus();
				temp = "true";
				break;
			}
		}
	}
//******************************************
<%
	}
%>
	
	if(temp == 'false')
	{
		if (isNetscape()) targetObj = document.testconfig.update;
		if (isIE()) targetObj = document.testconfig.update;
		targetObj.disabled = true;

		//alert("Please wait...");
		document.testconfig.update.value="<egui:intnl text='admin.common.Updating'/>...";
		document.testconfig.submit();
	}
	else{}
}

function trim(s)
{
	if(s != null)
	{
		while (s.substring(0,1) == ' ') 
		{
			s = s.substring(1,s.length);
		}

		while (s.substring(s.length-1,s.length) == ' ')
		{
			s = s.substring(0,s.length-1);
		}
	}
	return s;
}

function isValidSqcFactor(value,isNegative)
{
	var tokens = value.split("*");
	if (tokens.length == 2)
	{
		if (!isNegative)
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}else
		{
			if ((isNumber("+", tokens[0]) && tokens[1] == 'sqc')||(isNumber("-", tokens[0]) && tokens[1] == 'sqc'))
			{
				return true;
			}
		}

	}
	else if (tokens.length == 1 && (tokens[0] == 'sqc' || tokens[0] == "-"))
	{
		return true;
	}

	return false;
}

function isRelativeDescending(val1,val2,val3){
	var token1 = val1.split("*");
	var token2 = val2.split("*");
	var token3 = val3.split("*");

	if(token1[0] == 'sqc') token1[0] = '1';
	if(token2[0] == 'sqc') token2[0] = '1';
	if(token3[0] == 'sqc') token3[0] = '1';

	if(token1[0] == '1'){
		if(token2[0] != '-' || token3[0] != '-'){
			return false;
		}
	}
	if(token2[0] == '1' && token3[0] != '-'){
			return false;
	}
	if(token2[0] != '-' && token3[0] != '-'){
		if( (eval(token2[0]) < eval(token3[0])) ||  (eval(token2[0]) == eval(token3[0])) ){
			return false;
		}
	}
	if(token1[0] != '-' && token2[0] != '-'){
		if( (eval(token1[0]) < eval(token2[0])) || (eval(token1[0]) == eval(token2[0]))){
			return false;
		}
	}
	if(token1[0] != '-' && token3[0] != '-'){
		if( (eval(token1[0]) < eval(token3[0])) || (eval(token1[0]) == eval(token3[0])) ){
			return false;
		}
	}
	return true;
}

function isNegative(val1,val2,val3)
{
	if ((val1 >= 0 || val1 == '-1' || val1 == '-') &&
		(val2 >= 0 || val2 == '-1' || val2 == '-') &&
		(val3 >= 0 || val3 == '-1' || val3 == '-'))
	{
		return false;
	}
	else
	{
		return true;
	}
}

function isRelativeAscending(val1,val2,val3){
	var token1 = val1.split("*");
	var token2 = val2.split("*");
	var token3 = val3.split("*");

	if(token1[0] == 'sqc') token1[0] = '1';
	if(token2[0] == 'sqc') token2[0] = '1';
	if(token3[0] == 'sqc') token3[0] = '1';

	if(token1[0] == '9'){
		if(token2[0] != '-' || token3[0] != '-'){
			return false;
		}
	}
	if(token2[0] == '9' && token3[0] != '-'){
			return false;
	}
	if(token2[0] != '-' && token3[0] != '-'){
		if( (eval(token2[0]) > eval(token3[0])) || (eval(token2[0]) == eval(token3[0])) ){
			return false;
		}
	}
	if(token1[0] != '-' && token2[0] != '-'){
		if( (eval(token1[0]) > eval(token2[0])) || (eval(token1[0]) == eval(token2[0])) ){
			return false;
		}
	}
	if(token1[0] != '-' && token3[0] != '-'){
		if( (eval(token1[0]) > eval(token3[0])) || (eval(token1[0]) == eval(token3[0])) ){
			return false;
		}
	}
	return true;
}


function call()
{
	window.location.href ="EgTestList.jsp?&server=" + "<%= request.getParameter("server")%>" + "&qctr=1";
}

</script>
</head>

<!-- <body leftmargin="0" topmargin="20" marginwidth="0" marginheight="20" bgcolor="#FFFFFF"> -->
<body style="overflow:auto" id="space6" >
<form name="testconfig" method="post" action="Egdefaultp.jsp" style="margin:0px">
<input type="hidden" name="agg_test_name" value="<%=request.getParameter("t_name")%>">
<input type="hidden" name="normalTestName" value="<%=request.getParameter("normalTestName")%>">
<input type = "hidden" name="updateparam" value="<%= updateParam %>">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<jsp:include page="listSearch.jsp?title=AGENT - DEFAULT THRESHOLDS&leftString=Add User&backButton=true&subtitle=false"/>

	<!-- <tr>		
		<td width="100%" id="body_headbg">
			<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="head_padding2">
				<tr>
					<td id="eg_maintitle" nowrap> &nbsp; AGENT - THRESHOLDS &nbsp; </td>
					<td  nowrap  width="90%" align="right"><input type="button" value="<<&nbsp;Back" style="width: 60px; height: 19;" id="eg_back" onClick="javascript:history.back();">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr> -->
<%
	String[] hostTests = egSpecs.getDefaultTestsForServer("Host_system");
	ArrayList hostTestsList = new ArrayList();
	if (hostTests != null)
	{
		hostTestsList = new ArrayList(Arrays.asList(hostTests));
	}
	if (hostTestsList.contains(testName))
	{
%>
	<tr align="center">
		<td>*&nbsp;<egui:intnl text="admin.threshold.Changes made to default thresholds will be applied to all component types to which this test is mapped"/></td>
	</tr>
<%	
	}
%>	
	<tr>
		<td width="100%" height="22"  align="center"><br>
		<table align="center" border="0" cellpadding="0" cellspacing="0" height="22" width="85%">
		<tr>
			<td id="subhead_left" width="7">
				<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
			</td>
			<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%">
<%
		if(pg != null)
		{
%>	
				<egui:intnl text="admin.threshold.Default thresholds of"/> <b><egui:intnl test="<%= testName%>"/></b>
<%
		}
		else
		{
			//if(egSpecs.isPortRelevantForTest(testName))
			if(!hostTestsList.contains(testName))
			{
%>
				<egui:intnl text="admin.threshold.Default thresholds of "/> <b><egui:intnl test="<%= testName%>"/></b>&nbsp;<egui:intnl text="admin.common.for"/>&nbsp;<b><egui:intnl type="<%=serverName%>"/></b>
<%
			}
			else
			{
%>
				<egui:intnl text="admin.threshold.Default thresholds of"/> <b><egui:intnl test="<%= testName%>"/></b>&nbsp;<egui:intnl text="admin.common.for"/>&nbsp;<b><egui:intnl text="admin.threshold.Operating System"/></b>
<%
			}
		}
%>
			</td>
			<td id="subhead_right" width="7">
				<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
			</td>
			</tr>
		</table>
		</td>
	</tr>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td align="center" valign="top">
<%
//		prgBean.createFile("eg_thresholds.ini");
//		String[] alarmPolicies= prgBean.getVariables(subjectAlarm);
		String[] alarmPolicies= egThresh.getAllAlarmPolicies();

		//Inifile operations
//		strIniVar = prgBean.getVariables("DEFAULT_THRESHOLDS");
		strIniVar = egThresh.getDefaultThresholds();
		boolean multiThresh = false;
		for(int i=0; i<strIniVar.length; i++)
		{
			if(strIniVar[i].startsWith(";"))
			{
				continue;
			}
			if(strIniVar[i].equals(testName))
			{
//				strIniVal = prgBean.getStrValue("DEFAULT_THRESHOLDS",strIniVar[i]);
				strIniVal = egThresh.getDefaultThresholdValue(strIniVar[i]);
				//out.println("strIniVal==>"+strIniVal);
				st = new StringTokenizer(strIniVal,",");
				//This code to find if multiple thresholds is present..... START
				String s_tempStr1 = "";
				StringTokenizer st1;
/*				while(st.hasMoreTokens())
				{
					s_tempStr1 = st.nextToken();
					st1 = new StringTokenizer(s_tempStr1, ":");
					while(st1.hasMoreTokens())
					{
						st1.nextToken(); // remove measure token
						st1.nextToken(); // remove policy token
						min = st1.nextToken();
						max = st1.nextToken();
						
						if((min.indexOf("/") > -1) && !(min.equals("-1")))
							{
							if(!(min.lastIndexOf("-") > min.indexOf("-")))
							{
								multiThresh = true;
								break;
							}
						}
						if((max.indexOf("/") > -1) && !(max.equals("-1")))
						{
							if(!(max.lastIndexOf("-") > max.indexOf("-")))
							{
								multiThresh = true;
								break;
							}
						}
						break;
					}
				}	*/
				// END

			if(true)
			{
%>
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="cell_border1">
						<col width="29%"><col width="29%"><col width="29%"><col width="13%">
							<tr>
								<td id="table_head" class="eg_subcontent" align="center" height="20"><b><egui:intnl text="admin.threshold.Measurements"/></b></td>
								<td id="table_head" class="lineleft"  align="center" ><b><egui:intnl text="admin.threshold.Minimum"/></b></td>
								<td id="table_head" class="lineleft"  align="center" ><b><egui:intnl text="admin.threshold.Maximum"/></b></td>
								<td id="table_head" class="lineleft"  align="center" ><b><egui:intnl text="admin.threshold.Alarm Policy"/></b></td>
							</tr>
							
							<tr>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="left">&nbsp;</td>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="left"  >
									<table cellspacing="0" cellpadding="3" border="0" width="100%" >
										<tr>
											<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
											<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
										</tr>
									</table>
								</td>
								<td id="eg_cellbgmedium" class="eg_subcontent"  align="left" >
									<table cellspacing="0" cellpadding="0" border="0" width="100%">
										<tr>
											<td align="center" width="42%" class="eg_subcontent"><egui:intnl text="admin.threshold.Absolute"/></td>
											<td width="68%" align="center" class="eg_subcontent"><egui:intnl text="admin.threshold.Relative"/></td>
										</tr>
									</table>
								</td>
								<td id="eg_cellbgmedium" class="eg_subcontent" align="left"></td>
							</tr>
<!-- 							<tr>
								<td colspan="5" id="eg_blankspace" nowrap height="7" id="eg_cellbglits">&nbsp;</td>
							</tr>
 -->							

<%
				v_abs = new Vector();
				strIniVal = egThresh.getDefaultThresholdValue(strIniVar[i]);
				v_abs.addElement(serverName);
				v_abs.addElement(testName);
				count=0;
				v_temp = new Vector();
				//boolean cellFlag = false;
				boolean tdcolor=false;
				//out.print(tdcolor);
				ArrayList allAuditLogList = new ArrayList();
				while(st.hasMoreTokens())
				{
					

					//cellFlag=!cellFlag;
					strTok=st.nextToken();
					st1 = new StringTokenizer(strTok,":");
					while(st1.hasMoreTokens())
					{
						prior = "";
						measure = st1.nextToken();
						policy = st1.nextToken();
						if(policy.equalsIgnoreCase("none"))
						{
							policy = "mix";
						}
						//~~~~~~3/4/2006 thirumal ~~~~~~
						if (policy.equalsIgnoreCase("relative"))
						{
							min = st1.nextToken();
							relA = min;
							if (min.equals("-1"))
							{
								relA = "none";
								min = relA;
							}
							max = st1.nextToken();
							relB = max;
							if (max.equals("-1"))
							{
								relB = "none";
								max = relB;
							}
							alarmpolicy = st1.nextToken();
							st1.nextToken();
							wholeStr=measure+":"+policy+":"+ relA+":"+relB;
							v_temp.addElement(wholeStr);
							absA = "none";
							absB = "none";
						}else if (policy.equalsIgnoreCase("absolute"))
						{
							min = st1.nextToken();
							absA = min;
							if (min.equals("-1"))
							{
								absA = "none";
								min = absA;
							}
							max = st1.nextToken();
							absB = max;
							if (max.equals("-1"))
							{
								absB = "none";
								max = absB;
							}
							alarmpolicy = st1.nextToken();
							st1.nextToken();
							wholeStr=measure+":"+policy+":"+ absA+":"+absB;
							v_temp.addElement(wholeStr);
							relA = "none";
							relB = "none";
						}else if (policy.equalsIgnoreCase("mix"))
						{
							min = st1.nextToken();
							max = st1.nextToken();
							Vector _vec = getAbsAndRel(min);
							absA = (String) _vec.get(0);
							relA = (String) _vec.get(1);
							Vector _vec1 = getAbsAndRel(max);
							absB = (String) _vec1.get(0);
							relB = (String) _vec1.get(1);
							alarmpolicy = st1.nextToken();
							st1.nextToken();
							StringBuffer sb1 = new StringBuffer();
							StringBuffer sb2 = new StringBuffer();
							sb1.append(absA);
							sb1.append("&");
							sb1.append(relA);
							String m1 = sb1.toString();
							sb2.append(absB);
							sb2.append("&");
							sb2.append(relB);
							String m2 = sb2.toString();
							if (absA.equals("none") && relA.equals("none"))
								m1 = "none";
							if (absB.equals("none") && relB.equals("none"))
								m2 = "none";
							wholeStr = measure+":"+policy+":"+ m1+":"+m2;
							v_temp.addElement(wholeStr);
						}else	//none
						{
							min = st1.nextToken();
							max = st1.nextToken();
							absA = min;
							absB = max;
							if (min.equals("-1"))
							{
								absA = "none";
								min = absA;
							}
							if (max.equals("-1"))
							{
								absB = "none";
								max = absA;
							}
							alarmpolicy = st1.nextToken();
							st1.nextToken();
							wholeStr=measure+":"+policy+":"+ absA+":"+absB;
							v_temp.addElement(wholeStr);
							relA = "none";
							relB = "none";
						}
						//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
						pol="pol"+count;

						

%>
							<!-- <tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
								<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
								<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr> -->
							<tr >
								<td id="<%=tdcolor?"cell_border3":"cell_border4"%>" class="eg_subcontent" wrap style="padding-left:5px" >
<%
	boolean isNegativeValuesAllowed = testerInfo.isNegativeValuesAllowed(testName,measure);
	String readOnly = "";
	if(isNegativeValuesAllowed)
	{
		readOnly = "readOnly";
	}

	String measureNameForUI = _mapping.getMeasureDescription(testName,measure);
	String colon=":";
%>
								<egui:intnl measure="<%=testName+colon+measure%>"/><input type=hidden name=<%=pol%> value=<%=policy%>>
								<input type="hidden" id="<%="ANV"+count%>" name="<%="ANV"+count%>" value='<%=measureNameForUI+":"+isNegativeValuesAllowed%>'>
								</td>
<%
						ArrayList auditLogList = new ArrayList();
						auditLogList.add((testName+":"+measure));
						auditLogList.add(absA);
						auditLogList.add(relA);
						auditLogList.add(absB);
						auditLogList.add(relB);
						auditLogList.add(alarmpolicy);
						allAuditLogList.add(auditLogList);
						absoluteA = "absA"+count;						
						absoluteB = "absB"+count;						
						relativeA = "relA"+count;
						relativeB = "relB"+count;
						alarmString="alarm"+count;

						String readOnlyStr = "";
						if(isGlobalThresholds) {
							readOnlyStr = "id=input_disabled readonly";
						}
%>
								<td  id="<%=tdcolor?"cell_border3":"cell_border4"%>" class="eg_subcontent" align="center" >
									<table cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td><input type=text name=<%=absoluteA%> value=<%=absA%> size="8" style="width:85px"></td>
											<td width="30">&nbsp;</td>
											<td id="eg_subcontentbg" class="eg_subcontent" align="center" ><input type=text name="<%=relativeA%>" value="<%=relA%>" size="8" class="list" style="width:110px" <%=readOnlyStr%> <%=readOnly%>></td>
										</tr>
									</table>
								</td>
								<td id="<%=tdcolor?"cell_border3":"cell_border4"%>" class="eg_subcontent" align="center" >
									<table cellspacing="0" cellpadding="0" border="0" >
										<tr>
											<td><input type=text name=<%=absoluteB%> value=<%=absB%> size="8" style="width:85px"></td>
											<td width="30">&nbsp;</td>
											<td id="eg_subcontentbg" align="center" ><input type=text name="<%=relativeB%>" value="<%=relB%>" size="8" class="list" style="width:110px" <%=readOnlyStr%> <%=readOnly%>></td>
										</tr>
									</table>
								</td>
								<td id="<%=tdcolor?"cell_border3":"cell_border4"%>" class="eg_subcontent"  align="center" style="padding:3px">
								<select name="<%=alarmString%>" class="list" style="width:85px">
<%
									for (int x=0;x<alarmPolicies.length;x++)
									{
										if (defaultPolicies.contains(alarmPolicies[x]))
										{
%>											
											<option value="<%=alarmPolicies[x]%>"  <%=(alarmPolicies[x].equals(alarmpolicy))?"selected":""%> ><egui:intnl text='<%="admin.threshhold."+alarmPolicies[x]%>'/></option>		
<%										}else
										{
%>											
											<option value="<%=alarmPolicies[x]%>"  <%=(alarmPolicies[x].equals(alarmpolicy))?"selected":""%> ><%=alarmPolicies[x]%></option>		
<%										}
									}
%>
								<%//=HtmlUtils.setSelectOptions(alarmPolicies, alarmpolicy)%>
								</select>
								</td>
<%
						v_abs.addElement(measure);
						v_abs.addElement(policy);
						v_abs.addElement(min);
						v_abs.addElement(max);
						v_abs.addElement(alarmpolicy);
						v_abs.addElement(prior);
						session.setAttribute("v_absolute",v_abs);

					
					} 
					count=count+1;
					

%>
							</tr>
							<!-- <tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
							<tr>
								<td colspan="5" id="eg_blankspace" nowrap height="7" id="eg_cellbglits">&nbsp;</td>
							</tr> -->
<%	tdcolor=!tdcolor;
			
				}
					session.setAttribute("previousValues",allAuditLogList);
%>
			<input type="hidden" name="threshType" value="Multiple">
<%
				session.setAttribute("v_compare",v_temp);
			}
		}
	}
%>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="4" height="15" align="center">
					&nbsp;
					</td>
				</tr>
				<tr>
					<td colspan="4" height="26" align="center">
					<input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" onClick="javascript:populateNEW()">
					</td>
				</tr>
			</table>
		<input type=hidden name="measNum" value=<%=count%>> 
		</td>
	</tr>
</table>
</form>
</body>
</html>
<%!
	// T.Thirumal Azhagan    3/7/2006
	public Vector getAbsAndRel(String format) // for mix format in threshold ,introduced by BOSS(MIX)
	{
		Vector vect = new Vector();	// [absolute,relative]
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String h;
			String m;
			String l;
			String H = stok1.nextToken();
			String M = stok1.nextToken();
			String L = stok1.nextToken();
			if (!(H.equals("-")))
			{
				if (H.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(H,"&");
					H = st.nextToken();
					h = st.nextToken();
				}else
				{
					if (H.indexOf("sqc") > -1)
					{
						h = H;
						H = "-";
					}else
						h = "-";
				}
			}else
			{
				h = "-";
			}
			if (!(M.equals("-")))
			{
				if (M.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(M,"&");
					M = st.nextToken();
					m = st.nextToken();
				}else
				{
					if (M.indexOf("sqc") > -1)
					{
						m = M;
						M = "-";
					}else
						m = "-";
				}
			}else
			{
				m = "-";
			}
			if (!(L.equals("-")))
			{
				if (L.indexOf("&") > -1)
				{
					StringTokenizer st = new StringTokenizer(L,"&");
					L = st.nextToken();
					l = st.nextToken();
				}else
				{
					if (L.indexOf("sqc") > -1)
					{
						l = L;
						L = "-";
					}else
						l = "-";
				}
			}else
			{
				l = "-";
			}
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (H.equals("-") && M.equals("-") && L.equals("-"))
			{
				s1 = "none";
			}else
			{
				sb1.append(H);
				sb1.append("/");
				sb1.append(M);
				sb1.append("/");
				sb1.append(L);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (h.equals("-") && m.equals("-") && l.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}else
			{
				sb2.append(h);
				sb2.append("/");
				sb2.append(m);
				sb2.append("/");
				sb2.append(l);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}
%>
<%
session.setAttribute("adminLastAccessedURL","/final/admin/EgDefault.jsp?"+request.getQueryString());
%>
