<%@ include file= "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import="net.sf.json.*" %>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.MappingNameSorter"%>

<%! 
	public String getCategoryForCompononetType(String compType)
	{
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		String[] subs = iniFile.getSubjects();
		String res ="";
		if(subs!=null)
		{
			for (int s=0; s<subs.length; s++)
			{
				String sub = subs[s];
				String[] vars = iniFile.getVariables(sub);
				if(vars!=null)
				{
					List compTypes = Arrays.asList(vars);
					if(compTypes.contains(compType))
					{
						res = sub;
					}
				}
			}
		}
		return res;
	}
%>
<%
	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String s_name = request.getParameter("name");
	String s_elementType = request.getParameter("elementType");
	EgGroupInfo groupInfo = new EgGroupInfo();
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList values = aggregateInfo.getAssociatedElementNames(s_elementType);
	if(values == null) values = new ArrayList();
	if(StringUtils.isNull(s_name) && !values.isEmpty())
	{
		s_name=(String)values.get(0);
	}
	ArrayList components = aggregateInfo.getAggregateComponentsOfElement(s_elementType, s_name);
	if(components == null)
		components = new ArrayList();
	//Getting all anchor components of all types which were set for zone/service/segment
	Hashtable anchorTypeComponent = null;
	Hashtable anchorComponents = aggregateInfo.getAnchorComponentsOfElement(s_elementType, s_name);
	if(anchorComponents != null && !anchorComponents.isEmpty())
	{
		anchorTypeComponent = new Hashtable();
		Iterator compItr = anchorComponents.keySet().iterator();
		while(compItr.hasNext())
		{
			String s = (String)compItr.next();
			String type = s.substring(0,s.indexOf(":"));
			anchorTypeComponent.put(type,s);
		}
	}

	boolean isElementZone = s_elementType.equalsIgnoreCase("zone");
	Hashtable ht = new Hashtable();
	for(int i=0;i<components.size();i++)
	{
		String component = (String) components.get(i);
		String type = component.substring(0,component.indexOf(":"));
		if(ht.containsKey(type))
		{
			ArrayList alist = (ArrayList) ht.get(type);
			alist.add(component);
			ht.put(type,alist);
		}
		else
		{
			ArrayList alist = new ArrayList();
			alist.add(component);
			ht.put(type,alist);
		}
	}
	int totalComponents = components.size();
	String key = "admin.common.No aggregate components have been created from " + s_elementType+"s";
	String errorMessage = _mapping.getTextDescription(key)+".";
	rootJson.put("errorMessage",errorMessage);
	rootJson.put("elementName",s_name);
	rootJson.put("displayName",_mapping.getTextDescription("admin.common."+s_elementType.substring(0,1).toUpperCase()+s_elementType.substring(1)));
	rootJson.put("gridTitle",_mapping.getTextDescription("admin.infrastructure.Total Components") + "&nbsp;:&nbsp;" + totalComponents);
	rootJson.put("totalComponents",totalComponents);
	if(totalComponents>0)
	{
		JSONArray comboArray =new JSONArray();
		for(int i=0;i<values.size();i++)
		{
			String str = (String)values.get(i);
			JSONObject comboObject = new JSONObject();
			comboObject.put("displayField",str);
			comboObject.put("valueField",str);
			comboArray.add(comboObject);
		}
		rootJson.put("comboboxDataList",comboArray);
		ArrayList siteServers = new com.eg.EgDiscInfo("manager").getSiteServers();
		if(siteServers == null)
			siteServers = new ArrayList();
		JSONArray gridArray =new JSONArray();
		ArrayList compTypes = new ArrayList(ht.keySet());
		MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
		compTypes = sorter.getSortedCompTypeList(compTypes);
		for(int c=0;c<compTypes.size();c++)
		{
			EgName nameObj = (EgName)compTypes.get(c);
			String aggCompType = nameObj.getActualName();
			String normalServerType = aggCompType.substring(aggCompType.indexOf("_")+1);
			String serverGategory = getCategoryForCompononetType(normalServerType);
			ArrayList aggregateComponents = (ArrayList) ht.get(aggCompType);
			JSONObject gridDataObject = new JSONObject();
			gridDataObject.put("aggType",nameObj.getLocalName());
			gridDataObject.put("count",aggregateComponents.size());
			String anchorComp = null;
			String anchorCompNick = null;
			if(anchorTypeComponent != null && anchorTypeComponent.containsKey(aggCompType))
			{
				anchorComp = (String)anchorTypeComponent.remove(aggCompType);
				anchorCompNick = anchorComp.substring(anchorComp.indexOf(":")+1,anchorComp.lastIndexOf(":"));
				if(aggregateComponents.contains(anchorComp))
				{
					Collections.sort(aggregateComponents,String.CASE_INSENSITIVE_ORDER);
					aggregateComponents.remove(anchorComp);
					aggregateComponents.add(0,anchorComp);
				}
			}
			String tmpStr = "<table class='mylink' cellspacing=\"0\" cellpadding=\"4\" border=\"0\" width=\"99%\" align=\"left\"><tr>";
			if(aggregateComponents != null && aggregateComponents.size() > 0)
			{
				int countColumn = 0;
				for (int i = 0;i<aggregateComponents.size();i++)
				{
					String aggComp = (String)aggregateComponents.get(i);
					String autoAssociatedToZone = isElementZone && groupInfo.doesComponentExistUnderZone(s_name, aggComp) ?"yes":"no";
					String nickPort = aggComp.substring(aggComp.indexOf(":")+1);
					String nick = aggComp.substring(aggComp.indexOf(":")+1,aggComp.lastIndexOf(":"));
					boolean isAnchorNick = anchorCompNick != null && anchorCompNick.equals(nick);
					countColumn++;
					if(isAnchorNick)
					{
						if(countColumn == 3)
						{
							tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%'><a data-qtip='Anchor Component' data-qclass='yellowTip' href=\"/final/admin/aggNewServer.jsp?server="+EgURLEncoder.encode(nickPort,"UTF-8")+"&serverType="+EgURLEncoder.encode(aggCompType,"UTF-8")+"&modifyserver=true&elementType="+s_elementType+"&elementName="+s_name+"&operation=modify&serverGategory="+serverGategory+"\" style='font:normal 11px/13px Calibri,Candara,Arial,sans-serif;text-decoration:none;vertical-align:top'>&nbsp;<b>"+nick+"</b></a></td>";
							countColumn = 0;
							tmpStr = tmpStr + "</tr><tr>";
						}
						else
						{
							tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%'><a data-qtip='Anchor Component' data-qclass='yellowTip' href=\"/final/admin/aggNewServer.jsp?server="+EgURLEncoder.encode(nickPort,"UTF-8")+"&serverType="+EgURLEncoder.encode(aggCompType,"UTF-8")+"&modifyserver=true&elementType="+s_elementType+"&elementName="+s_name+"&operation=modify&serverGategory="+serverGategory+"\" id='mouse' style='font:normal 11px/13px Calibri,Candara,Arial,sans-serif;text-decoration:none;vertical-align:top'>&nbsp;<b>"+nick+"</b></a></td>";
						}
					}
					else
					{
						if(countColumn == 3)
						{
							tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%'><a class='eg_monlink' href=\"/final/admin/aggNewServer.jsp?server="+EgURLEncoder.encode(nickPort,"UTF-8")+"&serverType="+EgURLEncoder.encode(aggCompType,"UTF-8")+"&modifyserver=true&elementType="+s_elementType+"&elementName="+s_name+"&operation=modify&serverGategory="+serverGategory+"\" id='mouse' style='font:normal 11px/13px Calibri,Candara,Arial,sans-serif;text-decoration:none;vertical-align:top'>&nbsp;"+nick+"</a></td>";
							countColumn = 0;
							tmpStr = tmpStr + "</tr><tr>";
						}
						else
						{
							tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%'><a class='eg_monlink' href=\"/final/admin/aggNewServer.jsp?server="+EgURLEncoder.encode(nickPort,"UTF-8")+"&serverType="+EgURLEncoder.encode(aggCompType,"UTF-8")+"&modifyserver=true&elementType="+s_elementType+"&elementName="+s_name+"&operation=modify&serverGategory="+serverGategory+"\" id='mouse' style='font:normal 11px/13px Calibri,Candara,Arial,sans-serif;text-decoration:none;vertical-align:top'>&nbsp;"+nick+"</a></td>";
						}
					}
				}
				if(countColumn == 2)
				{
					tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%' align='left'>&nbsp;</td>";
				}
				if(countColumn == 1)
				{
					tmpStr = tmpStr + "<td style='padding-top:3px;padding-bottom:5px;width:33%' align='left'>&nbsp;</td><td style='padding-top:3px;padding-bottom:5px;width:33%' align='left'>&nbsp;</td>";
				}
			}
			tmpStr = tmpStr + "</tr></table>";
			gridDataObject.put("nickname",tmpStr);
			gridArray.add(gridDataObject);
		}
		rootJson.put("gridDataList",gridArray);
	}
	out.println(rootJson.toString());
%>