<%
/*
*		Name			:	EgHostCheck.jsp
*		Purpose			:	To list the host names given for a particular ip address and check if the given hostname is present in the host names list.
							If present we alert the user about the hostname and ask for confirmation for using the same host name for the server or not.
*		CreationDate	:	18/12/2001
*/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	Vector temp_v_host_name = null;
	Vector v_host_name = new Vector();
	Vector v_host_name_nocase = new Vector();
	//component case issue. dont allow components to have same name with different case
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	ArrayList al_all_hosts=egDiscInfo.getAllHostsWithPort();
	String s_host_ip = request.getParameter("hostip");
	String s_host_name = request.getParameter("hostname");
	String s_server_name = request.getParameter("server");
	String s_server_type = request.getParameter("stype");
	String s_sid=request.getParameter("sid");
	String oldhostname = request.getParameter("oldhostname");
	String port_for_asset = request.getParameter("hportno");
	String lowerCaseHostName=request.getParameter("lowerCaseHostName");
	String newHostName = request.getParameter("newHostName");
	String siteflag = request.getParameter("siteflag");
	String treeViewSrc = request.getParameter("treeViewSrc");
	String fromResultPage = request.getParameter("fromResultPage");
	String serverNameWithPort = s_host_name;

	if (s_server_name != null && s_server_name.equals("new"))
	{
		oldhostname = "";
	}
	String mserver = request.getParameter("modifyserver");
	boolean isModifyServer = false;
	if(mserver != null && mserver.equals("true"))
	{
		isModifyServer = true;
	}
	if (port_for_asset == null || port_for_asset == "null")
		serverNameWithPort = s_host_name+":NULL";
	else
		serverNameWithPort = s_host_name+":"+port_for_asset;

	String selectedServerGroup = request.getParameter("selectedServerGroup");
	if (selectedServerGroup == null)
	{
		selectedServerGroup = "";
	}
	/*....... For Auto Topology .... (Start)*/
	String frmTopology = request.getParameter("frmTopology");
	String topoSegName = request.getParameter("topoSegName");
	String initialPortNo = request.getParameter("portnumber");
	/*....... For Auto Topology .... (End)*/
	

	if (lowerCaseHostName!=null && lowerCaseHostName.equals("true"))
		s_host_name = newHostName;

	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager"); //skm
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	boolean exist=false;

	egurkha.EgUIUtils uiUtils = new egurkha.EgUIUtils();
	v_host_name = uiUtils.getAllHostsForIp(s_host_ip,s_host_name);

	Vector ext = externalInfo.getAllExternalHostsForIP(s_host_ip,s_host_name);
	Vector rem = externalInfo.getAllRemoteHostsForIP(s_host_ip,s_host_name);

	if(v_host_name == null)
		v_host_name = new Vector();

	temp_v_host_name = new Vector(v_host_name);

	if(ext != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,ext);

	if(rem != null)
		temp_v_host_name = getUniqueHosts(temp_v_host_name,rem);


	if (v_host_name!=null)
	{
		for (int i=0; i<v_host_name.size(); i++)
		{
			String thisName = ((String)v_host_name.get(i)).toLowerCase();
			v_host_name_nocase.add(thisName);
		}
	}

	int nameIndex = v_host_name_nocase.indexOf(s_host_name.toLowerCase());

	if(v_host_name.size() > 0)
	{
		for(int vi=0;vi<v_host_name.size();vi++)
		{
			String host_na=(String)v_host_name_nocase.get(vi);
			exist=s_host_name.toLowerCase().equalsIgnoreCase(host_na);
			if(exist)
				break;
		}
	}

	if(!exist)
	{
		for(int vi=0;vi<temp_v_host_name.size();vi=vi+2)
		{
			String host_na=(String)temp_v_host_name.get(vi);
			exist=s_host_name.equalsIgnoreCase(host_na);
			if(exist)
			{
				nameIndex = (nameIndex == -1?vi:nameIndex);
				break;
			}
		}
	}


	boolean nickManaged =false;
	Hashtable nickIPMap=egDiscInfo.getNickIpMap();

	ArrayList allNicks=egDiscInfo.getAllNicks();
	boolean newNickAdded = !allNicks.contains(s_host_name.toLowerCase());
	Enumeration keys = nickIPMap.keys();
	while (keys.hasMoreElements())
	{
		String thisKey = (String) keys.nextElement();
		if (thisKey.equalsIgnoreCase(s_host_name))
		{
			String thisIp = (String)nickIPMap.get(thisKey);
			if (!thisIp.equals(s_host_ip))
			{
				nickManaged = true;
			}
		}
	}
	//Vmware Vcenter eg_services.ini entries
	//IniFile externalRead = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
	IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
	ArrayList extIniEntries = new ArrayList();
	String Ssl = "True";
	String uName = "$unconfigured";
	String uPass = "$unconfigured";
	String isDiscovery = "Yes";
	String webPort = "443";
	if (!(nickManaged || (v_host_name_nocase.size() > 0 && !exist)))
	{
		if (s_server_type.equals("Virtual_center"))
		{
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
		}
	}
	else if (s_server_type.equals("Virtual_center") && (mserver != null))
	{
		ArrayList vCValList = new ArrayList();
		String vCVal = externalWrite.getValue("VIRTUAL_CENTER",oldhostname);
		StringTokenizer stTok = new StringTokenizer(vCVal,"#");
		while (stTok.hasMoreTokens())
		{
			vCValList.add(stTok.nextToken());
		}
		if (vCValList.size() > 0 && !vCValList.contains("$unconfigured"))
		{
			String SslMod = (String)vCValList.get(0);
			String uNameMod = (String)vCValList.get(1);
			String uPassMod = (String)vCValList.get(2);
			String isDiscoveryMod = (String)vCValList.get(3);
			String webPortMod = (String)vCValList.get(4);

			extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", oldhostname, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod));
		}
		else
		{
			extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", oldhostname, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", s_host_name, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
		}
	}
	if (extIniEntries.size() > 0)
	{
		//IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		for (int n=0; n<extIniEntries.size(); n++)
		{
			IniHelper iniHelper = (IniHelper)extIniEntries.get(n);
			String iniAction = iniHelper.getAction();
			String subject = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String value = iniHelper.getValue();
			if(iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					externalWrite.setValue(subject,key,value);
				}
				else if (iniAction.equals(IniHelper.DELETE))
				{
					externalWrite.deleteValue(subject,key);
				}
			}
		}
		externalWrite.saveFile();
		//EgConfigFilesSync.releaseInstance(externalWrite);
	}
	EgConfigFilesSync.releaseInstance(externalWrite);
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Server Configuration");
	/* code for auditlog ends */

	if(s_server_name != null && s_host_name != null && (s_server_name.equals("new") || isModifyServer) && IniUI.isEgReservedKeyword(s_host_name))
	{
		//Vector sess_vec = new Vector();
		//sess_vec.removeAllElements();
		//sess_vec.addElement(_mapping.getTextDescription("admin.server.Add/Modify Component"));
		rootJSON.put("requestStatus","failed");
		rootJSON.put("error_type","alert");
		JSONObject obj = new JSONObject();
		obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
		if(!StringUtils.isNull(treeViewSrc))
		{
			//sess_vec.addElement("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
			obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
		}
		else
		{
			obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
			//sess_vec.addElement("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
		}
		obj.put("error_Msg_Count","2");
		obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.Possible reason")+":");
		obj.put("error_Msg_2","'"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is an eG defined keyword choose another name")+".");
		//sess_vec.addElement(_mapping.getTextDescription("admin.server.Possible reason")+":");
		//sess_vec.addElement("'"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is an eG defined keyword choose another name")+".");
		if(frmTopology!=null && frmTopology.equals("yes"))
		{
			//sess_vec.add("frmTopology");
		}
		//session.setAttribute("vec_Errors",sess_vec);
		rootJSON.put("error_Info",obj);
		out.println(rootJSON);
		return;
	}
	//testing, if new nickname is already used or not
	if(aggTypes != null && !aggTypes.isEmpty() && s_host_name != null && s_host_name.length()>0)
	{
		if(s_host_name.indexOf(":")>0)
		{
			s_host_name = s_host_name.substring(0,s_host_name.indexOf(":"));
		}
		if((s_server_name != null && s_server_name.equals("new")) || (isModifyServer && !s_host_name.equals(oldhostname)))
		{
			for(int j=0;j<aggTypes.size();j++)
			{
				String[] aggComps = egDiscInfo.getAllServersOfType((String)aggTypes.get(j));
				if(aggComps !=null && aggComps.length>0)
				{
					for(int i=0;i<aggComps.length;i++)
					{
						String aggregateComponent = aggComps[i];
						String aggregateComponentNick=aggregateComponent.substring(0,aggregateComponent.lastIndexOf(":"));
						int colonIdx = aggregateComponentNick.indexOf(":");
						String aggregatecomponentType = aggregateComponentNick.substring(0,colonIdx);
						aggregateComponentNick = aggregateComponentNick.substring(colonIdx+1);
						if(aggregateComponentNick.equalsIgnoreCase(s_host_name))
						{
							rootJSON.put("requestStatus","failed");
							rootJSON.put("error_type","alert");
							JSONObject obj = new JSONObject();
							obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
							if(!StringUtils.isNull(treeViewSrc))
							{
								obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
							}
							else
							{
								obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
							}
							obj.put("error_Msg_Count","2");
							obj.put("error_Msg_1","");
							if(aggregatecomponentType.equals(s_server_type))
							{
								obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The nick name")+" '"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is already used")+".");
							}
							else
							{
								obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The nick name")+" '"+s_host_name+"' "+_mapping.getTextDescription("admin.server.is already used for the component of type ")+" " + _mapping.getComponentTypeDescription(aggregatecomponentType)+".");
							}
							rootJSON.put("error_Info",obj);
							auditLogThread.setCurrentValue("ColumnName","Component Not Added");
							auditLogThread.setCurrentValue("01~~Component type","$ctype$:"+s_server_type);
							auditLogThread.setCurrentValue("02~~Nick name",s_host_name);
							auditLogThread.setCurrentValue("04~~Component type in which nick name is used","$ctype$:"+aggregatecomponentType);
							if(aggregatecomponentType.equals(s_server_type))
							{
								auditLogThread.setValue("Description","Component has not been added as the nickname is already used");
							}
							else
							{
								auditLogThread.setValue("Description","Component has not been added as the nickname is already used for another aggregate component");
							}
							auditLogThread.sendItToDB();
							out.println(rootJSON);
							return;
						}
					}
				}
			}
		}
	}

	if (!(nickManaged || (v_host_name_nocase.size() > 0 && !exist)))
	{
		if(s_server_name.equalsIgnoreCase("new"))
		{
			boolean isManagedServer = false;
			String arr_comps[]=egDiscInfo.getAllServersOfType(s_server_type);
			String s_port = request.getParameter("hportno");
			String s_key ="";
			if(s_port==null) s_port = "NULL";
			if(arr_comps != null)
			{
				if(s_sid!=null && s_sid.length()>0)
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port + ":" + s_sid;
				}
				else
				{
					s_key = s_server_type+ ":" + s_host_name + ":" + s_port;
				}
				for(int i=0;i<arr_comps.length;i++)
				{
					if(arr_comps[i].equalsIgnoreCase(s_key))
					{
						isManagedServer = true;
						break;
					}
				}
			}
			String tmpPort = "";
			if (s_port != null && !s_port.equalsIgnoreCase("null"))
			{
				tmpPort = ":"+s_port;
			}
			if(isManagedServer)
			{
				//Vector sess_vec = new Vector();
				//sess_vec.add(_mapping.getTextDescription("admin.server.Add/Modify Component"));
				rootJSON.put("requestStatus","failed");
				rootJSON.put("error_type","alert");
				JSONObject obj = new JSONObject();
				obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
				if(!StringUtils.isNull(treeViewSrc))
				{
					//sess_vec.add("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
					obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&treeViewSrc="+treeViewSrc+"&selectedServerGroup="+selectedServerGroup);
				}
				else
				{
					//sess_vec.add("EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
					obj.put("error_URL","EgDispServer.jsp?qctr=1&server="+ s_server_type+"&isAggregateLink="+s_server_type.startsWith("Agg_")+"&selectedServerGroup="+selectedServerGroup);
				}
				obj.put("error_Msg_Count","2");
				//obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.Component already managed."));
				obj.put("error_Msg_1","");
				obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.The component")+" '"+s_host_name+tmpPort+"' ("+_mapping.getComponentTypeDescription(s_server_type)+") "+_mapping.getTextDescription("admin.server.you are trying to add is already managed")+".");
				//sess_vec.add(_mapping.getTextDescription("admin.server.Component already managed."));
				//sess_vec.add(_mapping.getTextDescription("admin.server.The component")+" '"+s_host_name+tmpPort+"' ("+_mapping.getComponentTypeDescription(s_server_type)+") "+_mapping.getTextDescription("admin.server.you are trying to add is already managed")+".");
				if(frmTopology!=null && frmTopology.equals("yes"))
				{
					//sess_vec.add("frmTopology");
				}
				//session.setAttribute("vec_Errors",sess_vec);
				rootJSON.put("error_Info",obj);
				/* code for auditlog starts */
				auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
				auditLogThread.setCurrentValue("Component type","$ctype$:"+s_server_type);
				auditLogThread.setCurrentValue("Component name",s_host_name);
				auditLogThread.setCurrentValue("Port number",s_port);
				auditLogThread.setValue("Description","Component was not added as it had been already managed");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
				out.println(rootJSON);
				return;
			}
		}

		boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();

		if ((lowerCaseHostName == null || !lowerCaseHostName.equals("true")) && caseIssue)
		{
			if (allNicks == null || !allNicks.contains(s_host_name.toLowerCase()))
			{
				removeOldEntries(newNickAdded, s_host_name, userinfo);
				rootJSON.put("requestStatus","success");
				rootJSON.put("forward",true);
				rootJSON.put("forward_URL","EgnewserverpJson.jsp?action=allservers&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc);
			}
		}
		else
		{
			removeOldEntries(newNickAdded, s_host_name, userinfo);
			String ur ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc+"&servertype="+EgURLEncoder.encode(s_server_type,"UTF-8")+"&servername="+EgURLEncoder.encode(serverNameWithPort,"UTF-8")+"&hostIp="+s_host_ip;
			if(frmTopology!=null && frmTopology.equals("yes"))
			{
				ur = ur + "&topoSegName="+topoSegName+"&initPort="+initialPortNo;
			}
			rootJSON.put("requestStatus","success");
			rootJSON.put("forward",true);
			rootJSON.put("forward_URL",ur);
		}
	}
	boolean notYetForwarded = true;
	if(!nickManaged && s_server_type.startsWith("Agg_"))
	{
		UpdateAndTransmitUserInfo userinfo = new UpdateAndTransmitUserInfo();
		removeOldEntries(newNickAdded, s_host_name, userinfo);
		String url ="EgnewserverpJson.jsp?action=singleserver&hostname="+EgURLEncoder.encode(s_host_name,"UTF-8")+"&"+request.getQueryString()+"&treeViewSrc="+treeViewSrc;
		rootJSON.put("requestStatus","success");
		rootJSON.put("forward",true);
		rootJSON.put("forward_URL",url);
		notYetForwarded = false;
	}
	JSONObject  hiddens = new JSONObject();
	//hiddens.put("qstring",request.getQueryString());
	hiddens.put("treeViewSrc",treeViewSrc);
	hiddens.put("fromResultPage",fromResultPage);
	//hiddens.put("server_name",s_server_name);
	hiddens.put("server_type",s_server_type);
	hiddens.put("initPort",initialPortNo);

	String elementModify = request.getParameter("elementModify");
	if(elementModify != null && elementModify.trim().equals("yes"))
	{
		elementModify = "yes";
	}
	else
	{
		elementModify = "no";
	}
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = (String)en.nextElement();
		if(elementModify.equals("yes") && name.equals("hostname"))
		{
			continue;
		}
		String [] val2 = request.getParameterValues(name);
		String val ="";
		if (val!=null && val2.length==1)
			val = request.getParameter(name);
		else
			val = com.egurkha.util.StringUtils.getUniqueArrayAsString(val2);
		hiddens.put(name,val);
	}
	if(notYetForwarded)
	{
		if(nickManaged || (v_host_name_nocase.size() > 0 && !exist))
		{
			String hostname = "";
			String dispHostName = "";
			boolean proceed = true;

			for(int i=1;i < temp_v_host_name.size();i=i+2)
			{
				if(((String)temp_v_host_name.get(i)).equals("false"))
				{
					proceed = false;
					hostname = (String)temp_v_host_name.get(i-1);
					break;
				}
			}

			if(hostname.length() > 0)
			{
				Hashtable nickIPMapTemp = egDiscInfo.getAllNicksIpMap();
				Hashtable lowerCaseNickIPMap = new Hashtable();
				Hashtable originalNickMap = new Hashtable();
				if(nickIPMapTemp != null)
				{
					dispHostName = (String)nickIPMapTemp.get(s_host_name);
					if (dispHostName == null)
					{
						Enumeration eunmMap  = nickIPMapTemp.keys();
						while(eunmMap.hasMoreElements())
						{
							String key = (String)eunmMap.nextElement();
							String value = (String)nickIPMapTemp.get(key);
							lowerCaseNickIPMap.put(key.toLowerCase(),value);
							originalNickMap.put(key.toLowerCase(),key);
						}
					}
					dispHostName = (String)lowerCaseNickIPMap.get(s_host_name.toLowerCase());
					if(dispHostName != null)
					{
						dispHostName = (String)originalNickMap.get(s_host_name.toLowerCase());
					}
					else
					{
						dispHostName = s_host_name;
					}
				}
			}
			hiddens.put("hostcheck","true");

			String enable="";
			String port=request.getParameter("hportno");
			if( port!=null &&!port.equals(request.getParameter("sportno")))
			{
				enable="disabled";
			}
			if(!s_server_name.equalsIgnoreCase("new"))
			{
				enable="disabled";
			}
			rootJSON.put("proceed",proceed);
			rootJSON.put("main_Msg_Title",s_host_ip+" "+_mapping.getTextDescription("admin.server.IP is already mapped to the following nick name(s)")+":");
			
			if(proceed)
			{
				JSONArray gridData = new JSONArray();
				for(int i=0;i < v_host_name.size();i=i+2)
				{
					String compName = (String)v_host_name.get(i);
					JSONObject gridVal = new JSONObject();
					gridVal.put("column_1",compName);
					gridData.add(gridVal);
				}
				rootJSON.put("gridData",gridData);
			}
			if(v_host_name_nocase.contains(s_host_name.toLowerCase()))
			{
				if(proceed)
				{
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","radio");
					rootJSON.put("radio_Msg_Title",_mapping.getTextDescription("admin.server.The host name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is already present in this list"));
					rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to continue adding the same host name for this component?"));
					rootJSON.put("radio1_value","singleserver");
					rootJSON.put("radio2_Msg",_mapping.getTextDescription("admin.server.Do you wish to continue adding the same host name for this component and apply for all components?"));
					rootJSON.put("radio2_value","allservers");
					rootJSON.put("radio2_enable",enable);
				}
				else
				{
					rootJSON.put("requestStatus","failed");	
					rootJSON.put("error_type","alert");
					JSONObject obj = new JSONObject();
					obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
					obj.put("error_URL","");
					obj.put("error_Msg_Count","2");
					obj.put("error_Msg_1",_mapping.getTextDescription("admin.server.The host name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is already associated with")+" "+hostname);
					obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host name")+".");

					rootJSON.put("error_Info",obj);
				}
			}
			else if(!v_host_name_nocase.contains(s_host_name.toLowerCase()))
			{
				if(proceed)
				{
					String radioValue = "singleserver"; 
					if(!s_server_name.equalsIgnoreCase("new"))
						radioValue ="allservers";

					ArrayList nicks = egDiscInfo.getAllComponentNicks(false);
					int count = 0;
					for (int i=0;i<nicks.size();i++)
					{
						String nick = (String)nicks.get(i);
						if (nick.equals(oldhostname))
							count++;
						if(count > 1)
							break;
					}

					if (count > 1)
						radioValue = "allservers";
					else
						radioValue = "singleserver";
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","radio");
					rootJSON.put("radio_Msg_Title",_mapping.getTextDescription("admin.server.The host name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.server.you have added is not present in the below list")+".");
					rootJSON.put("radio1_value",radioValue);
					rootJSON.put("radio1_checked",true);
					
					//rootJSON.put("radio_Msg_2",_mapping.getTextDescription("admin.server.Do you wish to continue adding the same host name for this component and apply for all components?"));
				
					if(s_server_name.equalsIgnoreCase("new"))
					{
						rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to add the new host name for this component alone?"));
					}
					else
					{
						rootJSON.put("radio1_Msg",_mapping.getTextDescription("admin.server.Do you wish to rename all the components that have the old host name?"));
						hiddens.put("modify","yes");
					}
					rootJSON.put("radio2_Msg",_mapping.getTextDescription("admin.server.Do you wish to add the new host name for this component and apply for all components?")+".");
					rootJSON.put("radio2_value","allservers");
					rootJSON.put("radio2_enable",enable);
	%>
					
	<%
				}
				else
				{
					/* code for auditlog starts */
					auditLogThread.setCurrentValue("ColumnName","Component Already Managed");
					auditLogThread.setCurrentValue("01~~Component type","$ctype$:"+s_server_type);
					auditLogThread.setCurrentValue("02~~Component name",s_host_name);
					if(s_host_ip != null && !s_host_ip.equals("0.0.0.0"))
					{
						auditLogThread.setCurrentValue("03~~IP in which component to be managed",s_host_ip);
					}

					if(hostname != null && hostname.equals("0.0.0.0"))
					{
						List aggCompTypes = egDiscInfo.getServerTypesForNick(dispHostName);
						rootJSON.put("requestStatus","failed");
						rootJSON.put("error_type","alert");
						JSONObject obj = new JSONObject();
						obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
						obj.put("error_URL","");
						obj.put("error_Msg_Count","2");
						obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with an aggregate component in the following manner")+".");
						obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host/nick name")+".");					

						if(aggCompTypes != null && !aggCompTypes.isEmpty())
						{
							JSONArray aggArray = new JSONArray();
							for(int i=0;i<aggCompTypes.size();i++)
							{
								String aggCompType = (String) aggCompTypes.get(i);
								auditLogThread.setCurrentValue("Component already managed","$ctype$:"+aggCompType+":"+dispHostName);
								JSONObject obj2 = new JSONObject();
								obj2.put("compType",_mapping.getComponentTypeDescription(aggCompType));
								obj2.put("comoName",dispHostName);
								aggArray.add(obj2);
							}
						}
						rootJSON.put("error_Info",obj);
						auditLogThread.setValue("Description","Component was not added as it had been already managed");
						auditLogThread.sendItToDB();
						/* code for auditlog ends */
					}
					else
					{
						auditLogThread.setCurrentValue("IP in which component already managed",hostname);
						auditLogThread.setValue("Description","Component was not added as it had been already managed");
						auditLogThread.sendItToDB();
						/* code for auditlog ends */

						rootJSON.put("requestStatus","failed");
						rootJSON.put("error_type","alert");
						JSONObject obj = new JSONObject();
						obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
						obj.put("error_URL","");
						obj.put("error_Msg_Count","2");
						obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+hostname+"). ");//+_mapping.getTextDescription("admin.error.in the following manner")+". ");
						obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Please choose a different host/nick name")+".");
						obj.put("IP",hostname);
						obj.put("nickName",dispHostName);
						rootJSON.put("error_Info",obj);
					}
				}
			}
			//hiddens.put("qstring",request.getQueryString());
			hiddens.put("server_name",s_server_name);
			hiddens.put("server_type",s_server_type);
		}
		else
		{
			boolean caseIssue = (nameIndex!=-1) && !temp_v_host_name.contains(s_host_name);
			if ((lowerCaseHostName==null || !lowerCaseHostName.equals("true")) && caseIssue)
			{
				if(allNicks != null && allNicks.contains(s_host_name.toLowerCase()))
				{
					newHostName = (String)temp_v_host_name.get(nameIndex);
					rootJSON.put("requestStatus","failed");
					rootJSON.put("error_type","confirm");
					JSONObject obj = new JSONObject();
					obj.put("error_Title",_mapping.getTextDescription("admin.server.Add/Modify Component"));
					obj.put("error_URL","");
					obj.put("error_Msg_Count","2");
					obj.put("error_Msg_1",_mapping.getTextDescription("admin.error.The host/nick name")+" ("+s_host_name+") "+_mapping.getTextDescription("admin.error.you are trying to add is already associated with the IP")+" ("+s_host_ip+"). ");//+_mapping.getTextDescription("admin.error.in the following manner"));
					obj.put("IP",s_host_ip);
					obj.put("nickName",newHostName);
					obj.put("error_Msg_2",_mapping.getTextDescription("admin.server.Do you wish to use the old host/nick name")+" ("+newHostName+") "+_mapping.getTextDescription("admin.server.for this IP address")+".");
					rootJSON.put("error_Info",obj);
				}
			}
		}
	}
	rootJSON.put("hiddenValues",hiddens);
	out.println(rootJSON);
%>

<%!
	public void removeOldEntries(boolean newNickAdded, String s_host_name, UpdateAndTransmitUserInfo userinfo)
	{
		if (newNickAdded)
		{
			ArrayList queryList = new ArrayList();
			queryList.add("delete from measure_last where trgt_host='"+s_host_name+"'");
			queryList.add("delete from metatest where comp_name like '"+s_host_name+":%'");
			for (int j=0; j<queryList.size(); j++)
			{
				String thisQry = (String) queryList.get(j);
				userinfo.deleteFromDb(thisQry);
			}
		}
	}
	public Vector getUniqueHosts(Vector v_host_name,Vector hosts)
	{
		for(int i=0;i<hosts.size();i=i+2)
		{
			String temp1 = (String)hosts.get(i);
			String temp2 = (String)hosts.get(i+1);
			if(!v_host_name.contains(temp1))
			{
				v_host_name.add(temp1);
				v_host_name.add(temp2);
			}
		}
		return v_host_name;
	}
%>


