<%
/**********************************************************************************
*	Name			:	aggAddAll.jsp
*	Purpose			:	adding components for the given component types
***********************************************************************************/
%>
<%@ include file= "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgTesterInfo"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="java.util.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();
	JSONArray gridValuesArray = new JSONArray();

	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	boolean externalAgentRunsAllAggTests = testerInfo.externalAgentRunsAllAggTests();
	rootJson.put("externalAgentRunsAllAggTests",externalAgentRunsAllAggTests);
	if(externalAgentRunsAllAggTests)
	{
		rootJson.put("AgentLabel",_mapping.getTextDescription("admin.common.External Agent"));
	}
	else
	{
		rootJson.put("AgentLabel",_mapping.getTextDescription("admin.common.Remote Agent"));
	}

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String serverTypes = (String)session.getAttribute("selected_server_types");

	JSONArray server_types_internal_names = new JSONArray();
	String [] srvTypes = discInfo.getServerTypes();
	for(int i=0;i<srvTypes.length;i++)
	{
		String stype = srvTypes[i];
		if(stype.startsWith("Agg_"))
		{
			continue;
		}
		server_types_internal_names.add(stype);
		server_types_internal_names.add("Agg_"+stype);
	}
	rootJson.put("server_types_internal_names",server_types_internal_names);
	
	JSONArray externalAgentArray = new JSONArray();
	String defaultExternalAgent = new EgSpecsInfo("manager").getEGServer();
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] externalAgents = extInfo.getAllExternalAgents();
	if (externalAgents != null)
	{
		Vector v = new Vector(Arrays.asList(externalAgents));
		v.remove(defaultExternalAgent);
		Object [] emuClient = extInfo.getClientEmulatingAgents();
		if(emuClient != null && emuClient.length>0)
		{
			//Client Emulation enabled external agents will not execute normal external tests, so we are filtering here.
			ArrayList clEmuAgents = new ArrayList(Arrays.asList(emuClient));
			v.removeAll(clEmuAgents);
		}
		Collections.sort(v,String.CASE_INSENSITIVE_ORDER);
		v.add(0,defaultExternalAgent);
		externalAgents = (String[])v.toArray(new String[0]);
	}
	for(int i=0;i<externalAgents.length;i++)
	{
		JSONObject externalAgentObj = new JSONObject();
		externalAgentObj.put("displayField",externalAgents[i]);
		externalAgentObj.put("valueField",externalAgents[i]);
		externalAgentArray.add(externalAgentObj);
	}
	rootJson.put("defaultExternalAgents",defaultExternalAgent);
	rootJson.put("externalAgents",externalAgentArray);

	JSONArray remoteAgentArray = new JSONArray();
	String defaultRemoteAgent = new EgSpecsInfo("manager").getEGServer();
	String[] remoteAgents = extInfo.getAllRemoteAgents();
	if (remoteAgents != null)
	{
		Vector v = new Vector(Arrays.asList(remoteAgents));
		v.remove(defaultRemoteAgent);
		Collections.sort(v,String.CASE_INSENSITIVE_ORDER);
		v.add(0,defaultRemoteAgent);
		remoteAgents = (String[])v.toArray(new String[0]);
	}
	for(int i=0;i<remoteAgents.length;i++)
	{
		JSONObject remoteAgentObj = new JSONObject();
		remoteAgentObj.put("displayField",remoteAgents[i]);
		remoteAgentObj.put("valueField",remoteAgents[i]);
		remoteAgentArray.add(remoteAgentObj);
	}
	rootJson.put("defaultRemoteAgents",defaultRemoteAgent);
	rootJson.put("remoteAgents",remoteAgentArray);

	String existing_agg_nicks = "";
	String component_types[] = discInfo.getComponentTypes();
	for(int i=0;i<component_types.length;i++)
	{
		String[] component = discInfo.getAllServersOfType(component_types[i]);
		if(component != null && component.length>0)
		{
			for(int j=0;j<component.length;j++)
			{
				String temp = component[j];
				existing_agg_nicks += "," + temp.substring(temp.indexOf(":")+1,temp.lastIndexOf(":")).toLowerCase();
			}
		}
	}
	if(existing_agg_nicks.length()>0)
	{
		existing_agg_nicks = existing_agg_nicks.substring(1);
		rootJson.put("existing_agg_nicks",existing_agg_nicks);
	}
	String elementType = (String)session.getAttribute("elementType");
	String elementName = (String)session.getAttribute("elementType");
	if(!StringUtils.isNull(serverTypes))
	{
		String componentTypes[] = StringUtils.getTokens(serverTypes,",");
		for(int i=0;i<componentTypes.length;i++)
		{
			JSONObject gridValues = new JSONObject();
			String dispNickName = componentTypes[i];
			gridValues.put("componentType",_mapping.getComponentTypeDescription(dispNickName));
			dispNickName = dispNickName.substring(dispNickName.indexOf("_")+1);
			if(dispNickName.indexOf("_")>0)
			{
				if(dispNickName.indexOf("_") == dispNickName.lastIndexOf("_"))
				{
					dispNickName=dispNickName.substring(0,dispNickName.indexOf("_"));
				}
				else
				{
					dispNickName=dispNickName.substring(0,dispNickName.lastIndexOf("_"));
				}
			}
			gridValues.put("nickname",dispNickName);
			gridValues.put("remoteAgent",defaultRemoteAgent);
			gridValuesArray.add(gridValues);
		}
		rootJson.put("gridValues",gridValuesArray);

		JSONArray reservedWord = new JSONArray();
		Iterator itr = IniUI.reservedKeywords.iterator();
		while(itr.hasNext())
		{
			reservedWord.add((String)itr.next());
		}
		rootJson.put("reservedWord",reservedWord);

		out.println(rootJson.toString());
	}
%>
