<%
/**
 *	Name		:	EgUpgradeStatusJson.jsp
 *	Purpose		:	
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "java.util.List" %>
<%@ page import = "java.util.LinkedList" %>
<%@ page import = "java.util.Iterator" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.ArrayUtils"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	JSONObject jsnObj;
	rootJSON.put("success","true");
	
	String str = request.getParameter("AgentStatus");
	if(str == null || str.equals("")) str = "Enabled";
	UpgradeStatusHelper ush = new UpgradeStatusHelper();

	List agents = ush.getAllDetails();
	if (agents.size() > 0)
	{
		String separator = ush.getSeparator();
		User user=registry.getUser(session.getId());
		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		String thisLanguage = ui.getDefaultLanguage();
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
		EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
		String none=mappingInfo.getTextDescription("admin.common.None");
		String versions=mappingInfo.getTextDescription("admin.upgrade.Version");
		String operatingsystem=mappingInfo.getTextDescription("admin.upgrade.Operating System");
		String upgradesetting=mappingInfo.getTextDescription("admin.upgrade.Upgrade Status"); 
		String jreversion=mappingInfo.getTextDescription("admin.upgrade.JRE Version");

		String[] options = {none,versions,operatingsystem,upgradesetting,jreversion};
		String selectedOption = request.getParameter("filterBy");
		if (StringUtils.isNull(selectedOption))
		{
			selectedOption = options[0];
		}

		Object[] filterOptions = null;
		if (selectedOption.equals(options[1]))
		{
			/*
			 * Get the versions
			 */
			List version = new LinkedList();
			for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
			{
				String line = (String)iterator.next();
				String[] tokens = StringUtils.getTokens(line, separator);
				if (version.indexOf(tokens[1]) == -1)
				{
					version.add(tokens[1]);
				}
			}
			filterOptions = version.toArray();
		}
		else if (selectedOption.equals(options[2]))
		{
			/*
			 * Get the OSes
			 */
			filterOptions = new String[] {"AIX", "HPUX", "Linux", "Solaris", "WindowsNT", "Windows2000", "Windows2003","Windows2008","Windows2012","Windows2016"};
		}
		else if (selectedOption.equals(options[3]))
		{
			/*
			 * Upgrade settings
			 */
			filterOptions = new String[] {"Enabled", "Disabled"};
		}
		else if (selectedOption.equals(options[4]))
		{
			/*
			 * Get the versions
			 */
			List version = new LinkedList();
			for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
			{
				String line = (String)iterator.next();
				String[] tokens = StringUtils.getTokens(line, separator);
				if (version.indexOf(tokens[tokens.length-1]) == -1)
				{
					version.add(tokens[tokens.length-1]);
				}
			}
			filterOptions = version.toArray();
		}

		String selectedCriteria = request.getParameter("filterCriteria");
		if ((StringUtils.isNull(selectedCriteria) 
			|| filterOptions == null)
			|| !ArrayUtils.contains(filterOptions, selectedCriteria))
		{
			if (filterOptions == null)
			{
				selectedCriteria = EgConstants.BLANK_STRING;
			}
			else
			{
				selectedCriteria = (String)filterOptions[0];
			}
		}

		JSONArray filters = new JSONArray();
		for (int f=0; f < options.length; f++)
		{
			jsnObj = new JSONObject();
			jsnObj.put("displayField",options[f]);
			jsnObj.put("valueField",options[f]);
			filters.add(jsnObj);
		}
		rootJSON.put("filterBy",filters);
		rootJSON.put("filterBySelected",selectedOption);

		if (selectedOption.equals(options[0]))
		{
			rootJSON.put("filterCriteriaOption",false);
		}
		else
		{
			rootJSON.put("filterCriteriaOption",true);
			JSONArray citerias = new JSONArray();
			for (int f=0; f < filterOptions.length; f++)
			{
				jsnObj = new JSONObject();
				jsnObj.put("displayField",filterOptions[f]);
				jsnObj.put("valueField",filterOptions[f]);
				citerias.add(jsnObj);
			}
			rootJSON.put("filterCriteria",citerias);
			rootJSON.put("filterCriteriaSelected",selectedCriteria);
			
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[3]))
		{
			rootJSON.put("gridStatusCol",true);
		}
		else
		{
			rootJSON.put("gridStatusCol",false);
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[2]))
		{
			rootJSON.put("gridOsCol",true);
		}
		else
		{
			rootJSON.put("gridOsCol",false);
		}

		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[1]))
		{
			rootJSON.put("gridVersionCol",true);
		}
		else
		{
			rootJSON.put("gridVersionCol",false);
		}
		if (selectedOption.equals(options[0]) || !selectedOption.equals(options[4]))
		{
			rootJSON.put("gridJreVersionCol",true);
		}
		else
		{
			rootJSON.put("gridJreVersionCol",false);
		}

		int lin  = 0;
		int sol  = 0;
		int aix  = 0;
		int hpux = 0;
		int wnt  = 0;
		int w2k  = 0;
		int w2k3 = 0;
		int w2k8 = 0;
		int w2k12 = 0;
		int w2k16 = 0;

		int count = 0;
		JSONArray gridData = new JSONArray();
		for (Iterator iterator=agents.iterator(); iterator.hasNext(); )
		{
			String line = (String)iterator.next();
			String[] tokens = StringUtils.getTokens(line, separator);
			/*
			 * tokens[0] : Agent IP/Name
			 * tokens[1] : Version
			 * tokens[2] : Upgrade setting
			 * tokens[3] : Operating system
			 * tokens[4] : Host name
			 * tokens[5] : Startup time
			 * tokens[6] : Last upgraded package
			 * tokens[7] : Last upgraded time
			 */
			String agent = tokens[0];
			if (agent.indexOf(EgConstants.COLON) > -1)
			{
				agent = StringUtils.replace(agent, EgConstants.COLON, ", ");
			}
			String agentVer = tokens[1];
			String upgradeVer = tokens[2];
			String osName = tokens[3];

			if ((osName).equalsIgnoreCase("linux")) lin++;
			else if ((osName).equalsIgnoreCase("aix")) aix++;
			else if ((osName).equalsIgnoreCase("hpux")) hpux++;
			else if ((osName).equalsIgnoreCase("solaris"))sol++;
			else if ((osName).equalsIgnoreCase("windows2000"))w2k++;
			else if ((osName).equalsIgnoreCase("windowsnt"))wnt++;
			else if ((osName).equalsIgnoreCase("windows2003"))w2k3++;
			else if ((osName).equalsIgnoreCase("windows2008"))w2k8++;
			else if ((osName).equalsIgnoreCase("windows2012"))w2k12++;
			else if ((osName).equalsIgnoreCase("windows2016"))w2k16++;

			if (!tokens[7].equalsIgnoreCase("None"))
			{
				tokens[7] = (new java.util.Date(Long.parseLong(tokens[7]))).toString();
			}
			String javaVersion = tokens[8];

			boolean condition = false;
			if (selectedOption.equals(options[1]))
			{
				condition = (selectedCriteria.equals(agentVer));
			}
			else if (selectedOption.equals(options[2]))
			{
				condition = (selectedCriteria.equals(osName));
			}
			else if (selectedOption.equals(options[3]))
			{
				condition = (selectedCriteria.equals(upgradeVer));
			}
			else if(selectedOption.equals(options[4]))
			{
				condition = (selectedCriteria.equals(javaVersion));
			}
			else if (selectedOption.equals(options[0]))
			{
				condition = true;
			}
		
			if (condition)
			{
				JSONObject gridRow = new JSONObject();
				gridRow.put("AgentID",agent);
				gridRow.put("RecentPackage",tokens[6]);
				gridRow.put("LastUpgradedTime",tokens[7]);

				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[3]))
				{
					gridRow.put("Status",upgradeVer);
				}

				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[2]))
				{
					gridRow.put("OS",osName);
				}

				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[1]))
				{
					gridRow.put("Version",agentVer);
				}
				if (selectedOption.equals(options[0]) || !selectedOption.equals(options[4]))
				{
					gridRow.put("JREVersion",javaVersion);
				}
				gridData.add(gridRow);
				count++;
			}
		}
		rootJSON.put("agentInfoGrid",gridData);
		if (count == 0)
		{
			rootJSON.put("noAgentsFound",true);
		}

		if (count>0)
		{
			rootJSON.put("selectedAgentsCount",count);
		}
		rootJSON.put("totalAgentsCount",(aix+hpux+lin+sol+wnt+w2k+w2k3+w2k8+w2k12+w2k16));

		String[] osList =  new String[] {"AIX", "HPUX", "Linux", "Solaris", "WindowsNT", "Windows2000", "Windows2003","Windows2008","Windows2012","Windows2016"};
		String[] osCount = new String[] {aix+"", hpux+"", lin+"", sol+"", wnt+"", w2k+"", w2k3+"", w2k8+"", w2k12+"", w2k16+""};
		JSONArray osCountArray = new JSONArray();
		JSONObject osRow;
		for (int a=0; a < osList.length; a++)
		{
			osRow = new JSONObject();
			osRow.put("OS",_mapping.getTextDescription("admin.upgrade."+osList[a]));
			osRow.put("Agents",osCount[a]);
			osCountArray.add(osRow);
		}
		osRow = new JSONObject();
		osRow.put("OS","<b>"+_mapping.getTextDescription("admin.upgrade.Total agents")+"</b>");
		osRow.put("Agents","<b>"+(aix+hpux+lin+sol+wnt+w2k+w2k3+w2k8+w2k12+w2k16)+"</b>");
		osCountArray.add(osRow);
		rootJSON.put("totalAgentsGrid",osCountArray);
	}
	else
	{
		rootJSON.put("noAgentsConfigured",true);
	}
	out.println(rootJSON);
%>







