<%
/*
 *	Name		:	EgServerListJSON.jsp
 *	Purpose		:	To view all agents' current status
 *	Navigation	:	Home > [Click here to get the license details] > [Agent Status]
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="egurkha.UserBean" %>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page import="com.eg.EgLicenseInfo"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.egurkha.util.StringUtils"%>

<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Collections"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="java.util.StringTokenizer"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>
<%!
	String USER_COMP_AGENTS = "Agents for user licensed types";
	String[] agentTypes = {"BasicAgents","PremiumAgents", "ExternalAgents", "RemoteAgents",USER_COMP_AGENTS};
	String[] agentStatus = {"All","Running","NotRunning"};
%>
<%
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean isUserBasedCert = false;
	if (usersInfo.getUserAllowedCount() > 0)
	{
		isUserBasedCert = true;
	}
	JSONObject rootJSON = new JSONObject();
	JSONArray agentTys = new JSONArray();
	for (int a=0; a<agentTypes.length; a++)
	{
		String agentType = agentTypes[a];
		if (!isUserBasedCert && agentType.equals(USER_COMP_AGENTS))
		{
			continue;
		}
		JSONObject obj = new JSONObject();
		obj.put("valueField",agentType);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+agentType));
		agentTys.add(obj);
	}
	rootJSON.put("agentTypes",agentTys);
	//For CSV
	List csvData = new ArrayList();
	csvData.add("Agents Status Report");
	csvData.add("");
	
	String agentType = request.getParameter("agent"); // Agent Type
	if (StringUtils.isNull(agentType))
	{
		agentType = agentTypes[0];
	}
	rootJSON.put("agentType",agentType);
	csvData.add("Agent Type,"+agentType);
	JSONArray agentsSts = new JSONArray();
	for (int s=0;s<agentStatus.length;s++)
	{
		String status = agentStatus[s];
		JSONObject obj = new JSONObject();
		obj.put("valueField",status);
		obj.put("displayField",_mapping.getTextDescription("admin.agents."+status));
		agentsSts.add(obj);
	}
	rootJSON.put("agentStatus",agentsSts);
	String agentState=request.getParameter("status"); // Agent status
	if (StringUtils.isNull(agentState))
	{
		agentState = agentStatus[0];
	}
	rootJSON.put("agentState",agentState);
	csvData.add("Agent Status,"+agentState);
	csvData.add("");
	//Only when search option is enabled, 'hostname' & 'search' 
	//will be obtained
	String hostname = request.getParameter("hostname");
	if(hostname == null)
		hostname = "";
	String search = request.getParameter("search");
	if(search == null)
		search = "false";

	rootJSON.put("hostname",hostname);
	rootJSON.put("search",search);
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();
	EgServerList serverList = new EgServerList();
	int totalAgentCount = (licInfo.getExternalAgents()).size() + (licInfo.getBasicAgents()).size() + (licInfo.getPremiumAgents()).size() + (licInfo.getRemoteAgents()).size();
	rootJSON.put("totalAgentCount",totalAgentCount);

	ArrayList agentList = new ArrayList();
	ArrayList allAgents = licInfo.getTotalAgents();
	if(search.equals("false"))
	{
		if(agentType.equalsIgnoreCase("ExternalAgents"))
			agentList = licInfo.getExternalAgents();
		else if(agentType.equalsIgnoreCase("BasicAgents"))
			agentList = licInfo.getBasicAgents();
		else if(agentType.equalsIgnoreCase("PremiumAgents"))
		{
			agentList = userBean.getPremiumAgents();
		}
		else if(agentType.equalsIgnoreCase("RemoteAgents"))
			agentList = licInfo.getRemoteAgents();
		else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
		{
			agentList = userBean.getPremiumAgents(true);
		}
	}
	else
	{
		StringTokenizer st1 = new StringTokenizer(hostname);
		while (st1.hasMoreTokens())
		{
			String Token = st1.nextToken().trim();
			if (Token.equals("") || Token.length() == 0)
				continue;
			agentList.add(Token);
		}
		if(!agentList.contains(hostname.trim()))
		{
			agentList.add(hostname.trim());
		}
	}
	List csvAssignHosts = new ArrayList();
	if(agentList == null || agentList.size() == 0)
	{
		rootJSON.put("noManagedHostsFound",true);
		csvData.add("-No Agents Found-");
	}
	else
	{
		if(search.equals("true"))
		{
			ArrayList comps = (ArrayList)agentList.clone();
			ArrayList newGetreqArraylist = new ArrayList();
			agentList.clear();
			for(int i=0;i<comps.size(); i++)
			{
				String comp_name = (String)comps.get(i);
				comp_name = comp_name.trim();
				if(agentType.equalsIgnoreCase("ExternalAgents"))
					allAgents=licInfo.getExternalAgents(); 
				else if(agentType.equalsIgnoreCase("BasicAgents"))
					allAgents=licInfo.getBasicAgents();
				else if(agentType.equalsIgnoreCase("PremiumAgents"))
					allAgents = userBean.getPremiumAgents();
				else if(agentType.equalsIgnoreCase("RemoteAgents"))
					allAgents=licInfo.getRemoteAgents();
				else if (agentType.equalsIgnoreCase(USER_COMP_AGENTS))
					allAgents = userBean.getPremiumAgents(true);

				for(int j=0;j<allAgents.size(); j++)
				{
					if(((String)allAgents.get(j)).toLowerCase().indexOf(comp_name.toLowerCase()) > -1)
					{
						if(!agentList.contains(allAgents.get(j)))
							agentList.add(allAgents.get(j));
					}
				}
			}
		}
		Hashtable nick_ip_map = new com.eg.EgDiscInfo("manager").getNickIpMap();
		if(nick_ip_map == null)
		{
			nick_ip_map = new Hashtable();
		}
		IniFile agentStatus_ini =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agentoutputstatus.ini");
		Hashtable debug_status = new Hashtable();
		String variables_ini[] = agentStatus_ini.getVariables("AGENT_OUTPUT_STATUS");
		if(variables_ini != null && variables_ini.length>0)
		{
			for(int i=0;i<variables_ini.length;i++)
			{
				debug_status.put(variables_ini[i],agentStatus_ini.getValue("AGENT_OUTPUT_STATUS",variables_ini[i]));
			}
		}

		ArrayList totalAgents = null;
		ArrayList a_tmp = new ArrayList();
		a_tmp.add("Not Installed-Not Running");
		a_tmp.add("Installed-Not Running");
		a_tmp.add("Installed-Running");

		//coding insertion for sorted list of agents according to ip and status starts
		Vector v1=new Vector();
		Vector v2=new Vector();
		Vector v3=new Vector();
		String agentIP = "";
		String message = "";
		String installed = "";
		String insGif  = "";
		String running  = "";
		String runGif  = "";
		ArrayList agentless=new ArrayList();
		ArrayList agentlesscom=new ArrayList();
		ArrayList aList = serverList.getAgentListFromDB();
		String currList[] = serverList.getTargetNames();
		totalAgents=serverList.getAgentList(agentList,aList,currList);

		if(totalAgents.size() > 0)
		{
			for(int j=0;j<totalAgents.size();j=j+4)
			{
				agentIP = (String)totalAgents.get(j);
				message = (String)totalAgents.get(j+1);
				if(agentState.equalsIgnoreCase("All")||agentState.equalsIgnoreCase("NotRunning"))
				{
					if(message.equals("Not Installed-Not Running"))
						v1.add(agentIP);
					else if(message.equals("Installed-Not Running"))
						v2.add(agentIP);
				}
				if(agentState.equalsIgnoreCase("All")||agentState.equalsIgnoreCase("Running"))
				{
					if(message.equals("Installed-Running"))
					v3.add(agentIP);
				}
			}
		}
		totalAgents.clear();
		Collections.sort(v1,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v1.size();i++)
		{
			totalAgents.add(v1.get(i));
			totalAgents.add("Not Installed-Not Running");
			totalAgents.add("/final/admin/eg_images/Installed-Not.gif");
			totalAgents.add("eg_images/newnotrunning2.gif");
		}
		Collections.sort(v2,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v2.size();i++)
		{
			totalAgents.add(v2.get(i));
			totalAgents.add("Installed-Not Running");
			totalAgents.add("/final/admin/eg_images/Installed-Running.gif");
			totalAgents.add("eg_images/newnotrunning2.gif");
		}
		Collections.sort(v3,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<v3.size();i++)
		{
			totalAgents.add(v3.get(i));
			totalAgents.add("Installed-Running");
			totalAgents.add("/final/admin/eg_images/Installed-Running.gif");
			totalAgents.add("eg_images/newstatus.gif");
		}
		v1=null;v2=null;v3=null;
		JSONArray agentsDetails = new JSONArray();
		if(totalAgents.size() > 0)
		{
			csvData.add("Total number of Agents,"+(totalAgents.size()/4));
			csvData.add("");
			csvData.add("Agent IP/Nickname,Installed,Status,Output Logging Enabled");
			rootJSON.put("enableSearch",true);
			rootJSON.put("managedHostsFoundForSearch",true);
			for(int i=0;i<totalAgents.size();i=i+4)
			{
				boolean border=(i+4)<totalAgents.size();
				agentIP = (String)totalAgents.get(i);
				message = (String)totalAgents.get(i+1);
				installed = message.substring(0,message.indexOf("-"));
				insGif = (String)totalAgents.get(i+2);
				running = message.substring(message.indexOf("-")+1);
				runGif = (String)totalAgents.get(i+3);

				String restartFlg = "No";
				if(installed != null && (installed.equals("Not Installed") || running.equals("Not Running")))
				{
					restartFlg = "No";
				}
				else
				{
					restartFlg = "Yes";
				}
				//String onSelected="";
				//String offSelected="";
				boolean output = false;
				String agent_ip_address=null;
				String debugStatus=null;
				if(nick_ip_map.containsKey(agentIP))
				{
					agent_ip_address = (String)nick_ip_map.get(agentIP);
				}
				if(agent_ip_address != null && debug_status.containsKey(agent_ip_address))
				{
					debugStatus = (String)debug_status.get(agent_ip_address);
				}
				if(debugStatus != null && debugStatus.equalsIgnoreCase("yes"))
				{
					//onSelected = "selected";
					//offSelected = "";
					output=true;
				}
				else
				{
					//onSelected = "";
					//offSelected = "selected";
					output=false;
				}//AgentIP/Nickname-Installed-Status-Output-Restart-Logs
				rootJSON.put(agentIP+"_IP",agent_ip_address);
				JSONObject obj = new JSONObject();
				String tempInstalled = "Yes";
				if (installed.equalsIgnoreCase("Not Installed"))
				{
					tempInstalled = "No";
				}
				obj.put("AgentIP",agentIP+'~'+tempInstalled);
				obj.put("Installed",tempInstalled);
				obj.put("Status",running);
				obj.put("Output",output);
				obj.put("Restart",restartFlg+"~"+agentIP);
				String csvOutput = "No";
				if (output)
					csvOutput = "Yes";
				csvData.add(agentIP+","+tempInstalled+","+running+","+csvOutput);
				if(installed.equalsIgnoreCase("Not Installed") || running.equalsIgnoreCase("Not Running"))
				{
					obj.put("Logs","DoNotShow");
				}
				else
				{
					obj.put("Logs","Show");
				}
				if(agentType.equalsIgnoreCase("ExternalAgents"))
				{
					String hosts = getAssignedHostsForExternalAgent(agentIP);
					if(hosts.trim().equals(""))
						hosts = "- No assigned hosts found -";
					obj.put("AssignedHosts",hosts);
					csvAssignHosts.add(agentIP+"#@#"+hosts);
				}
				else if (agentType.equalsIgnoreCase("RemoteAgents"))
				{
					String hosts = getAssignedHostsForRemoteAgent(agentIP);
					if(hosts.trim().equals(""))
						hosts = "- No assigned hosts found -";
					obj.put("AssignedHosts",hosts);
					csvAssignHosts.add(agentIP+"#@#"+hosts);
				}
				obj.put("StopAgent",restartFlg+"~"+agentIP);
				agentsDetails.add(obj);
			}
		}
		else
		{
			rootJSON.put("enableSearch",false);
			rootJSON.put("managedHostsFoundForSearch",false);
		}
		rootJSON.put("agentDetails",agentsDetails);
	}
	if (csvAssignHosts.size() > 0)
	{
		String agentIPs = "";
		int big = 0;
		ArrayList allAssignHosts = new ArrayList();
		for (int c=0; c<csvAssignHosts.size(); c++)
		{
			String tmpStr = csvAssignHosts.get(c).toString();
			String agent = tmpStr.substring(0,tmpStr.indexOf("#@#"));
			String assignHosts = tmpStr.substring(tmpStr.indexOf("#@#")+3);
			ArrayList assignHostsList = StringUtils.egTokenizer(assignHosts,",");
			int size = assignHostsList.size();
			agentIPs += agent +" ("+size+")"+",";
			if(size > big)
				big = size;

			allAssignHosts.add(assignHostsList);
		}
		csvData.add("");
		csvData.add("");
		csvData.add("Assigned Hosts");
		csvData.add("");
		csvData.add(agentIPs);
		csvData.add("");
		for (int b=0; b<big; b++)
		{
			String row = "";
			for(int a=0; a<allAssignHosts.size(); a++)
			{
				ArrayList tmpList = (ArrayList)allAssignHosts.get(a);
				if(b < tmpList.size())
				{
					row += tmpList.get(b).toString()+",";
				}
				else
				{
					row += ""+",";
				}				
			}
			csvData.add(row);
		}
	}
	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	out.println(rootJSON);
%>
<%!
	public String getAssignedHostsForExternalAgent(String agentName)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Test_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		com.eg.EgDiscInfo discInfoObj = new com.eg.EgDiscInfo("manager");
		String rumServerList[] = discInfoObj.getAllServersOfType("Real_user_monitor");
		ArrayList varsList = new ArrayList(Arrays.asList(vars));
		boolean isRUMCompExists = false;
		try{
			if (rumServerList != null ) {
				for (int a=0;a<rumServerList.length;a++) {
					String serverName = (String)rumServerList[a];
					if (serverName != null && serverName.startsWith("Real_user_monitor")) {
						try{
							serverName = serverName.substring(serverName.indexOf(":")+1,serverName.lastIndexOf(":"));
							isRUMCompExists = true;
						} catch(Exception ex){
							serverName = serverName;
						}
						varsList.remove(serverName);
					}
				}
			}
		}
		catch(Exception ex){
			ex.printStackTrace();
		}
		if (isRUMCompExists){
			vars = (String[])varsList.toArray(new String[varsList.size()]);
		}
		for (int v=0; v<vars.length; v++)
		{
			String host = vars[v];
			String agents = extIni.getValue("Test_Mapping_Section",host);
			StringTokenizer stt = new StringTokenizer(agents,",");
			while (stt.hasMoreTokens())
			{
				if (agentName.equals(stt.nextToken()))
				{
					//res += host+", ";
					tmpList.add(host);
					break;
				}
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}

	public String getAssignedHostsForRemoteAgent(String agentName)
	{
		IniFile extIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] vars = extIni.getVariables("Remote_Agent_Mapping_Section");
		String res="";
		if (vars == null)
			return res;
		List tmpList = new ArrayList();
		for (int v=0; v<vars.length; v++)
		{
			String host = vars[v];
			String agent = extIni.getValue("Remote_Agent_Mapping_Section",host);
			if (agent.equals(agentName))
			{
				//res += host+", ";
				tmpList.add(host);
			}
		}
		Collections.sort(tmpList, String.CASE_INSENSITIVE_ORDER);
		for (int t=0; t < tmpList.size(); t++)
		{
			String tmp = tmpList.get(t).toString();
			res += tmp+",";
		}
		res = res.trim();
		if (res.endsWith(","))
			res = res.substring(0,res.length()-1);
		return res;
	}
%>