<%
/*
 *   File			:	EgConfigureVCTasksJson.jsp
 *   Purpose		:	UI for configuring tasks for vCenter server
*/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "application/json; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	IniFile egTestsini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	String strDescriptor = request.getParameter("descriptor");
	strDescriptor = (strDescriptor == null?"":strDescriptor);

	String[] descriptor_arr = egTestsini.getVariables("VCTaskFilterTypes");
	ArrayList aListDescriptor = new ArrayList();
	String tasks ="";
	String tasksEntry = "";
	ArrayList aListIncludedTasks = new ArrayList();
	ArrayList aListExcludedTasks = new ArrayList();

	for (int i=0; i<descriptor_arr.length; i++)
	{
		String strDesc = "";
		String strTestAndDescriptor = descriptor_arr[i];
		strDesc = strTestAndDescriptor.substring(strTestAndDescriptor.lastIndexOf(":")+1);
		aListDescriptor.add(strDesc);
	}
	Collections.sort(aListDescriptor,String.CASE_INSENSITIVE_ORDER);

	if (strDescriptor != null)
	{
		String thisToken = "";
		tasks = egTestsini.getValue("VirtualCenterTasks","VCTaskEvtTest:"+strDescriptor).trim();
		tasksEntry = egTestsini.getValue("VCTaskFilterTypes","VCTaskEvtTest:"+strDescriptor).trim();
		StringTokenizer st1 = new StringTokenizer(tasks,",");
		if (tasksEntry.equalsIgnoreCase("all:none"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListIncludedTasks.add(thisToken);
			}
		}
		else if (tasksEntry.equalsIgnoreCase("none:all"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListExcludedTasks.add(thisToken);
			}
		}
		else if (!tasksEntry.startsWith("all:") && tasksEntry.endsWith("none"))
		{
			String temp = tasksEntry.substring(0,tasksEntry.indexOf(":"));
			StringTokenizer st2 = new StringTokenizer(temp,",");
	
			while (st2.hasMoreTokens())
			{
				thisToken = st2.nextToken().trim();
				aListIncludedTasks.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListIncludedTasks.contains(token)) continue;
				aListExcludedTasks.add(token);
			}
		}
		else if (tasksEntry.startsWith("all")&& !tasksEntry.endsWith(":none"))
		{
			String temp = tasksEntry.substring(tasksEntry.lastIndexOf(":")+1);
			StringTokenizer st3 = new StringTokenizer(temp,",");

			while (st3.hasMoreTokens())
			{
				thisToken = st3.nextToken().trim();
				aListExcludedTasks.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListExcludedTasks.contains(token)) continue;
				aListIncludedTasks.add(token);
			}
		}
	}

	screenLabels.put("admin.vctask.Task category",_mapping.getTextDescription("admin.vctask.Task category"));
	screenLabels.put("admin.common.Choose one",_mapping.getTextDescription("admin.common.Choose one"));
	screenLabels.put("admin.vctask.Not Applicable",_mapping.getTextDescription("admin.vctask.Not Applicable"));
	screenLabels.put("admin.vctask.Included Tasks",_mapping.getTextDescription("admin.vctask.INCLUDED TASKS"));
	screenLabels.put("admin.vctask.Excluded Tasks",_mapping.getTextDescription("admin.vctask.EXCLUDED TASKS"));
	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));
	screenLabels.put("admin.vctask.Please choose a task category",_mapping.getTextDescription("admin.vctask.Please choose a task category"));
	screenLabels.put("admin.vctask.Please choose atleast one task to include or exclude",_mapping.getTextDescription("admin.vctask.Please choose atleast one task to include or exclude"));
	screenLabels.put("admin.vctask.Task have been included/excluded sucessfully",_mapping.getTextDescription("admin.vctask.Tasks have been included/excluded sucessfully"));


	JSONArray comArray = new JSONArray();
	JSONObject objcomb = new JSONObject();
	if (aListDescriptor != null && aListDescriptor.size() > 0)
	{
		objcomb.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
		objcomb.put("valueField",-1);
		comArray.add(objcomb);
		for (int j=0;j<aListDescriptor.size();j++)
		{
			String descVal = (String)aListDescriptor.get(j);
			objcomb.put("displayField",descVal);
			objcomb.put("valueField",descVal);
			comArray.add(objcomb);
		}
	}
	else
	{
		objcomb.put("displayField",_mapping.getTextDescription("admin.vctask.Not Applicable"));
		objcomb.put("valueField",-1);
		comArray.add(objcomb);
	}
	rootJson.put("comboValue",comArray);

	Collections.sort(aListIncludedTasks,String.CASE_INSENSITIVE_ORDER);
	JSONArray includedArray = new JSONArray();
	JSONObject includedObject = new JSONObject();

	JSONArray prevIncludedArray = new JSONArray();
	for (int m=0;m<aListIncludedTasks.size();m++)
	{
		String inclTasks = (String)aListIncludedTasks.get(m);
		prevIncludedArray.add(inclTasks);

		includedObject.put("displayField",inclTasks);
		includedObject.put("valueField",inclTasks);
		includedArray.add(includedObject);
	}
	rootJson.put("includedArray",includedArray);
	rootJson.put("prevIncludedArray",prevIncludedArray);

	JSONArray excludedArray = new JSONArray();
	JSONObject excludedObject = new JSONObject();
	JSONArray prevExcludedArray = new JSONArray();

	Collections.sort(aListExcludedTasks,String.CASE_INSENSITIVE_ORDER);
	for (int mm=0;mm<aListExcludedTasks.size();mm++)
	{
		String exclTasks = (String)aListExcludedTasks.get(mm);
		prevExcludedArray.add(exclTasks);

		excludedObject.put("displayField",exclTasks);
		excludedObject.put("valueField",exclTasks);
		excludedArray.add(excludedObject);
	}
	rootJson.put("prevExcludedArray",prevExcludedArray);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAgentSettings.jsp?"+request.getQueryString());

	rootJson.put("excludedArray",excludedArray);
	rootJson.put("screenLabels",screenLabels);

	System.out.println("rootJson_______"+rootJson);
	out.println(rootJson.toString());
%>



