<%
/*
 *   File			:	EgConfigureVCEventsJson.jsp
 *   Purpose		:	UI for configuring events for vCenter server
*/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	IniFile egTestsini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	String strDescriptor = request.getParameter("descriptor");
	strDescriptor = (strDescriptor == null?"":strDescriptor);

	String[] descriptor_arr = egTestsini.getVariables("VCEventFilterTypes");
	ArrayList aListDescriptor = new ArrayList();
	String events ="";
	String eventsEntry = "";
	ArrayList aListIncludedEvents = new ArrayList();
	ArrayList aListExcludedEvents = new ArrayList();

	for (int i=0; i<descriptor_arr.length; i++)
	{
		String strDesc = "";
		String strTestAndDescriptor = descriptor_arr[i];
		strDesc = strTestAndDescriptor.substring(strTestAndDescriptor.lastIndexOf(":")+1);
		aListDescriptor.add(strDesc);
	}
	Collections.sort(aListDescriptor,String.CASE_INSENSITIVE_ORDER);

	if (strDescriptor != null)
	{
		String thisToken = "";
		events = egTestsini.getValue("VirtualCenterEvents","VCEventsTest:"+strDescriptor).trim();
		eventsEntry = egTestsini.getValue("VCEventFilterTypes","VCEventsTest:"+strDescriptor).trim();
		StringTokenizer st1 = new StringTokenizer(events,",");
		if (eventsEntry.equalsIgnoreCase("all:none"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListIncludedEvents.add(thisToken);
			}
		}
		else if (eventsEntry.equalsIgnoreCase("none:all"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListExcludedEvents.add(thisToken);
			}
		}
		else if (!eventsEntry.startsWith("all:") && eventsEntry.endsWith("none"))
		{
			String temp = eventsEntry.substring(0,eventsEntry.indexOf(":"));
			StringTokenizer st2 = new StringTokenizer(temp,",");
	
			while (st2.hasMoreTokens())
			{
				thisToken = st2.nextToken().trim();
				aListIncludedEvents.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListIncludedEvents.contains(token)) continue;
				aListExcludedEvents.add(token);
			}
		}
		else if (eventsEntry.startsWith("all")&& !eventsEntry.endsWith(":none"))
		{
			String temp = eventsEntry.substring(eventsEntry.lastIndexOf(":")+1);
			StringTokenizer st3 = new StringTokenizer(temp,",");

			while (st3.hasMoreTokens())
			{
				thisToken = st3.nextToken().trim();
				aListExcludedEvents.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListExcludedEvents.contains(token)) continue;
				aListIncludedEvents.add(token);
			}
		}
	}

	screenLabels.put("admin.vcevent.Please choose an event category",_mapping.getTextDescription("admin.vcevent.Please choose an event category"));
	screenLabels.put("admin.vcevent.Event category",_mapping.getTextDescription("admin.vcevent.Event category"));
	screenLabels.put("admin.vcevent.Included Events",_mapping.getTextDescription("admin.vcevent.INCLUDED EVENTS"));
	screenLabels.put("admin.vcevent.Excluded Events",_mapping.getTextDescription("admin.vcevent.EXCLUDED EVENTS"));
	screenLabels.put("admin.common.Update",_mapping.getTextDescription("admin.common.Update"));
	screenLabels.put("admin.vcevent.Events have been included/excluded sucessfully",_mapping.getTextDescription("admin.vcevent.Events have been included/excluded sucessfully"));

	JSONArray eventCategory = new JSONArray();
	JSONObject objevent = new JSONObject();

	if (aListDescriptor != null && aListDescriptor.size() > 0)
	{
		objevent.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
		objevent.put("valueField","-1");
		eventCategory.add(objevent);

		for (int j=0;j<aListDescriptor.size();j++)
		{
			String descVal = (String)aListDescriptor.get(j);
			objevent.put("displayField",descVal);
			objevent.put("valueField",descVal);
			eventCategory.add(objevent);
		}
	}
	else
	{
		objevent.put("displayField",_mapping.getTextDescription("admin.vcevent.Not Applicable"));
		objevent.put("valueField","-1");
		eventCategory.add(objevent);
	}
	rootJson.put("comboValue",eventCategory);

	Collections.sort(aListIncludedEvents,String.CASE_INSENSITIVE_ORDER);

	JSONArray prevIncludedEvents = new JSONArray();
	JSONArray includedEventsArray = new JSONArray();
	JSONObject includedEventsObject = new JSONObject();

	for (int m=0;m<aListIncludedEvents.size();m++)
	{
		String inclEvents = (String)aListIncludedEvents.get(m);
		prevIncludedEvents.add(inclEvents);

		includedEventsObject.put("displayField",inclEvents);
		includedEventsObject.put("valueField",inclEvents);
		includedEventsArray.add(includedEventsObject);
	}
	rootJson.put("includedEventsArray",includedEventsArray);
	rootJson.put("prevIncludedEvents",prevIncludedEvents);

	Collections.sort(aListExcludedEvents,String.CASE_INSENSITIVE_ORDER);
	JSONArray prevExcludedEvents = new JSONArray();
	JSONArray excludedEventsArray = new JSONArray();
	JSONObject excludedEventsObject = new JSONObject();

	for (int mm=0;mm<aListExcludedEvents.size();mm++)
	{
		String exclEvents = (String)aListExcludedEvents.get(mm);
		prevExcludedEvents.add(exclEvents);

		excludedEventsObject.put("displayField",exclEvents);
		excludedEventsObject.put("valueField",exclEvents);
		excludedEventsArray.add(excludedEventsObject);
	}
	rootJson.put("excludedEventsArray",excludedEventsArray);
	rootJson.put("prevExcludedEvents",prevExcludedEvents);
	rootJson.put("screenLabels",screenLabels);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAgentSettings.jsp?"+request.getQueryString());

	System.out.println("rootJson_______"+rootJson);
	out.println(rootJson.toString());
%>



