
/**
 * Traditional Chinese translation
 * By hata1234
 * 09 April 2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm),
        parseCodes;

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ǅ...</div>';
    }

    Ext.define("Ext.locale.zh_TW.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.zh_TW.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "焦 {0} "
    });

    Ext.define("Ext.locale.zh_TW.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "놡և"
    });

    Ext.define("Ext.locale.zh_TW.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "ǭ쇼ꆼ䄻숪Ņ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.zh_TW.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ǅ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ǆ", "", "놣", "", "", "ࡆ", "↣", "ཆ", "", "", "ǆ", ""];

        Ext.Date.dayNames = ["", "", "", "", "", "", ""];

        Ext.Date.formatCodes.a = "(this.getHours() < 12 ? '' : '')";
        Ext.Date.formatCodes.A = "(this.getHours() < 12 ? '' : '')";

        parseCodes = {
            g: 1,
            c: "if (/()/i.test(results[{0}])) {\n"
                + "if (!h || h == 12) { h = 0; }\n"
                + "} else { if (!h || h < 12) { h = (h || 0) + 12; }}",
            s: "(|)",
            calcAtEnd: true
        };

        Ext.Date.parseCodes.a = Ext.Date.parseCodes.A = parseCodes;
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "󦅫",
            cancel: "",
            yes: "",
            no: "ɪ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: ',',
            decimalSeparator: '.',
            currencySign: '\u00a5',
            // Chinese Yuan
            dateFormat: 'Y/m/d'
        });
    }

    Ext.define("Ext.locale.zh_TW.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "",
        minText: "цǅŅц",
        maxText: "цꅗņǅ񺅫ц",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: " (Ctrl+)",
        prevText: " (Ctrl+)",
        monthYearText: "熣ꄩ (Ctrl+/촉煠)",
        format: "y/m/d",
        ariaTitle: '{0}',
        ariaTitleDateFormat: 'Y\u5e74m\u6708d\u65e5',
        longDayFormat: 'Y\u5e74m\u6708d\u65e5',
        monthYearFormat: 'Y\u5e74m\u6708',
        getDayInitial: function (value) {
            // Grab the last character
            return value.substr(value.length - 1);
        }
    });

    Ext.define("Ext.locale.zh_TW.picker.Month", {
        override: "Ext.picker.Month",
        okText: "",
        cancelText: ""
    });

    Ext.define("Ext.locale.zh_TW.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "",
        afterPageText: "{0}",
        firstText: "ǉ",
        prevText: "脹ǉ",
        nextText: "ǉ",
        lastText: "ǅ",
        refreshText: "",
        displayMsg: "{0} - {1},{2}",
        emptyMsg: 'Ɔ넩'
    });

    Ext.define("Ext.locale.zh_TW.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "䄻솣ǅ截 {0} ",
        maxLengthText: "䄻솣ǅ܈ {0} ",
        blankText: "䄻馅",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.zh_TW.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "䄻선ǭ {0}",
        maxText: "䄻선ǭꅗņ {0}",
        nanText: "{0} 򹅡"
    });

    Ext.define("Ext.locale.zh_TW.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "",
        disabledDatesText: "",
        minText: "䄻선цꅣ {0} ",
        maxText: "䄻선цꅣ {0} ",
        invalidText: "{0} цᭅ - ņ  {1}  ֆᭅ",
        format: "Y/m/d"
    });

    Ext.define("Ext.locale.zh_TW.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ǅ ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: '䄻ꈭх "user@example.com" E-Mailᭅ',
            urlText: '䄻ꈭх "http:/' + '/www.example.com" ǆᭅ',
            alphaText: '䄻⻈х腻煡腦( _ )֖',
            alphanumText: '䄻⻈х腻煡򹅡腦( _ )֖'
        });
    }

    Ext.define("Ext.locale.zh_TW.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "ƅ",
        sortDescText: "ƅ",
        lockText: "܆䄻",
        unlockText: "䄻",
        columnsText: "䄻"
    });

    Ext.define("Ext.locale.zh_TW.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "쇿",
        valueText: "ǭ",
        dateFormat: "Y/m/d"
    });

});
