/**
 * Romanian translations for ExtJS 2.1
 * First released by Lucian Lature on 2007-04-24
 * Changed locale for Romania (date formats) as suggested by keypoint
 * on ExtJS forums: http://www.extjs.com/forum/showthread.php?p=129524#post129524
 * Removed some useless parts
 * Changed by: Emil Cazamir, 2008-04-24
 * Fixed some errors left behind
 * Changed by: Emil Cazamir, 2008-09-01
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);


    if (Ext.updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ncrcare...</div>';
    }

    Ext.define("Ext.locale.ro.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} rnd(uri) selectate"
    });

    Ext.define("Ext.locale.ro.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "nchide acest tab"
    });

    Ext.define("Ext.locale.ro.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Valoarea acestui cmp este invalid"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.ro.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ncrcare..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Ianuarie", "Februarie", "Martie", "Aprilie", "Mai", "Iunie", "Iulie", "August", "Septembrie", "Octombrie", "Noiembrie", "Decembrie"];

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.monthNames[month].substring(0, 3);
        };

        Ext.Date.monthNumbers = {
            Ian: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            Mai: 4,
            Iun: 5,
            Iul: 6,
            Aug: 7,
            Sep: 8,
            Oct: 9,
            Noi: 10,
            Dec: 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1, 3).toLowerCase()];
        };

        Ext.Date.dayNames = ["Duminic", "Luni", "Mari", "Miercuri", "Joi", "Vineri", "Smbt"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Renun",
            yes: "Da",
            no: "Nu"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'Lei',
            // Romanian Lei
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.ro.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Astzi",
        minText: "Aceast dat este anterioar datei minime",
        maxText: "Aceast dat este ulterioar datei maxime",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Luna urmtoare (Control+Dreapta)',
        prevText: 'Luna precedent (Control+Stnga)',
        monthYearText: 'Alege o lun (Control+Sus/Jos pentru a parcurge anii)',
        todayTip: "{0} (Bara spaiu)",
        format: "d.m.Y",
        startDay: 0
    });

    Ext.define("Ext.locale.ro.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Renun"
    });

    Ext.define("Ext.locale.ro.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Pagina",
        afterPageText: "din {0}",
        firstText: "Prima pagin",
        prevText: "Pagina anterioar",
        nextText: "Pagina urmtoare",
        lastText: "Ultima pagin",
        refreshText: "mprospteaz",
        displayMsg: "Afiare ȫnregistrrile {0} - {1} din {2}",
        emptyMsg: 'Nu sunt date de afiat'
    });

    Ext.define("Ext.locale.ro.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Lungimea minim pentru acest cmp este de {0}",
        maxLengthText: "Lungimea maxim pentru acest cmp este {0}",
        blankText: "Acest cmp este obligatoriu",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.ro.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Valoarea minim permis a acestui cmp este {0}",
        maxText: "Valaorea maxim permis a acestui cmp este {0}",
        nanText: "{0} nu este un numr valid"
    });

    Ext.define("Ext.locale.ro.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Indisponibil",
        disabledDatesText: "Indisponibil",
        minText: "Data din aceast caset trebuie s fie dup {0}",
        maxText: "Data din aceast caset trebuie s fie inainte de {0}",
        invalidText: "{0} nu este o dat valid, trebuie s fie ȫn formatul {1}",
        format: "d.m.Y",
        altFormats: "d-m-Y|d.m.y|d-m-y|d.m|d-m|dm|d|Y-m-d"
    });

    Ext.define("Ext.locale.ro.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ncrcare..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'Acest cmp trebuie s conin o adres de e-mail ȫn formatul "user@domeniu.com"',
            urlText: 'Acest cmp trebuie s conin o adres URL ȫn formatul "http:/' + '/www.domeniu.com"',
            alphaText: 'Acest cmp trebuie s conin doar litere ʖi _',
            alphanumText: 'Acest cmp trebuie s conin doar litere, cifre ʖi _'
        });
    }

    Ext.define("Ext.locale.ro.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'V rugm introduceti un URL pentru aceast legtur web:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'ngroʖat (Ctrl+B)',
                    text: 'ngroʖati caracterele textului selectat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'nclinat (Ctrl+I)',
                    text: 'nclinai caracterele textului selectat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Subliniat (Ctrl+U)',
                    text: 'Subliniai caracterele textului selectat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Mrit',
                    text: 'Mreʖte dimensiunea fontului.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'Micʖorat',
                    text: 'Micʖoreaz dimensiunea textului.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Culoarea fundalului',
                    text: 'Schimb culoarea fundalului pentru textul selectat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Culoarea textului',
                    text: 'Schimb culoarea textului selectat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Aliniat la stnga',
                    text: 'Aliniaz textul la stnga.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Centrat',
                    text: 'Centreaz textul ȫn editor.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Aliniat la dreapta',
                    text: 'Aliniaz textul la dreapta.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'List cu puncte',
                    text: 'Insereaz list cu puncte.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'List numerotat',
                    text: 'Insereaz o list numerotat.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'Legtur web',
                    text: 'Transform textul selectat ȫn legtur web.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'Editare surs',
                    text: 'Schimb pe modul de editare al codului HTML.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.ro.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Sortare ascendent",
        sortDescText: "Sortare descendent",
        lockText: "Blocheaz coloana",
        unlockText: "Deblocheaz coloana",
        columnsText: "Coloane"
    });

    Ext.define("Ext.locale.ro.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(Fr)',
        groupByText: 'Grupeaz dup aceast coloan',
        showGroupsText: 'Afieaz grupat'
    });

    Ext.define("Ext.locale.ro.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Nume",
        valueText: "Valoare",
        dateFormat: "d.m.Y"
    });

});
