/**
 * Latvian Translations
 * By salix 17 April 2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Notiek ielde...</div>';
    }

    Ext.define("Ext.locale.lv.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.lv.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} iezmtu rindu"
    });

    Ext.define("Ext.locale.lv.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Aizver o zmni"
    });

    Ext.define("Ext.locale.lv.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Vrtba aj lauk nav pareiza"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.lv.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Ield..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Janvris", "Februris", "Marts", "Aprlis", "Maijs", "Jʽnijs", "Jʽlijs", "Augusts", "Septembris", "Oktobris", "Novembris", "Decembris"];

        Ext.Date.dayNames = ["Svtdiena", "Pirmdiena", "Otrdiena", "Trediena", "Ceturtdiena", "Piektdiena", "Sestdiena"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "Labi",
            cancel: "Atcelt",
            yes: "J",
            no: "N"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: 'Ls',
            // Latvian Lati
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.lv.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "odiena",
        minText: "Nordtais datums ir mazks par minimlo datumu",
        maxText: "Nordtais datums ir lielks par maksimlo datumu",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Nkamais mnesis (Control+pa labi)',
        prevText: 'Iepriekjais mnesis (Control+pa kreisi)',
        monthYearText: 'Mnea izvle (Control+uz augu/uz leju lai prslgtu gadus)',
        todayTip: "{0} (Tukumzme)",
        format: "d.m.Y",
        startDay: 1
    });

    Ext.define("Ext.locale.lv.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Lapa",
        afterPageText: "no {0}",
        firstText: "Pirm lapa",
        prevText: "iepriekj lapa",
        nextText: "Nkam lapa",
        lastText: "Pdj lapa",
        refreshText: "Atsvaidzint",
        displayMsg: "Rda no {0} ldz {1} ierakstiem, kop {2}",
        emptyMsg: 'Nav datu, ko pardt'
    });

    Ext.define("Ext.locale.lv.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Minimlais garums im laukam ir {0}",
        maxLengthText: "Maksimlais garums im laukam ir {0}",
        blankText: "is ir obligts lauks",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.lv.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Minimlais garums im laukam ir  {0}",
        maxText: "Maksimlais garums im laukam ir  {0}",
        nanText: "{0} nav pareizs skaitlis"
    });

    Ext.define("Ext.locale.lv.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Atspjots",
        disabledDatesText: "Atspjots",
        minText: "Datumam aj lauk jbʽt lielkam k {0}",
        maxText: "Datumam aj lauk jbʽt mazkam k {0}",
        invalidText: "{0} nav pareizs datums - tam jbʽt d formt: {1}",
        format: "d.m.Y"
    });

    Ext.define("Ext.locale.lv.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Ield..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'aj lauk jieraksta e-pasta adrese formt "lietots@domns.lv"',
            urlText: 'aj lauk jieraksta URL formt "http:/' + '/www.domns.lv"',
            alphaText: 'is lauks drkst saturt tikai burtus un _ zmi',
            alphanumText: 'is lauks drkst saturt tikai burtus, ciparus un _ zmi'
        });
    }

    Ext.define("Ext.locale.lv.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Krtot pieaugo secb",
        sortDescText: "Krtot dilsto secb",
        lockText: "Noslgt kolonnu",
        unlockText: "Atslgt kolonnu",
        columnsText: "Kolonnas"
    });

    Ext.define("Ext.locale.lv.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Nosaukums",
        valueText: "Vrtba",
        dateFormat: "j.m.Y"
    });

});
