/**
 * Greek (Old Version) Translations by Vagelis
 * 03-June-2007
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">ȭȘȳȠȺ...</div>';
    }

    Ext.define("Ext.locale.gr.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.gr.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} ȗȨȽȼȥȡȺ(ș) ȘȼȼȤ(ȥș)"
    });

    Ext.define("Ext.locale.gr.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "ȽȖȳ ȴȳȤ ȳȺȡ ȬȘȳȥȽ"
    });

    Ext.define("Ext.locale.gr.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: " ȳȨȼȤ ȳȯ ȗȖȯ ȡ ȖȡȨ ȥȬȴȘȺ"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.gr.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "ȭȘȳȠȺ..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["ȡȯȴȣȘȨȯș", "ȘȯȴȣȘȨȯș", "ȣȘȳȨȯș", "ȗȘȖȽȨȯș", "ȣȨȯș", "ȯȻȡȨȯș", "ȯȻȽȨȯș", "Ȼȯȴȳȯș", "ȗȳȥȼȘȨȯș", "ȬȳȾȘȨȯș", "ȯȥȼȘȨȯș", "ȬȥȼȘȨȯș"];

        Ext.Date.dayNames = ["ȴȘȨȬȤ", "ȴȳȥȘ", "ȘȖȳȺ", "ȳȣȘȳȺ", "ȥȼȗȳȺ", "ȘȬȴȤ", "ȣȳȯ"];
    }

    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "ȡȳȣȫȨ",
            cancel: "ȬȻȘȠȺ",
            yes: "Ȩ",
            no: "íȸȨ"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u20ac',
            // Greek Euro
            dateFormat: 'ȼ/Ⱥ/'
        });
    }

    Ext.define("Ext.locale.gr.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "ȤȼȘ",
        minText: " ȺȼȘȯȼȺȡȖ ȴȳȤ ȖȡȨ ȗȘȨȡ ȳȺȡ ȼȨȬȘȭȳȘȺ ȺȼȘȯȼȺȡȖ",
        maxText: " ȺȼȘȯȼȺȡȖ ȴȳȤ ȖȡȨ ȼȳȣ ȳȺȡ ȼȽȻȳȘȺ ȺȼȘȯȼȺȡȖ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'ȗȭȼȡȯș Ȥȡș (Control+Right)',
        prevText: 'ȘȯȺȯȻȼȡȯș Ȥȡș (Control+Left)',
        monthYearText: 'ȗȨȽȥȫȳ Ȥȡ (Control+Up/Down Ȩ ȼȳȬȖȡȺȺ ȳ ȥȳȺ)',
        todayTip: "{0} (Spacebar)",
        format: "ȼ/Ⱥ/"
    });

    Ext.define("Ext.locale.gr.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "ȽȖ",
        afterPageText: "ȗȭ {0}",
        firstText: "ȘȾȳȺ ȽȖ",
        prevText: "ȘȯȺȯȻȼȡȺ ȽȖ",
        nextText: "ȗȭȼȡȺ ȽȖ",
        lastText: "ȽȴȳȖ ȽȖ",
        refreshText: "ȡȡȥȠȺ",
        displayMsg: "ȼȵȣȡȨȺ {0} - {1} ȗȭ {2}",
        emptyMsg: 'ȡ ȘȥȿȺȬȡ Șȵȥș Ȩ ȼȵȣȡȨȺ'
    });

    Ext.define("Ext.locale.gr.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "ȯ ȽȣȸȨȳȯ ȼȥȿȯș Ȩ ȴȳȭ ȳȯ ȗȖȯ ȖȡȨ {0}",
        maxLengthText: "ȯ ȼȥȨȳȯ ȼȥȿȯș Ȩ ȴȳȭ ȳȯ ȗȖȯ ȖȡȨ {0}",
        blankText: "ȯ ȗȖȯ ȴȳȭ ȖȡȨ ȴȗȯȸȘȠȳȯȬȭ",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.gr.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: " ȽȣȸȨȳȺ ȳȨȼȤ Ȩ ȴȳȭ ȳȯ ȗȖȯ ȖȡȨ {0}",
        maxText: " ȼȥȨȳȺ ȳȨȼȤ Ȩ ȴȳȭ ȳȯ ȗȖȯ ȖȡȨ {0}",
        nanText: "{0} ȡ ȖȡȨ ȥȬȴȘȯș ȘȨȿȼȭș"
    });

    Ext.define("Ext.locale.gr.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "ȗȡȘȯȗȯȨȺȼȥȡȯ",
        disabledDatesText: "ȗȡȘȯȗȯȨȺȼȥȡȯ",
        minText: " ȺȼȘȯȼȺȡȖ ' ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȖȡȨ ȼȳȣ ȗȭ {0}",
        maxText: " ȺȼȘȯȼȺȡȖ ' ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȖȡȨ ȗȘȨȡ ȗȭ {0}",
        invalidText: "{0} ȡ ȖȡȨ ȥȬȴȘȺ ȺȼȘȯȼȺȡȖ - ȗȘȥȗȨ ȡ ȖȡȨ ȳȺș ȼȯȘȵȤș {1}",
        format: "ȼ/Ⱥ/"
    });

    Ext.define("Ext.locale.gr.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "ȭȘȳȠȺ..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȖȡȨ e-mail address ȳȺș ȼȯȘȵȤș "user@example.com"',
            urlText: 'ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȖȡȨ ȼȨ ȨȻȿȴȡȺ URL ȳȺș ȼȯȘȵȤș "http:/' + '/www.example.com"',
            alphaText: 'ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȗȘȨȥȸȨ Șȣȼȼȳ ȬȨ _',
            alphanumText: 'ȴȳȭ ȳȯ ȗȖȯ ȗȘȥȗȨ ȡ ȗȘȨȥȸȨ Șȣȼȼȳ, ȘȨȿȼȯȻș ȬȨ _'
        });
    }

    Ext.define("Ext.locale.gr.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "Ȼȫȯȴ ȫȨȡȭȼȺȺ",
        sortDescText: "ȿȖȡȯȴ ȫȨȡȭȼȺȺ",
        lockText: "ȽȖȠȼ ȳȤȽȺș",
        unlockText: "ȬȽȖȠȼ ȳȤȽȺș",
        columnsText: "ȳȤȽș"
    });

    Ext.define("Ext.locale.gr.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "íȡȯȼ",
        valueText: "ȨȼȤ",
        dateFormat: "ȼ/Ⱥ/"
    });

});
