/**
 * Czech Translations
 * Translated by Tom Kork (72)
 * 2008/02/08 18:02, Ext-2.0.1
 */
Ext.onReady(function() {
    var cm = Ext.ClassManager,
        exists = Ext.Function.bind(cm.get, cm);

    if (Ext.Updater) {
        Ext.Updater.defaults.indicatorText = '<div class="loading-indicator">Prosȡm ekejte...</div>';
    }

    Ext.define("Ext.locale.cs.view.View", {
        override: "Ext.view.View",
        emptyText: ""
    });

    Ext.define("Ext.locale.cs.grid.Panel", {
        override: "Ext.grid.Panel",
        ddText: "{0} vybranȻch dkʯ"
    });

    Ext.define("Ext.locale.cs.TabPanelItem", {
        override: "Ext.TabPanelItem",
        closeText: "Zavȡt zloʾku"
    });

    Ext.define("Ext.locale.cs.form.field.Base", {
        override: "Ext.form.field.Base",
        invalidText: "Hodnota v tomto poli je neplatn"
    });

    // changing the msg text below will affect the LoadMask
    Ext.define("Ext.locale.cs.view.AbstractView", {
        override: "Ext.view.AbstractView",
        msg: "Prosȡm ekejte..."
    });

    if (Ext.Date) {
        Ext.Date.monthNames = ["Leden", "nor", "Bezen", "Duben", "Kvten", "erven", "ervenec", "Srpen", "Zȡ", "ȡjen", "Listopad", "Prosinec"];

        Ext.Date.shortMonthNames = {
            "Leden": "Led",
            "nor": "no",
            "Bezen": "Be",
            "Duben": "Dub",
            "Kvten": "Kv",
            "erven": "er",
            "ervenec": "vc",
            "Srpen": "Srp",
            "Zȡ": "Z",
            "ȡjen": "ȡj",
            "Listopad": "Lis",
            "Prosinec": "Pro"
        };

        Ext.Date.getShortMonthName = function(month) {
            return Ext.Date.shortMonthNames[Ext.Date.monthNames[month]];
        };

        Ext.Date.monthNumbers = {
            "Leden": 0,
            "nor": 1,
            "Bezen": 2,
            "Duben": 3,
            "Kvten": 4,
            "erven": 5,
            "ervenec": 6,
            "Srpen": 7,
            "Zȡ": 8,
            "ȡjen": 9,
            "Listopad": 10,
            "Prosinec": 11
        };

        Ext.Date.getMonthNumber = function(name) {
            return Ext.Date.monthNumbers[name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase()];
        };

        Ext.Date.dayNames = ["Nedle", "Pondlȡ", "terȻ", "Steda", "tvrtek", "Ptek", "Sobota"];

        Ext.Date.getShortDayName = function(day) {
            return Ext.Date.dayNames[day].substring(0, 3);
        };
    }
    if (Ext.MessageBox) {
        Ext.MessageBox.buttonText = {
            ok: "OK",
            cancel: "Storno",
            yes: "Ano",
            no: "Ne"
        };
    }

    if (exists('Ext.util.Format')) {
        Ext.apply(Ext.util.Format, {
            thousandSeparator: '.',
            decimalSeparator: ',',
            currencySign: '\u004b\u010d',
            // Czech Koruny
            dateFormat: 'd.m.Y'
        });
    }

    Ext.define("Ext.locale.cs.picker.Date", {
        override: "Ext.picker.Date",
        todayText: "Dnes",
        minText: "Datum nesmȡ bȻt starȡ neʾ je minimlnȡ",
        maxText: "Datum nesmȡ bȻt dȡvjȡ neʾ je maximlnȡ",
        disabledDaysText: "",
        disabledDatesText: "",
        monthNames: Ext.Date.monthNames,
        dayNames: Ext.Date.dayNames,
        nextText: 'Nsledujȡcȡ msȡc (Control+Right)',
        prevText: 'Pedchzejȡcȡ msȡc (Control+Left)',
        monthYearText: 'Zvolte msȡc (ke zmn let pouʾijte Control+Up/Down)',
        todayTip: "{0} (Spacebar)",
        format: "d.m.Y",
        startDay: 1
    });

    Ext.define("Ext.locale.cs.picker.Month", {
        override: "Ext.picker.Month",
        okText: "&#160;OK&#160;",
        cancelText: "Storno"
    });

    Ext.define("Ext.locale.cs.toolbar.Paging", {
        override: "Ext.PagingToolbar",
        beforePageText: "Strana",
        afterPageText: "z {0}",
        firstText: "Prvnȡ strana",
        prevText: "Pechzejȡcȡ strana",
        nextText: "Nsledujȡcȡ strana",
        lastText: "Poslednȡ strana",
        refreshText: "Aktualizovat",
        displayMsg: "Zobrazeno {0} - {1} z celkovȻch {2}",
        emptyMsg: 'ʻdnȨ zznamy nebyly nalezeny'
    });

    Ext.define("Ext.locale.cs.form.field.Text", {
        override: "Ext.form.field.Text",
        minLengthText: "Pole nesmȡ mȡt mȨn {0} znakʯ",
        maxLengthText: "Pole nesmȡ bȻt delȡ neʾ {0} znakʯ",
        blankText: "This field is required",
        regexText: "",
        emptyText: null
    });

    Ext.define("Ext.locale.cs.form.field.Number", {
        override: "Ext.form.field.Number",
        minText: "Hodnota v tomto poli nesmȡ bȻt menȡ neʾ {0}",
        maxText: "Hodnota v tomto poli nesmȡ bȻt vtȡ neʾ {0}",
        nanText: "{0} nenȡ platnȨ ȡslo"
    });

    Ext.define("Ext.locale.cs.form.field.Date", {
        override: "Ext.form.field.Date",
        disabledDaysText: "Neaktivnȡ",
        disabledDatesText: "Neaktivnȡ",
        minText: "Datum v tomto poli nesmȡ bȻt starȡ neʾ {0}",
        maxText: "Datum v tomto poli nesmȡ bȻt novjȡ neʾ {0}",
        invalidText: "{0} nenȡ platnȻm datem - zkontrolujte zda-li je ve formtu {1}",
        format: "d.m.Y",
        altFormats: "d/m/Y|d-m-y|d-m-Y|d/m|d-m|dm|dmy|dmY|d|Y-m-d"
    });

    Ext.define("Ext.locale.cs.form.field.ComboBox", {
        override: "Ext.form.field.ComboBox",
        valueNotFoundText: undefined
    }, function() {
        Ext.apply(Ext.form.field.ComboBox.prototype.defaultListConfig, {
            loadingText: "Prosȡm ekejte..."
        });
    });

    if (exists('Ext.form.field.VTypes')) {
        Ext.apply(Ext.form.field.VTypes, {
            emailText: 'V tomto poli mʯʾe bȻt vyplnna pouze emailov adresa ve formtu "uʾivatel@domȨna.cz"',
            urlText: 'V tomto poli mʯʾe bȻt vyplnna pouze URL (adresa internetovȨ strnky) ve formtu "http:/' + '/www.domȨna.cz"',
            alphaText: 'Toto pole mʯʾe obsahovat pouze pȡsmena abecedy a znak _',
            alphanumText: 'Toto pole mʯʾe obsahovat pouze pȡsmena abecedy, ȡsla a znak _'
        });
    }

    Ext.define("Ext.locale.cs.form.field.HtmlEditor", {
        override: "Ext.form.field.HtmlEditor",
        createLinkText: 'Zadejte URL adresu odkazu:'
    }, function() {
        Ext.apply(Ext.form.field.HtmlEditor.prototype, {
            buttonTips: {
                bold: {
                    title: 'TunȨ (Ctrl+B)',
                    text: 'Oznaȡ vybranȻ text tun.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                italic: {
                    title: 'Kurzȡva (Ctrl+I)',
                    text: 'Oznaȡ vybranȻ text kurzȡvou.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                underline: {
                    title: 'Podtrʾenȡ (Ctrl+U)',
                    text: 'Podtrhne vybranȻ text.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                increasefontsize: {
                    title: 'Zvtit pȡsmo',
                    text: 'Zvtȡ velikost pȡsma.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                decreasefontsize: {
                    title: 'ZȦʾit pȡsmo',
                    text: 'Zmenȡ velikost pȡsma.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                backcolor: {
                    title: 'Barva zvȻraznnȡ textu',
                    text: 'Oznaȡ vybranȻ text tak, aby vypadal jako oznaenȻ zvȻrazovaem.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                forecolor: {
                    title: 'Barva pȡsma',
                    text: 'Zmnȡ barvu textu.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyleft: {
                    title: 'Zarovnat text vlevo',
                    text: 'Zarovn text doleva.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifycenter: {
                    title: 'Zarovnat na sted',
                    text: 'Zarovn text na sted.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                justifyright: {
                    title: 'Zarovnat text vpravo',
                    text: 'Zarovn text doprava.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertunorderedlist: {
                    title: 'Odrʾky',
                    text: 'Zane seznam s odrʾkami.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                insertorderedlist: {
                    title: 'ȡslovnȡ',
                    text: 'Zane ȡslovanȻ seznam.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                createlink: {
                    title: 'InternetovȻ odkaz',
                    text: 'Z vybranȨho textu vytvoȡ internetovȻ odkaz.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                },
                sourceedit: {
                    title: 'ZdrojovȻ kd',
                    text: 'Pepne do mdu Ȧpravy zdrojovȨho kdu.',
                    cls: Ext.baseCSSPrefix + 'html-editor-tip'
                }
            }
        });
    });

    Ext.define("Ext.locale.cs.grid.header.Container", {
        override: "Ext.grid.header.Container",
        sortAscText: "adit vzestupn",
        sortDescText: "adit sestupn",
        lockText: "Ukotvit sloupec",
        unlockText: "Uvolnit sloupec",
        columnsText: "Sloupce"
    });

    Ext.define("Ext.locale.cs.grid.GroupingFeature", {
        override: "Ext.grid.GroupingFeature",
        emptyGroupText: '(ʻdn data)',
        groupByText: 'Seskupit dle tohoto pole',
        showGroupsText: 'Zobrazit ve skupin'
    });

    Ext.define("Ext.locale.cs.grid.PropertyColumnModel", {
        override: "Ext.grid.PropertyColumnModel",
        nameText: "Nzev",
        valueText: "Hodnota",
        dateFormat: "j.m.Y"
    });

});
