#!/bin/sh

# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
#  Set CLASSPATH and Java options
#
#  $Id: setclasspath.sh 795037 2009-07-17 10:52:16Z markt $
# -----------------------------------------------------------------------------

# Make sure prerequisite environment variables are set
if [ -z "$JAVA_HOME" -a -z "$JRE_HOME" ]; then
  # Bugzilla 37284 (reviewed).
  if $darwin; then
    if [ -d "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home" ]; then
      export JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Home"
    fi
  else
    JAVA_PATH=`which java 2>/dev/null`
    if [ "x$JAVA_PATH" != "x" ]; then
      JAVA_PATH=`dirname $JAVA_PATH 2>/dev/null`
      JRE_HOME=`dirname $JAVA_PATH 2>/dev/null`
    fi
    if [ "x$JRE_HOME" = "x" ]; then
      # XXX: Should we try other locations?
      if [ -x /usr/bin/java ]; then
        JRE_HOME=/usr
      fi
    fi
  fi
  if [ -z "$JAVA_HOME" -a -z "$JRE_HOME" ]; then
    echo "Neither the JAVA_HOME nor the JRE_HOME environment variable is defined"
    echo "At least one of these environment variable is needed to run this program"
    exit 1
  fi
fi
if [ -z "$JAVA_HOME" -a "$1" = "debug" ]; then
  echo "JAVA_HOME should point to a JDK in order to run in debug mode."
  exit 1
fi
echo "JAVA HOME ISSSSSSSSSSSSSSSSSSS $JAVA_HOME"
if [ -z "$JRE_HOME" ]; then
  JRE_HOME="$JAVA_HOME"
fi

# If we're running under jdb, we need a full jdk.
if [ "$1" = "debug" ] ; then
  if [ "$os400" = "true" ]; then
    if [ ! -x "$JAVA_HOME"/bin/java -o ! -x "$JAVA_HOME"/bin/javac ]; then
      echo "The JAVA_HOME environment variable is not defined correctly"
      echo "This environment variable is needed to run this program"
      echo "NB: JAVA_HOME should point to a JDK not a JRE"
      exit 1
    fi
  else
    if [ ! -x "$JAVA_HOME"/bin/java -o ! -x "$JAVA_HOME"/bin/jdb -o ! -x "$JAVA_HOME"/bin/javac ]; then
      echo "The JAVA_HOME environment variable is not defined correctly"
      echo "This environment variable is needed to run this program"
      echo "NB: JAVA_HOME should point to a JDK not a JRE"
      exit 1
    fi
  fi
fi
if [ -z "$BASEDIR" ]; then
  echo "The BASEDIR environment variable is not defined"
  echo "This environment variable is needed to run this program"
  exit 1
fi
if [ ! -x "$BASEDIR"/bin/setclasspath.sh ]; then
  if $os400; then
    # -x will Only work on the os400 if the files are:
    # 1. owned by the user
    # 2. owned by the PRIMARY group of the user
    # this will not work if the user belongs in secondary groups
    eval
  else
    echo "The BASEDIR environment variable is not defined correctly"
    echo "This environment variable is needed to run this program"
    exit 1
  fi
fi

# Don't override the endorsed dir if the user has set it previously
if [ -z "$JAVA_ENDORSED_DIRS" ]; then
  # Set the default -Djava.endorsed.dirs argument
  JAVA_ENDORSED_DIRS="$BASEDIR"/endorsed
fi

# OSX hack to CLASSPATH
JIKESPATH=
if [ `uname -s` = "Darwin" ]; then
  OSXHACK="/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Classes"
  if [ -d "$OSXHACK" ]; then
    for i in "$OSXHACK"/*.jar; do
      JIKESPATH="$JIKESPATH":"$i"
    done
  fi
fi

# Set standard commands for invoking Java.
_RUNJAVA="$JRE_HOME"/bin/java
if [ "$os400" != "true" ]; then
  _RUNJDB="$JAVA_HOME"/bin/jdb
fi


EG_HOME=/opt/egurkha
export EG_HOME

EGURKHA_INSTALL_DIR=$EG_HOME
CATALINA_HOME=$EG_HOME/manager/tomcat
EG_LIB=$EG_HOME/lib
PJA_HOME=$EG_HOME/manager/pja

export EGURKHA_INSTALL_DIR CATALINA_HOME EG_LIB PJA_HOME

LD_LIBRARY_PATH=$EG_HOME/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

CLASSPATH=.:$EG_HOME/lib/httpcore.jar:$CATALINA_HOME/bin/bootstrap.jar:$CATALINA_HOME/bin/tomcat-juli.jar:$CATALINA_HOME/lib/catalina.jar:$CATALINA_HOME/lib/servlet-api.jar:$CATALINA_HOME/lib/jsp-api.jar:$CATALINA_HOME/bin/commons-daemon.jar:$CATALINA_HOME/lib/catalina-ant.jar:$CATALINA_HOME/lib/annotations-api.jar:$CATALINA_HOME/lib/catalina-ha.jar:$CATALINA_HOME/lib/catalina-tribes.jar:$CATALINA_HOME/lib/el-api.jar:$CATALINA_HOME/lib/ecj-3.3.1.jar:$CATALINA_HOME/lib/jasper.jar:$CATALINA_HOME/lib/jasper-el.jar:$CATALINA_HOME/lib/tomcat-coyote.jar:$CATALINA_HOME/lib/tomcat-dbcp.jar:$CATALINA_HOME/webapps/final/WEB-INF/classes:$EG_HOME/lib/eg_manager.jar:$EG_HOME/lib/eg_util.jar:$EG_HOME/lib/pd4ml.jar:$EG_HOME/lib/pdfbox-app.jar:$EG_HOME/lib/ss_css2.jar:$EG_HOME/lib/java-ssh.jar:$EG_HOME/lib/fcexporter.jar:$EG_HOME/lib/dnsjava.jar:$EG_HOME/lib/spark.jar:$EG_HOME/lib/font.jar:$EG_HOME/lib/pop3.jar:$EG_HOME/lib/ireasoningsnmp.jar:$EG_HOME/lib/jakarta-regexp-1.2.jar:$EG_HOME/lib/NCSO.jar:$EG_HOME/lib/Notes.jar:$EG_HOME/lib/eg_ttclient.jar:$EG_HOME/lib/indexer-taglib.jar:$EG_HOME/lib/GSMEngine.jar:$EG_HOME/lib/eg_troubleticket.jar:$EG_HOME/lib/ThinTds.jar:$EG_HOME/lib/mail.jar:$EG_HOME/lib/:$PJA_HOME/pja.jar:$EG_HOME/lib/Acme.jar:$EG_HOME/lib/eg_jvmdemo.jar:$EG_HOME/lib/jdom.jar:$EG_HOME/lib/jaxen-jdom.jar:$EG_HOME/lib/OpenForecast-0.4.0.jar:$EG_HOME/lib/aws-java-sdk.jar:$EG_HOME/lib/commons-codec.jar:$EG_HOME/lib/commons-httpclient.jar:$PJA_HOME/rtgraphics.jar:$EG_HOME/lib/log4j.jar:$EG_HOME/lib/activation.jar:$EG_LIB/itext.jar:$EG_LIB/jasperreports.jar:$EG_LIB/jce.jar:$EG_LIB/jcert.jar:$EG_LIB/jnet.jar:$EG_LIB/jsse.jar:$EG_LIB/jtds.jar:$EG_LIB/parser.jar:$EG_LIB/xml-apis.jar:$EG_LIB/xercesImpl.jar:$EG_LIB/classes111.zip:$EG_LIB/chart.jar:$EG_LIB/chart.ext.jar:$EG_LIB/chartServer.jar:$CATALINA_HOME/lib/commons-beanutils.jar:$JAVA_LIB/tools.jar:$JAVA_LIB/dt.jar:$JAVA_LIB/rt.jar:$CLASSPATH
export CLASSPATH
