DROP TABLE XMAppNameTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION number(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppNameTest ON XMAppNameTest(MSMT_TIME);
ALTER TABLE XMAppNameTest ADD constraint PK_XMAppNameTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppNameTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN number(20,4) NOT NULL,
FAILED_APPLICATION_MAX number(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppNameTest_TREND ADD constraint PK_XMAppNameTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppNameTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppNameTest_THRESH ADD constraint PK_XMAppNameTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppNameTest_THRESH ON XMAppNameTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppNameTest ON XMAppNameTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppNameTest ON XMAppNameTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppLaunchTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION number(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppLaunchTest ON XMAppLaunchTest(MSMT_TIME);
ALTER TABLE XMAppLaunchTest ADD constraint PK_XMAppLaunchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppLaunchTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX number(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN number(20,4) NOT NULL,
FAILED_APPLICATION_MAX number(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppLaunchTest_TREND ADD constraint PK_XMAppLaunchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppLaunchTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppLaunchTest_THRESH ADD constraint PK_XMAppLaunchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppLaunchTest_THRESH ON XMAppLaunchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppLaunchTest ON XMAppLaunchTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppLaunchTest ON XMAppLaunchTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBCpuUsageTest CASCADE CONSTRAINTS;
CREATE TABLE UEBCpuUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CPU_USAGE Number(20,4) NOT NULL,
CPU_USAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBCpuUsageTest ON UEBCpuUsageTest(MSMT_TIME);
ALTER TABLE UEBCpuUsageTest ADD constraint PK_UEBCpuUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBCpuUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBCpuUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CPU_USAGE_MIN Number(20,4) NOT NULL,
CPU_USAGE_MAX Number(20,4) NOT NULL,
CPU_USAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBCpuUsageTest_TREND ADD constraint PK_UEBCpuUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBCpuUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBCpuUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CPU_USAGE_MIN VARCHAR2(256) NOT NULL,
CPU_USAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBCpuUsageTest_THRESH ADD constraint PK_UEBCpuUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBCpuUsageTest_THRESH ON UEBCpuUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBCpuUsageTest ON UEBCpuUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBCpuUsageTest ON UEBCpuUsageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBMemUsageTest CASCADE CONSTRAINTS;
CREATE TABLE UEBMemUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_MEMORY Number(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar2(32) NOT NULL,
USED_MEMORY Number(20,4) NOT NULL,
USED_MEMORY_ST varchar2(32) NOT NULL,
FREE_MEMORY Number(20,4) NOT NULL,
FREE_MEMORY_ST varchar2(32) NOT NULL,
MEMORY_UTILIZATION Number(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBMemUsageTest ON UEBMemUsageTest(MSMT_TIME);
ALTER TABLE UEBMemUsageTest ADD constraint PK_UEBMemUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBMemUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBMemUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_MEMORY_MIN Number(20,4) NOT NULL,
TOTAL_MEMORY_MAX Number(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar2(32) NOT NULL,
USED_MEMORY_MIN Number(20,4) NOT NULL,
USED_MEMORY_MAX Number(20,4) NOT NULL,
USED_MEMORY_STCNT varchar2(32) NOT NULL,
FREE_MEMORY_MIN Number(20,4) NOT NULL,
FREE_MEMORY_MAX Number(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar2(32) NOT NULL,
MEMORY_UTILIZATION_MIN Number(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX Number(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBMemUsageTest_TREND ADD constraint PK_UEBMemUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBMemUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBMemUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_MEMORY_MIN VARCHAR2(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR2(256) NOT NULL,
USED_MEMORY_MIN VARCHAR2(256) NOT NULL,
USED_MEMORY_MAX VARCHAR2(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR2(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBMemUsageTest_THRESH ADD constraint PK_UEBMemUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBMemUsageTest_THRESH ON UEBMemUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBMemUsageTest ON UEBMemUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBMemUsageTest ON UEBMemUsageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBArchivStatTest CASCADE CONSTRAINTS;
CREATE TABLE UEBArchivStatTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL,
SIZES Number(20,4) NOT NULL,
SIZES_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBArchivStatTest ON UEBArchivStatTest(MSMT_TIME);
ALTER TABLE UEBArchivStatTest ADD constraint PK_UEBArchivStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBArchivStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBArchivStatTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL,
SIZES_MIN Number(20,4) NOT NULL,
SIZES_MAX Number(20,4) NOT NULL,
SIZES_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBArchivStatTest_TREND ADD constraint PK_UEBArchivStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBArchivStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBArchivStatTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL,
SIZES_MIN VARCHAR2(256) NOT NULL,
SIZES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBArchivStatTest_THRESH ADD constraint PK_UEBArchivStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBArchivStatTest_THRESH ON UEBArchivStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBArchivStatTest ON UEBArchivStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBArchivStatTest ON UEBArchivStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBBkpCapacityTest CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpCapacityTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_SPACE Number(20,4) NOT NULL,
TOTAL_SPACE_ST varchar2(32) NOT NULL,
USED_SPACE Number(20,4) NOT NULL,
USED_SPACE_ST varchar2(32) NOT NULL,
FREE_SPACE Number(20,4) NOT NULL,
FREE_SPACE_ST varchar2(32) NOT NULL,
SPACE_USAGE_PCT Number(20,4) NOT NULL,
SPACE_USAGE_PCT_ST varchar2(32) NOT NULL,
SPACE_FREE_PCT Number(20,4) NOT NULL,
SPACE_FREE_PCT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBBkpCapacityTest ON UEBBkpCapacityTest(MSMT_TIME);
ALTER TABLE UEBBkpCapacityTest ADD constraint PK_UEBBkpCapacityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBBkpCapacityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpCapacityTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_SPACE_MIN Number(20,4) NOT NULL,
TOTAL_SPACE_MAX Number(20,4) NOT NULL,
TOTAL_SPACE_STCNT varchar2(32) NOT NULL,
USED_SPACE_MIN Number(20,4) NOT NULL,
USED_SPACE_MAX Number(20,4) NOT NULL,
USED_SPACE_STCNT varchar2(32) NOT NULL,
FREE_SPACE_MIN Number(20,4) NOT NULL,
FREE_SPACE_MAX Number(20,4) NOT NULL,
FREE_SPACE_STCNT varchar2(32) NOT NULL,
SPACE_USAGE_PCT_MIN Number(20,4) NOT NULL,
SPACE_USAGE_PCT_MAX Number(20,4) NOT NULL,
SPACE_USAGE_PCT_STCNT varchar2(32) NOT NULL,
SPACE_FREE_PCT_MIN Number(20,4) NOT NULL,
SPACE_FREE_PCT_MAX Number(20,4) NOT NULL,
SPACE_FREE_PCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBBkpCapacityTest_TREND ADD constraint PK_UEBBkpCapacityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBBkpCapacityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpCapacityTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SPACE_MIN VARCHAR2(256) NOT NULL,
TOTAL_SPACE_MAX VARCHAR2(256) NOT NULL,
USED_SPACE_MIN VARCHAR2(256) NOT NULL,
USED_SPACE_MAX VARCHAR2(256) NOT NULL,
FREE_SPACE_MIN VARCHAR2(256) NOT NULL,
FREE_SPACE_MAX VARCHAR2(256) NOT NULL,
SPACE_USAGE_PCT_MIN VARCHAR2(256) NOT NULL,
SPACE_USAGE_PCT_MAX VARCHAR2(256) NOT NULL,
SPACE_FREE_PCT_MIN VARCHAR2(256) NOT NULL,
SPACE_FREE_PCT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBBkpCapacityTest_THRESH ADD constraint PK_UEBBkpCapacityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBBkpCapacityTest_THRESH ON UEBBkpCapacityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBBkpCapacityTest ON UEBBkpCapacityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBBkpCapacityTest ON UEBBkpCapacityTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBBkpStatusTest CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL,
SIZES Number(20,4) NOT NULL,
SIZES_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBBkpStatusTest ON UEBBkpStatusTest(MSMT_TIME);
ALTER TABLE UEBBkpStatusTest ADD constraint PK_UEBBkpStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBBkpStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL,
SIZES_MIN Number(20,4) NOT NULL,
SIZES_MAX Number(20,4) NOT NULL,
SIZES_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBBkpStatusTest_TREND ADD constraint PK_UEBBkpStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBBkpStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBBkpStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL,
SIZES_MIN VARCHAR2(256) NOT NULL,
SIZES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBBkpStatusTest_THRESH ADD constraint PK_UEBBkpStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBBkpStatusTest_THRESH ON UEBBkpStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBBkpStatusTest ON UEBBkpStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBBkpStatusTest ON UEBBkpStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBFanStatusTest CASCADE CONSTRAINTS;
CREATE TABLE UEBFanStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
HEALTH_STATUS Number(20,4) NOT NULL,
HEALTH_STATUS_ST varchar2(32) NOT NULL,
SENSOR_STATUS Number(20,4) NOT NULL,
SENSOR_STATUS_ST varchar2(32) NOT NULL,
SPEED Number(20,4) NOT NULL,
SPEED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBFanStatusTest ON UEBFanStatusTest(MSMT_TIME);
ALTER TABLE UEBFanStatusTest ADD constraint PK_UEBFanStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBFanStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBFanStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
HEALTH_STATUS_MIN Number(20,4) NOT NULL,
HEALTH_STATUS_MAX Number(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar2(32) NOT NULL,
SENSOR_STATUS_MIN Number(20,4) NOT NULL,
SENSOR_STATUS_MAX Number(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar2(32) NOT NULL,
SPEED_MIN Number(20,4) NOT NULL,
SPEED_MAX Number(20,4) NOT NULL,
SPEED_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBFanStatusTest_TREND ADD constraint PK_UEBFanStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBFanStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBFanStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
HEALTH_STATUS_MIN VARCHAR2(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR2(256) NOT NULL,
SPEED_MIN VARCHAR2(256) NOT NULL,
SPEED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBFanStatusTest_THRESH ADD constraint PK_UEBFanStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBFanStatusTest_THRESH ON UEBFanStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBFanStatusTest ON UEBFanStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBFanStatusTest ON UEBFanStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTempStatusTest CASCADE CONSTRAINTS;
CREATE TABLE UEBTempStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
HEALTH_STATUS Number(20,4) NOT NULL,
HEALTH_STATUS_ST varchar2(32) NOT NULL,
SENSOR_STATUS Number(20,4) NOT NULL,
SENSOR_STATUS_ST varchar2(32) NOT NULL,
CURRENT_TEMPERATURE Number(20,4) NOT NULL,
CURRENT_TEMPERATURE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBTempStatusTest ON UEBTempStatusTest(MSMT_TIME);
ALTER TABLE UEBTempStatusTest ADD constraint PK_UEBTempStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTempStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBTempStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
HEALTH_STATUS_MIN Number(20,4) NOT NULL,
HEALTH_STATUS_MAX Number(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar2(32) NOT NULL,
SENSOR_STATUS_MIN Number(20,4) NOT NULL,
SENSOR_STATUS_MAX Number(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar2(32) NOT NULL,
CURRENT_TEMPERATURE_MIN Number(20,4) NOT NULL,
CURRENT_TEMPERATURE_MAX Number(20,4) NOT NULL,
CURRENT_TEMPERATURE_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBTempStatusTest_TREND ADD constraint PK_UEBTempStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTempStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBTempStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
HEALTH_STATUS_MIN VARCHAR2(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR2(256) NOT NULL,
CURRENT_TEMPERATURE_MIN VARCHAR2(256) NOT NULL,
CURRENT_TEMPERATURE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBTempStatusTest_THRESH ADD constraint PK_UEBTempStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTempStatusTest_THRESH ON UEBTempStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTempStatusTest ON UEBTempStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTempStatusTest ON UEBTempStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTotalBackupTest CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalBackupTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_BACKUPS Number(20,4) NOT NULL,
TOTAL_BACKUPS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBTotalBackupTest ON UEBTotalBackupTest(MSMT_TIME);
ALTER TABLE UEBTotalBackupTest ADD constraint PK_UEBTotalBackupTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTotalBackupTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalBackupTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_BACKUPS_MIN Number(20,4) NOT NULL,
TOTAL_BACKUPS_MAX Number(20,4) NOT NULL,
TOTAL_BACKUPS_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBTotalBackupTest_TREND ADD constraint PK_UEBTotalBackupTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTotalBackupTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalBackupTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_BACKUPS_MIN VARCHAR2(256) NOT NULL,
TOTAL_BACKUPS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBTotalBackupTest_THRESH ADD constraint PK_UEBTotalBackupTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTotalBackupTest_THRESH ON UEBTotalBackupTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTotalBackupTest ON UEBTotalBackupTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTotalBackupTest ON UEBTotalBackupTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTotalArchivTest CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalArchivTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_ARCHIV Number(20,4) NOT NULL,
TOTAL_ARCHIV_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBTotalArchivTest ON UEBTotalArchivTest(MSMT_TIME);
ALTER TABLE UEBTotalArchivTest ADD constraint PK_UEBTotalArchivTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTotalArchivTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalArchivTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_ARCHIV_MIN Number(20,4) NOT NULL,
TOTAL_ARCHIV_MAX Number(20,4) NOT NULL,
TOTAL_ARCHIV_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBTotalArchivTest_TREND ADD constraint PK_UEBTotalArchivTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTotalArchivTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBTotalArchivTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_ARCHIV_MIN VARCHAR2(256) NOT NULL,
TOTAL_ARCHIV_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBTotalArchivTest_THRESH ADD constraint PK_UEBTotalArchivTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTotalArchivTest_THRESH ON UEBTotalArchivTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTotalArchivTest ON UEBTotalArchivTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTotalArchivTest ON UEBTotalArchivTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBVoltStatusTest CASCADE CONSTRAINTS;
CREATE TABLE UEBVoltStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
HEALTH_STATUS Number(20,4) NOT NULL,
HEALTH_STATUS_ST varchar2(32) NOT NULL,
SENSOR_STATUS Number(20,4) NOT NULL,
SENSOR_STATUS_ST varchar2(32) NOT NULL,
CURRENT_VOLTAGE Number(20,4) NOT NULL,
CURRENT_VOLTAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_UEBVoltStatusTest ON UEBVoltStatusTest(MSMT_TIME);
ALTER TABLE UEBVoltStatusTest ADD constraint PK_UEBVoltStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBVoltStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE UEBVoltStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
HEALTH_STATUS_MIN Number(20,4) NOT NULL,
HEALTH_STATUS_MAX Number(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar2(32) NOT NULL,
SENSOR_STATUS_MIN Number(20,4) NOT NULL,
SENSOR_STATUS_MAX Number(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar2(32) NOT NULL,
CURRENT_VOLTAGE_MIN Number(20,4) NOT NULL,
CURRENT_VOLTAGE_MAX Number(20,4) NOT NULL,
CURRENT_VOLTAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE UEBVoltStatusTest_TREND ADD constraint PK_UEBVoltStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBVoltStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE UEBVoltStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
HEALTH_STATUS_MIN VARCHAR2(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR2(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR2(256) NOT NULL,
CURRENT_VOLTAGE_MIN VARCHAR2(256) NOT NULL,
CURRENT_VOLTAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE UEBVoltStatusTest_THRESH ADD constraint PK_UEBVoltStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBVoltStatusTest_THRESH ON UEBVoltStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBVoltStatusTest ON UEBVoltStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBVoltStatusTest ON UEBVoltStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPSOURCETEST CASCADE CONSTRAINTS;
CREATE TABLE TOPSOURCETEST( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
in_OCTETSRATE NUMBER(20,4) NOT NULL,
in_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
in_PACKETSRATE NUMBER(20,4) NOT NULL,
in_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_TOPSOURCETEST ON TOPSOURCETEST(MSMT_TIME);
ALTER TABLE TOPSOURCETEST ADD CONSTRAINT PK_TOPSOURCETEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSOURCETEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TOPSOURCETEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
in_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
in_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
in_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
in_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
in_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
in_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE TOPSOURCETEST_TREND ADD CONSTRAINT PK_TOPSOURCETEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSOURCETEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TOPSOURCETEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
in_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
in_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
in_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
in_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TOPSOURCETEST_THRESH ADD CONSTRAINT PK_TOPSOURCETEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSOURCETEST_THRESH ON TOPSOURCETEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSOURCETEST ON TOPSOURCETEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSOURCETEST ON TOPSOURCETEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPDESTTEST CASCADE CONSTRAINTS;
CREATE TABLE TOPDESTTEST( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
in_OCTETSRATE NUMBER(20,4) NOT NULL,
in_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
in_PACKETSRATE NUMBER(20,4) NOT NULL,
in_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_TOPDESTTEST ON TOPDESTTEST(MSMT_TIME);
ALTER TABLE TOPDESTTEST ADD CONSTRAINT PK_TOPDESTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPDESTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TOPDESTTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
in_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
in_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
in_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
in_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
in_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
in_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE TOPDESTTEST_TREND ADD CONSTRAINT PK_TOPDESTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPDESTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TOPDESTTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
in_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
in_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
in_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
in_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TOPDESTTEST_THRESH ADD CONSTRAINT PK_TOPDESTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPDESTTEST_THRESH ON TOPDESTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPDESTTEST ON TOPDESTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPDESTTEST ON TOPDESTTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPCONVERTEST CASCADE CONSTRAINTS;
CREATE TABLE TOPCONVERTEST( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
IN_OCTETSRATE NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
IN_PACKETSRATE NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL,
protocol NUMBER(20,4) NOT NULL,
protocol_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_TOPCONVERTEST ON TOPCONVERTEST(MSMT_TIME);
ALTER TABLE TOPCONVERTEST ADD CONSTRAINT PK_TOPCONVERTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPCONVERTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TOPCONVERTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
IN_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL,
protocol_MIN NUMBER(20,4) NOT NULL,
protocol_MAX NUMBER(20,4) NOT NULL,
protocol_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE TOPCONVERTEST_TREND ADD CONSTRAINT PK_TOPCONVERTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPCONVERTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TOPCONVERTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL,
protocol_MIN VARCHAR2(256) NOT NULL,
protocol_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TOPCONVERTEST_THRESH ADD CONSTRAINT PK_TOPCONVERTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPCONVERTEST_THRESH ON TOPCONVERTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPCONVERTEST ON TOPCONVERTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPCONVERTEST ON TOPCONVERTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPAPPLICATIONTEST CASCADE CONSTRAINTS;
CREATE TABLE TOPAPPLICATIONTEST( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
IN_OCTETSRATE NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
IN_PACKETSRATE NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST(MSMT_TIME);
ALTER TABLE TOPAPPLICATIONTEST ADD CONSTRAINT PK_TOPAPPLICATIONTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPAPPLICATIONTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TOPAPPLICATIONTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
IN_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_TREND ADD CONSTRAINT PK_TOPAPPLICATIONTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPAPPLICATIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TOPAPPLICATIONTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_THRESH ADD CONSTRAINT PK_TOPAPPLICATIONTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPAPPLICATIONTEST_THRESH ON TOPAPPLICATIONTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPSITESTEST CASCADE CONSTRAINTS;
CREATE TABLE TOPSITESTEST( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
IN_OCTETSRATE NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
IN_PACKETSRATE NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_TOPSITESTEST ON TOPSITESTEST(MSMT_TIME);
ALTER TABLE TOPSITESTEST ADD CONSTRAINT PK_TOPSITESTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSITESTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TOPSITESTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
IN_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE TOPSITESTEST_TREND ADD CONSTRAINT PK_TOPSITESTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSITESTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TOPSITESTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TOPSITESTEST_THRESH ADD CONSTRAINT PK_TOPSITESTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSITESTEST_THRESH ON TOPSITESTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSITESTEST ON TOPSITESTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSITESTEST ON TOPSITESTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE SpecificSrcTest CASCADE CONSTRAINTS;
CREATE TABLE SpecificSrcTest( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
IN_OCTETSRATE NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
IN_PACKETSRATE NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_SpecificSrcTest ON SpecificSrcTest(MSMT_TIME);
ALTER TABLE SpecificSrcTest ADD CONSTRAINT PK_SpecificSrcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificSrcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SpecificSrcTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
IN_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE SpecificSrcTest_TREND ADD CONSTRAINT PK_SpecificSrcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificSrcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SpecificSrcTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SpecificSrcTest_THRESH ADD CONSTRAINT PK_SpecificSrcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificSrcTest_THRESH ON SpecificSrcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificSrcTest ON SpecificSrcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificSrcTest ON SpecificSrcTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SpecificDestTest CASCADE CONSTRAINTS;
CREATE TABLE SpecificDestTest( 
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
IN_OCTETS NUMBER(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR2(32) NOT NULL,
OUT_OCTETS NUMBER(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR2(32) NOT NULL,
BYTES NUMBER(20,4) NOT NULL,
BYTES_ST VARCHAR2(32) NOT NULL,
IN_PACKETS NUMBER(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR2(32) NOT NULL,
OUT_PACKETS NUMBER(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR2(32) NOT NULL,
PACKETS NUMBER(20,4) NOT NULL,
PACKETS_ST VARCHAR2(32) NOT NULL,
IN_OCTETSRATE NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
IN_PACKETSRATE NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR2(32) NOT NULL,
BYTESPERSEC NUMBER(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR2(32) NOT NULL,
PACKETSPERSEC NUMBER(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR2(32) NOT NULL,
IN_TRAFFIC NUMBER(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR2(32) NOT NULL,
OUT_TRAFFIC NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR2(32) NOT NULL,
TRAFFICRATE NUMBER(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR2(32) NOT NULL,
IN_BW NUMBER(20,4) NOT NULL,
IN_BW_ST VARCHAR2(32) NOT NULL,
OUT_BW NUMBER(20,4) NOT NULL,
OUT_BW_ST VARCHAR2(32) NOT NULL,
BWUTILIZED NUMBER(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_SpecificDestTest ON SpecificDestTest(MSMT_TIME);
ALTER TABLE SpecificDestTest ADD CONSTRAINT PK_SpecificDestTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificDestTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SpecificDestTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
IN_OCTETS_MIN NUMBER(20,4) NOT NULL,
IN_OCTETS_MAX NUMBER(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETS_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETS_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR2(32) NOT NULL,
BYTES_MIN NUMBER(20,4) NOT NULL,
BYTES_MAX NUMBER(20,4) NOT NULL,
BYTES_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETS_MIN NUMBER(20,4) NOT NULL,
IN_PACKETS_MAX NUMBER(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETS_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETS_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR2(32) NOT NULL,
PACKETS_MIN NUMBER(20,4) NOT NULL,
PACKETS_MAX NUMBER(20,4) NOT NULL,
PACKETS_STCNT VARCHAR2(32) NOT NULL,
IN_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
IN_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_OCTETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR2(32) NOT NULL,
OUT_PACKETSRATE_MIN NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_MAX NUMBER(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR2(32) NOT NULL,
BYTESPERSEC_MIN NUMBER(20,4) NOT NULL,
BYTESPERSEC_MAX NUMBER(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR2(32) NOT NULL,
PACKETSPERSEC_MIN NUMBER(20,4) NOT NULL,
PACKETSPERSEC_MAX NUMBER(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR2(32) NOT NULL,
IN_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
IN_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
OUT_TRAFFIC_MIN NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_MAX NUMBER(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR2(32) NOT NULL,
TRAFFICRATE_MIN NUMBER(20,4) NOT NULL,
TRAFFICRATE_MAX NUMBER(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR2(32) NOT NULL,
IN_BW_MIN NUMBER(20,4) NOT NULL,
IN_BW_MAX NUMBER(20,4) NOT NULL,
IN_BW_STCNT VARCHAR2(32) NOT NULL,
OUT_BW_MIN NUMBER(20,4) NOT NULL,
OUT_BW_MAX NUMBER(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR2(32) NOT NULL,
BWUTILIZED_MIN NUMBER(20,4) NOT NULL,
BWUTILIZED_MAX NUMBER(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE SpecificDestTest_TREND ADD CONSTRAINT PK_SpecificDestTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificDestTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SpecificDestTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
IN_OCTETS_MIN VARCHAR2(256) NOT NULL,
IN_OCTETS_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR2(256) NOT NULL,
BYTES_MIN VARCHAR2(256) NOT NULL,
BYTES_MAX VARCHAR2(256) NOT NULL,
IN_PACKETS_MIN VARCHAR2(256) NOT NULL,
IN_PACKETS_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR2(256) NOT NULL,
PACKETS_MIN VARCHAR2(256) NOT NULL,
PACKETS_MAX VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR2(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR2(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR2(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR2(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR2(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR2(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR2(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR2(256) NOT NULL,
IN_BW_MIN VARCHAR2(256) NOT NULL,
IN_BW_MAX VARCHAR2(256) NOT NULL,
OUT_BW_MIN VARCHAR2(256) NOT NULL,
OUT_BW_MAX VARCHAR2(256) NOT NULL,
BWUTILIZED_MIN VARCHAR2(256) NOT NULL,
BWUTILIZED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SpecificDestTest_THRESH ADD CONSTRAINT PK_SpecificDestTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificDestTest_THRESH ON SpecificDestTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificDestTest ON SpecificDestTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificDestTest ON SpecificDestTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFHDXLOGINSTEST CASCADE CONSTRAINTS; 
CREATE TABLE AFHDXLOGINSTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     CURRENT_SESSIONS           NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_ST        VARCHAR2(32) NOT NULL, 
     NEW_SESSIONS               NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_ST            VARCHAR2(32) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS    NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_ST VARCHAR2(32) NOT NULL, 
     SESSION_LOGOUTS            NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_ST         VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXLOGINSTEST 
  ON AFHDXLOGINSTEST(MSMT_TIME); 

ALTER TABLE AFHDXLOGINSTEST 
  ADD CONSTRAINT PK_AFHDXLOGINSTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXLOGINSTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXLOGINSTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     CURRENT_SESSIONS_MIN          NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_MAX          NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_STCNT        VARCHAR2(32) NOT NULL, 
     NEW_SESSIONS_MIN              NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_MAX              NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_STCNT            VARCHAR2(32) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MIN   NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MAX   NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_STCNT VARCHAR2(32) NOT NULL, 
     SESSION_LOGOUTS_MIN           NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_MAX           NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_STCNT         VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXLOGINSTEST_TREND 
  ADD CONSTRAINT PK_AFHDXLOGINSTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXLOGINSTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXLOGINSTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     CURRENT_SESSIONS_MIN        VARCHAR2(256) NOT NULL, 
     CURRENT_SESSIONS_MAX        VARCHAR2(256) NOT NULL, 
     NEW_SESSIONS_MIN            VARCHAR2(256) NOT NULL, 
     NEW_SESSIONS_MAX            VARCHAR2(256) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MIN VARCHAR2(256) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MAX VARCHAR2(256) NOT NULL, 
     SESSION_LOGOUTS_MIN         VARCHAR2(256) NOT NULL, 
     SESSION_LOGOUTS_MAX         VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXLOGINSTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXLOGINSTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXLOGINSTEST_THRESH 
  ON AFHDXLOGINSTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXLOGINSTEST 
  ON AFHDXLOGINSTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXLOGINSTEST 
  ON AFHDXLOGINSTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXUSERSTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSERSTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     APPLICATION_LAUNCHES       NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_ST    VARCHAR2(32) NOT NULL, 
     APPLICATION_TERMINATES     NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_ST  VARCHAR2(32) NOT NULL, 
     ACTIVE_APPLICATIONS        NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_ST     VARCHAR2(32) NOT NULL, 
     ACTIVE_DESKTOPS            NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_ST         VARCHAR2(32) NOT NULL, 
     AVGAPPSTARTUPDURATION      NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_ST   VARCHAR2(32) NOT NULL, 
     RTT                        NUMBER(20, 4) NOT NULL, 
     RTT_ST                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY                NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_ST             VARCHAR2(32) NOT NULL, 
     DC_LATENCY                 NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_ST              VARCHAR2(32) NOT NULL, 
     CLIENT_SRTT                NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_ST             VARCHAR2(32) NOT NULL, 
     SERVER_SRTT                NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_ST             VARCHAR2(32) NOT NULL, 
     CLIENT_JITTER              NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_ST           VARCHAR2(32) NOT NULL, 
     SERVER_JITTER              NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_ST           VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     ACR_COUNTS                 NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_ST              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS         NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_ST      VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_FAST_RTO       NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_ST    VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_FAST_RTO       NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_ST    VARCHAR2(32) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT     NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_ST  VARCHAR2(32) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT     NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_ST  VARCHAR2(32) NOT NULL, 
     NOOFDSKTPLNCHS             NUMBER(20, 4) NOT NULL, 
     NOOFDSKTPLNCHS_ST          VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL             NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_ST          VARCHAR2(32) NOT NULL, 
     BWPERINTRVL                NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_ST             VARCHAR2(32) NOT NULL, 
     HOSTDLY                    NUMBER(20, 4) NOT NULL, 
     HOSTDLY_ST                 VARCHAR2(32) NOT NULL, 
     SESSION_STATUS             NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_ST          VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXUSERSTEST 
  ON AFHDXUSERSTEST(MSMT_TIME); 

ALTER TABLE AFHDXUSERSTEST 
  ADD CONSTRAINT PK_AFHDXUSERSTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXUSERSTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSERSTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     APPLICATION_LAUNCHES_MIN      NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_MAX      NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_STCNT    VARCHAR2(32) NOT NULL, 
     APPLICATION_TERMINATES_MIN    NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_MAX    NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_STCNT  VARCHAR2(32) NOT NULL, 
     ACTIVE_APPLICATIONS_MIN       NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_MAX       NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_STCNT     VARCHAR2(32) NOT NULL, 
     ACTIVE_DESKTOPS_MIN           NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_MAX           NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_STCNT         VARCHAR2(32) NOT NULL, 
     AVGAPPSTARTUPDURATION_MIN     NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_MAX     NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_STCNT   VARCHAR2(32) NOT NULL, 
     RTT_MIN                       NUMBER(20, 4) NOT NULL, 
     RTT_MAX                       NUMBER(20, 4) NOT NULL, 
     RTT_STCNT                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY_MIN               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_MAX               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_STCNT             VARCHAR2(32) NOT NULL, 
     DC_LATENCY_MIN                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_MAX                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_STCNT              VARCHAR2(32) NOT NULL, 
     CLIENT_SRTT_MIN               NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_MAX               NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_STCNT             VARCHAR2(32) NOT NULL, 
     SERVER_SRTT_MIN               NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_MAX               NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_STCNT             VARCHAR2(32) NOT NULL, 
     CLIENT_JITTER_MIN             NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_MAX             NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_STCNT           VARCHAR2(32) NOT NULL, 
     SERVER_JITTER_MIN             NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_MAX             NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_STCNT           VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     ACR_COUNTS_MIN                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_MAX                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_STCNT              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS_MIN        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_MAX        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_STCNT      VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MIN      NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MAX      NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_STCNT    VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MIN      NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MAX      NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_STCNT    VARCHAR2(32) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MIN    NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MAX    NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_STCNT  VARCHAR2(32) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MIN    NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MAX    NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_STCNT  VARCHAR2(32) NOT NULL, 
     NOOFDSKTPLNCHS_MIN            NUMBER(20, 4) NOT NULL, 
     NOOFDSKTPLNCHS_MAX            NUMBER(20, 4) NOT NULL, 
     NOOFDSKTPLNCHS_STCNT          VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL_MIN            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_MAX            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_STCNT          VARCHAR2(32) NOT NULL, 
     BWPERINTRVL_MIN               NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_MAX               NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_STCNT             VARCHAR2(32) NOT NULL, 
     HOSTDLY_MIN                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_MAX                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_STCNT                 VARCHAR2(32) NOT NULL, 
     SESSION_STATUS_MIN            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_MAX            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_STCNT          VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXUSERSTEST_TREND 
  ADD CONSTRAINT PK_AFHDXUSERSTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXUSERSTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSERSTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     APPLICATION_LAUNCHES_MIN    VARCHAR2(256) NOT NULL, 
     APPLICATION_LAUNCHES_MAX    VARCHAR2(256) NOT NULL, 
     APPLICATION_TERMINATES_MIN  VARCHAR2(256) NOT NULL, 
     APPLICATION_TERMINATES_MAX  VARCHAR2(256) NOT NULL, 
     ACTIVE_APPLICATIONS_MIN     VARCHAR2(256) NOT NULL, 
     ACTIVE_APPLICATIONS_MAX     VARCHAR2(256) NOT NULL, 
     ACTIVE_DESKTOPS_MIN         VARCHAR2(256) NOT NULL, 
     ACTIVE_DESKTOPS_MAX         VARCHAR2(256) NOT NULL, 
     AVGAPPSTARTUPDURATION_MIN   VARCHAR2(256) NOT NULL, 
     AVGAPPSTARTUPDURATION_MAX   VARCHAR2(256) NOT NULL, 
     RTT_MIN                     VARCHAR2(256) NOT NULL, 
     RTT_MAX                     VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MIN             VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MAX             VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MIN              VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MAX              VARCHAR2(256) NOT NULL, 
     CLIENT_SRTT_MIN             VARCHAR2(256) NOT NULL, 
     CLIENT_SRTT_MAX             VARCHAR2(256) NOT NULL, 
     SERVER_SRTT_MIN             VARCHAR2(256) NOT NULL, 
     SERVER_SRTT_MAX             VARCHAR2(256) NOT NULL, 
     CLIENT_JITTER_MIN           VARCHAR2(256) NOT NULL, 
     CLIENT_JITTER_MAX           VARCHAR2(256) NOT NULL, 
     SERVER_JITTER_MIN           VARCHAR2(256) NOT NULL, 
     SERVER_JITTER_MAX           VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MIN              VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MAX              VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MIN      VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MAX      VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MIN    VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MAX    VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MIN    VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MAX    VARCHAR2(256) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MIN  VARCHAR2(256) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MAX  VARCHAR2(256) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MIN  VARCHAR2(256) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MAX  VARCHAR2(256) NOT NULL, 
     NOOFDSKTPLNCHS_MIN          VARCHAR2(256) NOT NULL, 
     NOOFDSKTPLNCHS_MAX          VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MIN          VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MAX          VARCHAR2(256) NOT NULL, 
     BWPERINTRVL_MIN             VARCHAR2(256) NOT NULL, 
     BWPERINTRVL_MAX             VARCHAR2(256) NOT NULL, 
     HOSTDLY_MIN                 VARCHAR2(256) NOT NULL, 
     HOSTDLY_MAX                 VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MIN          VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MAX          VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXUSERSTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXUSERSTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXUSERSTEST_THRESH 
  ON AFHDXUSERSTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXUSERSTEST 
  ON AFHDXUSERSTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXUSERSTEST 
  ON AFHDXUSERSTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXACTUSERSTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTUSERSTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     APPLICATION_LAUNCHES       NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_ST    VARCHAR2(32) NOT NULL, 
     APPLICATION_TERMINATES     NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_ST  VARCHAR2(32) NOT NULL, 
     ACTIVE_APPLICATIONS        NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_ST     VARCHAR2(32) NOT NULL, 
     AVGAPPSTARTUPDURATION      NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_ST   VARCHAR2(32) NOT NULL, 
     RTT                        NUMBER(20, 4) NOT NULL, 
     RTT_ST                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY                NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_ST             VARCHAR2(32) NOT NULL, 
     DC_LATENCY                 NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_ST              VARCHAR2(32) NOT NULL, 
     CLIENT_SRTT                NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_ST             VARCHAR2(32) NOT NULL, 
     SERVER_SRTT                NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_ST             VARCHAR2(32) NOT NULL, 
     CLIENT_JITTER              NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_ST           VARCHAR2(32) NOT NULL, 
     SERVER_JITTER              NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_ST           VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     ACR_COUNTS                 NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_ST              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS         NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_ST      VARCHAR2(32) NOT NULL, 
     SESSION_STATUS             NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_ST          VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_FAST_RTO       NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_ST    VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_FAST_RTO       NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_ST    VARCHAR2(32) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT     NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_ST  VARCHAR2(32) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT     NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_ST  VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL             NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_ST          VARCHAR2(32) NOT NULL, 
     BWPERINTRVL                NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_ST             VARCHAR2(32) NOT NULL, 
     HOSTDLY                    NUMBER(20, 4) NOT NULL, 
     HOSTDLY_ST                 VARCHAR2(32) NOT NULL, 
     CLIENTDELAY                NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_ST             VARCHAR2(32) NOT NULL, 
     SERVERDELAY                NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_ST             VARCHAR2(32) NOT NULL, 
     L7CLIENTLATENCY            NUMBER(20, 4) NOT NULL, 
     L7CLIENTLATENCY_ST         VARCHAR2(32) NOT NULL, 
     L7SERVERLATENCY            NUMBER(20, 4) NOT NULL, 
     L7SERVERLATENCY_ST         VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXACTUSERSTEST 
  ON AFHDXACTUSERSTEST(MSMT_TIME); 

ALTER TABLE AFHDXACTUSERSTEST 
  ADD CONSTRAINT PK_AFHDXACTUSERSTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXACTUSERSTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTUSERSTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     APPLICATION_LAUNCHES_MIN      NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_MAX      NUMBER(20, 4) NOT NULL, 
     APPLICATION_LAUNCHES_STCNT    VARCHAR2(32) NOT NULL, 
     APPLICATION_TERMINATES_MIN    NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_MAX    NUMBER(20, 4) NOT NULL, 
     APPLICATION_TERMINATES_STCNT  VARCHAR2(32) NOT NULL, 
     ACTIVE_APPLICATIONS_MIN       NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_MAX       NUMBER(20, 4) NOT NULL, 
     ACTIVE_APPLICATIONS_STCNT     VARCHAR2(32) NOT NULL, 
     AVGAPPSTARTUPDURATION_MIN     NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_MAX     NUMBER(20, 4) NOT NULL, 
     AVGAPPSTARTUPDURATION_STCNT   VARCHAR2(32) NOT NULL, 
     RTT_MIN                       NUMBER(20, 4) NOT NULL, 
     RTT_MAX                       NUMBER(20, 4) NOT NULL, 
     RTT_STCNT                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY_MIN               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_MAX               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_STCNT             VARCHAR2(32) NOT NULL, 
     DC_LATENCY_MIN                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_MAX                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_STCNT              VARCHAR2(32) NOT NULL, 
     CLIENT_SRTT_MIN               NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_MAX               NUMBER(20, 4) NOT NULL, 
     CLIENT_SRTT_STCNT             VARCHAR2(32) NOT NULL, 
     SERVER_SRTT_MIN               NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_MAX               NUMBER(20, 4) NOT NULL, 
     SERVER_SRTT_STCNT             VARCHAR2(32) NOT NULL, 
     CLIENT_JITTER_MIN             NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_MAX             NUMBER(20, 4) NOT NULL, 
     CLIENT_JITTER_STCNT           VARCHAR2(32) NOT NULL, 
     SERVER_JITTER_MIN             NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_MAX             NUMBER(20, 4) NOT NULL, 
     SERVER_JITTER_STCNT           VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     ACR_COUNTS_MIN                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_MAX                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_STCNT              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS_MIN        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_MAX        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_STCNT      VARCHAR2(32) NOT NULL, 
     SESSION_STATUS_MIN            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_MAX            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_STCNT          VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MIN      NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MAX      NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_FAST_RTO_STCNT    VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MIN      NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MAX      NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_STCNT    VARCHAR2(32) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MIN    NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MAX    NUMBER(20, 4) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_STCNT  VARCHAR2(32) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MIN    NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MAX    NUMBER(20, 4) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_STCNT  VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL_MIN            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_MAX            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_STCNT          VARCHAR2(32) NOT NULL, 
     BWPERINTRVL_MIN               NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_MAX               NUMBER(20, 4) NOT NULL, 
     BWPERINTRVL_STCNT             VARCHAR2(32) NOT NULL, 
     HOSTDLY_MIN                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_MAX                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_STCNT                 VARCHAR2(32) NOT NULL, 
     CLIENTDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_STCNT             VARCHAR2(32) NOT NULL, 
     SERVERDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_STCNT             VARCHAR2(32) NOT NULL, 
     L7CLIENTLATENCY_MIN           NUMBER(20, 4) NOT NULL, 
     L7CLIENTLATENCY_MAX           NUMBER(20, 4) NOT NULL, 
     L7CLIENTLATENCY_STCNT         VARCHAR2(32) NOT NULL, 
     L7SERVERLATENCY_MIN           NUMBER(20, 4) NOT NULL, 
     L7SERVERLATENCY_MAX           NUMBER(20, 4) NOT NULL, 
     L7SERVERLATENCY_STCNT         VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXACTUSERSTEST_TREND 
  ADD CONSTRAINT PK_AFHDXACTUSERSTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXACTUSERSTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTUSERSTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     APPLICATION_LAUNCHES_MIN    VARCHAR2(256) NOT NULL, 
     APPLICATION_LAUNCHES_MAX    VARCHAR2(256) NOT NULL, 
     APPLICATION_TERMINATES_MIN  VARCHAR2(256) NOT NULL, 
     APPLICATION_TERMINATES_MAX  VARCHAR2(256) NOT NULL, 
     ACTIVE_APPLICATIONS_MIN     VARCHAR2(256) NOT NULL, 
     ACTIVE_APPLICATIONS_MAX     VARCHAR2(256) NOT NULL, 
     AVGAPPSTARTUPDURATION_MIN   VARCHAR2(256) NOT NULL, 
     AVGAPPSTARTUPDURATION_MAX   VARCHAR2(256) NOT NULL, 
     RTT_MIN                     VARCHAR2(256) NOT NULL, 
     RTT_MAX                     VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MIN             VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MAX             VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MIN              VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MAX              VARCHAR2(256) NOT NULL, 
     CLIENT_SRTT_MIN             VARCHAR2(256) NOT NULL, 
     CLIENT_SRTT_MAX             VARCHAR2(256) NOT NULL, 
     SERVER_SRTT_MIN             VARCHAR2(256) NOT NULL, 
     SERVER_SRTT_MAX             VARCHAR2(256) NOT NULL, 
     CLIENT_JITTER_MIN           VARCHAR2(256) NOT NULL, 
     CLIENT_JITTER_MAX           VARCHAR2(256) NOT NULL, 
     SERVER_JITTER_MIN           VARCHAR2(256) NOT NULL, 
     SERVER_JITTER_MAX           VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MIN              VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MAX              VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MIN      VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MAX      VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MIN          VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MAX          VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MIN    VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_FAST_RTO_MAX    VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MIN    VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_FAST_RTO_MAX    VARCHAR2(256) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MIN  VARCHAR2(256) NOT NULL, 
     CLIENTSIDEZEROWNDOEVNT_MAX  VARCHAR2(256) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MIN  VARCHAR2(256) NOT NULL, 
     SERVERSIDEZEROWNDOEVNT_MAX  VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MIN          VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MAX          VARCHAR2(256) NOT NULL, 
     BWPERINTRVL_MIN             VARCHAR2(256) NOT NULL, 
     BWPERINTRVL_MAX             VARCHAR2(256) NOT NULL, 
     HOSTDLY_MIN                 VARCHAR2(256) NOT NULL, 
     HOSTDLY_MAX                 VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MIN             VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MAX             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MIN             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MAX             VARCHAR2(256) NOT NULL, 
     L7CLIENTLATENCY_MIN         VARCHAR2(256) NOT NULL, 
     L7CLIENTLATENCY_MAX         VARCHAR2(256) NOT NULL, 
     L7SERVERLATENCY_MIN         VARCHAR2(256) NOT NULL, 
     L7SERVERLATENCY_MAX         VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXACTUSERSTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXACTUSERSTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXACTUSERSTEST_THRESH 
  ON AFHDXACTUSERSTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXACTUSERSTEST 
  ON AFHDXACTUSERSTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXACTUSERSTEST 
  ON AFHDXACTUSERSTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXCHANNELTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXCHANNELTEST 
  ( 
     TRGT_HOST            VARCHAR2(32) NOT NULL, 
     PORT_NO              VARCHAR2(32) NOT NULL, 
     SITE_NAME            VARCHAR2(64) NOT NULL, 
     INFO                 VARCHAR2(128) NOT NULL, 
     MSMT_HOST            VARCHAR2(32) NOT NULL, 
     MSMT_TIME            DATE NOT NULL, 
     TOTAL_BYTES          NUMBER(20, 4) NOT NULL, 
     TOTAL_BYTES_ST       VARCHAR2(32) NOT NULL, 
     AVERAGE_BANDWIDTH    NUMBER(20, 4) NOT NULL, 
     AVERAGE_BANDWIDTH_ST VARCHAR2(32) NOT NULL, 
     TRAFFIC              NUMBER(20, 4) NOT NULL, 
     TRAFFIC_ST           VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXCHANNELTEST 
  ON AFHDXCHANNELTEST(MSMT_TIME); 

ALTER TABLE AFHDXCHANNELTEST 
  ADD CONSTRAINT PK_AFHDXCHANNELTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXCHANNELTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXCHANNELTEST_TREND 
  ( 
     TRGT_HOST               VARCHAR2(32) NOT NULL, 
     PORT_NO                 VARCHAR2(32) NOT NULL, 
     SITE_NAME               VARCHAR2(64) NOT NULL, 
     INFO                    VARCHAR2(128) NOT NULL, 
     MSMT_HOST               VARCHAR2(32) NOT NULL, 
     MSMT_TIME               DATE NOT NULL, 
     PERIOD                  VARCHAR2(32) NOT NULL, 
     TOTAL_BYTES_MIN         NUMBER(20, 4) NOT NULL, 
     TOTAL_BYTES_MAX         NUMBER(20, 4) NOT NULL, 
     TOTAL_BYTES_STCNT       VARCHAR2(32) NOT NULL, 
     AVERAGE_BANDWIDTH_MIN   NUMBER(20, 4) NOT NULL, 
     AVERAGE_BANDWIDTH_MAX   NUMBER(20, 4) NOT NULL, 
     AVERAGE_BANDWIDTH_STCNT VARCHAR2(32) NOT NULL, 
     TRAFFIC_MIN             NUMBER(20, 4) NOT NULL, 
     TRAFFIC_MAX             NUMBER(20, 4) NOT NULL, 
     TRAFFIC_STCNT           VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXCHANNELTEST_TREND 
  ADD CONSTRAINT PK_AFHDXCHANNELTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXCHANNELTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXCHANNELTEST_THRESH 
  ( 
     TRGT_HOST             VARCHAR2(32) NOT NULL, 
     PORT_NO               VARCHAR2(32) NOT NULL, 
     SITE_NAME             VARCHAR2(64) NOT NULL, 
     INFO                  VARCHAR2(128) NOT NULL, 
     MSMT_HOST             VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START       DATE NOT NULL, 
     MSMT_TIME_END         DATE NOT NULL, 
     TOTAL_BYTES_MIN       VARCHAR2(256) NOT NULL, 
     TOTAL_BYTES_MAX       VARCHAR2(256) NOT NULL, 
     AVERAGE_BANDWIDTH_MIN VARCHAR2(256) NOT NULL, 
     AVERAGE_BANDWIDTH_MAX VARCHAR2(256) NOT NULL, 
     TRAFFIC_MIN           VARCHAR2(256) NOT NULL, 
     TRAFFIC_MAX           VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXCHANNELTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXCHANNELTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXCHANNELTEST_THRESH 
  ON AFHDXCHANNELTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXCHANNELTEST 
  ON AFHDXCHANNELTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXCHANNELTEST 
  ON AFHDXCHANNELTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXUSRAGNTTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSRAGNTTEST 
  ( 
     TRGT_HOST    VARCHAR2(32) NOT NULL, 
     PORT_NO      VARCHAR2(32) NOT NULL, 
     SITE_NAME    VARCHAR2(64) NOT NULL, 
     INFO         VARCHAR2(128) NOT NULL, 
     MSMT_HOST    VARCHAR2(32) NOT NULL, 
     MSMT_TIME    DATE NOT NULL, 
     TOT_BYTES    NUMBER(20, 4) NOT NULL, 
     TOT_BYTES_ST VARCHAR2(32) NOT NULL, 
     BW           NUMBER(20, 4) NOT NULL, 
     BW_ST        VARCHAR2(32) NOT NULL, 
     TRAFFIC      NUMBER(20, 4) NOT NULL, 
     TRAFFIC_ST   VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXUSRAGNTTEST 
  ON AFHDXUSRAGNTTEST(MSMT_TIME); 

ALTER TABLE AFHDXUSRAGNTTEST 
  ADD CONSTRAINT PK_AFHDXUSRAGNTTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXUSRAGNTTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSRAGNTTEST_TREND 
  ( 
     TRGT_HOST       VARCHAR2(32) NOT NULL, 
     PORT_NO         VARCHAR2(32) NOT NULL, 
     SITE_NAME       VARCHAR2(64) NOT NULL, 
     INFO            VARCHAR2(128) NOT NULL, 
     MSMT_HOST       VARCHAR2(32) NOT NULL, 
     MSMT_TIME       DATE NOT NULL, 
     PERIOD          VARCHAR2(32) NOT NULL, 
     TOT_BYTES_MIN   NUMBER(20, 4) NOT NULL, 
     TOT_BYTES_MAX   NUMBER(20, 4) NOT NULL, 
     TOT_BYTES_STCNT VARCHAR2(32) NOT NULL, 
     BW_MIN          NUMBER(20, 4) NOT NULL, 
     BW_MAX          NUMBER(20, 4) NOT NULL, 
     BW_STCNT        VARCHAR2(32) NOT NULL, 
     TRAFFIC_MIN     NUMBER(20, 4) NOT NULL, 
     TRAFFIC_MAX     NUMBER(20, 4) NOT NULL, 
     TRAFFIC_STCNT   VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXUSRAGNTTEST_TREND 
  ADD CONSTRAINT PK_AFHDXUSRAGNTTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXUSRAGNTTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXUSRAGNTTEST_THRESH 
  ( 
     TRGT_HOST       VARCHAR2(32) NOT NULL, 
     PORT_NO         VARCHAR2(32) NOT NULL, 
     SITE_NAME       VARCHAR2(64) NOT NULL, 
     INFO            VARCHAR2(128) NOT NULL, 
     MSMT_HOST       VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START DATE NOT NULL, 
     MSMT_TIME_END   DATE NOT NULL, 
     TOT_BYTES_MIN   VARCHAR2(256) NOT NULL, 
     TOT_BYTES_MAX   VARCHAR2(256) NOT NULL, 
     BW_MIN          VARCHAR2(256) NOT NULL, 
     BW_MAX          VARCHAR2(256) NOT NULL, 
     TRAFFIC_MIN     VARCHAR2(256) NOT NULL, 
     TRAFFIC_MAX     VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXUSRAGNTTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXUSRAGNTTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXUSRAGNTTEST_THRESH 
  ON AFHDXUSRAGNTTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXUSRAGNTTEST 
  ON AFHDXUSRAGNTTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXUSRAGNTTEST 
  ON AFHDXUSRAGNTTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXAPPSTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXAPPSTEST 
  ( 
     TRGT_HOST          VARCHAR2(32) NOT NULL, 
     PORT_NO            VARCHAR2(32) NOT NULL, 
     SITE_NAME          VARCHAR2(64) NOT NULL, 
     INFO               VARCHAR2(128) NOT NULL, 
     MSMT_HOST          VARCHAR2(32) NOT NULL, 
     MSMT_TIME          DATE NOT NULL, 
     ACTIVEAPPS         NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_ST      VARCHAR2(32) NOT NULL, 
     ACTIVE_SESSIONS    NUMBER(20, 4) NOT NULL, 
     ACTIVE_SESSIONS_ST VARCHAR2(32) NOT NULL, 
     CURRENTLAUNCHES    NUMBER(20, 4) NOT NULL, 
     CURRENTLAUNCHES_ST VARCHAR2(32) NOT NULL, 
     AVGLNCHDURATION    NUMBER(20, 4) NOT NULL, 
     AVGLNCHDURATION_ST VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXAPPSTEST 
  ON AFHDXAPPSTEST(MSMT_TIME); 

ALTER TABLE AFHDXAPPSTEST 
  ADD CONSTRAINT PK_AFHDXAPPSTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXAPPSTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXAPPSTEST_TREND 
  ( 
     TRGT_HOST             VARCHAR2(32) NOT NULL, 
     PORT_NO               VARCHAR2(32) NOT NULL, 
     SITE_NAME             VARCHAR2(64) NOT NULL, 
     INFO                  VARCHAR2(128) NOT NULL, 
     MSMT_HOST             VARCHAR2(32) NOT NULL, 
     MSMT_TIME             DATE NOT NULL, 
     PERIOD                VARCHAR2(32) NOT NULL, 
     ACTIVEAPPS_MIN        NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_MAX        NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_STCNT      VARCHAR2(32) NOT NULL, 
     ACTIVE_SESSIONS_MIN   NUMBER(20, 4) NOT NULL, 
     ACTIVE_SESSIONS_MAX   NUMBER(20, 4) NOT NULL, 
     ACTIVE_SESSIONS_STCNT VARCHAR2(32) NOT NULL, 
     CURRENTLAUNCHES_MIN   NUMBER(20, 4) NOT NULL, 
     CURRENTLAUNCHES_MAX   NUMBER(20, 4) NOT NULL, 
     CURRENTLAUNCHES_STCNT VARCHAR2(32) NOT NULL, 
     AVGLNCHDURATION_MIN   NUMBER(20, 4) NOT NULL, 
     AVGLNCHDURATION_MAX   NUMBER(20, 4) NOT NULL, 
     AVGLNCHDURATION_STCNT VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXAPPSTEST_TREND 
  ADD CONSTRAINT PK_AFHDXAPPSTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXAPPSTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXAPPSTEST_THRESH 
  ( 
     TRGT_HOST           VARCHAR2(32) NOT NULL, 
     PORT_NO             VARCHAR2(32) NOT NULL, 
     SITE_NAME           VARCHAR2(64) NOT NULL, 
     INFO                VARCHAR2(128) NOT NULL, 
     MSMT_HOST           VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START     DATE NOT NULL, 
     MSMT_TIME_END       DATE NOT NULL, 
     ACTIVEAPPS_MIN      VARCHAR2(256) NOT NULL, 
     ACTIVEAPPS_MAX      VARCHAR2(256) NOT NULL, 
     ACTIVE_SESSIONS_MIN VARCHAR2(256) NOT NULL, 
     ACTIVE_SESSIONS_MAX VARCHAR2(256) NOT NULL, 
     CURRENTLAUNCHES_MIN VARCHAR2(256) NOT NULL, 
     CURRENTLAUNCHES_MAX VARCHAR2(256) NOT NULL, 
     AVGLNCHDURATION_MIN VARCHAR2(256) NOT NULL, 
     AVGLNCHDURATION_MAX VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXAPPSTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXAPPSTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXAPPSTEST_THRESH 
  ON AFHDXAPPSTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXAPPSTEST 
  ON AFHDXAPPSTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXAPPSTEST 
  ON AFHDXAPPSTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXDSKTPLOGINTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPLOGINTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     CURRENT_SESSIONS           NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_ST        VARCHAR2(32) NOT NULL, 
     NEW_SESSIONS               NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_ST            VARCHAR2(32) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS    NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_ST VARCHAR2(32) NOT NULL, 
     SESSION_LOGOUTS            NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_ST         VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXDSKTPLOGINTEST 
  ON AFHDXDSKTPLOGINTEST(MSMT_TIME); 

ALTER TABLE AFHDXDSKTPLOGINTEST 
  ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXDSKTPLOGINTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPLOGINTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     CURRENT_SESSIONS_MIN          NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_MAX          NUMBER(20, 4) NOT NULL, 
     CURRENT_SESSIONS_STCNT        VARCHAR2(32) NOT NULL, 
     NEW_SESSIONS_MIN              NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_MAX              NUMBER(20, 4) NOT NULL, 
     NEW_SESSIONS_STCNT            VARCHAR2(32) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MIN   NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MAX   NUMBER(20, 4) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_STCNT VARCHAR2(32) NOT NULL, 
     SESSION_LOGOUTS_MIN           NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_MAX           NUMBER(20, 4) NOT NULL, 
     SESSION_LOGOUTS_STCNT         VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXDSKTPLOGINTEST_TREND 
  ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXDSKTPLOGINTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPLOGINTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     CURRENT_SESSIONS_MIN        VARCHAR2(256) NOT NULL, 
     CURRENT_SESSIONS_MAX        VARCHAR2(256) NOT NULL, 
     NEW_SESSIONS_MIN            VARCHAR2(256) NOT NULL, 
     NEW_SESSIONS_MAX            VARCHAR2(256) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MIN VARCHAR2(256) NOT NULL, 
     PERCENT_OF_NEW_SESSIONS_MAX VARCHAR2(256) NOT NULL, 
     SESSION_LOGOUTS_MIN         VARCHAR2(256) NOT NULL, 
     SESSION_LOGOUTS_MAX         VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXDSKTPLOGINTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXDSKTPLOGINTEST_THRESH 
  ON AFHDXDSKTPLOGINTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXDSKTPLOGINTEST 
  ON AFHDXDSKTPLOGINTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXDSKTPLOGINTEST 
  ON AFHDXDSKTPLOGINTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXDSKTPUSERSTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPUSERSTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     BYTESPERINTRVL             NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_ST          VARCHAR2(32) NOT NULL, 
     BANDWIDTHPERINTRVL         NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_ST      VARCHAR2(32) NOT NULL, 
     RTT                        NUMBER(20, 4) NOT NULL, 
     RTT_ST                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY                NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_ST             VARCHAR2(32) NOT NULL, 
     DC_LATENCY                 NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_ST              VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     ACR_COUNTS                 NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_ST              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS         NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_ST      VARCHAR2(32) NOT NULL, 
     HOSTDLY                    NUMBER(20, 4) NOT NULL, 
     HOSTDLY_ST                 VARCHAR2(32) NOT NULL, 
     CLIENTDELAY                NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_ST             VARCHAR2(32) NOT NULL, 
     SERVERDELAY                NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_ST             VARCHAR2(32) NOT NULL, 
     DSKTP_LNCHS                NUMBER(20, 4) NOT NULL, 
     DSKTP_LNCHS_ST             VARCHAR2(32) NOT NULL, 
     SESSION_STATUS             NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_ST          VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXDSKTPUSERSTEST 
  ON AFHDXDSKTPUSERSTEST(MSMT_TIME); 

ALTER TABLE AFHDXDSKTPUSERSTEST 
  ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXDSKTPUSERSTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPUSERSTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL_MIN            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_MAX            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_STCNT          VARCHAR2(32) NOT NULL, 
     BANDWIDTHPERINTRVL_MIN        NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_MAX        NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_STCNT      VARCHAR2(32) NOT NULL, 
     RTT_MIN                       NUMBER(20, 4) NOT NULL, 
     RTT_MAX                       NUMBER(20, 4) NOT NULL, 
     RTT_STCNT                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY_MIN               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_MAX               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_STCNT             VARCHAR2(32) NOT NULL, 
     DC_LATENCY_MIN                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_MAX                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_STCNT              VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     ACR_COUNTS_MIN                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_MAX                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_STCNT              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS_MIN        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_MAX        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_STCNT      VARCHAR2(32) NOT NULL, 
     HOSTDLY_MIN                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_MAX                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_STCNT                 VARCHAR2(32) NOT NULL, 
     CLIENTDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_STCNT             VARCHAR2(32) NOT NULL, 
     SERVERDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_STCNT             VARCHAR2(32) NOT NULL, 
     DSKTP_LNCHS_MIN               NUMBER(20, 4) NOT NULL, 
     DSKTP_LNCHS_MAX               NUMBER(20, 4) NOT NULL, 
     DSKTP_LNCHS_STCNT             VARCHAR2(32) NOT NULL, 
     SESSION_STATUS_MIN            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_MAX            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_STCNT          VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXDSKTPUSERSTEST_TREND 
  ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXDSKTPUSERSTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXDSKTPUSERSTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     BYTESPERINTRVL_MIN          VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MAX          VARCHAR2(256) NOT NULL, 
     BANDWIDTHPERINTRVL_MIN      VARCHAR2(256) NOT NULL, 
     BANDWIDTHPERINTRVL_MAX      VARCHAR2(256) NOT NULL, 
     RTT_MIN                     VARCHAR2(256) NOT NULL, 
     RTT_MAX                     VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MIN             VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MAX             VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MIN              VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MAX              VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MIN              VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MAX              VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MIN      VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MAX      VARCHAR2(256) NOT NULL, 
     HOSTDLY_MIN                 VARCHAR2(256) NOT NULL, 
     HOSTDLY_MAX                 VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MIN             VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MAX             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MIN             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MAX             VARCHAR2(256) NOT NULL, 
     DSKTP_LNCHS_MIN             VARCHAR2(256) NOT NULL, 
     DSKTP_LNCHS_MAX             VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MIN          VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MAX          VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXDSKTPUSERSTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXDSKTPUSERSTEST_THRESH 
  ON AFHDXDSKTPUSERSTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXDSKTPUSERSTEST 
  ON AFHDXDSKTPUSERSTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXDSKTPUSERSTEST 
  ON AFHDXDSKTPUSERSTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXACTDSKTPTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTDSKTPTEST 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     BYTESPERINTRVL             NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_ST          VARCHAR2(32) NOT NULL, 
     BANDWIDTHPERINTRVL         NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_ST      VARCHAR2(32) NOT NULL, 
     RTT                        NUMBER(20, 4) NOT NULL, 
     RTT_ST                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY                NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_ST             VARCHAR2(32) NOT NULL, 
     DC_LATENCY                 NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_ST              VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS    NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_ST VARCHAR2(32) NOT NULL, 
     ACR_COUNTS                 NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_ST              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS         NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_ST      VARCHAR2(32) NOT NULL, 
     ICA_CLIENT_TYPE            NUMBER(20, 4) NOT NULL, 
     ICA_CLIENT_TYPE_ST         VARCHAR2(32) NOT NULL, 
     HOSTDLY                    NUMBER(20, 4) NOT NULL, 
     HOSTDLY_ST                 VARCHAR2(32) NOT NULL, 
     SESSION_STATUS             NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_ST          VARCHAR2(32) NOT NULL, 
     CLIENTDELAY                NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_ST             VARCHAR2(32) NOT NULL, 
     SERVERDELAY                NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_ST             VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXACTDSKTPTEST 
  ON AFHDXACTDSKTPTEST(MSMT_TIME); 

ALTER TABLE AFHDXACTDSKTPTEST 
  ADD CONSTRAINT PK_AFHDXACTDSKTPTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXACTDSKTPTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTDSKTPTEST_TREND 
  ( 
     TRGT_HOST                     VARCHAR2(32) NOT NULL, 
     PORT_NO                       VARCHAR2(32) NOT NULL, 
     SITE_NAME                     VARCHAR2(64) NOT NULL, 
     INFO                          VARCHAR2(128) NOT NULL, 
     MSMT_HOST                     VARCHAR2(32) NOT NULL, 
     MSMT_TIME                     DATE NOT NULL, 
     PERIOD                        VARCHAR2(32) NOT NULL, 
     BYTESPERINTRVL_MIN            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_MAX            NUMBER(20, 4) NOT NULL, 
     BYTESPERINTRVL_STCNT          VARCHAR2(32) NOT NULL, 
     BANDWIDTHPERINTRVL_MIN        NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_MAX        NUMBER(20, 4) NOT NULL, 
     BANDWIDTHPERINTRVL_STCNT      VARCHAR2(32) NOT NULL, 
     RTT_MIN                       NUMBER(20, 4) NOT NULL, 
     RTT_MAX                       NUMBER(20, 4) NOT NULL, 
     RTT_STCNT                     VARCHAR2(32) NOT NULL, 
     WAN_LATENCY_MIN               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_MAX               NUMBER(20, 4) NOT NULL, 
     WAN_LATENCY_STCNT             VARCHAR2(32) NOT NULL, 
     DC_LATENCY_MIN                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_MAX                NUMBER(20, 4) NOT NULL, 
     DC_LATENCY_STCNT              VARCHAR2(32) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX   NUMBER(20, 4) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_STCNT VARCHAR2(32) NOT NULL, 
     ACR_COUNTS_MIN                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_MAX                NUMBER(20, 4) NOT NULL, 
     ACR_COUNTS_STCNT              VARCHAR2(32) NOT NULL, 
     SESSION_RECONNECTS_MIN        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_MAX        NUMBER(20, 4) NOT NULL, 
     SESSION_RECONNECTS_STCNT      VARCHAR2(32) NOT NULL, 
     ICA_CLIENT_TYPE_MIN           NUMBER(20, 4) NOT NULL, 
     ICA_CLIENT_TYPE_MAX           NUMBER(20, 4) NOT NULL, 
     ICA_CLIENT_TYPE_STCNT         VARCHAR2(32) NOT NULL, 
     HOSTDLY_MIN                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_MAX                   NUMBER(20, 4) NOT NULL, 
     HOSTDLY_STCNT                 VARCHAR2(32) NOT NULL, 
     SESSION_STATUS_MIN            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_MAX            NUMBER(20, 4) NOT NULL, 
     SESSION_STATUS_STCNT          VARCHAR2(32) NOT NULL, 
     CLIENTDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     CLIENTDELAY_STCNT             VARCHAR2(32) NOT NULL, 
     SERVERDELAY_MIN               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_MAX               NUMBER(20, 4) NOT NULL, 
     SERVERDELAY_STCNT             VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXACTDSKTPTEST_TREND 
  ADD CONSTRAINT PK_AFHDXACTDSKTPTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXACTDSKTPTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXACTDSKTPTEST_THRESH 
  ( 
     TRGT_HOST                   VARCHAR2(32) NOT NULL, 
     PORT_NO                     VARCHAR2(32) NOT NULL, 
     SITE_NAME                   VARCHAR2(64) NOT NULL, 
     INFO                        VARCHAR2(128) NOT NULL, 
     MSMT_HOST                   VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START             DATE NOT NULL, 
     MSMT_TIME_END               DATE NOT NULL, 
     BYTESPERINTRVL_MIN          VARCHAR2(256) NOT NULL, 
     BYTESPERINTRVL_MAX          VARCHAR2(256) NOT NULL, 
     BANDWIDTHPERINTRVL_MIN      VARCHAR2(256) NOT NULL, 
     BANDWIDTHPERINTRVL_MAX      VARCHAR2(256) NOT NULL, 
     RTT_MIN                     VARCHAR2(256) NOT NULL, 
     RTT_MAX                     VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MIN             VARCHAR2(256) NOT NULL, 
     WAN_LATENCY_MAX             VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MIN              VARCHAR2(256) NOT NULL, 
     DC_LATENCY_MAX              VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     CLIENT_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MIN VARCHAR2(256) NOT NULL, 
     SERVER_SIDE_RETRANSMITS_MAX VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MIN              VARCHAR2(256) NOT NULL, 
     ACR_COUNTS_MAX              VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MIN      VARCHAR2(256) NOT NULL, 
     SESSION_RECONNECTS_MAX      VARCHAR2(256) NOT NULL, 
     ICA_CLIENT_TYPE_MIN         VARCHAR2(256) NOT NULL, 
     ICA_CLIENT_TYPE_MAX         VARCHAR2(256) NOT NULL, 
     HOSTDLY_MIN                 VARCHAR2(256) NOT NULL, 
     HOSTDLY_MAX                 VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MIN          VARCHAR2(256) NOT NULL, 
     SESSION_STATUS_MAX          VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MIN             VARCHAR2(256) NOT NULL, 
     CLIENTDELAY_MAX             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MIN             VARCHAR2(256) NOT NULL, 
     SERVERDELAY_MAX             VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXACTDSKTPTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXACTDSKTPTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXACTDSKTPTEST_THRESH 
  ON AFHDXACTDSKTPTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXACTDSKTPTEST 
  ON AFHDXACTDSKTPTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXACTDSKTPTEST 
  ON AFHDXACTDSKTPTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXGATEWAYTEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXGATEWAYTEST 
  ( 
     TRGT_HOST               VARCHAR2(32) NOT NULL, 
     PORT_NO                 VARCHAR2(32) NOT NULL, 
     SITE_NAME               VARCHAR2(64) NOT NULL, 
     INFO                    VARCHAR2(128) NOT NULL, 
     MSMT_HOST               VARCHAR2(32) NOT NULL, 
     MSMT_TIME               DATE NOT NULL, 
     SESSIONLAUNCHES         NUMBER(20, 4) NOT NULL, 
     SESSIONLAUNCHES_ST      VARCHAR2(32) NOT NULL, 
     SESSIONTERMINATES       NUMBER(20, 4) NOT NULL, 
     SESSIONTERMINATES_ST    VARCHAR2(32) NOT NULL, 
     ACTIVESESSIONS          NUMBER(20, 4) NOT NULL, 
     ACTIVESESSIONS_ST       VARCHAR2(32) NOT NULL, 
     APPLAUNCHES             NUMBER(20, 4) NOT NULL, 
     APPLAUNCHES_ST          VARCHAR2(32) NOT NULL, 
     APPTERMINATES           NUMBER(20, 4) NOT NULL, 
     APPTERMINATES_ST        VARCHAR2(32) NOT NULL, 
     ACTIVEAPPS              NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_ST           VARCHAR2(32) NOT NULL, 
     NEW_DESKTOP_LAUNCHES    NUMBER(20, 4) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_ST VARCHAR2(32) NOT NULL, 
     DESKTOP_TERMINATES      NUMBER(20, 4) NOT NULL, 
     DESKTOP_TERMINATES_ST   VARCHAR2(32) NOT NULL, 
     ACTIVE_DESKTOPS         NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_ST      VARCHAR2(32) NOT NULL, 
     ACTIVE_APP_SESSIONS     NUMBER(20, 4) NOT NULL, 
     ACTIVE_APP_SESSIONS_ST  VARCHAR2(32) NOT NULL, 
     NEW_APP_SESSIONS        NUMBER(20, 4) NOT NULL, 
     NEW_APP_SESSIONS_ST     VARCHAR2(32) NOT NULL, 
     UNIQUE_USERS            NUMBER(20, 4) NOT NULL, 
     UNIQUE_USERS_ST         VARCHAR2(32) NOT NULL, 
     AVG_BW                  NUMBER(20, 4) NOT NULL, 
     AVG_BW_ST               VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXGATEWAYTEST 
  ON AFHDXGATEWAYTEST(MSMT_TIME); 

ALTER TABLE AFHDXGATEWAYTEST 
  ADD CONSTRAINT PK_AFHDXGATEWAYTEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXGATEWAYTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXGATEWAYTEST_TREND 
  ( 
     TRGT_HOST                  VARCHAR2(32) NOT NULL, 
     PORT_NO                    VARCHAR2(32) NOT NULL, 
     SITE_NAME                  VARCHAR2(64) NOT NULL, 
     INFO                       VARCHAR2(128) NOT NULL, 
     MSMT_HOST                  VARCHAR2(32) NOT NULL, 
     MSMT_TIME                  DATE NOT NULL, 
     PERIOD                     VARCHAR2(32) NOT NULL, 
     SESSIONLAUNCHES_MIN        NUMBER(20, 4) NOT NULL, 
     SESSIONLAUNCHES_MAX        NUMBER(20, 4) NOT NULL, 
     SESSIONLAUNCHES_STCNT      VARCHAR2(32) NOT NULL, 
     SESSIONTERMINATES_MIN      NUMBER(20, 4) NOT NULL, 
     SESSIONTERMINATES_MAX      NUMBER(20, 4) NOT NULL, 
     SESSIONTERMINATES_STCNT    VARCHAR2(32) NOT NULL, 
     ACTIVESESSIONS_MIN         NUMBER(20, 4) NOT NULL, 
     ACTIVESESSIONS_MAX         NUMBER(20, 4) NOT NULL, 
     ACTIVESESSIONS_STCNT       VARCHAR2(32) NOT NULL, 
     APPLAUNCHES_MIN            NUMBER(20, 4) NOT NULL, 
     APPLAUNCHES_MAX            NUMBER(20, 4) NOT NULL, 
     APPLAUNCHES_STCNT          VARCHAR2(32) NOT NULL, 
     APPTERMINATES_MIN          NUMBER(20, 4) NOT NULL, 
     APPTERMINATES_MAX          NUMBER(20, 4) NOT NULL, 
     APPTERMINATES_STCNT        VARCHAR2(32) NOT NULL, 
     ACTIVEAPPS_MIN             NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_MAX             NUMBER(20, 4) NOT NULL, 
     ACTIVEAPPS_STCNT           VARCHAR2(32) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_MIN   NUMBER(20, 4) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_MAX   NUMBER(20, 4) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_STCNT VARCHAR2(32) NOT NULL, 
     DESKTOP_TERMINATES_MIN     NUMBER(20, 4) NOT NULL, 
     DESKTOP_TERMINATES_MAX     NUMBER(20, 4) NOT NULL, 
     DESKTOP_TERMINATES_STCNT   VARCHAR2(32) NOT NULL, 
     ACTIVE_DESKTOPS_MIN        NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_MAX        NUMBER(20, 4) NOT NULL, 
     ACTIVE_DESKTOPS_STCNT      VARCHAR2(32) NOT NULL, 
     ACTIVE_APP_SESSIONS_MIN    NUMBER(20, 4) NOT NULL, 
     ACTIVE_APP_SESSIONS_MAX    NUMBER(20, 4) NOT NULL, 
     ACTIVE_APP_SESSIONS_STCNT  VARCHAR2(32) NOT NULL, 
     NEW_APP_SESSIONS_MIN       NUMBER(20, 4) NOT NULL, 
     NEW_APP_SESSIONS_MAX       NUMBER(20, 4) NOT NULL, 
     NEW_APP_SESSIONS_STCNT     VARCHAR2(32) NOT NULL, 
     UNIQUE_USERS_MIN           NUMBER(20, 4) NOT NULL, 
     UNIQUE_USERS_MAX           NUMBER(20, 4) NOT NULL, 
     UNIQUE_USERS_STCNT         VARCHAR2(32) NOT NULL, 
     AVG_BW_MIN                 NUMBER(20, 4) NOT NULL, 
     AVG_BW_MAX                 NUMBER(20, 4) NOT NULL, 
     AVG_BW_STCNT               VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXGATEWAYTEST_TREND 
  ADD CONSTRAINT PK_AFHDXGATEWAYTEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXGATEWAYTEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXGATEWAYTEST_THRESH 
  ( 
     TRGT_HOST                VARCHAR2(32) NOT NULL, 
     PORT_NO                  VARCHAR2(32) NOT NULL, 
     SITE_NAME                VARCHAR2(64) NOT NULL, 
     INFO                     VARCHAR2(128) NOT NULL, 
     MSMT_HOST                VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START          DATE NOT NULL, 
     MSMT_TIME_END            DATE NOT NULL, 
     SESSIONLAUNCHES_MIN      VARCHAR2(256) NOT NULL, 
     SESSIONLAUNCHES_MAX      VARCHAR2(256) NOT NULL, 
     SESSIONTERMINATES_MIN    VARCHAR2(256) NOT NULL, 
     SESSIONTERMINATES_MAX    VARCHAR2(256) NOT NULL, 
     ACTIVESESSIONS_MIN       VARCHAR2(256) NOT NULL, 
     ACTIVESESSIONS_MAX       VARCHAR2(256) NOT NULL, 
     APPLAUNCHES_MIN          VARCHAR2(256) NOT NULL, 
     APPLAUNCHES_MAX          VARCHAR2(256) NOT NULL, 
     APPTERMINATES_MIN        VARCHAR2(256) NOT NULL, 
     APPTERMINATES_MAX        VARCHAR2(256) NOT NULL, 
     ACTIVEAPPS_MIN           VARCHAR2(256) NOT NULL, 
     ACTIVEAPPS_MAX           VARCHAR2(256) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_MIN VARCHAR2(256) NOT NULL, 
     NEW_DESKTOP_LAUNCHES_MAX VARCHAR2(256) NOT NULL, 
     DESKTOP_TERMINATES_MIN   VARCHAR2(256) NOT NULL, 
     DESKTOP_TERMINATES_MAX   VARCHAR2(256) NOT NULL, 
     ACTIVE_DESKTOPS_MIN      VARCHAR2(256) NOT NULL, 
     ACTIVE_DESKTOPS_MAX      VARCHAR2(256) NOT NULL, 
     ACTIVE_APP_SESSIONS_MIN  VARCHAR2(256) NOT NULL, 
     ACTIVE_APP_SESSIONS_MAX  VARCHAR2(256) NOT NULL, 
     NEW_APP_SESSIONS_MIN     VARCHAR2(256) NOT NULL, 
     NEW_APP_SESSIONS_MAX     VARCHAR2(256) NOT NULL, 
     UNIQUE_USERS_MIN         VARCHAR2(256) NOT NULL, 
     UNIQUE_USERS_MAX         VARCHAR2(256) NOT NULL, 
     AVG_BW_MIN               VARCHAR2(256) NOT NULL, 
     AVG_BW_MAX               VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXGATEWAYTEST_THRESH 
  ADD CONSTRAINT PK_AFHDXGATEWAYTEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXGATEWAYTEST_THRESH 
  ON AFHDXGATEWAYTEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 

CREATE INDEX IDX_TH_AFHDXGATEWAYTEST 
  ON AFHDXGATEWAYTEST_THRESH (MSMT_TIME_START); 

CREATE INDEX IDX_TR_AFHDXGATEWAYTEST 
  ON AFHDXGATEWAYTEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFHDXLICENSETEST CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXLICENSETEST 
  ( 
     TRGT_HOST              VARCHAR2(32) NOT NULL, 
     PORT_NO                VARCHAR2(32) NOT NULL, 
     SITE_NAME              VARCHAR2(64) NOT NULL, 
     INFO                   VARCHAR2(128) NOT NULL, 
     MSMT_HOST              VARCHAR2(32) NOT NULL, 
     MSMT_TIME              DATE NOT NULL, 
     TOTAL_LICENSES         NUMBER(20, 4) NOT NULL, 
     TOTAL_LICENSES_ST      VARCHAR2(32) NOT NULL, 
     LICENSES_IN_USE        NUMBER(20, 4) NOT NULL, 
     LICENSES_IN_USE_ST     VARCHAR2(32) NOT NULL, 
     PERCENTAGE_CONSUMED    NUMBER(20, 4) NOT NULL, 
     PERCENTAGE_CONSUMED_ST VARCHAR2(32) NOT NULL, 
     AVAILABLE              NUMBER(20, 4) NOT NULL, 
     AVAILABLE_ST           VARCHAR2(32) NOT NULL 
  ); 

CREATE INDEX IDX_AFHDXLICENSETEST 
  ON AFHDXLICENSETEST(MSMT_TIME); 

ALTER TABLE AFHDXLICENSETEST 
  ADD CONSTRAINT PK_AFHDXLICENSETEST PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, 
  INFO, MSMT_HOST, MSMT_TIME); 

DROP TABLE AFHDXLICENSETEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXLICENSETEST_TREND 
  ( 
     TRGT_HOST                 VARCHAR2(32) NOT NULL, 
     PORT_NO                   VARCHAR2(32) NOT NULL, 
     SITE_NAME                 VARCHAR2(64) NOT NULL, 
     INFO                      VARCHAR2(128) NOT NULL, 
     MSMT_HOST                 VARCHAR2(32) NOT NULL, 
     MSMT_TIME                 DATE NOT NULL, 
     PERIOD                    VARCHAR2(32) NOT NULL, 
     TOTAL_LICENSES_MIN        NUMBER(20, 4) NOT NULL, 
     TOTAL_LICENSES_MAX        NUMBER(20, 4) NOT NULL, 
     TOTAL_LICENSES_STCNT      VARCHAR2(32) NOT NULL, 
     LICENSES_IN_USE_MIN       NUMBER(20, 4) NOT NULL, 
     LICENSES_IN_USE_MAX       NUMBER(20, 4) NOT NULL, 
     LICENSES_IN_USE_STCNT     VARCHAR2(32) NOT NULL, 
     PERCENTAGE_CONSUMED_MIN   NUMBER(20, 4) NOT NULL, 
     PERCENTAGE_CONSUMED_MAX   NUMBER(20, 4) NOT NULL, 
     PERCENTAGE_CONSUMED_STCNT VARCHAR2(32) NOT NULL, 
     AVAILABLE_MIN             NUMBER(20, 4) NOT NULL, 
     AVAILABLE_MAX             NUMBER(20, 4) NOT NULL, 
     AVAILABLE_STCNT           VARCHAR2(32) NOT NULL 
  ); 

ALTER TABLE AFHDXLICENSETEST_TREND 
  ADD CONSTRAINT PK_AFHDXLICENSETEST_TREND PRIMARY KEY(TRGT_HOST, PORT_NO, 
  SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD); 

DROP TABLE AFHDXLICENSETEST_THRESH CASCADE CONSTRAINTS; 

CREATE TABLE AFHDXLICENSETEST_THRESH 
  ( 
     TRGT_HOST               VARCHAR2(32) NOT NULL, 
     PORT_NO                 VARCHAR2(32) NOT NULL, 
     SITE_NAME               VARCHAR2(64) NOT NULL, 
     INFO                    VARCHAR2(128) NOT NULL, 
     MSMT_HOST               VARCHAR2(32) NOT NULL, 
     MSMT_TIME_START         DATE NOT NULL, 
     MSMT_TIME_END           DATE NOT NULL, 
     TOTAL_LICENSES_MIN      VARCHAR2(256) NOT NULL, 
     TOTAL_LICENSES_MAX      VARCHAR2(256) NOT NULL, 
     LICENSES_IN_USE_MIN     VARCHAR2(256) NOT NULL, 
     LICENSES_IN_USE_MAX     VARCHAR2(256) NOT NULL, 
     PERCENTAGE_CONSUMED_MIN VARCHAR2(256) NOT NULL, 
     PERCENTAGE_CONSUMED_MAX VARCHAR2(256) NOT NULL, 
     AVAILABLE_MIN           VARCHAR2(256) NOT NULL, 
     AVAILABLE_MAX           VARCHAR2(256) NOT NULL 
  ); 

ALTER TABLE AFHDXLICENSETEST_THRESH ADD CONSTRAINT PK_AFHDXLICENSETEST_THRESH PRIMARY KEY(TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START); 

CREATE INDEX IDX_AFHDXLICENSETEST_THRESH ON AFHDXLICENSETEST_THRESH (MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END); 
CREATE INDEX IDX_TH_AFHDXLICENSETEST ON AFHDXLICENSETEST_THRESH (MSMT_TIME_START); 
CREATE INDEX IDX_TR_AFHDXLICENSETEST ON AFHDXLICENSETEST_TREND (MSMT_TIME, PERIOD); 

DROP TABLE AFNSWEBAPPTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBAPPTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS			NUMBER(20,4) NOT NULL,
HITS_ST			VARCHAR2(32) NOT NULL,
BANDWIDTH		NUMBER(20,4) NOT NULL,
BANDWIDTH_ST		VARCHAR2(32) NOT NULL,
RESPONSE_TIME		NUMBER(20,4) NOT NULL,
RESPONSE_TIME_ST	VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME	NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY	NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_CNL NUMBER(20,4)	NOT NULL,
MAX_CNL_ST VARCHAR2(32)	NOT NULL,
SERVER_NETWORK_LATENCY	NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_SNL NUMBER(20,4)	NOT NULL,
MAX_SNL_ST VARCHAR2(32)	NOT NULL);

CREATE INDEX IDX_AFNSWEBAPPTEST ON AFNSWEBAPPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBAPPTEST ADD CONSTRAINT PK_AFNSWEBAPPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBAPPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBAPPTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RESPONSE_TIME_MIN NUMBER(20,4) NOT NULL,
RESPONSE_TIME_MAX NUMBER(20,4) NOT NULL,
RESPONSE_TIME_STCNT VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_CNL_MIN NUMBER(20,4) NOT NULL,
MAX_CNL_MAX NUMBER(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR2(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_SNL_MIN NUMBER(20,4) NOT NULL,
MAX_SNL_MAX NUMBER(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBAPPTEST_TREND ADD CONSTRAINT PK_AFNSWEBAPPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBAPPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBAPPTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_CNL_MIN VARCHAR2(256) NOT NULL,
MAX_CNL_MAX VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_SNL_MIN VARCHAR2(256) NOT NULL,
MAX_SNL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBAPPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBAPPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBAPPTEST_THRESH ON AFNSWEBAPPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBAPPTEST ON AFNSWEBAPPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBAPPTEST ON AFNSWEBAPPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBCLIENTTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBCLIENTTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
REQUESTS NUMBER(20,4) NOT NULL,
REQUESTS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RENDER_TIME NUMBER(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_CNL NUMBER(20,4) NOT NULL,
MAX_CNL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBCLIENTTEST ADD CONSTRAINT PK_AFNSWEBCLIENTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBCLIENTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBCLIENTTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
REQUESTS_MIN NUMBER(20,4) NOT NULL,
REQUESTS_MAX NUMBER(20,4) NOT NULL,
REQUESTS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RENDER_TIME_MIN NUMBER(20,4) NOT NULL,
RENDER_TIME_MAX NUMBER(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_CNL_MIN NUMBER(20,4) NOT NULL,
MAX_CNL_MAX NUMBER(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBCLIENTTEST_TREND ADD CONSTRAINT PK_AFNSWEBCLIENTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBCLIENTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBCLIENTTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
REQUESTS_MIN VARCHAR2(256) NOT NULL,
REQUESTS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RENDER_TIME_MIN VARCHAR2(256) NOT NULL,
RENDER_TIME_MAX VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_CNL_MIN VARCHAR2(256) NOT NULL,
MAX_CNL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBCLIENTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBCLIENTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBCLIENTTEST_THRESH ON AFNSWEBCLIENTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBSERVERSTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBSERVERSTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR2(32) NOT NULL,
SERVER_NETWORK_LATENCY NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_SNL NUMBER(20,4) NOT NULL,
MAX_SNL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBSERVERSTEST ADD CONSTRAINT PK_AFNSWEBSERVERSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBSERVERSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBSERVERSTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR2(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_SNL_MIN NUMBER(20,4) NOT NULL,
MAX_SNL_MAX NUMBER(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBSERVERSTEST_TREND ADD CONSTRAINT PK_AFNSWEBSERVERSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBSERVERSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBSERVERSTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_SNL_MIN VARCHAR2(256) NOT NULL,
MAX_SNL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBSERVERSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBSERVERSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBSERVERSTEST_THRESH ON AFNSWEBSERVERSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBUSERAGNTTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBUSERAGNTTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RENDER_TIME NUMBER(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBUSERAGNTTEST ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBUSERAGNTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBUSERAGNTTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RENDER_TIME_MIN NUMBER(20,4) NOT NULL,
RENDER_TIME_MAX NUMBER(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBUSERAGNTTEST_TREND ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBUSERAGNTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBUSERAGNTTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RENDER_TIME_MIN VARCHAR2(256) NOT NULL,
RENDER_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBUSERAGNTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBUSERAGNTTEST_THRESH ON AFNSWEBUSERAGNTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBOSTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBOSTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RENDER_TIME NUMBER(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBOSTEST ON AFNSWEBOSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBOSTEST ADD CONSTRAINT PK_AFNSWEBOSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBOSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBOSTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RENDER_TIME_MIN NUMBER(20,4) NOT NULL,
RENDER_TIME_MAX NUMBER(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBOSTEST_TREND ADD CONSTRAINT PK_AFNSWEBOSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBOSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBOSTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RENDER_TIME_MIN VARCHAR2(256) NOT NULL,
RENDER_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBOSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBOSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBOSTEST_THRESH ON AFNSWEBOSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBOSTEST ON AFNSWEBOSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBOSTEST ON AFNSWEBOSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBHTTPRESPTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPRESPTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RENDER_TIME NUMBER(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBHTTPRESPTEST ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBHTTPRESPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPRESPTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RENDER_TIME_MIN NUMBER(20,4) NOT NULL,
RENDER_TIME_MAX NUMBER(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBHTTPRESPTEST_TREND ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBHTTPRESPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPRESPTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RENDER_TIME_MIN VARCHAR2(256) NOT NULL,
RENDER_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBHTTPRESPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBHTTPRESPTEST_THRESH ON AFNSWEBHTTPRESPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBHTTPREQTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPREQTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST(MSMT_TIME);
ALTER TABLE AFNSWEBHTTPREQTEST ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBHTTPREQTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPREQTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBHTTPREQTEST_TREND ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBHTTPREQTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBHTTPREQTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBHTTPREQTEST_THRESH ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBHTTPREQTEST_THRESH ON AFNSWEBHTTPREQTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBDEVICESTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBDEVICESTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
NETSCALER_AVG_LATENCY NUMBER(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_ST VARCHAR2(32) NOT NULL,
NETSCALER_MAX_LATENCY NUMBER(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST(MSMT_TIME);
ALTER TABLE AFNSWEBDEVICESTEST ADD CONSTRAINT PK_AFNSWEBDEVICESTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBDEVICESTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBDEVICESTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
NETSCALER_AVG_LATENCY_MIN NUMBER(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_MAX NUMBER(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_STCNT VARCHAR2(32) NOT NULL,
NETSCALER_MAX_LATENCY_MIN NUMBER(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_MAX NUMBER(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBDEVICESTEST_TREND ADD CONSTRAINT PK_AFNSWEBDEVICESTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBDEVICESTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBDEVICESTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
NETSCALER_AVG_LATENCY_MIN VARCHAR2(256) NOT NULL,
NETSCALER_AVG_LATENCY_MAX VARCHAR2(256) NOT NULL,
NETSCALER_MAX_LATENCY_MIN VARCHAR2(256) NOT NULL,
NETSCALER_MAX_LATENCY_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBDEVICESTEST_THRESH ADD CONSTRAINT PK_AFNSWEBDEVICESTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBDEVICESTEST_THRESH ON AFNSWEBDEVICESTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE AFNSWEBURLSTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBURLSTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RENDER_TIME NUMBER(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR2(32) NOT NULL,
LOAD_TIME NUMBER(20,4) NOT NULL,
LOAD_TIME_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBURLSTEST ON AFNSWEBURLSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBURLSTEST ADD CONSTRAINT PK_AFNSWEBURLSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBURLSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBURLSTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RENDER_TIME_MIN NUMBER(20,4) NOT NULL,
RENDER_TIME_MAX NUMBER(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR2(32) NOT NULL,
LOAD_TIME_MIN NUMBER(20,4) NOT NULL,
LOAD_TIME_MAX NUMBER(20,4) NOT NULL,
LOAD_TIME_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBURLSTEST_TREND ADD CONSTRAINT PK_AFNSWEBURLSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBURLSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBURLSTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RENDER_TIME_MIN VARCHAR2(256) NOT NULL,
RENDER_TIME_MAX VARCHAR2(256) NOT NULL,
LOAD_TIME_MIN VARCHAR2(256) NOT NULL,
LOAD_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBURLSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBURLSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBURLSTEST_THRESH ON AFNSWEBURLSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBURLSTEST ON AFNSWEBURLSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBURLSTEST ON AFNSWEBURLSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBPROTTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBPROTTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
HITS NUMBER(20,4) NOT NULL,
HITS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
RESPONSE_TIME NUMBER(20,4) NOT NULL,
RESPONSE_TIME_ST VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_CNL NUMBER(20,4) NOT NULL,
MAX_CNL_ST VARCHAR2(32) NOT NULL,
SERVER_NETWORK_LATENCY NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,

MAX_SNL NUMBER(20,4) NOT NULL,
MAX_SNL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBPROTTEST ON AFNSWEBPROTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBPROTTEST ADD CONSTRAINT PK_AFNSWEBPROTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBPROTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBPROTTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
HITS_MIN NUMBER(20,4) NOT NULL,
HITS_MAX NUMBER(20,4) NOT NULL,
HITS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
RESPONSE_TIME_MIN NUMBER(20,4) NOT NULL,
RESPONSE_TIME_MAX NUMBER(20,4) NOT NULL,
RESPONSE_TIME_STCNT VARCHAR2(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX NUMBER(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_CNL_MIN NUMBER(20,4) NOT NULL,
MAX_CNL_MAX NUMBER(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR2(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,

MAX_SNL_MIN NUMBER(20,4) NOT NULL,
MAX_SNL_MAX NUMBER(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBPROTTEST_TREND ADD CONSTRAINT PK_AFNSWEBPROTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBPROTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBPROTTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
HITS_MIN VARCHAR2(256) NOT NULL,
HITS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR2(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_CNL_MIN VARCHAR2(256) NOT NULL,
MAX_CNL_MAX VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_SNL_MIN VARCHAR2(256) NOT NULL,
MAX_SNL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBPROTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBPROTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBPROTTEST_THRESH ON AFNSWEBPROTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBPROTTEST ON AFNSWEBPROTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBPROTTEST ON AFNSWEBPROTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBVIPTEST CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBVIPTEST(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
REQUESTS NUMBER(20,4) NOT NULL,
REQUESTS_ST VARCHAR2(32) NOT NULL,
BANDWIDTH NUMBER(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR2(32) NOT NULL,
MAX_CNL NUMBER(20,4) NOT NULL,
MAX_CNL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBVIPTEST ON AFNSWEBVIPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBVIPTEST ADD CONSTRAINT PK_AFNSWEBVIPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBVIPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBVIPTEST_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32) NOT NULL,
REQUESTS_MIN NUMBER(20,4) NOT NULL,
REQUESTS_MAX NUMBER(20,4) NOT NULL,
REQUESTS_STCNT VARCHAR2(32) NOT NULL,
BANDWIDTH_MIN NUMBER(20,4) NOT NULL,
BANDWIDTH_MAX NUMBER(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR2(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX NUMBER(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR2(32) NOT NULL,
MAX_CNL_MIN NUMBER(20,4) NOT NULL,
MAX_CNL_MAX NUMBER(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE AFNSWEBVIPTEST_TREND ADD CONSTRAINT PK_AFNSWEBVIPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBVIPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AFNSWEBVIPTEST_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
REQUESTS_MIN VARCHAR2(256) NOT NULL,
REQUESTS_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR2(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR2(256) NOT NULL,
MAX_CNL_MIN VARCHAR2(256) NOT NULL,
MAX_CNL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AFNSWEBVIPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBVIPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBVIPTEST_THRESH ON AFNSWEBVIPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBVIPTEST ON AFNSWEBVIPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBVIPTEST ON AFNSWEBVIPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE SapWasUserSessTest CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	LoggedInUsers			NUMBER(20,4) NOT NULL,
	LoggedInUsers_ST			varchar2(32) NOT NULL,
	OpenedSessions			NUMBER(20,4) NOT NULL,
	OpenedSessions_ST			varchar2(32) NOT NULL,
	ActiveSessions			NUMBER(20,4) NOT NULL,
	ActiveSessions_ST			varchar2(32) NOT NULL,
	SecuritySessions			NUMBER(20,4) NOT NULL,
	SecuritySessions_ST			varchar2(32) NOT NULL,
	EjbSessions			NUMBER(20,4) NOT NULL,
	EjbSessions_ST			varchar2(32) NOT NULL
);
CREATE INDEX IDX_SapWasUserSessTest ON SapWasUserSessTest(MSMT_TIME);
ALTER TABLE SapWasUserSessTest ADD constraint PK_SapWasUserSessTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SapWasUserSessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	LoggedInUsers_MIN			NUMBER(20,4) NOT NULL,
	LoggedInUsers_MAX			NUMBER(20,4) NOT NULL,
	LoggedInUsers_STCNT			varchar2(32) NOT NULL,
	OpenedSessions_MIN			NUMBER(20,4) NOT NULL,
	OpenedSessions_MAX			NUMBER(20,4) NOT NULL,
	OpenedSessions_STCNT			varchar2(32) NOT NULL,
	ActiveSessions_MIN			NUMBER(20,4) NOT NULL,
	ActiveSessions_MAX			NUMBER(20,4) NOT NULL,
	ActiveSessions_STCNT			varchar2(32) NOT NULL,
	SecuritySessions_MIN			NUMBER(20,4) NOT NULL,
	SecuritySessions_MAX			NUMBER(20,4) NOT NULL,
	SecuritySessions_STCNT			varchar2(32) NOT NULL,
	EjbSessions_MIN			NUMBER(20,4) NOT NULL,
	EjbSessions_MAX			NUMBER(20,4) NOT NULL,
	EjbSessions_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SapWasUserSessTest_TREND ADD constraint PK_SapWasUserSessTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SapWasUserSessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	LoggedInUsers_MIN			VARCHAR2(256)	 NOT NULL,
	LoggedInUsers_MAX	VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MIN			VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MAX	VARCHAR2(256)	 NOT NULL,
	ActiveSessions_MIN			VARCHAR2(256)	 NOT NULL,
	ActiveSessions_MAX	VARCHAR2(256)	 NOT NULL,
	SecuritySessions_MIN			VARCHAR2(256)	 NOT NULL,
	SecuritySessions_MAX	VARCHAR2(256)	 NOT NULL,
	EjbSessions_MIN			VARCHAR2(256)	 NOT NULL,
	EjbSessions_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SapWasUserSessTest_THRESH ADD constraint PK_SapWasUserSessTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SapWasUserSessTest_THRESH ON SapWasUserSessTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SapWasUserSessTest ON SapWasUserSessTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SapWasUserSessTest ON SapWasUserSessTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HttpResponsesTest CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESPONSES Number(20,4) NOT NULL,
RESPONSES_ST varchar2(32) NOT NULL,
RESPONSERATE Number(20,4) NOT NULL,
RESPONSERATE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HttpResponsesTest ON HttpResponsesTest(MSMT_TIME);
ALTER TABLE HttpResponsesTest ADD constraint PK_HttpResponsesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HttpResponsesTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESPONSES_MIN Number(20,4) NOT NULL,
RESPONSES_MAX Number(20,4) NOT NULL,
RESPONSES_STCNT varchar2(32) NOT NULL,
RESPONSERATE_MIN Number(20,4) NOT NULL,
RESPONSERATE_MAX Number(20,4) NOT NULL,
RESPONSERATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE HttpResponsesTest_TREND ADD constraint PK_HttpResponsesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HttpResponsesTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HttpResponsesTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESPONSES_MIN VARCHAR2(256) NOT NULL,
RESPONSES_MAX VARCHAR2(256) NOT NULL,
RESPONSERATE_MIN VARCHAR2(256) NOT NULL,
RESPONSERATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HttpResponsesTest_THRESH ADD constraint PK_HttpResponsesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HttpResponsesTest_THRESH ON HttpResponsesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HttpResponsesTest ON HttpResponsesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HttpResponsesTest ON HttpResponsesTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE AsAbapCenProcTest CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Display_Status NUMBER(20,4) NOT NULL,
Display_Status_ST varchar2(32) NOT NULL,
Process_Status NUMBER(20,4) NOT NULL,
Process_Status_ST varchar2(32) NOT NULL,
is_Restarted NUMBER(20,4) NOT NULL,
is_Restarted_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsAbapCenProcTest ON AsAbapCenProcTest(MSMT_TIME);
ALTER TABLE AsAbapCenProcTest ADD constraint PK_AsAbapCenProcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsAbapCenProcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Display_Status_MIN NUMBER(20,4) NOT NULL,
Display_Status_MAX NUMBER(20,4) NOT NULL,
Display_Status_STCNT varchar2(32) NOT NULL,
Process_Status_MIN NUMBER(20,4) NOT NULL,
Process_Status_MAX NUMBER(20,4) NOT NULL,
Process_Status_STCNT varchar2(32) NOT NULL,
is_Restarted_MIN NUMBER(20,4) NOT NULL,
is_Restarted_MAX NUMBER(20,4) NOT NULL,
is_Restarted_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsAbapCenProcTest_TREND ADD constraint PK_AsAbapCenProcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsAbapCenProcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsAbapCenProcTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Display_Status_MIN varchar2(256) NOT NULL,
Display_Status_MAX varchar2(256) NOT NULL,
Process_Status_MIN varchar2(256) NOT NULL,
Process_Status_MAX varchar2(256) NOT NULL,
is_Restarted_MIN varchar2(256) NOT NULL,
is_Restarted_MAX varchar2(256) NOT NULL);

ALTER TABLE AsAbapCenProcTest_THRESH ADD constraint PK_AsAbapCenProcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsAbapCenProcTest_THRESH ON AsAbapCenProcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsAbapCenProcTest ON AsAbapCenProcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsAbapCenProcTest ON AsAbapCenProcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPLocksTest CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	exclusiveLocks			NUMBER(20,4) NOT NULL,
	exclusiveLocks_ST			varchar2(32) NOT NULL,
	exclNonCumLocks			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_ST			varchar2(32) NOT NULL,
	otherLocks			NUMBER(20,4) NOT NULL,
	otherLocks_ST			varchar2(32) NOT NULL,
	allLocks			NUMBER(20,4) NOT NULL,
	allLocks_ST			varchar2(32) NOT NULL,
	maxLocks			NUMBER(20,4) NOT NULL,
	maxLocks_ST			varchar2(32) NOT NULL,
	currLockUtil			NUMBER(20,4) NOT NULL,
	currLockUtil_ST			varchar2(32) NOT NULL,
	highLocks			NUMBER(20,4) NOT NULL,
	highLocks_ST			varchar2(32) NOT NULL,
	highLockUtil			NUMBER(20,4) NOT NULL,
	highLockUtil_ST			varchar2(32) NOT NULL,
	currOwners			NUMBER(20,4) NOT NULL,
	currOwners_ST			varchar2(32) NOT NULL,
	currOwnerUtil			NUMBER(20,4) NOT NULL,
	currOwnerUtil_ST			varchar2(32) NOT NULL,
	currArgs			NUMBER(20,4) NOT NULL,
	currArgs_ST			varchar2(32) NOT NULL,
	currArgUtil			NUMBER(20,4) NOT NULL,
	currArgUtil_ST			varchar2(32) NOT NULL,
	enqReqs			NUMBER(20,4) NOT NULL,
	enqReqs_ST			varchar2(32) NOT NULL,
	enqReqRate			NUMBER(20,4) NOT NULL,
	enqReqRate_ST			varchar2(32) NOT NULL,
	enqReqRej			NUMBER(20,4) NOT NULL,
	enqReqRej_ST			varchar2(32) NOT NULL,
	enqReqRejRate			NUMBER(20,4) NOT NULL,
	enqReqRejRate_ST			varchar2(32) NOT NULL,
	pctEnqReqRej			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_ST			varchar2(32) NOT NULL,
	enqErrs			NUMBER(20,4) NOT NULL,
	enqErrs_ST			varchar2(32) NOT NULL,
	enqErrRate			NUMBER(20,4) NOT NULL,
	enqErrRate_ST			varchar2(32) NOT NULL,
	deqReqs			NUMBER(20,4) NOT NULL,
	deqReqs_ST			varchar2(32) NOT NULL,
	deqReqRate			NUMBER(20,4) NOT NULL,
	deqReqRate_ST			varchar2(32) NOT NULL,
	deqErrs			NUMBER(20,4) NOT NULL,
	deqErrs_ST			varchar2(32) NOT NULL,
	deqErrRate			NUMBER(20,4) NOT NULL,
	deqErrRate_ST			varchar2(32) NOT NULL,
	UpdReqRate			NUMBER(20,4) NOT NULL,
	UpdReqRate_ST			varchar2(32) NOT NULL,
	lckTblTime			NUMBER(20,4) NOT NULL,
	lckTblTime_ST			varchar2(32) NOT NULL,
	lckTblWaitTime			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_ST			varchar2(32) NOT NULL,
	lckSrvTime			NUMBER(20,4) NOT NULL,
	lckSrvTime_ST			varchar2(32) NOT NULL
);
ALTER TABLE SAPLocksTest ADD constraint PK_SAPLocksTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPLocksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	exclusiveLocks_MIN			NUMBER(20,4) NOT NULL,
	exclusiveLocks_MAX			NUMBER(20,4) NOT NULL,
	exclusiveLocks_STCNT			varchar2(32) NOT NULL,
	exclNonCumLocks_MIN			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_MAX			NUMBER(20,4) NOT NULL,
	exclNonCumLocks_STCNT			varchar2(32) NOT NULL,
	otherLocks_MIN			NUMBER(20,4) NOT NULL,
	otherLocks_MAX			NUMBER(20,4) NOT NULL,
	otherLocks_STCNT			varchar2(32) NOT NULL,
	allLocks_MIN			NUMBER(20,4) NOT NULL,
	allLocks_MAX			NUMBER(20,4) NOT NULL,
	allLocks_STCNT			varchar2(32) NOT NULL,
	maxLocks_MIN			NUMBER(20,4) NOT NULL,
	maxLocks_MAX			NUMBER(20,4) NOT NULL,
	maxLocks_STCNT			varchar2(32) NOT NULL,
	currLockUtil_MIN			NUMBER(20,4) NOT NULL,
	currLockUtil_MAX			NUMBER(20,4) NOT NULL,
	currLockUtil_STCNT			varchar2(32) NOT NULL,
	highLocks_MIN			NUMBER(20,4) NOT NULL,
	highLocks_MAX			NUMBER(20,4) NOT NULL,
	highLocks_STCNT			varchar2(32) NOT NULL,
	highLockUtil_MIN			NUMBER(20,4) NOT NULL,
	highLockUtil_MAX			NUMBER(20,4) NOT NULL,
	highLockUtil_STCNT			varchar2(32) NOT NULL,
	currOwners_MIN			NUMBER(20,4) NOT NULL,
	currOwners_MAX			NUMBER(20,4) NOT NULL,
	currOwners_STCNT			varchar2(32) NOT NULL,
	currOwnerUtil_MIN			NUMBER(20,4) NOT NULL,
	currOwnerUtil_MAX			NUMBER(20,4) NOT NULL,
	currOwnerUtil_STCNT			varchar2(32) NOT NULL,
	currArgs_MIN			NUMBER(20,4) NOT NULL,
	currArgs_MAX			NUMBER(20,4) NOT NULL,
	currArgs_STCNT			varchar2(32) NOT NULL,
	currArgUtil_MIN			NUMBER(20,4) NOT NULL,
	currArgUtil_MAX			NUMBER(20,4) NOT NULL,
	currArgUtil_STCNT			varchar2(32) NOT NULL,
	enqReqs_MIN			NUMBER(20,4) NOT NULL,
	enqReqs_MAX			NUMBER(20,4) NOT NULL,
	enqReqs_STCNT			varchar2(32) NOT NULL,
	enqReqRate_MIN			NUMBER(20,4) NOT NULL,
	enqReqRate_MAX			NUMBER(20,4) NOT NULL,
	enqReqRate_STCNT			varchar2(32) NOT NULL,
	enqReqRej_MIN			NUMBER(20,4) NOT NULL,
	enqReqRej_MAX			NUMBER(20,4) NOT NULL,
	enqReqRej_STCNT			varchar2(32) NOT NULL,
	enqReqRejRate_MIN			NUMBER(20,4) NOT NULL,
	enqReqRejRate_MAX			NUMBER(20,4) NOT NULL,
	enqReqRejRate_STCNT			varchar2(32) NOT NULL,
	pctEnqReqRej_MIN			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_MAX			NUMBER(20,4) NOT NULL,
	pctEnqReqRej_STCNT			varchar2(32) NOT NULL,
	enqErrs_MIN			NUMBER(20,4) NOT NULL,
	enqErrs_MAX			NUMBER(20,4) NOT NULL,
	enqErrs_STCNT			varchar2(32) NOT NULL,
	enqErrRate_MIN			NUMBER(20,4) NOT NULL,
	enqErrRate_MAX			NUMBER(20,4) NOT NULL,
	enqErrRate_STCNT			varchar2(32) NOT NULL,
	deqReqs_MIN			NUMBER(20,4) NOT NULL,
	deqReqs_MAX			NUMBER(20,4) NOT NULL,
	deqReqs_STCNT			varchar2(32) NOT NULL,
	deqReqRate_MIN			NUMBER(20,4) NOT NULL,
	deqReqRate_MAX			NUMBER(20,4) NOT NULL,
	deqReqRate_STCNT			varchar2(32) NOT NULL,
	deqErrs_MIN			NUMBER(20,4) NOT NULL,
	deqErrs_MAX			NUMBER(20,4) NOT NULL,
	deqErrs_STCNT			varchar2(32) NOT NULL,
	deqErrRate_MIN			NUMBER(20,4) NOT NULL,
	deqErrRate_MAX			NUMBER(20,4) NOT NULL,
	deqErrRate_STCNT			varchar2(32) NOT NULL,
	UpdReqRate_MIN			NUMBER(20,4) NOT NULL,
	UpdReqRate_MAX			NUMBER(20,4) NOT NULL,
	UpdReqRate_STCNT			varchar2(32) NOT NULL,
	lckTblTime_MIN			NUMBER(20,4) NOT NULL,
	lckTblTime_MAX			NUMBER(20,4) NOT NULL,
	lckTblTime_STCNT			varchar2(32) NOT NULL,
	lckTblWaitTime_MIN			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_MAX			NUMBER(20,4) NOT NULL,
	lckTblWaitTime_STCNT			varchar2(32) NOT NULL,
	lckSrvTime_MIN			NUMBER(20,4) NOT NULL,
	lckSrvTime_MAX			NUMBER(20,4) NOT NULL,
	lckSrvTime_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SAPLocksTest_TREND ADD constraint PK_SAPLocksTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPLocksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SAPLocksTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	exclusiveLocks_MIN			VARCHAR2(256)	 NOT NULL,
	exclusiveLocks_MAX	VARCHAR2(256)	 NOT NULL,
	exclNonCumLocks_MIN			VARCHAR2(256)	 NOT NULL,
	exclNonCumLocks_MAX	VARCHAR2(256)	 NOT NULL,
	otherLocks_MIN			VARCHAR2(256)	 NOT NULL,
	otherLocks_MAX	VARCHAR2(256)	 NOT NULL,
	allLocks_MIN			VARCHAR2(256)	 NOT NULL,
	allLocks_MAX	VARCHAR2(256)	 NOT NULL,
	maxLocks_MIN			VARCHAR2(256)	 NOT NULL,
	maxLocks_MAX	VARCHAR2(256)	 NOT NULL,
	currLockUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currLockUtil_MAX	VARCHAR2(256)	 NOT NULL,
	highLocks_MIN			VARCHAR2(256)	 NOT NULL,
	highLocks_MAX	VARCHAR2(256)	 NOT NULL,
	highLockUtil_MIN			VARCHAR2(256)	 NOT NULL,
	highLockUtil_MAX	VARCHAR2(256)	 NOT NULL,
	currOwners_MIN			VARCHAR2(256)	 NOT NULL,
	currOwners_MAX	VARCHAR2(256)	 NOT NULL,
	currOwnerUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currOwnerUtil_MAX	VARCHAR2(256)	 NOT NULL,
	currArgs_MIN			VARCHAR2(256)	 NOT NULL,
	currArgs_MAX	VARCHAR2(256)	 NOT NULL,
	currArgUtil_MIN			VARCHAR2(256)	 NOT NULL,
	currArgUtil_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqs_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqs_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRej_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRej_MAX	VARCHAR2(256)	 NOT NULL,
	enqReqRejRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqReqRejRate_MAX	VARCHAR2(256)	 NOT NULL,
	pctEnqReqRej_MIN			VARCHAR2(256)	 NOT NULL,
	pctEnqReqRej_MAX	VARCHAR2(256)	 NOT NULL,
	enqErrs_MIN			VARCHAR2(256)	 NOT NULL,
	enqErrs_MAX	VARCHAR2(256)	 NOT NULL,
	enqErrRate_MIN			VARCHAR2(256)	 NOT NULL,
	enqErrRate_MAX	VARCHAR2(256)	 NOT NULL,
	deqReqs_MIN			VARCHAR2(256)	 NOT NULL,
	deqReqs_MAX	VARCHAR2(256)	 NOT NULL,
	deqReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	deqReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	deqErrs_MIN			VARCHAR2(256)	 NOT NULL,
	deqErrs_MAX	VARCHAR2(256)	 NOT NULL,
	deqErrRate_MIN			VARCHAR2(256)	 NOT NULL,
	deqErrRate_MAX	VARCHAR2(256)	 NOT NULL,
	UpdReqRate_MIN			VARCHAR2(256)	 NOT NULL,
	UpdReqRate_MAX	VARCHAR2(256)	 NOT NULL,
	lckTblTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckTblTime_MAX	VARCHAR2(256)	 NOT NULL,
	lckTblWaitTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckTblWaitTime_MAX	VARCHAR2(256)	 NOT NULL,
	lckSrvTime_MIN			VARCHAR2(256)	 NOT NULL,
	lckSrvTime_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SAPLocksTest_THRESH ADD constraint PK_SAPLocksTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPLocksTest_THRESH ON SAPLocksTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_SAPLOCKSTEST ON SAPLOCKSTEST (MSMT_TIME);
CREATE INDEX IDX_TR_SAPLOCKSTEST ON SAPLOCKSTEST_TREND (MSMT_TIME,PERIOD);
CREATE INDEX IDX_TH_SAPLOCKSTEST ON SAPLOCKSTEST_THRESH (MSMT_TIME_START);


DROP TABLE SAPICMTest CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	RUNTHRD			NUMBER(20,4) NOT NULL,
	RUNTHRD_ST			varchar2(32) NOT NULL,
	IDLTHRD			NUMBER(20,4) NOT NULL,
	IDLTHRD_ST			varchar2(32) NOT NULL,
	USDTHRD			NUMBER(20,4) NOT NULL,
	USDTHRD_ST			varchar2(32) NOT NULL,
	MAXTHRD			NUMBER(20,4) NOT NULL,
	MAXTHRD_ST			varchar2(32) NOT NULL,
	USDTHRDPCT			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_ST			varchar2(32) NOT NULL,
	RUNTHRDPCT			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_ST			varchar2(32) NOT NULL,
	RUNCRTTHRDPCT			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_ST			varchar2(32) NOT NULL,
	USDCONNS			NUMBER(20,4) NOT NULL,
	USDCONNS_ST			varchar2(32) NOT NULL,
	USDCONNSPCT			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_ST			varchar2(32) NOT NULL,
	MAXCONNS			NUMBER(20,4) NOT NULL,
	MAXCONNS_ST			varchar2(32) NOT NULL,
	QUENOW			NUMBER(20,4) NOT NULL,
	QUENOW_ST			varchar2(32) NOT NULL,
	USDQUESPCT			NUMBER(20,4) NOT NULL,
	USDQUESPCT_ST			varchar2(32) NOT NULL,
	MAXQUES			NUMBER(20,4) NOT NULL,
	MAXQUES_ST			varchar2(32) NOT NULL
);
ALTER TABLE SAPICMTest ADD constraint PK_SAPICMTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPICMTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	RUNTHRD_MIN			NUMBER(20,4) NOT NULL,
	RUNTHRD_MAX			NUMBER(20,4) NOT NULL,
	RUNTHRD_STCNT			varchar2(32) NOT NULL,
	IDLTHRD_MIN			NUMBER(20,4) NOT NULL,
	IDLTHRD_MAX			NUMBER(20,4) NOT NULL,
	IDLTHRD_STCNT			varchar2(32) NOT NULL,
	USDTHRD_MIN			NUMBER(20,4) NOT NULL,
	USDTHRD_MAX			NUMBER(20,4) NOT NULL,
	USDTHRD_STCNT			varchar2(32) NOT NULL,
	MAXTHRD_MIN			NUMBER(20,4) NOT NULL,
	MAXTHRD_MAX			NUMBER(20,4) NOT NULL,
	MAXTHRD_STCNT			varchar2(32) NOT NULL,
	USDTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	USDTHRDPCT_STCNT			varchar2(32) NOT NULL,
	RUNTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	RUNTHRDPCT_STCNT			varchar2(32) NOT NULL,
	RUNCRTTHRDPCT_MIN			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_MAX			NUMBER(20,4) NOT NULL,
	RUNCRTTHRDPCT_STCNT			varchar2(32) NOT NULL,
	USDCONNS_MIN			NUMBER(20,4) NOT NULL,
	USDCONNS_MAX			NUMBER(20,4) NOT NULL,
	USDCONNS_STCNT			varchar2(32) NOT NULL,
	USDCONNSPCT_MIN			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_MAX			NUMBER(20,4) NOT NULL,
	USDCONNSPCT_STCNT			varchar2(32) NOT NULL,
	MAXCONNS_MIN			NUMBER(20,4) NOT NULL,
	MAXCONNS_MAX			NUMBER(20,4) NOT NULL,
	MAXCONNS_STCNT			varchar2(32) NOT NULL,
	QUENOW_MIN			NUMBER(20,4) NOT NULL,
	QUENOW_MAX			NUMBER(20,4) NOT NULL,
	QUENOW_STCNT			varchar2(32) NOT NULL,
	USDQUESPCT_MIN			NUMBER(20,4) NOT NULL,
	USDQUESPCT_MAX			NUMBER(20,4) NOT NULL,
	USDQUESPCT_STCNT			varchar2(32) NOT NULL,
	MAXQUES_MIN			NUMBER(20,4) NOT NULL,
	MAXQUES_MAX			NUMBER(20,4) NOT NULL,
	MAXQUES_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SAPICMTest_TREND ADD constraint PK_SAPICMTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPICMTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SAPICMTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	RUNTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	RUNTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	IDLTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	IDLTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	USDTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	USDTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	MAXTHRD_MIN			VARCHAR2(256)	 NOT NULL,
	MAXTHRD_MAX	VARCHAR2(256)	 NOT NULL,
	USDTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	RUNTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	RUNTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	RUNCRTTHRDPCT_MIN			VARCHAR2(256)	 NOT NULL,
	RUNCRTTHRDPCT_MAX	VARCHAR2(256)	 NOT NULL,
	USDCONNS_MIN			VARCHAR2(256)	 NOT NULL,
	USDCONNS_MAX	VARCHAR2(256)	 NOT NULL,
	USDCONNSPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDCONNSPCT_MAX	VARCHAR2(256)	 NOT NULL,
	MAXCONNS_MIN			VARCHAR2(256)	 NOT NULL,
	MAXCONNS_MAX	VARCHAR2(256)	 NOT NULL,
	QUENOW_MIN			VARCHAR2(256)	 NOT NULL,
	QUENOW_MAX	VARCHAR2(256)	 NOT NULL,
	USDQUESPCT_MIN			VARCHAR2(256)	 NOT NULL,
	USDQUESPCT_MAX	VARCHAR2(256)	 NOT NULL,
	MAXQUES_MIN			VARCHAR2(256)	 NOT NULL,
	MAXQUES_MAX	VARCHAR2(256)	 NOT NULL
);
ALTER TABLE SAPICMTest_THRESH ADD constraint PK_SAPICMTest_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPICMTEST ON SAPICMTEST (MSMT_TIME);
CREATE INDEX IDX_SAPICMTest_THRESH ON SAPICMTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPICMTest ON SAPICMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPICMTest ON SAPICMTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HPRCpuUtilTest CASCADE CONSTRAINTS;
CREATE TABLE HPRCpuUtilTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CPU_UTILIZATION Number(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar2(32) NOT NULL,
MAX_CPU_UTILIZATION Number(20,4) NOT NULL,
MAX_CPU_UTILIZATION_ST varchar2(32) NOT NULL,
AVG_CPU_UTILIZATION Number(20,4) NOT NULL,
AVG_CPU_UTILIZATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HPRCpuUtilTest ON HPRCpuUtilTest(MSMT_TIME);
ALTER TABLE HPRCpuUtilTest ADD constraint PK_HPRCpuUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRCpuUtilTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HPRCpuUtilTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CPU_UTILIZATION_MIN Number(20,4) NOT NULL,
CPU_UTILIZATION_MAX Number(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar2(32) NOT NULL,
MAX_CPU_UTILIZATION_MIN Number(20,4) NOT NULL,
MAX_CPU_UTILIZATION_MAX Number(20,4) NOT NULL,
MAX_CPU_UTILIZATION_STCNT varchar2(32) NOT NULL,
AVG_CPU_UTILIZATION_MIN Number(20,4) NOT NULL,
AVG_CPU_UTILIZATION_MAX Number(20,4) NOT NULL,
AVG_CPU_UTILIZATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE HPRCpuUtilTest_TREND ADD constraint PK_HPRCpuUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRCpuUtilTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HPRCpuUtilTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CPU_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
MAX_CPU_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
MAX_CPU_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
AVG_CPU_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
AVG_CPU_UTILIZATION_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HPRCpuUtilTest_THRESH ADD constraint PK_HPRCpuUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRCpuUtilTest_THRESH ON HPRCpuUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRCpuUtilTest ON HPRCpuUtilTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRCpuUtilTest ON HPRCpuUtilTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRPwrSupplyTest CASCADE CONSTRAINTS;
CREATE TABLE HPRPwrSupplyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NOMINAL_POWER Number(20,4) NOT NULL,
NOMINAL_POWER_ST varchar2(32) NOT NULL,
CURRENT_POWER Number(20,4) NOT NULL,
CURRENT_POWER_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HPRPwrSupplyTest ON HPRPwrSupplyTest(MSMT_TIME);
ALTER TABLE HPRPwrSupplyTest ADD constraint PK_HPRPwrSupplyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRPwrSupplyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HPRPwrSupplyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NOMINAL_POWER_MIN Number(20,4) NOT NULL,
NOMINAL_POWER_MAX Number(20,4) NOT NULL,
NOMINAL_POWER_STCNT varchar2(32) NOT NULL,
CURRENT_POWER_MIN Number(20,4) NOT NULL,
CURRENT_POWER_MAX Number(20,4) NOT NULL,
CURRENT_POWER_STCNT varchar2(32) NOT NULL);

ALTER TABLE HPRPwrSupplyTest_TREND ADD constraint PK_HPRPwrSupplyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRPwrSupplyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HPRPwrSupplyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NOMINAL_POWER_MIN VARCHAR2(256) NOT NULL,
NOMINAL_POWER_MAX VARCHAR2(256) NOT NULL,
CURRENT_POWER_MIN VARCHAR2(256) NOT NULL,
CURRENT_POWER_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HPRPwrSupplyTest_THRESH ADD constraint PK_HPRPwrSupplyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRPwrSupplyTest_THRESH ON HPRPwrSupplyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRPwrSupplyTest ON HPRPwrSupplyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRPwrSupplyTest ON HPRPwrSupplyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRVoltageTest CASCADE CONSTRAINTS;
CREATE TABLE HPRVoltageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
INPUT_VOLTAGE Number(20,4) NOT NULL,
INPUT_VOLTAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HPRVoltageTest ON HPRVoltageTest(MSMT_TIME);
ALTER TABLE HPRVoltageTest ADD constraint PK_HPRVoltageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRVoltageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HPRVoltageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
INPUT_VOLTAGE_MIN Number(20,4) NOT NULL,
INPUT_VOLTAGE_MAX Number(20,4) NOT NULL,
INPUT_VOLTAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE HPRVoltageTest_TREND ADD constraint PK_HPRVoltageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRVoltageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HPRVoltageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
INPUT_VOLTAGE_MIN VARCHAR2(256) NOT NULL,
INPUT_VOLTAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HPRVoltageTest_THRESH ADD constraint PK_HPRVoltageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRVoltageTest_THRESH ON HPRVoltageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRVoltageTest ON HPRVoltageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRVoltageTest ON HPRVoltageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRGlobalStTest CASCADE CONSTRAINTS;
CREATE TABLE HPRGlobalStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_TUNNELS Number(20,4) NOT NULL,
ACTIVE_TUNNELS_ST varchar2(32) NOT NULL,
RECVD_DATA Number(20,4) NOT NULL,
RECVD_DATA_ST varchar2(32) NOT NULL,
RECVD_PACKET Number(20,4) NOT NULL,
RECVD_PACKET_ST varchar2(32) NOT NULL,
RECVD_DROP_PACKET Number(20,4) NOT NULL,
RECVD_DROP_PACKET_ST varchar2(32) NOT NULL,
TXMTD_DATA Number(20,4) NOT NULL,
TXMTD_DATA_ST varchar2(32) NOT NULL,
TXMTD_PACKET Number(20,4) NOT NULL,
TXMTD_PACKET_ST varchar2(32) NOT NULL,
TXMTD_DROP_PACKET Number(20,4) NOT NULL,
TXMTD_DROP_PACKET_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HPRGlobalStTest ON HPRGlobalStTest(MSMT_TIME);
ALTER TABLE HPRGlobalStTest ADD constraint PK_HPRGlobalStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRGlobalStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HPRGlobalStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ACTIVE_TUNNELS_MIN Number(20,4) NOT NULL,
ACTIVE_TUNNELS_MAX Number(20,4) NOT NULL,
ACTIVE_TUNNELS_STCNT varchar2(32) NOT NULL,
RECVD_DATA_MIN Number(20,4) NOT NULL,
RECVD_DATA_MAX Number(20,4) NOT NULL,
RECVD_DATA_STCNT varchar2(32) NOT NULL,
RECVD_PACKET_MIN Number(20,4) NOT NULL,
RECVD_PACKET_MAX Number(20,4) NOT NULL,
RECVD_PACKET_STCNT varchar2(32) NOT NULL,
RECVD_DROP_PACKET_MIN Number(20,4) NOT NULL,
RECVD_DROP_PACKET_MAX Number(20,4) NOT NULL,
RECVD_DROP_PACKET_STCNT varchar2(32) NOT NULL,
TXMTD_DATA_MIN Number(20,4) NOT NULL,
TXMTD_DATA_MAX Number(20,4) NOT NULL,
TXMTD_DATA_STCNT varchar2(32) NOT NULL,
TXMTD_PACKET_MIN Number(20,4) NOT NULL,
TXMTD_PACKET_MAX Number(20,4) NOT NULL,
TXMTD_PACKET_STCNT varchar2(32) NOT NULL,
TXMTD_DROP_PACKET_MIN Number(20,4) NOT NULL,
TXMTD_DROP_PACKET_MAX Number(20,4) NOT NULL,
TXMTD_DROP_PACKET_STCNT varchar2(32) NOT NULL);

ALTER TABLE HPRGlobalStTest_TREND ADD constraint PK_HPRGlobalStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRGlobalStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HPRGlobalStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_TUNNELS_MIN VARCHAR2(256) NOT NULL,
ACTIVE_TUNNELS_MAX VARCHAR2(256) NOT NULL,
RECVD_DATA_MIN VARCHAR2(256) NOT NULL,
RECVD_DATA_MAX VARCHAR2(256) NOT NULL,
RECVD_PACKET_MIN VARCHAR2(256) NOT NULL,
RECVD_PACKET_MAX VARCHAR2(256) NOT NULL,
RECVD_DROP_PACKET_MIN VARCHAR2(256) NOT NULL,
RECVD_DROP_PACKET_MAX VARCHAR2(256) NOT NULL,
TXMTD_DATA_MIN VARCHAR2(256) NOT NULL,
TXMTD_DATA_MAX VARCHAR2(256) NOT NULL,
TXMTD_PACKET_MIN VARCHAR2(256) NOT NULL,
TXMTD_PACKET_MAX VARCHAR2(256) NOT NULL,
TXMTD_DROP_PACKET_MIN VARCHAR2(256) NOT NULL,
TXMTD_DROP_PACKET_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HPRGlobalStTest_THRESH ADD constraint PK_HPRGlobalStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRGlobalStTest_THRESH ON HPRGlobalStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRGlobalStTest ON HPRGlobalStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRGlobalStTest ON HPRGlobalStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRMemUtilTest CASCADE CONSTRAINTS;
CREATE TABLE HPRMemUtilTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_MEMORY Number(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar2(32) NOT NULL,
MEM_UTILIZED Number(20,4) NOT NULL,
MEM_UTILIZED_ST varchar2(32) NOT NULL,
FREE_MEMORY Number(20,4) NOT NULL,
FREE_MEMORY_ST varchar2(32) NOT NULL,
MEM_UTILIZATION Number(20,4) NOT NULL,
MEM_UTILIZATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_HPRMemUtilTest ON HPRMemUtilTest(MSMT_TIME);
ALTER TABLE HPRMemUtilTest ADD constraint PK_HPRMemUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRMemUtilTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HPRMemUtilTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_MEMORY_MIN Number(20,4) NOT NULL,
TOTAL_MEMORY_MAX Number(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar2(32) NOT NULL,
MEM_UTILIZED_MIN Number(20,4) NOT NULL,
MEM_UTILIZED_MAX Number(20,4) NOT NULL,
MEM_UTILIZED_STCNT varchar2(32) NOT NULL,
FREE_MEMORY_MIN Number(20,4) NOT NULL,
FREE_MEMORY_MAX Number(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar2(32) NOT NULL,
MEM_UTILIZATION_MIN Number(20,4) NOT NULL,
MEM_UTILIZATION_MAX Number(20,4) NOT NULL,
MEM_UTILIZATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE HPRMemUtilTest_TREND ADD constraint PK_HPRMemUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRMemUtilTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HPRMemUtilTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_MEMORY_MIN VARCHAR2(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR2(256) NOT NULL,
MEM_UTILIZED_MIN VARCHAR2(256) NOT NULL,
MEM_UTILIZED_MAX VARCHAR2(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR2(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR2(256) NOT NULL,
MEM_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
MEM_UTILIZATION_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE HPRMemUtilTest_THRESH ADD constraint PK_HPRMemUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRMemUtilTest_THRESH ON HPRMemUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRMemUtilTest ON HPRMemUtilTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRMemUtilTest ON HPRMemUtilTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RZDCPUMgtTest CASCADE CONSTRAINTS;
CREATE TABLE RZDCPUMgtTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDCPUMgtTest ON RZDCPUMgtTest(MSMT_TIME);
ALTER TABLE RZDCPUMgtTest ADD constraint PK_RZDCPUMgtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDCPUMgtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDCPUMgtTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDCPUMgtTest_TREND ADD constraint PK_RZDCPUMgtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDCPUMgtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDCPUMgtTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CPU_UTIL_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDCPUMgtTest_THRESH ADD constraint PK_RZDCPUMgtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDCPUMgtTest_THRESH ON RZDCPUMgtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDCPUMgtTest ON RZDCPUMgtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDCPUMgtTest ON RZDCPUMgtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RZDMemoryTest CASCADE CONSTRAINTS;
CREATE TABLE RZDMemoryTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_MEMORY Number(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar2(32) NOT NULL,
USED_MEMORY Number(20,4) NOT NULL,
USED_MEMORY_ST varchar2(32) NOT NULL,
AVAILABLE_MEMORY Number(20,4) NOT NULL,
AVAILABLE_MEMORY_ST varchar2(32) NOT NULL,
MEMORY_UTIL Number(20,4) NOT NULL,
MEMORY_UTIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDMemoryTest ON RZDMemoryTest(MSMT_TIME);
ALTER TABLE RZDMemoryTest ADD constraint PK_RZDMemoryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDMemoryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDMemoryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_MEMORY_MIN Number(20,4) NOT NULL,
TOTAL_MEMORY_MAX Number(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar2(32) NOT NULL,
USED_MEMORY_MIN Number(20,4) NOT NULL,
USED_MEMORY_MAX Number(20,4) NOT NULL,
USED_MEMORY_STCNT varchar2(32) NOT NULL,
AVAILABLE_MEMORY_MIN Number(20,4) NOT NULL,
AVAILABLE_MEMORY_MAX Number(20,4) NOT NULL,
AVAILABLE_MEMORY_STCNT varchar2(32) NOT NULL,
MEMORY_UTIL_MIN Number(20,4) NOT NULL,
MEMORY_UTIL_MAX Number(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDMemoryTest_TREND ADD constraint PK_RZDMemoryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDMemoryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDMemoryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_MEMORY_MIN VARCHAR2(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR2(256) NOT NULL,
USED_MEMORY_MIN VARCHAR2(256) NOT NULL,
USED_MEMORY_MAX VARCHAR2(256) NOT NULL,
AVAILABLE_MEMORY_MIN VARCHAR2(256) NOT NULL,
AVAILABLE_MEMORY_MAX VARCHAR2(256) NOT NULL,
MEMORY_UTIL_MIN VARCHAR2(256) NOT NULL,
MEMORY_UTIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDMemoryTest_THRESH ADD constraint PK_RZDMemoryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDMemoryTest_THRESH ON RZDMemoryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDMemoryTest ON RZDMemoryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDMemoryTest ON RZDMemoryTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDUpTimeTest CASCADE CONSTRAINTS;
CREATE TABLE RZDUpTimeTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REBOOT Number(20,4) NOT NULL,
REBOOT_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL,
TOTAL_UPTIME Number(20,4) NOT NULL,
TOTAL_UPTIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDUpTimeTest ON RZDUpTimeTest(MSMT_TIME);
ALTER TABLE RZDUpTimeTest ADD constraint PK_RZDUpTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDUpTimeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDUpTimeTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REBOOT_MIN Number(20,4) NOT NULL,
REBOOT_MAX Number(20,4) NOT NULL,
REBOOT_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL,
TOTAL_UPTIME_MIN Number(20,4) NOT NULL,
TOTAL_UPTIME_MAX Number(20,4) NOT NULL,
TOTAL_UPTIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDUpTimeTest_TREND ADD constraint PK_RZDUpTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDUpTimeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDUpTimeTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REBOOT_MIN VARCHAR2(256) NOT NULL,
REBOOT_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL,
TOTAL_UPTIME_MIN VARCHAR2(256) NOT NULL,
TOTAL_UPTIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDUpTimeTest_THRESH ADD constraint PK_RZDUpTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDUpTimeTest_THRESH ON RZDUpTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDUpTimeTest ON RZDUpTimeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDUpTimeTest ON RZDUpTimeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDEthernetTest CASCADE CONSTRAINTS;
CREATE TABLE RZDEthernetTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ETHERNET_STATUS Number(20,4) NOT NULL,
ETHERNET_STATUS_ST varchar2(32) NOT NULL,
TRANSMIT_PKT Number(20,4) NOT NULL,
TRANSMIT_PKT_ST varchar2(32) NOT NULL,
RECEIVED_PKT Number(20,4) NOT NULL,
RECEIVED_PKT_ST varchar2(32) NOT NULL,
TRANSMIT_DATA Number(20,4) NOT NULL,
TRANSMIT_DATA_ST varchar2(32) NOT NULL,
RECEIVED_DATA Number(20,4) NOT NULL,
RECEIVED_DATA_ST varchar2(32) NOT NULL,
TRANSMIT_DROP_PKT Number(20,4) NOT NULL,
TRANSMIT_DROP_PKT_ST varchar2(32) NOT NULL,
RECEIVED_DROP_PKT Number(20,4) NOT NULL,
RECEIVED_DROP_PKT_ST varchar2(32) NOT NULL,
ETHER_UTIL Number(20,4) NOT NULL,
ETHER_UTIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDEthernetTest ON RZDEthernetTest(MSMT_TIME);
ALTER TABLE RZDEthernetTest ADD constraint PK_RZDEthernetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDEthernetTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDEthernetTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ETHERNET_STATUS_MIN Number(20,4) NOT NULL,
ETHERNET_STATUS_MAX Number(20,4) NOT NULL,
ETHERNET_STATUS_STCNT varchar2(32) NOT NULL,
TRANSMIT_PKT_MIN Number(20,4) NOT NULL,
TRANSMIT_PKT_MAX Number(20,4) NOT NULL,
TRANSMIT_PKT_STCNT varchar2(32) NOT NULL,
RECEIVED_PKT_MIN Number(20,4) NOT NULL,
RECEIVED_PKT_MAX Number(20,4) NOT NULL,
RECEIVED_PKT_STCNT varchar2(32) NOT NULL,
TRANSMIT_DATA_MIN Number(20,4) NOT NULL,
TRANSMIT_DATA_MAX Number(20,4) NOT NULL,
TRANSMIT_DATA_STCNT varchar2(32) NOT NULL,
RECEIVED_DATA_MIN Number(20,4) NOT NULL,
RECEIVED_DATA_MAX Number(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar2(32) NOT NULL,
TRANSMIT_DROP_PKT_MIN Number(20,4) NOT NULL,
TRANSMIT_DROP_PKT_MAX Number(20,4) NOT NULL,
TRANSMIT_DROP_PKT_STCNT varchar2(32) NOT NULL,
RECEIVED_DROP_PKT_MIN Number(20,4) NOT NULL,
RECEIVED_DROP_PKT_MAX Number(20,4) NOT NULL,
RECEIVED_DROP_PKT_STCNT varchar2(32) NOT NULL,
ETHER_UTIL_MIN Number(20,4) NOT NULL,
ETHER_UTIL_MAX Number(20,4) NOT NULL,
ETHER_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDEthernetTest_TREND ADD constraint PK_RZDEthernetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDEthernetTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDEthernetTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ETHERNET_STATUS_MIN VARCHAR2(256) NOT NULL,
ETHERNET_STATUS_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_PKT_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_PKT_MAX VARCHAR2(256) NOT NULL,
RECEIVED_PKT_MIN VARCHAR2(256) NOT NULL,
RECEIVED_PKT_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_DATA_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_DATA_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_DROP_PKT_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_DROP_PKT_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DROP_PKT_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DROP_PKT_MAX VARCHAR2(256) NOT NULL,
ETHER_UTIL_MIN VARCHAR2(256) NOT NULL,
ETHER_UTIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDEthernetTest_THRESH ADD constraint PK_RZDEthernetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDEthernetTest_THRESH ON RZDEthernetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDEthernetTest ON RZDEthernetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDEthernetTest ON RZDEthernetTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDSysDetailTest CASCADE CONSTRAINTS;
CREATE TABLE RZDSysDetailTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CPU_UTILIZATION Number(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar2(32) NOT NULL,
MEMORY_UTILIZATION Number(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDSysDetailTest ON RZDSysDetailTest(MSMT_TIME);
ALTER TABLE RZDSysDetailTest ADD constraint PK_RZDSysDetailTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDSysDetailTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDSysDetailTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CPU_UTILIZATION_MIN Number(20,4) NOT NULL,
CPU_UTILIZATION_MAX Number(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar2(32) NOT NULL,
MEMORY_UTILIZATION_MIN Number(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX Number(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDSysDetailTest_TREND ADD constraint PK_RZDSysDetailTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDSysDetailTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDSysDetailTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CPU_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDSysDetailTest_THRESH ADD constraint PK_RZDSysDetailTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDSysDetailTest_THRESH ON RZDSysDetailTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDSysDetailTest ON RZDSysDetailTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDSysDetailTest ON RZDSysDetailTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE RZDDevInfoTest CASCADE CONSTRAINTS;
CREATE TABLE RZDDevInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_ACCESSPOINT Number(20,4) NOT NULL,
TOTAL_ACCESSPOINT_ST varchar2(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_ST varchar2(32) NOT NULL,
TOTAL_ROGUE_DEVICE Number(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDDevInfoTest ON RZDDevInfoTest(MSMT_TIME);
ALTER TABLE RZDDevInfoTest ADD constraint PK_RZDDevInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDDevInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDDevInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_ACCESSPOINT_MIN Number(20,4) NOT NULL,
TOTAL_ACCESSPOINT_MAX Number(20,4) NOT NULL,
TOTAL_ACCESSPOINT_STCNT varchar2(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_STCNT varchar2(32) NOT NULL,
TOTAL_ROGUE_DEVICE_MIN Number(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_MAX Number(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDDevInfoTest_TREND ADD constraint PK_RZDDevInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDDevInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDDevInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_ACCESSPOINT_MIN VARCHAR2(256) NOT NULL,
TOTAL_ACCESSPOINT_MAX VARCHAR2(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN VARCHAR2(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX VARCHAR2(256) NOT NULL,
TOTAL_ROGUE_DEVICE_MIN VARCHAR2(256) NOT NULL,
TOTAL_ROGUE_DEVICE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDDevInfoTest_THRESH ADD constraint PK_RZDDevInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDDevInfoTest_THRESH ON RZDDevInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDDevInfoTest ON RZDDevInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDDevInfoTest ON RZDDevInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDDetailStatTest CASCADE CONSTRAINTS;
CREATE TABLE RZDDetailStatTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TRANSMIITED_PACKETS Number(20,4) NOT NULL,
TRANSMIITED_PACKETS_ST varchar2(32) NOT NULL,
RECEIVED_PACKETS Number(20,4) NOT NULL,
RECEIVED_PACKETS_ST varchar2(32) NOT NULL,
DATA_TRANSMITTED Number(20,4) NOT NULL,
DATA_TRANSMITTED_ST varchar2(32) NOT NULL,
DATA_RECEIVED Number(20,4) NOT NULL,
DATA_RECEIVED_ST varchar2(32) NOT NULL,
TRANSMITTED_FAIL_PACKETS Number(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_ST varchar2(32) NOT NULL,
TRANSMITTED_RETRY_PACKET Number(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_ST varchar2(32) NOT NULL,
MCAST_PACKET_TRANSMITTED Number(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_ST varchar2(32) NOT NULL,
MCAST_PACKET_RECEIVED Number(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDDetailStatTest ON RZDDetailStatTest(MSMT_TIME);
ALTER TABLE RZDDetailStatTest ADD constraint PK_RZDDetailStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDDetailStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDDetailStatTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TRANSMIITED_PACKETS_MIN Number(20,4) NOT NULL,
TRANSMIITED_PACKETS_MAX Number(20,4) NOT NULL,
TRANSMIITED_PACKETS_STCNT varchar2(32) NOT NULL,
RECEIVED_PACKETS_MIN Number(20,4) NOT NULL,
RECEIVED_PACKETS_MAX Number(20,4) NOT NULL,
RECEIVED_PACKETS_STCNT varchar2(32) NOT NULL,
DATA_TRANSMITTED_MIN Number(20,4) NOT NULL,
DATA_TRANSMITTED_MAX Number(20,4) NOT NULL,
DATA_TRANSMITTED_STCNT varchar2(32) NOT NULL,
DATA_RECEIVED_MIN Number(20,4) NOT NULL,
DATA_RECEIVED_MAX Number(20,4) NOT NULL,
DATA_RECEIVED_STCNT varchar2(32) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MIN Number(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MAX Number(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_STCNT varchar2(32) NOT NULL,
TRANSMITTED_RETRY_PACKET_MIN Number(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_MAX Number(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_STCNT varchar2(32) NOT NULL,
MCAST_PACKET_TRANSMITTED_MIN Number(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_MAX Number(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_STCNT varchar2(32) NOT NULL,
MCAST_PACKET_RECEIVED_MIN Number(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_MAX Number(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDDetailStatTest_TREND ADD constraint PK_RZDDetailStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDDetailStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDDetailStatTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TRANSMIITED_PACKETS_MIN VARCHAR2(256) NOT NULL,
TRANSMIITED_PACKETS_MAX VARCHAR2(256) NOT NULL,
RECEIVED_PACKETS_MIN VARCHAR2(256) NOT NULL,
RECEIVED_PACKETS_MAX VARCHAR2(256) NOT NULL,
DATA_TRANSMITTED_MIN VARCHAR2(256) NOT NULL,
DATA_TRANSMITTED_MAX VARCHAR2(256) NOT NULL,
DATA_RECEIVED_MIN VARCHAR2(256) NOT NULL,
DATA_RECEIVED_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRY_PACKET_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRY_PACKET_MAX VARCHAR2(256) NOT NULL,
MCAST_PACKET_TRANSMITTED_MIN VARCHAR2(256) NOT NULL,
MCAST_PACKET_TRANSMITTED_MAX VARCHAR2(256) NOT NULL,
MCAST_PACKET_RECEIVED_MIN VARCHAR2(256) NOT NULL,
MCAST_PACKET_RECEIVED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDDetailStatTest_THRESH ADD constraint PK_RZDDetailStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDDetailStatTest_THRESH ON RZDDetailStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDDetailStatTest ON RZDDetailStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDDetailStatTest ON RZDDetailStatTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDRogueInfoTest CASCADE CONSTRAINTS;
CREATE TABLE RZDRogueInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RADIO_TYPE Number(20,4) NOT NULL,
RADIO_TYPE_ST varchar2(32) NOT NULL,
CHANNEL Number(20,4) NOT NULL,
CHANNEL_ST varchar2(32) NOT NULL,
ROGUE_TYPE Number(20,4) NOT NULL,
ROGUE_TYPE_ST varchar2(32) NOT NULL,
ENCRYPTION_MODE Number(20,4) NOT NULL,
ENCRYPTION_MODE_ST varchar2(32) NOT NULL,
SIGNAL_STRENGTH Number(20,4) NOT NULL,
SIGNAL_STRENGTH_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDRogueInfoTest ON RZDRogueInfoTest(MSMT_TIME);
ALTER TABLE RZDRogueInfoTest ADD constraint PK_RZDRogueInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDRogueInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDRogueInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RADIO_TYPE_MIN Number(20,4) NOT NULL,
RADIO_TYPE_MAX Number(20,4) NOT NULL,
RADIO_TYPE_STCNT varchar2(32) NOT NULL,
CHANNEL_MIN Number(20,4) NOT NULL,
CHANNEL_MAX Number(20,4) NOT NULL,
CHANNEL_STCNT varchar2(32) NOT NULL,
ROGUE_TYPE_MIN Number(20,4) NOT NULL,
ROGUE_TYPE_MAX Number(20,4) NOT NULL,
ROGUE_TYPE_STCNT varchar2(32) NOT NULL,
ENCRYPTION_MODE_MIN Number(20,4) NOT NULL,
ENCRYPTION_MODE_MAX Number(20,4) NOT NULL,
ENCRYPTION_MODE_STCNT varchar2(32) NOT NULL,
SIGNAL_STRENGTH_MIN Number(20,4) NOT NULL,
SIGNAL_STRENGTH_MAX Number(20,4) NOT NULL,
SIGNAL_STRENGTH_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDRogueInfoTest_TREND ADD constraint PK_RZDRogueInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDRogueInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDRogueInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RADIO_TYPE_MIN VARCHAR2(256) NOT NULL,
RADIO_TYPE_MAX VARCHAR2(256) NOT NULL,
CHANNEL_MIN VARCHAR2(256) NOT NULL,
CHANNEL_MAX VARCHAR2(256) NOT NULL,
ROGUE_TYPE_MIN VARCHAR2(256) NOT NULL,
ROGUE_TYPE_MAX VARCHAR2(256) NOT NULL,
ENCRYPTION_MODE_MIN VARCHAR2(256) NOT NULL,
ENCRYPTION_MODE_MAX VARCHAR2(256) NOT NULL,
SIGNAL_STRENGTH_MIN VARCHAR2(256) NOT NULL,
SIGNAL_STRENGTH_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDRogueInfoTest_THRESH ADD constraint PK_RZDRogueInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDRogueInfoTest_THRESH ON RZDRogueInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDRogueInfoTest ON RZDRogueInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDRogueInfoTest ON RZDRogueInfoTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDWLANInfoTest CASCADE CONSTRAINTS;
CREATE TABLE RZDWLANInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AUTHORIZED_CLIENT_DEVICE Number(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_ST varchar2(32) NOT NULL,
TRANSMITTED_DATA Number(20,4) NOT NULL,
TRANSMITTED_DATA_ST varchar2(32) NOT NULL,
RECEIVED_DATA Number(20,4) NOT NULL,
RECEIVED_DATA_ST varchar2(32) NOT NULL,
TRANSMITTED_PACKET Number(20,4) NOT NULL,
TRANSMITTED_PACKET_ST varchar2(32) NOT NULL,
RECEIVED_PACKET Number(20,4) NOT NULL,
RECEIVED_PACKET_ST varchar2(32) NOT NULL,
TRANSMITTED_DATA_LAN Number(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_ST varchar2(32) NOT NULL,
RECEIVED_DATA_LAN Number(20,4) NOT NULL,
RECEIVED_DATA_LAN_ST varchar2(32) NOT NULL,
TOTAL_AUTHENTICATION Number(20,4) NOT NULL,
TOTAL_AUTHENTICATION_ST varchar2(32) NOT NULL,
SUCCESS_AUTHENTICATION Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_ST varchar2(32) NOT NULL,
FAILED_AUTHENTICATION Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_ST varchar2(32) NOT NULL,
SUCCESS_AUTHEN_PERCENT Number(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDWLANInfoTest ON RZDWLANInfoTest(MSMT_TIME);
ALTER TABLE RZDWLANInfoTest ADD constraint PK_RZDWLANInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDWLANInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDWLANInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AUTHORIZED_CLIENT_DEVICE_MIN Number(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MAX Number(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_STCNT varchar2(32) NOT NULL,
TRANSMITTED_DATA_MIN Number(20,4) NOT NULL,
TRANSMITTED_DATA_MAX Number(20,4) NOT NULL,
TRANSMITTED_DATA_STCNT varchar2(32) NOT NULL,
RECEIVED_DATA_MIN Number(20,4) NOT NULL,
RECEIVED_DATA_MAX Number(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar2(32) NOT NULL,
TRANSMITTED_PACKET_MIN Number(20,4) NOT NULL,
TRANSMITTED_PACKET_MAX Number(20,4) NOT NULL,
TRANSMITTED_PACKET_STCNT varchar2(32) NOT NULL,
RECEIVED_PACKET_MIN Number(20,4) NOT NULL,
RECEIVED_PACKET_MAX Number(20,4) NOT NULL,
RECEIVED_PACKET_STCNT varchar2(32) NOT NULL,
TRANSMITTED_DATA_LAN_MIN Number(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_MAX Number(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_STCNT varchar2(32) NOT NULL,
RECEIVED_DATA_LAN_MIN Number(20,4) NOT NULL,
RECEIVED_DATA_LAN_MAX Number(20,4) NOT NULL,
RECEIVED_DATA_LAN_STCNT varchar2(32) NOT NULL,
TOTAL_AUTHENTICATION_MIN Number(20,4) NOT NULL,
TOTAL_AUTHENTICATION_MAX Number(20,4) NOT NULL,
TOTAL_AUTHENTICATION_STCNT varchar2(32) NOT NULL,
SUCCESS_AUTHENTICATION_MIN Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_MAX Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_STCNT varchar2(32) NOT NULL,
FAILED_AUTHENTICATION_MIN Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_MAX Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_STCNT varchar2(32) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MIN Number(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MAX Number(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDWLANInfoTest_TREND ADD constraint PK_RZDWLANInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDWLANInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDWLANInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AUTHORIZED_CLIENT_DEVICE_MIN VARCHAR2(256) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_MAX VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_MIN VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_LAN_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_LAN_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DATA_LAN_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DATA_LAN_MAX VARCHAR2(256) NOT NULL,
TOTAL_AUTHENTICATION_MIN VARCHAR2(256) NOT NULL,
TOTAL_AUTHENTICATION_MAX VARCHAR2(256) NOT NULL,
SUCCESS_AUTHENTICATION_MIN VARCHAR2(256) NOT NULL,
SUCCESS_AUTHENTICATION_MAX VARCHAR2(256) NOT NULL,
FAILED_AUTHENTICATION_MIN VARCHAR2(256) NOT NULL,
FAILED_AUTHENTICATION_MAX VARCHAR2(256) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MIN VARCHAR2(256) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDWLANInfoTest_THRESH ADD constraint PK_RZDWLANInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDWLANInfoTest_THRESH ON RZDWLANInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDWLANInfoTest ON RZDWLANInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDWLANInfoTest ON RZDWLANInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDUserInfoTest CASCADE CONSTRAINTS;
CREATE TABLE RZDUserInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RADIO_TYPE Number(20,4) NOT NULL,
RADIO_TYPE_ST varchar2(32) NOT NULL,
TRANSMITTED_PACKET Number(20,4) NOT NULL,
TRANSMITTED_PACKET_ST varchar2(32) NOT NULL,
RECEIVED_PACKET Number(20,4) NOT NULL,
RECEIVED_PACKET_ST varchar2(32) NOT NULL,
TRANSMITTED_DATA Number(20,4) NOT NULL,
TRANSMITTED_DATA_ST varchar2(32) NOT NULL,
RECEIVED_DATA Number(20,4) NOT NULL,
RECEIVED_DATA_ST varchar2(32) NOT NULL,
TRANSMITTED_DROPPKT Number(20,4) NOT NULL,
TRANSMITTED_DROPPKT_ST varchar2(32) NOT NULL,
RECEIVED_DROPPKT Number(20,4) NOT NULL,
RECEIVED_DROPPKT_ST varchar2(32) NOT NULL,
TRANSMITTED_ERRORPKT Number(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_ST varchar2(32) NOT NULL,
RECEIVED_ERRORPKT Number(20,4) NOT NULL,
RECEIVED_ERRORPKT_ST varchar2(32) NOT NULL,
TRANSMITTED_RETRIES Number(20,4) NOT NULL,
TRANSMITTED_RETRIES_ST varchar2(32) NOT NULL,
TRANSMITTED_RETRYDATA Number(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_ST varchar2(32) NOT NULL,
SIGNALNOISE_RATIO Number(20,4) NOT NULL,
SIGNALNOISE_RATIO_ST varchar2(32) NOT NULL,
SIGNAL_STRENGTH Number(20,4) NOT NULL,
SIGNAL_STRENGTH_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDUserInfoTest ON RZDUserInfoTest(MSMT_TIME);
ALTER TABLE RZDUserInfoTest ADD constraint PK_RZDUserInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDUserInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDUserInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RADIO_TYPE_MIN Number(20,4) NOT NULL,
RADIO_TYPE_MAX Number(20,4) NOT NULL,
RADIO_TYPE_STCNT varchar2(32) NOT NULL,
TRANSMITTED_PACKET_MIN Number(20,4) NOT NULL,
TRANSMITTED_PACKET_MAX Number(20,4) NOT NULL,
TRANSMITTED_PACKET_STCNT varchar2(32) NOT NULL,
RECEIVED_PACKET_MIN Number(20,4) NOT NULL,
RECEIVED_PACKET_MAX Number(20,4) NOT NULL,
RECEIVED_PACKET_STCNT varchar2(32) NOT NULL,
TRANSMITTED_DATA_MIN Number(20,4) NOT NULL,
TRANSMITTED_DATA_MAX Number(20,4) NOT NULL,
TRANSMITTED_DATA_STCNT varchar2(32) NOT NULL,
RECEIVED_DATA_MIN Number(20,4) NOT NULL,
RECEIVED_DATA_MAX Number(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar2(32) NOT NULL,
TRANSMITTED_DROPPKT_MIN Number(20,4) NOT NULL,
TRANSMITTED_DROPPKT_MAX Number(20,4) NOT NULL,
TRANSMITTED_DROPPKT_STCNT varchar2(32) NOT NULL,
RECEIVED_DROPPKT_MIN Number(20,4) NOT NULL,
RECEIVED_DROPPKT_MAX Number(20,4) NOT NULL,
RECEIVED_DROPPKT_STCNT varchar2(32) NOT NULL,
TRANSMITTED_ERRORPKT_MIN Number(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_MAX Number(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_STCNT varchar2(32) NOT NULL,
RECEIVED_ERRORPKT_MIN Number(20,4) NOT NULL,
RECEIVED_ERRORPKT_MAX Number(20,4) NOT NULL,
RECEIVED_ERRORPKT_STCNT varchar2(32) NOT NULL,
TRANSMITTED_RETRIES_MIN Number(20,4) NOT NULL,
TRANSMITTED_RETRIES_MAX Number(20,4) NOT NULL,
TRANSMITTED_RETRIES_STCNT varchar2(32) NOT NULL,
TRANSMITTED_RETRYDATA_MIN Number(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_MAX Number(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_STCNT varchar2(32) NOT NULL,
SIGNALNOISE_RATIO_MIN Number(20,4) NOT NULL,
SIGNALNOISE_RATIO_MAX Number(20,4) NOT NULL,
SIGNALNOISE_RATIO_STCNT varchar2(32) NOT NULL,
SIGNAL_STRENGTH_MIN Number(20,4) NOT NULL,
SIGNAL_STRENGTH_MAX Number(20,4) NOT NULL,
SIGNAL_STRENGTH_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDUserInfoTest_TREND ADD constraint PK_RZDUserInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDUserInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDUserInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RADIO_TYPE_MIN VARCHAR2(256) NOT NULL,
RADIO_TYPE_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_MAX VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_MIN VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_DROPPKT_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_DROPPKT_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DROPPKT_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DROPPKT_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_ERRORPKT_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_ERRORPKT_MAX VARCHAR2(256) NOT NULL,
RECEIVED_ERRORPKT_MIN VARCHAR2(256) NOT NULL,
RECEIVED_ERRORPKT_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRIES_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRIES_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRYDATA_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_RETRYDATA_MAX VARCHAR2(256) NOT NULL,
SIGNALNOISE_RATIO_MIN VARCHAR2(256) NOT NULL,
SIGNALNOISE_RATIO_MAX VARCHAR2(256) NOT NULL,
SIGNAL_STRENGTH_MIN VARCHAR2(256) NOT NULL,
SIGNAL_STRENGTH_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDUserInfoTest_THRESH ADD constraint PK_RZDUserInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDUserInfoTest_THRESH ON RZDUserInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDUserInfoTest ON RZDUserInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDUserInfoTest ON RZDUserInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDApUpTimeTest CASCADE CONSTRAINTS;
CREATE TABLE RZDApUpTimeTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REBOOT Number(20,4) NOT NULL,
REBOOT_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL,
TOTAL_UPTIME Number(20,4) NOT NULL,
TOTAL_UPTIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDApUpTimeTest ON RZDApUpTimeTest(MSMT_TIME);
ALTER TABLE RZDApUpTimeTest ADD constraint PK_RZDApUpTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApUpTimeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDApUpTimeTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REBOOT_MIN Number(20,4) NOT NULL,
REBOOT_MAX Number(20,4) NOT NULL,
REBOOT_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL,
TOTAL_UPTIME_MIN Number(20,4) NOT NULL,
TOTAL_UPTIME_MAX Number(20,4) NOT NULL,
TOTAL_UPTIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDApUpTimeTest_TREND ADD constraint PK_RZDApUpTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApUpTimeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDApUpTimeTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REBOOT_MIN VARCHAR2(256) NOT NULL,
REBOOT_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL,
TOTAL_UPTIME_MIN VARCHAR2(256) NOT NULL,
TOTAL_UPTIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDApUpTimeTest_THRESH ADD constraint PK_RZDApUpTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApUpTimeTest_THRESH ON RZDApUpTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApUpTimeTest ON RZDApUpTimeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApUpTimeTest ON RZDApUpTimeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDApInfoTest CASCADE CONSTRAINTS;
CREATE TABLE RZDApInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_RADIO Number(20,4) NOT NULL,
TOTAL_RADIO_ST varchar2(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_ST varchar2(32) NOT NULL,
AP_STATUS Number(20,4) NOT NULL,
AP_STATUS_ST varchar2(32) NOT NULL,
CPU_UTILIZATION Number(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar2(32) NOT NULL,
MEMORY_UTILIZATION Number(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar2(32) NOT NULL,
CLIENT_RECEIVEDATA_AP Number(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_ST varchar2(32) NOT NULL,
CLIENT_SENDDATA_AP Number(20,4) NOT NULL,
CLIENT_SENDDATA_AP_ST varchar2(32) NOT NULL,
TRANSMITTED_DATA_ON_LAN Number(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_ST varchar2(32) NOT NULL,
RECEIVED_DATA_ON_LAN Number(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_ST varchar2(32) NOT NULL,
TRANSMITTED_PACKET_LAN Number(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_ST varchar2(32) NOT NULL,
RECEIVED_PACKET_LAN Number(20,4) NOT NULL,
RECEIVED_PACKET_LAN_ST varchar2(32) NOT NULL,
TRANSMITTED_UCASTPKT_LAN Number(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_ST varchar2(32) NOT NULL,
RECEIVED_UCASTPKT_LAN Number(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_ST varchar2(32) NOT NULL,
TRANSMITTED_MCASTPKT_LAN Number(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_ST varchar2(32) NOT NULL,
RECEIEVED_MCASTPKT_LAN Number(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDApInfoTest ON RZDApInfoTest(MSMT_TIME);
ALTER TABLE RZDApInfoTest ADD constraint PK_RZDApInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDApInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_RADIO_MIN Number(20,4) NOT NULL,
TOTAL_RADIO_MAX Number(20,4) NOT NULL,
TOTAL_RADIO_STCNT varchar2(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX Number(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_STCNT varchar2(32) NOT NULL,
AP_STATUS_MIN Number(20,4) NOT NULL,
AP_STATUS_MAX Number(20,4) NOT NULL,
AP_STATUS_STCNT varchar2(32) NOT NULL,
CPU_UTILIZATION_MIN Number(20,4) NOT NULL,
CPU_UTILIZATION_MAX Number(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar2(32) NOT NULL,
MEMORY_UTILIZATION_MIN Number(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX Number(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar2(32) NOT NULL,
CLIENT_RECEIVEDATA_AP_MIN Number(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_MAX Number(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_STCNT varchar2(32) NOT NULL,
CLIENT_SENDDATA_AP_MIN Number(20,4) NOT NULL,
CLIENT_SENDDATA_AP_MAX Number(20,4) NOT NULL,
CLIENT_SENDDATA_AP_STCNT varchar2(32) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MIN Number(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MAX Number(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_STCNT varchar2(32) NOT NULL,
RECEIVED_DATA_ON_LAN_MIN Number(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_MAX Number(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_STCNT varchar2(32) NOT NULL,
TRANSMITTED_PACKET_LAN_MIN Number(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_MAX Number(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_STCNT varchar2(32) NOT NULL,
RECEIVED_PACKET_LAN_MIN Number(20,4) NOT NULL,
RECEIVED_PACKET_LAN_MAX Number(20,4) NOT NULL,
RECEIVED_PACKET_LAN_STCNT varchar2(32) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MIN Number(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MAX Number(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_STCNT varchar2(32) NOT NULL,
RECEIVED_UCASTPKT_LAN_MIN Number(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_MAX Number(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_STCNT varchar2(32) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MIN Number(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MAX Number(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_STCNT varchar2(32) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MIN Number(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MAX Number(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDApInfoTest_TREND ADD constraint PK_RZDApInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDApInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_RADIO_MIN VARCHAR2(256) NOT NULL,
TOTAL_RADIO_MAX VARCHAR2(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN VARCHAR2(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX VARCHAR2(256) NOT NULL,
AP_STATUS_MIN VARCHAR2(256) NOT NULL,
AP_STATUS_MAX VARCHAR2(256) NOT NULL,
CPU_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
CLIENT_RECEIVEDATA_AP_MIN VARCHAR2(256) NOT NULL,
CLIENT_RECEIVEDATA_AP_MAX VARCHAR2(256) NOT NULL,
CLIENT_SENDDATA_AP_MIN VARCHAR2(256) NOT NULL,
CLIENT_SENDDATA_AP_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MAX VARCHAR2(256) NOT NULL,
RECEIVED_DATA_ON_LAN_MIN VARCHAR2(256) NOT NULL,
RECEIVED_DATA_ON_LAN_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_LAN_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_PACKET_LAN_MAX VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_LAN_MIN VARCHAR2(256) NOT NULL,
RECEIVED_PACKET_LAN_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MAX VARCHAR2(256) NOT NULL,
RECEIVED_UCASTPKT_LAN_MIN VARCHAR2(256) NOT NULL,
RECEIVED_UCASTPKT_LAN_MAX VARCHAR2(256) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MIN VARCHAR2(256) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MAX VARCHAR2(256) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MIN VARCHAR2(256) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDApInfoTest_THRESH ADD constraint PK_RZDApInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApInfoTest_THRESH ON RZDApInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApInfoTest ON RZDApInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApInfoTest ON RZDApInfoTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDApRadioTest CASCADE CONSTRAINTS;
CREATE TABLE RZDApRadioTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESOURCE_UTILIZATION Number(20,4) NOT NULL,
RESOURCE_UTILIZATION_ST varchar2(32) NOT NULL,
TRANSMIT_PACKET Number(20,4) NOT NULL,
TRANSMIT_PACKET_ST varchar2(32) NOT NULL,
RECEIEVED_PACKET Number(20,4) NOT NULL,
RECEIEVED_PACKET_ST varchar2(32) NOT NULL,
TRANSMIT_DATA Number(20,4) NOT NULL,
TRANSMIT_DATA_ST varchar2(32) NOT NULL,
RECEIEVED_DATA Number(20,4) NOT NULL,
RECEIEVED_DATA_ST varchar2(32) NOT NULL,
TRANSMIT_MCAST_PACKET Number(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_ST varchar2(32) NOT NULL,
RECEIVED_MCAST_PACKET Number(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_ST varchar2(32) NOT NULL,
FAILED_TRANSMIT_PACKET Number(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_ST varchar2(32) NOT NULL,
RETRY_TRANSMIT_PACKET Number(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_ST varchar2(32) NOT NULL,
SUCCESS_AUTHENTICATION Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_ST varchar2(32) NOT NULL,
FAILED_AUTHENTICATION Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_ST varchar2(32) NOT NULL,
TRANSMIT_POWER Number(20,4) NOT NULL,
TRANSMIT_POWER_ST varchar2(32) NOT NULL,
POWER_MGT Number(20,4) NOT NULL,
POWER_MGT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_RZDApRadioTest ON RZDApRadioTest(MSMT_TIME);
ALTER TABLE RZDApRadioTest ADD constraint PK_RZDApRadioTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApRadioTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RZDApRadioTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESOURCE_UTILIZATION_MIN Number(20,4) NOT NULL,
RESOURCE_UTILIZATION_MAX Number(20,4) NOT NULL,
RESOURCE_UTILIZATION_STCNT varchar2(32) NOT NULL,
TRANSMIT_PACKET_MIN Number(20,4) NOT NULL,
TRANSMIT_PACKET_MAX Number(20,4) NOT NULL,
TRANSMIT_PACKET_STCNT varchar2(32) NOT NULL,
RECEIEVED_PACKET_MIN Number(20,4) NOT NULL,
RECEIEVED_PACKET_MAX Number(20,4) NOT NULL,
RECEIEVED_PACKET_STCNT varchar2(32) NOT NULL,
TRANSMIT_DATA_MIN Number(20,4) NOT NULL,
TRANSMIT_DATA_MAX Number(20,4) NOT NULL,
TRANSMIT_DATA_STCNT varchar2(32) NOT NULL,
RECEIEVED_DATA_MIN Number(20,4) NOT NULL,
RECEIEVED_DATA_MAX Number(20,4) NOT NULL,
RECEIEVED_DATA_STCNT varchar2(32) NOT NULL,
TRANSMIT_MCAST_PACKET_MIN Number(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_MAX Number(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_STCNT varchar2(32) NOT NULL,
RECEIVED_MCAST_PACKET_MIN Number(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_MAX Number(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_STCNT varchar2(32) NOT NULL,
FAILED_TRANSMIT_PACKET_MIN Number(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_MAX Number(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_STCNT varchar2(32) NOT NULL,
RETRY_TRANSMIT_PACKET_MIN Number(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_MAX Number(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_STCNT varchar2(32) NOT NULL,
SUCCESS_AUTHENTICATION_MIN Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_MAX Number(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_STCNT varchar2(32) NOT NULL,
FAILED_AUTHENTICATION_MIN Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_MAX Number(20,4) NOT NULL,
FAILED_AUTHENTICATION_STCNT varchar2(32) NOT NULL,
TRANSMIT_POWER_MIN Number(20,4) NOT NULL,
TRANSMIT_POWER_MAX Number(20,4) NOT NULL,
TRANSMIT_POWER_STCNT varchar2(32) NOT NULL,
POWER_MGT_MIN Number(20,4) NOT NULL,
POWER_MGT_MAX Number(20,4) NOT NULL,
POWER_MGT_STCNT varchar2(32) NOT NULL);

ALTER TABLE RZDApRadioTest_TREND ADD constraint PK_RZDApRadioTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApRadioTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RZDApRadioTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESOURCE_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
RESOURCE_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_PACKET_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_PACKET_MAX VARCHAR2(256) NOT NULL,
RECEIEVED_PACKET_MIN VARCHAR2(256) NOT NULL,
RECEIEVED_PACKET_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_DATA_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_DATA_MAX VARCHAR2(256) NOT NULL,
RECEIEVED_DATA_MIN VARCHAR2(256) NOT NULL,
RECEIEVED_DATA_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_MCAST_PACKET_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_MCAST_PACKET_MAX VARCHAR2(256) NOT NULL,
RECEIVED_MCAST_PACKET_MIN VARCHAR2(256) NOT NULL,
RECEIVED_MCAST_PACKET_MAX VARCHAR2(256) NOT NULL,
FAILED_TRANSMIT_PACKET_MIN VARCHAR2(256) NOT NULL,
FAILED_TRANSMIT_PACKET_MAX VARCHAR2(256) NOT NULL,
RETRY_TRANSMIT_PACKET_MIN VARCHAR2(256) NOT NULL,
RETRY_TRANSMIT_PACKET_MAX VARCHAR2(256) NOT NULL,
SUCCESS_AUTHENTICATION_MIN VARCHAR2(256) NOT NULL,
SUCCESS_AUTHENTICATION_MAX VARCHAR2(256) NOT NULL,
FAILED_AUTHENTICATION_MIN VARCHAR2(256) NOT NULL,
FAILED_AUTHENTICATION_MAX VARCHAR2(256) NOT NULL,
TRANSMIT_POWER_MIN VARCHAR2(256) NOT NULL,
TRANSMIT_POWER_MAX VARCHAR2(256) NOT NULL,
POWER_MGT_MIN VARCHAR2(256) NOT NULL,
POWER_MGT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE RZDApRadioTest_THRESH ADD constraint PK_RZDApRadioTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApRadioTest_THRESH ON RZDApRadioTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApRadioTest ON RZDApRadioTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApRadioTest ON RZDApRadioTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwCpuUtTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwCpuUtTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CPU_UTIL_5SEC Number(20,4) NOT NULL,
CPU_UTIL_5SEC_ST varchar2(32) NOT NULL,
CPU_UTIL_1MIN Number(20,4) NOT NULL,
CPU_UTIL_1MIN_ST varchar2(32) NOT NULL,
CPU_UTIL_5MIN Number(20,4) NOT NULL,
CPU_UTIL_5MIN_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwCpuUtTest ON DellSwCpuUtTest(MSMT_TIME);
ALTER TABLE DellSwCpuUtTest ADD constraint PK_DellSwCpuUtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwCpuUtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwCpuUtTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CPU_UTIL_5SEC_MIN Number(20,4) NOT NULL,
CPU_UTIL_5SEC_MAX Number(20,4) NOT NULL,
CPU_UTIL_5SEC_STCNT varchar2(32) NOT NULL,
CPU_UTIL_1MIN_MIN Number(20,4) NOT NULL,
CPU_UTIL_1MIN_MAX Number(20,4) NOT NULL,
CPU_UTIL_1MIN_STCNT varchar2(32) NOT NULL,
CPU_UTIL_5MIN_MIN Number(20,4) NOT NULL,
CPU_UTIL_5MIN_MAX Number(20,4) NOT NULL,
CPU_UTIL_5MIN_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwCpuUtTest_TREND ADD constraint PK_DellSwCpuUtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwCpuUtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwCpuUtTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CPU_UTIL_5SEC_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_5SEC_MAX VARCHAR2(256) NOT NULL,
CPU_UTIL_1MIN_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_1MIN_MAX VARCHAR2(256) NOT NULL,
CPU_UTIL_5MIN_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_5MIN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwCpuUtTest_THRESH ADD constraint PK_DellSwCpuUtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwCpuUtTest_THRESH ON DellSwCpuUtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwCpuUtTest ON DellSwCpuUtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwCpuUtTest ON DellSwCpuUtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwFanStTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwFanStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FAN_STATUS Number(20,4) NOT NULL,
FAN_STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwFanStTest ON DellSwFanStTest(MSMT_TIME);
ALTER TABLE DellSwFanStTest ADD constraint PK_DellSwFanStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwFanStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwFanStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FAN_STATUS_MIN Number(20,4) NOT NULL,
FAN_STATUS_MAX Number(20,4) NOT NULL,
FAN_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwFanStTest_TREND ADD constraint PK_DellSwFanStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwFanStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwFanStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FAN_STATUS_MIN VARCHAR2(256) NOT NULL,
FAN_STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwFanStTest_THRESH ADD constraint PK_DellSwFanStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwFanStTest_THRESH ON DellSwFanStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwFanStTest ON DellSwFanStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwFanStTest ON DellSwFanStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwMemUTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwMemUTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_MEMORY Number(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar2(32) NOT NULL,
UTILIZED_MEMORY Number(20,4) NOT NULL,
UTILIZED_MEMORY_ST varchar2(32) NOT NULL,
FREE_MEMORY Number(20,4) NOT NULL,
FREE_MEMORY_ST varchar2(32) NOT NULL,
MEMORY_UTIL Number(20,4) NOT NULL,
MEMORY_UTIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwMemUTest ON DellSwMemUTest(MSMT_TIME);
ALTER TABLE DellSwMemUTest ADD constraint PK_DellSwMemUTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwMemUTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwMemUTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_MEMORY_MIN Number(20,4) NOT NULL,
TOTAL_MEMORY_MAX Number(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar2(32) NOT NULL,
UTILIZED_MEMORY_MIN Number(20,4) NOT NULL,
UTILIZED_MEMORY_MAX Number(20,4) NOT NULL,
UTILIZED_MEMORY_STCNT varchar2(32) NOT NULL,
FREE_MEMORY_MIN Number(20,4) NOT NULL,
FREE_MEMORY_MAX Number(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar2(32) NOT NULL,
MEMORY_UTIL_MIN Number(20,4) NOT NULL,
MEMORY_UTIL_MAX Number(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwMemUTest_TREND ADD constraint PK_DellSwMemUTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwMemUTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwMemUTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_MEMORY_MIN VARCHAR2(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR2(256) NOT NULL,
UTILIZED_MEMORY_MIN VARCHAR2(256) NOT NULL,
UTILIZED_MEMORY_MAX VARCHAR2(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR2(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR2(256) NOT NULL,
MEMORY_UTIL_MIN VARCHAR2(256) NOT NULL,
MEMORY_UTIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwMemUTest_THRESH ADD constraint PK_DellSwMemUTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwMemUTest_THRESH ON DellSwMemUTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwMemUTest ON DellSwMemUTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwMemUTest ON DellSwMemUTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwPortDtTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwPortDtTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ADMIN_STATUS Number(20,4) NOT NULL,
ADMIN_STATUS_ST varchar2(32) NOT NULL,
OPERATIONAL_STATUS Number(20,4) NOT NULL,
OPERATIONAL_STATUS_ST varchar2(32) NOT NULL,
RECD_POWER_SIGNAL Number(20,4) NOT NULL,
RECD_POWER_SIGNAL_ST varchar2(32) NOT NULL,
TXMT_POWER_SIGNAL Number(20,4) NOT NULL,
TXMT_POWER_SIGNAL_ST varchar2(32) NOT NULL,
RECD_TEMPERATURE Number(20,4) NOT NULL,
RECD_TEMPERATURE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwPortDtTest ON DellSwPortDtTest(MSMT_TIME);
ALTER TABLE DellSwPortDtTest ADD constraint PK_DellSwPortDtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwPortDtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwPortDtTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ADMIN_STATUS_MIN Number(20,4) NOT NULL,
ADMIN_STATUS_MAX Number(20,4) NOT NULL,
ADMIN_STATUS_STCNT varchar2(32) NOT NULL,
OPERATIONAL_STATUS_MIN Number(20,4) NOT NULL,
OPERATIONAL_STATUS_MAX Number(20,4) NOT NULL,
OPERATIONAL_STATUS_STCNT varchar2(32) NOT NULL,
RECD_POWER_SIGNAL_MIN Number(20,4) NOT NULL,
RECD_POWER_SIGNAL_MAX Number(20,4) NOT NULL,
RECD_POWER_SIGNAL_STCNT varchar2(32) NOT NULL,
TXMT_POWER_SIGNAL_MIN Number(20,4) NOT NULL,
TXMT_POWER_SIGNAL_MAX Number(20,4) NOT NULL,
TXMT_POWER_SIGNAL_STCNT varchar2(32) NOT NULL,
RECD_TEMPERATURE_MIN Number(20,4) NOT NULL,
RECD_TEMPERATURE_MAX Number(20,4) NOT NULL,
RECD_TEMPERATURE_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwPortDtTest_TREND ADD constraint PK_DellSwPortDtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwPortDtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwPortDtTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ADMIN_STATUS_MIN VARCHAR2(256) NOT NULL,
ADMIN_STATUS_MAX VARCHAR2(256) NOT NULL,
OPERATIONAL_STATUS_MIN VARCHAR2(256) NOT NULL,
OPERATIONAL_STATUS_MAX VARCHAR2(256) NOT NULL,
RECD_POWER_SIGNAL_MIN VARCHAR2(256) NOT NULL,
RECD_POWER_SIGNAL_MAX VARCHAR2(256) NOT NULL,
TXMT_POWER_SIGNAL_MIN VARCHAR2(256) NOT NULL,
TXMT_POWER_SIGNAL_MAX VARCHAR2(256) NOT NULL,
RECD_TEMPERATURE_MIN VARCHAR2(256) NOT NULL,
RECD_TEMPERATURE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwPortDtTest_THRESH ADD constraint PK_DellSwPortDtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwPortDtTest_THRESH ON DellSwPortDtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwPortDtTest ON DellSwPortDtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwPortDtTest ON DellSwPortDtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwPSSTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwPSSTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PS_STATUS Number(20,4) NOT NULL,
PS_STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwPSSTest ON DellSwPSSTest(MSMT_TIME);
ALTER TABLE DellSwPSSTest ADD constraint PK_DellSwPSSTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwPSSTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwPSSTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PS_STATUS_MIN Number(20,4) NOT NULL,
PS_STATUS_MAX Number(20,4) NOT NULL,
PS_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwPSSTest_TREND ADD constraint PK_DellSwPSSTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwPSSTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwPSSTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PS_STATUS_MIN VARCHAR2(256) NOT NULL,
PS_STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwPSSTest_THRESH ADD constraint PK_DellSwPSSTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwPSSTest_THRESH ON DellSwPSSTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwPSSTest ON DellSwPSSTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwPSSTest ON DellSwPSSTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwStatusTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwStatusTest ON DellSwStatusTest(MSMT_TIME);
ALTER TABLE DellSwStatusTest ADD constraint PK_DellSwStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwStatusTest_TREND ADD constraint PK_DellSwStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwStatusTest_THRESH ADD constraint PK_DellSwStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwStatusTest_THRESH ON DellSwStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwStatusTest ON DellSwStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwStatusTest ON DellSwStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwTmpStTest CASCADE CONSTRAINTS;
CREATE TABLE DellSwTmpStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TEMPERATURE Number(20,4) NOT NULL,
TEMPERATURE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_DellSwTmpStTest ON DellSwTmpStTest(MSMT_TIME);
ALTER TABLE DellSwTmpStTest ADD constraint PK_DellSwTmpStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwTmpStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DellSwTmpStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TEMPERATURE_MIN Number(20,4) NOT NULL,
TEMPERATURE_MAX Number(20,4) NOT NULL,
TEMPERATURE_STCNT varchar2(32) NOT NULL);

ALTER TABLE DellSwTmpStTest_TREND ADD constraint PK_DellSwTmpStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwTmpStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DellSwTmpStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TEMPERATURE_MIN VARCHAR2(256) NOT NULL,
TEMPERATURE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE DellSwTmpStTest_THRESH ADD constraint PK_DellSwTmpStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwTmpStTest_THRESH ON DellSwTmpStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwTmpStTest ON DellSwTmpStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwTmpStTest ON DellSwTmpStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxBattStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxBattStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BATTERY_STATUS Number(20,4) NOT NULL,
BATTERY_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxBattStTest ON HiVSPGxBattStTest(MSMT_TIME);
ALTER TABLE HiVSPGxBattStTest ADD constraint PK_HiVSPGxBattStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxBattStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxBattStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BATTERY_STATUS_MIN Number(20,4) NOT NULL,
BATTERY_STATUS_MAX Number(20,4) NOT NULL,
BATTERY_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxBattStTest_TREND ADD constraint PK_HiVSPGxBattStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxBattStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxBattStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BATTERY_STATUS_MIN VARCHAR2(256) NOT NULL,
BATTERY_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxBattStTest_THRESH ADD constraint PK_HiVSPGxBattStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxBattStTest_THRESH ON HiVSPGxBattStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxBattStTest ON HiVSPGxBattStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxBattStTest ON HiVSPGxBattStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxCacheStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCacheStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CACHE_STATUS Number(20,4) NOT NULL,
CACHE_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCacheStTest ON HiVSPGxCacheStTest(MSMT_TIME);
ALTER TABLE HiVSPGxCacheStTest ADD constraint PK_HiVSPGxCacheStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCacheStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCacheStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CACHE_STATUS_MIN Number(20,4) NOT NULL,
CACHE_STATUS_MAX Number(20,4) NOT NULL,
CACHE_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxCacheStTest_TREND ADD constraint PK_HiVSPGxCacheStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCacheStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCacheStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CACHE_STATUS_MIN VARCHAR2(256) NOT NULL,
CACHE_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxCacheStTest_THRESH ADD constraint PK_HiVSPGxCacheStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCacheStTest_THRESH ON HiVSPGxCacheStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCacheStTest ON HiVSPGxCacheStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCacheStTest ON HiVSPGxCacheStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxSMStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxSMStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SHARED_MEMORY_STATUS Number(20,4) NOT NULL,
SHARED_MEMORY_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxSMStTest ON HiVSPGxSMStTest(MSMT_TIME);
ALTER TABLE HiVSPGxSMStTest ADD constraint PK_HiVSPGxSMStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxSMStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxSMStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SHARED_MEMORY_STATUS_MIN Number(20,4) NOT NULL,
SHARED_MEMORY_STATUS_MAX Number(20,4) NOT NULL,
SHARED_MEMORY_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxSMStTest_TREND ADD constraint PK_HiVSPGxSMStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxSMStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxSMStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SHARED_MEMORY_STATUS_MIN VARCHAR2(256) NOT NULL,
SHARED_MEMORY_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxSMStTest_THRESH ADD constraint PK_HiVSPGxSMStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxSMStTest_THRESH ON HiVSPGxSMStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxSMStTest ON HiVSPGxSMStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxSMStTest ON HiVSPGxSMStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxPSStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPSStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
POWER_STUPPLY_STATUS Number(20,4) NOT NULL,
POWER_STUPPLY_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxPSStTest ON HiVSPGxPSStTest(MSMT_TIME);
ALTER TABLE HiVSPGxPSStTest ADD constraint PK_HiVSPGxPSStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPSStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPSStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
POWER_STUPPLY_STATUS_MIN Number(20,4) NOT NULL,
POWER_STUPPLY_STATUS_MAX Number(20,4) NOT NULL,
POWER_STUPPLY_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxPSStTest_TREND ADD constraint PK_HiVSPGxPSStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPSStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPSStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
POWER_STUPPLY_STATUS_MIN VARCHAR2(256) NOT NULL,
POWER_STUPPLY_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxPSStTest_THRESH ADD constraint PK_HiVSPGxPSStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPSStTest_THRESH ON HiVSPGxPSStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPSStTest ON HiVSPGxPSStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPSStTest ON HiVSPGxPSStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxProcStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxProcStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PROCESSOR_STATUS Number(20,4) NOT NULL,
PROCESSOR_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxProcStTest ON HiVSPGxProcStTest(MSMT_TIME);
ALTER TABLE HiVSPGxProcStTest ADD constraint PK_HiVSPGxProcStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxProcStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxProcStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PROCESSOR_STATUS_MIN Number(20,4) NOT NULL,
PROCESSOR_STATUS_MAX Number(20,4) NOT NULL,
PROCESSOR_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxProcStTest_TREND ADD constraint PK_HiVSPGxProcStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxProcStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxProcStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PROCESSOR_STATUS_MIN VARCHAR2(256) NOT NULL,
PROCESSOR_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxProcStTest_THRESH ADD constraint PK_HiVSPGxProcStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxProcStTest_THRESH ON HiVSPGxProcStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxProcStTest ON HiVSPGxProcStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxProcStTest ON HiVSPGxProcStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxFanStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxFanStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FAN_STATUS Number(20,4) NOT NULL,
FAN_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxFanStTest ON HiVSPGxFanStTest(MSMT_TIME);
ALTER TABLE HiVSPGxFanStTest ADD constraint PK_HiVSPGxFanStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxFanStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxFanStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FAN_STATUS_MIN Number(20,4) NOT NULL,
FAN_STATUS_MAX Number(20,4) NOT NULL,
FAN_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxFanStTest_TREND ADD constraint PK_HiVSPGxFanStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxFanStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxFanStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FAN_STATUS_MIN VARCHAR2(256) NOT NULL,
FAN_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxFanStTest_THRESH ADD constraint PK_HiVSPGxFanStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxFanStTest_THRESH ON HiVSPGxFanStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxFanStTest ON HiVSPGxFanStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxFanStTest ON HiVSPGxFanStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxDriveStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxDriveStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
DRIVE_STATUS Number(20,4) NOT NULL,
DRIVE_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxDriveStTest ON HiVSPGxDriveStTest(MSMT_TIME);
ALTER TABLE HiVSPGxDriveStTest ADD constraint PK_HiVSPGxDriveStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxDriveStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxDriveStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
DRIVE_STATUS_MIN Number(20,4) NOT NULL,
DRIVE_STATUS_MAX Number(20,4) NOT NULL,
DRIVE_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxDriveStTest_TREND ADD constraint PK_HiVSPGxDriveStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxDriveStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxDriveStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
DRIVE_STATUS_MIN VARCHAR2(256) NOT NULL,
DRIVE_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxDriveStTest_THRESH ADD constraint PK_HiVSPGxDriveStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxDriveStTest_THRESH ON HiVSPGxDriveStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxDriveStTest ON HiVSPGxDriveStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxDriveStTest ON HiVSPGxDriveStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxCntrlStTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCntrlStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CONTROLLER_STATUS Number(20,4) NOT NULL,
CONTROLLER_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest(MSMT_TIME);
ALTER TABLE HiVSPGxCntrlStTest ADD constraint PK_HiVSPGxCntrlStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCntrlStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCntrlStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CONTROLLER_STATUS_MIN Number(20,4) NOT NULL,
CONTROLLER_STATUS_MAX Number(20,4) NOT NULL,
CONTROLLER_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxCntrlStTest_TREND ADD constraint PK_HiVSPGxCntrlStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCntrlStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCntrlStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CONTROLLER_STATUS_MIN VARCHAR2(256) NOT NULL,
CONTROLLER_STATUS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxCntrlStTest_THRESH ADD constraint PK_HiVSPGxCntrlStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCntrlStTest_THRESH ON HiVSPGxCntrlStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxPortTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPortTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IOPS Number(20,4) NOT NULL,
IOPS_ST varchar2(32) NOT NULL,
KBPS Number(20,4) NOT NULL,
KBPS_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxPortTest ON HiVSPGxPortTest(MSMT_TIME);
ALTER TABLE HiVSPGxPortTest ADD constraint PK_HiVSPGxPortTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPortTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPortTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IOPS_MIN Number(20,4) NOT NULL,
IOPS_MAX Number(20,4) NOT NULL,
IOPS_STCNT varchar2(32) NOT NULL,
KBPS_MIN Number(20,4) NOT NULL,
KBPS_MAX Number(20,4) NOT NULL,
KBPS_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxPortTest_TREND ADD constraint PK_HiVSPGxPortTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPortTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPortTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IOPS_MIN VARCHAR2(256) NOT NULL,
IOPS_MAX VARCHAR2(256) NOT NULL,
KBPS_MIN VARCHAR2(256) NOT NULL,
KBPS_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxPortTest_THRESH ADD constraint PK_HiVSPGxPortTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPortTest_THRESH ON HiVSPGxPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPortTest ON HiVSPGxPortTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPortTest ON HiVSPGxPortTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxPGroupTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPGroupTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IOPS Number(20,4) NOT NULL,
IOPS_ST varchar2(32) NOT NULL,
TRANSRATE Number(20,4) NOT NULL,
TRANSRATE_ST varchar2(32) NOT NULL,
READ_IOPS Number(20,4) NOT NULL,
READ_IOPS_ST varchar2(32) NOT NULL,
WRITE_IOPS Number(20,4) NOT NULL,
WRITE_IOPS_ST varchar2(32) NOT NULL,
READ_HIT Number(20,4) NOT NULL,
READ_HIT_ST varchar2(32) NOT NULL,
WRITE_HIT Number(20,4) NOT NULL,
WRITE_HIT_ST varchar2(32) NOT NULL,
C2D_TRANSFER Number(20,4) NOT NULL,
C2D_TRANSFER_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL,
BACKTRANS Number(20,4) NOT NULL,
BACKTRANS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxPGroupTest ON HiVSPGxPGroupTest(MSMT_TIME);
ALTER TABLE HiVSPGxPGroupTest ADD constraint PK_HiVSPGxPGroupTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPGroupTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPGroupTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IOPS_MIN Number(20,4) NOT NULL,
IOPS_MAX Number(20,4) NOT NULL,
IOPS_STCNT varchar2(32) NOT NULL,
TRANSRATE_MIN Number(20,4) NOT NULL,
TRANSRATE_MAX Number(20,4) NOT NULL,
TRANSRATE_STCNT varchar2(32) NOT NULL,
READ_IOPS_MIN Number(20,4) NOT NULL,
READ_IOPS_MAX Number(20,4) NOT NULL,
READ_IOPS_STCNT varchar2(32) NOT NULL,
WRITE_IOPS_MIN Number(20,4) NOT NULL,
WRITE_IOPS_MAX Number(20,4) NOT NULL,
WRITE_IOPS_STCNT varchar2(32) NOT NULL,
READ_HIT_MIN Number(20,4) NOT NULL,
READ_HIT_MAX Number(20,4) NOT NULL,
READ_HIT_STCNT varchar2(32) NOT NULL,
WRITE_HIT_MIN Number(20,4) NOT NULL,
WRITE_HIT_MAX Number(20,4) NOT NULL,
WRITE_HIT_STCNT varchar2(32) NOT NULL,
C2D_TRANSFER_MIN Number(20,4) NOT NULL,
C2D_TRANSFER_MAX Number(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
BACKTRANS_MIN Number(20,4) NOT NULL,
BACKTRANS_MAX Number(20,4) NOT NULL,
BACKTRANS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxPGroupTest_TREND ADD constraint PK_HiVSPGxPGroupTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPGroupTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxPGroupTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IOPS_MIN VARCHAR2(256) NOT NULL,
IOPS_MAX VARCHAR2(256) NOT NULL,
TRANSRATE_MIN VARCHAR2(256) NOT NULL,
TRANSRATE_MAX VARCHAR2(256) NOT NULL,
READ_IOPS_MIN VARCHAR2(256) NOT NULL,
READ_IOPS_MAX VARCHAR2(256) NOT NULL,
WRITE_IOPS_MIN VARCHAR2(256) NOT NULL,
WRITE_IOPS_MAX VARCHAR2(256) NOT NULL,
READ_HIT_MIN VARCHAR2(256) NOT NULL,
READ_HIT_MAX VARCHAR2(256) NOT NULL,
WRITE_HIT_MIN VARCHAR2(256) NOT NULL,
WRITE_HIT_MAX VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL,
BACKTRANS_MIN VARCHAR2(256) NOT NULL,
BACKTRANS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxPGroupTest_THRESH ADD constraint PK_HiVSPGxPGroupTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPGroupTest_THRESH ON HiVSPGxPGroupTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPGroupTest ON HiVSPGxPGroupTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPGroupTest ON HiVSPGxPGroupTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxLunDetTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLunDetTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IOPS Number(20,4) NOT NULL,
IOPS_ST varchar2(32) NOT NULL,
TRANSRATE Number(20,4) NOT NULL,
TRANSRATE_ST varchar2(32) NOT NULL,
SEQ_READ_HIT Number(20,4) NOT NULL,
SEQ_READ_HIT_ST varchar2(32) NOT NULL,
RAND_READ_HIT Number(20,4) NOT NULL,
RAND_READ_HIT_ST varchar2(32) NOT NULL,
SEQ_WRITE_HIT Number(20,4) NOT NULL,
SEQ_WRITE_HIT_ST varchar2(32) NOT NULL,
RAND_WRITE_HIT Number(20,4) NOT NULL,
RAND_WRITE_HIT_ST varchar2(32) NOT NULL,
C2D_TRANSFER Number(20,4) NOT NULL,
C2D_TRANSFER_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxLunDetTest ON HiVSPGxLunDetTest(MSMT_TIME);
ALTER TABLE HiVSPGxLunDetTest ADD constraint PK_HiVSPGxLunDetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxLunDetTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLunDetTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IOPS_MIN Number(20,4) NOT NULL,
IOPS_MAX Number(20,4) NOT NULL,
IOPS_STCNT varchar2(32) NOT NULL,
TRANSRATE_MIN Number(20,4) NOT NULL,
TRANSRATE_MAX Number(20,4) NOT NULL,
TRANSRATE_STCNT varchar2(32) NOT NULL,
SEQ_READ_HIT_MIN Number(20,4) NOT NULL,
SEQ_READ_HIT_MAX Number(20,4) NOT NULL,
SEQ_READ_HIT_STCNT varchar2(32) NOT NULL,
RAND_READ_HIT_MIN Number(20,4) NOT NULL,
RAND_READ_HIT_MAX Number(20,4) NOT NULL,
RAND_READ_HIT_STCNT varchar2(32) NOT NULL,
SEQ_WRITE_HIT_MIN Number(20,4) NOT NULL,
SEQ_WRITE_HIT_MAX Number(20,4) NOT NULL,
SEQ_WRITE_HIT_STCNT varchar2(32) NOT NULL,
RAND_WRITE_HIT_MIN Number(20,4) NOT NULL,
RAND_WRITE_HIT_MAX Number(20,4) NOT NULL,
RAND_WRITE_HIT_STCNT varchar2(32) NOT NULL,
C2D_TRANSFER_MIN Number(20,4) NOT NULL,
C2D_TRANSFER_MAX Number(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxLunDetTest_TREND ADD constraint PK_HiVSPGxLunDetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxLunDetTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLunDetTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IOPS_MIN VARCHAR2(256) NOT NULL,
IOPS_MAX VARCHAR2(256) NOT NULL,
TRANSRATE_MIN VARCHAR2(256) NOT NULL,
TRANSRATE_MAX VARCHAR2(256) NOT NULL,
SEQ_READ_HIT_MIN VARCHAR2(256) NOT NULL,
SEQ_READ_HIT_MAX VARCHAR2(256) NOT NULL,
RAND_READ_HIT_MIN VARCHAR2(256) NOT NULL,
RAND_READ_HIT_MAX VARCHAR2(256) NOT NULL,
SEQ_WRITE_HIT_MIN VARCHAR2(256) NOT NULL,
SEQ_WRITE_HIT_MAX VARCHAR2(256) NOT NULL,
RAND_WRITE_HIT_MIN VARCHAR2(256) NOT NULL,
RAND_WRITE_HIT_MAX VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxLunDetTest_THRESH ADD constraint PK_HiVSPGxLunDetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxLunDetTest_THRESH ON HiVSPGxLunDetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxLunDetTest ON HiVSPGxLunDetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxLunDetTest ON HiVSPGxLunDetTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxLdevDetTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLdevDetTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IOPS Number(20,4) NOT NULL,
IOPS_ST varchar2(32) NOT NULL,
TRANSRATE Number(20,4) NOT NULL,
TRANSRATE_ST varchar2(32) NOT NULL,
READ_IOPS Number(20,4) NOT NULL,
READ_IOPS_ST varchar2(32) NOT NULL,
WRITE_IOPS Number(20,4) NOT NULL,
WRITE_IOPS_ST varchar2(32) NOT NULL,
READ_HIT Number(20,4) NOT NULL,
READ_HIT_ST varchar2(32) NOT NULL,
WRITE_HIT Number(20,4) NOT NULL,
WRITE_HIT_ST varchar2(32) NOT NULL,
C2D_TRANSFER Number(20,4) NOT NULL,
C2D_TRANSFER_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL,
BACKTRANS Number(20,4) NOT NULL,
BACKTRANS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest(MSMT_TIME);
ALTER TABLE HiVSPGxLdevDetTest ADD constraint PK_HiVSPGxLdevDetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxLdevDetTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLdevDetTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IOPS_MIN Number(20,4) NOT NULL,
IOPS_MAX Number(20,4) NOT NULL,
IOPS_STCNT varchar2(32) NOT NULL,
TRANSRATE_MIN Number(20,4) NOT NULL,
TRANSRATE_MAX Number(20,4) NOT NULL,
TRANSRATE_STCNT varchar2(32) NOT NULL,
READ_IOPS_MIN Number(20,4) NOT NULL,
READ_IOPS_MAX Number(20,4) NOT NULL,
READ_IOPS_STCNT varchar2(32) NOT NULL,
WRITE_IOPS_MIN Number(20,4) NOT NULL,
WRITE_IOPS_MAX Number(20,4) NOT NULL,
WRITE_IOPS_STCNT varchar2(32) NOT NULL,
READ_HIT_MIN Number(20,4) NOT NULL,
READ_HIT_MAX Number(20,4) NOT NULL,
READ_HIT_STCNT varchar2(32) NOT NULL,
WRITE_HIT_MIN Number(20,4) NOT NULL,
WRITE_HIT_MAX Number(20,4) NOT NULL,
WRITE_HIT_STCNT varchar2(32) NOT NULL,
C2D_TRANSFER_MIN Number(20,4) NOT NULL,
C2D_TRANSFER_MAX Number(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
BACKTRANS_MIN Number(20,4) NOT NULL,
BACKTRANS_MAX Number(20,4) NOT NULL,
BACKTRANS_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxLdevDetTest_TREND ADD constraint PK_HiVSPGxLdevDetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxLdevDetTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxLdevDetTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IOPS_MIN VARCHAR2(256) NOT NULL,
IOPS_MAX VARCHAR2(256) NOT NULL,
TRANSRATE_MIN VARCHAR2(256) NOT NULL,
TRANSRATE_MAX VARCHAR2(256) NOT NULL,
READ_IOPS_MIN VARCHAR2(256) NOT NULL,
READ_IOPS_MAX VARCHAR2(256) NOT NULL,
WRITE_IOPS_MIN VARCHAR2(256) NOT NULL,
WRITE_IOPS_MAX VARCHAR2(256) NOT NULL,
READ_HIT_MIN VARCHAR2(256) NOT NULL,
READ_HIT_MAX VARCHAR2(256) NOT NULL,
WRITE_HIT_MIN VARCHAR2(256) NOT NULL,
WRITE_HIT_MAX VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR2(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR2(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR2(256) NOT NULL,
BACKTRANS_MIN VARCHAR2(256) NOT NULL,
BACKTRANS_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxLdevDetTest_THRESH ADD constraint PK_HiVSPGxLdevDetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxLdevDetTest_THRESH ON HiVSPGxLdevDetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxCPRateTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCPRateTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
WRITE_PENDING_RATE Number(20,4) NOT NULL,
WRITE_PENDING_RATE_ST varchar2(32) NOT NULL,
CACHE_USAGE_RATE Number(20,4) NOT NULL,
CACHE_USAGE_RATE_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCPRateTest ON HiVSPGxCPRateTest(MSMT_TIME);
ALTER TABLE HiVSPGxCPRateTest ADD constraint PK_HiVSPGxCPRateTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCPRateTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCPRateTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
WRITE_PENDING_RATE_MIN Number(20,4) NOT NULL,
WRITE_PENDING_RATE_MAX Number(20,4) NOT NULL,
WRITE_PENDING_RATE_STCNT varchar2(32) NOT NULL,
CACHE_USAGE_RATE_MIN Number(20,4) NOT NULL,
CACHE_USAGE_RATE_MAX Number(20,4) NOT NULL,
CACHE_USAGE_RATE_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxCPRateTest_TREND ADD constraint PK_HiVSPGxCPRateTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCPRateTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCPRateTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
WRITE_PENDING_RATE_MIN VARCHAR2(256) NOT NULL,
WRITE_PENDING_RATE_MAX VARCHAR2(256) NOT NULL,
CACHE_USAGE_RATE_MIN VARCHAR2(256) NOT NULL,
CACHE_USAGE_RATE_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxCPRateTest_THRESH ADD constraint PK_HiVSPGxCPRateTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCPRateTest_THRESH ON HiVSPGxCPRateTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCPRateTest ON HiVSPGxCPRateTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCPRateTest ON HiVSPGxCPRateTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxCtrlTest CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCtrlTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
USAGE_RATE Number(20,4) NOT NULL,
USAGE_RATE_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCtrlTest ON HiVSPGxCtrlTest(MSMT_TIME);
ALTER TABLE HiVSPGxCtrlTest ADD constraint PK_HiVSPGxCtrlTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCtrlTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCtrlTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
USAGE_RATE_MIN Number(20,4) NOT NULL,
USAGE_RATE_MAX Number(20,4) NOT NULL,
USAGE_RATE_STCNT varchar2(32) NOT NULL);
ALTER TABLE HiVSPGxCtrlTest_TREND ADD constraint PK_HiVSPGxCtrlTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCtrlTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HiVSPGxCtrlTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
USAGE_RATE_MIN VARCHAR2(256) NOT NULL,
USAGE_RATE_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE HiVSPGxCtrlTest_THRESH ADD constraint PK_HiVSPGxCtrlTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCtrlTest_THRESH ON HiVSPGxCtrlTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCtrlTest ON HiVSPGxCtrlTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCtrlTest ON HiVSPGxCtrlTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSysLogSvrTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogSvrTest ON EgSysLogSvrTest(MSMT_TIME);
ALTER TABLE EgSysLogSvrTest ADD constraint PK_EgSysLogSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogSvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE EgSysLogSvrTest_TREND ADD constraint PK_EgSysLogSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogSvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogSvrTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL
,MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogSvrTest_THRESH ADD constraint PK_EgSysLogSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogSvrTest_THRESH ON EgSysLogSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogSvrTest ON EgSysLogSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogSvrTest ON EgSysLogSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EgSysLogAppTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogAppTest ON EgSysLogAppTest(MSMT_TIME);
ALTER TABLE EgSysLogAppTest ADD constraint PK_EgSysLogAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE EgSysLogAppTest_TREND ADD constraint PK_EgSysLogAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogAppTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogAppTest_THRESH ADD constraint PK_EgSysLogAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogAppTest_THRESH ON EgSysLogAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogAppTest ON EgSysLogAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogAppTest ON EgSysLogAppTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSyslogFilterTest CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterTest ON EgSyslogFilterTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterTest ADD constraint PK_EgSyslogFilterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT VARCHAR2(32) NOT NULL);



ALTER TABLE EgSyslogFilterTest_TREND ADD constraint PK_EgSyslogFilterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,	
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSyslogFilterTest_THRESH ADD constraint PK_EgSyslogFilterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslogFilterTest_THRESH ON EgSyslogFilterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterTest ON EgSyslogFilterTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterTest ON EgSyslogFilterTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSyslogFilterSvrTest CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
NO_OF_MESSAGES_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterSvrTest ADD constraint PK_EgSyslogFilterSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterSvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest_TREND(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME       DATE NOT NULL,
PERIOD       	VARCHAR2(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX NUMBER(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT VARCHAR2(32) NOT NULL);



ALTER TABLE EgSyslogFilterSvrTest_TREND ADD constraint PK_EgSyslogFilterSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterSvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSyslogFilterSvrTest_THRESH(
TRGT_HOST       VARCHAR2(32) NOT NULL,
PORT_NO         VARCHAR2(32) NOT NULL,
SITE_NAME       VARCHAR2(64) NOT NULL,	
INFO            VARCHAR2(128) NOT NULL,
MSMT_HOST       VARCHAR2(32) NOT NULL,
MSMT_TIME_START DATE NOT NULL,
MSMT_TIME_END   DATE NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR2(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSyslogFilterSvrTest_THRESH ADD constraint PK_EgSyslgFiltrSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslgFiltrSvrTest_THRESH ON EgSyslogFilterSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE   asset_info_default   CASCADE CONSTRAINTS;
create table asset_info_default (trgt_host varchar2(256) not null,asset_name varchar2(32),asset_desc varchar2(1024),asset_type varchar2(32),asset_state varchar2(32),asset_location varchar2(32),asset_ip_address varchar2(32),    asset_mac_address varchar2(32),asset_operating_system varchar2(256),asset_manufacturer varchar2(32),asset_user varchar2(32),asset_support_group varchar2(32),phone_number varchar2(32),email_id varchar2(32),license_expiry_date varchar2(32),asm_expiry_date varchar2(32),serial_number varchar2(32),license_serial_number varchar2(32),asset_busines_service varchar2(32),asset_business_impact varchar2(32) );
ALTER TABLE asset_info_default ADD constraint PK_asset_info_default PRIMARY KEY (trgt_host);

DROP TABLE   asset_info_custom  CASCADE CONSTRAINTS;
create table asset_info_custom (trgt_host varchar2(256) not null);
alter table asset_info_custom add constraint FK_asset_info_custom foreign key(trgt_host) references asset_info_default(trgt_host) ON DELETE CASCADE;

DROP TABLE CUSTOMDASHBOARDTEMPLATES CASCADE CONSTRAINTS;
CREATE TABLE CUSTOMDASHBOARDTEMPLATES(USERID VARCHAR2(256) NOT NULL,TEMPLATENAME VARCHAR2(2000) NOT NULL,ACCESSTYPE VARCHAR2(2048) NOT NULL);
 
DROP TABLE ActiveDirectoryTest CASCADE CONSTRAINTS;
CREATE TABLE ActiveDirectoryTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	schemaCacheHitRatio		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_ST		varchar2(32) NOT NULL,
	notifyQSize			Number(20,4) not null,
	notifyQSize_ST			varchar2(32) not null,
	currThreads			Number(20,4) not null,
	currThreads_ST			varchar2(32) not null,
	directoryWrites			number(20,4) not null,
	directoryWrites_ST		varchar2(32) not null,
	kerberosAuth			number(20,4) not null,
	kerberosAuth_ST			varchar2(32) not null,
	ntlmAuth			number(20,4) not null,
	ntlmAuth_ST			varchar2(32) not null,
	ticketReq			number(20,4) not null,
	ticketReq_ST			varchar2(32) not null,
	authSrvReq			number(20,4) not null,
	authSrvReq_ST			varchar2(32) not null,
	ldapSessions			Number(20,4) not null,
	ldapSessions_ST			varchar2(32) not null
);

ALTER TABLE ActiveDirectoryTest ADD constraint PK_ActiveDirectory
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   ActiveDirectoryTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ActiveDirectoryTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	schemaCacheHitRatio_MIN		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_MAX		NUMBER(20,4) NOT NULL,
	schemaCacheHitRatio_STCNT	varchar2(32) NOT NULL,
	notifyQSize_MIN			Number(20,4) not null,
	notifyQSize_MAX			Number(20,4) not null,
	notifyQSize_STCNT		varchar2(32) not null,
	currThreads_MIN			Number(20,4) not null,
	currThreads_MAX			Number(20,4) not null,
	currThreads_STCNT		varchar2(32) not null,
	directoryWrites_MIN		number(20,4) not null,
	directoryWrites_MAX		number(20,4) not null,
	directoryWrites_STCNT		varchar2(32) not null,
	kerberosAuth_MIN		number(20,4) not null,
	kerberosAuth_MAX		number(20,4) not null,
	kerberosAuth_STCNT		varchar2(32) not null,
	ntlmAuth_MIN			number(20,4) not null,
	ntlmAuth_MAX			number(20,4) not null,
	ntlmAuth_STCNT			varchar2(32) not null,
	ticketReq_MIN			number(20,4) not null,
	ticketReq_MAX			number(20,4) not null,
	ticketReq_STCNT			varchar2(32) not null,
	authSrvReq_MIN			number(20,4) not null,
	authSrvReq_MAX			number(20,4) not null,
	authSrvReq_STCNT		varchar2(32) not null,
	ldapSessions_MIN		Number(20,4) not null,
	ldapSessions_MAX		Number(20,4) not null,
	ldapSessions_STCNT		varchar2(32) not null
);

ALTER TABLE ActiveDirectoryTest_TREND ADD constraint PK_ActiveDirectoryTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ActiveDirectoryTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ActiveDirectoryTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	SCHEMACACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	SCHEMACACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL,
	NOTIFYQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	NOTIFYQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRTHREADS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRTHREADS_MAX	VARCHAR2(256)	 NOT NULL,
	DIRECTORYWRITES_MIN	VARCHAR2(256)	 NOT NULL,
	DIRECTORYWRITES_MAX	VARCHAR2(256)	 NOT NULL,
	KERBEROSAUTH_MIN	VARCHAR2(256)	 NOT NULL,
	KERBEROSAUTH_MAX	VARCHAR2(256)	 NOT NULL,
	NTLMAUTH_MIN	VARCHAR2(256)	 NOT NULL,
	NTLMAUTH_MAX	VARCHAR2(256)	 NOT NULL,
	TICKETREQ_MIN	VARCHAR2(256)	 NOT NULL,
	TICKETREQ_MAX	VARCHAR2(256)	 NOT NULL,
	AUTHSRVREQ_MIN	VARCHAR2(256)	 NOT NULL,
	AUTHSRVREQ_MAX	VARCHAR2(256)	 NOT NULL,
	LDAPSESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
	LDAPSESSIONS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ActiveDirectoryTest_THRESH ADD constraint PK_ActiveDirectoryTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ActiveDirectoryTest_THRESH ON ActiveDirectoryTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE ALARM CASCADE CONSTRAINTS;

CREATE TABLE ALARM 
(
	COMP_NAME	    VARCHAR2(1024),
	COMP_TYPE	    VARCHAR2(32),
	LAYER_NAME	    VARCHAR2(64),
	PROBLEM_DESC	    VARCHAR2(4000), 
	PRIORITY	    VARCHAR2(32) NOT NULL,
        MSMT_TIME	    DATE,
	ALARM_ID            NUMBER(18)			
 );
CREATE INDEX IDX_ALARM ON ALARM (PRIORITY,COMP_TYPE, COMP_NAME, LAYER_NAME, PROBLEM_DESC,MSMT_TIME);

ALTER TABLE ALARM ADD CONSTRAINT PK_ALARM
PRIMARY KEY (ALARM_ID);

DROP TABLE ATGJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	CONN_USE_PCT 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar2(32) 	NOT NULL,
	IDLE_CONN_PCT 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_ST varchar2(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST ADD constraint PK_ATG_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CONN_USE_PCT_MIN 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar2(32) 	NOT NULL,
	IDLE_CONN_PCT_MIN 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_MAX 	number(20,4) 	NOT NULL,
	IDLE_CONN_PCT_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_TREND ADD constraint PK_ATG_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
 
DROP TABLE ATGJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ATGJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	CONN_USE_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	IDLE_CONN_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	IDLE_CONN_PCT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_THRESH ADD constraint PK_ATG_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ATGJDBCTEST_THRESH ON ATGJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    
DROP TABLE ATGTEST CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	PCT_MEM_USE 	number(20,4) 	NOT NULL,
	PCT_MEM_USE_ST 	varchar2(32) 	NOT NULL,
	SESSION_RATE 	number(20,4) 	NOT NULL,
	SESSION_RATE_ST	varchar2(32) 	NOT NULL,
	SESSION_COUNT 	Number(20,4) 	NOT NULL,
	SESSION_COUNT_ST varchar2(32) 	NOT NULL,
	DRP_REQUEST_RATE number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_ST varchar2(32) NOT NULL,
	DRP_RESP_RATE number(20,4) 	NOT NULL,
	DRP_RESP_RATE_ST varchar2(32) 	NOT NULL
);

ALTER TABLE ATGTEST ADD constraint PK_ATG
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	PCT_MEM_USE_MIN	        number(20,4) 	NOT NULL,
	PCT_MEM_USE_MAX	        number(20,4) 	NOT NULL,
	PCT_MEM_USE_STCNT 	varchar2(32) 	NOT NULL,
	SESSION_RATE_MIN	number(20,4) 	NOT NULL,
	SESSION_RATE_MAX	number(20,4) 	NOT NULL,
	SESSION_RATE_STCNT 	varchar2(32) 	NOT NULL,
	SESSION_COUNT_MIN	Number(20,4) 	NOT NULL,
	SESSION_COUNT_MAX	Number(20,4) 	NOT NULL,
	SESSION_COUNT_STCNT 	varchar2(32) 	NOT NULL,
	DRP_REQUEST_RATE_MIN	number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_MAX	number(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_STCNT 	varchar2(32) 	NOT NULL,
	DRP_RESP_RATE_MIN	number(20,4) 	NOT NULL,
	DRP_RESP_RATE_MAX	number(20,4) 	NOT NULL,
	DRP_RESP_RATE_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE ATGTEST_TREND ADD constraint PK_ATG_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ATGTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ATGTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	PCT_MEM_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MEM_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DRP_RESP_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DRP_RESP_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ATGTEST_THRESH ADD constraint PK_ATG_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ATGTEST_THRESH ON ATGTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CHECKPOINTTEST  CASCADE CONSTRAINTS;

CREATE TABLE CHECKPOINTTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	PKT_PROCESSING_RATE 	number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_ST 	varchar2(32)    NOT NULL,
	PCT_ACC_PKTS 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_ST 	varchar2(32)    NOT NULL,
	PCT_REJ_PKTS 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_ST 	varchar2(32)    NOT NULL,
	PCT_DROP_PKTS 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE CHECKPOINTTEST ADD CONSTRAINT PK_CHECK_POINT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CHECKPOINTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE CHECKPOINTTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	PKT_PROCESSING_RATE_MIN 		number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_MAX 		number(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_STCNT		varchar2(32) NOT NULL,
	PCT_ACC_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_ACC_PKTS_STCNT		varchar2(32) NOT NULL,
	PCT_REJ_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_REJ_PKTS_STCNT 		varchar2(32) NOT NULL,
	PCT_DROP_PKTS_MIN 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_MAX 		number(20,4) 	NOT NULL,
	PCT_DROP_PKTS_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE CHECKPOINTTEST_TREND ADD CONSTRAINT PK_CHECK_POINT_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE CHECKPOINTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CHECKPOINTTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	PKT_PROCESSING_RATE_MIN	VARCHAR2(256)		NOT NULL,
	PKT_PROCESSING_RATE_MAX	VARCHAR2(256)		NOT NULL,
	PCT_ACC_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_ACC_PKTS_MAX	VARCHAR2(256)		NOT NULL,
	PCT_REJ_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_REJ_PKTS_MAX	VARCHAR2(256)		NOT NULL,
	PCT_DROP_PKTS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_DROP_PKTS_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE CHECKPOINTTEST_THRESH ADD CONSTRAINT PK_CHECK_POINT_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CHECKPOINTTEST_THRESH ON CHECKPOINTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CISCOCPUTEST CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	UTIL_PCT 	number(20,4) 	NOT NULL,
	UTIL_PCT_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST ADD constraint PK_CISCO_CPU
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CISCOCPUTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	UTIL_PCT_MIN 		number(20,4) 	NOT NULL,
	UTIL_PCT_MAX 		number(20,4) 	NOT NULL,
	UTIL_PCT_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_TREND ADD constraint PK_CISCO_CPU_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOCPUTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CISCOCPUTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	UTIL_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_THRESH ADD constraint PK_CISCO_CPU_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOCPUTEST_THRESH ON CISCOCPUTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE CISCOMEMORYTEST CASCADE CONSTRAINTS;

CREATE TABLE CISCOMEMORYTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	USED_PCT 	number(20,4) 	NOT NULL,
	USED_PCT_ST 	varchar2(32) 	NOT NULL,
	USED_MEMORY	number(20,4) 	NOT NULL,
	USED_MEMORY_ST	varchar2(32) 	NOT NULL,
	FREE_MEMORY	number(20,4) 	NOT NULL,
	FREE_MEMORY_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST ADD constraint PK_CISCO_MEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CISCOMEMORYTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE CISCOMEMORYTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	USED_PCT_MIN 		number(20,4) 	NOT NULL,
	USED_PCT_MAX 		number(20,4) 	NOT NULL,
	USED_PCT_STCNT 		varchar2(32) 	NOT NULL,
	USED_MEMORY_MIN		number(20,4) 	NOT NULL,
	USED_MEMORY_MAX		number(20,4) 	NOT NULL,
	USED_MEMORY_STCNT	varchar2(32) 	NOT NULL,
	FREE_MEMORY_MIN		number(20,4) 	NOT NULL,
	FREE_MEMORY_MAX		number(20,4) 	NOT NULL,
	FREE_MEMORY_STCNT	varchar2(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_TREND ADD constraint PK_CISCO_MEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOMEMORYTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CISCOMEMORYTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	USED_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	USED_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	USED_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	USED_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_THRESH ADD constraint PK_CISCO_MEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOMEMORYTEST_THRESH ON CISCOMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE COLDFUSIONTEST  CASCADE CONSTRAINTS;

CREATE TABLE COLDFUSIONTEST
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        PAGE_HIT_RATE           number(20,4)    NOT NULL, 
	PAGE_HIT_RATE_ST       	varchar2(32)  	NOT NULL,
        DB_HIT_RATE 		number(20,4)    NOT NULL,
        DB_HIT_RATE_ST 		varchar2(32)  	NOT NULL,
        BYTES_IN_RATE           number(20,4)    NOT NULL, 
        BYTES_IN_RATE_ST        varchar2(32)     NOT NULL,
        BYTES_OUT_RATE          number(20,4)    NOT NULL, 
        BYTES_OUT_RATE_ST       varchar2(32)     NOT NULL,
        REQUESTS_QUEUED         number(20,4)    NOT NULL, 
        REQUESTS_QUEUED_ST      varchar2(32)     NOT NULL,
        REQUESTS_RUNNING        number(20,4)    NOT NULL, 
       	REQUESTS_RUNNING_ST  	varchar2(32)     NOT NULL,
	REQ_TOUT_RATE		number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_ST	varchar2(32)	NOT NULL,
	AVG_QUEUE_TIME		number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_ST	varchar2(32)	NOT NULL,
        AVG_REQ_TIME        	number(20,4)    NOT NULL, 
       	AVG_REQ_TIME_ST  	varchar2(32)     NOT NULL,
        AVG_DB_TIME        	number(20,4)    NOT NULL, 
       	AVG_DB_TIME_ST  	varchar2(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST ADD CONSTRAINT PK_CFTEST_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE COLDFUSIONTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE COLDFUSIONTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD			varchar2(32), 
        PAGE_HIT_RATE_MIN       number(20,4)    NOT NULL, 
        PAGE_HIT_RATE_MAX       number(20,4)    NOT NULL,
	PAGE_HIT_RATE_STCNT	varchar2(32)     NOT NULL, 
        DB_HIT_RATE_MIN 	number(20,4)    NOT NULL,
        DB_HIT_RATE_MAX 	number(20,4)    NOT NULL,
	DB_HIT_RATE_STCNT	varchar2(32)     NOT NULL,
        BYTES_IN_RATE_MIN       number(20,4)    NOT NULL, 
        BYTES_IN_RATE_MAX       number(20,4)    NOT NULL, 
	BYTES_IN_RATE_STCNT	varchar2(32)     NOT NULL,
        BYTES_OUT_RATE_MIN      number(20,4)    NOT NULL, 
        BYTES_OUT_RATE_MAX      number(20,4)    NOT NULL, 
	BYTES_OUT_RATE_STCNT	varchar2(32)     NOT NULL,
        REQUESTS_QUEUED_MIN     number(20,4)    NOT NULL, 
        REQUESTS_QUEUED_MAX     number(20,4)    NOT NULL, 
	REQUESTS_QUEUED_STCNT	varchar2(32)     NOT NULL,
        REQUESTS_RUNNING_MIN    number(20,4)    NOT NULL, 
        REQUESTS_RUNNING_MAX    number(20,4)    NOT NULL, 
	REQUESTS_RUNNING_STCNT	varchar2(32)     NOT NULL,
	REQ_TOUT_RATE_MIN	number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_MAX	number(20,4)   	NOT NULL,
	REQ_TOUT_RATE_STCNT	varchar2(32)     NOT NULL,
	AVG_QUEUE_TIME_MIN	number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_MAX	number(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_STCNT	varchar2(32)     NOT NULL,
        AVG_REQ_TIME_MIN       	number(20,4)    NOT NULL, 
        AVG_REQ_TIME_MAX       	number(20,4)    NOT NULL, 
	AVG_REQ_TIME_STCNT	varchar2(32)     NOT NULL,
        AVG_DB_TIME_MIN        	number(20,4)    NOT NULL, 
        AVG_DB_TIME_MAX        	number(20,4)    NOT NULL, 
	AVG_DB_TIME_STCNT	varchar2(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST_TREND ADD CONSTRAINT PK_CFTEST_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE COLDFUSIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE COLDFUSIONTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(64),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        PAGE_HIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        PAGE_HIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        DB_HIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        DB_HIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        BYTES_IN_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        BYTES_IN_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        BYTES_OUT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        BYTES_OUT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        REQUESTS_QUEUED_MIN	VARCHAR2(256)	    NOT NULL,
        REQUESTS_QUEUED_MAX	VARCHAR2(256)	    NOT NULL,
        REQUESTS_RUNNING_MIN	VARCHAR2(256)	    NOT NULL,
        REQUESTS_RUNNING_MAX	VARCHAR2(256)	    NOT NULL,
	REQ_TOUT_RATE_MIN	VARCHAR2(256)	   	NOT NULL,
	REQ_TOUT_RATE_MAX	VARCHAR2(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR2(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR2(256)	   	NOT NULL,
        AVG_REQ_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_REQ_TIME_MAX	VARCHAR2(256)	    NOT NULL,
        AVG_DB_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_DB_TIME_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE COLDFUSIONTEST_THRESH ADD CONSTRAINT PK_CFTEST_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_COLDFUSIONTEST_THRESH ON COLDFUSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DB2BUFFERPOOLTEST  CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	PCT_POOL_HIT_RATIO 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_ST 		varchar2(32)  	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_ST 	varchar2(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO         number(20,4)	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_ST      varchar2(32)	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST ADD CONSTRAINT PK_DB2BUFFERPOOLTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2BUFFERPOOLTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	PCT_POOL_HIT_RATIO_MIN 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_MAX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_STCNT		varchar2(32) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX 		number(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_STCNT		varchar2(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN 		number(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX 		number(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_TREND ADD CONSTRAINT PK_DB2BUFFER_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2BUFFERPOOLTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2BUFFERPOOLTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	PCT_POOL_HIT_RATIO_MIN	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_MAX	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN	VARCHAR2(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX	VARCHAR2(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN	VARCHAR2(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_THRESH ADD CONSTRAINT PK_DB2_BUFFER_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2BUFFERPOOLTEST_THRESH ON DB2BUFFERPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2INSTANCETEST CASCADE CONSTRAINTS;

CREATE TABLE DB2INSTANCETEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	PCT_AGENTS_WAITING	 	number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_ST 		varchar2(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED 	number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_ST 	varchar2(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED 	number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_ST	varchar2(32)	NOT NULL,
	AGENTS_REGISTERED		number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_ST 		varchar2(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST ADD CONSTRAINT PK_DB2_INSTANCE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2INSTANCETEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2INSTANCETEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	PCT_AGENTS_WAITING_MIN	 		number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	 		number(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_STCNT 		varchar2(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN 		number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX 		number(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_STCNT 		varchar2(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN 		number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX 		number(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_STCNT		varchar2(32)	NOT NULL,
	AGENTS_REGISTERED_MIN			number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_MAX			number(20,4) 	NOT NULL,
	AGENTS_REGISTERED_STCNT 		varchar2(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX		number(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_TREND ADD CONSTRAINT PK_DB2_INSTANCE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2INSTANCETEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2INSTANCETEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	PCT_AGENTS_WAITING_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN	VARCHAR2(256)		NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX	VARCHAR2(256)		NOT NULL,
	AGENTS_REGISTERED_MIN	VARCHAR2(256)	 	NOT NULL,
	AGENTS_REGISTERED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_THRESH ADD CONSTRAINT PK_DB2_INSTANCE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2INSTANCETEST_THRESH ON DB2INSTANCETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2IOTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2IOTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	DIRECT_READ_RATE 		number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_ST 		varchar2(32)  	NOT NULL,
	DIRECT_WRITE_RATE 		number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_ST 		varchar2(32)  	NOT NULL,
	BUF_POOL_IO_RATE         	number(20,4)	NOT NULL,
	BUF_POOL_IO_RATE_ST         	varchar2(32)	NOT NULL
);

ALTER TABLE DB2IOTEST ADD CONSTRAINT PK_DB2IOTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2IOTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2IOTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	DIRECT_READ_RATE_MIN 			number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_MAX 			number(20,4) 	NOT NULL,
	DIRECT_READ_RATE_STCNT			varchar2(32) 	NOT NULL,
	DIRECT_WRITE_RATE_MIN 			number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_MAX	 		number(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_STCNT			varchar2(32) 	NOT NULL,
	BUF_POOL_IO_RATE_MIN 			number(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_MAX 			number(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2IOTEST_TREND ADD CONSTRAINT PK_DB2IOTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2IOTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2IOTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	DIRECT_READ_RATE_MIN	VARCHAR2(256)		NOT NULL,
	DIRECT_READ_RATE_MAX	VARCHAR2(256)		NOT NULL,
	DIRECT_WRITE_RATE_MIN	VARCHAR2(256)		NOT NULL,
	DIRECT_WRITE_RATE_MAX	VARCHAR2(256)		NOT NULL,
	BUF_POOL_IO_RATE_MIN	VARCHAR2(256)		NOT NULL,
	BUF_POOL_IO_RATE_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2IOTEST_THRESH ADD CONSTRAINT PK_DB2IOTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2IOTEST_THRESH ON DB2IOTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2LOCKANDDEADLOCKTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2LOCKANDDEADLOCKTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	TOTAL_DEADLOCKS 		number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_ST 		varchar2(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL	 	number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_ST 	varchar2(32) 	NOT NULL,
	LOCKS_HELD        		number(20,4)	NOT NULL,
	LOCKS_HELD_ST   		varchar2(32)	NOT NULL,
	LOCK_TIMEOUTS	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_ST 		varchar2(32)  	NOT NULL,
	LOCK_ESCALATIONS 		number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_ST 		varchar2(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_ST 	varchar2(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST ADD CONSTRAINT PK_DB2_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2LOCKANDDEADLOCKTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	TOTAL_DEADLOCKS_MIN 			number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_MAX 			number(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_STCNT 			varchar2(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN		number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX		number(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_STCNT		varchar2(32) 	NOT NULL,
	LOCKS_HELD_MIN        			number(20,4)	NOT NULL,
	LOCKS_HELD_MAX        			number(20,4)	NOT NULL,
	LOCKS_HELD_STCNT   			varchar2(32)	NOT NULL,
	LOCK_TIMEOUTS_MIN	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_MAX	 		number(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_STCNT 			varchar2(32)  	NOT NULL,
	LOCK_ESCALATIONS_MIN 			number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_MAX 			number(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_STCNT 			varchar2(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX  		number(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_TREND ADD CONSTRAINT PK_DB2_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2LOCKANDDEADLOCKTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	TOTAL_DEADLOCKS_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_DEADLOCKS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCKS_HELD_MIN	VARCHAR2(256)		NOT NULL,
	LOCKS_HELD_MAX	VARCHAR2(256)		NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN	VARCHAR2(256)		NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_THRESH ADD CONSTRAINT PK_DB2_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2LOCKTEST_THRESH ON DB2LOCKANDDEADLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2SORTTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2SORTTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	AVG_SORT_TIME	 		number(20,4) 	NOT NULL,
	AVG_SORT_TIME_ST	 	varchar2(32)  	NOT NULL,
	PCT_SORT_OVERFLOW	 	number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST ADD CONSTRAINT PK_DB2SORTTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2SORTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2SORTTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	AVG_SORT_TIME_MIN 			number(20,4) 	NOT NULL,
	AVG_SORT_TIME_MAX 			number(20,4) 	NOT NULL,
	AVG_SORT_TIME_STCNT			varchar2(32) 	NOT NULL,
	PCT_SORT_OVERFLOW_MIN 			number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_MAX 			number(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST_TREND ADD CONSTRAINT PK_DB2SORTTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SORTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2SORTTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	AVG_SORT_TIME_MIN	VARCHAR2(256)		NOT NULL,
	AVG_SORT_TIME_MAX	VARCHAR2(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MIN	VARCHAR2(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2SORTTEST_THRESH ADD CONSTRAINT PK_DB2SORTTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2SORTTEST_THRESH ON DB2SORTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2SQLACTIVITYTEST CASCADE CONSTRAINTS;

CREATE TABLE DB2SQLACTIVITYTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	DYNAMIC_SQL_RATE	 	number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_ST 		varchar2(32)  	NOT NULL,
	SELECT_SQL_RATE		 	number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_ST	 	varchar2(32) 	NOT NULL,
	FAILED_SQL_RATE        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_ST   		varchar2(32)	NOT NULL,
	UID_SQL_RATE	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_ST 		varchar2(32)  	NOT NULL,
	PCT_FAILED_SQL	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_ST 		varchar2(32) 	NOT NULL,
	PCT_DDL_SQL  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_ST			varchar2(32)	NOT NULL,
	PCT_UID_SQL  			number(20,4)	NOT NULL,
	PCT_UID_SQL_ST	 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST ADD CONSTRAINT PK_DB2_SQLACTIVITY
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2SQLACTIVITYTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2SQLACTIVITYTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	DYNAMIC_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_STCNT 			varchar2(32)  	NOT NULL,
	SELECT_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	SELECT_SQL_RATE_STCNT	 		varchar2(32) 	NOT NULL,
	FAILED_SQL_RATE_MIN        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_MAX        		number(20,4)	NOT NULL,
	FAILED_SQL_RATE_STCNT   		varchar2(32)	NOT NULL,
	UID_SQL_RATE_MIN	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_MAX	 		number(20,4) 	NOT NULL,
	UID_SQL_RATE_STCNT 			varchar2(32)  	NOT NULL,
	PCT_FAILED_SQL_MIN	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_MAX	 		number(20,4) 	NOT NULL,
	PCT_FAILED_SQL_STCNT 			varchar2(32) 	NOT NULL,
	PCT_DDL_SQL_MIN  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_MAX  			number(20,4)	NOT NULL,
	PCT_DDL_SQL_STCNT			varchar2(32)	NOT NULL,
	PCT_UID_SQL_MIN  			number(20,4)	NOT NULL,
	PCT_UID_SQL_MAX  			number(20,4)	NOT NULL,
	PCT_UID_SQL_STCNT	 		varchar2(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_TREND ADD CONSTRAINT PK_DB2_SQLACTIVITY_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SQLACTIVITYTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2SQLACTIVITYTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	DYNAMIC_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	SELECT_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SELECT_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	FAILED_SQL_RATE_MIN	VARCHAR2(256)		NOT NULL,
	FAILED_SQL_RATE_MAX	VARCHAR2(256)		NOT NULL,
	UID_SQL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	UID_SQL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_FAILED_SQL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_FAILED_SQL_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_DDL_SQL_MIN	VARCHAR2(256)		NOT NULL,
	PCT_DDL_SQL_MAX	VARCHAR2(256)		NOT NULL,
	PCT_UID_SQL_MIN	VARCHAR2(256)		NOT NULL,
	PCT_UID_SQL_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_THRESH ADD CONSTRAINT PK_DB2_SQLACTIVITY_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2SQLACTIVITYTEST_THRESH ON DB2SQLACTIVITYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DB2TRANSACTIONTEST  CASCADE CONSTRAINTS;

CREATE TABLE DB2TRANSACTIONTEST
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
        MSMT_TIME 			date,
	COMM_STMT_RATE	 		number(20,4) 	NOT NULL,
	COMM_STMT_RATE_ST 		varchar2(32)  	NOT NULL,
	ROLLBACK_RATE		 	number(20,4) 	NOT NULL,
	ROLLBACK_RATE_ST	 	varchar2(32) 	NOT NULL,
	TRANSACTION_RATE 	        number(20,4)	NOT NULL,
	TRANSACTION_RATE_ST     	 varchar2(32)	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST ADD CONSTRAINT PK_DB2TRANSACTIONTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DB2TRANSACTIONTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DB2TRANSACTIONTEST_TREND 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME 				date,
	PERIOD 					varchar2(32), 
	COMM_STMT_RATE_MIN 			number(20,4) 	NOT NULL,
	COMM_STMT_RATE_MAX 			number(20,4) 	NOT NULL,
	COMM_STMT_RATE_STCNT			varchar2(32) 	NOT NULL,
	ROLLBACK_RATE_MIN 			number(20,4) 	NOT NULL,
	ROLLBACK_RATE_MAX 			number(20,4) 	NOT NULL,
	ROLLBACK_RATE_STCNT			varchar2(32) 	NOT NULL,
	TRANSACTION_RATE_MIN 			number(20,4) 	NOT NULL,
	TRANSACTION_RATE_MAX 			number(20,4) 	NOT NULL,
	TRANSACTION_RATE_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_TREND ADD CONSTRAINT PK_DB2TRANSACTIONTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2TRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DB2TRANSACTIONTEST_THRESH 
(
	TRGT_HOST 				varchar2(32),
        PORT_NO                 		varchar2(32),
        SITE_NAME               		varchar2(64),
        INFO                    		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME_START 			date,
        MSMT_TIME_END           		date,
	COMM_STMT_RATE_MIN	VARCHAR2(256)		NOT NULL,
	COMM_STMT_RATE_MAX	VARCHAR2(256)		NOT NULL,
	ROLLBACK_RATE_MIN	VARCHAR2(256)		NOT NULL,
	ROLLBACK_RATE_MAX	VARCHAR2(256)		NOT NULL,
	TRANSACTION_RATE_MIN	VARCHAR2(256)		NOT NULL,
	TRANSACTION_RATE_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_THRESH ADD CONSTRAINT PK_DB2TRANSACTIONTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2TRANSACTIONTEST_THRESH ON DB2TRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DISKTEST CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	UTIL_PCT	number(20,4) 	NOT NULL,
	UTIL_PCT_ST	varchar2(32)    NOT NULL,
	READ_RATE 	number(20,4) 	NOT NULL,
	READ_RATE_ST 	varchar2(32)    NOT NULL,
	WRITE_RATE 	number(20,4) 	NOT NULL,
	WRITE_RATE_ST 	varchar2(32)    NOT NULL,
	BYTES_READ_RATE 	number(20,4) 	NOT NULL,
	BYTES_READ_RATE_ST 	varchar2(32)    NOT NULL,
	BYTES_WRITE_RATE 	number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE DISKTEST ADD constraint PK_DISK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DISKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	UTIL_PCT_MIN		number(20,4) 	NOT NULL,
	UTIL_PCT_MAX		number(20,4) 	NOT NULL,
	UTIL_PCT_STCNT		varchar2(32)   	NOT NULL,
	READ_RATE_MIN 		number(20,4) 	NOT NULL,
	READ_RATE_MAX 		number(20,4) 	NOT NULL,
	READ_RATE_STCNT 	varchar2(32)   	NOT NULL,
	WRITE_RATE_MIN 		number(20,4) 	NOT NULL,
	WRITE_RATE_MAX 		number(20,4) 	NOT NULL,
	WRITE_RATE_STCNT 	varchar2(32)   	NOT NULL,
	BYTES_READ_RATE_MIN 		number(20,4) 	NOT NULL,
	BYTES_READ_RATE_MAX 		number(20,4) 	NOT NULL,
	BYTES_READ_RATE_STCNT 	varchar2(32)   	NOT NULL,
	BYTES_WRITE_RATE_MIN 		number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_MAX 		number(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE DISKTEST_TREND ADD constraint PK_DISK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DISKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DISKTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	UTIL_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	BYTES_READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTES_READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE DISKTEST_THRESH ADD constraint PK_DISK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DISKTEST_THRESH ON DISKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE DNSTEST CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO   	varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	AVAILABLE 	number(3)  	NOT NULL,
	AVAILABLE_ST 	varchar2(32)   	NOT NULL,
	RESP_TIME 	number(20,4) 	NOT NULL,
	RESP_TIME_ST	varchar2(32) 	NOT NULL
);

alter table DNSTEST add constraint PK_DNS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DNSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST_TREND
(
	TRGT_HOST 			varchar2(32),
	PORT_NO   			varchar2(32),
        SITE_NAME       		varchar2(64),
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD				varchar2(32),
	AVAILABLE_MIN 			number(20,4)  	NOT NULL,
	AVAILABLE_MAX 			number(20,4)  	NOT NULL,
	AVAILABLE_STCNT 		varchar2(32)   	NOT NULL,
	RESP_TIME_MIN 			number(20,4) 	NOT NULL,
	RESP_TIME_MAX 			number(20,4) 	NOT NULL,
	RESP_TIME_STCNT			varchar2(32) 	NOT NULL
);

alter table DNSTEST_TREND add constraint PK_DNS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DNSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DNSTEST_THRESH
(
	TRGT_HOST 	varchar2(32),
	PORT_NO   	varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date, 
	AVAILABLE_MIN	VARCHAR2(256)	    NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	    NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL
);

alter table DNSTEST_THRESH add constraint PK_DNS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DNSTEST_THRESH ON DNSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE   DocReceiveTest CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	receive_Rate			NUMBER(20,4) NOT NULL,
	receive_Rate_ST			VARCHAR2(32) NOT NULL
);

ALTER TABLE  DocReceiveTest ADD constraint PK_DocReceiveTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   DocReceiveTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	receive_Rate_MIN		NUMBER(20,4) NOT NULL,
	receive_Rate_MAX		NUMBER(20,4) NOT NULL,
	receive_Rate_STCNT		VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocReceiveTest_TREND ADD constraint PK_DocReceiveTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocReceiveTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DocReceiveTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	RECEIVE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
      	RECEIVE_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE DocReceiveTest_THRESH ADD constraint PK_DocReceiveTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocReceiveTest_THRESH ON DocReceiveTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE DocSubmitTest CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	submit_Rate			NUMBER(20,4) NOT NULL,
	submit_Rate_ST			VARCHAR2(32) NOT NULL,
	mapped_Rate			NUMBER(20,4) NOT NULL,
	mapped_Rate_ST			VARCHAR2(32) NOT NULL,
	parsed_Rate			NUMBER(20,4) NOT NULL,
	parsed_Rate_ST			VARCHAR2(32) NOT NULL,
	process_Rate			NUMBER(20,4) NOT NULL,
	process_Rate_ST			VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocSubmitTest ADD constraint PK_DOCSUBMIT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   DocSubmitTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	submit_Rate_MIN			NUMBER(20,4) NOT NULL,
	submit_Rate_MAX			NUMBER(20,4) NOT NULL,
	submit_Rate_STCNT		VARCHAR2(32) NOT NULL,
	mapped_Rate_MIN		NUMBER(20,4) NOT NULL,
	mapped_Rate_MAX		NUMBER(20,4) NOT NULL,
	mapped_Rate_STCNT		VARCHAR2(32) NOT NULL,
	parsed_Rate_MIN		NUMBER(20,4) NOT NULL,
	parsed_Rate_MAX		NUMBER(20,4) NOT NULL,
	parsed_Rate_STCNT		VARCHAR2(32) NOT NULL,
	process_Rate_MIN		NUMBER(20,4) NOT NULL,
	process_Rate_MAX		NUMBER(20,4) NOT NULL,
	process_Rate_STCNT		VARCHAR2(32) NOT NULL
	);

ALTER TABLE DocSubmitTest_TREND ADD constraint PK_DocSubmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocSubmitTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DocSubmitTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	SUBMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SUBMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAPPED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAPPED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PARSED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	PARSED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PROCESS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	PROCESS_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE DocSubmitTest_THRESH ADD constraint PK_DocSubmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocSubmitTest_THRESH ON DocSubmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE DOMINODBTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINODBTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	CACHE_CURR_ENTRIES	 		number(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_ST 		varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES		 	number(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_ST 		varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO		 		number(20,4) 	NOT NULL,
	CACHE_HT_RATIO_ST 			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST ADD CONSTRAINT PK_DOMINODBTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINODBTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINODBTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	CACHE_CURR_ENTRIES_MIN	 		number(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX 			varchar2(32) 	NOT NULL,
	CACHE_CURR_ENTRIES_STCNT		varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	 		number(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX 			varchar2(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_STCNT			varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO_MIN	 			number(20,4) 	NOT NULL,
	CACHE_HT_RATIO_MAX 				varchar2(32) 	NOT NULL,
	CACHE_HT_RATIO_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST_TREND ADD CONSTRAINT PK_DOMINODBTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINODBTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINODBTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	CACHE_CURR_ENTRIES_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX	VARCHAR2(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX	VARCHAR2(256)	 	NOT NULL,
	CACHE_HT_RATIO_MIN	VARCHAR2(256)	 	NOT NULL,
	CACHE_HT_RATIO_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINODBTEST_THRESH ADD CONSTRAINT PK_DOMINODBTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINODBTEST_THRESH ON DOMINODBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINOMAILSTATSTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINOMAILSTATSTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	DELIVERED_MAIL_RATE	 		number(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_ST 		varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS		 		number(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_ST 			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING 		 	number(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_ST 		varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME			number(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_ST 		varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL 			number(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_ST 		varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV		number(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST ADD CONSTRAINT PK_DOMINOMAILSTATSTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINOMAILSTATSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMAILSTATSTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	DELIVERED_MAIL_RATE_MIN	 		number(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX 		varchar2(32) 	NOT NULL,
	DELIVERED_MAIL_RATE_STCNT		varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS_MIN	 			number(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_MAX 				varchar2(32) 	NOT NULL,
	PCT_DEAD_MAILS_STCNT			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING_MIN	 		number(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_MAX 			varchar2(32) 	NOT NULL,
	NUM_MAIL_WAITING_STCNT			varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	 		number(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX 			varchar2(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_STCNT		varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	 		number(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX 			varchar2(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_STCNT			varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	 		number(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX 		varchar2(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST_TREND ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMAILSTATSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMAILSTATSTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	DELIVERED_MAIL_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MAX	VARCHAR2(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	VARCHAR2(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINOMAILSTATSTEST_THRESH ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMAILSTATSTEST_THRESH ON DOMINOMAILSTATSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINOMEMTEST  CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	TOTAL_MEM_ALLOCATED	 		number(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_ST 		varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS		 	number(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_ST 		varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED		 	number(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST ADD CONSTRAINT PK_DOMINOMEMTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINOMEMTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	TOTAL_MEM_ALLOCATED_MIN	 		number(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX 		varchar2(32) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_STCNT		varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	 		number(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX 			varchar2(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_STCNT			varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	 		number(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_MAX 			varchar2(32) 	NOT NULL,
	MEM_ALLOC_SHARED_STCNT			varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST_TREND ADD CONSTRAINT PK_DOMINOMEMTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMEMTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINOMEMTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	TOTAL_MEM_ALLOCATED_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINOMEMTEST_THRESH ADD CONSTRAINT PK_DOMINOMEMTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMEMTEST_THRESH ON DOMINOMEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE DOMINONETTEST  CASCADE CONSTRAINTS;

CREATE TABLE DOMINONETTEST
(
	TRGT_HOST 					varchar2(32),
    PORT_NO                		varchar2(32),
    SITE_NAME               	varchar2(64),
    INFO                    	varchar2(128),
	MSMT_HOST 					varchar2(32), 
    MSMT_TIME 					date,
	DATA_RCVD_RATE	 			number(20,4) 	NOT NULL,
	DATA_RCVD_RATE_ST 			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE		 		number(20,4) 	NOT NULL,
	DATA_SENT_RATE_ST 			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE 		 	number(20,4) 	NOT NULL,
	IN_SESSION_RATE_ST 			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE			number(20,4) 	NOT NULL,
	OUT_SESSION_RATE_ST 		varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE			number(20,4) 	NOT NULL,
	DROP_SESSION_RATE_ST 		varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT		number(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST ADD CONSTRAINT PK_DOMINONETTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DOMINONETTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE DOMINONETTEST_TREND 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME 						date,
	PERIOD 							varchar2(32), 
	DATA_RCVD_RATE_MIN	 			number(20,4) 	NOT NULL,
	DATA_RCVD_RATE_MAX 			varchar2(32) 	NOT NULL,
	DATA_RCVD_RATE_STCNT			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE_MIN	 			number(20,4) 	NOT NULL,
	DATA_SENT_RATE_MAX 			varchar2(32) 	NOT NULL,
	DATA_SENT_RATE_STCNT			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE_MIN	 			number(20,4) 	NOT NULL,
	IN_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	IN_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE_MIN	 		number(20,4) 	NOT NULL,
	OUT_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	OUT_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE_MIN	 		number(20,4) 	NOT NULL,
	DROP_SESSION_RATE_MAX 			varchar2(32) 	NOT NULL,
	DROP_SESSION_RATE_STCNT			varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN 		number(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX 		varchar2(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST_TREND ADD CONSTRAINT PK_DOMINONETTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINONETTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DOMINONETTEST_THRESH 
(
	TRGT_HOST 						varchar2(32),
    PORT_NO                 		varchar2(32),
    SITE_NAME               		varchar2(64),
    INFO                    		varchar2(128),
	MSMT_HOST 						varchar2(32), 
	MSMT_TIME_START 				date,
    MSMT_TIME_END           		date,
	DATA_RCVD_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_SENT_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_SENT_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	IN_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	IN_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	OUT_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	OUT_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DROP_SESSION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DROP_SESSION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE DOMINONETTEST_THRESH ADD CONSTRAINT PK_DOMINONETTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINONETTEST_THRESH ON DOMINONETTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE EG_HELP CASCADE CONSTRAINTS;

CREATE TABLE EG_HELP
(
        SECTION            varchar2(32),
        MODULE              varchar2(32),
        SUB_MODULE	     varchar2(64),
	ID		     number,
	TITLE		    VARCHAR2(256) NOT NULL,
	PARA1		    VARCHAR2(1024) NOT NULL, 
	PARA2		    VARCHAR2(1024),
	PARA3	            VARCHAR2(1024),
	PARA4	            VARCHAR2(1024),
	PARA5		    VARCHAR2(1024), 
	PARA6		    VARCHAR2(1024),
	PARA7	            VARCHAR2(1024),
	PARA8	            VARCHAR2(1024),
	PARA9		    VARCHAR2(1024), 
	PARA10		    VARCHAR2(1024),
	PARA11	            VARCHAR2(1024),
	PARA12	            VARCHAR2(1024)
);

ALTER TABLE EG_HELP ADD CONSTRAINT PK_EG_HELP
primary key (
        SECTION            ,
        MODULE             ,
        SUB_MODULE	   ,
	ID		   
) ;

DROP TABLE EG_HELP_REF CASCADE CONSTRAINTS;

CREATE TABLE EG_HELP_REF 
(
        PAGE_REF      varchar2(128),
        ID            number
);

ALTER TABLE EG_HELP_REF ADD CONSTRAINT PK_EG_HELP_REF 
PRIMARY KEY (PAGE_REF) ;

DROP TABLE EJBNAMES CASCADE CONSTRAINTS;

CREATE TABLE EJBNAMES
(
	TEST_NAME 	varchar2(64),
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        EJB             varchar2(256)
);
ALTER TABLE EJBNAMES ADD CONSTRAINT PK_EJBNAMES
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,EJB);

DROP TABLE ERR_TBL CASCADE CONSTRAINTS;

CREATE TABLE ERR_TBL 
(
      TRGT_HOST            varchar2(32),
      PORT_NO              varchar2(32),
      SITE_NAME            varchar2(64),
      INFO                 varchar2(128),
      MSMT_TIME            date,
      TEST_NAME            varchar2(128) NOT NULL,
      MSMT_NAME            varchar2(128) NOT NULL,  
      MSMT_HOST            varchar2(32)  NOT NULL,
      STATE                VARCHAR2(32)  NOT NULL
);

alter table ERR_TBL add constraint PK_ERRTBLE
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO,TEST_NAME,MSMT_NAME,MSMT_HOST);
create index idx_err_tbl on err_tbl(site_name);

DROP TABLE FIXTABLE CASCADE CONSTRAINTS;

CREATE TABLE FIXTABLE 
(
        SITE_NAME		varchar2(64),
        COMP_NAME		varchar2(64),
        COMP_TYPE		varchar2(32),
        INFO			varchar2(128),
        TEST_name		varchar2(64),
        MEASURE            	varchar2(64),
	MSMT_TIME            	date,
	FIX_DATE            	date NOT NULL,
	PROB_REASON            	varchar2(4000)    NOT NULL,
	PROB_FIX            	varchar2(4000)    NOT NULL,
	PROB_FIXED_BY           varchar2(600)    NOT NULL
);

ALTER TABLE FIXTABLE ADD CONSTRAINT PK_FIXTABLE 
PRIMARY KEY (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_name,MEASURE,MSMT_TIME) ;
create index idx_fixtable on fixtable (site_name);
DROP TABLE FTPTEST CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	AVAILABILITY			number(3)	      NOT NULL,
	AVAILABILITY_ST			varchar2(32)	NOT NULL,
	TOT_RESPONSE_TIME 		number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_ST 		varchar2(32)	NOT NULL,
	TCP_AVAIL			number(3)		NOT NULL,
	TCP_AVAIL_ST			varchar2(32)	NOT NULL,
	TCP_CONN_TIME			number(20,4)		NOT NULL,
	TCP_CONN_TIME_ST 		varchar2(23)	NOT NULL,
	AUTHENTICATE_STATUS		number(3)		NOT NULL,
	AUTHENTICATE_STATUS_ST  	varchar2(32)	NOT NULL,
	AUTHENTICATE_TIME		number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_ST		varchar2(32)	NOT NULL
);

ALTER TABLE FTPTEST ADD constraint PK_FTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FTPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 			varchar2(32),
	AVAILABILITY_MIN		number(20,4)		NOT NULL,	
	AVAILABILITY_MAX		number(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar2(32)	NOT NULL,
	TOT_RESPONSE_TIME_MIN	number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_MAX	number(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_STCNT	varchar2(32)	NOT NULL,
	TCP_AVAIL_MIN		number(20,4)		NOT NULL,
	TCP_AVAIL_MAX		number(20,4)		NOT NULL,
	TCP_AVAIL_STCNT		varchar2(32)	NOT NULL,
	TCP_CONN_TIME_MIN		number(20,4)		NOT NULL,
	TCP_CONN_TIME_MAX	number(20,4)		NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)	NOT NULL,
	AUTHENTICATE_STATUS_MIN	number(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_MAX	number(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_STCNT varchar2(32)    NOT NULL,
	AUTHENTICATE_TIME_MIN	number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_MAX	number(20,4)		NOT NULL,
	AUTHENTICATE_TIME_STCNT varchar2(32)	NOT NULL
);

ALTER TABLE FTPTEST_TREND ADD constraint PK_FTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE FTPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE FTPTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	AVAILABILITY_MIN	VARCHAR2(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)			NOT NULL,
	TOT_RESPONSE_TIME_MIN	VARCHAR2(256)			NOT NULL,
	TOT_RESPONSE_TIME_MAX	VARCHAR2(256)			NOT NULL,
	TCP_AVAIL_MIN	VARCHAR2(256)			NOT NULL,
	TCP_AVAIL_MAX	VARCHAR2(256)			NOT NULL,
	TCP_CONN_TIME_MIN	VARCHAR2(256)			NOT NULL,
	TCP_CONN_TIME_MAX	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_STATUS_MIN	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_STATUS_MAX	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_TIME_MIN	VARCHAR2(256)			NOT NULL,
	AUTHENTICATE_TIME_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE FTPTEST_THRESH ADD constraint PK_FTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_FTPTEST_THRESH ON FTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE HTTPTEST CASCADE CONSTRAINTS;
CREATE TABLE HTTPTEST 
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL  	number(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar2(32)     	NOT NULL,
	TCP_CONN_TIME   	number(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar2(32)  	NOT NULL,
	SVR_RESP_TIME   	number(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar2(32)  	NOT NULL,
	CONTENT_VAL   		number(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar2(32)  	NOT NULL,
	RESP_CODE   		number(3)  	NOT NULL,
	RESP_CODE_ST   		varchar2(32)  	NOT NULL,
	CONTENT_LEN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar2(32)  	NOT NULL,
	DATA_XFER_TIME   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar2(32)  	NOT NULL
);

alter table HTTPTEST add constraint PK_HTTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HTTPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE HTTPTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		number(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		number(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar2(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_VAL_MIN   		number(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		number(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar2(32)  	NOT NULL,
	RESP_CODE_MIN   		number(20,4)  	NOT NULL,
	RESP_CODE_MAX   		number(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_LEN_MIN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_MAX   		number(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT   		varchar2(32)  	NOT NULL,
	DATA_XFER_TIME_MIN   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT   		varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT   	varchar2(32)  	NOT NULL
);

alter table HTTPTEST_TREND add constraint PK_HTTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE HTTPTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MAX	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MAX	VARCHAR2(256)	  NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        DATA_XFER_TIME_MAX	VARCHAR2(256)	  NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR2(256)	  NOT NULL,
        DNS_AVAILABILITY_MAX	VARCHAR2(256)	  NOT NULL
);

alter table HTTPTEST_THRESH add constraint PK_HTTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_HTTPTEST_THRESH ON HTTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   

DROP TABLE HTTPPOSTTEST CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST 
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL  	number(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar2(32)     	NOT NULL,
	TCP_CONN_TIME   	number(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar2(32)  	NOT NULL,
	SVR_RESP_TIME   	number(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar2(32)  	NOT NULL,
	CONTENT_VAL   		number(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar2(32)  	NOT NULL,
	RESP_CODE   		number(3)  	NOT NULL,
	RESP_CODE_ST   		varchar2(32)  	NOT NULL,
	CONTENT_LEN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar2(32)  	NOT NULL,
	DATA_XFER_TIME   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar2(32)  	NOT NULL
);

alter table HTTPPOSTTEST add constraint PK_HTTPPOST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HTTPPOSTTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		number(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		number(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar2(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_VAL_MIN   		number(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		number(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar2(32)  	NOT NULL,
	RESP_CODE_MIN   		number(20,4)  	NOT NULL,
	RESP_CODE_MAX   		number(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_LEN_MIN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_MAX   		number(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT   		varchar2(32)  	NOT NULL,
	DATA_XFER_TIME_MIN   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX   		number(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT   		varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX   		number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT   	varchar2(32)  	NOT NULL
);

alter table HTTPPOSTTEST_TREND add constraint PK_HTTPPOST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPPOSTTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HTTPPOSTTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MAX	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MAX	VARCHAR2(256)	  NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        DATA_XFER_TIME_MAX	VARCHAR2(256)	  NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR2(256)	  NOT NULL,
        DNS_AVAILABILITY_MAX	VARCHAR2(256)	  NOT NULL
);

alter table HTTPPOSTTEST_THRESH add constraint PK_HTTPPOST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_HTTPPOSTTEST_THRESH ON HTTPPOSTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   

DROP TABLE IISXChgLayerTest CASCADE CONSTRAINTS;
CREATE TABLE IISXChgLayerTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	clientQSize			Number(20,4) not null,
	clientQSize_st		varchar2(32) not null,
	rpcOperationsRate		number(20,4) not null,
	rpcOperationsRate_st		varchar2(32) not null
);

ALTER TABLE IISXChgLayerTest ADD constraint PK_IISXChgLayerTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   IISXChgLayerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE IISXChgLayerTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	clientQSize_min		Number(20,4) not null,
	clientQSize_max		Number(20,4) not null,
	clientQSize_stcnt		varchar2(32) not null,
	rpcOperationsRate_min		number(20,4) not null,
	rpcOperationsRate_max		number(20,4) not null,
	rpcOperationsRate_stcnt		varchar2(32) not null
);

ALTER TABLE IISXChgLayerTest_TREND ADD constraint PK_IISXChgLayerTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IISXChgLayerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE IISXChgLayerTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CLIENTQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	CLIENTQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	RPCOPERATIONSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	RPCOPERATIONSRATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE IISXChgLayerTest_THRESH ADD constraint PK_IISXChgLayerTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IISXChgLayerTest_THRESH ON IISXChgLayerTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE InterChangeRcvdTest CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	decode_Rate		number(20,4) not null,
	decode_Rate_ST		varchar2(32) not null,
	decrypt_Rate		number(20,4) not null,
	decrypt_Rate_ST		varchar2(32) not null,
	receive_Rate		number(20,4) not null,
	receive_Rate_ST		varchar2(32) not null
);

ALTER TABLE InterChangeRcvdTest ADD constraint PK_InterChangeRcvdTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE InterChangeRcvdTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	decode_Rate_MIN		number(20,4) not null,
	decode_Rate_MAX		number(20,4) not null,
	decode_Rate_STCNT	varchar2(32) not null,
	decrypt_Rate_MIN	number(20,4) not null,
	decrypt_Rate_MAX	number(20,4) not null,
	decrypt_Rate_STCNT	varchar2(32) not null,
	receive_Rate_MIN	number(20,4) not null,
	receive_Rate_MAX	number(20,4) not null,
	receive_Rate_STCNT	varchar2(32) not null
);

ALTER TABLE InterChangeRcvdTest_TREND ADD constraint PK_InterChangeRcvdTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE InterChangeRcvdTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterChangeRcvdTest_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
      	MSMT_TIME_END   	date,
      	DECODE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DECODE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	DECRYPT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DECRYPT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	RECEIVE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	RECEIVE_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterChangeRcvdTest_THRESH ADD constraint PK_InterChangeRcvdTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_InterChangeRcvdTest_THRESH ON InterChangeRcvdTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE  InterChangeXmitTest CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	encode_Rate			NUMBER(20,4) NOT NULL,
	encode_Rate_ST			VARCHAR2(32) NOT NULL,
	encrypt_Rate			NUMBER(20,4) NOT NULL,
	encrypt_Rate_ST			VARCHAR2(32) NOT NULL,
	serialize_Rate			NUMBER(20,4) NOT NULL,
	serialize_Rate_ST		VARCHAR2(32) NOT NULL,
	xmit_Rate			NUMBER(20,4) NOT NULL,
	xmit_Rate_ST			VARCHAR2(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest ADD constraint PK_InterChangeXmitTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE  InterChangeXmitTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	encode_Rate_MIN			NUMBER(20,4) NOT NULL,
	encode_Rate_MAX			NUMBER(20,4) NOT NULL,
	encode_Rate_STCNT		VARCHAR2(32) NOT NULL,
	encrypt_Rate_MIN		NUMBER(20,4) NOT NULL,
	encrypt_Rate_MAX		NUMBER(20,4) NOT NULL,
	encrypt_Rate_STCNT		VARCHAR2(32) NOT NULL,
	serialize_Rate_MIN		NUMBER(20,4) NOT NULL,
	serialize_Rate_MAX		NUMBER(20,4) NOT NULL,
	serialize_Rate_STCNT		VARCHAR2(32) NOT NULL,
	xmit_Rate_MIN			NUMBER(20,4) NOT NULL,
	xmit_Rate_MAX			NUMBER(20,4) NOT NULL,
	xmit_Rate_STCNT			VARCHAR2(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest_TREND ADD constraint PK_InterChangeXmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterChangeXmitTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterChangeXmitTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	ENCODE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	ENCODE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	ENCRYPT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	ENCRYPT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	SERIALIZE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SERIALIZE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterChangeXmitTest_THRESH ADD constraint PK_InterChangeXmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterChangeXmitTest_THRESH ON InterChangeXmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE InterSiteReplTest CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_rate				NUMBER(20,4) NOT NULL,
	in_rate_ST			varchar2(32) NOT NULL,
	out_rate			number(20,4) not null,
	out_rate_ST			varchar2(32) not null
);

ALTER TABLE InterSiteReplTest ADD constraint PK_InterSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   InterSiteReplTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_rate_MIN			NUMBER(20,4) NOT NULL,
	in_rate_MAX			NUMBER(20,4) NOT NULL,
	in_rate_STCNT		varchar2(32) NOT NULL,
	out_rate_MIN		number(20,4) not null,
	out_rate_MAX		number(20,4) not null,
	out_rate_STCNT		varchar2(32) not null
);

ALTER TABLE InterSiteReplTest_TREND ADD constraint PK_InterSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterSiteReplTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE InterSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE InterSiteReplTest_THRESH ADD constraint PK_InterSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterSiteReplTest_THRESH ON InterSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE IntraSiteReplTest CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_rate			NUMBER(20,4) NOT NULL,
	in_rate_ST			varchar2(32) NOT NULL,
	out_rate			number(20,4) not null,
	out_rate_ST			varchar2(32) not null
);

ALTER TABLE IntraSiteReplTest ADD constraint PK_IntraSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   IntraSiteReplTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_rate_MIN			NUMBER(20,4) NOT NULL,
	in_rate_MAX			NUMBER(20,4) NOT NULL,
	in_rate_STCNT		varchar2(32) NOT NULL,
	out_rate_MIN		number(20,4) not null,
	out_rate_MAX		number(20,4) not null,
	out_rate_STCNT		varchar2(32) not null
);

ALTER TABLE IntraSiteReplTest_TREND ADD constraint PK_IntraSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IntraSiteReplTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE IntraSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE IntraSiteReplTest_THRESH ADD constraint PK_IntraSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IntraSiteReplTest_THRESH ON IntraSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE LDAPTEST CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST       	varchar2(32)  	NOT NULL,
	TCP_AVAIL       	number(3)  	NOT NULL,
	TCP_AVAIL_ST       	varchar2(32)  	NOT NULL,
	CURR_CONN		Number(20,4)    	NOT NULL,
	CURR_CONN_ST		varchar2(32)    	NOT NULL,
	CONN_RATE 		number(20,4)  	NOT NULL,
	CONN_RATE_ST 		varchar2(32)  	NOT NULL,
	BYTE_RATE_OUT   	number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_ST   	varchar2(32)  	NOT NULL,
	OUT_STND_OPNS		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_ST	varchar2(32)    	NOT NULL
);

alter table LDAPTEST add constraint PK_LDAP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDAPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 	
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT   		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT       		varchar2(32)  	NOT NULL,
	TCP_AVAIL_MIN		       	number(20,4)  	NOT NULL,
	TCP_AVAIL_MAX			number(20,4)	NOT NULL,
	TCP_AVAIL_STCNT       		varchar2(32)  	NOT NULL,
	CURR_CONN_MIN			Number(20,4)    	NOT NULL,
	CURR_CONN_MAX			Number(20,4)    	NOT NULL,
	CURR_CONN_STCNT			varchar2(32)    NOT NULL,
	CONN_RATE_MIN	 		number(20,4)  	NOT NULL,
	CONN_RATE_MAX 			number(20,4)  	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)  	NOT NULL,
	BYTE_RATE_OUT_MIN   		number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_MAX   		number(20,4)  	NOT NULL,
	BYTE_RATE_OUT_STCNT   		varchar2(32)  	NOT NULL,
	OUT_STND_OPNS_MIN		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_MAX		Number(20,4)    	NOT NULL,
	OUT_STND_OPNS_STCNT		varchar2(32)    NOT NULL
);

alter table LDAPTEST_TREND add constraint PK_LDAP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDAPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDAPTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_AVAIL_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_AVAIL_MAX	VARCHAR2(256)	  NOT NULL,
        CURR_CONN_MIN	VARCHAR2(256)	    NOT NULL,
        CURR_CONN_MAX	VARCHAR2(256)	    NOT NULL,
        CONN_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        CONN_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	  NOT NULL,
        BYTE_RATE_OUT_MAX	VARCHAR2(256)	  NOT NULL,
        OUT_STND_OPNS_MIN	VARCHAR2(256)	    NOT NULL,
        OUT_STND_OPNS_MAX	VARCHAR2(256)	    NOT NULL
);

alter table LDAPTEST_THRESH add constraint PK_LDAP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDAPTEST_THRESH ON LDAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       
DROP TABLE LDREALSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	STATE		Number(20,4) 	NOT NULL,
	STATE_ST	varchar2(32)    NOT NULL,
	CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	DATA_RATE 	number(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE LDREALSERVERTEST ADD constraint PK_REAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDREALSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	STATE_MIN		Number(20,4) 	NOT NULL,
	STATE_MAX		Number(20,4) 	NOT NULL,
	STATE_STCNT		varchar2(32)   	NOT NULL,
	CONN_RATE_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar2(32)   	NOT NULL,
	DATA_RATE_MIN 		number(20,4) 	NOT NULL,
	DATA_RATE_MAX 		number(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_TREND ADD constraint PK_REAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDREALSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDREALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	STATE_MIN	VARCHAR2(256)	 	NOT NULL,
	STATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_THRESH ADD constraint PK_REAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDREALSERVERTEST_THRESH ON LDREALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE LDVIRTUALSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	STATE		Number(20,4) 	NOT NULL,
	STATE_ST	varchar2(32)    NOT NULL,
	CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	DATA_RATE 	number(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST ADD constraint PK_VIRTUAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE LDVIRTUALSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	STATE_MIN		Number(20,4) 	NOT NULL,
	STATE_MAX		Number(20,4) 	NOT NULL,
	STATE_STCNT		varchar2(32)   	NOT NULL,
	CONN_RATE_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar2(32)   	NOT NULL,
	DATA_RATE_MIN 		number(20,4) 	NOT NULL,
	DATA_RATE_MAX 		number(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar2(32)   	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_TREND ADD constraint PK_VIRTUAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDVIRTUALSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE LDVIRTUALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	STATE_MIN	VARCHAR2(256)	 	NOT NULL,
	STATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_THRESH ADD constraint PK_VIRTUAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDVIRTUALSERVERTEST_THRESH ON LDVIRTUALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);        
DROP TABLE MAILTEST CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        SMTP_AVAIL           NUMBER(3)    NOT NULL,
        SMTP_AVAIL_ST        VARCHAR2(32)    NOT NULL,
        POP3_AVAIL           NUMBER(3)    NOT NULL,
        POP3_AVAIL_ST        VARCHAR2(32)    NOT NULL,
        OUT_MAIL             NUMBER(20,4)    NOT NULL,
        OUT_MAIL_ST          VARCHAR2(32)    NOT NULL,
        RT_DELAY             NUMBER(20,4)    NOT NULL,
        RT_DELAY_ST          VARCHAR2(32)    NOT NULL
);

alter table MAILTEST add constraint PK_MAILTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MAILTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        SMTP_AVAIL_MIN           	NUMBER(20,4)    NOT NULL,
        SMTP_AVAIL_MAX           	NUMBER(20,4)    NOT NULL,
        SMTP_AVAIL_STCNT        	VARCHAR2(32)    NOT NULL,
        POP3_AVAIL_MIN          	NUMBER(20,4)    NOT NULL,
        POP3_AVAIL_MAX           	NUMBER(20,4)    NOT NULL,
        POP3_AVAIL_STCNT        	VARCHAR2(32)    NOT NULL,
        OUT_MAIL_MIN                    NUMBER(20,4)    NOT NULL,
        OUT_MAIL_MAX             	NUMBER(20,4)    NOT NULL,
        OUT_MAIL_STCNT          	VARCHAR2(32)    NOT NULL,
        RT_DELAY_MIN              	NUMBER(20,4)    NOT NULL,
        RT_DELAY_MAX             	NUMBER(20,4)    NOT NULL,
        RT_DELAY_STCNT          	VARCHAR2(32)    NOT NULL
);


alter table MAILTEST_TREND add constraint PK_MAILTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MAILTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MAILTEST_THRESH 
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        SMTP_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
        SMTP_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
        POP3_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
        POP3_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
        OUT_MAIL_MIN	VARCHAR2(256)	    NOT NULL,
        OUT_MAIL_MAX	VARCHAR2(256)	    NOT NULL,
        RT_DELAY_MIN	VARCHAR2(256)	    NOT NULL,
        RT_DELAY_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MAILTEST_THRESH add constraint PK_MAILTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MAILTEST_THRESH ON MAILTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE MEASURE_LAST CASCADE CONSTRAINTS;
CREATE TABLE MEASURE_LAST
(
	TEST_NAME 	varchar2(64),
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date
);

alter table MEASURE_LAST add constraint PK_MEASURE_LAST 
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST);
create index idx_measure_last on measure_last (site_name);
create index idx1_measure_last on measure_last(trgt_host);
create index idx2_measure_last on measure_last (test_name,port_no);
CREATE INDEX IDX3_MEASURE_LAST ON MEASURE_LAST ( INFO, MSMT_TIME);

DROP TABLE METATEST  CASCADE CONSTRAINTS;
CREATE TABLE METATEST 
(
        COMP_NAME          varchar2(64),
	COMP_TYPE		varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST		varchar2(64),
        TEST_NAME               varchar2(128),
        MSMT_TIME 		date
);

ALTER TABLE METATEST ADD CONSTRAINT PK_METATEST
PRIMARY KEY (COMP_NAME,COMP_TYPE,SITE_NAME,INFO,MSMT_HOST,TEST_NAME);

CREATE INDEX IDX_METATEST ON METATEST(SITE_NAME,INFO);              

DROP TABLE MSMQTEST CASCADE CONSTRAINTS;

CREATE TABLE MSMQTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	IN_MSG_RATE		number(20,4)	NOT NULL,	
	IN_MSG_RATE_ST		varchar2(32)	NOT NULL,	
	OUT_MSG_RATE		number(20,4)	NOT NULL,
	OUT_MSG_RATE_ST		varchar2(32)	NOT NULL,
	CURRENT_SESSIONS	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_ST	varchar2(32)	NOT NULL,
	ERROR_MSG_CNT		number(20,4)	NOT NULL,
	ERROR_MSG_CNT_ST	varchar2(32)	NOT NULL,
	TOTAL_NO_MSGS		number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_ST	varchar2(32)	NOT NULL,
	GROWTH_RATE		number(20,4)	NOT NULL,
	GROWTH_RATE_ST		varchar2(32)	NOT NULL,
	IP_SESSION	number(20,4)	NOT NULL,
	IP_SESSION_ST	varchar2(32)	NOT NULL,
	IN_MULTICAST_SESSION	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_ST	VARCHAR2(32)	NOT NULL,
	MSMQ_IN_MSG	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_ST VARCHAR2(32)	NOT NULL,
	MSMQ_OUT_MSG	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_ST	VARCHAR2(32)	NOT NULL,
	OUT_HTTP_SESSION	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_ST	VARCHAR2(32)	NOT NULL,
	OUT_MULTICAST_SESSION NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_ST VARCHAR2(32)	NOT NULL,
	TOT_BYTES	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_ST VARCHAR2(32)	NOT NULL
);

ALTER TABLE MSMQTEST ADD constraint PK_MSMQ
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSMQTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSMQTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	IN_MSG_RATE_MIN		number(20,4)	NOT NULL,	
	IN_MSG_RATE_MAX		number(20,4)	NOT NULL,	
	IN_MSG_RATE_STCNT	varchar2(32)	NOT NULL,	
	OUT_MSG_RATE_MIN	number(20,4)	NOT NULL,
	OUT_MSG_RATE_MAX	number(20,4)	NOT NULL,
	OUT_MSG_RATE_STCNT	varchar2(32)	NOT NULL,
	CURRENT_SESSIONS_MIN	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_MAX	number(20,4)	NOT NULL,
	CURRENT_SESSIONS_STCNT	varchar2(32)	NOT NULL,
	ERROR_MSG_CNT_MIN	number(20,4)	NOT NULL,
	ERROR_MSG_CNT_MAX	number(20,4)	NOT NULL,
	ERROR_MSG_CNT_STCNT	varchar2(32)	NOT NULL,
	TOTAL_NO_MSGS_MIN	number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_MAX	number(20,4)	NOT NULL,
	TOTAL_NO_MSGS_STCNT	varchar2(32)	NOT NULL,
	GROWTH_RATE_MIN		number(20,4)	NOT NULL,
	GROWTH_RATE_MAX		number(20,4)	NOT NULL,
	GROWTH_RATE_STCNT	varchar2(32)	NOT NULL,
	IP_SESSION_MIN	number(20,4)	NOT NULL,
	IP_SESSION_MAX	number(20,4)	NOT NULL,
	IP_SESSION_STCNT	varchar2(32)	NOT NULL,
	IN_MULTICAST_SESSION_MIN	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_MAX	NUMBER(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_STCNT	VARCHAR2(32)	NOT NULL,
	MSMQ_IN_MSG_MIN	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_MAX	NUMBER(20,4)	NOT NULL,
	MSMQ_IN_MSG_STCNT VARCHAR2(32)	NOT NULL,
	MSMQ_OUT_MSG_MIN	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_MAX	NUMBER(20,4)	NOT NULL,
	MSMQ_OUT_MSG_STCNT	VARCHAR2(32)	NOT NULL,
	OUT_HTTP_SESSION_MIN	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_MAX	NUMBER(20,4)	NOT NULL,
	OUT_HTTP_SESSION_STCNT	VARCHAR2(32)	NOT NULL,
	OUT_MULTICAST_SESSION_MIN NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_MAX NUMBER(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_STCNT VARCHAR2(32)	NOT NULL,
	TOT_BYTES_MIN	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_MAX	NUMBER(20,4)	NOT NULL,
	TOT_BYTES_STCNT VARCHAR2(32)	NOT NULL
);

ALTER TABLE MSMQTEST_TREND ADD constraint PK_MSMQ_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSMQTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSMQTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
      	MSMT_TIME_END   	date,
	IN_MSG_RATE_MIN	VARCHAR2(256)		NOT NULL,
	IN_MSG_RATE_MAX	VARCHAR2(256)		NOT NULL,
	OUT_MSG_RATE_MIN	VARCHAR2(256)		NOT NULL,
	OUT_MSG_RATE_MAX	VARCHAR2(256)		NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR2(256)		NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR2(256)		NOT NULL,
	ERROR_MSG_CNT_MIN	VARCHAR2(256)		NOT NULL,
	ERROR_MSG_CNT_MAX	VARCHAR2(256)		NOT NULL,
	TOTAL_NO_MSGS_MIN	VARCHAR2(256)		NOT NULL,
	TOTAL_NO_MSGS_MAX	VARCHAR2(256)		NOT NULL,
	GROWTH_RATE_MIN	VARCHAR2(256)		NOT NULL,
	GROWTH_RATE_MAX	VARCHAR2(256)		NOT NULL,
	IP_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	IP_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	IN_MULTICAST_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	IN_MULTICAST_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	MSMQ_IN_MSG_MIN	VARCHAR2(256)		NOT NULL,
	MSMQ_IN_MSG_MAX	VARCHAR2(256)		NOT NULL,
	MSMQ_OUT_MSG_MIN	VARCHAR2(256)		NOT NULL,
	MSMQ_OUT_MSG_MAX	VARCHAR2(256)		NOT NULL,
	OUT_HTTP_SESSION_MIN	VARCHAR2(256)		NOT NULL,
	OUT_HTTP_SESSION_MAX	VARCHAR2(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MIN VARCHAR2(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MAX VARCHAR2(256)		NOT NULL,
	TOT_BYTES_MIN	VARCHAR2(256)		NOT NULL,
	TOT_BYTES_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE MSMQTEST_THRESH ADD constraint PK_MSMQ_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSMQTEST_THRESH ON MSMQTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);              
DROP TABLE MSSQLBUFFERTEST CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	BUFFER_CHEHIT_RT	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_ST	VARCHAR2(32)    NOT NULL,
	PAGE_RD			NUMBER(20,4)    NOT NULL,	
	PAGE_RD_ST		VARCHAR2(32)    NOT NULL,
	PAGE_WRT_RT		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_ST		VARCHAR2(32)    NOT NULL,
	CACHE_HTRT		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_ST		VARCHAR2(32)    NOT NULL,
	CACHE_OBJCT		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_ST		VARCHAR2(32)    NOT NULL,
	LOG_CACHITRT		NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_ST		VARCHAR2(32)    NOT NULL
	);
												
alter table MSSQLBUFFERTEST add constraint PK_MSSQLBUFFERTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLBUFFERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	BUFFER_CHEHIT_RT_MIN	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_MAX	NUMBER(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_STCNT	VARCHAR2(32)    NOT NULL,
	PAGE_RD_MIN		NUMBER(20,4)    NOT NULL,	
	PAGE_RD_MAX		NUMBER(20,4)    NOT NULL,	
	PAGE_RD_STCNT		VARCHAR2(32)    NOT NULL,
	PAGE_WRT_RT_MIN		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_MAX		NUMBER(20,4)    NOT NULL,	
	PAGE_WRT_RT_STCNT	VARCHAR2(32)    NOT NULL,
	CACHE_HTRT_MIN		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_MAX		NUMBER(20,4)    NOT NULL,	
	CACHE_HTRT_STCNT	VARCHAR2(32)    NOT NULL,
	CACHE_OBJCT_MIN		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_MAX		NUMBER(20,4)    NOT NULL,	
	CACHE_OBJCT_STCNT	VARCHAR2(32)    NOT NULL,
	LOG_CACHITRT_MIN	NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_MAX	NUMBER(20,4)    NOT NULL,	
	LOG_CACHITRT_STCNT	VARCHAR2(32)    NOT NULL
);

alter table MSSQLBUFFERTEST_TREND add constraint PK_MSSQLBUFFERTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLBUFFERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLBUFFERTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        BUFFER_CHEHIT_RT_MIN	VARCHAR2(256)	    NOT NULL,
	BUFFER_CHEHIT_RT_MAX	VARCHAR2(256)	    NOT NULL,
	PAGE_RD_MIN	VARCHAR2(256)	    NOT NULL,
	PAGE_RD_MAX	VARCHAR2(256)	    NOT NULL,
	PAGE_WRT_RT_MIN	VARCHAR2(256)	    NOT NULL,
	PAGE_WRT_RT_MAX	VARCHAR2(256)	    NOT NULL,
	CACHE_HTRT_MIN	VARCHAR2(256)	    NOT NULL,
	CACHE_HTRT_MAX	VARCHAR2(256)	    NOT NULL,
	CACHE_OBJCT_MIN	VARCHAR2(256)	    NOT NULL,
	CACHE_OBJCT_MAX	VARCHAR2(256)	    NOT NULL,
	LOG_CACHITRT_MIN	VARCHAR2(256)	    NOT NULL,
	LOG_CACHITRT_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MSSQLBUFFERTEST_THRESH add constraint PK_MSSQLBUFFERTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MSSQLBUFFERTEST_THRESH ON MSSQLBUFFERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLLOCKTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLLOCKTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	AVG_WTTIME		NUMBER(20,4)    NOT NULL,	
	AVG_WTTIME_ST		VARCHAR2(32)    NOT NULL,
	LOCK_REQ		NUMBER(20,4)    NOT NULL,	
	LOCK_REQ_ST		VARCHAR2(32)    NOT NULL,
	LOCK_WAIT		NUMBER(20,4)    NOT NULL,	
	LOCK_WAIT_ST		VARCHAR2(32)    NOT NULL,
	NUM_DEADLOCK		NUMBER(20,4)    NOT NULL,	
	NUM_DEADLOCK_ST		VARCHAR2(32)    NOT NULL,
	LOCK_TIMEOUTS		NUMBER(20,4)    NOT NULL,	
	LOCK_TIMEOUTS_ST	VARCHAR2(32)    NOT NULL);

CREATE  INDEX IDX_MSSQLLOCKTEST ON MSSQLLOCKTEST(MSMT_TIME);
alter table MSSQLLOCKTEST add constraint PK_MSSQLLOCKTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLLOCKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLLOCKTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	AVG_WTTIME_MIN			NUMBER(20,4)    NOT NULL,
	AVG_WTTIME_MAX			NUMBER(20,4)    NOT NULL,
	AVG_WTTIME_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_REQ_MIN			NUMBER(20,4)    NOT NULL,
	LOCK_REQ_MAX			NUMBER(20,4)    NOT NULL,
	LOCK_REQ_STCNT			VARCHAR2(32)    NOT NULL,
	LOCK_WAIT_MIN			NUMBER(20,4)    NOT NULL,
	LOCK_WAIT_MAX			NUMBER(20,4)    NOT NULL,
	LOCK_WAIT_STCNT			VARCHAR2(32)    NOT NULL,
	NUM_DEADLOCK_MIN		NUMBER(20,4)    NOT NULL,
	NUM_DEADLOCK_MAX		NUMBER(20,4)    NOT NULL,
	NUM_DEADLOCK_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_TIMEOUTS_MIN		NUMBER(20,4)    NOT NULL,
	LOCK_TIMEOUTS_MAX		NUMBER(20,4)    NOT NULL,
	LOCK_TIMEOUTS_STCNT		VARCHAR2(32)    NOT NULL);
alter table MSSQLLOCKTEST_TREND add constraint PK_MSSQLLOCKTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLLOCKTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MSSQLLOCKTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        AVG_WTTIME_MIN		VARCHAR2(256)	    NOT NULL,
	AVG_WTTIME_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_REQ_MIN		VARCHAR2(256)	    NOT NULL,
	LOCK_REQ_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_WAIT_MIN		VARCHAR2(256)	    NOT NULL,
	LOCK_WAIT_MAX		VARCHAR2(256)	    NOT NULL,
	NUM_DEADLOCK_MIN	VARCHAR2(256)	    NOT NULL,
	NUM_DEADLOCK_MAX	VARCHAR2(256)	    NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR2(256)	    NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR2(256)	    NOT NULL);

alter table MSSQLLOCKTEST_THRESH add constraint PK_MSSQLLOCKTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLLOCKTEST_THRESH ON MSSQLLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MSSQLMEMORYTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLMEMORYTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	TOT_SERVMEM			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_ST			VARCHAR2(32)    NOT NULL,
	TGT_SERVMEM			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_ST			VARCHAR2(32)    NOT NULL,
	SQL_CACHEMEM			NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_ST			VARCHAR2(32)    NOT NULL,
	OPTZ_MEM			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_ST			VARCHAR2(32)    NOT NULL,
	MAX_WORKSPMEM			NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_ST		VARCHAR2(32)    NOT NULL,
	LOCK_MEM			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_ST			VARCHAR2(32)    NOT NULL,
	GRANT_WKSPACEMEM		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_ST		VARCHAR2(32)    NOT NULL,
	CONNEC_MEM			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_ST			VARCHAR2(32)    NOT NULL,
	MEMORY_GRANTS_PENDING		NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_ST	VARCHAR2(32)    NOT NULL
	);
CREATE  INDEX IDX_MSSQLMEMORYTEST ON MSSQLMEMORYTEST(MSMT_TIME);
ALTER TABLE MSSQLMEMORYTEST add constraint PK_MSSQLMEMORYTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLMEMORYTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLMEMORYTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	TOT_SERVMEM_MIN			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_MAX			NUMBER(20,4)    NOT NULL,	
	TOT_SERVMEM_STCNT		VARCHAR2(32)    NOT NULL,
	TGT_SERVMEM_MIN			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_MAX			NUMBER(20,4)    NOT NULL,	
	TGT_SERVMEM_STCNT		VARCHAR2(32)    NOT NULL,
	SQL_CACHEMEM_MIN		NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_MAX		NUMBER(20,4)    NOT NULL,	
	SQL_CACHEMEM_STCNT		VARCHAR2(32)    NOT NULL,
	OPTZ_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	OPTZ_MEM_STCNT			VARCHAR2(32)    NOT NULL,
	MAX_WORKSPMEM_MIN		NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_MAX		NUMBER(20,4)    NOT NULL,	
	MAX_WORKSPMEM_STCNT		VARCHAR2(32)    NOT NULL,
	LOCK_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	LOCK_MEM_STCNT			VARCHAR2(32)    NOT NULL,
	GRANT_WKSPACEMEM_MIN		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_MAX		NUMBER(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_STCNT		VARCHAR2(32)    NOT NULL,
	CONNEC_MEM_MIN			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_MAX			NUMBER(20,4)    NOT NULL,	
	CONNEC_MEM_STCNT		VARCHAR2(32)    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_MAX	NUMBER(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_STCNT	VARCHAR2(32)    NOT NULL
);


ALTER TABLE MSSQLMEMORYTEST_TREND add constraint PK_MSSQLMEMORYTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLMEMORYTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLMEMORYTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32),         
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        TOT_SERVMEM_MIN			VARCHAR2(256)	    NOT NULL,
	TOT_SERVMEM_MAX			VARCHAR2(256)	    NOT NULL,
	TGT_SERVMEM_MIN			VARCHAR2(256)	    NOT NULL,
	TGT_SERVMEM_MAX			VARCHAR2(256)	    NOT NULL,
	SQL_CACHEMEM_MIN		VARCHAR2(256)	    NOT NULL,
	SQL_CACHEMEM_MAX		VARCHAR2(256)	    NOT NULL,
	OPTZ_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	OPTZ_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	MAX_WORKSPMEM_MIN		VARCHAR2(256)	    NOT NULL,
	MAX_WORKSPMEM_MAX		VARCHAR2(256)	    NOT NULL,
	LOCK_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	LOCK_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MIN		VARCHAR2(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MAX		VARCHAR2(256)	    NOT NULL,
	CONNEC_MEM_MIN			VARCHAR2(256)	    NOT NULL,
	CONNEC_MEM_MAX			VARCHAR2(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	VARCHAR2(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MAX	VARCHAR2(256)	    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST_THRESH add constraint PK_MSSQLMEMORYTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLMEMORYTEST_THRESH ON MSSQLMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLSESSIONTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLSESSIONTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	LOGIN_COUNTER		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_ST	VARCHAR2(32)    NOT NULL,
	LOGOUT_COUNTER		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_ST	VARCHAR2(32)    NOT NULL,	
	USER_CONNECTION		NUMBER(20,4)     NOT NULL,
	USER_CONNECTION_ST	VARCHAR2(32)    NOT NULL,
	LOGICAL_CONNECTIONS	NUMBER(20,4)     NOT NULL,
	LOGICAL_CONNECTIONS_ST	VARCHAR2(32)    NOT NULL
	);
CREATE INDEX IDX_MSSQLSESSIONTEST ON MSSQLSESSIONTEST(MSMT_TIME);

ALTER TABLE MSSQLSESSIONTEST add constraint PK_MSSQLSESSIONTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLSESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLSESSIONTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	LOGIN_COUNTER_MIN		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_MAX		NUMBER(20,4)    NOT NULL,
	LOGIN_COUNTER_STCNT		VARCHAR2(32)    NOT NULL,
	LOGOUT_COUNTER_MIN		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_MAX		NUMBER(20,4)    NOT NULL,
	LOGOUT_COUNTER_STCNT		VARCHAR2(32)    NOT NULL,
	USER_CONNECTION_MIN		NUMBER(20,4)    NOT NULL,
	USER_CONNECTION_MAX		NUMBER(20,4)    NOT NULL,
	USER_CONNECTION_STCNT		VARCHAR2(32)    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		NUMBER(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		NUMBER(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_STCNT	VARCHAR2(32)    NOT NULL
);


ALTER TABLE MSSQLSESSIONTEST_TREND add constraint PK_MSSQLSESSIONTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLSESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLSESSIONTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        LOGIN_COUNTER_MIN	VARCHAR2(256)	    NOT NULL,
	LOGIN_COUNTER_MAX	VARCHAR2(256)	    NOT NULL,
	LOGOUT_COUNTER_MIN	VARCHAR2(256)	    NOT NULL,
	LOGOUT_COUNTER_MAX	VARCHAR2(256)	    NOT NULL,
	USER_CONNECTION_MIN	VARCHAR2(256)	    NOT NULL,
	USER_CONNECTION_MAX	VARCHAR2(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MIN	VARCHAR2(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE MSSQLSESSIONTEST_THRESH add constraint PK_MSSQLSESSIONTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLSESSIONTEST_THRESH ON MSSQLSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLTRANSACTIONTEST CASCADE CONSTRAINTS;
CREATE TABLE MSSQLTRANSACTIONTEST 
(
        TRGT_HOST		varchar2(32),
        PORT_NO             	varchar2(32),
        SITE_NAME          	varchar2(64),
        INFO              	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME         	date,
	ACTIVE_TRAN		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_ST		VARCHAR2(32)    NOT NULL,
	LOG_FLUSHWT		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_ST		VARCHAR2(32)    NOT NULL,
	REPL_PNDXACTS		NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_ST	VARCHAR2(32)    NOT NULL,
	REPL_TRANRT		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_ST		VARCHAR2(32)    NOT NULL,
	NUM_TRANSACT		NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_ST		VARCHAR2(32)    NOT NULL
	);

alter table MSSQLTRANSACTIONTEST add constraint PK_MSSQLTRANSACTIONTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MSSQLTRANSACTIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MSSQLTRANSACTIONTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	ACTIVE_TRAN_MIN		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_MAX		NUMBER(20,4)    NOT NULL,	
	ACTIVE_TRAN_STCNT	VARCHAR2(32)    NOT NULL,
	LOG_FLUSHWT_MIN		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_MAX		NUMBER(20,4)    NOT NULL,	
	LOG_FLUSHWT_STCNT	VARCHAR2(32)    NOT NULL,
	REPL_PNDXACTS_MIN	NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_MAX	NUMBER(20,4)    NOT NULL,	
	REPL_PNDXACTS_STCNT	VARCHAR2(32)    NOT NULL,
	REPL_TRANRT_MIN		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_MAX		NUMBER(20,4)    NOT NULL,	
	REPL_TRANRT_STCNT	VARCHAR2(32)    NOT NULL,
	NUM_TRANSACT_MIN	NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_MAX	NUMBER(20,4)    NOT NULL,	
	NUM_TRANSACT_STCNT	VARCHAR2(32)    NOT NULL
	);


alter table MSSQLTRANSACTIONTEST_TREND add constraint PK_MSSQLTRANSACTIONTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLTRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MSSQLTRANSACTIONTEST_THRESH 
(
        TRGT_HOST               	varchar2(32),
        PORT_NO             	    	varchar2(32),
        SITE_NAME           	    	varchar2(64),
        INFO                	    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START         	date,
        MSMT_TIME_END           	date,
        ACTIVE_TRAN_MIN	VARCHAR2(256)	    NOT NULL,
	ACTIVE_TRAN_MAX	VARCHAR2(256)	    NOT NULL,
	LOG_FLUSHWT_MIN	VARCHAR2(256)	    NOT NULL,
	LOG_FLUSHWT_MAX	VARCHAR2(256)	    NOT NULL,
	REPL_PNDXACTS_MIN	VARCHAR2(256)	    NOT NULL,
	REPL_PNDXACTS_MAX	VARCHAR2(256)	    NOT NULL,
	REPL_TRANRT_MIN	VARCHAR2(256)	    NOT NULL,
	REPL_TRANRT_MAX	VARCHAR2(256)	    NOT NULL,
	NUM_TRANSACT_MIN	VARCHAR2(256)	    NOT NULL,
	NUM_TRANSACT_MAX	VARCHAR2(256)	    NOT NULL
);

alter table MSSQLTRANSACTIONTEST_THRESH add constraint PK_MSSQLTRANSACTIONTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSSQLTRANS2TEST_THRESH ON MSSQLTRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE MsXCacheTest CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	cacheHitRatio			number(20,4) not null,
	cacheHitRatio_ST		varchar2(32) not null
);

ALTER TABLE MsXCacheTest ADD constraint PK_MsXCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXCacheTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	cacheHitRatio_min		number(20,4) not null,
	cacheHitRatio_max		number(20,4) not null,
	cacheHitRatio_stcnt		varchar2(32) not null
);

ALTER TABLE MsXCacheTest_TREND ADD constraint PK_MsXCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXCacheTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXCacheTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
 	MSMT_TIME_END   		date,
 	CACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXCacheTest_THRESH ADD constraint PK_MsXCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXCacheTest_THRESH ON MsXCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXDBTest CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	dbCacheHit			number(20,4) not null,
	dbCacheHit_ST			varchar2(32) not null,
	dbTablesCacheHit		number(20,4) not null,
	dbTablesCacheHit_st		varchar2(32) not null,
	logRecrdWaitingRate		number(20,4) not null,
	logRecrdWaitingRate_st		varchar2(32) not null,
	logThreadWaiting		Number(20,4) not null,
	logThreadWaiting_st		varchar2(32) not null
);

ALTER TABLE MsXDBTest ADD constraint PK_MsXDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXDBTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	dbCacheHit_min			number(20,4) not null,
	dbCacheHit_max			number(20,4) not null,
	dbCacheHit_stcnt		varchar2(32) not null,
	dbTablesCacheHit_min		number(20,4) not null,
	dbTablesCacheHit_max		number(20,4) not null,
	dbTablesCacheHit_stcnt		varchar2(32) not null,
	logRecrdWaitingRate_min		number(20,4) not null,
	logRecrdWaitingRate_max		number(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar2(32) not null,
	logThreadWaiting_min		Number(20,4) not null,
	logThreadWaiting_max		Number(20,4) not null,
	logThreadWaiting_stcnt		varchar2(32) not null
);

ALTER TABLE MsXDBTest_TREND ADD constraint PK_MsXDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXDBTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXDBTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
  MSMT_TIME_END   		date,
  DBCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXDBTest_THRESH ADD constraint PK_MsXDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXDBTest_THRESH ON MsXDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXMailRetrvlTest CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currPop3Conn			Number(20,4) not null,
	currPop3Conn_st			varchar2(32) not null,
	currImapConn			Number(20,4) not null,
	currImapConn_st			varchar2(32) not null,
	pop3ClientWaitingReq		Number(20,4) not null,
	pop3ClientWaitingReq_st		varchar2(32) not null,
	imapClientWaitingReq		Number(20,4) not null,
	imapClientWaitingReq_st		varchar2(32) not null
);

ALTER TABLE MsXMailRetrvlTest ADD constraint PK_MsXMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXMailRetrvlTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currPop3Conn_min		Number(20,4) not null,
	currPop3Conn_max		Number(20,4) not null,
	currPop3Conn_stcnt		varchar2(32) not null,
	currImapConn_min		Number(20,4) not null,
	currImapConn_max		Number(20,4) not null,
	currImapConn_stcnt		varchar2(32) not null,
	pop3ClientWaitingReq_min		Number(20,4) not null,
	pop3ClientWaitingReq_max		Number(20,4) not null,
	pop3ClientWaitingReq_stcnt		varchar2(32) not null,
	imapClientWaitingReq_min		Number(20,4) not null,
	imapClientWaitingReq_max		Number(20,4) not null,
	imapClientWaitingReq_stcnt		varchar2(32) not null
);

ALTER TABLE MsXMailRetrvlTest_TREND ADD constraint PK_MsXMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailRetrvlTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRPOP3CONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MIN	VARCHAR2(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MAX	VARCHAR2(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MIN	VARCHAR2(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXMailRetrvlTest_THRESH ADD constraint PK_MsXMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailRetrvlTest_THRESH ON MsXMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE MsXMailSvcTest CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
INBOUND_QSIZE Number(20,4) NOT NULL,
INBOUND_QSIZE_ST varchar2(32) NOT NULL,
OUTBOUND_QSIZE Number(20,4) NOT NULL,
OUTBOUND_QSIZE_ST varchar2(32) NOT NULL,
MTS_IN_QSIZE Number(20,4) NOT NULL,
MTS_IN_QSIZE_ST varchar2(32) NOT NULL,
MTS_OUT_QSIZE Number(20,4) NOT NULL,
MTS_OUT_QSIZE_ST varchar2(32) NOT NULL,
IN_CONNS Number(20,4) NOT NULL,
IN_CONNS_ST varchar2(32) NOT NULL,
OUT_CONNS Number(20,4) NOT NULL,
OUT_CONNS_ST varchar2(32) NOT NULL,
CONNS_FAILED Number(20,4) NOT NULL,
CONNS_FAILED_ST varchar2(32) NOT NULL,
CONNS_REJECTED Number(20,4) NOT NULL,
CONNS_REJECTED_ST varchar2(32) NOT NULL,
IN_MSGS Number(20,4) NOT NULL,
IN_MSGS_ST varchar2(32) NOT NULL,
OUT_MSGS Number(20,4) NOT NULL,
OUT_MSGS_ST varchar2(32) NOT NULL);

ALTER TABLE MsXMailSvcTest ADD constraint PK_MsXMailSvcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsXMailSvcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
INBOUND_QSIZE_MIN Number(20,4) NOT NULL,
INBOUND_QSIZE_MAX Number(20,4) NOT NULL,
INBOUND_QSIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_QSIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_QSIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_QSIZE_STCNT varchar2(32) NOT NULL,
MTS_IN_QSIZE_MIN Number(20,4) NOT NULL,
MTS_IN_QSIZE_MAX Number(20,4) NOT NULL,
MTS_IN_QSIZE_STCNT varchar2(32) NOT NULL,
MTS_OUT_QSIZE_MIN Number(20,4) NOT NULL,
MTS_OUT_QSIZE_MAX Number(20,4) NOT NULL,
MTS_OUT_QSIZE_STCNT varchar2(32) NOT NULL,
IN_CONNS_MIN Number(20,4) NOT NULL,
IN_CONNS_MAX Number(20,4) NOT NULL,
IN_CONNS_STCNT varchar2(32) NOT NULL,
OUT_CONNS_MIN Number(20,4) NOT NULL,
OUT_CONNS_MAX Number(20,4) NOT NULL,
OUT_CONNS_STCNT varchar2(32) NOT NULL,
CONNS_FAILED_MIN Number(20,4) NOT NULL,
CONNS_FAILED_MAX Number(20,4) NOT NULL,
CONNS_FAILED_STCNT varchar2(32) NOT NULL,
CONNS_REJECTED_MIN Number(20,4) NOT NULL,
CONNS_REJECTED_MAX Number(20,4) NOT NULL,
CONNS_REJECTED_STCNT varchar2(32) NOT NULL,
IN_MSGS_MIN Number(20,4) NOT NULL,
IN_MSGS_MAX Number(20,4) NOT NULL,
IN_MSGS_STCNT varchar2(32) NOT NULL,
OUT_MSGS_MIN Number(20,4) NOT NULL,
OUT_MSGS_MAX Number(20,4) NOT NULL,
OUT_MSGS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsXMailSvcTest_TREND ADD constraint PK_MsXMailSvcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsXMailSvcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsXMailSvcTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
INBOUND_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
INBOUND_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
OUTBOUND_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
OUTBOUND_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
MTS_IN_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
MTS_IN_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
MTS_OUT_QSIZE_MIN	VARCHAR2(256)	 NOT NULL,
MTS_OUT_QSIZE_MAX	VARCHAR2(256)	 NOT NULL,
IN_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
IN_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
OUT_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
OUT_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_FAILED_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_FAILED_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_REJECTED_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_REJECTED_MAX	VARCHAR2(256)	 NOT NULL,
IN_MSGS_MIN	VARCHAR2(256)	 NOT NULL,
IN_MSGS_MAX	VARCHAR2(256)	 NOT NULL,
OUT_MSGS_MIN	VARCHAR2(256)	 NOT NULL,
OUT_MSGS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsXMailSvcTest_THRESH ADD constraint PK_MsXMailSvcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsXMailSvcTest_THRESH ON MsXMailSvcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailXferTest CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	localQSize			Number(20,4) not null,
	localQSize_st			varchar2(32) not null,
	remoteQSize			Number(20,4) not null,
	remoteQSize_st			varchar2(32) not null,
	currSmtpConn			Number(20,4) not null,
	currSmtpConn_st			varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null,
	avgRetryMsgDelvry		number(20,4) not null,
	avgRetryMsgDelvry_st		varchar2(32) not null,
	avgRetryMsgSent			number(20,4) not null,
	avgRetryMsgSent_st		varchar2(32) not null
);

ALTER TABLE MsXMailXferTest ADD constraint PK_MsXMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXMailXferTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	localQSize_min			Number(20,4) not null,
	localQSize_max			Number(20,4) not null,
	localQSize_stcnt		varchar2(32) not null,
	remoteQSize_min			Number(20,4) not null,
	remoteQSize_max			Number(20,4) not null,
	remoteQSize_stcnt		varchar2(32) not null,
	currSmtpConn_min		Number(20,4) not null,
	currSmtpConn_max		Number(20,4) not null,
	currSmtpConn_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null,
	avgRetryMsgDelvry_min		number(20,4) not null,
	avgRetryMsgDelvry_max		number(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar2(32) not null,
	avgRetryMsgSent_min		number(20,4) not null,
	avgRetryMsgSent_max		number(20,4) not null,
	avgRetryMsgSent_stcnt		varchar2(32) not null
);

ALTER TABLE MsXMailXferTest_TREND ADD constraint PK_MsXMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailXferTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXMailXferTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOCALQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXMailXferTest_THRESH ADD constraint PK_MsXMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailXferTest_THRESH ON MsXMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MsXStoreTest CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currUsers			Number(20,4) not null,
	currUsers_st			varchar2(32) not null,
	mailSendQSize			Number(20,4) not null,
	mailSendQSize_st		varchar2(32) not null,
	mailRcvdQSize			Number(20,4) not null,
	mailRcvdQSize_st		varchar2(32) not null,
	mailSentRate			number(20,4) not null,
	mailSentRate_st			varchar2(32) not null,
	mailOpensRate			number(20,4) not null,
	mailOpensRate_st		varchar2(32) not null,
	folderOpensRate			number(20,4) not null,
	folderOpensRate_st		varchar2(32) not null,
	avgMailDelvryTime			number(20,4) not null,
	avgMailDelvryTime_st		varchar2(32) not null,
	avgMailLocalDelvryTime		number(20,4) not null,
	avgMailLocalDelvryTime_st		varchar2(32) not null
);

ALTER TABLE MsXStoreTest ADD constraint PK_MsXStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   MsXStoreTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currUsers_min			Number(20,4) not null,
	currUsers_max			Number(20,4) not null,
	currUsers_stcnt			varchar2(32) not null,
	mailSendQSize_min		Number(20,4) not null,
	mailSendQSize_max		Number(20,4) not null,
	mailSendQSize_stcnt		varchar2(32) not null,
	mailRcvdQSize_min		Number(20,4) not null,
	mailRcvdQSize_max		Number(20,4) not null,
	mailRcvdQSize_stcnt		varchar2(32) not null,
	mailSentRate_min		number(20,4) not null,
	mailSentRate_max		number(20,4) not null,
	mailSentRate_stcnt		varchar2(32) not null,
	mailOpensRate_min		number(20,4) not null,
	mailOpensRate_max		number(20,4) not null,
	mailOpensRate_stcnt		varchar2(32) not null,
	folderOpensRate_min		number(20,4) not null,
	folderOpensRate_max		number(20,4) not null,
	folderOpensRate_stcnt		varchar2(32) not null,
	avgMailDelvryTime_min		number(20,4) not null,
	avgMailDelvryTime_max		number(20,4) not null,
	avgMailDelvryTime_stcnt		varchar2(32) not null,
	avgMailLocalDelvryTime_min		number(20,4) not null,
	avgMailLocalDelvryTime_max		number(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar2(32) not null
);

ALTER TABLE MsXStoreTest_TREND ADD constraint PK_MsXStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXStoreTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MsXStoreTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRUSERS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsXStoreTest_THRESH ADD constraint PK_MsXStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXStoreTest_THRESH ON MsXStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE MTSPROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)    NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)    NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE MTSPROCESSTEST ADD constraint PK_MTSPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTSPROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_TREND ADD constraint PK_MTSPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSPROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MTSPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_THRESH ADD constraint PK_MTSPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MTSPROCESSTEST_THRESH ON MTSPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE MTSTEST CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	TOTAL_PACKAGES_COUNT		number(4)	NOT NULL, 	
	TOTAL_PACKAGES_COUNT_ST		varchar2(32)	NOT NULL,
	TOTAL_COMPONENTS_COUNT		number(6)	NOT NULL,
	TOTAL_COMPONENTS_COUNT_ST	varchar2(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT	number(4)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_ST 	varchar2(32)	NOT NULL
);

ALTER TABLE MTSTEST ADD constraint PK_MTS	
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 			varchar2(32),
	TOTAL_PACKAGES_COUNT_MIN	number(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_MAX	number(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_STCNT	varchar2(32)	NOT NULL, 	
	TOTAL_COMPONENTS_COUNT_MIN	number(6)		NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	number(6)		NOT NULL,	
	TOTAL_COMPONENTS_COUNT_STCNT	varchar2(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	number(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	number(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_STCNT	varchar2(32)	NOT NULL
);

ALTER TABLE MTSTEST_TREND ADD constraint PK_MTS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MTSTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
	TOTAL_PACKAGES_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_PACKAGES_COUNT_MAX	VARCHAR2(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	VARCHAR2(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	VARCHAR2(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE MTSTEST_THRESH ADD constraint PK_MTS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MTSTEST_THRESH ON MTSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE NASSNMPTEST  CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                         varchar2(32),
        SITE_NAME                       varchar2(64),
        INFO                            varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	REQ_RATE 			number(20,4)	NOT NULL,
	REQ_RATE_ST 			varchar2(32)		NOT NULL,
	RESP_TIME 			number(20,4)	NOT NULL,
	RESP_TIME_ST 			varchar2(32)		NOT NULL,
	PCT_ACTIVE_THREADS		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_ST		varchar2(32)		NOT NULL,
	DATA_RATE_OUT 			number(20,4)	NOT NULL,
	DATA_RATE_OUT_ST 		varchar2(32)		NOT NULL,
	DATA_RATE_IN 			number(20,4)	NOT NULL,
	DATA_RATE_IN_ST 		varchar2(32)		NOT NULL
);

ALTER TABLE NASSNMPTEST ADD CONSTRAINT PK_NAS_SNMP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NASSNMPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                         varchar2(32),
        SITE_NAME                       varchar2(64),
        INFO                            varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	REQ_RATE_MIN 			number(20,4)	NOT NULL,
	REQ_RATE_MAX 			number(20,4)	NOT NULL,
	REQ_RATE_STCNT		 	varchar2(32)	NOT NULL,
	RESP_TIME_MIN 			number(20,4)	NOT NULL,
	RESP_TIME_MAX 			number(20,4)	NOT NULL,
	RESP_TIME_STCNT 		varchar2(32)	NOT NULL,
	PCT_ACTIVE_THREADS_MIN		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_MAX		number(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_STCNT 	varchar2(32)	NOT NULL,
	DATA_RATE_OUT_MIN 		number(20,4)	NOT NULL,
	DATA_RATE_OUT_MAX 		number(20,4)	NOT NULL,
	DATA_RATE_OUT_STCNT 		varchar2(32)	NOT NULL,
	DATA_RATE_IN_MIN 		number(20,4)	NOT NULL,
	DATA_RATE_IN_MAX 		number(20,4)	NOT NULL,
	DATA_RATE_IN_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE NASSNMPTEST_TREND ADD CONSTRAINT PK_NAS_SNMP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE NASSNMPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NASSNMPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	REQ_RATE_MIN	VARCHAR2(256)		NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)		NOT NULL,
	RESP_TIME_MIN	VARCHAR2(256)		NOT NULL,
	RESP_TIME_MAX	VARCHAR2(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MIN	VARCHAR2(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MAX	VARCHAR2(256)		NOT NULL,
	DATA_RATE_OUT_MIN	VARCHAR2(256)		NOT NULL,
	DATA_RATE_OUT_MAX	VARCHAR2(256)		NOT NULL,
	DATA_RATE_IN_MIN	VARCHAR2(256)		NOT NULL,
	DATA_RATE_IN_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE NASSNMPTEST_THRESH ADD CONSTRAINT PK_NAS_SNMP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NASSNMPTEST_THRESH ON NASSNMPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE NETWORKBANDWIDTHTEST CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        RCVD_RATE           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_ST        VARCHAR2(32)    NOT NULL,
        XMIT_RATE           NUMBER(20,4)    NOT NULL,
        XMIT_RATE_ST        VARCHAR2(32)    NOT NULL,
        PCT_BANDW             NUMBER(20,4)    NOT NULL,
        PCT_BANDW_ST          VARCHAR2(32)    NOT NULL
);

alter table NETWORKBANDWIDTHTEST add constraint PK_NETWORKBANDWIDTHTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKBANDWIDTHTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        RCVD_RATE_MIN           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_MAX           	NUMBER(20,4)    NOT NULL,
        RCVD_RATE_STCNT        	VARCHAR2(32)    NOT NULL,
        XMIT_RATE_MIN          	NUMBER(20,4)    NOT NULL,
        XMIT_RATE_MAX           	NUMBER(20,4)    NOT NULL,
        XMIT_RATE_STCNT        	VARCHAR2(32)    NOT NULL,
        PCT_BANDW_MIN                    NUMBER(20,4)    NOT NULL,
        PCT_BANDW_MAX             	NUMBER(20,4)    NOT NULL,
        PCT_BANDW_STCNT          	VARCHAR2(32)    NOT NULL
);


alter table NETWORKBANDWIDTHTEST_TREND add constraint PK_NETWORKBANDWIDTHTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKBANDWIDTHTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKBANDWIDTHTEST_THRESH 
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        RCVD_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        RCVD_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        XMIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
        XMIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        PCT_BANDW_MIN	VARCHAR2(256)	    NOT NULL,
        PCT_BANDW_MAX	VARCHAR2(256)	    NOT NULL
);

alter table NETWORKBANDWIDTHTEST_THRESH add constraint PK_NETWORKBANDWIDTHTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETBANDWIDTHTEST_THRESH ON NETWORKBANDWIDTHTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE NETWORKTEST CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST 
(
	TRGT_HOST            varchar2(32),
    PORT_NO              varchar2(32),
    SITE_NAME            varchar2(64),
    INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
    MSMT_TIME            date,
	AVG_RND_TRIP	     number(20,4)      NOT NULL,
	AVG_RND_TRIP_ST      varchar2(32)      NOT NULL,
	MIN_RND_TRIP	     number(20,4)      NOT NULL,
	MIN_RND_TRIP_ST	     varchar2(32)      NOT NULL,
	PKT_LOSS_PCT	     number(20,4)       NOT NULL,
	PKT_LOSS_PCT_ST	     varchar2(32)      NOT NULL,
	AVAILABILITY	     NUMBER(3)	     NOT NULL,
	AVAILABILITY_ST	     VARCHAR2(32)    NOT NULL
);
CREATE  INDEX IDX1_NETWORKTEST ON NETWORKTEST(PKT_LOSS_PCT,AVAILABILITY,AVG_RND_TRIP);
alter table NETWORKTEST add constraint PK_NETWORK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST_TREND 
(
	TRGT_HOST            		varchar2(32),
    PORT_NO              		varchar2(32),
    SITE_NAME            		varchar2(64),
    INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD	             		varchar2(32), 
	AVG_RND_TRIP_MIN		number(20,4)      NOT NULL,
	AVG_RND_TRIP_MAX		number(20,4)      NOT NULL,
	AVG_RND_TRIP_STCNT 		varchar2(32)      NOT NULL,
	MIN_RND_TRIP_MIN     		number(20,4)      NOT NULL,
	MIN_RND_TRIP_MAX     		number(20,4)      NOT NULL,
	MIN_RND_TRIP_STCNT 		varchar2(32)      NOT NULL,
	PKT_LOSS_PCT_MIN		number(20,4)       NOT NULL,
	PKT_LOSS_PCT_MAX		number(20,4)       NOT NULL,
	PKT_LOSS_PCT_STCNT 		varchar2(32)      NOT NULL,
	AVAILABILITY_MIN	NUMBER(3)	    NOT NULL,
	AVAILABILITY_MAX	NUMBER(3)	    NOT NULL,
	AVAILABILITY_STCNT	VARCHAR2(32)    NOT NULL
);

alter table NETWORKTEST_TREND add constraint PK_NETWORK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTEST_THRESH 
(
	TRGT_HOST               varchar2(32),
    PORT_NO                 varchar2(32),
    SITE_NAME               varchar2(64),
    INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
    MSMT_TIME_END           date,
	AVG_RND_TRIP_MIN	VARCHAR2(256)	 NOT NULL,
	AVG_RND_TRIP_MAX	VARCHAR2(256)	 NOT NULL,
	MIN_RND_TRIP_MIN	VARCHAR2(256)	 NOT NULL,
	MIN_RND_TRIP_MAX	VARCHAR2(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR2(256)	  NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR2(256)	  NOT NULL,
	AVAILABILITY_MIN	VARCHAR2(256)	     NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	     NOT NULL
);

alter table NETWORKTEST_THRESH add constraint PK_NETWORK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTEST_THRESH ON NETWORKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE UdNETWORKTRAFFICTEST  CASCADE CONSTRAINTS;

CREATE TABLE UdNETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME       date,
	INP_PKT_RATE	number(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar2(32)      NOT NULL,
	OUT_PKT_RATE 	number(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar2(32)      NOT NULL
);

alter table UdNETWORKTRAFFICTEST add constraint PK_UdNETWORKTRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

  
DROP TABLE NETWORKTRAFFICTEST  CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME       date,
	INP_PKT_RATE	number(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar2(32)      NOT NULL,
	OUT_PKT_RATE 	number(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar2(32)      NOT NULL
);

alter table NETWORKTRAFFICTEST add constraint PK_NETWORK_TRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NETWORKTRAFFICTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST_TREND 
(
	TRGT_HOST       		varchar2(32),
        PORT_NO         		varchar2(32),
        SITE_NAME       		varchar2(64),
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	INP_PKT_RATE_MIN		number(20,4) NOT NULL,
	INP_PKT_RATE_MAX		number(20,4) NOT NULL,
	INP_PKT_RATE_STCNT 		varchar2(32) NOT NULL,
	OUT_PKT_RATE_MIN 		number(20,4) NOT NULL,
	OUT_PKT_RATE_MAX 		number(20,4) NOT NULL,
	OUT_PKT_RATE_STCNT 		varchar2(32) NOT NULL
);

alter table NETWORKTRAFFICTEST_TREND add constraint PK_NETWORK_TRAFFIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTRAFFICTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NETWORKTRAFFICTEST_THRESH
(
	TRGT_HOST       varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START date,
        MSMT_TIME_END   date,
	INP_PKT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	INP_PKT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_PKT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_PKT_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

alter table NETWORKTRAFFICTEST_THRESH add constraint PK_NET_TRAFFIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTRAFFICTEST_THRESH ON NETWORKTRAFFICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE NewsGroupTest CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	logonFailureRate		number(20,4) not null,
	logonFailureRate_st		varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null
);

ALTER TABLE NewsGroupTest ADD constraint PK_NewsGroupTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   NewsGroupTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	logonFailureRate_min		number(20,4) not null,
	logonFailureRate_max		number(20,4) not null,
	logonFailureRate_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null
);

ALTER TABLE NewsGroupTest_TREND ADD constraint PK_NewsGroupTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   NewsGroupTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE NewsGroupTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOGONFAILURERATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGONFAILURERATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE NewsGroupTest_THRESH ADD constraint PK_NewsGroupTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_NewsGroupTest_THRESH ON NewsGroupTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE ORADATAFILETEST CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        PHY_BLKRDS_RATE	     NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_ST   VARCHAR2(32)    NOT NULL, 
        PHY_BLKWRTS_RATE     NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_ST  VARCHAR2(32)    NOT NULL,
		PCT_USAGE			 NUMBER(20,4)	 NOT NULL,
		PCT_USAGE_ST		 VARCHAR2(32)	 NOT NULL      
);

alter table ORADATAFILETEST add constraint PK_ORA_DATAFILE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORADATAFILETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD            		varchar2(32), 
        PHY_BLKRDS_RATE_MIN	        NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_MAX	        NUMBER(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_STCNT   	VARCHAR2(32)    NOT NULL, 
        PHY_BLKWRTS_RATE_MIN     	NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_MAX     	NUMBER(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_STCNT  	VARCHAR2(32)    NOT NULL,
		PCT_USAGE_MIN				NUMBER(20,4)	NOT NULL,
		PCT_USAGE_MAX				NUMBER(20,4)	NOT NULL,
		PCT_USAGE_STCNT				VARCHAR2(32)	NOT NULL     
);


alter table ORADATAFILETEST_TREND add constraint PK_ORA_DATAFILE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORADATAFILETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORADATAFILETEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        PHY_BLKRDS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_BLKRDS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
		PCT_USAGE_MIN	VARCHAR2(256)	  NOT NULL,
		PCT_USAGE_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORADATAFILETEST_THRESH add constraint PK_ORA_DATAFILE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORADATAFILETEST_THRESH ON ORADATAFILETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORALOCKTEST CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST 
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME            date,
        CURR_LOCK            NUMBER(20,4)    NOT NULL,
        CURR_LOCK_ST         VARCHAR2(32)    NOT NULL,
        AVG_LOCK_TIME        NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_ST     VARCHAR2(32)    NOT NULL 
);

alter table ORALOCKTEST add constraint PK_ORA_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORALOCKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
        CURR_LOCK_MIN           	NUMBER(20,4)    NOT NULL,
        CURR_LOCK_MAX           	NUMBER(20,4)    NOT NULL,
        CURR_LOCK_STCNT         	VARCHAR2(32)    NOT NULL,
        AVG_LOCK_TIME_MIN        	NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_MAX        	NUMBER(20,4)    NOT NULL,
        AVG_LOCK_TIME_STCNT     	VARCHAR2(32)    NOT NULL 
);


alter table ORALOCKTEST_TREND add constraint PK_ORA_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORALOCKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORALOCKTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        CURR_LOCK_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_LOCK_MAX	VARCHAR2(256)	  NOT NULL,
        AVG_LOCK_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        AVG_LOCK_TIME_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORALOCKTEST_THRESH add constraint PK_ORA_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORALOCKTEST_THRESH ON ORALOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);         
DROP TABLE ORAPROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)     	NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)     	NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)     	NOT NULL
);

ALTER TABLE ORAPROCESSTEST ADD constraint PK_ORAPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORAPROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32), 
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_TREND ADD constraint PK_ORAPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAPROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORAPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_THRESH ADD constraint PK_ORAPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORAPROCESSTEST_THRESH ON ORAPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORAROLLBACKTEST CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST
(
        TRGT_HOST                 varchar2(32),
        PORT_NO                   varchar2(32),
        SITE_NAME                 varchar2(64),
        INFO                      varchar2(128),
	MSMT_HOST 		  varchar2(32), 
	MSMT_TIME                 date,
	PCT_SYS_SEG_WAIT       	  NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_ST       VARCHAR2(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT      NUMBER(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_ST   VARCHAR2(32)    NOT NULL
);

alter table ORAROLLBACKTEST add constraint PK_ORA_ROLLBACK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORAROLLBACKTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST_TREND
(
        TRGT_HOST                 		varchar2(32),
        PORT_NO                   		varchar2(32),
        SITE_NAME                 		varchar2(64),
        INFO                      		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME                 		date,
	PERIOD                 			varchar2(32), 
	PCT_SYS_SEG_WAIT_MIN        		NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX        		NUMBER(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_STCNT       		VARCHAR2(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN      		NUMBER(20,4)     NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MAX      		NUMBER(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_STCNT   		VARCHAR2(32)    NOT NULL
);


alter table ORAROLLBACKTEST_TREND add constraint PK_ORA_ROLL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAROLLBACKTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORAROLLBACKTEST_THRESH
(
        TRGT_HOST                  varchar2(32),
        PORT_NO                    varchar2(32),
        SITE_NAME                  varchar2(64),
        INFO                       varchar2(128),
	MSMT_HOST 		   varchar2(32), 
	MSMT_TIME_START            date,
        MSMT_TIME_END              date,
	PCT_SYS_SEG_WAIT_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX	VARCHAR2(256)		   NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN	VARCHAR2(256)	     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_MAX	VARCHAR2(256)		   NOT NULL
);

alter table ORAROLLBACKTEST_THRESH add constraint PK_ORA_ROLL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ORAROLLBACKTEST_THRESH ON ORAROLLBACKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORASESSIONTEST CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST 
(
        TRGT_HOST              varchar2(32),
        PORT_NO                varchar2(32),
        SITE_NAME              varchar2(64),
        INFO                   varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME              date,
        CURR_SESSIONS           NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_ST        VARCHAR2(32)    NOT NULL,
        CURR_ACT_SESSION       NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_ST    VARCHAR2(32)    NOT NULL,
	BACKGROUND_SESSION       NUMBER(20,4)    NOT NULL,
        BACKGROUND_SESSION_ST    VARCHAR2(32)    NOT NULL,
	INACTIVE_SESSION       NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_ST    VARCHAR2(32)    NOT NULL,
	KILLED_SESSION       NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	CACHED_SESSION       NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	SNIPED_SESSION       NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_ST    VARCHAR2(32)    NOT NULL,
	BLOCKED_SESSION       NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_ST    VARCHAR2(32)    NOT NULL
);

alter table ORASESSIONTEST add constraint PK_ORA_SESSION
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORASESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST_TREND
(
        TRGT_HOST              		varchar2(32),
        PORT_NO                		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                   		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME              		date,
	PERIOD              		varchar2(32), 
        CURR_SESSIONS_MIN      		NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_MAX      		NUMBER(20,4)    NOT NULL,
        CURR_SESSIONS_STCNT       	VARCHAR2(32)    NOT NULL,
        CURR_ACT_SESSION_MIN            NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_MAX            NUMBER(20,4)    NOT NULL,
        CURR_ACT_SESSION_STCNT    	VARCHAR2(32)    NOT NULL,
	BACKGROUND_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	BACKGROUND_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	BACKGROUND_SESSION_STCNT	VARCHAR2(32)    NOT NULL,
	INACTIVE_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	INACTIVE_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	KILLED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	KILLED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	CACHED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	CACHED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	SNIPED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	SNIPED_SESSION_STCNT		VARCHAR2(32)    NOT NULL,
	BLOCKED_SESSION_MIN		NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_MAX		NUMBER(20,4)    NOT NULL,
	BLOCKED_SESSION_STCNT		VARCHAR2(32)    NOT NULL
);


alter table ORASESSIONTEST_TREND add constraint PK_ORA_SESSION_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORASESSIONTEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        CURR_SESSIONS_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_SESSIONS_MAX	VARCHAR2(256)	  NOT NULL,
        CURR_ACT_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_ACT_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	BACKGROUND_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	BACKGROUND_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	INACTIVE_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	INACTIVE_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	KILLED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	KILLED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	CACHED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	CACHED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	SNIPED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	SNIPED_SESSION_MAX	VARCHAR2(256)	  NOT NULL,
	BLOCKED_SESSION_MIN	VARCHAR2(256)	  NOT NULL,
	BLOCKED_SESSION_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORASESSIONTEST_THRESH add constraint PK_ORA_SESSION_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASESSIONTEST_THRESH ON ORASESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORASGATEST CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST
(
        TRGT_HOST                 varchar2(32),
        PORT_NO                   varchar2(32),
        SITE_NAME                 varchar2(64),
        INFO                      varchar2(128),
	MSMT_HOST 		  varchar2(32), 
	MSMT_TIME                 date,
	PCT_LIBCACHE_RATIO        NUMBER(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_ST     VARCHAR2(32)     NOT NULL,
	PCT_DICTCACHE_RATIO       NUMBER(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_ST    VARCHAR2(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO     NUMBER(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_ST  VARCHAR2(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO    NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_ST VARCHAR2(32)   NOT NULL,
	PCT_SORTS_DISK            NUMBER(20,4)      NOT NULL,
        PCT_SORTS_DISK_ST         VARCHAR2(32)     NOT NULL,
	SGA_CURR_USAGE            NUMBER(20,4)      NOT NULL,
        SGA_CURR_USAGE_ST         VARCHAR2(32)     NOT NULL,
	BUFFER_NOWAIT_PCT         NUMBER(20,4)      NOT NULL,
        BUFFER_NOWAIT_PCT_ST      VARCHAR2(32)     NOT NULL,
	SOFT_PARSE_RATIO          NUMBER(20,4)      NOT NULL,
        SOFT_PARSE_RATIO_ST       VARCHAR2(32)     NOT NULL,
	EXECUTE_PARSE_RATIO       NUMBER(20,4)      NOT NULL,
        EXECUTE_PARSE_RATIO_ST    VARCHAR2(32)     NOT NULL,
	CPU_PARSE_RATIO           NUMBER(20,4)      NOT NULL,
        CPU_PARSE_RATIO_ST        VARCHAR2(32)     NOT NULL,
	NON_PARSE_CPU_RATIO       NUMBER(20,4)      NOT NULL,
        NON_PARSE_CPU_RATIO_ST    VARCHAR2(32)     NOT NULL,
	HARD_PARSE_RATIO          NUMBER(20,4)      NOT NULL,
        HARD_PARSE_RATIO_ST       VARCHAR2(32)     NOT NULL,
	TARGET_SIZE_PCT           NUMBER(20,4)      NOT NULL,
        TARGET_SIZE_PCT_ST        VARCHAR2(32)     NOT NULL
);

alter table ORASGATEST add constraint PK_ORA_SGA
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORASGATEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST_TREND
(
        TRGT_HOST                 		varchar2(32),
        PORT_NO                   		varchar2(32),
        SITE_NAME                 		varchar2(64),
        INFO                      		varchar2(128),
	MSMT_HOST 				varchar2(32), 
	MSMT_TIME                 		date,
	PERIOD                 			varchar2(32), 
	PCT_LIBCACHE_RATIO_MIN        		NUMBER(20,4)      NOT NULL,
	PCT_LIBCACHE_RATIO_MAX        		NUMBER(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_STCNT           	VARCHAR2(32)     NOT NULL,
	PCT_DICTCACHE_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	PCT_DICTCACHE_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_STCNT          	VARCHAR2(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MIN               NUMBER(20,4)      NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX               NUMBER(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_STCNT        	VARCHAR2(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN              NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX              NUMBER(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_STCNT       	VARCHAR2(32)   NOT NULL,
	PCT_SORTS_DISK_MIN                      NUMBER(20,4)      NOT NULL,
	PCT_SORTS_DISK_MAX                      NUMBER(20,4)      NOT NULL,
        PCT_SORTS_DISK_STCNT               	VARCHAR2(32)     NOT NULL,
	SGA_CURR_USAGE_MIN                      NUMBER(20,4)      NOT NULL,
	SGA_CURR_USAGE_MAX                      NUMBER(20,4)      NOT NULL,
        SGA_CURR_USAGE_STCNT               	VARCHAR2(32)     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN                   NUMBER(20,4)      NOT NULL,
	BUFFER_NOWAIT_PCT_MAX                   NUMBER(20,4)      NOT NULL,
        BUFFER_NOWAIT_PCT_STCNT               	VARCHAR2(32)     NOT NULL,
	SOFT_PARSE_RATIO_MIN                    NUMBER(20,4)      NOT NULL,
	SOFT_PARSE_RATIO_MAX                    NUMBER(20,4)      NOT NULL,
        SOFT_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	EXECUTE_PARSE_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        EXECUTE_PARSE_RATIO_STCNT		VARCHAR2(32)     NOT NULL,
	CPU_PARSE_RATIO_MIN                      NUMBER(20,4)      NOT NULL,
	CPU_PARSE_RATIO_MAX                      NUMBER(20,4)      NOT NULL,
        CPU_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN                 NUMBER(20,4)      NOT NULL,
	NON_PARSE_CPU_RATIO_MAX                 NUMBER(20,4)      NOT NULL,
        NON_PARSE_CPU_RATIO_STCNT               VARCHAR2(32)     NOT NULL,
	HARD_PARSE_RATIO_MIN                    NUMBER(20,4)      NOT NULL,
	HARD_PARSE_RATIO_MAX                    NUMBER(20,4)      NOT NULL,
	HARD_PARSE_RATIO_STCNT               	VARCHAR2(32)     NOT NULL,
	TARGET_SIZE_PCT_MIN                     NUMBER(20,4)      NOT NULL,
	TARGET_SIZE_PCT_MAX                     NUMBER(20,4)      NOT NULL,
	TARGET_SIZE_PCT_STCNT               	VARCHAR2(32)     NOT NULL
);

alter table ORASGATEST_TREND add constraint PK_ORA_SGA_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASGATEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ORASGATEST_THRESH
(
        TRGT_HOST			varchar2(32),
        PORT_NO				varchar2(32),
        SITE_NAME			varchar2(64),
        INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END			date,
        PCT_LIBCACHE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_LIBCACHE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
        PCT_DICTCACHE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_DICTCACHE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
        PCT_DBBUFFCACHE_RATIO_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX	VARCHAR2(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN	VARCHAR2(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX	VARCHAR2(256)	     NOT NULL,
        PCT_SORTS_DISK_MIN		VARCHAR2(256)	     NOT NULL,
	PCT_SORTS_DISK_MAX		VARCHAR2(256)	     NOT NULL,
	SGA_CURR_USAGE_MIN		VARCHAR2(256)	     NOT NULL,
	SGA_CURR_USAGE_MAX		VARCHAR2(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN		VARCHAR2(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX		VARCHAR2(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	CPU_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	CPU_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	HARD_PARSE_RATIO_MIN		VARCHAR2(256)	     NOT NULL,
	HARD_PARSE_RATIO_MAX		VARCHAR2(256)	     NOT NULL,
	TARGET_SIZE_PCT_MIN		VARCHAR2(256)	     NOT NULL,
	TARGET_SIZE_PCT_MAX		VARCHAR2(256)	     NOT NULL
);

alter table ORASGATEST_THRESH add constraint PK_ORA_SGA_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASGATEST_THRESH ON ORASGATEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE ORATABLESPACETEST CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST
(
        TRGT_HOST            varchar2(32),
        PORT_NO              varchar2(32),
        SITE_NAME            varchar2(64),
        INFO                 varchar2(128),
	MSMT_HOST 	     varchar2(32), 
	MSMT_TIME            date,
	PCT_SPACE_USED       NUMBER(20,4)     NOT NULL,
        PCT_SPACE_USED_ST    VARCHAR2(32)     NOT NULL,
        PHY_RDS_RATE	     NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_ST      VARCHAR2(32)    NOT NULL, 
        PHY_WRTS_RATE        NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_ST     VARCHAR2(32)    NOT NULL       
);

alter table ORATABLESPACETEST add constraint PK_ORA_TABLESPACE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ORATABLESPACETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST_TREND
(
        TRGT_HOST            		varchar2(32),
        PORT_NO              		varchar2(32),
        SITE_NAME            		varchar2(64),
        INFO                 		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME            		date,
	PERIOD               		varchar2(32), 
	PCT_SPACE_USED_MIN     		NUMBER(20,4)     NOT NULL,
	PCT_SPACE_USED_MAX     		NUMBER(20,4)     NOT NULL,
        PCT_SPACE_USED_STCNT    	VARCHAR2(32)     NOT NULL,
        PHY_RDS_RATE_MIN	     	NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_MAX	     	NUMBER(20,4)    NOT NULL,
        PHY_RDS_RATE_STCNT      	VARCHAR2(32)    NOT NULL, 
        PHY_WRTS_RATE_MIN        	NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_MAX        	NUMBER(20,4)    NOT NULL,
        PHY_WRTS_RATE_STCNT     	VARCHAR2(32)    NOT NULL       
);


alter table ORATABLESPACETEST_TREND add constraint PK_ORA_TABLESPACE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORATABLESPACETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ORATABLESPACETEST_THRESH
(
        TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,
        PCT_SPACE_USED_MIN	VARCHAR2(256)	   NOT NULL,
        PCT_SPACE_USED_MAX	VARCHAR2(256)	   NOT NULL,
        PHY_RDS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_RDS_RATE_MAX	VARCHAR2(256)	  NOT NULL,
        PHY_WRTS_RATE_MIN	VARCHAR2(256)	  NOT NULL,
        PHY_WRTS_RATE_MAX	VARCHAR2(256)	  NOT NULL
);

alter table ORATABLESPACETEST_THRESH add constraint PK_ORA_TABLESPACE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORATABLESPACETEST_THRESH ON ORATABLESPACETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE PROCESSTEST CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	NUM_PROC	Number(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar2(32)     	NOT NULL,
	CPU_UTIL 	number(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar2(32)     	NOT NULL,
	MEM_UTIL 	number(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar2(32)     	NOT NULL
);

ALTER TABLE PROCESSTEST ADD constraint PK_PROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PROCESSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	NUM_PROC_MIN		Number(20,4) 	NOT NULL,
	NUM_PROC_MAX		Number(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar2(32)   	NOT NULL,
	CPU_UTIL_MIN 		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar2(32)   	NOT NULL,
	MEM_UTIL_MIN 		number(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		number(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar2(32)   	NOT NULL
);

ALTER TABLE PROCESSTEST_TREND ADD constraint PK_PROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE PROCESSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	NUM_PROC_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR2(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PROCESSTEST_THRESH ADD constraint PK_PROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_PROCESSTEST_THRESH ON PROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    
DROP TABLE ReplicationTest CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	in_Obj_Appld_rate		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_ST		varchar2(32) NOT NULL,
	in_Prop_Appld_rate		number(20,4) not null,
	in_Prop_Appld_rate_ST		varchar2(32) not null,
	in_Obj_Filtrd_rate		number(20,4) not null,
	in_Obj_Filtrd_rate_ST		varchar2(32) not null,
	in_Prop_Filtrd_rate		number(20,4) not null,
	in_Prop_Filtrd_rate_ST		varchar2(32) not null,
	out_Obj_Filtrd_rate		number(20,4) not null,
	out_Obj_Filtrd_rate_ST		varchar2(32) not null,
	pending_Rep_Sync		Number(20,4) not null,
	pending_Rep_Sync_ST		varchar2(32) not null
);

ALTER TABLE ReplicationTest ADD constraint PK_Replication
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   ReplicationTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	in_Obj_Appld_rate_MIN		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_MAX		NUMBER(20,4) NOT NULL,
	in_Obj_Appld_rate_STCNT		varchar2(32) NOT NULL,
	in_Prop_Appld_rate_MIN		number(20,4) not null,
	in_Prop_Appld_rate_MAX		number(20,4) not null,
	in_Prop_Appld_rate_STCNT	varchar2(32) not null,
	in_Obj_Filtrd_rate_MIN		number(20,4) not null,
	in_Obj_Filtrd_rate_MAX		number(20,4) not null,
	in_Obj_Filtrd_rate_STCNT	varchar2(32) not null,
	in_Prop_Filtrd_rate_MIN		number(20,4) not null,
	in_Prop_Filtrd_rate_MAX		number(20,4) not null,
	in_Prop_Filtrd_rate_STCNT	varchar2(32) not null,
	out_Obj_Filtrd_rate_MIN		number(20,4) not null,
	out_Obj_Filtrd_rate_MAX		number(20,4) not null,
	out_Obj_Filtrd_rate_STCNT	varchar2(32) not null,
	pending_Rep_Sync_MIN		Number(20,4) not null,
	pending_Rep_Sync_MAX		Number(20,4) not null,
	pending_Rep_Sync_STCNT		varchar2(32) not null
);

ALTER TABLE ReplicationTest_TREND ADD constraint PK_ReplicationTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ReplicationTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ReplicationTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	IN_OBJ_APPLD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_APPLD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	PENDING_REP_SYNC_MIN	VARCHAR2(256)	 NOT NULL,
	PENDING_REP_SYNC_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ReplicationTest_THRESH ADD constraint PK_ReplicationTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ReplicationTest_THRESH ON ReplicationTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE REPORT CASCADE CONSTRAINTS;

CREATE TABLE REPORT 
(
	SITE_NAME      	    varchar2(64),
	COMP_NAME 	    varchar2(64),
	COMP_TYPE      	    varchar2(32),
	INFO                varchar2(128),
	LAYER_NAME	    varchar2(64),	
	TEST_NAME	    varchar2(64),	
	MEASURE             varchar2(64), 
	MSMT_HOST           varchar2(32),
	STATE               varchar2(32)
);    

alter table REPORT add constraint PK_REPORT
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,LAYER_NAME,TEST_NAME,MEASURE,MSMT_HOST);
create index idx_report on report(site_name);
CREATE INDEX IDX1_REPORT ON REPORT (STATE);

DROP TABLE EVENT_HIST CASCADE CONSTRAINTS;

CREATE TABLE EVENT_HIST
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16),
	EVENT_SVRTY varchar2(32) 
);

alter table EVENT_HIST add constraint PK_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);
create unique index IDX_EVENT_HIST  on EVENT_HIST(EVENT_ID,MSMT_TIME_START);

DROP TABLE UD_EVENT_HIST CASCADE CONSTRAINTS;

CREATE TABLE UD_EVENT_HIST
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16),
	EVENT_SVRTY varchar2(32) 
);

alter table UD_EVENT_HIST add constraint PK_UD_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);
create unique index IDX_UD_EVENT_HIST  on UD_EVENT_HIST(EVENT_ID,MSMT_TIME_START);


DROP TABLE UNKNOWN_HISTORY CASCADE CONSTRAINTS;

CREATE TABLE UNKNOWN_HISTORY
(
	SITE_NAME	varchar2(64),	
	COMP_NAME	varchar2(64),
	COMP_TYPE	varchar2(32),
	INFO		varchar2(128),
	TEST_NAME	varchar2(64),
	MEASURE		varchar2(64),
	MSMT_TIME_START date,
	MSMT_TIME_END 	date,
	MSMT_HOST	varchar2(32),
	EVENT_ID	number(16)
);

alter table UNKNOWN_HISTORY add constraint PK_UNKNOWN_HISTORY
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST);
create unique index IDX_UNKNOWN_HISTORY on UNKNOWN_HISTORY(EVENT_ID);

DROP TABLE EG_UD_MEASURE CASCADE CONSTRAINTS;
CREATE TABLE EG_UD_MEASURE
(
	SITE_NAME  VARCHAR2(64) NOT NULL,
	TRGT_HOST    VARCHAR2(32) NOT NULL,
	PORT_NO      VARCHAR2(32)NOT NULL,
	TEST_NAME    VARCHAR2(64) NOT NULL,
	MEASURE      VARCHAR2(64) NOT NULL,
	INFO         VARCHAR2(128) NOT NULL,
	STATE        VARCHAR2(32) NOT NULL,
	INDX_MEAS    NUMBER(16) NOT NULL,
	MSMT_HOST    VARCHAR2(32) NOT NULL,
	MSMT_TIME    DATE NOT NULL,
	DETL_MEAS    VARCHAR2(2000)
);
ALTER TABLE EG_UD_MEASURE ADD constraint PK_EG_UD_MEASURE
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE INDEX IDX_EG_UD_MEASURE ON EG_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE REGISTERED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE REGISTERED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, REGISTERED_TIME DATE);
ALTER TABLE REGISTERED_DESKTOPS ADD CONSTRAINT PK_REGISTERED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_REGISTERED_DESKTOPS ON REGISTERED_DESKTOPS(REGISTERED_TIME);

DROP TABLE ALLOWED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE ALLOWED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, ALLOWED_TIME DATE);
ALTER TABLE ALLOWED_DESKTOPS ADD CONSTRAINT PK_ALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_ALLOWED_DESKTOPS ON ALLOWED_DESKTOPS(ALLOWED_TIME);

DROP TABLE DISALLOWED_DESKTOPS CASCADE CONSTRAINTS;
CREATE TABLE DISALLOWED_DESKTOPS(HOST_NAME VARCHAR2(256) NOT NULL, DISALLOWED_TIME DATE);
ALTER TABLE DISALLOWED_DESKTOPS ADD CONSTRAINT PK_DISALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_DISALLOWED_DESKTOPS ON DISALLOWED_DESKTOPS(DISALLOWED_TIME);


DROP TABLE EG_UD_UD_MEASURE CASCADE CONSTRAINTS;
CREATE TABLE EG_UD_UD_MEASURE
(
	SITE_NAME  VARCHAR2(64) NOT NULL,
	TRGT_HOST    VARCHAR2(32) NOT NULL,
	PORT_NO      VARCHAR2(32)NOT NULL,
	TEST_NAME    VARCHAR2(64) NOT NULL,
	MEASURE      VARCHAR2(64) NOT NULL,
	INFO         VARCHAR2(128) NOT NULL,
	STATE        VARCHAR2(32) NOT NULL,
	INDX_MEAS    NUMBER(16) NOT NULL,
	MSMT_HOST    VARCHAR2(32) NOT NULL,
	MSMT_TIME    DATE NOT NULL,
	DETL_MEAS    VARCHAR2(2000)
);
ALTER TABLE EG_UD_UD_MEASURE ADD constraint PK_EG_UD_UD_MEASURE
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE INDEX IDX_EG_UD_UD_MEASURE ON EG_UD_UD_MEASURE
(
	MSMT_TIME
);



DROP TABLE SILVERSTREAMTEST  CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	SERVER_USAGE_METRIC	number(20,4) 	NOT NULL,
	SERVER_USAGE_METRIC_ST	varchar2(32)    NOT NULL,
	USED_THREAD_PCT 	number(20,4) 	NOT NULL,
	USED_THREAD_PCT_ST 	varchar2(32)    NOT NULL,
	IDLE_THREAD_PCT 	number(20,4) 	NOT NULL,
	IDLE_THREAD_PCT_ST 	varchar2(32)    NOT NULL,
	REQUEST_RATE            number(20,4)    NOT NULL,
	REQUEST_RATE_ST         varchar2(32)    NOT NULL,
	MEAN_RESPONSE_TIME      number(20,4)      NOT NULL,
	MEAN_RESPONSE_TIME_ST   varchar2(32)    NOT NULL,
	MAX_RESPONSE_TIME       number(20,4)      NOT NULL,
        MAX_RESPONSE_TIME_ST    varchar2(32)    NOT NULL,
	DATA_XMIT_RATE    	number(20,4)    NOT NULL,
	DATA_XMIT_RATE_ST 	varchar2(32)    NOT NULL,
	MEMORY_UTIL         	number(20,4)     NOT NULL,
	MEMORY_UTIL_ST      	varchar2(32)    NOT NULL,
	TOTAL_SESS_COUNT        number(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_ST     varchar2(32)    NOT NULL,
	IDLE_SESS_COUNT         number(20,4)      NOT NULL,
	IDLE_SESS_COUNT_ST      varchar2(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST ADD CONSTRAINT PK_SILVER_STREAM PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE SILVERSTREAMTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	SERVER_USAGE_METRIC_MIN		number(20,4)     NOT NULL,
	SERVER_USAGE_METRIC_MAX		number(20,4)     NOT NULL,
 	SERVER_USAGE_METRIC_STCNT	varchar2(32)    NOT NULL,
 	USED_THREAD_PCT_MIN		number(20,4)      NOT NULL,
 	USED_THREAD_PCT_MAX		number(20,4)      NOT NULL,
 	USED_THREAD_PCT_STCNT    	varchar2(32)    NOT NULL,
        IDLE_THREAD_PCT_MIN		number(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_MAX		number(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_STCNT    	varchar2(32)    NOT NULL,
 	REQUEST_RATE_MIN		number(20,4)    NOT NULL,
 	REQUEST_RATE_MAX		number(20,4)    NOT NULL,
 	REQUEST_RATE_STCNT		varchar2(32)    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN		number(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX		number(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_STCNT	varchar2(32)    NOT NULL,
 	MAX_RESPONSE_TIME_MIN		number(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_MAX		number(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_STCNT		varchar2(32)    NOT NULL,
 	DATA_XMIT_RATE_MIN    		number(20,4)    NOT NULL,
 	DATA_XMIT_RATE_MAX    		number(20,4)    NOT NULL,
        DATA_XMIT_RATE_STCNT 		varchar2(32)    NOT NULL,
        MEMORY_UTIL_MIN         	number(20,4)     NOT NULL,
        MEMORY_UTIL_MAX         	number(20,4)     NOT NULL,
        MEMORY_UTIL_STCNT      		varchar2(32)    NOT NULL,
 	TOTAL_SESS_COUNT_MIN		number(20,4)      NOT NULL,
 	TOTAL_SESS_COUNT_MAX		number(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_STCNT		varchar2(32)    NOT NULL,
        IDLE_SESS_COUNT_MIN            	number(20,4)      NOT NULL,
        IDLE_SESS_COUNT_MAX            	number(20,4)      NOT NULL,
	IDLE_SESS_COUNT_STCNT		varchar2(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_TREND ADD CONSTRAINT PK_SILVER_STREAM_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE SILVERSTREAMTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SILVERSTREAMTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START 		date,
        MSMT_TIME_END           	date,
	SERVER_USAGE_METRIC_MIN	VARCHAR2(256)	     NOT NULL,
	SERVER_USAGE_METRIC_MAX	VARCHAR2(256)	     NOT NULL,
 	USED_THREAD_PCT_MIN	VARCHAR2(256)	      NOT NULL,
 	USED_THREAD_PCT_MAX	VARCHAR2(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MIN	VARCHAR2(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MAX	VARCHAR2(256)	      NOT NULL,
 	REQUEST_RATE_MIN	VARCHAR2(256)	    NOT NULL,
 	REQUEST_RATE_MAX	VARCHAR2(256)	    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN	VARCHAR2(256)	      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX	VARCHAR2(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MIN	VARCHAR2(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MAX	VARCHAR2(256)	      NOT NULL,
 	DATA_XMIT_RATE_MIN	VARCHAR2(256)	    NOT NULL,
 	DATA_XMIT_RATE_MAX	VARCHAR2(256)	    NOT NULL,
        MEMORY_UTIL_MIN	VARCHAR2(256)	     NOT NULL,
        MEMORY_UTIL_MAX	VARCHAR2(256)	     NOT NULL,
 	TOTAL_SESS_COUNT_MIN	VARCHAR2(256)	      NOT NULL,
 	TOTAL_SESS_COUNT_MAX	VARCHAR2(256)	      NOT NULL,
        IDLE_SESS_COUNT_MIN	VARCHAR2(256)	      NOT NULL,
        IDLE_SESS_COUNT_MAX	VARCHAR2(256)	      NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_THRESH ADD CONSTRAINT PK_SILVER_STREAM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SILVERSTREAMTEST_THRESH ON SILVERSTREAMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDataCacheTest CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
UTILIZATION Number(20,4) NOT NULL,
UTILIZATION_ST varchar2(32) NOT NULL,
CACHE_HIT_RATIO Number(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
SPINLOCK_CONTENTION Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_ST varchar2(32) NOT NULL,
BUFFERS_GRABBED Number(20,4) NOT NULL,
BUFFERS_GRABBED_ST varchar2(32) NOT NULL,
BUFFERS_GRABBED_DIRTY Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_ST varchar2(32) NOT NULL,
PCT_LARGE_IO_DENIED Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_ST varchar2(32) NOT NULL,
LARGE_IO_EFFECTIVENESS Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_ST varchar2(32) NOT NULL);

ALTER TABLE SybDataCacheTest ADD constraint PK_SybDataCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybDataCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
UTILIZATION_MIN Number(20,4) NOT NULL,
UTILIZATION_MAX Number(20,4) NOT NULL,
UTILIZATION_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
SPINLOCK_CONTENTION_MIN Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_MAX Number(20,4) NOT NULL,
SPINLOCK_CONTENTION_STCNT varchar2(32) NOT NULL,
BUFFERS_GRABBED_MIN Number(20,4) NOT NULL,
BUFFERS_GRABBED_MAX Number(20,4) NOT NULL,
BUFFERS_GRABBED_STCNT varchar2(32) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX Number(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_STCNT varchar2(32) NOT NULL,
PCT_LARGE_IO_DENIED_MIN Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_MAX Number(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_STCNT varchar2(32) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX Number(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybDataCacheTest_TREND ADD constraint PK_SybDataCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDataCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybDataCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
UTILIZATION_MIN VARCHAR2(256) NOT NULL,
UTILIZATION_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR2(256) NOT NULL,
SPINLOCK_CONTENTION_MIN VARCHAR2(256) NOT NULL,
SPINLOCK_CONTENTION_MAX VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_MIN VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_MAX VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN VARCHAR2(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX VARCHAR2(256) NOT NULL,
PCT_LARGE_IO_DENIED_MIN VARCHAR2(256) NOT NULL,
PCT_LARGE_IO_DENIED_MAX VARCHAR2(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN VARCHAR2(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybDataCacheTest_THRESH ADD constraint PK_SybDataCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDataCacheTest_THRESH ON SybDataCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybDeviceTest CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IO_REQUESTS Number(20,4) NOT NULL,
IO_REQUESTS_ST varchar2(32) NOT NULL,
PHY_READ_RATE Number(20,4) NOT NULL,
PHY_READ_RATE_ST varchar2(32) NOT NULL,
PHY_WRITE_RATE Number(20,4) NOT NULL,
PHY_WRITE_RATE_ST varchar2(32) NOT NULL,
IO_ERRORS Number(20,4) NOT NULL,
IO_ERRORS_ST varchar2(32) NOT NULL,
IO_WAITS Number(20,4) NOT NULL,
IO_WAITS_ST varchar2(32) NOT NULL);

ALTER TABLE SybDeviceTest ADD constraint PK_SybDeviceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybDeviceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IO_REQUESTS_MIN Number(20,4) NOT NULL,
IO_REQUESTS_MAX Number(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar2(32) NOT NULL,
PHY_READ_RATE_MIN Number(20,4) NOT NULL,
PHY_READ_RATE_MAX Number(20,4) NOT NULL,
PHY_READ_RATE_STCNT varchar2(32) NOT NULL,
PHY_WRITE_RATE_MIN Number(20,4) NOT NULL,
PHY_WRITE_RATE_MAX Number(20,4) NOT NULL,
PHY_WRITE_RATE_STCNT varchar2(32) NOT NULL,
IO_ERRORS_MIN Number(20,4) NOT NULL,
IO_ERRORS_MAX Number(20,4) NOT NULL,
IO_ERRORS_STCNT varchar2(32) NOT NULL,
IO_WAITS_MIN Number(20,4) NOT NULL,
IO_WAITS_MAX Number(20,4) NOT NULL,
IO_WAITS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybDeviceTest_TREND ADD constraint PK_SybDeviceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDeviceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybDeviceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IO_REQUESTS_MIN VARCHAR2(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR2(256) NOT NULL,
PHY_READ_RATE_MIN VARCHAR2(256) NOT NULL,
PHY_READ_RATE_MAX VARCHAR2(256) NOT NULL,
PHY_WRITE_RATE_MIN VARCHAR2(256) NOT NULL,
PHY_WRITE_RATE_MAX VARCHAR2(256) NOT NULL,
IO_ERRORS_MIN VARCHAR2(256) NOT NULL,
IO_ERRORS_MAX VARCHAR2(256) NOT NULL,
IO_WAITS_MIN VARCHAR2(256) NOT NULL,
IO_WAITS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybDeviceTest_THRESH ADD constraint PK_SybDeviceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDeviceTest_THRESH ON SybDeviceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybLockTest CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
LOCK_REQUESTS Number(20,4) NOT NULL,
LOCK_REQUESTS_ST varchar2(32) NOT NULL,
LOCK_WAITS Number(20,4) NOT NULL,
LOCK_WAITS_ST varchar2(32) NOT NULL,
AVG_LOCK_WAIT_TIME Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_ST varchar2(32) NOT NULL,
LOCK_TIMEOUTS Number(20,4) NOT NULL,
LOCK_TIMEOUTS_ST varchar2(32) NOT NULL,
DEAD_LOCKS Number(20,4) NOT NULL,
DEAD_LOCKS_ST varchar2(32) NOT NULL);

ALTER TABLE SybLockTest ADD constraint PK_SybLockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
LOCK_REQUESTS_MIN Number(20,4) NOT NULL,
LOCK_REQUESTS_MAX Number(20,4) NOT NULL,
LOCK_REQUESTS_STCNT varchar2(32) NOT NULL,
LOCK_WAITS_MIN Number(20,4) NOT NULL,
LOCK_WAITS_MAX Number(20,4) NOT NULL,
LOCK_WAITS_STCNT varchar2(32) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX Number(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_STCNT varchar2(32) NOT NULL,
LOCK_TIMEOUTS_MIN Number(20,4) NOT NULL,
LOCK_TIMEOUTS_MAX Number(20,4) NOT NULL,
LOCK_TIMEOUTS_STCNT varchar2(32) NOT NULL,
DEAD_LOCKS_MIN Number(20,4) NOT NULL,
DEAD_LOCKS_MAX Number(20,4) NOT NULL,
DEAD_LOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybLockTest_TREND ADD constraint PK_SybLockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybLockTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
LOCK_REQUESTS_MIN VARCHAR2(256) NOT NULL,
LOCK_REQUESTS_MAX VARCHAR2(256) NOT NULL,
LOCK_WAITS_MIN VARCHAR2(256) NOT NULL,
LOCK_WAITS_MAX VARCHAR2(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN VARCHAR2(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX VARCHAR2(256) NOT NULL,
LOCK_TIMEOUTS_MIN VARCHAR2(256) NOT NULL,
LOCK_TIMEOUTS_MAX VARCHAR2(256) NOT NULL,
DEAD_LOCKS_MIN VARCHAR2(256) NOT NULL,
DEAD_LOCKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybLockTest_THRESH ADD constraint PK_SybLockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockTest_THRESH ON SybLockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybLockStatsTest CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_OF_LOCKS Number(20,4) NOT NULL,
NUM_OF_LOCKS_ST varchar2(32) NOT NULL,
AVG_BLOCK_TIME Number(20,4) NOT NULL,
AVG_BLOCK_TIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SybLockStatsTest ON SybLockStatsTest(MSMT_TIME);
ALTER TABLE SybLockStatsTest ADD constraint PK_SybLockStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_OF_LOCKS_MIN Number(20,4) NOT NULL,
NUM_OF_LOCKS_MAX Number(20,4) NOT NULL,
NUM_OF_LOCKS_STCNT varchar2(32) NOT NULL,
AVG_BLOCK_TIME_MIN Number(20,4) NOT NULL,
AVG_BLOCK_TIME_MAX Number(20,4) NOT NULL,
AVG_BLOCK_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybLockStatsTest_TREND ADD constraint PK_SybLockStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybLockStatsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_OF_LOCKS_MIN VARCHAR2(256) NOT NULL,
NUM_OF_LOCKS_MAX VARCHAR2(256) NOT NULL,
AVG_BLOCK_TIME_MIN VARCHAR2(256) NOT NULL,
AVG_BLOCK_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybLockStatsTest_THRESH ADD constraint PK_SybLockStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockStatsTest_THRESH ON SybLockStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);




DROP TABLE SybNetworkTest CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IO_REQUESTS Number(20,4) NOT NULL,
IO_REQUESTS_ST varchar2(32) NOT NULL,
IO_DELAY Number(20,4) NOT NULL,
IO_DELAY_ST varchar2(32) NOT NULL,
DATA_RECVD_RATE Number(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar2(32) NOT NULL,
DATA_SENT_RATE Number(20,4) NOT NULL,
DATA_SENT_RATE_ST varchar2(32) NOT NULL,
AVG_PACKET_SIZE Number(20,4) NOT NULL,
AVG_PACKET_SIZE_ST varchar2(32) NOT NULL);

ALTER TABLE SybNetworkTest ADD constraint PK_SybNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybNetworkTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IO_REQUESTS_MIN Number(20,4) NOT NULL,
IO_REQUESTS_MAX Number(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar2(32) NOT NULL,
IO_DELAY_MIN Number(20,4) NOT NULL,
IO_DELAY_MAX Number(20,4) NOT NULL,
IO_DELAY_STCNT varchar2(32) NOT NULL,
DATA_RECVD_RATE_MIN Number(20,4) NOT NULL,
DATA_RECVD_RATE_MAX Number(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar2(32) NOT NULL,
DATA_SENT_RATE_MIN Number(20,4) NOT NULL,
DATA_SENT_RATE_MAX Number(20,4) NOT NULL,
DATA_SENT_RATE_STCNT varchar2(32) NOT NULL,
AVG_PACKET_SIZE_MIN Number(20,4) NOT NULL,
AVG_PACKET_SIZE_MAX Number(20,4) NOT NULL,
AVG_PACKET_SIZE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybNetworkTest_TREND ADD constraint PK_SybNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybNetworkTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybNetworkTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IO_REQUESTS_MIN VARCHAR2(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR2(256) NOT NULL,
IO_DELAY_MIN VARCHAR2(256) NOT NULL,
IO_DELAY_MAX VARCHAR2(256) NOT NULL,
DATA_RECVD_RATE_MIN VARCHAR2(256) NOT NULL,
DATA_RECVD_RATE_MAX VARCHAR2(256) NOT NULL,
DATA_SENT_RATE_MIN VARCHAR2(256) NOT NULL,
DATA_SENT_RATE_MAX VARCHAR2(256) NOT NULL,
AVG_PACKET_SIZE_MIN VARCHAR2(256) NOT NULL,
AVG_PACKET_SIZE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybNetworkTest_THRESH ADD constraint PK_SybNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybNetworkTest_THRESH ON SybNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybProcCacheTest CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PROCEDURE_REQUESTS Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_ST varchar2(32) NOT NULL,
DISK_READS Number(20,4) NOT NULL,
DISK_READS_ST varchar2(32) NOT NULL,
CACHE_HIT_RATIO Number(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
PROCEDURES_CREATED Number(20,4) NOT NULL,
PROCEDURES_CREATED_ST varchar2(32) NOT NULL,
PROCEDURES_AGED_OUT Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_ST varchar2(32) NOT NULL);

ALTER TABLE SybProcCacheTest ADD constraint PK_SybProcCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybProcCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PROCEDURE_REQUESTS_MIN Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_MAX Number(20,4) NOT NULL,
PROCEDURE_REQUESTS_STCNT varchar2(32) NOT NULL,
DISK_READS_MIN Number(20,4) NOT NULL,
DISK_READS_MAX Number(20,4) NOT NULL,
DISK_READS_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
PROCEDURES_CREATED_MIN Number(20,4) NOT NULL,
PROCEDURES_CREATED_MAX Number(20,4) NOT NULL,
PROCEDURES_CREATED_STCNT varchar2(32) NOT NULL,
PROCEDURES_AGED_OUT_MIN Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_MAX Number(20,4) NOT NULL,
PROCEDURES_AGED_OUT_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybProcCacheTest_TREND ADD constraint PK_SybProcCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybProcCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybProcCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PROCEDURE_REQUESTS_MIN VARCHAR2(256) NOT NULL,
PROCEDURE_REQUESTS_MAX VARCHAR2(256) NOT NULL,
DISK_READS_MIN VARCHAR2(256) NOT NULL,
DISK_READS_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR2(256) NOT NULL,
PROCEDURES_CREATED_MIN VARCHAR2(256) NOT NULL,
PROCEDURES_CREATED_MAX VARCHAR2(256) NOT NULL,
PROCEDURES_AGED_OUT_MIN VARCHAR2(256) NOT NULL,
PROCEDURES_AGED_OUT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybProcCacheTest_THRESH ADD constraint PK_SybProcCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybProcCacheTest_THRESH ON SybProcCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSpaceTest CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_SIZE Number(20,4) NOT NULL,
TOTAL_SIZE_ST varchar2(32) NOT NULL,
PCT_RESERVED Number(20,4) NOT NULL,
PCT_RESERVED_ST varchar2(32) NOT NULL,
RESERVED_SPACE Number(20,4) NOT NULL,
RESERVED_SPACE_ST varchar2(32) NOT NULL,
DATA_SPACE Number(20,4) NOT NULL,
DATA_SPACE_ST varchar2(32) NOT NULL,
INDEX_SPACE Number(20,4) NOT NULL,
INDEX_SPACE_ST varchar2(32) NOT NULL,
UNUSED_SPACE Number(20,4) NOT NULL,
UNUSED_SPACE_ST varchar2(32) NOT NULL);

ALTER TABLE SybSpaceTest ADD constraint PK_SybSpaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybSpaceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_SIZE_MIN Number(20,4) NOT NULL,
TOTAL_SIZE_MAX Number(20,4) NOT NULL,
TOTAL_SIZE_STCNT varchar2(32) NOT NULL,
PCT_RESERVED_MIN Number(20,4) NOT NULL,
PCT_RESERVED_MAX Number(20,4) NOT NULL,
PCT_RESERVED_STCNT varchar2(32) NOT NULL,
RESERVED_SPACE_MIN Number(20,4) NOT NULL,
RESERVED_SPACE_MAX Number(20,4) NOT NULL,
RESERVED_SPACE_STCNT varchar2(32) NOT NULL,
DATA_SPACE_MIN Number(20,4) NOT NULL,
DATA_SPACE_MAX Number(20,4) NOT NULL,
DATA_SPACE_STCNT varchar2(32) NOT NULL,
INDEX_SPACE_MIN Number(20,4) NOT NULL,
INDEX_SPACE_MAX Number(20,4) NOT NULL,
INDEX_SPACE_STCNT varchar2(32) NOT NULL,
UNUSED_SPACE_MIN Number(20,4) NOT NULL,
UNUSED_SPACE_MAX Number(20,4) NOT NULL,
UNUSED_SPACE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybSpaceTest_TREND ADD constraint PK_SybSpaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSpaceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybSpaceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SIZE_MIN VARCHAR2(256) NOT NULL,
TOTAL_SIZE_MAX VARCHAR2(256) NOT NULL,
PCT_RESERVED_MIN VARCHAR2(256) NOT NULL,
PCT_RESERVED_MAX VARCHAR2(256) NOT NULL,
RESERVED_SPACE_MIN VARCHAR2(256) NOT NULL,
RESERVED_SPACE_MAX VARCHAR2(256) NOT NULL,
DATA_SPACE_MIN VARCHAR2(256) NOT NULL,
DATA_SPACE_MAX VARCHAR2(256) NOT NULL,
INDEX_SPACE_MIN VARCHAR2(256) NOT NULL,
INDEX_SPACE_MAX VARCHAR2(256) NOT NULL,
UNUSED_SPACE_MIN VARCHAR2(256) NOT NULL,
UNUSED_SPACE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybSpaceTest_THRESH ADD constraint PK_SybSpaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSpaceTest_THRESH ON SybSpaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTasksTest CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CONNECTION_OPEN_RATE Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_ST varchar2(32) NOT NULL,
TASK_SWITCH_RATE Number(20,4) NOT NULL,
TASK_SWITCH_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE SybTasksTest ADD constraint PK_SybTasksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTasksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CONNECTION_OPEN_RATE_MIN Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_MAX Number(20,4) NOT NULL,
CONNECTION_OPEN_RATE_STCNT varchar2(32) NOT NULL,
TASK_SWITCH_RATE_MIN Number(20,4) NOT NULL,
TASK_SWITCH_RATE_MAX Number(20,4) NOT NULL,
TASK_SWITCH_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTasksTest_TREND ADD constraint PK_SybTasksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTasksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTasksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CONNECTION_OPEN_RATE_MIN VARCHAR2(256) NOT NULL,
CONNECTION_OPEN_RATE_MAX VARCHAR2(256) NOT NULL,
TASK_SWITCH_RATE_MIN VARCHAR2(256) NOT NULL,
TASK_SWITCH_RATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTasksTest_THRESH ADD constraint PK_SybTasksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTasksTest_THRESH ON SybTasksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxLogTest CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ULC_LOG_WRITES Number(20,4) NOT NULL,
ULC_LOG_WRITES_ST varchar2(32) NOT NULL,
ULC_LOG_WRITE_WAITS Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_ST varchar2(32) NOT NULL,
ULC_FLUSHES Number(20,4) NOT NULL,
ULC_FLUSHES_ST varchar2(32) NOT NULL,
ULC_FLUSH_WAITS Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_ST varchar2(32) NOT NULL,
MAX_ULC_SIZE Number(20,4) NOT NULL,
MAX_ULC_SIZE_ST varchar2(32) NOT NULL,
LOG_ALLOCATIONS Number(20,4) NOT NULL,
LOG_ALLOCATIONS_ST varchar2(32) NOT NULL,
TRANSACTION_LOG_WRITES Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_ST varchar2(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_ST varchar2(32) NOT NULL);

ALTER TABLE SybTxLogTest ADD constraint PK_SybTxLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTxLogTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ULC_LOG_WRITES_MIN Number(20,4) NOT NULL,
ULC_LOG_WRITES_MAX Number(20,4) NOT NULL,
ULC_LOG_WRITES_STCNT varchar2(32) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX Number(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_STCNT varchar2(32) NOT NULL,
ULC_FLUSHES_MIN Number(20,4) NOT NULL,
ULC_FLUSHES_MAX Number(20,4) NOT NULL,
ULC_FLUSHES_STCNT varchar2(32) NOT NULL,
ULC_FLUSH_WAITS_MIN Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_MAX Number(20,4) NOT NULL,
ULC_FLUSH_WAITS_STCNT varchar2(32) NOT NULL,
MAX_ULC_SIZE_MIN Number(20,4) NOT NULL,
MAX_ULC_SIZE_MAX Number(20,4) NOT NULL,
MAX_ULC_SIZE_STCNT varchar2(32) NOT NULL,
LOG_ALLOCATIONS_MIN Number(20,4) NOT NULL,
LOG_ALLOCATIONS_MAX Number(20,4) NOT NULL,
LOG_ALLOCATIONS_STCNT varchar2(32) NOT NULL,
TRANSACTION_LOG_WRITES_MIN Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_MAX Number(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_STCNT varchar2(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX Number(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTxLogTest_TREND ADD constraint PK_SybTxLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxLogTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTxLogTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ULC_LOG_WRITES_MIN VARCHAR2(256) NOT NULL,
ULC_LOG_WRITES_MAX VARCHAR2(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN VARCHAR2(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX VARCHAR2(256) NOT NULL,
ULC_FLUSHES_MIN VARCHAR2(256) NOT NULL,
ULC_FLUSHES_MAX VARCHAR2(256) NOT NULL,
ULC_FLUSH_WAITS_MIN VARCHAR2(256) NOT NULL,
ULC_FLUSH_WAITS_MAX VARCHAR2(256) NOT NULL,
MAX_ULC_SIZE_MIN VARCHAR2(256) NOT NULL,
MAX_ULC_SIZE_MAX VARCHAR2(256) NOT NULL,
LOG_ALLOCATIONS_MIN VARCHAR2(256) NOT NULL,
LOG_ALLOCATIONS_MAX VARCHAR2(256) NOT NULL,
TRANSACTION_LOG_WRITES_MIN VARCHAR2(256) NOT NULL,
TRANSACTION_LOG_WRITES_MAX VARCHAR2(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN VARCHAR2(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTxLogTest_THRESH ADD constraint PK_SybTxLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxLogTest_THRESH ON SybTxLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxTest CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
COMMITTED_TRANSACTIONS Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_ST varchar2(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_ST varchar2(32) NOT NULL,
INSERTS Number(20,4) NOT NULL,
INSERTS_ST varchar2(32) NOT NULL,
UPDATES Number(20,4) NOT NULL,
UPDATES_ST varchar2(32) NOT NULL,
DELETES Number(20,4) NOT NULL,
DELETES_ST varchar2(32) NOT NULL);

ALTER TABLE SybTxTest ADD constraint PK_SybTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybTxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
COMMITTED_TRANSACTIONS_MIN Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_MAX Number(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_STCNT varchar2(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX Number(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_STCNT varchar2(32) NOT NULL,
INSERTS_MIN Number(20,4) NOT NULL,
INSERTS_MAX Number(20,4) NOT NULL,
INSERTS_STCNT varchar2(32) NOT NULL,
UPDATES_MIN Number(20,4) NOT NULL,
UPDATES_MAX Number(20,4) NOT NULL,
UPDATES_STCNT varchar2(32) NOT NULL,
DELETES_MIN Number(20,4) NOT NULL,
DELETES_MAX Number(20,4) NOT NULL,
DELETES_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybTxTest_TREND ADD constraint PK_SybTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybTxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
COMMITTED_TRANSACTIONS_MIN VARCHAR2(256) NOT NULL,
COMMITTED_TRANSACTIONS_MAX VARCHAR2(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN VARCHAR2(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX VARCHAR2(256) NOT NULL,
INSERTS_MIN VARCHAR2(256) NOT NULL,
INSERTS_MAX VARCHAR2(256) NOT NULL,
UPDATES_MIN VARCHAR2(256) NOT NULL,
UPDATES_MAX VARCHAR2(256) NOT NULL,
DELETES_MIN VARCHAR2(256) NOT NULL,
DELETES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybTxTest_THRESH ADD constraint PK_SybTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxTest_THRESH ON SybTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSysProcessTest CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_PROCESSES Number(20,4) NOT NULL,
TOTAL_PROCESSES_ST varchar2(32) NOT NULL,
BACKGROUND_PROCESSES Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_ST varchar2(32) NOT NULL,
RUNNING_PROCESSES Number(20,4) NOT NULL,
RUNNING_PROCESSES_ST varchar2(32) NOT NULL,
SLEEPING_PROCESSES Number(20,4) NOT NULL,
SLEEPING_PROCESSES_ST varchar2(32) NOT NULL,
INFECTED_PROCESSES Number(20,4) NOT NULL,
INFECTED_PROCESSES_ST varchar2(32) NOT NULL,
BLOCKED_PROCESSES Number(20,4) NOT NULL,
BLOCKED_PROCESSES_ST varchar2(32) NOT NULL,
REMOTE_PROCESSES Number(20,4) NOT NULL,
REMOTE_PROCESSES_ST varchar2(32) NOT NULL,
STOPPED_PROCESSES Number(20,4) NOT NULL,
STOPPED_PROCESSES_ST varchar2(32) NOT NULL);

ALTER TABLE SybSysProcessTest ADD constraint PK_SybSysProcessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybSysProcessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_PROCESSES_MIN Number(20,4) NOT NULL,
TOTAL_PROCESSES_MAX Number(20,4) NOT NULL,
TOTAL_PROCESSES_STCNT varchar2(32) NOT NULL,
BACKGROUND_PROCESSES_MIN Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_MAX Number(20,4) NOT NULL,
BACKGROUND_PROCESSES_STCNT varchar2(32) NOT NULL,
RUNNING_PROCESSES_MIN Number(20,4) NOT NULL,
RUNNING_PROCESSES_MAX Number(20,4) NOT NULL,
RUNNING_PROCESSES_STCNT varchar2(32) NOT NULL,
SLEEPING_PROCESSES_MIN Number(20,4) NOT NULL,
SLEEPING_PROCESSES_MAX Number(20,4) NOT NULL,
SLEEPING_PROCESSES_STCNT varchar2(32) NOT NULL,
INFECTED_PROCESSES_MIN Number(20,4) NOT NULL,
INFECTED_PROCESSES_MAX Number(20,4) NOT NULL,
INFECTED_PROCESSES_STCNT varchar2(32) NOT NULL,
BLOCKED_PROCESSES_MIN Number(20,4) NOT NULL,
BLOCKED_PROCESSES_MAX Number(20,4) NOT NULL,
BLOCKED_PROCESSES_STCNT varchar2(32) NOT NULL,
REMOTE_PROCESSES_MIN Number(20,4) NOT NULL,
REMOTE_PROCESSES_MAX Number(20,4) NOT NULL,
REMOTE_PROCESSES_STCNT varchar2(32) NOT NULL,
STOPPED_PROCESSES_MIN Number(20,4) NOT NULL,
STOPPED_PROCESSES_MAX Number(20,4) NOT NULL,
STOPPED_PROCESSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE SybSysProcessTest_TREND ADD constraint PK_SybSysProcessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSysProcessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SybSysProcessTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_PROCESSES_MIN VARCHAR2(256) NOT NULL,
TOTAL_PROCESSES_MAX VARCHAR2(256) NOT NULL,
BACKGROUND_PROCESSES_MIN VARCHAR2(256) NOT NULL,
BACKGROUND_PROCESSES_MAX VARCHAR2(256) NOT NULL,
RUNNING_PROCESSES_MIN VARCHAR2(256) NOT NULL,
RUNNING_PROCESSES_MAX VARCHAR2(256) NOT NULL,
SLEEPING_PROCESSES_MIN VARCHAR2(256) NOT NULL,
SLEEPING_PROCESSES_MAX VARCHAR2(256) NOT NULL,
INFECTED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
INFECTED_PROCESSES_MAX VARCHAR2(256) NOT NULL,
BLOCKED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
BLOCKED_PROCESSES_MAX VARCHAR2(256) NOT NULL,
REMOTE_PROCESSES_MIN VARCHAR2(256) NOT NULL,
REMOTE_PROCESSES_MAX VARCHAR2(256) NOT NULL,
STOPPED_PROCESSES_MIN VARCHAR2(256) NOT NULL,
STOPPED_PROCESSES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SybSysProcessTest_THRESH ADD constraint PK_SybSysProcessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSysProcessTest_THRESH ON SybSysProcessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE UdSYSTEMTEST CASCADE CONSTRAINTS; 
CREATE TABLE UdSYSTEMTEST 
(
	TRGT_HOST           varchar2(32),
        PORT_NO             varchar2(32),
        SITE_NAME           varchar2(64),
        INFO                varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME           date,
	CPU_UTIL	    number(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar2(32)        NOT NULL,
	SYS_CPU_UTIL	    number(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar2(32)     	NOT NULL,
	RUNNING_PROC	    Number(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar2(32)     	NOT NULL,
	BLOCKED_PROC	    Number(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar2(32)     	NOT NULL,
	SWAP_AVAIL	    number(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar2(32)        NOT NULL,
	FREE_MEM_AVAIL	    number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar2(32)        NOT NULL,
	MEM_SCAN_RATE 	    number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar2(32)        NOT NULL
);
alter table UdSYSTEMTEST add constraint PK_UdSYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);


DROP TABLE SYSTEMTEST CASCADE CONSTRAINTS; 

CREATE TABLE SYSTEMTEST 
(
	TRGT_HOST           varchar2(32),
        PORT_NO             varchar2(32),
        SITE_NAME           varchar2(64),
        INFO                varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME           date,
	CPU_UTIL	    number(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar2(32)        NOT NULL,
	SYS_CPU_UTIL	    number(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar2(32)     	NOT NULL,
	RUNNING_PROC	    Number(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar2(32)     	NOT NULL,
	BLOCKED_PROC	    Number(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar2(32)     	NOT NULL,
	SWAP_AVAIL	    number(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar2(32)        NOT NULL,
	FREE_MEM_AVAIL	    number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar2(32)        NOT NULL,
	MEM_SCAN_RATE 	    number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar2(32)        NOT NULL
);

alter table SYSTEMTEST add constraint PK_SYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE SYSTEMTEST_TREND CASCADE CONSTRAINTS; 

CREATE TABLE SYSTEMTEST_TREND 
(
	TRGT_HOST           		varchar2(32),
        PORT_NO             		varchar2(32),
        SITE_NAME           		varchar2(64),
        INFO                		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME           		date,
	PERIOD              		varchar2(32),
	CPU_UTIL_MIN	    		number(20,4) 	NOT NULL,
	CPU_UTIL_MAX	    		number(20,4) 	NOT NULL,
	CPU_UTIL_STCNT    		varchar2(32)    NOT NULL,
	SYS_CPU_UTIL_MIN    		number(20,4)     NOT NULL,
	SYS_CPU_UTIL_MAX    		number(20,4)     NOT NULL,
	SYS_CPU_UTIL_STCNT	    	varchar2(32)   	NOT NULL,
	RUNNING_PROC_MIN	    	Number(20,4)  	NOT NULL,
	RUNNING_PROC_MAX	    	Number(20,4)  	NOT NULL,
	RUNNING_PROC_STCNT	    	varchar2(32)   	NOT NULL,
	BLOCKED_PROC_MIN	    	Number(20,4)  	NOT NULL,
	BLOCKED_PROC_MAX	    	Number(20,4)  	NOT NULL,
	BLOCKED_PROC_STCNT	    	varchar2(32)   	NOT NULL,
	SWAP_AVAIL_MIN	    		number(20,4)  	NOT NULL,
	SWAP_AVAIL_MAX	    		number(20,4)  	NOT NULL,
	SWAP_AVAIL_STCNT	 	varchar2(32)    NOT NULL,
	FREE_MEM_AVAIL_MIN	    	number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_MAX	    	number(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_STCNT   		varchar2(32)    NOT NULL,
	MEM_SCAN_RATE_MIN 	    	number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_MAX 	    	number(20,4)  	NOT NULL,
	MEM_SCAN_RATE_STCNT		varchar2(32)    NOT NULL
);

alter table SYSTEMTEST_TREND add constraint PK_SYSTEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE SYSTEMTEST_THRESH CASCADE CONSTRAINTS; 
CREATE TABLE SYSTEMTEST_THRESH 
(
	TRGT_HOST               varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START         date,
        MSMT_TIME_END           date,  
	CPU_UTIL_MIN	VARCHAR2(256)	   NOT NULL,
	CPU_UTIL_MAX	VARCHAR2(256)	   NOT NULL,
	SYS_CPU_UTIL_MIN	VARCHAR2(256)	   NOT NULL,
	SYS_CPU_UTIL_MAX	VARCHAR2(256)	   NOT NULL,
	RUNNING_PROC_MIN	VARCHAR2(256)	    NOT NULL,
	RUNNING_PROC_MAX	VARCHAR2(256)	    NOT NULL,
	BLOCKED_PROC_MIN	VARCHAR2(256)	    NOT NULL,
	BLOCKED_PROC_MAX	VARCHAR2(256)	    NOT NULL,
	SWAP_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
	SWAP_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
	FREE_MEM_AVAIL_MIN	VARCHAR2(256)	    NOT NULL,
	FREE_MEM_AVAIL_MAX	VARCHAR2(256)	    NOT NULL,
	MEM_SCAN_RATE_MIN	VARCHAR2(256)	    NOT NULL,
	MEM_SCAN_RATE_MAX	VARCHAR2(256)	    NOT NULL
);

alter table SYSTEMTEST_THRESH add constraint PK_SYSTEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SYSTEMTEST_THRESH ON SYSTEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE TCPTEST  CASCADE CONSTRAINTS;

CREATE TABLE TCPTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
	CONN_RATE_IN 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_ST 	varchar2(32)    NOT NULL,
	CONN_RATE_OUT 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_ST 	varchar2(32)    NOT NULL,
	CURR_CONN 		Number(20,4) 	NOT NULL,
	CURR_CONN_ST 		varchar2(32)    NOT NULL,
	COMP_CONN_DROPS 	number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_ST 	varchar2(32)    NOT NULL,
	HALF_CONN_DROPS 	number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_ST 	varchar2(32)    NOT NULL
);

ALTER TABLE TCPTEST ADD CONSTRAINT PK_TCP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TCPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE TCPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
	CONN_RATE_IN_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_IN_STCNT 		varchar2(32)    NOT NULL,
	CONN_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	CONN_RATE_OUT_STCNT 		varchar2(32)    NOT NULL,
	CURR_CONN_MIN 			Number(20,4) 	NOT NULL,
	CURR_CONN_MAX 			Number(20,4) 	NOT NULL,
	CURR_CONN_STCNT 		varchar2(32)    NOT NULL,
	COMP_CONN_DROPS_MIN 		number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_MAX 		number(20,4) 	NOT NULL,
	COMP_CONN_DROPS_STCNT 		varchar2(32)    NOT NULL,
	HALF_CONN_DROPS_MIN 		number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_MAX 		number(20,4) 	NOT NULL,
	HALF_CONN_DROPS_STCNT 		varchar2(32)    NOT NULL
);

ALTER TABLE TCPTEST_TREND ADD CONSTRAINT PK_TCP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE TCPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TCPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
	CONN_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_CONN_MIN	VARCHAR2(256)	 	NOT NULL,
	CURR_CONN_MAX	VARCHAR2(256)	 	NOT NULL,
	COMP_CONN_DROPS_MIN	VARCHAR2(256)	 	NOT NULL,
	COMP_CONN_DROPS_MAX	VARCHAR2(256)	 	NOT NULL,
	HALF_CONN_DROPS_MIN	VARCHAR2(256)	 	NOT NULL,
	HALF_CONN_DROPS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE TCPTEST_THRESH ADD CONSTRAINT PK_TCP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_TCPTEST_THRESH ON TCPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE TESTDESC  CASCADE CONSTRAINTS;

CREATE TABLE TESTDESC 
(
	TEST_NAME 		varchar2(64),
	TEST_SDESC 		varchar2(1000),
	TEST_LDESC 		varchar2(2048)
);

ALTER TABLE TESTDESC ADD CONSTRAINT PK_TESTDESC
PRIMARY KEY (TEST_NAME); 

DROP TABLE TESTMEASURE  CASCADE CONSTRAINTS;

CREATE TABLE TESTMEASURE
(
        TEST_NAME               varchar2(64),
        MSMT_NAME               varchar2(64),
        MSMT_DESC               varchar2(1000)
);

ALTER TABLE TESTMEASURE ADD CONSTRAINT PK_TESTMEASURE
PRIMARY KEY (TEST_NAME);

DROP TABLE topology CASCADE CONSTRAINTS;

CREATE TABLE TOPOLOGY
(
	COMP_TYPE 	    varchar2(32),
	COMP_NAME           varchar2(64),
        DEPD                varchar2(64)  NOT NULL,
        DIRCT               varchar2(32)  NOT NULL
);

alter table TOPOLOGY add constraint PK_TOPOLOGY
primary key (COMP_TYPE,COMP_NAME,DEPD);

DROP TABLE EGTRANSACTION CASCADE CONSTRAINTS;

CREATE TABLE EGTRANSACTION 
(
	TRANS_NAME 	          varchar2(64),
	SITE_NAME                 varchar2(64),
	USER_ID			   varchar2(256) NOT NULL,
        IMG                       varchar2(64)
);    

alter table EGTRANSACTION add constraint PK_EGTRANSACTION
primary key (TRANS_NAME,SITE_name,USER_ID);


DROP TABLE UDPTEST CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	PKT_RATE_IN 		number(20,4)  	NOT NULL,
	PKT_RATE_IN_ST 		varchar2(32)  	NOT NULL,
	PKT_RATE_OUT    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_ST    	varchar2(32)  	NOT NULL,
	PKT_OFLOW_RATE    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_ST   	varchar2(32)  	NOT NULL
);

alter table UDPTEST add constraint PK_UDP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE UDPTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	PERIOD       		varchar2(32), 
	PKT_RATE_IN_MIN 	number(20,4)  	NOT NULL,
	PKT_RATE_IN_MAX 	number(20,4)  	NOT NULL,
	PKT_RATE_IN_STCNT 	varchar2(32)  	NOT NULL,
	PKT_RATE_OUT_MIN    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_MAX    	number(20,4)  	NOT NULL,
	PKT_RATE_OUT_STCNT	varchar2(32)  	NOT NULL,
	PKT_OFLOW_RATE_MIN    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_MAX    	number(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_STCNT	varchar2(32)  	NOT NULL
);

alter table UDPTEST_TREND add constraint PK_UDP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE UDPTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE UDPTEST_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
	MSMT_TIME_END          	date,
	PKT_RATE_IN_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_IN_MAX	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_OUT_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_RATE_OUT_MAX	VARCHAR2(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MIN	VARCHAR2(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MAX	VARCHAR2(256)	  	NOT NULL
);

alter table UDPTEST_THRESH add constraint PK_UDP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_UDPTEST_THRESH ON UDPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE USER_ROLE CASCADE CONSTRAINTS;

create table USER_ROLE
(
	role_name varchar2(32) primary key,
	admin_perm number(20) not null,
	monitor_perm number(20) not null,
	reporter_perm number(20) not null,
	admin_action number(20) not null,
	monitor_action number(20) not null,
	reporter_action number(20) not null,
	all_components char(1) not null,
	config_perm number(20) not null,
	config_action number(20) not null
);          

insert into user_role values('Admin',9223372036854775807, 9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('ServerAdmin',9223372036854775806,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Supermonitor',0,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Monitor',0,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('SupermonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'y',0,0);
insert into user_role values('MonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('AlarmViewer',0,9223372036854775807,0,0,7,0,'n',0,0);
insert into user_role values('SuperAlarmViewer',0,9223372036854775807,0,0,7,0,'y',0,0);
insert into user_role values('egsm',0,9223372036854775807, 9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdmin',772,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdminNoConfig',772,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);


DROP TABLE USER_INFO CASCADE CONSTRAINTS;

CREATE TABLE USER_INFO
(
        USER_ID             varchar2(256),
        USER_PASS           varchar2(1024)  NOT NULL,
        USER_TYPE           varchar2(32)  NOT NULL,
        USER_MAILID         varchar2(2000),
        USER_ALARM_TYPE     varchar2(32),
        USER_ALARM_PREF     varchar2(32),
        USER_ALARM_MODE     varchar2(32),
 USER_VALID_TILL     DATE,  
 USER_REG_DATE     DATE,
 USER_SERV_TYPE     varchar2(1024),
 CA_ENABLED         varchar2(16),
 REPT_TIMELINE    varchar2(16)
);

alter table USER_INFO add constraint PK_USER_INFO
primary key (USER_ID);

DROP TABLE USER_SITE CASCADE CONSTRAINTS;

CREATE TABLE USER_SITE
(
	USER_ID 		varchar2(256),
	SITE_NAME		varchar2(128)
);

alter table USER_SITE add constraint PK_USER_SITE
primary key (
		USER_ID,
		SITE_NAME
	);

alter table USER_SITE add constraint FK_USER_SITE
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_SERVICEGROUP CASCADE CONSTRAINTS;

CREATE TABLE USER_SERVICEGROUP
(
	USER_ID			varchar2(256),
	SERVICEGROUP_NAME	varchar2(128)
);

alter table USER_SERVICEGROUP add constraint PK_USER_SERVICEGROUP
primary key (USER_ID,SERVICEGROUP_NAME);
 
alter table USER_SERVICEGROUP add constraint FK_USER_SERVICEGROUP
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_SEG CASCADE CONSTRAINTS;

CREATE TABLE USER_SEG
(
        USER_ID                varchar2(256),
        SEG_NAME               varchar2(128)
);

alter table USER_SEG add constraint PK_USER_SEG
primary key (
                USER_ID,
                SEG_NAME
        );

alter table USER_SEG add constraint FK_USER_SEG
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;


DROP TABLE USER_SERV CASCADE CONSTRAINTS;

CREATE TABLE USER_SERV
(
	USER_ID 		varchar2(256),
	SERV_NAME		varchar2(128),
	SERV_TYPE		varchar2(128)
);

alter table USER_SERV add constraint PK_USER_SERV
primary key (
		USER_ID,
		SERV_NAME,
		SERV_TYPE
	);

alter table USER_SERV add constraint FK_USER_SERV
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

DROP TABLE USER_VM CASCADE CONSTRAINTS; 

CREATE TABLE USER_VM 
( 
	USER_ID			 varchar2(256), 
	SERV_NAME		 varchar2(128), 
	SERV_TYPE		 varchar2(128), 
	VM_NAME			 varchar2(128) 
); 

alter table USER_VM add constraint PK_USER_VM 
primary key ( 
		USER_ID, 
		SERV_NAME, 
		SERV_TYPE, 
		VM_NAME
	); 
alter table USER_VM add constraint FK_USER_VM 
foreign key(USER_ID) references USER_INFO(USER_ID) ON DELETE CASCADE;

insert into user_info (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('admin','26:28:21:27:27','Admin','true#true','-1');
insert into user_info (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('supermonitor','43:43:35:43:35:31:30:22:32:18:10:9','Supermonitor','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egsm','24:15:24:23','egsm','false','-1');

DROP TABLE QINSIGHT_DETAILS CASCADE CONSTRAINTS;
DROP TABLE QINSIGHT_REPORT CASCADE CONSTRAINTS;

CREATE TABLE QINSIGHT_REPORT(
	user_id varchar2(512) primary key ,
	No_of_tiers number(2),
	No_of_servers_per_tier number(2),
	No_of_metrics_per_server number(2),
	refresh_rate number(5)
);


CREATE TABLE QINSIGHT_DETAILS(
	user_id varchar2(512),
	tier_name varchar2(128),
	tier_index number(2),
	server_name varchar2(128),
	server_index number(2),
	component varchar2(256),
	metric_name varchar2(128),
	metric_index number(2),
	test varchar2(31),
	measure varchar2(31),
	info varchar2(128),
	site varchar2(64),
	type char(1)
);

DROP TABLE USER_REPORTS CASCADE CONSTRAINTS;
DROP TABLE USER_REPORT_DETAILS CASCADE CONSTRAINTS;

CREATE TABLE USER_REPORTS(
	rept_id number(16) NOT NULL,
	user_id varchar2(256),
	rept_name varchar2(128),
	unique(user_id,rept_name)
);
ALTER TABLE USER_REPORTS ADD constraint PK_USER_REPORTS
PRIMARY KEY (rept_id);

INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(1,'admin','USER_PREF');
INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(2,'supermonitor','USER_PREF');

CREATE TABLE USER_REPORT_DETAILS(
	rept_id number(16) NOT NULL,
	rept_param varchar2(128),
	rept_value varchar2(1024)
);

alter table USER_REPORT_DETAILS add constraint FK_USER_REPORT_DETAILS
foreign key(rept_id) references user_reports(rept_id) ON DELETE CASCADE;

INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(1,'ALARM_WINDOW','HIL');
INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(2,'ALARM_WINDOW','HIL');

DROP TABLE WAPTEST  CASCADE CONSTRAINTS;

CREATE TABLE WAPTEST 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        AVAILABILITY            number(20,4)    NOT NULL,
        AVAILABILITY_ST        	varchar2(32)  	NOT NULL,
        CONN_AVAILABILITY 	number(20,4)    NOT NULL,
        CONN_AVAILABILITY_ST 	varchar2(32)  	NOT NULL,
        RESPONSE_TIME           number(20,4)    NOT NULL, 
        RESPONSE_TIME_ST        varchar2(32)     NOT NULL 
);

ALTER TABLE WAPTEST ADD CONSTRAINT PK_WAP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WAPTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE WAPTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
        PORT_NO                 	varchar2(32),
        SITE_NAME               	varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
        AVAILABILITY_MIN            	number(20,4)    NOT NULL,
        AVAILABILITY_MAX            	number(20,4)    NOT NULL,
        AVAILABILITY_STCNT        	varchar2(32)  	NOT NULL,
        CONN_AVAILABILITY_MIN 		number(20,4)    NOT NULL,
        CONN_AVAILABILITY_MAX 		number(20,4)    NOT NULL,
        CONN_AVAILABILITY_STCNT 	varchar2(32)  	NOT NULL,
        RESPONSE_TIME_MIN           	number(20,4)    NOT NULL, 
        RESPONSE_TIME_MAX           	number(20,4)    NOT NULL, 
        RESPONSE_TIME_STCNT       	varchar2(32)     NOT NULL 
);

ALTER TABLE WAPTEST_TREND ADD CONSTRAINT PK_WAP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE WAPTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WAPTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO                 varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        AVAILABILITY_MIN	VARCHAR2(256)	    NOT NULL,
        AVAILABILITY_MAX	VARCHAR2(256)	    NOT NULL,
        CONN_AVAILABILITY_MIN	VARCHAR2(256)	    NOT NULL,
        CONN_AVAILABILITY_MAX	VARCHAR2(256)	    NOT NULL,
        RESPONSE_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        RESPONSE_TIME_MAX	VARCHAR2(256)	    NOT NULL
);

ALTER TABLE WAPTEST_THRESH ADD CONSTRAINT PK_WAP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WAPTEST_THRESH ON WAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE WEBLOGICEJBTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	TX_COMMIT_RATE			number(20,4)	NOT NULL,
	TX_COMMIT_RATE_ST		varchar2(32)	NOT NULL,
	TX_ROLLBACK_RATE 		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_ST 		varchar2(32)	NOT NULL,
	TX_INFLIGHT			number(8)	NOT NULL,
	TX_INFLIGHT_ST			varchar2(32)	NOT NULL,
	NUM_WAITING_RATE		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_ST 		varchar2(23)	NOT NULL,
	TIME_OUT_RATE			number(20,4)	NOT NULL,
	TIME_OUT_RATE_ST  		varchar2(32)	NOT NULL,
	IDLE_BEAN_PCT			number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_ST		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST ADD constraint PK_WLEJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICEJBTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	TX_COMMIT_RATE_MIN		number(20,4)	NOT NULL,	
	TX_COMMIT_RATE_MAX		number(20,4)	NOT NULL,
	TX_COMMIT_RATE_STCNT		varchar2(32)	NOT NULL,
	TX_ROLLBACK_RATE_MIN		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_MAX		number(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_STCNT		varchar2(32)	NOT NULL,
	TX_INFLIGHT_MIN			number(8)	NOT NULL,
	TX_INFLIGHT_MAX			number(8)	NOT NULL,
	TX_INFLIGHT_STCNT		varchar2(32)	NOT NULL,
	NUM_WAITING_RATE_MIN		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_MAX		number(20,4)	NOT NULL,
	NUM_WAITING_RATE_STCNT		varchar2(32)	NOT NULL,
	TIME_OUT_RATE_MIN		number(20,4)	NOT NULL,
	TIME_OUT_RATE_MAX		number(20,4)	NOT NULL,
	TIME_OUT_RATE_STCNT 		varchar2(32)    NOT NULL,
	IDLE_BEAN_PCT_MIN		number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_MAX		number(20,4)	NOT NULL,
	IDLE_BEAN_PCT_STCNT 		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_TREND ADD constraint PK_WLEJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICEJBTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICEJBTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
	TX_COMMIT_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TX_COMMIT_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TX_ROLLBACK_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TX_ROLLBACK_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TX_INFLIGHT_MIN	VARCHAR2(256)			NOT NULL,
	TX_INFLIGHT_MAX	VARCHAR2(256)			NOT NULL,
	NUM_WAITING_RATE_MIN	VARCHAR2(256)			NOT NULL,
	NUM_WAITING_RATE_MAX	VARCHAR2(256)			NOT NULL,
	TIME_OUT_RATE_MIN	VARCHAR2(256)			NOT NULL,
	TIME_OUT_RATE_MAX	VARCHAR2(256)			NOT NULL,
	IDLE_BEAN_PCT_MIN	VARCHAR2(256)			NOT NULL,
	IDLE_BEAN_PCT_MAX	VARCHAR2(256)			NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_THRESH ADD constraint PK_WLEJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICEJBTEST_THRESH ON WEBLOGICEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBLOGICJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	CONN_USE_PCT 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar2(32) 	NOT NULL,
	CONN_PENDING 	number(20,4) 	NOT NULL,
	CONN_PENDING_ST varchar2(32) 	NOT NULL,
	MAX_CONNS		number(20,4)		NOT NULL,
	MAX_CONNS_ST	varchar2(32) 	NOT NULL,
	CURR_CONNS		number(20,4)		NOT NULL,
	CURR_CONNS_ST	varchar2(32)	NOT NULL,
	POOL_STATE	number(20,4)	NOT NULL,
	POOL_STATE_ST	varchar2(32)	NOT NULL,
	FAIL_RECONNS	number(20,4)	NOT NULL,
	FAIL_RECONNS_ST	varchar2(32)	NOT NULL,
	CONNS_COUNT	number(20,4)	NOT NULL,
	CONNS_COUNT_ST	varchar2(32)	NOT NULL,
	CONNS_DELAY	number(20,4)	NOT NULL,
	CONNS_DELAY_ST	varchar2(32)	NOT NULL,
	LEAK_CONNS	number(20,4)	NOT NULL,
	LEAK_CONNS_ST	varchar2(32)	NOT NULL,
	ACTIVE_HIGH	number(20,4)	NOT NULL,
	ACTIVE_HIGH_ST	varchar2(32)	NOT NULL,
	WAIT_HIGH	number(20,4)	NOT NULL,
	WAIT_HIGH_ST	varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST ADD constraint PK_WEBLOGIC_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CONN_USE_PCT_MIN 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	number(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar2(32) 	NOT NULL,
	CONN_PENDING_MIN 	number(20,4) 	NOT NULL,
	CONN_PENDING_MAX 	number(20,4) 	NOT NULL,
	CONN_PENDING_STCNT 	varchar2(32) 	NOT NULL,
	MAX_CONNS_MIN		number(20,4)		NOT NULL,
	MAX_CONNS_MAX		number(20,4)		NOT NULL,
	MAX_CONNS_STCNT		varchar2(32)		NOT NULL,
	CURR_CONNS_MIN		number(20,4)		NOT NULL,
	CURR_CONNS_MAX		number(20,4)		NOT NULL,
	CURR_CONNS_STCNT	varchar2(32)	NOT NULL,
	POOL_STATE_MIN		number(20,4)	NOT NULL,
	POOL_STATE_MAX		number(20,4)	NOT NULL,
	POOL_STATE_STCNT	varchar2(32)	NOT NULL,
	FAIL_RECONNS_MIN	number(20,4)	NOT NULL,
	FAIL_RECONNS_MAX	number(20,4)	NOT NULL,
	FAIL_RECONNS_STCNT	varchar2(32)	NOT NULL,
	CONNS_COUNT_MIN		number(20,4)	NOT NULL,
	CONNS_COUNT_MAX		number(20,4)	NOT NULL,
	CONNS_COUNT_STCNT	varchar2(32)	NOT NULL,
	CONNS_DELAY_MIN		number(20,4)	NOT NULL,
	CONNS_DELAY_MAX		number(20,4)	NOT NULL,
	CONNS_DELAY_STCNT	varchar2(32)	NOT NULL,
	LEAK_CONNS_MIN		number(20,4)	NOT NULL,
	LEAK_CONNS_MAX		number(20,4)	NOT NULL,
	LEAK_CONNS_STCNT	varchar2(32)	NOT NULL,
	ACTIVE_HIGH_MIN		number(20,4)	NOT NULL,
	ACTIVE_HIGH_MAX		number(20,4)	NOT NULL,
	ACTIVE_HIGH_STCNT	varchar2(32)	NOT NULL,
	WAIT_HIGH_MIN		number(20,4)	NOT NULL,
	WAIT_HIGH_MAX		number(20,4)	NOT NULL,
	WAIT_HIGH_STCNT		varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_TREND ADD constraint PK_WEBLOGIC_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	CONN_USE_PCT_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR2(256)	 	NOT NULL,
	CONN_PENDING_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_PENDING_MAX	VARCHAR2(256)	 	NOT NULL,
	MAX_CONNS_MIN	VARCHAR2(256)			NOT NULL,
	MAX_CONNS_MAX	VARCHAR2(256)			NOT NULL,
	CURR_CONNS_MIN	VARCHAR2(256)			NOT NULL,
	CURR_CONNS_MAX	VARCHAR2(256)			NOT NULL,
	POOL_STATE_MIN	VARCHAR2(256)		NOT NULL,
	POOL_STATE_MAX	VARCHAR2(256)		NOT NULL,
	FAIL_RECONNS_MIN	VARCHAR2(256)		NOT NULL,
	FAIL_RECONNS_MAX	VARCHAR2(256)		NOT NULL,
	CONNS_COUNT_MIN	VARCHAR2(256)		NOT NULL,
	CONNS_COUNT_MAX	VARCHAR2(256)		NOT NULL,
	CONNS_DELAY_MIN	VARCHAR2(256)		NOT NULL,
	CONNS_DELAY_MAX	VARCHAR2(256)		NOT NULL,
	LEAK_CONNS_MIN	VARCHAR2(256)		NOT NULL,
	LEAK_CONNS_MAX	VARCHAR2(256)		NOT NULL,
	ACTIVE_HIGH_MIN	VARCHAR2(256)		NOT NULL,
	ACTIVE_HIGH_MAX	VARCHAR2(256)		NOT NULL,
	WAIT_HIGH_MIN	VARCHAR2(256)		NOT NULL,
	WAIT_HIGH_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_THRESH ADD constraint PK_WEBLOGIC_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICJDBCTEST_THRESH ON WEBLOGICJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE WEBLOGICTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	THROUGHPUT 		number(20,4) 	NOT NULL,
	THROUGHPUT_ST 	varchar2(32) 	NOT NULL,
	PCT_HEAP_USE 	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar2(32) 	NOT NULL,
	EXECUTE_Q_LEN 	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_ST varchar2(32) 	NOT NULL,
	TOTAL_HEAP		number(20,4) 	NOT NULL,
	TOTAL_HEAP_ST	varchar2(32)	NOT NULL,
	FREE_HEAP		number(20,4)	NOT NULL,	
	FREE_HEAP_ST	varchar2(32)	NOT NULL
);

ALTER TABLE WEBLOGICTEST ADD constraint PK_WEB_LOGIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBLOGICTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	THROUGHPUT_MIN	        number(20,4) 	NOT NULL,
	THROUGHPUT_MAX	        number(20,4) 	NOT NULL,
	THROUGHPUT_STCNT 	varchar2(32) 	NOT NULL,
	PCT_HEAP_USE_MIN	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar2(32) 	NOT NULL,
	EXECUTE_Q_LEN_MIN	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_MAX	number(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_HEAP_MIN		number(20,4) 	NOT NULL,
	TOTAL_HEAP_MAX	number(20,4) 	NOT NULL,
	TOTAL_HEAP_STCNT 	varchar2(32) 	NOT NULL,
	FREE_HEAP_MIN		number(20,4) 	NOT NULL,
	FREE_HEAP_MAX		number(20,4) 	NOT NULL,
	FREE_HEAP_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_TREND ADD constraint PK_WEB_LOGIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBLOGICTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	THROUGHPUT_MIN	VARCHAR2(256)	 	NOT NULL,
	THROUGHPUT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MIN	VARCHAR2(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_HEAP_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_HEAP_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_HEAP_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_HEAP_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_THRESH ADD constraint PK_WEB_LOGIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICTEST_THRESH ON WEBLOGICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WEBSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date,
        CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	REQ_RATE 	number(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar2(32)    NOT NULL,
	BYTE_RATE_IN 	number(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar2(32)    NOT NULL,
	PCT_ERR 	number(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_ABORT 	number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar2(32)    NOT NULL,
	PCT_300_ERR 	number(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_400_ERR 	number(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_500_ERR 	number(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar2(32)    NOT NULL,
        CURR_REQ 	number(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar2(32)    NOT NULL
	);

ALTER TABLE WEBSERVERTEST ADD CONSTRAINT PK_WEBMON_SERVER 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME       		varchar2(64),  
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD	 			varchar2(32), 
        CONN_RATE_MIN 			number(20,4) 	NOT NULL,
        CONN_RATE_MAX 			number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)    NOT NULL,
	REQ_RATE_MIN 			number(20,4) 	NOT NULL,
	REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar2(32)    NOT NULL,
	BYTE_RATE_IN_MIN    		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX    		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar2(32)    NOT NULL,
	PCT_ERR_MIN 			number(20,4) 	NOT NULL,
	PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
	PCT_ABORT_MIN    		number(20,4) 	NOT NULL,
	PCT_ABORT_MAX    		number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar2(32)    NOT NULL,
	PCT_300_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_400_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_500_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar2(32)    NOT NULL,
        CURR_REQ_MIN     		number(20,4) 	NOT NULL,
        CURR_REQ_MAX     		number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar2(32)    NOT NULL
);

ALTER TABLE WEBSERVERTEST_TREND ADD CONSTRAINT PK_WEBMON_SERVER_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBSERVERTEST_THRESH
(
	TRGT_HOST 	  varchar2(32),
	PORT_NO 	  varchar2(32),
        SITE_NAME         varchar2(64),  
        INFO              varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	  date,
        MSMT_TIME_END     date,
        CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	  NOT NULL
     );
ALTER TABLE WEBSERVERTEST_THRESH ADD CONSTRAINT PK_WEBMON_SERVER_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSERVERTEST_THRESH ON WEBSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  



DROP TABLE WEBSITETEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO 	varchar2(32),
        SITE_NAME       varchar2(64),  
        INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
        MSMT_TIME 	date,
        CONN_RATE 	number(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar2(32)    NOT NULL,
	REQ_RATE 	number(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar2(32)    NOT NULL,
	BYTE_RATE_IN 	number(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar2(32)    NOT NULL,
	PCT_ERR 	number(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_ABORT 	number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar2(32)    NOT NULL,
	PCT_300_ERR 	number(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_400_ERR 	number(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar2(32)    NOT NULL,
	PCT_500_ERR 	number(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar2(32)    NOT NULL,
        CURR_REQ 	number(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar2(32)    NOT NULL
	);

ALTER TABLE WEBSITETEST ADD CONSTRAINT PK_WEBSITE 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WEBSITETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME       		varchar2(64),  
        INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD  			varchar2(32), 
        CONN_RATE_MIN 			number(20,4) 	NOT NULL,
        CONN_RATE_MAX 			number(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar2(32)    NOT NULL,
	REQ_RATE_MIN 			number(20,4) 	NOT NULL,
	REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT 		varchar2(32)    NOT NULL,
	BYTE_RATE_IN_MIN 		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX 		number(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar2(32)    NOT NULL,
	PCT_ERR_MIN 			number(20,4) 	NOT NULL,
	PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
	PCT_ABORT_MIN 			number(20,4) 	NOT NULL,
	PCT_ABORT_MAX 			number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar2(32)    NOT NULL,
	PCT_300_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT		varchar2(32)    NOT NULL,
	PCT_400_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar2(32)    NOT NULL,
	PCT_500_ERR_MIN 		number(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		number(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar2(32)    NOT NULL,
        CURR_REQ_MIN 			number(20,4) 	NOT NULL,
        CURR_REQ_MAX 			number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar2(32)    NOT NULL
);

ALTER TABLE WEBSITETEST_TREND ADD CONSTRAINT PK_WEBSITE_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETEST_THRESH
(
	TRGT_HOST 	  varchar2(32),
	PORT_NO 	  varchar2(32),
        SITE_NAME         varchar2(64),  
        INFO              varchar2(128),
	MSMT_HOST 	  varchar2(32), 
	MSMT_TIME_START	  date,
        MSMT_TIME_END     date,
        CONN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR2(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	  NOT NULL
     );
ALTER TABLE WEBSITETEST_THRESH ADD CONSTRAINT PK_WEBSITE_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETEST_THRESH ON WEBSITETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       

DROP TABLE   WEBSITETRANSACTIONTEST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        REQ_RATE 		number(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar2(32)    NOT NULL,
        PCT_ERR 		number(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar2(32)    NOT NULL,
        PCT_ABORT 		number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	        number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar2(32)    NOT NULL,
        AVG_RESP_TIME 	        number(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar2(32) 	NOT NULL,
        CURR_REQ 		number(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar2(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST ADD CONSTRAINT PK_WEBSITE_TRAN 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   WEBSITETRANSACTIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST_TREND 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO 			varchar2(32),
        SITE_NAME               	varchar2(64),  
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	PERIOD 				varchar2(32), 
        REQ_RATE_MIN 			number(20,4) 	NOT NULL,
        REQ_RATE_MAX 			number(20,4) 	NOT NULL,
	REQ_RATE_STCNT 	       		varchar2(32)    NOT NULL,
        PCT_ERR_MIN 			number(20,4) 	NOT NULL,
        PCT_ERR_MAX 			number(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar2(32)    NOT NULL,
        PCT_ABORT_MIN 			number(20,4) 	NOT NULL,
        PCT_ABORT_MAX 			number(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 	       	varchar2(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 	       	number(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 	       	number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar2(32)    NOT NULL,
        AVG_RESP_TIME_MIN 	       	number(20,4) 	NOT NULL,
        AVG_RESP_TIME_MAX 	       	number(20,4) 	NOT NULL,
	AVG_RESP_TIME_STCNT        	varchar2(32) 	NOT NULL,
        CURR_REQ_MIN 			number(20,4) 	NOT NULL,
        CURR_REQ_MAX 			number(20,4) 	NOT NULL,
	CURR_REQ_STCNT 	       		varchar2(32)    NOT NULL
      );
ALTER TABLE WEBSITETRANSACTIONTEST_TREND ADD CONSTRAINT PK_WEBSITE_TRAN_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETRANSACTIONTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WEBSITETRANSACTIONTEST_THRESH
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START 	date,
        MSMT_TIME_END           date,
        REQ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
        PCT_ERR_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR2(256)	 	NOT NULL,
        PCT_ABORT_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR2(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR2(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR2(256)	 	NOT NULL,
        AVG_RESP_TIME_MIN	VARCHAR2(256)	    NOT NULL,
        AVG_RESP_TIME_MAX	VARCHAR2(256)	    NOT NULL,
        CURR_REQ_MIN	VARCHAR2(256)	    NOT NULL,
        CURR_REQ_MAX	VARCHAR2(256)	    NOT NULL
     );
ALTER TABLE WEBSITETRANSACTIONTEST_THRESH ADD CONSTRAINT PK_WEBSITE_TRAN_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETRANSTEST_THRESH ON WEBSITETRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE   WEBSITETRANSACTIONTEST_LAST CASCADE CONSTRAINTS;

CREATE TABLE WEBSITETRANSACTIONTEST_LAST 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO 		varchar2(32),
        SITE_NAME               varchar2(64),  
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
        MSMT_TIME 		date,
        REQ_RATE 		number(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar2(32)    NOT NULL,
        PCT_ERR 		number(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar2(32)    NOT NULL,
        PCT_ABORT 		number(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar2(32)    NOT NULL,
        BYTE_RATE_OUT 	        number(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar2(32)    NOT NULL,
        AVG_RESP_TIME 	        number(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar2(32) 	NOT NULL,
        CURR_REQ 		number(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar2(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST_LAST ADD CONSTRAINT PK_WEBSITE_TRAN_LAST 
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO);
create index idx_websitetranstest_last on websitetransactiontest_last(site_name);


DROP TABLE WINSERVICETEST CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	AVAIL		number(3) 	NOT NULL,
	AVAIL_ST	varchar2(32)    NOT NULL,
	SERVICE_STATE		number(3) 	NOT NULL,
	SERVICE_STATE_ST	varchar2(32)    NOT NULL

);

ALTER TABLE WINSERVICETEST ADD constraint PK_WINSERVICE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WINSERVICETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST_TREND 
(
	TRGT_HOST 		varchar2(32),
        PORT_NO         	varchar2(32),
        SITE_NAME       	varchar2(64),
        INFO            	varchar2(128), 
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	PERIOD 			varchar2(32),
	AVAIL_MIN		number(20,4) 	NOT NULL,
	AVAIL_MAX		number(20,4) 	NOT NULL,
	AVAIL_STCNT		varchar2(32)   	NOT NULL,
	SERVICE_STATE_MIN	number(20,4) 	NOT NULL,
	SERVICE_STATE_MAX	number(20,4) 	NOT NULL,
	SERVICE_STATE_STCNT	varchar2(32)   	NOT NULL
);

ALTER TABLE WINSERVICETEST_TREND ADD constraint PK_WINSERVICE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WINSERVICETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WINSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
        PORT_NO         varchar2(32),
        SITE_NAME       varchar2(64),
        INFO            varchar2(128), 
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	AVAIL_MIN	VARCHAR2(256)	 	NOT NULL,
	AVAIL_MAX	VARCHAR2(256)	 	NOT NULL,
	SERVICE_STATE_MIN	VARCHAR2(256)	NOT NULL,
	SERVICE_STATE_MAX	VARCHAR2(256)	NOT NULL
);

ALTER TABLE WINSERVICETEST_THRESH ADD constraint PK_WINSERVICE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WINSERVICETEST_THRESH ON WINSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE WSEJBTEST CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	INSTANTIATES		number(20,4) 	NOT NULL,
	INSTANTIATES_ST		varchar2(32) 	NOT NULL,
	DESTROYS		number(20,4) 	NOT NULL,
	DESTROYS_ST		varchar2(32) 	NOT NULL,
	TOT_METHOD_CALLS	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_ST	varchar2(32) 	NOT NULL,
	AVG_METHOD_RT		number(20,4) 	NOT NULL,
	AVG_METHOD_RT_ST	varchar2(32) 	NOT NULL,
	AVG_CREATE_TIME		number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE		number(20,4) 	NOT NULL,
	POOl_SIZE_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST ADD constraint PK_WS_EJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSEJBTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	INSTANTIATES_MIN	number(20,4) 	NOT NULL,
	INSTANTIATES_MAX	number(20,4) 	NOT NULL,
	INSTANTIATES_STCNT	varchar2(32) 	NOT NULL,
	DESTROYS_MIN		number(20,4) 	NOT NULL,
	DESTROYS_MAX		number(20,4) 	NOT NULL,
	DESTROYS_STCNT		varchar2(32) 	NOT NULL,
	TOT_METHOD_CALLS_MIN	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_MAX	number(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_STCNT	varchar2(32) 	NOT NULL,
	AVG_METHOD_RT_MIN	number(20,4) 	NOT NULL,
	AVG_METHOD_RT_MAX	number(20,4) 	NOT NULL,
	AVG_METHOD_RT_STCNT	varchar2(32) 	NOT NULL,
	AVG_CREATE_TIME_MIN	number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_MAX	number(20,4) 	NOT NULL,
	AVG_CREATE_TIME_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST_TREND ADD constraint PK_WS_EJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSEJBTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSEJBTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME        	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
        MSMT_TIME_END   	date,
	INSTANTIATES_MIN	VARCHAR2(256)	 	NOT NULL,
	INSTANTIATES_MAX	VARCHAR2(256)	 	NOT NULL,
	DESTROYS_MIN	VARCHAR2(256)	 	NOT NULL,
	DESTROYS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MIN	VARCHAR2(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_METHOD_RT_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_METHOD_RT_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_CREATE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_CREATE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSEJBTEST_THRESH ADD constraint PK_WS_EJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSEJBTEST_THRESH ON WSEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSGLOBALTXTEST CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	GLOBAL_TX_BEGUN			number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_ST		varchar2(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_ST		varchar2(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_ST	varchar2(32) 	NOT NULL,
	NUM_OPTIMIZATION		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK		number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_ST	varchar2(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_ST		varchar2(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_ST		varchar2(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION		number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSGLOBALTXTEST ADD constraint PK_WS_GL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSGLOBALTXTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	GLOBAL_TX_BEGUN_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX		number(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_DURATION_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	number(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_STCNT	varchar2(32) 	NOT NULL,
	NUM_OPTIMIZATION_MIN		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_MAX		number(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	number(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_STCNT		varchar2(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX		number(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_STCNT	varchar2(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	number(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_STCNT	varchar2(32) 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_TREND ADD constraint PK_WS_GL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSGLOBALTXTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSGLOBALTXTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	GLOBAL_TX_BEGUN_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	VARCHAR2(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	VARCHAR2(256)	 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_THRESH ADD constraint PK_WS_GL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSGLOBALTXTEST_THRESH ON WSGLOBALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSJDBCTEST CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	CREATION_RATE		number(20,4) 	NOT NULL,
	CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	DESTROY_RATE		number(20,4) 	NOT NULL,
	DESTROY_RATE_ST		varchar2(32) 	NOT NULL,
	RETURN_RATE		number(20,4) 	NOT NULL,
	RETURN_RATE_ST		varchar2(32) 	NOT NULL,
	ALLOCATE_RATE		number(20,4) 	NOT NULL,
	ALLOCATE_RATE_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE		number(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar2(32) 	NOT NULL,
	CONCUR_WAITERS		number(20,4) 	NOT NULL,
	CONCUR_WAITERS_ST	varchar2(32) 	NOT NULL,
	AVG_WAIT_TIME		number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_ST	varchar2(32) 	NOT NULL,
	FAULTS			number(20,4) 	NOT NULL,
	FAULTS_ST		varchar2(32) 	NOT NULL,
	PCT_USED		number(20,4) 	NOT NULL,
	PCT_USED_ST		varchar2(32) 	NOT NULL,
	PCT_MAXED		number(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar2(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST ADD constraint PK_WS_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSJDBCTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	CREATION_RATE_MIN	number(20,4) 	NOT NULL,
	CREATION_RATE_MAX	number(20,4) 	NOT NULL,
	CREATION_RATE_STCNT	varchar2(32) 	NOT NULL,
	DESTROY_RATE_MIN	number(20,4) 	NOT NULL,
	DESTROY_RATE_MAX	number(20,4) 	NOT NULL,
	DESTROY_RATE_STCNT	varchar2(32) 	NOT NULL,
	RETURN_RATE_MIN		number(20,4) 	NOT NULL,
	RETURN_RATE_MAX		number(20,4) 	NOT NULL,
	RETURN_RATE_STCNT	varchar2(32) 	NOT NULL,
	ALLOCATE_RATE_MIN	number(20,4) 	NOT NULL,
	ALLOCATE_RATE_MAX	number(20,4) 	NOT NULL,
	ALLOCATE_RATE_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL,
	CONCUR_WAITERS_MIN	number(20,4) 	NOT NULL,
	CONCUR_WAITERS_MAX	number(20,4) 	NOT NULL,
	CONCUR_WAITERS_STCNT	varchar2(32) 	NOT NULL,
	AVG_WAIT_TIME_MIN	number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_MAX	number(20,4) 	NOT NULL,
	AVG_WAIT_TIME_STCNT	varchar2(32) 	NOT NULL,
	FAULTS_MIN		number(20,4) 	NOT NULL,
	FAULTS_MAX		number(20,4) 	NOT NULL,
	FAULTS_STCNT		varchar2(32) 	NOT NULL,
	PCT_USED_MIN		number(20,4) 	NOT NULL,
	PCT_USED_MAX		number(20,4) 	NOT NULL,
	PCT_USED_STCNT		varchar2(32) 	NOT NULL,
	PCT_MAXED_MIN		number(20,4) 	NOT NULL,
	PCT_MAXED_MAX		number(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar2(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	number(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_STCNT	varchar2(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST_TREND ADD constraint PK_WS_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSJDBCTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSJDBCTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DESTROY_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DESTROY_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	RETURN_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	RETURN_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	ALLOCATE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	ALLOCATE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCUR_WAITERS_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCUR_WAITERS_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_WAIT_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_WAIT_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	FAULTS_MIN	VARCHAR2(256)	 	NOT NULL,
	FAULTS_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_USED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_USED_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR2(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	VARCHAR2(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSJDBCTEST_THRESH ADD constraint PK_WS_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSJDBCTEST_THRESH ON WSJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSLOCALTXTEST CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	LOCAL_TX_BEGUN			number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_ST		varchar2(32) 	NOT NULL,
	ACTIVE_LOCAL_TX			number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_DURA		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_ST		varchar2(32) 	NOT NULL,
	LOCAL_COMMIT_DURA		number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_ST	varchar2(32) 	NOT NULL,
	LOCAL_TX_COMMITTED		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK		number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_ST		varchar2(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSLOCALTXTEST ADD constraint PK_WS_LOCAL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSLOCALTXTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	LOCAL_TX_BEGUN_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN		number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX		number(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_STCNT		varchar2(32) 	NOT NULL,
	LOCAL_TX_DURA_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_DURA_STCNT		varchar2(32) 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	number(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	number(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_STCNT	varchar2(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX		number(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_STCNT		varchar2(32) 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_TREND ADD constraint PK_WS_LOCAL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSLOCALTXTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSLOCALTXTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	LOCAL_TX_BEGUN_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_BEGUN_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_DURA_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_DURA_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN	VARCHAR2(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX	VARCHAR2(256)	 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_THRESH ADD constraint PK_WS_LOCAL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSLOCALTXTEST_THRESH ON WSLOCALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSSRVLTSESSIONTEST CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	SESSION_CREATION_RATE	number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	INVALIDATED_SESSIONS	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_ST	varchar2(32) 	NOT NULL,
	SESSION_LIFE_TIME	number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_ST	varchar2(32) 	NOT NULL,
	ACTIVE_SESSIONS		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_ST	varchar2(32) 	NOT NULL,
	LIVE_SESSIONS		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST ADD constraint PK_WS_SS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSSRVLTSESSIONTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	SESSION_CREATION_RATE_MIN		number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_MAX		number(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_STCNT		varchar2(32) 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	number(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_STCNT	varchar2(32) 	NOT NULL,
	SESSION_LIFE_TIME_MIN		number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_MAX		number(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_STCNT		varchar2(32) 	NOT NULL,
	ACTIVE_SESSIONS_MIN		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_MAX		number(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_STCNT		varchar2(32) 	NOT NULL,
	LIVE_SESSIONS_MIN		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_MAX		number(20,4) 	NOT NULL,
	LIVE_SESSIONS_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_TREND ADD constraint PK_WS_SS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSSRVLTSESSIONTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSSRVLTSESSIONTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	SESSION_CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	LIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	LIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_THRESH ADD constraint PK_WS_SS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSSRVLTSESSIONTEST_THRESH ON WSSRVLTSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSTEST CASCADE CONSTRAINTS;

CREATE TABLE WSTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date,
	PCT_HEAP_USE 	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar2(32) 	NOT NULL,
	AVAILABILITY 	number(20,4) 	NOT NULL,
	AVAILABILITY_ST	varchar2(32) 	NOT NULL
);

ALTER TABLE WSTEST ADD constraint PK_WS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	PCT_HEAP_USE_MIN	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	number(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar2(32) 	NOT NULL,
	AVAILABILITY_MIN	number(20,4) 	NOT NULL,
	AVAILABILITY_MAX	number(20,4) 	NOT NULL,
	AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE WSTEST_TREND ADD constraint PK_WS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	PCT_HEAP_USE_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR2(256)	 	NOT NULL,
	AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSTEST_THRESH ADD constraint PK_WS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTEST_THRESH ON WSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSTHREADPOOLTEST CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	THREAD_CREATION_RATE 	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_ST	varchar2(32) 	NOT NULL,
	THREAD_DESTROY_RATE 	number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_ST	varchar2(32) 	NOT NULL,
	ACTIVE_THREADS 		number(20,4) 	NOT NULL,
	ACTIVE_THREADS_ST	varchar2(32) 	NOT NULL,
	POOL_SIZE 		number(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar2(32) 	NOT NULL,
	PCT_MAXED		number(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST ADD constraint PK_WSTHREAD_POOL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSTHREADPOOLTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME		date,
	PERIOD 			varchar2(32),
	THREAD_CREATION_RATE_MIN	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_MAX	number(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_STCNT 	varchar2(32) 	NOT NULL,
	THREAD_DESTROY_RATE_MIN		number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_MAX		number(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_STCNT	varchar2(32) 	NOT NULL,
	ACTIVE_THREADS_MIN	number(20,4) 	NOT NULL,
	ACTIVE_THREADS_MAX	number(20,4) 	NOT NULL,
	ACTIVE_THREADS_STCNT	varchar2(32) 	NOT NULL,
	POOL_SIZE_MIN		number(20,4) 	NOT NULL,
	POOL_SIZE_MAX		number(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar2(32) 	NOT NULL,
	PCT_MAXED_MIN		number(20,4) 	NOT NULL,
	PCT_MAXED_MAX		number(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_TREND ADD constraint PK_WSTHREAD_POOL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTHREADPOOLTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSTHREADPOOLTEST_THRESH 
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      		varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START		date,
        MSMT_TIME_END   	date,
	THREAD_CREATION_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	THREAD_CREATION_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREADS_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREADS_MAX	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR2(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_THRESH ADD constraint PK_WSTHREAD_POOL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTHREADPOOLTEST_THRESH ON WSTHREADPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WSWEBAPPSTEST CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST
(
	TRGT_HOST 		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME 		date,
	NUM_LOADED_SERVLETS	number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_ST	varchar2(32) 	NOT NULL,
	NUM_RELOADS		number(20,4) 	NOT NULL,
	NUM_RELOADS_ST		varchar2(32) 	NOT NULL,
	REQUEST_RATE		number(20,4) 	NOT NULL,
	REQUEST_RATE_ST		varchar2(32) 	NOT NULL,
	CONCURRENT_REQUESTS	number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_ST	varchar2(32) 	NOT NULL,
	RESPONSE_TIME		number(20,4) 	NOT NULL,
	RESPONSE_TIME_ST	varchar2(32) 	NOT NULL,
	NUM_ERRORS		number(20,4) 	NOT NULL,
	NUM_ERRORS_ST		varchar2(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST ADD constraint PK_WS_WEB_APPS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WSWEBAPPSTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	NUM_LOADED_SERVLETS_MIN		number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX		number(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_STCNT	varchar2(32) 	NOT NULL,
	NUM_RELOADS_MIN			number(20,4) 	NOT NULL,
	NUM_RELOADS_MAX			number(20,4) 	NOT NULL,
	NUM_RELOADS_STCNT		varchar2(32) 	NOT NULL,
	REQUEST_RATE_MIN		number(20,4) 	NOT NULL,
	REQUEST_RATE_MAX		number(20,4) 	NOT NULL,
	REQUEST_RATE_STCNT		varchar2(32) 	NOT NULL,
	CONCURRENT_REQUESTS_MIN		number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_MAX		number(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_STCNT	varchar2(32) 	NOT NULL,
	RESPONSE_TIME_MIN		number(20,4) 	NOT NULL,
	RESPONSE_TIME_MAX		number(20,4) 	NOT NULL,
	RESPONSE_TIME_STCNT		varchar2(32) 	NOT NULL,
	NUM_ERRORS_MIN			number(20,4) 	NOT NULL,
	NUM_ERRORS_MAX			number(20,4) 	NOT NULL,
	NUM_ERRORS_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_TREND ADD constraint PK_WS_WEB_APPS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSWEBAPPSTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WSWEBAPPSTEST_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
        MSMT_TIME_END   		date,
	NUM_LOADED_SERVLETS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_RELOADS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_RELOADS_MAX	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MIN	VARCHAR2(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MAX	VARCHAR2(256)	 	NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_ERRORS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_ERRORS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_THRESH ADD constraint PK_WS_WEB_APPS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSWEBAPPSTEST_THRESH ON WSWEBAPPSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE XChgCacheTest CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	cacheHitRatio			number(20,4) not null,
	cacheHitRatio_ST		varchar2(32) not null
);

ALTER TABLE XChgCacheTest ADD constraint PK_XChgCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgCacheTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	cacheHitRatio_min		number(20,4) not null,
	cacheHitRatio_max		number(20,4) not null,
	cacheHitRatio_stcnt		varchar2(32) not null
);

ALTER TABLE XChgCacheTest_TREND ADD constraint PK_XChgCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgCacheTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgCacheTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CACHEHITRATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgCacheTest_THRESH ADD constraint PK_XChgCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgCacheTest_THRESH ON XChgCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgDBTest CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	dbCacheHit			number(20,4) not null,
	dbCacheHit_ST			varchar2(32) not null,
	dbTablesCacheHit		number(20,4) not null,
	dbTablesCacheHit_st		varchar2(32) not null,
	logRecrdWaitingRate		number(20,4) not null,
	logRecrdWaitingRate_st		varchar2(32) not null,
	logThreadWaiting		Number(20,4) not null,
	logThreadWaiting_st		varchar2(32) not null
);

ALTER TABLE XChgDBTest ADD constraint PK_XChgDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgDBTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	dbCacheHit_min			number(20,4) not null,
	dbCacheHit_max			number(20,4) not null,
	dbCacheHit_stcnt		varchar2(32) not null,
	dbTablesCacheHit_min		number(20,4) not null,
	dbTablesCacheHit_max		number(20,4) not null,
	dbTablesCacheHit_stcnt		varchar2(32) not null,
	logRecrdWaitingRate_min		number(20,4) not null,
	logRecrdWaitingRate_max		number(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar2(32) not null,
	logThreadWaiting_min		Number(20,4) not null,
	logThreadWaiting_max		Number(20,4) not null,
	logThreadWaiting_stcnt		varchar2(32) not null
);

ALTER TABLE XChgDBTest_TREND ADD constraint PK_XChgDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgDBTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgDBTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	DBCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR2(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR2(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgDBTest_THRESH ADD constraint PK_XChgDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgDBTest_THRESH ON XChgDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgMailRetrvlTest CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currPop3Conn			Number(20,4) not null,
	currPop3Conn_st			varchar2(32) not null,
	currImapConn			Number(20,4) not null,
	currImapConn_st			varchar2(32) not null,
	pop3AuthFailures		Number(20,4) not null,
	pop3AuthFailures_st		varchar2(32) not null,
	imapAuthFailures		Number(20,4) not null,
	imapAuthFailures_st		varchar2(32) not null
);

ALTER TABLE XChgMailRetrvlTest ADD constraint PK_XChgMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgMailRetrvlTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currPop3Conn_min		Number(20,4) not null,
	currPop3Conn_max		Number(20,4) not null,
	currPop3Conn_stcnt		varchar2(32) not null,
	currImapConn_min		Number(20,4) not null,
	currImapConn_max		Number(20,4) not null,
	currImapConn_stcnt		varchar2(32) not null,
	pop3AuthFailures_min		Number(20,4) not null,
	pop3AuthFailures_max		Number(20,4) not null,
	pop3AuthFailures_stcnt		varchar2(32) not null,
	imapAuthFailures_min		Number(20,4) not null,
	imapAuthFailures_max		Number(20,4) not null,
	imapAuthFailures_stcnt		varchar2(32) not null
);

ALTER TABLE XChgMailRetrvlTest_TREND ADD constraint PK_XChgMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailRetrvlTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRPOP3CONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	POP3AUTHFAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	POP3AUTHFAILURES_MAX	VARCHAR2(256)	 NOT NULL,
	IMAPAUTHFAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	IMAPAUTHFAILURES_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgMailRetrvlTest_THRESH ADD constraint PK_XChgMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailRetrvlTest_THRESH ON XChgMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgMailXferTest CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	localQSize			Number(20,4) not null,
	localQSize_st			varchar2(32) not null,
	remoteQSize			Number(20,4) not null,
	remoteQSize_st			varchar2(32) not null,
	currSmtpConn			Number(20,4) not null,
	currSmtpConn_st			varchar2(32) not null,
	badMailMsgs			Number(20,4) not null,
	badMailMsgs_st			varchar2(32) not null,
	dataRcvdRate			number(20,4) not null,
	dataRcvdRate_st			varchar2(32) not null,
	dataSentRate			number(20,4) not null,
	dataSentRate_st			varchar2(32) not null,
	avgRetryMsgDelvry		number(20,4) not null,
	avgRetryMsgDelvry_st		varchar2(32) not null,
	avgRetryMsgSent			number(20,4) not null,
	avgRetryMsgSent_st		varchar2(32) not null
);

ALTER TABLE XChgMailXferTest ADD constraint PK_XChgMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgMailXferTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	localQSize_min			Number(20,4) not null,
	localQSize_max			Number(20,4) not null,
	localQSize_stcnt		varchar2(32) not null,
	remoteQSize_min			Number(20,4) not null,
	remoteQSize_max			Number(20,4) not null,
	remoteQSize_stcnt		varchar2(32) not null,
	currSmtpConn_min		Number(20,4) not null,
	currSmtpConn_max		Number(20,4) not null,
	currSmtpConn_stcnt		varchar2(32) not null,
	badMailMsgs_min			Number(20,4) not null,
	badMailMsgs_max			Number(20,4) not null,
	badMailMsgs_stcnt		varchar2(32) not null,
	dataRcvdRate_min		number(20,4) not null,
	dataRcvdRate_max		number(20,4) not null,
	dataRcvdRate_stcnt		varchar2(32) not null,
	dataSentRate_min		number(20,4) not null,
	dataSentRate_max		number(20,4) not null,
	dataSentRate_stcnt		varchar2(32) not null,
	avgRetryMsgDelvry_min		number(20,4) not null,
	avgRetryMsgDelvry_max		number(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar2(32) not null,
	avgRetryMsgSent_min		number(20,4) not null,
	avgRetryMsgSent_max		number(20,4) not null,
	avgRetryMsgSent_stcnt		varchar2(32) not null
);

ALTER TABLE XChgMailXferTest_TREND ADD constraint PK_XChgMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailXferTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgMailXferTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	LOCALQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR2(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR2(256)	 NOT NULL,
	BADMAILMSGS_MIN	VARCHAR2(256)	 NOT NULL,
	BADMAILMSGS_MAX	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR2(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgMailXferTest_THRESH ADD constraint PK_XChgMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailXferTest_THRESH ON XChgMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          
DROP TABLE XChgStoreTest CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME 			date,
	currUsers			Number(20,4) not null,
	currUsers_st			varchar2(32) not null,
	mailSendQSize			Number(20,4) not null,
	mailSendQSize_st		varchar2(32) not null,
	mailRcvdQSize			Number(20,4) not null,
	mailRcvdQSize_st		varchar2(32) not null,
	mailSentRate			number(20,4) not null,
	mailSentRate_st			varchar2(32) not null,
	mailOpensRate			number(20,4) not null,
	mailOpensRate_st		varchar2(32) not null,
	folderOpensRate			number(20,4) not null,
	folderOpensRate_st		varchar2(32) not null,
	avgMailDelvryTime			number(20,4) not null,
	avgMailDelvryTime_st		varchar2(32) not null,
	avgMailLocalDelvryTime		number(20,4) not null,
	avgMailLocalDelvryTime_st		varchar2(32) not null
);

ALTER TABLE XChgStoreTest ADD constraint PK_XChgStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE   XChgStoreTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest_TREND 
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	currUsers_min			Number(20,4) not null,
	currUsers_max			Number(20,4) not null,
	currUsers_stcnt			varchar2(32) not null,
	mailSendQSize_min		Number(20,4) not null,
	mailSendQSize_max		Number(20,4) not null,
	mailSendQSize_stcnt		varchar2(32) not null,
	mailRcvdQSize_min		Number(20,4) not null,
	mailRcvdQSize_max		Number(20,4) not null,
	mailRcvdQSize_stcnt		varchar2(32) not null,
	mailSentRate_min		number(20,4) not null,
	mailSentRate_max		number(20,4) not null,
	mailSentRate_stcnt		varchar2(32) not null,
	mailOpensRate_min		number(20,4) not null,
	mailOpensRate_max		number(20,4) not null,
	mailOpensRate_stcnt		varchar2(32) not null,
	folderOpensRate_min		number(20,4) not null,
	folderOpensRate_max		number(20,4) not null,
	folderOpensRate_stcnt		varchar2(32) not null,
	avgMailDelvryTime_min		number(20,4) not null,
	avgMailDelvryTime_max		number(20,4) not null,
	avgMailDelvryTime_stcnt		varchar2(32) not null,
	avgMailLocalDelvryTime_min		number(20,4) not null,
	avgMailLocalDelvryTime_max		number(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar2(32) not null
);

ALTER TABLE XChgStoreTest_TREND ADD constraint PK_XChgStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgStoreTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XChgStoreTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME_START			date,
      	MSMT_TIME_END   		date,
      	CURRUSERS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR2(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XChgStoreTest_THRESH ADD constraint PK_XChgStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgStoreTest_THRESH ON XChgStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNTHREADTEST CASCADE CONSTRAINTS;
CREATE TABLE JRUNTHREADTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32), 
	MSMT_TIME 	date ,
	Pct_threads_utilized 		number(20,4) 	NOT NULL,
	Pct_threads_utilized_st 	varchar2(32) 	NOT NULL,
	Waiting_thread_count 		Number(20,4) 	NOT NULL,
	Waiting_thread_count_st		varchar2(32) 	NOT NULL,
	Total_threads_count	 	Number(20,4) 	NOT NULL,
	Total_threads_count_st		 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST ADD constraint PK_JRUNTHREADTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNTHREADTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNTHREADTEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date ,
	PERIOD 			varchar2(32) ,
	Pct_threads_utilized_MIN	        number(20,4) 	NOT NULL,
	Pct_threads_utilized_MAX	        number(20,4) 	NOT NULL,
	Pct_threads_utilized_STCNT 	varchar2(32) 	NOT NULL,
	Waiting_thread_count_MIN	number(20,4) 	NOT NULL,
	Waiting_thread_count_MAX	number(20,4) 	NOT NULL,
	Waiting_thread_count_STCNT 	varchar2(32) 	NOT NULL,
	Total_threads_count_MIN		number(20,4) 	NOT NULL,
	Total_threads_count_MAX		number(20,4) 	NOT NULL,
	Total_threads_count_STCNT 	varchar2(32) 	NOT NULL
);


ALTER TABLE JRUNTHREADTEST_TREND ADD constraint PK_JRUNTHREADTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNTHREADTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNTHREADTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32) ,
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date ,
        MSMT_TIME_END   date ,
	PCT_THREADS_UTILIZED_MIN	VARCHAR2(256)	 	NOT NULL,
	PCT_THREADS_UTILIZED_MAX	VARCHAR2(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST_THRESH ADD constraint PK_JRUNTHREADTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNTHREADTEST_THRESH ON JRUNTHREADTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNSERVERTEST CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64) ,
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME 	date ,
	Total_serv_memory 		number(20,4) 	NOT NULL,
	Total_serv_memory_st 	varchar2(32) 	NOT NULL,
	Free_serv_memory 		number(20,4) 	NOT NULL,
	Free_serv_memory_st		varchar2(32) 	NOT NULL,
	Num_active_sessions	 	Number(20,4) 	NOT NULL,
	Num_active_sessions_st		 varchar2(32) 	NOT NULL,
	Num_mem_sessions	 	Number(20,4) 	NOT NULL,
	Num_mem_sessions_st		 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNSERVERTEST ADD constraint PK_JRUNSERVERTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNSERVERTEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST_TREND 
(
	TRGT_HOST		varchar2(32) ,
	PORT_NO         	varchar2(32) ,
	SITE_NAME       	varchar2(64) ,
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date ,
	PERIOD 			varchar2(32) ,
	Total_serv_memory_MIN	        number(20,4) 	NOT NULL,
	Total_serv_memory_MAX	        number(20,4) 	NOT NULL,
	Total_serv_memory_STCNT 	varchar2(32) 	NOT NULL,
	Free_serv_memory_MIN		number(20,4) 	NOT NULL,
	Free_serv_memory_MAX		number(20,4) 	NOT NULL,
	Free_serv_memory_STCNT 		varchar2(32) 	NOT NULL,
	Num_active_sessions_MIN		number(20,4) 	NOT NULL,
	Num_active_sessions_MAX		number(20,4) 	NOT NULL,
	Num_active_sessions_STCNT 	varchar2(32) 	NOT NULL,
	Num_mem_sessions_MIN		number(20,4) 	NOT NULL,
	Num_mem_sessions_MAX		number(20,4) 	NOT NULL,
	Num_mem_sessions_STCNT 		varchar2(32) 	NOT NULL	
);


ALTER TABLE JRUNSERVERTEST_TREND ADD constraint PK_JRUNSERVERTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVERTEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	TOTAL_SERV_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_SERV_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MIN	VARCHAR2(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MIN	VARCHAR2(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNSERVERTEST_THRESH ADD constraint PK_JRUNSERVERTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVERTEST_THRESH ON JRUNSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JRUNSERVICETEST CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME 	date,
	Request_rate	number(20,4) NOT NULL,
	Request_rate_st	varchar2(32) NOT NULL,
	Avg_queue_time 		number(20,4) 	NOT NULL,
	Avg_queue_time_st 	varchar2(32) 	NOT NULL,
	Avg_proc_time 		number(20,4) 	NOT NULL,
	Avg_proc_time_st		varchar2(32) 	NOT NULL,
	Avg_response_time	 	number(20,4) 	NOT NULL,
	Avg_response_time_st		 varchar2(32) 	NOT NULL,
	Data_read_rate	 		number(20,4) 	NOT NULL,
	Data_read_rate_st		 varchar2(32) 	NOT NULL,
	Data_write_rate	 		number(20,4) 	NOT NULL,
	Data_write_rate_st		 varchar2(32) 	NOT NULL,
	Delayed_request_count	 	Number(20,4) 	NOT NULL,
	Delayed_request_count_st	 varchar2(32) 	NOT NULL,
	Dropped_request_count	 	Number(20,4) 	NOT NULL,
	Dropped_request_count_st	 varchar2(32) 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST ADD constraint PK_JRUNSERVICETEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 

DROP TABLE JRUNSERVICETEST_TREND CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST_TREND 
(
	TRGT_HOST		varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST 		varchar2(32) , 
	MSMT_TIME		date,
	PERIOD 			varchar2(32) NOT NULL,
	Request_rate_MIN	        number(20,4) 	NOT NULL,
	Request_rate_MAX	        number(20,4) 	NOT NULL,
	Request_rate_STCNT			varchar2(32)	NOT NULL,
	Avg_queue_time_MIN	        number(20,4) 	NOT NULL,
	Avg_queue_time_MAX	        number(20,4) 	NOT NULL,
	Avg_queue_time_STCNT 		varchar2(32) 	NOT NULL,
	Avg_proc_time_MIN		number(20,4) 	NOT NULL,
	Avg_proc_time_MAX		number(20,4) 	NOT NULL,
	Avg_proc_time_STCNT 		varchar2(32) 	NOT NULL,
	Avg_response_time_MIN		number(20,4) 	NOT NULL,
	Avg_response_time_MAX		number(20,4) 	NOT NULL,
	Avg_response_time_STCNT 	varchar2(32) 	NOT NULL,
	Data_read_rate_MIN		number(20,4) 	NOT NULL,
	Data_read_rate_MAX		number(20,4) 	NOT NULL,
	Data_read_rate_STCNT 		varchar2(32) 	NOT NULL,	
	Data_write_rate_MIN		number(20,4) 	NOT NULL,
	Data_write_rate_MAX		number(20,4) 	NOT NULL,
	Data_write_rate_STCNT 		varchar2(32) 	NOT NULL,	
	Delayed_request_count_MIN		number(20,4) 	NOT NULL,
	Delayed_request_count_MAX		number(20,4) 	NOT NULL,
	Delayed_request_count_STCNT 		varchar2(32) 	NOT NULL,
	Dropped_request_count_MIN		number(20,4) 	NOT NULL,
	Dropped_request_count_MAX		number(20,4) 	NOT NULL,
	Dropped_request_count_STCNT 		varchar2(32) 	NOT NULL	
);


ALTER TABLE JRUNSERVICETEST_TREND ADD constraint PK_JRUNSERVICETEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVICETEST_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JRUNSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME        varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST 	varchar2(32) , 
	MSMT_TIME_START	date,
        MSMT_TIME_END   date,
	REQUEST_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_PROC_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_PROC_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR2(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_READ_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_READ_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DATA_WRITE_RATE_MIN	VARCHAR2(256)	 	NOT NULL,
	DATA_WRITE_RATE_MAX	VARCHAR2(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST_THRESH ADD constraint PK_JRUNSERVICETEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVICETEST_THRESH ON JRUNSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE PrinterTest CASCADE CONSTRAINTS;
CREATE TABLE PrinterTest
( 	
	TRGT_HOST			varchar2(32),       
	PORT_NO    			varchar2(32),       
	SITE_NAME      			varchar2(64),       
	INFO           			varchar2(128),	
	MSMT_HOST			varchar2(32),	
	MSMT_TIME     			date,
	PRINTER_AVAILABILITY	 	Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterTest ADD constraint PK_PrinterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterTest_TREND 
( 	
	TRGT_HOST       			varchar2(32),       
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME       			date,	
	PERIOD       				varchar2(32),
	PRINTER_AVAILABILITY_MIN 		Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_MAX 		Number(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_STCNT		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterTest_TREND ADD constraint PK_PrinterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterTest_THRESH 
( 	
	TRGT_HOST       			varchar2(32),       
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME_START 			date,	
	MSMT_TIME_END   			date,
	PRINTER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	PRINTER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL
);
ALTER TABLE PrinterTest_THRESH ADD constraint PK_PrinterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterTest_THRESH ON PrinterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterCoverTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest 
( 	
	TRGT_HOST       		varchar2(32),       
	PORT_NO         		varchar2(32),       
	SITE_NAME       		varchar2(64),       
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	COVER_CLOSED 			Number(20,4) 	NOT NULL,
	COVER_CLOSED_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest ADD constraint PK_PrinterCoverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterCoverTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),       
	PORT_NO         		varchar2(32),       
	SITE_NAME       		varchar2(64),       
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,	
	PERIOD       			varchar2(32),
	COVER_CLOSED_MIN 		Number(20,4) 	NOT NULL,
	COVER_CLOSED_MAX 		Number(20,4) 	NOT NULL,
	COVER_CLOSED_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest_TREND ADD constraint PK_PrinterCoverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterCoverTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterCoverTest_THRESH 
( 		
	TRGT_HOST       	varchar2(32),       
	PORT_NO        		varchar2(32), 
	SITE_NAME       	varchar2(64), 
	INFO            	varchar2(128),	
	MSMT_HOST     		varchar2(32),	
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	COVER_CLOSED_MIN	VARCHAR2(256)	 	NOT NULL,
	COVER_CLOSED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PrinterCoverTest_THRESH ADD constraint PK_PrinterCoverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterCoverTest_THRESH ON PrinterCoverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterErrorTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest
( 
	TRGT_HOST       		varchar2(32),    
	PORT_NO         		varchar2(32),     
	SITE_NAME       		varchar2(64),  
	INFO            			varchar2(128),	
	MSMT_HOST			varchar2(32),	
	MSMT_TIME       		date,
	PAPER_AVAILABILITY 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_ST varchar2(32) 	NOT NULL,
	TONER_CAPACITY 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_ST 	varchar2(32) 	NOT NULL,
	TONER_AVAILABILITY 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_ST varchar2(32) 	NOT NULL,
	PAPER_FLOW 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_ST 		varchar2(32) 	NOT NULL,
	ON_LINE 				Number(20,4) 	NOT NULL,
	ON_LINE_ST 			varchar2(32) 	NOT NULL,
	DOOR_CLOSED 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_ST 		varchar2(32) NOT NULL
);
	
ALTER TABLE PrinterErrorTest ADD constraint PK_PrinterErrorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterErrorTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest_TREND
( 
	TRGT_HOST       			varchar2(32),  
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),       
	INFO            				varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME       			date,	
	PERIOD       				varchar2(32),
	PAPER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL,
	TONER_CAPACITY_MIN 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_MAX 		Number(20,4) 	NOT NULL,
	TONER_CAPACITY_STCNT 	varchar2(32) 	NOT NULL,
	TONER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	TONER_AVAILABILITY_STCNT 	varchar2(32)	NOT NULL,
	PAPER_FLOW_MIN 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_MAX 			Number(20,4) 	NOT NULL,
	PAPER_FLOW_STCNT 		varchar2(32) 	NOT NULL,
	ON_LINE_MIN 				Number(20,4) 	NOT NULL,
	ON_LINE_MAX 				Number(20,4) 	NOT NULL,
	ON_LINE_STCNT 			varchar2(32) 	NOT NULL,
	DOOR_CLOSED_MIN 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_MAX 		Number(20,4) 	NOT NULL,
	DOOR_CLOSED_STCNT 		varchar2(32) 	NOT NULL
);
	
ALTER TABLE PrinterErrorTest_TREND ADD constraint PK_PrinterErrorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterErrorTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterErrorTest_THRESH 
( 	
	TRGT_HOST       			varchar2(32), 
	PORT_NO         			varchar2(32),       
	SITE_NAME       			varchar2(64),	
	INFO            				varchar2(128),	
	MSMT_HOST       			varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   			date,
	PAPER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	PAPER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL,
	TONER_CAPACITY_MIN	VARCHAR2(256)	 	NOT NULL,
	TONER_CAPACITY_MAX	VARCHAR2(256)		NOT NULL,
	TONER_AVAILABILITY_MIN	VARCHAR2(256)	 	NOT NULL,
	TONER_AVAILABILITY_MAX	VARCHAR2(256)	 	NOT NULL,
	PAPER_FLOW_MIN	VARCHAR2(256)	 	NOT NULL,
	PAPER_FLOW_MAX	VARCHAR2(256)	 	NOT NULL,
	ON_LINE_MIN	VARCHAR2(256)	 	NOT NULL,
	ON_LINE_MAX	VARCHAR2(256)	 	NOT NULL,
	DOOR_CLOSED_MIN	VARCHAR2(256)	 	NOT NULL,
	DOOR_CLOSED_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE PrinterErrorTest_THRESH ADD constraint PK_PrinterErrorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterErrorTest_THRESH ON PrinterErrorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterInputTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest
( 	
	TRGT_HOST       		varchar2(32),   
	PORT_NO         		varchar2(32),      
	SITE_NAME       		varchar2(64),     
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	TRAY_AVAILABILITY 		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_ST		varchar2(32) 	NOT NULL,
	TRAY_IDLE 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_ST 			varchar2(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY 	Number(20,4)	NOT NULL,
	TRAY_PAPER_AVAILABILITY_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest ADD constraint PK_PrinterInputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterInputTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),   
	PORT_NO         		varchar2(32),   
	SITE_NAME       		varchar2(64),      
	INFO            		varchar2(128),	
	MSMT_HOST      			varchar2(32),	
	MSMT_TIME      			date,	
	PERIOD       			varchar2(32),
	TRAY_AVAILABILITY_MIN 		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_MAX		Number(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_STCNT 	varchar2(32)	NOT NULL,
	TRAY_IDLE_MIN 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_MAX 			Number(20,4) 	NOT NULL,
	TRAY_IDLE_STCNT 		varchar2(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN 	Number(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX 	Number(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest_TREND ADD constraint PK_PrinterInputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterInputTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterInputTest_THRESH 
( 	
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),
	INFO           			varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	TRAY_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	TRAY_IDLE_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_IDLE_MAX	VARCHAR2(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterInputTest_THRESH ADD constraint PK_PrinterInputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterInputTest_THRESH ON PrinterInputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterOutputTest CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),  
	INFO            		varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME      			date,
	OUTPUT_BIN_AVAILABLE 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_ST 	varchar2(32) 	NOT NULL,
	OUTPUT_BIN_IDLE 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest ADD constraint PK_PrinterOutputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterOutputTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest_TREND
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO           			varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	OUTPUT_BIN_AVAILABLE_MIN 	Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX 	Number(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_STCNT	varchar2(32) 	NOT NULL,
	OUTPUT_BIN_IDLE_MIN 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_MAX 		Number(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest_TREND ADD constraint PK_PrinterOutputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterOutputTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterOutputTest_THRESH
( 	
	TRGT_HOST      			varchar2(32),  
	PORT_NO         		varchar2(32),   
	SITE_NAME       		varchar2(64),     
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   		date,
	OUTPUT_BIN_AVAILABLE_MIN	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MIN	VARCHAR2(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterOutputTest_THRESH ADD constraint PK_PrinterOutputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterOutputTest_THRESH ON PrinterOutputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterPageCount CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount
( 	
	TRGT_HOST       varchar2(32),  
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),   
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PAGES_PRINTED Number(20,4)
	NOT NULL,
	PAGES_PRINTED_ST varchar2(32) NOT NULL
);

ALTER TABLE PrinterPageCount ADD constraint PK_PrinterPageCount PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE PrinterPageCount_TREND CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount_TREND 
( 	
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME      	 		varchar2(64), 
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	PAGES_PRINTED_MIN 		Number(20,4) 	NOT NULL,
	PAGES_PRINTED_MAX 		Number(20,4) 	NOT NULL,
	PAGES_PRINTED_STCNT 		varchar2(32) 	NOT NULL
);

ALTER TABLE PrinterPageCount_TREND ADD constraint PK_PrinterPageCount_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterPageCount_THRESH CASCADE CONSTRAINTS;

CREATE TABLE PrinterPageCount_THRESH 
( 	
	TRGT_HOST       		varchar2(32),  
	PORT_NO        			varchar2(32),   
	SITE_NAME       		varchar2(64),    
	INFO            		varchar2(128),	
	MSMT_HOST       		varchar2(32),	
	MSMT_TIME_START 		date,	
	MSMT_TIME_END   		date,
	PAGES_PRINTED_MIN	VARCHAR2(256)	 NOT NULL,
	PAGES_PRINTED_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE PrinterPageCount_THRESH ADD constraint PK_PrinterPageCount_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterPageCount_THRESH ON PrinterPageCount_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE BackupJobsTest CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	ACTIVE_JOB_COUNT 	Number(20,4)   NOT NULL,
	ACTIVE_JOB_COUNT_ST 	varchar2(32) 	NOT NULL,
	FAILED_JOBS_COUNT 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_ST 	varchar2(32) 	NOT NULL,
	SUCCESSFUL_JOBS 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_ST 	varchar2(32) 	NOT NULL,
	TOTAL_BYTES 		Number(20,4) 	NOT NULL,
	TOTAL_BYTES_ST 		varchar2(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest ADD constraint PK_BackupJobsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BackupJobsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO           		varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	ACTIVE_JOB_COUNT_MIN 	Number(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX 	Number(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_STCNT 	varchar2(32) 	NOT NULL,
	FAILED_JOBS_COUNT_MIN 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_MAX 	Number(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_STCNT varchar2(32) 	NOT NULL,
	SUCCESSFUL_JOBS_MIN 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_MAX 	Number(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_BYTES_MIN 	Number(20,4) 	NOT NULL,
	TOTAL_BYTES_MAX 	Number(20,4) 	NOT NULL,
	TOTAL_BYTES_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest_TREND ADD constraint PK_BackupJobsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BackupJobsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE BackupJobsTest_THRESH 
( 	
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ACTIVE_JOB_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MIN	VARCHAR2(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MAX	VARCHAR2(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MIN	VARCHAR2(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_BYTES_MIN	VARCHAR2(256)	 	NOT NULL,
	TOTAL_BYTES_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE BackupJobsTest_THRESH ADD constraint PK_BackupJobsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_BackupJobsTest_THRESH ON BackupJobsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE VeritasStatsTest CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	ABORTED_JOBS 		Number(20,4) 	NOT NULL,
	ABORTED_JOBS_ST 	varchar2(32) 	NOT NULL,
	CORRUPTED_OBJECTS 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_ST 	varchar2(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS 	Number(20,4) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_ST varchar2(32) 	NOT NULL,
	FAILED_VERIFY_OBJECTS 	Number(20,4) 	NOT NULL,
	FAILED_VERIFY_OBJECTS_ST varchar2(32) 	NOT NULL,
	SKIPPED_OBJECTS 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_ST 	varchar2(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest ADD constraint PK_VeritasStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE VeritasStatsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	ABORTED_JOBS_MIN 	Number(20,4) 	NOT NULL,
	ABORTED_JOBS_MAX 	Number(20,4) 	NOT NULL,
	ABORTED_JOBS_STCNT 	varchar2(32) 	NOT NULL,
	CORRUPTED_OBJECTS_MIN 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_MAX 	Number(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_STCNT varchar2(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN Number(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX Number(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_STCNT varchar2(32) NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN Number(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX Number(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_STCNT varchar2(32) NOT NULL,
	SKIPPED_OBJECTS_MIN 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_MAX 	Number(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_STCNT 	varchar2(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest_TREND ADD constraint PK_VeritasStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE VeritasStatsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE VeritasStatsTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ABORTED_JOBS_MIN	VARCHAR2(256)	 	NOT NULL,
	ABORTED_JOBS_MAX	VARCHAR2(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MIN	VARCHAR2(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MAX	VARCHAR2(256)	 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	SKIPPED_OBJECTS_MIN	VARCHAR2(256)	 	NOT NULL,
	SKIPPED_OBJECTS_MAX	VARCHAR2(256)	 	NOT NULL
);

ALTER TABLE VeritasStatsTest_THRESH ADD constraint PK_VeritasStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_VeritasStatsTest_THRESH ON VeritasStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE EventLogTest CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	APP_ERROR_CNT		Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_ST 	varchar2(32) 	NOT NULL,
	APP_INFRM_CNT		Number(20,4)	NOT NULL,
	APP_INFRM_CNT_ST	varchar2(32)	NOT NULL,
	APP_WARNING_CNT		Number(20,4)	NOT NULL,
	APP_WARNING_CNT_ST	varchar2(32)	NOT NULL,
	SYS_ERROR_CNT		Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_ST	varchar2(32)	NOT NULL,
	SYS_INFRM_CNT		Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_ST	varchar2(32)	NOT NULL,
	SYS_WARNING_CNT		Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_ST	varchar2(32)	NOT NULL,
	APP_CRITICAL_CNT	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_ST 	varchar2(32) 	NOT NULL,
	APP_VERBOSE_CNT		Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_ST	varchar2(32)	NOT NULL,
	SYS_CRITICAL_CNT	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_ST	varchar2(32)	NOT NULL,
	SYS_VERBOSE_CNT		Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_ST	varchar2(32)	NOT NULL
);

ALTER TABLE EventLogTest ADD constraint PK_EventLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE EventLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       		varchar2(32),
	APP_ERROR_CNT_MIN	Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_MAX	Number(20,4) 	NOT NULL,
	APP_ERROR_CNT_STCNT 	varchar2(32) 	NOT NULL,
	APP_INFRM_CNT_MIN	Number(20,4)	NOT NULL,
	APP_INFRM_CNT_MAX	Number(20,4)	NOT NULL,
	APP_INFRM_CNT_STCNT	varchar2(32)	NOT NULL,
	APP_WARNING_CNT_MIN	Number(20,4)	NOT NULL,
	APP_WARNING_CNT_MAX	Number(20,4)	NOT NULL,
	APP_WARNING_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_ERROR_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_ERROR_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_INFRM_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_INFRM_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_WARNING_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_WARNING_CNT_STCNT	varchar2(32)	NOT NULL,
	APP_CRITICAL_CNT_MIN	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_MAX	Number(20,4) 	NOT NULL,
	APP_CRITICAL_CNT_STCNT 	varchar2(32) 	NOT NULL,
	APP_VERBOSE_CNT_MIN	Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_MAX	Number(20,4)	NOT NULL,
	APP_VERBOSE_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_CRITICAL_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_STCNT	varchar2(32)	NOT NULL,
	SYS_VERBOSE_CNT_MIN	Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_MAX	Number(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_STCNT	varchar2(32)	NOT NULL
);

ALTER TABLE EventLogTest_TREND ADD constraint PK_EventLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EventLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE EventLogTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO            	varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	APP_ERROR_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	APP_ERROR_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	APP_INFRM_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_INFRM_CNT_MAX	VARCHAR2(256)		NOT NULL,
	APP_WARNING_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_WARNING_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_ERROR_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_ERROR_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_INFRM_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_INFRM_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_WARNING_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_WARNING_CNT_MAX	VARCHAR2(256)		NOT NULL,
	APP_CRITICAL_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	APP_CRITICAL_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	APP_VERBOSE_CNT_MIN	VARCHAR2(256)		NOT NULL,
	APP_VERBOSE_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_CRITICAL_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_CRITICAL_CNT_MAX	VARCHAR2(256)		NOT NULL,
	SYS_VERBOSE_CNT_MIN	VARCHAR2(256)		NOT NULL,
	SYS_VERBOSE_CNT_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE EventLogTest_THRESH ADD constraint PK_EventLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EventLogTest_THRESH ON EventLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JavaServerTest CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest
( 
	TRGT_HOST       varchar2(32),
	PORT_NO         	varchar2(32),
	SITE_NAME       	varchar2(64),
	INFO       	  	varchar2(128),
	MSMT_HOST      varchar2(32),
	MSMT_TIME       date,
	ACTIVE_THREAD_CNT	Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_ST 	varchar2(32) 	NOT NULL,
	TOTAL_MEMORY 		Number(20,4)	NOT NULL,
	TOTAL_MEMORY_ST	        varchar2(32)	NOT NULL,
	FREE_MEMORY           	Number(20,4)	NOT NULL,
	FREE_MEMORY_ST	        varchar2(32)	NOT NULL
);

ALTER TABLE JavaServerTest ADD constraint PK_JavaServerTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE JavaServerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest_TREND
(
	TRGT_HOST       	varchar2(32),
	PORT_NO             	varchar2(32),
	SITE_NAME      	 	varchar2(64),
	INFO            	        varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME       	date,
	PERIOD       	        varchar2(32),
	ACTIVE_THREAD_CNT_MIN	        Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	Number(20,4) 	NOT NULL,
	ACTIVE_THREAD_CNT_STCNT 	varchar2(32) 	NOT NULL,
	TOTAL_MEMORY_MIN	                Number(20,4)	NOT NULL,
	TOTAL_MEMORY_MAX         	Number(20,4)	NOT NULL,
	TOTAL_MEMORY_STCNT	        varchar2(32)	NOT NULL,
	FREE_MEMORY_MIN	                Number(20,4)	NOT NULL,
	FREE_MEMORY_MAX	                Number(20,4)	NOT NULL,
	FREE_MEMORY_STCNT	        varchar2(32)	NOT NULL
);

ALTER TABLE JavaServerTest_TREND ADD constraint PK_JavaServerTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JavaServerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE JavaServerTest_THRESH
( 
	TRGT_HOST       	varchar2(32),
	PORT_NO               	varchar2(32),
	SITE_NAME       	        varchar2(64),
	INFO            	        varchar2(128),
	MSMT_HOST       	varchar2(32),
	MSMT_TIME_START 	date,
	MSMT_TIME_END   	date,
	ACTIVE_THREAD_CNT_MIN	VARCHAR2(256)	 	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	VARCHAR2(256)	 	NOT NULL,
	TOTAL_MEMORY_MIN	VARCHAR2(256)		NOT NULL,
	TOTAL_MEMORY_MAX	VARCHAR2(256)		NOT NULL,
	FREE_MEMORY_MIN	VARCHAR2(256)		NOT NULL,
	FREE_MEMORY_MAX	VARCHAR2(256)		NOT NULL
);

ALTER TABLE JavaServerTest_THRESH ADD constraint PK_JavaServerTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_JavaServerTest_THRESH ON JavaServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpConnectionTest CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest
( 
	TRGT_HOST      varchar2(32), 
	PORT_NO          varchar2(32),  
	SITE_NAME       varchar2(64),    
	INFO                 varchar2(128),	
	MSMT_HOST      varchar2(32),	
	MSMT_TIME       date,
	AVAILABILITY          Number(20,4) NOT NULL,
	AVAILABILITY_ST     varchar2(32) NOT NULL,
	RESPONSETIME        Number(20,4) NOT NULL,
	RESPONSETIME_ST  varchar2(32) NOT NULL
);

ALTER TABLE TcpConnectionTest ADD constraint PK_TcpConnectionTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE TcpConnectionTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest_TREND
(
	TRGT_HOST       varchar2(32),  
	PORT_NO           varchar2(32),  
	SITE_NAME        varchar2(64),
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,	
	PERIOD       	varchar2(32),
	AVAILABILITY_MIN        Number(20,4) NOT NULL,
	AVAILABILITY_MAX       Number(20,4) NOT NULL,
	AVAILABILITY_STCNT    varchar2(32) NOT NULL,
	RESPONSETIME_MIN      Number(20,4) NOT NULL,
	RESPONSETIME_MAX     Number(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar2(32) NOT NULL
);

ALTER TABLE TcpConnectionTest_TREND ADD constraint PK_TcpConnectionTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpConnectionTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TcpConnectionTest_THRESH 
( 
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32),
	SITE_NAME        varchar2(64), 
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),	
	MSMT_TIME_START  date,
	MSMT_TIME_END     date,
	AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR2(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE TcpConnectionTest_THRESH ADD constraint PK_TcpConnectionTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpConnectionTest_THRESH ON TcpConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProcessPoolTest CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest
(
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32), 
	SITE_NAME        varchar2(64),  
	INFO                  varchar2(128),	
	MSMT_HOST       varchar2(32),
	MSMT_TIME        date,
	NUMBER_OF_PROCESSES        Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_ST   varchar2(32) NOT NULL,
	PERCENTAGE_CPU_UTIL          Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_ST     varchar2(32) NOT NULL,
	PERCENTAGE_MEM_UTIL          Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_ST     varchar2(32) NOT NULL
);

ALTER TABLE ProcessPoolTest ADD constraint PK_ProcessPoolTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE ProcessPoolTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest_TREND
( 
	TRGT_HOST       varchar2(32),
	PORT_NO           varchar2(32),
	SITE_NAME        varchar2(64),
	INFO                 varchar2(128),	
	MSMT_HOST      varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	NUMBER_OF_PROCESSES_MIN        Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_MAX       Number(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_STCNT   varchar2(32) NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN         Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX        Number(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_STCNT    varchar2(32) NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN        Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX       Number(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_STCNT   varchar2(32) NOT NULL
);

ALTER TABLE ProcessPoolTest_TREND ADD constraint PK_ProcessPoolTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ProcessPoolTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ProcessPoolTest_THRESH
(
	TRGT_HOST      varchar2(32), 
	PORT_NO          varchar2(32), 
	SITE_NAME        varchar2(64),
	INFO                  varchar2(128),
	MSMT_HOST       varchar2(32),	
	MSMT_TIME_START  date,
	MSMT_TIME_END     date,
	NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
	NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ProcessPoolTest_THRESH ADD constraint PK_ProcessPoolTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProcessPoolTest_THRESH ON ProcessPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ErrorLogTest CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),    
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE ErrorLogTest ADD constraint PK_ErrorLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE ErrorLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest_TREND
(
 	TRGT_HOST       varchar2(32),   
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE ErrorLogTest_TREND ADD constraint PK_ErrorLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ErrorLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ErrorLogTest_THRESH
( 
	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE ErrorLogTest_THRESH ADD constraint PK_ErrorLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ErrorLogTest_THRESH ON ErrorLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsgLogTest CASCADE CONSTRAINTS;

CREATE TABLE MsgLogTest
(
 	TRGT_HOST       varchar2(32),  
    PORT_NO         varchar2(32),   
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE MsgLogTest ADD constraint PK_MsgLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE MsgLogTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsgLogTest_TREND
(
 	TRGT_HOST       varchar2(32),   
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MsgLogTest_TREND ADD constraint PK_MsgLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MsgLogTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsgLogTest_THRESH
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE MsgLogTest_THRESH ADD constraint PK_MsgLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsgLogTest_THRESH ON MsgLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE XceptionLogTest CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
    NUMBER_EXCEPTION_COUNT Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar2(32) NOT NULL
);

ALTER TABLE XceptionLogTest ADD constraint PK_XceptionLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE XceptionLogTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest_TREND 
( 
	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32),  
    SITE_NAME       varchar2(64),   
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
    NUMBER_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN Number(20,4) NOT NULL, 
    LOW_EXCEPTION_COUNT_MAX Number(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar2(32) NOT NULL
);

ALTER TABLE XceptionLogTest_TREND ADD constraint PK_XceptionLogTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE XceptionLogTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE XceptionLogTest_THRESH
(
 	TRGT_HOST       varchar2(32), 
    PORT_NO         varchar2(32), 
    SITE_NAME       varchar2(64),  
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE XceptionLogTest_THRESH ADD constraint PK_XceptionLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XceptionLogTest_THRESH ON XceptionLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE CiscoCatalystTest CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest (
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
DATA_RECVD_RATE Number(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar2(32) NOT NULL,
DATA_XMIT_RATE Number(20,4) NOT NULL,
DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
PCT_BANDWIDTH_USED Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_ST varchar2(32) NOT NULL);

ALTER TABLE CiscoCatalystTest ADD constraint PK_CiscoCatalystTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CiscoCatalystTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest_TREND ( 	
TRGT_HOST       varchar2(32),       
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,	
PERIOD       	varchar2(32),
DATA_RECVD_RATE_MIN Number(20,4) NOT NULL,
DATA_RECVD_RATE_MAX Number(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar2(32) NOT NULL,
DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
PCT_BANDWIDTH_USED_MIN Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_MAX Number(20,4) NOT NULL,
PCT_BANDWIDTH_USED_STCNT varchar2(32) NOT NULL);

ALTER TABLE CiscoCatalystTest_TREND ADD constraint PK_CiscoCatalystTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoCatalystTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CiscoCatalystTest_THRESH ( 	
TRGT_HOST       varchar2(32),       
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
DATA_RECVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DATA_RECVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MIN	VARCHAR2(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CiscoCatalystTest_THRESH ADD constraint PK_CiscoCatalystTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CiscoCatalystTest_THRESH ON CiscoCatalystTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxARTimeTest CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVAILABILITY NUMBER(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE TuxARTimeTest ADD constraint PK_TuxARTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxARTimeTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN NUMBER(20,4) NOT NULL,
AVAILABILITY_MAX NUMBER(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxARTimeTest_TREND ADD constraint PK_TuxARTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxARTimeTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxARTimeTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxARTimeTest_THRESH ADD constraint PK_TuxARTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxARTimeTest_THRESH ON TuxARTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxBridgeTest CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BRIDGE_STATE Number(20,4) NOT NULL,
BRIDGE_STATE_ST varchar2(32) NOT NULL,
BYT_RCVD_RATE NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_ST varchar2(32) NOT NULL,
BYT_SENT_RATE NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_ST varchar2(32) NOT NULL,
MSG_RCVD_RATE NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_ST varchar2(32) NOT NULL,
MSG_SENT_RATE NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxBridgeTest ADD constraint PK_TuxBridgeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxBridgeTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest_TREND ( 	TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
BRIDGE_STATE_MIN Number(20,4) NOT NULL,
BRIDGE_STATE_MAX Number(20,4) NOT NULL,
BRIDGE_STATE_STCNT varchar2(32) NOT NULL,
BYT_RCVD_RATE_MIN NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_MAX NUMBER(20,4) NOT NULL,
BYT_RCVD_RATE_STCNT varchar2(32) NOT NULL,
BYT_SENT_RATE_MIN NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_MAX NUMBER(20,4) NOT NULL,
BYT_SENT_RATE_STCNT varchar2(32) NOT NULL,
MSG_RCVD_RATE_MIN NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_MAX NUMBER(20,4) NOT NULL,
MSG_RCVD_RATE_STCNT varchar2(32) NOT NULL,
MSG_SENT_RATE_MIN NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_MAX NUMBER(20,4) NOT NULL,
MSG_SENT_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxBridgeTest_TREND ADD constraint PK_TuxBridgeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxBridgeTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxBridgeTest_THRESH ( 	TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
BRIDGE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
BRIDGE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
BYT_RCVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BYT_RCVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BYT_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BYT_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
MSG_RCVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
MSG_RCVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
MSG_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
MSG_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxBridgeTest_THRESH ADD constraint PK_TuxBridgeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxBridgeTest_THRESH ON TuxBridgeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TuxDomainTest CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CURR_MACS Number(20,4) NOT NULL,
CURR_MACS_ST varchar2(32) NOT NULL,
CURR_SERVERS Number(20,4) NOT NULL,
CURR_SERVERS_ST varchar2(32) NOT NULL,
CURR_QS Number(20,4) NOT NULL,
CURR_QS_ST varchar2(32) NOT NULL,
CURR_SERVICES Number(20,4) NOT NULL,
CURR_SERVICES_ST varchar2(32) NOT NULL,
MAC_PCT_UTIL NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_ST varchar2(32) NOT NULL,
SERVER_PCT_UTIL NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_ST varchar2(32) NOT NULL,
Q_PCT_UTIL NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_ST varchar2(32) NOT NULL,
SERVICE_PCT_UTIL NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_ST varchar2(32) NOT NULL);

ALTER TABLE TuxDomainTest ADD constraint PK_TuxDomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxDomainTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURR_MACS_MIN Number(20,4) NOT NULL,
CURR_MACS_MAX Number(20,4) NOT NULL,
CURR_MACS_STCNT varchar2(32) NOT NULL,
CURR_SERVERS_MIN Number(20,4) NOT NULL,
CURR_SERVERS_MAX Number(20,4) NOT NULL,
CURR_SERVERS_STCNT varchar2(32) NOT NULL,
CURR_QS_MIN Number(20,4) NOT NULL,
CURR_QS_MAX Number(20,4) NOT NULL,
CURR_QS_STCNT varchar2(32) NOT NULL,
CURR_SERVICES_MIN Number(20,4) NOT NULL,
CURR_SERVICES_MAX Number(20,4) NOT NULL,
CURR_SERVICES_STCNT varchar2(32) NOT NULL,
MAC_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
MAC_PCT_UTIL_STCNT varchar2(32) NOT NULL,
SERVER_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
SERVER_PCT_UTIL_STCNT varchar2(32) NOT NULL,
Q_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
Q_PCT_UTIL_STCNT varchar2(32) NOT NULL,
SERVICE_PCT_UTIL_MIN NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_MAX NUMBER(20,4) NOT NULL,
SERVICE_PCT_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxDomainTest_TREND ADD constraint PK_TuxDomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxDomainTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxDomainTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURR_MACS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_MACS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_SERVERS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_SERVERS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_QS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_QS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_SERVICES_MIN	VARCHAR2(256)	 NOT NULL,
CURR_SERVICES_MAX	VARCHAR2(256)	 NOT NULL,
MAC_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MAC_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
SERVER_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
Q_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
Q_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
SERVICE_PCT_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
SERVICE_PCT_UTIL_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxDomainTest_THRESH ADD constraint PK_TuxDomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxDomainTest_THRESH ON TuxDomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxProcsTest CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_OF_PROCS Number(20,4) NOT NULL,
NUM_OF_PROCS_ST varchar2(32) NOT NULL,
CPU_UTIL_PCT NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_ST varchar2(32) NOT NULL,
MEM_UTIL_PCT NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_ST varchar2(32) NOT NULL);

ALTER TABLE TuxProcsTest ADD constraint PK_TuxProcsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxProcsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_OF_PROCS_MIN Number(20,4) NOT NULL,
NUM_OF_PROCS_MAX Number(20,4) NOT NULL,
NUM_OF_PROCS_STCNT varchar2(32) NOT NULL,
CPU_UTIL_PCT_MIN NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_MAX NUMBER(20,4) NOT NULL,
CPU_UTIL_PCT_STCNT varchar2(32) NOT NULL,
MEM_UTIL_PCT_MIN NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_MAX NUMBER(20,4) NOT NULL,
MEM_UTIL_PCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxProcsTest_TREND ADD constraint PK_TuxProcsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxProcsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxProcsTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_OF_PROCS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_OF_PROCS_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_PCT_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_PCT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxProcsTest_THRESH ADD constraint PK_TuxProcsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxProcsTest_THRESH ON TuxProcsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServerTest CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVER_STATE Number(20,4) NOT NULL,
SERVER_STATE_ST varchar2(32) NOT NULL,
TOTWRKLC_RATE NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_ST varchar2(32) NOT NULL,
TOTAL_CONV Number(20,4) NOT NULL,
TOTAL_CONV_ST varchar2(32) NOT NULL,
CURR_ACTIVE_CONV Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_ST varchar2(32) NOT NULL,
TOTAL_REQ Number(20,4) NOT NULL,
TOTAL_REQ_ST varchar2(32) NOT NULL,
CURR_ACTIVE_REQ Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_ST varchar2(32) NOT NULL,
TRAN_INIT_RATE NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar2(32) NOT NULL,
TRAN_ABT_RATE NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar2(32) NOT NULL,
TRAN_CMT_RATE NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar2(32) NOT NULL,
TOTREQC_RATE NUMBER(20,4) NOT NULL,
TOTREQC_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxServerTest ADD constraint PK_TuxServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxServerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVER_STATE_MIN Number(20,4) NOT NULL,
SERVER_STATE_MAX Number(20,4) NOT NULL,
SERVER_STATE_STCNT varchar2(32) NOT NULL,
TOTWRKLC_RATE_MIN NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_MAX NUMBER(20,4) NOT NULL,
TOTWRKLC_RATE_STCNT varchar2(32) NOT NULL,
TOTAL_CONV_MIN Number(20,4) NOT NULL,
TOTAL_CONV_MAX Number(20,4) NOT NULL,
TOTAL_CONV_STCNT varchar2(32) NOT NULL,
CURR_ACTIVE_CONV_MIN Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_MAX Number(20,4) NOT NULL,
CURR_ACTIVE_CONV_STCNT varchar2(32) NOT NULL,
TOTAL_REQ_MIN Number(20,4) NOT NULL,
TOTAL_REQ_MAX Number(20,4) NOT NULL,
TOTAL_REQ_STCNT varchar2(32) NOT NULL,
CURR_ACTIVE_REQ_MIN Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_MAX Number(20,4) NOT NULL,
CURR_ACTIVE_REQ_STCNT varchar2(32) NOT NULL,
TRAN_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_ABT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_CMT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar2(32) NOT NULL,
TOTREQC_RATE_MIN NUMBER(20,4) NOT NULL,
TOTREQC_RATE_MAX NUMBER(20,4) NOT NULL,
TOTREQC_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxServerTest_TREND ADD constraint PK_TuxServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxServerTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVER_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_STATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTWRKLC_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TOTWRKLC_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONV_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONV_MAX	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_CONV_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_CONV_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_REQ_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_REQ_MAX	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_REQ_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ACTIVE_REQ_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TOTREQC_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TOTREQC_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxServerTest_THRESH ADD constraint PK_TuxServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServerTest_THRESH ON TuxServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServiceTest CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVICE_STATE Number(20,4) NOT NULL,
SERVICE_STATE_ST varchar2(32) NOT NULL,
LD_IMPOSED Number(20,4) NOT NULL,
LD_IMPOSED_ST varchar2(32) NOT NULL,
REQ_COMPLTD_RATE NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_ST varchar2(32) NOT NULL,
REQ_CURR_QUD Number(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar2(32) NOT NULL);

ALTER TABLE TuxServiceTest ADD constraint PK_TuxServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxServiceTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVICE_STATE_MIN Number(20,4) NOT NULL,
SERVICE_STATE_MAX Number(20,4) NOT NULL,
SERVICE_STATE_STCNT varchar2(32) NOT NULL,
LD_IMPOSED_MIN Number(20,4) NOT NULL,
LD_IMPOSED_MAX Number(20,4) NOT NULL,
LD_IMPOSED_STCNT varchar2(32) NOT NULL,
REQ_COMPLTD_RATE_MIN NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_MAX NUMBER(20,4) NOT NULL,
REQ_COMPLTD_RATE_STCNT varchar2(32) NOT NULL,
REQ_CURR_QUD_MIN Number(20,4) NOT NULL,
REQ_CURR_QUD_MAX Number(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxServiceTest_TREND ADD constraint PK_TuxServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServiceTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxServiceTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVICE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SERVICE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
LD_IMPOSED_MIN	VARCHAR2(256)	 NOT NULL,
LD_IMPOSED_MAX	VARCHAR2(256)	 NOT NULL,
REQ_COMPLTD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_COMPLTD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxServiceTest_THRESH ADD constraint PK_TuxServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServiceTest_THRESH ON TuxServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxSiteTest CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SITE_STATE Number(20,4) NOT NULL,
SITE_STATE_ST varchar2(32) NOT NULL,
TRAN_ABT_RATE NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar2(32) NOT NULL,
TRAN_CMT_RATE NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar2(32) NOT NULL,
TLISTEN_STATE Number(20,4) NOT NULL,
TLISTEN_STATE_ST varchar2(32) NOT NULL,
CURR_CLTS Number(20,4) NOT NULL,
CURR_CLTS_ST varchar2(32) NOT NULL,
CUR_WS_CLTS Number(20,4) NOT NULL,
CUR_WS_CLTS_ST varchar2(32) NOT NULL,
CURR_CONV Number(20,4) NOT NULL,
CURR_CONV_ST varchar2(32) NOT NULL,
CURR_GT Number(20,4) NOT NULL,
CURR_GT_ST varchar2(32) NOT NULL,
CURR_LOAD_RATE NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_ST varchar2(32) NOT NULL,
WK_COMPLETED_RATE NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_ST varchar2(32) NOT NULL,
WK_INIT_RATE NUMBER(20,4) NOT NULL,
WK_INIT_RATE_ST varchar2(32) NOT NULL,
TRAN_INIT_RATE NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE TuxSiteTest ADD constraint PK_TuxSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxSiteTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SITE_STATE_MIN Number(20,4) NOT NULL,
SITE_STATE_MAX Number(20,4) NOT NULL,
SITE_STATE_STCNT varchar2(32) NOT NULL,
TRAN_ABT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_CMT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar2(32) NOT NULL,
TLISTEN_STATE_MIN Number(20,4) NOT NULL,
TLISTEN_STATE_MAX Number(20,4) NOT NULL,
TLISTEN_STATE_STCNT varchar2(32) NOT NULL,
CURR_CLTS_MIN Number(20,4) NOT NULL,
CURR_CLTS_MAX Number(20,4) NOT NULL,
CURR_CLTS_STCNT varchar2(32) NOT NULL,
CUR_WS_CLTS_MIN Number(20,4) NOT NULL,
CUR_WS_CLTS_MAX Number(20,4) NOT NULL,
CUR_WS_CLTS_STCNT varchar2(32) NOT NULL,
CURR_CONV_MIN Number(20,4) NOT NULL,
CURR_CONV_MAX Number(20,4) NOT NULL,
CURR_CONV_STCNT varchar2(32) NOT NULL,
CURR_GT_MIN Number(20,4) NOT NULL,
CURR_GT_MAX Number(20,4) NOT NULL,
CURR_GT_STCNT varchar2(32) NOT NULL,
CURR_LOAD_RATE_MIN NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_MAX NUMBER(20,4) NOT NULL,
CURR_LOAD_RATE_STCNT varchar2(32) NOT NULL,
WK_COMPLETED_RATE_MIN NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_MAX NUMBER(20,4) NOT NULL,
WK_COMPLETED_RATE_STCNT varchar2(32) NOT NULL,
WK_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
WK_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
WK_INIT_RATE_STCNT varchar2(32) NOT NULL,
TRAN_INIT_RATE_MIN NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_MAX NUMBER(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxSiteTest_TREND ADD constraint PK_TuxSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxSiteTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxSiteTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SITE_STATE_MIN	VARCHAR2(256)	 NOT NULL,
SITE_STATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TLISTEN_STATE_MIN	VARCHAR2(256)	 NOT NULL,
TLISTEN_STATE_MAX	VARCHAR2(256)	 NOT NULL,
CURR_CLTS_MIN	VARCHAR2(256)	 NOT NULL,
CURR_CLTS_MAX	VARCHAR2(256)	 NOT NULL,
CUR_WS_CLTS_MIN	VARCHAR2(256)	 NOT NULL,
CUR_WS_CLTS_MAX	VARCHAR2(256)	 NOT NULL,
CURR_CONV_MIN	VARCHAR2(256)	 NOT NULL,
CURR_CONV_MAX	VARCHAR2(256)	 NOT NULL,
CURR_GT_MIN	VARCHAR2(256)	 NOT NULL,
CURR_GT_MAX	VARCHAR2(256)	 NOT NULL,
CURR_LOAD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
CURR_LOAD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
WK_COMPLETED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
WK_COMPLETED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
WK_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
WK_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxSiteTest_THRESH ADD constraint PK_TuxSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxSiteTest_THRESH ON TuxSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxTQueueTest CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Q_STATE Number(20,4) NOT NULL,
Q_STATE_ST varchar2(32) NOT NULL,
SERVER_CNT Number(20,4) NOT NULL,
SERVER_CNT_ST varchar2(32) NOT NULL,
REQ_CURR_QUD Number(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar2(32) NOT NULL,
WKL_CURR_QUD Number(20,4) NOT NULL,
WKL_CURR_QUD_ST varchar2(32) NOT NULL);

ALTER TABLE TuxTQueueTest ADD constraint PK_TuxTQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TuxTQueueTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest_TREND ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Q_STATE_MIN Number(20,4) NOT NULL,
Q_STATE_MAX Number(20,4) NOT NULL,
Q_STATE_STCNT varchar2(32) NOT NULL,
SERVER_CNT_MIN Number(20,4) NOT NULL,
SERVER_CNT_MAX Number(20,4) NOT NULL,
SERVER_CNT_STCNT varchar2(32) NOT NULL,
REQ_CURR_QUD_MIN Number(20,4) NOT NULL,
REQ_CURR_QUD_MAX Number(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar2(32) NOT NULL,
WKL_CURR_QUD_MIN Number(20,4) NOT NULL,
WKL_CURR_QUD_MAX Number(20,4) NOT NULL,
WKL_CURR_QUD_STCNT varchar2(32) NOT NULL);

ALTER TABLE TuxTQueueTest_TREND ADD constraint PK_TuxTQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxTQueueTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TuxTQueueTest_THRESH ( 	
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Q_STATE_MIN	VARCHAR2(256)	 NOT NULL,
Q_STATE_MAX	VARCHAR2(256)	 NOT NULL,
SERVER_CNT_MIN	VARCHAR2(256)	 NOT NULL,
SERVER_CNT_MAX	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL,
WKL_CURR_QUD_MIN	VARCHAR2(256)	 NOT NULL,
WKL_CURR_QUD_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TuxTQueueTest_THRESH ADD constraint PK_TuxTQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxTQueueTest_THRESH ON TuxTQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MQManagerTest CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest (
TRGT_HOST varchar2(32),
PORT_NO varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

ALTER TABLE MQManagerTest ADD constraint PK_MQManagerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE MQManagerTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest_TREND (
TRGT_HOST varchar2(32),
PORT_NO  varchar2(32),
SITE_NAME varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQManagerTest_TREND ADD constraint PK_MQManagerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MQManagerTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQManagerTest_THRESH (
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),  
SITE_NAME       varchar2(64), 
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQManagerTest_THRESH ADD constraint PK_MQManagerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQManagerTest_THRESH ON MQManagerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MQLocalQueueTest CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest ( 
TRGT_HOST       varchar2(32), 
PORT_NO         varchar2(32), 
SITE_NAME       varchar2(64),  
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
CURRENT_QUEUE_DEPTH Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_ST varchar2(32) NOT NULL,
QUEUE_FILL_PCT Number(20,4) NOT NULL,
QUEUE_FILL_PCT_ST varchar2(32) NOT NULL);

ALTER TABLE MQLocalQueueTest ADD constraint PK_MQLocalQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MQLocalQueueTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest_TREND ( 
TRGT_HOST       varchar2(32),     
PORT_NO         varchar2(32),       
SITE_NAME       varchar2(64),  
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURRENT_QUEUE_DEPTH_MIN Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_MAX Number(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_STCNT varchar2(32) NOT NULL,
QUEUE_FILL_PCT_MIN Number(20,4) NOT NULL,
QUEUE_FILL_PCT_MAX Number(20,4) NOT NULL,
QUEUE_FILL_PCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQLocalQueueTest_TREND ADD constraint PK_MQLocalQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQLocalQueueTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQLocalQueueTest_THRESH ( 
TRGT_HOST       varchar2(32),   
PORT_NO         varchar2(32), 
SITE_NAME       varchar2(64), 
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,	
MSMT_TIME_END   date,
CURRENT_QUEUE_DEPTH_MIN	VARCHAR2(256)	 NOT NULL,
CURRENT_QUEUE_DEPTH_MAX	VARCHAR2(256)	 NOT NULL,
QUEUE_FILL_PCT_MIN	VARCHAR2(256)	 NOT NULL,
QUEUE_FILL_PCT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQLocalQueueTest_THRESH ADD constraint PK_MQLocalQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQLocalQueueTest_THRESH ON MQLocalQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQChannelTest CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest ( 
TRGT_HOST       varchar2(32), 
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),       
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
KBYTES_RECD_RATE Number(20,4) NOT NULL,
KBYTES_RECD_RATE_ST varchar2(32) NOT NULL,
KBYTES_SENT_RATE Number(20,4) NOT NULL,
KBYTES_SENT_RATE_ST varchar2(32) NOT NULL,
BUFFERS_RECD_RATE Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_ST varchar2(32) NOT NULL,
BUFFERS_SENT_RATE Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_ST varchar2(32) NOT NULL,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

ALTER TABLE MQChannelTest ADD constraint PK_MQChannelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MQChannelTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
KBYTES_RECD_RATE_MIN Number(20,4) NOT NULL,
KBYTES_RECD_RATE_MAX Number(20,4) NOT NULL,
KBYTES_RECD_RATE_STCNT varchar2(32) NOT NULL,
KBYTES_SENT_RATE_MIN Number(20,4) NOT NULL,
KBYTES_SENT_RATE_MAX Number(20,4) NOT NULL,
KBYTES_SENT_RATE_STCNT varchar2(32) NOT NULL,
BUFFERS_RECD_RATE_MIN Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_MAX Number(20,4) NOT NULL,
BUFFERS_RECD_RATE_STCNT varchar2(32) NOT NULL,
BUFFERS_SENT_RATE_MIN Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_MAX Number(20,4) NOT NULL,
BUFFERS_SENT_RATE_STCNT varchar2(32) NOT NULL,
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE MQChannelTest_TREND ADD constraint PK_MQChannelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQChannelTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE MQChannelTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
KBYTES_RECD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
KBYTES_RECD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
KBYTES_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
KBYTES_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BUFFERS_RECD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BUFFERS_RECD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
BUFFERS_SENT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
BUFFERS_SENT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MQChannelTest_THRESH ADD constraint PK_MQChannelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQChannelTest_THRESH ON MQChannelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpPerfTest CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest ( 
TRGT_HOST       		varchar2(32), 
PORT_NO         		varchar2(32),     
SITE_NAME       		varchar2(64),       
INFO            		varchar2(128),	
MSMT_HOST       		varchar2(32),	
MSMT_TIME       		date,
AVG_PKTS_RATE			Number(20,4) NOT NULL,
AVG_PKTS_RATE_ST		varchar2(32) NOT NULL,
CURR_MSG_QUEUE_LEN 		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_ST 	Varchar2(32) NOT NULL,
REQ_RATE 				Number(20,4) NOT NULL,
REQ_RATE_ST				varchar2(32) NOT NULL,
REQ_ACKS_RATE			Number(20,4) NOT NULL,
REQ_ACKS_RATE_ST 		varchar2(32) NOT NULL,
REQ_NACKS_RATE 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_ST 		varchar2(32) NOT NULL,
REQ_DECLINES_RATE 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_ST	varchar2(32) NOT NULL,
PKTS_EXPD_RATE 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_ST 		varchar2(32) NOT NULL,
PKTS_DROPPED_RATE 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_ST 	varchar2(32) NOT NULL,
REQ_RELEASE_RATE 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_ST 	varchar2(32) NOT NULL);

ALTER TABLE DhcpPerfTest ADD constraint PK_DhcpPerfTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DhcpPerfTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVG_PKTS_RATE_MIN			Number(20,4) NOT NULL,
AVG_PKTS_RATE_MAX			Number(20,4) NOT NULL,
AVG_PKTS_RATE_STCNT			varchar2(32) NOT NULL,
CURR_MSG_QUEUE_LEN_MIN		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_MAX		Number(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_STCNT 	Varchar2(32) NOT NULL,
REQ_RATE_MIN 				Number(20,4) NOT NULL,
REQ_RATE_MAX 				Number(20,4) NOT NULL,
REQ_RATE_STCNT				varchar2(32) NOT NULL,
REQ_ACKS_RATE_MIN			Number(20,4) NOT NULL,
REQ_ACKS_RATE_MAX			Number(20,4) NOT NULL,
REQ_ACKS_RATE_STCNT 		varchar2(32) NOT NULL,
REQ_NACKS_RATE_MIN 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_MAX 			Number(20,4) NOT NULL,
REQ_NACKS_RATE_STCNT 		varchar2(32) NOT NULL,
REQ_DECLINES_RATE_MIN 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_MAX 		Number(20,4) NOT NULL,
REQ_DECLINES_RATE_STCNT		varchar2(32) NOT NULL,
PKTS_EXPD_RATE_MIN 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_MAX 			Number(20,4) NOT NULL,
PKTS_EXPD_RATE_STCNT 		varchar2(32) NOT NULL,
PKTS_DROPPED_RATE_MIN 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_MAX 		Number(20,4) NOT NULL,
PKTS_DROPPED_RATE_STCNT 	varchar2(32) NOT NULL,
REQ_RELEASE_RATE_MIN 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_MAX 		Number(20,4) NOT NULL,
REQ_RELEASE_RATE_STCNT	 	varchar2(32) NOT NULL);

ALTER TABLE DhcpPerfTest_TREND ADD constraint PK_DhcpPerfTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpPerfTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DhcpPerfTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVG_PKTS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
AVG_PKTS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MIN	VARCHAR2(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MAX	VARCHAR2(256)	 NOT NULL,
REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_ACKS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_ACKS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_NACKS_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_NACKS_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_DECLINES_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_DECLINES_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PKTS_EXPD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
PKTS_EXPD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
PKTS_DROPPED_RATE_MIN	VARCHAR2(256)	 NOT NULL,
PKTS_DROPPED_RATE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_RELEASE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_RELEASE_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE DhcpPerfTest_THRESH ADD constraint PK_DhcpPerfTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpPerfTest_THRESH ON DhcpPerfTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpUtilTest CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest ( 
TRGT_HOST       		varchar2(32), 
PORT_NO         		varchar2(32),     
SITE_NAME       		varchar2(64),       
INFO            		varchar2(128),	
MSMT_HOST       		varchar2(32),	
MSMT_TIME       		date,
CURR_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
FREE_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT		Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_ST	VARCHAR2(32) NOT NULL,
USAGE				Number(20,4) NOT NULL,
USAGE_ST		VARCHAR2(32) NOT NULL);


ALTER TABLE DhcpUtilTest ADD constraint PK_DhcpUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE DhcpUtilTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest_TREND ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),   
SITE_NAME       varchar2(64), 
INFO            varchar2(128),
MSMT_HOST       varchar2(32),	
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURR_ADDR_USAGE_CNT_MIN		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_MAX		Number(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
FREE_ADDR_USAGE_CNT_MIN		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_MAX		Number(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN	Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX	Number(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_STCNT	VARCHAR2(32) NOT NULL,
USAGE_MIN			Number(20,4) NOT NULL,
USAGE_MAX			Number(20,4) NOT NULL,
USAGE_STCNT			VARCHAR2(32) NOT NULL);

ALTER TABLE DhcpUtilTest_TREND ADD constraint PK_DhcpUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpUtilTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE DhcpUtilTest_THRESH ( 
TRGT_HOST       varchar2(32),    
PORT_NO         varchar2(32),     
SITE_NAME       varchar2(64),      
INFO            varchar2(128),	
MSMT_HOST       varchar2(32),	
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURR_ADDR_USAGE_CNT_MIN	VARCHAR2(256)	 NOT NULL,
CURR_ADDR_USAGE_CNT_MAX	VARCHAR2(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MIN	VARCHAR2(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN VARCHAR2(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX VARCHAR2(256)	 NOT NULL,
USAGE_MIN		VARCHAR2(256)	 NOT NULL,
USAGE_MAX		VARCHAR2(256)	 NOT NULL);

ALTER TABLE DhcpUtilTest_THRESH ADD constraint PK_DhcpUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpUtilTest_THRESH ON DhcpUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLThreadTest CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest 
(
	TRGT_HOST       		varchar2(32), 
	PORT_NO         		varchar2(32), 
	SITE_NAME       		varchar2(64),  
	INFO            		varchar2(128),  
	MSMT_HOST       		varchar2(32), 
	MSMT_TIME       		date,
	IDLE_THREADS    		Number(20,4) NOT NULL,
	IDLE_THREADS_ST 		varchar2(32) NOT NULL,
	PCT_THREAD_UTILIZATION  	Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_ST 	varchar2(32) NOT NULL,
	PENDING_REQUESTS 		Number(20,4) NOT NULL,
	PENDING_REQUESTS_ST 		varchar2(32) NOT NULL,
	REQUEST_RATE			Number(20,4) NOT NULL,
	REQUEST_RATE_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLThreadTest ADD constraint PK_WLThreadTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WLThreadTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest_TREND 
(
	TRGT_HOST      					varchar2(32), 
	PORT_NO    		       			varchar2(32),
	SITE_NAME    					varchar2(64),
	INFO							varchar2(128), 
	MSMT_HOST   					varchar2(32), 
	MSMT_TIME    					date,
	PERIOD      		   			varchar2(32),
	IDLE_THREADS_MIN 				Number(20,4) NOT NULL,
	IDLE_THREADS_MAX 				Number(20,4) NOT NULL,
	IDLE_THREADS_STCNT 				varchar2(32) NOT NULL,
	PCT_THREAD_UTILIZATION_MIN 		Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_MAX 		Number(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_STCNT    varchar2(32) NOT NULL,
	PENDING_REQUESTS_MIN 			Number(20,4) NOT NULL,
	PENDING_REQUESTS_MAX 			Number(20,4) NOT NULL,
	PENDING_REQUESTS_STCNT 			varchar2(32) NOT NULL,
	REQUEST_RATE_MIN 				Number(20,4) NOT NULL,
	REQUEST_RATE_MAX 				Number(20,4) NOT NULL,
	REQUEST_RATE_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLThreadTest_TREND ADD constraint PK_WLThreadTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WLThreadTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLThreadTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO			        		varchar2(32),
	SITE_NAME    					varchar2(64),
	INFO			        		varchar2(128),      
	MSMT_HOST		        		varchar2(32),   
	MSMT_TIME_START 				date,
	MSMT_TIME_END  					date,
	IDLE_THREADS_MIN	VARCHAR2(256)	 NOT NULL,
	IDLE_THREADS_MAX	VARCHAR2(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MIN	VARCHAR2(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MAX	VARCHAR2(256)	 NOT NULL,
	PENDING_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
	PENDING_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
	REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLThreadTest_THRESH ADD constraint PK_WLThreadTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WLThreadTest_THRESH ON WLThreadTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLClusterTest CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	ALIVE_SERVERS_COUNT 		Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_ST 		varchar2(32) NOT NULL,
	FRAGMENTS_SENT_RT 			Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_ST 		varchar2(32) NOT NULL,
	FRAGMENTS_RECEIVED_RT 		Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_ST 	varchar2(32) NOT NULL,
	FRAGMENTS_DROPPED_RT 		Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_ST 	varchar2(32) NOT NULL,
	MSGS_LOST_RT 				Number(20,4) NOT NULL,
	MSGS_LOST_RT_ST 			varchar2(32) NOT NULL,
	RESEND_REQUESTS_RT 			Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_ST 		varchar2(32) NOT NULL,
	PRIMARY_COUNT 				Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_ST 			varchar2(32) NOT NULL
);

ALTER TABLE WLClusterTest ADD constraint PK_WLClusterTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLClusterTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest_TREND
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	PERIOD       				varchar2(32),
	ALIVE_SERVERS_COUNT_MIN 	Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_MAX 	Number(20,4)	 NOT NULL,
	ALIVE_SERVERS_COUNT_STCNT 	varchar2(32) NOT NULL,
	FRAGMENTS_SENT_RT_MIN 		Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_MAX 		Number(20,4) NOT NULL,
	FRAGMENTS_SENT_RT_STCNT 	varchar2(32) NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN 	Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX 	Number(20,4) NOT NULL,
	FRAGMENTS_RECEIVED_RT_STCNT varchar2(32) NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN 	Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX 	Number(20,4) NOT NULL,
	FRAGMENTS_DROPPED_RT_STCNT 	varchar2(32) NOT NULL,
	MSGS_LOST_RT_MIN 			Number(20,4) NOT NULL,
	MSGS_LOST_RT_MAX 			Number(20,4) NOT NULL,
	MSGS_LOST_RT_STCNT 			varchar2(32) NOT NULL,
	RESEND_REQUESTS_RT_MIN 		Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_MAX 		Number(20,4) NOT NULL,
	RESEND_REQUESTS_RT_STCNT 	varchar2(32) NOT NULL,
	PRIMARY_COUNT_MIN 			Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_MAX 			Number(20,4)	 NOT NULL,
	PRIMARY_COUNT_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE WLClusterTest_TREND ADD constraint PK_WLClusterTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLClusterTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLClusterTest_THRESH(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	ALIVE_SERVERS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
	ALIVE_SERVERS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	MSGS_LOST_RT_MIN	VARCHAR2(256)	 NOT NULL,
	MSGS_LOST_RT_MAX	VARCHAR2(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MIN	VARCHAR2(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MAX	VARCHAR2(256)	 NOT NULL,
	PRIMARY_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
	PRIMARY_COUNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLClusterTest_THRESH ADD constraint PK_WLClusterTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLClusterTest_THRESH ON WLClusterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLConnectorTest CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	TOTAL_CONNS_CREATED_RT 			Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_ST 	varchar2(32) NOT NULL,
	TOTAL_CONNS_MATCHED_RT 			Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_REJECTED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT 		Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_ST 		varchar2(32) NOT NULL,
	CURRENT_ACTIVE_CONNS 			Number(20,4)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_ST 		varchar2(32) NOT NULL,
	ACTIVE_CONNS_HWM 				Number(20,4)	 NOT NULL,
	ACTIVE_CONNS_HWM_ST 			varchar2(32) NOT NULL,
	CURRENT_FREE_CONNS 				Number(20,4)	 NOT NULL,
	CURRENT_FREE_CONNS_ST 			varchar2(32) NOT NULL,
	FREE_CONNS_HWM 					Number(20,4)	 NOT NULL,
	FREE_CONNS_HWM_ST 				varchar2(32) NOT NULL,
	MAX_CAPACITY 					Number(20,4)	 NOT NULL,
	MAX_CAPACITY_ST 				varchar2(32) NOT NULL
);

ALTER TABLE WLConnectorTest ADD constraint PK_WLConnectorTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLConnectorTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO           					varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	TOTAL_CONNS_CREATED_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN 	Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX 	Number(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_STCNT 	varchar2(32) NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN 		Number(20,4) NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX 		Number(20,4) NOT NULL,
	CURRENT_ACTIVE_CONNS_STCNT 		varchar2(32) NOT NULL,
	ACTIVE_CONNS_HWM_MIN 			Number(20,4) NOT NULL,
	ACTIVE_CONNS_HWM_MAX 			Number(20,4) NOT NULL,
	ACTIVE_CONNS_HWM_STCNT 			varchar2(32) NOT NULL,
	CURRENT_FREE_CONNS_MIN 			Number(20,4) NOT NULL,
	CURRENT_FREE_CONNS_MAX 			Number(20,4) NOT NULL,
	CURRENT_FREE_CONNS_STCNT 		varchar2(32) NOT NULL,
	FREE_CONNS_HWM_MIN 				Number(20,4) NOT NULL,
	FREE_CONNS_HWM_MAX 				Number(20,4) NOT NULL,
	FREE_CONNS_HWM_STCNT 			varchar2(32) NOT NULL,
	MAX_CAPACITY_MIN 				Number(20,4) NOT NULL,
	MAX_CAPACITY_MAX 				Number(20,4) NOT NULL,
	MAX_CAPACITY_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLConnectorTest_TREND ADD constraint PK_WLConnectorTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLConnectorTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLConnectorTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME      					varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	TOTAL_CONNS_CREATED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN	VARCHAR2(256)		 NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX	VARCHAR2(256)		 NOT NULL,
	ACTIVE_CONNS_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	ACTIVE_CONNS_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	CURRENT_FREE_CONNS_MIN	VARCHAR2(256)		 NOT NULL,
	CURRENT_FREE_CONNS_MAX	VARCHAR2(256)		 NOT NULL,
	FREE_CONNS_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	FREE_CONNS_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	MAX_CAPACITY_MIN	VARCHAR2(256)		 NOT NULL,
	MAX_CAPACITY_MAX	VARCHAR2(256)	 	 NOT NULL
);

ALTER TABLE WLConnectorTest_THRESH ADD constraint PK_WLConnectorTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLConnectorTest_THRESH ON WLConnectorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLJMSTest CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	BYTES_RECEIVED_RT 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_ST 		varchar2(32) NOT NULL,
	MSGS_RECEIVED_RT 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_ST 		varchar2(32) NOT NULL,
	BYTES_CURRENT_COUNT 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	BYTES_PENDING_COUNT 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_ST 		varchar2(32) NOT NULL,
	BYTES_COUNT_HWM 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	MSGS_CURRENT_COUNT 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	MSGS_PENDING_COUNT 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_ST 		varchar2(32) NOT NULL,
	MSGS_COUNT_HWM 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	DEST_CURRENT_COUNT 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_ST 		varchar2(32) NOT NULL,
	DEST_COUNT_HWM 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_ST 			varchar2(32) NOT NULL,
	SESS_POOL_CURRENT_COUNT 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_ST 	varchar2(32) NOT NULL,
	SESSION_POOL_HWM 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLJMSTest ADD constraint PK_WLJMSTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLJMSTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME      					date,
	PERIOD       					varchar2(32),
	BYTES_RECEIVED_RT_MIN 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_MAX 			Number(20,4) NOT NULL,
	BYTES_RECEIVED_RT_STCNT 		varchar2(32) NOT NULL,
	MSGS_RECEIVED_RT_MIN 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_MAX 			Number(20,4) NOT NULL,
	MSGS_RECEIVED_RT_STCNT 			varchar2(32) NOT NULL,
	BYTES_CURRENT_COUNT_MIN 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_MAX 		Number(20,4)	 NOT NULL,
	BYTES_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	BYTES_PENDING_COUNT_MIN 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_MAX 		Number(20,4)	 NOT NULL,
	BYTES_PENDING_COUNT_STCNT 		varchar2(32) NOT NULL,
	BYTES_COUNT_HWM_MIN 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_MAX 			Number(20,4)	 NOT NULL,
	BYTES_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	MSGS_CURRENT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	MSGS_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	MSGS_PENDING_COUNT_MIN 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_MAX 			Number(20,4)	 NOT NULL,
	MSGS_PENDING_COUNT_STCNT 		varchar2(32) NOT NULL,
	MSGS_COUNT_HWM_MIN 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_MAX 				Number(20,4)	 NOT NULL,
	MSGS_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	DEST_CURRENT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	DEST_CURRENT_COUNT_STCNT 		varchar2(32) NOT NULL,
	DEST_COUNT_HWM_MIN 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_MAX 				Number(20,4)	 NOT NULL,
	DEST_COUNT_HWM_STCNT 			varchar2(32) NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX 	Number(20,4)	 NOT NULL,
	SESS_POOL_CURRENT_COUNT_STCNT 	varchar2(32) NOT NULL,
	SESSION_POOL_HWM_MIN 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_MAX 			Number(20,4)	 NOT NULL,
	SESSION_POOL_HWM_STCNT 			varchar2(32) NOT NULL
);

ALTER TABLE WLJMSTest_TREND ADD constraint PK_WLJMSTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLJMSTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLJMSTest_THRESH
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME      				varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	BYTES_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	BYTES_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MIN	VARCHAR2(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MAX	VARCHAR2(256)	 NOT NULL,
	BYTES_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	BYTES_PENDING_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_PENDING_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	BYTES_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	BYTES_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_PENDING_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_PENDING_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	MSGS_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	MSGS_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	DEST_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	DEST_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	DEST_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	DEST_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	SESSION_POOL_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	SESSION_POOL_HWM_MAX	VARCHAR2(256)		 NOT NULL
);

ALTER TABLE WLJMSTest_THRESH ADD constraint PK_WLJMSTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJMSTest_THRESH ON WLJMSTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLJTATest CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	TOTAL_ACTIVE_TX 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_ST 			varchar2(32) NOT NULL,
	ABANDONED_TX_RT 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_ST 			varchar2(32) NOT NULL,
	APP_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_ST varchar2(32) NOT NULL,
	SYS_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_ST varchar2(32) NOT NULL,
	COMMITTED_TX_RT 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_ST 			varchar2(32) NOT NULL,
	HEURISTICS_TX_RT 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_ST 		varchar2(32) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_ST 	varchar2(32) NOT NULL,
	TOTAL_TX_RT 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_ST 				varchar2(32) NOT NULL
);

ALTER TABLE WLJTATest ADD constraint PK_WLJTATest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLJTATest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	TOTAL_ACTIVE_TX_MIN 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_MAX 			Number(20,4)	 NOT NULL,
	TOTAL_ACTIVE_TX_STCNT 			varchar2(32) NOT NULL,
	ABANDONED_TX_RT_MIN 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_MAX 			Number(20,4) NOT NULL,
	ABANDONED_TX_RT_STCNT 			varchar2(32) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_STCNT 		varchar2(32) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX 	Number(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_STCNT 		varchar2(32) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX 	Number(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	COMMITTED_TX_RT_MIN 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_MAX 			Number(20,4) NOT NULL,
	COMMITTED_TX_RT_STCNT 			varchar2(32) NOT NULL,
	HEURISTICS_TX_RT_MIN 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_MAX 			Number(20,4) NOT NULL,
	HEURISTICS_TX_RT_STCNT 			varchar2(32) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX 		Number(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_STCNT 	varchar2(32) NOT NULL,
	TOTAL_TX_RT_MIN 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_MAX 				Number(20,4) NOT NULL,
	TOTAL_TX_RT_STCNT 				varchar2(32) NOT NULL
);

ALTER TABLE WLJTATest_TREND ADD constraint PK_WLJTATest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLJTATest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLJTATest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	TOTAL_ACTIVE_TX_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_ACTIVE_TX_MAX	VARCHAR2(256)	 NOT NULL,
	ABANDONED_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	ABANDONED_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	COMMITTED_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	COMMITTED_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	HEURISTICS_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	HEURISTICS_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_TX_RT_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_TX_RT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WLJTATest_THRESH ADD constraint PK_WLJTATest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,			
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJTATest_THRESH ON WLJTATest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLSecurityTest CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest
(
	TRGT_HOST       			varchar2(32),
	PORT_NO         			varchar2(32),
	SITE_NAME       			varchar2(64),
	INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	INVALID_LOGIN_ATTEMPT_RT 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_ST varchar2(32) NOT NULL,
	INVALID_USERS_COUNT_HWM 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_ST 	varchar2(32) NOT NULL,
	CURR_LOCKED_USERS_COUNT 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_ST 	varchar2(32) NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_ST varchar2(32) NOT NULL,
	TOTAL_UNLOCKED_USERS 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_ST 	varchar2(32) NOT NULL,
	USER_LOCKOUT_COUNT 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_ST 		varchar2(32) NOT NULL
);

ALTER TABLE WLSecurityTest ADD constraint PK_WLSecurityTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);

DROP TABLE WLSecurityTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest_TREND
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	INVALID_LOGIN_ATTEMPT_RT_MIN 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX 	Number(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_STCNT 	varchar2(32) NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX 	Number(20,4)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_STCNT 	varchar2(32) NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX 	Number(20,4)	 NOT NULL,
	CURR_LOCKED_USERS_COUNT_STCNT 	varchar2(32) NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX 	Number(20,4)	 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_STCNT 	varchar2(32) NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX 		Number(20,4)	 NOT NULL,
	TOTAL_UNLOCKED_USERS_STCNT 		varchar2(32) NOT NULL,
	USER_LOCKOUT_COUNT_MIN 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_MAX 			Number(20,4)	 NOT NULL,
	USER_LOCKOUT_COUNT_STCNT 		varchar2(32) NOT NULL
);

ALTER TABLE WLSecurityTest_TREND ADD constraint PK_WLSecurityTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,
			PERIOD);

DROP TABLE WLSecurityTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WLSecurityTest_THRESH
(
	TRGT_HOST       				varchar2(32),
	PORT_NO         				varchar2(32),
	SITE_NAME       				varchar2(64),
	INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),
	MSMT_TIME_START 				date,
	MSMT_TIME_END   				date,
	INVALID_LOGIN_ATTEMPT_RT_MIN	VARCHAR2(256)	 NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX	VARCHAR2(256)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN	VARCHAR2(256)		 NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX	VARCHAR2(256)		 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX	VARCHAR2(256)		 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN	VARCHAR2(256)		 NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX	VARCHAR2(256)		 NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN	VARCHAR2(256)		 NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX	VARCHAR2(256)		 NOT NULL,
	USER_LOCKOUT_COUNT_MIN	VARCHAR2(256)		 NOT NULL,
	USER_LOCKOUT_COUNT_MAX	VARCHAR2(256)		 NOT NULL
);

ALTER TABLE WLSecurityTest_THRESH ADD constraint PK_WLSecurityTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLSecurityTest_THRESH ON WLSecurityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpPortTest CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest
( 
	TRGT_HOST      			 varchar2(32),
    PORT_NO        			 varchar2(32),
    SITE_NAME      			 varchar2(64),
    INFO           			 varchar2(128),
	MSMT_HOST      			 varchar2(32),
	MSMT_TIME      			 date,
	SYN_SENT 				 Number(20,4) NOT NULL,
	SYN_SENT_ST 			 varchar2(32) NOT NULL,
	SYN_RECEIVED 			 Number(20,4) NOT NULL,
	SYN_RECEIVED_ST 		 varchar2(32) NOT NULL,
	ESTABLISHED 			 Number(20,4) NOT NULL,
	ESTABLISHED_ST 			 varchar2(32) NOT NULL,
	CLOSE_WAIT 				 Number(20,4) NOT NULL,
	CLOSE_WAIT_ST 			 varchar2(32) NOT NULL,
	FIN_WAIT_1 				 Number(20,4) NOT NULL,
	FIN_WAIT_1_ST 			 varchar2(32) NOT NULL,
	FIN_WAIT_2 				 Number(20,4) NOT NULL,
	FIN_WAIT_2_ST		     varchar2(32) NOT NULL,
	TIME_WAIT 				 Number(20,4) NOT NULL,
	TIME_WAIT_ST 			 varchar2(32) NOT NULL,
	SEND_QUEUE 				 Number(20,4) NOT NULL,
	SEND_QUEUE_ST			 varchar2(32) NOT NULL,
	RECEIVE_QUEUE			 Number(20,4) NOT NULL,
	RECEIVE_QUEUE_ST		 varchar2(32) NOT NULL
);

ALTER TABLE TcpPortTest ADD constraint PK_TcpPortTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE TcpPortTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest_TREND
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64), 
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	SYN_SENT_MIN Number(20,4) NOT NULL,
	SYN_SENT_MAX Number(20,4) NOT NULL,
	SYN_SENT_STCNT varchar2(32) NOT NULL,
	SYN_RECEIVED_MIN Number(20,4) NOT NULL,
	SYN_RECEIVED_MAX Number(20,4) NOT NULL,
	SYN_RECEIVED_STCNT varchar2(32) NOT NULL,
	ESTABLISHED_MIN Number(20,4) NOT NULL,
	ESTABLISHED_MAX Number(20,4) NOT NULL,
	ESTABLISHED_STCNT varchar2(32) NOT NULL,
	CLOSE_WAIT_MIN Number(20,4) NOT NULL,
	CLOSE_WAIT_MAX Number(20,4) NOT NULL,
	CLOSE_WAIT_STCNT varchar2(32) NOT NULL,
	FIN_WAIT_1_MIN Number(20,4) NOT NULL,
	FIN_WAIT_1_MAX Number(20,4) NOT NULL,
	FIN_WAIT_1_STCNT varchar2(32) NOT NULL,
	FIN_WAIT_2_MIN Number(20,4) NOT NULL,
	FIN_WAIT_2_MAX Number(20,4) NOT NULL,
	FIN_WAIT_2_STCNT varchar2(32) NOT NULL,
	TIME_WAIT_MIN Number(20,4) NOT NULL,
	TIME_WAIT_MAX Number(20,4) NOT NULL,
	TIME_WAIT_STCNT varchar2(32) NOT NULL,
	SEND_QUEUE_MIN Number(20,4) NOT NULL,
	SEND_QUEUE_MAX Number(20,4) NOT NULL,
	SEND_QUEUE_STCNT varchar2(32) NOT NULL,
	RECEIVE_QUEUE_MIN Number(20,4) NOT NULL,
	RECEIVE_QUEUE_MAX Number(20,4) NOT NULL,
	RECEIVE_QUEUE_STCNT varchar2(32) NOT NULL
);

ALTER TABLE TcpPortTest_TREND ADD constraint PK_TcpPortTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TcpPortTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE TcpPortTest_THRESH
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	SYN_SENT_MIN	VARCHAR2(256)	 NOT NULL,
	SYN_SENT_MAX	VARCHAR2(256)	 NOT NULL,
	SYN_RECEIVED_MIN	VARCHAR2(256)	 NOT NULL,
	SYN_RECEIVED_MAX	VARCHAR2(256)	 NOT NULL,
	ESTABLISHED_MIN	VARCHAR2(256)	 NOT NULL,
	ESTABLISHED_MAX	VARCHAR2(256)	 NOT NULL,
	CLOSE_WAIT_MIN	VARCHAR2(256)	 NOT NULL,
	CLOSE_WAIT_MAX	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_1_MIN	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_1_MAX	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_2_MIN	VARCHAR2(256)	 NOT NULL,
	FIN_WAIT_2_MAX	VARCHAR2(256)	 NOT NULL,
	TIME_WAIT_MIN	VARCHAR2(256)	 NOT NULL,
	TIME_WAIT_MAX	VARCHAR2(256)	 NOT NULL,
	SEND_QUEUE_MIN	VARCHAR2(256)	 NOT NULL,
	SEND_QUEUE_MAX	VARCHAR2(256)	 NOT NULL,
	RECEIVE_QUEUE_MIN	VARCHAR2(256)	 NOT NULL,
	RECEIVE_QUEUE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE TcpPortTest_THRESH ADD constraint PK_TcpPortTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TcpPortTest_THRESH ON TcpPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE FileTest CASCADE CONSTRAINTS;

CREATE TABLE FileTest
( 	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	CDUMPCNT 				Number(20,4) NOT NULL,
	CDUMPCNT_ST 			varchar2(32) NOT NULL,
	RECENTCDUMPCNT 			Number(20,4) NOT NULL,
	RECENTCDUMPCNT_ST 		varchar2(32) NOT NULL
);

ALTER TABLE FileTest ADD constraint PK_FileTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FileTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE FileTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	CDUMPCNT_MIN 			Number(20,4) NOT NULL,
	CDUMPCNT_MAX 			Number(20,4) NOT NULL,
	CDUMPCNT_STCNT 			varchar2(32) NOT NULL,
	RECENTCDUMPCNT_MIN		Number(20,4) NOT NULL,
	RECENTCDUMPCNT_MAX 		Number(20,4) NOT NULL,
	RECENTCDUMPCNT_STCNT 	varchar2(32) NOT NULL
);


ALTER TABLE FileTest_TREND ADD constraint PK_FileTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE FileTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	CDUMPCNT_MIN	VARCHAR2(256)	 NOT NULL,
	CDUMPCNT_MAX	VARCHAR2(256)	 NOT NULL,
	RECENTCDUMPCNT_MIN	VARCHAR2(256)	 NOT NULL,
	RECENTCDUMPCNT_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE FileTest_THRESH ADD constraint PK_FileTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_FileTest_THRESH ON FileTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraArchiveTest CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	ARCHIVE_LOG_MODE 		Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_ST 	varchar2(32) NOT NULL
);

ALTER TABLE OraArchiveTest ADD constraint PK_OraArchiveTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraArchiveTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest_TREND
( 	
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),	
	MSMT_TIME       date,	
	PERIOD       	varchar2(32),
	ARCHIVE_LOG_MODE_MIN Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_MAX Number(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_STCNT varchar2(32) NOT NULL
);

ALTER TABLE OraArchiveTest_TREND ADD constraint PK_OraArchiveTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraArchiveTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraArchiveTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64), 
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	ARCHIVE_LOG_MODE_MIN	VARCHAR2(256)	 NOT NULL,
	ARCHIVE_LOG_MODE_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraArchiveTest_THRESH ADD constraint PK_OraArchiveTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraArchiveTest_THRESH ON OraArchiveTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraUserTsTest CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest
( 
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	SYSTEM_TS_USERS Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_ST varchar2(32) NOT NULL
);

ALTER TABLE OraUserTsTest ADD constraint PK_OraUserTsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraUserTsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST      			varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	SYSTEM_TS_USERS_MIN 	Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_MAX 	Number(20,4) NOT NULL,
	SYSTEM_TS_USERS_STCNT 	varchar2(32) NOT NULL
);

ALTER TABLE OraUserTsTest_TREND ADD constraint PK_OraUserTsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraUserTsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraUserTsTest_THRESH
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	SYSTEM_TS_USERS_MIN	VARCHAR2(256)	 NOT NULL,
	SYSTEM_TS_USERS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraUserTsTest_THRESH ADD constraint PK_OraUserTsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraUserTsTest_THRESH ON OraUserTsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraParamsTest CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest
( 	
	TRGT_HOST       varchar2(32),
    PORT_NO         varchar2(32),
    SITE_NAME       varchar2(64),
    INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	NON_ORACLE_PARAMS Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_ST varchar2(32) NOT NULL
);

ALTER TABLE OraParamsTest ADD constraint PK_OraParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraParamsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest_TREND
( 	
	TRGT_HOST       		varchar2(32),
    PORT_NO         		varchar2(32),
    SITE_NAME       		varchar2(64), 
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	PERIOD       			varchar2(32),
	NON_ORACLE_PARAMS_MIN 	Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_MAX 	Number(20,4) NOT NULL,
	NON_ORACLE_PARAMS_STCNT varchar2(32) NOT NULL
);

ALTER TABLE OraParamsTest_TREND ADD constraint PK_OraParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraParamsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraParamsTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
    PORT_NO        			varchar2(32),
    SITE_NAME       		varchar2(64),
    INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END   		date,
	NON_ORACLE_PARAMS_MIN	VARCHAR2(256)	 NOT NULL,
	NON_ORACLE_PARAMS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraParamsTest_THRESH ADD constraint PK_OraParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraParamsTest_THRESH ON OraParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraAlertTest CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest
( 
	TRGT_HOST       		varchar2(32),
	PORT_NO        			varchar2(32),      
	SITE_NAME       		varchar2(64), 
	INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME       		date,
	BDUMPERRORCNT 			Number(20,4) NOT NULL,
	BDUMPERRORCNT_ST 		varchar2(32) NOT NULL,
	FILE_SIZE 			Number(20,4) NOT NULL,
	FILE_SIZE_ST 			varchar2(32) NOT NULL,
	GROWTH_RATE 			Number(20,4) NOT NULL,
	GROWTH_RATE_ST 			varchar2(32) NOT NULL
);
ALTER TABLE OraAlertTest ADD constraint PK_OraAlertTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraAlertTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest_TREND 
( 	
	TRGT_HOST       		varchar2(32),
	 PORT_NO         		varchar2(32),
	 SITE_NAME       		varchar2(64),
	 INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME      	 		date,
	PERIOD       			varchar2(32),
	BDUMPERRORCNT_MIN 		Number(20,4) NOT NULL,
	BDUMPERRORCNT_MAX 		Number(20,4) NOT NULL,
	BDUMPERRORCNT_STCNT 		varchar2(32) NOT NULL,
	FILE_SIZE_MIN 			Number(20,4) NOT NULL,
	FILE_SIZE_MAX 			Number(20,4) NOT NULL,
	FILE_SIZE_STCNT 		varchar2(32) NOT NULL,
	GROWTH_RATE_MIN 		Number(20,4) NOT NULL,
	GROWTH_RATE_MAX 		Number(20,4) NOT NULL,
	GROWTH_RATE_STCNT 		varchar2(32) NOT NULL

);
ALTER TABLE OraAlertTest_TREND ADD constraint PK_OraAlertTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraAlertTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraAlertTest_THRESH
( 
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
	 SITE_NAME       		varchar2(64),
	 INFO            		varchar2(128),
	MSMT_HOST       		varchar2(32),
	MSMT_TIME_START 		date,
	MSMT_TIME_END  	 		date,
	BDUMPERRORCNT_MIN		VARCHAR2(256)	 NOT NULL,
	BDUMPERRORCNT_MAX		VARCHAR2(256)	 NOT NULL,
	FILE_SIZE_MIN			VARCHAR2(256)	 NOT NULL,
	FILE_SIZE_MAX			VARCHAR2(256)	 NOT NULL,
	GROWTH_RATE_MIN			 VARCHAR2(256)	 NOT NULL,
	GROWTH_RATE_MAX			VARCHAR2(256)	 NOT NULL
);
ALTER TABLE OraAlertTest_THRESH ADD constraint PK_OraAlertTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraAlertTest_THRESH ON OraAlertTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTsParamsTest CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest
( 	
	TRGT_HOST       			varchar2(32),
   	PORT_NO         			varchar2(32),
    SITE_NAME       			varchar2(64),  
    INFO            			varchar2(128),	
	MSMT_HOST       			varchar2(32),
	MSMT_TIME       			date,
	NON_LOCALLY_MANAGED_TS 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_ST 	varchar2(32) NOT NULL
);

ALTER TABLE OraTsParamsTest ADD constraint PK_OraTsParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraTsParamsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest_TREND
( 	
	TRGT_HOST      					varchar2(32),
    PORT_NO         				varchar2(32),
    SITE_NAME       				varchar2(64),
    INFO            				varchar2(128),
	MSMT_HOST       				varchar2(32),	
	MSMT_TIME       				date,
	PERIOD       					varchar2(32),
	NON_LOCALLY_MANAGED_TS_MIN 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX 		Number(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_STCNT 	varchar2(32) NOT NULL
);

ALTER TABLE OraTsParamsTest_TREND ADD constraint PK_OraTsParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraTsParamsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE OraTsParamsTest_THRESH
( 	
	TRGT_HOST       			varchar2(32),
    PORT_NO         			varchar2(32),
    SITE_NAME       			varchar2(64),
    INFO            			varchar2(128),
	MSMT_HOST       			varchar2(32),
	MSMT_TIME_START 			date,
	MSMT_TIME_END   			date,
	NON_LOCALLY_MANAGED_TS_MIN	VARCHAR2(256)	 NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE OraTsParamsTest_THRESH ADD constraint PK_OraTsParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraTsParamsTest_THRESH ON OraTsParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbCacheTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESIZE_QUANTITY Number(20,4) NOT NULL,
RESIZE_QUANTITY_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL,
IDLE_TIMEOUT Number(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar2(32) NOT NULL,
NUM_PASSIVS Number(20,4) NOT NULL,
NUM_PASSIVS_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
NUM_PASSIV_ERRORS Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_ST varchar2(32) NOT NULL,
BEANS_IN_CACHE Number(20,4) NOT NULL,
BEANS_IN_CACHE_ST varchar2(32) NOT NULL,
EXPIRED_SESS_REMOVED Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_ST varchar2(32) NOT NULL,
MAX_BEANS_IN_CACHE Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_ST varchar2(32) NOT NULL,
NUM_PASSIV_SUCCESS Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest ADD constraint PK_Sun1EjbCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1EjbCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESIZE_QUANTITY_MIN Number(20,4) NOT NULL,
RESIZE_QUANTITY_MAX Number(20,4) NOT NULL,
RESIZE_QUANTITY_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL,
IDLE_TIMEOUT_MIN Number(20,4) NOT NULL,
IDLE_TIMEOUT_MAX Number(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar2(32) NOT NULL,
NUM_PASSIVS_MIN Number(20,4) NOT NULL,
NUM_PASSIVS_MAX Number(20,4) NOT NULL,
NUM_PASSIVS_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
NUM_PASSIV_ERRORS_MIN Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_MAX Number(20,4) NOT NULL,
NUM_PASSIV_ERRORS_STCNT varchar2(32) NOT NULL,
BEANS_IN_CACHE_MIN Number(20,4) NOT NULL,
BEANS_IN_CACHE_MAX Number(20,4) NOT NULL,
BEANS_IN_CACHE_STCNT varchar2(32) NOT NULL,
EXPIRED_SESS_REMOVED_MIN Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_MAX Number(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_STCNT varchar2(32) NOT NULL,
MAX_BEANS_IN_CACHE_MIN Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_MAX Number(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_STCNT varchar2(32) NOT NULL,
NUM_PASSIV_SUCCESS_MIN Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_MAX Number(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest_TREND ADD constraint PK_Sun1EjbCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESIZE_QUANTITY_MIN	VARCHAR2(256)	 NOT NULL,
RESIZE_QUANTITY_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIVS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIVS_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
BEANS_IN_CACHE_MIN	VARCHAR2(256)	 NOT NULL,
BEANS_IN_CACHE_MAX	VARCHAR2(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MIN	VARCHAR2(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MAX	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1EjbCacheTest_THRESH ADD constraint PK_Sun1EjbCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbCacheTest_THRESH ON Sun1EjbCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbPoolTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
IDLE_TIMEOUT Number(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar2(32) NOT NULL,
STEADY_POOL_SIZE Number(20,4) NOT NULL,
STEADY_POOL_SIZE_ST varchar2(32) NOT NULL,
TOTAL_BEANS_DESTROYED Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_ST varchar2(32) NOT NULL,
NUM_THREADS_WAITING Number(20,4) NOT NULL,
NUM_THREADS_WAITING_ST varchar2(32) NOT NULL,
NUM_BEANS_IN_POOL Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_ST varchar2(32) NOT NULL,
MAX_POOL_SIZE Number(20,4) NOT NULL,
MAX_POOL_SIZE_ST varchar2(32) NOT NULL,
POOL_RESIZE_QUANTITY Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_ST varchar2(32) NOT NULL,
TOTAL_BEANS_CREATED Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest ADD constraint PK_Sun1EjbPoolTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1EjbPoolTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
IDLE_TIMEOUT_MIN Number(20,4) NOT NULL,
IDLE_TIMEOUT_MAX Number(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar2(32) NOT NULL,
STEADY_POOL_SIZE_MIN Number(20,4) NOT NULL,
STEADY_POOL_SIZE_MAX Number(20,4) NOT NULL,
STEADY_POOL_SIZE_STCNT varchar2(32) NOT NULL,
TOTAL_BEANS_DESTROYED_MIN Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_MAX Number(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_STCNT varchar2(32) NOT NULL,
NUM_THREADS_WAITING_MIN Number(20,4) NOT NULL,
NUM_THREADS_WAITING_MAX Number(20,4) NOT NULL,
NUM_THREADS_WAITING_STCNT varchar2(32) NOT NULL,
NUM_BEANS_IN_POOL_MIN Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_MAX Number(20,4) NOT NULL,
NUM_BEANS_IN_POOL_STCNT varchar2(32) NOT NULL,
MAX_POOL_SIZE_MIN Number(20,4) NOT NULL,
MAX_POOL_SIZE_MAX Number(20,4) NOT NULL,
MAX_POOL_SIZE_STCNT varchar2(32) NOT NULL,
POOL_RESIZE_QUANTITY_MIN Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_MAX Number(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_STCNT varchar2(32) NOT NULL,
TOTAL_BEANS_CREATED_MIN Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_MAX Number(20,4) NOT NULL,
TOTAL_BEANS_CREATED_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest_TREND ADD constraint PK_Sun1EjbPoolTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbPoolTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1EjbPoolTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
IDLE_TIMEOUT_MIN	VARCHAR2(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR2(256)	 NOT NULL,
STEADY_POOL_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
STEADY_POOL_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MAX	VARCHAR2(256)	 NOT NULL,
NUM_THREADS_WAITING_MIN	VARCHAR2(256)	 NOT NULL,
NUM_THREADS_WAITING_MAX	VARCHAR2(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MIN	VARCHAR2(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MAX	VARCHAR2(256)	 NOT NULL,
MAX_POOL_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
MAX_POOL_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MIN	VARCHAR2(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1EjbPoolTest_THRESH ADD constraint PK_Sun1EjbPoolTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbPoolTest_THRESH ON Sun1EjbPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1HttpTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REQUESTS_COUNT Number(20,4) NOT NULL,
REQUESTS_COUNT_ST varchar2(32) NOT NULL,
KB_RECEIVED_COUNT Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_ST varchar2(32) NOT NULL,
KB_TRANSMITTED_COUNT Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_ST varchar2(32) NOT NULL,
MAX_TRANS_RATE_HWM Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_ST varchar2(32) NOT NULL,
OPEN_CONNECTIONS_COUNT Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_ST varchar2(32) NOT NULL,
MAX_OPEN_CONNS_HWM Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_ST varchar2(32) NOT NULL,
COUNT_2XX Number(20,4) NOT NULL,
COUNT_2XX_ST varchar2(32) NOT NULL,
COUNT_3XX Number(20,4) NOT NULL,
COUNT_3XX_ST varchar2(32) NOT NULL,
COUNT_4XX Number(20,4) NOT NULL,
COUNT_4XX_ST varchar2(32) NOT NULL,
COUNT_5XX Number(20,4) NOT NULL,
COUNT_5XX_ST varchar2(32) NOT NULL,
OTHER_RESPONSES_COUNT Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1HttpTest ADD constraint PK_Sun1HttpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1HttpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REQUESTS_COUNT_MIN Number(20,4) NOT NULL,
REQUESTS_COUNT_MAX Number(20,4) NOT NULL,
REQUESTS_COUNT_STCNT varchar2(32) NOT NULL,
KB_RECEIVED_COUNT_MIN Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_MAX Number(20,4) NOT NULL,
KB_RECEIVED_COUNT_STCNT varchar2(32) NOT NULL,
KB_TRANSMITTED_COUNT_MIN Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_MAX Number(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_STCNT varchar2(32) NOT NULL,
MAX_TRANS_RATE_HWM_MIN Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_MAX Number(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_STCNT varchar2(32) NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX Number(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_STCNT varchar2(32) NOT NULL,
MAX_OPEN_CONNS_HWM_MIN Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_MAX Number(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_STCNT varchar2(32) NOT NULL,
COUNT_2XX_MIN Number(20,4) NOT NULL,
COUNT_2XX_MAX Number(20,4) NOT NULL,
COUNT_2XX_STCNT varchar2(32) NOT NULL,
COUNT_3XX_MIN Number(20,4) NOT NULL,
COUNT_3XX_MAX Number(20,4) NOT NULL,
COUNT_3XX_STCNT varchar2(32) NOT NULL,
COUNT_4XX_MIN Number(20,4) NOT NULL,
COUNT_4XX_MAX Number(20,4) NOT NULL,
COUNT_4XX_STCNT varchar2(32) NOT NULL,
COUNT_5XX_MIN Number(20,4) NOT NULL,
COUNT_5XX_MAX Number(20,4) NOT NULL,
COUNT_5XX_STCNT varchar2(32) NOT NULL,
OTHER_RESPONSES_COUNT_MIN Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_MAX Number(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1HttpTest_TREND ADD constraint PK_Sun1HttpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1HttpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1HttpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REQUESTS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
REQUESTS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
KB_RECEIVED_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
KB_RECEIVED_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MIN	VARCHAR2(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MAX	VARCHAR2(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MIN	VARCHAR2(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_2XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_2XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_3XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_3XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_4XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_4XX_MAX	VARCHAR2(256)	 NOT NULL,
COUNT_5XX_MIN	VARCHAR2(256)	 NOT NULL,
COUNT_5XX_MAX	VARCHAR2(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1HttpTest_THRESH ADD constraint PK_Sun1HttpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1HttpTest_THRESH ON Sun1HttpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1JdbcTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_THREADS_WAITING Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_ST varchar2(32) NOT NULL,
TOTAL_CONNS_FAILED Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_ST varchar2(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1JdbcTest ADD constraint PK_Sun1JdbcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1JdbcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_THREADS_WAITING_MIN Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_MAX Number(20,4) NOT NULL,
TOTAL_THREADS_WAITING_STCNT varchar2(32) NOT NULL,
TOTAL_CONNS_FAILED_MIN Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_MAX Number(20,4) NOT NULL,
TOTAL_CONNS_FAILED_STCNT varchar2(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX Number(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1JdbcTest_TREND ADD constraint PK_Sun1JdbcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1JdbcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1JdbcTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_THREADS_WAITING_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_THREADS_WAITING_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1JdbcTest_THRESH ADD constraint PK_Sun1JdbcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1JdbcTest_THRESH ON Sun1JdbcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1TxTest CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_TX_COMPLETED Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_ST varchar2(32) NOT NULL,
TOTAL_TX_ROLLED_BACK Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_ST varchar2(32) NOT NULL,
TOTAL_TX_INFLIGHT Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_ST varchar2(32) NOT NULL);

ALTER TABLE Sun1TxTest ADD constraint PK_Sun1TxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE Sun1TxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_TX_COMPLETED_MIN Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_MAX Number(20,4) NOT NULL,
TOTAL_TX_COMPLETED_STCNT varchar2(32) NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX Number(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_STCNT varchar2(32) NOT NULL,
TOTAL_TX_INFLIGHT_MIN Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_MAX Number(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_STCNT varchar2(32) NOT NULL);

ALTER TABLE Sun1TxTest_TREND ADD constraint PK_Sun1TxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1TxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE Sun1TxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_TX_COMPLETED_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_COMPLETED_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE Sun1TxTest_THRESH ADD constraint PK_Sun1TxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1TxTest_THRESH ON Sun1TxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppTest CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUMBER_OF_PROCESSES Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar2(32) NOT NULL,
CPU_USAGE Number(20,4) NOT NULL,
CPU_USAGE_ST varchar2(32) NOT NULL,
MEMORY_USAGE Number(20,4) NOT NULL,
MEMORY_USAGE_ST varchar2(32) NOT NULL,
HANDLE_COUNT Number(20,4) NOT NULL,
HANDLE_COUNT_ST varchar2(32) NOT NULL,
NO_OF_THREADS Number(20,4) NOT NULL,
NO_OF_THREADS_ST varchar2(32) NOT NULL,
IO_DATA_RATE Number(20,4) NOT NULL,
IO_DATA_RATE_ST varchar2(32) NOT NULL,
IO_DATA_OPER_RATE Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_ST varchar2(32) NOT NULL,
IO_READ_DATA_RATE Number(20,4) NOT NULL,
IO_READ_DATA_RATE_ST varchar2(32) NOT NULL,
IO_WRITE_DATA_RATE Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_ST varchar2(32) NOT NULL,
PAGE_FAULT_RATE Number(20,4) NOT NULL,
PAGE_FAULT_RATE_ST varchar2(32) NOT NULL,
VIRTUAL_MEMORY_USED Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_ST varchar2(32) NOT NULL,
MEMORY_USED Number(20,4) NOT NULL,
MEMORY_USED_ST varchar2(32) NOT NULL);

ALTER TABLE CtxAppTest ADD constraint PK_CtxAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUMBER_OF_PROCESSES_MIN Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar2(32) NOT NULL,
CPU_USAGE_MIN Number(20,4) NOT NULL,
CPU_USAGE_MAX Number(20,4) NOT NULL,
CPU_USAGE_STCNT varchar2(32) NOT NULL,
MEMORY_USAGE_MIN Number(20,4) NOT NULL,
MEMORY_USAGE_MAX Number(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar2(32) NOT NULL,
HANDLE_COUNT_MIN Number(20,4) NOT NULL,
HANDLE_COUNT_MAX Number(20,4) NOT NULL,
HANDLE_COUNT_STCNT varchar2(32) NOT NULL,
NO_OF_THREADS_MIN Number(20,4) NOT NULL,
NO_OF_THREADS_MAX Number(20,4) NOT NULL,
NO_OF_THREADS_STCNT varchar2(32) NOT NULL,
IO_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_DATA_RATE_STCNT varchar2(32) NOT NULL,
IO_DATA_OPER_RATE_MIN Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_MAX Number(20,4) NOT NULL,
IO_DATA_OPER_RATE_STCNT varchar2(32) NOT NULL,
IO_READ_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_READ_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_READ_DATA_RATE_STCNT varchar2(32) NOT NULL,
IO_WRITE_DATA_RATE_MIN Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_MAX Number(20,4) NOT NULL,
IO_WRITE_DATA_RATE_STCNT varchar2(32) NOT NULL,
PAGE_FAULT_RATE_MIN Number(20,4) NOT NULL,
PAGE_FAULT_RATE_MAX Number(20,4) NOT NULL,
PAGE_FAULT_RATE_STCNT varchar2(32) NOT NULL,
VIRTUAL_MEMORY_USED_MIN Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_MAX Number(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_STCNT varchar2(32) NOT NULL,
MEMORY_USED_MIN Number(20,4) NOT NULL,
MEMORY_USED_MAX Number(20,4) NOT NULL,
MEMORY_USED_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxAppTest_TREND ADD constraint PK_CtxAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxAppTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
HANDLE_COUNT_MIN VARCHAR2(256) NOT NULL,
HANDLE_COUNT_MAX VARCHAR2(256) NOT NULL,
NO_OF_THREADS_MIN VARCHAR2(256) NOT NULL,
NO_OF_THREADS_MAX VARCHAR2(256) NOT NULL,
IO_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
IO_DATA_OPER_RATE_MIN VARCHAR2(256) NOT NULL,
IO_DATA_OPER_RATE_MAX VARCHAR2(256) NOT NULL,
IO_READ_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_READ_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
IO_WRITE_DATA_RATE_MIN VARCHAR2(256) NOT NULL,
IO_WRITE_DATA_RATE_MAX VARCHAR2(256) NOT NULL,
PAGE_FAULT_RATE_MIN VARCHAR2(256) NOT NULL,
PAGE_FAULT_RATE_MAX VARCHAR2(256) NOT NULL,
VIRTUAL_MEMORY_USED_MIN VARCHAR2(256) NOT NULL,
VIRTUAL_MEMORY_USED_MAX VARCHAR2(256) NOT NULL,
MEMORY_USED_MIN VARCHAR2(256) NOT NULL,
MEMORY_USED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE CtxAppTest_THRESH ADD constraint PK_CtxAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAppTest_THRESH ON CtxAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxMfAppTest CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUMBER_OF_PROCESSES Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar2(32) NOT NULL,
CPU_USAGE Number(20,4) NOT NULL,
CPU_USAGE_ST varchar2(32) NOT NULL,
MEMORY_USAGE Number(20,4) NOT NULL,
MEMORY_USAGE_ST varchar2(32) NOT NULL);

ALTER TABLE CtxMfAppTest ADD constraint PK_CtxMfAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxMfAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUMBER_OF_PROCESSES_MIN Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX Number(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar2(32) NOT NULL,
CPU_USAGE_MIN Number(20,4) NOT NULL,
CPU_USAGE_MAX Number(20,4) NOT NULL,
CPU_USAGE_STCNT varchar2(32) NOT NULL,
MEMORY_USAGE_MIN Number(20,4) NOT NULL,
MEMORY_USAGE_MAX Number(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxMfAppTest_TREND ADD constraint PK_CtxMfAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxMfAppTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUMBER_OF_PROCESSES_MIN	VARCHAR2(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxMfAppTest_THRESH ADD constraint PK_CtxMfAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfAppTest_THRESH ON CtxMfAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxClientTest CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CURRENT_CONNS Number(20,4) NOT NULL,
CURRENT_CONNS_ST varchar2(32) NOT NULL,
NEW_CONNS_ADDED Number(20,4) NOT NULL,
NEW_CONNS_ADDED_ST varchar2(32) NOT NULL,
OLD_CONNS_REMOVED Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_ST varchar2(32) NOT NULL,
AVG_CONN_DURATION Number(20,4) NOT NULL,
AVG_CONN_DURATION_ST varchar2(32) NOT NULL);

ALTER TABLE CtxClientTest ADD constraint PK_CtxClientTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxClientTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURRENT_CONNS_MIN Number(20,4) NOT NULL,
CURRENT_CONNS_MAX Number(20,4) NOT NULL,
CURRENT_CONNS_STCNT varchar2(32) NOT NULL,
NEW_CONNS_ADDED_MIN Number(20,4) NOT NULL,
NEW_CONNS_ADDED_MAX Number(20,4) NOT NULL,
NEW_CONNS_ADDED_STCNT varchar2(32) NOT NULL,
OLD_CONNS_REMOVED_MIN Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_MAX Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_STCNT varchar2(32) NOT NULL,
AVG_CONN_DURATION_MIN Number(20,4) NOT NULL,
AVG_CONN_DURATION_MAX Number(20,4) NOT NULL,
AVG_CONN_DURATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxClientTest_TREND ADD constraint PK_CtxClientTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxClientTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxClientTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURRENT_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
CURRENT_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MIN	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MAX	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MIN	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxClientTest_THRESH ADD constraint PK_CtxClientTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxClientTest_THRESH ON CtxClientTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxImaTest CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BYTES_RECEIVED Number(20,4) NOT NULL,
BYTES_RECEIVED_ST varchar2(32) NOT NULL,
BYTES_SENT Number(20,4) NOT NULL,
BYTES_SENT_ST varchar2(32) NOT NULL,
NETWORK_CONNECTIONS Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_ST varchar2(32) NOT NULL);

ALTER TABLE CtxImaTest ADD constraint PK_CtxImaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxImaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BYTES_RECEIVED_MIN Number(20,4) NOT NULL,
BYTES_RECEIVED_MAX Number(20,4) NOT NULL,
BYTES_RECEIVED_STCNT varchar2(32) NOT NULL,
BYTES_SENT_MIN Number(20,4) NOT NULL,
BYTES_SENT_MAX Number(20,4) NOT NULL,
BYTES_SENT_STCNT varchar2(32) NOT NULL,
NETWORK_CONNECTIONS_MIN Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_MAX Number(20,4) NOT NULL,
NETWORK_CONNECTIONS_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxImaTest_TREND ADD constraint PK_CtxImaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxImaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxImaTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BYTES_RECEIVED_MIN	VARCHAR2(256)	 NOT NULL,
BYTES_RECEIVED_MAX	VARCHAR2(256)	 NOT NULL,
BYTES_SENT_MIN	VARCHAR2(256)	 NOT NULL,
BYTES_SENT_MAX	VARCHAR2(256)	 NOT NULL,
NETWORK_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
NETWORK_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxImaTest_THRESH ADD constraint PK_CtxImaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxImaTest_THRESH ON CtxImaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE CtxSessionTest CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_SESSIONS Number(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
IDLE_SESSIONS Number(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTED_SESSIONS Number(20,4) NOT NULL,
CONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTING_SESSIONS Number(20,4) NOT NULL,
CONNECTING_SESSIONS_ST varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
LISTEN_SESSIONS Number(20,4) NOT NULL,
LISTEN_SESSIONS_ST varchar2(32) NOT NULL,
SHADOW_SESSIONS Number(20,4) NOT NULL,
SHADOW_SESSIONS_ST varchar2(32) NOT NULL,
DOWN_SESSIONS Number(20,4) NOT NULL,
DOWN_SESSIONS_ST varchar2(32) NOT NULL,
INIT_SESSIONS Number(20,4) NOT NULL,
INIT_SESSIONS_ST varchar2(32) NOT NULL);
 
CREATE INDEX IDX_CtxSessionTest ON CtxSessionTest(MSMT_TIME);
CREATE INDEX IDX1_CTXSESSIONTEST ON CTXSESSIONTEST (ACTIVE_SESSIONS);
ALTER TABLE CtxSessionTest ADD constraint PK_CtxSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxSessionTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD        varchar2(32),
ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
IDLE_SESSIONS_MIN Number(20,4) NOT NULL,
IDLE_SESSIONS_MAX Number(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTING_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTING_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTING_SESSIONS_STCNT varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
LISTEN_SESSIONS_MIN Number(20,4) NOT NULL,
LISTEN_SESSIONS_MAX Number(20,4) NOT NULL,
LISTEN_SESSIONS_STCNT varchar2(32) NOT NULL,
SHADOW_SESSIONS_MIN Number(20,4) NOT NULL,
SHADOW_SESSIONS_MAX Number(20,4) NOT NULL,
SHADOW_SESSIONS_STCNT varchar2(32) NOT NULL,
DOWN_SESSIONS_MIN Number(20,4) NOT NULL,
DOWN_SESSIONS_MAX Number(20,4) NOT NULL,
DOWN_SESSIONS_STCNT varchar2(32) NOT NULL,
INIT_SESSIONS_MIN Number(20,4) NOT NULL,
INIT_SESSIONS_MAX Number(20,4) NOT NULL,
INIT_SESSIONS_STCNT varchar2(32) NOT NULL);
 
ALTER TABLE CtxSessionTest_TREND ADD constraint PK_CtxSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxSessionTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxSessionTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
ACTIVE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MIN VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MIN VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MAX VARCHAR2(256) NOT NULL);
 
ALTER TABLE CtxSessionTest_THRESH ADD constraint PK_CtxSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxSessionTest_THRESH ON CtxSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_CtxSessionTest ON CtxSessionTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_CtxSessionTest ON CtxSessionTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE CtxMfXpSrvTest CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
APP_ENUMS_RT Number(20,4) NOT NULL,
APP_ENUMS_RT_ST varchar2(32) NOT NULL,
APP_RESOLUTIONS_RT Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_ST varchar2(32) NOT NULL,
DSTORE_CONN_FAILURE Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_ST varchar2(32) NOT NULL,
DSTORE_KB_READ_RT Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_ST varchar2(32) NOT NULL,
DSTORE_KB_WRITTEN_RT Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
DYNSTORE_KB_READ_RT Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_ST varchar2(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
LH_CACHE_KB_READ_RT Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_ST varchar2(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_ST varchar2(32) NOT NULL,
ZONE_ELECTIONS Number(20,4) NOT NULL,
ZONE_ELECTIONS_ST varchar2(32) NOT NULL,
ZONE_ELECTIONS_W Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_ST varchar2(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest ADD constraint PK_CtxMfXpSrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxMfXpSrvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
APP_ENUMS_RT_MIN Number(20,4) NOT NULL,
APP_ENUMS_RT_MAX Number(20,4) NOT NULL,
APP_ENUMS_RT_STCNT varchar2(32) NOT NULL,
APP_RESOLUTIONS_RT_MIN Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_MAX Number(20,4) NOT NULL,
APP_RESOLUTIONS_RT_STCNT varchar2(32) NOT NULL,
DSTORE_CONN_FAILURE_MIN Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_MAX Number(20,4) NOT NULL,
DSTORE_CONN_FAILURE_STCNT varchar2(32) NOT NULL,
DSTORE_KB_READ_RT_MIN Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_MAX Number(20,4) NOT NULL,
DSTORE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
DYNSTORE_KB_READ_RT_MIN Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_MAX Number(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
LH_CACHE_KB_READ_RT_MIN Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_MAX Number(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_STCNT varchar2(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX Number(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_STCNT varchar2(32) NOT NULL,
ZONE_ELECTIONS_MIN Number(20,4) NOT NULL,
ZONE_ELECTIONS_MAX Number(20,4) NOT NULL,
ZONE_ELECTIONS_STCNT varchar2(32) NOT NULL,
ZONE_ELECTIONS_W_MIN Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_MAX Number(20,4) NOT NULL,
ZONE_ELECTIONS_W_STCNT varchar2(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_TREND ADD constraint PK_CtxMfXpSrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfXpSrvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxMfXpSrvTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
APP_ENUMS_RT_MIN	VARCHAR2(256)	 NOT NULL,
APP_ENUMS_RT_MAX	VARCHAR2(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MIN	VARCHAR2(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MIN	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MAX	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN	VARCHAR2(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_W_MIN	VARCHAR2(256)	 NOT NULL,
ZONE_ELECTIONS_W_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_THRESH ADD constraint PK_CtxMfXpSrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfXpSrvTest_THRESH ON CtxMfXpSrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxXpUserTest CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NO_OF_SESSIONS Number(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar2(32) NOT NULL,
LATENCY_LAST Number(20,4) NOT NULL,
LATENCY_LAST_ST varchar2(32) NOT NULL,
LATENCY_AVG Number(20,4) NOT NULL,
LATENCY_AVG_ST varchar2(32) NOT NULL,
LATENCY_DEVN Number(20,4) NOT NULL,
LATENCY_DEVN_ST varchar2(32) NOT NULL,
MEM_UTIL Number(20,4) NOT NULL,
MEM_UTIL_ST varchar2(32) NOT NULL,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL,
INPUT_BANDWIDTH Number(20,4) NOT NULL,
INPUT_BANDWIDTH_ST varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_ST varchar2(32) NOT NULL,
INPUT_LINE_SPEED Number(20,4) NOT NULL,
INPUT_LINE_SPEED_ST varchar2(32) NOT NULL,
OUTPUT_LINE_SPEED Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_ST varchar2(32) NOT NULL,
INPUT_COMPRESSION Number(20,4) NOT NULL,
INPUT_COMPRESSION_ST varchar2(32) NOT NULL,
OUTPUT_COMPRESSION Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_ST varchar2(32) NOT NULL,
IO_READS Number(20,4) NOT NULL,
IO_READS_ST varchar2(32) NOT NULL,
IO_WRITES Number(20,4) NOT NULL,
IO_WRITES_ST varchar2(32) NOT NULL,
PAGE_FAULTS Number(20,4) NOT NULL,
PAGE_FAULTS_ST varchar2(32) NOT NULL,
VIRTUAL_MEM Number(20,4) NOT NULL,
VIRTUAL_MEM_ST varchar2(32) NOT NULL,
HANDLES Number(20,4) NOT NULL,
HANDLES_ST varchar2(32) NOT NULL,
INPUT_AUDIO Number(20,4) NOT NULL,
INPUT_AUDIO_ST varchar2(32) NOT NULL,
OUTPUT_AUDIO Number(20,4) NOT NULL,
OUTPUT_AUDIO_ST varchar2(32) NOT NULL,
INPUT_COM Number(20,4) NOT NULL,
INPUT_COM_ST varchar2(32) NOT NULL,
OUTPUT_COM Number(20,4) NOT NULL,
OUTPUT_COM_ST varchar2(32) NOT NULL,
INPUT_DRIVE Number(20,4) NOT NULL,
INPUT_DRIVE_ST varchar2(32) NOT NULL,
OUTPUT_DRIVE Number(20,4) NOT NULL,
OUTPUT_DRIVE_ST varchar2(32) NOT NULL,
INPUT_HDX Number(20,4) NOT NULL,
INPUT_HDX_ST varchar2(32) NOT NULL,
OUTPUT_HDX Number(20,4) NOT NULL,
OUTPUT_HDX_ST varchar2(32) NOT NULL,
INPUT_PRINTER Number(20,4) NOT NULL,
INPUT_PRINTER_ST varchar2(32) NOT NULL,
OUTPUT_PRINTER Number(20,4) NOT NULL,
OUTPUT_PRINTER_ST varchar2(32) NOT NULL,
INPUT_DATA Number(20,4) NOT NULL,
INPUT_DATA_ST varchar2(32) NOT NULL,
OUTPUT_DATA Number(20,4) NOT NULL,
OUTPUT_DATA_ST varchar2(32) NOT NULL,
INPUT_MULTI Number(20,4) NOT NULL,
INPUT_MULTI_ST varchar2(32) NOT NULL,
OUTPUT_MULTI Number(20,4) NOT NULL,
OUTPUT_MULTI_ST varchar2(32) NOT NULL,
INPUT_USB Number(20,4) NOT NULL,
INPUT_USB_ST varchar2(32) NOT NULL,
OUTPUT_USB Number(20,4) NOT NULL,
OUTPUT_USB_ST varchar2(32) NOT NULL,
CPU_UTIL_TIME Number(20,4) NOT NULL,
CPU_UTIL_TIME_ST varchar2(32) NOT NULL,
BANDWIDTH_USAGE Number(20,4) NOT NULL,
BANDWIDTH_USAGE_ST varchar2(32) NOT NULL,
INPUT_THINWIRE Number(20,4) NOT NULL,
INPUT_THINWIRE_ST varchar2(32) NOT NULL,
OUTPUT_THINWIRE Number(20,4) NOT NULL,
OUTPUT_THINWIRE_ST varchar2(32) NOT NULL,
INPUT_SEAMLESS Number(20,4) NOT NULL,
INPUT_SEAMLESS_ST varchar2(32) NOT NULL,
OUTPUT_SEAMLESS Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_ST varchar2(32) NOT NULL,
RESOURCE_SHARES Number(20,4) NOT NULL,
RESOURCE_SHARES_ST varchar2(32) NOT NULL,
TOTAL_SESSION_DURATION Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_ST varchar2(32) NOT NULL,
IDLE_TIME_MEASUREPRD Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_ST varchar2(32) NOT NULL,
IDLE_TIME_DURATION Number(20,4) NOT NULL,
IDLE_TIME_DURATION_ST varchar2(32) NOT NULL,
TOTAL_IDLE_DURATION Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_ST varchar2(32) NOT NULL,
TOTAL_BANDWIDTH Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_ST varchar2(32) NOT NULL,
MEMORY_USED Number(20,4) NOT NULL,
MEMORY_USED_ST varchar2(32) NOT NULL,
PROCESS_COUNT Number(20,4) NOT NULL,
PROCESS_COUNT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX1_CTXXPUSERTEST ON CTXXPUSERTEST (PORT_NO , MSMT_TIME);
ALTER TABLE CtxXpUserTest ADD constraint PK_CtxXpUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxXpUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NO_OF_SESSIONS_MIN Number(20,4) NOT NULL,
NO_OF_SESSIONS_MAX Number(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar2(32) NOT NULL,
LATENCY_LAST_MIN Number(20,4) NOT NULL,
LATENCY_LAST_MAX Number(20,4) NOT NULL,
LATENCY_LAST_STCNT varchar2(32) NOT NULL,
LATENCY_AVG_MIN Number(20,4) NOT NULL,
LATENCY_AVG_MAX Number(20,4) NOT NULL,
LATENCY_AVG_STCNT varchar2(32) NOT NULL,
LATENCY_DEVN_MIN Number(20,4) NOT NULL,
LATENCY_DEVN_MAX Number(20,4) NOT NULL,
LATENCY_DEVN_STCNT varchar2(32) NOT NULL,
MEM_UTIL_MIN Number(20,4) NOT NULL,
MEM_UTIL_MAX Number(20,4) NOT NULL,
MEM_UTIL_STCNT varchar2(32) NOT NULL,
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL,
INPUT_BANDWIDTH_MIN Number(20,4) NOT NULL,
INPUT_BANDWIDTH_MAX Number(20,4) NOT NULL,
INPUT_BANDWIDTH_STCNT varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH_MIN Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_MAX Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_STCNT varchar2(32) NOT NULL,
INPUT_LINE_SPEED_MIN Number(20,4) NOT NULL,
INPUT_LINE_SPEED_MAX Number(20,4) NOT NULL,
INPUT_LINE_SPEED_STCNT varchar2(32) NOT NULL,
OUTPUT_LINE_SPEED_MIN Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_MAX Number(20,4) NOT NULL,
OUTPUT_LINE_SPEED_STCNT varchar2(32) NOT NULL,
INPUT_COMPRESSION_MIN Number(20,4) NOT NULL,
INPUT_COMPRESSION_MAX Number(20,4) NOT NULL,
INPUT_COMPRESSION_STCNT varchar2(32) NOT NULL,
OUTPUT_COMPRESSION_MIN Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_MAX Number(20,4) NOT NULL,
OUTPUT_COMPRESSION_STCNT varchar2(32) NOT NULL,
IO_READS_MIN Number(20,4) NOT NULL,
IO_READS_MAX Number(20,4)  NOT NULL,
IO_READS_STCNT varchar2(32) NOT NULL,
IO_WRITES_MIN Number(20,4) NOT NULL,
IO_WRITES_MAX Number(20,4) NOT NULL,
IO_WRITES_STCNT varchar2(32) NOT NULL,
PAGE_FAULTS_MIN Number(20,4) NOT NULL,
PAGE_FAULTS_MAX Number(20,4) NOT NULL,
PAGE_FAULTS_STCNT varchar2(32) NOT NULL,
VIRTUAL_MEM_MIN Number(20,4) NOT NULL,
VIRTUAL_MEM_MAX Number(20,4) NOT NULL,
VIRTUAL_MEM_STCNT varchar2(32) NOT NULL,
HANDLES_MIN Number(20,4) NOT NULL,
HANDLES_MAX Number(20,4) NOT NULL,
HANDLES_STCNT varchar2(32) NOT NULL,
INPUT_AUDIO_MIN Number(20,4) NOT NULL,
INPUT_AUDIO_MAX Number(20,4) NOT NULL,
INPUT_AUDIO_STCNT varchar2(32) NOT NULL,
OUTPUT_AUDIO_MIN Number(20,4) NOT NULL,
OUTPUT_AUDIO_MAX Number(20,4) NOT NULL,
OUTPUT_AUDIO_STCNT varchar2(32) NOT NULL,
INPUT_COM_MIN Number(20,4) NOT NULL,
INPUT_COM_MAX Number(20,4) NOT NULL,
INPUT_COM_STCNT varchar2(32) NOT NULL,
OUTPUT_COM_MIN Number(20,4) NOT NULL,
OUTPUT_COM_MAX Number(20,4) NOT NULL,
OUTPUT_COM_STCNT varchar2(32) NOT NULL,
INPUT_DRIVE_MIN Number(20,4) NOT NULL,
INPUT_DRIVE_MAX Number(20,4) NOT NULL,
INPUT_DRIVE_STCNT varchar2(32) NOT NULL,
OUTPUT_DRIVE_MIN Number(20,4) NOT NULL,
OUTPUT_DRIVE_MAX Number(20,4) NOT NULL,
OUTPUT_DRIVE_STCNT varchar2(32) NOT NULL,
INPUT_HDX_MIN Number(20,4) NOT NULL,
INPUT_HDX_MAX Number(20,4) NOT NULL,
INPUT_HDX_STCNT varchar2(32) NOT NULL,
OUTPUT_HDX_MIN Number(20,4) NOT NULL,
OUTPUT_HDX_MAX Number(20,4) NOT NULL,
OUTPUT_HDX_STCNT varchar2(32) NOT NULL,
INPUT_PRINTER_MIN Number(20,4) NOT NULL,
INPUT_PRINTER_MAX Number(20,4) NOT NULL,
INPUT_PRINTER_STCNT varchar2(32) NOT NULL,
OUTPUT_PRINTER_MIN Number(20,4) NOT NULL,
OUTPUT_PRINTER_MAX Number(20,4) NOT NULL,
OUTPUT_PRINTER_STCNT varchar2(32) NOT NULL,
INPUT_DATA_MIN Number(20,4) NOT NULL,
INPUT_DATA_MAX Number(20,4) NOT NULL,
INPUT_DATA_STCNT varchar2(32) NOT NULL,
OUTPUT_DATA_MIN Number(20,4) NOT NULL,
OUTPUT_DATA_MAX Number(20,4) NOT NULL,
OUTPUT_DATA_STCNT varchar2(32) NOT NULL,
INPUT_MULTI_MIN Number(20,4) NOT NULL,
INPUT_MULTI_MAX Number(20,4) NOT NULL,
INPUT_MULTI_STCNT varchar2(32) NOT NULL,
OUTPUT_MULTI_MIN Number(20,4) NOT NULL,
OUTPUT_MULTI_MAX Number(20,4) NOT NULL,
OUTPUT_MULTI_STCNT varchar2(32) NOT NULL,
INPUT_USB_MIN Number(20,4) NOT NULL,
INPUT_USB_MAX Number(20,4) NOT NULL,
INPUT_USB_STCNT varchar2(32) NOT NULL,
OUTPUT_USB_MIN Number(20,4) NOT NULL,
OUTPUT_USB_MAX Number(20,4) NOT NULL,
OUTPUT_USB_STCNT varchar2(32) NOT NULL,
CPU_UTIL_TIME_MIN Number(20,4) NOT NULL,
CPU_UTIL_TIME_MAX Number(20,4) NOT NULL,
CPU_UTIL_TIME_STCNT varchar2(32) NOT NULL,
BANDWIDTH_USAGE_MIN Number(20,4) NOT NULL,
BANDWIDTH_USAGE_MAX Number(20,4) NOT NULL,
BANDWIDTH_USAGE_STCNT varchar2(32) NOT NULL,
INPUT_THINWIRE_MIN Number(20,4) NOT NULL,
INPUT_THINWIRE_MAX Number(20,4) NOT NULL,
INPUT_THINWIRE_STCNT varchar2(32) NOT NULL,
OUTPUT_THINWIRE_MIN Number(20,4) NOT NULL,
OUTPUT_THINWIRE_MAX Number(20,4) NOT NULL,
OUTPUT_THINWIRE_STCNT varchar2(32) NOT NULL,
INPUT_SEAMLESS_MIN Number(20,4) NOT NULL,
INPUT_SEAMLESS_MAX Number(20,4) NOT NULL,
INPUT_SEAMLESS_STCNT varchar2(32) NOT NULL,
OUTPUT_SEAMLESS_MIN Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_MAX Number(20,4) NOT NULL,
OUTPUT_SEAMLESS_STCNT varchar2(32) NOT NULL,
RESOURCE_SHARES_MIN Number(20,4) NOT NULL,
RESOURCE_SHARES_MAX Number(20,4) NOT NULL,
RESOURCE_SHARES_STCNT varchar2(32) NOT NULL,
TOTAL_SESSION_DURATION_MIN Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_MAX Number(20,4) NOT NULL,
TOTAL_SESSION_DURATION_STCNT varchar2(32) NOT NULL,
IDLE_TIME_MEASUREPRD_MIN Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_MAX Number(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_STCNT varchar2(32) NOT NULL,
IDLE_TIME_DURATION_MIN Number(20,4) NOT NULL,
IDLE_TIME_DURATION_MAX Number(20,4) NOT NULL,
IDLE_TIME_DURATION_STCNT varchar2(32) NOT NULL,
TOTAL_IDLE_DURATION_MIN Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_MAX Number(20,4) NOT NULL,
TOTAL_IDLE_DURATION_STCNT varchar2(32) NOT NULL,
TOTAL_BANDWIDTH_MIN Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_MAX Number(20,4) NOT NULL,
TOTAL_BANDWIDTH_STCNT varchar2(32) NOT NULL,
MEMORY_USED_MIN Number(20,4) NOT NULL,
MEMORY_USED_MAX Number(20,4) NOT NULL,
MEMORY_USED_STCNT varchar2(32) NOT NULL,
PROCESS_COUNT_MIN Number(20,4) NOT NULL,
PROCESS_COUNT_MAX Number(20,4) NOT NULL,
PROCESS_COUNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxXpUserTest_TREND ADD constraint PK_CtxXpUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxXpUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxXpUserTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NO_OF_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_LAST_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_LAST_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_AVG_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_AVG_MAX	VARCHAR2(256)	 NOT NULL,
LATENCY_DEVN_MIN	VARCHAR2(256)	 NOT NULL,
LATENCY_DEVN_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_LINE_SPEED_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_LINE_SPEED_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_COMPRESSION_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_COMPRESSION_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_COMPRESSION_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_COMPRESSION_MAX	VARCHAR2(256)	 NOT NULL,
IO_READS_MIN VARCHAR2(256) NOT NULL,
IO_READS_MAX VARCHAR2(256)  NOT NULL,
IO_WRITES_MIN VARCHAR2(256) NOT NULL,
IO_WRITES_MAX VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MIN VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MAX VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MIN VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MAX VARCHAR2(256) NOT NULL,
HANDLES_MIN VARCHAR2(256) NOT NULL,
HANDLES_MAX VARCHAR2(256) NOT NULL,
INPUT_AUDIO_MIN VARCHAR2(256) NOT NULL,
INPUT_AUDIO_MAX VARCHAR2(256) NOT NULL,
OUTPUT_AUDIO_MIN VARCHAR2(256) NOT NULL,
OUTPUT_AUDIO_MAX VARCHAR2(256) NOT NULL,
INPUT_COM_MIN VARCHAR2(256) NOT NULL,
INPUT_COM_MAX VARCHAR2(256) NOT NULL,
OUTPUT_COM_MIN VARCHAR2(256) NOT NULL,
OUTPUT_COM_MAX VARCHAR2(256) NOT NULL,
INPUT_DRIVE_MIN VARCHAR2(256) NOT NULL,
INPUT_DRIVE_MAX VARCHAR2(256) NOT NULL,
OUTPUT_DRIVE_MIN VARCHAR2(256) NOT NULL,
OUTPUT_DRIVE_MAX VARCHAR2(256) NOT NULL,
INPUT_HDX_MIN VARCHAR2(256) NOT NULL,
INPUT_HDX_MAX VARCHAR2(256) NOT NULL,
OUTPUT_HDX_MIN VARCHAR2(256) NOT NULL,
OUTPUT_HDX_MAX VARCHAR2(256) NOT NULL,
INPUT_PRINTER_MIN VARCHAR2(256) NOT NULL,
INPUT_PRINTER_MAX VARCHAR2(256) NOT NULL,
OUTPUT_PRINTER_MIN VARCHAR2(256) NOT NULL,
OUTPUT_PRINTER_MAX VARCHAR2(256) NOT NULL,
INPUT_DATA_MIN VARCHAR2(256) NOT NULL,
INPUT_DATA_MAX VARCHAR2(256) NOT NULL,
OUTPUT_DATA_MIN VARCHAR2(256) NOT NULL,
OUTPUT_DATA_MAX VARCHAR2(256) NOT NULL,
INPUT_MULTI_MIN VARCHAR2(256) NOT NULL,
INPUT_MULTI_MAX VARCHAR2(256) NOT NULL,
OUTPUT_MULTI_MIN VARCHAR2(256) NOT NULL,
OUTPUT_MULTI_MAX VARCHAR2(256) NOT NULL,
INPUT_USB_MIN VARCHAR2(256) NOT NULL,
INPUT_USB_MAX VARCHAR2(256) NOT NULL,
OUTPUT_USB_MIN VARCHAR2(256) NOT NULL,
OUTPUT_USB_MAX VARCHAR2(256) NOT NULL,
CPU_UTIL_TIME_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_TIME_MAX VARCHAR2(256) NOT NULL,
BANDWIDTH_USAGE_MIN VARCHAR2(256) NOT NULL,
BANDWIDTH_USAGE_MAX VARCHAR2(256) NOT NULL,
INPUT_THINWIRE_MIN VARCHAR2(256) NOT NULL,
INPUT_THINWIRE_MAX VARCHAR2(256) NOT NULL,
OUTPUT_THINWIRE_MIN VARCHAR2(256) NOT NULL,
OUTPUT_THINWIRE_MAX VARCHAR2(256) NOT NULL,
INPUT_SEAMLESS_MIN VARCHAR2(256) NOT NULL,
INPUT_SEAMLESS_MAX VARCHAR2(256) NOT NULL,
OUTPUT_SEAMLESS_MIN VARCHAR2(256) NOT NULL,
OUTPUT_SEAMLESS_MAX VARCHAR2(256) NOT NULL,
RESOURCE_SHARES_MIN VARCHAR2(256) NOT NULL,
RESOURCE_SHARES_MAX VARCHAR2(256) NOT NULL,
TOTAL_SESSION_DURATION_MIN VARCHAR2(256) NOT NULL,
TOTAL_SESSION_DURATION_MAX VARCHAR2(256) NOT NULL,
IDLE_TIME_MEASUREPRD_MIN VARCHAR2(256) NOT NULL,
IDLE_TIME_MEASUREPRD_MAX VARCHAR2(256) NOT NULL,
IDLE_TIME_DURATION_MIN VARCHAR2(256) NOT NULL,
IDLE_TIME_DURATION_MAX VARCHAR2(256) NOT NULL,
TOTAL_IDLE_DURATION_MIN VARCHAR2(256) NOT NULL,
TOTAL_IDLE_DURATION_MAX VARCHAR2(256) NOT NULL,
TOTAL_BANDWIDTH_MIN VARCHAR2(256) NOT NULL,
TOTAL_BANDWIDTH_MAX VARCHAR2(256) NOT NULL,
MEMORY_USED_MIN VARCHAR2(256) NOT NULL,
MEMORY_USED_MAX VARCHAR2(256) NOT NULL,
PROCESS_COUNT_MIN VARCHAR2(256) NOT NULL,
PROCESS_COUNT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE CtxXpUserTest_THRESH ADD constraint PK_CtxXpUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxXpUserTest_THRESH ON CtxXpUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxMfUserTest CASCADE CONSTRAINTS;
CREATE TABLE CtxMfUserTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NO_OF_SESSIONS Number(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar2(32) NOT NULL,
USER_PROCESSOR_TIME Number(20,4) NOT NULL,
USER_PROCESSOR_TIME_ST varchar2(32) NOT NULL,
MEM_UTIL Number(20,4) NOT NULL,
MEM_UTIL_ST varchar2(32) NOT NULL,
INPUT_BYTES Number(20,4) NOT NULL,
INPUT_BYTES_ST varchar2(32) NOT NULL,
INPUT_ERRORS Number(20,4) NOT NULL,
INPUT_ERRORS_ST varchar2(32) NOT NULL,
OUTPUT_BYTES Number(20,4) NOT NULL,
OUTPUT_BYTES_ST varchar2(32) NOT NULL,
OUTPUT_ERRORS Number(20,4) NOT NULL,
OUTPUT_ERRORS_ST varchar2(32) NOT NULL
);

ALTER TABLE CtxMfUserTest ADD constraint PK_CtxMfUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxMfUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxMfUserTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NO_OF_SESSIONS_MIN Number(20,4) NOT NULL,
NO_OF_SESSIONS_MAX Number(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar2(32) NOT NULL,
USER_PROCESSOR_TIME_MIN Number(20,4) NOT NULL,
USER_PROCESSOR_TIME_MAX Number(20,4) NOT NULL,
USER_PROCESSOR_TIME_STCNT varchar2(32) NOT NULL,
MEM_UTIL_MIN Number(20,4) NOT NULL,
MEM_UTIL_MAX Number(20,4) NOT NULL,
MEM_UTIL_STCNT varchar2(32) NOT NULL,
INPUT_BYTES_MIN Number(20,4) NOT NULL,
INPUT_BYTES_MAX Number(20,4) NOT NULL,
INPUT_BYTES_STCNT varchar2(32) NOT NULL,
INPUT_ERRORS_MIN Number(20,4) NOT NULL,
INPUT_ERRORS_MAX Number(20,4) NOT NULL,
INPUT_ERRORS_STCNT varchar2(32) NOT NULL,
OUTPUT_BYTES_MIN Number(20,4) NOT NULL,
OUTPUT_BYTES_MAX Number(20,4) NOT NULL,
OUTPUT_BYTES_STCNT varchar2(32) NOT NULL,
OUTPUT_ERRORS_MIN Number(20,4) NOT NULL,
OUTPUT_ERRORS_MAX Number(20,4) NOT NULL,
OUTPUT_ERRORS_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxMfUserTest_TREND ADD constraint PK_CtxMfUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxMfUserTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NO_OF_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
USER_PROCESSOR_TIME_MIN	VARCHAR2(256)	 NOT NULL,
USER_PROCESSOR_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_BYTES_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_BYTES_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_BYTES_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_BYTES_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxMfUserTest_THRESH ADD constraint PK_CtxMfUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfUserTest_THRESH ON CtxMfUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE report_info CASCADE CONSTRAINTS;

CREATE TABLE report_info(rept_id VARCHAR2(16),
rept_name VARCHAR2(256),
rept_type VARCHAR2(32));

ALTER TABLE report_info ADD constraint PK_report_info
 primary key(rept_id);

INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d1','DeepHome','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d2','DeepSegments','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d3','DeepComptypes','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d4','DeepSites','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d5','DeepCompnamesLayers','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d6','DeepLayersTests','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d7','DeepTestsMeasures','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErMacroDetails','Detailed Graph of infrastructure health','Macro');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErMacroHome','Details of Infrastructure states','Macro');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErQuick','Infrastructure State Quick','Quick');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Measure','Measure Graph','RepoLite');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Summary','Summary Graph','RepoLite');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Comparison','Comparison Graphs','RepoLite');

DROP table user_report CASCADE CONSTRAINTS;

CREATE TABLE user_report(
user_rept_id Number(20,4) NOT NULL,
user_rept_name VARCHAR2(200) NOT NULL,
user_id VARCHAR2(256) NOT NULL,
rept_time DATE NOT NULL);
CREATE INDEX IDX1_USER_REPORT ON USER_REPORT(USER_ID);
ALTER TABLE user_report ADD constraint PK_user_report
primary key(user_rept_id);


DROP table user_rept_info CASCADE CONSTRAINTS;

CREATE TABLE  user_rept_info(
user_rept_id NUMBER(16) NOT NULL,
rept_param VARCHAR2(128) NOT NULL,
rept_value VARCHAR2(1024));

ALTER TABLE user_rept_info ADD constraint FK_user_rept_info
foreign key(user_rept_id) references user_report(user_rept_id) ON DELETE CASCADE;
DROP TABLE report_share CASCADE CONSTRAINTS;

CREATE TABLE report_share (user_rept_id NUMBER(16),
user_id VARCHAR2(256));

ALTER TABLE report_share ADD constraint FK_report_share_1
 foreign key(user_rept_id) references user_report(user_rept_id) ON DELETE CASCADE;

ALTER TABLE report_share ADD constraint FK_report_share_2
 foreign key(user_id) references user_info(user_id) ON DELETE CASCADE;
 
 DROP TABLE schedule_info CASCADE CONSTRAINTS;
 
CREATE TABLE schedule_info(
schedule_id NUMBER(16),
user_id VARCHAR2(256) NOT NULL,
schedule_name VARCHAR2(200) NOT NULL,
mail_frequency VARCHAR2(512),
print_frequency VARCHAR2(32),
creation_time DATE NOT NULL,
mail_id VARCHAR2(512),
schedule_booklet_id VARCHAR2(256));

ALTER TABLE schedule_info ADD constraint PK_schedule_info
primary key(schedule_id);


DROP TABLE schedule_detail CASCADE CONSTRAINTS;

CREATE TABLE  schedule_detail(
schedule_id NUMBER(16) NOT NULL,
schedule_param VARCHAR2(128) NOT NULL,
schedule_value VARCHAR2(1024));

ALTER TABLE schedule_detail ADD constraint FK_schedule_detail
foreign key(schedule_id) references schedule_info(schedule_id) ON DELETE CASCADE;
DROP TABLE onetime_schedule_info CASCADE CONSTRAINTS;

CREATE TABLE onetime_schedule_info(
onetime_schedule_id VARCHAR2(128) NOT NULL,
onetime_user_id VARCHAR2(256) NOT NULL,
onetime_bgreport_name VARCHAR2(32) NOT NULL,
onetime_bgreport_from VARCHAR2(100) NOT NULL,
onetime_status VARCHAR2(32) NOT NULL,
onetime_timeline VARCHAR2(32) NOT NULL,
onetime_startDate DATE,
onetime_endDate DATE,
creation_time DATE NOT NULL);

ALTER TABLE onetime_schedule_info ADD constraint PK_onetime_schedule_info
primary key(onetime_schedule_id);





DROP TABLE onetime_schedule_detail CASCADE CONSTRAINTS;

CREATE TABLE  onetime_schedule_detail(
onetime_schedule_id VARCHAR2(128) NOT NULL,
onetime_schedule_param VARCHAR2(128) NOT NULL,
onetime_schedule_value VARCHAR2(256));

ALTER TABLE onetime_schedule_detail ADD constraint FK_onetime_schedule_detail
foreign key(onetime_schedule_id) references onetime_schedule_info(onetime_schedule_id) ON DELETE CASCADE;

DROP TABLE BOOKLET_GROUP_INFO CASCADE CONSTRAINTS;

CREATE TABLE BOOKLET_GROUP_INFO(
BOOKLET_ID NUMBER(16) NOT NULL,
USER_ID VARCHAR2(256) NOT NULL,
BOOKLET_NAME VARCHAR2(200) NOT NULL,
REPORT_ORDER VARCHAR2(100) NOT NULL,
STATUS VARCHAR2(32) NOT NULL,
REPORT_FORMATE VARCHAR2(32) NOT NULL,
CREATED_DATE DATE  NOT NULL,
DESCRIPTION VARCHAR2(256));

ALTER TABLE BOOKLET_GROUP_INFO ADD constraint PK_BOOKLET_GROUP_INFO
primary key(BOOKLET_ID);

DROP TABLE BOOKLET_REPORT_INFO CASCADE CONSTRAINTS;
CREATE TABLE BOOKLET_REPORT_INFO(
REPORT_ID NUMBER(16) NOT NULL, 
BOOKLET_ID NUMBER(16) NOT NULL, 
REPORT_NAME VARCHAR2(200) NOT NULL);

ALTER TABLE BOOKLET_REPORT_INFO ADD constraint PK_BOOKLET_REPORT_INFO
primary key(REPORT_ID);

DROP TABLE BOOKLET_REPORT_PARAMETER_INFO CASCADE CONSTRAINTS;
CREATE TABLE BOOKLET_REPORT_PARAMETER_INFO(
REPORT_ID NUMBER(16) NOT NULL, 
PARAMETER_NAME  VARCHAR2(256) NOT NULL,
PARAMETER_VALUE VARCHAR2(256));

DROP table SCHEDULE_BOOKLET_INFO CASCADE CONSTRAINTS;
 CREATE TABLE SCHEDULE_BOOKLET_INFO 
	(SCHEDULE_BOOKLET_ID NUMBER(16) NOT NULL,
	USER_ID VARCHAR2(256) NOT NULL,
	SCHEDULE_BOOKLET_NAME VARCHAR2(200) NOT NULL,
	MAIL_FREQUENCY VARCHAR2(512),
	MAIL_ID VARCHAR2(256),
	CREATED_DATE DATE NOT NULL,
	IS_ANYTIME_SCHEDULE VARCHAR2(256),
	NEED_TO_MERGE VARCHAR2(256) DEFAULT 'no');

ALTER TABLE SCHEDULE_BOOKLET_INFO ADD constraint PK_SCHEDULE_BOOKLET_INFO
primary key(SCHEDULE_BOOKLET_ID);


DROP TABLE report_state_summary CASCADE CONSTRAINTS;

CREATE TABLE  report_state_summary(
comp_name VARCHAR2(64),
comp_type VARCHAR2(32),
site_name VARCHAR2(64),
segment_name VARCHAR2(64),
layer_name VARCHAR2(64),
summ_date DATE,
component VARCHAR2(128),
durn_good NUMBER(20,4),
durn_high NUMBER(20,4),
durn_medium NUMBER(20,4),
durn_low NUMBER(20,4),
durn_unknown NUMBER(20,4),
cnt_high NUMBER(16),
cnt_medium NUMBER(16),
cnt_low NUMBER(16),
cnt_unknown NUMBER(16),
dcnt_high NUMBER(16),
dcnt_medium NUMBER(16),
dcnt_low NUMBER(16),
dcnt_unknown NUMBER(16));

ALTER TABLE report_state_summary ADD CONSTRAINT pk_report_state_summary 
PRIMARY KEY(comp_name,comp_type,site_name,segment_name,layer_name,summ_date);

create unique index IDX_REPORT_STATE_SUMMMARY  on report_state_summary (component,site_name,segment_name,layer_name,summ_date);
CREATE INDEX IDX1_REPORT_STATE_SUMMARY ON REPORT_STATE_SUMMARY(SUMM_DATE, DURN_HIGH, DURN_MEDIUM, DURN_LOW, DURN_UNKNOWN, CNT_HIGH ,CNT_MEDIUM, CNT_LOW);
CREATE INDEX IDX2_REPORT_STATE_SUMMARY ON REPORT_STATE_SUMMARY(SITE_NAME, SEGMENT_NAME, LAYER_NAME, SUMM_DATE, COMPONENT);

DROP TABLE CiscoBufferTest CASCADE CONSTRAINTS;
CREATE TABLE CiscoBufferTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	NO_MEM_ERRORS Number(20,4) NOT NULL,
	NO_MEM_ERRORS_ST varchar2(32) NOT NULL,
	SMALL_BUFFER_MISSES Number(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_ST varchar2(32) NOT NULL,
	MEDIUM_BUFFER_MISSES Number(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_ST varchar2(32) NOT NULL,
	BIG_BUFFER_MISSES Number(20,4) NOT NULL,
	BIG_BUFFER_MISSES_ST varchar2(32) NOT NULL,
	LARGE_BUFFER_MISSES Number(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_ST varchar2(32) NOT NULL,
	HUGE_BUFFER_MISSES Number(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_ST varchar2(32) NOT NULL,
	BUFFER_HITS     Number(20,4) NOT NULL,
	BUFFER_HITS_ST  varchar2(32) NOT NULL);

ALTER TABLE CiscoBufferTest ADD constraint PK_CiscoBufferTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CiscoBufferTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CiscoBufferTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	NO_MEM_ERRORS_MIN Number(20,4) NOT NULL,
	NO_MEM_ERRORS_MAX Number(20,4) NOT NULL,
	NO_MEM_ERRORS_STCNT varchar2(32) NOT NULL,
	SMALL_BUFFER_MISSES_MIN Number(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_MAX Number(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_STCNT varchar2(32) NOT NULL,
	MEDIUM_BUFFER_MISSES_MIN Number(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_MAX Number(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_STCNT varchar2(32) NOT NULL,
	BIG_BUFFER_MISSES_MIN Number(20,4) NOT NULL,
	BIG_BUFFER_MISSES_MAX Number(20,4) NOT NULL,
	BIG_BUFFER_MISSES_STCNT varchar2(32) NOT NULL,
	LARGE_BUFFER_MISSES_MIN Number(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_MAX Number(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_STCNT varchar2(32) NOT NULL,
	HUGE_BUFFER_MISSES_MIN Number(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_MAX Number(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_STCNT varchar2(32) NOT NULL,
	BUFFER_HITS_MIN         Number(20,4) NOT NULL,
	BUFFER_HITS_MAX        Number(20,4) NOT NULL,
	BUFFER_HITS_STCNT    varchar2(32) NOT NULL);
		
ALTER TABLE CiscoBufferTest_TREND ADD constraint PK_CiscoBufferTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CiscoBufferTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CiscoBufferTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	NO_MEM_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	NO_MEM_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	SMALL_BUFFER_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	SMALL_BUFFER_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	MEDIUM_BUFFER_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	MEDIUM_BUFFER_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	BIG_BUFFER_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	BIG_BUFFER_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	LARGE_BUFFER_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	LARGE_BUFFER_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	HUGE_BUFFER_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	HUGE_BUFFER_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	BUFFER_HITS_MIN VARCHAR2(256)	 NOT NULL,
	BUFFER_HITS_MAX  VARCHAR2(256)	 NOT NULL);
	
ALTER TABLE CiscoBufferTest_THRESH ADD constraint PK_CiscoBufferTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CiscoBufferTest_THRESH ON CiscoBufferTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CiscoInterfaceTest CASCADE CONSTRAINTS;

CREATE TABLE CiscoInterfaceTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	RELIABILITY_VALUE Number(20,4) NOT NULL,
	RELIABILITY_VALUE_ST varchar2(32) NOT NULL,
	RELIABILITY_PCT Number(20,4) NOT NULL,
	RELIABILITY_PCT_ST varchar2(32) NOT NULL,
	DELAY Number(20,4) NOT NULL,
	DELAY_ST varchar2(32) NOT NULL,
	LOAD_FACTOR Number(20,4) NOT NULL,
	LOAD_FACTOR_ST varchar2(32) NOT NULL,
	DATA_RECVD_RATE Number(20,4) NOT NULL,
	DATA_RECVD_RATE_ST varchar2(32) NOT NULL,
	DATA_XMIT_RATE Number(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
	IN_QUEUE_DROPS Number(20,4) NOT NULL,
	IN_QUEUE_DROPS_ST varchar2(32) NOT NULL,
	OUT_QUEUE_DROPS Number(20,4) NOT NULL,
	OUT_QUEUE_DROPS_ST varchar2(32) NOT NULL,
	NUM_RESETS Number(20,4) NOT NULL,
	NUM_RESETS_ST varchar2(32) NOT NULL,
	NUM_RESTARTS Number(20,4) NOT NULL,
	NUM_RESTARTS_ST varchar2(32) NOT NULL,
	NUM_CRC_ERRORS Number(20,4) NOT NULL,
	NUM_CRC_ERRORS_ST varchar2(32) NOT NULL,
	NUM_ABORTS Number(20,4) NOT NULL,
	NUM_ABORTS_ST varchar2(32) NOT NULL,
	NUM_COLLISIONS Number(20,4) NOT NULL,
	NUM_COLLISIONS_ST varchar2(32) NOT NULL,
	SLOW_PACKETS_IN     NUMBER(20,4)    NOT NULL,
	SLOW_PACKETS_IN_ST   VARCHAR2(32)    NOT NULL,
	SLOW_PACKETS_OUT   NUMBER(20,4)    NOT NULL,
	SLOW_PACKETS_OUT_ST VARCHAR2(32)    NOT NULL,
	LINK_PROTOCOL	NUMBER(20,4)    NOT NULL,	
	LINK_PROTOCOL_ST VARCHAR2(32)    NOT NULL);

ALTER TABLE CiscoInterfaceTest ADD constraint PK_CiscoInterfaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CiscoInterfaceTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CiscoInterfaceTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	RELIABILITY_VALUE_MIN Number(20,4) NOT NULL,
	RELIABILITY_VALUE_MAX Number(20,4) NOT NULL,
	RELIABILITY_VALUE_STCNT varchar2(32) NOT NULL,
	RELIABILITY_PCT_MIN Number(20,4) NOT NULL,
	RELIABILITY_PCT_MAX Number(20,4) NOT NULL,
	RELIABILITY_PCT_STCNT varchar2(32) NOT NULL,
	DELAY_MIN Number(20,4) NOT NULL,
	DELAY_MAX Number(20,4) NOT NULL,
	DELAY_STCNT varchar2(32) NOT NULL,
	LOAD_FACTOR_MIN Number(20,4) NOT NULL,
	LOAD_FACTOR_MAX Number(20,4) NOT NULL,
	LOAD_FACTOR_STCNT varchar2(32) NOT NULL,
	DATA_RECVD_RATE_MIN Number(20,4) NOT NULL,
	DATA_RECVD_RATE_MAX Number(20,4) NOT NULL,
	DATA_RECVD_RATE_STCNT varchar2(32) NOT NULL,
	DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
	IN_QUEUE_DROPS_MIN Number(20,4) NOT NULL,
	IN_QUEUE_DROPS_MAX Number(20,4) NOT NULL,
	IN_QUEUE_DROPS_STCNT varchar2(32) NOT NULL,
	OUT_QUEUE_DROPS_MIN Number(20,4) NOT NULL,
	OUT_QUEUE_DROPS_MAX Number(20,4) NOT NULL,
	OUT_QUEUE_DROPS_STCNT varchar2(32) NOT NULL,
	NUM_RESETS_MIN Number(20,4) NOT NULL,
	NUM_RESETS_MAX Number(20,4) NOT NULL,
	NUM_RESETS_STCNT varchar2(32) NOT NULL,
	NUM_RESTARTS_MIN Number(20,4) NOT NULL,
	NUM_RESTARTS_MAX Number(20,4) NOT NULL,
	NUM_RESTARTS_STCNT varchar2(32) NOT NULL,
	NUM_CRC_ERRORS_MIN Number(20,4) NOT NULL,
	NUM_CRC_ERRORS_MAX Number(20,4) NOT NULL,
	NUM_CRC_ERRORS_STCNT varchar2(32) NOT NULL,
	NUM_ABORTS_MIN Number(20,4) NOT NULL,
	NUM_ABORTS_MAX Number(20,4) NOT NULL,
	NUM_ABORTS_STCNT varchar2(32) NOT NULL,
	NUM_COLLISIONS_MIN Number(20,4) NOT NULL,
	NUM_COLLISIONS_MAX Number(20,4) NOT NULL,
	NUM_COLLISIONS_STCNT varchar2(32) NOT NULL,
	SLOW_PACKETS_IN_MIN		NUMBER(20,4)	NOT NULL,
	SLOW_PACKETS_IN_MAX		NUMBER(20,4)	NOT NULL,
	SLOW_PACKETS_IN_STCNT		VARCHAR2(32) 	NOT NULL,
	SLOW_PACKETS_OUT_MIN		NUMBER(20,4)	NOT NULL,
	SLOW_PACKETS_OUT_MAX		NUMBER(20,4)	NOT NULL,
	SLOW_PACKETS_OUT_STCNT		VARCHAR2(32) 	NOT NULL,
	LINK_PROTOCOL_MIN		NUMBER(20,4)	NOT NULL,
	LINK_PROTOCOL_MAX		NUMBER(20,4)	NOT NULL,
	LINK_PROTOCOL_STCNT		VARCHAR2(32) 	NOT NULL);

ALTER TABLE CiscoInterfaceTest_TREND ADD constraint PK_CiscoInterfaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoInterfaceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CiscoInterfaceTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	RELIABILITY_VALUE_MIN	VARCHAR2(256)	 NOT NULL,
	RELIABILITY_VALUE_MAX	VARCHAR2(256)	 NOT NULL,
	RELIABILITY_PCT_MIN	VARCHAR2(256)	 NOT NULL,
	RELIABILITY_PCT_MAX	VARCHAR2(256)	 NOT NULL,
	DELAY_MIN	VARCHAR2(256)	 NOT NULL,
	DELAY_MAX	VARCHAR2(256)	 NOT NULL,
	LOAD_FACTOR_MIN	VARCHAR2(256)	 NOT NULL,
	LOAD_FACTOR_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_RECVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_RECVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	IN_QUEUE_DROPS_MIN	VARCHAR2(256)	 NOT NULL,
	IN_QUEUE_DROPS_MAX	VARCHAR2(256)	 NOT NULL,
	OUT_QUEUE_DROPS_MIN	VARCHAR2(256)	 NOT NULL,
	OUT_QUEUE_DROPS_MAX	VARCHAR2(256)	 NOT NULL,
	NUM_RESETS_MIN	VARCHAR2(256)	 NOT NULL,
	NUM_RESETS_MAX	VARCHAR2(256)	 NOT NULL,
	NUM_RESTARTS_MIN	VARCHAR2(256)	 NOT NULL,
	NUM_RESTARTS_MAX	VARCHAR2(256)	 NOT NULL,
	NUM_CRC_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	NUM_CRC_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	NUM_ABORTS_MIN	VARCHAR2(256)	 NOT NULL,
	NUM_ABORTS_MAX	VARCHAR2(256)	 NOT NULL,
	NUM_COLLISIONS_MIN	VARCHAR2(256)	 NOT NULL,
	NUM_COLLISIONS_MAX	VARCHAR2(256)	 NOT NULL,
	SLOW_PACKETS_IN_MIN	VARCHAR2(256)	    NOT NULL,
	SLOW_PACKETS_IN_MAX	VARCHAR2(256)	    NOT NULL,
	SLOW_PACKETS_OUT_MIN	VARCHAR2(256)	    NOT NULL,
	SLOW_PACKETS_OUT_MAX	VARCHAR2(256)	    NOT NULL,
	LINK_PROTOCOL_MIN	VARCHAR2(256)	    NOT NULL,
	LINK_PROTOCOL_MAX	VARCHAR2(256)	    NOT NULL);

ALTER TABLE CiscoInterfaceTest_THRESH ADD constraint PK_CiscoInterfaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CiscoInterfaceTest_THRESH ON CiscoInterfaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE WinSessionTest CASCADE CONSTRAINTS;

CREATE TABLE WinSessionTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	LOGON_RATE Number(20,4) NOT NULL,
	LOGON_RATE_ST varchar2(32) NOT NULL,
	LOGON_ERRORS Number(20,4) NOT NULL,
	LOGON_ERRORS_ST varchar2(32) NOT NULL,
	CURRENT_SESSIONS Number(20,4) NOT NULL,
	CURRENT_SESSIONS_ST varchar2(32) NOT NULL,
	SESSIONS_WITH_ERRORS Number(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_ST varchar2(32) NOT NULL,
	SESSIONS_FORCED_OFF Number(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_ST varchar2(32) NOT NULL,
	SESSIONS_LOGGED_OFF Number(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_ST varchar2(32) NOT NULL,
	SESSIONS_TIMED_OUT Number(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_ST varchar2(32) NOT NULL);

ALTER TABLE WinSessionTest ADD constraint PK_WinSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WinSessionTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WinSessionTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	LOGON_RATE_MIN Number(20,4) NOT NULL,
	LOGON_RATE_MAX Number(20,4) NOT NULL,
	LOGON_RATE_STCNT varchar2(32) NOT NULL,
	LOGON_ERRORS_MIN Number(20,4) NOT NULL,
	LOGON_ERRORS_MAX Number(20,4) NOT NULL,
	LOGON_ERRORS_STCNT varchar2(32) NOT NULL,
	CURRENT_SESSIONS_MIN Number(20,4) NOT NULL,
	CURRENT_SESSIONS_MAX Number(20,4) NOT NULL,
	CURRENT_SESSIONS_STCNT varchar2(32) NOT NULL,
	SESSIONS_WITH_ERRORS_MIN Number(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_MAX Number(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_STCNT varchar2(32) NOT NULL,
	SESSIONS_FORCED_OFF_MIN Number(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_MAX Number(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_STCNT varchar2(32) NOT NULL,
	SESSIONS_LOGGED_OFF_MIN Number(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_MAX Number(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_STCNT varchar2(32) NOT NULL,
	SESSIONS_TIMED_OUT_MIN Number(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_MAX Number(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_STCNT varchar2(32) NOT NULL);

ALTER TABLE WinSessionTest_TREND ADD constraint PK_WinSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinSessionTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WinSessionTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	LOGON_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	LOGON_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	LOGON_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	LOGON_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
	SESSIONS_WITH_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	SESSIONS_WITH_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	SESSIONS_FORCED_OFF_MIN	VARCHAR2(256)	 NOT NULL,
	SESSIONS_FORCED_OFF_MAX	VARCHAR2(256)	 NOT NULL,
	SESSIONS_LOGGED_OFF_MIN	VARCHAR2(256)	 NOT NULL,
	SESSIONS_LOGGED_OFF_MAX	VARCHAR2(256)	 NOT NULL,
	SESSIONS_TIMED_OUT_MIN	VARCHAR2(256)	 NOT NULL,
	SESSIONS_TIMED_OUT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE WinSessionTest_THRESH ADD constraint PK_WinSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WinSessionTest_THRESH ON WinSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinAccessTest CASCADE CONSTRAINTS;
CREATE TABLE WinAccessTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	BLOCKING_REQ_REJECTS Number(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_ST varchar2(32) NOT NULL,
	PERMISSION_ERRORS Number(20,4) NOT NULL,
	PERMISSION_ERRORS_ST varchar2(32) NOT NULL,
	FILE_ACCESS_DENIED Number(20,4) NOT NULL,
	FILE_ACCESS_DENIED_ST varchar2(32) NOT NULL,
	INTERNAL_SERVER_ERRORS Number(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_ST varchar2(32) NOT NULL,
	DATA_RCVD_RATE Number(20,4) NOT NULL,
	DATA_RCVD_RATE_ST varchar2(32) NOT NULL,
	DATA_XMIT_RATE Number(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
	RESOURCE_SHORT Number(20,4) NOT NULL,
	RESOURCE_SHORT_ST varchar2(32) NOT NULL,
	RESP_TIME Number(20,4) NOT NULL,
	RESP_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE WinAccessTest ADD constraint PK_WinAccessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE WinAccessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE WinAccessTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	BLOCKING_REQ_REJECTS_MIN Number(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_MAX Number(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_STCNT varchar2(32) NOT NULL,
	PERMISSION_ERRORS_MIN Number(20,4) NOT NULL,
	PERMISSION_ERRORS_MAX Number(20,4) NOT NULL,
	PERMISSION_ERRORS_STCNT varchar2(32) NOT NULL,
	FILE_ACCESS_DENIED_MIN Number(20,4) NOT NULL,
	FILE_ACCESS_DENIED_MAX Number(20,4) NOT NULL,
	FILE_ACCESS_DENIED_STCNT varchar2(32) NOT NULL,
	INTERNAL_SERVER_ERRORS_MIN Number(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_MAX Number(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_STCNT varchar2(32) NOT NULL,
	DATA_RCVD_RATE_MIN Number(20,4) NOT NULL,
	DATA_RCVD_RATE_MAX Number(20,4) NOT NULL,
	DATA_RCVD_RATE_STCNT varchar2(32) NOT NULL,
	DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
	RESOURCE_SHORT_MIN Number(20,4) NOT NULL,
	RESOURCE_SHORT_MAX Number(20,4) NOT NULL,
	RESOURCE_SHORT_STCNT varchar2(32) NOT NULL,
	RESP_TIME_MIN      Number(20,4) NOT NULL,
	RESP_TIME_MAX	   Number(20,4) NOT NULL,
    RESP_TIME_STCNT    varchar2(32) NOT NULL
);

ALTER TABLE WinAccessTest_TREND ADD constraint PK_WinAccessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinAccessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WinAccessTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	BLOCKING_REQ_REJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	BLOCKING_REQ_REJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	PERMISSION_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	PERMISSION_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	FILE_ACCESS_DENIED_MIN	VARCHAR2(256)	 NOT NULL,
	FILE_ACCESS_DENIED_MAX	VARCHAR2(256)	 NOT NULL,
	INTERNAL_SERVER_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	INTERNAL_SERVER_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_RCVD_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	RESOURCE_SHORT_MIN	VARCHAR2(256)	 NOT NULL,
	RESOURCE_SHORT_MAX	VARCHAR2(256)	 NOT NULL,
	RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL
);

ALTER TABLE WinAccessTest_THRESH ADD constraint PK_WinAccessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinAccessTest_THRESH ON WinAccessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinDnsTest CASCADE CONSTRAINTS;

CREATE TABLE WinDnsTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	TOTAL_QUERIES Number(20,4) NOT NULL,
	TOTAL_QUERIES_ST varchar2(32) NOT NULL,
	TOTAL_RESPONSES Number(20,4) NOT NULL,
	TOTAL_RESPONSES_ST varchar2(32) NOT NULL,
	RECURSIVE_QUERIES Number(20,4) NOT NULL,
	RECURSIVE_QUERIES_ST varchar2(32) NOT NULL,
	RECURSIVE_QUERY_FAILURES Number(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_ST varchar2(32) NOT NULL,
	RECURSIVE_TIMEOUTS Number(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_ST varchar2(32) NOT NULL,
	ZONE_XFERS_RCVD Number(20,4) NOT NULL,
	ZONE_XFERS_RCVD_ST varchar2(32) NOT NULL,
	ZONE_XFERS_FAILED Number(20,4) NOT NULL,
	ZONE_XFERS_FAILED_ST varchar2(32) NOT NULL);

ALTER TABLE WinDnsTest ADD constraint PK_WinDnsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WinDnsTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WinDnsTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	TOTAL_QUERIES_MIN Number(20,4) NOT NULL,
	TOTAL_QUERIES_MAX Number(20,4) NOT NULL,
	TOTAL_QUERIES_STCNT varchar2(32) NOT NULL,
	TOTAL_RESPONSES_MIN Number(20,4) NOT NULL,
	TOTAL_RESPONSES_MAX Number(20,4) NOT NULL,
	TOTAL_RESPONSES_STCNT varchar2(32) NOT NULL,
	RECURSIVE_QUERIES_MIN Number(20,4) NOT NULL,
	RECURSIVE_QUERIES_MAX Number(20,4) NOT NULL,
	RECURSIVE_QUERIES_STCNT varchar2(32) NOT NULL,
	RECURSIVE_QUERY_FAILURES_MIN Number(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_MAX Number(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_STCNT varchar2(32) NOT NULL,
	RECURSIVE_TIMEOUTS_MIN Number(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_MAX Number(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_STCNT varchar2(32) NOT NULL,
	ZONE_XFERS_RCVD_MIN Number(20,4) NOT NULL,
	ZONE_XFERS_RCVD_MAX Number(20,4) NOT NULL,
	ZONE_XFERS_RCVD_STCNT varchar2(32) NOT NULL,
	ZONE_XFERS_FAILED_MIN Number(20,4) NOT NULL,
	ZONE_XFERS_FAILED_MAX Number(20,4) NOT NULL,
	ZONE_XFERS_FAILED_STCNT varchar2(32) NOT NULL);

ALTER TABLE WinDnsTest_TREND ADD constraint PK_WinDnsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinDnsTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WinDnsTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128)
	,MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	TOTAL_QUERIES_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_QUERIES_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_RESPONSES_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_RESPONSES_MAX	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_QUERIES_MIN	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_QUERIES_MAX	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_QUERY_FAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_QUERY_FAILURES_MAX	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_TIMEOUTS_MIN	VARCHAR2(256)	 NOT NULL,
	RECURSIVE_TIMEOUTS_MAX	VARCHAR2(256)	 NOT NULL,
	ZONE_XFERS_RCVD_MIN	VARCHAR2(256)	 NOT NULL,
	ZONE_XFERS_RCVD_MAX	VARCHAR2(256)	 NOT NULL,
	ZONE_XFERS_FAILED_MIN	VARCHAR2(256)	 NOT NULL,
	ZONE_XFERS_FAILED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE WinDnsTest_THRESH ADD constraint PK_WinDnsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WinDnsTest_THRESH ON WinDnsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxLicenseTest CASCADE CONSTRAINTS;

CREATE TABLE CtxLicenseTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	POOL_LICENSES_IN_USE Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_ST varchar2(32) NOT NULL);

ALTER TABLE CtxLicenseTest ADD constraint PK_CtxLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CtxLicenseTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CtxLicenseTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	POOL_LICENSES_IN_USE_MIN Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_MAX Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxLicenseTest_TREND ADD constraint PK_CtxLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxLicenseTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CtxLicenseTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	POOL_LICENSES_IN_USE_MIN	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_IN_USE_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxLicenseTest_THRESH ADD constraint PK_CtxLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CtxLicenseTest_THRESH ON CtxLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxConnectionTest CASCADE CONSTRAINTS;

CREATE TABLE CtxConnectionTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	AVAILABILITY Number(20,4) NOT NULL,
	AVAILABILITY_ST varchar2(32) NOT NULL,
	PKT_LOSS_PCT Number(20,4) NOT NULL,
	PKT_LOSS_PCT_ST varchar2(32) NOT NULL,
	AVG_RESPONSE_TIME Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_ST varchar2(32) NOT NULL,
	MAX_RESPONSE_TIME Number(20,4) NOT NULL,
	MAX_RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE CtxConnectionTest ADD constraint PK_CtxConnectionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CtxConnectionTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CtxConnectionTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	AVAILABILITY_MIN Number(20,4) NOT NULL,
	AVAILABILITY_MAX Number(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar2(32) NOT NULL,
	PKT_LOSS_PCT_MIN Number(20,4) NOT NULL,
	PKT_LOSS_PCT_MAX Number(20,4) NOT NULL,
	PKT_LOSS_PCT_STCNT varchar2(32) NOT NULL,
	AVG_RESPONSE_TIME_MIN Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_MAX Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
	MAX_RESPONSE_TIME_MIN Number(20,4) NOT NULL,
	MAX_RESPONSE_TIME_MAX Number(20,4) NOT NULL,
	MAX_RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxConnectionTest_TREND ADD constraint PK_CtxConnectionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxConnectionTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CtxConnectionTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR2(256)	 NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR2(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
	MAX_RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	MAX_RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxConnectionTest_THRESH ADD constraint PK_CtxConnectionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxConnectionTest_THRESH ON CtxConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAuthTest CASCADE CONSTRAINTS;

CREATE TABLE CtxAuthTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	AVAILABILITY Number(20,4) NOT NULL,
	AVAILABILITY_ST varchar2(32) NOT NULL,
	RESPONSE_TIME Number(20,4) NOT NULL,
	RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE CtxAuthTest ADD constraint PK_CtxAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE CtxAuthTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE CtxAuthTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	AVAILABILITY_MIN Number(20,4) NOT NULL,
	AVAILABILITY_MAX Number(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar2(32) NOT NULL,
	RESPONSE_TIME_MIN Number(20,4) NOT NULL,
	RESPONSE_TIME_MAX Number(20,4) NOT NULL,
	RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxAuthTest_TREND ADD constraint PK_CtxAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxAuthTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE CtxAuthTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxAuthTest_THRESH ADD constraint PK_CtxAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAuthTest_THRESH ON CtxAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinAuthTest CASCADE CONSTRAINTS;

CREATE TABLE WinAuthTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	AVAILABILITY Number(20,4) NOT NULL,
	AVAILABILITY_ST varchar2(32) NOT NULL,
	RESPONSE_TIME Number(20,4) NOT NULL,
	RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE WinAuthTest ADD constraint PK_WinAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE WinAuthTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE WinAuthTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	AVAILABILITY_MIN Number(20,4) NOT NULL,
	AVAILABILITY_MAX Number(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar2(32) NOT NULL,
	RESPONSE_TIME_MIN Number(20,4) NOT NULL,
	RESPONSE_TIME_MAX Number(20,4) NOT NULL,
	RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE WinAuthTest_TREND ADD constraint PK_WinAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinAuthTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE WinAuthTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE WinAuthTest_THRESH ADD constraint PK_WinAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinAuthTest_THRESH ON WinAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxFarmLicenseTest CASCADE CONSTRAINTS;
CREATE TABLE CtxFarmLicenseTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	POOL_LICENSES_IN_USE Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_ST varchar2(32) NOT NULL,
	POOL_LICENSES_AVAILABLE Number(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_ST varchar2(32) NOT NULL,
	POOL_LICENSES_USAGE Number(20,4) NOT NULL,
	POOL_LICENSES_USAGE_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_ST varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_ST varchar2(32) NOT NULL);

ALTER TABLE CtxFarmLicenseTest ADD constraint PK_CtxFarmLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxFarmLicenseTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxFarmLicenseTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	POOL_LICENSES_IN_USE_MIN Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_MAX Number(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_STCNT varchar2(32) NOT NULL,
	POOL_LICENSES_AVAILABLE_MIN Number(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_MAX Number(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_STCNT varchar2(32) NOT NULL,
	POOL_LICENSES_USAGE_MIN Number(20,4) NOT NULL,
	POOL_LICENSES_USAGE_MAX Number(20,4) NOT NULL,
	POOL_LICENSES_USAGE_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_STCNT varchar2(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX Number(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxFarmLicenseTest_TREND ADD constraint PK_CtxFarmLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxFarmLicenseTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxFarmLicenseTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	POOL_LICENSES_IN_USE_MIN	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_IN_USE_MAX	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_AVAILABLE_MIN	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_AVAILABLE_MAX	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
	POOL_LICENSES_USAGE_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN	VARCHAR2(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxFarmLicenseTest_THRESH ADD constraint PK_CtxFarmLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxFarmLicenseTest_THRESH ON CtxFarmLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxSrvrTest CASCADE CONSTRAINTS;
CREATE TABLE CtxSrvrTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	DATA_COLLECTION_ENABLED Number(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_ST varchar2(32) NOT NULL,
	SERVER_AVAILABILITY Number(20,4) NOT NULL,
	SERVER_AVAILABILITY_ST varchar2(32) NOT NULL,
	SERVER_LOAD Number(20,4) NOT NULL,
	SERVER_LOAD_ST varchar2(32) NOT NULL);

ALTER TABLE CtxSrvrTest ADD constraint PK_CtxSrvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxSrvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxSrvrTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	DATA_COLLECTION_ENABLED_MIN Number(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_MAX Number(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_STCNT varchar2(32) NOT NULL,
	SERVER_AVAILABILITY_MIN Number(20,4) NOT NULL,
	SERVER_AVAILABILITY_MAX Number(20,4) NOT NULL,
	SERVER_AVAILABILITY_STCNT varchar2(32) NOT NULL,
	SERVER_LOAD_MIN Number(20,4) NOT NULL,
	SERVER_LOAD_MAX Number(20,4) NOT NULL,
	SERVER_LOAD_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxSrvrTest_TREND ADD constraint PK_CtxSrvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxSrvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxSrvrTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	DATA_COLLECTION_ENABLED_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_COLLECTION_ENABLED_MAX	VARCHAR2(256)	 NOT NULL,
	SERVER_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
	SERVER_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
	SERVER_LOAD_MIN	VARCHAR2(256)	 NOT NULL,
	SERVER_LOAD_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxSrvrTest_THRESH ADD constraint PK_CtxSrvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxSrvrTest_THRESH ON CtxSrvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraCursorTest CASCADE CONSTRAINTS;
CREATE TABLE OraCursorTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	CURRENT_OPEN_CURSORS Number(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_ST varchar2(32) NOT NULL,
	PCT_OPEN_CURSORS Number(20,4) NOT NULL,
	PCT_OPEN_CURSORS_ST varchar2(32) NOT NULL);

ALTER TABLE OraCursorTest ADD constraint PK_OraCursorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraCursorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraCursorTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	CURRENT_OPEN_CURSORS_MIN Number(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_MAX Number(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_STCNT varchar2(32) NOT NULL,
	PCT_OPEN_CURSORS_MIN Number(20,4) NOT NULL,
	PCT_OPEN_CURSORS_MAX Number(20,4) NOT NULL,
	PCT_OPEN_CURSORS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraCursorTest_TREND ADD constraint PK_OraCursorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraCursorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraCursorTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	CURRENT_OPEN_CURSORS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRENT_OPEN_CURSORS_MAX	VARCHAR2(256)	 NOT NULL,
	PCT_OPEN_CURSORS_MIN	VARCHAR2(256)	 NOT NULL,
	PCT_OPEN_CURSORS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraCursorTest_THRESH ADD constraint PK_OraCursorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraCursorTest_THRESH ON OraCursorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraLatchTest CASCADE CONSTRAINTS;
CREATE TABLE OraLatchTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	WILLING_TO_WAIT_MISSES Number(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_ST varchar2(32) NOT NULL,
	IMMEDIATE_MISSES Number(20,4) NOT NULL,
	IMMEDIATE_MISSES_ST varchar2(32) NOT NULL);

ALTER TABLE OraLatchTest ADD constraint PK_OraLatchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraLatchTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraLatchTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	WILLING_TO_WAIT_MISSES_MIN Number(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_MAX Number(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_STCNT varchar2(32) NOT NULL,
	IMMEDIATE_MISSES_MIN Number(20,4) NOT NULL,
	IMMEDIATE_MISSES_MAX Number(20,4) NOT NULL,
	IMMEDIATE_MISSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraLatchTest_TREND ADD constraint PK_OraLatchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraLatchTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraLatchTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	WILLING_TO_WAIT_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	WILLING_TO_WAIT_MISSES_MAX	VARCHAR2(256)	 NOT NULL,
	IMMEDIATE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
	IMMEDIATE_MISSES_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraLatchTest_THRESH ADD constraint PK_OraLatchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraLatchTest_THRESH ON OraLatchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraScanTest CASCADE CONSTRAINTS;
CREATE TABLE OraScanTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PCT_LONG_TABLE_SCANS Number(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_ST varchar2(32) NOT NULL,
	LONG_TABLE_SCANS Number(20,4) NOT NULL,
	LONG_TABLE_SCANS_ST varchar2(32) NOT NULL,
	SHORT_TABLE_SCANS Number(20,4) NOT NULL,
	SHORT_TABLE_SCANS_ST varchar2(32) NOT NULL,
	FULL_TABLE_SCANS Number(20,4) NOT NULL,
	FULL_TABLE_SCANS_ST varchar2(32) NOT NULL);

ALTER TABLE OraScanTest ADD constraint PK_OraScanTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraScanTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE OraScanTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	PCT_LONG_TABLE_SCANS_MIN Number(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_MAX Number(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_STCNT varchar2(32) NOT NULL,
	LONG_TABLE_SCANS_MIN Number(20,4) NOT NULL,
	LONG_TABLE_SCANS_MAX Number(20,4) NOT NULL,
	LONG_TABLE_SCANS_STCNT varchar2(32) NOT NULL,
	SHORT_TABLE_SCANS_MIN Number(20,4) NOT NULL,
	SHORT_TABLE_SCANS_MAX Number(20,4) NOT NULL,
	SHORT_TABLE_SCANS_STCNT varchar2(32) NOT NULL,
	FULL_TABLE_SCANS_MIN Number(20,4) NOT NULL,
	FULL_TABLE_SCANS_MAX Number(20,4) NOT NULL,
	FULL_TABLE_SCANS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraScanTest_TREND ADD constraint PK_OraScanTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraScanTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraScanTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	PCT_LONG_TABLE_SCANS_MIN	VARCHAR2(256)	 NOT NULL,
	PCT_LONG_TABLE_SCANS_MAX	VARCHAR2(256)	 NOT NULL,
	LONG_TABLE_SCANS_MIN	VARCHAR2(256)	 NOT NULL,
	LONG_TABLE_SCANS_MAX	VARCHAR2(256)	 NOT NULL,
	SHORT_TABLE_SCANS_MIN	VARCHAR2(256)	 NOT NULL,
	SHORT_TABLE_SCANS_MAX	VARCHAR2(256)	 NOT NULL,
	FULL_TABLE_SCANS_MIN	VARCHAR2(256)	 NOT NULL,
	FULL_TABLE_SCANS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraScanTest_THRESH ADD constraint PK_OraScanTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraScanTest_THRESH ON OraScanTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTransTest CASCADE CONSTRAINTS;
CREATE TABLE OraTransTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	USER_COMMITS Number(20,4) NOT NULL,
	USER_COMMITS_ST varchar2(32) NOT NULL,
	USER_ROLLBACKS Number(20,4) NOT NULL,
	USER_ROLLBACKS_ST varchar2(32) NOT NULL,
	PCT_ROLLBACKS Number(20,4) NOT NULL,
	PCT_ROLLBACKS_ST varchar2(32) NOT NULL);

ALTER TABLE OraTransTest ADD constraint PK_OraTransTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraTransTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraTransTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	USER_COMMITS_MIN Number(20,4) NOT NULL,
	USER_COMMITS_MAX Number(20,4) NOT NULL,
	USER_COMMITS_STCNT varchar2(32) NOT NULL,
	USER_ROLLBACKS_MIN Number(20,4) NOT NULL,
	USER_ROLLBACKS_MAX Number(20,4) NOT NULL,
	USER_ROLLBACKS_STCNT varchar2(32) NOT NULL,
	PCT_ROLLBACKS_MIN Number(20,4) NOT NULL,
	PCT_ROLLBACKS_MAX Number(20,4) NOT NULL,
	PCT_ROLLBACKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraTransTest_TREND ADD constraint PK_OraTransTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraTransTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraTransTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	USER_COMMITS_MIN	VARCHAR2(256)	 NOT NULL,
	USER_COMMITS_MAX	VARCHAR2(256)	 NOT NULL,
	USER_ROLLBACKS_MIN	VARCHAR2(256)	 NOT NULL,
	USER_ROLLBACKS_MAX	VARCHAR2(256)	 NOT NULL,
	PCT_ROLLBACKS_MIN	VARCHAR2(256)	 NOT NULL,
	PCT_ROLLBACKS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraTransTest_THRESH ADD constraint PK_OraTransTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraTransTest_THRESH ON OraTransTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppLoadTest CASCADE CONSTRAINTS;
CREATE TABLE CtxAppLoadTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NORMAL Number(20,4) NOT NULL,
NORMAL_ST varchar2(32) NOT NULL,
OVERLOAD Number(20,4) NOT NULL,
OVERLOAD_ST varchar2(32) NOT NULL,
OUT_OF_LICENSE Number(20,4) NOT NULL,
OUT_OF_LICENSE_ST varchar2(32) NOT NULL,
DISABLED Number(20,4) NOT NULL,
DISABLED_ST varchar2(32) NOT NULL);

ALTER TABLE CtxAppLoadTest ADD constraint PK_CtxAppLoadTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxAppLoadTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CtxAppLoadTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NORMAL_MIN Number(20,4) NOT NULL,
NORMAL_MAX Number(20,4) NOT NULL,
NORMAL_STCNT varchar2(32) NOT NULL,
OVERLOAD_MIN Number(20,4) NOT NULL,
OVERLOAD_MAX Number(20,4) NOT NULL,
OVERLOAD_STCNT varchar2(32) NOT NULL,
OUT_OF_LICENSE_MIN Number(20,4) NOT NULL,
OUT_OF_LICENSE_MAX Number(20,4) NOT NULL,
OUT_OF_LICENSE_STCNT varchar2(32) NOT NULL,
DISABLED_MIN Number(20,4) NOT NULL,
DISABLED_MAX Number(20,4) NOT NULL,
DISABLED_STCNT varchar2(32) NOT NULL);

ALTER TABLE CtxAppLoadTest_TREND ADD constraint PK_CtxAppLoadTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxAppLoadTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CtxAppLoadTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NORMAL_MIN	VARCHAR2(256)	 NOT NULL,
NORMAL_MAX	VARCHAR2(256)	 NOT NULL,
OVERLOAD_MIN	VARCHAR2(256)	 NOT NULL,
OVERLOAD_MAX	VARCHAR2(256)	 NOT NULL,
OUT_OF_LICENSE_MIN	VARCHAR2(256)	 NOT NULL,
OUT_OF_LICENSE_MAX	VARCHAR2(256)	 NOT NULL,
DISABLED_MIN	VARCHAR2(256)	 NOT NULL,
DISABLED_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE CtxAppLoadTest_THRESH ADD constraint PK_CtxAppLoadTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAppLoadTest_THRESH ON CtxAppLoadTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraObjTest CASCADE CONSTRAINTS;
CREATE TABLE OraObjTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	INVALID_OBJECTS Number(20,4) NOT NULL,
	INVALID_OBJECTS_ST varchar2(32) NOT NULL,
	MODIFIED_OBJECTS Number(20,4) NOT NULL,
	MODIFIED_OBJECTS_ST varchar2(32) NOT NULL);

ALTER TABLE OraObjTest ADD constraint PK_OraObjTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraObjTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraObjTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	INVALID_OBJECTS_MIN Number(20,4) NOT NULL,
	INVALID_OBJECTS_MAX Number(20,4) NOT NULL,
	INVALID_OBJECTS_STCNT varchar2(32) NOT NULL,
	MODIFIED_OBJECTS_MIN Number(20,4) NOT NULL,
	MODIFIED_OBJECTS_MAX Number(20,4) NOT NULL,
	MODIFIED_OBJECTS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraObjTest_TREND ADD constraint PK_OraObjTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraObjTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraObjTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	INVALID_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	INVALID_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL,
	MODIFIED_OBJECTS_MIN	VARCHAR2(256)	 NOT NULL,
	MODIFIED_OBJECTS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraObjTest_THRESH ADD constraint PK_OraObjTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraObjTest_THRESH ON OraObjTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlAccessTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlAccessTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	FULL_SCAN_RATE			Number(20,4) NOT NULL,
	FULL_SCAN_RATE_ST		varchar2(32) NOT NULL,
	PAGE_SPLIT_RATE			Number(20,4) NOT NULL,
	PAGE_SPLIT_RATE_ST		varchar2(32) NOT NULL,
	SQL_COMPILATION_RATE		Number(20,4) NOT NULL,
	SQL_COMPILATION_RATE_ST		varchar2(32) NOT NULL,
	SQL_RECOMPILATION_RATE		Number(20,4) NOT NULL,
	SQL_RECOMPILATION_RATE_ST	varchar2(32) NOT NULL,
	BATCH_REQUEST_RATE		Number(20,4) NOT NULL,
	BATCH_REQUEST_RATE_ST		varchar2(32) NOT NULL,
	WORKFILES_RATE			Number(20,4) NOT NULL,
	WORKFILES_RATE_ST		varchar2(32) NOT NULL,
	WORKTABLES_RATE			Number(20,4) NOT NULL,
	WORKTABLES_RATE_ST		varchar2(32) NOT NULL,
	WORKTABLES_RATIO		Number(20,4) NOT NULL,
	WORKTABLES_RATIO_ST		varchar2(32) NOT NULL,
	FREESPACE_SCAN_RATE		Number(20,4) NOT NULL,
	FREESPACE_SCAN_RATE_ST		varchar2(32) NOT NULL,
	SQL_ATTENTION_RATE		Number(20,4) NOT NULL,
	SQL_ATTENTION_RATE_ST		varchar2(32) NOT NULL);

CREATE  INDEX IDX_MSSQLACCESSTEST ON MSSQLACCESSTEST(MSMT_TIME);
ALTER TABLE MsSqlAccessTest ADD constraint PK_MsSqlAccessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlAccessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlAccessTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	FULL_SCAN_RATE_MIN		Number(20,4) NOT NULL,
	FULL_SCAN_RATE_MAX		Number(20,4) NOT NULL,
	FULL_SCAN_RATE_STCNT		varchar2(32) NOT NULL,
	PAGE_SPLIT_RATE_MIN		Number(20,4) NOT NULL,
	PAGE_SPLIT_RATE_MAX		Number(20,4) NOT NULL,
	PAGE_SPLIT_RATE_STCNT		varchar2(32) NOT NULL,
	SQL_COMPILATION_RATE_MIN	Number(20,4) NOT NULL,
	SQL_COMPILATION_RATE_MAX	Number(20,4) NOT NULL,
	SQL_COMPILATION_RATE_STCNT	varchar2(32) NOT NULL,
	SQL_RECOMPILATION_RATE_MIN	Number(20,4) NOT NULL,
	SQL_RECOMPILATION_RATE_MAX	Number(20,4) NOT NULL,
	SQL_RECOMPILATION_RATE_STCNT	varchar2(32) NOT NULL,
	BATCH_REQUEST_RATE_MIN		Number(20,4) NOT NULL,
	BATCH_REQUEST_RATE_MAX		Number(20,4) NOT NULL,
	BATCH_REQUEST_RATE_STCNT	varchar2(32) NOT NULL,
	WORKFILES_RATE_MIN		Number(20,4) NOT NULL,
	WORKFILES_RATE_MAX		Number(20,4) NOT NULL,
	WORKFILES_RATE_STCNT		varchar2(32) NOT NULL,
	WORKTABLES_RATE_MIN		Number(20,4) NOT NULL,
	WORKTABLES_RATE_MAX		Number(20,4) NOT NULL,
	WORKTABLES_RATE_STCNT		varchar2(32) NOT NULL,
	WORKTABLES_RATIO_MIN		Number(20,4) NOT NULL,
	WORKTABLES_RATIO_MAX		Number(20,4) NOT NULL,
	WORKTABLES_RATIO_STCNT		varchar2(32) NOT NULL,
	FREESPACE_SCAN_RATE_MIN		Number(20,4) NOT NULL,
	FREESPACE_SCAN_RATE_MAX		Number(20,4) NOT NULL,
	FREESPACE_SCAN_RATE_STCNT	varchar2(32) NOT NULL,
	SQL_ATTENTION_RATE_MIN		Number(20,4) NOT NULL,
	SQL_ATTENTION_RATE_MAX		Number(20,4) NOT NULL,
	SQL_ATTENTION_RATE_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MsSqlAccessTest_TREND ADD constraint PK_MsSqlAccessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlAccessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlAccessTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	FULL_SCAN_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	FULL_SCAN_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	PAGE_SPLIT_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	PAGE_SPLIT_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	SQL_COMPILATION_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SQL_COMPILATION_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	SQL_RECOMPILATION_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	SQL_RECOMPILATION_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	BATCH_REQUEST_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	BATCH_REQUEST_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	WORKFILES_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	WORKFILES_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	WORKTABLES_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	WORKTABLES_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	WORKTABLES_RATIO_MAX		VARCHAR2(256)	 NOT NULL,
	WORKTABLES_RATIO_MIN		VARCHAR2(256)	 NOT NULL,
	FREESPACE_SCAN_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	FREESPACE_SCAN_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	SQL_ATTENTION_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	SQL_ATTENTION_RATE_MAX		VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsSqlAccessTest_THRESH ADD constraint PK_MsSqlAccessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlAccessTest_THRESH ON MsSqlAccessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlCacheTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlCacheTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	CACHE_HIT_RATIO Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
	CACHE_OBJECT_COUNT Number(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_ST varchar2(32) NOT NULL,
	LOG_CACHE_HIT_RATIO Number(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_ST varchar2(32) NOT NULL);

ALTER TABLE MsSqlCacheTest ADD constraint PK_MsSqlCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlCacheTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
	CACHE_OBJECT_COUNT_MIN Number(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_MAX Number(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_STCNT varchar2(32) NOT NULL,
	LOG_CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsSqlCacheTest_TREND ADD constraint PK_MsSqlCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlCacheTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	CACHE_HIT_RATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHE_HIT_RATIO_MAX	VARCHAR2(256)	 NOT NULL,
	CACHE_OBJECT_COUNT_MIN	VARCHAR2(256)	 NOT NULL,
	CACHE_OBJECT_COUNT_MAX	VARCHAR2(256)	 NOT NULL,
	LOG_CACHE_HIT_RATIO_MIN	VARCHAR2(256)	 NOT NULL,
	LOG_CACHE_HIT_RATIO_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsSqlCacheTest_THRESH ADD constraint PK_MsSqlCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlCacheTest_THRESH ON MsSqlCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlLatchTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlLatchTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	LATCH_WAIT_RATE Number(20,4) NOT NULL,
	LATCH_WAIT_RATE_ST varchar2(32) NOT NULL,
	TOTAL_WAIT_TIME Number(20,4) NOT NULL,
	TOTAL_WAIT_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE MsSqlLatchTest ADD constraint PK_MsSqlLatchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlLatchTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlLatchTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	LATCH_WAIT_RATE_MIN Number(20,4) NOT NULL,
	LATCH_WAIT_RATE_MAX Number(20,4) NOT NULL,
	LATCH_WAIT_RATE_STCNT varchar2(32) NOT NULL,
	TOTAL_WAIT_TIME_MIN Number(20,4) NOT NULL,
	TOTAL_WAIT_TIME_MAX Number(20,4) NOT NULL,
	TOTAL_WAIT_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsSqlLatchTest_TREND ADD constraint PK_MsSqlLatchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlLatchTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlLatchTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	LATCH_WAIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	LATCH_WAIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_WAIT_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_WAIT_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsSqlLatchTest_THRESH ADD constraint PK_MsSqlLatchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlLatchTest_THRESH ON MsSqlLatchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlDatabaseTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlDatabaseTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	ACTIVE_TRANSACTIONS		Number(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_ST		varchar2(32) NOT NULL,
	TRANSACTION_RATE		Number(20,4) NOT NULL,
	TRANSACTION_RATE_ST		varchar2(32) NOT NULL,
	REPL_TRANS_RATE			Number(20,4) NOT NULL,
	REPL_TRANS_RATE_ST		varchar2(32) NOT NULL,
	PENDING_REPL_TRANS		Number(20,4) NOT NULL,
	PENDING_REPL_TRANS_ST		varchar2(32) NOT NULL,
	DATA_FILE_SIZE			Number(20,4) NOT NULL,
	DATA_FILE_SIZE_ST		varchar2(32) NOT NULL,
	LOG_FLUSH_WAITS			Number(20,4) NOT NULL,
	LOG_FLUSH_WAITS_ST		varchar2(32) NOT NULL,
	WRITE_TRANSACTION_RATE		Number(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_ST	varchar2(32) NOT NULL);

CREATE  INDEX IDX_MSSQLDATABASETEST ON MSSQLDATABASETEST(MSMT_TIME);
ALTER TABLE MsSqlDatabaseTest ADD constraint PK_MsSqlDatabaseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlDatabaseTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlDatabaseTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	ACTIVE_TRANSACTIONS_MIN		Number(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_MAX		Number(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_STCNT	varchar2(32) NOT NULL,
	TRANSACTION_RATE_MIN		Number(20,4) NOT NULL,
	TRANSACTION_RATE_MAX		Number(20,4) NOT NULL,
	TRANSACTION_RATE_STCNT		varchar2(32) NOT NULL,
	REPL_TRANS_RATE_MIN		Number(20,4) NOT NULL,
	REPL_TRANS_RATE_MAX		Number(20,4) NOT NULL,
	REPL_TRANS_RATE_STCNT		varchar2(32) NOT NULL,
	PENDING_REPL_TRANS_MIN		Number(20,4) NOT NULL,
	PENDING_REPL_TRANS_MAX		Number(20,4) NOT NULL,
	PENDING_REPL_TRANS_STCNT	varchar2(32) NOT NULL,
	DATA_FILE_SIZE_MIN		Number(20,4) NOT NULL,
	DATA_FILE_SIZE_MAX		Number(20,4) NOT NULL,
	DATA_FILE_SIZE_STCNT		varchar2(32) NOT NULL,
	LOG_FLUSH_WAITS_MIN		Number(20,4) NOT NULL,
	LOG_FLUSH_WAITS_MAX		Number(20,4) NOT NULL,
	LOG_FLUSH_WAITS_STCNT		varchar2(32) NOT NULL,
	WRITE_TRANSACTION_RATE_MIN	Number(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_MAX	Number(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MsSqlDatabaseTest_TREND ADD constraint PK_MsSqlDatabaseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlDatabaseTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlDatabaseTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	ACTIVE_TRANSACTIONS_MIN		VARCHAR2(256)	 NOT NULL,
	ACTIVE_TRANSACTIONS_MAX		VARCHAR2(256)	 NOT NULL,
	TRANSACTION_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	TRANSACTION_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	REPL_TRANS_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	REPL_TRANS_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	PENDING_REPL_TRANS_MIN		VARCHAR2(256)	 NOT NULL,
	PENDING_REPL_TRANS_MAX		VARCHAR2(256)	 NOT NULL,
	DATA_FILE_SIZE_MIN		VARCHAR2(256)	 NOT NULL,
	DATA_FILE_SIZE_MAX		VARCHAR2(256)	 NOT NULL,
	LOG_FLUSH_WAITS_MIN		VARCHAR2(256)	 NOT NULL,
	LOG_FLUSH_WAITS_MAX		VARCHAR2(256)	 NOT NULL,
	WRITE_TRANSACTION_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	WRITE_TRANSACTION_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsSqlDatabaseTest_THRESH ADD constraint PK_MsSqlDatabaseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlDatabaseTest_THRESH ON MsSqlDatabaseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TR_MsSqlDatabaseTest on MsSqlDatabaseTest_TREND(msmt_time,period);
CREATE INDEX IDX_TH_MsSqlDatabaseTest on MsSqlDatabaseTest_THRESH(msmt_time_start);

DROP TABLE MsSqlBufferMgtTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlBufferMgtTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	BUFFER_CACHE_HIT_RATIO		Number(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_ST	varchar2(32) NOT NULL,
	PAGE_READS			Number(20,4) NOT NULL,
	PAGE_READS_ST			varchar2(32) NOT NULL,
	PAGE_WRITES			Number(20,4) NOT NULL,
	PAGE_WRITES_ST			varchar2(32) NOT NULL,
	TARGET_PAGES			Number(20,4) NOT NULL,
	TARGET_PAGES_ST			varchar2(32) NOT NULL,
	TOTAL_PAGES			Number(20,4) NOT NULL,
	TOTAL_PAGES_ST			varchar2(32) NOT NULL,
	FREE_PAGES			Number(20,4) NOT NULL,
	FREE_PAGES_ST			varchar2(32) NOT NULL,
	STOLEN_PAGES			Number(20,4) NOT NULL,
	STOLEN_PAGES_ST			varchar2(32) NOT NULL,
	LAZY_WRITES_RATE		Number(20,4) NOT NULL,
	LAZY_WRITES_RATE_ST		varchar2(32) NOT NULL,
	PAGE_LIFE_EXPECTANCY		Number(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_ST		varchar2(32) NOT NULL,
	FREE_LIST_STALLS		Number(20,4) NOT NULL,
	FREE_LIST_STALLS_ST		varchar2(32) NOT NULL);

CREATE  INDEX IDX_MSSQLBUFFERMGTTEST ON MSSQLBUFFERMGTTEST(MSMT_TIME);
ALTER TABLE MsSqlBufferMgtTest ADD constraint PK_MsSqlBufferMgtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlBufferMgtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlBufferMgtTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	BUFFER_CACHE_HIT_RATIO_MIN	Number(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MAX	Number(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_STCNT	varchar2(32) NOT NULL,
	PAGE_READS_MIN			Number(20,4) NOT NULL,
	PAGE_READS_MAX			Number(20,4) NOT NULL,
	PAGE_READS_STCNT		varchar2(32) NOT NULL,
	PAGE_WRITES_MIN			Number(20,4) NOT NULL,
	PAGE_WRITES_MAX			Number(20,4) NOT NULL,
	PAGE_WRITES_STCNT		varchar2(32) NOT NULL,
	TARGET_PAGES_MIN		Number(20,4) NOT NULL,
	TARGET_PAGES_MAX		Number(20,4) NOT NULL,
	TARGET_PAGES_STCNT		varchar2(32) NOT NULL,
	TOTAL_PAGES_MIN			Number(20,4) NOT NULL,
	TOTAL_PAGES_MAX			Number(20,4) NOT NULL,
	TOTAL_PAGES_STCNT		varchar2(32) NOT NULL,
	FREE_PAGES_MIN			Number(20,4) NOT NULL,
	FREE_PAGES_MAX			Number(20,4) NOT NULL,
	FREE_PAGES_STCNT		varchar2(32) NOT NULL,
	STOLEN_PAGES_MIN		Number(20,4) NOT NULL,
	STOLEN_PAGES_MAX		Number(20,4) NOT NULL,
	STOLEN_PAGES_STCNT		varchar2(32) NOT NULL,
	LAZY_WRITES_RATE_MIN		Number(20,4) NOT NULL,
	LAZY_WRITES_RATE_MAX		Number(20,4) NOT NULL,
	LAZY_WRITES_RATE_STCNT		varchar2(32) NOT NULL,
	PAGE_LIFE_EXPECTANCY_MIN	Number(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_MAX	Number(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_STCNT	varchar2(32) NOT NULL,
	FREE_LIST_STALLS_MIN		Number(20,4) NOT NULL,
	FREE_LIST_STALLS_MAX		Number(20,4) NOT NULL,
	FREE_LIST_STALLS_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MsSqlBufferMgtTest_TREND ADD constraint PK_MsSqlBufferMgtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlBufferMgtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlBufferMgtTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	BUFFER_CACHE_HIT_RATIO_MIN	VARCHAR2(256)	 NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MAX	VARCHAR2(256)	 NOT NULL,
	PAGE_READS_MIN			VARCHAR2(256)	 NOT NULL,
	PAGE_READS_MAX			VARCHAR2(256)	 NOT NULL,
	PAGE_WRITES_MIN			VARCHAR2(256)	 NOT NULL,
	PAGE_WRITES_MAX			VARCHAR2(256)	 NOT NULL,
	TARGET_PAGES_MIN		VARCHAR2(256)	 NOT NULL,
	TARGET_PAGES_MAX		VARCHAR2(256)	 NOT NULL,
	TOTAL_PAGES_MIN			VARCHAR2(256)	 NOT NULL,
	TOTAL_PAGES_MAX			VARCHAR2(256)	 NOT NULL,
	FREE_PAGES_MIN			VARCHAR2(256)	 NOT NULL,
	FREE_PAGES_MAX			VARCHAR2(256)	 NOT NULL,
	STOLEN_PAGES_MIN		VARCHAR2(256)	 NOT NULL,
	STOLEN_PAGES_MAX		VARCHAR2(256)	 NOT NULL,
	LAZY_WRITES_RATE_MIN		VARCHAR2(256)	 NOT NULL,
	LAZY_WRITES_RATE_MAX		VARCHAR2(256)	 NOT NULL,
	PAGE_LIFE_EXPECTANCY_MIN	VARCHAR2(256)	 NOT NULL,
	PAGE_LIFE_EXPECTANCY_MAX	VARCHAR2(256)	 NOT NULL,
	FREE_LIST_STALLS_MIN		VARCHAR2(256)	 NOT NULL,
	FREE_LIST_STALLS_MAX		VARCHAR2(256)	 NOT NULL);

ALTER TABLE MsSqlBufferMgtTest_THRESH ADD constraint PK_MsSqlBufferMgtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlBufferMgtTest_THRESH ON MsSqlBufferMgtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iWebModuleTest CASCADE CONSTRAINTS;
CREATE TABLE O9iWebModuleTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REQ_ACTIVE Number(20,4) NOT NULL,
REQ_ACTIVE_ST varchar2(32) NOT NULL,
REQ_COMPLETED Number(20,4) NOT NULL,
REQ_COMPLETED_ST varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL,
AVG_CTX_RESOLVE_TIME Number(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_ST varchar2(32) NOT NULL,
AVG_REQ_PARSE_TIME Number(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE O9iWebModuleTest ADD constraint PK_O9iWebModuleTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iWebModuleTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iWebModuleTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REQ_ACTIVE_MIN Number(20,4) NOT NULL,
REQ_ACTIVE_MAX Number(20,4) NOT NULL,
REQ_ACTIVE_STCNT varchar2(32) NOT NULL,
REQ_COMPLETED_MIN Number(20,4) NOT NULL,
REQ_COMPLETED_MAX Number(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL,
AVG_CTX_RESOLVE_TIME_MIN Number(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_MAX Number(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_STCNT varchar2(32) NOT NULL,
AVG_REQ_PARSE_TIME_MIN Number(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_MAX Number(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iWebModuleTest_TREND ADD constraint PK_O9iWebModuleTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iWebModuleTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iWebModuleTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REQ_ACTIVE_MIN	VARCHAR2(256)	 NOT NULL,
REQ_ACTIVE_MAX	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL,
AVG_CTX_RESOLVE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_CTX_RESOLVE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PARSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PARSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iWebModuleTest_THRESH ADD constraint PK_O9iWebModuleTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iWebModuleTest_THRESH ON O9iWebModuleTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE O9iDriverTest CASCADE CONSTRAINTS;
CREATE TABLE O9iDriverTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
THREADS_CREATING_CONNS Number(20,4) NOT NULL,
THREADS_CREATING_CONNS_ST varchar2(32) NOT NULL,
AVG_CONN_CREATE_TIME Number(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_ST varchar2(32) NOT NULL,
MAX_CONN_CREATE_TIME Number(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_ST varchar2(32) NOT NULL,
CONNS_OPEN Number(20,4) NOT NULL,
CONNS_OPEN_ST varchar2(32) NOT NULL,
CONNS_CLOSE Number(20,4) NOT NULL,
CONNS_CLOSE_ST varchar2(32) NOT NULL);

ALTER TABLE O9iDriverTest ADD constraint PK_O9iDriverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iDriverTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iDriverTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
THREADS_CREATING_CONNS_MIN Number(20,4) NOT NULL,
THREADS_CREATING_CONNS_MAX Number(20,4) NOT NULL,
THREADS_CREATING_CONNS_STCNT varchar2(32) NOT NULL,
AVG_CONN_CREATE_TIME_MIN Number(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_MAX Number(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_STCNT varchar2(32) NOT NULL,
MAX_CONN_CREATE_TIME_MIN Number(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_MAX Number(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_STCNT varchar2(32) NOT NULL,
CONNS_OPEN_MIN Number(20,4) NOT NULL,
CONNS_OPEN_MAX Number(20,4) NOT NULL,
CONNS_OPEN_STCNT varchar2(32) NOT NULL,
CONNS_CLOSE_MIN Number(20,4) NOT NULL,
CONNS_CLOSE_MAX Number(20,4) NOT NULL,
CONNS_CLOSE_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iDriverTest_TREND ADD constraint PK_O9iDriverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iDriverTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iDriverTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
THREADS_CREATING_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
THREADS_CREATING_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
AVG_CONN_CREATE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_CONN_CREATE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MAX_CONN_CREATE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
MAX_CONN_CREATE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_OPEN_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_OPEN_MAX	VARCHAR2(256)	 NOT NULL,
CONNS_CLOSE_MIN	VARCHAR2(256)	 NOT NULL,
CONNS_CLOSE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iDriverTest_THRESH ADD constraint PK_O9iDriverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iDriverTest_THRESH ON O9iDriverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iJspTest CASCADE CONSTRAINTS;
CREATE TABLE O9iJspTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
THREADS_SERVICING_JSP Number(20,4) NOT NULL,
THREADS_SERVICING_JSP_ST varchar2(32) NOT NULL,
REQ_COMPLETED Number(20,4) NOT NULL,
REQ_COMPLETED_ST varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE O9iJspTest ADD constraint PK_O9iJspTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iJspTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iJspTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
THREADS_SERVICING_JSP_MIN Number(20,4) NOT NULL,
THREADS_SERVICING_JSP_MAX Number(20,4) NOT NULL,
THREADS_SERVICING_JSP_STCNT varchar2(32) NOT NULL,
REQ_COMPLETED_MIN Number(20,4) NOT NULL,
REQ_COMPLETED_MAX Number(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iJspTest_TREND ADD constraint PK_O9iJspTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iJspTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iJspTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
THREADS_SERVICING_JSP_MIN	VARCHAR2(256)	 NOT NULL,
THREADS_SERVICING_JSP_MAX	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iJspTest_THRESH ADD constraint PK_O9iJspTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iJspTest_THRESH ON O9iJspTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iJvmTest CASCADE CONSTRAINTS;
CREATE TABLE O9iJvmTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_THREAD_GROUPS Number(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_ST varchar2(32) NOT NULL,
ACTIVE_THREADS Number(20,4) NOT NULL,
ACTIVE_THREADS_ST varchar2(32) NOT NULL,
FREE_HEAP Number(20,4) NOT NULL,
FREE_HEAP_ST varchar2(32) NOT NULL,
MIN_FREE_HEAP Number(20,4) NOT NULL,
MIN_FREE_HEAP_ST varchar2(32) NOT NULL,
HEAP_USED Number(20,4) NOT NULL,
HEAP_USED_ST varchar2(32) NOT NULL,
MAX_HEAP_USED Number(20,4) NOT NULL,
MAX_HEAP_USED_ST varchar2(32) NOT NULL,
JVM_AVAILABILITY Number(20,4) NOT NULL,
JVM_AVAILABILITY_ST varchar2(32) NOT NULL);

ALTER TABLE O9iJvmTest ADD constraint PK_O9iJvmTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iJvmTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iJvmTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ACTIVE_THREAD_GROUPS_MIN Number(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_MAX Number(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_STCNT varchar2(32) NOT NULL,
ACTIVE_THREADS_MIN Number(20,4) NOT NULL,
ACTIVE_THREADS_MAX Number(20,4) NOT NULL,
ACTIVE_THREADS_STCNT varchar2(32) NOT NULL,
FREE_HEAP_MIN Number(20,4) NOT NULL,
FREE_HEAP_MAX Number(20,4) NOT NULL,
FREE_HEAP_STCNT varchar2(32) NOT NULL,
MIN_FREE_HEAP_MIN Number(20,4) NOT NULL,
MIN_FREE_HEAP_MAX Number(20,4) NOT NULL,
MIN_FREE_HEAP_STCNT varchar2(32) NOT NULL,
HEAP_USED_MIN Number(20,4) NOT NULL,
HEAP_USED_MAX Number(20,4) NOT NULL,
HEAP_USED_STCNT varchar2(32) NOT NULL,
MAX_HEAP_USED_MIN Number(20,4) NOT NULL,
MAX_HEAP_USED_MAX Number(20,4) NOT NULL,
MAX_HEAP_USED_STCNT varchar2(32) NOT NULL,
JVM_AVAILABILITY_MIN Number(20,4) NOT NULL,
JVM_AVAILABILITY_MAX Number(20,4) NOT NULL,
JVM_AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iJvmTest_TREND ADD constraint PK_O9iJvmTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iJvmTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iJvmTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_THREAD_GROUPS_MIN	VARCHAR2(256)	 NOT NULL,
ACTIVE_THREAD_GROUPS_MAX	VARCHAR2(256)	 NOT NULL,
ACTIVE_THREADS_MIN	VARCHAR2(256)	 NOT NULL,
ACTIVE_THREADS_MAX	VARCHAR2(256)	 NOT NULL,
FREE_HEAP_MIN	VARCHAR2(256)	 NOT NULL,
FREE_HEAP_MAX	VARCHAR2(256)	 NOT NULL,
MIN_FREE_HEAP_MIN	VARCHAR2(256)	 NOT NULL,
MIN_FREE_HEAP_MAX	VARCHAR2(256)	 NOT NULL,
HEAP_USED_MIN	VARCHAR2(256)	 NOT NULL,
HEAP_USED_MAX	VARCHAR2(256)	 NOT NULL,
MAX_HEAP_USED_MIN	VARCHAR2(256)	 NOT NULL,
MAX_HEAP_USED_MAX	VARCHAR2(256)	 NOT NULL,
JVM_AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
JVM_AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iJvmTest_THRESH ADD constraint PK_O9iJvmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iJvmTest_THRESH ON O9iJvmTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE O9iServletTest CASCADE CONSTRAINTS;
CREATE TABLE O9iServletTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
THREADS_SERVICING_SERVLT Number(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_ST varchar2(32) NOT NULL,
REQ_COMPLETED Number(20,4) NOT NULL,
REQ_COMPLETED_ST varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE O9iServletTest ADD constraint PK_O9iServletTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iServletTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iServletTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
THREADS_SERVICING_SERVLT_MIN Number(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_MAX Number(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_STCNT varchar2(32) NOT NULL,
REQ_COMPLETED_MIN Number(20,4) NOT NULL,
REQ_COMPLETED_MAX Number(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar2(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX Number(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iServletTest_TREND ADD constraint PK_O9iServletTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iServletTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iServletTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
THREADS_SERVICING_SERVLT_MIN	VARCHAR2(256)	 NOT NULL,
THREADS_SERVICING_SERVLT_MAX	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR2(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR2(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iServletTest_THRESH ADD constraint PK_O9iServletTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iServletTest_THRESH ON O9iServletTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iTxTest CASCADE CONSTRAINTS;
CREATE TABLE O9iTxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TX_ACTIVE Number(20,4) NOT NULL,
TX_ACTIVE_ST varchar2(32) NOT NULL,
TX_COMMITS Number(20,4) NOT NULL,
TX_COMMITS_ST varchar2(32) NOT NULL,
TX_ROLLBACKS Number(20,4) NOT NULL,
TX_ROLLBACKS_ST varchar2(32) NOT NULL);

ALTER TABLE O9iTxTest ADD constraint PK_O9iTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iTxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iTxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TX_ACTIVE_MIN Number(20,4) NOT NULL,
TX_ACTIVE_MAX Number(20,4) NOT NULL,
TX_ACTIVE_STCNT varchar2(32) NOT NULL,
TX_COMMITS_MIN Number(20,4) NOT NULL,
TX_COMMITS_MAX Number(20,4) NOT NULL,
TX_COMMITS_STCNT varchar2(32) NOT NULL,
TX_ROLLBACKS_MIN Number(20,4) NOT NULL,
TX_ROLLBACKS_MAX Number(20,4) NOT NULL,
TX_ROLLBACKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iTxTest_TREND ADD constraint PK_O9iTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iTxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iTxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TX_ACTIVE_MIN	VARCHAR2(256)	 NOT NULL,
TX_ACTIVE_MAX	VARCHAR2(256)	 NOT NULL,
TX_COMMITS_MIN	VARCHAR2(256)	 NOT NULL,
TX_COMMITS_MAX	VARCHAR2(256)	 NOT NULL,
TX_ROLLBACKS_MIN	VARCHAR2(256)	 NOT NULL,
TX_ROLLBACKS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iTxTest_THRESH ADD constraint PK_O9iTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iTxTest_THRESH ON O9iTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iWebCtxTest CASCADE CONSTRAINTS;
CREATE TABLE O9iWebCtxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_SESSIONS Number(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
AVG_SESSION_LIFE_TIME Number(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_ST varchar2(32) NOT NULL,
MAX_SERVLET_RESOLVE_TIME Number(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_ST varchar2(32) NOT NULL,
AVG_SERVLET_RESOLVE_TIME Number(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE O9iWebCtxTest ADD constraint PK_O9iWebCtxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iWebCtxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iWebCtxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
AVG_SESSION_LIFE_TIME_MIN Number(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_MAX Number(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_STCNT varchar2(32) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MIN Number(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MAX Number(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_STCNT varchar2(32) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MIN Number(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MAX Number(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iWebCtxTest_TREND ADD constraint PK_O9iWebCtxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iWebCtxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iWebCtxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_LIFE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_LIFE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iWebCtxTest_THRESH ADD constraint PK_O9iWebCtxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iWebCtxTest_THRESH ON O9iWebCtxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iConnCacheTest CASCADE CONSTRAINTS;
CREATE TABLE O9iConnCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FREE_CACHE_SIZE Number(20,4) NOT NULL,
FREE_CACHE_SIZE_ST varchar2(32) NOT NULL,
CACHE_SIZE Number(20,4) NOT NULL,
CACHE_SIZE_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL);

ALTER TABLE O9iConnCacheTest ADD constraint PK_O9iConnCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O9iConnCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O9iConnCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FREE_CACHE_SIZE_MIN Number(20,4) NOT NULL,
FREE_CACHE_SIZE_MAX Number(20,4) NOT NULL,
FREE_CACHE_SIZE_STCNT varchar2(32) NOT NULL,
CACHE_SIZE_MIN Number(20,4) NOT NULL,
CACHE_SIZE_MAX Number(20,4) NOT NULL,
CACHE_SIZE_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE O9iConnCacheTest_TREND ADD constraint PK_O9iConnCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iConnCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O9iConnCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FREE_CACHE_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
FREE_CACHE_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE O9iConnCacheTest_THRESH ADD constraint PK_O9iConnCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iConnCacheTest_THRESH ON O9iConnCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinsTest CASCADE CONSTRAINTS;
CREATE TABLE WinsTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	QUERY_RATE Number(20,4) NOT NULL,
	QUERY_RATE_ST varchar2(32) NOT NULL,
	FAILED_QUERY_RATE Number(20,4) NOT NULL,
	FAILED_QUERY_RATE_ST varchar2(32) NOT NULL,
	RELEASE_RATE Number(20,4) NOT NULL,
	RELEASE_RATE_ST varchar2(32) NOT NULL,
	FAILED_RELEASE_RATE Number(20,4) NOT NULL,
	FAILED_RELEASE_RATE_ST varchar2(32) NOT NULL,
	CONFLICT_RATE Number(20,4) NOT NULL,
	CONFLICT_RATE_ST varchar2(32) NOT NULL,
	RENEWAL_RATE Number(20,4) NOT NULL,
	RENEWAL_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE WinsTest ADD constraint PK_WinsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE WinsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE WinsTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	QUERY_RATE_MIN Number(20,4) NOT NULL,
	QUERY_RATE_MAX Number(20,4) NOT NULL,
	QUERY_RATE_STCNT varchar2(32) NOT NULL,
	FAILED_QUERY_RATE_MIN Number(20,4) NOT NULL,
	FAILED_QUERY_RATE_MAX Number(20,4) NOT NULL,
	FAILED_QUERY_RATE_STCNT varchar2(32) NOT NULL,
	RELEASE_RATE_MIN Number(20,4) NOT NULL,
	RELEASE_RATE_MAX Number(20,4) NOT NULL,
	RELEASE_RATE_STCNT varchar2(32) NOT NULL,
	FAILED_RELEASE_RATE_MIN Number(20,4) NOT NULL,
	FAILED_RELEASE_RATE_MAX Number(20,4) NOT NULL,
	FAILED_RELEASE_RATE_STCNT varchar2(32) NOT NULL,
	CONFLICT_RATE_MIN Number(20,4) NOT NULL,
	CONFLICT_RATE_MAX Number(20,4) NOT NULL,
	CONFLICT_RATE_STCNT varchar2(32) NOT NULL,
	RENEWAL_RATE_MIN Number(20,4) NOT NULL,
	RENEWAL_RATE_MAX Number(20,4) NOT NULL,
	RENEWAL_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE WinsTest_TREND ADD constraint PK_WinsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WinsTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	QUERY_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	QUERY_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	FAILED_QUERY_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	FAILED_QUERY_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	RELEASE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	RELEASE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	FAILED_RELEASE_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	FAILED_RELEASE_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	CONFLICT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	CONFLICT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	RENEWAL_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	RENEWAL_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE WinsTest_THRESH ADD constraint PK_WinsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinsTest_THRESH ON WinsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermUserTest CASCADE CONSTRAINTS;
CREATE TABLE TermUserTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NO_OF_SESSIONS		Number(20,4) NOT NULL,
NO_OF_SESSIONS_ST	varchar2(32) NOT NULL,
CPU_UTIL		Number(20,4) NOT NULL,
CPU_UTIL_ST		varchar2(32) NOT NULL,
MEM_UTIL		Number(20,4) NOT NULL,
MEM_UTIL_ST		varchar2(32) NOT NULL,
INPUT_BANDWIDTH		Number(20,4) NOT NULL,
INPUT_BANDWIDTH_ST	varchar2(32) NOT NULL,
INPUT_ERRORS		Number(20,4) NOT NULL,
INPUT_ERRORS_ST		varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH	Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_ST	varchar2(32) NOT NULL,
OUTPUT_ERRORS		Number(20,4) NOT NULL,
OUTPUT_ERRORS_ST	varchar2(32) NOT NULL,
IO_READS		Number(20,4) NOT NULL,
IO_READS_ST		varchar2(32) NOT NULL,
IO_WRITES		Number(20,4) NOT NULL,
IO_WRITES_ST		varchar2(32) NOT NULL,
PAGE_FAULTS		Number(20,4) NOT NULL,
PAGE_FAULTS_ST		varchar2(32) NOT NULL,
VIRTUAL_MEM		Number(20,4) NOT NULL,
VIRTUAL_MEM_ST		varchar2(32) NOT NULL,
HANDLES			Number(20,4) NOT NULL,
HANDLES_ST		varchar2(32) NOT NULL,
CPU_UTIL_TIME		Number(20,4) NOT NULL,
CPU_UTIL_TIME_ST	varchar2(32) NOT NULL);

ALTER TABLE TermUserTest ADD constraint PK_TermUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermUserTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NO_OF_SESSIONS_MIN	Number(20,4) NOT NULL,
NO_OF_SESSIONS_MAX	Number(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT	varchar2(32) NOT NULL,
CPU_UTIL_MIN		Number(20,4) NOT NULL,
CPU_UTIL_MAX		Number(20,4) NOT NULL,
CPU_UTIL_STCNT		varchar2(32) NOT NULL,
MEM_UTIL_MIN		Number(20,4) NOT NULL,
MEM_UTIL_MAX		Number(20,4) NOT NULL,
MEM_UTIL_STCNT		varchar2(32) NOT NULL,
INPUT_BANDWIDTH_MIN	Number(20,4) NOT NULL,
INPUT_BANDWIDTH_MAX	Number(20,4) NOT NULL,
INPUT_BANDWIDTH_STCNT	varchar2(32) NOT NULL,
INPUT_ERRORS_MIN	Number(20,4) NOT NULL,
INPUT_ERRORS_MAX	Number(20,4) NOT NULL,
INPUT_ERRORS_STCNT	varchar2(32) NOT NULL,
OUTPUT_BANDWIDTH_MIN	Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_MAX	Number(20,4) NOT NULL,
OUTPUT_BANDWIDTH_STCNT	varchar2(32) NOT NULL,
OUTPUT_ERRORS_MIN	Number(20,4) NOT NULL,
OUTPUT_ERRORS_MAX	Number(20,4) NOT NULL,
OUTPUT_ERRORS_STCNT	varchar2(32) NOT NULL,
IO_READS_MIN		Number(20,4) NOT NULL,
IO_READS_MAX		Number(20,4)  NOT NULL,
IO_READS_STCNT		varchar2(32) NOT NULL,
IO_WRITES_MIN		Number(20,4) NOT NULL,
IO_WRITES_MAX		Number(20,4) NOT NULL,
IO_WRITES_STCNT		varchar2(32) NOT NULL,
PAGE_FAULTS_MIN		Number(20,4) NOT NULL,
PAGE_FAULTS_MAX		Number(20,4) NOT NULL,
PAGE_FAULTS_STCNT	varchar2(32) NOT NULL,
VIRTUAL_MEM_MIN		Number(20,4) NOT NULL,
VIRTUAL_MEM_MAX		Number(20,4) NOT NULL,
VIRTUAL_MEM_STCNT	varchar2(32) NOT NULL,
HANDLES_MIN		Number(20,4) NOT NULL,
HANDLES_MAX		Number(20,4) NOT NULL,
HANDLES_STCNT		varchar2(32) NOT NULL,
CPU_UTIL_TIME_MIN	Number(20,4) NOT NULL,
CPU_UTIL_TIME_MAX	Number(20,4) NOT NULL,
CPU_UTIL_TIME_STCNT	varchar2(32) NOT NULL);

ALTER TABLE TermUserTest_TREND ADD constraint PK_TermUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermUserTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NO_OF_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
INPUT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
INPUT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MAX	VARCHAR2(256)	 NOT NULL,
OUTPUT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
OUTPUT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
IO_READS_MIN VARCHAR2(256) NOT NULL,
IO_READS_MAX VARCHAR2(256)  NOT NULL,
IO_WRITES_MIN VARCHAR2(256) NOT NULL,
IO_WRITES_MAX VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MIN VARCHAR2(256) NOT NULL,
PAGE_FAULTS_MAX VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MIN VARCHAR2(256) NOT NULL,
VIRTUAL_MEM_MAX VARCHAR2(256) NOT NULL,
HANDLES_MIN VARCHAR2(256) NOT NULL,
HANDLES_MAX VARCHAR2(256) NOT NULL,
CPU_UTIL_TIME_MIN VARCHAR2(256) NOT NULL,
CPU_UTIL_TIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TermUserTest_THRESH ADD constraint PK_TermUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermUserTest_THRESH ON TermUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermSessionTest CASCADE CONSTRAINTS;
CREATE TABLE TermSessionTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ACTIVE_SESSIONS Number(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
IDLE_SESSIONS Number(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTED_SESSIONS Number(20,4) NOT NULL,
CONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
CONNECTING_SESSIONS Number(20,4) NOT NULL,
CONNECTING_SESSIONS_ST varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_ST varchar2(32) NOT NULL,
LISTEN_SESSIONS Number(20,4) NOT NULL,
LISTEN_SESSIONS_ST varchar2(32) NOT NULL,
SHADOW_SESSIONS Number(20,4) NOT NULL,
SHADOW_SESSIONS_ST varchar2(32) NOT NULL,
DOWN_SESSIONS Number(20,4) NOT NULL,
DOWN_SESSIONS_ST varchar2(32) NOT NULL,
INIT_SESSIONS Number(20,4) NOT NULL,
INIT_SESSIONS_ST varchar2(32) NOT NULL);

ALTER TABLE TermSessionTest ADD constraint PK_TermSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermSessionTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermSessionTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
IDLE_SESSIONS_MIN Number(20,4) NOT NULL,
IDLE_SESSIONS_MAX Number(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
CONNECTING_SESSIONS_MIN Number(20,4) NOT NULL,
CONNECTING_SESSIONS_MAX Number(20,4) NOT NULL,
CONNECTING_SESSIONS_STCNT varchar2(32) NOT NULL,
DISCONNECTED_SESSIONS_MIN Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_MAX Number(20,4) NOT NULL,
DISCONNECTED_SESSIONS_STCNT varchar2(32) NOT NULL,
LISTEN_SESSIONS_MIN Number(20,4) NOT NULL,
LISTEN_SESSIONS_MAX Number(20,4) NOT NULL,
LISTEN_SESSIONS_STCNT varchar2(32) NOT NULL,
SHADOW_SESSIONS_MIN Number(20,4) NOT NULL,
SHADOW_SESSIONS_MAX Number(20,4) NOT NULL,
SHADOW_SESSIONS_STCNT varchar2(32) NOT NULL,
DOWN_SESSIONS_MIN Number(20,4) NOT NULL,
DOWN_SESSIONS_MAX Number(20,4) NOT NULL,
DOWN_SESSIONS_STCNT varchar2(32) NOT NULL,
INIT_SESSIONS_MIN Number(20,4) NOT NULL,
INIT_SESSIONS_MAX Number(20,4) NOT NULL,
INIT_SESSIONS_STCNT varchar2(32) NOT NULL);

ALTER TABLE TermSessionTest_TREND ADD constraint PK_TermSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermSessionTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermSessionTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ACTIVE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
ACTIVE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MIN VARCHAR2(256) NOT NULL,
IDLE_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MIN VARCHAR2(256) NOT NULL,
CONNECTING_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DISCONNECTED_SESSIONS_MAX VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
LISTEN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MIN VARCHAR2(256) NOT NULL,
SHADOW_SESSIONS_MAX VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MIN VARCHAR2(256) NOT NULL,
DOWN_SESSIONS_MAX VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MIN VARCHAR2(256) NOT NULL,
INIT_SESSIONS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TermSessionTest_THRESH ADD constraint PK_TermSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermSessionTest_THRESH ON TermSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermAppTest CASCADE CONSTRAINTS;
CREATE TABLE TermAppTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_PROCS_RUNNING Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_ST varchar2(32) NOT NULL,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL,
MEMORY_UTIL Number(20,4) NOT NULL,
MEMORY_UTIL_ST varchar2(32) NOT NULL);

ALTER TABLE TermAppTest ADD constraint PK_TermAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermAppTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_PROCS_RUNNING_MIN Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_MAX Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_STCNT varchar2(32) NOT NULL,
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL,
MEMORY_UTIL_MIN Number(20,4) NOT NULL,
MEMORY_UTIL_MAX Number(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE TermAppTest_TREND ADD constraint PK_TermAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermAppTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_PROCS_RUNNING_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PROCS_RUNNING_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TermAppTest_THRESH ADD constraint PK_TermAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermAppTest_THRESH ON TermAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermConnTest CASCADE CONSTRAINTS;
CREATE TABLE TermConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSETIME Number(20,4) NOT NULL,
RESPONSETIME_ST varchar2(32) NOT NULL);

ALTER TABLE TermConnTest ADD constraint PK_TermConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSETIME_MIN Number(20,4) NOT NULL,
RESPONSETIME_MAX Number(20,4) NOT NULL,
RESPONSETIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE TermConnTest_TREND ADD constraint PK_TermConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
RESPONSETIME_MIN	VARCHAR2(256)	 NOT NULL,
RESPONSETIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TermConnTest_THRESH ADD constraint PK_TermConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermConnTest_THRESH ON TermConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermAuthTest CASCADE CONSTRAINTS;
CREATE TABLE TermAuthTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE TermAuthTest ADD constraint PK_TermAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermAuthTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermAuthTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE TermAuthTest_TREND ADD constraint PK_TermAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermAuthTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermAuthTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVAILABILITY_MIN	VARCHAR2(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TermAuthTest_THRESH ADD constraint PK_TermAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermAuthTest_THRESH ON TermAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermClientTest CASCADE CONSTRAINTS;
CREATE TABLE TermClientTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CURRENT_CONNS Number(20,4) NOT NULL,
CURRENT_CONNS_ST varchar2(32) NOT NULL,
NEW_CONNS_ADDED Number(20,4) NOT NULL,
NEW_CONNS_ADDED_ST varchar2(32) NOT NULL,
OLD_CONNS_REMOVED Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_ST varchar2(32) NOT NULL,
AVG_CONN_DURATION Number(20,4) NOT NULL,
AVG_CONN_DURATION_ST varchar2(32) NOT NULL);

ALTER TABLE TermClientTest ADD constraint PK_TermClientTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TermClientTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TermClientTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CURRENT_CONNS_MIN Number(20,4) NOT NULL,
CURRENT_CONNS_MAX Number(20,4) NOT NULL,
CURRENT_CONNS_STCNT varchar2(32) NOT NULL,
NEW_CONNS_ADDED_MIN Number(20,4) NOT NULL,
NEW_CONNS_ADDED_MAX Number(20,4) NOT NULL,
NEW_CONNS_ADDED_STCNT varchar2(32) NOT NULL,
OLD_CONNS_REMOVED_MIN Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_MAX Number(20,4) NOT NULL,
OLD_CONNS_REMOVED_STCNT varchar2(32) NOT NULL,
AVG_CONN_DURATION_MIN Number(20,4) NOT NULL,
AVG_CONN_DURATION_MAX Number(20,4) NOT NULL,
AVG_CONN_DURATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE TermClientTest_TREND ADD constraint PK_TermClientTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermClientTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TermClientTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CURRENT_CONNS_MIN	VARCHAR2(256)	 NOT NULL,
CURRENT_CONNS_MAX	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MIN	VARCHAR2(256)	 NOT NULL,
NEW_CONNS_ADDED_MAX	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
OLD_CONNS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MIN	VARCHAR2(256)	 NOT NULL,
AVG_CONN_DURATION_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE TermClientTest_THRESH ADD constraint PK_TermClientTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermClientTest_THRESH ON TermClientTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxyCacheTest CASCADE CONSTRAINTS;
CREATE TABLE ProxyCacheTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	ACTIVE_REFRESH_RATE Number(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_ST varchar2(32) NOT NULL,
	ACTIVE_URL_REFRESH Number(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_ST varchar2(32) NOT NULL,
	CACHE_SIZE Number(20,4) NOT NULL,
	CACHE_SIZE_ST varchar2(32) NOT NULL,
	URL_COMMITS Number(20,4) NOT NULL,
	URL_COMMITS_ST varchar2(32) NOT NULL,
	URL_RETRIEVALS Number(20,4) NOT NULL,
	URL_RETRIEVALS_ST varchar2(32) NOT NULL,
	URLS_IN_CACHE Number(20,4) NOT NULL,
	URLS_IN_CACHE_ST varchar2(32) NOT NULL);

ALTER TABLE ProxyCacheTest ADD constraint PK_ProxyCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ProxyCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ProxyCacheTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	ACTIVE_REFRESH_RATE_MIN Number(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_MAX Number(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_STCNT varchar2(32) NOT NULL,
	ACTIVE_URL_REFRESH_MIN Number(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_MAX Number(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_STCNT varchar2(32) NOT NULL,
	CACHE_SIZE_MIN Number(20,4) NOT NULL,
	CACHE_SIZE_MAX Number(20,4) NOT NULL,
	CACHE_SIZE_STCNT varchar2(32) NOT NULL,
	URL_COMMITS_MIN Number(20,4) NOT NULL,
	URL_COMMITS_MAX Number(20,4) NOT NULL,
	URL_COMMITS_STCNT varchar2(32) NOT NULL,
	URL_RETRIEVALS_MIN Number(20,4) NOT NULL,
	URL_RETRIEVALS_MAX Number(20,4) NOT NULL,
	URL_RETRIEVALS_STCNT varchar2(32) NOT NULL,
	URLS_IN_CACHE_MIN Number(20,4) NOT NULL,
	URLS_IN_CACHE_MAX Number(20,4) NOT NULL,
	URLS_IN_CACHE_STCNT varchar2(32) NOT NULL);

ALTER TABLE ProxyCacheTest_TREND ADD constraint PK_ProxyCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ProxyCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ProxyCacheTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	ACTIVE_REFRESH_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	ACTIVE_REFRESH_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	ACTIVE_URL_REFRESH_MIN	VARCHAR2(256)	 NOT NULL,
	ACTIVE_URL_REFRESH_MAX	VARCHAR2(256)	 NOT NULL,
	CACHE_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
	CACHE_SIZE_MAX	VARCHAR2(256)	 NOT NULL,
	URL_COMMITS_MIN	VARCHAR2(256)	 NOT NULL,
	URL_COMMITS_MAX	VARCHAR2(256)	 NOT NULL,
	URL_RETRIEVALS_MIN	VARCHAR2(256)	 NOT NULL,
	URL_RETRIEVALS_MAX	VARCHAR2(256)	 NOT NULL,
	URLS_IN_CACHE_MIN	VARCHAR2(256)	 NOT NULL,
	URLS_IN_CACHE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE ProxyCacheTest_THRESH ADD constraint PK_ProxyCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProxyCacheTest_THRESH ON ProxyCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxyServerTest CASCADE CONSTRAINTS;
CREATE TABLE ProxyServerTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	CACHE_HIT_RATIO Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_ST varchar2(32) NOT NULL,
	CLIENT_DATA_RECVD Number(20,4) NOT NULL,
	CLIENT_DATA_RECVD_ST varchar2(32) NOT NULL,
	CLIENT_DATA_SENT Number(20,4) NOT NULL,
	CLIENT_DATA_SENT_ST varchar2(32) NOT NULL,
	AVG_RESPONSE_TIME Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_ST varchar2(32) NOT NULL,
	CURRENT_USERS Number(20,4) NOT NULL,
	CURRENT_USERS_ST varchar2(32) NOT NULL,
	DNS_CACHE_HITS Number(20,4) NOT NULL,
	DNS_CACHE_HITS_ST varchar2(32) NOT NULL,
	FAILING_REQUESTS Number(20,4) NOT NULL,
	FAILING_REQUESTS_ST varchar2(32) NOT NULL,
	FTP_REQUESTS Number(20,4) NOT NULL,
	FTP_REQUESTS_ST varchar2(32) NOT NULL,
	HTTP_REQUESTS Number(20,4) NOT NULL,
	HTTP_REQUESTS_ST varchar2(32) NOT NULL,
	HTTPS_SESSIONS Number(20,4) NOT NULL,
	HTTPS_SESSIONS_ST varchar2(32) NOT NULL,
	THREAD_POOL_ACTIVE_SESS Number(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_ST varchar2(32) NOT NULL,
	THREAD_POOL_FAILURES Number(20,4) NOT NULL,
	THREAD_POOL_FAILURES_ST varchar2(32) NOT NULL,
	UPSTREAM_DATA_RECVD Number(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_ST varchar2(32) NOT NULL,
	UPSTREAM_DATA_SENT Number(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_ST varchar2(32) NOT NULL);

ALTER TABLE ProxyServerTest ADD constraint PK_ProxyServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ProxyServerTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ProxyServerTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	CACHE_HIT_RATIO_MIN Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_MAX Number(20,4) NOT NULL,
	CACHE_HIT_RATIO_STCNT varchar2(32) NOT NULL,
	CLIENT_DATA_RECVD_MIN Number(20,4) NOT NULL,
	CLIENT_DATA_RECVD_MAX Number(20,4) NOT NULL,
	CLIENT_DATA_RECVD_STCNT varchar2(32) NOT NULL,
	CLIENT_DATA_SENT_MIN Number(20,4) NOT NULL,
	CLIENT_DATA_SENT_MAX Number(20,4) NOT NULL,
	CLIENT_DATA_SENT_STCNT varchar2(32) NOT NULL,
	AVG_RESPONSE_TIME_MIN Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_MAX Number(20,4) NOT NULL,
	AVG_RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
	CURRENT_USERS_MIN Number(20,4) NOT NULL,
	CURRENT_USERS_MAX Number(20,4) NOT NULL,
	CURRENT_USERS_STCNT varchar2(32) NOT NULL,
	DNS_CACHE_HITS_MIN Number(20,4) NOT NULL,
	DNS_CACHE_HITS_MAX Number(20,4) NOT NULL,
	DNS_CACHE_HITS_STCNT varchar2(32) NOT NULL,
	FAILING_REQUESTS_MIN Number(20,4) NOT NULL,
	FAILING_REQUESTS_MAX Number(20,4) NOT NULL,
	FAILING_REQUESTS_STCNT varchar2(32) NOT NULL,
	FTP_REQUESTS_MIN Number(20,4) NOT NULL,
	FTP_REQUESTS_MAX Number(20,4) NOT NULL,
	FTP_REQUESTS_STCNT varchar2(32) NOT NULL,
	HTTP_REQUESTS_MIN Number(20,4) NOT NULL,
	HTTP_REQUESTS_MAX Number(20,4) NOT NULL,
	HTTP_REQUESTS_STCNT varchar2(32) NOT NULL,
	HTTPS_SESSIONS_MIN Number(20,4) NOT NULL,
	HTTPS_SESSIONS_MAX Number(20,4) NOT NULL,
	HTTPS_SESSIONS_STCNT varchar2(32) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MIN Number(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MAX Number(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_STCNT varchar2(32) NOT NULL,
	THREAD_POOL_FAILURES_MIN Number(20,4) NOT NULL,
	THREAD_POOL_FAILURES_MAX Number(20,4) NOT NULL,
	THREAD_POOL_FAILURES_STCNT varchar2(32) NOT NULL,
	UPSTREAM_DATA_RECVD_MIN Number(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_MAX Number(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_STCNT varchar2(32) NOT NULL,
	UPSTREAM_DATA_SENT_MIN Number(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_MAX Number(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_STCNT varchar2(32) NOT NULL);

ALTER TABLE ProxyServerTest_TREND ADD constraint PK_ProxyServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ProxyServerTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ProxyServerTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	CACHE_HIT_RATIO_MIN	VARCHAR2(256)	 NOT NULL,
	CACHE_HIT_RATIO_MAX	VARCHAR2(256)	 NOT NULL,
	CLIENT_DATA_RECVD_MIN	VARCHAR2(256)	 NOT NULL,
	CLIENT_DATA_RECVD_MAX	VARCHAR2(256)	 NOT NULL,
	CLIENT_DATA_SENT_MIN	VARCHAR2(256)	 NOT NULL,
	CLIENT_DATA_SENT_MAX	VARCHAR2(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
	CURRENT_USERS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRENT_USERS_MAX	VARCHAR2(256)	 NOT NULL,
	DNS_CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
	DNS_CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
	FAILING_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
	FAILING_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
	FTP_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
	FTP_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
	HTTP_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
	HTTP_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
	HTTPS_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
	HTTPS_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MIN	VARCHAR2(256)	 NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MAX	VARCHAR2(256)	 NOT NULL,
	THREAD_POOL_FAILURES_MIN	VARCHAR2(256)	 NOT NULL,
	THREAD_POOL_FAILURES_MAX	VARCHAR2(256)	 NOT NULL,
	UPSTREAM_DATA_RECVD_MIN	VARCHAR2(256)	 NOT NULL,
	UPSTREAM_DATA_RECVD_MAX	VARCHAR2(256)	 NOT NULL,
	UPSTREAM_DATA_SENT_MIN	VARCHAR2(256)	 NOT NULL,
	UPSTREAM_DATA_SENT_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE ProxyServerTest_THRESH ADD constraint PK_ProxyServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProxyServerTest_THRESH ON ProxyServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinSockTest CASCADE CONSTRAINTS;
CREATE TABLE WinSockTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	ACEPTING_TCP_CONNECTIONS Number(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_ST varchar2(32) NOT NULL,
	ACTIVE_SESSIONS Number(20,4) NOT NULL,
	ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
	ACTIVE_TCP_CONNECTIONS Number(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_ST varchar2(32) NOT NULL,
	ACTIVE_UDP_CONNECTIONS Number(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_ST varchar2(32) NOT NULL,
	AVAILABLE_WORKER_THREADS Number(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_ST varchar2(32) NOT NULL,
	DATA_RECV_RATE Number(20,4) NOT NULL,
	DATA_RECV_RATE_ST varchar2(32) NOT NULL,
	DATA_XMIT_RATE Number(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
	FAILED_DNS_RESOLUTIONS Number(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_ST varchar2(32) NOT NULL,
	PENDING_DNS_RESOLUTIONS Number(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_ST varchar2(32) NOT NULL,
	WORKER_THREADS Number(20,4) NOT NULL,
	WORKER_THREADS_ST varchar2(32) NOT NULL);

ALTER TABLE WinSockTest ADD constraint PK_WinSockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE WinSockTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE WinSockTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	ACEPTING_TCP_CONNECTIONS_MIN Number(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MAX Number(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_STCNT varchar2(32) NOT NULL,
	ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
	ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
	ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MIN Number(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MAX Number(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_STCNT varchar2(32) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MIN Number(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MAX Number(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_STCNT varchar2(32) NOT NULL,
	AVAILABLE_WORKER_THREADS_MIN Number(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_MAX Number(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_STCNT varchar2(32) NOT NULL,
	DATA_RECV_RATE_MIN Number(20,4) NOT NULL,
	DATA_RECV_RATE_MAX Number(20,4) NOT NULL,
	DATA_RECV_RATE_STCNT varchar2(32) NOT NULL,
	DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
	FAILED_DNS_RESOLUTIONS_MIN Number(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_MAX Number(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_STCNT varchar2(32) NOT NULL,
	PENDING_DNS_RESOLUTIONS_MIN Number(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_MAX Number(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_STCNT varchar2(32) NOT NULL,
	WORKER_THREADS_MIN Number(20,4) NOT NULL,
	WORKER_THREADS_MAX Number(20,4) NOT NULL,
	WORKER_THREADS_STCNT varchar2(32) NOT NULL);

ALTER TABLE WinSockTest_TREND ADD constraint PK_WinSockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinSockTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WinSockTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	ACEPTING_TCP_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
	AVAILABLE_WORKER_THREADS_MIN	VARCHAR2(256)	 NOT NULL,
	AVAILABLE_WORKER_THREADS_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_RECV_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_RECV_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
	FAILED_DNS_RESOLUTIONS_MIN	VARCHAR2(256)	 NOT NULL,
	FAILED_DNS_RESOLUTIONS_MAX	VARCHAR2(256)	 NOT NULL,
	PENDING_DNS_RESOLUTIONS_MIN	VARCHAR2(256)	 NOT NULL,
	PENDING_DNS_RESOLUTIONS_MAX	VARCHAR2(256)	 NOT NULL,
	WORKER_THREADS_MIN	VARCHAR2(256)	 NOT NULL,
	WORKER_THREADS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE WinSockTest_THRESH ADD constraint PK_WinSockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinSockTest_THRESH ON WinSockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxySvcTest CASCADE CONSTRAINTS;

CREATE TABLE ProxySvcTest 
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME       	date,
	AVAILABLE       	number(3)     	NOT NULL,
	AVAILABLE_ST       	varchar2(32)     	NOT NULL,
	RESP_TIME       	number(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL  	number(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar2(32)     	NOT NULL,
	TCP_CONN_TIME   	number(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar2(32)  	NOT NULL,
	SVR_RESP_TIME   	number(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar2(32)  	NOT NULL,
	CONTENT_VAL   		number(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar2(32)  	NOT NULL,
	RESP_CODE   		number(3)  	NOT NULL,
	RESP_CODE_ST   		varchar2(32)  	NOT NULL,
	CONTENT_LEN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar2(32)  	NOT NULL,
	DATA_XFER_TIME   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar2(32)  	NOT NULL
);

alter table ProxySvcTest add constraint PK_ProxySvcTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ProxySvcTest_TREND CASCADE CONSTRAINTS;

CREATE TABLE ProxySvcTest_TREND
(
	TRGT_HOST       		varchar2(32),
	PORT_NO         		varchar2(32),
        SITE_NAME              		varchar2(64),
        INFO                    	varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME       		date,
	PERIOD       			varchar2(32), 
	AVAILABLE_MIN       		number(20,4)     	NOT NULL,
	AVAILABLE_MAX       		number(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar2(32)    NOT NULL,
	RESP_TIME_MIN       		number(20,4)  	NOT NULL,
	RESP_TIME_MAX       		number(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar2(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		number(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		number(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar2(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		number(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar2(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		number(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_VAL_MIN   		number(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		number(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar2(32)  	NOT NULL,
	RESP_CODE_MIN   		number(20,4)  	NOT NULL,
	RESP_CODE_MAX   		number(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar2(32)  	NOT NULL,
	CONTENT_LEN_MIN   		number(20,4)  	NOT NULL,
	CONTENT_LEN_MAX   		number(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT   		varchar2(32)  	NOT NULL,
	DATA_XFER_TIME_MIN   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX   	number(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT   	varchar2(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX   	number(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT   	varchar2(32)  	NOT NULL
);

alter table ProxySvcTest_TREND add constraint PK_ProxySvcTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ProxySvcTest_THRESH CASCADE CONSTRAINTS;

CREATE TABLE ProxySvcTest_THRESH
(
	TRGT_HOST       	varchar2(32),
	PORT_NO         	varchar2(32),
        SITE_NAME               varchar2(64),
        INFO                    varchar2(128),
	MSMT_HOST 		varchar2(32), 
	MSMT_TIME_START       	date,
        MSMT_TIME_END           date,
        AVAILABLE_MIN	VARCHAR2(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR2(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR2(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR2(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_VAL_MAX	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MIN	VARCHAR2(256)	  NOT NULL,
        RESP_CODE_MAX	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MIN	VARCHAR2(256)	  NOT NULL,
        CONTENT_LEN_MAX	VARCHAR2(256)	  NOT NULL,
	DATA_XFER_TIME_MIN   	VARCHAR2(256)  	NOT NULL,
	DATA_XFER_TIME_MAX   	VARCHAR2(256)  	NOT NULL,
	DNS_AVAILABILITY_MIN   	VARCHAR2(256)  	NOT NULL,
	DNS_AVAILABILITY_MAX   	VARCHAR2(256)  	NOT NULL
);

alter table ProxySvcTest_THRESH add constraint PK_ProxySvcTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ProxySvcTest_THRESH ON ProxySvcTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE OraHttpSvrTest CASCADE CONSTRAINTS;
CREATE TABLE OraHttpSvrTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL,
REQUEST_RATE Number(20,4) NOT NULL,
REQUEST_RATE_ST varchar2(32) NOT NULL,
ACTIVE_CONNECTIONS Number(20,4) NOT NULL,
ACTIVE_CONNECTIONS_ST varchar2(32) NOT NULL,
CONNECTION_RATE Number(20,4) NOT NULL,
CONNECTION_RATE_ST varchar2(32) NOT NULL,
DATA_XMIT_RATE Number(20,4) NOT NULL,
DATA_XMIT_RATE_ST varchar2(32) NOT NULL,
ERROR_RATE Number(20,4) NOT NULL,
ERROR_RATE_ST varchar2(32) NOT NULL,
POST_REQUEST_RATE Number(20,4) NOT NULL,
POST_REQUEST_RATE_ST varchar2(32) NOT NULL,
GET_REQUEST_RATE Number(20,4) NOT NULL,
GET_REQUEST_RATE_ST varchar2(32) NOT NULL);

ALTER TABLE OraHttpSvrTest ADD constraint PK_OraHttpSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraHttpSvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraHttpSvrTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
REQUEST_RATE_MIN Number(20,4) NOT NULL,
REQUEST_RATE_MAX Number(20,4) NOT NULL,
REQUEST_RATE_STCNT varchar2(32) NOT NULL,
ACTIVE_CONNECTIONS_MIN Number(20,4) NOT NULL,
ACTIVE_CONNECTIONS_MAX Number(20,4) NOT NULL,
ACTIVE_CONNECTIONS_STCNT varchar2(32) NOT NULL,
CONNECTION_RATE_MIN Number(20,4) NOT NULL,
CONNECTION_RATE_MAX Number(20,4) NOT NULL,
CONNECTION_RATE_STCNT varchar2(32) NOT NULL,
DATA_XMIT_RATE_MIN Number(20,4) NOT NULL,
DATA_XMIT_RATE_MAX Number(20,4) NOT NULL,
DATA_XMIT_RATE_STCNT varchar2(32) NOT NULL,
ERROR_RATE_MIN Number(20,4) NOT NULL,
ERROR_RATE_MAX Number(20,4) NOT NULL,
ERROR_RATE_STCNT varchar2(32) NOT NULL,
POST_REQUEST_RATE_MIN Number(20,4) NOT NULL,
POST_REQUEST_RATE_MAX Number(20,4) NOT NULL,
POST_REQUEST_RATE_STCNT varchar2(32) NOT NULL,
GET_REQUEST_RATE_MIN Number(20,4) NOT NULL,
GET_REQUEST_RATE_MAX Number(20,4) NOT NULL,
GET_REQUEST_RATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraHttpSvrTest_TREND ADD constraint PK_OraHttpSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraHttpSvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraHttpSvrTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RESPONSE_TIME_MIN	VARCHAR2(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR2(256)	 NOT NULL,
REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL,
ACTIVE_CONNECTIONS_MIN	VARCHAR2(256)	 NOT NULL,
ACTIVE_CONNECTIONS_MAX	VARCHAR2(256)	 NOT NULL,
CONNECTION_RATE_MIN	VARCHAR2(256)	 NOT NULL,
CONNECTION_RATE_MAX	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DATA_XMIT_RATE_MAX	VARCHAR2(256)	 NOT NULL,
ERROR_RATE_MIN	VARCHAR2(256)	 NOT NULL,
ERROR_RATE_MAX	VARCHAR2(256)	 NOT NULL,
POST_REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
POST_REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL,
GET_REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
GET_REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraHttpSvrTest_THRESH ADD constraint PK_OraHttpSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraHttpSvrTest_THRESH ON OraHttpSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE OraContentCachTest CASCADE CONSTRAINTS;
CREATE TABLE OraContentCachTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REQUEST_RATE Number(20,4) NOT NULL,
REQUEST_RATE_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL);

ALTER TABLE OraContentCachTest ADD constraint PK_OraContentCachTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraContentCachTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraContentCachTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REQUEST_RATE_MIN Number(20,4) NOT NULL,
REQUEST_RATE_MAX Number(20,4) NOT NULL,
REQUEST_RATE_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraContentCachTest_TREND ADD constraint PK_OraContentCachTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraContentCachTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraContentCachTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraContentCachTest_THRESH ADD constraint PK_OraContentCachTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraContentCachTest_THRESH ON OraContentCachTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE OraHttpRespTest CASCADE CONSTRAINTS;
CREATE TABLE OraHttpRespTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PCT_200S Number(20,4) NOT NULL,
PCT_200S_ST varchar2(32) NOT NULL,
PCT_ERRORS Number(20,4) NOT NULL,
PCT_ERRORS_ST varchar2(32) NOT NULL,
PCT_300S Number(20,4) NOT NULL,
PCT_300S_ST varchar2(32) NOT NULL,
PCT_400_ERRORS Number(20,4) NOT NULL,
PCT_400_ERRORS_ST varchar2(32) NOT NULL,
PCT_500_ERRORS Number(20,4) NOT NULL,
PCT_500_ERRORS_ST varchar2(32) NOT NULL);

ALTER TABLE OraHttpRespTest ADD constraint PK_OraHttpRespTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraHttpRespTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraHttpRespTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PCT_200S_MIN Number(20,4) NOT NULL,
PCT_200S_MAX Number(20,4) NOT NULL,
PCT_200S_STCNT varchar2(32) NOT NULL,
PCT_ERRORS_MIN Number(20,4) NOT NULL,
PCT_ERRORS_MAX Number(20,4) NOT NULL,
PCT_ERRORS_STCNT varchar2(32) NOT NULL,
PCT_300S_MIN Number(20,4) NOT NULL,
PCT_300S_MAX Number(20,4) NOT NULL,
PCT_300S_STCNT varchar2(32) NOT NULL,
PCT_400_ERRORS_MIN Number(20,4) NOT NULL,
PCT_400_ERRORS_MAX Number(20,4) NOT NULL,
PCT_400_ERRORS_STCNT varchar2(32) NOT NULL,
PCT_500_ERRORS_MIN Number(20,4) NOT NULL,
PCT_500_ERRORS_MAX Number(20,4) NOT NULL,
PCT_500_ERRORS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraHttpRespTest_TREND ADD constraint PK_OraHttpRespTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraHttpRespTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraHttpRespTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PCT_200S_MIN	VARCHAR2(256)	 NOT NULL,
PCT_200S_MAX	VARCHAR2(256)	 NOT NULL,
PCT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
PCT_300S_MIN	VARCHAR2(256)	 NOT NULL,
PCT_300S_MAX	VARCHAR2(256)	 NOT NULL,
PCT_400_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_400_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
PCT_500_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_500_ERRORS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraHttpRespTest_THRESH ADD constraint PK_OraHttpRespTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraHttpRespTest_THRESH ON OraHttpRespTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE OraSessCacheTest CASCADE CONSTRAINTS;
CREATE TABLE OraSessCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
REQUEST_RATE Number(20,4) NOT NULL,
REQUEST_RATE_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL);

ALTER TABLE OraSessCacheTest ADD constraint PK_OraSessCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraSessCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraSessCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
REQUEST_RATE_MIN Number(20,4) NOT NULL,
REQUEST_RATE_MAX Number(20,4) NOT NULL,
REQUEST_RATE_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraSessCacheTest_TREND ADD constraint PK_OraSessCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraSessCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraSessCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
REQUEST_RATE_MIN	VARCHAR2(256)	 NOT NULL,
REQUEST_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR2(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraSessCacheTest_THRESH ADD constraint PK_OraSessCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraSessCacheTest_THRESH ON OraSessCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE OraPlsqlRespTest CASCADE CONSTRAINTS;
CREATE TABLE OraPlsqlRespTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PCT_200S Number(20,4) NOT NULL,
PCT_200S_ST varchar2(32) NOT NULL,
PCT_ERRORS Number(20,4) NOT NULL,
PCT_ERRORS_ST varchar2(32) NOT NULL,
PCT_300S Number(20,4) NOT NULL,
PCT_300S_ST varchar2(32) NOT NULL,
PCT_400_ERRORS Number(20,4) NOT NULL,
PCT_400_ERRORS_ST varchar2(32) NOT NULL,
PCT_500_ERRORS Number(20,4) NOT NULL,
PCT_500_ERRORS_ST varchar2(32) NOT NULL);

ALTER TABLE OraPlsqlRespTest ADD constraint PK_OraPlsqlRespTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraPlsqlRespTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraPlsqlRespTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PCT_200S_MIN Number(20,4) NOT NULL,
PCT_200S_MAX Number(20,4) NOT NULL,
PCT_200S_STCNT varchar2(32) NOT NULL,
PCT_ERRORS_MIN Number(20,4) NOT NULL,
PCT_ERRORS_MAX Number(20,4) NOT NULL,
PCT_ERRORS_STCNT varchar2(32) NOT NULL,
PCT_300S_MIN Number(20,4) NOT NULL,
PCT_300S_MAX Number(20,4) NOT NULL,
PCT_300S_STCNT varchar2(32) NOT NULL,
PCT_400_ERRORS_MIN Number(20,4) NOT NULL,
PCT_400_ERRORS_MAX Number(20,4) NOT NULL,
PCT_400_ERRORS_STCNT varchar2(32) NOT NULL,
PCT_500_ERRORS_MIN Number(20,4) NOT NULL,
PCT_500_ERRORS_MAX Number(20,4) NOT NULL,
PCT_500_ERRORS_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraPlsqlRespTest_TREND ADD constraint PK_OraPlsqlRespTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraPlsqlRespTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraPlsqlRespTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PCT_200S_MIN	VARCHAR2(256)	 NOT NULL,
PCT_200S_MAX	VARCHAR2(256)	 NOT NULL,
PCT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
PCT_300S_MIN	VARCHAR2(256)	 NOT NULL,
PCT_300S_MAX	VARCHAR2(256)	 NOT NULL,
PCT_400_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_400_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
PCT_500_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_500_ERRORS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE OraPlsqlRespTest_THRESH ADD constraint PK_OraPlsqlRespTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraPlsqlRespTest_THRESH ON OraPlsqlRespTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

  
DROP TABLE PrintSrvrTest CASCADE CONSTRAINTS;
CREATE TABLE PrintSrvrTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	JOBS_SERVICED Number(20,4) NOT NULL,
	JOBS_SERVICED_ST varchar2(32) NOT NULL,
	PAGES_PRINTED Number(16) NOT NULL,
	PAGES_PRINTED_ST varchar2(32) NOT NULL,
	PRINT_TRAFFIC Number(20,4) NOT NULL,
	PRINT_TRAFFIC_ST varchar2(32) NOT NULL,
	CURRENT_JOBS Number(16) NOT NULL,
	CURRENT_JOBS_ST varchar2(32) NOT NULL,
	PRINT_ERRORS Number(16) NOT NULL,
	PRINT_ERRORS_ST varchar2(32) NOT NULL,
	SPOOLED_JOBS Number(16) NOT NULL,
	SPOOLED_JOBS_ST varchar2(32) NOT NULL,
	PAPER_ERRORS Number(16) NOT NULL,
	PAPER_ERRORS_ST varchar2(32) NOT NULL,
	NOT_READY_ERRORS Number(16) NOT NULL,
	NOT_READY_ERRORS_ST varchar2(32) NOT NULL,
	AVAILABLE Number(16) NOT NULL,
	AVAILABLE_ST varchar2(32) NOT NULL);

ALTER TABLE PrintSrvrTest ADD constraint PK_PrintSrvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE PrintSrvrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE PrintSrvrTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	JOBS_SERVICED_MIN Number(20,4) NOT NULL,
	JOBS_SERVICED_MAX Number(20,4) NOT NULL,
	JOBS_SERVICED_STCNT varchar2(32) NOT NULL,
	PAGES_PRINTED_MIN Number(16) NOT NULL,
	PAGES_PRINTED_MAX Number(16) NOT NULL,
	PAGES_PRINTED_STCNT varchar2(32) NOT NULL,
	PRINT_TRAFFIC_MIN Number(20,4) NOT NULL,
	PRINT_TRAFFIC_MAX Number(20,4) NOT NULL,
	PRINT_TRAFFIC_STCNT varchar2(32) NOT NULL,
	CURRENT_JOBS_MIN Number(16) NOT NULL,
	CURRENT_JOBS_MAX Number(16) NOT NULL,
	CURRENT_JOBS_STCNT varchar2(32) NOT NULL,
	PRINT_ERRORS_MIN Number(16) NOT NULL,
	PRINT_ERRORS_MAX Number(16) NOT NULL,
	PRINT_ERRORS_STCNT varchar2(32) NOT NULL,
	SPOOLED_JOBS_MIN Number(16) NOT NULL,
	SPOOLED_JOBS_MAX Number(16) NOT NULL,
	SPOOLED_JOBS_STCNT varchar2(32) NOT NULL,
	PAPER_ERRORS_MIN Number(16) NOT NULL,
	PAPER_ERRORS_MAX Number(16) NOT NULL,
	PAPER_ERRORS_STCNT varchar2(32) NOT NULL,
	NOT_READY_ERRORS_MIN Number(16) NOT NULL,
	NOT_READY_ERRORS_MAX Number(16) NOT NULL,
	NOT_READY_ERRORS_STCNT varchar2(32) NOT NULL,
	AVAILABLE_MIN Number(16) NOT NULL,
	AVAILABLE_MAX Number(16) NOT NULL,
	AVAILABLE_STCNT varchar2(32) NOT NULL);

ALTER TABLE PrintSrvrTest_TREND ADD constraint PK_PrintSrvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE PrintSrvrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE PrintSrvrTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	JOBS_SERVICED_MIN	VARCHAR2(256)	 NOT NULL,
	JOBS_SERVICED_MAX	VARCHAR2(256)	 NOT NULL,
	PAGES_PRINTED_MIN	VARCHAR2(256)	 NOT NULL,
	PAGES_PRINTED_MAX	VARCHAR2(256)	 NOT NULL,
	PRINT_TRAFFIC_MIN	VARCHAR2(256)	 NOT NULL,
	PRINT_TRAFFIC_MAX	VARCHAR2(256)	 NOT NULL,
	CURRENT_JOBS_MIN	VARCHAR2(256)	 NOT NULL,
	CURRENT_JOBS_MAX	VARCHAR2(256)	 NOT NULL,
	PRINT_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	PRINT_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	SPOOLED_JOBS_MIN	VARCHAR2(256)	 NOT NULL,
	SPOOLED_JOBS_MAX	VARCHAR2(256)	 NOT NULL,
	PAPER_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	PAPER_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	NOT_READY_ERRORS_MIN	VARCHAR2(256)	 NOT NULL,
	NOT_READY_ERRORS_MAX	VARCHAR2(256)	 NOT NULL,
	AVAILABLE_MIN VARCHAR2(256)	 NOT NULL,
	AVAILABLE_MAX VARCHAR2(256)	 NOT NULL);

ALTER TABLE PrintSrvrTest_THRESH ADD constraint PK_PrintSrvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_PrintSrvrTest_THRESH ON PrintSrvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE F9iProcessTest CASCADE CONSTRAINTS;
CREATE TABLE F9iProcessTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUM_PROCS_RUNNING Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_ST varchar2(32) NOT NULL,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL,
MEMORY_UTIL Number(20,4) NOT NULL,
MEMORY_UTIL_ST varchar2(32) NOT NULL);

ALTER TABLE F9iProcessTest ADD constraint PK_F9iProcessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE F9iProcessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE F9iProcessTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUM_PROCS_RUNNING_MIN Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_MAX Number(20,4) NOT NULL,
NUM_PROCS_RUNNING_STCNT varchar2(32) NOT NULL,
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL,
MEMORY_UTIL_MIN Number(20,4) NOT NULL,
MEMORY_UTIL_MAX Number(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE F9iProcessTest_TREND ADD constraint PK_F9iProcessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE F9iProcessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE F9iProcessTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUM_PROCS_RUNNING_MIN	VARCHAR2(256)	 NOT NULL,
NUM_PROCS_RUNNING_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE F9iProcessTest_THRESH ADD constraint PK_F9iProcessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_F9iProcessTest_THRESH ON F9iProcessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE F9iUserTest CASCADE CONSTRAINTS;
CREATE TABLE F9iUserTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FORMS_REQ_RATE Number(20,4) NOT NULL,
FORMS_REQ_RATE_ST varchar2(32) NOT NULL,
DB_REQ_RATE Number(20,4) NOT NULL,
DB_REQ_RATE_ST varchar2(32) NOT NULL,
CLIENT_NETWORK_RESP_TIME Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_ST varchar2(32) NOT NULL,
FORMS_SERVER_RESP_TIME Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_ST varchar2(32) NOT NULL,
DB_RESP_TIME Number(20,4) NOT NULL,
DB_RESP_TIME_ST varchar2(32) NOT NULL,
NO_OF_SESSIONS Number(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar2(32) NOT NULL,
AVG_SESSION_DURATION Number(20,4) NOT NULL,
AVG_SESSION_DURATION_ST varchar2(32) NOT NULL,
MEMORY_UTIL Number(20,4) NOT NULL,
MEMORY_UTIL_ST varchar2(32) NOT NULL,
CPU_UTIL Number(20,4) NOT NULL,
CPU_UTIL_ST varchar2(32) NOT NULL);

ALTER TABLE F9iUserTest ADD constraint PK_F9iUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE F9iUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE F9iUserTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FORMS_REQ_RATE_MIN Number(20,4) NOT NULL,
FORMS_REQ_RATE_MAX Number(20,4) NOT NULL,
FORMS_REQ_RATE_STCNT varchar2(32) NOT NULL,
DB_REQ_RATE_MIN Number(20,4) NOT NULL,
DB_REQ_RATE_MAX Number(20,4) NOT NULL,
DB_REQ_RATE_STCNT varchar2(32) NOT NULL,
CLIENT_NETWORK_RESP_TIME_MIN Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_MAX Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_STCNT varchar2(32) NOT NULL,
FORMS_SERVER_RESP_TIME_MIN Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_MAX Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_STCNT varchar2(32) NOT NULL,
DB_RESP_TIME_MIN Number(20,4) NOT NULL,
DB_RESP_TIME_MAX Number(20,4) NOT NULL,
DB_RESP_TIME_STCNT varchar2(32) NOT NULL,
NO_OF_SESSIONS_MIN Number(20,4) NOT NULL,
NO_OF_SESSIONS_MAX Number(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar2(32) NOT NULL,
AVG_SESSION_DURATION_MIN Number(20,4) NOT NULL,
AVG_SESSION_DURATION_MAX Number(20,4) NOT NULL,
AVG_SESSION_DURATION_STCNT varchar2(32) NOT NULL,
MEMORY_UTIL_MIN Number(20,4) NOT NULL,
MEMORY_UTIL_MAX Number(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar2(32) NOT NULL,
CPU_UTIL_MIN Number(20,4) NOT NULL,
CPU_UTIL_MAX Number(20,4) NOT NULL,
CPU_UTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE F9iUserTest_TREND ADD constraint PK_F9iUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE F9iUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE F9iUserTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FORMS_REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
FORMS_REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
DB_REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DB_REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CLIENT_NETWORK_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
CLIENT_NETWORK_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL,
FORMS_SERVER_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
FORMS_SERVER_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL,
DB_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
DB_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_DURATION_MIN	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_DURATION_MAX	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
MEMORY_UTIL_MAX	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR2(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE F9iUserTest_THRESH ADD constraint PK_F9iUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_F9iUserTest_THRESH ON F9iUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE F9iSessionTest CASCADE CONSTRAINTS;
CREATE TABLE F9iSessionTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTAL_SESSIONS Number(20,4) NOT NULL,
TOTAL_SESSIONS_ST varchar2(32) NOT NULL,
ACTIVE_SESSIONS Number(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar2(32) NOT NULL,
IDLE_SESSIONS Number(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar2(32) NOT NULL,
SESSIONS_ADDED Number(20,4) NOT NULL,
SESSIONS_ADDED_ST varchar2(32) NOT NULL,
SESSIONS_REMOVED Number(20,4) NOT NULL,
SESSIONS_REMOVED_ST varchar2(32) NOT NULL,
AVG_SESSION_DURATION Number(20,4) NOT NULL,
AVG_SESSION_DURATION_ST varchar2(32) NOT NULL);

ALTER TABLE F9iSessionTest ADD constraint PK_F9iSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE F9iSessionTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE F9iSessionTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTAL_SESSIONS_MIN Number(20,4) NOT NULL,
TOTAL_SESSIONS_MAX Number(20,4) NOT NULL,
TOTAL_SESSIONS_STCNT varchar2(32) NOT NULL,
ACTIVE_SESSIONS_MIN Number(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX Number(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar2(32) NOT NULL,
IDLE_SESSIONS_MIN Number(20,4) NOT NULL,
IDLE_SESSIONS_MAX Number(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar2(32) NOT NULL,
SESSIONS_ADDED_MIN Number(20,4) NOT NULL,
SESSIONS_ADDED_MAX Number(20,4) NOT NULL,
SESSIONS_ADDED_STCNT varchar2(32) NOT NULL,
SESSIONS_REMOVED_MIN Number(20,4) NOT NULL,
SESSIONS_REMOVED_MAX Number(20,4) NOT NULL,
SESSIONS_REMOVED_STCNT varchar2(32) NOT NULL,
AVG_SESSION_DURATION_MIN Number(20,4) NOT NULL,
AVG_SESSION_DURATION_MAX Number(20,4) NOT NULL,
AVG_SESSION_DURATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE F9iSessionTest_TREND ADD constraint PK_F9iSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE F9iSessionTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE F9iSessionTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
TOTAL_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
ACTIVE_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
ACTIVE_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
IDLE_SESSIONS_MIN	VARCHAR2(256)	 NOT NULL,
IDLE_SESSIONS_MAX	VARCHAR2(256)	 NOT NULL,
SESSIONS_ADDED_MIN	VARCHAR2(256)	 NOT NULL,
SESSIONS_ADDED_MAX	VARCHAR2(256)	 NOT NULL,
SESSIONS_REMOVED_MIN	VARCHAR2(256)	 NOT NULL,
SESSIONS_REMOVED_MAX	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_DURATION_MIN	VARCHAR2(256)	 NOT NULL,
AVG_SESSION_DURATION_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE F9iSessionTest_THRESH ADD constraint PK_F9iSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_F9iSessionTest_THRESH ON F9iSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE F9iResponseTest CASCADE CONSTRAINTS;
CREATE TABLE F9iResponseTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FORMS_REQ_RATE Number(20,4) NOT NULL,
FORMS_REQ_RATE_ST varchar2(32) NOT NULL,
DB_REQ_RATE Number(20,4) NOT NULL,
DB_REQ_RATE_ST varchar2(32) NOT NULL,
CLIENT_NETWORK_RESP_TIME Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_ST varchar2(32) NOT NULL,
FORMS_SERVER_RESP_TIME Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_ST varchar2(32) NOT NULL,
DB_RESP_TIME Number(20,4) NOT NULL,
DB_RESP_TIME_ST varchar2(32) NOT NULL);

ALTER TABLE F9iResponseTest ADD constraint PK_F9iResponseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE F9iResponseTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE F9iResponseTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FORMS_REQ_RATE_MIN Number(20,4) NOT NULL,
FORMS_REQ_RATE_MAX Number(20,4) NOT NULL,
FORMS_REQ_RATE_STCNT varchar2(32) NOT NULL,
DB_REQ_RATE_MIN Number(20,4) NOT NULL,
DB_REQ_RATE_MAX Number(20,4) NOT NULL,
DB_REQ_RATE_STCNT varchar2(32) NOT NULL,
CLIENT_NETWORK_RESP_TIME_MIN Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_MAX Number(20,4) NOT NULL,
CLIENT_NETWORK_RESP_TIME_STCNT varchar2(32) NOT NULL,
FORMS_SERVER_RESP_TIME_MIN Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_MAX Number(20,4) NOT NULL,
FORMS_SERVER_RESP_TIME_STCNT varchar2(32) NOT NULL,
DB_RESP_TIME_MIN Number(20,4) NOT NULL,
DB_RESP_TIME_MAX Number(20,4) NOT NULL,
DB_RESP_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE F9iResponseTest_TREND ADD constraint PK_F9iResponseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE F9iResponseTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE F9iResponseTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FORMS_REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
FORMS_REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
DB_REQ_RATE_MIN	VARCHAR2(256)	 NOT NULL,
DB_REQ_RATE_MAX	VARCHAR2(256)	 NOT NULL,
CLIENT_NETWORK_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
CLIENT_NETWORK_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL,
FORMS_SERVER_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
FORMS_SERVER_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL,
DB_RESP_TIME_MIN	VARCHAR2(256)	 NOT NULL,
DB_RESP_TIME_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE F9iResponseTest_THRESH ADD constraint PK_F9iResponseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_F9iResponseTest_THRESH ON F9iResponseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DirTest CASCADE CONSTRAINTS;
CREATE TABLE DirTest(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	TOTAL_FILES Number(20,4) NOT NULL,
	TOTAL_FILES_ST varchar2(32) NOT NULL,
	TOTAL_SUB_DIRECTORIES Number(20,4) NOT NULL,
	TOTAL_SUB_DIRECTORIES_ST varchar2(32) NOT NULL,
	MODIFIED_FILES Number(20,4) NOT NULL,
	MODIFIED_FILES_ST varchar2(32) NOT NULL,
	DIRECTORY_SIZE Number(20,4) NOT NULL,
	DIRECTORY_SIZE_ST varchar2(32) NOT NULL);

ALTER TABLE DirTest ADD constraint PK_DirTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DirTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE DirTest_TREND(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME       date,
	PERIOD       	varchar2(32),
	TOTAL_FILES_MIN Number(20,4) NOT NULL,
	TOTAL_FILES_MAX Number(20,4) NOT NULL,
	TOTAL_FILES_STCNT varchar2(32) NOT NULL,
	TOTAL_SUB_DIRECTORIES_MIN Number(20,4) NOT NULL,
	TOTAL_SUB_DIRECTORIES_MAX Number(20,4) NOT NULL,
	TOTAL_SUB_DIRECTORIES_STCNT varchar2(32) NOT NULL,
	MODIFIED_FILES_MIN Number(20,4) NOT NULL,
	MODIFIED_FILES_MAX Number(20,4) NOT NULL,
	MODIFIED_FILES_STCNT varchar2(32) NOT NULL,
	DIRECTORY_SIZE_MIN Number(20,4) NOT NULL,
	DIRECTORY_SIZE_MAX Number(20,4) NOT NULL,
	DIRECTORY_SIZE_STCNT varchar2(32) NOT NULL);

ALTER TABLE DirTest_TREND ADD constraint PK_DirTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DirTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE DirTest_THRESH(
	TRGT_HOST       varchar2(32),
	PORT_NO         varchar2(32),
	SITE_NAME       varchar2(64),
	INFO            varchar2(128),
	MSMT_HOST       varchar2(32),
	MSMT_TIME_START date,
	MSMT_TIME_END   date,
	TOTAL_FILES_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_FILES_MAX	VARCHAR2(256)	 NOT NULL,
	TOTAL_SUB_DIRECTORIES_MIN	VARCHAR2(256)	 NOT NULL,
	TOTAL_SUB_DIRECTORIES_MAX	VARCHAR2(256)	 NOT NULL,
	MODIFIED_FILES_MIN	VARCHAR2(256)	 NOT NULL,
	MODIFIED_FILES_MAX	VARCHAR2(256)	 NOT NULL,
	DIRECTORY_SIZE_MIN	VARCHAR2(256)	 NOT NULL,
	DIRECTORY_SIZE_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE DirTest_THRESH ADD constraint PK_DirTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DirTest_THRESH ON DirTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MySqlTransTest CASCADE CONSTRAINTS;
CREATE TABLE MySqlTransTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
USER_COMMITS Number(20,4) NOT NULL,
USER_COMMITS_ST varchar2(32) NOT NULL,
USER_ROLLBACKS Number(20,4) NOT NULL,
USER_ROLLBACKS_ST varchar2(32) NOT NULL,
PCT_ROLLBACKS Number(20,4) NOT NULL,
PCT_ROLLBACKS_ST varchar2(32) NOT NULL);

ALTER TABLE MySqlTransTest ADD constraint PK_MySqlTransTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MySqlTransTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MySqlTransTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
USER_COMMITS_MIN Number(20,4) NOT NULL,
USER_COMMITS_MAX Number(20,4) NOT NULL,
USER_COMMITS_STCNT varchar2(32) NOT NULL,
USER_ROLLBACKS_MIN Number(20,4) NOT NULL,
USER_ROLLBACKS_MAX Number(20,4) NOT NULL,
USER_ROLLBACKS_STCNT varchar2(32) NOT NULL,
PCT_ROLLBACKS_MIN Number(20,4) NOT NULL,
PCT_ROLLBACKS_MAX Number(20,4) NOT NULL,
PCT_ROLLBACKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MySqlTransTest_TREND ADD constraint PK_MySqlTransTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MySqlTransTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MySqlTransTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
USER_COMMITS_MIN	VARCHAR2(256)	 NOT NULL,
USER_COMMITS_MAX	VARCHAR2(256)	 NOT NULL,
USER_ROLLBACKS_MIN	VARCHAR2(256)	 NOT NULL,
USER_ROLLBACKS_MAX	VARCHAR2(256)	 NOT NULL,
PCT_ROLLBACKS_MIN	VARCHAR2(256)	 NOT NULL,
PCT_ROLLBACKS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MySqlTransTest_THRESH ADD constraint PK_MySqlTransTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MySqlTransTest_THRESH ON MySqlTransTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MySqlCacheTest CASCADE CONSTRAINTS;
CREATE TABLE MySqlCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
KEY_READS Number(20,4) NOT NULL,
KEY_READS_ST varchar2(32) NOT NULL,
KEY_READ_REQUESTS Number(20,4) NOT NULL,
KEY_READ_REQUESTS_ST varchar2(32) NOT NULL,
NOT_FLUSHED_KEY_BLOCKS Number(20,4) NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_ST varchar2(32) NOT NULL);

ALTER TABLE MySqlCacheTest ADD constraint PK_MySqlCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MySqlCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MySqlCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
KEY_READS_MIN Number(20,4) NOT NULL,
KEY_READS_MAX Number(20,4) NOT NULL,
KEY_READS_STCNT varchar2(32) NOT NULL,
KEY_READ_REQUESTS_MIN Number(20,4) NOT NULL,
KEY_READ_REQUESTS_MAX Number(20,4) NOT NULL,
KEY_READ_REQUESTS_STCNT varchar2(32) NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_MIN Number(20,4) NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_MAX Number(20,4) NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MySqlCacheTest_TREND ADD constraint PK_MySqlCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MySqlCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MySqlCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
KEY_READS_MIN	VARCHAR2(256)	 NOT NULL,
KEY_READS_MAX	VARCHAR2(256)	 NOT NULL,
KEY_READ_REQUESTS_MIN	VARCHAR2(256)	 NOT NULL,
KEY_READ_REQUESTS_MAX	VARCHAR2(256)	 NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_MIN	VARCHAR2(256)	 NOT NULL,
NOT_FLUSHED_KEY_BLOCKS_MAX	VARCHAR2(256)	 NOT NULL);

ALTER TABLE MySqlCacheTest_THRESH ADD constraint PK_MySqlCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MySqlCacheTest_THRESH ON MySqlCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MySqlConnTest CASCADE CONSTRAINTS;
CREATE TABLE MySqlConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CONNS_CREATE_RATE Number(20,4) NOT NULL,
CONNS_CREATE_RATE_ST varchar2(32) NOT NU