DROP TABLE XMAppNameTest;
CREATE TABLE XMAppNameTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SUCCESSFUL_APPLICATION DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar(32) NOT NULL,
FAILED_APPLICATION DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_XMAppNameTest ON XMAppNameTest(MSMT_TIME);
ALTER TABLE XMAppNameTest ADD constraint PK_XMAppNameTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppNameTest_TREND;
CREATE TABLE XMAppNameTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar(32) NOT NULL,
FAILED_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE XMAppNameTest_TREND ADD constraint PK_XMAppNameTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppNameTest_THRESH;
CREATE TABLE XMAppNameTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SUCCESSFUL_APPLICATION_MIN VARCHAR(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MIN VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE XMAppNameTest_THRESH ADD constraint PK_XMAppNameTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppNameTest_THRESH ON XMAppNameTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppNameTest ON XMAppNameTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppNameTest ON XMAppNameTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppLaunchTest;
CREATE TABLE XMAppLaunchTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SUCCESSFUL_APPLICATION DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar(32) NOT NULL,
FAILED_APPLICATION DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_XMAppLaunchTest ON XMAppLaunchTest(MSMT_TIME);
ALTER TABLE XMAppLaunchTest ADD constraint PK_XMAppLaunchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppLaunchTest_TREND;
CREATE TABLE XMAppLaunchTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar(32) NOT NULL,
FAILED_APPLICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar(32) NOT NULL);

ALTER TABLE XMAppLaunchTest_TREND ADD constraint PK_XMAppLaunchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppLaunchTest_THRESH;
CREATE TABLE XMAppLaunchTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SUCCESSFUL_APPLICATION_MIN VARCHAR(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MIN VARCHAR(256) NOT NULL,
FAILED_APPLICATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE XMAppLaunchTest_THRESH ADD constraint PK_XMAppLaunchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppLaunchTest_THRESH ON XMAppLaunchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppLaunchTest ON XMAppLaunchTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppLaunchTest ON XMAppLaunchTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBCpuUsageTest;
CREATE TABLE UEBCpuUsageTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CPU_USAGE DECIMAL(20,4) NOT NULL,
CPU_USAGE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBCpuUsageTest ON UEBCpuUsageTest(MSMT_TIME);
ALTER TABLE UEBCpuUsageTest ADD constraint PK_UEBCpuUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBCpuUsageTest_TREND;
CREATE TABLE UEBCpuUsageTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CPU_USAGE_MIN DECIMAL(20,4) NOT NULL,
CPU_USAGE_MAX DECIMAL(20,4) NOT NULL,
CPU_USAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBCpuUsageTest_TREND ADD constraint PK_UEBCpuUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBCpuUsageTest_THRESH;
CREATE TABLE UEBCpuUsageTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CPU_USAGE_MIN VARCHAR(256) NOT NULL,
CPU_USAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBCpuUsageTest_THRESH ADD constraint PK_UEBCpuUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBCpuUsageTest_THRESH ON UEBCpuUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBCpuUsageTest ON UEBCpuUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBCpuUsageTest ON UEBCpuUsageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBMemUsageTest;
CREATE TABLE UEBMemUsageTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MEMORY DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar(32) NOT NULL,
USED_MEMORY DECIMAL(20,4) NOT NULL,
USED_MEMORY_ST varchar(32) NOT NULL,
FREE_MEMORY DECIMAL(20,4) NOT NULL,
FREE_MEMORY_ST varchar(32) NOT NULL,
MEMORY_UTILIZATION DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBMemUsageTest ON UEBMemUsageTest(MSMT_TIME);
ALTER TABLE UEBMemUsageTest ADD constraint PK_UEBMemUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBMemUsageTest_TREND;
CREATE TABLE UEBMemUsageTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MEMORY_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar(32) NOT NULL,
USED_MEMORY_MIN DECIMAL(20,4) NOT NULL,
USED_MEMORY_MAX DECIMAL(20,4) NOT NULL,
USED_MEMORY_STCNT varchar(32) NOT NULL,
FREE_MEMORY_MIN DECIMAL(20,4) NOT NULL,
FREE_MEMORY_MAX DECIMAL(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar(32) NOT NULL,
MEMORY_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBMemUsageTest_TREND ADD constraint PK_UEBMemUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBMemUsageTest_THRESH;
CREATE TABLE UEBMemUsageTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MEMORY_MIN VARCHAR(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR(256) NOT NULL,
USED_MEMORY_MIN VARCHAR(256) NOT NULL,
USED_MEMORY_MAX VARCHAR(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBMemUsageTest_THRESH ADD constraint PK_UEBMemUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBMemUsageTest_THRESH ON UEBMemUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBMemUsageTest ON UEBMemUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBMemUsageTest ON UEBMemUsageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBArchivStatTest;
CREATE TABLE UEBArchivStatTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
STATUS DECIMAL(20,4) NOT NULL,
STATUS_ST varchar(32) NOT NULL,
SIZES DECIMAL(20,4) NOT NULL,
SIZES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBArchivStatTest ON UEBArchivStatTest(MSMT_TIME);
ALTER TABLE UEBArchivStatTest ADD constraint PK_UEBArchivStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBArchivStatTest_TREND;
CREATE TABLE UEBArchivStatTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
STATUS_MIN DECIMAL(20,4) NOT NULL,
STATUS_MAX DECIMAL(20,4) NOT NULL,
STATUS_STCNT varchar(32) NOT NULL,
SIZES_MIN DECIMAL(20,4) NOT NULL,
SIZES_MAX DECIMAL(20,4) NOT NULL,
SIZES_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBArchivStatTest_TREND ADD constraint PK_UEBArchivStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBArchivStatTest_THRESH;
CREATE TABLE UEBArchivStatTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
STATUS_MIN VARCHAR(256) NOT NULL,
STATUS_MAX VARCHAR(256) NOT NULL,
SIZES_MIN VARCHAR(256) NOT NULL,
SIZES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBArchivStatTest_THRESH ADD constraint PK_UEBArchivStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBArchivStatTest_THRESH ON UEBArchivStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBArchivStatTest ON UEBArchivStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBArchivStatTest ON UEBArchivStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBBkpCapacityTest;
CREATE TABLE UEBBkpCapacityTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_SPACE DECIMAL(20,4) NOT NULL,
TOTAL_SPACE_ST varchar(32) NOT NULL,
USED_SPACE DECIMAL(20,4) NOT NULL,
USED_SPACE_ST varchar(32) NOT NULL,
FREE_SPACE DECIMAL(20,4) NOT NULL,
FREE_SPACE_ST varchar(32) NOT NULL,
SPACE_USAGE_PCT DECIMAL(20,4) NOT NULL,
SPACE_USAGE_PCT_ST varchar(32) NOT NULL,
SPACE_FREE_PCT DECIMAL(20,4) NOT NULL,
SPACE_FREE_PCT_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBBkpCapacityTest ON UEBBkpCapacityTest(MSMT_TIME);
ALTER TABLE UEBBkpCapacityTest ADD constraint PK_UEBBkpCapacityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBBkpCapacityTest_TREND;
CREATE TABLE UEBBkpCapacityTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_SPACE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_SPACE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_SPACE_STCNT varchar(32) NOT NULL,
USED_SPACE_MIN DECIMAL(20,4) NOT NULL,
USED_SPACE_MAX DECIMAL(20,4) NOT NULL,
USED_SPACE_STCNT varchar(32) NOT NULL,
FREE_SPACE_MIN DECIMAL(20,4) NOT NULL,
FREE_SPACE_MAX DECIMAL(20,4) NOT NULL,
FREE_SPACE_STCNT varchar(32) NOT NULL,
SPACE_USAGE_PCT_MIN DECIMAL(20,4) NOT NULL,
SPACE_USAGE_PCT_MAX DECIMAL(20,4) NOT NULL,
SPACE_USAGE_PCT_STCNT varchar(32) NOT NULL,
SPACE_FREE_PCT_MIN DECIMAL(20,4) NOT NULL,
SPACE_FREE_PCT_MAX DECIMAL(20,4) NOT NULL,
SPACE_FREE_PCT_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBBkpCapacityTest_TREND ADD constraint PK_UEBBkpCapacityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBBkpCapacityTest_THRESH;
CREATE TABLE UEBBkpCapacityTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_SPACE_MIN VARCHAR(256) NOT NULL,
TOTAL_SPACE_MAX VARCHAR(256) NOT NULL,
USED_SPACE_MIN VARCHAR(256) NOT NULL,
USED_SPACE_MAX VARCHAR(256) NOT NULL,
FREE_SPACE_MIN VARCHAR(256) NOT NULL,
FREE_SPACE_MAX VARCHAR(256) NOT NULL,
SPACE_USAGE_PCT_MIN VARCHAR(256) NOT NULL,
SPACE_USAGE_PCT_MAX VARCHAR(256) NOT NULL,
SPACE_FREE_PCT_MIN VARCHAR(256) NOT NULL,
SPACE_FREE_PCT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBBkpCapacityTest_THRESH ADD constraint PK_UEBBkpCapacityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBBkpCapacityTest_THRESH ON UEBBkpCapacityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBBkpCapacityTest ON UEBBkpCapacityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBBkpCapacityTest ON UEBBkpCapacityTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBBkpStatusTest;
CREATE TABLE UEBBkpStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
STATUS DECIMAL(20,4) NOT NULL,
STATUS_ST varchar(32) NOT NULL,
SIZES DECIMAL(20,4) NOT NULL,
SIZES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBBkpStatusTest ON UEBBkpStatusTest(MSMT_TIME);
ALTER TABLE UEBBkpStatusTest ADD constraint PK_UEBBkpStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBBkpStatusTest_TREND;
CREATE TABLE UEBBkpStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
STATUS_MIN DECIMAL(20,4) NOT NULL,
STATUS_MAX DECIMAL(20,4) NOT NULL,
STATUS_STCNT varchar(32) NOT NULL,
SIZES_MIN DECIMAL(20,4) NOT NULL,
SIZES_MAX DECIMAL(20,4) NOT NULL,
SIZES_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBBkpStatusTest_TREND ADD constraint PK_UEBBkpStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBBkpStatusTest_THRESH;
CREATE TABLE UEBBkpStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
STATUS_MIN VARCHAR(256) NOT NULL,
STATUS_MAX VARCHAR(256) NOT NULL,
SIZES_MIN VARCHAR(256) NOT NULL,
SIZES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBBkpStatusTest_THRESH ADD constraint PK_UEBBkpStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBBkpStatusTest_THRESH ON UEBBkpStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBBkpStatusTest ON UEBBkpStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBBkpStatusTest ON UEBBkpStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBFanStatusTest;
CREATE TABLE UEBFanStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
HEALTH_STATUS DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_ST varchar(32) NOT NULL,
SENSOR_STATUS DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_ST varchar(32) NOT NULL,
SPEED DECIMAL(20,4) NOT NULL,
SPEED_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBFanStatusTest ON UEBFanStatusTest(MSMT_TIME);
ALTER TABLE UEBFanStatusTest ADD constraint PK_UEBFanStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBFanStatusTest_TREND;
CREATE TABLE UEBFanStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
HEALTH_STATUS_MIN DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_MAX DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar(32) NOT NULL,
SENSOR_STATUS_MIN DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_MAX DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar(32) NOT NULL,
SPEED_MIN DECIMAL(20,4) NOT NULL,
SPEED_MAX DECIMAL(20,4) NOT NULL,
SPEED_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBFanStatusTest_TREND ADD constraint PK_UEBFanStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBFanStatusTest_THRESH;
CREATE TABLE UEBFanStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
HEALTH_STATUS_MIN VARCHAR(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR(256) NOT NULL,
SPEED_MIN VARCHAR(256) NOT NULL,
SPEED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBFanStatusTest_THRESH ADD constraint PK_UEBFanStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBFanStatusTest_THRESH ON UEBFanStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBFanStatusTest ON UEBFanStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBFanStatusTest ON UEBFanStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTempStatusTest;
CREATE TABLE UEBTempStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
HEALTH_STATUS DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_ST varchar(32) NOT NULL,
SENSOR_STATUS DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_ST varchar(32) NOT NULL,
CURRENT_TEMPERATURE DECIMAL(20,4) NOT NULL,
CURRENT_TEMPERATURE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBTempStatusTest ON UEBTempStatusTest(MSMT_TIME);
ALTER TABLE UEBTempStatusTest ADD constraint PK_UEBTempStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTempStatusTest_TREND;
CREATE TABLE UEBTempStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
HEALTH_STATUS_MIN DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_MAX DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar(32) NOT NULL,
SENSOR_STATUS_MIN DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_MAX DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar(32) NOT NULL,
CURRENT_TEMPERATURE_MIN DECIMAL(20,4) NOT NULL,
CURRENT_TEMPERATURE_MAX DECIMAL(20,4) NOT NULL,
CURRENT_TEMPERATURE_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBTempStatusTest_TREND ADD constraint PK_UEBTempStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTempStatusTest_THRESH;
CREATE TABLE UEBTempStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
HEALTH_STATUS_MIN VARCHAR(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR(256) NOT NULL,
CURRENT_TEMPERATURE_MIN VARCHAR(256) NOT NULL,
CURRENT_TEMPERATURE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBTempStatusTest_THRESH ADD constraint PK_UEBTempStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTempStatusTest_THRESH ON UEBTempStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTempStatusTest ON UEBTempStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTempStatusTest ON UEBTempStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTotalBackupTest;
CREATE TABLE UEBTotalBackupTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_BACKUPS DECIMAL(20,4) NOT NULL,
TOTAL_BACKUPS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBTotalBackupTest ON UEBTotalBackupTest(MSMT_TIME);
ALTER TABLE UEBTotalBackupTest ADD constraint PK_UEBTotalBackupTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTotalBackupTest_TREND;
CREATE TABLE UEBTotalBackupTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_BACKUPS_MIN DECIMAL(20,4) NOT NULL,
TOTAL_BACKUPS_MAX DECIMAL(20,4) NOT NULL,
TOTAL_BACKUPS_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBTotalBackupTest_TREND ADD constraint PK_UEBTotalBackupTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTotalBackupTest_THRESH;
CREATE TABLE UEBTotalBackupTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_BACKUPS_MIN VARCHAR(256) NOT NULL,
TOTAL_BACKUPS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBTotalBackupTest_THRESH ADD constraint PK_UEBTotalBackupTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTotalBackupTest_THRESH ON UEBTotalBackupTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTotalBackupTest ON UEBTotalBackupTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTotalBackupTest ON UEBTotalBackupTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBTotalArchivTest;
CREATE TABLE UEBTotalArchivTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_ARCHIV DECIMAL(20,4) NOT NULL,
TOTAL_ARCHIV_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBTotalArchivTest ON UEBTotalArchivTest(MSMT_TIME);
ALTER TABLE UEBTotalArchivTest ADD constraint PK_UEBTotalArchivTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBTotalArchivTest_TREND;
CREATE TABLE UEBTotalArchivTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_ARCHIV_MIN DECIMAL(20,4) NOT NULL,
TOTAL_ARCHIV_MAX DECIMAL(20,4) NOT NULL,
TOTAL_ARCHIV_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBTotalArchivTest_TREND ADD constraint PK_UEBTotalArchivTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBTotalArchivTest_THRESH;
CREATE TABLE UEBTotalArchivTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_ARCHIV_MIN VARCHAR(256) NOT NULL,
TOTAL_ARCHIV_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBTotalArchivTest_THRESH ADD constraint PK_UEBTotalArchivTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBTotalArchivTest_THRESH ON UEBTotalArchivTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBTotalArchivTest ON UEBTotalArchivTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBTotalArchivTest ON UEBTotalArchivTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE UEBVoltStatusTest;
CREATE TABLE UEBVoltStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
HEALTH_STATUS DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_ST varchar(32) NOT NULL,
SENSOR_STATUS DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_ST varchar(32) NOT NULL,
CURRENT_VOLTAGE DECIMAL(20,4) NOT NULL,
CURRENT_VOLTAGE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_UEBVoltStatusTest ON UEBVoltStatusTest(MSMT_TIME);
ALTER TABLE UEBVoltStatusTest ADD constraint PK_UEBVoltStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE UEBVoltStatusTest_TREND;
CREATE TABLE UEBVoltStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
HEALTH_STATUS_MIN DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_MAX DECIMAL(20,4) NOT NULL,
HEALTH_STATUS_STCNT varchar(32) NOT NULL,
SENSOR_STATUS_MIN DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_MAX DECIMAL(20,4) NOT NULL,
SENSOR_STATUS_STCNT varchar(32) NOT NULL,
CURRENT_VOLTAGE_MIN DECIMAL(20,4) NOT NULL,
CURRENT_VOLTAGE_MAX DECIMAL(20,4) NOT NULL,
CURRENT_VOLTAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE UEBVoltStatusTest_TREND ADD constraint PK_UEBVoltStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE UEBVoltStatusTest_THRESH;
CREATE TABLE UEBVoltStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
HEALTH_STATUS_MIN VARCHAR(256) NOT NULL,
HEALTH_STATUS_MAX VARCHAR(256) NOT NULL,
SENSOR_STATUS_MIN VARCHAR(256) NOT NULL,
SENSOR_STATUS_MAX VARCHAR(256) NOT NULL,
CURRENT_VOLTAGE_MIN VARCHAR(256) NOT NULL,
CURRENT_VOLTAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE UEBVoltStatusTest_THRESH ADD constraint PK_UEBVoltStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_UEBVoltStatusTest_THRESH ON UEBVoltStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_UEBVoltStatusTest ON UEBVoltStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_UEBVoltStatusTest ON UEBVoltStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPSOURCETEST;
CREATE TABLE TOPSOURCETEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS	DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST	VARCHAR(32) NOT NULL,
OUT_OCTETS	DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST	VARCHAR(32) NOT NULL,
BYTES		DECIMAL(20,4) NOT NULL,
BYTES_ST	VARCHAR(32) NOT NULL,
IN_PACKETS	DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST	VARCHAR(32) NOT NULL,
OUT_PACKETS	DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST	VARCHAR(32) NOT NULL,
PACKETS		DECIMAL(20,4) NOT NULL,
PACKETS_ST	VARCHAR(32) NOT NULL,
in_OCTETSRATE	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
in_PACKETSRATE		DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE		DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE		DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
BYTESPERSEC		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST		VARCHAR(32) NOT NULL,
PACKETSPERSEC		DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST	VARCHAR(32) NOT NULL,
IN_TRAFFIC		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST		VARCHAR(32) NOT NULL,
OUT_TRAFFIC		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST		VARCHAR(32) NOT NULL,
TRAFFICRATE		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST		VARCHAR(32) NOT NULL,
IN_BW			DECIMAL(20,4) NOT NULL,
IN_BW_ST		VARCHAR(32) NOT NULL,
OUT_BW			DECIMAL(20,4) NOT NULL,
OUT_BW_ST		VARCHAR(32) NOT NULL,
BWUTILIZED		DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST		VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPSOURCETEST ON TOPSOURCETEST(MSMT_TIME);
ALTER TABLE TOPSOURCETEST ADD CONSTRAINT PK_TOPSOURCETEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSOURCETEST_TREND;
CREATE TABLE TOPSOURCETEST_TREND(
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL,
MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME		DATETIME NOT NULL,
PERIOD       		VARCHAR(32) NOT NULL,
IN_OCTETS_MIN		DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX		DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT		VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT	VARCHAR(32) NOT NULL,
BYTES_MIN		DECIMAL(20,4) NOT NULL,
BYTES_MAX		DECIMAL(20,4) NOT NULL,
BYTES_STCNT		VARCHAR(32) NOT NULL,
IN_PACKETS_MIN		DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX		DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT	VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT	VARCHAR(32) NOT NULL,
PACKETS_MIN		DECIMAL(20,4) NOT NULL,
PACKETS_MAX		DECIMAL(20,4) NOT NULL,
PACKETS_STCNT		VARCHAR(32) NOT NULL,
in_OCTETSRATE_MIN	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_MAX	DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_STCNT	VARCHAR(32) NOT NULL,
in_PACKETSRATE_MIN	DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_MAX	DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_STCNT	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN	DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX	DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN	DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX	DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT	VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT	VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN	DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX	DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT	VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT	VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT	VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT	VARCHAR(32) NOT NULL,
IN_BW_MIN		DECIMAL(20,4) NOT NULL,
IN_BW_MAX		DECIMAL(20,4) NOT NULL,
IN_BW_STCNT		VARCHAR(32) NOT NULL,
OUT_BW_MIN		DECIMAL(20,4) NOT NULL,
OUT_BW_MAX		DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT		VARCHAR(32) NOT NULL,
BWUTILIZED_MIN		DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX		DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT	VARCHAR(32) NOT NULL);

ALTER TABLE TOPSOURCETEST_TREND ADD CONSTRAINT PK_TOPSOURCETEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSOURCETEST_THRESH;
CREATE TABLE TOPSOURCETEST_THRESH(
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL
,MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME_START		DATETIME NOT NULL,
MSMT_TIME_END		DATETIME NOT NULL,
IN_OCTETS_MIN		VARCHAR(256) NOT NULL,
IN_OCTETS_MAX		VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN		VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX		VARCHAR(256) NOT NULL,
BYTES_MIN		VARCHAR(256) NOT NULL,
BYTES_MAX		VARCHAR(256) NOT NULL,
IN_PACKETS_MIN		VARCHAR(256) NOT NULL,
IN_PACKETS_MAX		VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN		VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX		VARCHAR(256) NOT NULL,
PACKETS_MIN		VARCHAR(256) NOT NULL,
PACKETS_MAX		VARCHAR(256) NOT NULL,
in_OCTETSRATE_MIN	VARCHAR(256) NOT NULL,
in_OCTETSRATE_MAX	VARCHAR(256) NOT NULL,
in_PACKETSRATE_MIN	VARCHAR(256) NOT NULL,
in_PACKETSRATE_MAX	VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN	VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX	VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN	VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX	VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN		VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX		VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN	VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX	VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN		VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX		VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN		VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX		VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN		VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX		VARCHAR(256) NOT NULL,
IN_BW_MIN		VARCHAR(256) NOT NULL,
IN_BW_MAX		VARCHAR(256) NOT NULL,
OUT_BW_MIN		VARCHAR(256) NOT NULL,
OUT_BW_MAX		VARCHAR(256) NOT NULL,
BWUTILIZED_MIN		VARCHAR(256) NOT NULL,
BWUTILIZED_MAX		VARCHAR(256) NOT NULL);

ALTER TABLE TOPSOURCETEST_THRESH ADD CONSTRAINT PK_TOPSOURCETEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSOURCETEST_THRESH ON TOPSOURCETEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSOURCETEST ON TOPSOURCETEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSOURCETEST ON TOPSOURCETEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPDESTTEST;
CREATE TABLE TOPDESTTEST( 
TRGT_HOST		VARCHAR(32) NOT NULL,
PORT_NO			VARCHAR(32) NOT NULL,
SITE_NAME		VARCHAR(64) NOT NULL,
INFO			VARCHAR(128) NOT NULL,
MSMT_HOST		VARCHAR(32) NOT NULL,
MSMT_TIME		DATETIME NOT NULL,
IN_OCTETS		DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST		VARCHAR(32) NOT NULL,
OUT_OCTETS		DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST		VARCHAR(32) NOT NULL,
BYTES			DECIMAL(20,4) NOT NULL,
BYTES_ST		VARCHAR(32) NOT NULL,
IN_PACKETS		DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST		VARCHAR(32) NOT NULL,
OUT_PACKETS		DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST		VARCHAR(32) NOT NULL,
PACKETS			DECIMAL(20,4) NOT NULL,
PACKETS_ST		VARCHAR(32) NOT NULL,
in_OCTETSRATE		DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
in_PACKETSRATE		DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_OCTETSRATE		DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST	VARCHAR(32) NOT NULL,
OUT_PACKETSRATE		DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST	VARCHAR(32) NOT NULL,
BYTESPERSEC		DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST		VARCHAR(32) NOT NULL,
PACKETSPERSEC		DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST	VARCHAR(32) NOT NULL,
IN_TRAFFIC		DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST		VARCHAR(32) NOT NULL,
OUT_TRAFFIC		DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST		VARCHAR(32) NOT NULL,
TRAFFICRATE		DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST		VARCHAR(32) NOT NULL,
IN_BW			DECIMAL(20,4) NOT NULL,
IN_BW_ST		VARCHAR(32) NOT NULL,
OUT_BW			DECIMAL(20,4) NOT NULL,
OUT_BW_ST		VARCHAR(32) NOT NULL,
BWUTILIZED		DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST		VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPDESTTEST ON TOPDESTTEST(MSMT_TIME);
ALTER TABLE TOPDESTTEST ADD CONSTRAINT PK_TOPDESTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPDESTTEST_TREND;
CREATE TABLE TOPDESTTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
in_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
in_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
in_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
in_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPDESTTEST_TREND ADD CONSTRAINT PK_TOPDESTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPDESTTEST_THRESH;
CREATE TABLE TOPDESTTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
in_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
in_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
in_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
in_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPDESTTEST_THRESH ADD CONSTRAINT PK_TOPDESTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPDESTTEST_THRESH ON TOPDESTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPDESTTEST ON TOPDESTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPDESTTEST ON TOPDESTTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPCONVERTEST;
CREATE TABLE TOPCONVERTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL,
protocol DECIMAL(20,4) NOT NULL,
protocol_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPCONVERTEST ON TOPCONVERTEST(MSMT_TIME);
ALTER TABLE TOPCONVERTEST ADD CONSTRAINT PK_TOPCONVERTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPCONVERTEST_TREND;
CREATE TABLE TOPCONVERTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL,
protocol_MIN DECIMAL(20,4) NOT NULL,
protocol_MAX DECIMAL(20,4) NOT NULL,
protocol_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPCONVERTEST_TREND ADD CONSTRAINT PK_TOPCONVERTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPCONVERTEST_THRESH;
CREATE TABLE TOPCONVERTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL,
protocol_MIN VARCHAR(256) NOT NULL,
protocol_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPCONVERTEST_THRESH ADD CONSTRAINT PK_TOPCONVERTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPCONVERTEST_THRESH ON TOPCONVERTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPCONVERTEST ON TOPCONVERTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPCONVERTEST ON TOPCONVERTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE TOPAPPLICATIONTEST;
CREATE TABLE TOPAPPLICATIONTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST(MSMT_TIME);
ALTER TABLE TOPAPPLICATIONTEST ADD CONSTRAINT PK_TOPAPPLICATIONTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPAPPLICATIONTEST_TREND;
CREATE TABLE TOPAPPLICATIONTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_TREND ADD CONSTRAINT PK_TOPAPPLICATIONTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPAPPLICATIONTEST_THRESH;
CREATE TABLE TOPAPPLICATIONTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPAPPLICATIONTEST_THRESH ADD CONSTRAINT PK_TOPAPPLICATIONTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPAPPLICATIONTEST_THRESH ON TOPAPPLICATIONTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPAPPLICATIONTEST ON TOPAPPLICATIONTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE TOPSITESTEST;
CREATE TABLE TOPSITESTEST( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_TOPSITESTEST ON TOPSITESTEST(MSMT_TIME);
ALTER TABLE TOPSITESTEST ADD CONSTRAINT PK_TOPSITESTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TOPSITESTEST_TREND;
CREATE TABLE TOPSITESTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE TOPSITESTEST_TREND ADD CONSTRAINT PK_TOPSITESTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TOPSITESTEST_THRESH;
CREATE TABLE TOPSITESTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TOPSITESTEST_THRESH ADD CONSTRAINT PK_TOPSITESTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TOPSITESTEST_THRESH ON TOPSITESTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TOPSITESTEST ON TOPSITESTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TOPSITESTEST ON TOPSITESTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE SpecificSrcTest;
CREATE TABLE SpecificSrcTest( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_SpecificSrcTest ON SpecificSrcTest(MSMT_TIME);
ALTER TABLE SpecificSrcTest ADD CONSTRAINT PK_SpecificSrcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificSrcTest_TREND;
CREATE TABLE SpecificSrcTest_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE SpecificSrcTest_TREND ADD CONSTRAINT PK_SpecificSrcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificSrcTest_THRESH;
CREATE TABLE SpecificSrcTest_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SpecificSrcTest_THRESH ADD CONSTRAINT PK_SpecificSrcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificSrcTest_THRESH ON SpecificSrcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificSrcTest ON SpecificSrcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificSrcTest ON SpecificSrcTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SpecificDestTest;
CREATE TABLE SpecificDestTest( 
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
IN_OCTETS DECIMAL(20,4) NOT NULL,
IN_OCTETS_ST VARCHAR(32) NOT NULL,
OUT_OCTETS DECIMAL(20,4) NOT NULL,
OUT_OCTETS_ST VARCHAR(32) NOT NULL,
BYTES DECIMAL(20,4) NOT NULL,
BYTES_ST VARCHAR(32) NOT NULL,
IN_PACKETS DECIMAL(20,4) NOT NULL,
IN_PACKETS_ST VARCHAR(32) NOT NULL,
OUT_PACKETS DECIMAL(20,4) NOT NULL,
OUT_PACKETS_ST VARCHAR(32) NOT NULL,
PACKETS DECIMAL(20,4) NOT NULL,
PACKETS_ST VARCHAR(32) NOT NULL,
IN_OCTETSRATE DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_ST VARCHAR(32) NOT NULL,
IN_PACKETSRATE DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_ST VARCHAR(32) NOT NULL,
OUT_OCTETSRATE DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_ST VARCHAR(32) NOT NULL,
OUT_PACKETSRATE DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_ST VARCHAR(32) NOT NULL,
BYTESPERSEC DECIMAL(20,4) NOT NULL,
BYTESPERSEC_ST VARCHAR(32) NOT NULL,
PACKETSPERSEC DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_ST VARCHAR(32) NOT NULL,
IN_TRAFFIC DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_ST VARCHAR(32) NOT NULL,
OUT_TRAFFIC DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_ST VARCHAR(32) NOT NULL,
TRAFFICRATE DECIMAL(20,4) NOT NULL,
TRAFFICRATE_ST VARCHAR(32) NOT NULL,
IN_BW DECIMAL(20,4) NOT NULL,
IN_BW_ST VARCHAR(32) NOT NULL,
OUT_BW DECIMAL(20,4) NOT NULL,
OUT_BW_ST VARCHAR(32) NOT NULL,
BWUTILIZED DECIMAL(20,4) NOT NULL,
BWUTILIZED_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_SpecificDestTest ON SpecificDestTest(MSMT_TIME);
ALTER TABLE SpecificDestTest ADD CONSTRAINT PK_SpecificDestTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SpecificDestTest_TREND;
CREATE TABLE SpecificDestTest_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
IN_OCTETS_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETS_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETS_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETS_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETS_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETS_STCNT VARCHAR(32) NOT NULL,
BYTES_MIN DECIMAL(20,4) NOT NULL,
BYTES_MAX DECIMAL(20,4) NOT NULL,
BYTES_STCNT VARCHAR(32) NOT NULL,
IN_PACKETS_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETS_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETS_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETS_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETS_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETS_STCNT VARCHAR(32) NOT NULL,
PACKETS_MIN DECIMAL(20,4) NOT NULL,
PACKETS_MAX DECIMAL(20,4) NOT NULL,
PACKETS_STCNT VARCHAR(32) NOT NULL,
IN_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
IN_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
IN_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_OCTETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_OCTETSRATE_STCNT VARCHAR(32) NOT NULL,
OUT_PACKETSRATE_MIN DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_MAX DECIMAL(20,4) NOT NULL,
OUT_PACKETSRATE_STCNT VARCHAR(32) NOT NULL,
BYTESPERSEC_MIN DECIMAL(20,4) NOT NULL,
BYTESPERSEC_MAX DECIMAL(20,4) NOT NULL,
BYTESPERSEC_STCNT VARCHAR(32) NOT NULL,
PACKETSPERSEC_MIN DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_MAX DECIMAL(20,4) NOT NULL,
PACKETSPERSEC_STCNT VARCHAR(32) NOT NULL,
IN_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
IN_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
OUT_TRAFFIC_MIN DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_MAX DECIMAL(20,4) NOT NULL,
OUT_TRAFFIC_STCNT VARCHAR(32) NOT NULL,
TRAFFICRATE_MIN DECIMAL(20,4) NOT NULL,
TRAFFICRATE_MAX DECIMAL(20,4) NOT NULL,
TRAFFICRATE_STCNT VARCHAR(32) NOT NULL,
IN_BW_MIN DECIMAL(20,4) NOT NULL,
IN_BW_MAX DECIMAL(20,4) NOT NULL,
IN_BW_STCNT VARCHAR(32) NOT NULL,
OUT_BW_MIN DECIMAL(20,4) NOT NULL,
OUT_BW_MAX DECIMAL(20,4) NOT NULL,
OUT_BW_STCNT VARCHAR(32) NOT NULL,
BWUTILIZED_MIN DECIMAL(20,4) NOT NULL,
BWUTILIZED_MAX DECIMAL(20,4) NOT NULL,
BWUTILIZED_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE SpecificDestTest_TREND ADD CONSTRAINT PK_SpecificDestTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SpecificDestTest_THRESH;
CREATE TABLE SpecificDestTest_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
IN_OCTETS_MIN VARCHAR(256) NOT NULL,
IN_OCTETS_MAX VARCHAR(256) NOT NULL,
OUT_OCTETS_MIN VARCHAR(256) NOT NULL,
OUT_OCTETS_MAX VARCHAR(256) NOT NULL,
BYTES_MIN VARCHAR(256) NOT NULL,
BYTES_MAX VARCHAR(256) NOT NULL,
IN_PACKETS_MIN VARCHAR(256) NOT NULL,
IN_PACKETS_MAX VARCHAR(256) NOT NULL,
OUT_PACKETS_MIN VARCHAR(256) NOT NULL,
OUT_PACKETS_MAX VARCHAR(256) NOT NULL,
PACKETS_MIN VARCHAR(256) NOT NULL,
PACKETS_MAX VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
IN_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
IN_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_OCTETSRATE_MAX VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MIN VARCHAR(256) NOT NULL,
OUT_PACKETSRATE_MAX VARCHAR(256) NOT NULL,
BYTESPERSEC_MIN VARCHAR(256) NOT NULL,
BYTESPERSEC_MAX VARCHAR(256) NOT NULL,
PACKETSPERSEC_MIN VARCHAR(256) NOT NULL,
PACKETSPERSEC_MAX VARCHAR(256) NOT NULL,
IN_TRAFFIC_MIN VARCHAR(256) NOT NULL,
IN_TRAFFIC_MAX VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MIN VARCHAR(256) NOT NULL,
OUT_TRAFFIC_MAX VARCHAR(256) NOT NULL,
TRAFFICRATE_MIN VARCHAR(256) NOT NULL,
TRAFFICRATE_MAX VARCHAR(256) NOT NULL,
IN_BW_MIN VARCHAR(256) NOT NULL,
IN_BW_MAX VARCHAR(256) NOT NULL,
OUT_BW_MIN VARCHAR(256) NOT NULL,
OUT_BW_MAX VARCHAR(256) NOT NULL,
BWUTILIZED_MIN VARCHAR(256) NOT NULL,
BWUTILIZED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SpecificDestTest_THRESH ADD CONSTRAINT PK_SpecificDestTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SpecificDestTest_THRESH ON SpecificDestTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SpecificDestTest ON SpecificDestTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SpecificDestTest ON SpecificDestTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFHDXLOGINSTEST;
CREATE TABLE AFHDXLOGINSTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    CURRENT_SESSIONS           DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_ST        VARCHAR (32)    NOT NULL,
    NEW_SESSIONS               DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_ST            VARCHAR (32)    NOT NULL,
    PERCENT_OF_NEW_SESSIONS    DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_ST VARCHAR (32)    NOT NULL,
    SESSION_LOGOUTS            DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_ST         VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXLOGINSTEST
    ON AFHDXLOGINSTEST(MSMT_TIME);

ALTER TABLE AFHDXLOGINSTEST
    ADD CONSTRAINT PK_AFHDXLOGINSTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXLOGINSTEST_TREND;

CREATE TABLE AFHDXLOGINSTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    CURRENT_SESSIONS_MIN          DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_MAX          DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_STCNT        VARCHAR (32)    NOT NULL,
    NEW_SESSIONS_MIN              DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_MAX              DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_STCNT            VARCHAR (32)    NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MIN   DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MAX   DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_STCNT VARCHAR (32)    NOT NULL,
    SESSION_LOGOUTS_MIN           DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_MAX           DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_STCNT         VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXLOGINSTEST_TREND
    ADD CONSTRAINT PK_AFHDXLOGINSTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXLOGINSTEST_THRESH;

CREATE TABLE AFHDXLOGINSTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    CURRENT_SESSIONS_MIN        VARCHAR (256) NOT NULL,
    CURRENT_SESSIONS_MAX        VARCHAR (256) NOT NULL,
    NEW_SESSIONS_MIN            VARCHAR (256) NOT NULL,
    NEW_SESSIONS_MAX            VARCHAR (256) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MIN VARCHAR (256) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MAX VARCHAR (256) NOT NULL,
    SESSION_LOGOUTS_MIN         VARCHAR (256) NOT NULL,
    SESSION_LOGOUTS_MAX         VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXLOGINSTEST_THRESH
    ADD CONSTRAINT PK_AFHDXLOGINSTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXLOGINSTEST_THRESH
    ON AFHDXLOGINSTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXLOGINSTEST
    ON AFHDXLOGINSTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXLOGINSTEST
    ON AFHDXLOGINSTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXUSERSTEST;

CREATE TABLE AFHDXUSERSTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    APPLICATION_LAUNCHES       DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_ST    VARCHAR (32)    NOT NULL,
    APPLICATION_TERMINATES     DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_ST  VARCHAR (32)    NOT NULL,
    ACTIVE_APPLICATIONS        DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_ST     VARCHAR (32)    NOT NULL,
    ACTIVE_DESKTOPS            DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_ST         VARCHAR (32)    NOT NULL,
    AVGAPPSTARTUPDURATION      DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_ST   VARCHAR (32)    NOT NULL,
    RTT                        DECIMAL (20, 4) NOT NULL,
    RTT_ST                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY                DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_ST             VARCHAR (32)    NOT NULL,
    DC_LATENCY                 DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_ST              VARCHAR (32)    NOT NULL,
    CLIENT_SRTT                DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_ST             VARCHAR (32)    NOT NULL,
    SERVER_SRTT                DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_ST             VARCHAR (32)    NOT NULL,
    CLIENT_JITTER              DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_ST           VARCHAR (32)    NOT NULL,
    SERVER_JITTER              DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_ST           VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    ACR_COUNTS                 DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_ST              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS         DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_ST      VARCHAR (32)    NOT NULL,
    SERVER_SIDE_FAST_RTO       DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_ST    VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_FAST_RTO       DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_ST    VARCHAR (32)    NOT NULL,
    CLIENTSIDEZEROWNDOEVNT     DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_ST  VARCHAR (32)    NOT NULL,
    SERVERSIDEZEROWNDOEVNT     DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_ST  VARCHAR (32)    NOT NULL,
    NOOFDSKTPLNCHS             DECIMAL (20, 4) NOT NULL,
    NOOFDSKTPLNCHS_ST          VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL             DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_ST          VARCHAR (32)    NOT NULL,
    BWPERINTRVL                DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_ST             VARCHAR (32)    NOT NULL,
    HOSTDLY                    DECIMAL (20, 4) NOT NULL,
    HOSTDLY_ST                 VARCHAR (32)    NOT NULL,
    SESSION_STATUS             DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_ST          VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXUSERSTEST
    ON AFHDXUSERSTEST(MSMT_TIME);

ALTER TABLE AFHDXUSERSTEST
    ADD CONSTRAINT PK_AFHDXUSERSTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXUSERSTEST_TREND;

CREATE TABLE AFHDXUSERSTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    APPLICATION_LAUNCHES_MIN      DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_MAX      DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_STCNT    VARCHAR (32)    NOT NULL,
    APPLICATION_TERMINATES_MIN    DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_MAX    DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_STCNT  VARCHAR (32)    NOT NULL,
    ACTIVE_APPLICATIONS_MIN       DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_MAX       DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_STCNT     VARCHAR (32)    NOT NULL,
    ACTIVE_DESKTOPS_MIN           DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_MAX           DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_STCNT         VARCHAR (32)    NOT NULL,
    AVGAPPSTARTUPDURATION_MIN     DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_MAX     DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_STCNT   VARCHAR (32)    NOT NULL,
    RTT_MIN                       DECIMAL (20, 4) NOT NULL,
    RTT_MAX                       DECIMAL (20, 4) NOT NULL,
    RTT_STCNT                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY_MIN               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_MAX               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_STCNT             VARCHAR (32)    NOT NULL,
    DC_LATENCY_MIN                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_MAX                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_STCNT              VARCHAR (32)    NOT NULL,
    CLIENT_SRTT_MIN               DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_MAX               DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_STCNT             VARCHAR (32)    NOT NULL,
    SERVER_SRTT_MIN               DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_MAX               DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_STCNT             VARCHAR (32)    NOT NULL,
    CLIENT_JITTER_MIN             DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_MAX             DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_STCNT           VARCHAR (32)    NOT NULL,
    SERVER_JITTER_MIN             DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_MAX             DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_STCNT           VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    ACR_COUNTS_MIN                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_MAX                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_STCNT              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS_MIN        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_MAX        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_STCNT      VARCHAR (32)    NOT NULL,
    SERVER_SIDE_FAST_RTO_MIN      DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_MAX      DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_STCNT    VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_FAST_RTO_MIN      DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MAX      DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_STCNT    VARCHAR (32)    NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MIN    DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MAX    DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_STCNT  VARCHAR (32)    NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MIN    DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MAX    DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_STCNT  VARCHAR (32)    NOT NULL,
    NOOFDSKTPLNCHS_MIN            DECIMAL (20, 4) NOT NULL,
    NOOFDSKTPLNCHS_MAX            DECIMAL (20, 4) NOT NULL,
    NOOFDSKTPLNCHS_STCNT          VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL_MIN            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_MAX            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_STCNT          VARCHAR (32)    NOT NULL,
    BWPERINTRVL_MIN               DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_MAX               DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_STCNT             VARCHAR (32)    NOT NULL,
    HOSTDLY_MIN                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_MAX                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_STCNT                 VARCHAR (32)    NOT NULL,
    SESSION_STATUS_MIN            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_MAX            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_STCNT          VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXUSERSTEST_TREND
    ADD CONSTRAINT PK_AFHDXUSERSTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXUSERSTEST_THRESH;

CREATE TABLE AFHDXUSERSTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    APPLICATION_LAUNCHES_MIN    VARCHAR (256) NOT NULL,
    APPLICATION_LAUNCHES_MAX    VARCHAR (256) NOT NULL,
    APPLICATION_TERMINATES_MIN  VARCHAR (256) NOT NULL,
    APPLICATION_TERMINATES_MAX  VARCHAR (256) NOT NULL,
    ACTIVE_APPLICATIONS_MIN     VARCHAR (256) NOT NULL,
    ACTIVE_APPLICATIONS_MAX     VARCHAR (256) NOT NULL,
    ACTIVE_DESKTOPS_MIN         VARCHAR (256) NOT NULL,
    ACTIVE_DESKTOPS_MAX         VARCHAR (256) NOT NULL,
    AVGAPPSTARTUPDURATION_MIN   VARCHAR (256) NOT NULL,
    AVGAPPSTARTUPDURATION_MAX   VARCHAR (256) NOT NULL,
    RTT_MIN                     VARCHAR (256) NOT NULL,
    RTT_MAX                     VARCHAR (256) NOT NULL,
    WAN_LATENCY_MIN             VARCHAR (256) NOT NULL,
    WAN_LATENCY_MAX             VARCHAR (256) NOT NULL,
    DC_LATENCY_MIN              VARCHAR (256) NOT NULL,
    DC_LATENCY_MAX              VARCHAR (256) NOT NULL,
    CLIENT_SRTT_MIN             VARCHAR (256) NOT NULL,
    CLIENT_SRTT_MAX             VARCHAR (256) NOT NULL,
    SERVER_SRTT_MIN             VARCHAR (256) NOT NULL,
    SERVER_SRTT_MAX             VARCHAR (256) NOT NULL,
    CLIENT_JITTER_MIN           VARCHAR (256) NOT NULL,
    CLIENT_JITTER_MAX           VARCHAR (256) NOT NULL,
    SERVER_JITTER_MIN           VARCHAR (256) NOT NULL,
    SERVER_JITTER_MAX           VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    ACR_COUNTS_MIN              VARCHAR (256) NOT NULL,
    ACR_COUNTS_MAX              VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MIN      VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MAX      VARCHAR (256) NOT NULL,
    SERVER_SIDE_FAST_RTO_MIN    VARCHAR (256) NOT NULL,
    SERVER_SIDE_FAST_RTO_MAX    VARCHAR (256) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MIN    VARCHAR (256) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MAX    VARCHAR (256) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MIN  VARCHAR (256) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MAX  VARCHAR (256) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MIN  VARCHAR (256) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MAX  VARCHAR (256) NOT NULL,
    NOOFDSKTPLNCHS_MIN          VARCHAR (256) NOT NULL,
    NOOFDSKTPLNCHS_MAX          VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MIN          VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MAX          VARCHAR (256) NOT NULL,
    BWPERINTRVL_MIN             VARCHAR (256) NOT NULL,
    BWPERINTRVL_MAX             VARCHAR (256) NOT NULL,
    HOSTDLY_MIN                 VARCHAR (256) NOT NULL,
    HOSTDLY_MAX                 VARCHAR (256) NOT NULL,
    SESSION_STATUS_MIN          VARCHAR (256) NOT NULL,
    SESSION_STATUS_MAX          VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXUSERSTEST_THRESH
    ADD CONSTRAINT PK_AFHDXUSERSTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXUSERSTEST_THRESH
    ON AFHDXUSERSTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXUSERSTEST
    ON AFHDXUSERSTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXUSERSTEST
    ON AFHDXUSERSTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXACTUSERSTEST;

CREATE TABLE AFHDXACTUSERSTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    APPLICATION_LAUNCHES       DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_ST    VARCHAR (32)    NOT NULL,
    APPLICATION_TERMINATES     DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_ST  VARCHAR (32)    NOT NULL,
    ACTIVE_APPLICATIONS        DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_ST     VARCHAR (32)    NOT NULL,
    AVGAPPSTARTUPDURATION      DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_ST   VARCHAR (32)    NOT NULL,
    RTT                        DECIMAL (20, 4) NOT NULL,
    RTT_ST                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY                DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_ST             VARCHAR (32)    NOT NULL,
    DC_LATENCY                 DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_ST              VARCHAR (32)    NOT NULL,
    CLIENT_SRTT                DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_ST             VARCHAR (32)    NOT NULL,
    SERVER_SRTT                DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_ST             VARCHAR (32)    NOT NULL,
    CLIENT_JITTER              DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_ST           VARCHAR (32)    NOT NULL,
    SERVER_JITTER              DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_ST           VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    ACR_COUNTS                 DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_ST              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS         DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_ST      VARCHAR (32)    NOT NULL,
    SESSION_STATUS             DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_ST          VARCHAR (32)    NOT NULL,
    SERVER_SIDE_FAST_RTO       DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_ST    VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_FAST_RTO       DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_ST    VARCHAR (32)    NOT NULL,
    CLIENTSIDEZEROWNDOEVNT     DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_ST  VARCHAR (32)    NOT NULL,
    SERVERSIDEZEROWNDOEVNT     DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_ST  VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL             DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_ST          VARCHAR (32)    NOT NULL,
    BWPERINTRVL                DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_ST             VARCHAR (32)    NOT NULL,
    HOSTDLY                    DECIMAL (20, 4) NOT NULL,
    HOSTDLY_ST                 VARCHAR (32)    NOT NULL,
    CLIENTDELAY                DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_ST             VARCHAR (32)    NOT NULL,
    SERVERDELAY                DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_ST             VARCHAR (32)    NOT NULL,
    L7CLIENTLATENCY            DECIMAL (20, 4) NOT NULL,
    L7CLIENTLATENCY_ST         VARCHAR (32)    NOT NULL,
    L7SERVERLATENCY            DECIMAL (20, 4) NOT NULL,
    L7SERVERLATENCY_ST         VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXACTUSERSTEST
    ON AFHDXACTUSERSTEST(MSMT_TIME);

ALTER TABLE AFHDXACTUSERSTEST
    ADD CONSTRAINT PK_AFHDXACTUSERSTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXACTUSERSTEST_TREND;

CREATE TABLE AFHDXACTUSERSTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    APPLICATION_LAUNCHES_MIN      DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_MAX      DECIMAL (20, 4) NOT NULL,
    APPLICATION_LAUNCHES_STCNT    VARCHAR (32)    NOT NULL,
    APPLICATION_TERMINATES_MIN    DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_MAX    DECIMAL (20, 4) NOT NULL,
    APPLICATION_TERMINATES_STCNT  VARCHAR (32)    NOT NULL,
    ACTIVE_APPLICATIONS_MIN       DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_MAX       DECIMAL (20, 4) NOT NULL,
    ACTIVE_APPLICATIONS_STCNT     VARCHAR (32)    NOT NULL,
    AVGAPPSTARTUPDURATION_MIN     DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_MAX     DECIMAL (20, 4) NOT NULL,
    AVGAPPSTARTUPDURATION_STCNT   VARCHAR (32)    NOT NULL,
    RTT_MIN                       DECIMAL (20, 4) NOT NULL,
    RTT_MAX                       DECIMAL (20, 4) NOT NULL,
    RTT_STCNT                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY_MIN               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_MAX               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_STCNT             VARCHAR (32)    NOT NULL,
    DC_LATENCY_MIN                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_MAX                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_STCNT              VARCHAR (32)    NOT NULL,
    CLIENT_SRTT_MIN               DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_MAX               DECIMAL (20, 4) NOT NULL,
    CLIENT_SRTT_STCNT             VARCHAR (32)    NOT NULL,
    SERVER_SRTT_MIN               DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_MAX               DECIMAL (20, 4) NOT NULL,
    SERVER_SRTT_STCNT             VARCHAR (32)    NOT NULL,
    CLIENT_JITTER_MIN             DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_MAX             DECIMAL (20, 4) NOT NULL,
    CLIENT_JITTER_STCNT           VARCHAR (32)    NOT NULL,
    SERVER_JITTER_MIN             DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_MAX             DECIMAL (20, 4) NOT NULL,
    SERVER_JITTER_STCNT           VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    ACR_COUNTS_MIN                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_MAX                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_STCNT              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS_MIN        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_MAX        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_STCNT      VARCHAR (32)    NOT NULL,
    SESSION_STATUS_MIN            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_MAX            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_STCNT          VARCHAR (32)    NOT NULL,
    SERVER_SIDE_FAST_RTO_MIN      DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_MAX      DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_FAST_RTO_STCNT    VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_FAST_RTO_MIN      DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MAX      DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_FAST_RTO_STCNT    VARCHAR (32)    NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MIN    DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MAX    DECIMAL (20, 4) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_STCNT  VARCHAR (32)    NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MIN    DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MAX    DECIMAL (20, 4) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_STCNT  VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL_MIN            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_MAX            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_STCNT          VARCHAR (32)    NOT NULL,
    BWPERINTRVL_MIN               DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_MAX               DECIMAL (20, 4) NOT NULL,
    BWPERINTRVL_STCNT             VARCHAR (32)    NOT NULL,
    HOSTDLY_MIN                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_MAX                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_STCNT                 VARCHAR (32)    NOT NULL,
    CLIENTDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_STCNT             VARCHAR (32)    NOT NULL,
    SERVERDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_STCNT             VARCHAR (32)    NOT NULL,
    L7CLIENTLATENCY_MIN           DECIMAL (20, 4) NOT NULL,
    L7CLIENTLATENCY_MAX           DECIMAL (20, 4) NOT NULL,
    L7CLIENTLATENCY_STCNT         VARCHAR (32)    NOT NULL,
    L7SERVERLATENCY_MIN           DECIMAL (20, 4) NOT NULL,
    L7SERVERLATENCY_MAX           DECIMAL (20, 4) NOT NULL,
    L7SERVERLATENCY_STCNT         VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXACTUSERSTEST_TREND
    ADD CONSTRAINT PK_AFHDXACTUSERSTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXACTUSERSTEST_THRESH;

CREATE TABLE AFHDXACTUSERSTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    APPLICATION_LAUNCHES_MIN    VARCHAR (256) NOT NULL,
    APPLICATION_LAUNCHES_MAX    VARCHAR (256) NOT NULL,
    APPLICATION_TERMINATES_MIN  VARCHAR (256) NOT NULL,
    APPLICATION_TERMINATES_MAX  VARCHAR (256) NOT NULL,
    ACTIVE_APPLICATIONS_MIN     VARCHAR (256) NOT NULL,
    ACTIVE_APPLICATIONS_MAX     VARCHAR (256) NOT NULL,
    AVGAPPSTARTUPDURATION_MIN   VARCHAR (256) NOT NULL,
    AVGAPPSTARTUPDURATION_MAX   VARCHAR (256) NOT NULL,
    RTT_MIN                     VARCHAR (256) NOT NULL,
    RTT_MAX                     VARCHAR (256) NOT NULL,
    WAN_LATENCY_MIN             VARCHAR (256) NOT NULL,
    WAN_LATENCY_MAX             VARCHAR (256) NOT NULL,
    DC_LATENCY_MIN              VARCHAR (256) NOT NULL,
    DC_LATENCY_MAX              VARCHAR (256) NOT NULL,
    CLIENT_SRTT_MIN             VARCHAR (256) NOT NULL,
    CLIENT_SRTT_MAX             VARCHAR (256) NOT NULL,
    SERVER_SRTT_MIN             VARCHAR (256) NOT NULL,
    SERVER_SRTT_MAX             VARCHAR (256) NOT NULL,
    CLIENT_JITTER_MIN           VARCHAR (256) NOT NULL,
    CLIENT_JITTER_MAX           VARCHAR (256) NOT NULL,
    SERVER_JITTER_MIN           VARCHAR (256) NOT NULL,
    SERVER_JITTER_MAX           VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    ACR_COUNTS_MIN              VARCHAR (256) NOT NULL,
    ACR_COUNTS_MAX              VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MIN      VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MAX      VARCHAR (256) NOT NULL,
    SESSION_STATUS_MIN          VARCHAR (256) NOT NULL,
    SESSION_STATUS_MAX          VARCHAR (256) NOT NULL,
    SERVER_SIDE_FAST_RTO_MIN    VARCHAR (256) NOT NULL,
    SERVER_SIDE_FAST_RTO_MAX    VARCHAR (256) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MIN    VARCHAR (256) NOT NULL,
    CLIENT_SIDE_FAST_RTO_MAX    VARCHAR (256) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MIN  VARCHAR (256) NOT NULL,
    CLIENTSIDEZEROWNDOEVNT_MAX  VARCHAR (256) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MIN  VARCHAR (256) NOT NULL,
    SERVERSIDEZEROWNDOEVNT_MAX  VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MIN          VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MAX          VARCHAR (256) NOT NULL,
    BWPERINTRVL_MIN             VARCHAR (256) NOT NULL,
    BWPERINTRVL_MAX             VARCHAR (256) NOT NULL,
    HOSTDLY_MIN                 VARCHAR (256) NOT NULL,
    HOSTDLY_MAX                 VARCHAR (256) NOT NULL,
    CLIENTDELAY_MIN             VARCHAR (256) NOT NULL,
    CLIENTDELAY_MAX             VARCHAR (256) NOT NULL,
    SERVERDELAY_MIN             VARCHAR (256) NOT NULL,
    SERVERDELAY_MAX             VARCHAR (256) NOT NULL,
    L7CLIENTLATENCY_MIN         VARCHAR (256) NOT NULL,
    L7CLIENTLATENCY_MAX         VARCHAR (256) NOT NULL,
    L7SERVERLATENCY_MIN         VARCHAR (256) NOT NULL,
    L7SERVERLATENCY_MAX         VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXACTUSERSTEST_THRESH
    ADD CONSTRAINT PK_AFHDXACTUSERSTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXACTUSERSTEST_THRESH
    ON AFHDXACTUSERSTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXACTUSERSTEST
    ON AFHDXACTUSERSTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXACTUSERSTEST
    ON AFHDXACTUSERSTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXCHANNELTEST;

CREATE TABLE AFHDXCHANNELTEST
(
    TRGT_HOST            VARCHAR (32)    NOT NULL,
    PORT_NO              VARCHAR (32)    NOT NULL,
    SITE_NAME            VARCHAR (64)    NOT NULL,
    INFO                 VARCHAR (128)   NOT NULL,
    MSMT_HOST            VARCHAR (32)    NOT NULL,
    MSMT_TIME            DATETIME        NOT NULL,
    TOTAL_BYTES          DECIMAL (20, 4) NOT NULL,
    TOTAL_BYTES_ST       VARCHAR (32)    NOT NULL,
    AVERAGE_BANDWIDTH    DECIMAL (20, 4) NOT NULL,
    AVERAGE_BANDWIDTH_ST VARCHAR (32)    NOT NULL,
    TRAFFIC              DECIMAL (20, 4) NOT NULL,
    TRAFFIC_ST           VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXCHANNELTEST
    ON AFHDXCHANNELTEST(MSMT_TIME);

ALTER TABLE AFHDXCHANNELTEST
    ADD CONSTRAINT PK_AFHDXCHANNELTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXCHANNELTEST_TREND;

CREATE TABLE AFHDXCHANNELTEST_TREND
(
    TRGT_HOST               VARCHAR (32)    NOT NULL,
    PORT_NO                 VARCHAR (32)    NOT NULL,
    SITE_NAME               VARCHAR (64)    NOT NULL,
    INFO                    VARCHAR (128)   NOT NULL,
    MSMT_HOST               VARCHAR (32)    NOT NULL,
    MSMT_TIME               DATETIME        NOT NULL,
    PERIOD                  VARCHAR (32)    NOT NULL,
    TOTAL_BYTES_MIN         DECIMAL (20, 4) NOT NULL,
    TOTAL_BYTES_MAX         DECIMAL (20, 4) NOT NULL,
    TOTAL_BYTES_STCNT       VARCHAR (32)    NOT NULL,
    AVERAGE_BANDWIDTH_MIN   DECIMAL (20, 4) NOT NULL,
    AVERAGE_BANDWIDTH_MAX   DECIMAL (20, 4) NOT NULL,
    AVERAGE_BANDWIDTH_STCNT VARCHAR (32)    NOT NULL,
    TRAFFIC_MIN             DECIMAL (20, 4) NOT NULL,
    TRAFFIC_MAX             DECIMAL (20, 4) NOT NULL,
    TRAFFIC_STCNT           VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXCHANNELTEST_TREND
    ADD CONSTRAINT PK_AFHDXCHANNELTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXCHANNELTEST_THRESH;

CREATE TABLE AFHDXCHANNELTEST_THRESH
(
    TRGT_HOST             VARCHAR (32)  NOT NULL,
    PORT_NO               VARCHAR (32)  NOT NULL,
    SITE_NAME             VARCHAR (64)  NOT NULL,
    INFO                  VARCHAR (128) NOT NULL,
    MSMT_HOST             VARCHAR (32)  NOT NULL,
    MSMT_TIME_START       DATETIME      NOT NULL,
    MSMT_TIME_END         DATETIME      NOT NULL,
    TOTAL_BYTES_MIN       VARCHAR (256) NOT NULL,
    TOTAL_BYTES_MAX       VARCHAR (256) NOT NULL,
    AVERAGE_BANDWIDTH_MIN VARCHAR (256) NOT NULL,
    AVERAGE_BANDWIDTH_MAX VARCHAR (256) NOT NULL,
    TRAFFIC_MIN           VARCHAR (256) NOT NULL,
    TRAFFIC_MAX           VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXCHANNELTEST_THRESH
    ADD CONSTRAINT PK_AFHDXCHANNELTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXCHANNELTEST_THRESH
    ON AFHDXCHANNELTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXCHANNELTEST
    ON AFHDXCHANNELTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXCHANNELTEST
    ON AFHDXCHANNELTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXUSRAGNTTEST;

CREATE TABLE AFHDXUSRAGNTTEST
(
    TRGT_HOST    VARCHAR (32)    NOT NULL,
    PORT_NO      VARCHAR (32)    NOT NULL,
    SITE_NAME    VARCHAR (64)    NOT NULL,
    INFO         VARCHAR (128)   NOT NULL,
    MSMT_HOST    VARCHAR (32)    NOT NULL,
    MSMT_TIME    DATETIME        NOT NULL,
    TOT_BYTES    DECIMAL (20, 4) NOT NULL,
    TOT_BYTES_ST VARCHAR (32)    NOT NULL,
    BW           DECIMAL (20, 4) NOT NULL,
    BW_ST        VARCHAR (32)    NOT NULL,
    TRAFFIC      DECIMAL (20, 4) NOT NULL,
    TRAFFIC_ST   VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXUSRAGNTTEST
    ON AFHDXUSRAGNTTEST(MSMT_TIME);

ALTER TABLE AFHDXUSRAGNTTEST
    ADD CONSTRAINT PK_AFHDXUSRAGNTTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXUSRAGNTTEST_TREND;

CREATE TABLE AFHDXUSRAGNTTEST_TREND
(
    TRGT_HOST       VARCHAR (32)    NOT NULL,
    PORT_NO         VARCHAR (32)    NOT NULL,
    SITE_NAME       VARCHAR (64)    NOT NULL,
    INFO            VARCHAR (128)   NOT NULL,
    MSMT_HOST       VARCHAR (32)    NOT NULL,
    MSMT_TIME       DATETIME        NOT NULL,
    PERIOD          VARCHAR (32)    NOT NULL,
    TOT_BYTES_MIN   DECIMAL (20, 4) NOT NULL,
    TOT_BYTES_MAX   DECIMAL (20, 4) NOT NULL,
    TOT_BYTES_STCNT VARCHAR (32)    NOT NULL,
    BW_MIN          DECIMAL (20, 4) NOT NULL,
    BW_MAX          DECIMAL (20, 4) NOT NULL,
    BW_STCNT        VARCHAR (32)    NOT NULL,
    TRAFFIC_MIN     DECIMAL (20, 4) NOT NULL,
    TRAFFIC_MAX     DECIMAL (20, 4) NOT NULL,
    TRAFFIC_STCNT   VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXUSRAGNTTEST_TREND
    ADD CONSTRAINT PK_AFHDXUSRAGNTTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXUSRAGNTTEST_THRESH;

CREATE TABLE AFHDXUSRAGNTTEST_THRESH
(
    TRGT_HOST       VARCHAR (32)  NOT NULL,
    PORT_NO         VARCHAR (32)  NOT NULL,
    SITE_NAME       VARCHAR (64)  NOT NULL,
    INFO            VARCHAR (128) NOT NULL,
    MSMT_HOST       VARCHAR (32)  NOT NULL,
    MSMT_TIME_START DATETIME      NOT NULL,
    MSMT_TIME_END   DATETIME      NOT NULL,
    TOT_BYTES_MIN   VARCHAR (256) NOT NULL,
    TOT_BYTES_MAX   VARCHAR (256) NOT NULL,
    BW_MIN          VARCHAR (256) NOT NULL,
    BW_MAX          VARCHAR (256) NOT NULL,
    TRAFFIC_MIN     VARCHAR (256) NOT NULL,
    TRAFFIC_MAX     VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXUSRAGNTTEST_THRESH
    ADD CONSTRAINT PK_AFHDXUSRAGNTTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXUSRAGNTTEST_THRESH
    ON AFHDXUSRAGNTTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXUSRAGNTTEST
    ON AFHDXUSRAGNTTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXUSRAGNTTEST
    ON AFHDXUSRAGNTTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXAPPSTEST;

CREATE TABLE AFHDXAPPSTEST
(
    TRGT_HOST          VARCHAR (32)    NOT NULL,
    PORT_NO            VARCHAR (32)    NOT NULL,
    SITE_NAME          VARCHAR (64)    NOT NULL,
    INFO               VARCHAR (128)   NOT NULL,
    MSMT_HOST          VARCHAR (32)    NOT NULL,
    MSMT_TIME          DATETIME        NOT NULL,
    ACTIVEAPPS         DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_ST      VARCHAR (32)    NOT NULL,
    ACTIVE_SESSIONS    DECIMAL (20, 4) NOT NULL,
    ACTIVE_SESSIONS_ST VARCHAR (32)    NOT NULL,
    CURRENTLAUNCHES    DECIMAL (20, 4) NOT NULL,
    CURRENTLAUNCHES_ST VARCHAR (32)    NOT NULL,
    AVGLNCHDURATION    DECIMAL (20, 4) NOT NULL,
    AVGLNCHDURATION_ST VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXAPPSTEST
    ON AFHDXAPPSTEST(MSMT_TIME);

ALTER TABLE AFHDXAPPSTEST
    ADD CONSTRAINT PK_AFHDXAPPSTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXAPPSTEST_TREND;

CREATE TABLE AFHDXAPPSTEST_TREND
(
    TRGT_HOST             VARCHAR (32)    NOT NULL,
    PORT_NO               VARCHAR (32)    NOT NULL,
    SITE_NAME             VARCHAR (64)    NOT NULL,
    INFO                  VARCHAR (128)   NOT NULL,
    MSMT_HOST             VARCHAR (32)    NOT NULL,
    MSMT_TIME             DATETIME        NOT NULL,
    PERIOD                VARCHAR (32)    NOT NULL,
    ACTIVEAPPS_MIN        DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_MAX        DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_STCNT      VARCHAR (32)    NOT NULL,
    ACTIVE_SESSIONS_MIN   DECIMAL (20, 4) NOT NULL,
    ACTIVE_SESSIONS_MAX   DECIMAL (20, 4) NOT NULL,
    ACTIVE_SESSIONS_STCNT VARCHAR (32)    NOT NULL,
    CURRENTLAUNCHES_MIN   DECIMAL (20, 4) NOT NULL,
    CURRENTLAUNCHES_MAX   DECIMAL (20, 4) NOT NULL,
    CURRENTLAUNCHES_STCNT VARCHAR (32)    NOT NULL,
    AVGLNCHDURATION_MIN   DECIMAL (20, 4) NOT NULL,
    AVGLNCHDURATION_MAX   DECIMAL (20, 4) NOT NULL,
    AVGLNCHDURATION_STCNT VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXAPPSTEST_TREND
    ADD CONSTRAINT PK_AFHDXAPPSTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXAPPSTEST_THRESH;

CREATE TABLE AFHDXAPPSTEST_THRESH
(
    TRGT_HOST           VARCHAR (32)  NOT NULL,
    PORT_NO             VARCHAR (32)  NOT NULL,
    SITE_NAME           VARCHAR (64)  NOT NULL,
    INFO                VARCHAR (128) NOT NULL,
    MSMT_HOST           VARCHAR (32)  NOT NULL,
    MSMT_TIME_START     DATETIME      NOT NULL,
    MSMT_TIME_END       DATETIME      NOT NULL,
    ACTIVEAPPS_MIN      VARCHAR (256) NOT NULL,
    ACTIVEAPPS_MAX      VARCHAR (256) NOT NULL,
    ACTIVE_SESSIONS_MIN VARCHAR (256) NOT NULL,
    ACTIVE_SESSIONS_MAX VARCHAR (256) NOT NULL,
    CURRENTLAUNCHES_MIN VARCHAR (256) NOT NULL,
    CURRENTLAUNCHES_MAX VARCHAR (256) NOT NULL,
    AVGLNCHDURATION_MIN VARCHAR (256) NOT NULL,
    AVGLNCHDURATION_MAX VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXAPPSTEST_THRESH
    ADD CONSTRAINT PK_AFHDXAPPSTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXAPPSTEST_THRESH
    ON AFHDXAPPSTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXAPPSTEST
    ON AFHDXAPPSTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXAPPSTEST
    ON AFHDXAPPSTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXDSKTPLOGINTEST;

CREATE TABLE AFHDXDSKTPLOGINTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    CURRENT_SESSIONS           DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_ST        VARCHAR (32)    NOT NULL,
    NEW_SESSIONS               DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_ST            VARCHAR (32)    NOT NULL,
    PERCENT_OF_NEW_SESSIONS    DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_ST VARCHAR (32)    NOT NULL,
    SESSION_LOGOUTS            DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_ST         VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXDSKTPLOGINTEST
    ON AFHDXDSKTPLOGINTEST(MSMT_TIME);

ALTER TABLE AFHDXDSKTPLOGINTEST
    ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXDSKTPLOGINTEST_TREND;

CREATE TABLE AFHDXDSKTPLOGINTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    CURRENT_SESSIONS_MIN          DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_MAX          DECIMAL (20, 4) NOT NULL,
    CURRENT_SESSIONS_STCNT        VARCHAR (32)    NOT NULL,
    NEW_SESSIONS_MIN              DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_MAX              DECIMAL (20, 4) NOT NULL,
    NEW_SESSIONS_STCNT            VARCHAR (32)    NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MIN   DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MAX   DECIMAL (20, 4) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_STCNT VARCHAR (32)    NOT NULL,
    SESSION_LOGOUTS_MIN           DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_MAX           DECIMAL (20, 4) NOT NULL,
    SESSION_LOGOUTS_STCNT         VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXDSKTPLOGINTEST_TREND
    ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXDSKTPLOGINTEST_THRESH;

CREATE TABLE AFHDXDSKTPLOGINTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    CURRENT_SESSIONS_MIN        VARCHAR (256) NOT NULL,
    CURRENT_SESSIONS_MAX        VARCHAR (256) NOT NULL,
    NEW_SESSIONS_MIN            VARCHAR (256) NOT NULL,
    NEW_SESSIONS_MAX            VARCHAR (256) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MIN VARCHAR (256) NOT NULL,
    PERCENT_OF_NEW_SESSIONS_MAX VARCHAR (256) NOT NULL,
    SESSION_LOGOUTS_MIN         VARCHAR (256) NOT NULL,
    SESSION_LOGOUTS_MAX         VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXDSKTPLOGINTEST_THRESH
    ADD CONSTRAINT PK_AFHDXDSKTPLOGINTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXDSKTPLOGINTEST_THRESH
    ON AFHDXDSKTPLOGINTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXDSKTPLOGINTEST
    ON AFHDXDSKTPLOGINTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXDSKTPLOGINTEST
    ON AFHDXDSKTPLOGINTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXDSKTPUSERSTEST;

CREATE TABLE AFHDXDSKTPUSERSTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    BYTESPERINTRVL             DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_ST          VARCHAR (32)    NOT NULL,
    BANDWIDTHPERINTRVL         DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_ST      VARCHAR (32)    NOT NULL,
    RTT                        DECIMAL (20, 4) NOT NULL,
    RTT_ST                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY                DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_ST             VARCHAR (32)    NOT NULL,
    DC_LATENCY                 DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_ST              VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    ACR_COUNTS                 DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_ST              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS         DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_ST      VARCHAR (32)    NOT NULL,
    HOSTDLY                    DECIMAL (20, 4) NOT NULL,
    HOSTDLY_ST                 VARCHAR (32)    NOT NULL,
    CLIENTDELAY                DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_ST             VARCHAR (32)    NOT NULL,
    SERVERDELAY                DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_ST             VARCHAR (32)    NOT NULL,
    DSKTP_LNCHS                DECIMAL (20, 4) NOT NULL,
    DSKTP_LNCHS_ST             VARCHAR (32)    NOT NULL,
    SESSION_STATUS             DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_ST          VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXDSKTPUSERSTEST
    ON AFHDXDSKTPUSERSTEST(MSMT_TIME);

ALTER TABLE AFHDXDSKTPUSERSTEST
    ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXDSKTPUSERSTEST_TREND;

CREATE TABLE AFHDXDSKTPUSERSTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL_MIN            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_MAX            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_STCNT          VARCHAR (32)    NOT NULL,
    BANDWIDTHPERINTRVL_MIN        DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_MAX        DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_STCNT      VARCHAR (32)    NOT NULL,
    RTT_MIN                       DECIMAL (20, 4) NOT NULL,
    RTT_MAX                       DECIMAL (20, 4) NOT NULL,
    RTT_STCNT                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY_MIN               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_MAX               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_STCNT             VARCHAR (32)    NOT NULL,
    DC_LATENCY_MIN                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_MAX                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_STCNT              VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    ACR_COUNTS_MIN                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_MAX                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_STCNT              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS_MIN        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_MAX        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_STCNT      VARCHAR (32)    NOT NULL,
    HOSTDLY_MIN                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_MAX                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_STCNT                 VARCHAR (32)    NOT NULL,
    CLIENTDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_STCNT             VARCHAR (32)    NOT NULL,
    SERVERDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_STCNT             VARCHAR (32)    NOT NULL,
    DSKTP_LNCHS_MIN               DECIMAL (20, 4) NOT NULL,
    DSKTP_LNCHS_MAX               DECIMAL (20, 4) NOT NULL,
    DSKTP_LNCHS_STCNT             VARCHAR (32)    NOT NULL,
    SESSION_STATUS_MIN            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_MAX            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_STCNT          VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXDSKTPUSERSTEST_TREND
    ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXDSKTPUSERSTEST_THRESH;

CREATE TABLE AFHDXDSKTPUSERSTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    BYTESPERINTRVL_MIN          VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MAX          VARCHAR (256) NOT NULL,
    BANDWIDTHPERINTRVL_MIN      VARCHAR (256) NOT NULL,
    BANDWIDTHPERINTRVL_MAX      VARCHAR (256) NOT NULL,
    RTT_MIN                     VARCHAR (256) NOT NULL,
    RTT_MAX                     VARCHAR (256) NOT NULL,
    WAN_LATENCY_MIN             VARCHAR (256) NOT NULL,
    WAN_LATENCY_MAX             VARCHAR (256) NOT NULL,
    DC_LATENCY_MIN              VARCHAR (256) NOT NULL,
    DC_LATENCY_MAX              VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    ACR_COUNTS_MIN              VARCHAR (256) NOT NULL,
    ACR_COUNTS_MAX              VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MIN      VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MAX      VARCHAR (256) NOT NULL,
    HOSTDLY_MIN                 VARCHAR (256) NOT NULL,
    HOSTDLY_MAX                 VARCHAR (256) NOT NULL,
    CLIENTDELAY_MIN             VARCHAR (256) NOT NULL,
    CLIENTDELAY_MAX             VARCHAR (256) NOT NULL,
    SERVERDELAY_MIN             VARCHAR (256) NOT NULL,
    SERVERDELAY_MAX             VARCHAR (256) NOT NULL,
    DSKTP_LNCHS_MIN             VARCHAR (256) NOT NULL,
    DSKTP_LNCHS_MAX             VARCHAR (256) NOT NULL,
    SESSION_STATUS_MIN          VARCHAR (256) NOT NULL,
    SESSION_STATUS_MAX          VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXDSKTPUSERSTEST_THRESH
    ADD CONSTRAINT PK_AFHDXDSKTPUSERSTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXDSKTPUSERSTEST_THRESH
    ON AFHDXDSKTPUSERSTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXDSKTPUSERSTEST
    ON AFHDXDSKTPUSERSTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXDSKTPUSERSTEST
    ON AFHDXDSKTPUSERSTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXACTDSKTPTEST;

CREATE TABLE AFHDXACTDSKTPTEST
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    BYTESPERINTRVL             DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_ST          VARCHAR (32)    NOT NULL,
    BANDWIDTHPERINTRVL         DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_ST      VARCHAR (32)    NOT NULL,
    RTT                        DECIMAL (20, 4) NOT NULL,
    RTT_ST                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY                DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_ST             VARCHAR (32)    NOT NULL,
    DC_LATENCY                 DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_ST              VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS    DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_ST VARCHAR (32)    NOT NULL,
    ACR_COUNTS                 DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_ST              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS         DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_ST      VARCHAR (32)    NOT NULL,
    ICA_CLIENT_TYPE            DECIMAL (20, 4) NOT NULL,
    ICA_CLIENT_TYPE_ST         VARCHAR (32)    NOT NULL,
    HOSTDLY                    DECIMAL (20, 4) NOT NULL,
    HOSTDLY_ST                 VARCHAR (32)    NOT NULL,
    SESSION_STATUS             DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_ST          VARCHAR (32)    NOT NULL,
    CLIENTDELAY                DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_ST             VARCHAR (32)    NOT NULL,
    SERVERDELAY                DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_ST             VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXACTDSKTPTEST
    ON AFHDXACTDSKTPTEST(MSMT_TIME);

ALTER TABLE AFHDXACTDSKTPTEST
    ADD CONSTRAINT PK_AFHDXACTDSKTPTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXACTDSKTPTEST_TREND;

CREATE TABLE AFHDXACTDSKTPTEST_TREND
(
    TRGT_HOST                     VARCHAR (32)    NOT NULL,
    PORT_NO                       VARCHAR (32)    NOT NULL,
    SITE_NAME                     VARCHAR (64)    NOT NULL,
    INFO                          VARCHAR (128)   NOT NULL,
    MSMT_HOST                     VARCHAR (32)    NOT NULL,
    MSMT_TIME                     DATETIME        NOT NULL,
    PERIOD                        VARCHAR (32)    NOT NULL,
    BYTESPERINTRVL_MIN            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_MAX            DECIMAL (20, 4) NOT NULL,
    BYTESPERINTRVL_STCNT          VARCHAR (32)    NOT NULL,
    BANDWIDTHPERINTRVL_MIN        DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_MAX        DECIMAL (20, 4) NOT NULL,
    BANDWIDTHPERINTRVL_STCNT      VARCHAR (32)    NOT NULL,
    RTT_MIN                       DECIMAL (20, 4) NOT NULL,
    RTT_MAX                       DECIMAL (20, 4) NOT NULL,
    RTT_STCNT                     VARCHAR (32)    NOT NULL,
    WAN_LATENCY_MIN               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_MAX               DECIMAL (20, 4) NOT NULL,
    WAN_LATENCY_STCNT             VARCHAR (32)    NOT NULL,
    DC_LATENCY_MIN                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_MAX                DECIMAL (20, 4) NOT NULL,
    DC_LATENCY_STCNT              VARCHAR (32)    NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX   DECIMAL (20, 4) NOT NULL,
    SERVER_SIDE_RETRANSMITS_STCNT VARCHAR (32)    NOT NULL,
    ACR_COUNTS_MIN                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_MAX                DECIMAL (20, 4) NOT NULL,
    ACR_COUNTS_STCNT              VARCHAR (32)    NOT NULL,
    SESSION_RECONNECTS_MIN        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_MAX        DECIMAL (20, 4) NOT NULL,
    SESSION_RECONNECTS_STCNT      VARCHAR (32)    NOT NULL,
    ICA_CLIENT_TYPE_MIN           DECIMAL (20, 4) NOT NULL,
    ICA_CLIENT_TYPE_MAX           DECIMAL (20, 4) NOT NULL,
    ICA_CLIENT_TYPE_STCNT         VARCHAR (32)    NOT NULL,
    HOSTDLY_MIN                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_MAX                   DECIMAL (20, 4) NOT NULL,
    HOSTDLY_STCNT                 VARCHAR (32)    NOT NULL,
    SESSION_STATUS_MIN            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_MAX            DECIMAL (20, 4) NOT NULL,
    SESSION_STATUS_STCNT          VARCHAR (32)    NOT NULL,
    CLIENTDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    CLIENTDELAY_STCNT             VARCHAR (32)    NOT NULL,
    SERVERDELAY_MIN               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_MAX               DECIMAL (20, 4) NOT NULL,
    SERVERDELAY_STCNT             VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXACTDSKTPTEST_TREND
    ADD CONSTRAINT PK_AFHDXACTDSKTPTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXACTDSKTPTEST_THRESH;

CREATE TABLE AFHDXACTDSKTPTEST_THRESH
(
    TRGT_HOST                   VARCHAR (32)  NOT NULL,
    PORT_NO                     VARCHAR (32)  NOT NULL,
    SITE_NAME                   VARCHAR (64)  NOT NULL,
    INFO                        VARCHAR (128) NOT NULL,
    MSMT_HOST                   VARCHAR (32)  NOT NULL,
    MSMT_TIME_START             DATETIME      NOT NULL,
    MSMT_TIME_END               DATETIME      NOT NULL,
    BYTESPERINTRVL_MIN          VARCHAR (256) NOT NULL,
    BYTESPERINTRVL_MAX          VARCHAR (256) NOT NULL,
    BANDWIDTHPERINTRVL_MIN      VARCHAR (256) NOT NULL,
    BANDWIDTHPERINTRVL_MAX      VARCHAR (256) NOT NULL,
    RTT_MIN                     VARCHAR (256) NOT NULL,
    RTT_MAX                     VARCHAR (256) NOT NULL,
    WAN_LATENCY_MIN             VARCHAR (256) NOT NULL,
    WAN_LATENCY_MAX             VARCHAR (256) NOT NULL,
    DC_LATENCY_MIN              VARCHAR (256) NOT NULL,
    DC_LATENCY_MAX              VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    CLIENT_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MIN VARCHAR (256) NOT NULL,
    SERVER_SIDE_RETRANSMITS_MAX VARCHAR (256) NOT NULL,
    ACR_COUNTS_MIN              VARCHAR (256) NOT NULL,
    ACR_COUNTS_MAX              VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MIN      VARCHAR (256) NOT NULL,
    SESSION_RECONNECTS_MAX      VARCHAR (256) NOT NULL,
    ICA_CLIENT_TYPE_MIN         VARCHAR (256) NOT NULL,
    ICA_CLIENT_TYPE_MAX         VARCHAR (256) NOT NULL,
    HOSTDLY_MIN                 VARCHAR (256) NOT NULL,
    HOSTDLY_MAX                 VARCHAR (256) NOT NULL,
    SESSION_STATUS_MIN          VARCHAR (256) NOT NULL,
    SESSION_STATUS_MAX          VARCHAR (256) NOT NULL,
    CLIENTDELAY_MIN             VARCHAR (256) NOT NULL,
    CLIENTDELAY_MAX             VARCHAR (256) NOT NULL,
    SERVERDELAY_MIN             VARCHAR (256) NOT NULL,
    SERVERDELAY_MAX             VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXACTDSKTPTEST_THRESH
    ADD CONSTRAINT PK_AFHDXACTDSKTPTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXACTDSKTPTEST_THRESH
    ON AFHDXACTDSKTPTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXACTDSKTPTEST
    ON AFHDXACTDSKTPTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXACTDSKTPTEST
    ON AFHDXACTDSKTPTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXGATEWAYTEST;

CREATE TABLE AFHDXGATEWAYTEST
(
    TRGT_HOST               VARCHAR (32)    NOT NULL,
    PORT_NO                 VARCHAR (32)    NOT NULL,
    SITE_NAME               VARCHAR (64)    NOT NULL,
    INFO                    VARCHAR (128)   NOT NULL,
    MSMT_HOST               VARCHAR (32)    NOT NULL,
    MSMT_TIME               DATETIME        NOT NULL,
    SESSIONLAUNCHES         DECIMAL (20, 4) NOT NULL,
    SESSIONLAUNCHES_ST      VARCHAR (32)    NOT NULL,
    SESSIONTERMINATES       DECIMAL (20, 4) NOT NULL,
    SESSIONTERMINATES_ST    VARCHAR (32)    NOT NULL,
    ACTIVESESSIONS          DECIMAL (20, 4) NOT NULL,
    ACTIVESESSIONS_ST       VARCHAR (32)    NOT NULL,
    APPLAUNCHES             DECIMAL (20, 4) NOT NULL,
    APPLAUNCHES_ST          VARCHAR (32)    NOT NULL,
    APPTERMINATES           DECIMAL (20, 4) NOT NULL,
    APPTERMINATES_ST        VARCHAR (32)    NOT NULL,
    ACTIVEAPPS              DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_ST           VARCHAR (32)    NOT NULL,
    NEW_DESKTOP_LAUNCHES    DECIMAL (20, 4) NOT NULL,
    NEW_DESKTOP_LAUNCHES_ST VARCHAR (32)    NOT NULL,
    DESKTOP_TERMINATES      DECIMAL (20, 4) NOT NULL,
    DESKTOP_TERMINATES_ST   VARCHAR (32)    NOT NULL,
    ACTIVE_DESKTOPS         DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_ST      VARCHAR (32)    NOT NULL,
    ACTIVE_APP_SESSIONS     DECIMAL (20, 4) NOT NULL,
    ACTIVE_APP_SESSIONS_ST  VARCHAR (32)    NOT NULL,
    NEW_APP_SESSIONS        DECIMAL (20, 4) NOT NULL,
    NEW_APP_SESSIONS_ST     VARCHAR (32)    NOT NULL,
    UNIQUE_USERS            DECIMAL (20, 4) NOT NULL,
    UNIQUE_USERS_ST         VARCHAR (32)    NOT NULL,
    AVG_BW                  DECIMAL (20, 4) NOT NULL,
    AVG_BW_ST               VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXGATEWAYTEST
    ON AFHDXGATEWAYTEST(MSMT_TIME);

ALTER TABLE AFHDXGATEWAYTEST
    ADD CONSTRAINT PK_AFHDXGATEWAYTEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXGATEWAYTEST_TREND;

CREATE TABLE AFHDXGATEWAYTEST_TREND
(
    TRGT_HOST                  VARCHAR (32)    NOT NULL,
    PORT_NO                    VARCHAR (32)    NOT NULL,
    SITE_NAME                  VARCHAR (64)    NOT NULL,
    INFO                       VARCHAR (128)   NOT NULL,
    MSMT_HOST                  VARCHAR (32)    NOT NULL,
    MSMT_TIME                  DATETIME        NOT NULL,
    PERIOD                     VARCHAR (32)    NOT NULL,
    SESSIONLAUNCHES_MIN        DECIMAL (20, 4) NOT NULL,
    SESSIONLAUNCHES_MAX        DECIMAL (20, 4) NOT NULL,
    SESSIONLAUNCHES_STCNT      VARCHAR (32)    NOT NULL,
    SESSIONTERMINATES_MIN      DECIMAL (20, 4) NOT NULL,
    SESSIONTERMINATES_MAX      DECIMAL (20, 4) NOT NULL,
    SESSIONTERMINATES_STCNT    VARCHAR (32)    NOT NULL,
    ACTIVESESSIONS_MIN         DECIMAL (20, 4) NOT NULL,
    ACTIVESESSIONS_MAX         DECIMAL (20, 4) NOT NULL,
    ACTIVESESSIONS_STCNT       VARCHAR (32)    NOT NULL,
    APPLAUNCHES_MIN            DECIMAL (20, 4) NOT NULL,
    APPLAUNCHES_MAX            DECIMAL (20, 4) NOT NULL,
    APPLAUNCHES_STCNT          VARCHAR (32)    NOT NULL,
    APPTERMINATES_MIN          DECIMAL (20, 4) NOT NULL,
    APPTERMINATES_MAX          DECIMAL (20, 4) NOT NULL,
    APPTERMINATES_STCNT        VARCHAR (32)    NOT NULL,
    ACTIVEAPPS_MIN             DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_MAX             DECIMAL (20, 4) NOT NULL,
    ACTIVEAPPS_STCNT           VARCHAR (32)    NOT NULL,
    NEW_DESKTOP_LAUNCHES_MIN   DECIMAL (20, 4) NOT NULL,
    NEW_DESKTOP_LAUNCHES_MAX   DECIMAL (20, 4) NOT NULL,
    NEW_DESKTOP_LAUNCHES_STCNT VARCHAR (32)    NOT NULL,
    DESKTOP_TERMINATES_MIN     DECIMAL (20, 4) NOT NULL,
    DESKTOP_TERMINATES_MAX     DECIMAL (20, 4) NOT NULL,
    DESKTOP_TERMINATES_STCNT   VARCHAR (32)    NOT NULL,
    ACTIVE_DESKTOPS_MIN        DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_MAX        DECIMAL (20, 4) NOT NULL,
    ACTIVE_DESKTOPS_STCNT      VARCHAR (32)    NOT NULL,
    ACTIVE_APP_SESSIONS_MIN    DECIMAL (20, 4) NOT NULL,
    ACTIVE_APP_SESSIONS_MAX    DECIMAL (20, 4) NOT NULL,
    ACTIVE_APP_SESSIONS_STCNT  VARCHAR (32)    NOT NULL,
    NEW_APP_SESSIONS_MIN       DECIMAL (20, 4) NOT NULL,
    NEW_APP_SESSIONS_MAX       DECIMAL (20, 4) NOT NULL,
    NEW_APP_SESSIONS_STCNT     VARCHAR (32)    NOT NULL,
    UNIQUE_USERS_MIN           DECIMAL (20, 4) NOT NULL,
    UNIQUE_USERS_MAX           DECIMAL (20, 4) NOT NULL,
    UNIQUE_USERS_STCNT         VARCHAR (32)    NOT NULL,
    AVG_BW_MIN                 DECIMAL (20, 4) NOT NULL,
    AVG_BW_MAX                 DECIMAL (20, 4) NOT NULL,
    AVG_BW_STCNT               VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXGATEWAYTEST_TREND
    ADD CONSTRAINT PK_AFHDXGATEWAYTEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXGATEWAYTEST_THRESH;

CREATE TABLE AFHDXGATEWAYTEST_THRESH
(
    TRGT_HOST                VARCHAR (32)  NOT NULL,
    PORT_NO                  VARCHAR (32)  NOT NULL,
    SITE_NAME                VARCHAR (64)  NOT NULL,
    INFO                     VARCHAR (128) NOT NULL,
    MSMT_HOST                VARCHAR (32)  NOT NULL,
    MSMT_TIME_START          DATETIME      NOT NULL,
    MSMT_TIME_END            DATETIME      NOT NULL,
    SESSIONLAUNCHES_MIN      VARCHAR (256) NOT NULL,
    SESSIONLAUNCHES_MAX      VARCHAR (256) NOT NULL,
    SESSIONTERMINATES_MIN    VARCHAR (256) NOT NULL,
    SESSIONTERMINATES_MAX    VARCHAR (256) NOT NULL,
    ACTIVESESSIONS_MIN       VARCHAR (256) NOT NULL,
    ACTIVESESSIONS_MAX       VARCHAR (256) NOT NULL,
    APPLAUNCHES_MIN          VARCHAR (256) NOT NULL,
    APPLAUNCHES_MAX          VARCHAR (256) NOT NULL,
    APPTERMINATES_MIN        VARCHAR (256) NOT NULL,
    APPTERMINATES_MAX        VARCHAR (256) NOT NULL,
    ACTIVEAPPS_MIN           VARCHAR (256) NOT NULL,
    ACTIVEAPPS_MAX           VARCHAR (256) NOT NULL,
    NEW_DESKTOP_LAUNCHES_MIN VARCHAR (256) NOT NULL,
    NEW_DESKTOP_LAUNCHES_MAX VARCHAR (256) NOT NULL,
    DESKTOP_TERMINATES_MIN   VARCHAR (256) NOT NULL,
    DESKTOP_TERMINATES_MAX   VARCHAR (256) NOT NULL,
    ACTIVE_DESKTOPS_MIN      VARCHAR (256) NOT NULL,
    ACTIVE_DESKTOPS_MAX      VARCHAR (256) NOT NULL,
    ACTIVE_APP_SESSIONS_MIN  VARCHAR (256) NOT NULL,
    ACTIVE_APP_SESSIONS_MAX  VARCHAR (256) NOT NULL,
    NEW_APP_SESSIONS_MIN     VARCHAR (256) NOT NULL,
    NEW_APP_SESSIONS_MAX     VARCHAR (256) NOT NULL,
    UNIQUE_USERS_MIN         VARCHAR (256) NOT NULL,
    UNIQUE_USERS_MAX         VARCHAR (256) NOT NULL,
    AVG_BW_MIN               VARCHAR (256) NOT NULL,
    AVG_BW_MAX               VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXGATEWAYTEST_THRESH
    ADD CONSTRAINT PK_AFHDXGATEWAYTEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXGATEWAYTEST_THRESH
    ON AFHDXGATEWAYTEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);

CREATE INDEX IDX_TH_AFHDXGATEWAYTEST
    ON AFHDXGATEWAYTEST_THRESH(MSMT_TIME_START);

CREATE INDEX IDX_TR_AFHDXGATEWAYTEST
    ON AFHDXGATEWAYTEST_TREND(MSMT_TIME, PERIOD);

DROP TABLE AFHDXLICENSETEST;

CREATE TABLE AFHDXLICENSETEST
(
    TRGT_HOST              VARCHAR (32)    NOT NULL,
    PORT_NO                VARCHAR (32)    NOT NULL,
    SITE_NAME              VARCHAR (64)    NOT NULL,
    INFO                   VARCHAR (128)   NOT NULL,
    MSMT_HOST              VARCHAR (32)    NOT NULL,
    MSMT_TIME              DATETIME        NOT NULL,
    TOTAL_LICENSES         DECIMAL (20, 4) NOT NULL,
    TOTAL_LICENSES_ST      VARCHAR (32)    NOT NULL,
    LICENSES_IN_USE        DECIMAL (20, 4) NOT NULL,
    LICENSES_IN_USE_ST     VARCHAR (32)    NOT NULL,
    PERCENTAGE_CONSUMED    DECIMAL (20, 4) NOT NULL,
    PERCENTAGE_CONSUMED_ST VARCHAR (32)    NOT NULL,
    AVAILABLE              DECIMAL (20, 4) NOT NULL,
    AVAILABLE_ST           VARCHAR (32)    NOT NULL
);

CREATE INDEX IDX_AFHDXLICENSETEST
    ON AFHDXLICENSETEST(MSMT_TIME);

ALTER TABLE AFHDXLICENSETEST
    ADD CONSTRAINT PK_AFHDXLICENSETEST PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE AFHDXLICENSETEST_TREND;

CREATE TABLE AFHDXLICENSETEST_TREND
(
    TRGT_HOST                 VARCHAR (32)    NOT NULL,
    PORT_NO                   VARCHAR (32)    NOT NULL,
    SITE_NAME                 VARCHAR (64)    NOT NULL,
    INFO                      VARCHAR (128)   NOT NULL,
    MSMT_HOST                 VARCHAR (32)    NOT NULL,
    MSMT_TIME                 DATETIME        NOT NULL,
    PERIOD                    VARCHAR (32)    NOT NULL,
    TOTAL_LICENSES_MIN        DECIMAL (20, 4) NOT NULL,
    TOTAL_LICENSES_MAX        DECIMAL (20, 4) NOT NULL,
    TOTAL_LICENSES_STCNT      VARCHAR (32)    NOT NULL,
    LICENSES_IN_USE_MIN       DECIMAL (20, 4) NOT NULL,
    LICENSES_IN_USE_MAX       DECIMAL (20, 4) NOT NULL,
    LICENSES_IN_USE_STCNT     VARCHAR (32)    NOT NULL,
    PERCENTAGE_CONSUMED_MIN   DECIMAL (20, 4) NOT NULL,
    PERCENTAGE_CONSUMED_MAX   DECIMAL (20, 4) NOT NULL,
    PERCENTAGE_CONSUMED_STCNT VARCHAR (32)    NOT NULL,
    AVAILABLE_MIN             DECIMAL (20, 4) NOT NULL,
    AVAILABLE_MAX             DECIMAL (20, 4) NOT NULL,
    AVAILABLE_STCNT           VARCHAR (32)    NOT NULL
);

ALTER TABLE AFHDXLICENSETEST_TREND
    ADD CONSTRAINT PK_AFHDXLICENSETEST_TREND PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME, PERIOD);

DROP TABLE AFHDXLICENSETEST_THRESH;

CREATE TABLE AFHDXLICENSETEST_THRESH
(
    TRGT_HOST               VARCHAR (32)  NOT NULL,
    PORT_NO                 VARCHAR (32)  NOT NULL,
    SITE_NAME               VARCHAR (64)  NOT NULL,
    INFO                    VARCHAR (128) NOT NULL,
    MSMT_HOST               VARCHAR (32)  NOT NULL,
    MSMT_TIME_START         DATETIME      NOT NULL,
    MSMT_TIME_END           DATETIME      NOT NULL,
    TOTAL_LICENSES_MIN      VARCHAR (256) NOT NULL,
    TOTAL_LICENSES_MAX      VARCHAR (256) NOT NULL,
    LICENSES_IN_USE_MIN     VARCHAR (256) NOT NULL,
    LICENSES_IN_USE_MAX     VARCHAR (256) NOT NULL,
    PERCENTAGE_CONSUMED_MIN VARCHAR (256) NOT NULL,
    PERCENTAGE_CONSUMED_MAX VARCHAR (256) NOT NULL,
    AVAILABLE_MIN           VARCHAR (256) NOT NULL,
    AVAILABLE_MAX           VARCHAR (256) NOT NULL
);

ALTER TABLE AFHDXLICENSETEST_THRESH ADD CONSTRAINT PK_AFHDXLICENSETEST_THRESH PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME_START);

CREATE INDEX IDX_AFHDXLICENSETEST_THRESH ON AFHDXLICENSETEST_THRESH(MSMT_HOST, MSMT_TIME_START, MSMT_TIME_END);
CREATE INDEX IDX_TH_AFHDXLICENSETEST ON AFHDXLICENSETEST_THRESH(MSMT_TIME_START);
CREATE INDEX IDX_TR_AFHDXLICENSETEST ON AFHDXLICENSETEST_TREND(MSMT_TIME, PERIOD);


DROP TABLE AFNSWEBAPPTEST;
CREATE TABLE AFNSWEBAPPTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_CNL DECIMAL(20,4) NOT NULL,
MAX_CNL_ST VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_SNL DECIMAL(20,4) NOT NULL,
MAX_SNL_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBAPPTEST ON AFNSWEBAPPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBAPPTEST ADD CONSTRAINT PK_AFNSWEBAPPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBAPPTEST_TREND;
CREATE TABLE AFNSWEBAPPTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_CNL_MIN DECIMAL(20,4) NOT NULL,
MAX_CNL_MAX DECIMAL(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_SNL_MIN DECIMAL(20,4) NOT NULL,
MAX_SNL_MAX DECIMAL(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBAPPTEST_TREND ADD CONSTRAINT PK_AFNSWEBAPPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBAPPTEST_THRESH;
CREATE TABLE AFNSWEBAPPTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_CNL_MIN VARCHAR(256) NOT NULL,
MAX_CNL_MAX VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_SNL_MIN VARCHAR(256) NOT NULL,
MAX_SNL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBAPPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBAPPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBAPPTEST_THRESH ON AFNSWEBAPPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBAPPTEST ON AFNSWEBAPPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBAPPTEST ON AFNSWEBAPPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBCLIENTTEST;
CREATE TABLE AFNSWEBCLIENTTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
REQUESTS DECIMAL(20,4) NOT NULL,
REQUESTS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RENDER_TIME DECIMAL(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_CNL DECIMAL(20,4) NOT NULL,
MAX_CNL_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBCLIENTTEST ADD CONSTRAINT PK_AFNSWEBCLIENTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBCLIENTTEST_TREND;
CREATE TABLE AFNSWEBCLIENTTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
REQUESTS_MIN DECIMAL(20,4) NOT NULL,
REQUESTS_MAX DECIMAL(20,4) NOT NULL,
REQUESTS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RENDER_TIME_MIN DECIMAL(20,4) NOT NULL,
RENDER_TIME_MAX DECIMAL(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_CNL_MIN DECIMAL(20,4) NOT NULL,
MAX_CNL_MAX DECIMAL(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBCLIENTTEST_TREND ADD CONSTRAINT PK_AFNSWEBCLIENTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBCLIENTTEST_THRESH;
CREATE TABLE AFNSWEBCLIENTTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
REQUESTS_MIN VARCHAR(256) NOT NULL,
REQUESTS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RENDER_TIME_MIN VARCHAR(256) NOT NULL,
RENDER_TIME_MAX VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_CNL_MIN VARCHAR(256) NOT NULL,
MAX_CNL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBCLIENTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBCLIENTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBCLIENTTEST_THRESH ON AFNSWEBCLIENTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBCLIENTTEST ON AFNSWEBCLIENTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBSERVERSTEST;
CREATE TABLE AFNSWEBSERVERSTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_SNL DECIMAL(20,4) NOT NULL,
MAX_SNL_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBSERVERSTEST ADD CONSTRAINT PK_AFNSWEBSERVERSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBSERVERSTEST_TREND;
CREATE TABLE AFNSWEBSERVERSTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_SNL_MIN DECIMAL(20,4) NOT NULL,
MAX_SNL_MAX DECIMAL(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBSERVERSTEST_TREND ADD CONSTRAINT PK_AFNSWEBSERVERSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBSERVERSTEST_THRESH;
CREATE TABLE AFNSWEBSERVERSTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_SNL_MIN VARCHAR(256) NOT NULL,
MAX_SNL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBSERVERSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBSERVERSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBSERVERSTEST_THRESH ON AFNSWEBSERVERSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBSERVERSTEST ON AFNSWEBSERVERSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBUSERAGNTTEST;
CREATE TABLE AFNSWEBUSERAGNTTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RENDER_TIME DECIMAL(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBUSERAGNTTEST ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBUSERAGNTTEST_TREND;
CREATE TABLE AFNSWEBUSERAGNTTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RENDER_TIME_MIN DECIMAL(20,4) NOT NULL,
RENDER_TIME_MAX DECIMAL(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBUSERAGNTTEST_TREND ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBUSERAGNTTEST_THRESH;
CREATE TABLE AFNSWEBUSERAGNTTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RENDER_TIME_MIN VARCHAR(256) NOT NULL,
RENDER_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBUSERAGNTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBUSERAGNTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBUSERAGNTTEST_THRESH ON AFNSWEBUSERAGNTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBUSERAGNTTEST ON AFNSWEBUSERAGNTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBOSTEST;
CREATE TABLE AFNSWEBOSTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RENDER_TIME DECIMAL(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBOSTEST ON AFNSWEBOSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBOSTEST ADD CONSTRAINT PK_AFNSWEBOSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBOSTEST_TREND;
CREATE TABLE AFNSWEBOSTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RENDER_TIME_MIN DECIMAL(20,4) NOT NULL,
RENDER_TIME_MAX DECIMAL(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBOSTEST_TREND ADD CONSTRAINT PK_AFNSWEBOSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBOSTEST_THRESH;
CREATE TABLE AFNSWEBOSTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RENDER_TIME_MIN VARCHAR(256) NOT NULL,
RENDER_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBOSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBOSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBOSTEST_THRESH ON AFNSWEBOSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBOSTEST ON AFNSWEBOSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBOSTEST ON AFNSWEBOSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBHTTPRESPTEST;
CREATE TABLE AFNSWEBHTTPRESPTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RENDER_TIME DECIMAL(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBHTTPRESPTEST ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBHTTPRESPTEST_TREND;
CREATE TABLE AFNSWEBHTTPRESPTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RENDER_TIME_MIN DECIMAL(20,4) NOT NULL,
RENDER_TIME_MAX DECIMAL(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBHTTPRESPTEST_TREND ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBHTTPRESPTEST_THRESH;
CREATE TABLE AFNSWEBHTTPRESPTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RENDER_TIME_MIN VARCHAR(256) NOT NULL,
RENDER_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBHTTPRESPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBHTTPRESPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBHTTPRESPTEST_THRESH ON AFNSWEBHTTPRESPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBHTTPRESPTEST ON AFNSWEBHTTPRESPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBHTTPREQTEST;
CREATE TABLE AFNSWEBHTTPREQTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST(MSMT_TIME);
ALTER TABLE AFNSWEBHTTPREQTEST ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBHTTPREQTEST_TREND;
CREATE TABLE AFNSWEBHTTPREQTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBHTTPREQTEST_TREND ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBHTTPREQTEST_THRESH;
CREATE TABLE AFNSWEBHTTPREQTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBHTTPREQTEST_THRESH ADD CONSTRAINT PK_AFNSWEBHTTPREQTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBHTTPREQTEST_THRESH ON AFNSWEBHTTPREQTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBHTTPREQTEST ON AFNSWEBHTTPREQTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBDEVICESTEST;
CREATE TABLE AFNSWEBDEVICESTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
NETSCALER_AVG_LATENCY DECIMAL(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_ST VARCHAR(32) NOT NULL,
NETSCALER_MAX_LATENCY DECIMAL(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST(MSMT_TIME);
ALTER TABLE AFNSWEBDEVICESTEST ADD CONSTRAINT PK_AFNSWEBDEVICESTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBDEVICESTEST_TREND;
CREATE TABLE AFNSWEBDEVICESTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
NETSCALER_AVG_LATENCY_MIN DECIMAL(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_MAX DECIMAL(20,4) NOT NULL,
NETSCALER_AVG_LATENCY_STCNT VARCHAR(32) NOT NULL,
NETSCALER_MAX_LATENCY_MIN DECIMAL(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_MAX DECIMAL(20,4) NOT NULL,
NETSCALER_MAX_LATENCY_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBDEVICESTEST_TREND ADD CONSTRAINT PK_AFNSWEBDEVICESTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBDEVICESTEST_THRESH;
CREATE TABLE AFNSWEBDEVICESTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
NETSCALER_AVG_LATENCY_MIN VARCHAR(256) NOT NULL,
NETSCALER_AVG_LATENCY_MAX VARCHAR(256) NOT NULL,
NETSCALER_MAX_LATENCY_MIN VARCHAR(256) NOT NULL,
NETSCALER_MAX_LATENCY_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBDEVICESTEST_THRESH ADD CONSTRAINT PK_AFNSWEBDEVICESTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBDEVICESTEST_THRESH ON AFNSWEBDEVICESTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBDEVICESTEST ON AFNSWEBDEVICESTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE AFNSWEBURLSTEST;
CREATE TABLE AFNSWEBURLSTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RENDER_TIME DECIMAL(20,4) NOT NULL,
RENDER_TIME_ST VARCHAR(32) NOT NULL,
LOAD_TIME DECIMAL(20,4) NOT NULL,
LOAD_TIME_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBURLSTEST ON AFNSWEBURLSTEST(MSMT_TIME);
ALTER TABLE AFNSWEBURLSTEST ADD CONSTRAINT PK_AFNSWEBURLSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBURLSTEST_TREND;
CREATE TABLE AFNSWEBURLSTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RENDER_TIME_MIN DECIMAL(20,4) NOT NULL,
RENDER_TIME_MAX DECIMAL(20,4) NOT NULL,
RENDER_TIME_STCNT VARCHAR(32) NOT NULL,
LOAD_TIME_MIN DECIMAL(20,4) NOT NULL,
LOAD_TIME_MAX DECIMAL(20,4) NOT NULL,
LOAD_TIME_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBURLSTEST_TREND ADD CONSTRAINT PK_AFNSWEBURLSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBURLSTEST_THRESH;
CREATE TABLE AFNSWEBURLSTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RENDER_TIME_MIN VARCHAR(256) NOT NULL,
RENDER_TIME_MAX VARCHAR(256) NOT NULL,
LOAD_TIME_MIN VARCHAR(256) NOT NULL,
LOAD_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBURLSTEST_THRESH ADD CONSTRAINT PK_AFNSWEBURLSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBURLSTEST_THRESH ON AFNSWEBURLSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBURLSTEST ON AFNSWEBURLSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBURLSTEST ON AFNSWEBURLSTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBPROTTEST;
CREATE TABLE AFNSWEBPROTTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
HITS DECIMAL(20,4) NOT NULL,
HITS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_ST VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_CNL DECIMAL(20,4) NOT NULL,
MAX_CNL_ST VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,

MAX_SNL DECIMAL(20,4) NOT NULL,
MAX_SNL_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBPROTTEST ON AFNSWEBPROTTEST(MSMT_TIME);
ALTER TABLE AFNSWEBPROTTEST ADD CONSTRAINT PK_AFNSWEBPROTTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBPROTTEST_TREND;
CREATE TABLE AFNSWEBPROTTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
HITS_MIN DECIMAL(20,4) NOT NULL,
HITS_MAX DECIMAL(20,4) NOT NULL,
HITS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT VARCHAR(32) NOT NULL,
SERVER_PROCESSING_TIME_MIN DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_MAX DECIMAL(20,4) NOT NULL,
SERVER_PROCESSING_TIME_STCNT VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_CNL_MIN DECIMAL(20,4) NOT NULL,
MAX_CNL_MAX DECIMAL(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR(32) NOT NULL,
SERVER_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
SERVER_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,

MAX_SNL_MIN DECIMAL(20,4) NOT NULL,
MAX_SNL_MAX DECIMAL(20,4) NOT NULL,
MAX_SNL_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBPROTTEST_TREND ADD CONSTRAINT PK_AFNSWEBPROTTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBPROTTEST_THRESH;
CREATE TABLE AFNSWEBPROTTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
HITS_MIN VARCHAR(256) NOT NULL,
HITS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MIN VARCHAR(256) NOT NULL,
SERVER_PROCESSING_TIME_MAX VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_CNL_MIN VARCHAR(256) NOT NULL,
MAX_CNL_MAX VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
SERVER_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_SNL_MIN VARCHAR(256) NOT NULL,
MAX_SNL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBPROTTEST_THRESH ADD CONSTRAINT PK_AFNSWEBPROTTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBPROTTEST_THRESH ON AFNSWEBPROTTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBPROTTEST ON AFNSWEBPROTTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBPROTTEST ON AFNSWEBPROTTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE AFNSWEBVIPTEST;
CREATE TABLE AFNSWEBVIPTEST(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
REQUESTS DECIMAL(20,4) NOT NULL,
REQUESTS_ST VARCHAR(32) NOT NULL,
BANDWIDTH DECIMAL(20,4) NOT NULL,
BANDWIDTH_ST VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_ST VARCHAR(32) NOT NULL,
MAX_CNL DECIMAL(20,4) NOT NULL,
MAX_CNL_ST VARCHAR(32) NOT NULL);

CREATE INDEX IDX_AFNSWEBVIPTEST ON AFNSWEBVIPTEST(MSMT_TIME);
ALTER TABLE AFNSWEBVIPTEST ADD CONSTRAINT PK_AFNSWEBVIPTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AFNSWEBVIPTEST_TREND;
CREATE TABLE AFNSWEBVIPTEST_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       DATETIME NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
REQUESTS_MIN DECIMAL(20,4) NOT NULL,
REQUESTS_MAX DECIMAL(20,4) NOT NULL,
REQUESTS_STCNT VARCHAR(32) NOT NULL,
BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_STCNT VARCHAR(32) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX DECIMAL(20,4) NOT NULL,
CLIENT_NETWORK_LATENCY_STCNT VARCHAR(32) NOT NULL,
MAX_CNL_MIN DECIMAL(20,4) NOT NULL,
MAX_CNL_MAX DECIMAL(20,4) NOT NULL,
MAX_CNL_STCNT VARCHAR(32) NOT NULL);

ALTER TABLE AFNSWEBVIPTEST_TREND ADD CONSTRAINT PK_AFNSWEBVIPTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AFNSWEBVIPTEST_THRESH;
CREATE TABLE AFNSWEBVIPTEST_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START DATETIME NOT NULL,
MSMT_TIME_END   DATETIME NOT NULL,
REQUESTS_MIN VARCHAR(256) NOT NULL,
REQUESTS_MAX VARCHAR(256) NOT NULL,
BANDWIDTH_MIN VARCHAR(256) NOT NULL,
BANDWIDTH_MAX VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MIN VARCHAR(256) NOT NULL,
CLIENT_NETWORK_LATENCY_MAX VARCHAR(256) NOT NULL,
MAX_CNL_MIN VARCHAR(256) NOT NULL,
MAX_CNL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AFNSWEBVIPTEST_THRESH ADD CONSTRAINT PK_AFNSWEBVIPTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AFNSWEBVIPTEST_THRESH ON AFNSWEBVIPTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AFNSWEBVIPTEST ON AFNSWEBVIPTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AFNSWEBVIPTEST ON AFNSWEBVIPTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE SapWasUserSessTest;
CREATE TABLE SapWasUserSessTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	LoggedInUsers			decimal(20,4) NOT NULL,
	LoggedInUsers_ST			varchar(32) NOT NULL,
	OpenedSessions			decimal(20,4) NOT NULL,
	OpenedSessions_ST			varchar(32) NOT NULL,
	ActiveSessions			decimal(20,4) NOT NULL,
	ActiveSessions_ST			varchar(32) NOT NULL,
	SecuritySessions			decimal(20,4) NOT NULL,
	SecuritySessions_ST			varchar(32) NOT NULL,
	EjbSessions			decimal(20,4) NOT NULL,
	EjbSessions_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SapWasUserSessTest ON SapWasUserSessTest(MSMT_TIME);
ALTER TABLE SapWasUserSessTest ADD constraint PK_SapWasUserSessTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SapWasUserSessTest_TREND;
CREATE TABLE SapWasUserSessTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	LoggedInUsers_MIN			decimal(20,4) NOT NULL,
	LoggedInUsers_MAX			decimal(20,4) NOT NULL,
	LoggedInUsers_STCNT			varchar(32) NOT NULL,
	OpenedSessions_MIN			decimal(20,4) NOT NULL,
	OpenedSessions_MAX			decimal(20,4) NOT NULL,
	OpenedSessions_STCNT			varchar(32) NOT NULL,
	ActiveSessions_MIN			decimal(20,4) NOT NULL,
	ActiveSessions_MAX			decimal(20,4) NOT NULL,
	ActiveSessions_STCNT			varchar(32) NOT NULL,
	SecuritySessions_MIN			decimal(20,4) NOT NULL,
	SecuritySessions_MAX			decimal(20,4) NOT NULL,
	SecuritySessions_STCNT			varchar(32) NOT NULL,
	EjbSessions_MIN			decimal(20,4) NOT NULL,
	EjbSessions_MAX			decimal(20,4) NOT NULL,
	EjbSessions_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SapWasUserSessTest_TREND ADD constraint PK_SapWasUserSessTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SapWasUserSessTest_THRESH;
CREATE TABLE SapWasUserSessTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	LoggedInUsers_MIN			varchar(256)	 NOT NULL,
	LoggedInUsers_MAX	varchar(256)	 NOT NULL,
	OpenedSessions_MIN			varchar(256)	 NOT NULL,
	OpenedSessions_MAX	varchar(256)	 NOT NULL,
	ActiveSessions_MIN			varchar(256)	 NOT NULL,
	ActiveSessions_MAX	varchar(256)	 NOT NULL,
	SecuritySessions_MIN			varchar(256)	 NOT NULL,
	SecuritySessions_MAX	varchar(256)	 NOT NULL,
	EjbSessions_MIN			varchar(256)	 NOT NULL,
	EjbSessions_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SapWasUserSessTest_THRESH ADD constraint PK_SapWasUserSessTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SapWasUserSessTest_THRESH ON SapWasUserSessTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SapWasUserSessTest ON SapWasUserSessTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SapWasUserSessTest ON SapWasUserSessTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HttpResponsesTest;
CREATE TABLE HttpResponsesTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
RESPONSES decimal(20,4) NOT NULL,
RESPONSES_ST varchar(32) NOT NULL,
RESPONSERATE decimal(20,4) NOT NULL,
RESPONSERATE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HttpResponsesTest ON HttpResponsesTest(MSMT_TIME);
ALTER TABLE HttpResponsesTest ADD constraint PK_HttpResponsesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HttpResponsesTest_TREND;
CREATE TABLE HttpResponsesTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RESPONSES_MIN decimal(20,4) NOT NULL,
RESPONSES_MAX decimal(20,4) NOT NULL,
RESPONSES_STCNT varchar(32) NOT NULL,
RESPONSERATE_MIN decimal(20,4) NOT NULL,
RESPONSERATE_MAX decimal(20,4) NOT NULL,
RESPONSERATE_STCNT varchar(32) NOT NULL);

ALTER TABLE HttpResponsesTest_TREND ADD constraint PK_HttpResponsesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HttpResponsesTest_THRESH;
CREATE TABLE HttpResponsesTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RESPONSES_MIN VARCHAR(256) NOT NULL,
RESPONSES_MAX VARCHAR(256) NOT NULL,
RESPONSERATE_MIN VARCHAR(256) NOT NULL,
RESPONSERATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HttpResponsesTest_THRESH ADD constraint PK_HttpResponsesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HttpResponsesTest_THRESH ON HttpResponsesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HttpResponsesTest ON HttpResponsesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HttpResponsesTest ON HttpResponsesTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE AsAbapCenProcTest;
CREATE TABLE AsAbapCenProcTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Display_Status DECIMAL(20,4) NOT NULL,
Display_Status_ST varchar(32) NOT NULL,
Process_Status DECIMAL(20,4) NOT NULL,
Process_Status_ST varchar(32) NOT NULL,
is_Restarted DECIMAL(20,4) NOT NULL,
is_Restarted_ST varchar(32) NOT NULL);

CREATE INDEX IDX_AsAbapCenProcTest ON AsAbapCenProcTest(MSMT_TIME);
ALTER TABLE AsAbapCenProcTest ADD constraint PK_AsAbapCenProcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsAbapCenProcTest_TREND;
CREATE TABLE AsAbapCenProcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Display_Status_MIN DECIMAL(20,4) NOT NULL,
Display_Status_MAX DECIMAL(20,4) NOT NULL,
Display_Status_STCNT varchar(32) NOT NULL,
Process_Status_MIN DECIMAL(20,4) NOT NULL,
Process_Status_MAX DECIMAL(20,4) NOT NULL,
Process_Status_STCNT varchar(32) NOT NULL,
is_Restarted_MIN DECIMAL(20,4) NOT NULL,
is_Restarted_MAX DECIMAL(20,4) NOT NULL,
is_Restarted_STCNT varchar(32) NOT NULL);

ALTER TABLE AsAbapCenProcTest_TREND ADD constraint PK_AsAbapCenProcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsAbapCenProcTest_THRESH;
CREATE TABLE AsAbapCenProcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Display_Status_MIN VARCHAR(256) NOT NULL,
Display_Status_MAX VARCHAR(256) NOT NULL,
Process_Status_MIN VARCHAR(256) NOT NULL,
Process_Status_MAX VARCHAR(256) NOT NULL,
is_Restarted_MIN VARCHAR(256) NOT NULL,
is_Restarted_MAX VARCHAR(256) NOT NULL);

ALTER TABLE AsAbapCenProcTest_THRESH ADD constraint PK_AsAbapCenProcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsAbapCenProcTest_THRESH ON AsAbapCenProcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsAbapCenProcTest ON AsAbapCenProcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsAbapCenProcTest ON AsAbapCenProcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPLocksTest;
CREATE TABLE SAPLocksTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	exclusiveLocks			decimal(20,4) NOT NULL,
	exclusiveLocks_ST			varchar(32) NOT NULL,
	exclNonCumLocks			decimal(20,4) NOT NULL,
	exclNonCumLocks_ST			varchar(32) NOT NULL,
	otherLocks			decimal(20,4) NOT NULL,
	otherLocks_ST			varchar(32) NOT NULL,
	allLocks			decimal(20,4) NOT NULL,
	allLocks_ST			varchar(32) NOT NULL,
	maxLocks			decimal(20,4) NOT NULL,
	maxLocks_ST			varchar(32) NOT NULL,
	currLockUtil			decimal(20,4) NOT NULL,
	currLockUtil_ST			varchar(32) NOT NULL,
	highLocks			decimal(20,4) NOT NULL,
	highLocks_ST			varchar(32) NOT NULL,
	highLockUtil			decimal(20,4) NOT NULL,
	highLockUtil_ST			varchar(32) NOT NULL,
	currOwners			decimal(20,4) NOT NULL,
	currOwners_ST			varchar(32) NOT NULL,
	currOwnerUtil			decimal(20,4) NOT NULL,
	currOwnerUtil_ST			varchar(32) NOT NULL,
	currArgs			decimal(20,4) NOT NULL,
	currArgs_ST			varchar(32) NOT NULL,
	currArgUtil			decimal(20,4) NOT NULL,
	currArgUtil_ST			varchar(32) NOT NULL,
	enqReqs			decimal(20,4) NOT NULL,
	enqReqs_ST			varchar(32) NOT NULL,
	enqReqRate			decimal(20,4) NOT NULL,
	enqReqRate_ST			varchar(32) NOT NULL,
	enqReqRej			decimal(20,4) NOT NULL,
	enqReqRej_ST			varchar(32) NOT NULL,
	enqReqRejRate			decimal(20,4) NOT NULL,
	enqReqRejRate_ST			varchar(32) NOT NULL,
	pctEnqReqRej			decimal(20,4) NOT NULL,
	pctEnqReqRej_ST			varchar(32) NOT NULL,
	enqErrs			decimal(20,4) NOT NULL,
	enqErrs_ST			varchar(32) NOT NULL,
	enqErrRate			decimal(20,4) NOT NULL,
	enqErrRate_ST			varchar(32) NOT NULL,
	deqReqs			decimal(20,4) NOT NULL,
	deqReqs_ST			varchar(32) NOT NULL,
	deqReqRate			decimal(20,4) NOT NULL,
	deqReqRate_ST			varchar(32) NOT NULL,
	deqErrs			decimal(20,4) NOT NULL,
	deqErrs_ST			varchar(32) NOT NULL,
	deqErrRate			decimal(20,4) NOT NULL,
	deqErrRate_ST			varchar(32) NOT NULL,
	UpdReqRate			decimal(20,4) NOT NULL,
	UpdReqRate_ST			varchar(32) NOT NULL,
	lckTblTime			decimal(20,4) NOT NULL,
	lckTblTime_ST			varchar(32) NOT NULL,
	lckTblWaitTime			decimal(20,4) NOT NULL,
	lckTblWaitTime_ST			varchar(32) NOT NULL,
	lckSrvTime			decimal(20,4) NOT NULL,
	lckSrvTime_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SAPLocksTest ON SAPLocksTest(MSMT_TIME);
ALTER TABLE SAPLocksTest ADD constraint PK_SAPLocksTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPLocksTest_TREND;
CREATE TABLE SAPLocksTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	exclusiveLocks_MIN			decimal(20,4) NOT NULL,
	exclusiveLocks_MAX			decimal(20,4) NOT NULL,
	exclusiveLocks_STCNT			varchar(32) NOT NULL,
	exclNonCumLocks_MIN			decimal(20,4) NOT NULL,
	exclNonCumLocks_MAX			decimal(20,4) NOT NULL,
	exclNonCumLocks_STCNT			varchar(32) NOT NULL,
	otherLocks_MIN			decimal(20,4) NOT NULL,
	otherLocks_MAX			decimal(20,4) NOT NULL,
	otherLocks_STCNT			varchar(32) NOT NULL,
	allLocks_MIN			decimal(20,4) NOT NULL,
	allLocks_MAX			decimal(20,4) NOT NULL,
	allLocks_STCNT			varchar(32) NOT NULL,
	maxLocks_MIN			decimal(20,4) NOT NULL,
	maxLocks_MAX			decimal(20,4) NOT NULL,
	maxLocks_STCNT			varchar(32) NOT NULL,
	currLockUtil_MIN			decimal(20,4) NOT NULL,
	currLockUtil_MAX			decimal(20,4) NOT NULL,
	currLockUtil_STCNT			varchar(32) NOT NULL,
	highLocks_MIN			decimal(20,4) NOT NULL,
	highLocks_MAX			decimal(20,4) NOT NULL,
	highLocks_STCNT			varchar(32) NOT NULL,
	highLockUtil_MIN			decimal(20,4) NOT NULL,
	highLockUtil_MAX			decimal(20,4) NOT NULL,
	highLockUtil_STCNT			varchar(32) NOT NULL,
	currOwners_MIN			decimal(20,4) NOT NULL,
	currOwners_MAX			decimal(20,4) NOT NULL,
	currOwners_STCNT			varchar(32) NOT NULL,
	currOwnerUtil_MIN			decimal(20,4) NOT NULL,
	currOwnerUtil_MAX			decimal(20,4) NOT NULL,
	currOwnerUtil_STCNT			varchar(32) NOT NULL,
	currArgs_MIN			decimal(20,4) NOT NULL,
	currArgs_MAX			decimal(20,4) NOT NULL,
	currArgs_STCNT			varchar(32) NOT NULL,
	currArgUtil_MIN			decimal(20,4) NOT NULL,
	currArgUtil_MAX			decimal(20,4) NOT NULL,
	currArgUtil_STCNT			varchar(32) NOT NULL,
	enqReqs_MIN			decimal(20,4) NOT NULL,
	enqReqs_MAX			decimal(20,4) NOT NULL,
	enqReqs_STCNT			varchar(32) NOT NULL,
	enqReqRate_MIN			decimal(20,4) NOT NULL,
	enqReqRate_MAX			decimal(20,4) NOT NULL,
	enqReqRate_STCNT			varchar(32) NOT NULL,
	enqReqRej_MIN			decimal(20,4) NOT NULL,
	enqReqRej_MAX			decimal(20,4) NOT NULL,
	enqReqRej_STCNT			varchar(32) NOT NULL,
	enqReqRejRate_MIN			decimal(20,4) NOT NULL,
	enqReqRejRate_MAX			decimal(20,4) NOT NULL,
	enqReqRejRate_STCNT			varchar(32) NOT NULL,
	pctEnqReqRej_MIN			decimal(20,4) NOT NULL,
	pctEnqReqRej_MAX			decimal(20,4) NOT NULL,
	pctEnqReqRej_STCNT			varchar(32) NOT NULL,
	enqErrs_MIN			decimal(20,4) NOT NULL,
	enqErrs_MAX			decimal(20,4) NOT NULL,
	enqErrs_STCNT			varchar(32) NOT NULL,
	enqErrRate_MIN			decimal(20,4) NOT NULL,
	enqErrRate_MAX			decimal(20,4) NOT NULL,
	enqErrRate_STCNT			varchar(32) NOT NULL,
	deqReqs_MIN			decimal(20,4) NOT NULL,
	deqReqs_MAX			decimal(20,4) NOT NULL,
	deqReqs_STCNT			varchar(32) NOT NULL,
	deqReqRate_MIN			decimal(20,4) NOT NULL,
	deqReqRate_MAX			decimal(20,4) NOT NULL,
	deqReqRate_STCNT			varchar(32) NOT NULL,
	deqErrs_MIN			decimal(20,4) NOT NULL,
	deqErrs_MAX			decimal(20,4) NOT NULL,
	deqErrs_STCNT			varchar(32) NOT NULL,
	deqErrRate_MIN			decimal(20,4) NOT NULL,
	deqErrRate_MAX			decimal(20,4) NOT NULL,
	deqErrRate_STCNT			varchar(32) NOT NULL,
	UpdReqRate_MIN			decimal(20,4) NOT NULL,
	UpdReqRate_MAX			decimal(20,4) NOT NULL,
	UpdReqRate_STCNT			varchar(32) NOT NULL,
	lckTblTime_MIN			decimal(20,4) NOT NULL,
	lckTblTime_MAX			decimal(20,4) NOT NULL,
	lckTblTime_STCNT			varchar(32) NOT NULL,
	lckTblWaitTime_MIN			decimal(20,4) NOT NULL,
	lckTblWaitTime_MAX			decimal(20,4) NOT NULL,
	lckTblWaitTime_STCNT			varchar(32) NOT NULL,
	lckSrvTime_MIN			decimal(20,4) NOT NULL,
	lckSrvTime_MAX			decimal(20,4) NOT NULL,
	lckSrvTime_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SAPLocksTest_TREND ADD constraint PK_SAPLocksTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPLocksTest_THRESH;
CREATE TABLE SAPLocksTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	exclusiveLocks_MIN			varchar(256)	 NOT NULL,
	exclusiveLocks_MAX	varchar(256)	 NOT NULL,
	exclNonCumLocks_MIN			varchar(256)	 NOT NULL,
	exclNonCumLocks_MAX	varchar(256)	 NOT NULL,
	otherLocks_MIN			varchar(256)	 NOT NULL,
	otherLocks_MAX	varchar(256)	 NOT NULL,
	allLocks_MIN			varchar(256)	 NOT NULL,
	allLocks_MAX	varchar(256)	 NOT NULL,
	maxLocks_MIN			varchar(256)	 NOT NULL,
	maxLocks_MAX	varchar(256)	 NOT NULL,
	currLockUtil_MIN			varchar(256)	 NOT NULL,
	currLockUtil_MAX	varchar(256)	 NOT NULL,
	highLocks_MIN			varchar(256)	 NOT NULL,
	highLocks_MAX	varchar(256)	 NOT NULL,
	highLockUtil_MIN			varchar(256)	 NOT NULL,
	highLockUtil_MAX	varchar(256)	 NOT NULL,
	currOwners_MIN			varchar(256)	 NOT NULL,
	currOwners_MAX	varchar(256)	 NOT NULL,
	currOwnerUtil_MIN			varchar(256)	 NOT NULL,
	currOwnerUtil_MAX	varchar(256)	 NOT NULL,
	currArgs_MIN			varchar(256)	 NOT NULL,
	currArgs_MAX	varchar(256)	 NOT NULL,
	currArgUtil_MIN			varchar(256)	 NOT NULL,
	currArgUtil_MAX	varchar(256)	 NOT NULL,
	enqReqs_MIN			varchar(256)	 NOT NULL,
	enqReqs_MAX	varchar(256)	 NOT NULL,
	enqReqRate_MIN			varchar(256)	 NOT NULL,
	enqReqRate_MAX	varchar(256)	 NOT NULL,
	enqReqRej_MIN			varchar(256)	 NOT NULL,
	enqReqRej_MAX	varchar(256)	 NOT NULL,
	enqReqRejRate_MIN			varchar(256)	 NOT NULL,
	enqReqRejRate_MAX	varchar(256)	 NOT NULL,
	pctEnqReqRej_MIN			varchar(256)	 NOT NULL,
	pctEnqReqRej_MAX	varchar(256)	 NOT NULL,
	enqErrs_MIN			varchar(256)	 NOT NULL,
	enqErrs_MAX	varchar(256)	 NOT NULL,
	enqErrRate_MIN			varchar(256)	 NOT NULL,
	enqErrRate_MAX	varchar(256)	 NOT NULL,
	deqReqs_MIN			varchar(256)	 NOT NULL,
	deqReqs_MAX	varchar(256)	 NOT NULL,
	deqReqRate_MIN			varchar(256)	 NOT NULL,
	deqReqRate_MAX	varchar(256)	 NOT NULL,
	deqErrs_MIN			varchar(256)	 NOT NULL,
	deqErrs_MAX	varchar(256)	 NOT NULL,
	deqErrRate_MIN			varchar(256)	 NOT NULL,
	deqErrRate_MAX	varchar(256)	 NOT NULL,
	UpdReqRate_MIN			varchar(256)	 NOT NULL,
	UpdReqRate_MAX	varchar(256)	 NOT NULL,
	lckTblTime_MIN			varchar(256)	 NOT NULL,
	lckTblTime_MAX	varchar(256)	 NOT NULL,
	lckTblWaitTime_MIN			varchar(256)	 NOT NULL,
	lckTblWaitTime_MAX	varchar(256)	 NOT NULL,
	lckSrvTime_MIN			varchar(256)	 NOT NULL,
	lckSrvTime_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SAPLocksTest_THRESH ADD constraint PK_SAPLocksTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPLocksTest_THRESH ON SAPLocksTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPLocksTest ON SAPLocksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPLocksTest ON SAPLocksTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SAPICMTest;
CREATE TABLE SAPICMTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO			varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL,
	MSMT_TIME 		datetime NOT NULL,
	RUNTHRD			decimal(20,4) NOT NULL,
	RUNTHRD_ST			varchar(32) NOT NULL,
	IDLTHRD			decimal(20,4) NOT NULL,
	IDLTHRD_ST			varchar(32) NOT NULL,
	USDTHRD			decimal(20,4) NOT NULL,
	USDTHRD_ST			varchar(32) NOT NULL,
	MAXTHRD			decimal(20,4) NOT NULL,
	MAXTHRD_ST			varchar(32) NOT NULL,
	USDTHRDPCT			decimal(20,4) NOT NULL,
	USDTHRDPCT_ST			varchar(32) NOT NULL,
	RUNTHRDPCT			decimal(20,4) NOT NULL,
	RUNTHRDPCT_ST			varchar(32) NOT NULL,
	RUNCRTTHRDPCT			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_ST			varchar(32) NOT NULL,
	USDCONNS			decimal(20,4) NOT NULL,
	USDCONNS_ST			varchar(32) NOT NULL,
	USDCONNSPCT			decimal(20,4) NOT NULL,
	USDCONNSPCT_ST			varchar(32) NOT NULL,
	MAXCONNS			decimal(20,4) NOT NULL,
	MAXCONNS_ST			varchar(32) NOT NULL,
	QUENOW			decimal(20,4) NOT NULL,
	QUENOW_ST			varchar(32) NOT NULL,
	USDQUESPCT			decimal(20,4) NOT NULL,
	USDQUESPCT_ST			varchar(32) NOT NULL,
	MAXQUES			decimal(20,4) NOT NULL,
	MAXQUES_ST			varchar(32) NOT NULL
);
CREATE INDEX IDX_SAPICMTest ON SAPICMTest(MSMT_TIME);
ALTER TABLE SAPICMTest ADD constraint PK_SAPICMTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SAPICMTest_TREND;
CREATE TABLE SAPICMTest_TREND
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	RUNTHRD_MIN			decimal(20,4) NOT NULL,
	RUNTHRD_MAX			decimal(20,4) NOT NULL,
	RUNTHRD_STCNT			varchar(32) NOT NULL,
	IDLTHRD_MIN			decimal(20,4) NOT NULL,
	IDLTHRD_MAX			decimal(20,4) NOT NULL,
	IDLTHRD_STCNT			varchar(32) NOT NULL,
	USDTHRD_MIN			decimal(20,4) NOT NULL,
	USDTHRD_MAX			decimal(20,4) NOT NULL,
	USDTHRD_STCNT			varchar(32) NOT NULL,
	MAXTHRD_MIN			decimal(20,4) NOT NULL,
	MAXTHRD_MAX			decimal(20,4) NOT NULL,
	MAXTHRD_STCNT			varchar(32) NOT NULL,
	USDTHRDPCT_MIN			decimal(20,4) NOT NULL,
	USDTHRDPCT_MAX			decimal(20,4) NOT NULL,
	USDTHRDPCT_STCNT			varchar(32) NOT NULL,
	RUNTHRDPCT_MIN			decimal(20,4) NOT NULL,
	RUNTHRDPCT_MAX			decimal(20,4) NOT NULL,
	RUNTHRDPCT_STCNT			varchar(32) NOT NULL,
	RUNCRTTHRDPCT_MIN			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_MAX			decimal(20,4) NOT NULL,
	RUNCRTTHRDPCT_STCNT			varchar(32) NOT NULL,
	USDCONNS_MIN			decimal(20,4) NOT NULL,
	USDCONNS_MAX			decimal(20,4) NOT NULL,
	USDCONNS_STCNT			varchar(32) NOT NULL,
	USDCONNSPCT_MIN			decimal(20,4) NOT NULL,
	USDCONNSPCT_MAX			decimal(20,4) NOT NULL,
	USDCONNSPCT_STCNT			varchar(32) NOT NULL,
	MAXCONNS_MIN			decimal(20,4) NOT NULL,
	MAXCONNS_MAX			decimal(20,4) NOT NULL,
	MAXCONNS_STCNT			varchar(32) NOT NULL,
	QUENOW_MIN			decimal(20,4) NOT NULL,
	QUENOW_MAX			decimal(20,4) NOT NULL,
	QUENOW_STCNT			varchar(32) NOT NULL,
	USDQUESPCT_MIN			decimal(20,4) NOT NULL,
	USDQUESPCT_MAX			decimal(20,4) NOT NULL,
	USDQUESPCT_STCNT			varchar(32) NOT NULL,
	MAXQUES_MIN			decimal(20,4) NOT NULL,
	MAXQUES_MAX			decimal(20,4) NOT NULL,
	MAXQUES_STCNT			varchar(32) NOT NULL
);
ALTER TABLE SAPICMTest_TREND ADD constraint PK_SAPICMTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SAPICMTest_THRESH;
CREATE TABLE SAPICMTest_THRESH 
(
	TRGT_HOST 			varchar(32)  NOT NULL,
	PORT_NO         		varchar(32)  NOT NULL,
	SITE_NAME        		varchar(64)  NOT NULL,
	INFO            		varchar(128)  NOT NULL,
	MSMT_HOST 			varchar(32)  NOT NULL,
	MSMT_TIME_START			datetime  NOT NULL,
	MSMT_TIME_END   		datetime  NOT NULL,
	RUNTHRD_MIN			varchar(256)	 NOT NULL,
	RUNTHRD_MAX	varchar(256)	 NOT NULL,
	IDLTHRD_MIN			varchar(256)	 NOT NULL,
	IDLTHRD_MAX	varchar(256)	 NOT NULL,
	USDTHRD_MIN			varchar(256)	 NOT NULL,
	USDTHRD_MAX	varchar(256)	 NOT NULL,
	MAXTHRD_MIN			varchar(256)	 NOT NULL,
	MAXTHRD_MAX	varchar(256)	 NOT NULL,
	USDTHRDPCT_MIN			varchar(256)	 NOT NULL,
	USDTHRDPCT_MAX	varchar(256)	 NOT NULL,
	RUNTHRDPCT_MIN			varchar(256)	 NOT NULL,
	RUNTHRDPCT_MAX	varchar(256)	 NOT NULL,
	RUNCRTTHRDPCT_MIN			varchar(256)	 NOT NULL,
	RUNCRTTHRDPCT_MAX	varchar(256)	 NOT NULL,
	USDCONNS_MIN			varchar(256)	 NOT NULL,
	USDCONNS_MAX	varchar(256)	 NOT NULL,
	USDCONNSPCT_MIN			varchar(256)	 NOT NULL,
	USDCONNSPCT_MAX	varchar(256)	 NOT NULL,
	MAXCONNS_MIN			varchar(256)	 NOT NULL,
	MAXCONNS_MAX	varchar(256)	 NOT NULL,
	QUENOW_MIN			varchar(256)	 NOT NULL,
	QUENOW_MAX	varchar(256)	 NOT NULL,
	USDQUESPCT_MIN			varchar(256)	 NOT NULL,
	USDQUESPCT_MAX	varchar(256)	 NOT NULL,
	MAXQUES_MIN			varchar(256)	 NOT NULL,
	MAXQUES_MAX	varchar(256)	 NOT NULL
);
ALTER TABLE SAPICMTest_THRESH ADD constraint PK_SAPICMTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SAPICMTest_THRESH ON SAPICMTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SAPICMTest ON SAPICMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SAPICMTest ON SAPICMTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRCpuUtilTest;
CREATE TABLE HPRCpuUtilTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CPU_UTILIZATION DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar(32) NOT NULL,
MAX_CPU_UTILIZATION DECIMAL(20,4) NOT NULL,
MAX_CPU_UTILIZATION_ST varchar(32) NOT NULL,
AVG_CPU_UTILIZATION DECIMAL(20,4) NOT NULL,
AVG_CPU_UTILIZATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HPRCpuUtilTest ON HPRCpuUtilTest(MSMT_TIME);
ALTER TABLE HPRCpuUtilTest ADD constraint PK_HPRCpuUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRCpuUtilTest_TREND;
CREATE TABLE HPRCpuUtilTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CPU_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar(32) NOT NULL,
MAX_CPU_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
MAX_CPU_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
MAX_CPU_UTILIZATION_STCNT varchar(32) NOT NULL,
AVG_CPU_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
AVG_CPU_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
AVG_CPU_UTILIZATION_STCNT varchar(32) NOT NULL);

ALTER TABLE HPRCpuUtilTest_TREND ADD constraint PK_HPRCpuUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRCpuUtilTest_THRESH;
CREATE TABLE HPRCpuUtilTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CPU_UTILIZATION_MIN VARCHAR(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR(256) NOT NULL,
MAX_CPU_UTILIZATION_MIN VARCHAR(256) NOT NULL,
MAX_CPU_UTILIZATION_MAX VARCHAR(256) NOT NULL,
AVG_CPU_UTILIZATION_MIN VARCHAR(256) NOT NULL,
AVG_CPU_UTILIZATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HPRCpuUtilTest_THRESH ADD constraint PK_HPRCpuUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRCpuUtilTest_THRESH ON HPRCpuUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRCpuUtilTest ON HPRCpuUtilTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRCpuUtilTest ON HPRCpuUtilTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRGlobalStTest;
CREATE TABLE HPRGlobalStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ACTIVE_TUNNELS DECIMAL(20,4) NOT NULL,
ACTIVE_TUNNELS_ST varchar(32) NOT NULL,
RECVD_DATA DECIMAL(20,4) NOT NULL,
RECVD_DATA_ST varchar(32) NOT NULL,
RECVD_PACKET DECIMAL(20,4) NOT NULL,
RECVD_PACKET_ST varchar(32) NOT NULL,
RECVD_DROP_PACKET DECIMAL(20,4) NOT NULL,
RECVD_DROP_PACKET_ST varchar(32) NOT NULL,
TXMTD_DATA DECIMAL(20,4) NOT NULL,
TXMTD_DATA_ST varchar(32) NOT NULL,
TXMTD_PACKET DECIMAL(20,4) NOT NULL,
TXMTD_PACKET_ST varchar(32) NOT NULL,
TXMTD_DROP_PACKET DECIMAL(20,4) NOT NULL,
TXMTD_DROP_PACKET_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HPRGlobalStTest ON HPRGlobalStTest(MSMT_TIME);
ALTER TABLE HPRGlobalStTest ADD constraint PK_HPRGlobalStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRGlobalStTest_TREND;
CREATE TABLE HPRGlobalStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ACTIVE_TUNNELS_MIN DECIMAL(20,4) NOT NULL,
ACTIVE_TUNNELS_MAX DECIMAL(20,4) NOT NULL,
ACTIVE_TUNNELS_STCNT varchar(32) NOT NULL,
RECVD_DATA_MIN DECIMAL(20,4) NOT NULL,
RECVD_DATA_MAX DECIMAL(20,4) NOT NULL,
RECVD_DATA_STCNT varchar(32) NOT NULL,
RECVD_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECVD_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECVD_PACKET_STCNT varchar(32) NOT NULL,
RECVD_DROP_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECVD_DROP_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECVD_DROP_PACKET_STCNT varchar(32) NOT NULL,
TXMTD_DATA_MIN DECIMAL(20,4) NOT NULL,
TXMTD_DATA_MAX DECIMAL(20,4) NOT NULL,
TXMTD_DATA_STCNT varchar(32) NOT NULL,
TXMTD_PACKET_MIN DECIMAL(20,4) NOT NULL,
TXMTD_PACKET_MAX DECIMAL(20,4) NOT NULL,
TXMTD_PACKET_STCNT varchar(32) NOT NULL,
TXMTD_DROP_PACKET_MIN DECIMAL(20,4) NOT NULL,
TXMTD_DROP_PACKET_MAX DECIMAL(20,4) NOT NULL,
TXMTD_DROP_PACKET_STCNT varchar(32) NOT NULL);

ALTER TABLE HPRGlobalStTest_TREND ADD constraint PK_HPRGlobalStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRGlobalStTest_THRESH;
CREATE TABLE HPRGlobalStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ACTIVE_TUNNELS_MIN VARCHAR(256) NOT NULL,
ACTIVE_TUNNELS_MAX VARCHAR(256) NOT NULL,
RECVD_DATA_MIN VARCHAR(256) NOT NULL,
RECVD_DATA_MAX VARCHAR(256) NOT NULL,
RECVD_PACKET_MIN VARCHAR(256) NOT NULL,
RECVD_PACKET_MAX VARCHAR(256) NOT NULL,
RECVD_DROP_PACKET_MIN VARCHAR(256) NOT NULL,
RECVD_DROP_PACKET_MAX VARCHAR(256) NOT NULL,
TXMTD_DATA_MIN VARCHAR(256) NOT NULL,
TXMTD_DATA_MAX VARCHAR(256) NOT NULL,
TXMTD_PACKET_MIN VARCHAR(256) NOT NULL,
TXMTD_PACKET_MAX VARCHAR(256) NOT NULL,
TXMTD_DROP_PACKET_MIN VARCHAR(256) NOT NULL,
TXMTD_DROP_PACKET_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HPRGlobalStTest_THRESH ADD constraint PK_HPRGlobalStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRGlobalStTest_THRESH ON HPRGlobalStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRGlobalStTest ON HPRGlobalStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRGlobalStTest ON HPRGlobalStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRMemUtilTest;
CREATE TABLE HPRMemUtilTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MEMORY DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar(32) NOT NULL,
MEM_UTILIZED DECIMAL(20,4) NOT NULL,
MEM_UTILIZED_ST varchar(32) NOT NULL,
FREE_MEMORY DECIMAL(20,4) NOT NULL,
FREE_MEMORY_ST varchar(32) NOT NULL,
MEM_UTILIZATION DECIMAL(20,4) NOT NULL,
MEM_UTILIZATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HPRMemUtilTest ON HPRMemUtilTest(MSMT_TIME);
ALTER TABLE HPRMemUtilTest ADD constraint PK_HPRMemUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRMemUtilTest_TREND;
CREATE TABLE HPRMemUtilTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MEMORY_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar(32) NOT NULL,
MEM_UTILIZED_MIN DECIMAL(20,4) NOT NULL,
MEM_UTILIZED_MAX DECIMAL(20,4) NOT NULL,
MEM_UTILIZED_STCNT varchar(32) NOT NULL,
FREE_MEMORY_MIN DECIMAL(20,4) NOT NULL,
FREE_MEMORY_MAX DECIMAL(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar(32) NOT NULL,
MEM_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
MEM_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
MEM_UTILIZATION_STCNT varchar(32) NOT NULL);

ALTER TABLE HPRMemUtilTest_TREND ADD constraint PK_HPRMemUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRMemUtilTest_THRESH;
CREATE TABLE HPRMemUtilTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MEMORY_MIN VARCHAR(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR(256) NOT NULL,
MEM_UTILIZED_MIN VARCHAR(256) NOT NULL,
MEM_UTILIZED_MAX VARCHAR(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR(256) NOT NULL,
MEM_UTILIZATION_MIN VARCHAR(256) NOT NULL,
MEM_UTILIZATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HPRMemUtilTest_THRESH ADD constraint PK_HPRMemUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRMemUtilTest_THRESH ON HPRMemUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRMemUtilTest ON HPRMemUtilTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRMemUtilTest ON HPRMemUtilTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRPwrSupplyTest;
CREATE TABLE HPRPwrSupplyTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NOMINAL_POWER DECIMAL(20,4) NOT NULL,
NOMINAL_POWER_ST varchar(32) NOT NULL,
CURRENT_POWER DECIMAL(20,4) NOT NULL,
CURRENT_POWER_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HPRPwrSupplyTest ON HPRPwrSupplyTest(MSMT_TIME);
ALTER TABLE HPRPwrSupplyTest ADD constraint PK_HPRPwrSupplyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRPwrSupplyTest_TREND;
CREATE TABLE HPRPwrSupplyTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NOMINAL_POWER_MIN DECIMAL(20,4) NOT NULL,
NOMINAL_POWER_MAX DECIMAL(20,4) NOT NULL,
NOMINAL_POWER_STCNT varchar(32) NOT NULL,
CURRENT_POWER_MIN DECIMAL(20,4) NOT NULL,
CURRENT_POWER_MAX DECIMAL(20,4) NOT NULL,
CURRENT_POWER_STCNT varchar(32) NOT NULL);

ALTER TABLE HPRPwrSupplyTest_TREND ADD constraint PK_HPRPwrSupplyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRPwrSupplyTest_THRESH;
CREATE TABLE HPRPwrSupplyTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NOMINAL_POWER_MIN VARCHAR(256) NOT NULL,
NOMINAL_POWER_MAX VARCHAR(256) NOT NULL,
CURRENT_POWER_MIN VARCHAR(256) NOT NULL,
CURRENT_POWER_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HPRPwrSupplyTest_THRESH ADD constraint PK_HPRPwrSupplyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRPwrSupplyTest_THRESH ON HPRPwrSupplyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRPwrSupplyTest ON HPRPwrSupplyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRPwrSupplyTest ON HPRPwrSupplyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HPRVoltageTest;
CREATE TABLE HPRVoltageTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
INPUT_VOLTAGE DECIMAL(20,4) NOT NULL,
INPUT_VOLTAGE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_HPRVoltageTest ON HPRVoltageTest(MSMT_TIME);
ALTER TABLE HPRVoltageTest ADD constraint PK_HPRVoltageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HPRVoltageTest_TREND;
CREATE TABLE HPRVoltageTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
INPUT_VOLTAGE_MIN DECIMAL(20,4) NOT NULL,
INPUT_VOLTAGE_MAX DECIMAL(20,4) NOT NULL,
INPUT_VOLTAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE HPRVoltageTest_TREND ADD constraint PK_HPRVoltageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HPRVoltageTest_THRESH;
CREATE TABLE HPRVoltageTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
INPUT_VOLTAGE_MIN VARCHAR(256) NOT NULL,
INPUT_VOLTAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE HPRVoltageTest_THRESH ADD constraint PK_HPRVoltageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HPRVoltageTest_THRESH ON HPRVoltageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HPRVoltageTest ON HPRVoltageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HPRVoltageTest ON HPRVoltageTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RZDCPUMgtTest;
CREATE TABLE RZDCPUMgtTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CPU_UTIL DECIMAL(20,4) NOT NULL,
CPU_UTIL_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDCPUMgtTest ON RZDCPUMgtTest(MSMT_TIME);
ALTER TABLE RZDCPUMgtTest ADD constraint PK_RZDCPUMgtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDCPUMgtTest_TREND;
CREATE TABLE RZDCPUMgtTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CPU_UTIL_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDCPUMgtTest_TREND ADD constraint PK_RZDCPUMgtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDCPUMgtTest_THRESH;
CREATE TABLE RZDCPUMgtTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CPU_UTIL_MIN VARCHAR(256) NOT NULL,
CPU_UTIL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDCPUMgtTest_THRESH ADD constraint PK_RZDCPUMgtTest_ex_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDCPUMgtTest_THRESH ON RZDCPUMgtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDCPUMgtTest ON RZDCPUMgtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDCPUMgtTest ON RZDCPUMgtTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDMemoryTest;
CREATE TABLE RZDMemoryTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MEMORY DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar(32) NOT NULL,
USED_MEMORY DECIMAL(20,4) NOT NULL,
USED_MEMORY_ST varchar(32) NOT NULL,
AVAILABLE_MEMORY DECIMAL(20,4) NOT NULL,
AVAILABLE_MEMORY_ST varchar(32) NOT NULL,
MEMORY_UTIL DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDMemoryTest ON RZDMemoryTest(MSMT_TIME);
ALTER TABLE RZDMemoryTest ADD constraint PK_RZDMemoryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDMemoryTest_TREND;
CREATE TABLE RZDMemoryTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MEMORY_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar(32) NOT NULL,
USED_MEMORY_MIN DECIMAL(20,4) NOT NULL,
USED_MEMORY_MAX DECIMAL(20,4) NOT NULL,
USED_MEMORY_STCNT varchar(32) NOT NULL,
AVAILABLE_MEMORY_MIN DECIMAL(20,4) NOT NULL,
AVAILABLE_MEMORY_MAX DECIMAL(20,4) NOT NULL,
AVAILABLE_MEMORY_STCNT varchar(32) NOT NULL,
MEMORY_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDMemoryTest_TREND ADD constraint PK_RZDMemoryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDMemoryTest_THRESH;
CREATE TABLE RZDMemoryTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MEMORY_MIN VARCHAR(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR(256) NOT NULL,
USED_MEMORY_MIN VARCHAR(256) NOT NULL,
USED_MEMORY_MAX VARCHAR(256) NOT NULL,
AVAILABLE_MEMORY_MIN VARCHAR(256) NOT NULL,
AVAILABLE_MEMORY_MAX VARCHAR(256) NOT NULL,
MEMORY_UTIL_MIN VARCHAR(256) NOT NULL,
MEMORY_UTIL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDMemoryTest_THRESH ADD constraint PK_RZDMemoryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDMemoryTest_THRESH ON RZDMemoryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDMemoryTest ON RZDMemoryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDMemoryTest ON RZDMemoryTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE RZDUpTimeTest;
CREATE TABLE RZDUpTimeTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
REBOOT DECIMAL(20,4) NOT NULL,
REBOOT_ST varchar(32) NOT NULL,
UPTIME DECIMAL(20,4) NOT NULL,
UPTIME_ST varchar(32) NOT NULL,
TOTAL_UPTIME DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDUpTimeTest ON RZDUpTimeTest(MSMT_TIME);
ALTER TABLE RZDUpTimeTest ADD constraint PK_RZDUpTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDUpTimeTest_TREND;
CREATE TABLE RZDUpTimeTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
REBOOT_MIN DECIMAL(20,4) NOT NULL,
REBOOT_MAX DECIMAL(20,4) NOT NULL,
REBOOT_STCNT varchar(32) NOT NULL,
UPTIME_MIN DECIMAL(20,4) NOT NULL,
UPTIME_MAX DECIMAL(20,4) NOT NULL,
UPTIME_STCNT varchar(32) NOT NULL,
TOTAL_UPTIME_MIN DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_MAX DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDUpTimeTest_TREND ADD constraint PK_RZDUpTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDUpTimeTest_THRESH;
CREATE TABLE RZDUpTimeTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
REBOOT_MIN VARCHAR(256) NOT NULL,
REBOOT_MAX VARCHAR(256) NOT NULL,
UPTIME_MIN VARCHAR(256) NOT NULL,
UPTIME_MAX VARCHAR(256) NOT NULL,
TOTAL_UPTIME_MIN VARCHAR(256) NOT NULL,
TOTAL_UPTIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDUpTimeTest_THRESH ADD constraint PK_RZDUpTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDUpTimeTest_THRESH ON RZDUpTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDUpTimeTest ON RZDUpTimeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDUpTimeTest ON RZDUpTimeTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RZDEthernetTest;
CREATE TABLE RZDEthernetTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ETHERNET_STATUS DECIMAL(20,4) NOT NULL,
ETHERNET_STATUS_ST varchar(32) NOT NULL,
TRANSMIT_PKT DECIMAL(20,4) NOT NULL,
TRANSMIT_PKT_ST varchar(32) NOT NULL,
RECEIVED_PKT DECIMAL(20,4) NOT NULL,
RECEIVED_PKT_ST varchar(32) NOT NULL,
TRANSMIT_DATA DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_ST varchar(32) NOT NULL,
RECEIVED_DATA DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ST varchar(32) NOT NULL,
TRANSMIT_DROP_PKT DECIMAL(20,4) NOT NULL,
TRANSMIT_DROP_PKT_ST varchar(32) NOT NULL,
RECEIVED_DROP_PKT DECIMAL(20,4) NOT NULL,
RECEIVED_DROP_PKT_ST varchar(32) NOT NULL,
ETHER_UTIL DECIMAL(20,4) NOT NULL,
ETHER_UTIL_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDEthernetTest ON RZDEthernetTest(MSMT_TIME);
ALTER TABLE RZDEthernetTest ADD constraint PK_RZDEthernetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDEthernetTest_TREND;
CREATE TABLE RZDEthernetTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ETHERNET_STATUS_MIN DECIMAL(20,4) NOT NULL,
ETHERNET_STATUS_MAX DECIMAL(20,4) NOT NULL,
ETHERNET_STATUS_STCNT varchar(32) NOT NULL,
TRANSMIT_PKT_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_PKT_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_PKT_STCNT varchar(32) NOT NULL,
RECEIVED_PKT_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_PKT_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_PKT_STCNT varchar(32) NOT NULL,
TRANSMIT_DATA_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_STCNT varchar(32) NOT NULL,
RECEIVED_DATA_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar(32) NOT NULL,
TRANSMIT_DROP_PKT_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_DROP_PKT_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_DROP_PKT_STCNT varchar(32) NOT NULL,
RECEIVED_DROP_PKT_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DROP_PKT_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DROP_PKT_STCNT varchar(32) NOT NULL,
ETHER_UTIL_MIN DECIMAL(20,4) NOT NULL,
ETHER_UTIL_MAX DECIMAL(20,4) NOT NULL,
ETHER_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDEthernetTest_TREND ADD constraint PK_RZDEthernetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDEthernetTest_THRESH;
CREATE TABLE RZDEthernetTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ETHERNET_STATUS_MIN VARCHAR(256) NOT NULL,
ETHERNET_STATUS_MAX VARCHAR(256) NOT NULL,
TRANSMIT_PKT_MIN VARCHAR(256) NOT NULL,
TRANSMIT_PKT_MAX VARCHAR(256) NOT NULL,
RECEIVED_PKT_MIN VARCHAR(256) NOT NULL,
RECEIVED_PKT_MAX VARCHAR(256) NOT NULL,
TRANSMIT_DATA_MIN VARCHAR(256) NOT NULL,
TRANSMIT_DATA_MAX VARCHAR(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR(256) NOT NULL,
TRANSMIT_DROP_PKT_MIN VARCHAR(256) NOT NULL,
TRANSMIT_DROP_PKT_MAX VARCHAR(256) NOT NULL,
RECEIVED_DROP_PKT_MIN VARCHAR(256) NOT NULL,
RECEIVED_DROP_PKT_MAX VARCHAR(256) NOT NULL,
ETHER_UTIL_MIN VARCHAR(256) NOT NULL,
ETHER_UTIL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDEthernetTest_THRESH ADD constraint PK_RZDEthernetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDEthernetTest_THRESH ON RZDEthernetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDEthernetTest ON RZDEthernetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDEthernetTest ON RZDEthernetTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDSysDetailTest;
CREATE TABLE RZDSysDetailTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CPU_UTILIZATION DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar(32) NOT NULL,
MEMORY_UTILIZATION DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDSysDetailTest ON RZDSysDetailTest(MSMT_TIME);
ALTER TABLE RZDSysDetailTest ADD constraint PK_RZDSysDetailTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDSysDetailTest_TREND;
CREATE TABLE RZDSysDetailTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CPU_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar(32) NOT NULL,
MEMORY_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDSysDetailTest_TREND ADD constraint PK_RZDSysDetailTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDSysDetailTest_THRESH;
CREATE TABLE RZDSysDetailTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CPU_UTILIZATION_MIN VARCHAR(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDSysDetailTest_THRESH ADD constraint PK_RZDSysDetailTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDSysDetailTest_THRESH ON RZDSysDetailTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDSysDetailTest ON RZDSysDetailTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDSysDetailTest ON RZDSysDetailTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDDevInfoTest;
CREATE TABLE RZDDevInfoTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_ACCESSPOINT DECIMAL(20,4) NOT NULL,
TOTAL_ACCESSPOINT_ST varchar(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_ST varchar(32) NOT NULL,
TOTAL_ROGUE_DEVICE DECIMAL(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDDevInfoTest ON RZDDevInfoTest(MSMT_TIME);
ALTER TABLE RZDDevInfoTest ADD constraint PK_RZDDevInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDDevInfoTest_TREND;
CREATE TABLE RZDDevInfoTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_ACCESSPOINT_MIN DECIMAL(20,4) NOT NULL,
TOTAL_ACCESSPOINT_MAX DECIMAL(20,4) NOT NULL,
TOTAL_ACCESSPOINT_STCNT varchar(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_STCNT varchar(32) NOT NULL,
TOTAL_ROGUE_DEVICE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_ROGUE_DEVICE_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDDevInfoTest_TREND ADD constraint PK_RZDDevInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDDevInfoTest_THRESH;
CREATE TABLE RZDDevInfoTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_ACCESSPOINT_MIN VARCHAR(256) NOT NULL,
TOTAL_ACCESSPOINT_MAX VARCHAR(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN VARCHAR(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX VARCHAR(256) NOT NULL,
TOTAL_ROGUE_DEVICE_MIN VARCHAR(256) NOT NULL,
TOTAL_ROGUE_DEVICE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDDevInfoTest_THRESH ADD constraint PK_RZDDevInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDDevInfoTest_THRESH ON RZDDevInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDDevInfoTest ON RZDDevInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDDevInfoTest ON RZDDevInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDDetailStatTest;
CREATE TABLE RZDDetailStatTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TRANSMIITED_PACKETS DECIMAL(20,4) NOT NULL,
TRANSMIITED_PACKETS_ST varchar(32) NOT NULL,
RECEIVED_PACKETS DECIMAL(20,4) NOT NULL,
RECEIVED_PACKETS_ST varchar(32) NOT NULL,
DATA_TRANSMITTED DECIMAL(20,4) NOT NULL,
DATA_TRANSMITTED_ST varchar(32) NOT NULL,
DATA_RECEIVED DECIMAL(20,4) NOT NULL,
DATA_RECEIVED_ST varchar(32) NOT NULL,
TRANSMITTED_FAIL_PACKETS DECIMAL(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_ST varchar(32) NOT NULL,
TRANSMITTED_RETRY_PACKET DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_ST varchar(32) NOT NULL,
MCAST_PACKET_TRANSMITTED DECIMAL(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_ST varchar(32) NOT NULL,
MCAST_PACKET_RECEIVED DECIMAL(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDDetailStatTest ON RZDDetailStatTest(MSMT_TIME);
ALTER TABLE RZDDetailStatTest ADD constraint PK_RZDDetailStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDDetailStatTest_TREND;
CREATE TABLE RZDDetailStatTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TRANSMIITED_PACKETS_MIN DECIMAL(20,4) NOT NULL,
TRANSMIITED_PACKETS_MAX DECIMAL(20,4) NOT NULL,
TRANSMIITED_PACKETS_STCNT varchar(32) NOT NULL,
RECEIVED_PACKETS_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_PACKETS_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_PACKETS_STCNT varchar(32) NOT NULL,
DATA_TRANSMITTED_MIN DECIMAL(20,4) NOT NULL,
DATA_TRANSMITTED_MAX DECIMAL(20,4) NOT NULL,
DATA_TRANSMITTED_STCNT varchar(32) NOT NULL,
DATA_RECEIVED_MIN DECIMAL(20,4) NOT NULL,
DATA_RECEIVED_MAX DECIMAL(20,4) NOT NULL,
DATA_RECEIVED_STCNT varchar(32) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_FAIL_PACKETS_STCNT varchar(32) NOT NULL,
TRANSMITTED_RETRY_PACKET_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRY_PACKET_STCNT varchar(32) NOT NULL,
MCAST_PACKET_TRANSMITTED_MIN DECIMAL(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_MAX DECIMAL(20,4) NOT NULL,
MCAST_PACKET_TRANSMITTED_STCNT varchar(32) NOT NULL,
MCAST_PACKET_RECEIVED_MIN DECIMAL(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_MAX DECIMAL(20,4) NOT NULL,
MCAST_PACKET_RECEIVED_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDDetailStatTest_TREND ADD constraint PK_RZDDetailStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDDetailStatTest_THRESH;
CREATE TABLE RZDDetailStatTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TRANSMIITED_PACKETS_MIN VARCHAR(256) NOT NULL,
TRANSMIITED_PACKETS_MAX VARCHAR(256) NOT NULL,
RECEIVED_PACKETS_MIN VARCHAR(256) NOT NULL,
RECEIVED_PACKETS_MAX VARCHAR(256) NOT NULL,
DATA_TRANSMITTED_MIN VARCHAR(256) NOT NULL,
DATA_TRANSMITTED_MAX VARCHAR(256) NOT NULL,
DATA_RECEIVED_MIN VARCHAR(256) NOT NULL,
DATA_RECEIVED_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_FAIL_PACKETS_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_RETRY_PACKET_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_RETRY_PACKET_MAX VARCHAR(256) NOT NULL,
MCAST_PACKET_TRANSMITTED_MIN VARCHAR(256) NOT NULL,
MCAST_PACKET_TRANSMITTED_MAX VARCHAR(256) NOT NULL,
MCAST_PACKET_RECEIVED_MIN VARCHAR(256) NOT NULL,
MCAST_PACKET_RECEIVED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDDetailStatTest_THRESH ADD constraint PK_RZDDetailStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDDetailStatTest_THRESH ON RZDDetailStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDDetailStatTest ON RZDDetailStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDDetailStatTest ON RZDDetailStatTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDRogueInfoTest;
CREATE TABLE RZDRogueInfoTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
RADIO_TYPE DECIMAL(20,4) NOT NULL,
RADIO_TYPE_ST varchar(32) NOT NULL,
CHANNEL DECIMAL(20,4) NOT NULL,
CHANNEL_ST varchar(32) NOT NULL,
ROGUE_TYPE DECIMAL(20,4) NOT NULL,
ROGUE_TYPE_ST varchar(32) NOT NULL,
ENCRYPTION_MODE DECIMAL(20,4) NOT NULL,
ENCRYPTION_MODE_ST varchar(32) NOT NULL,
SIGNAL_STRENGTH DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDRogueInfoTest ON RZDRogueInfoTest(MSMT_TIME);
ALTER TABLE RZDRogueInfoTest ADD constraint PK_RZDRogueInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDRogueInfoTest_TREND;
CREATE TABLE RZDRogueInfoTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RADIO_TYPE_MIN DECIMAL(20,4) NOT NULL,
RADIO_TYPE_MAX DECIMAL(20,4) NOT NULL,
RADIO_TYPE_STCNT varchar(32) NOT NULL,
CHANNEL_MIN DECIMAL(20,4) NOT NULL,
CHANNEL_MAX DECIMAL(20,4) NOT NULL,
CHANNEL_STCNT varchar(32) NOT NULL,
ROGUE_TYPE_MIN DECIMAL(20,4) NOT NULL,
ROGUE_TYPE_MAX DECIMAL(20,4) NOT NULL,
ROGUE_TYPE_STCNT varchar(32) NOT NULL,
ENCRYPTION_MODE_MIN DECIMAL(20,4) NOT NULL,
ENCRYPTION_MODE_MAX DECIMAL(20,4) NOT NULL,
ENCRYPTION_MODE_STCNT varchar(32) NOT NULL,
SIGNAL_STRENGTH_MIN DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_MAX DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDRogueInfoTest_TREND ADD constraint PK_RZDRogueInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDRogueInfoTest_THRESH;
CREATE TABLE RZDRogueInfoTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RADIO_TYPE_MIN VARCHAR(256) NOT NULL,
RADIO_TYPE_MAX VARCHAR(256) NOT NULL,
CHANNEL_MIN VARCHAR(256) NOT NULL,
CHANNEL_MAX VARCHAR(256) NOT NULL,
ROGUE_TYPE_MIN VARCHAR(256) NOT NULL,
ROGUE_TYPE_MAX VARCHAR(256) NOT NULL,
ENCRYPTION_MODE_MIN VARCHAR(256) NOT NULL,
ENCRYPTION_MODE_MAX VARCHAR(256) NOT NULL,
SIGNAL_STRENGTH_MIN VARCHAR(256) NOT NULL,
SIGNAL_STRENGTH_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDRogueInfoTest_THRESH ADD constraint PK_RZDRogueInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDRogueInfoTest_THRESH ON RZDRogueInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDRogueInfoTest ON RZDRogueInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDRogueInfoTest ON RZDRogueInfoTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDWLANInfoTest;
CREATE TABLE RZDWLANInfoTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AUTHORIZED_CLIENT_DEVICE DECIMAL(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_ST varchar(32) NOT NULL,
TRANSMITTED_DATA DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_ST varchar(32) NOT NULL,
RECEIVED_DATA DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ST varchar(32) NOT NULL,
TRANSMITTED_PACKET DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_ST varchar(32) NOT NULL,
RECEIVED_PACKET DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_ST varchar(32) NOT NULL,
TRANSMITTED_DATA_LAN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_ST varchar(32) NOT NULL,
RECEIVED_DATA_LAN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_LAN_ST varchar(32) NOT NULL,
TOTAL_AUTHENTICATION DECIMAL(20,4) NOT NULL,
TOTAL_AUTHENTICATION_ST varchar(32) NOT NULL,
SUCCESS_AUTHENTICATION DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_ST varchar(32) NOT NULL,
FAILED_AUTHENTICATION DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_ST varchar(32) NOT NULL,
SUCCESS_AUTHEN_PERCENT DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDWLANInfoTest ON RZDWLANInfoTest(MSMT_TIME);
ALTER TABLE RZDWLANInfoTest ADD constraint PK_RZDWLANInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDWLANInfoTest_TREND;
CREATE TABLE RZDWLANInfoTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MIN DECIMAL(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MAX DECIMAL(20,4) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_STCNT varchar(32) NOT NULL,
TRANSMITTED_DATA_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_STCNT varchar(32) NOT NULL,
RECEIVED_DATA_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar(32) NOT NULL,
TRANSMITTED_PACKET_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_STCNT varchar(32) NOT NULL,
RECEIVED_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_STCNT varchar(32) NOT NULL,
TRANSMITTED_DATA_LAN_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_LAN_STCNT varchar(32) NOT NULL,
RECEIVED_DATA_LAN_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_LAN_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_LAN_STCNT varchar(32) NOT NULL,
TOTAL_AUTHENTICATION_MIN DECIMAL(20,4) NOT NULL,
TOTAL_AUTHENTICATION_MAX DECIMAL(20,4) NOT NULL,
TOTAL_AUTHENTICATION_STCNT varchar(32) NOT NULL,
SUCCESS_AUTHENTICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_STCNT varchar(32) NOT NULL,
FAILED_AUTHENTICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_STCNT varchar(32) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHEN_PERCENT_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDWLANInfoTest_TREND ADD constraint PK_RZDWLANInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDWLANInfoTest_THRESH;
CREATE TABLE RZDWLANInfoTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MIN VARCHAR(256) NOT NULL,
AUTHORIZED_CLIENT_DEVICE_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_MAX VARCHAR(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_MAX VARCHAR(256) NOT NULL,
RECEIVED_PACKET_MIN VARCHAR(256) NOT NULL,
RECEIVED_PACKET_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_LAN_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_LAN_MAX VARCHAR(256) NOT NULL,
RECEIVED_DATA_LAN_MIN VARCHAR(256) NOT NULL,
RECEIVED_DATA_LAN_MAX VARCHAR(256) NOT NULL,
TOTAL_AUTHENTICATION_MIN VARCHAR(256) NOT NULL,
TOTAL_AUTHENTICATION_MAX VARCHAR(256) NOT NULL,
SUCCESS_AUTHENTICATION_MIN VARCHAR(256) NOT NULL,
SUCCESS_AUTHENTICATION_MAX VARCHAR(256) NOT NULL,
FAILED_AUTHENTICATION_MIN VARCHAR(256) NOT NULL,
FAILED_AUTHENTICATION_MAX VARCHAR(256) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MIN VARCHAR(256) NOT NULL,
SUCCESS_AUTHEN_PERCENT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDWLANInfoTest_THRESH ADD constraint PK_RZDWLANInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDWLANInfoTest_THRESH ON RZDWLANInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDWLANInfoTest ON RZDWLANInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDWLANInfoTest ON RZDWLANInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDUserInfoTest;
CREATE TABLE RZDUserInfoTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
RADIO_TYPE DECIMAL(20,4) NOT NULL,
RADIO_TYPE_ST varchar(32) NOT NULL,
TRANSMITTED_PACKET DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_ST varchar(32) NOT NULL,
RECEIVED_PACKET DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_ST varchar(32) NOT NULL,
TRANSMITTED_DATA DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_ST varchar(32) NOT NULL,
RECEIVED_DATA DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ST varchar(32) NOT NULL,
TRANSMITTED_DROPPKT DECIMAL(20,4) NOT NULL,
TRANSMITTED_DROPPKT_ST varchar(32) NOT NULL,
RECEIVED_DROPPKT DECIMAL(20,4) NOT NULL,
RECEIVED_DROPPKT_ST varchar(32) NOT NULL,
TRANSMITTED_ERRORPKT DECIMAL(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_ST varchar(32) NOT NULL,
RECEIVED_ERRORPKT DECIMAL(20,4) NOT NULL,
RECEIVED_ERRORPKT_ST varchar(32) NOT NULL,
TRANSMITTED_RETRIES DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRIES_ST varchar(32) NOT NULL,
TRANSMITTED_RETRYDATA DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_ST varchar(32) NOT NULL,
SIGNALNOISE_RATIO DECIMAL(20,4) NOT NULL,
SIGNALNOISE_RATIO_ST varchar(32) NOT NULL,
SIGNAL_STRENGTH DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDUserInfoTest ON RZDUserInfoTest(MSMT_TIME);
ALTER TABLE RZDUserInfoTest ADD constraint PK_RZDUserInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDUserInfoTest_TREND;
CREATE TABLE RZDUserInfoTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RADIO_TYPE_MIN DECIMAL(20,4) NOT NULL,
RADIO_TYPE_MAX DECIMAL(20,4) NOT NULL,
RADIO_TYPE_STCNT varchar(32) NOT NULL,
TRANSMITTED_PACKET_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_STCNT varchar(32) NOT NULL,
RECEIVED_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_STCNT varchar(32) NOT NULL,
TRANSMITTED_DATA_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_STCNT varchar(32) NOT NULL,
RECEIVED_DATA_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_STCNT varchar(32) NOT NULL,
TRANSMITTED_DROPPKT_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DROPPKT_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_DROPPKT_STCNT varchar(32) NOT NULL,
RECEIVED_DROPPKT_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DROPPKT_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DROPPKT_STCNT varchar(32) NOT NULL,
TRANSMITTED_ERRORPKT_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_ERRORPKT_STCNT varchar(32) NOT NULL,
RECEIVED_ERRORPKT_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_ERRORPKT_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_ERRORPKT_STCNT varchar(32) NOT NULL,
TRANSMITTED_RETRIES_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRIES_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRIES_STCNT varchar(32) NOT NULL,
TRANSMITTED_RETRYDATA_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_RETRYDATA_STCNT varchar(32) NOT NULL,
SIGNALNOISE_RATIO_MIN DECIMAL(20,4) NOT NULL,
SIGNALNOISE_RATIO_MAX DECIMAL(20,4) NOT NULL,
SIGNALNOISE_RATIO_STCNT varchar(32) NOT NULL,
SIGNAL_STRENGTH_MIN DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_MAX DECIMAL(20,4) NOT NULL,
SIGNAL_STRENGTH_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDUserInfoTest_TREND ADD constraint PK_RZDUserInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDUserInfoTest_THRESH;
CREATE TABLE RZDUserInfoTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RADIO_TYPE_MIN VARCHAR(256) NOT NULL,
RADIO_TYPE_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_MAX VARCHAR(256) NOT NULL,
RECEIVED_PACKET_MIN VARCHAR(256) NOT NULL,
RECEIVED_PACKET_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_MAX VARCHAR(256) NOT NULL,
RECEIVED_DATA_MIN VARCHAR(256) NOT NULL,
RECEIVED_DATA_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_DROPPKT_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_DROPPKT_MAX VARCHAR(256) NOT NULL,
RECEIVED_DROPPKT_MIN VARCHAR(256) NOT NULL,
RECEIVED_DROPPKT_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_ERRORPKT_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_ERRORPKT_MAX VARCHAR(256) NOT NULL,
RECEIVED_ERRORPKT_MIN VARCHAR(256) NOT NULL,
RECEIVED_ERRORPKT_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_RETRIES_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_RETRIES_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_RETRYDATA_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_RETRYDATA_MAX VARCHAR(256) NOT NULL,
SIGNALNOISE_RATIO_MIN VARCHAR(256) NOT NULL,
SIGNALNOISE_RATIO_MAX VARCHAR(256) NOT NULL,
SIGNAL_STRENGTH_MIN VARCHAR(256) NOT NULL,
SIGNAL_STRENGTH_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDUserInfoTest_THRESH ADD constraint PK_RZDUserInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDUserInfoTest_THRESH ON RZDUserInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDUserInfoTest ON RZDUserInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDUserInfoTest ON RZDUserInfoTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE RZDApUpTimeTest;
CREATE TABLE RZDApUpTimeTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
REBOOT DECIMAL(20,4) NOT NULL,
REBOOT_ST varchar(32) NOT NULL,
UPTIME DECIMAL(20,4) NOT NULL,
UPTIME_ST varchar(32) NOT NULL,
TOTAL_UPTIME DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDApUpTimeTest ON RZDApUpTimeTest(MSMT_TIME);
ALTER TABLE RZDApUpTimeTest ADD constraint PK_RZDApUpTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApUpTimeTest_TREND;
CREATE TABLE RZDApUpTimeTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
REBOOT_MIN DECIMAL(20,4) NOT NULL,
REBOOT_MAX DECIMAL(20,4) NOT NULL,
REBOOT_STCNT varchar(32) NOT NULL,
UPTIME_MIN DECIMAL(20,4) NOT NULL,
UPTIME_MAX DECIMAL(20,4) NOT NULL,
UPTIME_STCNT varchar(32) NOT NULL,
TOTAL_UPTIME_MIN DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_MAX DECIMAL(20,4) NOT NULL,
TOTAL_UPTIME_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDApUpTimeTest_TREND ADD constraint PK_RZDApUpTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApUpTimeTest_THRESH;
CREATE TABLE RZDApUpTimeTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
REBOOT_MIN VARCHAR(256) NOT NULL,
REBOOT_MAX VARCHAR(256) NOT NULL,
UPTIME_MIN VARCHAR(256) NOT NULL,
UPTIME_MAX VARCHAR(256) NOT NULL,
TOTAL_UPTIME_MIN VARCHAR(256) NOT NULL,
TOTAL_UPTIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDApUpTimeTest_THRESH ADD constraint PK_RZDApUpTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApUpTimeTest_THRESH ON RZDApUpTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApUpTimeTest ON RZDApUpTimeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApUpTimeTest ON RZDApUpTimeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDApInfoTest;
CREATE TABLE RZDApInfoTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_RADIO DECIMAL(20,4) NOT NULL,
TOTAL_RADIO_ST varchar(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_ST varchar(32) NOT NULL,
AP_STATUS DECIMAL(20,4) NOT NULL,
AP_STATUS_ST varchar(32) NOT NULL,
CPU_UTILIZATION DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_ST varchar(32) NOT NULL,
MEMORY_UTILIZATION DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_ST varchar(32) NOT NULL,
CLIENT_RECEIVEDATA_AP DECIMAL(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_ST varchar(32) NOT NULL,
CLIENT_SENDDATA_AP DECIMAL(20,4) NOT NULL,
CLIENT_SENDDATA_AP_ST varchar(32) NOT NULL,
TRANSMITTED_DATA_ON_LAN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_ST varchar(32) NOT NULL,
RECEIVED_DATA_ON_LAN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_ST varchar(32) NOT NULL,
TRANSMITTED_PACKET_LAN DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_ST varchar(32) NOT NULL,
RECEIVED_PACKET_LAN DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_LAN_ST varchar(32) NOT NULL,
TRANSMITTED_UCASTPKT_LAN DECIMAL(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_ST varchar(32) NOT NULL,
RECEIVED_UCASTPKT_LAN DECIMAL(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_ST varchar(32) NOT NULL,
TRANSMITTED_MCASTPKT_LAN DECIMAL(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_ST varchar(32) NOT NULL,
RECEIEVED_MCASTPKT_LAN DECIMAL(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDApInfoTest ON RZDApInfoTest(MSMT_TIME);
ALTER TABLE RZDApInfoTest ADD constraint PK_RZDApInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApInfoTest_TREND;
CREATE TABLE RZDApInfoTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_RADIO_MIN DECIMAL(20,4) NOT NULL,
TOTAL_RADIO_MAX DECIMAL(20,4) NOT NULL,
TOTAL_RADIO_STCNT varchar(32) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_STCNT varchar(32) NOT NULL,
AP_STATUS_MIN DECIMAL(20,4) NOT NULL,
AP_STATUS_MAX DECIMAL(20,4) NOT NULL,
AP_STATUS_STCNT varchar(32) NOT NULL,
CPU_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
CPU_UTILIZATION_STCNT varchar(32) NOT NULL,
MEMORY_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTILIZATION_STCNT varchar(32) NOT NULL,
CLIENT_RECEIVEDATA_AP_MIN DECIMAL(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_MAX DECIMAL(20,4) NOT NULL,
CLIENT_RECEIVEDATA_AP_STCNT varchar(32) NOT NULL,
CLIENT_SENDDATA_AP_MIN DECIMAL(20,4) NOT NULL,
CLIENT_SENDDATA_AP_MAX DECIMAL(20,4) NOT NULL,
CLIENT_SENDDATA_AP_STCNT varchar(32) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_DATA_ON_LAN_STCNT varchar(32) NOT NULL,
RECEIVED_DATA_ON_LAN_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_DATA_ON_LAN_STCNT varchar(32) NOT NULL,
TRANSMITTED_PACKET_LAN_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_PACKET_LAN_STCNT varchar(32) NOT NULL,
RECEIVED_PACKET_LAN_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_LAN_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_PACKET_LAN_STCNT varchar(32) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_STCNT varchar(32) NOT NULL,
RECEIVED_UCASTPKT_LAN_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_UCASTPKT_LAN_STCNT varchar(32) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MIN DECIMAL(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MAX DECIMAL(20,4) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_STCNT varchar(32) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MIN DECIMAL(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MAX DECIMAL(20,4) NOT NULL,
RECEIEVED_MCASTPKT_LAN_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDApInfoTest_TREND ADD constraint PK_RZDApInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApInfoTest_THRESH;
CREATE TABLE RZDApInfoTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_RADIO_MIN VARCHAR(256) NOT NULL,
TOTAL_RADIO_MAX VARCHAR(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MIN VARCHAR(256) NOT NULL,
TOTAL_AUTHORIZED_DEVICE_MAX VARCHAR(256) NOT NULL,
AP_STATUS_MIN VARCHAR(256) NOT NULL,
AP_STATUS_MAX VARCHAR(256) NOT NULL,
CPU_UTILIZATION_MIN VARCHAR(256) NOT NULL,
CPU_UTILIZATION_MAX VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MIN VARCHAR(256) NOT NULL,
MEMORY_UTILIZATION_MAX VARCHAR(256) NOT NULL,
CLIENT_RECEIVEDATA_AP_MIN VARCHAR(256) NOT NULL,
CLIENT_RECEIVEDATA_AP_MAX VARCHAR(256) NOT NULL,
CLIENT_SENDDATA_AP_MIN VARCHAR(256) NOT NULL,
CLIENT_SENDDATA_AP_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_DATA_ON_LAN_MAX VARCHAR(256) NOT NULL,
RECEIVED_DATA_ON_LAN_MIN VARCHAR(256) NOT NULL,
RECEIVED_DATA_ON_LAN_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_LAN_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_PACKET_LAN_MAX VARCHAR(256) NOT NULL,
RECEIVED_PACKET_LAN_MIN VARCHAR(256) NOT NULL,
RECEIVED_PACKET_LAN_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_UCASTPKT_LAN_MAX VARCHAR(256) NOT NULL,
RECEIVED_UCASTPKT_LAN_MIN VARCHAR(256) NOT NULL,
RECEIVED_UCASTPKT_LAN_MAX VARCHAR(256) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MIN VARCHAR(256) NOT NULL,
TRANSMITTED_MCASTPKT_LAN_MAX VARCHAR(256) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MIN VARCHAR(256) NOT NULL,
RECEIEVED_MCASTPKT_LAN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDApInfoTest_THRESH ADD constraint PK_RZDApInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApInfoTest_THRESH ON RZDApInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApInfoTest ON RZDApInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApInfoTest ON RZDApInfoTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE RZDApRadioTest;
CREATE TABLE RZDApRadioTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
RESOURCE_UTILIZATION DECIMAL(20,4) NOT NULL,
RESOURCE_UTILIZATION_ST varchar(32) NOT NULL,
TRANSMIT_PACKET DECIMAL(20,4) NOT NULL,
TRANSMIT_PACKET_ST varchar(32) NOT NULL,
RECEIEVED_PACKET DECIMAL(20,4) NOT NULL,
RECEIEVED_PACKET_ST varchar(32) NOT NULL,
TRANSMIT_DATA DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_ST varchar(32) NOT NULL,
RECEIEVED_DATA DECIMAL(20,4) NOT NULL,
RECEIEVED_DATA_ST varchar(32) NOT NULL,
TRANSMIT_MCAST_PACKET DECIMAL(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_ST varchar(32) NOT NULL,
RECEIVED_MCAST_PACKET DECIMAL(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_ST varchar(32) NOT NULL,
FAILED_TRANSMIT_PACKET DECIMAL(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_ST varchar(32) NOT NULL,
RETRY_TRANSMIT_PACKET DECIMAL(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_ST varchar(32) NOT NULL,
SUCCESS_AUTHENTICATION DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_ST varchar(32) NOT NULL,
FAILED_AUTHENTICATION DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_ST varchar(32) NOT NULL,
TRANSMIT_POWER DECIMAL(20,4) NOT NULL,
TRANSMIT_POWER_ST varchar(32) NOT NULL,
POWER_MGT DECIMAL(20,4) NOT NULL,
POWER_MGT_ST varchar(32) NOT NULL);

CREATE INDEX IDX_RZDApRadioTest ON RZDApRadioTest(MSMT_TIME);
ALTER TABLE RZDApRadioTest ADD constraint PK_RZDApRadioTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE RZDApRadioTest_TREND;
CREATE TABLE RZDApRadioTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RESOURCE_UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
RESOURCE_UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
RESOURCE_UTILIZATION_STCNT varchar(32) NOT NULL,
TRANSMIT_PACKET_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_PACKET_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_PACKET_STCNT varchar(32) NOT NULL,
RECEIEVED_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECEIEVED_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECEIEVED_PACKET_STCNT varchar(32) NOT NULL,
TRANSMIT_DATA_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_DATA_STCNT varchar(32) NOT NULL,
RECEIEVED_DATA_MIN DECIMAL(20,4) NOT NULL,
RECEIEVED_DATA_MAX DECIMAL(20,4) NOT NULL,
RECEIEVED_DATA_STCNT varchar(32) NOT NULL,
TRANSMIT_MCAST_PACKET_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_MCAST_PACKET_STCNT varchar(32) NOT NULL,
RECEIVED_MCAST_PACKET_MIN DECIMAL(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_MAX DECIMAL(20,4) NOT NULL,
RECEIVED_MCAST_PACKET_STCNT varchar(32) NOT NULL,
FAILED_TRANSMIT_PACKET_MIN DECIMAL(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_MAX DECIMAL(20,4) NOT NULL,
FAILED_TRANSMIT_PACKET_STCNT varchar(32) NOT NULL,
RETRY_TRANSMIT_PACKET_MIN DECIMAL(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_MAX DECIMAL(20,4) NOT NULL,
RETRY_TRANSMIT_PACKET_STCNT varchar(32) NOT NULL,
SUCCESS_AUTHENTICATION_MIN DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_MAX DECIMAL(20,4) NOT NULL,
SUCCESS_AUTHENTICATION_STCNT varchar(32) NOT NULL,
FAILED_AUTHENTICATION_MIN DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_MAX DECIMAL(20,4) NOT NULL,
FAILED_AUTHENTICATION_STCNT varchar(32) NOT NULL,
TRANSMIT_POWER_MIN DECIMAL(20,4) NOT NULL,
TRANSMIT_POWER_MAX DECIMAL(20,4) NOT NULL,
TRANSMIT_POWER_STCNT varchar(32) NOT NULL,
POWER_MGT_MIN DECIMAL(20,4) NOT NULL,
POWER_MGT_MAX DECIMAL(20,4) NOT NULL,
POWER_MGT_STCNT varchar(32) NOT NULL);

ALTER TABLE RZDApRadioTest_TREND ADD constraint PK_RZDApRadioTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RZDApRadioTest_THRESH;
CREATE TABLE RZDApRadioTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RESOURCE_UTILIZATION_MIN VARCHAR(256) NOT NULL,
RESOURCE_UTILIZATION_MAX VARCHAR(256) NOT NULL,
TRANSMIT_PACKET_MIN VARCHAR(256) NOT NULL,
TRANSMIT_PACKET_MAX VARCHAR(256) NOT NULL,
RECEIEVED_PACKET_MIN VARCHAR(256) NOT NULL,
RECEIEVED_PACKET_MAX VARCHAR(256) NOT NULL,
TRANSMIT_DATA_MIN VARCHAR(256) NOT NULL,
TRANSMIT_DATA_MAX VARCHAR(256) NOT NULL,
RECEIEVED_DATA_MIN VARCHAR(256) NOT NULL,
RECEIEVED_DATA_MAX VARCHAR(256) NOT NULL,
TRANSMIT_MCAST_PACKET_MIN VARCHAR(256) NOT NULL,
TRANSMIT_MCAST_PACKET_MAX VARCHAR(256) NOT NULL,
RECEIVED_MCAST_PACKET_MIN VARCHAR(256) NOT NULL,
RECEIVED_MCAST_PACKET_MAX VARCHAR(256) NOT NULL,
FAILED_TRANSMIT_PACKET_MIN VARCHAR(256) NOT NULL,
FAILED_TRANSMIT_PACKET_MAX VARCHAR(256) NOT NULL,
RETRY_TRANSMIT_PACKET_MIN VARCHAR(256) NOT NULL,
RETRY_TRANSMIT_PACKET_MAX VARCHAR(256) NOT NULL,
SUCCESS_AUTHENTICATION_MIN VARCHAR(256) NOT NULL,
SUCCESS_AUTHENTICATION_MAX VARCHAR(256) NOT NULL,
FAILED_AUTHENTICATION_MIN VARCHAR(256) NOT NULL,
FAILED_AUTHENTICATION_MAX VARCHAR(256) NOT NULL,
TRANSMIT_POWER_MIN VARCHAR(256) NOT NULL,
TRANSMIT_POWER_MAX VARCHAR(256) NOT NULL,
POWER_MGT_MIN VARCHAR(256) NOT NULL,
POWER_MGT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE RZDApRadioTest_THRESH ADD constraint PK_RZDApRadioTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RZDApRadioTest_THRESH ON RZDApRadioTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RZDApRadioTest ON RZDApRadioTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RZDApRadioTest ON RZDApRadioTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwCpuUtTest;
CREATE TABLE DellSwCpuUtTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CPU_UTIL_5SEC DECIMAL(20,4) NOT NULL,
CPU_UTIL_5SEC_ST varchar(32) NOT NULL,
CPU_UTIL_1MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_1MIN_ST varchar(32) NOT NULL,
CPU_UTIL_5MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_5MIN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwCpuUtTest ON DellSwCpuUtTest(MSMT_TIME);
ALTER TABLE DellSwCpuUtTest ADD constraint PK_DellSwCpuUtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwCpuUtTest_TREND;
CREATE TABLE DellSwCpuUtTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CPU_UTIL_5SEC_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_5SEC_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_5SEC_STCNT varchar(32) NOT NULL,
CPU_UTIL_1MIN_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_1MIN_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_1MIN_STCNT varchar(32) NOT NULL,
CPU_UTIL_5MIN_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_5MIN_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_5MIN_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwCpuUtTest_TREND ADD constraint PK_DellSwCpuUtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwCpuUtTest_THRESH;
CREATE TABLE DellSwCpuUtTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CPU_UTIL_5SEC_MIN VARCHAR(256) NOT NULL,
CPU_UTIL_5SEC_MAX VARCHAR(256) NOT NULL,
CPU_UTIL_1MIN_MIN VARCHAR(256) NOT NULL,
CPU_UTIL_1MIN_MAX VARCHAR(256) NOT NULL,
CPU_UTIL_5MIN_MIN VARCHAR(256) NOT NULL,
CPU_UTIL_5MIN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwCpuUtTest_THRESH ADD constraint PK_DellSwCpuUtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwCpuUtTest_THRESH ON DellSwCpuUtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwCpuUtTest ON DellSwCpuUtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwCpuUtTest ON DellSwCpuUtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwFanStTest;
CREATE TABLE DellSwFanStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
FAN_STATUS DECIMAL(20,4) NOT NULL,
FAN_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwFanStTest ON DellSwFanStTest(MSMT_TIME);
ALTER TABLE DellSwFanStTest ADD constraint PK_DellSwFanStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwFanStTest_TREND;
CREATE TABLE DellSwFanStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
FAN_STATUS_MIN DECIMAL(20,4) NOT NULL,
FAN_STATUS_MAX DECIMAL(20,4) NOT NULL,
FAN_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwFanStTest_TREND ADD constraint PK_DellSwFanStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwFanStTest_THRESH;
CREATE TABLE DellSwFanStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
FAN_STATUS_MIN VARCHAR(256) NOT NULL,
FAN_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwFanStTest_THRESH ADD constraint PK_DellSwFanStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwFanStTest_THRESH ON DellSwFanStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwFanStTest ON DellSwFanStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwFanStTest ON DellSwFanStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwMemUTest;
CREATE TABLE DellSwMemUTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_MEMORY DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_ST varchar(32) NOT NULL,
UTILIZED_MEMORY DECIMAL(20,4) NOT NULL,
UTILIZED_MEMORY_ST varchar(32) NOT NULL,
FREE_MEMORY DECIMAL(20,4) NOT NULL,
FREE_MEMORY_ST varchar(32) NOT NULL,
MEMORY_UTIL DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwMemUTest ON DellSwMemUTest(MSMT_TIME);
ALTER TABLE DellSwMemUTest ADD constraint PK_DellSwMemUTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwMemUTest_TREND;
CREATE TABLE DellSwMemUTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_MEMORY_MIN DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_MAX DECIMAL(20,4) NOT NULL,
TOTAL_MEMORY_STCNT varchar(32) NOT NULL,
UTILIZED_MEMORY_MIN DECIMAL(20,4) NOT NULL,
UTILIZED_MEMORY_MAX DECIMAL(20,4) NOT NULL,
UTILIZED_MEMORY_STCNT varchar(32) NOT NULL,
FREE_MEMORY_MIN DECIMAL(20,4) NOT NULL,
FREE_MEMORY_MAX DECIMAL(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar(32) NOT NULL,
MEMORY_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwMemUTest_TREND ADD constraint PK_DellSwMemUTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwMemUTest_THRESH;
CREATE TABLE DellSwMemUTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_MEMORY_MIN VARCHAR(256) NOT NULL,
TOTAL_MEMORY_MAX VARCHAR(256) NOT NULL,
UTILIZED_MEMORY_MIN VARCHAR(256) NOT NULL,
UTILIZED_MEMORY_MAX VARCHAR(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR(256) NOT NULL,
MEMORY_UTIL_MIN VARCHAR(256) NOT NULL,
MEMORY_UTIL_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwMemUTest_THRESH ADD constraint PK_DellSwMemUTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwMemUTest_THRESH ON DellSwMemUTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwMemUTest ON DellSwMemUTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwMemUTest ON DellSwMemUTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwPortDtTest;
CREATE TABLE DellSwPortDtTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ADMIN_STATUS DECIMAL(20,4) NOT NULL,
ADMIN_STATUS_ST varchar(32) NOT NULL,
OPERATIONAL_STATUS DECIMAL(20,4) NOT NULL,
OPERATIONAL_STATUS_ST varchar(32) NOT NULL,
RECD_POWER_SIGNAL DECIMAL(20,4) NOT NULL,
RECD_POWER_SIGNAL_ST varchar(32) NOT NULL,
TXMT_POWER_SIGNAL DECIMAL(20,4) NOT NULL,
TXMT_POWER_SIGNAL_ST varchar(32) NOT NULL,
RECD_TEMPERATURE DECIMAL(20,4) NOT NULL,
RECD_TEMPERATURE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwPortDtTest ON DellSwPortDtTest(MSMT_TIME);
ALTER TABLE DellSwPortDtTest ADD constraint PK_DellSwPortDtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwPortDtTest_TREND;
CREATE TABLE DellSwPortDtTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ADMIN_STATUS_MIN DECIMAL(20,4) NOT NULL,
ADMIN_STATUS_MAX DECIMAL(20,4) NOT NULL,
ADMIN_STATUS_STCNT varchar(32) NOT NULL,
OPERATIONAL_STATUS_MIN DECIMAL(20,4) NOT NULL,
OPERATIONAL_STATUS_MAX DECIMAL(20,4) NOT NULL,
OPERATIONAL_STATUS_STCNT varchar(32) NOT NULL,
RECD_POWER_SIGNAL_MIN DECIMAL(20,4) NOT NULL,
RECD_POWER_SIGNAL_MAX DECIMAL(20,4) NOT NULL,
RECD_POWER_SIGNAL_STCNT varchar(32) NOT NULL,
TXMT_POWER_SIGNAL_MIN DECIMAL(20,4) NOT NULL,
TXMT_POWER_SIGNAL_MAX DECIMAL(20,4) NOT NULL,
TXMT_POWER_SIGNAL_STCNT varchar(32) NOT NULL,
RECD_TEMPERATURE_MIN DECIMAL(20,4) NOT NULL,
RECD_TEMPERATURE_MAX DECIMAL(20,4) NOT NULL,
RECD_TEMPERATURE_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwPortDtTest_TREND ADD constraint PK_DellSwPortDtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwPortDtTest_THRESH;
CREATE TABLE DellSwPortDtTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ADMIN_STATUS_MIN VARCHAR(256) NOT NULL,
ADMIN_STATUS_MAX VARCHAR(256) NOT NULL,
OPERATIONAL_STATUS_MIN VARCHAR(256) NOT NULL,
OPERATIONAL_STATUS_MAX VARCHAR(256) NOT NULL,
RECD_POWER_SIGNAL_MIN VARCHAR(256) NOT NULL,
RECD_POWER_SIGNAL_MAX VARCHAR(256) NOT NULL,
TXMT_POWER_SIGNAL_MIN VARCHAR(256) NOT NULL,
TXMT_POWER_SIGNAL_MAX VARCHAR(256) NOT NULL,
RECD_TEMPERATURE_MIN VARCHAR(256) NOT NULL,
RECD_TEMPERATURE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwPortDtTest_THRESH ADD constraint PK_DellSwPortDtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwPortDtTest_THRESH ON DellSwPortDtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwPortDtTest ON DellSwPortDtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwPortDtTest ON DellSwPortDtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwPSSTest;
CREATE TABLE DellSwPSSTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PS_STATUS DECIMAL(20,4) NOT NULL,
PS_STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwPSSTest ON DellSwPSSTest(MSMT_TIME);
ALTER TABLE DellSwPSSTest ADD constraint PK_DellSwPSSTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwPSSTest_TREND;
CREATE TABLE DellSwPSSTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PS_STATUS_MIN DECIMAL(20,4) NOT NULL,
PS_STATUS_MAX DECIMAL(20,4) NOT NULL,
PS_STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwPSSTest_TREND ADD constraint PK_DellSwPSSTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwPSSTest_THRESH;
CREATE TABLE DellSwPSSTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PS_STATUS_MIN VARCHAR(256) NOT NULL,
PS_STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwPSSTest_THRESH ADD constraint PK_DellSwPSSTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwPSSTest_THRESH ON DellSwPSSTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwPSSTest ON DellSwPSSTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwPSSTest ON DellSwPSSTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwStatusTest;
CREATE TABLE DellSwStatusTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
STATUS DECIMAL(20,4) NOT NULL,
STATUS_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwStatusTest ON DellSwStatusTest(MSMT_TIME);
ALTER TABLE DellSwStatusTest ADD constraint PK_DellSwStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwStatusTest_TREND;
CREATE TABLE DellSwStatusTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
STATUS_MIN DECIMAL(20,4) NOT NULL,
STATUS_MAX DECIMAL(20,4) NOT NULL,
STATUS_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwStatusTest_TREND ADD constraint PK_DellSwStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwStatusTest_THRESH;
CREATE TABLE DellSwStatusTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
STATUS_MIN VARCHAR(256) NOT NULL,
STATUS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwStatusTest_THRESH ADD constraint PK_DellSwStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwStatusTest_THRESH ON DellSwStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwStatusTest ON DellSwStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwStatusTest ON DellSwStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE DellSwTmpStTest;
CREATE TABLE DellSwTmpStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TEMPERATURE DECIMAL(20,4) NOT NULL,
TEMPERATURE_ST varchar(32) NOT NULL);

CREATE INDEX IDX_DellSwTmpStTest ON DellSwTmpStTest(MSMT_TIME);
ALTER TABLE DellSwTmpStTest ADD constraint PK_DellSwTmpStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE DellSwTmpStTest_TREND;
CREATE TABLE DellSwTmpStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TEMPERATURE_MIN DECIMAL(20,4) NOT NULL,
TEMPERATURE_MAX DECIMAL(20,4) NOT NULL,
TEMPERATURE_STCNT varchar(32) NOT NULL);

ALTER TABLE DellSwTmpStTest_TREND ADD constraint PK_DellSwTmpStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE DellSwTmpStTest_THRESH;
CREATE TABLE DellSwTmpStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TEMPERATURE_MIN VARCHAR(256) NOT NULL,
TEMPERATURE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE DellSwTmpStTest_THRESH ADD constraint PK_DellSwTmpStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_DellSwTmpStTest_THRESH ON DellSwTmpStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_DellSwTmpStTest ON DellSwTmpStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_DellSwTmpStTest ON DellSwTmpStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxBattStTest;
CREATE TABLE HiVSPGxBattStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
BATTERY_STATUS decimal(20,4) NOT NULL,
BATTERY_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxBattStTest ON HiVSPGxBattStTest(MSMT_TIME);
ALTER TABLE HiVSPGxBattStTest ADD constraint PK_HiVSPGxBattStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxBattStTest_TREND;
CREATE TABLE HiVSPGxBattStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
BATTERY_STATUS_MIN decimal(20,4) NOT NULL,
BATTERY_STATUS_MAX decimal(20,4) NOT NULL,
BATTERY_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxBattStTest_TREND ADD constraint PK_HiVSPGxBattStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxBattStTest_THRESH;
CREATE TABLE HiVSPGxBattStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
BATTERY_STATUS_MIN VARCHAR(256) NOT NULL,
BATTERY_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxBattStTest_THRESH ADD constraint PK_HiVSPGxBattStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxBattStTest_THRESH ON HiVSPGxBattStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxBattStTest ON HiVSPGxBattStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxBattStTest ON HiVSPGxBattStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxCacheStTest;
CREATE TABLE HiVSPGxCacheStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CACHE_STATUS decimal(20,4) NOT NULL,
CACHE_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCacheStTest ON HiVSPGxCacheStTest(MSMT_TIME);
ALTER TABLE HiVSPGxCacheStTest ADD constraint PK_HiVSPGxCacheStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCacheStTest_TREND;
CREATE TABLE HiVSPGxCacheStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CACHE_STATUS_MIN decimal(20,4) NOT NULL,
CACHE_STATUS_MAX decimal(20,4) NOT NULL,
CACHE_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxCacheStTest_TREND ADD constraint PK_HiVSPGxCacheStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCacheStTest_THRESH;
CREATE TABLE HiVSPGxCacheStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CACHE_STATUS_MIN VARCHAR(256) NOT NULL,
CACHE_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxCacheStTest_THRESH ADD constraint PK_HiVSPGxCacheStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCacheStTest_THRESH ON HiVSPGxCacheStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCacheStTest ON HiVSPGxCacheStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCacheStTest ON HiVSPGxCacheStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxSMStTest;
CREATE TABLE HiVSPGxSMStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SHARED_MEMORY_STATUS decimal(20,4) NOT NULL,
SHARED_MEMORY_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxSMStTest ON HiVSPGxSMStTest(MSMT_TIME);
ALTER TABLE HiVSPGxSMStTest ADD constraint PK_HiVSPGxSMStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxSMStTest_TREND;
CREATE TABLE HiVSPGxSMStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SHARED_MEMORY_STATUS_MIN decimal(20,4) NOT NULL,
SHARED_MEMORY_STATUS_MAX decimal(20,4) NOT NULL,
SHARED_MEMORY_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxSMStTest_TREND ADD constraint PK_HiVSPGxSMStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxSMStTest_THRESH;
CREATE TABLE HiVSPGxSMStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SHARED_MEMORY_STATUS_MIN VARCHAR(256) NOT NULL,
SHARED_MEMORY_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxSMStTest_THRESH ADD constraint PK_HiVSPGxSMStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxSMStTest_THRESH ON HiVSPGxSMStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxSMStTest ON HiVSPGxSMStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxSMStTest ON HiVSPGxSMStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxPSStTest;
CREATE TABLE HiVSPGxPSStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
POWER_STUPPLY_STATUS decimal(20,4) NOT NULL,
POWER_STUPPLY_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_UspPSStatus ON HiVSPGxPSStTest(MSMT_TIME);
ALTER TABLE HiVSPGxPSStTest ADD constraint PK_HiVSPGxPSStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPSStTest_TREND;
CREATE TABLE HiVSPGxPSStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
POWER_STUPPLY_STATUS_MIN decimal(20,4) NOT NULL,
POWER_STUPPLY_STATUS_MAX decimal(20,4) NOT NULL,
POWER_STUPPLY_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxPSStTest_TREND ADD constraint PK_HiVSPGxPSStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPSStTest_THRESH;
CREATE TABLE HiVSPGxPSStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
POWER_STUPPLY_STATUS_MIN VARCHAR(256) NOT NULL,
POWER_STUPPLY_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxPSStTest_THRESH ADD constraint PK_HiVSPGxPSStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPSStTest_THRESH ON HiVSPGxPSStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPSStTest ON HiVSPGxPSStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPSStTest ON HiVSPGxPSStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxProcStTest;
CREATE TABLE HiVSPGxProcStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PROCESSOR_STATUS decimal(20,4) NOT NULL,
PROCESSOR_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxProcStTest ON HiVSPGxProcStTest(MSMT_TIME);
ALTER TABLE HiVSPGxProcStTest ADD constraint PK_HiVSPGxProcStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxProcStTest_TREND;
CREATE TABLE HiVSPGxProcStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PROCESSOR_STATUS_MIN decimal(20,4) NOT NULL,
PROCESSOR_STATUS_MAX decimal(20,4) NOT NULL,
PROCESSOR_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxProcStTest_TREND ADD constraint PK_HiVSPGxProcStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxProcStTest_THRESH;
CREATE TABLE HiVSPGxProcStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PROCESSOR_STATUS_MIN VARCHAR(256) NOT NULL,
PROCESSOR_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxProcStTest_THRESH ADD constraint PK_HiVSPGxProcStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxProcStTest_THRESH ON HiVSPGxProcStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxProcStTest ON HiVSPGxProcStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxProcStTest ON HiVSPGxProcStTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE HiVSPGxFanStTest;
CREATE TABLE HiVSPGxFanStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
FAN_STATUS decimal(20,4) NOT NULL,
FAN_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxFanStTest ON HiVSPGxFanStTest(MSMT_TIME);
ALTER TABLE HiVSPGxFanStTest ADD constraint PK_HiVSPGxFanStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxFanStTest_TREND;
CREATE TABLE HiVSPGxFanStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
FAN_STATUS_MIN decimal(20,4) NOT NULL,
FAN_STATUS_MAX decimal(20,4) NOT NULL,
FAN_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxFanStTest_TREND ADD constraint PK_HiVSPGxFanStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxFanStTest_THRESH;
CREATE TABLE HiVSPGxFanStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
FAN_STATUS_MIN VARCHAR(256) NOT NULL,
FAN_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxFanStTest_THRESH ADD constraint PK_HiVSPGxFanStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxFanStTest_THRESH ON HiVSPGxFanStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxFanStTest ON HiVSPGxFanStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxFanStTest ON HiVSPGxFanStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxDriveStTest;
CREATE TABLE HiVSPGxDriveStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
DRIVE_STATUS decimal(20,4) NOT NULL,
DRIVE_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxDriveStTest ON HiVSPGxDriveStTest(MSMT_TIME);
ALTER TABLE HiVSPGxDriveStTest ADD constraint PK_HiVSPGxDriveStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxDriveStTest_TREND;
CREATE TABLE HiVSPGxDriveStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
DRIVE_STATUS_MIN decimal(20,4) NOT NULL,
DRIVE_STATUS_MAX decimal(20,4) NOT NULL,
DRIVE_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxDriveStTest_TREND ADD constraint PK_HiVSPGxDriveStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxDriveStTest_THRESH;
CREATE TABLE HiVSPGxDriveStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
DRIVE_STATUS_MIN VARCHAR(256) NOT NULL,
DRIVE_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxDriveStTest_THRESH ADD constraint PK_HiVSPGxDriveStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxDriveStTest_THRESH ON HiVSPGxDriveStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxDriveStTest ON HiVSPGxDriveStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxDriveStTest ON HiVSPGxDriveStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxCntrlStTest;
CREATE TABLE HiVSPGxCntrlStTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CONTROLLER_STATUS decimal(20,4) NOT NULL,
CONTROLLER_STATUS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest(MSMT_TIME);
ALTER TABLE HiVSPGxCntrlStTest ADD constraint PK_HiVSPGxCntrlStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCntrlStTest_TREND;
CREATE TABLE HiVSPGxCntrlStTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CONTROLLER_STATUS_MIN decimal(20,4) NOT NULL,
CONTROLLER_STATUS_MAX decimal(20,4) NOT NULL,
CONTROLLER_STATUS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxCntrlStTest_TREND ADD constraint PK_HiVSPGxCntrlStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCntrlStTest_THRESH;
CREATE TABLE HiVSPGxCntrlStTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CONTROLLER_STATUS_MIN VARCHAR(256) NOT NULL,
CONTROLLER_STATUS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxCntrlStTest_THRESH ADD constraint PK_HiVSPGxCntrlStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCntrlStTest_THRESH ON HiVSPGxCntrlStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCntrlStTest ON HiVSPGxCntrlStTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE HiVSPGxPortTest;
CREATE TABLE HiVSPGxPortTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IOPS DECIMAL(20,4) NOT NULL,
IOPS_ST varchar(32) NOT NULL,
KBPS DECIMAL(20,4) NOT NULL,
KBPS_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxPortTest ON HiVSPGxPortTest(MSMT_TIME);
ALTER TABLE HiVSPGxPortTest ADD constraint PK_HiVSPGxPortTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPortTest_TREND;
CREATE TABLE HiVSPGxPortTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IOPS_MIN DECIMAL(20,4) NOT NULL,
IOPS_MAX DECIMAL(20,4) NOT NULL,
IOPS_STCNT varchar(32) NOT NULL,
KBPS_MIN DECIMAL(20,4) NOT NULL,
KBPS_MAX DECIMAL(20,4) NOT NULL,
KBPS_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxPortTest_TREND ADD constraint PK_HiVSPGxPortTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPortTest_THRESH;
CREATE TABLE HiVSPGxPortTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IOPS_MIN VARCHAR(256) NOT NULL,
IOPS_MAX VARCHAR(256) NOT NULL,
KBPS_MIN VARCHAR(256) NOT NULL,
KBPS_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxPortTest_THRESH ADD constraint PK_HiVSPGxPortTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPortTest_THRESH ON HiVSPGxPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPortTest ON HiVSPGxPortTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPortTest ON HiVSPGxPortTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxPGroupTest;
CREATE TABLE HiVSPGxPGroupTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IOPS DECIMAL(20,4) NOT NULL,
IOPS_ST varchar(32) NOT NULL,
TRANSRATE DECIMAL(20,4) NOT NULL,
TRANSRATE_ST varchar(32) NOT NULL,
READ_IOPS DECIMAL(20,4) NOT NULL,
READ_IOPS_ST varchar(32) NOT NULL,
WRITE_IOPS DECIMAL(20,4) NOT NULL,
WRITE_IOPS_ST varchar(32) NOT NULL,
READ_HIT DECIMAL(20,4) NOT NULL,
READ_HIT_ST varchar(32) NOT NULL,
WRITE_HIT DECIMAL(20,4) NOT NULL,
WRITE_HIT_ST varchar(32) NOT NULL,
C2D_TRANSFER DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL,
BACKTRANS DECIMAL(20,4) NOT NULL,
BACKTRANS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxPGroupTest ON HiVSPGxPGroupTest(MSMT_TIME);
ALTER TABLE HiVSPGxPGroupTest ADD constraint PK_HiVSPGxPGroupTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxPGroupTest_TREND;
CREATE TABLE HiVSPGxPGroupTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IOPS_MIN DECIMAL(20,4) NOT NULL,
IOPS_MAX DECIMAL(20,4) NOT NULL,
IOPS_STCNT varchar(32) NOT NULL,
TRANSRATE_MIN DECIMAL(20,4) NOT NULL,
TRANSRATE_MAX DECIMAL(20,4) NOT NULL,
TRANSRATE_STCNT varchar(32) NOT NULL,
READ_IOPS_MIN DECIMAL(20,4) NOT NULL,
READ_IOPS_MAX DECIMAL(20,4) NOT NULL,
READ_IOPS_STCNT varchar(32) NOT NULL,
WRITE_IOPS_MIN DECIMAL(20,4) NOT NULL,
WRITE_IOPS_MAX DECIMAL(20,4) NOT NULL,
WRITE_IOPS_STCNT varchar(32) NOT NULL,
READ_HIT_MIN DECIMAL(20,4) NOT NULL,
READ_HIT_MAX DECIMAL(20,4) NOT NULL,
READ_HIT_STCNT varchar(32) NOT NULL,
WRITE_HIT_MIN DECIMAL(20,4) NOT NULL,
WRITE_HIT_MAX DECIMAL(20,4) NOT NULL,
WRITE_HIT_STCNT varchar(32) NOT NULL,
C2D_TRANSFER_MIN DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_MAX DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL,
BACKTRANS_MIN DECIMAL(20,4) NOT NULL,
BACKTRANS_MAX DECIMAL(20,4) NOT NULL,
BACKTRANS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxPGroupTest_TREND ADD constraint PK_HiVSPGxPGroupTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxPGroupTest_THRESH;
CREATE TABLE HiVSPGxPGroupTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IOPS_MIN VARCHAR(256) NOT NULL,
IOPS_MAX VARCHAR(256) NOT NULL,
TRANSRATE_MIN VARCHAR(256) NOT NULL,
TRANSRATE_MAX VARCHAR(256) NOT NULL,
READ_IOPS_MIN VARCHAR(256) NOT NULL,
READ_IOPS_MAX VARCHAR(256) NOT NULL,
WRITE_IOPS_MIN VARCHAR(256) NOT NULL,
WRITE_IOPS_MAX VARCHAR(256) NOT NULL,
READ_HIT_MIN VARCHAR(256) NOT NULL,
READ_HIT_MAX VARCHAR(256) NOT NULL,
WRITE_HIT_MIN VARCHAR(256) NOT NULL,
WRITE_HIT_MAX VARCHAR(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL,
BACKTRANS_MIN VARCHAR(256) NOT NULL,
BACKTRANS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxPGroupTest_THRESH ADD constraint PK_HiVSPGxPGroupTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxPGroupTest_THRESH ON HiVSPGxPGroupTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxPGroupTest ON HiVSPGxPGroupTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxPGroupTest ON HiVSPGxPGroupTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxLunDetTest;
CREATE TABLE HiVSPGxLunDetTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IOPS DECIMAL(20,4) NOT NULL,
IOPS_ST varchar(32) NOT NULL,
TRANSRATE DECIMAL(20,4) NOT NULL,
TRANSRATE_ST varchar(32) NOT NULL,
SEQ_READ_HIT DECIMAL(20,4) NOT NULL,
SEQ_READ_HIT_ST varchar(32) NOT NULL,
RAND_READ_HIT DECIMAL(20,4) NOT NULL,
RAND_READ_HIT_ST varchar(32) NOT NULL,
SEQ_WRITE_HIT DECIMAL(20,4) NOT NULL,
SEQ_WRITE_HIT_ST varchar(32) NOT NULL,
RAND_WRITE_HIT DECIMAL(20,4) NOT NULL,
RAND_WRITE_HIT_ST varchar(32) NOT NULL,
C2D_TRANSFER DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxLunDetTest ON HiVSPGxLunDetTest(MSMT_TIME);
ALTER TABLE HiVSPGxLunDetTest ADD constraint PK_HiVSPGxLunDetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxLunDetTest_TREND;
CREATE TABLE HiVSPGxLunDetTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IOPS_MIN DECIMAL(20,4) NOT NULL,
IOPS_MAX DECIMAL(20,4) NOT NULL,
IOPS_STCNT varchar(32) NOT NULL,
TRANSRATE_MIN DECIMAL(20,4) NOT NULL,
TRANSRATE_MAX DECIMAL(20,4) NOT NULL,
TRANSRATE_STCNT varchar(32) NOT NULL,
SEQ_READ_HIT_MIN DECIMAL(20,4) NOT NULL,
SEQ_READ_HIT_MAX DECIMAL(20,4) NOT NULL,
SEQ_READ_HIT_STCNT varchar(32) NOT NULL,
RAND_READ_HIT_MIN DECIMAL(20,4) NOT NULL,
RAND_READ_HIT_MAX DECIMAL(20,4) NOT NULL,
RAND_READ_HIT_STCNT varchar(32) NOT NULL,
SEQ_WRITE_HIT_MIN DECIMAL(20,4) NOT NULL,
SEQ_WRITE_HIT_MAX DECIMAL(20,4) NOT NULL,
SEQ_WRITE_HIT_STCNT varchar(32) NOT NULL,
RAND_WRITE_HIT_MIN DECIMAL(20,4) NOT NULL,
RAND_WRITE_HIT_MAX DECIMAL(20,4) NOT NULL,
RAND_WRITE_HIT_STCNT varchar(32) NOT NULL,
C2D_TRANSFER_MIN DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_MAX DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxLunDetTest_TREND ADD constraint PK_HiVSPGxLunDetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxLunDetTest_THRESH;
CREATE TABLE HiVSPGxLunDetTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IOPS_MIN VARCHAR(256) NOT NULL,
IOPS_MAX VARCHAR(256) NOT NULL,
TRANSRATE_MIN VARCHAR(256) NOT NULL,
TRANSRATE_MAX VARCHAR(256) NOT NULL,
SEQ_READ_HIT_MIN VARCHAR(256) NOT NULL,
SEQ_READ_HIT_MAX VARCHAR(256) NOT NULL,
RAND_READ_HIT_MIN VARCHAR(256) NOT NULL,
RAND_READ_HIT_MAX VARCHAR(256) NOT NULL,
SEQ_WRITE_HIT_MIN VARCHAR(256) NOT NULL,
SEQ_WRITE_HIT_MAX VARCHAR(256) NOT NULL,
RAND_WRITE_HIT_MIN VARCHAR(256) NOT NULL,
RAND_WRITE_HIT_MAX VARCHAR(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxLunDetTest_THRESH ADD constraint PK_HiVSPGxLunDetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxLunDetTest_THRESH ON HiVSPGxLunDetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxLunDetTest ON HiVSPGxLunDetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxLunDetTest ON HiVSPGxLunDetTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HiVSPGxLdevDetTest;
CREATE TABLE HiVSPGxLdevDetTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IOPS DECIMAL(20,4) NOT NULL,
IOPS_ST varchar(32) NOT NULL,
TRANSRATE DECIMAL(20,4) NOT NULL,
TRANSRATE_ST varchar(32) NOT NULL,
READ_IOPS DECIMAL(20,4) NOT NULL,
READ_IOPS_ST varchar(32) NOT NULL,
WRITE_IOPS DECIMAL(20,4) NOT NULL,
WRITE_IOPS_ST varchar(32) NOT NULL,
READ_HIT DECIMAL(20,4) NOT NULL,
READ_HIT_ST varchar(32) NOT NULL,
WRITE_HIT DECIMAL(20,4) NOT NULL,
WRITE_HIT_ST varchar(32) NOT NULL,
C2D_TRANSFER DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL,
BACKTRANS DECIMAL(20,4) NOT NULL,
BACKTRANS_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest(MSMT_TIME);
ALTER TABLE HiVSPGxLdevDetTest ADD constraint PK_HiVSPGxLdevDetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxLdevDetTest_TREND;
CREATE TABLE HiVSPGxLdevDetTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IOPS_MIN DECIMAL(20,4) NOT NULL,
IOPS_MAX DECIMAL(20,4) NOT NULL,
IOPS_STCNT varchar(32) NOT NULL,
TRANSRATE_MIN DECIMAL(20,4) NOT NULL,
TRANSRATE_MAX DECIMAL(20,4) NOT NULL,
TRANSRATE_STCNT varchar(32) NOT NULL,
READ_IOPS_MIN DECIMAL(20,4) NOT NULL,
READ_IOPS_MAX DECIMAL(20,4) NOT NULL,
READ_IOPS_STCNT varchar(32) NOT NULL,
WRITE_IOPS_MIN DECIMAL(20,4) NOT NULL,
WRITE_IOPS_MAX DECIMAL(20,4) NOT NULL,
WRITE_IOPS_STCNT varchar(32) NOT NULL,
READ_HIT_MIN DECIMAL(20,4) NOT NULL,
READ_HIT_MAX DECIMAL(20,4) NOT NULL,
READ_HIT_STCNT varchar(32) NOT NULL,
WRITE_HIT_MIN DECIMAL(20,4) NOT NULL,
WRITE_HIT_MAX DECIMAL(20,4) NOT NULL,
WRITE_HIT_STCNT varchar(32) NOT NULL,
C2D_TRANSFER_MIN DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_MAX DECIMAL(20,4) NOT NULL,
C2D_TRANSFER_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL,
BACKTRANS_MIN DECIMAL(20,4) NOT NULL,
BACKTRANS_MAX DECIMAL(20,4) NOT NULL,
BACKTRANS_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxLdevDetTest_TREND ADD constraint PK_HiVSPGxLdevDetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxLdevDetTest_THRESH;
CREATE TABLE HiVSPGxLdevDetTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IOPS_MIN VARCHAR(256) NOT NULL,
IOPS_MAX VARCHAR(256) NOT NULL,
TRANSRATE_MIN VARCHAR(256) NOT NULL,
TRANSRATE_MAX VARCHAR(256) NOT NULL,
READ_IOPS_MIN VARCHAR(256) NOT NULL,
READ_IOPS_MAX VARCHAR(256) NOT NULL,
WRITE_IOPS_MIN VARCHAR(256) NOT NULL,
WRITE_IOPS_MAX VARCHAR(256) NOT NULL,
READ_HIT_MIN VARCHAR(256) NOT NULL,
READ_HIT_MAX VARCHAR(256) NOT NULL,
WRITE_HIT_MIN VARCHAR(256) NOT NULL,
WRITE_HIT_MAX VARCHAR(256) NOT NULL,
C2D_TRANSFER_MIN VARCHAR(256) NOT NULL,
C2D_TRANSFER_MAX VARCHAR(256) NOT NULL,
RESPONSE_TIME_MIN VARCHAR(256) NOT NULL,
RESPONSE_TIME_MAX VARCHAR(256) NOT NULL,
BACKTRANS_MIN VARCHAR(256) NOT NULL,
BACKTRANS_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxLdevDetTest_THRESH ADD constraint PK_HiVSPGxLdevDetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxLdevDetTest_THRESH ON HiVSPGxLdevDetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxLdevDetTest ON HiVSPGxLdevDetTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxCPRateTest;
CREATE TABLE HiVSPGxCPRateTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
WRITE_PENDING_RATE DECIMAL(20,4) NOT NULL,
WRITE_PENDING_RATE_ST varchar(32) NOT NULL,
CACHE_USAGE_RATE DECIMAL(20,4) NOT NULL,
CACHE_USAGE_RATE_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCPRateTest ON HiVSPGxCPRateTest(MSMT_TIME);
ALTER TABLE HiVSPGxCPRateTest ADD constraint PK_HiVSPGxCPRateTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCPRateTest_TREND;
CREATE TABLE HiVSPGxCPRateTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
WRITE_PENDING_RATE_MIN DECIMAL(20,4) NOT NULL,
WRITE_PENDING_RATE_MAX DECIMAL(20,4) NOT NULL,
WRITE_PENDING_RATE_STCNT varchar(32) NOT NULL,
CACHE_USAGE_RATE_MIN DECIMAL(20,4) NOT NULL,
CACHE_USAGE_RATE_MAX DECIMAL(20,4) NOT NULL,
CACHE_USAGE_RATE_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxCPRateTest_TREND ADD constraint PK_HiVSPGxCPRateTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCPRateTest_THRESH;
CREATE TABLE HiVSPGxCPRateTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
WRITE_PENDING_RATE_MIN VARCHAR(256) NOT NULL,
WRITE_PENDING_RATE_MAX VARCHAR(256) NOT NULL,
CACHE_USAGE_RATE_MIN VARCHAR(256) NOT NULL,
CACHE_USAGE_RATE_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxCPRateTest_THRESH ADD constraint PK_HiVSPGxCPRateTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCPRateTest_THRESH ON HiVSPGxCPRateTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCPRateTest ON HiVSPGxCPRateTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCPRateTest ON HiVSPGxCPRateTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HiVSPGxCtrlTest;
CREATE TABLE HiVSPGxCtrlTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
USAGE_RATE DECIMAL(20,4) NOT NULL,
USAGE_RATE_ST varchar(32) NOT NULL);
CREATE INDEX IDX_HiVSPGxCtrlTest ON HiVSPGxCtrlTest(MSMT_TIME);
ALTER TABLE HiVSPGxCtrlTest ADD constraint PK_HiVSPGxCtrlTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HiVSPGxCtrlTest_TREND;
CREATE TABLE HiVSPGxCtrlTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
USAGE_RATE_MIN DECIMAL(20,4) NOT NULL,
USAGE_RATE_MAX DECIMAL(20,4) NOT NULL,
USAGE_RATE_STCNT varchar(32) NOT NULL);
ALTER TABLE HiVSPGxCtrlTest_TREND ADD constraint PK_HiVSPGxCtrlTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HiVSPGxCtrlTest_THRESH;
CREATE TABLE HiVSPGxCtrlTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
USAGE_RATE_MIN VARCHAR(256) NOT NULL,
USAGE_RATE_MAX VARCHAR(256) NOT NULL);
ALTER TABLE HiVSPGxCtrlTest_THRESH ADD constraint PK_HiVSPGxCtrlTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HiVSPGxCtrlTest_THRESH ON HiVSPGxCtrlTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HiVSPGxCtrlTest ON HiVSPGxCtrlTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HiVSPGxCtrlTest ON HiVSPGxCtrlTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSysLogSvrTest;
CREATE TABLE EgSysLogSvrTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES decimal(20,4) NOT NULL,
NO_OF_MESSAGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSysLogSvrTest ON EgSysLogSvrTest(MSMT_TIME);
ALTER TABLE EgSysLogSvrTest ADD constraint PK_EgSysLogSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogSvrTest_TREND;
CREATE TABLE EgSysLogSvrTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT varchar(32) NOT NULL);

ALTER TABLE EgSysLogSvrTest_TREND ADD constraint PK_EgSysLogSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogSvrTest_THRESH;
CREATE TABLE EgSysLogSvrTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSysLogSvrTest_THRESH ADD constraint PK_EgSysLogSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogSvrTest_THRESH ON EgSysLogSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogSvrTest ON EgSysLogSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogSvrTest ON EgSysLogSvrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EgSysLogAppTest;
CREATE TABLE EgSysLogAppTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES decimal(20,4) NOT NULL,
NO_OF_MESSAGES_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSysLogAppTest ON EgSysLogAppTest(MSMT_TIME);
ALTER TABLE EgSysLogAppTest ADD constraint PK_EgSysLogAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogAppTest_TREND;
CREATE TABLE EgSysLogAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_STCNT varchar(32) NOT NULL);

ALTER TABLE EgSysLogAppTest_TREND ADD constraint PK_EgSysLogAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogAppTest_THRESH;
CREATE TABLE EgSysLogAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSysLogAppTest_THRESH ADD constraint PK_EgSysLogAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogAppTest_THRESH ON EgSysLogAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogAppTest ON EgSysLogAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogAppTest ON EgSysLogAppTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EgSyslogFilterTest;
CREATE TABLE EgSyslogFilterTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterTest ON EgSyslogFilterTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterTest ADD constraint PK_EgSyslogFilterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterTest_TREND;
CREATE TABLE EgSyslogFilterTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT varchar(32) NOT NULL);



ALTER TABLE EgSyslogFilterTest_TREND ADD constraint PK_EgSyslogFilterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterTest_THRESH;
CREATE TABLE EgSyslogFilterTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,	
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSyslogFilterTest_THRESH ADD constraint PK_EgSyslogFilterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslogFilterTest_THRESH ON EgSyslogFilterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterTest ON EgSyslogFilterTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterTest ON EgSyslogFilterTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSyslogFilterSvrTest;
CREATE TABLE EgSyslogFilterSvrTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_MESSAGES_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_ST varchar(32) NOT NULL);

CREATE INDEX IDX_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest(MSMT_TIME);
ALTER TABLE EgSyslogFilterSvrTest ADD constraint PK_EgSyslogFilterSvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSyslogFilterSvrTest_TREND;
CREATE TABLE EgSyslogFilterSvrTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_MESSAGES_MIN_MIN decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_MAX decimal(20,4) NOT NULL,
NO_OF_MESSAGES_MIN_STCNT varchar(32) NOT NULL);



ALTER TABLE EgSyslogFilterSvrTest_TREND ADD constraint PK_EgSyslogFilterSvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSyslogFilterSvrTest_THRESH;
CREATE TABLE EgSyslogFilterSvrTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,	
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_MESSAGES_MIN_MIN VARCHAR(256) NOT NULL,
NO_OF_MESSAGES_MIN_MAX VARCHAR(256) NOT NULL);

ALTER TABLE EgSyslogFilterSvrTest_THRESH ADD constraint PK_EgSyslgFiltrSvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSyslgFiltrSvrTest_THRESH ON EgSyslogFilterSvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSyslogFilterSvrTest ON EgSyslogFilterSvrTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE   asset_info_custom;
DROP TABLE   asset_info_default;
create table asset_info_default (trgt_host varchar(256) not null,asset_name varchar(32),asset_desc varchar(1024),asset_type varchar(32),asset_state varchar(32),asset_location varchar(32),asset_ip_address varchar(32),asset_mac_address varchar(32),asset_operating_system varchar(256),asset_manufacturer varchar(32),asset_user varchar(32),asset_support_group varchar(32),phone_number varchar(32),email_id varchar(32),license_expiry_date varchar(32),asm_expiry_date varchar(32),serial_number varchar(32),license_serial_number varchar(32),asset_busines_service varchar(32),asset_business_impact varchar(32) );
ALTER TABLE asset_info_default ADD constraint PK_asset_info_default PRIMARY KEY (trgt_host);

create table asset_info_custom (trgt_host varchar(256) not null);
alter table asset_info_custom add constraint FK_asset_info_custom foreign key(trgt_host) references asset_info_default(trgt_host) ON DELETE CASCADE;

DROP TABLE CUSTOMDASHBOARDTEMPLATES;
CREATE TABLE CUSTOMDASHBOARDTEMPLATES(USERID VARCHAR(256) NOT NULL,TEMPLATENAME VARCHAR(2000) NOT NULL,ACCESSTYPE VARCHAR(2048) NOT NULL);

DROP TABLE ALARM;
CREATE TABLE ALARM 
(
	COMP_NAME	    varchar(1024) NOT NULL,
	COMP_TYPE	    varchar(32) NOT NULL,
	LAYER_NAME	    varchar(64) NOT NULL,
	PROBLEM_DESC	    varchar(4000) NOT NULL, 
	PRIORITY	    varchar(32) NOT NULL,
        MSMT_TIME	    datetime NOT NULL,
	ALARM_ID            decimal(18) NOT NULL			
 );

alter table ALARM add constraint PK_ALARM
primary key (ALARM_ID);
CREATE NONCLUSTERED INDEX IDX_ALARM ON ALARM (PRIORITY,COMP_TYPE) INCLUDE ( COMP_NAME, LAYER_NAME, PROBLEM_DESC,MSMT_TIME, ALARM_ID);

DROP TABLE ATGTEST;
CREATE TABLE ATGTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PCT_MEM_USE 	decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_ST 	varchar(32) 	NOT NULL,
	SESSION_RATE 	decimal(20,4) 	NOT NULL,
	SESSION_RATE_ST	varchar(32) 	NOT NULL,
	SESSION_COUNT 	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_ST varchar(32) 	NOT NULL,
	DRP_REQUEST_RATE decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_ST varchar(32) NOT NULL,
	DRP_RESP_RATE decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_ST varchar(32) 	NOT NULL
);

ALTER TABLE ATGTEST ADD constraint PK_ATG
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE ATGTEST_TREND;

CREATE TABLE ATGTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	PCT_MEM_USE_MIN	        decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_MAX	        decimal(20,4) 	NOT NULL,
	PCT_MEM_USE_STCNT 	varchar(32) 	NOT NULL,
	SESSION_RATE_MIN	decimal(20,4) 	NOT NULL,
	SESSION_RATE_MAX	decimal(20,4) 	NOT NULL,
	SESSION_RATE_STCNT 	varchar(32) 	NOT NULL,
	SESSION_COUNT_MIN	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_MAX	decimal(20,4) 	NOT NULL,
	SESSION_COUNT_STCNT 	varchar(32) 	NOT NULL,
	DRP_REQUEST_RATE_MIN	decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_MAX	decimal(20,4) 	NOT NULL,
	DRP_REQUEST_RATE_STCNT 	varchar(32) 	NOT NULL,
	DRP_RESP_RATE_MIN	decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_MAX	decimal(20,4) 	NOT NULL,
	DRP_RESP_RATE_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE ATGTEST_TREND ADD constraint PK_ATG_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ATGTEST_THRESH;

CREATE TABLE ATGTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_MEM_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MEM_USE_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DRP_REQUEST_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DRP_RESP_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DRP_RESP_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ATGTEST_THRESH ADD constraint PK_ATG_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ATGTEST_THRESH ON ATGTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


CREATE  INDEX IDX_ATGTEST ON ATGTEST
(
	 MSMT_TIME
);


DROP TABLE ATGJDBCTEST;

CREATE TABLE ATGJDBCTEST
(
	TRGT_HOST 	varchar(32)	NOT NULL,
	PORT_NO         varchar(32)	NOT NULL,
	SITE_NAME       varchar(64)	NOT NULL,
	INFO            varchar(128)	NOT NULL,
	MSMT_HOST 	varchar(32)	NOT NULL, 
	MSMT_TIME 	datetime	NOT NULL,
	CONN_USE_PCT 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar(32) 	NOT NULL,
	IDLE_CONN_PCT 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_ST varchar(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST ADD constraint PK_ATG_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE INDEX IDX_ATGJDBCTEST ON ATGJDBCTEST
(
	 MSMT_TIME
);

DROP TABLE ATGJDBCTEST_TREND;

CREATE TABLE ATGJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32)	NOT NULL,
	PORT_NO         	varchar(32)	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST 		varchar(32)	NOT NULL, 
	MSMT_TIME		datetime	NOT NULL,
	PERIOD 			varchar(32)	NOT NULL,
	CONN_USE_PCT_MIN 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar(32) 	NOT NULL,
	IDLE_CONN_PCT_MIN 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_MAX 	decimal(20,4) 	NOT NULL,
	IDLE_CONN_PCT_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_TREND ADD constraint PK_ATG_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
 
DROP TABLE ATGJDBCTEST_THRESH ;

CREATE TABLE ATGJDBCTEST_THRESH 
(
	TRGT_HOST	 	varchar(32)	NOT NULL,
	PORT_NO  	       	varchar(32) 	NOT NULL,
	SITE_NAME	        varchar(64)	NOT NULL,
	INFO     	       	varchar(128)	NOT NULL,
	MSMT_HOST	 	varchar(32)	NOT NULL, 
	MSMT_TIME_START		datetime	NOT NULL,
        MSMT_TIME_END  		datetime 	NOT NULL,
	CONN_USE_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	IDLE_CONN_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	IDLE_CONN_PCT_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ATGJDBCTEST_THRESH ADD constraint PK_ATG_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ATGJDBCTEST_THRESH ON ATGJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE CHECKPOINTTEST;

CREATE TABLE CHECKPOINTTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
	PKT_PROCESSING_RATE 	decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_ST 	varchar(32)    NOT NULL,
	PCT_ACC_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_ST 	varchar(32)    NOT NULL,
	PCT_REJ_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_ST 	varchar(32)    NOT NULL,
	PCT_DROP_PKTS 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_ST 	varchar(32)    NOT NULL
);

ALTER TABLE CHECKPOINTTEST ADD CONSTRAINT PK_CHECK_POINT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_CHECKPOINTTEST ON CHECKPOINTTEST
(
	 MSMT_TIME
);

DROP TABLE CHECKPOINTTEST_TREND;
CREATE TABLE CHECKPOINTTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	PKT_PROCESSING_RATE_MIN 		decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_MAX 		decimal(20,4) 	NOT NULL,
	PKT_PROCESSING_RATE_STCNT		varchar(32) NOT NULL,
	PCT_ACC_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_ACC_PKTS_STCNT		varchar(32) NOT NULL,
	PCT_REJ_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_REJ_PKTS_STCNT 		varchar(32) NOT NULL,
	PCT_DROP_PKTS_MIN 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_MAX 		decimal(20,4) 	NOT NULL,
	PCT_DROP_PKTS_STCNT 		varchar(32) NOT NULL
);

ALTER TABLE CHECKPOINTTEST_TREND ADD CONSTRAINT PK_CHECK_POINT_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE CHECKPOINTTEST_THRESH;
CREATE TABLE CHECKPOINTTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	PKT_PROCESSING_RATE_MIN	VARCHAR(256)		NOT NULL,
	PKT_PROCESSING_RATE_MAX	VARCHAR(256)		NOT NULL,
	PCT_ACC_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_ACC_PKTS_MAX	VARCHAR(256)		NOT NULL,
	PCT_REJ_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_REJ_PKTS_MAX	VARCHAR(256)		NOT NULL,
	PCT_DROP_PKTS_MIN	VARCHAR(256)		NOT NULL,
	PCT_DROP_PKTS_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE CHECKPOINTTEST_THRESH ADD CONSTRAINT PK_CHECK_POINT_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CHECKPOINTTEST_THRESH ON CHECKPOINTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CISCOCPUTEST;

CREATE TABLE CISCOCPUTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	UTIL_PCT 	decimal(20,4) 	NOT NULL,
	UTIL_PCT_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST ADD constraint PK_CISCO_CPU
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CISCOCPUTEST ON CISCOCPUTEST (MSMT_TIME) INCLUDE (UTIL_PCT);

DROP TABLE CISCOCPUTEST_TREND;

CREATE TABLE CISCOCPUTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	UTIL_PCT_MIN 		decimal(20,4) 	NOT NULL,
	UTIL_PCT_MAX 		decimal(20,4) 	NOT NULL,
	UTIL_PCT_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_TREND ADD constraint PK_CISCO_CPU_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOCPUTEST_THRESH;

CREATE TABLE CISCOCPUTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	UTIL_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE CISCOCPUTEST_THRESH ADD constraint PK_CISCO_CPU_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOCPUTEST_THRESH ON CISCOCPUTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CISCOMEMORYTEST;
CREATE TABLE CISCOMEMORYTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	USED_PCT 	decimal(20,4) 	NOT NULL,
	USED_PCT_ST 	varchar(32) 	NOT NULL,
	USED_MEMORY	decimal(20,4) 	NOT NULL,
	USED_MEMORY_ST	varchar(32) 	NOT NULL,
	FREE_MEMORY	decimal(20,4) 	NOT NULL,
	FREE_MEMORY_ST	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST ADD constraint PK_CISCO_MEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CISCOMEMORYTEST ON CISCOMEMORYTEST (MSMT_TIME)INCLUDE (USED_PCT);

DROP TABLE CISCOMEMORYTEST_TREND;
CREATE TABLE CISCOMEMORYTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	USED_PCT_MIN 		decimal(20,4) 	NOT NULL,
	USED_PCT_MAX 		decimal(20,4) 	NOT NULL,
	USED_PCT_STCNT 		varchar(32) 	NOT NULL,
	USED_MEMORY_MIN		decimal(20,4) 	NOT NULL,
	USED_MEMORY_MAX		decimal(20,4) 	NOT NULL,
	USED_MEMORY_STCNT	varchar(32) 	NOT NULL,
	FREE_MEMORY_MIN		decimal(20,4) 	NOT NULL,
	FREE_MEMORY_MAX		decimal(20,4) 	NOT NULL,
	FREE_MEMORY_STCNT	varchar(32) 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_TREND ADD constraint PK_CISCO_MEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE CISCOMEMORYTEST_THRESH;
CREATE TABLE CISCOMEMORYTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	USED_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	USED_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	USED_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	USED_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_MEMORY_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE CISCOMEMORYTEST_THRESH ADD constraint PK_CISCO_MEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_CISCOMEMORYTEST_THRESH ON CISCOMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE COLDFUSIONTEST ;

CREATE TABLE COLDFUSIONTEST
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        PAGE_HIT_RATE           decimal(20,4)    NOT NULL, 
	PAGE_HIT_RATE_ST       	varchar(32)  	NOT NULL,
        DB_HIT_RATE 		decimal(20,4)    NOT NULL,
        DB_HIT_RATE_ST 		varchar(32)  	NOT NULL,
        BYTES_IN_RATE           decimal(20,4)    NOT NULL, 
        BYTES_IN_RATE_ST        varchar(32)     NOT NULL,
        BYTES_OUT_RATE          decimal(20,4)    NOT NULL, 
        BYTES_OUT_RATE_ST       varchar(32)     NOT NULL,
        REQUESTS_QUEUED         decimal(20,4)    NOT NULL, 
        REQUESTS_QUEUED_ST      varchar(32)     NOT NULL,
        REQUESTS_RUNNING        decimal(20,4)    NOT NULL, 
       	REQUESTS_RUNNING_ST  	varchar(32)     NOT NULL,
	REQ_TOUT_RATE		decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_ST	varchar(32)	NOT NULL,
	AVG_QUEUE_TIME		decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_ST	varchar(32)	NOT NULL,
        AVG_REQ_TIME        	decimal(20,4)    NOT NULL, 
       	AVG_REQ_TIME_ST  	varchar(32)     NOT NULL,
        AVG_DB_TIME        	decimal(20,4)    NOT NULL, 
       	AVG_DB_TIME_ST  	varchar(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST ADD CONSTRAINT PK_CFTEST_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_COLDFUSIONTEST ON COLDFUSIONTEST
(
	 MSMT_TIME
);

DROP TABLE COLDFUSIONTEST_TREND;
CREATE TABLE COLDFUSIONTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD			varchar(32) NOT NULL, 
        PAGE_HIT_RATE_MIN       decimal(20,4)    NOT NULL, 
        PAGE_HIT_RATE_MAX       decimal(20,4)    NOT NULL,
	PAGE_HIT_RATE_STCNT	varchar(32)     NOT NULL, 
        DB_HIT_RATE_MIN 	decimal(20,4)    NOT NULL,
        DB_HIT_RATE_MAX 	decimal(20,4)    NOT NULL,
	DB_HIT_RATE_STCNT	varchar(32)     NOT NULL,
        BYTES_IN_RATE_MIN       decimal(20,4)    NOT NULL, 
        BYTES_IN_RATE_MAX       decimal(20,4)    NOT NULL, 
	BYTES_IN_RATE_STCNT	varchar(32)     NOT NULL,
        BYTES_OUT_RATE_MIN      decimal(20,4)    NOT NULL, 
        BYTES_OUT_RATE_MAX      decimal(20,4)    NOT NULL, 
	BYTES_OUT_RATE_STCNT	varchar(32)     NOT NULL,
        REQUESTS_QUEUED_MIN     decimal(20,4)    NOT NULL, 
        REQUESTS_QUEUED_MAX     decimal(20,4)    NOT NULL, 
	REQUESTS_QUEUED_STCNT	varchar(32)     NOT NULL,
        REQUESTS_RUNNING_MIN    decimal(20,4)    NOT NULL, 
        REQUESTS_RUNNING_MAX    decimal(20,4)    NOT NULL, 
	REQUESTS_RUNNING_STCNT	varchar(32)     NOT NULL,
	REQ_TOUT_RATE_MIN	decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_MAX	decimal(20,4)   	NOT NULL,
	REQ_TOUT_RATE_STCNT	varchar(32)     NOT NULL,
	AVG_QUEUE_TIME_MIN	decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_MAX	decimal(20,4)   	NOT NULL,
	AVG_QUEUE_TIME_STCNT	varchar(32)     NOT NULL,
        AVG_REQ_TIME_MIN       	decimal(20,4)    NOT NULL, 
        AVG_REQ_TIME_MAX       	decimal(20,4)    NOT NULL, 
	AVG_REQ_TIME_STCNT	varchar(32)     NOT NULL,
        AVG_DB_TIME_MIN        	decimal(20,4)    NOT NULL, 
        AVG_DB_TIME_MAX        	decimal(20,4)    NOT NULL, 
	AVG_DB_TIME_STCNT	varchar(32)     NOT NULL
);

ALTER TABLE COLDFUSIONTEST_TREND ADD CONSTRAINT PK_CFTEST_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE COLDFUSIONTEST_THRESH;
CREATE TABLE COLDFUSIONTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(64) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PAGE_HIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        PAGE_HIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        DB_HIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        DB_HIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        BYTES_IN_RATE_MIN	VARCHAR(256)	    NOT NULL,
        BYTES_IN_RATE_MAX	VARCHAR(256)	    NOT NULL,
        BYTES_OUT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        BYTES_OUT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        REQUESTS_QUEUED_MIN	VARCHAR(256)	    NOT NULL,
        REQUESTS_QUEUED_MAX	VARCHAR(256)	    NOT NULL,
        REQUESTS_RUNNING_MIN	VARCHAR(256)	    NOT NULL,
        REQUESTS_RUNNING_MAX	VARCHAR(256)	    NOT NULL,
	REQ_TOUT_RATE_MIN	VARCHAR(256)	   	NOT NULL,
	REQ_TOUT_RATE_MAX	VARCHAR(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR(256)	   	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR(256)	   	NOT NULL,
        AVG_REQ_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_REQ_TIME_MAX	VARCHAR(256)	    NOT NULL,
        AVG_DB_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_DB_TIME_MAX	VARCHAR(256)	    NOT NULL
);

ALTER TABLE COLDFUSIONTEST_THRESH ADD CONSTRAINT PK_CFTEST_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_COLDFUSIONTEST_THRESH ON COLDFUSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DISKTEST;
CREATE TABLE DISKTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	UTIL_PCT	decimal(20,4) 	NOT NULL,
	UTIL_PCT_ST	varchar(32)    NOT NULL,
	READ_RATE 	decimal(20,4) 	NOT NULL,
	READ_RATE_ST 	varchar(32)    NOT NULL,
	WRITE_RATE 	decimal(20,4) 	NOT NULL,
	WRITE_RATE_ST 	varchar(32)    NOT NULL,
	BYTES_READ_RATE 	decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_ST 	varchar(32)    NOT NULL,
	BYTES_WRITE_RATE 	decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE DISKTEST ADD constraint PK_DISK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DISKTEST ON DISKTEST
(
	 MSMT_TIME
);

DROP TABLE DISKTEST_TREND;

CREATE TABLE DISKTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	UTIL_PCT_MIN		decimal(20,4) 	NOT NULL,
	UTIL_PCT_MAX		decimal(20,4) 	NOT NULL,
	UTIL_PCT_STCNT		varchar(32)   	NOT NULL,
	READ_RATE_MIN 		decimal(20,4) 	NOT NULL,
	READ_RATE_MAX 		decimal(20,4) 	NOT NULL,
	READ_RATE_STCNT 	varchar(32)   	NOT NULL,
	WRITE_RATE_MIN 		decimal(20,4) 	NOT NULL,
	WRITE_RATE_MAX 		decimal(20,4) 	NOT NULL,
	WRITE_RATE_STCNT 	varchar(32)   	NOT NULL,
	BYTES_READ_RATE_MIN 		decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_MAX 		decimal(20,4) 	NOT NULL,
	BYTES_READ_RATE_STCNT 	varchar(32)   	NOT NULL,
	BYTES_WRITE_RATE_MIN 		decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_MAX 		decimal(20,4) 	NOT NULL,
	BYTES_WRITE_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE DISKTEST_TREND ADD constraint PK_DISK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DISKTEST_THRESH;

CREATE TABLE DISKTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	UTIL_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	UTIL_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	BYTES_READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	BYTES_READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	BYTES_WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE DISKTEST_THRESH ADD constraint PK_DISK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DISKTEST_THRESH ON DISKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE DNSTEST;

CREATE TABLE DNSTEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO   	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	AVAILABLE 	decimal(3)  	NOT NULL,
	AVAILABLE_ST 	varchar(32)   	NOT NULL,
	RESP_TIME 	decimal(20,4) 	NOT NULL,
	RESP_TIME_ST	varchar(32) 	NOT NULL
);

alter table DNSTEST add constraint PK_DNS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DNSTEST ON DNSTEST
(
	 MSMT_TIME
);

DROP TABLE DNSTEST_TREND;

CREATE TABLE DNSTEST_TREND
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO   			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD				varchar(32) NOT NULL,
	AVAILABLE_MIN 			decimal(20,4)  	NOT NULL,
	AVAILABLE_MAX 			decimal(20,4)  	NOT NULL,
	AVAILABLE_STCNT 		varchar(32)   	NOT NULL,
	RESP_TIME_MIN 			decimal(20,4) 	NOT NULL,
	RESP_TIME_MAX 			decimal(20,4) 	NOT NULL,
	RESP_TIME_STCNT			varchar(32) 	NOT NULL
);

alter table DNSTEST_TREND add constraint PK_DNS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE DNSTEST_THRESH;

CREATE TABLE DNSTEST_THRESH
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO   	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL, 
	AVAILABLE_MIN	VARCHAR(256)	    NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	    NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	 NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	 NOT NULL
);

alter table DNSTEST_THRESH add constraint PK_DNS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DNSTEST_THRESH ON DNSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  



DROP TABLE EG_HELP_REF;

CREATE TABLE EG_HELP_REF 
(
        PAGE_REF      varchar(128) NOT NULL,
        ID            decimal
);

ALTER TABLE EG_HELP_REF ADD CONSTRAINT PK_EG_HELP_REF 
PRIMARY KEY (PAGE_REF) ;
DROP TABLE ERR_TBL;

CREATE TABLE ERR_TBL 
(
      TRGT_HOST            varchar(32) NOT NULL,
      PORT_NO              varchar(32) NOT NULL,
      SITE_NAME            varchar(64) NOT NULL,
      INFO                 varchar(128) NOT NULL,
      MSMT_TIME            datetime NOT NULL,
      TEST_NAME            varchar(128) NOT NULL,
      MSMT_NAME            varchar(128) NOT NULL,
      MSMT_HOST            varchar(32)  NOT NULL,
      STATE                varchar(32)  NOT NULL
);
      
alter table ERR_TBL add constraint PK_ERRTBLE
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO,TEST_NAME,MSMT_NAME,MSMT_HOST);
create index idx_err_tbl on err_tbl(site_name);

DROP TABLE FIXTABLE;

CREATE TABLE FIXTABLE 
(
        SITE_NAME            	varchar(64) NOT NULL,
        COMP_NAME            	varchar(64) NOT NULL,
        COMP_TYPE            	varchar(32) NOT NULL,
        INFO                 	varchar(128) NOT NULL,
        TEST_NAME           		varchar(64) NOT NULL,
        MEASURE            	varchar(64) NOT NULL,
	MSMT_TIME            	datetime NOT NULL,
	FIX_date            	datetime NOT NULL,
	PROB_REASON            	varchar(4000)    NOT NULL,
	PROB_FIX            	varchar(4000)    NOT NULL,
	PROB_FIXED_BY           varchar(600)    NOT NULL
);

ALTER TABLE FIXTABLE ADD CONSTRAINT PK_FIXTABLE 
PRIMARY KEY (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME) ;
create index idx_fixtable on fixtable (site_name);
DROP TABLE FTPTEST;

CREATE TABLE FTPTEST
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	AVAILABILITY			decimal(3)	      NOT NULL,
	AVAILABILITY_ST			varchar(32)	NOT NULL,
	TOT_RESPONSE_TIME 		decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_ST 		varchar(32)	NOT NULL,
	TCP_AVAIL			decimal(3)		NOT NULL,
	TCP_AVAIL_ST			varchar(32)	NOT NULL,
	TCP_CONN_TIME			decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_ST 		varchar(23)	NOT NULL,
	AUTHENTICATE_STATUS		decimal(3)		NOT NULL,
	AUTHENTICATE_STATUS_ST  	varchar(32)	NOT NULL,
	AUTHENTICATE_TIME		decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_ST		varchar(32)	NOT NULL
);

ALTER TABLE FTPTEST ADD constraint PK_FTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_FTPTEST ON FTPTEST
(
	 MSMT_TIME
);

DROP TABLE FTPTEST_TREND;

CREATE TABLE FTPTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	AVAILABILITY_MIN		decimal(20,4)		NOT NULL,	
	AVAILABILITY_MAX		decimal(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar(32)	NOT NULL,
	TOT_RESPONSE_TIME_MIN	decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_MAX	decimal(20,4)		NOT NULL,
	TOT_RESPONSE_TIME_STCNT	varchar(32)	NOT NULL,
	TCP_AVAIL_MIN		decimal(20,4)		NOT NULL,
	TCP_AVAIL_MAX		decimal(20,4)		NOT NULL,
	TCP_AVAIL_STCNT		varchar(32)	NOT NULL,
	TCP_CONN_TIME_MIN		decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_MAX	decimal(20,4)		NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)	NOT NULL,
	AUTHENTICATE_STATUS_MIN	decimal(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_MAX	decimal(20,4)		NOT NULL,
	AUTHENTICATE_STATUS_STCNT varchar(32)    NOT NULL,
	AUTHENTICATE_TIME_MIN	decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_MAX	decimal(20,4)		NOT NULL,
	AUTHENTICATE_TIME_STCNT varchar(32)	NOT NULL
);

ALTER TABLE FTPTEST_TREND ADD constraint PK_FTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE FTPTEST_THRESH;

CREATE TABLE FTPTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)			NOT NULL,
	TOT_RESPONSE_TIME_MIN	VARCHAR(256)			NOT NULL,
	TOT_RESPONSE_TIME_MAX	VARCHAR(256)			NOT NULL,
	TCP_AVAIL_MIN	VARCHAR(256)			NOT NULL,
	TCP_AVAIL_MAX	VARCHAR(256)			NOT NULL,
	TCP_CONN_TIME_MIN	VARCHAR(256)			NOT NULL,
	TCP_CONN_TIME_MAX	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_STATUS_MIN	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_STATUS_MAX	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_TIME_MIN	VARCHAR(256)			NOT NULL,
	AUTHENTICATE_TIME_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE FTPTEST_THRESH ADD constraint PK_FTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_FTPTEST_THRESH ON FTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE HTTPTEST;
CREATE TABLE HTTPTEST 
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL  	decimal(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar(32)     	NOT NULL,
	TCP_CONN_TIME   	decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar(32)  	NOT NULL,
	SVR_RESP_TIME   	decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar(32)  	NOT NULL,
	CONTENT_VAL   		decimal(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar(32)  	NOT NULL,
	RESP_CODE   		decimal(3)  	NOT NULL,
	RESP_CODE_ST   		varchar(32)  	NOT NULL,
	CONTENT_LEN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar(32)  	NOT NULL,
	DATA_XFER_TIME   	decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar(32)  	NOT NULL,
	DNS_AVAILABILITY   	decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar(32)  	NOT NULL
);

alter table HTTPTEST add constraint PK_HTTP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_HTTPTEST ON HTTPTEST (MSMT_TIME) INCLUDE (AVAILABLE,RESP_TIME);

DROP TABLE HTTPTEST_TREND;
CREATE TABLE HTTPTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		decimal(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		decimal(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_VAL_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar(32)  	NOT NULL,
	RESP_CODE_MIN  			decimal(20,4)  	NOT NULL,
	RESP_CODE_MAX  			decimal(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_LEN_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_MAX  		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT 	  	varchar(32)  	NOT NULL,
	DATA_XFER_TIME_MIN		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX  		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT 		varchar(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX  		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT 	  	varchar(32)  	NOT NULL
);

alter table HTTPTEST_TREND add constraint PK_HTTP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPTEST_THRESH;
CREATE TABLE HTTPTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
	CONTENT_VAL_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_VAL_MAX	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MIN	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MAX	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MAX	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MAX	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MAX	VARCHAR(256)	  	NOT NULL
	
);

alter table HTTPTEST_THRESH add constraint PK_HTTP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_HTTPTEST_THRESH ON HTTPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE HTTPPOSTTEST;
CREATE TABLE HTTPPOSTTEST 
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL  	decimal(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar(32)     	NOT NULL,
	TCP_CONN_TIME   	decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar(32)  	NOT NULL,
	SVR_RESP_TIME   	decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar(32)  	NOT NULL,
	CONTENT_VAL   		decimal(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar(32)  	NOT NULL,
	RESP_CODE   		decimal(3)  	NOT NULL,
	RESP_CODE_ST   		varchar(32)  	NOT NULL,
	CONTENT_LEN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar(32)  	NOT NULL,
	DATA_XFER_TIME   	decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar(32)  	NOT NULL,
	DNS_AVAILABILITY   	decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar(32)  	NOT NULL
);

alter table HTTPPOSTTEST add constraint PK_HTTPPOST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_HTTPPOSTTEST ON HTTPPOSTTEST
(
	 MSMT_TIME
);

DROP TABLE HTTPPOSTTEST_TREND;
CREATE TABLE HTTPPOSTTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		decimal(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		decimal(20,4)     	NOT NULL,	
        TCP_CONN_AVAIL_STCNT		varchar(32)    NOT NULL,
	TCP_CONN_TIME_MIN   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_MAX   		decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_STCNT		varchar(32)  	NOT NULL,
	SVR_RESP_TIME_MIN   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_MAX   		decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_VAL_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_MAX   		decimal(20,4)  	NOT NULL,
	CONTENT_VAL_STCNT   		varchar(32)  	NOT NULL,
	RESP_CODE_MIN  			decimal(20,4)  	NOT NULL,
	RESP_CODE_MAX  			decimal(20,4)  	NOT NULL,
	RESP_CODE_STCNT   		varchar(32)  	NOT NULL,
	CONTENT_LEN_MIN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_MAX  		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_STCNT 	  	varchar(32)  	NOT NULL,
	DATA_XFER_TIME_MIN		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_MAX  		decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_STCNT 		varchar(32)  	NOT NULL,
	DNS_AVAILABILITY_MIN   		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_MAX  		decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_STCNT 	  	varchar(32)  	NOT NULL
);

alter table HTTPPOSTTEST_TREND add constraint PK_HTTPPOST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE HTTPPOSTTEST_THRESH;

CREATE TABLE HTTPPOSTTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_CONN_AVAIL_MIN	VARCHAR(256)	     NOT NULL,
        TCP_CONN_AVAIL_MAX	VARCHAR(256)	     NOT NULL,
        TCP_CONN_TIME_MIN	VARCHAR(256)	  NOT NULL,
        TCP_CONN_TIME_MAX	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        SVR_RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
	CONTENT_VAL_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_VAL_MAX	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MIN	VARCHAR(256)	  	NOT NULL,
	RESP_CODE_MAX	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MIN	VARCHAR(256)	  	NOT NULL,
	CONTENT_LEN_MAX	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MIN	VARCHAR(256)	  	NOT NULL,
	DATA_XFER_TIME_MAX	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MIN	VARCHAR(256)	  	NOT NULL,
	DNS_AVAILABILITY_MAX	VARCHAR(256)	  	NOT NULL
	
);

alter table HTTPPOSTTEST_THRESH add constraint PK_HTTPPOST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_HTTPPOSTTEST_THRESH ON HTTPPOSTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE LDAPTEST;
CREATE TABLE LDAPTEST
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST       	varchar(32)  	NOT NULL,
	TCP_AVAIL       	decimal(3)  	NOT NULL,
	TCP_AVAIL_ST       	varchar(32)  	NOT NULL,
	CURR_CONN		decimal(20,4)    	NOT NULL,
	CURR_CONN_ST		varchar(32)    	NOT NULL,
	CONN_RATE 		decimal(20,4)  	NOT NULL,
	CONN_RATE_ST 		varchar(32)  	NOT NULL,
	BYTE_RATE_OUT   	decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_ST   	varchar(32)  	NOT NULL,
	OUT_STND_OPNS		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_ST	varchar(32)    	NOT NULL
);

alter table LDAPTEST add constraint PK_LDAP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDAPTEST ON LDAPTEST
(
	 MSMT_TIME
);

DROP TABLE LDAPTEST_TREND;

CREATE TABLE LDAPTEST_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 	
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT   		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT       		varchar(32)  	NOT NULL,
	TCP_AVAIL_MIN		       	decimal(20,4)  	NOT NULL,
	TCP_AVAIL_MAX			decimal(20,4)	NOT NULL,
	TCP_AVAIL_STCNT       		varchar(32)  	NOT NULL,
	CURR_CONN_MIN			decimal(20,4)    	NOT NULL,
	CURR_CONN_MAX			decimal(20,4)    	NOT NULL,
	CURR_CONN_STCNT			varchar(32)    NOT NULL,
	CONN_RATE_MIN	 		decimal(20,4)  	NOT NULL,
	CONN_RATE_MAX 			decimal(20,4)  	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)  	NOT NULL,
	BYTE_RATE_OUT_MIN   		decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_MAX   		decimal(20,4)  	NOT NULL,
	BYTE_RATE_OUT_STCNT   		varchar(32)  	NOT NULL,
	OUT_STND_OPNS_MIN		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_MAX		decimal(20,4)    	NOT NULL,
	OUT_STND_OPNS_STCNT		varchar(32)    NOT NULL
);

alter table LDAPTEST_TREND add constraint PK_LDAP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDAPTEST_THRESH;

CREATE TABLE LDAPTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABLE_MIN	VARCHAR(256)	     NOT NULL,
        AVAILABLE_MAX	VARCHAR(256)	     NOT NULL,
        RESP_TIME_MIN	VARCHAR(256)	  NOT NULL,
        RESP_TIME_MAX	VARCHAR(256)	  NOT NULL,
        TCP_AVAIL_MIN	VARCHAR(256)	  NOT NULL,
        TCP_AVAIL_MAX	VARCHAR(256)	  NOT NULL,
        CURR_CONN_MIN	VARCHAR(256)	    NOT NULL,
        CURR_CONN_MAX	VARCHAR(256)	    NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	  NOT NULL,
        CONN_RATE_MAX	VARCHAR(256)	  NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	  NOT NULL,
        BYTE_RATE_OUT_MAX	VARCHAR(256)	  NOT NULL,
        OUT_STND_OPNS_MIN	VARCHAR(256)	    NOT NULL,
        OUT_STND_OPNS_MAX	VARCHAR(256)	    NOT NULL
);

alter table LDAPTEST_THRESH add constraint PK_LDAP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDAPTEST_THRESH ON LDAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       
DROP TABLE LDREALSERVERTEST;

CREATE TABLE LDREALSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	STATE		decimal(20,4) 	NOT NULL,
	STATE_ST	varchar(32)    NOT NULL,
	CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	DATA_RATE 	decimal(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE LDREALSERVERTEST ADD constraint PK_REAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDREALSERVERTEST ON LDREALSERVERTEST
(
	 MSMT_TIME
);


DROP TABLE LDREALSERVERTEST_TREND;

CREATE TABLE LDREALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	STATE_MIN		decimal(20,4) 	NOT NULL,
	STATE_MAX		decimal(20,4) 	NOT NULL,
	STATE_STCNT		varchar(32)   	NOT NULL,
	CONN_RATE_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar(32)   	NOT NULL,
	DATA_RATE_MIN 		decimal(20,4) 	NOT NULL,
	DATA_RATE_MAX 		decimal(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_TREND ADD constraint PK_REAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDREALSERVERTEST_THRESH;

CREATE TABLE LDREALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	STATE_MIN	VARCHAR(256)	 	NOT NULL,
	STATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE LDREALSERVERTEST_THRESH ADD constraint PK_REAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDREALSERVERTEST_THRESH ON LDREALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE LDVIRTUALSERVERTEST;

CREATE TABLE LDVIRTUALSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	STATE		decimal(20,4) 	NOT NULL,
	STATE_ST	varchar(32)    NOT NULL,
	CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	DATA_RATE 	decimal(20,4) 	NOT NULL,
	DATA_RATE_ST 	varchar(32)    NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST ADD constraint PK_VIRTUAL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_LDVIRTUALSERVERTEST ON LDVIRTUALSERVERTEST
(
	 MSMT_TIME
);


DROP TABLE LDVIRTUALSERVERTEST_TREND;

CREATE TABLE LDVIRTUALSERVERTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	STATE_MIN		decimal(20,4) 	NOT NULL,
	STATE_MAX		decimal(20,4) 	NOT NULL,
	STATE_STCNT		varchar(32)   	NOT NULL,
	CONN_RATE_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 	varchar(32)   	NOT NULL,
	DATA_RATE_MIN 		decimal(20,4) 	NOT NULL,
	DATA_RATE_MAX 		decimal(20,4) 	NOT NULL,
	DATA_RATE_STCNT 	varchar(32)   	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_TREND ADD constraint PK_VIRTUAL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE LDVIRTUALSERVERTEST_THRESH;

CREATE TABLE LDVIRTUALSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	STATE_MIN	VARCHAR(256)	 	NOT NULL,
	STATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE LDVIRTUALSERVERTEST_THRESH ADD constraint PK_VIRTUAL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_LDVIRTUALSERVERTEST_THRESH ON LDVIRTUALSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);        
DROP TABLE MAILTEST;

CREATE TABLE MAILTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        SMTP_AVAIL           decimal(3)    NOT NULL,
        SMTP_AVAIL_ST        varchar(32)    NOT NULL,
        POP3_AVAIL           decimal(3)    NOT NULL,
        POP3_AVAIL_ST        varchar(32)    NOT NULL,
        OUT_MAIL             decimal(20,4)    NOT NULL,
        OUT_MAIL_ST          varchar(32)    NOT NULL,
        RT_DELAY             decimal(20,4)    NOT NULL,
        RT_DELAY_ST          varchar(32)    NOT NULL
);

alter table MAILTEST add constraint PK_MAILTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MAILTEST ON MAILTEST
(
	 MSMT_TIME
);

DROP TABLE MAILTEST_TREND;

CREATE TABLE MAILTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        SMTP_AVAIL_MIN           	decimal(20,4)    NOT NULL,
        SMTP_AVAIL_MAX           	decimal(20,4)    NOT NULL,
        SMTP_AVAIL_STCNT        	varchar(32)    NOT NULL,
        POP3_AVAIL_MIN          	decimal(20,4)    NOT NULL,
        POP3_AVAIL_MAX           	decimal(20,4)    NOT NULL,
        POP3_AVAIL_STCNT        	varchar(32)    NOT NULL,
        OUT_MAIL_MIN                    decimal(20,4)    NOT NULL,
        OUT_MAIL_MAX             	decimal(20,4)    NOT NULL,
        OUT_MAIL_STCNT          	varchar(32)    NOT NULL,
        RT_DELAY_MIN              	decimal(20,4)    NOT NULL,
        RT_DELAY_MAX             	decimal(20,4)    NOT NULL,
        RT_DELAY_STCNT          	varchar(32)    NOT NULL
);


alter table MAILTEST_TREND add constraint PK_MAILTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MAILTEST_THRESH;

CREATE TABLE MAILTEST_THRESH 
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        SMTP_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
        SMTP_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
        POP3_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
        POP3_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
        OUT_MAIL_MIN	VARCHAR(256)	    NOT NULL,
        OUT_MAIL_MAX	VARCHAR(256)	    NOT NULL,
        RT_DELAY_MIN	VARCHAR(256)	    NOT NULL,
        RT_DELAY_MAX	VARCHAR(256)	    NOT NULL
);

alter table MAILTEST_THRESH add constraint PK_MAILTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MAILTEST_THRESH ON MAILTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE METATEST ;
CREATE TABLE METATEST 
(
        COMP_NAME          varchar(64) NOT NULL,
	COMP_TYPE		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST		varchar(64) NOT NULL,
        TEST_NAME               varchar(128) NOT NULL,
        MSMT_TIME 		datetime
);
 	
ALTER TABLE METATEST ADD CONSTRAINT PK_METATEST
PRIMARY KEY (COMP_NAME,COMP_TYPE,SITE_NAME,INFO,MSMT_HOST,TEST_NAME);

CREATE INDEX IDX_METATEST ON METATEST(SITE_NAME,INFO);  
CREATE NONCLUSTERED INDEX IDX1_METATEST ON METATEST ( TEST_NAME ) INCLUDE ( COMP_NAME, COMP_TYPE, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);
DROP TABLE MSMQTEST;

CREATE TABLE MSMQTEST
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	IN_MSG_RATE		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_ST		varchar(32)	NOT NULL,	
	OUT_MSG_RATE		decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_ST		varchar(32)	NOT NULL,
	CURRENT_SESSIONS	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_ST	varchar(32)	NOT NULL,
	ERROR_MSG_CNT		decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_ST	varchar(32)	NOT NULL,
	TOTAL_NO_MSGS		decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_ST	varchar(32)	NOT NULL,
	GROWTH_RATE		decimal(20,4)	NOT NULL,
	GROWTH_RATE_ST		varchar(32)	NOT NULL,
	IP_SESSION	decimal(20,4)	NOT NULL,
	IP_SESSION_ST	varchar(32)	NOT NULL,
	IN_MULTICAST_SESSION	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_ST	VARCHAR(32)	NOT NULL,
	MSMQ_IN_MSG	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_ST VARCHAR(32)	NOT NULL,
	MSMQ_OUT_MSG	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_ST	VARCHAR(32)	NOT NULL,
	OUT_HTTP_SESSION	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_ST	VARCHAR(32)	NOT NULL,
	OUT_MULTICAST_SESSION decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_ST VARCHAR(32)	NOT NULL,
	TOT_BYTES	decimal(20,4)	NOT NULL,
	TOT_BYTES_ST VARCHAR(32)	NOT NULL
);

ALTER TABLE MSMQTEST ADD constraint PK_MSMQ
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSMQTEST ON MSMQTEST
(
	 MSMT_TIME
);

DROP TABLE MSMQTEST_TREND;

CREATE TABLE MSMQTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	IN_MSG_RATE_MIN		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_MAX		decimal(20,4)	NOT NULL,	
	IN_MSG_RATE_STCNT	varchar(32)	NOT NULL,	
	OUT_MSG_RATE_MIN	decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_MAX	decimal(20,4)	NOT NULL,
	OUT_MSG_RATE_STCNT	varchar(32)	NOT NULL,
	CURRENT_SESSIONS_MIN	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_MAX	decimal(20,4)	NOT NULL,
	CURRENT_SESSIONS_STCNT	varchar(32)	NOT NULL,
	ERROR_MSG_CNT_MIN	decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_MAX	decimal(20,4)	NOT NULL,
	ERROR_MSG_CNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_NO_MSGS_MIN	decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_MAX	decimal(20,4)	NOT NULL,
	TOTAL_NO_MSGS_STCNT	varchar(32)	NOT NULL,
	GROWTH_RATE_MIN		decimal(20,4)	NOT NULL,
	GROWTH_RATE_MAX		decimal(20,4)	NOT NULL,
	GROWTH_RATE_STCNT	varchar(32)	NOT NULL,
	IP_SESSION_MIN	decimal(20,4)	NOT NULL,
	IP_SESSION_MAX	decimal(20,4)	NOT NULL,
	IP_SESSION_STCNT	varchar(32)	NOT NULL,
	IN_MULTICAST_SESSION_MIN	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_MAX	decimal(20,4)	NOT NULL,
	IN_MULTICAST_SESSION_STCNT	VARCHAR(32)	NOT NULL,
	MSMQ_IN_MSG_MIN	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_MAX	decimal(20,4)	NOT NULL,
	MSMQ_IN_MSG_STCNT VARCHAR(32)	NOT NULL,
	MSMQ_OUT_MSG_MIN	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_MAX	decimal(20,4)	NOT NULL,
	MSMQ_OUT_MSG_STCNT	VARCHAR(32)	NOT NULL,
	OUT_HTTP_SESSION_MIN	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_MAX	decimal(20,4)	NOT NULL,
	OUT_HTTP_SESSION_STCNT	VARCHAR(32)	NOT NULL,
	OUT_MULTICAST_SESSION_MIN decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_MAX decimal(20,4)	NOT NULL,
	OUT_MULTICAST_SESSION_STCNT VARCHAR(32)	NOT NULL,
	TOT_BYTES_MIN	decimal(20,4)	NOT NULL,
	TOT_BYTES_MAX	decimal(20,4)	NOT NULL,
	TOT_BYTES_STCNT VARCHAR(32)	NOT NULL
);

ALTER TABLE MSMQTEST_TREND ADD constraint PK_MSMQ_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSMQTEST_THRESH;

CREATE TABLE MSMQTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME        	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
      	MSMT_TIME_END   	datetime NOT NULL,
	IN_MSG_RATE_MIN	VARCHAR(256)		NOT NULL,
	IN_MSG_RATE_MAX	VARCHAR(256)		NOT NULL,
	OUT_MSG_RATE_MIN	VARCHAR(256)		NOT NULL,
	OUT_MSG_RATE_MAX	VARCHAR(256)		NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR(256)		NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR(256)		NOT NULL,
	ERROR_MSG_CNT_MIN	VARCHAR(256)		NOT NULL,
	ERROR_MSG_CNT_MAX	VARCHAR(256)		NOT NULL,
	TOTAL_NO_MSGS_MIN	VARCHAR(256)		NOT NULL,
	TOTAL_NO_MSGS_MAX	VARCHAR(256)		NOT NULL,
	GROWTH_RATE_MIN	VARCHAR(256)		NOT NULL,
	GROWTH_RATE_MAX	VARCHAR(256)		NOT NULL,
	IP_SESSION_MIN	VARCHAR(256)		NOT NULL,
	IP_SESSION_MAX	VARCHAR(256)		NOT NULL,
	IN_MULTICAST_SESSION_MIN	VARCHAR(256)		NOT NULL,
	IN_MULTICAST_SESSION_MAX	VARCHAR(256)		NOT NULL,
	MSMQ_IN_MSG_MIN	VARCHAR(256)		NOT NULL,
	MSMQ_IN_MSG_MAX	VARCHAR(256)		NOT NULL,
	MSMQ_OUT_MSG_MIN	VARCHAR(256)		NOT NULL,
	MSMQ_OUT_MSG_MAX	VARCHAR(256)		NOT NULL,
	OUT_HTTP_SESSION_MIN	VARCHAR(256)		NOT NULL,
	OUT_HTTP_SESSION_MAX	VARCHAR(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MIN VARCHAR(256)		NOT NULL,
	OUT_MULTICAST_SESSION_MAX VARCHAR(256)		NOT NULL,
	TOT_BYTES_MIN	VARCHAR(256)		NOT NULL,
	TOT_BYTES_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE MSMQTEST_THRESH ADD constraint PK_MSMQ_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSMQTEST_THRESH ON MSMQTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);                  
DROP TABLE MSSQLBUFFERTEST;

CREATE TABLE MSSQLBUFFERTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	BUFFER_CHEHIT_RT	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_ST	varchar(32)    NOT NULL,
	PAGE_RD			decimal(20,4)    NOT NULL,	
	PAGE_RD_ST		varchar(32)    NOT NULL,
	PAGE_WRT_RT		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_ST		varchar(32)    NOT NULL,
	CACHE_HTRT		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_ST		varchar(32)    NOT NULL,
	CACHE_OBJCT		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_ST		varchar(32)    NOT NULL,
	LOG_CACHITRT		decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_ST		varchar(32)    NOT NULL
	);
												
alter table MSSQLBUFFERTEST add constraint PK_MSSQLBUFFERTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSSQLBUFFERTEST ON MSSQLBUFFERTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLBUFFERTEST_TREND;

CREATE TABLE MSSQLBUFFERTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	BUFFER_CHEHIT_RT_MIN	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_MAX	decimal(20,4)    NOT NULL,	
	BUFFER_CHEHIT_RT_STCNT	varchar(32)    NOT NULL,
	PAGE_RD_MIN		decimal(20,4)    NOT NULL,	
	PAGE_RD_MAX		decimal(20,4)    NOT NULL,	
	PAGE_RD_STCNT		varchar(32)    NOT NULL,
	PAGE_WRT_RT_MIN		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_MAX		decimal(20,4)    NOT NULL,	
	PAGE_WRT_RT_STCNT	varchar(32)    NOT NULL,
	CACHE_HTRT_MIN		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_MAX		decimal(20,4)    NOT NULL,	
	CACHE_HTRT_STCNT	varchar(32)    NOT NULL,
	CACHE_OBJCT_MIN		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_MAX		decimal(20,4)    NOT NULL,	
	CACHE_OBJCT_STCNT	varchar(32)    NOT NULL,
	LOG_CACHITRT_MIN	decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_MAX	decimal(20,4)    NOT NULL,	
	LOG_CACHITRT_STCNT	varchar(32)    NOT NULL
);

alter table MSSQLBUFFERTEST_TREND add constraint PK_MSSQLBUFFERTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLBUFFERTEST_THRESH;

CREATE TABLE MSSQLBUFFERTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        BUFFER_CHEHIT_RT_MIN	VARCHAR(256)	    NOT NULL,
	BUFFER_CHEHIT_RT_MAX	VARCHAR(256)	    NOT NULL,
	PAGE_RD_MIN	VARCHAR(256)	    NOT NULL,
	PAGE_RD_MAX	VARCHAR(256)	    NOT NULL,
	PAGE_WRT_RT_MIN	VARCHAR(256)	    NOT NULL,
	PAGE_WRT_RT_MAX	VARCHAR(256)	    NOT NULL,
	CACHE_HTRT_MIN	VARCHAR(256)	    NOT NULL,
	CACHE_HTRT_MAX	VARCHAR(256)	    NOT NULL,
	CACHE_OBJCT_MIN	VARCHAR(256)	    NOT NULL,
	CACHE_OBJCT_MAX	VARCHAR(256)	    NOT NULL,
	LOG_CACHITRT_MIN	VARCHAR(256)	    NOT NULL,
	LOG_CACHITRT_MAX	VARCHAR(256)	    NOT NULL
	);

alter table MSSQLBUFFERTEST_THRESH add constraint PK_MSSQLBUFFERTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MSSQLBUFFERTEST_THRESH ON MSSQLBUFFERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLLOCKTEST;
CREATE TABLE MSSQLLOCKTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	AVG_WTTIME		decimal(20,4) NOT NULL,	
	AVG_WTTIME_ST		varchar(32) NOT NULL,
	LOCK_REQ		decimal(20,4) NOT NULL,	
	LOCK_REQ_ST		varchar(32) NOT NULL,
	LOCK_WAIT		decimal(20,4) NOT NULL,	
	LOCK_WAIT_ST		varchar(32) NOT NULL,
	NUM_DEADLOCK		decimal(20,4) NOT NULL,	
	NUM_DEADLOCK_ST		varchar(32) NOT NULL,
	LOCK_TIMEOUTS		decimal(20,4) NOT NULL,	
	LOCK_TIMEOUTS_ST	varchar(32) NOT NULL	);

alter table MSSQLLOCKTEST add constraint PK_MSSQLLOCKTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_MSSQLLOCKTEST ON MSSQLLOCKTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLLOCKTEST_TREND;

CREATE TABLE MSSQLLOCKTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	AVG_WTTIME_MIN			decimal(20,4) NOT NULL,
	AVG_WTTIME_MAX			decimal(20,4) NOT NULL,
	AVG_WTTIME_STCNT		varchar(32) NOT NULL,
	LOCK_REQ_MIN			decimal(20,4) NOT NULL,
	LOCK_REQ_MAX			decimal(20,4) NOT NULL,
	LOCK_REQ_STCNT			varchar(32) NOT NULL,
	LOCK_WAIT_MIN			decimal(20,4) NOT NULL,
	LOCK_WAIT_MAX			decimal(20,4) NOT NULL,
	LOCK_WAIT_STCNT			varchar(32) NOT NULL,
	NUM_DEADLOCK_MIN		decimal(20,4) NOT NULL,
	NUM_DEADLOCK_MAX		decimal(20,4) NOT NULL,
	NUM_DEADLOCK_STCNT		varchar(32) NOT NULL,
	LOCK_TIMEOUTS_MIN		decimal(20,4) NOT NULL,
	LOCK_TIMEOUTS_MAX		decimal(20,4) NOT NULL,
	LOCK_TIMEOUTS_STCNT		varchar(32) NOT NULL);


alter table MSSQLLOCKTEST_TREND add constraint PK_MSSQLLOCKTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLLOCKTEST_THRESH;
CREATE TABLE MSSQLLOCKTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        AVG_WTTIME_MIN			VARCHAR(256) NOT NULL,
	AVG_WTTIME_MAX			VARCHAR(256) NOT NULL,
	LOCK_REQ_MIN			VARCHAR(256) NOT NULL,
	LOCK_REQ_MAX			VARCHAR(256) NOT NULL,
	LOCK_WAIT_MIN			VARCHAR(256) NOT NULL,
	LOCK_WAIT_MAX			VARCHAR(256) NOT NULL,
	NUM_DEADLOCK_MIN		VARCHAR(256) NOT NULL,
	NUM_DEADLOCK_MAX		VARCHAR(256) NOT NULL,
	LOCK_TIMEOUTS_MIN		VARCHAR(256) NOT NULL,
	LOCK_TIMEOUTS_MAX		VARCHAR(256) NOT NULL);

alter table MSSQLLOCKTEST_THRESH add constraint PK_MSSQLLOCKTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLLOCKTEST_THRESH ON MSSQLLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MSSQLMEMORYTEST;
CREATE TABLE MSSQLMEMORYTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	TOT_SERVMEM			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_ST			varchar(32)    NOT NULL,
	TGT_SERVMEM			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_ST			varchar(32)    NOT NULL,
	SQL_CACHEMEM			decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_ST			varchar(32)    NOT NULL,
	OPTZ_MEM			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_ST			varchar(32)    NOT NULL,
	MAX_WORKSPMEM			decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_ST		varchar(32)    NOT NULL,
	LOCK_MEM			decimal(20,4)    NOT NULL,	
	LOCK_MEM_ST			varchar(32)    NOT NULL,
	GRANT_WKSPACEMEM		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_ST		varchar(32)    NOT NULL,
	CONNEC_MEM			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_ST			varchar(32)    NOT NULL,
	MEMORY_GRANTS_PENDING		decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_ST	varchar(32)    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST add constraint PK_MSSQLMEMORYTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MSSQLMEMORYTEST ON MSSQLMEMORYTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLMEMORYTEST_TREND;

CREATE TABLE MSSQLMEMORYTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	TOT_SERVMEM_MIN			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_MAX			decimal(20,4)    NOT NULL,	
	TOT_SERVMEM_STCNT		varchar(32)    NOT NULL,
	TGT_SERVMEM_MIN			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_MAX			decimal(20,4)    NOT NULL,	
	TGT_SERVMEM_STCNT		varchar(32)    NOT NULL,
	SQL_CACHEMEM_MIN		decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_MAX		decimal(20,4)    NOT NULL,	
	SQL_CACHEMEM_STCNT		varchar(32)    NOT NULL,
	OPTZ_MEM_MIN			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_MAX			decimal(20,4)    NOT NULL,	
	OPTZ_MEM_STCNT			varchar(32)    NOT NULL,
	MAX_WORKSPMEM_MIN		decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_MAX		decimal(20,4)    NOT NULL,	
	MAX_WORKSPMEM_STCNT		varchar(32)    NOT NULL,
	LOCK_MEM_MIN			decimal(20,4)    NOT NULL,	
	LOCK_MEM_MAX			decimal(20,4)    NOT NULL,	
	LOCK_MEM_STCNT			varchar(32)    NOT NULL,
	GRANT_WKSPACEMEM_MIN		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_MAX		decimal(20,4)    NOT NULL,	
	GRANT_WKSPACEMEM_STCNT		varchar(32)    NOT NULL,
	CONNEC_MEM_MIN			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_MAX			decimal(20,4)    NOT NULL,	
	CONNEC_MEM_STCNT		varchar(32)    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_MAX	decimal(20,4)    NOT NULL,	
	MEMORY_GRANTS_PENDING_STCNT	varchar(32)    NOT NULL
);


ALTER TABLE MSSQLMEMORYTEST_TREND add constraint PK_MSSQLMEMORYTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLMEMORYTEST_THRESH;

CREATE TABLE MSSQLMEMORYTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL,         
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        TOT_SERVMEM_MIN			VARCHAR(256)	    NOT NULL,
	TOT_SERVMEM_MAX			VARCHAR(256)	    NOT NULL,
	TGT_SERVMEM_MIN			VARCHAR(256)	    NOT NULL,
	TGT_SERVMEM_MAX			VARCHAR(256)	    NOT NULL,
	SQL_CACHEMEM_MIN		VARCHAR(256)	    NOT NULL,
	SQL_CACHEMEM_MAX		VARCHAR(256)	    NOT NULL,
	OPTZ_MEM_MIN			VARCHAR(256)	    NOT NULL,
	OPTZ_MEM_MAX			VARCHAR(256)	    NOT NULL,
	MAX_WORKSPMEM_MIN		VARCHAR(256)	    NOT NULL,
	MAX_WORKSPMEM_MAX		VARCHAR(256)	    NOT NULL,
	LOCK_MEM_MIN			VARCHAR(256)	    NOT NULL,
	LOCK_MEM_MAX			VARCHAR(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MIN		VARCHAR(256)	    NOT NULL,
	GRANT_WKSPACEMEM_MAX		VARCHAR(256)	    NOT NULL,
	CONNEC_MEM_MIN			VARCHAR(256)	    NOT NULL,
	CONNEC_MEM_MAX			VARCHAR(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MIN	VARCHAR(256)	    NOT NULL,
	MEMORY_GRANTS_PENDING_MAX	VARCHAR(256)	    NOT NULL
	);

ALTER TABLE MSSQLMEMORYTEST_THRESH add constraint PK_MSSQLMEMORYTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLMEMORYTEST_THRESH ON MSSQLMEMORYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MSSQLSESSIONTEST;
CREATE TABLE MSSQLSESSIONTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	LOGIN_COUNTER		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_ST	varchar(32)    NOT NULL,
	LOGOUT_COUNTER		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_ST	varchar(32)    NOT NULL,	
	USER_CONNECTION		decimal(20,4)     NOT NULL,
	USER_CONNECTION_ST	varchar(32)    NOT NULL,
	LOGICAL_CONNECTIONS	decimal(20,4)     NOT NULL,
	LOGICAL_CONNECTIONS_ST	varchar(32)    NOT NULL
	);

ALTER TABLE MSSQLSESSIONTEST add constraint PK_MSSQLSESSIONTEST PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_MSSQLSESSIONTEST ON MSSQLSESSIONTEST (MSMT_TIME) INCLUDE (USER_CONNECTION);

DROP TABLE MSSQLSESSIONTEST_TREND;

CREATE TABLE MSSQLSESSIONTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	LOGIN_COUNTER_MIN		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_MAX		decimal(20,4)    NOT NULL,
	LOGIN_COUNTER_STCNT		varchar(32)    NOT NULL,
	LOGOUT_COUNTER_MIN		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_MAX		decimal(20,4)    NOT NULL,
	LOGOUT_COUNTER_STCNT		varchar(32)    NOT NULL,
	USER_CONNECTION_MIN		decimal(20,4)    NOT NULL,
	USER_CONNECTION_MAX		decimal(20,4)    NOT NULL,
	USER_CONNECTION_STCNT		varchar(32)    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		decimal(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		decimal(20,4)    NOT NULL,
	LOGICAL_CONNECTIONS_STCNT	varchar(32)    NOT NULL
);
ALTER TABLE MSSQLSESSIONTEST_TREND add constraint PK_MSSQLSESSIONTEST_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLSESSIONTEST_THRESH;
CREATE TABLE MSSQLSESSIONTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        LOGIN_COUNTER_MIN		VARCHAR(256)	    NOT NULL,
	LOGIN_COUNTER_MAX		VARCHAR(256)	    NOT NULL,
	LOGOUT_COUNTER_MIN		VARCHAR(256)	    NOT NULL,
	LOGOUT_COUNTER_MAX		VARCHAR(256)	    NOT NULL,
	USER_CONNECTION_MIN		VARCHAR(256)	    NOT NULL,
	USER_CONNECTION_MAX		VARCHAR(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MIN		VARCHAR(256)	    NOT NULL,
	LOGICAL_CONNECTIONS_MAX		VARCHAR(256)	    NOT NULL
);

ALTER TABLE MSSQLSESSIONTEST_THRESH add constraint PK_MSSQLSESSIONTEST_THRESH PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;
CREATE INDEX IDX_MSSQLSESSIONTEST_THRESH ON MSSQLSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     

DROP TABLE MSSQLTRANSACTIONTEST;
CREATE TABLE MSSQLTRANSACTIONTEST 
(
        TRGT_HOST		varchar(32) NOT NULL,
        PORT_NO             	varchar(32) NOT NULL,
        SITE_NAME          	varchar(64) NOT NULL,
        INFO              	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME         	datetime NOT NULL,
	ACTIVE_TRAN		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_ST		varchar(32)    NOT NULL,
	LOG_FLUSHWT		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_ST		varchar(32)    NOT NULL,
	REPL_PNDXACTS		decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_ST	varchar(32)    NOT NULL,
	REPL_TRANRT		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_ST		varchar(32)    NOT NULL,
	NUM_TRANSACT		decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_ST		varchar(32)    NOT NULL
	);

alter table MSSQLTRANSACTIONTEST add constraint PK_MSSQLTRANSACTIONTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MSSQLTRANSACTIONTEST ON MSSQLTRANSACTIONTEST
(
	 MSMT_TIME
);

DROP TABLE MSSQLTRANSACTIONTEST_TREND;

CREATE TABLE MSSQLTRANSACTIONTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	
	ACTIVE_TRAN_MIN		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_MAX		decimal(20,4)    NOT NULL,	
	ACTIVE_TRAN_STCNT	varchar(32)    NOT NULL,
	LOG_FLUSHWT_MIN		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_MAX		decimal(20,4)    NOT NULL,	
	LOG_FLUSHWT_STCNT	varchar(32)    NOT NULL,
	REPL_PNDXACTS_MIN	decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_MAX	decimal(20,4)    NOT NULL,	
	REPL_PNDXACTS_STCNT	varchar(32)    NOT NULL,
	REPL_TRANRT_MIN		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_MAX		decimal(20,4)    NOT NULL,	
	REPL_TRANRT_STCNT	varchar(32)    NOT NULL,
	NUM_TRANSACT_MIN	decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_MAX	decimal(20,4)    NOT NULL,	
	NUM_TRANSACT_STCNT	varchar(32)    NOT NULL
	);


alter table MSSQLTRANSACTIONTEST_TREND add constraint PK_MSSQLTRANSACTIONTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MSSQLTRANSACTIONTEST_THRESH;

CREATE TABLE MSSQLTRANSACTIONTEST_THRESH 
(
        TRGT_HOST               	varchar(32) NOT NULL,
        PORT_NO             	    	varchar(32) NOT NULL,
        SITE_NAME           	    	varchar(64) NOT NULL,
        INFO                	    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START         	datetime NOT NULL,
        MSMT_TIME_END           	datetime NOT NULL,
        ACTIVE_TRAN_MIN	VARCHAR(256)	    NOT NULL,
	ACTIVE_TRAN_MAX	VARCHAR(256)	    NOT NULL,
	LOG_FLUSHWT_MIN	VARCHAR(256)	    NOT NULL,
	LOG_FLUSHWT_MAX	VARCHAR(256)	    NOT NULL,
	REPL_PNDXACTS_MIN	VARCHAR(256)	    NOT NULL,
	REPL_PNDXACTS_MAX	VARCHAR(256)	    NOT NULL,
	REPL_TRANRT_MIN	VARCHAR(256)	    NOT NULL,
	REPL_TRANRT_MAX	VARCHAR(256)	    NOT NULL,
	NUM_TRANSACT_MIN	VARCHAR(256)	    NOT NULL,
	NUM_TRANSACT_MAX	VARCHAR(256)	    NOT NULL

	);

alter table MSSQLTRANSACTIONTEST_THRESH add constraint PK_MSSQLTRANSACTIONTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MSSQLTRANSTEST_THRESH ON MSSQLTRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   
DROP TABLE MTSPROCESSTEST;

CREATE TABLE MTSPROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)    NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)    NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)    NOT NULL
);

ALTER TABLE MTSPROCESSTEST ADD constraint PK_MTSPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  NONCLUSTERED INDEX IDX_MTSPROCESSTEST ON MTSPROCESSTEST (MSMT_TIME) INCLUDE (NUM_PROC);

DROP TABLE MTSPROCESSTEST_TREND;

CREATE TABLE MTSPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_TREND ADD constraint PK_MTSPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSPROCESSTEST_THRESH;

CREATE TABLE MTSPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE MTSPROCESSTEST_THRESH ADD constraint PK_MTSPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_MTSPROCESSTEST_THRESH ON MTSPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 
DROP TABLE MTSTEST;

CREATE TABLE MTSTEST
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	TOTAL_PACKAGES_COUNT		decimal(4)	NOT NULL, 	
	TOTAL_PACKAGES_COUNT_ST		varchar(32)	NOT NULL,
	TOTAL_COMPONENTS_COUNT		decimal(6)	NOT NULL,
	TOTAL_COMPONENTS_COUNT_ST	varchar(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT	decimal(4)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_ST 	varchar(32)	NOT NULL
);

ALTER TABLE MTSTEST ADD constraint PK_MTS	
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MTSTEST ON MTSTEST
(
	 MSMT_TIME
);

DROP TABLE MTSTEST_TREND;

CREATE TABLE MTSTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	TOTAL_PACKAGES_COUNT_MIN	decimal(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_MAX	decimal(4)		NOT NULL, 	
	TOTAL_PACKAGES_COUNT_STCNT	varchar(32)	NOT NULL, 	
	TOTAL_COMPONENTS_COUNT_MIN	decimal(6)		NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	decimal(6)		NOT NULL,	
	TOTAL_COMPONENTS_COUNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	decimal(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	decimal(4)		NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE MTSTEST_TREND ADD constraint PK_MTS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MTSTEST_THRESH;

CREATE TABLE MTSTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
	TOTAL_PACKAGES_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_PACKAGES_COUNT_MAX	VARCHAR(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_COMPONENTS_COUNT_MAX	VARCHAR(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MIN	VARCHAR(256)			NOT NULL,
	TOTAL_RUNNING_PACK_COUNT_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE MTSTEST_THRESH ADD constraint PK_MTS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MTSTEST_THRESH ON MTSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE NASSNMPTEST ;

CREATE TABLE NASSNMPTEST 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                         varchar(32) NOT NULL,
        SITE_NAME                       varchar(64) NOT NULL,
        INFO                            varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	REQ_RATE 			decimal(20,4)	NOT NULL,
	REQ_RATE_ST 			varchar(32)		NOT NULL,
	RESP_TIME 			decimal(20,4)	NOT NULL,
	RESP_TIME_ST 			varchar(32)		NOT NULL,
	PCT_ACTIVE_THREADS		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_ST		varchar(32)		NOT NULL,
	DATA_RATE_OUT 			decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_ST 		varchar(32)		NOT NULL,
	DATA_RATE_IN 			decimal(20,4)	NOT NULL,
	DATA_RATE_IN_ST 		varchar(32)		NOT NULL
);

ALTER TABLE NASSNMPTEST ADD CONSTRAINT PK_NAS_SNMP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NASSNMPTEST ON NASSNMPTEST
(
	 MSMT_TIME
);

DROP TABLE NASSNMPTEST_TREND;

CREATE TABLE NASSNMPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                         varchar(32) NOT NULL,
        SITE_NAME                       varchar(64) NOT NULL,
        INFO                            varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	REQ_RATE_MIN 			decimal(20,4)	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4)	NOT NULL,
	REQ_RATE_STCNT		 	varchar(32)	NOT NULL,
	RESP_TIME_MIN 			decimal(20,4)	NOT NULL,
	RESP_TIME_MAX 			decimal(20,4)	NOT NULL,
	RESP_TIME_STCNT 		varchar(32)	NOT NULL,
	PCT_ACTIVE_THREADS_MIN		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_MAX		decimal(20,4)	NOT NULL,
	PCT_ACTIVE_THREADS_STCNT 	varchar(32)	NOT NULL,
	DATA_RATE_OUT_MIN 		decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_MAX 		decimal(20,4)	NOT NULL,
	DATA_RATE_OUT_STCNT 		varchar(32)	NOT NULL,
	DATA_RATE_IN_MIN 		decimal(20,4)	NOT NULL,
	DATA_RATE_IN_MAX 		decimal(20,4)	NOT NULL,
	DATA_RATE_IN_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE NASSNMPTEST_TREND ADD CONSTRAINT PK_NAS_SNMP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE NASSNMPTEST_THRESH;

CREATE TABLE NASSNMPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)		NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)		NOT NULL,
	RESP_TIME_MIN	VARCHAR(256)		NOT NULL,
	RESP_TIME_MAX	VARCHAR(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MIN	VARCHAR(256)		NOT NULL,
	PCT_ACTIVE_THREADS_MAX	VARCHAR(256)		NOT NULL,
	DATA_RATE_OUT_MIN	VARCHAR(256)		NOT NULL,
	DATA_RATE_OUT_MAX	VARCHAR(256)		NOT NULL,
	DATA_RATE_IN_MIN	VARCHAR(256)		NOT NULL,
	DATA_RATE_IN_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE NASSNMPTEST_THRESH ADD CONSTRAINT PK_NAS_SNMP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NASSNMPTEST_THRESH ON NASSNMPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE NETWORKBANDWIDTHTEST;

CREATE TABLE NETWORKBANDWIDTHTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        RCVD_RATE           	decimal(20,4)    NOT NULL,
        RCVD_RATE_ST        varchar(32)    NOT NULL,
        XMIT_RATE           decimal(20,4)    NOT NULL,
        XMIT_RATE_ST        varchar(32)    NOT NULL,
        PCT_BANDW             decimal(20,4)    NOT NULL,
        PCT_BANDW_ST          varchar(32)    NOT NULL
);

alter table NETWORKBANDWIDTHTEST add constraint PK_NETWORKBANDWIDTHTEST 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NETWORKBANDWIDTHTEST ON NETWORKBANDWIDTHTEST
(
	 MSMT_TIME
);

DROP TABLE NETWORKBANDWIDTHTEST_TREND;

CREATE TABLE NETWORKBANDWIDTHTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        RCVD_RATE_MIN           	decimal(20,4)    NOT NULL,
        RCVD_RATE_MAX           	decimal(20,4)    NOT NULL,
        RCVD_RATE_STCNT        	varchar(32)    NOT NULL,
        XMIT_RATE_MIN          	decimal(20,4)    NOT NULL,
        XMIT_RATE_MAX           	decimal(20,4)    NOT NULL,
        XMIT_RATE_STCNT        	varchar(32)    NOT NULL,
        PCT_BANDW_MIN                    decimal(20,4)    NOT NULL,
        PCT_BANDW_MAX             	decimal(20,4)    NOT NULL,
        PCT_BANDW_STCNT          	varchar(32)    NOT NULL
);


alter table NETWORKBANDWIDTHTEST_TREND add constraint PK_NETWORKBANDWIDTHTEST_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKBANDWIDTHTEST_THRESH;

CREATE TABLE NETWORKBANDWIDTHTEST_THRESH 
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        RCVD_RATE_MIN	VARCHAR(256)	    NOT NULL,
        RCVD_RATE_MAX	VARCHAR(256)	    NOT NULL,
        XMIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
        XMIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        PCT_BANDW_MIN	VARCHAR(256)	    NOT NULL,
        PCT_BANDW_MAX	VARCHAR(256)	    NOT NULL
);

alter table NETWORKBANDWIDTHTEST_THRESH add constraint PK_NETWORKBANDWIDTHTEST_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETBANDWIDTHTEST_THRESH ON NETWORKBANDWIDTHTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE NETWORKTEST;

CREATE TABLE NETWORKTEST 
(
	TRGT_HOST            varchar(32) NOT NULL,
    PORT_NO              varchar(32) NOT NULL,
    SITE_NAME            varchar(64) NOT NULL,
    INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
    MSMT_TIME            datetime NOT NULL,
	AVG_RND_TRIP	     decimal(20,4)    NOT NULL,
	AVG_RND_TRIP_ST      varchar(32)      NOT NULL,
	MIN_RND_TRIP	     decimal(20,4)    NOT NULL,
	MIN_RND_TRIP_ST	     varchar(32)      NOT NULL,
	PKT_LOSS_PCT	     decimal(20,4)     NOT NULL,
	PKT_LOSS_PCT_ST	     varchar(32)      NOT NULL,
	AVAILABILITY			decimal(3)	  NOT NULL,
	AVAILABILITY_ST			varchar(32)   NOT NULL
);

alter table NETWORKTEST add constraint PK_NETWORK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_NETWORKTEST ON NETWORKTEST (MSMT_TIME) INCLUDE (TRGT_HOST, PORT_NO, INFO, MSMT_HOST, PKT_LOSS_PCT,AVAILABILITY,AVG_RND_TRIP);


DROP TABLE NETWORKTEST_TREND;

CREATE TABLE NETWORKTEST_TREND 
(
	TRGT_HOST            		varchar(32) NOT NULL,
    PORT_NO              		varchar(32) NOT NULL,
    SITE_NAME            		varchar(64) NOT NULL,
    INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 		        	varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD	             		varchar(32) NOT NULL, 
	AVG_RND_TRIP_MIN		    decimal(20,4)      NOT NULL,
	AVG_RND_TRIP_MAX	 	    decimal(20,4)      NOT NULL,
	AVG_RND_TRIP_STCNT 		    varchar(32)        NOT NULL,
	MIN_RND_TRIP_MIN     		decimal(20,4)      NOT NULL,
	MIN_RND_TRIP_MAX     		decimal(20,4)      NOT NULL,
	MIN_RND_TRIP_STCNT 		    varchar(32)        NOT NULL,
	PKT_LOSS_PCT_MIN		    decimal(20,4)       NOT NULL,
	PKT_LOSS_PCT_MAX		    decimal(20,4)       NOT NULL,
	PKT_LOSS_PCT_STCNT 		    varchar(32)        NOT NULL,
	AVAILABILITY_MIN		decimal(20,4)		NOT NULL,	
	AVAILABILITY_MAX		decimal(20,4)		NOT NULL,
	AVAILABILITY_STCNT		varchar(32)	NOT NULL
	
);

alter table NETWORKTEST_TREND add constraint PK_NETWORK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTEST_THRESH;

CREATE TABLE NETWORKTEST_THRESH 
(
	TRGT_HOST               varchar(32) NOT NULL,
    PORT_NO                 varchar(32) NOT NULL,
    SITE_NAME               varchar(64) NOT NULL,
    INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
    MSMT_TIME_END           datetime NOT NULL,
	AVG_RND_TRIP_MIN	VARCHAR(256)	 NOT NULL,
	AVG_RND_TRIP_MAX	VARCHAR(256)	 NOT NULL,
	MIN_RND_TRIP_MIN	VARCHAR(256)	 NOT NULL,
	MIN_RND_TRIP_MAX	VARCHAR(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR(256)	  NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR(256)	  NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)			NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)			NOT NULL
	
);

alter table NETWORKTEST_THRESH add constraint PK_NETWORK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTEST_THRESH ON NETWORKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE NETWORKTRAFFICTEST ;

CREATE TABLE NETWORKTRAFFICTEST 
(
	TRGT_HOST       varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME       datetime NOT NULL,
	INP_PKT_RATE	decimal(20,4) NOT NULL,
	INP_PKT_RATE_ST	varchar(32)      NOT NULL,
	OUT_PKT_RATE 	decimal(20,4) NOT NULL,
	OUT_PKT_RATE_ST	varchar(32)      NOT NULL
);

alter table NETWORKTRAFFICTEST add constraint PK_NETWORK_TRAFFIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NETWORKTRAFFICTEST ON NETWORKTRAFFICTEST
(
	 MSMT_TIME
);

DROP TABLE NETWORKTRAFFICTEST_TREND;

CREATE TABLE NETWORKTRAFFICTEST_TREND 
(
	TRGT_HOST       		varchar(32) NOT NULL,
        PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	INP_PKT_RATE_MIN		decimal(20,4) NOT NULL,
	INP_PKT_RATE_MAX		decimal(20,4) NOT NULL,
	INP_PKT_RATE_STCNT 		varchar(32) NOT NULL,
	OUT_PKT_RATE_MIN 		decimal(20,4) NOT NULL,
	OUT_PKT_RATE_MAX 		decimal(20,4) NOT NULL,
	OUT_PKT_RATE_STCNT 		varchar(32) NOT NULL
);

alter table NETWORKTRAFFICTEST_TREND add constraint PK_NETWORK_TRAFFIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE NETWORKTRAFFICTEST_THRESH;

CREATE TABLE NETWORKTRAFFICTEST_THRESH
(
	TRGT_HOST       varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	INP_PKT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	INP_PKT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_PKT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_PKT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

alter table NETWORKTRAFFICTEST_THRESH add constraint PK_NET_TRAFFIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_NETWORKTRAFFICTEST_THRESH ON NETWORKTRAFFICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      
DROP TABLE ORADATAFILETEST;

CREATE TABLE ORADATAFILETEST
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        PHY_BLKRDS_RATE	     decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_ST   varchar(32)    NOT NULL, 
        PHY_BLKWRTS_RATE     decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_ST  varchar(32)    NOT NULL,
        PCT_USAGE	     decimal(20,4)	NOT NULL,
        PCT_USAGE_ST		varchar(32)	NOT NULL
);

alter table ORADATAFILETEST add constraint PK_ORA_DATAFILE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORADATAFILETEST ON ORADATAFILETEST
(
	 MSMT_TIME
);
DROP TABLE ORADATAFILETEST_TREND;

CREATE TABLE ORADATAFILETEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD            		varchar(32) NOT NULL, 
        PHY_BLKRDS_RATE_MIN	        decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_MAX	        decimal(20,4)    NOT NULL,
        PHY_BLKRDS_RATE_STCNT   	varchar(32)    NOT NULL, 
        PHY_BLKWRTS_RATE_MIN     	decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_MAX     	decimal(20,4)    NOT NULL,
        PHY_BLKWRTS_RATE_STCNT  	varchar(32)    NOT NULL,
        PCT_USAGE_MIN			decimal(20,4)	NOT NULL,
        PCT_USAGE_MAX			decimal(20,4) 	NOT NULL,
        PCT_USAGE_STCNT			varchar(32)	NOT NULL
);


alter table ORADATAFILETEST_TREND add constraint PK_ORA_DATAFILE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORADATAFILETEST_THRESH;

CREATE TABLE ORADATAFILETEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PHY_BLKRDS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_BLKRDS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_BLKWRTS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PCT_USAGE_MIN	VARCHAR(256)	  NOT NULL,
        PCT_USAGE_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORADATAFILETEST_THRESH add constraint PK_ORA_DATAFILE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORADATAFILETEST_THRESH ON ORADATAFILETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     


DROP TABLE ORALOCKTEST;

CREATE TABLE ORALOCKTEST 
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
        CURR_LOCK            decimal(20,4)    NOT NULL,
        CURR_LOCK_ST         varchar(32)    NOT NULL,
        AVG_LOCK_TIME        decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_ST     varchar(32)    NOT NULL 
);

alter table ORALOCKTEST add constraint PK_ORA_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORALOCKTEST ON ORALOCKTEST
(
	 MSMT_TIME
);

DROP TABLE ORALOCKTEST_TREND;

CREATE TABLE ORALOCKTEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
        CURR_LOCK_MIN           	decimal(20,4)    NOT NULL,
        CURR_LOCK_MAX           	decimal(20,4)    NOT NULL,
        CURR_LOCK_STCNT         	varchar(32)    NOT NULL,
        AVG_LOCK_TIME_MIN        	decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_MAX        	decimal(20,4)    NOT NULL,
        AVG_LOCK_TIME_STCNT     	varchar(32)    NOT NULL 
);


alter table ORALOCKTEST_TREND add constraint PK_ORA_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORALOCKTEST_THRESH;

CREATE TABLE ORALOCKTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        CURR_LOCK_MIN	VARCHAR(256)	  NOT NULL,
        CURR_LOCK_MAX	VARCHAR(256)	  NOT NULL,
        AVG_LOCK_TIME_MIN	VARCHAR(256)	  NOT NULL,
        AVG_LOCK_TIME_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORALOCKTEST_THRESH add constraint PK_ORA_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORALOCKTEST_THRESH ON ORALOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);         
DROP TABLE ORAPROCESSTEST;

CREATE TABLE ORAPROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)     	NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)     	NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)     	NOT NULL
);

ALTER TABLE ORAPROCESSTEST ADD constraint PK_ORAPROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORAPROCESSTEST ON ORAPROCESSTEST
(
	 MSMT_TIME
);

DROP TABLE ORAPROCESSTEST_TREND;

CREATE TABLE ORAPROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL, 
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_TREND ADD constraint PK_ORAPROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAPROCESSTEST_THRESH;

CREATE TABLE ORAPROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE ORAPROCESSTEST_THRESH ADD constraint PK_ORAPROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORAPROCESSTEST_THRESH ON ORAPROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE ORAROLLBACKTEST;

CREATE TABLE ORAROLLBACKTEST
(
        TRGT_HOST                 varchar(32) NOT NULL,
        PORT_NO                   varchar(32) NOT NULL,
        SITE_NAME                 varchar(64) NOT NULL,
        INFO                      varchar(128) NOT NULL,
	MSMT_HOST 		  varchar(32) NOT NULL, 
	MSMT_TIME                 datetime NOT NULL,
	PCT_SYS_SEG_WAIT       	  decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_ST       varchar(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT      decimal(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_ST   varchar(32)    NOT NULL
);

alter table ORAROLLBACKTEST add constraint PK_ORA_ROLLBACK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORAROLLBACKTEST ON ORAROLLBACKTEST
(
	 MSMT_TIME
);

DROP TABLE ORAROLLBACKTEST_TREND;

CREATE TABLE ORAROLLBACKTEST_TREND
(
        TRGT_HOST                 		varchar(32) NOT NULL,
        PORT_NO                   		varchar(32) NOT NULL,
        SITE_NAME                 		varchar(64) NOT NULL,
        INFO                      		varchar(128) NOT NULL,
	MSMT_HOST 				varchar(32) NOT NULL, 
	MSMT_TIME                 		datetime NOT NULL,
	PERIOD                 			varchar(32) NOT NULL, 
	PCT_SYS_SEG_WAIT_MIN        		decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX        		decimal(20,4)     NOT NULL,
	PCT_SYS_SEG_WAIT_STCNT       		varchar(32)    NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN      		decimal(20,4)     NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MAX      		decimal(20,4)     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_STCNT   		varchar(32)    NOT NULL
);


alter table ORAROLLBACKTEST_TREND add constraint PK_ORA_ROLL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORAROLLBACKTEST_THRESH;

CREATE TABLE ORAROLLBACKTEST_THRESH
(
        TRGT_HOST                  varchar(32) NOT NULL,
        PORT_NO                    varchar(32) NOT NULL,
        SITE_NAME                  varchar(64) NOT NULL,
        INFO                       varchar(128) NOT NULL,
	MSMT_HOST 		   varchar(32) NOT NULL, 
	MSMT_TIME_START            datetime NOT NULL,
        MSMT_TIME_END              datetime NOT NULL,
	PCT_SYS_SEG_WAIT_MIN	VARCHAR(256)	     NOT NULL,
	PCT_SYS_SEG_WAIT_MAX	VARCHAR(256)		   NOT NULL,
	PCT_NON_SYS_SEG_WAIT_MIN	VARCHAR(256)	     NOT NULL,
        PCT_NON_SYS_SEG_WAIT_MAX	VARCHAR(256)		   NOT NULL
);

alter table ORAROLLBACKTEST_THRESH add constraint PK_ORA_ROLL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_ORAROLLBACKTEST_THRESH ON ORAROLLBACKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE ORASESSIONTEST;

CREATE TABLE ORASESSIONTEST 
(
        TRGT_HOST              varchar(32) NOT NULL,
        PORT_NO                varchar(32) NOT NULL,
        SITE_NAME              varchar(64) NOT NULL,
        INFO                   varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME              datetime NOT NULL,
        CURR_SESSIONS           decimal(20,4)    NOT NULL,
        CURR_SESSIONS_ST        varchar(32)    NOT NULL,
        CURR_ACT_SESSION       decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_ST    varchar(32)    NOT NULL,
        BACKGROUND_SESSION     decimal(20,4)    NOT NULL,
        BACKGROUND_SESSION_ST  varchar(32)    NOT NULL,
        INACTIVE_SESSION       decimal(20,4)    NOT NULL,
        INACTIVE_SESSION_ST    varchar(32)    NOT NULL,
        KILLED_SESSION         decimal(20,4)    NOT NULL,
        KILLED_SESSION_ST      varchar(32)    NOT NULL,
        CACHED_SESSION         decimal(20,4)    NOT NULL,
        CACHED_SESSION_ST      varchar(32)    NOT NULL,
        SNIPED_SESSION         decimal(20,4)    NOT NULL,
        SNIPED_SESSION_ST      varchar(32)    NOT NULL,
        BLOCKED_SESSION        decimal(20,4)    NOT NULL,
        BLOCKED_SESSION_ST     varchar(32)    NOT NULL
);

alter table ORASESSIONTEST add constraint PK_ORA_SESSION
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_ORASESSIONTEST ON ORASESSIONTEST (MSMT_TIME) INCLUDE (CURR_ACT_SESSION);


DROP TABLE ORASESSIONTEST_TREND;

CREATE TABLE ORASESSIONTEST_TREND
(
        TRGT_HOST              		varchar(32) NOT NULL,
        PORT_NO                		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                   		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME              		datetime NOT NULL,
	PERIOD              		varchar(32) NOT NULL, 
        CURR_SESSIONS_MIN      		decimal(20,4)    NOT NULL,
        CURR_SESSIONS_MAX      		decimal(20,4)    NOT NULL,
        CURR_SESSIONS_STCNT       	varchar(32)    NOT NULL,
        CURR_ACT_SESSION_MIN            decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_MAX            decimal(20,4)    NOT NULL,
        CURR_ACT_SESSION_STCNT    	varchar(32)    NOT NULL,
        BACKGROUND_SESSION_MIN          decimal(20,4)  NOT NULL,
        BACKGROUND_SESSION_MAX          decimal(20,4)  NOT NULL,
        BACKGROUND_SESSION_STCNT        varchar(32)    NOT NULL,
        INACTIVE_SESSION_MIN            decimal(20,4)  NOT NULL,
        INACTIVE_SESSION_MAX            decimal(20,4)  NOT NULL,
        INACTIVE_SESSION_STCNT          varchar(32)    NOT NULL,
        KILLED_SESSION_MIN              decimal(20,4)  NOT NULL,
        KILLED_SESSION_MAX              decimal(20,4)  NOT NULL,
        KILLED_SESSION_STCNT            varchar(32)    NOT NULL,
        CACHED_SESSION_MIN              decimal(20,4)  NOT NULL,
        CACHED_SESSION_MAX              decimal(20,4)  NOT NULL,
        CACHED_SESSION_STCNT            varchar(32)    NOT NULL,
        SNIPED_SESSION_MIN              decimal(20,4)  NOT NULL,
        SNIPED_SESSION_MAX              decimal(20,4)  NOT NULL,
        SNIPED_SESSION_STCNT            varchar(32)    NOT NULL,
        BLOCKED_SESSION_MIN             decimal(20,4)  NOT NULL,
        BLOCKED_SESSION_MAX             decimal(20,4)  NOT NULL,
        BLOCKED_SESSION_STCNT           varchar(32)    NOT NULL
);


alter table ORASESSIONTEST_TREND add constraint PK_ORA_SESSION_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASESSIONTEST_THRESH;

CREATE TABLE ORASESSIONTEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        CURR_SESSIONS_MIN	VARCHAR(256) NOT NULL,
        CURR_SESSIONS_MAX	VARCHAR(256) NOT NULL,
        CURR_ACT_SESSION_MIN	VARCHAR(256) NOT NULL,
        CURR_ACT_SESSION_MAX	VARCHAR(256) NOT NULL,
        BACKGROUND_SESSION_MIN  VARCHAR(256) NOT NULL,
        BACKGROUND_SESSION_MAX  VARCHAR(256) NOT NULL,
        INACTIVE_SESSION_MIN    VARCHAR(256) NOT NULL,
        INACTIVE_SESSION_MAX    VARCHAR(256) NOT NULL,
        KILLED_SESSION_MIN      VARCHAR(256) NOT NULL,
        KILLED_SESSION_MAX      VARCHAR(256) NOT NULL,
        CACHED_SESSION_MIN      VARCHAR(256) NOT NULL,
        CACHED_SESSION_MAX      VARCHAR(256) NOT NULL,
        SNIPED_SESSION_MIN      VARCHAR(256) NOT NULL,
        SNIPED_SESSION_MAX      VARCHAR(256) NOT NULL,
        BLOCKED_SESSION_MIN     VARCHAR(256) NOT NULL,
        BLOCKED_SESSION_MAX     VARCHAR(256) NOT NULL
);

alter table ORASESSIONTEST_THRESH add constraint PK_ORA_SESSION_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASESSIONTEST_THRESH ON ORASESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE ORASGATEST;
CREATE TABLE ORASGATEST
(
        TRGT_HOST                 varchar(32) NOT NULL,
        PORT_NO                   varchar(32) NOT NULL,
        SITE_NAME                 varchar(64) NOT NULL,
        INFO                      varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME                 datetime NOT NULL,
	PCT_LIBCACHE_RATIO        decimal(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_ST     varchar(32)     NOT NULL,
	PCT_DICTCACHE_RATIO       decimal(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_ST    varchar(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO     decimal(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_ST  varchar(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO    decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_ST varchar(32)   NOT NULL,
	PCT_SORTS_DISK            decimal(20,4)      NOT NULL,
        PCT_SORTS_DISK_ST         varchar(32)     NOT NULL,
	SGA_CURR_USAGE           decimal(20,4)     NOT NULL,
        SGA_CURR_USAGE_ST         varchar(32)     NOT NULL,
	BUFFER_NOWAIT_PCT            decimal(20,4)     NOT NULL,
        BUFFER_NOWAIT_PCT_ST         varchar(32)     NOT NULL,
	SOFT_PARSE_RATIO            decimal(20,4)     NOT NULL,
        SOFT_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	EXECUTE_PARSE_RATIO            decimal(20,4)     NOT NULL,
        EXECUTE_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	CPU_PARSE_RATIO            decimal(20,4)     NOT NULL,
        CPU_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	NON_PARSE_CPU_RATIO            decimal(20,4)     NOT NULL,
        NON_PARSE_CPU_RATIO_ST         varchar(32)     NOT NULL,
	HARD_PARSE_RATIO            decimal(20,4)     NOT NULL,
        HARD_PARSE_RATIO_ST         varchar(32)     NOT NULL,
	TARGET_SIZE_PCT            decimal(20,4)     NOT NULL,
        TARGET_SIZE_PCT_ST         varchar(32)     NOT NULL
);

alter table ORASGATEST add constraint PK_ORA_SGA
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORASGATEST ON ORASGATEST
(
	 MSMT_TIME
);

DROP TABLE ORASGATEST_TREND;
CREATE TABLE ORASGATEST_TREND
(
        TRGT_HOST                 		varchar(32) NOT NULL,
        PORT_NO                   		varchar(32) NOT NULL,
        SITE_NAME                 		varchar(64) NOT NULL,
        INFO                      		varchar(128) NOT NULL,
	MSMT_HOST 				varchar(32) NOT NULL, 
	MSMT_TIME                 		datetime NOT NULL,
	PERIOD                 			varchar(32) NOT NULL, 
	PCT_LIBCACHE_RATIO_MIN        		decimal(20,4)      NOT NULL,
	PCT_LIBCACHE_RATIO_MAX        		decimal(20,4)      NOT NULL,
        PCT_LIBCACHE_RATIO_STCNT           	varchar(32)     NOT NULL,
	PCT_DICTCACHE_RATIO_MIN                 decimal(20,4)      NOT NULL,
	PCT_DICTCACHE_RATIO_MAX                 decimal(20,4)      NOT NULL,
        PCT_DICTCACHE_RATIO_STCNT          	varchar(32)     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MIN               decimal(20,4)      NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX               decimal(20,4)      NOT NULL,
        PCT_DBBUFFCACHE_RATIO_STCNT        	varchar(32)     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN              decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX              decimal(20,4)    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_STCNT       	varchar(32)   NOT NULL,
	PCT_SORTS_DISK_MIN                      decimal(20,4)      NOT NULL,
	PCT_SORTS_DISK_MAX                      decimal(20,4)      NOT NULL,
        PCT_SORTS_DISK_STCNT               	varchar(32)     NOT NULL,
	SGA_CURR_USAGE_MIN	 decimal(20,4)     NOT NULL,
	SGA_CURR_USAGE_MAX                      decimal(20,4)     NOT NULL,
        SGA_CURR_USAGE_STCNT               	varchar(32)     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN                      decimal(20,4)     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX                      decimal(20,4)     NOT NULL,
        BUFFER_NOWAIT_PCT_STCNT               	varchar(32)     NOT NULL,
	SOFT_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	SOFT_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        SOFT_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        EXECUTE_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	CPU_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	CPU_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        CPU_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN                      decimal(20,4)     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX                      decimal(20,4)     NOT NULL,
        NON_PARSE_CPU_RATIO_STCNT               	varchar(32)     NOT NULL,
	HARD_PARSE_RATIO_MIN                      decimal(20,4)     NOT NULL,
	HARD_PARSE_RATIO_MAX                      decimal(20,4)     NOT NULL,
        HARD_PARSE_RATIO_STCNT               	varchar(32)     NOT NULL,
	TARGET_SIZE_PCT_MIN                      decimal(20,4)     NOT NULL,
	TARGET_SIZE_PCT_MAX                      decimal(20,4)     NOT NULL,
        TARGET_SIZE_PCT_STCNT               	varchar(32)      NOT NULL
);

alter table ORASGATEST_TREND add constraint PK_ORA_SGA_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORASGATEST_THRESH;
CREATE TABLE ORASGATEST_THRESH
(
        TRGT_HOST                  varchar(32) NOT NULL,
        PORT_NO                    varchar(32) NOT NULL,
        SITE_NAME                  varchar(64) NOT NULL,
        INFO                       varchar(128) NOT NULL,
	MSMT_HOST 		   varchar(32) NOT NULL, 
	MSMT_TIME_START            datetime NOT NULL,
        MSMT_TIME_END              datetime NOT NULL,
        PCT_LIBCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_LIBCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
        PCT_DICTCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_DICTCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
        PCT_DBBUFFCACHE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	PCT_DBBUFFCACHE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MIN	VARCHAR(256)	    NOT NULL,
	PCT_REDOLOG_MISS_RATIO_MAX	VARCHAR(256)	    NOT NULL,
        PCT_SORTS_DISK_MIN	VARCHAR(256)	     NOT NULL,
	PCT_SORTS_DISK_MAX	VARCHAR(256)	     NOT NULL,
	SGA_CURR_USAGE_MIN	VARCHAR(256)	     NOT NULL,
	SGA_CURR_USAGE_MAX	VARCHAR(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MIN  	VARCHAR(256)	     NOT NULL,
	BUFFER_NOWAIT_PCT_MAX 	VARCHAR(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MIN 	VARCHAR(256)	     NOT NULL,
	SOFT_PARSE_RATIO_MAX 	VARCHAR(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MIN VARCHAR(256)	     NOT NULL,
	EXECUTE_PARSE_RATIO_MAX VARCHAR(256)	     NOT NULL,
	CPU_PARSE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	CPU_PARSE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	NON_PARSE_CPU_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	HARD_PARSE_RATIO_MIN	VARCHAR(256)	     NOT NULL,
	HARD_PARSE_RATIO_MAX	VARCHAR(256)	     NOT NULL,
	TARGET_SIZE_PCT_MIN	VARCHAR(256)	     NOT NULL,
	TARGET_SIZE_PCT_MAX	VARCHAR(256)	     NOT NULL
);

alter table ORASGATEST_THRESH add constraint PK_ORA_SGA_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORASGATEST_THRESH ON ORASGATEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);   

DROP TABLE ORATABLESPACETEST;
CREATE TABLE ORATABLESPACETEST
(
        TRGT_HOST            varchar(32) NOT NULL,
        PORT_NO              varchar(32) NOT NULL,
        SITE_NAME            varchar(64) NOT NULL,
        INFO                 varchar(128) NOT NULL,
	MSMT_HOST 	     varchar(32) NOT NULL, 
	MSMT_TIME            datetime NOT NULL,
	PCT_SPACE_USED       decimal(20,4)     NOT NULL,
        PCT_SPACE_USED_ST    varchar(32)     NOT NULL,
        PHY_RDS_RATE	     decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_ST      varchar(32)    NOT NULL, 
        PHY_WRTS_RATE        decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_ST     varchar(32)    NOT NULL       
);

alter table ORATABLESPACETEST add constraint PK_ORA_TABLESPACE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ORATABLESPACETEST ON ORATABLESPACETEST
(
	 MSMT_TIME
);

DROP TABLE ORATABLESPACETEST_TREND;

CREATE TABLE ORATABLESPACETEST_TREND
(
        TRGT_HOST            		varchar(32) NOT NULL,
        PORT_NO              		varchar(32) NOT NULL,
        SITE_NAME            		varchar(64) NOT NULL,
        INFO                 		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME            		datetime NOT NULL,
	PERIOD               		varchar(32) NOT NULL, 
	PCT_SPACE_USED_MIN     		decimal(20,4)     NOT NULL,
	PCT_SPACE_USED_MAX     		decimal(20,4)     NOT NULL,
        PCT_SPACE_USED_STCNT    	varchar(32)     NOT NULL,
        PHY_RDS_RATE_MIN	     	decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_MAX	     	decimal(20,4)    NOT NULL,
        PHY_RDS_RATE_STCNT      	varchar(32)    NOT NULL, 
        PHY_WRTS_RATE_MIN        	decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_MAX        	decimal(20,4)    NOT NULL,
        PHY_WRTS_RATE_STCNT     	varchar(32)    NOT NULL       
);


alter table ORATABLESPACETEST_TREND add constraint PK_ORA_TABLESPACE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ORATABLESPACETEST_THRESH;

CREATE TABLE ORATABLESPACETEST_THRESH
(
        TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        PCT_SPACE_USED_MIN	VARCHAR(256)	   NOT NULL,
        PCT_SPACE_USED_MAX	VARCHAR(256)	   NOT NULL,
        PHY_RDS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_RDS_RATE_MAX	VARCHAR(256)	  NOT NULL,
        PHY_WRTS_RATE_MIN	VARCHAR(256)	  NOT NULL,
        PHY_WRTS_RATE_MAX	VARCHAR(256)	  NOT NULL
);

alter table ORATABLESPACETEST_THRESH add constraint PK_ORA_TABLESPACE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_ORATABLESPACETEST_THRESH ON ORATABLESPACETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END); 

DROP TABLE PROCESSTEST;

CREATE TABLE PROCESSTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	NUM_PROC	decimal(20,4) 	NOT NULL,
	NUM_PROC_ST	varchar(32)     	NOT NULL,
	CPU_UTIL 	decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST 	varchar(32)     	NOT NULL,
	MEM_UTIL 	decimal(20,4) 	NOT NULL,
	MEM_UTIL_ST 	varchar(32)     	NOT NULL
);

ALTER TABLE PROCESSTEST ADD constraint PK_PROCESS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_PROCESSTEST ON PROCESSTEST (MSMT_TIME) INCLUDE (NUM_PROC);

DROP TABLE PROCESSTEST_TREND;

CREATE TABLE PROCESSTEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	NUM_PROC_MIN		decimal(20,4) 	NOT NULL,
	NUM_PROC_MAX		decimal(20,4) 	NOT NULL,
	NUM_PROC_STCNT		varchar(32)   	NOT NULL,
	CPU_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT 		varchar(32)   	NOT NULL,
	MEM_UTIL_MIN 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_MAX 		decimal(20,4) 	NOT NULL,
	MEM_UTIL_STCNT 		varchar(32)   	NOT NULL
);

ALTER TABLE PROCESSTEST_TREND ADD constraint PK_PROCESS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE PROCESSTEST_THRESH;

CREATE TABLE PROCESSTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	NUM_PROC_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_PROC_MAX	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_UTIL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PROCESSTEST_THRESH ADD constraint PK_PROCESS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_PROCESSTEST_THRESH ON PROCESSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);    

DROP TABLE REPORT;

CREATE TABLE REPORT 
(
	SITE_NAME           	    varchar(64) not null,
	COMP_NAME 	    varchar(64) not null,
	COMP_TYPE      	    varchar(32) not null,
	INFO                varchar(128) not null,
	LAYER_NAME		    varchar(64) not null,	
	TEST_NAME		    varchar(64) not null,	
	MEASURE             varchar(64) not null, 
	MSMT_HOST           varchar(32) not null,
        STATE               varchar(32)
    );    

alter table REPORT add constraint PK_REPORT
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,LAYER_NAME,TEST_NAME,MEASURE,MSMT_HOST);
create index idx_report on report(site_name);
CREATE NONCLUSTERED INDEX IDX1_REPORT ON REPORT (COMP_TYPE) INCLUDE (SITE_NAME, COMP_NAME, INFO, LAYER_NAME, TEST_NAME, MEASURE, MSMT_HOST,STATE);

DROP TABLE EVENT_HIST;

CREATE TABLE EVENT_HIST
(
	SITE_NAME		varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME		varchar(64) NOT NULL,
	MEASURE		varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) not null,
	EVENT_ID		decimal(16),
    EVENT_SVRTY varchar(32) NOT NULL
);
	

alter table EVENT_HIST add constraint PK_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);

create unique index IDX_EVENT_HIST  on EVENT_HIST(EVENT_ID,MSMT_TIME_START);


DROP TABLE UD_EVENT_HIST;

CREATE TABLE UD_EVENT_HIST
(
	SITE_NAME		varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME		varchar(64) NOT NULL,
	MEASURE		varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) not null,
	EVENT_ID		decimal(16),
    EVENT_SVRTY varchar(32) NOT NULL
);
	

alter table UD_EVENT_HIST add constraint PK_UD_EVENT_HIST
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST,EVENT_SVRTY);

create unique index IDX_UD_EVENT_HIST  on UD_EVENT_HIST(EVENT_ID,MSMT_TIME_START);



DROP TABLE UNKNOWN_HISTORY;

CREATE TABLE UNKNOWN_HISTORY
(
	SITE_NAME	varchar(64) NOT NULL,	
	COMP_NAME	varchar(64) NOT NULL,
	COMP_TYPE	varchar(32) NOT NULL,
	INFO		varchar(128) NOT NULL,
	TEST_NAME	varchar(64) NOT NULL,
	MEASURE		varchar(64) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END 	datetime NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	EVENT_ID	decimal(16)
);

alter table UNKNOWN_HISTORY add constraint PK_UNKNOWN_HISTORY
primary key (SITE_NAME,COMP_NAME,COMP_TYPE,INFO,TEST_NAME,MEASURE,MSMT_TIME_START,MSMT_HOST);
create unique index IDX_UNKNOWN_HISTORY on UNKNOWN_HISTORY(EVENT_ID);

DROP TABLE EG_UD_MEASURE;


CREATE TABLE EG_UD_MEASURE
(
	SITE_NAME  VARCHAR(64) NOT NULL,
	TRGT_HOST    VARCHAR(32) NOT NULL,
	PORT_NO      VARCHAR(32)NOT NULL,
	TEST_NAME    VARCHAR(64) NOT NULL,
	MEASURE      VARCHAR(64) NOT NULL,
	INFO         VARCHAR(128) NOT NULL,
	STATE        VARCHAR(32) NOT NULL,
	INDX_MEAS    DECIMAL(16) NOT NULL,
	MSMT_HOST    VARCHAR(32) NOT NULL,
	MSMT_TIME    DATETIME NOT NULL,
	DETL_MEAS    VARCHAR(2000)
);


ALTER TABLE EG_UD_MEASURE ADD constraint PK_EG_UD_MEASURE 
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);

CREATE  INDEX IDX_EG_UD_MEASURE ON EG_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE REGISTERED_DESKTOPS;
CREATE TABLE REGISTERED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, REGISTERED_TIME DATETIME);
ALTER TABLE REGISTERED_DESKTOPS ADD CONSTRAINT PK_REGISTERED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_REGISTERED_DESKTOPS ON REGISTERED_DESKTOPS(REGISTERED_TIME);

DROP TABLE ALLOWED_DESKTOPS;
CREATE TABLE ALLOWED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, ALLOWED_TIME DATETIME);
ALTER TABLE ALLOWED_DESKTOPS ADD CONSTRAINT PK_ALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_ALLOWED_DESKTOPS ON ALLOWED_DESKTOPS(ALLOWED_TIME);

DROP TABLE DISALLOWED_DESKTOPS;
CREATE TABLE DISALLOWED_DESKTOPS(HOST_NAME varchar(256) NOT NULL, DISALLOWED_TIME DATETIME);
ALTER TABLE DISALLOWED_DESKTOPS ADD CONSTRAINT PK_DISALLOWED_DESKTOPS PRIMARY KEY (HOST_NAME);
CREATE INDEX IDX_DISALLOWED_DESKTOPS ON DISALLOWED_DESKTOPS(DISALLOWED_TIME);


DROP TABLE EG_UD_UD_MEASURE;
CREATE TABLE EG_UD_UD_MEASURE
(
	SITE_NAME  VARCHAR(64) NOT NULL,
	TRGT_HOST    VARCHAR(32) NOT NULL,
	PORT_NO      VARCHAR(32)NOT NULL,
	TEST_NAME    VARCHAR(64) NOT NULL,
	MEASURE      VARCHAR(64) NOT NULL,
	INFO         VARCHAR(128) NOT NULL,
	STATE        VARCHAR(32) NOT NULL,
	INDX_MEAS    DECIMAL(16) NOT NULL,
	MSMT_HOST    VARCHAR(32) NOT NULL,
	MSMT_TIME    DATETIME NOT NULL,
	DETL_MEAS    VARCHAR(2000)
);
ALTER TABLE EG_UD_UD_MEASURE ADD constraint PK_EG_UD_UD_MEASURE 
PRIMARY KEY (SITE_NAME,TRGT_HOST,PORT_NO,TEST_NAME,MEASURE,INFO,INDX_MEAS,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_EG_UD_UD_MEASURE ON EG_UD_UD_MEASURE
(
	MSMT_TIME
);


DROP TABLE SYSTEMTEST; 

CREATE TABLE SYSTEMTEST 
(
	TRGT_HOST           varchar(32) NOT NULL,
        PORT_NO             varchar(32) NOT NULL,
        SITE_NAME           varchar(64) NOT NULL,
        INFO                varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME           datetime NOT NULL,
	CPU_UTIL	    decimal(20,4) 	NOT NULL,
	CPU_UTIL_ST	    varchar(32)        NOT NULL,
	SYS_CPU_UTIL	    decimal(20,4)         NOT NULL,
	SYS_CPU_UTIL_ST	    varchar(32)     	NOT NULL,
	RUNNING_PROC	    decimal(20,4)  	NOT NULL,
	RUNNING_PROC_ST	    varchar(32)     	NOT NULL,
	BLOCKED_PROC	    decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_ST	    varchar(32)     	NOT NULL,
	SWAP_AVAIL	    decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_ST	    varchar(32)        NOT NULL,
	FREE_MEM_AVAIL	    decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_ST   varchar(32)        NOT NULL,
	MEM_SCAN_RATE 	    decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_ST    varchar(32)        NOT NULL
);

alter table SYSTEMTEST add constraint PK_SYSTEM
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_SYSTEMTEST ON SYSTEMTEST (MSMT_TIME) INCLUDE (CPU_UTIL,FREE_MEM_AVAIL,RUNNING_PROC);

DROP TABLE SYSTEMTEST_TREND; 

CREATE TABLE SYSTEMTEST_TREND 
(
	TRGT_HOST           		varchar(32) NOT NULL,
        PORT_NO             		varchar(32) NOT NULL,
        SITE_NAME           		varchar(64) NOT NULL,
        INFO                		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME           		datetime NOT NULL,
	PERIOD              		varchar(32) NOT NULL,
	CPU_UTIL_MIN	    		decimal(20,4) 	NOT NULL,
	CPU_UTIL_MAX	    		decimal(20,4) 	NOT NULL,
	CPU_UTIL_STCNT    		varchar(32)    NOT NULL,
	SYS_CPU_UTIL_MIN    		decimal(20,4)     NOT NULL,
	SYS_CPU_UTIL_MAX    		decimal(20,4)     NOT NULL,
	SYS_CPU_UTIL_STCNT	    	varchar(32)   	NOT NULL,
	RUNNING_PROC_MIN	    	decimal(20,4)  	NOT NULL,
	RUNNING_PROC_MAX	    	decimal(20,4)  	NOT NULL,
	RUNNING_PROC_STCNT	    	varchar(32)   	NOT NULL,
	BLOCKED_PROC_MIN	    	decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_MAX	    	decimal(20,4)  	NOT NULL,
	BLOCKED_PROC_STCNT	    	varchar(32)   	NOT NULL,
	SWAP_AVAIL_MIN	    		decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_MAX	    		decimal(20,4)  	NOT NULL,
	SWAP_AVAIL_STCNT	 	varchar(32)    NOT NULL,
	FREE_MEM_AVAIL_MIN	    	decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_MAX	    	decimal(20,4)  	NOT NULL,
	FREE_MEM_AVAIL_STCNT   		varchar(32)    NOT NULL,
	MEM_SCAN_RATE_MIN 	    	decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_MAX 	    	decimal(20,4)  	NOT NULL,
	MEM_SCAN_RATE_STCNT		varchar(32)    NOT NULL
);

alter table SYSTEMTEST_TREND add constraint PK_SYSTEM_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE SYSTEMTEST_THRESH; 
CREATE TABLE SYSTEMTEST_THRESH 
(
	TRGT_HOST               varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START         datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,  
	CPU_UTIL_MIN	VARCHAR(256)	   NOT NULL,
	CPU_UTIL_MAX	VARCHAR(256)	   NOT NULL,
	SYS_CPU_UTIL_MIN	VARCHAR(256)	   NOT NULL,
	SYS_CPU_UTIL_MAX	VARCHAR(256)	   NOT NULL,
	RUNNING_PROC_MIN	VARCHAR(256)	    NOT NULL,
	RUNNING_PROC_MAX	VARCHAR(256)	    NOT NULL,
	BLOCKED_PROC_MIN	VARCHAR(256)	    NOT NULL,
	BLOCKED_PROC_MAX	VARCHAR(256)	    NOT NULL,
	SWAP_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
	SWAP_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
	FREE_MEM_AVAIL_MIN	VARCHAR(256)	    NOT NULL,
	FREE_MEM_AVAIL_MAX	VARCHAR(256)	    NOT NULL,
	MEM_SCAN_RATE_MIN	VARCHAR(256)	    NOT NULL,
	MEM_SCAN_RATE_MAX	VARCHAR(256)	    NOT NULL
);

alter table SYSTEMTEST_THRESH add constraint PK_SYSTEM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SYSTEMTEST_THRESH ON SYSTEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE TCPTEST ;

CREATE TABLE TCPTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
	CONN_RATE_IN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_ST 	varchar(32)    NOT NULL,
	CONN_RATE_OUT 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_ST 	varchar(32)    NOT NULL,
	CURR_CONN 		decimal(20,4) 	NOT NULL,
	CURR_CONN_ST 		varchar(32)    NOT NULL,
	COMP_CONN_DROPS 	decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_ST 	varchar(32)    NOT NULL,
	HALF_CONN_DROPS 	decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_ST 	varchar(32)    NOT NULL
);

ALTER TABLE TCPTEST ADD CONSTRAINT PK_TCP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_TCPTEST ON TCPTEST (MSMT_TIME) INCLUDE (CURR_CONN);

DROP TABLE TCPTEST_TREND;
CREATE TABLE TCPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
	CONN_RATE_IN_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_IN_STCNT 		varchar(32)    NOT NULL,
	CONN_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	CONN_RATE_OUT_STCNT 		varchar(32)    NOT NULL,
	CURR_CONN_MIN 			decimal(20,4) 	NOT NULL,
	CURR_CONN_MAX 			decimal(20,4) 	NOT NULL,
	CURR_CONN_STCNT 		varchar(32)    NOT NULL,
	COMP_CONN_DROPS_MIN 		decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_MAX 		decimal(20,4) 	NOT NULL,
	COMP_CONN_DROPS_STCNT 		varchar(32)    NOT NULL,
	HALF_CONN_DROPS_MIN 		decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_MAX 		decimal(20,4) 	NOT NULL,
	HALF_CONN_DROPS_STCNT 		varchar(32)    NOT NULL
);

ALTER TABLE TCPTEST_TREND ADD CONSTRAINT PK_TCP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE TCPTEST_THRESH;
CREATE TABLE TCPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
	CONN_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_CONN_MIN	VARCHAR(256)	 	NOT NULL,
	CURR_CONN_MAX	VARCHAR(256)	 	NOT NULL,
	COMP_CONN_DROPS_MIN	VARCHAR(256)	 	NOT NULL,
	COMP_CONN_DROPS_MAX	VARCHAR(256)	 	NOT NULL,
	HALF_CONN_DROPS_MIN	VARCHAR(256)	 	NOT NULL,
	HALF_CONN_DROPS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE TCPTEST_THRESH ADD CONSTRAINT PK_TCP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_TCPTEST_THRESH ON TCPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TESTMEASURE ;
DROP TABLE TESTDESC ;
CREATE TABLE TESTDESC 
(
	TEST_NAME 		varchar(64) NOT NULL,
	TEST_SDESC 		varchar(1000) NOT NULL,
	TEST_LDESC 		varchar(2048)
);

ALTER TABLE TESTDESC ADD CONSTRAINT PK_TESTDESC
PRIMARY KEY (TEST_NAME); 


CREATE TABLE TESTMEASURE
(
        TEST_NAME               varchar(64) NOT NULL,
        MSMT_NAME               varchar(64) NOT NULL,
        MSMT_DESC               varchar(1000)
);

ALTER TABLE TESTMEASURE ADD CONSTRAINT PK_TESTMEASURE
PRIMARY KEY (TEST_NAME);

     

DROP TABLE topology;

CREATE TABLE TOPOLOGY
(
	COMP_TYPE 	    varchar(32) NOT NULL,
	COMP_NAME   	    varchar(64) NOT NULL,
        DEPD                varchar(64)  NOT NULL,
        DIRCT               varchar(32)  NOT NULL
);
	
alter table TOPOLOGY add constraint PK_TOPOLOGY
primary key (COMP_TYPE,COMP_NAME,DEPD);

DROP TABLE EGTRANSACTION;

CREATE TABLE EGTRANSACTION 
(
	TRANS_NAME 	          varchar(64)NOT NULL,
	SITE_NAME   	                  varchar(64) NOT NULL,
	USER_ID   		varchar(256) NOT NULL,
        IMG                     varchar(64)
);    
	
alter table EGTRANSACTION add constraint PK_EGTRANSACTION
primary key (TRANS_NAME,SITE_NAME,USER_ID);

DROP TABLE UDPTEST;

CREATE TABLE UDPTEST
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	PKT_RATE_IN 		decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_ST 		varchar(32)  	NOT NULL,
	PKT_RATE_OUT    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_ST    	varchar(32)  	NOT NULL,
	PKT_OFLOW_RATE    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_ST   	varchar(32)  	NOT NULL
);

alter table UDPTEST add constraint PK_UDP
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_UDPTEST ON UDPTEST
(
	 MSMT_TIME
);

DROP TABLE UDPTEST_TREND;

CREATE TABLE UDPTEST_TREND
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	PERIOD       		varchar(32) NOT NULL, 
	PKT_RATE_IN_MIN 	decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_MAX 	decimal(20,4)  	NOT NULL,
	PKT_RATE_IN_STCNT 	varchar(32)  	NOT NULL,
	PKT_RATE_OUT_MIN    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_MAX    	decimal(20,4)  	NOT NULL,
	PKT_RATE_OUT_STCNT	varchar(32)  	NOT NULL,
	PKT_OFLOW_RATE_MIN    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_MAX    	decimal(20,4)  	NOT NULL,
	PKT_OFLOW_RATE_STCNT	varchar(32)  	NOT NULL
);

alter table UDPTEST_TREND add constraint PK_UDP_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE UDPTEST_THRESH;

CREATE TABLE UDPTEST_THRESH
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START       	datetime NOT NULL,
	MSMT_TIME_END          	datetime NOT NULL,
	PKT_RATE_IN_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_IN_MAX	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_OUT_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_RATE_OUT_MAX	VARCHAR(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MIN	VARCHAR(256)	  	NOT NULL,
	PKT_OFLOW_RATE_MAX	VARCHAR(256)	  	NOT NULL
);

alter table UDPTEST_THRESH add constraint PK_UDP_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_UDPTEST_THRESH ON UDPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);            

DROP TABLE report_share;
DROP TABLE report_info;


DROP table USER_SERV;
DROP table USER_SITE;
DROP table USER_SERVICEGROUP;
DROP TABLE USER_SEG;
DROP TABLE USER_VM;
DROP TABLE USER_PREF;
DROP TABLE USER_INFO;
DROP TABLE USER_ROLE;

create table USER_ROLE
(
	role_name varchar(32) primary key,
	admin_perm decimal(20) not null,
	monitor_perm decimal(20) not null,
	reporter_perm decimal(20) not null,
	admin_action decimal(20) not null,
	monitor_action decimal(20) not null,
	reporter_action decimal(20) not null,
	all_components char(1) not null,
	config_perm decimal(20) not null,
	config_action decimal(20) not null
);

insert into user_role values('Admin',9223372036854775807, 9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('ServerAdmin',9223372036854775806,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Supermonitor',0,9223372036854775807,9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('Monitor',0,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('SupermonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'y',0,0);
insert into user_role values('MonitorNoConfig',0,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);
insert into user_role values('AlarmViewer',0,9223372036854775807,0,0,7,0,'n',0,0);
insert into user_role values('SuperAlarmViewer',0,9223372036854775807,0,0,7,0,'y',0,0);
insert into user_role values('egsm',0,9223372036854775807, 9223372036854775807,0,0,0,'y',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdmin',772,9223372036854775807,9223372036854775807,0,0,0,'n',9223372036854775807,0);
insert into user_role values('MonitorWithLimitedAdminNoConfig',772,9223372036854775807,9223372036854775807,0,0,0,'n',0,0);


CREATE TABLE USER_INFO 
(
	USER_ID 	    varchar(256) NOT NULL,
	USER_PASS   	    varchar(1024)  NOT NULL,
        USER_TYPE           varchar(32)  NOT NULL,
	USER_MAILID	    varchar(2000),
	USER_ALARM_TYPE	    varchar(32),
	USER_ALARM_PREF	    varchar(32),
	USER_ALARM_MODE     varchar(32),
	USER_VALID_TILL	    datetime,
	USER_REG_DATE	    datetime,
	USER_SERV_TYPE     varchar(1024),
	CA_ENABLED         varchar(16),
	REPT_TIMELINE	   varchar(16)
 );
	
alter table USER_INFO add constraint PK_USER_INFO
primary key (USER_ID);



CREATE TABLE USER_SITE
(
	USER_ID 		varchar(256) not null,
	SITE_NAME		varchar(128) not null
);

alter table USER_SITE add constraint PK_USER_SITE
primary key (USER_ID,SITE_NAME);

alter table USER_SITE add constraint FK_USER_SITE
foreign key(USER_ID) references USER_INFO(USER_ID) ;

CREATE TABLE USER_SERVICEGROUP
(
	USER_ID			varchar(256) not null,
	SERVICEGROUP_NAME	varchar(128) not null
);
 
alter table USER_SERVICEGROUP add constraint PK_USER_SERVICEGROUP
primary key (USER_ID,SERVICEGROUP_NAME);
 
alter table USER_SERVICEGROUP add constraint FK_USER_SERVICEGROUP
foreign key(USER_ID) references USER_INFO(USER_ID);

CREATE TABLE USER_SEG
(
        USER_ID         varchar(256) not null,
        SEG_NAME        varchar(128) not null
);

alter table USER_SEG add constraint PK_USER_SEG
primary key (USER_ID,SEG_NAME);

alter table USER_SEG add constraint FK_USER_SEG
foreign key(USER_ID) references USER_INFO(USER_ID) ;

CREATE TABLE USER_SERV
(
	USER_ID 		varchar(256) not null,
	SERV_NAME		varchar(128) not null,
	SERV_TYPE		varchar(128) not null
);

alter table USER_SERV add constraint PK_USER_SERV
primary key (
	USER_ID,
	SERV_NAME,
	SERV_TYPE);
alter table USER_SERV add constraint FK_USER_SERV
foreign key(USER_ID) references USER_INFO(USER_ID);

CREATE TABLE USER_VM 
( 
	USER_ID			 varchar(256) not null, 
	SERV_NAME		 varchar(128) not null, 
	SERV_TYPE		 varchar(128) not null, 
	VM_NAME			 varchar(128) not null 
); 

alter table USER_VM add constraint PK_USER_VM 
primary key ( 
	USER_ID, 
	SERV_NAME, 
	SERV_TYPE, 
	VM_NAME); 
alter table USER_VM add constraint FK_USER_VM 
foreign key(USER_ID) references USER_INFO(USER_ID); 
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('admin','26:28:21:27:27','Admin','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('supermonitor','43:43:35:43:35:31:30:22:32:18:10:9','Supermonitor','true#true','-1');
insert into USER_INFO (user_id,user_pass,user_type,ca_enabled,rept_timeline) values('egsm','24:15:24:23','egsm','false','-1');

DROP TABLE QINSIGHT_DETAILS;
DROP TABLE QINSIGHT_REPORT;

CREATE TABLE QINSIGHT_REPORT(
	user_id varchar(512) primary key ,
	No_of_tiers decimal(2),
	No_of_servers_per_tier decimal(2),
	No_of_metrics_per_server decimal(2),
	refresh_rate decimal(5)
);


CREATE TABLE QINSIGHT_DETAILS(
	user_id varchar(512),
	tier_name varchar(128),
	tier_index decimal(2),
	server_name varchar(128),
	server_index decimal(2),
	component varchar(256),
	metric_name varchar(128),
	metric_index decimal(2),
	test varchar(31),
	measure varchar(31),
	info varchar(128),
	site varchar(64),
	type char(1)
);

DROP TABLE USER_REPORT_DETAILS;
DROP TABLE USER_REPORTS;

CREATE TABLE USER_REPORTS(
	rept_id decimal(16)NOT NULL,
	user_id varchar(256),
	rept_name varchar(128),
	unique(user_id,rept_name)
);

ALTER TABLE USER_REPORTS ADD constraint PK_USER_REPORTS
PRIMARY KEY (rept_id);

INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(1,'admin','USER_PREF');
INSERT INTO USER_REPORTS (rept_id,user_id,rept_name) values(2,'supermonitor','USER_PREF');

CREATE TABLE USER_REPORT_DETAILS(
	rept_id decimal(16) NOT NULL,
	rept_param varchar(128),
	rept_value varchar(1024)
);


alter table USER_REPORT_DETAILS add constraint FK_USER_REPORT_DETAILS
foreign key(rept_id) references user_reports(rept_id) ON DELETE CASCADE;

INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(1,'ALARM_WINDOW','HIL');
INSERT INTO USER_REPORT_DETAILS (rept_id,rept_param,rept_value) values(2,'ALARM_WINDOW','HIL');

DROP TABLE WAPTEST ;

CREATE TABLE WAPTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        AVAILABILITY            decimal(20,4)    NOT NULL,
        AVAILABILITY_ST        	varchar(32)  	NOT NULL,
        CONN_AVAILABILITY 	decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_ST 	varchar(32)  	NOT NULL,
        RESPONSE_TIME           decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_ST        varchar(32)     NOT NULL 
);

ALTER TABLE WAPTEST ADD CONSTRAINT PK_WAP_STATS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WAPTEST ON WAPTEST
(
	 MSMT_TIME
);

DROP TABLE WAPTEST_TREND;
CREATE TABLE WAPTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
        PORT_NO                 	varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
        AVAILABILITY_MIN            	decimal(20,4)    NOT NULL,
        AVAILABILITY_MAX            	decimal(20,4)    NOT NULL,
        AVAILABILITY_STCNT        	varchar(32)  	NOT NULL,
        CONN_AVAILABILITY_MIN 		decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_MAX 		decimal(20,4)    NOT NULL,
        CONN_AVAILABILITY_STCNT 	varchar(32)  	NOT NULL,
        RESPONSE_TIME_MIN           	decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_MAX           	decimal(20,4)    NOT NULL, 
        RESPONSE_TIME_STCNT       	varchar(32)     NOT NULL 
);

ALTER TABLE WAPTEST_TREND ADD CONSTRAINT PK_WAP_STATS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE WAPTEST_THRESH;
CREATE TABLE WAPTEST_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO                 varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        AVAILABILITY_MIN	VARCHAR(256)	    NOT NULL,
        AVAILABILITY_MAX	VARCHAR(256)	    NOT NULL,
        CONN_AVAILABILITY_MIN	VARCHAR(256)	    NOT NULL,
        CONN_AVAILABILITY_MAX	VARCHAR(256)	    NOT NULL,
        RESPONSE_TIME_MIN	VARCHAR(256)	    NOT NULL,
        RESPONSE_TIME_MAX	VARCHAR(256)	    NOT NULL
);

ALTER TABLE WAPTEST_THRESH ADD CONSTRAINT PK_WAP_STATS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WAPTEST_THRESH ON WAPTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  
DROP TABLE WEBLOGICEJBTEST;

CREATE TABLE WEBLOGICEJBTEST
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	TX_COMMIT_RATE			decimal(20,4)	NOT NULL,
	TX_COMMIT_RATE_ST		varchar(32)	NOT NULL,
	TX_ROLLBACK_RATE 		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_ST 		varchar(32)	NOT NULL,
	TX_INFLIGHT			decimal(8)	NOT NULL,
	TX_INFLIGHT_ST			varchar(32)	NOT NULL,
	NUM_WAITING_RATE		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_ST 		varchar(23)	NOT NULL,
	TIME_OUT_RATE			decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_ST  		varchar(32)	NOT NULL,
	IDLE_BEAN_PCT			decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_ST		varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST ADD constraint PK_WLEJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICEJBTEST ON WEBLOGICEJBTEST
(
	 MSMT_TIME
);


DROP TABLE WEBLOGICEJBTEST_TREND;

CREATE TABLE WEBLOGICEJBTEST_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	TX_COMMIT_RATE_MIN		decimal(20,4)	NOT NULL,	
	TX_COMMIT_RATE_MAX		decimal(20,4)	NOT NULL,
	TX_COMMIT_RATE_STCNT		varchar(32)	NOT NULL,
	TX_ROLLBACK_RATE_MIN		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_MAX		decimal(20,4)	NOT NULL,
	TX_ROLLBACK_RATE_STCNT		varchar(32)	NOT NULL,
	TX_INFLIGHT_MIN			decimal(8)	NOT NULL,
	TX_INFLIGHT_MAX			decimal(8)	NOT NULL,
	TX_INFLIGHT_STCNT		varchar(32)	NOT NULL,
	NUM_WAITING_RATE_MIN		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_MAX		decimal(20,4)	NOT NULL,
	NUM_WAITING_RATE_STCNT		varchar(32)	NOT NULL,
	TIME_OUT_RATE_MIN		decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_MAX		decimal(20,4)	NOT NULL,
	TIME_OUT_RATE_STCNT 		varchar(32)    NOT NULL,
	IDLE_BEAN_PCT_MIN		decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_MAX		decimal(20,4)	NOT NULL,
	IDLE_BEAN_PCT_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_TREND ADD constraint PK_WLEJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICEJBTEST_THRESH;

CREATE TABLE WEBLOGICEJBTEST_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
	TX_COMMIT_RATE_MIN	VARCHAR(256)			NOT NULL,
	TX_COMMIT_RATE_MAX	VARCHAR(256)			NOT NULL,
	TX_ROLLBACK_RATE_MIN	VARCHAR(256)			NOT NULL,
	TX_ROLLBACK_RATE_MAX	VARCHAR(256)			NOT NULL,
	TX_INFLIGHT_MIN	VARCHAR(256)			NOT NULL,
	TX_INFLIGHT_MAX	VARCHAR(256)			NOT NULL,
	NUM_WAITING_RATE_MIN	VARCHAR(256)			NOT NULL,
	NUM_WAITING_RATE_MAX	VARCHAR(256)			NOT NULL,
	TIME_OUT_RATE_MIN	VARCHAR(256)			NOT NULL,
	TIME_OUT_RATE_MAX	VARCHAR(256)			NOT NULL,
	IDLE_BEAN_PCT_MIN	VARCHAR(256)			NOT NULL,
	IDLE_BEAN_PCT_MAX	VARCHAR(256)			NOT NULL
);

ALTER TABLE WEBLOGICEJBTEST_THRESH ADD constraint PK_WLEJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICEJBTEST_THRESH ON WEBLOGICEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBLOGICJDBCTEST;

CREATE TABLE WEBLOGICJDBCTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	CONN_USE_PCT 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_ST varchar(32) 	NOT NULL,
	CONN_PENDING 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_ST varchar(32) 	NOT NULL,
	MAX_CONNS		decimal(20,4)		NOT NULL,
	MAX_CONNS_ST	varchar(32) 	NOT NULL,
	CURR_CONNS		decimal(20,4)		NOT NULL,
	CURR_CONNS_ST	varchar(32)	NOT NULL,
	POOL_STATE		decimal(20,4)	NOT NULL,
	POOL_STATE_ST	varchar(32)	NOT NULL,
	FAIL_RECONNS	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_ST	varchar(32)	NOT NULL,
	CONNS_COUNT	decimal(20,4)	NOT NULL,
	CONNS_COUNT_ST	varchar(32)	NOT NULL,
	CONNS_DELAY		decimal(20,4)	NOT NULL,
	CONNS_DELAY_ST	varchar(32)	NOT NULL,
	LEAK_CONNS		decimal(20,4)	NOT NULL,
	LEAK_CONNS_ST	varchar(32)	NOT NULL,
	ACTIVE_HIGH		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_ST	varchar(32)	NOT NULL,
	WAIT_HIGH		decimal(20,4)	NOT NULL,
	WAIT_HIGH_ST	varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST ADD constraint PK_WEBLOGIC_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICJDBCTEST ON WEBLOGICJDBCTEST
(
	 MSMT_TIME
);

DROP TABLE WEBLOGICJDBCTEST_TREND;

CREATE TABLE WEBLOGICJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	CONN_USE_PCT_MIN 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_MAX 	decimal(20,4) 	NOT NULL,
	CONN_USE_PCT_STCNT 	varchar(32) 	NOT NULL,
	CONN_PENDING_MIN 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_MAX 	decimal(20,4) 	NOT NULL,
	CONN_PENDING_STCNT 	varchar(32) 	NOT NULL,
	MAX_CONNS_MIN		decimal(20,4)		NOT NULL,
	MAX_CONNS_MAX		decimal(20,4)		NOT NULL,
	MAX_CONNS_STCNT		varchar(32)		NOT NULL,
	CURR_CONNS_MIN		decimal(20,4)		NOT NULL,
	CURR_CONNS_MAX		decimal(20,4)		NOT NULL,
	CURR_CONNS_STCNT	varchar(32)			NOT NULL,
	POOL_STATE_MIN		decimal(20,4)	NOT NULL,
	POOL_STATE_MAX		decimal(20,4)	NOT NULL,
	POOL_STATE_STCNT	varchar(32)	NOT NULL,
	FAIL_RECONNS_MIN	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_MAX	decimal(20,4)	NOT NULL,
	FAIL_RECONNS_STCNT	varchar(32)	NOT NULL,
	CONNS_COUNT_MIN		decimal(20,4)	NOT NULL,
	CONNS_COUNT_MAX		decimal(20,4)	NOT NULL,
	CONNS_COUNT_STCNT	varchar(32)	NOT NULL,
	CONNS_DELAY_MIN		decimal(20,4)	NOT NULL,
	CONNS_DELAY_MAX		decimal(20,4)	NOT NULL,
	CONNS_DELAY_STCNT	varchar(32)	NOT NULL,
	LEAK_CONNS_MIN		decimal(20,4)	NOT NULL,
	LEAK_CONNS_MAX		decimal(20,4)	NOT NULL,
	LEAK_CONNS_STCNT	varchar(32)	NOT NULL,
	ACTIVE_HIGH_MIN		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_MAX		decimal(20,4)	NOT NULL,
	ACTIVE_HIGH_STCNT	varchar(32)	NOT NULL,
	WAIT_HIGH_MIN		decimal(20,4)	NOT NULL,
	WAIT_HIGH_MAX		decimal(20,4)	NOT NULL,
	WAIT_HIGH_STCNT		varchar(32)	NOT NULL

);

ALTER TABLE WEBLOGICJDBCTEST_TREND ADD constraint PK_WEBLOGIC_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICJDBCTEST_THRESH;

CREATE TABLE WEBLOGICJDBCTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	CONN_USE_PCT_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_USE_PCT_MAX	VARCHAR(256)	 	NOT NULL,
	CONN_PENDING_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_PENDING_MAX	VARCHAR(256)	 	NOT NULL,
	MAX_CONNS_MIN	VARCHAR(256)			NOT NULL,
	MAX_CONNS_MAX	VARCHAR(256)			NOT NULL,
	CURR_CONNS_MIN	VARCHAR(256)			NOT NULL,
	CURR_CONNS_MAX	VARCHAR(256)			NOT NULL,
	POOL_STATE_MIN	VARCHAR(256)			NOT NULL,
	POOL_STATE_MAX	VARCHAR(256)			NOT NULL,
	FAIL_RECONNS_MIN	VARCHAR(256)		NOT NULL,
	FAIL_RECONNS_MAX	VARCHAR(256)		NOT NULL,
	CONNS_COUNT_MIN	VARCHAR(256)		NOT NULL,
	CONNS_COUNT_MAX	VARCHAR(256)		NOT NULL,
	CONNS_DELAY_MIN	VARCHAR(256)		NOT NULL,
	CONNS_DELAY_MAX	VARCHAR(256)		NOT NULL,
	LEAK_CONNS_MIN	VARCHAR(256)		NOT NULL,
	LEAK_CONNS_MAX	VARCHAR(256)		NOT NULL,
	ACTIVE_HIGH_MIN	VARCHAR(256)		NOT NULL,
	ACTIVE_HIGH_MAX	VARCHAR(256)		NOT NULL,
	WAIT_HIGH_MIN	VARCHAR(256)		NOT NULL,
	WAIT_HIGH_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE WEBLOGICJDBCTEST_THRESH ADD constraint PK_WEBLOGIC_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICJDBCTEST_THRESH ON WEBLOGICJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
DROP TABLE WEBLOGICTEST;

CREATE TABLE WEBLOGICTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	THROUGHPUT 	decimal(20,4) 	NOT NULL,
	THROUGHPUT_ST 	varchar(32) 	NOT NULL,
	PCT_HEAP_USE 	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar(32) 	NOT NULL,
	EXECUTE_Q_LEN 	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_ST varchar(32) 	NOT NULL,
	TOTAL_HEAP		decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_ST	varchar(32)	NOT NULL,
	FREE_HEAP		decimal(20,4)	NOT NULL,	
	FREE_HEAP_ST	varchar(32)	NOT NULL
);

ALTER TABLE WEBLOGICTEST ADD constraint PK_WEB_LOGIC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBLOGICTEST ON WEBLOGICTEST
(
	 MSMT_TIME
);

DROP TABLE WEBLOGICTEST_TREND;

CREATE TABLE WEBLOGICTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	THROUGHPUT_MIN	        decimal(20,4) 	NOT NULL,
	THROUGHPUT_MAX	        decimal(20,4) 	NOT NULL,
	THROUGHPUT_STCNT 	varchar(32) 	NOT NULL,
	PCT_HEAP_USE_MIN	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar(32) 	NOT NULL,
	EXECUTE_Q_LEN_MIN	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_MAX	decimal(20,4) 	NOT NULL,
	EXECUTE_Q_LEN_STCNT 	varchar(32) 	NOT NULL,
	TOTAL_HEAP_MIN		decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_MAX	decimal(20,4) 	NOT NULL,
	TOTAL_HEAP_STCNT 	varchar(32) 	NOT NULL,
	FREE_HEAP_MIN		decimal(20,4) 	NOT NULL,
	FREE_HEAP_MAX		decimal(20,4) 	NOT NULL,
	FREE_HEAP_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_TREND ADD constraint PK_WEB_LOGIC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBLOGICTEST_THRESH;

CREATE TABLE WEBLOGICTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	THROUGHPUT_MIN	VARCHAR(256)	 	NOT NULL,
	THROUGHPUT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MIN	VARCHAR(256)	 	NOT NULL,
	EXECUTE_Q_LEN_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_HEAP_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_HEAP_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_HEAP_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_HEAP_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WEBLOGICTEST_THRESH ADD constraint PK_WEB_LOGIC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBLOGICTEST_THRESH ON WEBLOGICTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBSERVERTEST;

CREATE TABLE WEBSERVERTEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO 	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,  
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
        MSMT_TIME 	datetime NOT NULL,
        CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	REQ_RATE 	decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar(32)    NOT NULL,
	BYTE_RATE_IN 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar(32)    NOT NULL,
	PCT_ERR 	decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar(32)    NOT NULL,
	PCT_ABORT 	decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar(32)    NOT NULL,
	PCT_300_ERR 	decimal(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar(32)    NOT NULL,
	PCT_400_ERR 	decimal(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar(32)    NOT NULL,
	PCT_500_ERR 	decimal(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar(32)    NOT NULL,
        CURR_REQ 	decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar(32)    NOT NULL
	);

ALTER TABLE WEBSERVERTEST ADD CONSTRAINT PK_WEBMON_SERVER 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  NONCLUSTERED INDEX IDX_WEBSERVERTEST ON WEBSERVERTEST (MSMT_TIME) INCLUDE (REQ_RATE,PCT_ERR);

DROP TABLE WEBSERVERTEST_TREND;

CREATE TABLE WEBSERVERTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,  
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD	 			varchar(32) NOT NULL, 
        CONN_RATE_MIN 			decimal(20,4) 	NOT NULL,
        CONN_RATE_MAX 			decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)    NOT NULL,
	REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar(32)    NOT NULL,
	BYTE_RATE_IN_MIN    		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX    		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar(32)    NOT NULL,
	PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
	PCT_ABORT_MIN    		decimal(20,4) 	NOT NULL,
	PCT_ABORT_MAX    		decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar(32)    NOT NULL,
	PCT_300_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_400_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_500_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar(32)    NOT NULL,
        CURR_REQ_MIN     		decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX     		decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar(32)    NOT NULL
);

ALTER TABLE WEBSERVERTEST_TREND ADD CONSTRAINT PK_WEBMON_SERVER_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSERVERTEST_THRESH;

CREATE TABLE WEBSERVERTEST_THRESH
(
	TRGT_HOST 	  varchar(32) NOT NULL,
	PORT_NO 	  varchar(32) NOT NULL,
        SITE_NAME         varchar(64) NOT NULL,  
        INFO              varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	  datetime NOT NULL,
        MSMT_TIME_END     datetime NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	  NOT NULL
     );
ALTER TABLE WEBSERVERTEST_THRESH ADD CONSTRAINT PK_WEBMON_SERVER_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSERVERTEST_THRESH ON WEBSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WEBSITETEST;

CREATE TABLE WEBSITETEST 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO 	varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,  
        INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
        MSMT_TIME 	datetime NOT NULL,
        CONN_RATE 	decimal(20,4) 	NOT NULL,
	CONN_RATE_ST 	varchar(32)    NOT NULL,
	REQ_RATE 	decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST varchar(32)    NOT NULL,
	BYTE_RATE_IN 	decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_ST	varchar(32)    NOT NULL,
	PCT_ERR 	decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 	varchar(32)    NOT NULL,
	PCT_ABORT 	decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	varchar(32)    NOT NULL,
	PCT_300_ERR 	decimal(20,4) 	NOT NULL,
	PCT_300_ERR_ST 	varchar(32)    NOT NULL,
	PCT_400_ERR 	decimal(20,4) 	NOT NULL,
	PCT_400_ERR_ST 	varchar(32)    NOT NULL,
	PCT_500_ERR 	decimal(20,4) 	NOT NULL,
	PCT_500_ERR_ST 	varchar(32)    NOT NULL,
        CURR_REQ 	decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	varchar(32)    NOT NULL
	);

ALTER TABLE WEBSITETEST ADD CONSTRAINT PK_WEBSITE 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WEBSITETEST ON WEBSITETEST (MSMT_TIME) INCLUDE (REQ_RATE,BYTE_RATE_OUT,BYTE_RATE_IN,PCT_ERR);
create index idx1_websitetest on websitetest(site_name);
DROP TABLE WEBSITETEST_TREND;

CREATE TABLE WEBSITETEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME       		varchar(64) NOT NULL,  
        INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD  			varchar(32) NOT NULL, 
        CONN_RATE_MIN 			decimal(20,4) 	NOT NULL,
        CONN_RATE_MAX 			decimal(20,4) 	NOT NULL,
	CONN_RATE_STCNT 		varchar(32)    NOT NULL,
	REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 			varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 		decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT 		varchar(32)    NOT NULL,
	BYTE_RATE_IN_MIN 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_MAX 		decimal(20,4) 	NOT NULL,
	BYTE_RATE_IN_STCNT		varchar(32)    NOT NULL,
	PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
	PCT_ABORT_MIN 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 		varchar(32)    NOT NULL,
	PCT_300_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_300_ERR_STCNT		varchar(32)    NOT NULL,
	PCT_400_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_400_ERR_STCNT 		varchar(32)    NOT NULL,
	PCT_500_ERR_MIN 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_MAX 		decimal(20,4) 	NOT NULL,
	PCT_500_ERR_STCNT 		varchar(32)    NOT NULL,
        CURR_REQ_MIN 			decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX 			decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 			varchar(32)    NOT NULL
);

ALTER TABLE WEBSITETEST_TREND ADD CONSTRAINT PK_WEBSITE_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETEST_THRESH;

CREATE TABLE WEBSITETEST_THRESH
(
	TRGT_HOST 	  varchar(32) NOT NULL,
	PORT_NO 	  varchar(32) NOT NULL,
        SITE_NAME         varchar(64) NOT NULL,  
        INFO              varchar(128) NOT NULL,
	MSMT_HOST 	  varchar(32) NOT NULL, 
	MSMT_TIME_START	  datetime NOT NULL,
        MSMT_TIME_END     datetime NOT NULL,
        CONN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CONN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_IN_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_IN_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_300_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_400_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_500_ERR_MAX	VARCHAR(256)	 	NOT NULL,
	CURR_REQ_MIN	VARCHAR(256)	  NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	  NOT NULL
     );
ALTER TABLE WEBSITETEST_THRESH ADD CONSTRAINT PK_WEBSITE_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETEST_THRESH ON WEBSITETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);       

DROP TABLE   WEBSITETRANSACTIONTEST;

CREATE TABLE WEBSITETRANSACTIONTEST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        REQ_RATE 		decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar(32)    NOT NULL,
        PCT_ERR 		decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar(32)    NOT NULL,
        PCT_ABORT 		decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	        decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar(32)    NOT NULL,
        AVG_RESP_TIME 	        decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar(32) 	NOT NULL,
        CURR_REQ 		decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST ADD CONSTRAINT PK_WEBSITE_TRAN 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WEBSITETRANSACTIONTEST ON WEBSITETRANSACTIONTEST
(
	 MSMT_TIME
);
create index idx1_WebSiteTransactionTest on WebSiteTransactionTest(site_name);

DROP TABLE   WEBSITETRANSACTIONTEST_TREND;

CREATE TABLE WEBSITETRANSACTIONTEST_TREND 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO 			varchar(32) NOT NULL,
        SITE_NAME               	varchar(64) NOT NULL,  
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL, 
        REQ_RATE_MIN 			decimal(20,4) 	NOT NULL,
        REQ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	REQ_RATE_STCNT 	       		varchar(32)    NOT NULL,
        PCT_ERR_MIN 			decimal(20,4) 	NOT NULL,
        PCT_ERR_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ERR_STCNT 			varchar(32)    NOT NULL,
        PCT_ABORT_MIN 			decimal(20,4) 	NOT NULL,
        PCT_ABORT_MAX 			decimal(20,4) 	NOT NULL,
	PCT_ABORT_STCNT 	       	varchar(32)    NOT NULL,
        BYTE_RATE_OUT_MIN 	       	decimal(20,4) 	NOT NULL,
        BYTE_RATE_OUT_MAX 	       	decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_STCNT		varchar(32)    NOT NULL,
        AVG_RESP_TIME_MIN 	       	decimal(20,4) 	NOT NULL,
        AVG_RESP_TIME_MAX 	       	decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_STCNT        	varchar(32) 	NOT NULL,
        CURR_REQ_MIN 			decimal(20,4) 	NOT NULL,
        CURR_REQ_MAX 			decimal(20,4) 	NOT NULL,
	CURR_REQ_STCNT 	       		varchar(32)    NOT NULL
      );
ALTER TABLE WEBSITETRANSACTIONTEST_TREND ADD CONSTRAINT PK_WEBSITE_TRAN_TREND 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WEBSITETRANSACTIONTEST_THRESH;
CREATE TABLE WEBSITETRANSACTIONTEST_THRESH
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START 	datetime NOT NULL,
        MSMT_TIME_END           datetime NOT NULL,
        REQ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
        PCT_ERR_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ERR_MAX	VARCHAR(256)	 	NOT NULL,
        PCT_ABORT_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_ABORT_MAX	VARCHAR(256)	 	NOT NULL,
        BYTE_RATE_OUT_MIN	VARCHAR(256)	 	NOT NULL,
	BYTE_RATE_OUT_MAX	VARCHAR(256)	 	NOT NULL,
        AVG_RESP_TIME_MIN	VARCHAR(256)	    NOT NULL,
        AVG_RESP_TIME_MAX	VARCHAR(256)	    NOT NULL,
        CURR_REQ_MIN	VARCHAR(256)	    NOT NULL,
        CURR_REQ_MAX	VARCHAR(256)	    NOT NULL
     );
ALTER TABLE WEBSITETRANSACTIONTEST_THRESH ADD CONSTRAINT PK_WEBSITE_TRAN_THRESH 
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WEBSITETRANSTEST_THRESH ON WEBSITETRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);     
DROP TABLE   WEBSITETRANSACTIONTEST_LAST;

CREATE TABLE WEBSITETRANSACTIONTEST_LAST 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO 		varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,  
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
        MSMT_TIME 		datetime NOT NULL,
        REQ_RATE 		decimal(20,4) 	NOT NULL,
	REQ_RATE_ST 	        varchar(32)    NOT NULL,
        PCT_ERR 		decimal(20,4) 	NOT NULL,
	PCT_ERR_ST 		varchar(32)    NOT NULL,
        PCT_ABORT 		decimal(20,4) 	NOT NULL,
	PCT_ABORT_ST 	        varchar(32)    NOT NULL,
        BYTE_RATE_OUT 	        decimal(20,4) 	NOT NULL,
	BYTE_RATE_OUT_ST	varchar(32)    NOT NULL,
        AVG_RESP_TIME 	        decimal(20,4) 	NOT NULL,
	AVG_RESP_TIME_ST        varchar(32) 	NOT NULL,
        CURR_REQ 		decimal(20,4) 	NOT NULL,
	CURR_REQ_ST 	        varchar(32)    NOT NULL
    );

ALTER TABLE WEBSITETRANSACTIONTEST_LAST ADD CONSTRAINT PK_WEBSITE_TRAN_LAST 
primary key (TRGT_HOST,PORT_NO,SITE_NAME,INFO);
create index idx_websitetranstest_last on websitetransactiontest_last(site_name);

DROP TABLE WINSERVICETEST;

CREATE TABLE WINSERVICETEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	AVAIL		decimal(3) 	NOT NULL,
	AVAIL_ST	varchar(32)    NOT NULL,
	SERVICE_STATE	decimal(3) 	NOT NULL,
	SERVICE_STATE_ST	varchar(32)    NOT NULL
);

ALTER TABLE WINSERVICETEST ADD constraint PK_WINSERVICE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WINSERVICETEST ON WINSERVICETEST
(
	 MSMT_TIME
);

DROP TABLE WINSERVICETEST_TREND;

CREATE TABLE WINSERVICETEST_TREND 
(
	TRGT_HOST 		varchar(32) NOT NULL,
        PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME       	varchar(64) NOT NULL,
        INFO            	varchar(128) NOT NULL, 
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	AVAIL_MIN		decimal(20,4) 	NOT NULL,
	AVAIL_MAX		decimal(20,4) 	NOT NULL,
	AVAIL_STCNT		varchar(32)   	NOT NULL,
	SERVICE_STATE_MIN		decimal(20,4) 	NOT NULL,
	SERVICE_STATE_MAX		decimal(20,4) 	NOT NULL,
	SERVICE_STATE_STCNT		varchar(32)   	NOT NULL
);

ALTER TABLE WINSERVICETEST_TREND ADD constraint PK_WINSERVICE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WINSERVICETEST_THRESH;

CREATE TABLE WINSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
        PORT_NO         varchar(32) NOT NULL,
        SITE_NAME       varchar(64) NOT NULL,
        INFO            varchar(128) NOT NULL, 
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	AVAIL_MIN	VARCHAR(256)	 	NOT NULL,
	AVAIL_MAX	VARCHAR(256)	 	NOT NULL,
	SERVICE_STATE_MIN	VARCHAR(256)	 	NOT NULL,
	SERVICE_STATE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WINSERVICETEST_THRESH ADD constraint PK_WINSERVICE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WINSERVICETEST_THRESH ON WINSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);      

DROP TABLE MEASURE_LAST ;

CREATE TABLE MEASURE_LAST
(
	TEST_NAME 	varchar(64) not null,
	TRGT_HOST 	varchar(32) not null,
	PORT_NO 	varchar(32) not null,
        SITE_NAME       varchar(64) not null,    
        INFO            varchar(128) not null,
	MSMT_HOST 	varchar(32) not null, 
        MSMT_TIME 	datetime
);

alter table MEASURE_LAST add constraint PK_MEASURE_LAST 
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST);
create index idx_measure_last on measure_last(site_name);
create index idx1_measure_last on measure_last(trgt_host) include (test_name,msmt_host);       
CREATE NONCLUSTERED INDEX IDX2_MEASURE_LAST ON MEASURE_LAST (TEST_NAME, PORT_NO) INCLUDE (TRGT_HOST, INFO, SITE_NAME, MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX3_MEASURE_LAST ON MEASURE_LAST ( INFO, MSMT_TIME) INCLUDE (TRGT_HOST, PORT_NO);
       
DROP TABLE SILVERSTREAMTEST  ;

CREATE TABLE SILVERSTREAMTEST 
(
	TRGT_HOST 		varchar(32) not null,
        PORT_NO                 varchar(32) not null,
        SITE_NAME               varchar(64) not null,  
        INFO                    varchar(128) not null,
	MSMT_HOST 		varchar(32) not null, 
        MSMT_TIME 		datetime not null,
	SERVER_USAGE_METRIC	decimal(20,4) 	NOT NULL,
	SERVER_USAGE_METRIC_ST	varchar(32)    NOT NULL,
	USED_THREAD_PCT 	decimal(20,4) 	NOT NULL,
	USED_THREAD_PCT_ST 	varchar(32)    NOT NULL,
	IDLE_THREAD_PCT 	decimal(20,4) 	NOT NULL,
	IDLE_THREAD_PCT_ST 	varchar(32)    NOT NULL,
	REQUEST_RATE            decimal(20,4)    NOT NULL,
	REQUEST_RATE_ST         varchar(32)    NOT NULL,
	MEAN_RESPONSE_TIME      decimal(20,4)      NOT NULL,
	MEAN_RESPONSE_TIME_ST   varchar(32)    NOT NULL,
	MAX_RESPONSE_TIME       decimal(20,4)      NOT NULL,
        MAX_RESPONSE_TIME_ST    varchar(32)    NOT NULL,
	DATA_XMIT_RATE    	decimal(20,4)    NOT NULL,
	DATA_XMIT_RATE_ST 	varchar(32)    NOT NULL,
	MEMORY_UTIL         	decimal(20,4)     NOT NULL,
	MEMORY_UTIL_ST      	varchar(32)    NOT NULL,
	TOTAL_SESS_COUNT        decimal(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_ST     varchar(32)    NOT NULL,
	IDLE_SESS_COUNT         decimal(20,4)      NOT NULL,
	IDLE_SESS_COUNT_ST      varchar(32)    NOT NULL
);

ALTER TABLE SILVERSTREAMTEST ADD CONSTRAINT PK_SILVER_STREAM PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SILVERSTREAMTEST ON SILVERSTREAMTEST
(
	 MSMT_TIME
);
DROP TABLE SILVERSTREAMTEST_TREND ;
CREATE TABLE SILVERSTREAMTEST_TREND 
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                 	varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	PERIOD 				varchar(32) not null, 
	SERVER_USAGE_METRIC_MIN		decimal(20,4)     NOT NULL,
	SERVER_USAGE_METRIC_MAX		decimal(20,4)     NOT NULL,
 	SERVER_USAGE_METRIC_STCNT	varchar(32)    NOT NULL,
 	USED_THREAD_PCT_MIN		decimal(20,4)      NOT NULL,
 	USED_THREAD_PCT_MAX		decimal(20,4)      NOT NULL,
 	USED_THREAD_PCT_STCNT    	varchar(32)    NOT NULL,
        IDLE_THREAD_PCT_MIN		decimal(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_MAX		decimal(20,4)      NOT NULL,
 	IDLE_THREAD_PCT_STCNT    	varchar(32)    NOT NULL,
 	REQUEST_RATE_MIN		decimal(20,4)    NOT NULL,
 	REQUEST_RATE_MAX		decimal(20,4)    NOT NULL,
 	REQUEST_RATE_STCNT		varchar(32)    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN		decimal(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX		decimal(20,4)      NOT NULL,
 	MEAN_RESPONSE_TIME_STCNT	varchar(32)    NOT NULL,
 	MAX_RESPONSE_TIME_MIN		decimal(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_MAX		decimal(20,4)      NOT NULL,
 	MAX_RESPONSE_TIME_STCNT		varchar(32)    NOT NULL,
 	DATA_XMIT_RATE_MIN    		decimal(20,4)    NOT NULL,
 	DATA_XMIT_RATE_MAX    		decimal(20,4)    NOT NULL,
        DATA_XMIT_RATE_STCNT 		varchar(32)    NOT NULL,
        MEMORY_UTIL_MIN         	decimal(20,4)     NOT NULL,
        MEMORY_UTIL_MAX         	decimal(20,4)     NOT NULL,
        MEMORY_UTIL_STCNT      		varchar(32)    NOT NULL,
 	TOTAL_SESS_COUNT_MIN		decimal(20,4)      NOT NULL,
 	TOTAL_SESS_COUNT_MAX		decimal(20,4)      NOT NULL,
	TOTAL_SESS_COUNT_STCNT		varchar(32)    NOT NULL,
        IDLE_SESS_COUNT_MIN            	decimal(20,4)      NOT NULL,
        IDLE_SESS_COUNT_MAX            	decimal(20,4)      NOT NULL,
	IDLE_SESS_COUNT_STCNT		varchar(32)    NOT NULL

);

ALTER TABLE SILVERSTREAMTEST_TREND ADD CONSTRAINT PK_SILVER_STREAM_TREND PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE SILVERSTREAMTEST_THRESH ;
CREATE TABLE SILVERSTREAMTEST_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                 	varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START 		datetime not null,
        MSMT_TIME_END           	datetime not null,
	SERVER_USAGE_METRIC_MIN	VARCHAR(256)	     NOT NULL,
	SERVER_USAGE_METRIC_MAX	VARCHAR(256)	     NOT NULL,
 	USED_THREAD_PCT_MIN	VARCHAR(256)	      NOT NULL,
 	USED_THREAD_PCT_MAX	VARCHAR(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MIN	VARCHAR(256)	      NOT NULL,
 	IDLE_THREAD_PCT_MAX	VARCHAR(256)	      NOT NULL,
 	REQUEST_RATE_MIN	VARCHAR(256)	    NOT NULL,
 	REQUEST_RATE_MAX	VARCHAR(256)	    NOT NULL,
 	MEAN_RESPONSE_TIME_MIN	VARCHAR(256)	      NOT NULL,
 	MEAN_RESPONSE_TIME_MAX	VARCHAR(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MIN	VARCHAR(256)	      NOT NULL,
 	MAX_RESPONSE_TIME_MAX	VARCHAR(256)	      NOT NULL,
 	DATA_XMIT_RATE_MIN	VARCHAR(256)	    NOT NULL,
 	DATA_XMIT_RATE_MAX	VARCHAR(256)	    NOT NULL,
        MEMORY_UTIL_MIN	VARCHAR(256)	     NOT NULL,
        MEMORY_UTIL_MAX	VARCHAR(256)	     NOT NULL,
 	TOTAL_SESS_COUNT_MIN	VARCHAR(256)	      NOT NULL,
 	TOTAL_SESS_COUNT_MAX	VARCHAR(256)	      NOT NULL,
        IDLE_SESS_COUNT_MIN	VARCHAR(256)	      NOT NULL,
        IDLE_SESS_COUNT_MAX	VARCHAR(256)	      NOT NULL
);

ALTER TABLE SILVERSTREAMTEST_THRESH ADD CONSTRAINT PK_SILVER_STREAM_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_SILVERSTREAMTEST_THRESH ON SILVERSTREAMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2LOCKANDDEADLOCKTEST  ;

CREATE TABLE DB2LOCKANDDEADLOCKTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	TOTAL_DEADLOCKS 		decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_ST 		varchar(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL	 	decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_ST 	varchar(32) 	NOT NULL,
	LOCKS_HELD        		decimal(20,4)	NOT NULL,
	LOCKS_HELD_ST   		varchar(32)	NOT NULL,
	LOCK_TIMEOUTS	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_ST 		varchar(32)  	NOT NULL,
	LOCK_ESCALATIONS 		decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_ST 		varchar(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_ST 	varchar(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST ADD CONSTRAINT PK_DB2_LOCK
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2LOCKANDDEADLOCKTEST ON DB2LOCKANDDEADLOCKTEST
(
	 MSMT_TIME
);
DROP TABLE DB2LOCKANDDEADLOCKTEST_TREND ;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	TOTAL_DEADLOCKS_MIN 			decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_MAX 			decimal(20,4) 	NOT NULL,
	TOTAL_DEADLOCKS_STCNT 			varchar(32)  	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN		decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX		decimal(20,4) 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_STCNT		varchar(32) 	NOT NULL,
	LOCKS_HELD_MIN        			decimal(20,4)	NOT NULL,
	LOCKS_HELD_MAX        			decimal(20,4)	NOT NULL,
	LOCKS_HELD_STCNT   			varchar(32)	NOT NULL,
	LOCK_TIMEOUTS_MIN	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_MAX	 		decimal(20,4) 	NOT NULL,
	LOCK_TIMEOUTS_STCNT 			varchar(32)  	NOT NULL,
	LOCK_ESCALATIONS_MIN 			decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_MAX 			decimal(20,4) 	NOT NULL,
	LOCK_ESCALATIONS_STCNT 			varchar(32) 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX  		decimal(20,4)	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_STCNT 		varchar(32)	NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_TREND ADD CONSTRAINT PK_DB2_LOCK_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2LOCKANDDEADLOCKTEST_THRESH ;
CREATE TABLE DB2LOCKANDDEADLOCKTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	TOTAL_DEADLOCKS_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_DEADLOCKS_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_EXCL_LOCK_ESCAL_MAX	VARCHAR(256)	 	NOT NULL,
	LOCKS_HELD_MIN	VARCHAR(256)		NOT NULL,
	LOCKS_HELD_MAX	VARCHAR(256)		NOT NULL,
	LOCK_TIMEOUTS_MIN	VARCHAR(256)	 	NOT NULL,
	LOCK_TIMEOUTS_MAX	VARCHAR(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MIN	VARCHAR(256)	 	NOT NULL,
	LOCK_ESCALATIONS_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MIN	VARCHAR(256)		NOT NULL,
	PCT_APPL_IN_LOCK_WAIT_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2LOCKANDDEADLOCKTEST_THRESH ADD CONSTRAINT PK_DB2_LOCK_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2LOCKTEST_THRESH ON DB2LOCKANDDEADLOCKTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2SORTTEST  ;

CREATE TABLE DB2SORTTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	AVG_SORT_TIME	 		decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_ST	 	varchar(32)  	NOT NULL,
	PCT_SORT_OVERFLOW	 	decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST ADD CONSTRAINT PK_DB2SORTTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2SORTTEST ON DB2SORTTEST
(
	 MSMT_TIME
);
DROP TABLE DB2SORTTEST_TREND ;
CREATE TABLE DB2SORTTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	AVG_SORT_TIME_MIN 			decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_MAX 			decimal(20,4) 	NOT NULL,
	AVG_SORT_TIME_STCNT			varchar(32) 	NOT NULL,
	PCT_SORT_OVERFLOW_MIN 			decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_MAX 			decimal(20,4) 	NOT NULL,
	PCT_SORT_OVERFLOW_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2SORTTEST_TREND ADD CONSTRAINT PK_DB2SORTTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SORTTEST_THRESH ;
CREATE TABLE DB2SORTTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	AVG_SORT_TIME_MIN	VARCHAR(256)		NOT NULL,
	AVG_SORT_TIME_MAX	VARCHAR(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MIN	VARCHAR(256)		NOT NULL,
	PCT_SORT_OVERFLOW_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2SORTTEST_THRESH ADD CONSTRAINT PK_DB2SORTTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2SORTTEST_THRESH ON DB2SORTTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2BUFFERPOOLTEST  ;

CREATE TABLE DB2BUFFERPOOLTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	PCT_POOL_HIT_RATIO 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_ST 		varchar(32)  	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_ST 	varchar(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO         decimal(20,4)	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_ST      varchar(32)	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST ADD CONSTRAINT PK_DB2BUFFERPOOLTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2BUFFERPOOLTEST ON DB2BUFFERPOOLTEST
(
	 MSMT_TIME
);

DROP TABLE DB2BUFFERPOOLTEST_TREND ;
CREATE TABLE DB2BUFFERPOOLTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	PCT_POOL_HIT_RATIO_MIN 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_MAX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_STCNT		varchar(32) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX 		decimal(20,4) 	NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_STCNT		varchar(32) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN 		decimal(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX 		decimal(20,4) 	NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_TREND ADD CONSTRAINT PK_DB2BUFFER_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2BUFFERPOOLTEST_THRESH ;
CREATE TABLE DB2BUFFERPOOLTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	PCT_POOL_HIT_RATIO_MIN	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_MAX	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MIN	VARCHAR(256)		NOT NULL,
	PCT_POOL_HIT_RATIO_IDX_MAX	VARCHAR(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MIN	VARCHAR(256)		NOT NULL,
	PCT_CAT_CACHE_HIT_RATIO_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2BUFFERPOOLTEST_THRESH ADD CONSTRAINT PK_DB2_BUFFER_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2BUFFERPOOLTEST_THRESH ON DB2BUFFERPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2INSTANCETEST ;

CREATE TABLE DB2INSTANCETEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	PCT_AGENTS_WAITING	 	decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_ST 		varchar(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED 	decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_ST 	varchar(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED 	decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_ST	varchar(32)	NOT NULL,
	AGENTS_REGISTERED		decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_ST 		varchar(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_ST	varchar(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST ADD CONSTRAINT PK_DB2_INSTANCE
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2INSTANCETEST ON DB2INSTANCETEST
(
	 MSMT_TIME
);

DROP TABLE DB2INSTANCETEST_TREND ;
CREATE TABLE DB2INSTANCETEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	PCT_AGENTS_WAITING_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	 		decimal(20,4) 	NOT NULL,
	PCT_AGENTS_WAITING_STCNT 		varchar(32)  	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN 		decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX 		decimal(20,4) 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_STCNT 		varchar(32) 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN 		decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX 		decimal(20,4)	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_STCNT		varchar(32)	NOT NULL,
	AGENTS_REGISTERED_MIN			decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_MAX			decimal(20,4) 	NOT NULL,
	AGENTS_REGISTERED_STCNT 		varchar(32)  	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX		decimal(20,4) 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_TREND ADD CONSTRAINT PK_DB2_INSTANCE_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2INSTANCETEST_THRESH ;
CREATE TABLE DB2INSTANCETEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	PCT_AGENTS_WAITING_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_AGENTS_WAITING_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_ACCEPTED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MIN	VARCHAR(256)		NOT NULL,
	PCT_PIPED_SORTS_REJECTED_MAX	VARCHAR(256)		NOT NULL,
	AGENTS_REGISTERED_MIN	VARCHAR(256)	 	NOT NULL,
	AGENTS_REGISTERED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_AGTS_FROM_EPTY_POOL_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE DB2INSTANCETEST_THRESH ADD CONSTRAINT PK_DB2_INSTANCE_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2INSTANCETEST_THRESH ON DB2INSTANCETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DB2IOTEST  ;

CREATE TABLE DB2IOTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	DIRECT_READ_RATE 		decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_ST 		varchar(32)  	NOT NULL,
	DIRECT_WRITE_RATE 		decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_ST 		varchar(32)  	NOT NULL,
	BUF_POOL_IO_RATE         	decimal(20,4)	NOT NULL,
	BUF_POOL_IO_RATE_ST         	varchar(32)	NOT NULL
);

ALTER TABLE DB2IOTEST ADD CONSTRAINT PK_DB2IOTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2IOTEST ON DB2IOTEST
(
	 MSMT_TIME
);

DROP TABLE DB2IOTEST_TREND ;
CREATE TABLE DB2IOTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	DIRECT_READ_RATE_MIN 			decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_MAX 			decimal(20,4) 	NOT NULL,
	DIRECT_READ_RATE_STCNT			varchar(32) 	NOT NULL,
	DIRECT_WRITE_RATE_MIN 			decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	DIRECT_WRITE_RATE_STCNT			varchar(32) 	NOT NULL,
	BUF_POOL_IO_RATE_MIN 			decimal(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_MAX 			decimal(20,4) 	NOT NULL,
	BUF_POOL_IO_RATE_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2IOTEST_TREND ADD CONSTRAINT PK_DB2IOTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2IOTEST_THRESH ;
CREATE TABLE DB2IOTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	DIRECT_READ_RATE_MIN	VARCHAR(256)		NOT NULL,
	DIRECT_READ_RATE_MAX	VARCHAR(256)		NOT NULL,
	DIRECT_WRITE_RATE_MIN	VARCHAR(256)		NOT NULL,
	DIRECT_WRITE_RATE_MAX	VARCHAR(256)		NOT NULL,
	BUF_POOL_IO_RATE_MIN	VARCHAR(256)		NOT NULL,
	BUF_POOL_IO_RATE_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2IOTEST_THRESH ADD CONSTRAINT PK_DB2IOTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2IOTEST_THRESH ON DB2IOTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE DB2SQLACTIVITYTEST ;

CREATE TABLE DB2SQLACTIVITYTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	DYNAMIC_SQL_RATE	 	decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_ST 		varchar(32)  	NOT NULL,
	SELECT_SQL_RATE		 	decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_ST	 	varchar(32) 	NOT NULL,
	FAILED_SQL_RATE        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_ST   		varchar(32)	NOT NULL,
	UID_SQL_RATE	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_ST 		varchar(32)  	NOT NULL,
	PCT_FAILED_SQL	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_ST 		varchar(32) 	NOT NULL,
	PCT_DDL_SQL  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_ST			varchar(32)	NOT NULL,
	PCT_UID_SQL  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_ST	 		varchar(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST ADD CONSTRAINT PK_DB2_SQLACTIVITY
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DB2SQLACTIVITYTEST ON DB2SQLACTIVITYTEST
(
	 MSMT_TIME
);

DROP TABLE DB2SQLACTIVITYTEST_TREND ;
CREATE TABLE DB2SQLACTIVITYTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	DYNAMIC_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	DYNAMIC_SQL_RATE_STCNT 			varchar(32)  	NOT NULL,
	SELECT_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	SELECT_SQL_RATE_STCNT	 		varchar(32) 	NOT NULL,
	FAILED_SQL_RATE_MIN        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_MAX        		decimal(20,4)	NOT NULL,
	FAILED_SQL_RATE_STCNT   		varchar(32)	NOT NULL,
	UID_SQL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_MAX	 		decimal(20,4) 	NOT NULL,
	UID_SQL_RATE_STCNT 			varchar(32)  	NOT NULL,
	PCT_FAILED_SQL_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_MAX	 		decimal(20,4) 	NOT NULL,
	PCT_FAILED_SQL_STCNT 			varchar(32) 	NOT NULL,
	PCT_DDL_SQL_MIN  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_MAX  			decimal(20,4)	NOT NULL,
	PCT_DDL_SQL_STCNT			varchar(32)	NOT NULL,
	PCT_UID_SQL_MIN  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_MAX  			decimal(20,4)	NOT NULL,
	PCT_UID_SQL_STCNT	 		varchar(32)	NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_TREND ADD CONSTRAINT PK_DB2_SQLACTIVITY_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2SQLACTIVITYTEST_THRESH ;
CREATE TABLE DB2SQLACTIVITYTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	DYNAMIC_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DYNAMIC_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	SELECT_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SELECT_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	FAILED_SQL_RATE_MIN	VARCHAR(256)		NOT NULL,
	FAILED_SQL_RATE_MAX	VARCHAR(256)		NOT NULL,
	UID_SQL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	UID_SQL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_FAILED_SQL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_FAILED_SQL_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_DDL_SQL_MIN	VARCHAR(256)		NOT NULL,
	PCT_DDL_SQL_MAX	VARCHAR(256)		NOT NULL,
	PCT_UID_SQL_MIN	VARCHAR(256)		NOT NULL,
	PCT_UID_SQL_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2SQLACTIVITYTEST_THRESH ADD CONSTRAINT PK_DB2_SQLACTIVITY_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;


CREATE INDEX IDX_DB2SQLACTIVITYTEST_THRESH ON DB2SQLACTIVITYTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DB2TRANSACTIONTEST  ;

CREATE TABLE DB2TRANSACTIONTEST
(
	TRGT_HOST 			varchar(32) not null,
        PORT_NO                		varchar(32) not null,
        SITE_NAME               	varchar(64) not null,  
        INFO                    	varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
        MSMT_TIME 			datetime not null,
	COMM_STMT_RATE	 		decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_ST 		varchar(32)  	NOT NULL,
	ROLLBACK_RATE		 	decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_ST	 	varchar(32) 	NOT NULL,
	TRANSACTION_RATE 	        decimal(20,4)	NOT NULL,
	TRANSACTION_RATE_ST     	 varchar(32)	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST ADD CONSTRAINT PK_DB2TRANSACTIONTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DB2TRANSACTIONTEST ON DB2TRANSACTIONTEST
(
	 MSMT_TIME
);

DROP TABLE DB2TRANSACTIONTEST_TREND ;
CREATE TABLE DB2TRANSACTIONTEST_TREND 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME 				datetime not null,
	PERIOD 					varchar(32) not null, 
	COMM_STMT_RATE_MIN 			decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_MAX 			decimal(20,4) 	NOT NULL,
	COMM_STMT_RATE_STCNT			varchar(32) 	NOT NULL,
	ROLLBACK_RATE_MIN 			decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_MAX 			decimal(20,4) 	NOT NULL,
	ROLLBACK_RATE_STCNT			varchar(32) 	NOT NULL,
	TRANSACTION_RATE_MIN 			decimal(20,4) 	NOT NULL,
	TRANSACTION_RATE_MAX 			decimal(20,4) 	NOT NULL,
	TRANSACTION_RATE_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_TREND ADD CONSTRAINT PK_DB2TRANSACTIONTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DB2TRANSACTIONTEST_THRESH ;
CREATE TABLE DB2TRANSACTIONTEST_THRESH 
(
	TRGT_HOST 				varchar(32) not null,
        PORT_NO                 		varchar(32) not null,
        SITE_NAME               		varchar(64) not null,  
        INFO                    		varchar(128) not null,
	MSMT_HOST 				varchar(32) not null, 
	MSMT_TIME_START 			datetime not null,
        MSMT_TIME_END           		datetime not null,
	COMM_STMT_RATE_MIN	VARCHAR(256)		NOT NULL,
	COMM_STMT_RATE_MAX	VARCHAR(256)		NOT NULL,
	ROLLBACK_RATE_MIN	VARCHAR(256)		NOT NULL,
	ROLLBACK_RATE_MAX	VARCHAR(256)		NOT NULL,
	TRANSACTION_RATE_MIN	VARCHAR(256)		NOT NULL,
	TRANSACTION_RATE_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE DB2TRANSACTIONTEST_THRESH ADD CONSTRAINT PK_DB2TRANSACTIONTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DB2TRANSACTIONTEST_THRESH ON DB2TRANSACTIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDataCacheTest;
CREATE TABLE SybDataCacheTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
UTILIZATION DECIMAL(20,4) NOT NULL,
UTILIZATION_ST varchar(32) NOT NULL,
CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
SPINLOCK_CONTENTION DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_ST varchar(32) NOT NULL,
BUFFERS_GRABBED DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_ST varchar(32) NOT NULL,
BUFFERS_GRABBED_DIRTY DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_ST varchar(32) NOT NULL,
PCT_LARGE_IO_DENIED DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_ST varchar(32) NOT NULL,
LARGE_IO_EFFECTIVENESS DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_ST varchar(32) NOT NULL);

ALTER TABLE SybDataCacheTest ADD constraint PK_SybDataCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybDataCacheTest ON SybDataCacheTest
(
	 MSMT_TIME
);

DROP TABLE SybDataCacheTest_TREND;
CREATE TABLE SybDataCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
UTILIZATION_MIN DECIMAL(20,4) NOT NULL,
UTILIZATION_MAX DECIMAL(20,4) NOT NULL,
UTILIZATION_STCNT varchar(32) NOT NULL,
CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
SPINLOCK_CONTENTION_MIN DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_MAX DECIMAL(20,4) NOT NULL,
SPINLOCK_CONTENTION_STCNT varchar(32) NOT NULL,
BUFFERS_GRABBED_MIN DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_MAX DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_STCNT varchar(32) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX DECIMAL(20,4) NOT NULL,
BUFFERS_GRABBED_DIRTY_STCNT varchar(32) NOT NULL,
PCT_LARGE_IO_DENIED_MIN DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_MAX DECIMAL(20,4) NOT NULL,
PCT_LARGE_IO_DENIED_STCNT varchar(32) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX DECIMAL(20,4) NOT NULL,
LARGE_IO_EFFECTIVENESS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybDataCacheTest_TREND ADD constraint PK_SybDataCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDataCacheTest_THRESH;
CREATE TABLE SybDataCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
UTILIZATION_MIN VARCHAR(256) NOT NULL,
UTILIZATION_MAX VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR(256) NOT NULL,
SPINLOCK_CONTENTION_MIN VARCHAR(256) NOT NULL,
SPINLOCK_CONTENTION_MAX VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_MIN VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_MAX VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MIN VARCHAR(256) NOT NULL,
BUFFERS_GRABBED_DIRTY_MAX VARCHAR(256) NOT NULL,
PCT_LARGE_IO_DENIED_MIN VARCHAR(256) NOT NULL,
PCT_LARGE_IO_DENIED_MAX VARCHAR(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MIN VARCHAR(256) NOT NULL,
LARGE_IO_EFFECTIVENESS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybDataCacheTest_THRESH ADD constraint PK_SybDataCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDataCacheTest_THRESH ON SybDataCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybDeviceTest;
CREATE TABLE SybDeviceTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IO_REQUESTS DECIMAL(20,4) NOT NULL,
IO_REQUESTS_ST varchar(32) NOT NULL,
PHY_READ_RATE DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_ST varchar(32) NOT NULL,
PHY_WRITE_RATE DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_ST varchar(32) NOT NULL,
IO_ERRORS DECIMAL(20,4) NOT NULL,
IO_ERRORS_ST varchar(32) NOT NULL,
IO_WAITS DECIMAL(20,4) NOT NULL,
IO_WAITS_ST varchar(32) NOT NULL);

ALTER TABLE SybDeviceTest ADD constraint PK_SybDeviceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybDeviceTest ON SybDeviceTest
(
	 MSMT_TIME
);
DROP TABLE SybDeviceTest_TREND;
CREATE TABLE SybDeviceTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IO_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
IO_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar(32) NOT NULL,
PHY_READ_RATE_MIN DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_MAX DECIMAL(20,4) NOT NULL,
PHY_READ_RATE_STCNT varchar(32) NOT NULL,
PHY_WRITE_RATE_MIN DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_MAX DECIMAL(20,4) NOT NULL,
PHY_WRITE_RATE_STCNT varchar(32) NOT NULL,
IO_ERRORS_MIN DECIMAL(20,4) NOT NULL,
IO_ERRORS_MAX DECIMAL(20,4) NOT NULL,
IO_ERRORS_STCNT varchar(32) NOT NULL,
IO_WAITS_MIN DECIMAL(20,4) NOT NULL,
IO_WAITS_MAX DECIMAL(20,4) NOT NULL,
IO_WAITS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybDeviceTest_TREND ADD constraint PK_SybDeviceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybDeviceTest_THRESH;
CREATE TABLE SybDeviceTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IO_REQUESTS_MIN VARCHAR(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR(256) NOT NULL,
PHY_READ_RATE_MIN VARCHAR(256) NOT NULL,
PHY_READ_RATE_MAX VARCHAR(256) NOT NULL,
PHY_WRITE_RATE_MIN VARCHAR(256) NOT NULL,
PHY_WRITE_RATE_MAX VARCHAR(256) NOT NULL,
IO_ERRORS_MIN VARCHAR(256) NOT NULL,
IO_ERRORS_MAX VARCHAR(256) NOT NULL,
IO_WAITS_MIN VARCHAR(256) NOT NULL,
IO_WAITS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybDeviceTest_THRESH ADD constraint PK_SybDeviceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybDeviceTest_THRESH ON SybDeviceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybLockTest;
CREATE TABLE SybLockTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
LOCK_REQUESTS DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_ST varchar(32) NOT NULL,
LOCK_WAITS DECIMAL(20,4) NOT NULL,
LOCK_WAITS_ST varchar(32) NOT NULL,
AVG_LOCK_WAIT_TIME DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_ST varchar(32) NOT NULL,
LOCK_TIMEOUTS DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_ST varchar(32) NOT NULL,
DEAD_LOCKS DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_ST varchar(32) NOT NULL);

ALTER TABLE SybLockTest ADD constraint PK_SybLockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybLockTest ON SybLockTest
(
	 MSMT_TIME
);
DROP TABLE SybLockTest_TREND;
CREATE TABLE SybLockTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
LOCK_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
LOCK_REQUESTS_STCNT varchar(32) NOT NULL,
LOCK_WAITS_MIN DECIMAL(20,4) NOT NULL,
LOCK_WAITS_MAX DECIMAL(20,4) NOT NULL,
LOCK_WAITS_STCNT varchar(32) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_LOCK_WAIT_TIME_STCNT varchar(32) NOT NULL,
LOCK_TIMEOUTS_MIN DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_MAX DECIMAL(20,4) NOT NULL,
LOCK_TIMEOUTS_STCNT varchar(32) NOT NULL,
DEAD_LOCKS_MIN DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_MAX DECIMAL(20,4) NOT NULL,
DEAD_LOCKS_STCNT varchar(32) NOT NULL);

ALTER TABLE SybLockTest_TREND ADD constraint PK_SybLockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockTest_THRESH;
CREATE TABLE SybLockTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
LOCK_REQUESTS_MIN VARCHAR(256) NOT NULL,
LOCK_REQUESTS_MAX VARCHAR(256) NOT NULL,
LOCK_WAITS_MIN VARCHAR(256) NOT NULL,
LOCK_WAITS_MAX VARCHAR(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MIN VARCHAR(256) NOT NULL,
AVG_LOCK_WAIT_TIME_MAX VARCHAR(256) NOT NULL,
LOCK_TIMEOUTS_MIN VARCHAR(256) NOT NULL,
LOCK_TIMEOUTS_MAX VARCHAR(256) NOT NULL,
DEAD_LOCKS_MIN VARCHAR(256) NOT NULL,
DEAD_LOCKS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybLockTest_THRESH ADD constraint PK_SybLockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockTest_THRESH ON SybLockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE SybLockStatsTest;
CREATE TABLE SybLockStatsTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NUM_OF_LOCKS DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_ST varchar(32) NOT NULL,
AVG_BLOCK_TIME DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_ST varchar(32) NOT NULL);

CREATE  INDEX IDX_SybLockStatsTest ON SybLockStatsTest(MSMT_TIME);
ALTER TABLE SybLockStatsTest ADD constraint PK_SybLockStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybLockStatsTest_TREND;
CREATE TABLE SybLockStatsTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUM_OF_LOCKS_MIN DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_MAX DECIMAL(20,4) NOT NULL,
NUM_OF_LOCKS_STCNT varchar(32) NOT NULL,
AVG_BLOCK_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_BLOCK_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE SybLockStatsTest_TREND ADD constraint PK_SybLockStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybLockStatsTest_THRESH;
CREATE TABLE SybLockStatsTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUM_OF_LOCKS_MIN VARCHAR(256) NOT NULL,
NUM_OF_LOCKS_MAX VARCHAR(256) NOT NULL,
AVG_BLOCK_TIME_MIN VARCHAR(256) NOT NULL,
AVG_BLOCK_TIME_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybLockStatsTest_THRESH ADD constraint PK_SybLockStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybLockStatsTest_THRESH ON SybLockStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);



DROP TABLE SybNetworkTest;
CREATE TABLE SybNetworkTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
IO_REQUESTS DECIMAL(20,4) NOT NULL,
IO_REQUESTS_ST varchar(32) NOT NULL,
IO_DELAY DECIMAL(20,4) NOT NULL,
IO_DELAY_ST varchar(32) NOT NULL,
DATA_RECVD_RATE DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar(32) NOT NULL,
DATA_SENT_RATE DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_ST varchar(32) NOT NULL,
AVG_PACKET_SIZE DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_ST varchar(32) NOT NULL);

CREATE  INDEX IDX_SybNetworkTest ON SybNetworkTest
(
	 MSMT_TIME
);

ALTER TABLE SybNetworkTest ADD constraint PK_SybNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SybNetworkTest_TREND;
CREATE TABLE SybNetworkTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IO_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
IO_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
IO_REQUESTS_STCNT varchar(32) NOT NULL,
IO_DELAY_MIN DECIMAL(20,4) NOT NULL,
IO_DELAY_MAX DECIMAL(20,4) NOT NULL,
IO_DELAY_STCNT varchar(32) NOT NULL,
DATA_RECVD_RATE_MIN DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_MAX DECIMAL(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar(32) NOT NULL,
DATA_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
DATA_SENT_RATE_STCNT varchar(32) NOT NULL,
AVG_PACKET_SIZE_MIN DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_MAX DECIMAL(20,4) NOT NULL,
AVG_PACKET_SIZE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybNetworkTest_TREND ADD constraint PK_SybNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybNetworkTest_THRESH;
CREATE TABLE SybNetworkTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IO_REQUESTS_MIN VARCHAR(256) NOT NULL,
IO_REQUESTS_MAX VARCHAR(256) NOT NULL,
IO_DELAY_MIN VARCHAR(256) NOT NULL,
IO_DELAY_MAX VARCHAR(256) NOT NULL,
DATA_RECVD_RATE_MIN VARCHAR(256) NOT NULL,
DATA_RECVD_RATE_MAX VARCHAR(256) NOT NULL,
DATA_SENT_RATE_MIN VARCHAR(256) NOT NULL,
DATA_SENT_RATE_MAX VARCHAR(256) NOT NULL,
AVG_PACKET_SIZE_MIN VARCHAR(256) NOT NULL,
AVG_PACKET_SIZE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybNetworkTest_THRESH ADD constraint PK_SybNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybNetworkTest_THRESH ON SybNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybProcCacheTest;
CREATE TABLE SybProcCacheTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PROCEDURE_REQUESTS DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_ST varchar(32) NOT NULL,
DISK_READS DECIMAL(20,4) NOT NULL,
DISK_READS_ST varchar(32) NOT NULL,
CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
PROCEDURES_CREATED DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_ST varchar(32) NOT NULL,
PROCEDURES_AGED_OUT DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_ST varchar(32) NOT NULL);

ALTER TABLE SybProcCacheTest ADD constraint PK_SybProcCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybProcCacheTest ON SybProcCacheTest
(
	 MSMT_TIME
);
DROP TABLE SybProcCacheTest_TREND;
CREATE TABLE SybProcCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
PROCEDURE_REQUESTS_MIN DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_MAX DECIMAL(20,4) NOT NULL,
PROCEDURE_REQUESTS_STCNT varchar(32) NOT NULL,
DISK_READS_MIN DECIMAL(20,4) NOT NULL,
DISK_READS_MAX DECIMAL(20,4) NOT NULL,
DISK_READS_STCNT varchar(32) NOT NULL,
CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
PROCEDURES_CREATED_MIN DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_MAX DECIMAL(20,4) NOT NULL,
PROCEDURES_CREATED_STCNT varchar(32) NOT NULL,
PROCEDURES_AGED_OUT_MIN DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_MAX DECIMAL(20,4) NOT NULL,
PROCEDURES_AGED_OUT_STCNT varchar(32) NOT NULL);

ALTER TABLE SybProcCacheTest_TREND ADD constraint PK_SybProcCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybProcCacheTest_THRESH;
CREATE TABLE SybProcCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
PROCEDURE_REQUESTS_MIN VARCHAR(256) NOT NULL,
PROCEDURE_REQUESTS_MAX VARCHAR(256) NOT NULL,
DISK_READS_MIN VARCHAR(256) NOT NULL,
DISK_READS_MAX VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MIN VARCHAR(256) NOT NULL,
CACHE_HIT_RATIO_MAX VARCHAR(256) NOT NULL,
PROCEDURES_CREATED_MIN VARCHAR(256) NOT NULL,
PROCEDURES_CREATED_MAX VARCHAR(256) NOT NULL,
PROCEDURES_AGED_OUT_MIN VARCHAR(256) NOT NULL,
PROCEDURES_AGED_OUT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybProcCacheTest_THRESH ADD constraint PK_SybProcCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybProcCacheTest_THRESH ON SybProcCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSpaceTest;
CREATE TABLE SybSpaceTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_SIZE DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_ST varchar(32) NOT NULL,
PCT_RESERVED DECIMAL(20,4) NOT NULL,
PCT_RESERVED_ST varchar(32) NOT NULL,
RESERVED_SPACE DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_ST varchar(32) NOT NULL,
DATA_SPACE DECIMAL(20,4) NOT NULL,
DATA_SPACE_ST varchar(32) NOT NULL,
INDEX_SPACE DECIMAL(20,4) NOT NULL,
INDEX_SPACE_ST varchar(32) NOT NULL,
UNUSED_SPACE DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_ST varchar(32) NOT NULL);
ALTER TABLE SybSpaceTest ADD constraint PK_SybSpaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybSpaceTest ON SybSpaceTest
(
	 MSMT_TIME
);
DROP TABLE SybSpaceTest_TREND;
CREATE TABLE SybSpaceTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_SIZE_MIN DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_MAX DECIMAL(20,4) NOT NULL,
TOTAL_SIZE_STCNT varchar(32) NOT NULL,
PCT_RESERVED_MIN DECIMAL(20,4) NOT NULL,
PCT_RESERVED_MAX DECIMAL(20,4) NOT NULL,
PCT_RESERVED_STCNT varchar(32) NOT NULL,
RESERVED_SPACE_MIN DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_MAX DECIMAL(20,4) NOT NULL,
RESERVED_SPACE_STCNT varchar(32) NOT NULL,
DATA_SPACE_MIN DECIMAL(20,4) NOT NULL,
DATA_SPACE_MAX DECIMAL(20,4) NOT NULL,
DATA_SPACE_STCNT varchar(32) NOT NULL,
INDEX_SPACE_MIN DECIMAL(20,4) NOT NULL,
INDEX_SPACE_MAX DECIMAL(20,4) NOT NULL,
INDEX_SPACE_STCNT varchar(32) NOT NULL,
UNUSED_SPACE_MIN DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_MAX DECIMAL(20,4) NOT NULL,
UNUSED_SPACE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybSpaceTest_TREND ADD constraint PK_SybSpaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSpaceTest_THRESH;
CREATE TABLE SybSpaceTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_SIZE_MIN VARCHAR(256) NOT NULL,
TOTAL_SIZE_MAX VARCHAR(256) NOT NULL,
PCT_RESERVED_MIN VARCHAR(256) NOT NULL,
PCT_RESERVED_MAX VARCHAR(256) NOT NULL,
RESERVED_SPACE_MIN VARCHAR(256) NOT NULL,
RESERVED_SPACE_MAX VARCHAR(256) NOT NULL,
DATA_SPACE_MIN VARCHAR(256) NOT NULL,
DATA_SPACE_MAX VARCHAR(256) NOT NULL,
INDEX_SPACE_MIN VARCHAR(256) NOT NULL,
INDEX_SPACE_MAX VARCHAR(256) NOT NULL,
UNUSED_SPACE_MIN VARCHAR(256) NOT NULL,
UNUSED_SPACE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybSpaceTest_THRESH ADD constraint PK_SybSpaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSpaceTest_THRESH ON SybSpaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTasksTest;
CREATE TABLE SybTasksTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CONNECTION_OPEN_RATE DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_ST varchar(32) NOT NULL,
TASK_SWITCH_RATE DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_ST varchar(32) NOT NULL);

ALTER TABLE SybTasksTest ADD constraint PK_SybTasksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTasksTest ON SybTasksTest
(
	 MSMT_TIME
);

DROP TABLE SybTasksTest_TREND;
CREATE TABLE SybTasksTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CONNECTION_OPEN_RATE_MIN DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_MAX DECIMAL(20,4) NOT NULL,
CONNECTION_OPEN_RATE_STCNT varchar(32) NOT NULL,
TASK_SWITCH_RATE_MIN DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_MAX DECIMAL(20,4) NOT NULL,
TASK_SWITCH_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTasksTest_TREND ADD constraint PK_SybTasksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTasksTest_THRESH;
CREATE TABLE SybTasksTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CONNECTION_OPEN_RATE_MIN VARCHAR(256) NOT NULL,
CONNECTION_OPEN_RATE_MAX VARCHAR(256) NOT NULL,
TASK_SWITCH_RATE_MIN VARCHAR(256) NOT NULL,
TASK_SWITCH_RATE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTasksTest_THRESH ADD constraint PK_SybTasksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTasksTest_THRESH ON SybTasksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxLogTest;
CREATE TABLE SybTxLogTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ULC_LOG_WRITES DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_ST varchar(32) NOT NULL,
ULC_LOG_WRITE_WAITS DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_ST varchar(32) NOT NULL,
ULC_FLUSHES DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_ST varchar(32) NOT NULL,
ULC_FLUSH_WAITS DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_ST varchar(32) NOT NULL,
MAX_ULC_SIZE DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_ST varchar(32) NOT NULL,
LOG_ALLOCATIONS DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_ST varchar(32) NOT NULL,
TRANSACTION_LOG_WRITES DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_ST varchar(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_ST varchar(32) NOT NULL);

ALTER TABLE SybTxLogTest ADD constraint PK_SybTxLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTxLogTest ON SybTxLogTest
(
	 MSMT_TIME
);
DROP TABLE SybTxLogTest_TREND;
CREATE TABLE SybTxLogTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ULC_LOG_WRITES_MIN DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_MAX DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITES_STCNT varchar(32) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX DECIMAL(20,4) NOT NULL,
ULC_LOG_WRITE_WAITS_STCNT varchar(32) NOT NULL,
ULC_FLUSHES_MIN DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_MAX DECIMAL(20,4) NOT NULL,
ULC_FLUSHES_STCNT varchar(32) NOT NULL,
ULC_FLUSH_WAITS_MIN DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_MAX DECIMAL(20,4) NOT NULL,
ULC_FLUSH_WAITS_STCNT varchar(32) NOT NULL,
MAX_ULC_SIZE_MIN DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_MAX DECIMAL(20,4) NOT NULL,
MAX_ULC_SIZE_STCNT varchar(32) NOT NULL,
LOG_ALLOCATIONS_MIN DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_MAX DECIMAL(20,4) NOT NULL,
LOG_ALLOCATIONS_STCNT varchar(32) NOT NULL,
TRANSACTION_LOG_WRITES_MIN DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_MAX DECIMAL(20,4) NOT NULL,
TRANSACTION_LOG_WRITES_STCNT varchar(32) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX DECIMAL(20,4) NOT NULL,
AVG_WRITES_PER_LOGPAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTxLogTest_TREND ADD constraint PK_SybTxLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxLogTest_THRESH;
CREATE TABLE SybTxLogTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ULC_LOG_WRITES_MIN VARCHAR(256) NOT NULL,
ULC_LOG_WRITES_MAX VARCHAR(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MIN VARCHAR(256) NOT NULL,
ULC_LOG_WRITE_WAITS_MAX VARCHAR(256) NOT NULL,
ULC_FLUSHES_MIN VARCHAR(256) NOT NULL,
ULC_FLUSHES_MAX VARCHAR(256) NOT NULL,
ULC_FLUSH_WAITS_MIN VARCHAR(256) NOT NULL,
ULC_FLUSH_WAITS_MAX VARCHAR(256) NOT NULL,
MAX_ULC_SIZE_MIN VARCHAR(256) NOT NULL,
MAX_ULC_SIZE_MAX VARCHAR(256) NOT NULL,
LOG_ALLOCATIONS_MIN VARCHAR(256) NOT NULL,
LOG_ALLOCATIONS_MAX VARCHAR(256) NOT NULL,
TRANSACTION_LOG_WRITES_MIN VARCHAR(256) NOT NULL,
TRANSACTION_LOG_WRITES_MAX VARCHAR(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MIN VARCHAR(256) NOT NULL,
AVG_WRITES_PER_LOGPAGE_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTxLogTest_THRESH ADD constraint PK_SybTxLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxLogTest_THRESH ON SybTxLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybTxTest;
CREATE TABLE SybTxTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
COMMITTED_TRANSACTIONS DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_ST varchar(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_ST varchar(32) NOT NULL,
INSERTS DECIMAL(20,4) NOT NULL,
INSERTS_ST varchar(32) NOT NULL,
UPDATES DECIMAL(20,4) NOT NULL,
UPDATES_ST varchar(32) NOT NULL,
DELETES DECIMAL(20,4) NOT NULL,
DELETES_ST varchar(32) NOT NULL);

ALTER TABLE SybTxTest ADD constraint PK_SybTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybTxTest ON SybTxTest
(
	 MSMT_TIME
);
DROP TABLE SybTxTest_TREND;
CREATE TABLE SybTxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
COMMITTED_TRANSACTIONS_MIN DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_MAX DECIMAL(20,4) NOT NULL,
COMMITTED_TRANSACTIONS_STCNT varchar(32) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX DECIMAL(20,4) NOT NULL,
ROLLEDBACK_TRANSACTIONS_STCNT varchar(32) NOT NULL,
INSERTS_MIN DECIMAL(20,4) NOT NULL,
INSERTS_MAX DECIMAL(20,4) NOT NULL,
INSERTS_STCNT varchar(32) NOT NULL,
UPDATES_MIN DECIMAL(20,4) NOT NULL,
UPDATES_MAX DECIMAL(20,4) NOT NULL,
UPDATES_STCNT varchar(32) NOT NULL,
DELETES_MIN DECIMAL(20,4) NOT NULL,
DELETES_MAX DECIMAL(20,4) NOT NULL,
DELETES_STCNT varchar(32) NOT NULL);

ALTER TABLE SybTxTest_TREND ADD constraint PK_SybTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybTxTest_THRESH;
CREATE TABLE SybTxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
COMMITTED_TRANSACTIONS_MIN VARCHAR(256) NOT NULL,
COMMITTED_TRANSACTIONS_MAX VARCHAR(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MIN VARCHAR(256) NOT NULL,
ROLLEDBACK_TRANSACTIONS_MAX VARCHAR(256) NOT NULL,
INSERTS_MIN VARCHAR(256) NOT NULL,
INSERTS_MAX VARCHAR(256) NOT NULL,
UPDATES_MIN VARCHAR(256) NOT NULL,
UPDATES_MAX VARCHAR(256) NOT NULL,
DELETES_MIN VARCHAR(256) NOT NULL,
DELETES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybTxTest_THRESH ADD constraint PK_SybTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybTxTest_THRESH ON SybTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE SybSysProcessTest;
CREATE TABLE SybSysProcessTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
TOTAL_PROCESSES decimal(20,4) NOT NULL,
TOTAL_PROCESSES_ST varchar(32) NOT NULL,
BACKGROUND_PROCESSES decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_ST varchar(32) NOT NULL,
RUNNING_PROCESSES decimal(20,4) NOT NULL,
RUNNING_PROCESSES_ST varchar(32) NOT NULL,
SLEEPING_PROCESSES decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_ST varchar(32) NOT NULL,
INFECTED_PROCESSES decimal(20,4) NOT NULL,
INFECTED_PROCESSES_ST varchar(32) NOT NULL,
BLOCKED_PROCESSES decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_ST varchar(32) NOT NULL,
REMOTE_PROCESSES decimal(20,4) NOT NULL,
REMOTE_PROCESSES_ST varchar(32) NOT NULL,
STOPPED_PROCESSES decimal(20,4) NOT NULL,
STOPPED_PROCESSES_ST varchar(32) NOT NULL);

ALTER TABLE SybSysProcessTest ADD constraint PK_SybSysProcessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_SybSysProcessTest ON SybSysProcessTest
(
	 MSMT_TIME
);
DROP TABLE SybSysProcessTest_TREND;
CREATE TABLE SybSysProcessTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_PROCESSES_MIN decimal(20,4) NOT NULL,
TOTAL_PROCESSES_MAX decimal(20,4) NOT NULL,
TOTAL_PROCESSES_STCNT varchar(32) NOT NULL,
BACKGROUND_PROCESSES_MIN decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_MAX decimal(20,4) NOT NULL,
BACKGROUND_PROCESSES_STCNT varchar(32) NOT NULL,
RUNNING_PROCESSES_MIN decimal(20,4) NOT NULL,
RUNNING_PROCESSES_MAX decimal(20,4) NOT NULL,
RUNNING_PROCESSES_STCNT varchar(32) NOT NULL,
SLEEPING_PROCESSES_MIN decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_MAX decimal(20,4) NOT NULL,
SLEEPING_PROCESSES_STCNT varchar(32) NOT NULL,
INFECTED_PROCESSES_MIN decimal(20,4) NOT NULL,
INFECTED_PROCESSES_MAX decimal(20,4) NOT NULL,
INFECTED_PROCESSES_STCNT varchar(32) NOT NULL,
BLOCKED_PROCESSES_MIN decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_MAX decimal(20,4) NOT NULL,
BLOCKED_PROCESSES_STCNT varchar(32) NOT NULL,
REMOTE_PROCESSES_MIN decimal(20,4) NOT NULL,
REMOTE_PROCESSES_MAX decimal(20,4) NOT NULL,
REMOTE_PROCESSES_STCNT varchar(32) NOT NULL,
STOPPED_PROCESSES_MIN decimal(20,4) NOT NULL,
STOPPED_PROCESSES_MAX decimal(20,4) NOT NULL,
STOPPED_PROCESSES_STCNT varchar(32) NOT NULL);

ALTER TABLE SybSysProcessTest_TREND ADD constraint PK_SybSysProcessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SybSysProcessTest_THRESH;
CREATE TABLE SybSysProcessTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_PROCESSES_MIN VARCHAR(256) NOT NULL,
TOTAL_PROCESSES_MAX VARCHAR(256) NOT NULL,
BACKGROUND_PROCESSES_MIN VARCHAR(256) NOT NULL,
BACKGROUND_PROCESSES_MAX VARCHAR(256) NOT NULL,
RUNNING_PROCESSES_MIN VARCHAR(256) NOT NULL,
RUNNING_PROCESSES_MAX VARCHAR(256) NOT NULL,
SLEEPING_PROCESSES_MIN VARCHAR(256) NOT NULL,
SLEEPING_PROCESSES_MAX VARCHAR(256) NOT NULL,
INFECTED_PROCESSES_MIN VARCHAR(256) NOT NULL,
INFECTED_PROCESSES_MAX VARCHAR(256) NOT NULL,
BLOCKED_PROCESSES_MIN VARCHAR(256) NOT NULL,
BLOCKED_PROCESSES_MAX VARCHAR(256) NOT NULL,
REMOTE_PROCESSES_MIN VARCHAR(256) NOT NULL,
REMOTE_PROCESSES_MAX VARCHAR(256) NOT NULL,
STOPPED_PROCESSES_MIN VARCHAR(256) NOT NULL,
STOPPED_PROCESSES_MAX VARCHAR(256) NOT NULL);

ALTER TABLE SybSysProcessTest_THRESH ADD constraint PK_SybSysProcessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SybSysProcessTest_THRESH ON SybSysProcessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ActiveDirectoryTest ;

CREATE TABLE ActiveDirectoryTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	schemaCacheHitRatio		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_ST		varchar(32) NOT NULL,
	notifyQSize			decimal(20,4) not null,
	notifyQSize_ST			varchar(32) not null,
	currThreads			decimal(20,4) not null,
	currThreads_ST			varchar(32) not null,
	directoryWrites			decimal(20,4) not null,
	directoryWrites_ST		varchar(32) not null,
	kerberosAuth			decimal(20,4) not null,
	kerberosAuth_ST			varchar(32) not null,
	ntlmAuth			decimal(20,4) not null,
	ntlmAuth_ST			varchar(32) not null,
	ticketReq			decimal(20,4) not null,
	ticketReq_ST			varchar(32) not null,
	authSrvReq			decimal(20,4) not null,
	authSrvReq_ST			varchar(32) not null,
	ldapSessions			decimal(20,4) not null,
	ldapSessions_ST			varchar(32) not null
);

ALTER TABLE ActiveDirectoryTest ADD constraint PK_ActiveDirectory
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ActiveDirectoryTest ON ActiveDirectoryTest
(
	 MSMT_TIME
);
DROP TABLE   ActiveDirectoryTest_TREND ;

CREATE TABLE ActiveDirectoryTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	schemaCacheHitRatio_MIN		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_MAX		decimal(20,4) NOT NULL,
	schemaCacheHitRatio_STCNT	varchar(32) NOT NULL,
	notifyQSize_MIN			decimal(20,4) not null,
	notifyQSize_MAX			decimal(20,4) not null,
	notifyQSize_STCNT		varchar(32) not null,
	currThreads_MIN			decimal(20,4) not null,
	currThreads_MAX			decimal(20,4) not null,
	currThreads_STCNT		varchar(32) not null,
	directoryWrites_MIN		decimal(20,4) not null,
	directoryWrites_MAX		decimal(20,4) not null,
	directoryWrites_STCNT		varchar(32) not null,
	kerberosAuth_MIN		decimal(20,4) not null,
	kerberosAuth_MAX		decimal(20,4) not null,
	kerberosAuth_STCNT		varchar(32) not null,
	ntlmAuth_MIN			decimal(20,4) not null,
	ntlmAuth_MAX			decimal(20,4) not null,
	ntlmAuth_STCNT			varchar(32) not null,
	ticketReq_MIN			decimal(20,4) not null,
	ticketReq_MAX			decimal(20,4) not null,
	ticketReq_STCNT			varchar(32) not null,
	authSrvReq_MIN			decimal(20,4) not null,
	authSrvReq_MAX			decimal(20,4) not null,
	authSrvReq_STCNT		varchar(32) not null,
	ldapSessions_MIN		decimal(20,4) not null,
	ldapSessions_MAX		decimal(20,4) not null,
	ldapSessions_STCNT		varchar(32) not null
	
);

ALTER TABLE ActiveDirectoryTest_TREND ADD constraint PK_ActiveDirectoryTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ActiveDirectoryTest_THRESH ;

CREATE TABLE ActiveDirectoryTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	SCHEMACACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	SCHEMACACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL,
	NOTIFYQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	NOTIFYQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRTHREADS_MIN	VARCHAR(256)	 NOT NULL,
	CURRTHREADS_MAX	VARCHAR(256)	 NOT NULL,
	DIRECTORYWRITES_MIN	VARCHAR(256)	 NOT NULL,
	DIRECTORYWRITES_MAX	VARCHAR(256)	 NOT NULL,
	KERBEROSAUTH_MIN	VARCHAR(256)	 NOT NULL,
	KERBEROSAUTH_MAX	VARCHAR(256)	 NOT NULL,
	NTLMAUTH_MIN	VARCHAR(256)	 NOT NULL,
	NTLMAUTH_MAX	VARCHAR(256)	 NOT NULL,
	TICKETREQ_MIN	VARCHAR(256)	 NOT NULL,
	TICKETREQ_MAX	VARCHAR(256)	 NOT NULL,
	AUTHSRVREQ_MIN	VARCHAR(256)	 NOT NULL,
	AUTHSRVREQ_MAX	VARCHAR(256)	 NOT NULL,
	LDAPSESSIONS_MIN	VARCHAR(256)	 NOT NULL,
	LDAPSESSIONS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ActiveDirectoryTest_THRESH ADD constraint PK_ActiveDirectoryTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ActiveDirectoryTest_THRESH ON ActiveDirectoryTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE ReplicationTest ;

CREATE TABLE ReplicationTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_Obj_Appld_rate		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_ST		varchar(32) NOT NULL,
	in_Prop_Appld_rate		decimal(20,4) not null,
	in_Prop_Appld_rate_ST		varchar(32) not null,
	in_Obj_Filtrd_rate		decimal(20,4) not null,
	in_Obj_Filtrd_rate_ST		varchar(32) not null,
	in_Prop_Filtrd_rate		decimal(20,4) not null,
	in_Prop_Filtrd_rate_ST		varchar(32) not null,
	out_Obj_Filtrd_rate		decimal(20,4) not null,
	out_Obj_Filtrd_rate_ST		varchar(32) not null,
	pending_Rep_Sync		decimal(20,4) not null,
	pending_Rep_Sync_ST		varchar(32) not null
);

ALTER TABLE ReplicationTest ADD constraint PK_Replication
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ReplicationTest ON ReplicationTest
(
	 MSMT_TIME
);
DROP TABLE   ReplicationTest_TREND ;

CREATE TABLE ReplicationTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_Obj_Appld_rate_MIN		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_MAX		decimal(20,4) NOT NULL,
	in_Obj_Appld_rate_STCNT		varchar(32) NOT NULL,
	in_Prop_Appld_rate_MIN		decimal(20,4) not null,
	in_Prop_Appld_rate_MAX		decimal(20,4) not null,
	in_Prop_Appld_rate_STCNT	varchar(32) not null,
	in_Obj_Filtrd_rate_MIN		decimal(20,4) not null,
	in_Obj_Filtrd_rate_MAX		decimal(20,4) not null,
	in_Obj_Filtrd_rate_STCNT	varchar(32) not null,
	in_Prop_Filtrd_rate_MIN		decimal(20,4) not null,
	in_Prop_Filtrd_rate_MAX		decimal(20,4) not null,
	in_Prop_Filtrd_rate_STCNT	varchar(32) not null,
	out_Obj_Filtrd_rate_MIN		decimal(20,4) not null,
	out_Obj_Filtrd_rate_MAX		decimal(20,4) not null,
	out_Obj_Filtrd_rate_STCNT	varchar(32) not null,
	pending_Rep_Sync_MIN		decimal(20,4) not null,
	pending_Rep_Sync_MAX		decimal(20,4) not null,
	pending_Rep_Sync_STCNT		varchar(32) not null
	
);

ALTER TABLE ReplicationTest_TREND ADD constraint PK_ReplicationTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   ReplicationTest_THRESH ;

CREATE TABLE ReplicationTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_OBJ_APPLD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_OBJ_APPLD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_PROP_APPLD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_OBJ_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_PROP_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_OBJ_FILTRD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PENDING_REP_SYNC_MIN	VARCHAR(256)	 NOT NULL,
	PENDING_REP_SYNC_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ReplicationTest_THRESH ADD constraint PK_ReplicationTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_ReplicationTest_THRESH ON ReplicationTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE IntraSiteReplTest ;

CREATE TABLE IntraSiteReplTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_rate			decimal(20,4) NOT NULL,
	in_rate_ST			varchar(32) NOT NULL,
	out_rate			decimal(20,4) not null,
	out_rate_ST			varchar(32) not null
);

ALTER TABLE IntraSiteReplTest ADD constraint PK_IntraSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_IntraSiteReplTest ON IntraSiteReplTest
(
	 MSMT_TIME
);
DROP TABLE   IntraSiteReplTest_TREND ;

CREATE TABLE IntraSiteReplTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_rate_MIN			decimal(20,4) NOT NULL,
	in_rate_MAX			decimal(20,4) NOT NULL,
	in_rate_STCNT		varchar(32) NOT NULL,
	out_rate_MIN		decimal(20,4) not null,
	out_rate_MAX		decimal(20,4) not null,
	out_rate_STCNT		varchar(32) not null
	
);

ALTER TABLE IntraSiteReplTest_TREND ADD constraint PK_IntraSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IntraSiteReplTest_THRESH ;

CREATE TABLE IntraSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE IntraSiteReplTest_THRESH ADD constraint PK_IntraSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IntraSiteReplTest_THRESH ON IntraSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE InterSiteReplTest ;

CREATE TABLE InterSiteReplTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	in_rate				decimal(20,4) NOT NULL,
	in_rate_ST			varchar(32) NOT NULL,
	out_rate			decimal(20,4) not null,
	out_rate_ST			varchar(32) not null
);

ALTER TABLE InterSiteReplTest ADD constraint PK_InterSiteRepl
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterSiteReplTest ON InterSiteReplTest
(
	 MSMT_TIME
);
DROP TABLE   InterSiteReplTest_TREND ;

CREATE TABLE InterSiteReplTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	in_rate_MIN			decimal(20,4) NOT NULL,
	in_rate_MAX			decimal(20,4) NOT NULL,
	in_rate_STCNT		varchar(32) NOT NULL,
	out_rate_MIN		decimal(20,4) not null,
	out_rate_MAX		decimal(20,4) not null,
	out_rate_STCNT		varchar(32) not null
	
);

ALTER TABLE InterSiteReplTest_TREND ADD constraint PK_InterSiteReplTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterSiteReplTest_THRESH ;

CREATE TABLE InterSiteReplTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	IN_RATE_MIN	VARCHAR(256)	 NOT NULL,
	IN_RATE_MAX	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	OUT_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE InterSiteReplTest_THRESH ADD constraint PK_InterSiteReplTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterSiteReplTest_THRESH ON InterSiteReplTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE DocSubmitTest ;

CREATE TABLE DocSubmitTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	submit_Rate			decimal(20,4) NOT NULL,
	submit_Rate_ST			varchar(32) NOT NULL,
	mapped_Rate			decimal(20,4) NOT NULL,
	mapped_Rate_ST			varchar(32) NOT NULL,
	parsed_Rate			decimal(20,4) NOT NULL,
	parsed_Rate_ST			varchar(32) NOT NULL,
	process_Rate			decimal(20,4) NOT NULL,
	process_Rate_ST			varchar(32) NOT NULL
	
);

ALTER TABLE DocSubmitTest ADD constraint PK_DOCSUBMIT
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DocSubmitTest ON DocSubmitTest
(
	 MSMT_TIME
);
DROP TABLE   DocSubmitTest_TREND ;

CREATE TABLE DocSubmitTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	submit_Rate_MIN			decimal(20,4) NOT NULL,
	submit_Rate_MAX			decimal(20,4) NOT NULL,
	submit_Rate_STCNT		varchar(32) NOT NULL,
	mapped_Rate_MIN		decimal(20,4) NOT NULL,
	mapped_Rate_MAX		decimal(20,4) NOT NULL,
	mapped_Rate_STCNT		varchar(32) NOT NULL,
	parsed_Rate_MIN		decimal(20,4) NOT NULL,
	parsed_Rate_MAX		decimal(20,4) NOT NULL,
	parsed_Rate_STCNT		varchar(32) NOT NULL,
	process_Rate_MIN		decimal(20,4) NOT NULL,
	process_Rate_MAX		decimal(20,4) NOT NULL,
	process_Rate_STCNT		varchar(32) NOT NULL
	
);

ALTER TABLE DocSubmitTest_TREND ADD constraint PK_DocSubmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocSubmitTest_THRESH ;

CREATE TABLE DocSubmitTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	SUBMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	SUBMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	MAPPED_RATE_MIN	VARCHAR(256)	 NOT NULL,
	MAPPED_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PARSED_RATE_MIN	VARCHAR(256)	 NOT NULL,
	PARSED_RATE_MAX	VARCHAR(256)	 NOT NULL,
	PROCESS_RATE_MIN	VARCHAR(256)	 NOT NULL,
	PROCESS_RATE_MAX	VARCHAR(256)	 NOT NULL
	
		
);

ALTER TABLE DocSubmitTest_THRESH ADD constraint PK_DocSubmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocSubmitTest_THRESH ON DocSubmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE   DocReceiveTest ;

CREATE TABLE DocReceiveTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	receive_Rate			decimal(20,4) NOT NULL,
	receive_Rate_ST			varchar(32) NOT NULL
	
);

ALTER TABLE  DocReceiveTest ADD constraint PK_DocReceiveTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DocReceiveTest ON DocReceiveTest
(
	 MSMT_TIME
);
DROP TABLE   DocReceiveTest_TREND ;

CREATE TABLE DocReceiveTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	receive_Rate_MIN		decimal(20,4) NOT NULL,
	receive_Rate_MAX		decimal(20,4) NOT NULL,
	receive_Rate_STCNT		varchar(32) NOT NULL
	
);

ALTER TABLE DocReceiveTest_TREND ADD constraint PK_DocReceiveTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   DocReceiveTest_THRESH ;

CREATE TABLE DocReceiveTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	RECEIVE_RATE_MIN	VARCHAR(256)	 NOT NULL,
      	RECEIVE_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE DocReceiveTest_THRESH ADD constraint PK_DocReceiveTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DocReceiveTest_THRESH ON DocReceiveTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE XChgMailRetrvlTest ;

CREATE TABLE XChgMailRetrvlTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	currPop3Conn			decimal(20,4) not null,
	currPop3Conn_st			varchar(32) not null,
	currImapConn			decimal(20,4) not null,
	currImapConn_st			varchar(32) not null,
	pop3AuthFailures		decimal(20,4) not null,
	pop3AuthFailures_st		varchar(32) not null,
	imapAuthFailures		decimal(20,4) not null,
	imapAuthFailures_st		varchar(32) not null
);

ALTER TABLE XChgMailRetrvlTest ADD constraint PK_XChgMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgMailRetrvlTest ON XChgMailRetrvlTest
(
	 MSMT_TIME
);
DROP TABLE   XChgMailRetrvlTest_TREND ;

CREATE TABLE XChgMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	currPop3Conn_min		decimal(20,4) not null,
	currPop3Conn_max		decimal(20,4) not null,
	currPop3Conn_stcnt		varchar(32) not null,
	currImapConn_min		decimal(20,4) not null,
	currImapConn_max		decimal(20,4) not null,
	currImapConn_stcnt		varchar(32) not null,
	pop3AuthFailures_min		decimal(20,4) not null,
	pop3AuthFailures_max		decimal(20,4) not null,
	pop3AuthFailures_stcnt		varchar(32) not null,
	imapAuthFailures_min		decimal(20,4) not null,
	imapAuthFailures_max		decimal(20,4) not null,
	imapAuthFailures_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgMailRetrvlTest_TREND ADD constraint PK_XChgMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailRetrvlTest_THRESH ;

CREATE TABLE XChgMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	CURRPOP3CONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR(256)	 NOT NULL,
	POP3AUTHFAILURES_MIN	VARCHAR(256)	 NOT NULL,
	POP3AUTHFAILURES_MAX	VARCHAR(256)	 NOT NULL,
	IMAPAUTHFAILURES_MIN	VARCHAR(256)	 NOT NULL,
	IMAPAUTHFAILURES_MAX	VARCHAR(256)	 NOT NULL
	
	
);

ALTER TABLE XChgMailRetrvlTest_THRESH ADD constraint PK_XChgMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailRetrvlTest_THRESH ON XChgMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE IISXChgLayerTest ;

CREATE TABLE IISXChgLayerTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	clientQSize			decimal(20,4) not null,
	clientQSize_st		varchar(32) not null,
	rpcOperationsRate		decimal(20,4) not null,
	rpcOperationsRate_st		varchar(32) not null
	
);

ALTER TABLE IISXChgLayerTest ADD constraint PK_IISXChgLayerTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_IISXChgLayerTest ON IISXChgLayerTest
(
	 MSMT_TIME
);
DROP TABLE   IISXChgLayerTest_TREND ;

CREATE TABLE IISXChgLayerTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	clientQSize_min		decimal(20,4) not null,
	clientQSize_max		decimal(20,4) not null,
	clientQSize_stcnt		varchar(32) not null,
	rpcOperationsRate_min		decimal(20,4) not null,
	rpcOperationsRate_max		decimal(20,4) not null,
	rpcOperationsRate_stcnt		varchar(32) not null
	
);

ALTER TABLE IISXChgLayerTest_TREND ADD constraint PK_IISXChgLayerTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   IISXChgLayerTest_THRESH ;

CREATE TABLE IISXChgLayerTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	CLIENTQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	CLIENTQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	RPCOPERATIONSRATE_MIN	VARCHAR(256)	 NOT NULL,
	RPCOPERATIONSRATE_MAX	VARCHAR(256)	 NOT NULL
	
	
	
);

ALTER TABLE IISXChgLayerTest_THRESH ADD constraint PK_IISXChgLayerTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_IISXChgLayerTest_THRESH ON IISXChgLayerTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);           

DROP TABLE XChgDBTest ;

CREATE TABLE XChgDBTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	dbCacheHit			decimal(20,4) not null,
	dbCacheHit_ST			varchar(32) not null,
	dbTablesCacheHit		decimal(20,4) not null,
	dbTablesCacheHit_st		varchar(32) not null,
	logRecrdWaitingRate		decimal(20,4) not null,
	logRecrdWaitingRate_st		varchar(32) not null,
	logThreadWaiting		decimal(20,4) not null,
	logThreadWaiting_st		varchar(32) not null
);

ALTER TABLE XChgDBTest ADD constraint PK_XChgDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgDBTest ON XChgDBTest
(
	 MSMT_TIME
);
DROP TABLE   XChgDBTest_TREND ;

CREATE TABLE XChgDBTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	dbCacheHit_min			decimal(20,4) not null,
	dbCacheHit_max			decimal(20,4) not null,
	dbCacheHit_stcnt		varchar(32) not null,
	dbTablesCacheHit_min		decimal(20,4) not null,
	dbTablesCacheHit_max		decimal(20,4) not null,
	dbTablesCacheHit_stcnt		varchar(32) not null,
	logRecrdWaitingRate_min		decimal(20,4) not null,
	logRecrdWaitingRate_max		decimal(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar(32) not null,
	logThreadWaiting_min		decimal(20,4) not null,
	logThreadWaiting_max		decimal(20,4) not null,
	logThreadWaiting_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgDBTest_TREND ADD constraint PK_XChgDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgDBTest_THRESH ;

CREATE TABLE XChgDBTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	DBCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgDBTest_THRESH ADD constraint PK_XChgDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgDBTest_THRESH ON XChgDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE XChgMailXferTest ;

CREATE TABLE XChgMailXferTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	localQSize			decimal(20,4) not null,
	localQSize_st			varchar(32) not null,
	remoteQSize			decimal(20,4) not null,
	remoteQSize_st			varchar(32) not null,
	currSmtpConn			decimal(20,4) not null,
	currSmtpConn_st			varchar(32) not null,
	badMailMsgs			decimal(20,4) not null,
	badMailMsgs_st			varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null,
	avgRetryMsgDelvry		decimal(20,4) not null,
	avgRetryMsgDelvry_st		varchar(32) not null,
	avgRetryMsgSent			decimal(20,4) not null,
	avgRetryMsgSent_st		varchar(32) not null
	
);

ALTER TABLE XChgMailXferTest ADD constraint PK_XChgMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgMailXferTest ON XChgMailXferTest
(
	 MSMT_TIME
);
DROP TABLE   XChgMailXferTest_TREND ;

CREATE TABLE XChgMailXferTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	localQSize_min			decimal(20,4) not null,
	localQSize_max			decimal(20,4) not null,
	localQSize_stcnt		varchar(32) not null,
	remoteQSize_min			decimal(20,4) not null,
	remoteQSize_max			decimal(20,4) not null,
	remoteQSize_stcnt		varchar(32) not null,
	currSmtpConn_min		decimal(20,4) not null,
	currSmtpConn_max		decimal(20,4) not null,
	currSmtpConn_stcnt		varchar(32) not null,
	badMailMsgs_min			decimal(20,4) not null,
	badMailMsgs_max			decimal(20,4) not null,
	badMailMsgs_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null,
	avgRetryMsgDelvry_min		decimal(20,4) not null,
	avgRetryMsgDelvry_max		decimal(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar(32) not null,
	avgRetryMsgSent_min		decimal(20,4) not null,
	avgRetryMsgSent_max		decimal(20,4) not null,
	avgRetryMsgSent_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgMailXferTest_TREND ADD constraint PK_XChgMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgMailXferTest_THRESH ;

CREATE TABLE XChgMailXferTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	LOCALQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR(256)	 NOT NULL,
	BADMAILMSGS_MIN	VARCHAR(256)	 NOT NULL,
	BADMAILMSGS_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgMailXferTest_THRESH ADD constraint PK_XChgMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgMailXferTest_THRESH ON XChgMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE NewsGroupTest ;

CREATE TABLE NewsGroupTest
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO				varchar(32) not null,
	SITE_NAME			varchar(64) not null,  
	INFO				varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME 			datetime not null,
	logonFailureRate		decimal(20,4) not null,
	logonFailureRate_st		varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null
	
);

ALTER TABLE NewsGroupTest ADD constraint PK_NewsGroupTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_NewsGroupTest ON NewsGroupTest
(
	 MSMT_TIME
);
DROP TABLE   NewsGroupTest_TREND ;

CREATE TABLE NewsGroupTest_TREND 
(
	TRGT_HOST			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME       		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME			datetime not null,
	PERIOD 				varchar(32) not null,
	logonFailureRate_min		decimal(20,4) not null,
	logonFailureRate_max		decimal(20,4) not null,
	logonFailureRate_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null
	
	
);

ALTER TABLE NewsGroupTest_TREND ADD constraint PK_NewsGroupTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   NewsGroupTest_THRESH ;

CREATE TABLE NewsGroupTest_THRESH 
(
	TRGT_HOST 			varchar(32) not null,
	PORT_NO         		varchar(32) not null,
	SITE_NAME        		varchar(64) not null,  
	INFO            		varchar(128) not null,
	MSMT_HOST 			varchar(32) not null, 
	MSMT_TIME_START			datetime not null,
      	MSMT_TIME_END   		datetime not null,
      	LOGONFAILURERATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGONFAILURERATE_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE NewsGroupTest_THRESH ADD constraint PK_NewsGroupTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_NewsGroupTest_THRESH ON NewsGroupTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          


DROP TABLE XChgCacheTest;

CREATE TABLE XChgCacheTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	cacheHitRatio		decimal(20,4) not null,
	cacheHitRatio_ST	varchar(32) not null
	
	
);

ALTER TABLE XChgCacheTest ADD constraint PK_XChgCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgCacheTest ON XChgCacheTest
(
	 MSMT_TIME
);
	
DROP TABLE   XChgCacheTest_TREND;

CREATE TABLE XChgCacheTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	cacheHitRatio_min		decimal(20,4) not null,
	cacheHitRatio_max		decimal(20,4) not null,
	cacheHitRatio_stcnt		varchar(32) not null
	
);

ALTER TABLE XChgCacheTest_TREND ADD constraint PK_XChgCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgCacheTest_THRESH;

CREATE TABLE XChgCacheTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgCacheTest_THRESH ADD constraint PK_XChgCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgCacheTest_THRESH ON XChgCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE XChgStoreTest;

CREATE TABLE XChgStoreTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currUsers			decimal(20,4) not null,
	currUsers_st		varchar(32) not null,
	mailSendQSize		decimal(20,4) not null,
	mailSendQSize_st	varchar(32) not null,
	mailRcvdQSize		decimal(20,4) not null,
	mailRcvdQSize_st	varchar(32) not null,
	mailSentRate		decimal(20,4) not null,
	mailSentRate_st		varchar(32) not null,
	mailOpensRate		decimal(20,4) not null,
	mailOpensRate_st	varchar(32) not null,
	folderOpensRate		decimal(20,4) not null,
	folderOpensRate_st	varchar(32) not null,
	avgMailDelvryTime	decimal(20,4) not null,
	avgMailDelvryTime_st	varchar(32) not null,
	avgMailLocalDelvryTime		decimal(20,4) not null,
	avgMailLocalDelvryTime_st		varchar(32) not null
	
);

ALTER TABLE XChgStoreTest ADD constraint PK_XChgStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_XChgStoreTest ON XChgStoreTest
(
	 MSMT_TIME
);
	
DROP TABLE   XChgStoreTest_TREND;

CREATE TABLE XChgStoreTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currUsers_min			decimal(20,4) not null,
	currUsers_max			decimal(20,4) not null,
	currUsers_stcnt			varchar(32) not null,
	mailSendQSize_min		decimal(20,4) not null,
	mailSendQSize_max		decimal(20,4) not null,
	mailSendQSize_stcnt		varchar(32) not null,
	mailRcvdQSize_min		decimal(20,4) not null,
	mailRcvdQSize_max		decimal(20,4) not null,
	mailRcvdQSize_stcnt		varchar(32) not null,
	mailSentRate_min		decimal(20,4) not null,
	mailSentRate_max		decimal(20,4) not null,
	mailSentRate_stcnt		varchar(32) not null,
	mailOpensRate_min		decimal(20,4) not null,
	mailOpensRate_max		decimal(20,4) not null,
	mailOpensRate_stcnt		varchar(32) not null,
	folderOpensRate_min		decimal(20,4) not null,
	folderOpensRate_max		decimal(20,4) not null,
	folderOpensRate_stcnt	varchar(32) not null,
	avgMailDelvryTime_min	decimal(20,4) not null,
	avgMailDelvryTime_max	decimal(20,4) not null,
	avgMailDelvryTime_stcnt	 varchar(32) not null,
	avgMailLocalDelvryTime_min		decimal(20,4) not null,
	avgMailLocalDelvryTime_max		decimal(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar(32) not null
	
);

ALTER TABLE XChgStoreTest_TREND ADD constraint PK_XChgStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   XChgStoreTest_THRESH;

CREATE TABLE XChgStoreTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRUSERS_MIN	VARCHAR(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE XChgStoreTest_THRESH ADD constraint PK_XChgStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_XChgStoreTest_THRESH ON XChgStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE DOMINONETTEST;

CREATE TABLE DOMINONETTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	DATA_RCVD_RATE	 			decimal(20,4) 	NOT NULL,
	DATA_RCVD_RATE_ST 			varchar(32) 	NOT NULL,
	DATA_SENT_RATE		 		decimal(20,4) 	NOT NULL,
	DATA_SENT_RATE_ST 			varchar(32) 	NOT NULL,
	IN_SESSION_RATE 		 	decimal(20,4) 	NOT NULL,
	IN_SESSION_RATE_ST 			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE			decimal(20,4) 	NOT NULL,
	OUT_SESSION_RATE_ST 		varchar(32) 	NOT NULL,
	DROP_SESSION_RATE			decimal(20,4) 	NOT NULL,
	DROP_SESSION_RATE_ST 		varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT		decimal(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST ADD CONSTRAINT PK_DOMINONETTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DOMINONETTEST ON DOMINONETTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINONETTEST_TREND;
CREATE TABLE DOMINONETTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	DATA_RCVD_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	DATA_RCVD_RATE_MAX 				varchar(32) 	NOT NULL,
	DATA_RCVD_RATE_STCNT			varchar(32) 	NOT NULL,
	DATA_SENT_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	DATA_SENT_RATE_MAX 				varchar(32) 	NOT NULL,
	DATA_SENT_RATE_STCNT			varchar(32) 	NOT NULL,
	IN_SESSION_RATE_MIN	 			decimal(20,4) 	NOT NULL,
	IN_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	IN_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	OUT_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	OUT_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	DROP_SESSION_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DROP_SESSION_RATE_MAX 			varchar(32) 	NOT NULL,
	DROP_SESSION_RATE_STCNT			varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	 		decimal(20,4) 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX 		varchar(32) 	NOT NULL,
	CONCURR_SESSION_LIMIT_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINONETTEST_TREND ADD CONSTRAINT PK_DOMINONETTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINONETTEST_THRESH;
CREATE TABLE DOMINONETTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	DATA_RCVD_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_SENT_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_SENT_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	IN_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	IN_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	OUT_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	OUT_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DROP_SESSION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DROP_SESSION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MIN	VARCHAR(256)	 	NOT NULL,
	CONCURR_SESSION_LIMIT_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINONETTEST_THRESH ADD CONSTRAINT PK_DOMINONETTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINONETTEST_THRESH ON DOMINONETTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DOMINOMEMTEST;
CREATE TABLE DOMINOMEMTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	TOTAL_MEM_ALLOCATED	 		decimal(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_ST 		varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS		 	decimal(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_ST 		varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED		 	decimal(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST ADD CONSTRAINT PK_DOMINOMEMTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX_DOMINOMEMTEST ON DOMINOMEMTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINOMEMTEST_TREND;
CREATE TABLE DOMINOMEMTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	TOTAL_MEM_ALLOCATED_MIN	 		decimal(20,4) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX 		varchar(32) 	NOT NULL,
	TOTAL_MEM_ALLOCATED_STCNT		varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	 		decimal(20,4) 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX 			varchar(32) 	NOT NULL,
	MEM_ALLOC_PROCESS_STCNT			varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	 		decimal(20,4) 	NOT NULL,
	MEM_ALLOC_SHARED_MAX 			varchar(32) 	NOT NULL,
	MEM_ALLOC_SHARED_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMEMTEST_TREND ADD CONSTRAINT PK_DOMINOMEMTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMEMTEST_THRESH;
CREATE TABLE DOMINOMEMTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	TOTAL_MEM_ALLOCATED_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_MEM_ALLOCATED_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_PROCESS_MAX	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MIN	VARCHAR(256)	 	NOT NULL,
	MEM_ALLOC_SHARED_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINOMEMTEST_THRESH ADD CONSTRAINT PK_DOMINOMEMTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMEMTEST_THRESH ON DOMINOMEMTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DOMINODBTEST;

CREATE TABLE DOMINODBTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	CACHE_CURR_ENTRIES	 		decimal(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_ST 		varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES		 	decimal(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_ST 		varchar(32) 	NOT NULL,
	CACHE_HT_RATIO		 		decimal(20,4) 	NOT NULL,
	CACHE_HT_RATIO_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST ADD CONSTRAINT PK_DOMINODBTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DOMINODBTEST ON DOMINODBTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINODBTEST_TREND;
CREATE TABLE DOMINODBTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	CACHE_CURR_ENTRIES_MIN	 		decimal(20,4) 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX 			varchar(32) 	NOT NULL,
	CACHE_CURR_ENTRIES_STCNT		varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	 		decimal(20,4) 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX 			varchar(32) 	NOT NULL,
	CACHE_MAX_ENTRIES_STCNT			varchar(32) 	NOT NULL,
	CACHE_HT_RATIO_MIN	 			decimal(20,4) 	NOT NULL,
	CACHE_HT_RATIO_MAX 				varchar(32) 	NOT NULL,
	CACHE_HT_RATIO_STCNT			varchar(32) 	NOT NULL
);

ALTER TABLE DOMINODBTEST_TREND ADD CONSTRAINT PK_DOMINODBTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINODBTEST_THRESH;
CREATE TABLE DOMINODBTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	CACHE_CURR_ENTRIES_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_CURR_ENTRIES_MAX	VARCHAR(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_MAX_ENTRIES_MAX	VARCHAR(256)	 	NOT NULL,
	CACHE_HT_RATIO_MIN	VARCHAR(256)	 	NOT NULL,
	CACHE_HT_RATIO_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINODBTEST_THRESH ADD CONSTRAINT PK_DOMINODBTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINODBTEST_THRESH ON DOMINODBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE DOMINOMAILSTATSTEST;

CREATE TABLE DOMINOMAILSTATSTEST
(
	TRGT_HOST 					varchar(32) NOT NULL,
    PORT_NO                		varchar(32) NOT NULL,
    SITE_NAME               	varchar(64) NOT NULL,
    INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 					varchar(32) NOT NULL, 
    MSMT_TIME 					datetime NOT NULL,
	DELIVERED_MAIL_RATE	 		decimal(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_ST 		varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS		 		decimal(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_ST 			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING 		 	decimal(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_ST 		varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME			decimal(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_ST 		varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL 			decimal(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_ST 		varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV		decimal(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST ADD CONSTRAINT PK_DOMINOMAILSTATSTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE  INDEX IDX_DOMINOMAILSTATSTEST ON DOMINOMAILSTATSTEST
(
	 MSMT_TIME
);
DROP TABLE DOMINOMAILSTATSTEST_TREND;
CREATE TABLE DOMINOMAILSTATSTEST_TREND 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME 						datetime NOT NULL,
	PERIOD 							varchar(32) NOT NULL, 
	DELIVERED_MAIL_RATE_MIN	 		decimal(20,4) 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX 		varchar(32) 	NOT NULL,
	DELIVERED_MAIL_RATE_STCNT		varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS_MIN	 			decimal(20,4) 	NOT NULL,
	PCT_DEAD_MAILS_MAX 				varchar(32) 	NOT NULL,
	PCT_DEAD_MAILS_STCNT			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING_MIN	 		decimal(20,4) 	NOT NULL,
	NUM_MAIL_WAITING_MAX 			varchar(32) 	NOT NULL,
	NUM_MAIL_WAITING_STCNT			varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	 		decimal(20,4) 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX 			varchar(32) 	NOT NULL,
	MAIL_DELIVERY_TIME_STCNT		varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	 		decimal(20,4) 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX 			varchar(32) 	NOT NULL,
	PCT_TRANSFER_FAIL_STCNT			varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	 		decimal(20,4) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX 		varchar(32) 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE DOMINOMAILSTATSTEST_TREND ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);


DROP TABLE DOMINOMAILSTATSTEST_THRESH;
CREATE TABLE DOMINOMAILSTATSTEST_THRESH 
(
	TRGT_HOST 						varchar(32) NOT NULL,
    PORT_NO                 		varchar(32) NOT NULL,
    SITE_NAME               		varchar(64) NOT NULL,
    INFO                    		varchar(128) NOT NULL,
	MSMT_HOST 						varchar(32) NOT NULL, 
	MSMT_TIME_START 				datetime NOT NULL,
    MSMT_TIME_END           		datetime NOT NULL,
	DELIVERED_MAIL_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DELIVERED_MAIL_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_DEAD_MAILS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_MAIL_WAITING_MAX	VARCHAR(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	MAIL_DELIVERY_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_TRANSFER_FAIL_MAX	VARCHAR(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MIN	VARCHAR(256)	 	NOT NULL,
	MAIL_WAIT_LOCAL_DELV_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE DOMINOMAILSTATSTEST_THRESH ADD CONSTRAINT PK_DOMINOMAILSTATSTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_DOMINOMAILSTATSTEST_THRESH ON DOMINOMAILSTATSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE InterChangeRcvdTest;

CREATE TABLE InterChangeRcvdTest
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	decode_Rate		decimal(20,4) not null,
	decode_Rate_ST		varchar(32) not null,
	decrypt_Rate		decimal(20,4) not null,
	decrypt_Rate_ST		varchar(32) not null,
	receive_Rate		decimal(20,4) not null,
	receive_Rate_ST		varchar(32) not null
);

ALTER TABLE InterChangeRcvdTest ADD constraint PK_InterChangeRcvdTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterChangeRcvdTest ON InterChangeRcvdTest
(
	 MSMT_TIME
);
DROP TABLE InterChangeRcvdTest_TREND;

CREATE TABLE InterChangeRcvdTest_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	decode_Rate_MIN		decimal(20,4) not null,
	decode_Rate_MAX		decimal(20,4) not null,
	decode_Rate_STCNT	varchar(32) not null,
	decrypt_Rate_MIN	decimal(20,4) not null,
	decrypt_Rate_MAX	decimal(20,4) not null,
	decrypt_Rate_STCNT	varchar(32) not null,
	receive_Rate_MIN	decimal(20,4) not null,
	receive_Rate_MAX	decimal(20,4) not null,
	receive_Rate_STCNT	varchar(32) not null
);

ALTER TABLE InterChangeRcvdTest_TREND ADD constraint PK_InterChangeRcvdTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE InterChangeRcvdTest_THRESH;

CREATE TABLE InterChangeRcvdTest_THRESH 
(
	TRGT_HOST 		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME        	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
      	MSMT_TIME_END   	datetime NOT NULL,
      	DECODE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DECODE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	DECRYPT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DECRYPT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	RECEIVE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	RECEIVE_RATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE InterChangeRcvdTest_THRESH ADD constraint PK_InterChangeRcvdTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_InterChangeRcvdTest_THRESH ON InterChangeRcvdTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);                  

DROP TABLE  InterChangeXmitTest;

CREATE TABLE InterChangeXmitTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	encode_Rate			decimal(20,4) NOT NULL,
	encode_Rate_ST			varchar(32) NOT NULL,
	encrypt_Rate			decimal(20,4) NOT NULL,
	encrypt_Rate_ST			varchar(32) NOT NULL,
	serialize_Rate			decimal(20,4) NOT NULL,
	serialize_Rate_ST		varchar(32) NOT NULL,
	xmit_Rate			decimal(20,4) NOT NULL,
	xmit_Rate_ST			varchar(32) NOT NULL
);

ALTER TABLE InterChangeXmitTest ADD constraint PK_InterChangeXmitTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_InterChangeXmitTest ON InterChangeXmitTest
(
	 MSMT_TIME
);
DROP TABLE  InterChangeXmitTest_TREND;

CREATE TABLE InterChangeXmitTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	encode_Rate_MIN			decimal(20,4) NOT NULL,
	encode_Rate_MAX			decimal(20,4) NOT NULL,
	encode_Rate_STCNT		varchar(32) NOT NULL,
	encrypt_Rate_MIN		decimal(20,4) NOT NULL,
	encrypt_Rate_MAX		decimal(20,4) NOT NULL,
	encrypt_Rate_STCNT		varchar(32) NOT NULL,
	serialize_Rate_MIN		decimal(20,4) NOT NULL,
	serialize_Rate_MAX		decimal(20,4) NOT NULL,
	serialize_Rate_STCNT		varchar(32) NOT NULL,
	xmit_Rate_MIN			decimal(20,4) NOT NULL,
	xmit_Rate_MAX			decimal(20,4) NOT NULL,
	xmit_Rate_STCNT			varchar(32) NOT NULL
	
);

ALTER TABLE InterChangeXmitTest_TREND ADD constraint PK_InterChangeXmitTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   InterChangeXmitTest_THRESH;

CREATE TABLE InterChangeXmitTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	ENCODE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	ENCODE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	ENCRYPT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	ENCRYPT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	SERIALIZE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	SERIALIZE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE InterChangeXmitTest_THRESH ADD constraint PK_InterChangeXmitTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_InterChangeXmitTest_THRESH ON InterChangeXmitTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE WSJDBCTEST;

CREATE TABLE WSJDBCTEST
(
	TRGT_HOST 		varchar(32)	NOT NULL,
	PORT_NO         	varchar(32)	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST 		varchar(32)	NOT NULL, 
	MSMT_TIME 		datetime	NOT NULL,
	CREATION_RATE		decimal(20,4) 	NOT NULL,
	CREATION_RATE_ST	varchar(32) 	NOT NULL,
	DESTROY_RATE		decimal(20,4) 	NOT NULL,
	DESTROY_RATE_ST		varchar(32) 	NOT NULL,
	RETURN_RATE		decimal(20,4) 	NOT NULL,
	RETURN_RATE_ST		varchar(32) 	NOT NULL,
	ALLOCATE_RATE		decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_ST	varchar(32) 	NOT NULL,
	POOL_SIZE		decimal(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar(32) 	NOT NULL,
	CONCUR_WAITERS		decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_ST	varchar(32) 	NOT NULL,
	AVG_WAIT_TIME		decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_ST	varchar(32) 	NOT NULL,
	FAULTS			decimal(20,4) 	NOT NULL,
	FAULTS_ST		varchar(32) 	NOT NULL,
	PCT_USED		decimal(20,4) 	NOT NULL,
	PCT_USED_ST		varchar(32) 	NOT NULL,
	PCT_MAXED		decimal(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST ADD constraint PK_WS_JDBC
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_WSJDBCTEST ON WSJDBCTEST (MSMT_TIME) INCLUDE (CONCUR_WAITERS,AVG_WAIT_TIME,PCT_USED);

DROP TABLE WSJDBCTEST_TREND;

CREATE TABLE WSJDBCTEST_TREND 
(
	TRGT_HOST		varchar(32)	 NOT NULL,
	PORT_NO         	varchar(32)	 NOT NULL,
	SITE_NAME       	varchar(64)	 NOT NULL,
	INFO            	varchar(128)	 NOT NULL,
	MSMT_HOST 		varchar(32) 	NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	CREATION_RATE_MIN	decimal(20,4) 	NOT NULL,
	CREATION_RATE_MAX	decimal(20,4) 	NOT NULL,
	CREATION_RATE_STCNT	varchar(32) 	NOT NULL,
	DESTROY_RATE_MIN	decimal(20,4) 	NOT NULL,
	DESTROY_RATE_MAX	decimal(20,4) 	NOT NULL,
	DESTROY_RATE_STCNT	varchar(32) 	NOT NULL,
	RETURN_RATE_MIN		decimal(20,4) 	NOT NULL,
	RETURN_RATE_MAX		decimal(20,4) 	NOT NULL,
	RETURN_RATE_STCNT	varchar(32) 	NOT NULL,
	ALLOCATE_RATE_MIN	decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_MAX	decimal(20,4) 	NOT NULL,
	ALLOCATE_RATE_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL,
	CONCUR_WAITERS_MIN	decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_MAX	decimal(20,4) 	NOT NULL,
	CONCUR_WAITERS_STCNT	varchar(32) 	NOT NULL,
	AVG_WAIT_TIME_MIN	decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_MAX	decimal(20,4) 	NOT NULL,
	AVG_WAIT_TIME_STCNT	varchar(32) 	NOT NULL,
	FAULTS_MIN		decimal(20,4) 	NOT NULL,
	FAULTS_MAX		decimal(20,4) 	NOT NULL,
	FAULTS_STCNT		varchar(32) 	NOT NULL,
	PCT_USED_MIN		decimal(20,4) 	NOT NULL,
	PCT_USED_MAX		decimal(20,4) 	NOT NULL,
	PCT_USED_STCNT		varchar(32) 	NOT NULL,
	PCT_MAXED_MIN		decimal(20,4) 	NOT NULL,
	PCT_MAXED_MAX		decimal(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar(32) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	decimal(20,4) 	NOT NULL,
	PSTMT_CACHE_DISCARDS_STCNT	varchar(32) 	NOT NULL
);

ALTER TABLE WSJDBCTEST_TREND ADD constraint PK_WS_JDBC_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSJDBCTEST_THRESH;

CREATE TABLE WSJDBCTEST_THRESH 
(
	TRGT_HOST 			varchar(32)	NOT NULL,
	PORT_NO         		varchar(32)	NOT NULL,
	SITE_NAME        		varchar(64)	NOT NULL,
	INFO            		varchar(128)	NOT NULL,
	MSMT_HOST 			varchar(32)	NOT NULL, 
	MSMT_TIME_START			datetime 	NOT NULL,
        MSMT_TIME_END   		datetime	NOT NULL,
	CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DESTROY_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DESTROY_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	RETURN_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	RETURN_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	ALLOCATE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	ALLOCATE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCUR_WAITERS_MIN	VARCHAR(256)	 	NOT NULL,
	CONCUR_WAITERS_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_WAIT_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_WAIT_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	FAULTS_MIN	VARCHAR(256)	 	NOT NULL,
	FAULTS_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_USED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_USED_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MIN	VARCHAR(256)	 	NOT NULL,
	PSTMT_CACHE_DISCARDS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSJDBCTEST_THRESH ADD constraint PK_WS_JDBC_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSJDBCTEST_THRESH ON WSJDBCTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  


DROP TABLE WSGLOBALTXTEST;

CREATE TABLE WSGLOBALTXTEST
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	GLOBAL_TX_BEGUN			decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_ST		varchar(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_ST		varchar(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_ST	varchar(32) 	NOT NULL,
	NUM_OPTIMIZATION		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_ST	varchar(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_ST		varchar(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_ST		varchar(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION		decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSGLOBALTXTEST ADD constraint PK_WS_GL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSGLOBALTXTEST ON WSGLOBALTXTEST
(
	 MSMT_TIME
);
DROP TABLE WSGLOBALTXTEST_TREND;

CREATE TABLE WSGLOBALTXTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	GLOBAL_TX_BEGUN_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_BEGUN_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_GLOBAL_TX_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_DURATION_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_DURATION_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_COMMIT_DURATION_STCNT	varchar(32) 	NOT NULL,
	NUM_OPTIMIZATION_MIN		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_MAX		decimal(20,4) 	NOT NULL,
	NUM_OPTIMIZATION_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_COMMITTED_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_TIMEOUT_STCNT		varchar(32) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX		decimal(20,4) 	NOT NULL,
	GLOBAL_TX_INVOLVED_STCNT	varchar(32) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	decimal(20,4) 	NOT NULL,
	GLOBAL_PREPARE_DURATION_STCNT	varchar(32) 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_TREND ADD constraint PK_WS_GL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSGLOBALTXTEST_THRESH;

CREATE TABLE WSGLOBALTXTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	GLOBAL_TX_BEGUN_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_BEGUN_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_GLOBAL_TX_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_DURATION_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_COMMIT_DURATION_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_OPTIMIZATION_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_COMMITTED_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_TIMEOUT_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_TX_INVOLVED_MAX	VARCHAR(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MIN	VARCHAR(256)	 	NOT NULL,
	GLOBAL_PREPARE_DURATION_MAX	VARCHAR(256)	 	NOT NULL
);
	
ALTER TABLE WSGLOBALTXTEST_THRESH ADD constraint PK_WS_GL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSGLOBALTXTEST_THRESH ON WSGLOBALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSEJBTEST;

CREATE TABLE WSEJBTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime 	NOT NULL,
	INSTANTIATES		decimal(20,4) 	NOT NULL,
	INSTANTIATES_ST		varchar(32) 	NOT NULL,
	DESTROYS		decimal(20,4) 	NOT NULL,
	DESTROYS_ST		varchar(32) 	NOT NULL,
	TOT_METHOD_CALLS	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_ST	varchar(32) 	NOT NULL,
	AVG_METHOD_RT		decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_ST	varchar(32) 	NOT NULL,
	AVG_CREATE_TIME		decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_ST	varchar(32) 	NOT NULL,
	POOL_SIZE		decimal(20,4) 	NOT NULL,
	POOl_SIZE_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST ADD constraint PK_WS_EJB
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSEJBTEST ON WSEJBTEST
(
	 MSMT_TIME
);
DROP TABLE WSEJBTEST_TREND;

CREATE TABLE WSEJBTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	INSTANTIATES_MIN	decimal(20,4) 	NOT NULL,
	INSTANTIATES_MAX	decimal(20,4) 	NOT NULL,
	INSTANTIATES_STCNT	varchar(32) 	NOT NULL,
	DESTROYS_MIN		decimal(20,4) 	NOT NULL,
	DESTROYS_MAX		decimal(20,4) 	NOT NULL,
	DESTROYS_STCNT		varchar(32) 	NOT NULL,
	TOT_METHOD_CALLS_MIN	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_MAX	decimal(20,4) 	NOT NULL,
	TOT_METHOD_CALLS_STCNT	varchar(32) 	NOT NULL,
	AVG_METHOD_RT_MIN	decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_MAX	decimal(20,4) 	NOT NULL,
	AVG_METHOD_RT_STCNT	varchar(32) 	NOT NULL,
	AVG_CREATE_TIME_MIN	decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_MAX	decimal(20,4) 	NOT NULL,
	AVG_CREATE_TIME_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSEJBTEST_TREND ADD constraint PK_WS_EJB_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSEJBTEST_THRESH;

CREATE TABLE WSEJBTEST_THRESH 
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME        	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
        MSMT_TIME_END   	datetime NOT NULL,
	INSTANTIATES_MIN	VARCHAR(256)	 	NOT NULL,
	INSTANTIATES_MAX	VARCHAR(256)	 	NOT NULL,
	DESTROYS_MIN	VARCHAR(256)	 	NOT NULL,
	DESTROYS_MAX	VARCHAR(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MIN	VARCHAR(256)	 	NOT NULL,
	TOT_METHOD_CALLS_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_METHOD_RT_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_METHOD_RT_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_CREATE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_CREATE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSEJBTEST_THRESH ADD constraint PK_WS_EJB_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSEJBTEST_THRESH ON WSEJBTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSLOCALTXTEST;

CREATE TABLE WSLOCALTXTEST
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	LOCAL_TX_BEGUN			decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_ST		varchar(32) 	NOT NULL,
	ACTIVE_LOCAL_TX			decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_DURA		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_ST		varchar(32) 	NOT NULL,
	LOCAL_COMMIT_DURA		decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_ST	varchar(32) 	NOT NULL,
	LOCAL_TX_COMMITTED		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK		decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_ST		varchar(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSLOCALTXTEST ADD constraint PK_WS_LOCAL_TX
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX_WSLOCALTXTEST ON WSLOCALTXTEST
(
	 MSMT_TIME
);
DROP TABLE WSLOCALTXTEST_TREND;

CREATE TABLE WSLOCALTXTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	LOCAL_TX_BEGUN_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_BEGUN_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_LOCAL_TX_STCNT		varchar(32) 	NOT NULL,
	LOCAL_TX_DURA_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_DURA_STCNT		varchar(32) 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	decimal(20,4) 	NOT NULL,
	LOCAL_COMMIT_DURA_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_COMMITTED_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	decimal(20,4) 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_STCNT	varchar(32) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX		decimal(20,4) 	NOT NULL,
	LOCAL_TX_TIMEOUT_STCNT		varchar(32) 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_TREND ADD constraint PK_WS_LOCAL_TX_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSLOCALTXTEST_THRESH;

CREATE TABLE WSLOCALTXTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	LOCAL_TX_BEGUN_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_BEGUN_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_LOCAL_TX_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_DURA_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_DURA_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_COMMIT_DURA_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_COMMITTED_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MIN	VARCHAR(256)	 	NOT NULL,
	LOCAL_TX_TIMEOUT_MAX	VARCHAR(256)	 	NOT NULL
);
	
ALTER TABLE WSLOCALTXTEST_THRESH ADD constraint PK_WS_LOCAL_TX_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSLOCALTXTEST_THRESH ON WSLOCALTXTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSSRVLTSESSIONTEST;

CREATE TABLE WSSRVLTSESSIONTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	SESSION_CREATION_RATE	decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_ST	varchar(32) 	NOT NULL,
	INVALIDATED_SESSIONS	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_ST	varchar(32) 	NOT NULL,
	SESSION_LIFE_TIME	decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_ST	varchar(32) 	NOT NULL,
	ACTIVE_SESSIONS		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_ST	varchar(32) 	NOT NULL,
	LIVE_SESSIONS		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST ADD constraint PK_WS_SS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSSRVLTSESSIONTEST ON WSSRVLTSESSIONTEST
(
	 MSMT_TIME
);
DROP TABLE WSSRVLTSESSIONTEST_TREND;

CREATE TABLE WSSRVLTSESSIONTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	SESSION_CREATION_RATE_MIN		decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_MAX		decimal(20,4) 	NOT NULL,
	SESSION_CREATION_RATE_STCNT		varchar(32) 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	decimal(20,4) 	NOT NULL,
	INVALIDATED_SESSIONS_STCNT	varchar(32) 	NOT NULL,
	SESSION_LIFE_TIME_MIN		decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_MAX		decimal(20,4) 	NOT NULL,
	SESSION_LIFE_TIME_STCNT		varchar(32) 	NOT NULL,
	ACTIVE_SESSIONS_MIN		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_MAX		decimal(20,4) 	NOT NULL,
	ACTIVE_SESSIONS_STCNT		varchar(32) 	NOT NULL,
	LIVE_SESSIONS_MIN		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_MAX		decimal(20,4) 	NOT NULL,
	LIVE_SESSIONS_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_TREND ADD constraint PK_WS_SS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSSRVLTSESSIONTEST_THRESH;

CREATE TABLE WSSRVLTSESSIONTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	SESSION_CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	INVALIDATED_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	SESSION_LIFE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	LIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	LIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSSRVLTSESSIONTEST_THRESH ADD constraint PK_WS_SS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSSRVLTSESSIONTEST_THRESH ON WSSRVLTSESSIONTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSTEST;

CREATE TABLE WSTEST
(
	TRGT_HOST 	varchar(32)    NOT NULL,
	PORT_NO         varchar(32)    NOT NULL,
	SITE_NAME       varchar(64)    NOT NULL,
	INFO            varchar(128)    NOT NULL,
	MSMT_HOST 	varchar(32)    NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PCT_HEAP_USE 	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_ST	varchar(32) 	NOT NULL,
	AVAILABILITY 	decimal(20,4) 	NOT NULL,
	AVAILABILITY_ST	varchar(32) 	NOT NULL
);

ALTER TABLE WSTEST ADD constraint PK_WS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WSTEST ON WSTEST (MSMT_TIME) INCLUDE (PCT_HEAP_USE);
DROP TABLE WSTEST_TREND;

CREATE TABLE WSTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	PCT_HEAP_USE_MIN	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_MAX	decimal(20,4) 	NOT NULL,
	PCT_HEAP_USE_STCNT 	varchar(32) 	NOT NULL,
	AVAILABILITY_MIN	decimal(20,4) 	NOT NULL,
	AVAILABILITY_MAX	decimal(20,4) 	NOT NULL,
	AVAILABILITY_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE WSTEST_TREND ADD constraint PK_WS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTEST_THRESH;

CREATE TABLE WSTEST_THRESH 
(
	TRGT_HOST 	varchar(32)    NOT NULL,
	PORT_NO         varchar(32)    NOT NULL,
	SITE_NAME        varchar(64)    NOT NULL,
	INFO            varchar(128)    NOT NULL,
	MSMT_HOST 	varchar(32)    NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_HEAP_USE_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_HEAP_USE_MAX	VARCHAR(256)	 	NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSTEST_THRESH ADD constraint PK_WS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTEST_THRESH ON WSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSTHREADPOOLTEST;

CREATE TABLE WSTHREADPOOLTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	THREAD_CREATION_RATE 	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_ST	varchar(32) 	NOT NULL,
	THREAD_DESTROY_RATE 	decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_ST	varchar(32) 	NOT NULL,
	ACTIVE_THREADS 		decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_ST	varchar(32) 	NOT NULL,
	POOL_SIZE 		decimal(20,4) 	NOT NULL,
	POOL_SIZE_ST		varchar(32) 	NOT NULL,
	PCT_MAXED		decimal(20,4) 	NOT NULL,
	PCT_MAXED_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST ADD constraint PK_WSTHREAD_POOL
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_WSTHREADPOOLTEST ON WSTHREADPOOLTEST (MSMT_TIME) INCLUDE (ACTIVE_THREADS);

DROP TABLE WSTHREADPOOLTEST_TREND;

CREATE TABLE WSTHREADPOOLTEST_TREND 
(
	TRGT_HOST		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32)    NOT NULL,
	THREAD_CREATION_RATE_MIN	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_MAX	decimal(20,4) 	NOT NULL,
	THREAD_CREATION_RATE_STCNT 	varchar(32) 	NOT NULL,
	THREAD_DESTROY_RATE_MIN		decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_MAX		decimal(20,4) 	NOT NULL,
	THREAD_DESTROY_RATE_STCNT	varchar(32) 	NOT NULL,
	ACTIVE_THREADS_MIN	decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_MAX	decimal(20,4) 	NOT NULL,
	ACTIVE_THREADS_STCNT	varchar(32) 	NOT NULL,
	POOL_SIZE_MIN		decimal(20,4) 	NOT NULL,
	POOL_SIZE_MAX		decimal(20,4) 	NOT NULL,
	POOL_SIZE_STCNT		varchar(32) 	NOT NULL,
	PCT_MAXED_MIN		decimal(20,4) 	NOT NULL,
	PCT_MAXED_MAX		decimal(20,4) 	NOT NULL,
	PCT_MAXED_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_TREND ADD constraint PK_WSTHREAD_POOL_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSTHREADPOOLTEST_THRESH;

CREATE TABLE WSTHREADPOOLTEST_THRESH 
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME      		varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME_START		datetime NOT NULL,
        MSMT_TIME_END   	datetime NOT NULL,
	THREAD_CREATION_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	THREAD_CREATION_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	THREAD_DESTROY_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	ACTIVE_THREADS_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_THREADS_MAX	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MIN	VARCHAR(256)	 	NOT NULL,
	POOL_SIZE_MAX	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_MAXED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSTHREADPOOLTEST_THRESH ADD constraint PK_WSTHREAD_POOL_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSTHREADPOOLTEST_THRESH ON WSTHREADPOOLTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE WSWEBAPPSTEST;

CREATE TABLE WSWEBAPPSTEST
(
	TRGT_HOST 		varchar(32)    NOT NULL,
	PORT_NO         	varchar(32)    NOT NULL,
	SITE_NAME       	varchar(64)    NOT NULL,
	INFO            	varchar(128)    NOT NULL,
	MSMT_HOST 		varchar(32)    NOT NULL, 
	MSMT_TIME 		datetime NOT NULL,
	NUM_LOADED_SERVLETS	decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_ST	varchar(32) 	NOT NULL,
	NUM_RELOADS		decimal(20,4) 	NOT NULL,
	NUM_RELOADS_ST		varchar(32) 	NOT NULL,
	REQUEST_RATE		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_ST		varchar(32) 	NOT NULL,
	CONCURRENT_REQUESTS	decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_ST	varchar(32) 	NOT NULL,
	RESPONSE_TIME		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_ST	varchar(32) 	NOT NULL,
	NUM_ERRORS		decimal(20,4) 	NOT NULL,
	NUM_ERRORS_ST		varchar(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST ADD constraint PK_WS_WEB_APPS
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WSWEBAPPSTEST ON WSWEBAPPSTEST
(
	 MSMT_TIME
);
DROP TABLE WSWEBAPPSTEST_TREND;

CREATE TABLE WSWEBAPPSTEST_TREND 
(
	TRGT_HOST			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME       		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32)    NOT NULL,
	NUM_LOADED_SERVLETS_MIN		decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX		decimal(20,4) 	NOT NULL,
	NUM_LOADED_SERVLETS_STCNT	varchar(32) 	NOT NULL,
	NUM_RELOADS_MIN			decimal(20,4) 	NOT NULL,
	NUM_RELOADS_MAX			decimal(20,4) 	NOT NULL,
	NUM_RELOADS_STCNT		varchar(32) 	NOT NULL,
	REQUEST_RATE_MIN		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_MAX		decimal(20,4) 	NOT NULL,
	REQUEST_RATE_STCNT		varchar(32) 	NOT NULL,
	CONCURRENT_REQUESTS_MIN		decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_MAX		decimal(20,4) 	NOT NULL,
	CONCURRENT_REQUESTS_STCNT	varchar(32) 	NOT NULL,
	RESPONSE_TIME_MIN		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_MAX		decimal(20,4) 	NOT NULL,
	RESPONSE_TIME_STCNT		varchar(32) 	NOT NULL,
	NUM_ERRORS_MIN			decimal(20,4) 	NOT NULL,
	NUM_ERRORS_MAX			decimal(20,4) 	NOT NULL,
	NUM_ERRORS_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_TREND ADD constraint PK_WS_WEB_APPS_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE WSWEBAPPSTEST_THRESH;

CREATE TABLE WSWEBAPPSTEST_THRESH 
(
	TRGT_HOST 			varchar(32)    NOT NULL,
	PORT_NO         		varchar(32)    NOT NULL,
	SITE_NAME        		varchar(64)    NOT NULL,
	INFO            		varchar(128)    NOT NULL,
	MSMT_HOST 			varchar(32)    NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
        MSMT_TIME_END   		datetime NOT NULL,
	NUM_LOADED_SERVLETS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_LOADED_SERVLETS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_RELOADS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_RELOADS_MAX	VARCHAR(256)	 	NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MIN	VARCHAR(256)	 	NOT NULL,
	CONCURRENT_REQUESTS_MAX	VARCHAR(256)	 	NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_ERRORS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_ERRORS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE WSWEBAPPSTEST_THRESH ADD constraint PK_WS_WEB_APPS_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_WSWEBAPPSTEST_THRESH ON WSWEBAPPSTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MsXCacheTest;

CREATE TABLE MsXCacheTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	cacheHitRatio			decimal(20,4) not null,
	cacheHitRatio_ST		varchar(32) not null
);

ALTER TABLE MsXCacheTest ADD constraint PK_MsXCacheTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXCacheTest ON MsXCacheTest
(
	 MSMT_TIME
);
DROP TABLE   MsXCacheTest_TREND;

CREATE TABLE MsXCacheTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	cacheHitRatio_min		decimal(20,4) not null,
	cacheHitRatio_max		decimal(20,4) not null,
	cacheHitRatio_stcnt		varchar(32) not null
);

ALTER TABLE MsXCacheTest_TREND ADD constraint PK_MsXCacheTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXCacheTest_THRESH;

CREATE TABLE MsXCacheTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
 	MSMT_TIME_END   		datetime NOT NULL,
 	CACHEHITRATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHEHITRATIO_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXCacheTest_THRESH ADD constraint PK_MsXCacheTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXCacheTest_THRESH ON MsXCacheTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXDBTest; 

CREATE TABLE MsXDBTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	dbCacheHit			decimal(20,4) not null,
	dbCacheHit_ST			varchar(32) not null,
	dbTablesCacheHit		decimal(20,4) not null,
	dbTablesCacheHit_st		varchar(32) not null,
	logRecrdWaitingRate		decimal(20,4) not null,
	logRecrdWaitingRate_st		varchar(32) not null,
	logThreadWaiting		decimal(20,4) not null,
	logThreadWaiting_st		varchar(32) not null
);

ALTER TABLE MsXDBTest ADD constraint PK_MsXDBTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXDBTest ON MsXDBTest
(
	 MSMT_TIME
);
DROP TABLE   MsXDBTest_TREND;

CREATE TABLE MsXDBTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	dbCacheHit_min			decimal(20,4) not null,
	dbCacheHit_max			decimal(20,4) not null,
	dbCacheHit_stcnt		varchar(32) not null,
	dbTablesCacheHit_min		decimal(20,4) not null,
	dbTablesCacheHit_max		decimal(20,4) not null,
	dbTablesCacheHit_stcnt		varchar(32) not null,
	logRecrdWaitingRate_min		decimal(20,4) not null,
	logRecrdWaitingRate_max		decimal(20,4) not null,
	logRecrdWaitingRate_stcnt	varchar(32) not null,
	logThreadWaiting_min		decimal(20,4) not null,
	logThreadWaiting_max		decimal(20,4) not null,
	logThreadWaiting_stcnt		varchar(32) not null
);

ALTER TABLE MsXDBTest_TREND ADD constraint PK_MsXDBTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXDBTest_THRESH;

CREATE TABLE MsXDBTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
  MSMT_TIME_END   		datetime NOT NULL,
  DBCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MIN	VARCHAR(256)	 NOT NULL,
	DBTABLESCACHEHIT_MAX	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGRECRDWAITINGRATE_MAX	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MIN	VARCHAR(256)	 NOT NULL,
	LOGTHREADWAITING_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXDBTest_THRESH ADD constraint PK_MsXDBTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXDBTest_THRESH ON MsXDBTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailRetrvlTest;

CREATE TABLE MsXMailRetrvlTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currPop3Conn			decimal(20,4) not null,
	currPop3Conn_st			varchar(32) not null,
	currImapConn			decimal(20,4) not null,
	currImapConn_st			varchar(32) not null,
	pop3ClientWaitingReq		decimal(20,4) not null,
	pop3ClientWaitingReq_st		varchar(32) not null,
	imapClientWaitingReq		decimal(20,4) not null,
	imapClientWaitingReq_st		varchar(32) not null
);

ALTER TABLE MsXMailRetrvlTest ADD constraint PK_MsXMailRetrvlTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailRetrvlTest ON MsXMailRetrvlTest
(
	 MSMT_TIME
);
DROP TABLE   MsXMailRetrvlTest_TREND;

CREATE TABLE MsXMailRetrvlTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currPop3Conn_min		decimal(20,4) not null,
	currPop3Conn_max		decimal(20,4) not null,
	currPop3Conn_stcnt		varchar(32) not null,
	currImapConn_min		decimal(20,4) not null,
	currImapConn_max		decimal(20,4) not null,
	currImapConn_stcnt		varchar(32) not null,
	pop3ClientWaitingReq_min		decimal(20,4) not null,
	pop3ClientWaitingReq_max		decimal(20,4) not null,
	pop3ClientWaitingReq_stcnt		varchar(32) not null,
	imapClientWaitingReq_min		decimal(20,4) not null,
	imapClientWaitingReq_max		decimal(20,4) not null,
	imapClientWaitingReq_stcnt		varchar(32) not null
);

ALTER TABLE MsXMailRetrvlTest_TREND ADD constraint PK_MsXMailRetrvlTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailRetrvlTest_THRESH;

CREATE TABLE MsXMailRetrvlTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRPOP3CONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRPOP3CONN_MAX	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRIMAPCONN_MAX	VARCHAR(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MIN	VARCHAR(256)	 NOT NULL,
	POP3CLIENTWAITINGREQ_MAX	VARCHAR(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MIN	VARCHAR(256)	 NOT NULL,
	IMAPCLIENTWAITINGREQ_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsXMailRetrvlTest_THRESH ADD constraint PK_MsXMailRetrvlTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailRetrvlTest_THRESH ON MsXMailRetrvlTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsXMailSvcTest;
CREATE TABLE MsXMailSvcTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
INBOUND_QSIZE DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_ST varchar(32) NOT NULL,
OUTBOUND_QSIZE DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_ST varchar(32) NOT NULL,
MTS_IN_QSIZE DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_ST varchar(32) NOT NULL,
MTS_OUT_QSIZE DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_ST varchar(32) NOT NULL,
IN_CONNS DECIMAL(20,4) NOT NULL,
IN_CONNS_ST varchar(32) NOT NULL,
OUT_CONNS DECIMAL(20,4) NOT NULL,
OUT_CONNS_ST varchar(32) NOT NULL,
CONNS_FAILED DECIMAL(20,4) NOT NULL,
CONNS_FAILED_ST varchar(32) NOT NULL,
CONNS_REJECTED DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_ST varchar(32) NOT NULL,
IN_MSGS DECIMAL(20,4) NOT NULL,
IN_MSGS_ST varchar(32) NOT NULL,
OUT_MSGS DECIMAL(20,4) NOT NULL,
OUT_MSGS_ST varchar(32) NOT NULL);

ALTER TABLE MsXMailSvcTest ADD constraint PK_MsXMailSvcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailSvcTest ON MsXMailSvcTest
(
	 MSMT_TIME
);
DROP TABLE MsXMailSvcTest_TREND;
CREATE TABLE MsXMailSvcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
INBOUND_QSIZE_MIN DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_MAX DECIMAL(20,4) NOT NULL,
INBOUND_QSIZE_STCNT varchar(32) NOT NULL,
OUTBOUND_QSIZE_MIN DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_MAX DECIMAL(20,4) NOT NULL,
OUTBOUND_QSIZE_STCNT varchar(32) NOT NULL,
MTS_IN_QSIZE_MIN DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_MAX DECIMAL(20,4) NOT NULL,
MTS_IN_QSIZE_STCNT varchar(32) NOT NULL,
MTS_OUT_QSIZE_MIN DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_MAX DECIMAL(20,4) NOT NULL,
MTS_OUT_QSIZE_STCNT varchar(32) NOT NULL,
IN_CONNS_MIN DECIMAL(20,4) NOT NULL,
IN_CONNS_MAX DECIMAL(20,4) NOT NULL,
IN_CONNS_STCNT varchar(32) NOT NULL,
OUT_CONNS_MIN DECIMAL(20,4) NOT NULL,
OUT_CONNS_MAX DECIMAL(20,4) NOT NULL,
OUT_CONNS_STCNT varchar(32) NOT NULL,
CONNS_FAILED_MIN DECIMAL(20,4) NOT NULL,
CONNS_FAILED_MAX DECIMAL(20,4) NOT NULL,
CONNS_FAILED_STCNT varchar(32) NOT NULL,
CONNS_REJECTED_MIN DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_MAX DECIMAL(20,4) NOT NULL,
CONNS_REJECTED_STCNT varchar(32) NOT NULL,
IN_MSGS_MIN DECIMAL(20,4) NOT NULL,
IN_MSGS_MAX DECIMAL(20,4) NOT NULL,
IN_MSGS_STCNT varchar(32) NOT NULL,
OUT_MSGS_MIN DECIMAL(20,4) NOT NULL,
OUT_MSGS_MAX DECIMAL(20,4) NOT NULL,
OUT_MSGS_STCNT varchar(32) NOT NULL);

ALTER TABLE MsXMailSvcTest_TREND ADD constraint PK_MsXMailSvcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsXMailSvcTest_THRESH;
CREATE TABLE MsXMailSvcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
INBOUND_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
INBOUND_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
OUTBOUND_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
OUTBOUND_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
MTS_IN_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
MTS_IN_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
MTS_OUT_QSIZE_MIN	VARCHAR(256)	 NOT NULL,
MTS_OUT_QSIZE_MAX	VARCHAR(256)	 NOT NULL,
IN_CONNS_MIN	VARCHAR(256)	 NOT NULL,
IN_CONNS_MAX	VARCHAR(256)	 NOT NULL,
OUT_CONNS_MIN	VARCHAR(256)	 NOT NULL,
OUT_CONNS_MAX	VARCHAR(256)	 NOT NULL,
CONNS_FAILED_MIN	VARCHAR(256)	 NOT NULL,
CONNS_FAILED_MAX	VARCHAR(256)	 NOT NULL,
CONNS_REJECTED_MIN	VARCHAR(256)	 NOT NULL,
CONNS_REJECTED_MAX	VARCHAR(256)	 NOT NULL,
IN_MSGS_MIN	VARCHAR(256)	 NOT NULL,
IN_MSGS_MAX	VARCHAR(256)	 NOT NULL,
OUT_MSGS_MIN	VARCHAR(256)	 NOT NULL,
OUT_MSGS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MsXMailSvcTest_THRESH ADD constraint PK_MsXMailSvcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsXMailSvcTest_THRESH ON MsXMailSvcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MsXMailXferTest;

CREATE TABLE MsXMailXferTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	localQSize			decimal(20,4) not null,
	localQSize_st			varchar(32) not null,
	remoteQSize			decimal(20,4) not null,
	remoteQSize_st			varchar(32) not null,
	currSmtpConn			decimal(20,4) not null,
	currSmtpConn_st			varchar(32) not null,
	dataRcvdRate			decimal(20,4) not null,
	dataRcvdRate_st			varchar(32) not null,
	dataSentRate			decimal(20,4) not null,
	dataSentRate_st			varchar(32) not null,
	avgRetryMsgDelvry		decimal(20,4) not null,
	avgRetryMsgDelvry_st		varchar(32) not null,
	avgRetryMsgSent			decimal(20,4) not null,
	avgRetryMsgSent_st		varchar(32) not null
	
);

ALTER TABLE MsXMailXferTest ADD constraint PK_MsXMailXferTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXMailXferTest ON MsXMailXferTest
(
	 MSMT_TIME
);
DROP TABLE   MsXMailXferTest_TREND;

CREATE TABLE MsXMailXferTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	localQSize_min			decimal(20,4) not null,
	localQSize_max			decimal(20,4) not null,
	localQSize_stcnt		varchar(32) not null,
	remoteQSize_min			decimal(20,4) not null,
	remoteQSize_max			decimal(20,4) not null,
	remoteQSize_stcnt		varchar(32) not null,
	currSmtpConn_min		decimal(20,4) not null,
	currSmtpConn_max		decimal(20,4) not null,
	currSmtpConn_stcnt		varchar(32) not null,
	dataRcvdRate_min		decimal(20,4) not null,
	dataRcvdRate_max		decimal(20,4) not null,
	dataRcvdRate_stcnt		varchar(32) not null,
	dataSentRate_min		decimal(20,4) not null,
	dataSentRate_max		decimal(20,4) not null,
	dataSentRate_stcnt		varchar(32) not null,
	avgRetryMsgDelvry_min		decimal(20,4) not null,
	avgRetryMsgDelvry_max		decimal(20,4) not null,
	avgRetryMsgDelvry_stcnt		varchar(32) not null,
	avgRetryMsgSent_min		decimal(20,4) not null,
	avgRetryMsgSent_max		decimal(20,4) not null,
	avgRetryMsgSent_stcnt		varchar(32) not null
	
);

ALTER TABLE MsXMailXferTest_TREND ADD constraint PK_MsXMailXferTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXMailXferTest_THRESH;

CREATE TABLE MsXMailXferTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	LOCALQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	LOCALQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	REMOTEQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MIN	VARCHAR(256)	 NOT NULL,
	CURRSMTPCONN_MAX	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATARCVDRATE_MAX	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	DATASENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGDELVRY_MAX	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MIN	VARCHAR(256)	 NOT NULL,
	AVGRETRYMSGSENT_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE MsXMailXferTest_THRESH ADD constraint PK_MsXMailXferTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXMailXferTest_THRESH ON MsXMailXferTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);  

DROP TABLE MsXStoreTest;

CREATE TABLE MsXStoreTest
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO				varchar(32) NOT NULL,
	SITE_NAME			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME 			datetime NOT NULL,
	currUsers			decimal(20,4) not null,
	currUsers_st			varchar(32) not null,
	mailSendQSize			decimal(20,4) not null,
	mailSendQSize_st		varchar(32) not null,
	mailRcvdQSize			decimal(20,4) not null,
	mailRcvdQSize_st		varchar(32) not null,
	mailSentRate			decimal(20,4) not null,
	mailSentRate_st			varchar(32) not null,
	mailOpensRate			decimal(20,4) not null,
	mailOpensRate_st		varchar(32) not null,
	folderOpensRate			decimal(20,4) not null,
	folderOpensRate_st		varchar(32) not null,
	avgMailDelvryTime			decimal(20,4) not null,
	avgMailDelvryTime_st		varchar(32) not null,
	avgMailLocalDelvryTime		decimal(20,4) not null,
	avgMailLocalDelvryTime_st		varchar(32) not null
	
);

ALTER TABLE MsXStoreTest ADD constraint PK_MsXStoreTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsXStoreTest ON MsXStoreTest
(
	 MSMT_TIME
);
DROP TABLE   MsXStoreTest_TREND;

CREATE TABLE MsXStoreTest_TREND 
(
	TRGT_HOST			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME			datetime NOT NULL,
	PERIOD 				varchar(32) NOT NULL,
	currUsers_min			decimal(20,4) not null,
	currUsers_max			decimal(20,4) not null,
	currUsers_stcnt			varchar(32) not null,
	mailSendQSize_min		decimal(20,4) not null,
	mailSendQSize_max		decimal(20,4) not null,
	mailSendQSize_stcnt		varchar(32) not null,
	mailRcvdQSize_min		decimal(20,4) not null,
	mailRcvdQSize_max		decimal(20,4) not null,
	mailRcvdQSize_stcnt		varchar(32) not null,
	mailSentRate_min		decimal(20,4) not null,
	mailSentRate_max		decimal(20,4) not null,
	mailSentRate_stcnt		varchar(32) not null,
	mailOpensRate_min		decimal(20,4) not null,
	mailOpensRate_max		decimal(20,4) not null,
	mailOpensRate_stcnt		varchar(32) not null,
	folderOpensRate_min		decimal(20,4) not null,
	folderOpensRate_max		decimal(20,4) not null,
	folderOpensRate_stcnt		varchar(32) not null,
	avgMailDelvryTime_min		decimal(20,4) not null,
	avgMailDelvryTime_max		decimal(20,4) not null,
	avgMailDelvryTime_stcnt		varchar(32) not null,
	avgMailLocalDelvryTime_min		decimal(20,4) not null,
	avgMailLocalDelvryTime_max		decimal(20,4) not null,
	avgMailLocalDelvryTime_stcnt	varchar(32) not null
	
);

ALTER TABLE MsXStoreTest_TREND ADD constraint PK_MsXStoreTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE   MsXStoreTest_THRESH;

CREATE TABLE MsXStoreTest_THRESH 
(
	TRGT_HOST 			varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME        		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME_START			datetime NOT NULL,
      	MSMT_TIME_END   		datetime NOT NULL,
      	CURRUSERS_MIN	VARCHAR(256)	 NOT NULL,
	CURRUSERS_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MIN	VARCHAR(256)	 NOT NULL,
	MAILRCVDQSIZE_MAX	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILSENTRATE_MAX	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	MAILOPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MIN	VARCHAR(256)	 NOT NULL,
	FOLDEROPENSRATE_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MIN	VARCHAR(256)	 NOT NULL,
	AVGMAILLOCALDELVRYTIME_MAX	VARCHAR(256)	 NOT NULL
	
);

ALTER TABLE MsXStoreTest_THRESH ADD constraint PK_MsXStoreTest_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MsXStoreTest_THRESH ON MsXStoreTest_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);          

DROP TABLE EJBNAMES;

CREATE TABLE EJBNAMES
(
        TEST_NAME       varchar(64) not null,
        TRGT_HOST       varchar(32) not null,
        PORT_NO         varchar(32) not null,
        EJB             varchar(256) not null
);
ALTER TABLE EJBNAMES ADD CONSTRAINT PK_EJBNAMES
PRIMARY KEY (TEST_NAME,TRGT_HOST,PORT_NO,EJB);

DROP TABLE PrinterTest;

CREATE TABLE PrinterTest
( 	
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO 	           	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PRINTER_AVAILABILITY	 	decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterTest ADD constraint PK_PrinterTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterTest ON PrinterTest
(
	 MSMT_TIME
);
DROP TABLE PrinterTest_TREND;

CREATE TABLE PrinterTest_TREND 
( 	
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO 	           	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime 	NOT NULL,
	PERIOD       				varchar(32)			NOT NULL,
	PRINTER_AVAILABILITY_MIN 		decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_MAX 		decimal(20,4) 	NOT NULL,
	PRINTER_AVAILABILITY_STCNT		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterTest_TREND ADD constraint PK_PrinterTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterTest_THRESH ;

CREATE TABLE PrinterTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
		PORT_NO         varchar(32) NOT NULL,
		SITE_NAME        varchar(64) NOT NULL,
		INFO            varchar(128) NOT NULL,
		MSMT_HOST 	varchar(32) NOT NULL, 
		MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PRINTER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	PRINTER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL
);
ALTER TABLE PrinterTest_THRESH ADD constraint PK_PrinterTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterTest_THRESH ON PrinterTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterCoverTest;

CREATE TABLE PrinterCoverTest 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	COVER_CLOSED 			decimal(20,4) 	NOT NULL,
	COVER_CLOSED_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest ADD constraint PK_PrinterCoverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterCoverTest ON PrinterCoverTest
(
	 MSMT_TIME
);
DROP TABLE PrinterCoverTest_TREND;

CREATE TABLE PrinterCoverTest_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)		NOT NULL,
	COVER_CLOSED_MIN 		decimal(20,4) 	NOT NULL,
	COVER_CLOSED_MAX 		decimal(20,4) 	NOT NULL,
	COVER_CLOSED_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterCoverTest_TREND ADD constraint PK_PrinterCoverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterCoverTest_THRESH ;

CREATE TABLE PrinterCoverTest_THRESH 
( 		
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	COVER_CLOSED_MIN	VARCHAR(256)	 	NOT NULL,
	COVER_CLOSED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PrinterCoverTest_THRESH ADD constraint PK_PrinterCoverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterCoverTest_THRESH ON PrinterCoverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterErrorTest;

CREATE TABLE PrinterErrorTest
( 
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PAPER_AVAILABILITY 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_ST varchar(32) 	NOT NULL,
	TONER_CAPACITY 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_ST 	varchar(32) 	NOT NULL,
	TONER_AVAILABILITY 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_ST varchar(32) 	NOT NULL,
	PAPER_FLOW 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_ST 		varchar(32) 	NOT NULL,
	ON_LINE 				decimal(20,4) 	NOT NULL,
	ON_LINE_ST 			varchar(32) 	NOT NULL,
	DOOR_CLOSED 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_ST 		varchar(32) NOT NULL
);
	
ALTER TABLE PrinterErrorTest ADD constraint PK_PrinterErrorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterErrorTest ON PrinterErrorTest
(
	 MSMT_TIME
);
DROP TABLE PrinterErrorTest_TREND;

CREATE TABLE PrinterErrorTest_TREND
( 
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       				varchar(32)	NOT NULL,
	PAPER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	PAPER_AVAILABILITY_STCNT 	varchar(32) 	NOT NULL,
	TONER_CAPACITY_MIN 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_MAX 		decimal(20,4) 	NOT NULL,
	TONER_CAPACITY_STCNT 	varchar(32) 	NOT NULL,
	TONER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	TONER_AVAILABILITY_STCNT 	varchar(32)	NOT NULL,
	PAPER_FLOW_MIN 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_MAX 			decimal(20,4) 	NOT NULL,
	PAPER_FLOW_STCNT 		varchar(32) 	NOT NULL,
	ON_LINE_MIN 				decimal(20,4) 	NOT NULL,
	ON_LINE_MAX 				decimal(20,4) 	NOT NULL,
	ON_LINE_STCNT 			varchar(32) 	NOT NULL,
	DOOR_CLOSED_MIN 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_MAX 		decimal(20,4) 	NOT NULL,
	DOOR_CLOSED_STCNT 		varchar(32) 	NOT NULL
);
	
ALTER TABLE PrinterErrorTest_TREND ADD constraint PK_PrinterErrorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterErrorTest_THRESH;

CREATE TABLE PrinterErrorTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PAPER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	PAPER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL,
	TONER_CAPACITY_MIN	VARCHAR(256)	 	NOT NULL,
	TONER_CAPACITY_MAX	VARCHAR(256)		NOT NULL,
	TONER_AVAILABILITY_MIN	VARCHAR(256)	 	NOT NULL,
	TONER_AVAILABILITY_MAX	VARCHAR(256)	 	NOT NULL,
	PAPER_FLOW_MIN	VARCHAR(256)	 	NOT NULL,
	PAPER_FLOW_MAX	VARCHAR(256)	 	NOT NULL,
	ON_LINE_MIN	VARCHAR(256)	 	NOT NULL,
	ON_LINE_MAX	VARCHAR(256)	 	NOT NULL,
	DOOR_CLOSED_MIN	VARCHAR(256)	 	NOT NULL,
	DOOR_CLOSED_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE PrinterErrorTest_THRESH ADD constraint PK_PrinterErrorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterErrorTest_THRESH ON PrinterErrorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterInputTest;

CREATE TABLE PrinterInputTest
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	TRAY_AVAILABILITY 		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_ST		varchar(32) 	NOT NULL,
	TRAY_IDLE 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_ST 			varchar(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY 	decimal(20,4)	NOT NULL,
	TRAY_PAPER_AVAILABILITY_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest ADD constraint PK_PrinterInputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterInputTest ON PrinterInputTest
(
	 MSMT_TIME
);
DROP TABLE PrinterInputTest_TREND;

CREATE TABLE PrinterInputTest_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)			NOT NULL,
	TRAY_AVAILABILITY_MIN 		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_MAX		decimal(20,4) 	NOT NULL,
	TRAY_AVAILABILITY_STCNT 	varchar(32)	NOT NULL,
	TRAY_IDLE_MIN 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_MAX 			decimal(20,4) 	NOT NULL,
	TRAY_IDLE_STCNT 		varchar(32) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN 	decimal(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX 	decimal(20,4) 	NOT NULL,
	TRAY_PAPER_AVAILABILITY_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE PrinterInputTest_TREND ADD constraint PK_PrinterInputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterInputTest_THRESH;

CREATE TABLE PrinterInputTest_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	TRAY_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	TRAY_IDLE_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_IDLE_MAX	VARCHAR(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	TRAY_PAPER_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterInputTest_THRESH ADD constraint PK_PrinterInputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterInputTest_THRESH ON PrinterInputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterOutputTest;

CREATE TABLE PrinterOutputTest
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	OUTPUT_BIN_AVAILABLE 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_ST 	varchar(32) 	NOT NULL,
	OUTPUT_BIN_IDLE 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest ADD constraint PK_PrinterOutputTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterOutputTest ON PrinterOutputTest
(
	 MSMT_TIME
);
DROP TABLE PrinterOutputTest_TREND;

CREATE TABLE PrinterOutputTest_TREND
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)			NOT NULL,
	OUTPUT_BIN_AVAILABLE_MIN 	decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX 	decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_AVAILABLE_STCNT	varchar(32) 	NOT NULL,
	OUTPUT_BIN_IDLE_MIN 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_MAX 		decimal(20,4) 	NOT NULL,
	OUTPUT_BIN_IDLE_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterOutputTest_TREND ADD constraint PK_PrinterOutputTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterOutputTest_THRESH;

CREATE TABLE PrinterOutputTest_THRESH
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	OUTPUT_BIN_AVAILABLE_MIN	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_AVAILABLE_MAX	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MIN	VARCHAR(256)	 NOT NULL,
	OUTPUT_BIN_IDLE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterOutputTest_THRESH ADD constraint PK_PrinterOutputTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterOutputTest_THRESH ON PrinterOutputTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE PrinterPageCount;

CREATE TABLE PrinterPageCount
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PAGES_PRINTED decimal(20,4) NOT NULL,
	PAGES_PRINTED_ST varchar(32) NOT NULL
);

ALTER TABLE PrinterPageCount ADD constraint PK_PrinterPageCount PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_PrinterPageCount ON PrinterPageCount
(
	 MSMT_TIME
);
DROP TABLE PrinterPageCount_TREND;

CREATE TABLE PrinterPageCount_TREND 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	PERIOD       			varchar(32)		NOT NULL,
	PAGES_PRINTED_MIN 		decimal(20,4) 	NOT NULL,
	PAGES_PRINTED_MAX 		decimal(20,4) 	NOT NULL,
	PAGES_PRINTED_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE PrinterPageCount_TREND ADD constraint PK_PrinterPageCount_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE PrinterPageCount_THRESH;

CREATE TABLE PrinterPageCount_THRESH 
( 	
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PAGES_PRINTED_MIN	VARCHAR(256)	 NOT NULL,
	PAGES_PRINTED_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE PrinterPageCount_THRESH ADD constraint PK_PrinterPageCount_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_PrinterPageCount_THRESH ON PrinterPageCount_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNTHREADTEST;
CREATE TABLE JRUNTHREADTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Pct_threads_utilized 		decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_st 	varchar(32) 	NOT NULL,
	Waiting_thread_count 		decimal(20,4) 	NOT NULL,
	Waiting_thread_count_st		varchar(32) 	NOT NULL,
	Total_threads_count	 	decimal(20,4) 	NOT NULL,
	Total_threads_count_st		 varchar(32) 	NOT NULL
);

ALTER TABLE JRUNTHREADTEST ADD constraint PK_JRUNTHREADTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNTHREADTEST ON JRUNTHREADTEST
(
	 MSMT_TIME
);
DROP TABLE JRUNTHREADTEST_TREND;

CREATE TABLE JRUNTHREADTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Pct_threads_utilized_MIN	        decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_MAX	        decimal(20,4) 	NOT NULL,
	Pct_threads_utilized_STCNT 	varchar(32) 	NOT NULL,
	Waiting_thread_count_MIN	decimal(20,4) 	NOT NULL,
	Waiting_thread_count_MAX	decimal(20,4) 	NOT NULL,
	Waiting_thread_count_STCNT 	varchar(32) 	NOT NULL,
	Total_threads_count_MIN		decimal(20,4) 	NOT NULL,
	Total_threads_count_MAX		decimal(20,4) 	NOT NULL,
	Total_threads_count_STCNT 	varchar(32) 	NOT NULL
	
);


ALTER TABLE JRUNTHREADTEST_TREND ADD constraint PK_JRUNTHREADTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNTHREADTEST_THRESH;

CREATE TABLE JRUNTHREADTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	PCT_THREADS_UTILIZED_MIN	VARCHAR(256)	 	NOT NULL,
	PCT_THREADS_UTILIZED_MAX	VARCHAR(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	WAITING_THREAD_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_THREADS_COUNT_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNTHREADTEST_THRESH ADD constraint PK_JRUNTHREADTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNTHREADTEST_THRESH ON JRUNTHREADTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE JRUNSERVERTEST;

CREATE TABLE JRUNSERVERTEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Total_serv_memory 		decimal(20,4) 	NOT NULL,
	Total_serv_memory_st 	varchar(32) 	NOT NULL,
	Free_serv_memory 		decimal(20,4) 	NOT NULL,
	Free_serv_memory_st		varchar(32) 	NOT NULL,
	Num_active_sessions	 	decimal(20,4) 	NOT NULL,
	Num_active_sessions_st		 varchar(32) 	NOT NULL,
	Num_mem_sessions	 	decimal(20,4) 	NOT NULL,
	Num_mem_sessions_st		 varchar(32) 	NOT NULL

);

ALTER TABLE JRUNSERVERTEST ADD constraint PK_JRUNSERVERTEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNSERVERTEST ON JRUNSERVERTEST
(
	 MSMT_TIME
);
DROP TABLE JRUNSERVERTEST_TREND;

CREATE TABLE JRUNSERVERTEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Total_serv_memory_MIN	        decimal(20,4) 	NOT NULL,
	Total_serv_memory_MAX	        decimal(20,4) 	NOT NULL,
	Total_serv_memory_STCNT 	varchar(32) 	NOT NULL,
	Free_serv_memory_MIN		decimal(20,4) 	NOT NULL,
	Free_serv_memory_MAX		decimal(20,4) 	NOT NULL,
	Free_serv_memory_STCNT 		varchar(32) 	NOT NULL,
	Num_active_sessions_MIN		decimal(20,4) 	NOT NULL,
	Num_active_sessions_MAX		decimal(20,4) 	NOT NULL,
	Num_active_sessions_STCNT 	varchar(32) 	NOT NULL,
	Num_mem_sessions_MIN		decimal(20,4) 	NOT NULL,
	Num_mem_sessions_MAX		decimal(20,4) 	NOT NULL,
	Num_mem_sessions_STCNT 		varchar(32) 	NOT NULL	
	
);


ALTER TABLE JRUNSERVERTEST_TREND ADD constraint PK_JRUNSERVERTEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVERTEST_THRESH;

CREATE TABLE JRUNSERVERTEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	TOTAL_SERV_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_SERV_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MIN	VARCHAR(256)	 	NOT NULL,
	FREE_SERV_MEMORY_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_ACTIVE_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MIN	VARCHAR(256)	 	NOT NULL,
	NUM_MEM_SESSIONS_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNSERVERTEST_THRESH ADD constraint PK_JRUNSERVERTEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVERTEST_THRESH ON JRUNSERVERTEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JRUNSERVICETEST;

CREATE TABLE JRUNSERVICETEST
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME 	datetime NOT NULL,
	Request_rate 		decimal(20,4) 	NOT NULL,
	Request_rate_st 	varchar(32) 	NOT NULL,
	Avg_queue_time 		decimal(20,4) 	NOT NULL,
	Avg_queue_time_st 	varchar(32) 	NOT NULL,
	Avg_proc_time 		decimal(20,4) 	NOT NULL,
	Avg_proc_time_st		varchar(32) 	NOT NULL,
	Avg_response_time	 	decimal(20,4) 	NOT NULL,
	Avg_response_time_st		 varchar(32) 	NOT NULL,
	Data_read_rate	 		decimal(20,4) 	NOT NULL,
	Data_read_rate_st		 varchar(32) 	NOT NULL,
	Data_write_rate	 		decimal(20,4) 	NOT NULL,
	Data_write_rate_st		 varchar(32) 	NOT NULL,
	Delayed_request_count	 	decimal(20,4) 	NOT NULL,
	Delayed_request_count_st	 varchar(32) 	NOT NULL,
	Dropped_request_count	 	decimal(20,4) 	NOT NULL,
	Dropped_request_count_st	 varchar(32) 	NOT NULL
);

ALTER TABLE JRUNSERVICETEST ADD constraint PK_JRUNSERVICETEST
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME); 
CREATE  INDEX IDX_JRUNSERVICETEST ON JRUNSERVICETEST
(
	 MSMT_TIME
);
DROP TABLE JRUNSERVICETEST_TREND;

CREATE TABLE JRUNSERVICETEST_TREND 
(
	TRGT_HOST		varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
	SITE_NAME       	varchar(64) NOT NULL,
	INFO            	varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME		datetime NOT NULL,
	PERIOD 			varchar(32) NOT NULL,
	Request_rate_MIN	decimal(20,4) NOT NULL,
	Request_rate_MAX	decimal(20,4) NOT NULL,
	Request_rate_STCNT	varchar(32) NOT NULL,
	Avg_queue_time_MIN	        decimal(20,4) 	NOT NULL,
	Avg_queue_time_MAX	        decimal(20,4) 	NOT NULL,
	Avg_queue_time_STCNT 		varchar(32) 	NOT NULL,
	Avg_proc_time_MIN		decimal(20,4) 	NOT NULL,
	Avg_proc_time_MAX		decimal(20,4) 	NOT NULL,
	Avg_proc_time_STCNT 		varchar(32) 	NOT NULL,
	Avg_response_time_MIN		decimal(20,4) 	NOT NULL,
	Avg_response_time_MAX		decimal(20,4) 	NOT NULL,
	Avg_response_time_STCNT 	varchar(32) 	NOT NULL,
	Data_read_rate_MIN		decimal(20,4) 	NOT NULL,
	Data_read_rate_MAX		decimal(20,4) 	NOT NULL,
	Data_read_rate_STCNT 		varchar(32) 	NOT NULL,	
	Data_write_rate_MIN		decimal(20,4) 	NOT NULL,
	Data_write_rate_MAX		decimal(20,4) 	NOT NULL,
	Data_write_rate_STCNT 		varchar(32) 	NOT NULL,	
	Delayed_request_count_MIN		decimal(20,4) 	NOT NULL,
	Delayed_request_count_MAX		decimal(20,4) 	NOT NULL,
	Delayed_request_count_STCNT 		varchar(32) 	NOT NULL,
	Dropped_request_count_MIN		decimal(20,4) 	NOT NULL,
	Dropped_request_count_MAX		decimal(20,4) 	NOT NULL,
	Dropped_request_count_STCNT 		varchar(32) 	NOT NULL	
	
);


ALTER TABLE JRUNSERVICETEST_TREND ADD constraint PK_JRUNSERVICETEST_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JRUNSERVICETEST_THRESH;

CREATE TABLE JRUNSERVICETEST_THRESH 
(
	TRGT_HOST 	varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST 	varchar(32) NOT NULL, 
	MSMT_TIME_START	datetime NOT NULL,
        MSMT_TIME_END   datetime NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 NOT NULL,
	AVG_QUEUE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_QUEUE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_PROC_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_PROC_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR(256)	 	NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_READ_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_READ_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DATA_WRITE_RATE_MIN	VARCHAR(256)	 	NOT NULL,
	DATA_WRITE_RATE_MAX	VARCHAR(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	DELAYED_REQUEST_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	DROPPED_REQUEST_COUNT_MAX	VARCHAR(256)	 	NOT NULL
	
);

ALTER TABLE JRUNSERVICETEST_THRESH ADD constraint PK_JRUNSERVICETEST_THRESH
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START) ;

CREATE INDEX IDX_JRUNSERVICETEST_THRESH ON JRUNSERVICETEST_THRESH(MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE BackupJobsTest;

CREATE TABLE BackupJobsTest
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128)	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ACTIVE_JOB_COUNT 	DECIMAL(20,4)   NOT NULL,
	ACTIVE_JOB_COUNT_ST 	varchar(32) 	NOT NULL,
	FAILED_JOBS_COUNT 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_ST 	varchar(32) 	NOT NULL,
	SUCCESSFUL_JOBS 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_ST 	varchar(32) 	NOT NULL,
	TOTAL_BYTES 		DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_ST 		varchar(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest ADD constraint PK_BackupJobsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_BackupJobsTest ON BackupJobsTest
(
	 MSMT_TIME
);
DROP TABLE BackupJobsTest_TREND;

CREATE TABLE BackupJobsTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO           		varchar(128)	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	ACTIVE_JOB_COUNT_MIN 	DECIMAL(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX 	DECIMAL(20,4) 	NOT NULL,
	ACTIVE_JOB_COUNT_STCNT 	varchar(32) 	NOT NULL,
	FAILED_JOBS_COUNT_MIN 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_MAX 	DECIMAL(20,4) 	NOT NULL,
	FAILED_JOBS_COUNT_STCNT varchar(32) 	NOT NULL,
	SUCCESSFUL_JOBS_MIN 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_MAX 	DECIMAL(20,4) 	NOT NULL,
	SUCCESSFUL_JOBS_STCNT 	varchar(32) 	NOT NULL,
	TOTAL_BYTES_MIN 	DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_MAX 	DECIMAL(20,4) 	NOT NULL,
	TOTAL_BYTES_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE BackupJobsTest_TREND ADD constraint PK_BackupJobsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BackupJobsTest_THRESH;

CREATE TABLE BackupJobsTest_THRESH 
( 	
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64)	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ACTIVE_JOB_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	ACTIVE_JOB_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MIN	VARCHAR(256)	 	NOT NULL,
	FAILED_JOBS_COUNT_MAX	VARCHAR(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MIN	VARCHAR(256)	 	NOT NULL,
	SUCCESSFUL_JOBS_MAX	VARCHAR(256)	 	NOT NULL,
	TOTAL_BYTES_MIN	VARCHAR(256)	 	NOT NULL,
	TOTAL_BYTES_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE BackupJobsTest_THRESH ADD constraint PK_BackupJobsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_BackupJobsTest_THRESH ON BackupJobsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE VeritasStatsTest;

CREATE TABLE VeritasStatsTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO       	  	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ABORTED_JOBS 		DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_ST 	varchar(32) 	NOT NULL,
	CORRUPTED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_ST 	varchar(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_ST varchar(32) 	NOT NULL,
	FAILED_VERIFY_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	FAILED_VERIFY_OBJECTS_ST varchar(32) 	NOT NULL,
	SKIPPED_OBJECTS 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_ST 	varchar(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest ADD constraint PK_VeritasStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_VeritasStatsTest ON VeritasStatsTest
(
	 MSMT_TIME
);
DROP TABLE VeritasStatsTest_TREND;

CREATE TABLE VeritasStatsTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	ABORTED_JOBS_MIN 	DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_MAX 	DECIMAL(20,4) 	NOT NULL,
	ABORTED_JOBS_STCNT 	varchar(32) 	NOT NULL,
	CORRUPTED_OBJECTS_MIN 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_MAX 	DECIMAL(20,4) 	NOT NULL,
	CORRUPTED_OBJECTS_STCNT varchar(32) 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN DECIMAL(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX DECIMAL(20,4) NOT NULL,
	ERROR_SKIPPED_OBJECTS_STCNT varchar(32) NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN DECIMAL(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX DECIMAL(20,4) NOT NULL,
	FAILED_VERIFY_OBJECTS_STCNT varchar(32) NOT NULL,
	SKIPPED_OBJECTS_MIN 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_MAX 	DECIMAL(20,4) 	NOT NULL,
	SKIPPED_OBJECTS_STCNT 	varchar(32) 	NOT NULL
);

ALTER TABLE VeritasStatsTest_TREND ADD constraint PK_VeritasStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE VeritasStatsTest_THRESH;

CREATE TABLE VeritasStatsTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ABORTED_JOBS_MIN	VARCHAR(256)	 	NOT NULL,
	ABORTED_JOBS_MAX	VARCHAR(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MIN	VARCHAR(256)	 	NOT NULL,
	CORRUPTED_OBJECTS_MAX	VARCHAR(256)	 	NOT NULL,
	ERROR_SKIPPED_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	ERROR_SKIPPED_OBJECTS_MAX	VARCHAR(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	FAILED_VERIFY_OBJECTS_MAX	VARCHAR(256)	 NOT NULL,
	SKIPPED_OBJECTS_MIN	VARCHAR(256)	 	NOT NULL,
	SKIPPED_OBJECTS_MAX	VARCHAR(256)	 	NOT NULL
);

ALTER TABLE VeritasStatsTest_THRESH ADD constraint PK_VeritasStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_VeritasStatsTest_THRESH ON VeritasStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE EventLogTest;

CREATE TABLE EventLogTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO       	  	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	APP_ERROR_CNT		DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_ST	varchar(32)	NOT NULL,
	APP_INFRM_CNT		DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_ST	varchar(32)	NOT NULL,
	APP_WARNING_CNT		DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_ST	varchar(32)	NOT NULL,
	SYS_ERROR_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_ST	varchar(32)	NOT NULL,
	SYS_INFRM_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_ST	varchar(32)	NOT NULL,
	SYS_WARNING_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_ST	varchar(32)	NOT NULL,
	APP_CRITICAL_CNT	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_ST	varchar(32)	NOT NULL,
	APP_VERBOSE_CNT		DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_ST	varchar(32)	NOT NULL,
	SYS_CRITICAL_CNT	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_ST	varchar(32)	NOT NULL,
	SYS_VERBOSE_CNT		DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_ST	varchar(32)	NOT NULL
	
);

ALTER TABLE EventLogTest ADD constraint PK_EventLogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_EventLogTest ON EventLogTest
(
	 MSMT_TIME
);
DROP TABLE EventLogTest_TREND;

CREATE TABLE EventLogTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       		varchar(32) 	NOT NULL,
	APP_ERROR_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_ERROR_CNT_STCNT	varchar(32)	NOT NULL,
	APP_INFRM_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_INFRM_CNT_STCNT	varchar(32)	NOT NULL,
	APP_WARNING_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_WARNING_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_ERROR_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_ERROR_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_INFRM_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_INFRM_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_WARNING_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_WARNING_CNT_STCNT	varchar(32)	NOT NULL,
	APP_CRITICAL_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_CRITICAL_CNT_STCNT	varchar(32)	NOT NULL,
	APP_VERBOSE_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	APP_VERBOSE_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_CRITICAL_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_CRITICAL_CNT_STCNT	varchar(32)	NOT NULL,
	SYS_VERBOSE_CNT_MIN	DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	SYS_VERBOSE_CNT_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE EventLogTest_TREND ADD constraint PK_EventLogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EventLogTest_THRESH;

CREATE TABLE EventLogTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO         	varchar(32) 	NOT NULL,
	SITE_NAME       	varchar(64) 	NOT NULL,
	INFO            	varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	APP_ERROR_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_ERROR_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_INFRM_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_INFRM_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_WARNING_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_WARNING_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_ERROR_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_ERROR_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_INFRM_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_INFRM_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_WARNING_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_WARNING_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_CRITICAL_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_CRITICAL_CNT_MAX	VARCHAR(256)		NOT NULL,
	APP_VERBOSE_CNT_MIN	VARCHAR(256)		NOT NULL,
	APP_VERBOSE_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_CRITICAL_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_CRITICAL_CNT_MAX	VARCHAR(256)		NOT NULL,
	SYS_VERBOSE_CNT_MIN	VARCHAR(256)		NOT NULL,
	SYS_VERBOSE_CNT_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE EventLogTest_THRESH ADD constraint PK_EventLogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_EventLogTest_THRESH ON EventLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE JavaServerTest;

CREATE TABLE JavaServerTest
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO                	varchar(32) 	NOT NULL,
	SITE_NAME        	varchar(64) 	NOT NULL,
	INFO       	  	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	ACTIVE_THREAD_CNT	DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_ST	varchar(32)	NOT NULL,
	TOTAL_MEMORY		        DECIMAL(20,4)	NOT NULL,
	TOTAl_MEMORY_ST	        varchar(32)	NOT NULL,
	FREE_MEMORY		        DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_ST	        varchar(32)	NOT NULL
);

ALTER TABLE JavaServerTest ADD constraint PK_JavaServerTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE INDEX IDX_JavaServerTest ON JavaServerTest
(
	 MSMT_TIME
);
DROP TABLE JavaServerTest_TREND;

CREATE TABLE JavaServerTest_TREND
(
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO              	varchar(32) 	NOT NULL,
	SITE_NAME      	 	varchar(64) 	NOT NULL,
	INFO            	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME       	datetime 	NOT NULL,
	PERIOD       	        varchar(32) NOT NULL,
	ACTIVE_THREAD_CNT_MIN	        DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_MAX	DECIMAL(20,4)	NOT NULL,
	ACTIVE_THREAD_CNT_STCNT	varchar(32)	NOT NULL,
	TOTAL_MEMORY_MIN	        DECIMAL(20,4)	NOT NULL,
	TOTAL_MEMORY_MAX	        DECIMAL(20,4)	NOT NULL,
	TOTAL_MEMORY_STCNT	varchar(32)	NOT NULL,
	FREE_MEMORY_MIN	        DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_MAX    	DECIMAL(20,4)	NOT NULL,
	FREE_MEMORY_STCNT	varchar(32)	NOT NULL
);

ALTER TABLE JavaServerTest_TREND ADD constraint PK_JavaServerTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE JavaServerTest_THRESH;

CREATE TABLE JavaServerTest_THRESH
( 
	TRGT_HOST       	varchar(32) 	NOT NULL,
	PORT_NO               	varchar(32) 	NOT NULL,
	SITE_NAME       	        varchar(64) 	NOT NULL,
	INFO            	        varchar(128) 	NOT NULL,
	MSMT_HOST       	varchar(32) 	NOT NULL,
	MSMT_TIME_START 	datetime 	NOT NULL,
	MSMT_TIME_END   	datetime 	NOT NULL,
	ACTIVE_THREAD_CNT_MIN	VARCHAR(256)		NOT NULL,
	ACTIVE_THREAD_CNT_MAX	VARCHAR(256)		NOT NULL,
	TOTAL_MEMORY_MIN	VARCHAR(256)		NOT NULL,
	TOTAL_MEMORY_MAX	VARCHAR(256)		NOT NULL,
	FREE_MEMORY_MIN	VARCHAR(256)		NOT NULL,
	FREE_MEMORY_MAX	VARCHAR(256)		NOT NULL
);

ALTER TABLE JavaServerTest_THRESH ADD constraint PK_JavaServerTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_JavaServerTest_THRESH ON JavaServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TcpConnectionTest;

CREATE TABLE TcpConnectionTest
( 
	TRGT_HOST      varchar(32) NOT NULL, 
	PORT_NO          varchar(32) NOT NULL,  
	SITE_NAME       varchar(64) NOT NULL,    
	INFO                 varchar(128) NOT NULL,	
	MSMT_HOST      varchar(32) NOT NULL,	
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY          DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST     varchar(32) NOT NULL,
	RESPONSETIME        DECIMAL(20,4) NOT NULL,
	RESPONSETIME_ST  varchar(32) NOT NULL
);

ALTER TABLE TcpConnectionTest ADD constraint PK_TcpConnectionTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_TcpConnectionTest ON TcpConnectionTest
(
	 MSMT_TIME
);
DROP TABLE TcpConnectionTest_TREND;

CREATE TABLE TcpConnectionTest_TREND
(
	TRGT_HOST       varchar(32) NOT NULL,  
	PORT_NO           varchar(32) NOT NULL,  
	SITE_NAME        varchar(64) NOT NULL,
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,	
	PERIOD       	varchar(32) NOT NULL,
	AVAILABILITY_MIN        DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX       DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT    varchar(32) NOT NULL,
	RESPONSETIME_MIN      DECIMAL(20,4) NOT NULL,
	RESPONSETIME_MAX     DECIMAL(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar(32) NOT NULL
);

ALTER TABLE TcpConnectionTest_TREND ADD constraint PK_TcpConnectionTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpConnectionTest_THRESH;

CREATE TABLE TcpConnectionTest_THRESH 
( 
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL, 
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME_START  datetime NOT NULL,
	MSMT_TIME_END     datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE TcpConnectionTest_THRESH ADD constraint PK_TcpConnectionTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpConnectionTest_THRESH ON TcpConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE TcpPortStatusTest;

CREATE TABLE TcpPortStatusTest( 
	TRGT_HOST       varchar(32) NOT NULL, 
	PORT_NO         varchar(32) NOT NULL,  
	SITE_NAME       varchar(64) NOT NULL,    
	INFO            varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY    DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST varchar(32) NOT NULL,
	RESPONSETIME    DECIMAL(20,4) NOT NULL,
	RESPONSETIME_ST varchar(32) NOT NULL);

ALTER TABLE TcpPortStatusTest ADD constraint PK_TcpPortStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_TcpPortStatusTest ON TcpPortStatusTest (MSMT_TIME) INCLUDE(AVAILABILITY);

DROP TABLE TcpPortStatusTest_TREND;

CREATE TABLE TcpPortStatusTest_TREND(
	TRGT_HOST          varchar(32) NOT NULL,  
	PORT_NO            varchar(32) NOT NULL,  
	SITE_NAME          varchar(64) NOT NULL,
	INFO               varchar(128) NOT NULL,	
	MSMT_HOST          varchar(32) NOT NULL,
	MSMT_TIME          datetime NOT NULL,	
	PERIOD       	   varchar(32) NOT NULL,
	AVAILABILITY_MIN   DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX   DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar(32) NOT NULL,
	RESPONSETIME_MIN   DECIMAL(20,4) NOT NULL,
	RESPONSETIME_MAX   DECIMAL(20,4) NOT NULL,
	RESPONSETIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TcpPortStatusTest_TREND ADD constraint PK_TcpPortStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE TcpPortStatusTest_THRESH;

CREATE TABLE TcpPortStatusTest_THRESH( 
	TRGT_HOST           varchar(32) NOT NULL,
	PORT_NO             varchar(32) NOT NULL,
	SITE_NAME           varchar(64) NOT NULL, 
	INFO                varchar(128) NOT NULL,	
	MSMT_HOST           varchar(32) NOT NULL,	
	MSMT_TIME_START     datetime NOT NULL,
	MSMT_TIME_END       datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSETIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TcpPortStatusTest_THRESH ADD constraint PK_TcpPortStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TcpPortStatusTest_THRESH ON TcpPortStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE ProcessPoolTest;

CREATE TABLE ProcessPoolTest
(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL, 
	SITE_NAME        varchar(64) NOT NULL,  
	INFO                  varchar(128) NOT NULL,	
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME        datetime NOT NULL,
	NUMBER_OF_PROCESSES        DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_ST   varchar(32) NOT NULL,
	PERCENTAGE_CPU_UTIL          DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_ST     varchar(32) NOT NULL,
	PERCENTAGE_MEM_UTIL          DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_ST     varchar(32) NOT NULL
);

ALTER TABLE ProcessPoolTest ADD constraint PK_ProcessPoolTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_ProcessPoolTest ON ProcessPoolTest
(
	 MSMT_TIME
);
DROP TABLE ProcessPoolTest_TREND;

CREATE TABLE ProcessPoolTest_TREND
( 
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO           varchar(32) NOT NULL,
	SITE_NAME        varchar(64) NOT NULL,
	INFO                 varchar(128) NOT NULL,	
	MSMT_HOST      varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	NUMBER_OF_PROCESSES_MIN        DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_MAX       DECIMAL(20,4) NOT NULL,
	NUMBER_OF_PROCESSES_STCNT   varchar(32) NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN         DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX        DECIMAL(20,4) NOT NULL,
	PERCENTAGE_CPU_UTIL_STCNT    varchar(32) NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN        DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX       DECIMAL(20,4) NOT NULL,
	PERCENTAGE_MEM_UTIL_STCNT   varchar(32) NOT NULL
);

ALTER TABLE ProcessPoolTest_TREND ADD constraint PK_ProcessPoolTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ProcessPoolTest_THRESH;

CREATE TABLE ProcessPoolTest_THRESH
(
	TRGT_HOST      varchar(32) NOT NULL, 
	PORT_NO          varchar(32) NOT NULL, 
	SITE_NAME        varchar(64) NOT NULL,
	INFO                  varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,	
	MSMT_TIME_START  datetime NOT NULL,
	MSMT_TIME_END     datetime NOT NULL,
	NUMBER_OF_PROCESSES_MIN	VARCHAR(256)	 NOT NULL,
	NUMBER_OF_PROCESSES_MAX	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MIN	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_CPU_UTIL_MAX	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MIN	VARCHAR(256)	 NOT NULL,
	PERCENTAGE_MEM_UTIL_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ProcessPoolTest_THRESH ADD constraint PK_ProcessPoolTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProcessPoolTest_THRESH ON ProcessPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ErrorLogTest;

CREATE TABLE ErrorLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,    
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE ErrorLogTest ADD constraint PK_ErrorLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_ErrorLogTest ON ErrorLogTest
(
	 MSMT_TIME
);
DROP TABLE ErrorLogTest_TREND;

CREATE TABLE ErrorLogTest_TREND
(
 	TRGT_HOST       varchar(32) NOT NULL,   
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE ErrorLogTest_TREND ADD constraint PK_ErrorLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE ErrorLogTest_THRESH;

CREATE TABLE ErrorLogTest_THRESH
( 
	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE ErrorLogTest_THRESH ADD constraint PK_ErrorLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ErrorLogTest_THRESH ON ErrorLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsgLogTest;

CREATE TABLE MsgLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL,  
    PORT_NO         varchar(32) NOT NULL,   
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE MsgLogTest ADD constraint PK_MsgLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_MsgLogTest ON MsgLogTest
(
	 MSMT_TIME
);
DROP TABLE MsgLogTest_TREND;

CREATE TABLE MsgLogTest_TREND
(
 	TRGT_HOST       varchar(32) NOT NULL,   
    PORT_NO         varchar(32) NOT NULL,
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE MsgLogTest_TREND ADD constraint PK_MsgLogTest_TREND
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MsgLogTest_THRESH;
CREATE TABLE MsgLogTest_THRESH
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE MsgLogTest_THRESH ADD constraint PK_MsgLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsgLogTest_THRESH ON MsgLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE XceptionLogTest;

CREATE TABLE XceptionLogTest
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL, 
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
    NUMBER_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_ST varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_ST varchar(32) NOT NULL
);

ALTER TABLE XceptionLogTest ADD constraint PK_XceptionLogTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_XceptionLogTest ON XceptionLogTest
(
	 MSMT_TIME
);
DROP TABLE XceptionLogTest_TREND;

CREATE TABLE XceptionLogTest_TREND 
( 
	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL,  
    SITE_NAME       varchar(64) NOT NULL,   
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    NUMBER_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    HIGH_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    MEDIUM_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL,
    LOW_EXCEPTION_COUNT_MIN DECIMAL(20,4) NOT NULL, 
    LOW_EXCEPTION_COUNT_MAX DECIMAL(20,4) NOT NULL,
    LOW_EXCEPTION_COUNT_STCNT varchar(32) NOT NULL
);

ALTER TABLE XceptionLogTest_TREND ADD constraint PK_XceptionLogTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE XceptionLogTest_THRESH;

CREATE TABLE XceptionLogTest_THRESH
(
 	TRGT_HOST       varchar(32) NOT NULL, 
    PORT_NO         varchar(32) NOT NULL, 
    SITE_NAME       varchar(64) NOT NULL,  
    INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,  
    NUMBER_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    NUMBER_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    HIGH_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    MEDIUM_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MIN	VARCHAR(256)	 NOT NULL,
    LOW_EXCEPTION_COUNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE XceptionLogTest_THRESH ADD constraint PK_XceptionLogTest_THRESH
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XceptionLogTest_THRESH ON XceptionLogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE CiscoCatalystTest;

CREATE TABLE CiscoCatalystTest (
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
DATA_RECVD_RATE decimal(20,4) NOT NULL,
DATA_RECVD_RATE_ST varchar(32) NOT NULL,
DATA_XMIT_RATE decimal(20,4) NOT NULL,
DATA_XMIT_RATE_ST varchar(32) NOT NULL,
PCT_BANDWIDTH_USED decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_ST varchar(32) NOT NULL);

ALTER TABLE CiscoCatalystTest ADD constraint PK_CiscoCatalystTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_CiscoCatalystTest ON CiscoCatalystTest
(
	 MSMT_TIME
);
DROP TABLE CiscoCatalystTest_TREND;

CREATE TABLE CiscoCatalystTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,       
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,	
PERIOD       	varchar(32) NOT NULL,
DATA_RECVD_RATE_MIN decimal(20,4) NOT NULL,
DATA_RECVD_RATE_MAX decimal(20,4) NOT NULL,
DATA_RECVD_RATE_STCNT varchar(32) NOT NULL,
DATA_XMIT_RATE_MIN decimal(20,4) NOT NULL,
DATA_XMIT_RATE_MAX decimal(20,4) NOT NULL,
DATA_XMIT_RATE_STCNT varchar(32) NOT NULL,
PCT_BANDWIDTH_USED_MIN decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_MAX decimal(20,4) NOT NULL,
PCT_BANDWIDTH_USED_STCNT varchar(32) NOT NULL);

ALTER TABLE CiscoCatalystTest_TREND ADD constraint PK_CiscoCatalystTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoCatalystTest_THRESH;

CREATE TABLE CiscoCatalystTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,       
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,	
MSMT_TIME_END   datetime NOT NULL,
DATA_RECVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
DATA_RECVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
DATA_XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
DATA_XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MIN	VARCHAR(256)	 NOT NULL,
PCT_BANDWIDTH_USED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CiscoCatalystTest_THRESH ADD constraint PK_CiscoCatalystTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CiscoCatalystTest_THRESH ON CiscoCatalystTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxARTimeTest;

CREATE TABLE TuxARTimeTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
AVAILABILITY DECIMAL(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSE_TIME decimal(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE TuxARTimeTest ADD constraint PK_TuxARTimeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxARTimeTest ON TuxARTimeTest
(
	 MSMT_TIME
);
DROP TABLE TuxARTimeTest_TREND;

CREATE TABLE TuxARTimeTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN decimal(20,4) NOT NULL,
RESPONSE_TIME_MAX decimal(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxARTimeTest_TREND ADD constraint PK_TuxARTimeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxARTimeTest_THRESH;

CREATE TABLE TuxARTimeTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxARTimeTest_THRESH ADD constraint PK_TuxARTimeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxARTimeTest_THRESH ON TuxARTimeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxBridgeTest;

CREATE TABLE TuxBridgeTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
BRIDGE_STATE decimal(20,4) NOT NULL,
BRIDGE_STATE_ST varchar(32) NOT NULL,
BYT_RCVD_RATE DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_ST varchar(32) NOT NULL,
BYT_SENT_RATE DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_ST varchar(32) NOT NULL,
MSG_RCVD_RATE DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_ST varchar(32) NOT NULL,
MSG_SENT_RATE DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxBridgeTest ADD constraint PK_TuxBridgeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxBridgeTest ON TuxBridgeTest
(
	 MSMT_TIME
);
DROP TABLE TuxBridgeTest_TREND;

CREATE TABLE TuxBridgeTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
BRIDGE_STATE_MIN decimal(20,4) NOT NULL,
BRIDGE_STATE_MAX decimal(20,4) NOT NULL,
BRIDGE_STATE_STCNT varchar(32) NOT NULL,
BYT_RCVD_RATE_MIN DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_MAX DECIMAL(20,4) NOT NULL,
BYT_RCVD_RATE_STCNT varchar(32) NOT NULL,
BYT_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
BYT_SENT_RATE_STCNT varchar(32) NOT NULL,
MSG_RCVD_RATE_MIN DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_MAX DECIMAL(20,4) NOT NULL,
MSG_RCVD_RATE_STCNT varchar(32) NOT NULL,
MSG_SENT_RATE_MIN DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_MAX DECIMAL(20,4) NOT NULL,
MSG_SENT_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxBridgeTest_TREND ADD constraint PK_TuxBridgeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxBridgeTest_THRESH;

CREATE TABLE TuxBridgeTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
BRIDGE_STATE_MIN	VARCHAR(256)	 NOT NULL,
BRIDGE_STATE_MAX	VARCHAR(256)	 NOT NULL,
BYT_RCVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
BYT_RCVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
BYT_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
BYT_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
MSG_RCVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
MSG_RCVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
MSG_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
MSG_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxBridgeTest_THRESH ADD constraint PK_TuxBridgeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxBridgeTest_THRESH ON TuxBridgeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxDomainTest;

CREATE TABLE TuxDomainTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
CURR_MACS decimal(20,4) NOT NULL,
CURR_MACS_ST varchar(32) NOT NULL,
CURR_SERVERS decimal(20,4) NOT NULL,
CURR_SERVERS_ST varchar(32) NOT NULL,
CURR_QS decimal(20,4) NOT NULL,
CURR_QS_ST varchar(32) NOT NULL,
CURR_SERVICES decimal(20,4) NOT NULL,
CURR_SERVICES_ST varchar(32) NOT NULL,
MAC_PCT_UTIL DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_ST varchar(32) NOT NULL,
SERVER_PCT_UTIL DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_ST varchar(32) NOT NULL,
Q_PCT_UTIL DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_ST varchar(32) NOT NULL,
SERVICE_PCT_UTIL DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_ST varchar(32) NOT NULL);

ALTER TABLE TuxDomainTest ADD constraint PK_TuxDomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxDomainTest ON TuxDomainTest
(
	 MSMT_TIME
);
DROP TABLE TuxDomainTest_TREND;

CREATE TABLE TuxDomainTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURR_MACS_MIN decimal(20,4) NOT NULL,
CURR_MACS_MAX decimal(20,4) NOT NULL,
CURR_MACS_STCNT varchar(32) NOT NULL,
CURR_SERVERS_MIN decimal(20,4) NOT NULL,
CURR_SERVERS_MAX decimal(20,4) NOT NULL,
CURR_SERVERS_STCNT varchar(32) NOT NULL,
CURR_QS_MIN decimal(20,4) NOT NULL,
CURR_QS_MAX decimal(20,4) NOT NULL,
CURR_QS_STCNT varchar(32) NOT NULL,
CURR_SERVICES_MIN decimal(20,4) NOT NULL,
CURR_SERVICES_MAX decimal(20,4) NOT NULL,
CURR_SERVICES_STCNT varchar(32) NOT NULL,
MAC_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
MAC_PCT_UTIL_STCNT varchar(32) NOT NULL,
SERVER_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
SERVER_PCT_UTIL_STCNT varchar(32) NOT NULL,
Q_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
Q_PCT_UTIL_STCNT varchar(32) NOT NULL,
SERVICE_PCT_UTIL_MIN DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_MAX DECIMAL(20,4) NOT NULL,
SERVICE_PCT_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxDomainTest_TREND ADD constraint PK_TuxDomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxDomainTest_THRESH;

CREATE TABLE TuxDomainTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURR_MACS_MIN	VARCHAR(256)	 NOT NULL,
CURR_MACS_MAX	VARCHAR(256)	 NOT NULL,
CURR_SERVERS_MIN	VARCHAR(256)	 NOT NULL,
CURR_SERVERS_MAX	VARCHAR(256)	 NOT NULL,
CURR_QS_MIN	VARCHAR(256)	 NOT NULL,
CURR_QS_MAX	VARCHAR(256)	 NOT NULL,
CURR_SERVICES_MIN	VARCHAR(256)	 NOT NULL,
CURR_SERVICES_MAX	VARCHAR(256)	 NOT NULL,
MAC_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MAC_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
SERVER_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
SERVER_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
Q_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
Q_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL,
SERVICE_PCT_UTIL_MIN	VARCHAR(256)	 NOT NULL,
SERVICE_PCT_UTIL_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxDomainTest_THRESH ADD constraint PK_TuxDomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxDomainTest_THRESH ON TuxDomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxProcsTest;

CREATE TABLE TuxProcsTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NUM_OF_PROCS decimal(20,4) NOT NULL,
NUM_OF_PROCS_ST varchar(32) NOT NULL,
CPU_UTIL_PCT DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_ST varchar(32) NOT NULL,
MEM_UTIL_PCT DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_ST varchar(32) NOT NULL);

ALTER TABLE TuxProcsTest ADD constraint PK_TuxProcsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxProcsTest ON TuxProcsTest
(
	 MSMT_TIME
);
DROP TABLE TuxProcsTest_TREND;

CREATE TABLE TuxProcsTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUM_OF_PROCS_MIN decimal(20,4) NOT NULL,
NUM_OF_PROCS_MAX decimal(20,4) NOT NULL,
NUM_OF_PROCS_STCNT varchar(32) NOT NULL,
CPU_UTIL_PCT_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_PCT_STCNT varchar(32) NOT NULL,
MEM_UTIL_PCT_MIN DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_MAX DECIMAL(20,4) NOT NULL,
MEM_UTIL_PCT_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxProcsTest_TREND ADD constraint PK_TuxProcsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxProcsTest_THRESH;

CREATE TABLE TuxProcsTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUM_OF_PROCS_MIN	VARCHAR(256)	 NOT NULL,
NUM_OF_PROCS_MAX	VARCHAR(256)	 NOT NULL,
CPU_UTIL_PCT_MIN	VARCHAR(256)	 NOT NULL,
CPU_UTIL_PCT_MAX	VARCHAR(256)	 NOT NULL,
MEM_UTIL_PCT_MIN	VARCHAR(256)	 NOT NULL,
MEM_UTIL_PCT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxProcsTest_THRESH ADD constraint PK_TuxProcsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxProcsTest_THRESH ON TuxProcsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServerTest;

CREATE TABLE TuxServerTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVER_STATE decimal(20,4) NOT NULL,
SERVER_STATE_ST varchar(32) NOT NULL,
TOTWRKLC_RATE DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_ST varchar(32) NOT NULL,
TOTAL_CONV decimal(20,4) NOT NULL,
TOTAL_CONV_ST varchar(32) NOT NULL,
CURR_ACTIVE_CONV decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_ST varchar(32) NOT NULL,
TOTAL_REQ decimal(20,4) NOT NULL,
TOTAL_REQ_ST varchar(32) NOT NULL,
CURR_ACTIVE_REQ decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_ST varchar(32) NOT NULL,
TRAN_INIT_RATE DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar(32) NOT NULL,
TRAN_ABT_RATE DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar(32) NOT NULL,
TRAN_CMT_RATE DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar(32) NOT NULL,
TOTREQC_RATE DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxServerTest ADD constraint PK_TuxServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxServerTest ON TuxServerTest
(
	 MSMT_TIME
);
DROP TABLE TuxServerTest_TREND;

CREATE TABLE TuxServerTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVER_STATE_MIN decimal(20,4) NOT NULL,
SERVER_STATE_MAX decimal(20,4) NOT NULL,
SERVER_STATE_STCNT varchar(32) NOT NULL,
TOTWRKLC_RATE_MIN DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_MAX DECIMAL(20,4) NOT NULL,
TOTWRKLC_RATE_STCNT varchar(32) NOT NULL,
TOTAL_CONV_MIN decimal(20,4) NOT NULL,
TOTAL_CONV_MAX decimal(20,4) NOT NULL,
TOTAL_CONV_STCNT varchar(32) NOT NULL,
CURR_ACTIVE_CONV_MIN decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_MAX decimal(20,4) NOT NULL,
CURR_ACTIVE_CONV_STCNT varchar(32) NOT NULL,
TOTAL_REQ_MIN decimal(20,4) NOT NULL,
TOTAL_REQ_MAX decimal(20,4) NOT NULL,
TOTAL_REQ_STCNT varchar(32) NOT NULL,
CURR_ACTIVE_REQ_MIN decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_MAX decimal(20,4) NOT NULL,
CURR_ACTIVE_REQ_STCNT varchar(32) NOT NULL,
TRAN_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar(32) NOT NULL,
TRAN_ABT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar(32) NOT NULL,
TRAN_CMT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar(32) NOT NULL,
TOTREQC_RATE_MIN DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_MAX DECIMAL(20,4) NOT NULL,
TOTREQC_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxServerTest_TREND ADD constraint PK_TuxServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServerTest_THRESH;

CREATE TABLE TuxServerTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVER_STATE_MIN	VARCHAR(256)	 NOT NULL,
SERVER_STATE_MAX	VARCHAR(256)	 NOT NULL,
TOTWRKLC_RATE_MIN	VARCHAR(256)	 NOT NULL,
TOTWRKLC_RATE_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONV_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONV_MAX	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_CONV_MIN	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_CONV_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_REQ_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_REQ_MAX	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_REQ_MIN	VARCHAR(256)	 NOT NULL,
CURR_ACTIVE_REQ_MAX	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TOTREQC_RATE_MIN	VARCHAR(256)	 NOT NULL,
TOTREQC_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxServerTest_THRESH ADD constraint PK_TuxServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServerTest_THRESH ON TuxServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxServiceTest;

CREATE TABLE TuxServiceTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SERVICE_STATE decimal(20,4) NOT NULL,
SERVICE_STATE_ST varchar(32) NOT NULL,
LD_IMPOSED decimal(20,4) NOT NULL,
LD_IMPOSED_ST varchar(32) NOT NULL,
REQ_COMPLTD_RATE DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_ST varchar(32) NOT NULL,
REQ_CURR_QUD decimal(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar(32) NOT NULL);

ALTER TABLE TuxServiceTest ADD constraint PK_TuxServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxServiceTest ON TuxServiceTest
(
	 MSMT_TIME
);
DROP TABLE TuxServiceTest_TREND;

CREATE TABLE TuxServiceTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SERVICE_STATE_MIN decimal(20,4) NOT NULL,
SERVICE_STATE_MAX decimal(20,4) NOT NULL,
SERVICE_STATE_STCNT varchar(32) NOT NULL,
LD_IMPOSED_MIN decimal(20,4) NOT NULL,
LD_IMPOSED_MAX decimal(20,4) NOT NULL,
LD_IMPOSED_STCNT varchar(32) NOT NULL,
REQ_COMPLTD_RATE_MIN DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_MAX DECIMAL(20,4) NOT NULL,
REQ_COMPLTD_RATE_STCNT varchar(32) NOT NULL,
REQ_CURR_QUD_MIN decimal(20,4) NOT NULL,
REQ_CURR_QUD_MAX decimal(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxServiceTest_TREND ADD constraint PK_TuxServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxServiceTest_THRESH;

CREATE TABLE TuxServiceTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SERVICE_STATE_MIN	VARCHAR(256)	 NOT NULL,
SERVICE_STATE_MAX	VARCHAR(256)	 NOT NULL,
LD_IMPOSED_MIN	VARCHAR(256)	 NOT NULL,
LD_IMPOSED_MAX	VARCHAR(256)	 NOT NULL,
REQ_COMPLTD_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_COMPLTD_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxServiceTest_THRESH ADD constraint PK_TuxServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxServiceTest_THRESH ON TuxServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxSiteTest;

CREATE TABLE TuxSiteTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
SITE_STATE decimal(20,4) NOT NULL,
SITE_STATE_ST varchar(32) NOT NULL,
TRAN_ABT_RATE DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_ST varchar(32) NOT NULL,
TRAN_CMT_RATE DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_ST varchar(32) NOT NULL,
TLISTEN_STATE decimal(20,4) NOT NULL,
TLISTEN_STATE_ST varchar(32) NOT NULL,
CURR_CLTS decimal(20,4) NOT NULL,
CURR_CLTS_ST varchar(32) NOT NULL,
CUR_WS_CLTS decimal(20,4) NOT NULL,
CUR_WS_CLTS_ST varchar(32) NOT NULL,
CURR_CONV decimal(20,4) NOT NULL,
CURR_CONV_ST varchar(32) NOT NULL,
CURR_GT decimal(20,4) NOT NULL,
CURR_GT_ST varchar(32) NOT NULL,
CURR_LOAD_RATE DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_ST varchar(32) NOT NULL,
WK_COMPLETED_RATE DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_ST varchar(32) NOT NULL,
WK_INIT_RATE DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_ST varchar(32) NOT NULL,
TRAN_INIT_RATE DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_ST varchar(32) NOT NULL);

ALTER TABLE TuxSiteTest ADD constraint PK_TuxSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxSiteTest ON TuxSiteTest
(
	 MSMT_TIME
);
DROP TABLE TuxSiteTest_TREND;

CREATE TABLE TuxSiteTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
SITE_STATE_MIN decimal(20,4) NOT NULL,
SITE_STATE_MAX decimal(20,4) NOT NULL,
SITE_STATE_STCNT varchar(32) NOT NULL,
TRAN_ABT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_ABT_RATE_STCNT varchar(32) NOT NULL,
TRAN_CMT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_CMT_RATE_STCNT varchar(32) NOT NULL,
TLISTEN_STATE_MIN decimal(20,4) NOT NULL,
TLISTEN_STATE_MAX decimal(20,4) NOT NULL,
TLISTEN_STATE_STCNT varchar(32) NOT NULL,
CURR_CLTS_MIN decimal(20,4) NOT NULL,
CURR_CLTS_MAX decimal(20,4) NOT NULL,
CURR_CLTS_STCNT varchar(32) NOT NULL,
CUR_WS_CLTS_MIN decimal(20,4) NOT NULL,
CUR_WS_CLTS_MAX decimal(20,4) NOT NULL,
CUR_WS_CLTS_STCNT varchar(32) NOT NULL,
CURR_CONV_MIN decimal(20,4) NOT NULL,
CURR_CONV_MAX decimal(20,4) NOT NULL,
CURR_CONV_STCNT varchar(32) NOT NULL,
CURR_GT_MIN decimal(20,4) NOT NULL,
CURR_GT_MAX decimal(20,4) NOT NULL,
CURR_GT_STCNT varchar(32) NOT NULL,
CURR_LOAD_RATE_MIN DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_MAX DECIMAL(20,4) NOT NULL,
CURR_LOAD_RATE_STCNT varchar(32) NOT NULL,
WK_COMPLETED_RATE_MIN DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_MAX DECIMAL(20,4) NOT NULL,
WK_COMPLETED_RATE_STCNT varchar(32) NOT NULL,
WK_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
WK_INIT_RATE_STCNT varchar(32) NOT NULL,
TRAN_INIT_RATE_MIN DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_MAX DECIMAL(20,4) NOT NULL,
TRAN_INIT_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxSiteTest_TREND ADD constraint PK_TuxSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxSiteTest_THRESH;

CREATE TABLE TuxSiteTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
SITE_STATE_MIN	VARCHAR(256)	 NOT NULL,
SITE_STATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_ABT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_CMT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TLISTEN_STATE_MIN	VARCHAR(256)	 NOT NULL,
TLISTEN_STATE_MAX	VARCHAR(256)	 NOT NULL,
CURR_CLTS_MIN	VARCHAR(256)	 NOT NULL,
CURR_CLTS_MAX	VARCHAR(256)	 NOT NULL,
CUR_WS_CLTS_MIN	VARCHAR(256)	 NOT NULL,
CUR_WS_CLTS_MAX	VARCHAR(256)	 NOT NULL,
CURR_CONV_MIN	VARCHAR(256)	 NOT NULL,
CURR_CONV_MAX	VARCHAR(256)	 NOT NULL,
CURR_GT_MIN	VARCHAR(256)	 NOT NULL,
CURR_GT_MAX	VARCHAR(256)	 NOT NULL,
CURR_LOAD_RATE_MIN	VARCHAR(256)	 NOT NULL,
CURR_LOAD_RATE_MAX	VARCHAR(256)	 NOT NULL,
WK_COMPLETED_RATE_MIN	VARCHAR(256)	 NOT NULL,
WK_COMPLETED_RATE_MAX	VARCHAR(256)	 NOT NULL,
WK_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
WK_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
TRAN_INIT_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxSiteTest_THRESH ADD constraint PK_TuxSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxSiteTest_THRESH ON TuxSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TuxTQueueTest;

CREATE TABLE TuxTQueueTest ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
Q_STATE decimal(20,4) NOT NULL,
Q_STATE_ST varchar(32) NOT NULL,
SERVER_CNT decimal(20,4) NOT NULL,
SERVER_CNT_ST varchar(32) NOT NULL,
REQ_CURR_QUD decimal(20,4) NOT NULL,
REQ_CURR_QUD_ST varchar(32) NOT NULL,
WKL_CURR_QUD decimal(20,4) NOT NULL,
WKL_CURR_QUD_ST varchar(32) NOT NULL);

ALTER TABLE TuxTQueueTest ADD constraint PK_TuxTQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TuxTQueueTest ON TuxTQueueTest
(
	 MSMT_TIME
);
DROP TABLE TuxTQueueTest_TREND;

CREATE TABLE TuxTQueueTest_TREND ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
Q_STATE_MIN decimal(20,4) NOT NULL,
Q_STATE_MAX decimal(20,4) NOT NULL,
Q_STATE_STCNT varchar(32) NOT NULL,
SERVER_CNT_MIN decimal(20,4) NOT NULL,
SERVER_CNT_MAX decimal(20,4) NOT NULL,
SERVER_CNT_STCNT varchar(32) NOT NULL,
REQ_CURR_QUD_MIN decimal(20,4) NOT NULL,
REQ_CURR_QUD_MAX decimal(20,4) NOT NULL,
REQ_CURR_QUD_STCNT varchar(32) NOT NULL,
WKL_CURR_QUD_MIN decimal(20,4) NOT NULL,
WKL_CURR_QUD_MAX decimal(20,4) NOT NULL,
WKL_CURR_QUD_STCNT varchar(32) NOT NULL);

ALTER TABLE TuxTQueueTest_TREND ADD constraint PK_TuxTQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TuxTQueueTest_THRESH;

CREATE TABLE TuxTQueueTest_THRESH ( 	
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
Q_STATE_MIN	VARCHAR(256)	 NOT NULL,
Q_STATE_MAX	VARCHAR(256)	 NOT NULL,
SERVER_CNT_MIN	VARCHAR(256)	 NOT NULL,
SERVER_CNT_MAX	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
REQ_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL,
WKL_CURR_QUD_MIN	VARCHAR(256)	 NOT NULL,
WKL_CURR_QUD_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TuxTQueueTest_THRESH ADD constraint PK_TuxTQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TuxTQueueTest_THRESH ON TuxTQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQManagerTest;

CREATE TABLE MQManagerTest (
TRGT_HOST varchar(32) NOT NULL,
PORT_NO varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
AVAILABILITY decimal(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL);

ALTER TABLE MQManagerTest ADD constraint PK_MQManagerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);
CREATE  INDEX IDX_MQManagerTest ON MQManagerTest
(
	 MSMT_TIME
);
DROP TABLE MQManagerTest_TREND;

CREATE TABLE MQManagerTest_TREND (
TRGT_HOST varchar(32) NOT NULL,
PORT_NO  varchar(32) NOT NULL,
SITE_NAME varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN decimal(20,4) NOT NULL,
AVAILABILITY_MAX decimal(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE MQManagerTest_TREND ADD constraint PK_MQManagerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);

DROP TABLE MQManagerTest_THRESH;

CREATE TABLE MQManagerTest_THRESH (
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,  
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,	
MSMT_TIME_END   dateTime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQManagerTest_THRESH ADD constraint PK_MQManagerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQManagerTest_THRESH ON MQManagerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQLocalQueueTest; 

CREATE TABLE MQLocalQueueTest ( 
TRGT_HOST       varchar(32) NOT NULL, 
PORT_NO         varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL,  
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
CURRENT_QUEUE_DEPTH decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_ST varchar(32) NOT NULL,
QUEUE_FILL_PCT DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_ST varchar(32) NOT NULL);

ALTER TABLE MQLocalQueueTest ADD constraint PK_MQLocalQueueTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MQLocalQueueTest ON MQLocalQueueTest
(
	 MSMT_TIME
);
DROP TABLE MQLocalQueueTest_TREND;

CREATE TABLE MQLocalQueueTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,     
PORT_NO         varchar(32) NOT NULL,       
SITE_NAME       varchar(64) NOT NULL,  
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURRENT_QUEUE_DEPTH_MIN decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_MAX decimal(20,4) NOT NULL,
CURRENT_QUEUE_DEPTH_STCNT varchar(32) NOT NULL,
QUEUE_FILL_PCT_MIN DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_MAX DECIMAL(20,4) NOT NULL,
QUEUE_FILL_PCT_STCNT varchar(32) NOT NULL);

ALTER TABLE MQLocalQueueTest_TREND ADD constraint PK_MQLocalQueueTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQLocalQueueTest_THRESH;

CREATE TABLE MQLocalQueueTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,   
PORT_NO         varchar(32) NOT NULL, 
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,	
MSMT_TIME_END   dateTime NOT NULL,
CURRENT_QUEUE_DEPTH_MIN	VARCHAR(256)	 NOT NULL,
CURRENT_QUEUE_DEPTH_MAX	VARCHAR(256)	 NOT NULL,
QUEUE_FILL_PCT_MIN	VARCHAR(256)	 NOT NULL,
QUEUE_FILL_PCT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQLocalQueueTest_THRESH ADD constraint PK_MQLocalQueueTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQLocalQueueTest_THRESH ON MQLocalQueueTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE MQChannelTest;

CREATE TABLE MQChannelTest ( 
TRGT_HOST       varchar(32) NOT NULL, 
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,       
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
KBYTES_RECD_RATE decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_ST varchar(32) NOT NULL,
KBYTES_SENT_RATE decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_ST varchar(32) NOT NULL,
BUFFERS_RECD_RATE decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_ST varchar(32) NOT NULL,
BUFFERS_SENT_RATE decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_ST varchar(32) NOT NULL,
AVAILABILITY decimal(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL);

ALTER TABLE MQChannelTest ADD constraint PK_MQChannelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MQChannelTest ON MQChannelTest
(
	 MSMT_TIME
);
DROP TABLE MQChannelTest_TREND;

CREATE TABLE MQChannelTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       dateTime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
KBYTES_RECD_RATE_MIN decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_MAX decimal(20,4) NOT NULL,
KBYTES_RECD_RATE_STCNT varchar(32) NOT NULL,
KBYTES_SENT_RATE_MIN decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_MAX decimal(20,4) NOT NULL,
KBYTES_SENT_RATE_STCNT varchar(32) NOT NULL,
BUFFERS_RECD_RATE_MIN decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_MAX decimal(20,4) NOT NULL,
BUFFERS_RECD_RATE_STCNT varchar(32) NOT NULL,
BUFFERS_SENT_RATE_MIN decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_MAX decimal(20,4) NOT NULL,
BUFFERS_SENT_RATE_STCNT varchar(32) NOT NULL,
AVAILABILITY_MIN decimal(20,4) NOT NULL,
AVAILABILITY_MAX decimal(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE MQChannelTest_TREND ADD constraint PK_MQChannelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MQChannelTest_THRESH;

CREATE TABLE MQChannelTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START dateTime NOT NULL,
MSMT_TIME_END   dateTime NOT NULL,
KBYTES_RECD_RATE_MIN	VARCHAR(256)	 NOT NULL,
KBYTES_RECD_RATE_MAX	VARCHAR(256)	 NOT NULL,
KBYTES_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
KBYTES_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
BUFFERS_RECD_RATE_MIN	VARCHAR(256)	 NOT NULL,
BUFFERS_RECD_RATE_MAX	VARCHAR(256)	 NOT NULL,
BUFFERS_SENT_RATE_MIN	VARCHAR(256)	 NOT NULL,
BUFFERS_SENT_RATE_MAX	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MQChannelTest_THRESH ADD constraint PK_MQChannelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_MQChannelTest_THRESH ON MQChannelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpPerfTest;

CREATE TABLE DhcpPerfTest ( 
TRGT_HOST       		varchar(32) NOT NULL, 
PORT_NO         		varchar(32) NOT NULL,     
SITE_NAME       		varchar(64) NOT NULL,       
INFO            		varchar(128) NOT NULL,	
MSMT_HOST       		varchar(32) NOT NULL,	
MSMT_TIME       		datetime NOT NULL,
AVG_PKTS_RATE			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_ST		varchar(32) NOT NULL,
CURR_MSG_QUEUE_LEN 		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_ST 	Varchar(32) NOT NULL,
REQ_RATE 				DECIMAL(20,4) NOT NULL,
REQ_RATE_ST				varchar(32) NOT NULL,
REQ_ACKS_RATE			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_ST 		varchar(32) NOT NULL,
REQ_NACKS_RATE 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_ST 		varchar(32) NOT NULL,
REQ_DECLINES_RATE 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_ST	varchar(32) NOT NULL,
PKTS_EXPD_RATE 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_ST 		varchar(32) NOT NULL,
PKTS_DROPPED_RATE 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_ST 	varchar(32) NOT NULL,
REQ_RELEASE_RATE 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_ST 	varchar(32) NOT NULL);

ALTER TABLE DhcpPerfTest ADD constraint PK_DhcpPerfTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DhcpPerfTest ON DhcpPerfTest
(
	 MSMT_TIME
);
DROP TABLE DhcpPerfTest_TREND;

CREATE TABLE DhcpPerfTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVG_PKTS_RATE_MIN			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_MAX			DECIMAL(20,4) NOT NULL,
AVG_PKTS_RATE_STCNT			varchar(32) NOT NULL,
CURR_MSG_QUEUE_LEN_MIN		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_MAX		DECIMAL(20,4) NOT NULL,
CURR_MSG_QUEUE_LEN_STCNT 	Varchar(32) NOT NULL,
REQ_RATE_MIN 				DECIMAL(20,4) NOT NULL,
REQ_RATE_MAX 				DECIMAL(20,4) NOT NULL,
REQ_RATE_STCNT				varchar(32) NOT NULL,
REQ_ACKS_RATE_MIN			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_MAX			DECIMAL(20,4) NOT NULL,
REQ_ACKS_RATE_STCNT 		varchar(32) NOT NULL,
REQ_NACKS_RATE_MIN 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_MAX 			DECIMAL(20,4) NOT NULL,
REQ_NACKS_RATE_STCNT 		varchar(32) NOT NULL,
REQ_DECLINES_RATE_MIN 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_MAX 		DECIMAL(20,4) NOT NULL,
REQ_DECLINES_RATE_STCNT		varchar(32) NOT NULL,
PKTS_EXPD_RATE_MIN 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_MAX 			DECIMAL(20,4) NOT NULL,
PKTS_EXPD_RATE_STCNT 		varchar(32) NOT NULL,
PKTS_DROPPED_RATE_MIN 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_MAX 		DECIMAL(20,4) NOT NULL,
PKTS_DROPPED_RATE_STCNT 	varchar(32) NOT NULL,
REQ_RELEASE_RATE_MIN 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_MAX 		DECIMAL(20,4) NOT NULL,
REQ_RELEASE_RATE_STCNT	 	varchar(32) NOT NULL);

ALTER TABLE DhcpPerfTest_TREND ADD constraint PK_DhcpPerfTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpPerfTest_THRESH;

CREATE TABLE DhcpPerfTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVG_PKTS_RATE_MIN	VARCHAR(256)	 NOT NULL,
AVG_PKTS_RATE_MAX	VARCHAR(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MIN	VARCHAR(256)	 NOT NULL,
CURR_MSG_QUEUE_LEN_MAX	VARCHAR(256)	 NOT NULL,
REQ_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_ACKS_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_ACKS_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_NACKS_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_NACKS_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_DECLINES_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_DECLINES_RATE_MAX	VARCHAR(256)	 NOT NULL,
PKTS_EXPD_RATE_MIN	VARCHAR(256)	 NOT NULL,
PKTS_EXPD_RATE_MAX	VARCHAR(256)	 NOT NULL,
PKTS_DROPPED_RATE_MIN	VARCHAR(256)	 NOT NULL,
PKTS_DROPPED_RATE_MAX	VARCHAR(256)	 NOT NULL,
REQ_RELEASE_RATE_MIN	VARCHAR(256)	 NOT NULL,
REQ_RELEASE_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE DhcpPerfTest_THRESH ADD constraint PK_DhcpPerfTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpPerfTest_THRESH ON DhcpPerfTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE DhcpUtilTest;

CREATE TABLE DhcpUtilTest ( 
TRGT_HOST       		varchar(32) NOT NULL, 
PORT_NO         		varchar(32) NOT NULL,     
SITE_NAME       		varchar(64) NOT NULL,       
INFO            		varchar(128) NOT NULL,	
MSMT_HOST       		varchar(32) NOT NULL,	
MSMT_TIME       		datetime NOT NULL,
CURR_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
FREE_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT		decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_ST	VARCHAR(32) NOT NULL,
USAGE		decimal(20,4) NOT NULL,
USAGE_ST	VARCHAR(32) NOT NULL);

ALTER TABLE DhcpUtilTest ADD constraint PK_DhcpUtilTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_DhcpUtilTest ON DhcpUtilTest
(
	 MSMT_TIME
);
DROP TABLE DhcpUtilTest_TREND;

CREATE TABLE DhcpUtilTest_TREND ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,   
SITE_NAME       varchar(64) NOT NULL, 
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURR_ADDR_USAGE_CNT_MIN		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_MAX		decimal(20,4) NOT NULL,
CURR_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
FREE_ADDR_USAGE_CNT_MIN		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_MAX		decimal(20,4) NOT NULL,
FREE_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN	decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX	decimal(20,4) NOT NULL,
TOTAL_ADDR_USAGE_CNT_STCNT	VARCHAR(32) NOT NULL,
USAGE_MIN			decimal(20,4) NOT NULL,
USAGE_MAX			decimal(20,4) NOT NULL,
USAGE_STCNT			VARCHAR(32) NOT NULL);
ALTER TABLE DhcpUtilTest_TREND ADD constraint PK_DhcpUtilTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE DhcpUtilTest_THRESH;

CREATE TABLE DhcpUtilTest_THRESH ( 
TRGT_HOST       varchar(32) NOT NULL,    
PORT_NO         varchar(32) NOT NULL,     
SITE_NAME       varchar(64) NOT NULL,      
INFO            varchar(128) NOT NULL,	
MSMT_HOST       varchar(32) NOT NULL,	
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURR_ADDR_USAGE_CNT_MIN	VARCHAR(256)	 NOT NULL,
CURR_ADDR_USAGE_CNT_MAX	VARCHAR(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MIN	VARCHAR(256)	 NOT NULL,
FREE_ADDR_USAGE_CNT_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MIN VARCHAR(256)	 NOT NULL,
TOTAL_ADDR_USAGE_CNT_MAX VARCHAR(256)	 NOT NULL,
USAGE_MIN		VARCHAR(256)	 NOT NULL,
USAGE_MAX		VARCHAR(256)	 NOT NULL);


ALTER TABLE DhcpUtilTest_THRESH ADD constraint PK_DhcpUtilTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_DhcpUtilTest_THRESH ON DhcpUtilTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WLThreadTest;

CREATE TABLE WLThreadTest 
(
	TRGT_HOST       		varchar(32) NOT NULL, 
	PORT_NO         		varchar(32) NOT NULL, 
	SITE_NAME       		varchar(64) NOT NULL,  
	INFO            		varchar(128) NOT NULL,  
	MSMT_HOST       		varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	IDLE_THREADS    		decimal(20,4) NOT NULL,
	IDLE_THREADS_ST 		varchar(32) NOT NULL,
	PCT_THREAD_UTILIZATION  	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_ST 	varchar(32) NOT NULL,
	PENDING_REQUESTS 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_ST 		varchar(32) NOT NULL,
	REQUEST_RATE			decimal(20,4) NOT NULL,
	REQUEST_RATE_ST 		varchar(32) NOT NULL
);

ALTER TABLE WLThreadTest ADD constraint PK_WLThreadTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WLThreadTest ON WLThreadTest
(
	 MSMT_TIME
);
DROP TABLE WLThreadTest_TREND;

CREATE TABLE WLThreadTest_TREND 
(
	TRGT_HOST      			varchar(32) NOT NULL, 
	PORT_NO    		        varchar(32) NOT NULL,
	SITE_NAME    			varchar(64) NOT NULL,
	INFO				varchar(128) NOT NULL, 
	MSMT_HOST   			varchar(32) NOT NULL, 
	MSMT_TIME    			datetime NOT NULL,
	PERIOD      		        varchar(32) NOT NULL,
	IDLE_THREADS_MIN 		decimal(20,4) NOT NULL,
	IDLE_THREADS_MAX 		decimal(20,4) NOT NULL,
	IDLE_THREADS_STCNT 		varchar(32) NOT NULL,
	PCT_THREAD_UTILIZATION_MIN 	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_MAX 	decimal(20,4) NOT NULL,
	PCT_THREAD_UTILIZATION_STCNT    varchar(32) NOT NULL,
	PENDING_REQUESTS_MIN 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_MAX 		decimal(20,4) NOT NULL,
	PENDING_REQUESTS_STCNT 		varchar(32) NOT NULL,
	REQUEST_RATE_MIN 		decimal(20,4) NOT NULL,
	REQUEST_RATE_MAX 		decimal(20,4) NOT NULL,
	REQUEST_RATE_STCNT 		varchar(32) NOT NULL
);

ALTER TABLE WLThreadTest_TREND ADD constraint PK_WLThreadTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WLThreadTest_THRESH;

CREATE TABLE WLThreadTest_THRESH
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO			        varchar(32) NOT NULL,
	SITE_NAME    			varchar(64) NOT NULL,
	INFO			        varchar(128) NOT NULL,      
	MSMT_HOST		        varchar(32) NOT NULL,   
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END  			datetime NOT NULL,
	IDLE_THREADS_MIN	VARCHAR(256)	 NOT NULL,
	IDLE_THREADS_MAX	VARCHAR(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MIN	VARCHAR(256)	 NOT NULL,
	PCT_THREAD_UTILIZATION_MAX	VARCHAR(256)	 NOT NULL,
	PENDING_REQUESTS_MIN	VARCHAR(256)	 NOT NULL,
	PENDING_REQUESTS_MAX	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MIN	VARCHAR(256)	 NOT NULL,
	REQUEST_RATE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE WLThreadTest_THRESH ADD constraint PK_WLThreadTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WLThreadTest_THRESH ON WLThreadTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);


DROP TABLE WLClusterTest;

CREATE TABLE WLClusterTest
(
		TRGT_HOST       			varchar(32)		NOT NULL,
		PORT_NO         			varchar(32)		NOT NULL,
		SITE_NAME       			varchar(64)		NOT NULL,
		INFO            			varchar(128)	NOT NULL,
		MSMT_HOST       			varchar(32)		NOT NULL,
		MSMT_TIME       			datetime		NOT NULL,
		ALIVE_SERVERS_COUNT 		decimal(20,4) 	NOT NULL,
		ALIVE_SERVERS_COUNT_ST 		varchar(32) 	NOT NULL,
		FRAGMENTS_SENT_RT 			Decimal(20,4)	NOT NULL,
		FRAGMENTS_SENT_RT_ST 		varchar(32) 	NOT NULL,
		FRAGMENTS_RECEIVED_RT 		Decimal(20,4)	NOT NULL,
		FRAGMENTS_RECEIVED_RT_ST 	varchar(32) 	NOT NULL,
		FRAGMENTS_DROPPED_RT 		Decimal(20,4)	NOT NULL,
		FRAGMENTS_DROPPED_RT_ST 	varchar(32) 	NOT NULL,
		MSGS_LOST_RT 				Decimal(20,4) 	NOT NULL,
		MSGS_LOST_RT_ST 			varchar(32) 	NOT NULL,
		RESEND_REQUESTS_RT 			Decimal(20,4) 	NOT NULL,
		RESEND_REQUESTS_RT_ST 		varchar(32) 	NOT NULL,
		PRIMARY_COUNT 				decimal(20,4) 	NOT NULL,
		PRIMARY_COUNT_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE WLClusterTest ADD constraint PK_WLClusterTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLClusterTest ON WLClusterTest
(
	 MSMT_TIME
);
DROP TABLE WLClusterTest_TREND ;

CREATE TABLE WLClusterTest_TREND
(
	TRGT_HOST       			varchar(32) 	NOT NULL,
	PORT_NO         			varchar(32) 	NOT NULL,
	SITE_NAME       			varchar(64) 	NOT NULL,
	INFO            			varchar(128) 	NOT NULL,
	MSMT_HOST       			varchar(32) 	NOT NULL,
	MSMT_TIME       			datetime 		NOT NULL,
	PERIOD       				varchar(32) 	NOT NULL,
	ALIVE_SERVERS_COUNT_MIN 	decimal(20,4) 	NOT NULL,
	ALIVE_SERVERS_COUNT_MAX 	decimal(20,4) 	NOT NULL,
	ALIVE_SERVERS_COUNT_STCNT 	varchar(32)		NOT NULL,
	FRAGMENTS_SENT_RT_MIN 		Decimal(20,4)	NOT NULL,
	FRAGMENTS_SENT_RT_MAX 		Decimal(20,4) 	NOT NULL,
	FRAGMENTS_SENT_RT_STCNT 	varchar(32) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_RECEIVED_RT_STCNT varchar(32) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX 	Decimal(20,4) 	NOT NULL,
	FRAGMENTS_DROPPED_RT_STCNT 	varchar(32) 	NOT NULL,
	MSGS_LOST_RT_MIN 			Decimal(20,4) 	NOT NULL,
	MSGS_LOST_RT_MAX 			Decimal(20,4) 	NOT NULL,
	MSGS_LOST_RT_STCNT 			varchar(32) 	NOT NULL,
	RESEND_REQUESTS_RT_MIN 		Decimal(20,4) 	NOT NULL,
	RESEND_REQUESTS_RT_MAX 		Decimal(20,4) 	NOT NULL,
	RESEND_REQUESTS_RT_STCNT 	varchar(32) 	NOT NULL,
	PRIMARY_COUNT_MIN 			decimal(20,4) 	NOT NULL,
	PRIMARY_COUNT_MAX 			decimal(20,4) 	NOT NULL,
	PRIMARY_COUNT_STCNT 		varchar(32) 	NOT NULL
);

ALTER TABLE WLClusterTest_TREND ADD constraint PK_WLClusterTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLClusterTest_THRESH ;

CREATE TABLE WLClusterTest_THRESH
(
	TRGT_HOST       varchar(32)				  NOT NULL,
	PORT_NO         varchar(32)				  NOT NULL,
	SITE_NAME       varchar(64)				  NOT NULL,
	INFO            varchar(128)			  NOT NULL,
	MSMT_HOST       varchar(32)				  NOT NULL,
	MSMT_TIME_START datetime				  NOT NULL,
	MSMT_TIME_END   datetime				  NOT NULL,
	ALIVE_SERVERS_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	ALIVE_SERVERS_COUNT_MAX	VARCHAR(256)		  NOT NULL,
	FRAGMENTS_SENT_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_SENT_RT_MAX	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MIN	VARCHAR(256)	 NOT NULL,
	FRAGMENTS_DROPPED_RT_MAX	VARCHAR(256)	 NOT NULL,
	MSGS_LOST_RT_MIN	VARCHAR(256)	 NOT NULL,
	MSGS_LOST_RT_MAX	VARCHAR(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MIN	VARCHAR(256)	 NOT NULL,
	RESEND_REQUESTS_RT_MAX	VARCHAR(256)	 NOT NULL,
	PRIMARY_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	PRIMARY_COUNT_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLClusterTest_THRESH ADD constraint PK_WLClusterTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLClusterTest_THRESH ON WLClusterTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);


DROP TABLE WLConnectorTest;

CREATE TABLE WLConnectorTest
(
	TRGT_HOST       			varchar(32)   	NOT NULL,
	PORT_NO         			varchar(32)   	NOT NULL,
	SITE_NAME       			varchar(64)   	NOT NULL,
	INFO            			varchar(128)  	NOT NULL,
	MSMT_HOST      				varchar(32)	  	NOT NULL,
	MSMT_TIME       			datetime	  	NOT NULL,
	TOTAL_CONNS_CREATED_RT 		Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_CREATED_RT_ST 	varchar(32)		NOT NULL,
	TOTAL_CONNS_DESTROYED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_ST varchar(32) 	NOT NULL,
	TOTAL_CONNS_MATCHED_RT 		Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_MATCHED_RT_ST 	varchar(32) 	NOT NULL,
	TOTAL_CONNS_REJECTED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_REJECTED_RT_ST 	varchar(32) 	NOT NULL,
	TOTAL_CONNS_RECYCLED_RT 	Decimal(20,4) 	NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_ST 	varchar(32) 	NOT NULL,
	CURRENT_ACTIVE_CONNS 		decimal(20,4) 	NOT NULL,
	CURRENT_ACTIVE_CONNS_ST 	varchar(32) 	NOT NULL,
	ACTIVE_CONNS_HWM 			decimal(20,4) 	NOT NULL,
	ACTIVE_CONNS_HWM_ST 		varchar(32) 	NOT NULL,
	CURRENT_FREE_CONNS 			decimal(20,4) 	NOT NULL,
	CURRENT_FREE_CONNS_ST 		varchar(32) 	NOT NULL,
	FREE_CONNS_HWM 				decimal(20,4) 	NOT NULL,
	FREE_CONNS_HWM_ST 			varchar(32) 	NOT NULL,
	MAX_CAPACITY 				decimal(20,4) 	NOT NULL,
	MAX_CAPACITY_ST 			varchar(32) 	NOT NULL
);

ALTER TABLE WLConnectorTest ADD constraint PK_WLConnectorTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLConnectorTest ON WLConnectorTest
(
	 MSMT_TIME
);
DROP TABLE WLConnectorTest_TREND ;

CREATE TABLE WLConnectorTest_TREND
(
	TRGT_HOST       				varchar(32)   NOT NULL,
	PORT_NO         				varchar(32)   NOT NULL,
	SITE_NAME      					varchar(64)   NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	TOTAL_CONNS_CREATED_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_CREATED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_CONNS_MATCHED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_REJECTED_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX 	Decimal(20,4) NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_STCNT 	varchar(32)   NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN 		decimal(20,4)   NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX 		decimal(20,4)   NOT NULL,
	CURRENT_ACTIVE_CONNS_STCNT 		varchar(32)   NOT NULL,
	ACTIVE_CONNS_HWM_MIN 			decimal(20,4)   NOT NULL,
	ACTIVE_CONNS_HWM_MAX 			decimal(20,4)   NOT NULL,
	ACTIVE_CONNS_HWM_STCNT 			varchar(32)   NOT NULL,
	CURRENT_FREE_CONNS_MIN 			decimal(20,4)   NOT NULL,
	CURRENT_FREE_CONNS_MAX 			decimal(20,4)   NOT NULL,
	CURRENT_FREE_CONNS_STCNT 		varchar(32)   NOT NULL,
	FREE_CONNS_HWM_MIN 				decimal(20,4)   NOT NULL,
	FREE_CONNS_HWM_MAX 				decimal(20,4)   NOT NULL,
	FREE_CONNS_HWM_STCNT 			varchar(32)   NOT NULL,
	MAX_CAPACITY_MIN 				decimal(20,4)   NOT NULL,
	MAX_CAPACITY_MAX 				decimal(20,4)   NOT NULL,
	MAX_CAPACITY_STCNT 				varchar(32)   NOT NULL
);

ALTER TABLE WLConnectorTest_TREND ADD constraint PK_WLConnectorTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLConnectorTest_THRESH ;

CREATE TABLE WLConnectorTest_THRESH
(
	TRGT_HOST       varchar(32)				   NOT NULL,
	PORT_NO         varchar(32)				   NOT NULL,
	SITE_NAME       varchar(64)				   NOT NULL,
	INFO            varchar(128)			   NOT NULL,
	MSMT_HOST       varchar(32)				   NOT NULL,
	MSMT_TIME_START datetime				   NOT NULL,
	MSMT_TIME_END   datetime				   NOT NULL,
	TOTAL_CONNS_CREATED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_CREATED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_DESTROYED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_MATCHED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_REJECTED_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_CONNS_RECYCLED_RT_MAX	VARCHAR(256)	 NOT NULL,
	CURRENT_ACTIVE_CONNS_MIN	VARCHAR(256)	   NOT NULL,
	CURRENT_ACTIVE_CONNS_MAX	VARCHAR(256)	   NOT NULL,
	ACTIVE_CONNS_HWM_MIN	VARCHAR(256)	   NOT NULL,
	ACTIVE_CONNS_HWM_MAX	VARCHAR(256)	   NOT NULL,
	CURRENT_FREE_CONNS_MIN	VARCHAR(256)	   NOT NULL,
	CURRENT_FREE_CONNS_MAX	VARCHAR(256)	   NOT NULL,
	FREE_CONNS_HWM_MIN	VARCHAR(256)	   NOT NULL,
	FREE_CONNS_HWM_MAX	VARCHAR(256)	   NOT NULL,
	MAX_CAPACITY_MIN	VARCHAR(256)	   NOT NULL,
	MAX_CAPACITY_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLConnectorTest_THRESH ADD constraint PK_WLConnectorTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLConnectorTest_THRESH ON WLConnectorTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLJMSTest;

CREATE TABLE WLJMSTest
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST      				varchar(32)	  NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	BYTES_RECEIVED_RT 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_ST 		varchar(32)	  NOT NULL,
	MSGS_RECEIVED_RT 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_ST 		varchar(32)   NOT NULL,
	BYTES_CURRENT_COUNT 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	BYTES_PENDING_COUNT 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_ST 		varchar(32)   NOT NULL,
	BYTES_COUNT_HWM 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	MSGS_CURRENT_COUNT 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	MSGS_PENDING_COUNT 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_ST 		varchar(32)   NOT NULL,
	MSGS_COUNT_HWM 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	DEST_CURRENT_COUNT 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_ST 		varchar(32)   NOT NULL,
	DEST_COUNT_HWM 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_ST 			varchar(32)   NOT NULL,
	SESS_POOL_CURRENT_COUNT 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_ST 	varchar(32)   NOT NULL,
	SESSION_POOL_HWM 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_ST 		varchar(32)   NOT NULL
);

ALTER TABLE WLJMSTest ADD constraint PK_WLJMSTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLJMSTest ON WLJMSTest
(
	 MSMT_TIME
);
DROP TABLE WLJMSTest_TREND ;

CREATE TABLE WLJMSTest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	BYTES_RECEIVED_RT_MIN 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_MAX 			Decimal(20,4) NOT NULL,
	BYTES_RECEIVED_RT_STCNT 		varchar(32)   NOT NULL,
	MSGS_RECEIVED_RT_MIN 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_MAX 			Decimal(20,4) NOT NULL,
	MSGS_RECEIVED_RT_STCNT 			varchar(32)   NOT NULL,
	BYTES_CURRENT_COUNT_MIN 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_MAX 		decimal(20,4)   NOT NULL,
	BYTES_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	BYTES_PENDING_COUNT_MIN 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_MAX 		decimal(20,4)   NOT NULL,
	BYTES_PENDING_COUNT_STCNT 		varchar(32)   NOT NULL,
	BYTES_COUNT_HWM_MIN 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_MAX 			decimal(20,4)   NOT NULL,
	BYTES_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	MSGS_CURRENT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_MAX 			decimal(20,4)   NOT NULL,
	MSGS_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	MSGS_PENDING_COUNT_MIN 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_MAX 			decimal(20,4)   NOT NULL,
	MSGS_PENDING_COUNT_STCNT 		varchar(32)   NOT NULL,
	MSGS_COUNT_HWM_MIN 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_MAX 				decimal(20,4)   NOT NULL,
	MSGS_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	DEST_CURRENT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_MAX 			decimal(20,4)   NOT NULL,
	DEST_CURRENT_COUNT_STCNT 		varchar(32)   NOT NULL,
	DEST_COUNT_HWM_MIN 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_MAX 				decimal(20,4)   NOT NULL,
	DEST_COUNT_HWM_STCNT 			varchar(32)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX 	decimal(20,4)   NOT NULL,
	SESS_POOL_CURRENT_COUNT_STCNT 	varchar(32)   NOT NULL,
	SESSION_POOL_HWM_MIN 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_MAX 			decimal(20,4)   NOT NULL,
	SESSION_POOL_HWM_STCNT 			varchar(32)   NOT NULL
);

ALTER TABLE WLJMSTest_TREND ADD constraint PK_WLJMSTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLJMSTest_THRESH ;

CREATE TABLE WLJMSTest_THRESH
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)	  NOT NULL,
	MSMT_TIME_START 			datetime	  NOT NULL,
	MSMT_TIME_END   			datetime	  NOT NULL,
	BYTES_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	BYTES_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MIN	VARCHAR(256)	 NOT NULL,
	MSGS_RECEIVED_RT_MAX	VARCHAR(256)	 NOT NULL,
	BYTES_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	BYTES_PENDING_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_PENDING_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	BYTES_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	BYTES_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_PENDING_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_PENDING_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	MSGS_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	MSGS_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	DEST_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	DEST_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	DEST_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	DEST_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	SESS_POOL_CURRENT_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	SESSION_POOL_HWM_MIN	VARCHAR(256)	   NOT NULL,
	SESSION_POOL_HWM_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLJMSTest_THRESH ADD constraint PK_WLJMSTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJMSTest_THRESH ON WLJMSTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLJTATest;

CREATE TABLE WLJTATest
(
	TRGT_HOST       			varchar(32)	  NOT NULL,
	PORT_NO         			varchar(32)	  NOT NULL,
	SITE_NAME       			varchar(64)	  NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)	  NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	TOTAL_ACTIVE_TX 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_ST 			varchar(32)   NOT NULL,
	ABANDONED_TX_RT 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_ST 			varchar(32)   NOT NULL,
	APP_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_ST varchar(32)   NOT NULL,
	SYS_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_ST varchar(32)   NOT NULL,
	COMMITTED_TX_RT 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_ST 			varchar(32)   NOT NULL,
	HEURISTICS_TX_RT 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_ST 		varchar(32)   NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_ST 	varchar(32)   NOT NULL,
	TOTAL_TX_RT 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_ST 				varchar(32)   NOT NULL
);

ALTER TABLE WLJTATest ADD constraint PK_WLJTATest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLJTATest ON WLJTATest
(
	 MSMT_TIME
);
DROP TABLE WLJTATest_TREND;

CREATE TABLE WLJTATest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	TOTAL_ACTIVE_TX_MIN 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_MAX 			decimal(20,4)   NOT NULL,
	TOTAL_ACTIVE_TX_STCNT 			varchar(32)   NOT NULL,
	ABANDONED_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	ABANDONED_TX_RT_STCNT 			varchar(32)   NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	APP_ROLLEDBACK_TX_RT_STCNT 		varchar(32)   NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX 	Decimal(20,4) NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	SYS_ROLLEDBACK_TX_RT_STCNT 		varchar(32)   NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX 	Decimal(20,4) NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	COMMITTED_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	COMMITTED_TX_RT_STCNT 			varchar(32)   NOT NULL,
	HEURISTICS_TX_RT_MIN 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_MAX 			Decimal(20,4) NOT NULL,
	HEURISTICS_TX_RT_STCNT 			varchar(32)   NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX 		Decimal(20,4) NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_STCNT 	varchar(32)   NOT NULL,
	TOTAL_TX_RT_MIN 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_MAX 				Decimal(20,4) NOT NULL,
	TOTAL_TX_RT_STCNT 				varchar(32)   NOT NULL
);

ALTER TABLE WLJTATest_TREND ADD constraint PK_WLJTATest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLJTATest_THRESH;

CREATE TABLE WLJTATest_THRESH
(
	TRGT_HOST      				 varchar(32)   NOT NULL,
	PORT_NO         			 varchar(32)   NOT NULL,
	SITE_NAME       		 	 varchar(64)   NOT NULL,
	INFO            			 varchar(128)  NOT NULL,
	MSMT_HOST       			 varchar(32)   NOT NULL,
	MSMT_TIME_START 			 datetime	   NOT NULL,
	MSMT_TIME_END   			 datetime	   NOT NULL,
	TOTAL_ACTIVE_TX_MIN	VARCHAR(256)	   NOT NULL,
	TOTAL_ACTIVE_TX_MAX	VARCHAR(256)	   NOT NULL,
	ABANDONED_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	ABANDONED_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	APP_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	RESOURC_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	SYS_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TIMEOUT_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	COMMITTED_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	COMMITTED_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	HEURISTICS_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	HEURISTICS_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_ROLLEDBACK_TX_RT_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_TX_RT_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_TX_RT_MAX	VARCHAR(256)	 NOT NULL
); 

ALTER TABLE WLJTATest_THRESH ADD constraint PK_WLJTATest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLJTATest_THRESH ON WLJTATest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE WLSecurityTest ;

CREATE TABLE WLSecurityTest
(
	TRGT_HOST       			varchar(32)   NOT NULL,
	PORT_NO         			varchar(32)   NOT NULL,
	SITE_NAME       			varchar(64)   NOT NULL,
	INFO            			varchar(128)  NOT NULL,
	MSMT_HOST       			varchar(32)   NOT NULL,
	MSMT_TIME       			datetime	  NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_ST varchar(32)   NOT NULL,
	INVALID_USERS_COUNT_HWM 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_ST 	varchar(32)   NOT NULL,
	CURR_LOCKED_USERS_COUNT 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_ST 	varchar(32)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_ST varchar(32)   NOT NULL,
	TOTAL_UNLOCKED_USERS 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_ST 	varchar(32)   NOT NULL,
	USER_LOCKOUT_COUNT 			decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_ST 		varchar(32)   NOT NULL
);

ALTER TABLE WLSecurityTest ADD constraint PK_WLSecurityTest 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME);
CREATE  INDEX IDX_WLSecurityTest ON WLSecurityTest
(
	 MSMT_TIME
);
DROP TABLE WLSecurityTest_TREND ;

CREATE TABLE WLSecurityTest_TREND
(
	TRGT_HOST       				varchar(32)	  NOT NULL,
	PORT_NO         				varchar(32)	  NOT NULL,
	SITE_NAME       				varchar(64)	  NOT NULL,
	INFO            				varchar(128)  NOT NULL,
	MSMT_HOST       				varchar(32)	  NOT NULL,
	MSMT_TIME       				datetime	  NOT NULL,
	PERIOD       					varchar(32)	  NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MIN 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX 	Decimal(20,4) NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_STCNT 	varchar(32)	  NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX 	decimal(20,4)   NOT NULL,
	INVALID_USERS_COUNT_HWM_STCNT 	varchar(32)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX 	decimal(20,4)   NOT NULL,
	CURR_LOCKED_USERS_COUNT_STCNT 	varchar(32)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX 	decimal(20,4)   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_STCNT 	varchar(32)   NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX 		decimal(20,4)   NOT NULL,
	TOTAL_UNLOCKED_USERS_STCNT 		varchar(32)   NOT NULL,
	USER_LOCKOUT_COUNT_MIN 			decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_MAX		 	decimal(20,4)   NOT NULL,
	USER_LOCKOUT_COUNT_STCNT 		varchar(32)   NOT NULL
);

ALTER TABLE WLSecurityTest_TREND ADD constraint PK_WLSecurityTest_TREND 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST, 
			MSMT_TIME,PERIOD);

DROP TABLE WLSecurityTest_THRESH ;

CREATE TABLE WLSecurityTest_THRESH
(
	TRGT_HOST       			 varchar(32)   NOT NULL,
	PORT_NO         			 varchar(32)   NOT NULL,
	SITE_NAME       			 varchar(64)   NOT NULL,
	INFO            			 varchar(128)  NOT NULL,
	MSMT_HOST       			 varchar(32)   NOT NULL,
	MSMT_TIME_START 			 datetime	   NOT NULL,
	MSMT_TIME_END   			 datetime	   NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MIN	VARCHAR(256)	 NOT NULL,
	INVALID_LOGIN_ATTEMPT_RT_MAX	VARCHAR(256)	 NOT NULL,
	INVALID_USERS_COUNT_HWM_MIN	VARCHAR(256)	   NOT NULL,
	INVALID_USERS_COUNT_HWM_MAX	VARCHAR(256)	   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	CURR_LOCKED_USERS_COUNT_MAX	VARCHAR(256)	   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MIN	VARCHAR(256)	   NOT NULL,
	LOGIN_ATTEMPTS_WHILE_LKD_MAX	VARCHAR(256)	   NOT NULL,
	TOTAL_UNLOCKED_USERS_MIN	VARCHAR(256)	   NOT NULL,
	TOTAL_UNLOCKED_USERS_MAX	VARCHAR(256)	   NOT NULL,
	USER_LOCKOUT_COUNT_MIN	VARCHAR(256)	   NOT NULL,
	USER_LOCKOUT_COUNT_MAX	VARCHAR(256)	   NOT NULL
);

ALTER TABLE WLSecurityTest_THRESH ADD constraint PK_WLSecurityTest_THRESH 
PRIMARY KEY(TRGT_HOST,
			PORT_NO,
			SITE_NAME,
			INFO,
			MSMT_HOST,
			MSMT_TIME_START);

CREATE INDEX IDX_WLSecurityTest_THRESH ON WLSecurityTest_THRESH 
(
	MSMT_HOST,
	MSMT_TIME_START,
	MSMT_TIME_END
);

DROP TABLE TcpPortTest;

CREATE TABLE TcpPortTest
( 
	TRGT_HOST      		 varchar(32) NOT NULL,
    PORT_NO        		 varchar(32) NOT NULL,
    SITE_NAME      		 varchar(64) NOT NULL,
    INFO           		 varchar(128) NOT NULL,
	MSMT_HOST      		 varchar(32) NOT NULL,
	MSMT_TIME      		 datetime NOT NULL,
	SYN_SENT			 decimal(20,4) NOT NULL,
	SYN_SENT_ST 	 	 varchar(32) NOT NULL,
	SYN_RECEIVED 		 decimal(20,4) NOT NULL,
	SYN_RECEIVED_ST 	 varchar(32) NOT NULL,
	ESTABLISHED 		 decimal(20,4) NOT NULL,
	ESTABLISHED_ST 		 varchar(32) NOT NULL,
	CLOSE_WAIT 			 decimal(20,4) NOT NULL,
	CLOSE_WAIT_ST 		 varchar(32) NOT NULL,
	FIN_WAIT_1 			 decimal(20,4) NOT NULL,
	FIN_WAIT_1_ST 		 varchar(32) NOT NULL,
	FIN_WAIT_2			 decimal(20,4) NOT NULL,
	FIN_WAIT_2_ST 		 varchar(32) NOT NULL,
	TIME_WAIT 			 decimal(20,4) NOT NULL,
	TIME_WAIT_ST 		 varchar(32) NOT NULL,
	SEND_QUEUE 			 decimal(20,4) NOT NULL,
	SEND_QUEUE_ST 		 varchar(32) NOT NULL,
	RECEIVE_QUEUE 		 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_ST 	 varchar(32) NOT NULL
);

ALTER TABLE TcpPortTest ADD constraint PK_TcpPortTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TcpPortTest ON TcpPortTest
(
	 MSMT_TIME
);
DROP TABLE TcpPortTest_TREND;

CREATE TABLE TcpPortTest_TREND
( 
	TRGT_HOST      		 varchar(32) NOT NULL,
    PORT_NO         	 varchar(32) NOT NULL,
    SITE_NAME      		 varchar(64) NOT NULL, 
    INFO        		 varchar(128) NOT NULL,
	MSMT_HOST     		 varchar(32) NOT NULL,
	MSMT_TIME      		 datetime NOT NULL,
	PERIOD       	     varchar(32) NOT NULL,
	SYN_SENT_MIN   		 decimal(20,4) NOT NULL,
	SYN_SENT_MAX 		 decimal(20,4) NOT NULL,
	SYN_SENT_STCNT 		 varchar(32) NOT NULL,
	SYN_RECEIVED_MIN 	 decimal(20,4) NOT NULL,
	SYN_RECEIVED_MAX 	 decimal(20,4) NOT NULL,
	SYN_RECEIVED_STCNT 	 varchar(32) NOT NULL,
	ESTABLISHED_MIN		 decimal(20,4) NOT NULL,
	ESTABLISHED_MAX 	 decimal(20,4) NOT NULL,
	ESTABLISHED_STCNT 	 varchar(32) NOT NULL,
	CLOSE_WAIT_MIN 		 decimal(20,4) NOT NULL,
	CLOSE_WAIT_MAX 		 decimal(20,4) NOT NULL,
	CLOSE_WAIT_STCNT 	 varchar(32) NOT NULL,
	FIN_WAIT_1_MIN 		 decimal(20,4) NOT NULL,
	FIN_WAIT_1_MAX 		 decimal(20,4) NOT NULL,
	FIN_WAIT_1_STCNT	 varchar(32) NOT NULL,
	FIN_WAIT_2_MIN 		 decimal(20,4) NOT NULL,
	FIN_WAIT_2_MAX 		 decimal(20,4) NOT NULL,
	FIN_WAIT_2_STCNT 	 varchar(32) NOT NULL,
	TIME_WAIT_MIN 		 decimal(20,4) NOT NULL,
	TIME_WAIT_MAX 		 decimal(20,4) NOT NULL,
	TIME_WAIT_STCNT 	 varchar(32) NOT NULL,
	SEND_QUEUE_MIN 		 decimal(20,4) NOT NULL,
	SEND_QUEUE_MAX 		 decimal(20,4) NOT NULL,
	SEND_QUEUE_STCNT 	 varchar(32) NOT NULL,
	RECEIVE_QUEUE_MIN 	 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_MAX 	 decimal(20,4) NOT NULL,
	RECEIVE_QUEUE_STCNT  varchar(32) NOT NULL
);

ALTER TABLE TcpPortTest_TREND ADD constraint PK_TcpPortTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE TcpPortTest_THRESH;

CREATE TABLE TcpPortTest_THRESH 
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO        			varchar(32) NOT NULL, 
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	SYN_SENT_MIN	VARCHAR(256)	 NOT NULL,
	SYN_SENT_MAX	VARCHAR(256)	 NOT NULL,
	SYN_RECEIVED_MIN	VARCHAR(256)	 NOT NULL,
	SYN_RECEIVED_MAX	VARCHAR(256)	 NOT NULL,
	ESTABLISHED_MIN	VARCHAR(256)	 NOT NULL,
	ESTABLISHED_MAX	VARCHAR(256)	 NOT NULL,
	CLOSE_WAIT_MIN	VARCHAR(256)	 NOT NULL,
	CLOSE_WAIT_MAX	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_1_MIN	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_1_MAX	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_2_MIN	VARCHAR(256)	 NOT NULL,
	FIN_WAIT_2_MAX	VARCHAR(256)	 NOT NULL,
	TIME_WAIT_MIN	VARCHAR(256)	 NOT NULL,
	TIME_WAIT_MAX	VARCHAR(256)	 NOT NULL,
	SEND_QUEUE_MIN	VARCHAR(256)	 NOT NULL,
	SEND_QUEUE_MAX	VARCHAR(256)	 NOT NULL,
	RECEIVE_QUEUE_MIN	VARCHAR(256)	 NOT NULL,
	RECEIVE_QUEUE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE TcpPortTest_THRESH ADD constraint PK_TcpPortTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_TcpPortTest_THRESH ON TcpPortTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE FileTest;

CREATE TABLE FileTest
( 	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	CDUMPCNT 				decimal(20,4) NOT NULL,
	CDUMPCNT_ST 			varchar(32) NOT NULL,
	RECENTCDUMPCNT 			decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_ST 		varchar(32) NOT NULL
);

ALTER TABLE FileTest ADD constraint PK_FileTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_FileTest ON FileTest
(
	 MSMT_TIME
);
DROP TABLE FileTest_TREND;

CREATE TABLE FileTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	CDUMPCNT_MIN 			decimal(20,4) NOT NULL,
	CDUMPCNT_MAX 			decimal(20,4) NOT NULL,
	CDUMPCNT_STCNT 			varchar(32) NOT NULL,
	RECENTCDUMPCNT_MIN		decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_MAX 		decimal(20,4) NOT NULL,
	RECENTCDUMPCNT_STCNT 	varchar(32) NOT NULL
);


ALTER TABLE FileTest_TREND ADD constraint PK_FileTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileTest_THRESH;

CREATE TABLE FileTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	CDUMPCNT_MIN	VARCHAR(256)	 NOT NULL,
	CDUMPCNT_MAX	VARCHAR(256)	 NOT NULL,
	RECENTCDUMPCNT_MIN	VARCHAR(256)	 NOT NULL,
	RECENTCDUMPCNT_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE FileTest_THRESH ADD constraint PK_FileTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_FileTest_THRESH ON FileTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraArchiveTest;

CREATE TABLE OraArchiveTest
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	ARCHIVE_LOG_MODE 		decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_ST 	varchar(32) NOT NULL
);

ALTER TABLE OraArchiveTest ADD constraint PK_OraArchiveTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraArchiveTest ON OraArchiveTest
(
	 MSMT_TIME
);
DROP TABLE OraArchiveTest_TREND;

CREATE TABLE OraArchiveTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,	
	MSMT_TIME       		datetime NOT NULL,	
	PERIOD       			varchar(32) NOT NULL,
	ARCHIVE_LOG_MODE_MIN 	decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_MAX 	decimal(20,4) NOT NULL,
	ARCHIVE_LOG_MODE_STCNT	varchar(32) NOT NULL
);

ALTER TABLE OraArchiveTest_TREND ADD constraint PK_OraArchiveTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraArchiveTest_THRESH;

CREATE TABLE OraArchiveTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL, 
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	ARCHIVE_LOG_MODE_MIN	VARCHAR(256)	 NOT NULL,
	ARCHIVE_LOG_MODE_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraArchiveTest_THRESH ADD constraint PK_OraArchiveTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraArchiveTest_THRESH ON OraArchiveTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraUserTsTest;

CREATE TABLE OraUserTsTest
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	SYSTEM_TS_USERS 		decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_ST 		varchar(32) NOT NULL
);

ALTER TABLE OraUserTsTest ADD constraint PK_OraUserTsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraUserTsTest ON OraUserTsTest
(
	 MSMT_TIME
);
DROP TABLE OraUserTsTest_TREND;

CREATE TABLE OraUserTsTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST      			varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	SYSTEM_TS_USERS_MIN 	decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_MAX 	decimal(20,4) NOT NULL,
	SYSTEM_TS_USERS_STCNT 	varchar(32) NOT NULL
);

ALTER TABLE OraUserTsTest_TREND ADD constraint PK_OraUserTsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraUserTsTest_THRESH;

CREATE TABLE OraUserTsTest_THRESH
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	SYSTEM_TS_USERS_MIN	VARCHAR(256)	 NOT NULL,
	SYSTEM_TS_USERS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraUserTsTest_THRESH ADD constraint PK_OraUserTsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraUserTsTest_THRESH ON OraUserTsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraParamsTest;

CREATE TABLE OraParamsTest
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	NON_ORACLE_PARAMS	    decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_ST 	varchar(32) NOT NULL
);

ALTER TABLE OraParamsTest ADD constraint PK_OraParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraParamsTest ON OraParamsTest
(
	 MSMT_TIME
);
DROP TABLE OraParamsTest_TREND;

CREATE TABLE OraParamsTest_TREND
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO         		varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL, 
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	NON_ORACLE_PARAMS_MIN 	decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_MAX 	decimal(20,4) NOT NULL,
	NON_ORACLE_PARAMS_STCNT varchar(32) NOT NULL
);

ALTER TABLE OraParamsTest_TREND ADD constraint PK_OraParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraParamsTest_THRESH;

CREATE TABLE OraParamsTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
    PORT_NO        			varchar(32) NOT NULL,
    SITE_NAME       		varchar(64) NOT NULL,
    INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END   		datetime NOT NULL,
	NON_ORACLE_PARAMS_MIN	VARCHAR(256)	 NOT NULL,
	NON_ORACLE_PARAMS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraParamsTest_THRESH ADD constraint PK_OraParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraParamsTest_THRESH ON OraParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraAlertTest;
CREATE TABLE OraAlertTest
( 
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO        			varchar(32) NOT NULL,      
	SITE_NAME       		varchar(64) NOT NULL, 
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME       		datetime NOT NULL,
	BDUMPERRORCNT 			decimal(20,4) NOT NULL,
	BDUMPERRORCNT_ST 		varchar(32) NOT NULL,
	FILE_SIZE 			decimal(20,4) NOT NULL,
	FILE_SIZE_ST 		varchar(32) NOT NULL,
	GROWTH_RATE			decimal(20,4) NOT NULL,
	GROWTH_RATE_ST			varchar(32) NOT NULL
);
ALTER TABLE OraAlertTest ADD constraint PK_OraAlertTest
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraAlertTest ON OraAlertTest
(
	 MSMT_TIME
);
DROP TABLE OraAlertTest_TREND;
CREATE TABLE OraAlertTest_TREND 
( 	
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME      	 		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL,
	BDUMPERRORCNT_MIN 		decimal(20,4) NOT NULL,
	BDUMPERRORCNT_MAX 		decimal(20,4) NOT NULL,
	BDUMPERRORCNT_STCNT 		varchar(32) NOT NULL,
	FILE_SIZE_MIN 			decimal(20,4) NOT NULL,
	FILE_SIZE_MAX 			decimal(20,4) NOT NULL,
	FILE_SIZE_STCNT 		varchar(32) NOT NULL,
	GROWTH_RATE_MIN 		decimal(20,4) NOT NULL,
	GROWTH_RATE_MAX 		decimal(20,4) NOT NULL,
	GROWTH_RATE_STCNT 		varchar(32) NOT NULL
);
ALTER TABLE OraAlertTest_TREND ADD constraint PK_OraAlertTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraAlertTest_THRESH;
CREATE TABLE OraAlertTest_THRESH
( 
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
	SITE_NAME       		varchar(64) NOT NULL,
	INFO            		varchar(128) NOT NULL,
	MSMT_HOST       		varchar(32) NOT NULL,
	MSMT_TIME_START 		datetime NOT NULL,
	MSMT_TIME_END  	 		datetime NOT NULL,
	BDUMPERRORCNT_MIN		VARCHAR(256)	 NOT NULL,
	BDUMPERRORCNT_MAX		VARCHAR(256)	 NOT NULL,
	FILE_SIZE_MIN			VARCHAR(256)	 NOT NULL,
	FILE_SIZE_MAX			VARCHAR(256)	 NOT NULL,
	GROWTH_RATE_MIN			VARCHAR(256)	 NOT NULL,
	GROWTH_RATE_MAX			VARCHAR(256)	 NOT NULL
);
ALTER TABLE OraAlertTest_THRESH ADD constraint PK_OraAlertTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraAlertTest_THRESH ON OraAlertTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTsParamsTest;

CREATE TABLE OraTsParamsTest
( 	
	TRGT_HOST       			varchar(32) NOT NULL,
   	PORT_NO         			varchar(32) NOT NULL,
	SITE_NAME       			varchar(64) NOT NULL,  
	INFO            			varchar(128) NOT NULL,	
	MSMT_HOST       			varchar(32) NOT NULL,
	MSMT_TIME       			datetime NOT NULL,
	NON_LOCALLY_MANAGED_TS 			decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_ST 		varchar(32) NOT NULL
);

ALTER TABLE OraTsParamsTest ADD constraint PK_OraTsParamsTest 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraTsParamsTest ON OraTsParamsTest
(
	 MSMT_TIME
);
DROP TABLE OraTsParamsTest_TREND;

CREATE TABLE OraTsParamsTest_TREND
( 	
	TRGT_HOST      					varchar(32) NOT NULL,
    PORT_NO         				varchar(32) NOT NULL,
    SITE_NAME       				varchar(64) NOT NULL,
    INFO            				varchar(128) NOT NULL,
	MSMT_HOST       				varchar(32) NOT NULL,	
	MSMT_TIME       				datetime NOT NULL,
	PERIOD       					varchar(32) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MIN 		decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX 		decimal(20,4) NOT NULL,
	NON_LOCALLY_MANAGED_TS_STCNT 	varchar(32) NOT NULL
);

ALTER TABLE OraTsParamsTest_TREND ADD constraint PK_OraTsParamsTest_TREND 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraTsParamsTest_THRESH;

CREATE TABLE OraTsParamsTest_THRESH
( 	
	TRGT_HOST       			varchar(32) NOT NULL,
    PORT_NO         			varchar(32) NOT NULL,
    SITE_NAME       			varchar(64) NOT NULL,
    INFO            			varchar(128) NOT NULL,
	MSMT_HOST       			varchar(32) NOT NULL,
	MSMT_TIME_START 			datetime NOT NULL,
	MSMT_TIME_END   			datetime NOT NULL,
	NON_LOCALLY_MANAGED_TS_MIN	VARCHAR(256)	 NOT NULL,
	NON_LOCALLY_MANAGED_TS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE OraTsParamsTest_THRESH ADD constraint PK_OraTsParamsTest_THRESH 
PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraTsParamsTest_THRESH ON OraTsParamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbCacheTest;
CREATE TABLE Sun1EjbCacheTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
RESIZE_QUANTITY decimal(20,4) NOT NULL,
RESIZE_QUANTITY_ST varchar(32) NOT NULL,
CACHE_MISSES decimal(20,4) NOT NULL,
CACHE_MISSES_ST varchar(32) NOT NULL,
IDLE_TIMEOUT decimal(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar(32) NOT NULL,
NUM_PASSIVS decimal(20,4) NOT NULL,
NUM_PASSIVS_ST varchar(32) NOT NULL,
CACHE_HITS decimal(20,4) NOT NULL,
CACHE_HITS_ST varchar(32) NOT NULL,
NUM_PASSIV_ERRORS decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_ST varchar(32) NOT NULL,
BEANS_IN_CACHE decimal(20,4) NOT NULL,
BEANS_IN_CACHE_ST varchar(32) NOT NULL,
EXPIRED_SESS_REMOVED decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_ST varchar(32) NOT NULL,
MAX_BEANS_IN_CACHE decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_ST varchar(32) NOT NULL,
NUM_PASSIV_SUCCESS decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_ST varchar(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest ADD constraint PK_Sun1EjbCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1EjbCacheTest ON Sun1EjbCacheTest
(
	 MSMT_TIME
);
DROP TABLE Sun1EjbCacheTest_TREND;
CREATE TABLE Sun1EjbCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
RESIZE_QUANTITY_MIN decimal(20,4) NOT NULL,
RESIZE_QUANTITY_MAX decimal(20,4) NOT NULL,
RESIZE_QUANTITY_STCNT varchar(32) NOT NULL,
CACHE_MISSES_MIN decimal(20,4) NOT NULL,
CACHE_MISSES_MAX decimal(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar(32) NOT NULL,
IDLE_TIMEOUT_MIN decimal(20,4) NOT NULL,
IDLE_TIMEOUT_MAX decimal(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar(32) NOT NULL,
NUM_PASSIVS_MIN decimal(20,4) NOT NULL,
NUM_PASSIVS_MAX decimal(20,4) NOT NULL,
NUM_PASSIVS_STCNT varchar(32) NOT NULL,
CACHE_HITS_MIN decimal(20,4) NOT NULL,
CACHE_HITS_MAX decimal(20,4) NOT NULL,
CACHE_HITS_STCNT varchar(32) NOT NULL,
NUM_PASSIV_ERRORS_MIN decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_MAX decimal(20,4) NOT NULL,
NUM_PASSIV_ERRORS_STCNT varchar(32) NOT NULL,
BEANS_IN_CACHE_MIN decimal(20,4) NOT NULL,
BEANS_IN_CACHE_MAX decimal(20,4) NOT NULL,
BEANS_IN_CACHE_STCNT varchar(32) NOT NULL,
EXPIRED_SESS_REMOVED_MIN decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_MAX decimal(20,4) NOT NULL,
EXPIRED_SESS_REMOVED_STCNT varchar(32) NOT NULL,
MAX_BEANS_IN_CACHE_MIN decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_MAX decimal(20,4) NOT NULL,
MAX_BEANS_IN_CACHE_STCNT varchar(32) NOT NULL,
NUM_PASSIV_SUCCESS_MIN decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_MAX decimal(20,4) NOT NULL,
NUM_PASSIV_SUCCESS_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1EjbCacheTest_TREND ADD constraint PK_Sun1EjbCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbCacheTest_THRESH;
CREATE TABLE Sun1EjbCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
RESIZE_QUANTITY_MIN	VARCHAR(256)	 NOT NULL,
RESIZE_QUANTITY_MAX	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIVS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIVS_MAX	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
BEANS_IN_CACHE_MIN	VARCHAR(256)	 NOT NULL,
BEANS_IN_CACHE_MAX	VARCHAR(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MIN	VARCHAR(256)	 NOT NULL,
EXPIRED_SESS_REMOVED_MAX	VARCHAR(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MIN	VARCHAR(256)	 NOT NULL,
MAX_BEANS_IN_CACHE_MAX	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MIN	VARCHAR(256)	 NOT NULL,
NUM_PASSIV_SUCCESS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1EjbCacheTest_THRESH ADD constraint PK_Sun1EjbCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbCacheTest_THRESH ON Sun1EjbCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1EjbPoolTest;
CREATE TABLE Sun1EjbPoolTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
IDLE_TIMEOUT decimal(20,4) NOT NULL,
IDLE_TIMEOUT_ST varchar(32) NOT NULL,
STEADY_POOL_SIZE decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_ST varchar(32) NOT NULL,
TOTAL_BEANS_DESTROYED decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_ST varchar(32) NOT NULL,
NUM_THREADS_WAITING decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_ST varchar(32) NOT NULL,
NUM_BEANS_IN_POOL decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_ST varchar(32) NOT NULL,
MAX_POOL_SIZE decimal(20,4) NOT NULL,
MAX_POOL_SIZE_ST varchar(32) NOT NULL,
POOL_RESIZE_QUANTITY decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_ST varchar(32) NOT NULL,
TOTAL_BEANS_CREATED decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_ST varchar(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest ADD constraint PK_Sun1EjbPoolTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1EjbPoolTest ON Sun1EjbPoolTest
(
	 MSMT_TIME
);
DROP TABLE Sun1EjbPoolTest_TREND;
CREATE TABLE Sun1EjbPoolTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
IDLE_TIMEOUT_MIN decimal(20,4) NOT NULL,
IDLE_TIMEOUT_MAX decimal(20,4) NOT NULL,
IDLE_TIMEOUT_STCNT varchar(32) NOT NULL,
STEADY_POOL_SIZE_MIN decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_MAX decimal(20,4) NOT NULL,
STEADY_POOL_SIZE_STCNT varchar(32) NOT NULL,
TOTAL_BEANS_DESTROYED_MIN decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_MAX decimal(20,4) NOT NULL,
TOTAL_BEANS_DESTROYED_STCNT varchar(32) NOT NULL,
NUM_THREADS_WAITING_MIN decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_MAX decimal(20,4) NOT NULL,
NUM_THREADS_WAITING_STCNT varchar(32) NOT NULL,
NUM_BEANS_IN_POOL_MIN decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_MAX decimal(20,4) NOT NULL,
NUM_BEANS_IN_POOL_STCNT varchar(32) NOT NULL,
MAX_POOL_SIZE_MIN decimal(20,4) NOT NULL,
MAX_POOL_SIZE_MAX decimal(20,4) NOT NULL,
MAX_POOL_SIZE_STCNT varchar(32) NOT NULL,
POOL_RESIZE_QUANTITY_MIN decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_MAX decimal(20,4) NOT NULL,
POOL_RESIZE_QUANTITY_STCNT varchar(32) NOT NULL,
TOTAL_BEANS_CREATED_MIN decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_MAX decimal(20,4) NOT NULL,
TOTAL_BEANS_CREATED_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1EjbPoolTest_TREND ADD constraint PK_Sun1EjbPoolTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1EjbPoolTest_THRESH;
CREATE TABLE Sun1EjbPoolTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
IDLE_TIMEOUT_MIN	VARCHAR(256)	 NOT NULL,
IDLE_TIMEOUT_MAX	VARCHAR(256)	 NOT NULL,
STEADY_POOL_SIZE_MIN	VARCHAR(256)	 NOT NULL,
STEADY_POOL_SIZE_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_DESTROYED_MAX	VARCHAR(256)	 NOT NULL,
NUM_THREADS_WAITING_MIN	VARCHAR(256)	 NOT NULL,
NUM_THREADS_WAITING_MAX	VARCHAR(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MIN	VARCHAR(256)	 NOT NULL,
NUM_BEANS_IN_POOL_MAX	VARCHAR(256)	 NOT NULL,
MAX_POOL_SIZE_MIN	VARCHAR(256)	 NOT NULL,
MAX_POOL_SIZE_MAX	VARCHAR(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MIN	VARCHAR(256)	 NOT NULL,
POOL_RESIZE_QUANTITY_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_BEANS_CREATED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1EjbPoolTest_THRESH ADD constraint PK_Sun1EjbPoolTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1EjbPoolTest_THRESH ON Sun1EjbPoolTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1HttpTest;
CREATE TABLE Sun1HttpTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
REQUESTS_COUNT DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_ST varchar(32) NOT NULL,
KB_RECEIVED_COUNT DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_ST varchar(32) NOT NULL,
KB_TRANSMITTED_COUNT DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_ST varchar(32) NOT NULL,
MAX_TRANS_RATE_HWM decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_ST varchar(32) NOT NULL,
OPEN_CONNECTIONS_COUNT decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_ST varchar(32) NOT NULL,
MAX_OPEN_CONNS_HWM decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_ST varchar(32) NOT NULL,
COUNT_2XX DECIMAL(20,4) NOT NULL,
COUNT_2XX_ST varchar(32) NOT NULL,
COUNT_3XX DECIMAL(20,4) NOT NULL,
COUNT_3XX_ST varchar(32) NOT NULL,
COUNT_4XX DECIMAL(20,4) NOT NULL,
COUNT_4XX_ST varchar(32) NOT NULL,
COUNT_5XX DECIMAL(20,4) NOT NULL,
COUNT_5XX_ST varchar(32) NOT NULL,
OTHER_RESPONSES_COUNT DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1HttpTest ADD constraint PK_Sun1HttpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1HttpTest ON Sun1HttpTest
(
	 MSMT_TIME
);
DROP TABLE Sun1HttpTest_TREND;
CREATE TABLE Sun1HttpTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
REQUESTS_COUNT_MIN DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_MAX DECIMAL(20,4) NOT NULL,
REQUESTS_COUNT_STCNT varchar(32) NOT NULL,
KB_RECEIVED_COUNT_MIN DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_MAX DECIMAL(20,4) NOT NULL,
KB_RECEIVED_COUNT_STCNT varchar(32) NOT NULL,
KB_TRANSMITTED_COUNT_MIN DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_MAX DECIMAL(20,4) NOT NULL,
KB_TRANSMITTED_COUNT_STCNT varchar(32) NOT NULL,
MAX_TRANS_RATE_HWM_MIN decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_MAX decimal(20,4) NOT NULL,
MAX_TRANS_RATE_HWM_STCNT varchar(32) NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX decimal(20,4) NOT NULL,
OPEN_CONNECTIONS_COUNT_STCNT varchar(32) NOT NULL,
MAX_OPEN_CONNS_HWM_MIN decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_MAX decimal(20,4) NOT NULL,
MAX_OPEN_CONNS_HWM_STCNT varchar(32) NOT NULL,
COUNT_2XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_2XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_2XX_STCNT varchar(32) NOT NULL,
COUNT_3XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_3XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_3XX_STCNT varchar(32) NOT NULL,
COUNT_4XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_4XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_4XX_STCNT varchar(32) NOT NULL,
COUNT_5XX_MIN DECIMAL(20,4) NOT NULL,
COUNT_5XX_MAX DECIMAL(20,4) NOT NULL,
COUNT_5XX_STCNT varchar(32) NOT NULL,
OTHER_RESPONSES_COUNT_MIN DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_MAX DECIMAL(20,4) NOT NULL,
OTHER_RESPONSES_COUNT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1HttpTest_TREND ADD constraint PK_Sun1HttpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1HttpTest_THRESH;
CREATE TABLE Sun1HttpTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
REQUESTS_COUNT_MIN	VARCHAR(256)	 NOT NULL,
REQUESTS_COUNT_MAX	VARCHAR(256)	 NOT NULL,
KB_RECEIVED_COUNT_MIN	VARCHAR(256)	 NOT NULL,
KB_RECEIVED_COUNT_MAX	VARCHAR(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MIN	VARCHAR(256)	 NOT NULL,
KB_TRANSMITTED_COUNT_MAX	VARCHAR(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MIN	VARCHAR(256)	 NOT NULL,
MAX_TRANS_RATE_HWM_MAX	VARCHAR(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MIN	VARCHAR(256)	 NOT NULL,
OPEN_CONNECTIONS_COUNT_MAX	VARCHAR(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MIN	VARCHAR(256)	 NOT NULL,
MAX_OPEN_CONNS_HWM_MAX	VARCHAR(256)	 NOT NULL,
COUNT_2XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_2XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_3XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_3XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_4XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_4XX_MAX	VARCHAR(256)	 NOT NULL,
COUNT_5XX_MIN	VARCHAR(256)	 NOT NULL,
COUNT_5XX_MAX	VARCHAR(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MIN	VARCHAR(256)	 NOT NULL,
OTHER_RESPONSES_COUNT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1HttpTest_THRESH ADD constraint PK_Sun1HttpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1HttpTest_THRESH ON Sun1HttpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1JdbcTest;
CREATE TABLE Sun1JdbcTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
TOTAL_THREADS_WAITING decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_ST varchar(32) NOT NULL,
TOTAL_CONNS_FAILED decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_ST varchar(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1JdbcTest ADD constraint PK_Sun1JdbcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1JdbcTest ON Sun1JdbcTest
(
	 MSMT_TIME
);
DROP TABLE Sun1JdbcTest_TREND;
CREATE TABLE Sun1JdbcTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_THREADS_WAITING_MIN decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_MAX decimal(20,4) NOT NULL,
TOTAL_THREADS_WAITING_STCNT varchar(32) NOT NULL,
TOTAL_CONNS_FAILED_MIN decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_MAX decimal(20,4) NOT NULL,
TOTAL_CONNS_FAILED_STCNT varchar(32) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX decimal(20,4) NOT NULL,
TOTAL_CONNS_TIMED_OUT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1JdbcTest_TREND ADD constraint PK_Sun1JdbcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1JdbcTest_THRESH;
CREATE TABLE Sun1JdbcTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_THREADS_WAITING_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_THREADS_WAITING_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_FAILED_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_CONNS_TIMED_OUT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1JdbcTest_THRESH ADD constraint PK_Sun1JdbcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1JdbcTest_THRESH ON Sun1JdbcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE Sun1TxTest;
CREATE TABLE Sun1TxTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
TOTAL_TX_COMPLETED decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_ST varchar(32) NOT NULL,
TOTAL_TX_ROLLED_BACK decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_ST varchar(32) NOT NULL,
TOTAL_TX_INFLIGHT decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_ST varchar(32) NOT NULL);

ALTER TABLE Sun1TxTest ADD constraint PK_Sun1TxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_Sun1TxTest ON Sun1TxTest
(
	 MSMT_TIME
);
DROP TABLE Sun1TxTest_TREND;
CREATE TABLE Sun1TxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TOTAL_TX_COMPLETED_MIN decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_MAX decimal(20,4) NOT NULL,
TOTAL_TX_COMPLETED_STCNT varchar(32) NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX decimal(20,4) NOT NULL,
TOTAL_TX_ROLLED_BACK_STCNT varchar(32) NOT NULL,
TOTAL_TX_INFLIGHT_MIN decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_MAX decimal(20,4) NOT NULL,
TOTAL_TX_INFLIGHT_STCNT varchar(32) NOT NULL);

ALTER TABLE Sun1TxTest_TREND ADD constraint PK_Sun1TxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE Sun1TxTest_THRESH;
CREATE TABLE Sun1TxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TOTAL_TX_COMPLETED_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_COMPLETED_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_ROLLED_BACK_MAX	VARCHAR(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MIN	VARCHAR(256)	 NOT NULL,
TOTAL_TX_INFLIGHT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE Sun1TxTest_THRESH ADD constraint PK_Sun1TxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_Sun1TxTest_THRESH ON Sun1TxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppTest;
CREATE TABLE CtxAppTest (
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NUMBER_OF_PROCESSES decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar(32) NOT NULL,
CPU_USAGE DECIMAL(20,4) NOT NULL,
CPU_USAGE_ST varchar(32) NOT NULL,
MEMORY_USAGE DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_ST varchar(32) NOT NULL,
HANDLE_COUNT decimal(20,4) NOT NULL,
HANDLE_COUNT_ST varchar(32) NOT NULL,
NO_OF_THREADS decimal(20,4) NOT NULL,
NO_OF_THREADS_ST varchar(32) NOT NULL,
IO_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_ST varchar(32) NOT NULL,
IO_DATA_OPER_RATE DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_ST varchar(32) NOT NULL,
IO_READ_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_ST varchar(32) NOT NULL,
IO_WRITE_DATA_RATE DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_ST varchar(32) NOT NULL,
PAGE_FAULT_RATE DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_ST varchar(32) NOT NULL,
VIRTUAL_MEMORY_USED DECIMAL(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_ST varchar(32) NOT NULL,
MEMORY_USED DECIMAL(20,4) NOT NULL,
MEMORY_USED_ST varchar(32) NOT NULL);

ALTER TABLE CtxAppTest ADD constraint PK_CtxAppTest  PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_CtxAppTest ON CtxAppTest (MSMT_TIME) INCLUDE (NUMBER_OF_PROCESSES,CPU_USAGE,MEMORY_USAGE);
DROP TABLE CtxAppTest_TREND;
CREATE TABLE CtxAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUMBER_OF_PROCESSES_MIN decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar(32) NOT NULL,
CPU_USAGE_MIN DECIMAL(20,4) NOT NULL,
CPU_USAGE_MAX DECIMAL(20,4) NOT NULL,
CPU_USAGE_STCNT varchar(32) NOT NULL,
MEMORY_USAGE_MIN DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_MAX DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar(32) NOT NULL,
HANDLE_COUNT_MIN decimal(20,4) NOT NULL,
HANDLE_COUNT_MAX decimal(20,4) NOT NULL,
HANDLE_COUNT_STCNT varchar(32) NOT NULL,
NO_OF_THREADS_MIN decimal(20,4) NOT NULL,
NO_OF_THREADS_MAX decimal(20,4) NOT NULL,
NO_OF_THREADS_STCNT varchar(32) NOT NULL,
IO_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_DATA_RATE_STCNT varchar(32) NOT NULL,
IO_DATA_OPER_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_DATA_OPER_RATE_STCNT varchar(32) NOT NULL,
IO_READ_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_READ_DATA_RATE_STCNT varchar(32) NOT NULL,
IO_WRITE_DATA_RATE_MIN DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_MAX DECIMAL(20,4) NOT NULL,
IO_WRITE_DATA_RATE_STCNT varchar(32) NOT NULL,
PAGE_FAULT_RATE_MIN DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_MAX DECIMAL(20,4) NOT NULL,
PAGE_FAULT_RATE_STCNT varchar(32) NOT NULL,
VIRTUAL_MEMORY_USED_MIN DECIMAL(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_MAX DECIMAL(20,4) NOT NULL,
VIRTUAL_MEMORY_USED_STCNT varchar(32) NOT NULL,
MEMORY_USED_MIN DECIMAL(20,4) NOT NULL,
MEMORY_USED_MAX DECIMAL(20,4) NOT NULL,
MEMORY_USED_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxAppTest_TREND ADD constraint PK_CtxAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxAppTest_THRESH;
CREATE TABLE CtxAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUMBER_OF_PROCESSES_MIN	VARCHAR(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR(256)	 NOT NULL,
HANDLE_COUNT_MIN VARCHAR(256) NOT NULL,
HANDLE_COUNT_MAX VARCHAR(256) NOT NULL,
NO_OF_THREADS_MIN VARCHAR(256) NOT NULL,
NO_OF_THREADS_MAX VARCHAR(256) NOT NULL,
IO_DATA_RATE_MIN VARCHAR(256) NOT NULL,
IO_DATA_RATE_MAX VARCHAR(256) NOT NULL,
IO_DATA_OPER_RATE_MIN VARCHAR(256) NOT NULL,
IO_DATA_OPER_RATE_MAX VARCHAR(256) NOT NULL,
IO_READ_DATA_RATE_MIN VARCHAR(256) NOT NULL,
IO_READ_DATA_RATE_MAX VARCHAR(256) NOT NULL,
IO_WRITE_DATA_RATE_MIN VARCHAR(256) NOT NULL,
IO_WRITE_DATA_RATE_MAX VARCHAR(256) NOT NULL,
PAGE_FAULT_RATE_MIN VARCHAR(256) NOT NULL,
PAGE_FAULT_RATE_MAX VARCHAR(256) NOT NULL,
VIRTUAL_MEMORY_USED_MIN VARCHAR(256) NOT NULL,
VIRTUAL_MEMORY_USED_MAX VARCHAR(256) NOT NULL,
MEMORY_USED_MIN VARCHAR(256) NOT NULL,
MEMORY_USED_MAX VARCHAR(256) NOT NULL);

ALTER TABLE CtxAppTest_THRESH ADD constraint PK_CtxAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAppTest_THRESH ON CtxAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxMfAppTest;
CREATE TABLE CtxMfAppTest (
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NUMBER_OF_PROCESSES decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_ST varchar(32) NOT NULL,
CPU_USAGE DECIMAL(20,4) NOT NULL,
CPU_USAGE_ST varchar(32) NOT NULL,
MEMORY_USAGE DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_ST varchar(32) NOT NULL);

ALTER TABLE CtxMfAppTest ADD constraint PK_CtxMfAppTest  PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxMfAppTest ON CtxMfAppTest
(
	 MSMT_TIME
);
DROP TABLE CtxMfAppTest_TREND;
CREATE TABLE CtxMfAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUMBER_OF_PROCESSES_MIN decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_MAX decimal(20,4) NOT NULL,
NUMBER_OF_PROCESSES_STCNT varchar(32) NOT NULL,
CPU_USAGE_MIN DECIMAL(20,4) NOT NULL,
CPU_USAGE_MAX DECIMAL(20,4) NOT NULL,
CPU_USAGE_STCNT varchar(32) NOT NULL,
MEMORY_USAGE_MIN DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_MAX DECIMAL(20,4) NOT NULL,
MEMORY_USAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxMfAppTest_TREND ADD constraint PK_CtxMfAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfAppTest_THRESH;
CREATE TABLE CtxMfAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUMBER_OF_PROCESSES_MIN	VARCHAR(256)	 NOT NULL,
NUMBER_OF_PROCESSES_MAX	VARCHAR(256)	 NOT NULL,
CPU_USAGE_MIN	VARCHAR(256)	 NOT NULL,
CPU_USAGE_MAX	VARCHAR(256)	 NOT NULL,
MEMORY_USAGE_MIN	VARCHAR(256)	 NOT NULL,
MEMORY_USAGE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxMfAppTest_THRESH ADD constraint PK_CtxMfAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfAppTest_THRESH ON CtxMfAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);


DROP TABLE CtxClientTest;
CREATE TABLE CtxClientTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
CURRENT_CONNS decimal(20,4) NOT NULL,
CURRENT_CONNS_ST varchar(32) NOT NULL,
NEW_CONNS_ADDED decimal(20,4) NOT NULL,
NEW_CONNS_ADDED_ST varchar(32) NOT NULL,
OLD_CONNS_REMOVED decimal(20,4) NOT NULL,
OLD_CONNS_REMOVED_ST varchar(32) NOT NULL,
AVG_CONN_DURATION DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_ST varchar(32) NOT NULL);

ALTER TABLE CtxClientTest ADD constraint PK_CtxClientTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxClientTest ON CtxClientTest
(
	 MSMT_TIME
);
DROP TABLE CtxClientTest_TREND;
CREATE TABLE CtxClientTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURRENT_CONNS_MIN decimal(20,4) NOT NULL,
CURRENT_CONNS_MAX decimal(20,4) NOT NULL,
CURRENT_CONNS_STCNT varchar(32) NOT NULL,
NEW_CONNS_ADDED_MIN decimal(20,4) NOT NULL,
NEW_CONNS_ADDED_MAX decimal(20,4) NOT NULL,
NEW_CONNS_ADDED_STCNT varchar(32) NOT NULL,
OLD_CONNS_REMOVED_MIN decimal(20,4) NOT NULL,
OLD_CONNS_REMOVED_MAX decimal(20,4) NOT NULL,
OLD_CONNS_REMOVED_STCNT varchar(32) NOT NULL,
AVG_CONN_DURATION_MIN DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_MAX DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxClientTest_TREND ADD constraint PK_CtxClientTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxClientTest_THRESH;
CREATE TABLE CtxClientTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURRENT_CONNS_MIN	VARCHAR(256)	 NOT NULL,
CURRENT_CONNS_MAX	VARCHAR(256)	 NOT NULL,
NEW_CONNS_ADDED_MIN	VARCHAR(256)	 NOT NULL,
NEW_CONNS_ADDED_MAX	VARCHAR(256)	 NOT NULL,
OLD_CONNS_REMOVED_MIN	VARCHAR(256)	 NOT NULL,
OLD_CONNS_REMOVED_MAX	VARCHAR(256)	 NOT NULL,
AVG_CONN_DURATION_MIN	VARCHAR(256)	 NOT NULL,
AVG_CONN_DURATION_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxClientTest_THRESH ADD constraint PK_CtxClientTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxClientTest_THRESH ON CtxClientTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxImaTest;
CREATE TABLE CtxImaTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
BYTES_RECEIVED DECIMAL(20,4) NOT NULL,
BYTES_RECEIVED_ST varchar(32) NOT NULL,
BYTES_SENT DECIMAL(20,4) NOT NULL,
BYTES_SENT_ST varchar(32) NOT NULL,
NETWORK_CONNECTIONS decimal(20,4) NOT NULL,
NETWORK_CONNECTIONS_ST varchar(32) NOT NULL);

ALTER TABLE CtxImaTest ADD constraint PK_CtxImaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxImaTest ON CtxImaTest
(
	 MSMT_TIME
);
DROP TABLE CtxImaTest_TREND;
CREATE TABLE CtxImaTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
BYTES_RECEIVED_MIN DECIMAL(20,4) NOT NULL,
BYTES_RECEIVED_MAX DECIMAL(20,4) NOT NULL,
BYTES_RECEIVED_STCNT varchar(32) NOT NULL,
BYTES_SENT_MIN DECIMAL(20,4) NOT NULL,
BYTES_SENT_MAX DECIMAL(20,4) NOT NULL,
BYTES_SENT_STCNT varchar(32) NOT NULL,
NETWORK_CONNECTIONS_MIN decimal(20,4) NOT NULL,
NETWORK_CONNECTIONS_MAX decimal(20,4) NOT NULL,
NETWORK_CONNECTIONS_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxImaTest_TREND ADD constraint PK_CtxImaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxImaTest_THRESH;
CREATE TABLE CtxImaTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
BYTES_RECEIVED_MIN	VARCHAR(256)	 NOT NULL,
BYTES_RECEIVED_MAX	VARCHAR(256)	 NOT NULL,
BYTES_SENT_MIN	VARCHAR(256)	 NOT NULL,
BYTES_SENT_MAX	VARCHAR(256)	 NOT NULL,
NETWORK_CONNECTIONS_MIN	VARCHAR(256)	 NOT NULL,
NETWORK_CONNECTIONS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxImaTest_THRESH ADD constraint PK_CtxImaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxImaTest_THRESH ON CtxImaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxSessionTest;
CREATE TABLE CtxSessionTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
ACTIVE_SESSIONS decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar(32) NOT NULL,
IDLE_SESSIONS decimal(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar(32) NOT NULL,
CONNECTED_SESSIONS decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_ST varchar(32) NOT NULL,
CONNECTING_SESSIONS decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_ST varchar(32) NOT NULL,
DISCONNECTED_SESSIONS decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_ST varchar(32) NOT NULL,
LISTEN_SESSIONS decimal(20,4) NOT NULL,
LISTEN_SESSIONS_ST varchar(32) NOT NULL,
SHADOW_SESSIONS decimal(20,4) NOT NULL,
SHADOW_SESSIONS_ST varchar(32) NOT NULL,
DOWN_SESSIONS decimal(20,4) NOT NULL,
DOWN_SESSIONS_ST varchar(32) NOT NULL,
INIT_SESSIONS decimal(20,4) NOT NULL,
INIT_SESSIONS_ST varchar(32) NOT NULL);
 
CREATE NONCLUSTERED INDEX IDX_CtxSessionTest ON CtxSessionTest (MSMT_TIME) INCLUDE (ACTIVE_SESSIONS);
CREATE NONCLUSTERED INDEX IDX1_CTXSESSIONTEST ON CTXSESSIONTEST (TRGT_HOST, PORT_NO ) INCLUDE ( MSMT_TIME, ACTIVE_SESSIONS, INFO );
ALTER TABLE CtxSessionTest ADD constraint PK_CtxSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CtxSessionTest_TREND;
CREATE TABLE CtxSessionTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD        varchar(32) NOT NULL,
ACTIVE_SESSIONS_MIN decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar(32) NOT NULL,
IDLE_SESSIONS_MIN decimal(20,4) NOT NULL,
IDLE_SESSIONS_MAX decimal(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar(32) NOT NULL,
CONNECTED_SESSIONS_MIN decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_MAX decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_STCNT varchar(32) NOT NULL,
CONNECTING_SESSIONS_MIN decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_MAX decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_STCNT varchar(32) NOT NULL,
DISCONNECTED_SESSIONS_MIN decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_MAX decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_STCNT varchar(32) NOT NULL,
LISTEN_SESSIONS_MIN decimal(20,4) NOT NULL,
LISTEN_SESSIONS_MAX decimal(20,4) NOT NULL,
LISTEN_SESSIONS_STCNT varchar(32) NOT NULL,
SHADOW_SESSIONS_MIN decimal(20,4) NOT NULL,
SHADOW_SESSIONS_MAX decimal(20,4) NOT NULL,
SHADOW_SESSIONS_STCNT varchar(32) NOT NULL,
DOWN_SESSIONS_MIN decimal(20,4) NOT NULL,
DOWN_SESSIONS_MAX decimal(20,4) NOT NULL,
DOWN_SESSIONS_STCNT varchar(32) NOT NULL,
INIT_SESSIONS_MIN decimal(20,4) NOT NULL,
INIT_SESSIONS_MAX decimal(20,4) NOT NULL,
INIT_SESSIONS_STCNT varchar(32) NOT NULL);
 
ALTER TABLE CtxSessionTest_TREND ADD constraint PK_CtxSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxSessionTest_THRESH;
CREATE TABLE CtxSessionTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ACTIVE_SESSIONS_MIN VARCHAR(256) NOT NULL,
ACTIVE_SESSIONS_MAX VARCHAR(256) NOT NULL,
IDLE_SESSIONS_MIN VARCHAR(256) NOT NULL,
IDLE_SESSIONS_MAX VARCHAR(256) NOT NULL,
CONNECTED_SESSIONS_MIN VARCHAR(256) NOT NULL,
CONNECTED_SESSIONS_MAX VARCHAR(256) NOT NULL,
CONNECTING_SESSIONS_MIN VARCHAR(256) NOT NULL,
CONNECTING_SESSIONS_MAX VARCHAR(256) NOT NULL,
DISCONNECTED_SESSIONS_MIN VARCHAR(256) NOT NULL,
DISCONNECTED_SESSIONS_MAX VARCHAR(256) NOT NULL,
LISTEN_SESSIONS_MIN VARCHAR(256) NOT NULL,
LISTEN_SESSIONS_MAX VARCHAR(256) NOT NULL,
SHADOW_SESSIONS_MIN VARCHAR(256) NOT NULL,
SHADOW_SESSIONS_MAX VARCHAR(256) NOT NULL,
DOWN_SESSIONS_MIN VARCHAR(256) NOT NULL,
DOWN_SESSIONS_MAX VARCHAR(256) NOT NULL,
INIT_SESSIONS_MIN VARCHAR(256) NOT NULL,
INIT_SESSIONS_MAX VARCHAR(256) NOT NULL);
 
ALTER TABLE CtxSessionTest_THRESH ADD constraint PK_CtxSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxSessionTest_THRESH ON CtxSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_CtxSessionTest ON CtxSessionTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_CtxSessionTest ON CtxSessionTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE CtxMfXpSrvTest;
CREATE TABLE CtxMfXpSrvTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
APP_ENUMS_RT DECIMAL(20,4) NOT NULL,
APP_ENUMS_RT_ST varchar(32) NOT NULL,
APP_RESOLUTIONS_RT DECIMAL(20,4) NOT NULL,
APP_RESOLUTIONS_RT_ST varchar(32) NOT NULL,
DSTORE_CONN_FAILURE decimal(20,4) NOT NULL,
DSTORE_CONN_FAILURE_ST varchar(32) NOT NULL,
DSTORE_KB_READ_RT DECIMAL(20,4) NOT NULL,
DSTORE_KB_READ_RT_ST varchar(32) NOT NULL,
DSTORE_KB_WRITTEN_RT DECIMAL(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_ST varchar(32) NOT NULL,
DYNSTORE_KB_READ_RT DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_ST varchar(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_ST varchar(32) NOT NULL,
LH_CACHE_KB_READ_RT DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_ST varchar(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_ST varchar(32) NOT NULL,
ZONE_ELECTIONS decimal(20,4) NOT NULL,
ZONE_ELECTIONS_ST varchar(32) NOT NULL,
ZONE_ELECTIONS_W decimal(20,4) NOT NULL,
ZONE_ELECTIONS_W_ST varchar(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest ADD constraint PK_CtxMfXpSrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxMfXpSrvTest ON CtxMfXpSrvTest
(
	 MSMT_TIME
);
DROP TABLE CtxMfXpSrvTest_TREND;
CREATE TABLE CtxMfXpSrvTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
APP_ENUMS_RT_MIN DECIMAL(20,4) NOT NULL,
APP_ENUMS_RT_MAX DECIMAL(20,4) NOT NULL,
APP_ENUMS_RT_STCNT varchar(32) NOT NULL,
APP_RESOLUTIONS_RT_MIN DECIMAL(20,4) NOT NULL,
APP_RESOLUTIONS_RT_MAX DECIMAL(20,4) NOT NULL,
APP_RESOLUTIONS_RT_STCNT varchar(32) NOT NULL,
DSTORE_CONN_FAILURE_MIN decimal(20,4) NOT NULL,
DSTORE_CONN_FAILURE_MAX decimal(20,4) NOT NULL,
DSTORE_CONN_FAILURE_STCNT varchar(32) NOT NULL,
DSTORE_KB_READ_RT_MIN DECIMAL(20,4) NOT NULL,
DSTORE_KB_READ_RT_MAX DECIMAL(20,4) NOT NULL,
DSTORE_KB_READ_RT_STCNT varchar(32) NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN DECIMAL(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX DECIMAL(20,4) NOT NULL,
DSTORE_KB_WRITTEN_RT_STCNT varchar(32) NOT NULL,
DYNSTORE_KB_READ_RT_MIN DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_MAX DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_READ_RT_STCNT varchar(32) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX DECIMAL(20,4) NOT NULL,
DYNSTORE_KB_WRITTEN_RT_STCNT varchar(32) NOT NULL,
LH_CACHE_KB_READ_RT_MIN DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_MAX DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_READ_RT_STCNT varchar(32) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX DECIMAL(20,4) NOT NULL,
LH_CACHE_KB_WRITTEN_RT_STCNT varchar(32) NOT NULL,
ZONE_ELECTIONS_MIN decimal(20,4) NOT NULL,
ZONE_ELECTIONS_MAX decimal(20,4) NOT NULL,
ZONE_ELECTIONS_STCNT varchar(32) NOT NULL,
ZONE_ELECTIONS_W_MIN decimal(20,4) NOT NULL,
ZONE_ELECTIONS_W_MAX decimal(20,4) NOT NULL,
ZONE_ELECTIONS_W_STCNT varchar(32) NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_TREND ADD constraint PK_CtxMfXpSrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfXpSrvTest_THRESH;
CREATE TABLE CtxMfXpSrvTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
APP_ENUMS_RT_MIN	VARCHAR(256)	 NOT NULL,
APP_ENUMS_RT_MAX	VARCHAR(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MIN	VARCHAR(256)	 NOT NULL,
APP_RESOLUTIONS_RT_MAX	VARCHAR(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MIN	VARCHAR(256)	 NOT NULL,
DSTORE_CONN_FAILURE_MAX	VARCHAR(256)	 NOT NULL,
DSTORE_KB_READ_RT_MIN	VARCHAR(256)	 NOT NULL,
DSTORE_KB_READ_RT_MAX	VARCHAR(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MIN	VARCHAR(256)	 NOT NULL,
DSTORE_KB_WRITTEN_RT_MAX	VARCHAR(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MIN	VARCHAR(256)	 NOT NULL,
DYNSTORE_KB_READ_RT_MAX	VARCHAR(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MIN	VARCHAR(256)	 NOT NULL,
DYNSTORE_KB_WRITTEN_RT_MAX	VARCHAR(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MIN	VARCHAR(256)	 NOT NULL,
LH_CACHE_KB_READ_RT_MAX	VARCHAR(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MIN	VARCHAR(256)	 NOT NULL,
LH_CACHE_KB_WRITTEN_RT_MAX	VARCHAR(256)	 NOT NULL,
ZONE_ELECTIONS_MIN	VARCHAR(256)	 NOT NULL,
ZONE_ELECTIONS_MAX	VARCHAR(256)	 NOT NULL,
ZONE_ELECTIONS_W_MIN	VARCHAR(256)	 NOT NULL,
ZONE_ELECTIONS_W_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE CtxMfXpSrvTest_THRESH ADD constraint PK_CtxMfXpSrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfXpSrvTest_THRESH ON CtxMfXpSrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxXpUserTest;
CREATE TABLE CtxXpUserTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NO_OF_SESSIONS DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar(32) NOT NULL,
LATENCY_LAST DECIMAL(20,4) NOT NULL,
LATENCY_LAST_ST varchar(32) NOT NULL,
LATENCY_AVG DECIMAL(20,4) NOT NULL,
LATENCY_AVG_ST varchar(32) NOT NULL,
LATENCY_DEVN DECIMAL(20,4) NOT NULL,
LATENCY_DEVN_ST varchar(32) NOT NULL,
MEM_UTIL DECIMAL(20,4) NOT NULL,
MEM_UTIL_ST varchar(32) NOT NULL,
CPU_UTIL DECIMAL(20,4) NOT NULL,
CPU_UTIL_ST varchar(32) NOT NULL,
INPUT_BANDWIDTH DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_ST varchar(32) NOT NULL,
OUTPUT_BANDWIDTH DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_ST varchar(32) NOT NULL,
INPUT_LINE_SPEED DECIMAL(20,4) NOT NULL,
INPUT_LINE_SPEED_ST varchar(32) NOT NULL,
OUTPUT_LINE_SPEED DECIMAL(20,4) NOT NULL,
OUTPUT_LINE_SPEED_ST varchar(32) NOT NULL,
INPUT_COMPRESSION DECIMAL(20,4) NOT NULL,
INPUT_COMPRESSION_ST varchar(32) NOT NULL,
OUTPUT_COMPRESSION DECIMAL(20,4) NOT NULL,
OUTPUT_COMPRESSION_ST varchar(32) NOT NULL,
IO_READS DECIMAL(20,4) NOT NULL,
IO_READS_ST varchar(32) NOT NULL,
IO_WRITES DECIMAL(20,4) NOT NULL,
IO_WRITES_ST varchar(32) NOT NULL,
PAGE_FAULTS DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_ST varchar(32) NOT NULL,
VIRTUAL_MEM DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_ST varchar(32) NOT NULL,
HANDLES decimal(20,4) NOT NULL,
HANDLES_ST varchar(32) NOT NULL,
INPUT_AUDIO DECIMAL(20,4) NOT NULL,
INPUT_AUDIO_ST varchar(32) NOT NULL,
OUTPUT_AUDIO DECIMAL(20,4) NOT NULL,
OUTPUT_AUDIO_ST varchar(32) NOT NULL,
INPUT_COM DECIMAL(20,4) NOT NULL,
INPUT_COM_ST varchar(32) NOT NULL,
OUTPUT_COM DECIMAL(20,4) NOT NULL,
OUTPUT_COM_ST varchar(32) NOT NULL,
INPUT_DRIVE DECIMAL(20,4) NOT NULL,
INPUT_DRIVE_ST varchar(32) NOT NULL,
OUTPUT_DRIVE DECIMAL(20,4) NOT NULL,
OUTPUT_DRIVE_ST varchar(32) NOT NULL,
INPUT_HDX DECIMAL(20,4) NOT NULL,
INPUT_HDX_ST varchar(32) NOT NULL,
OUTPUT_HDX DECIMAL(20,4) NOT NULL,
OUTPUT_HDX_ST varchar(32) NOT NULL,
INPUT_PRINTER DECIMAL(20,4) NOT NULL,
INPUT_PRINTER_ST varchar(32) NOT NULL,
OUTPUT_PRINTER DECIMAL(20,4) NOT NULL,
OUTPUT_PRINTER_ST varchar(32) NOT NULL,
INPUT_DATA DECIMAL(20,4) NOT NULL,
INPUT_DATA_ST varchar(32) NOT NULL,
OUTPUT_DATA DECIMAL(20,4) NOT NULL,
OUTPUT_DATA_ST varchar(32) NOT NULL,
INPUT_MULTI DECIMAL(20,4) NOT NULL,
INPUT_MULTI_ST varchar(32) NOT NULL,
OUTPUT_MULTI DECIMAL(20,4) NOT NULL,
OUTPUT_MULTI_ST varchar(32) NOT NULL,
INPUT_USB DECIMAL(20,4) NOT NULL,
INPUT_USB_ST varchar(32) NOT NULL,
OUTPUT_USB DECIMAL(20,4) NOT NULL,
OUTPUT_USB_ST varchar(32) NOT NULL,
CPU_UTIL_TIME DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_ST varchar(32) NOT NULL,
BANDWIDTH_USAGE DECIMAL(20,4) NOT NULL,
BANDWIDTH_USAGE_ST varchar(32) NOT NULL,
INPUT_THINWIRE DECIMAL(20,4) NOT NULL,
INPUT_THINWIRE_ST varchar(32) NOT NULL,
OUTPUT_THINWIRE DECIMAL(20,4) NOT NULL,
OUTPUT_THINWIRE_ST varchar(32) NOT NULL,
INPUT_SEAMLESS DECIMAL(20,4) NOT NULL,
INPUT_SEAMLESS_ST varchar(32) NOT NULL,
OUTPUT_SEAMLESS DECIMAL(20,4) NOT NULL,
OUTPUT_SEAMLESS_ST varchar(32) NOT NULL,
RESOURCE_SHARES DECIMAL(20,4) NOT NULL,
RESOURCE_SHARES_ST varchar(32) NOT NULL,
TOTAL_SESSION_DURATION DECIMAL(20,4) NOT NULL,
TOTAL_SESSION_DURATION_ST varchar(32) NOT NULL,
IDLE_TIME_MEASUREPRD DECIMAL(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_ST varchar(32) NOT NULL,
IDLE_TIME_DURATION DECIMAL(20,4) NOT NULL,
IDLE_TIME_DURATION_ST varchar(32) NOT NULL,
TOTAL_IDLE_DURATION DECIMAL(20,4) NOT NULL,
TOTAL_IDLE_DURATION_ST varchar(32) NOT NULL,
TOTAL_BANDWIDTH DECIMAL(20,4) NOT NULL,
TOTAL_BANDWIDTH_ST varchar(32) NOT NULL,
MEMORY_USED DECIMAL(20,4) NOT NULL,
MEMORY_USED_ST varchar(32) NOT NULL,
PROCESS_COUNT DECIMAL(20,4) NOT NULL,
PROCESS_COUNT_ST varchar(32) NOT NULL);

ALTER TABLE CtxXpUserTest ADD constraint PK_CtxXpUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE INDEX IDX_CTXXPUSERTEST ON CTXXPUSERTEST (MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX1_CTXXPUSERTEST ON CTXXPUSERTEST (PORT_NO , MSMT_TIME) INCLUDE (TRGT_HOST, INFO, MSMT_HOST, NO_OF_SESSIONS, LATENCY_AVG, MEM_UTIL, CPU_UTIL, INPUT_BANDWIDTH, OUTPUT_BANDWIDTH, IO_READS, IO_WRITES, PAGE_FAULTS, VIRTUAL_MEM, HANDLES, INPUT_AUDIO, OUTPUT_AUDIO, BANDWIDTH_USAGE);

DROP TABLE CtxXpUserTest_TREND;
CREATE TABLE CtxXpUserTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_SESSIONS_MIN DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_MAX DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar(32) NOT NULL,
LATENCY_LAST_MIN DECIMAL(20,4) NOT NULL,
LATENCY_LAST_MAX DECIMAL(20,4) NOT NULL,
LATENCY_LAST_STCNT varchar(32) NOT NULL,
LATENCY_AVG_MIN DECIMAL(20,4) NOT NULL,
LATENCY_AVG_MAX DECIMAL(20,4) NOT NULL,
LATENCY_AVG_STCNT varchar(32) NOT NULL,
LATENCY_DEVN_MIN DECIMAL(20,4) NOT NULL,
LATENCY_DEVN_MAX DECIMAL(20,4) NOT NULL,
LATENCY_DEVN_STCNT varchar(32) NOT NULL,
MEM_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEM_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEM_UTIL_STCNT varchar(32) NOT NULL,
CPU_UTIL_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_STCNT varchar(32) NOT NULL,
INPUT_BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_STCNT varchar(32) NOT NULL,
OUTPUT_BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_STCNT varchar(32) NOT NULL,
INPUT_LINE_SPEED_MIN DECIMAL(20,4) NOT NULL,
INPUT_LINE_SPEED_MAX DECIMAL(20,4) NOT NULL,
INPUT_LINE_SPEED_STCNT varchar(32) NOT NULL,
OUTPUT_LINE_SPEED_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_LINE_SPEED_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_LINE_SPEED_STCNT varchar(32) NOT NULL,
INPUT_COMPRESSION_MIN DECIMAL(20,4) NOT NULL,
INPUT_COMPRESSION_MAX DECIMAL(20,4) NOT NULL,
INPUT_COMPRESSION_STCNT varchar(32) NOT NULL,
OUTPUT_COMPRESSION_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_COMPRESSION_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_COMPRESSION_STCNT varchar(32) NOT NULL,
IO_READS_MIN DECIMAL(20,4) NOT NULL,
IO_READS_MAX DECIMAL(20,4)  NOT NULL,
IO_READS_STCNT varchar(32) NOT NULL,
IO_WRITES_MIN DECIMAL(20,4) NOT NULL,
IO_WRITES_MAX DECIMAL(20,4) NOT NULL,
IO_WRITES_STCNT varchar(32) NOT NULL,
PAGE_FAULTS_MIN DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_MAX DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_STCNT varchar(32) NOT NULL,
VIRTUAL_MEM_MIN DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_MAX DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_STCNT varchar(32) NOT NULL,
HANDLES_MIN DECIMAL(20,4) NOT NULL,
HANDLES_MAX DECIMAL(20,4) NOT NULL,
HANDLES_STCNT varchar(32) NOT NULL,
INPUT_AUDIO_MIN DECIMAL(20,4) NOT NULL,
INPUT_AUDIO_MAX DECIMAL(20,4) NOT NULL,
INPUT_AUDIO_STCNT varchar(32) NOT NULL,
OUTPUT_AUDIO_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_AUDIO_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_AUDIO_STCNT varchar(32) NOT NULL,
INPUT_COM_MIN DECIMAL(20,4) NOT NULL,
INPUT_COM_MAX DECIMAL(20,4) NOT NULL,
INPUT_COM_STCNT varchar(32) NOT NULL,
OUTPUT_COM_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_COM_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_COM_STCNT varchar(32) NOT NULL,
INPUT_DRIVE_MIN DECIMAL(20,4) NOT NULL,
INPUT_DRIVE_MAX DECIMAL(20,4) NOT NULL,
INPUT_DRIVE_STCNT varchar(32) NOT NULL,
OUTPUT_DRIVE_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_DRIVE_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_DRIVE_STCNT varchar(32) NOT NULL,
INPUT_HDX_MIN DECIMAL(20,4) NOT NULL,
INPUT_HDX_MAX DECIMAL(20,4) NOT NULL,
INPUT_HDX_STCNT varchar(32) NOT NULL,
OUTPUT_HDX_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_HDX_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_HDX_STCNT varchar(32) NOT NULL,
INPUT_PRINTER_MIN DECIMAL(20,4) NOT NULL,
INPUT_PRINTER_MAX DECIMAL(20,4) NOT NULL,
INPUT_PRINTER_STCNT varchar(32) NOT NULL,
OUTPUT_PRINTER_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_PRINTER_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_PRINTER_STCNT varchar(32) NOT NULL,
INPUT_DATA_MIN DECIMAL(20,4) NOT NULL,
INPUT_DATA_MAX DECIMAL(20,4) NOT NULL,
INPUT_DATA_STCNT varchar(32) NOT NULL,
OUTPUT_DATA_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_DATA_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_DATA_STCNT varchar(32) NOT NULL,
INPUT_MULTI_MIN DECIMAL(20,4) NOT NULL,
INPUT_MULTI_MAX DECIMAL(20,4) NOT NULL,
INPUT_MULTI_STCNT varchar(32) NOT NULL,
OUTPUT_MULTI_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_MULTI_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_MULTI_STCNT varchar(32) NOT NULL,
INPUT_USB_MIN DECIMAL(20,4) NOT NULL,
INPUT_USB_MAX DECIMAL(20,4) NOT NULL,
INPUT_USB_STCNT varchar(32) NOT NULL,
OUTPUT_USB_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_USB_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_USB_STCNT varchar(32) NOT NULL,
CPU_UTIL_TIME_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_STCNT varchar(32) NOT NULL,
BANDWIDTH_USAGE_MIN DECIMAL(20,4) NOT NULL,
BANDWIDTH_USAGE_MAX DECIMAL(20,4) NOT NULL,
BANDWIDTH_USAGE_STCNT varchar(32) NOT NULL,
INPUT_THINWIRE_MIN DECIMAL(20,4) NOT NULL,
INPUT_THINWIRE_MAX DECIMAL(20,4) NOT NULL,
INPUT_THINWIRE_STCNT varchar(32) NOT NULL,
OUTPUT_THINWIRE_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_THINWIRE_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_THINWIRE_STCNT varchar(32) NOT NULL,
INPUT_SEAMLESS_MIN DECIMAL(20,4) NOT NULL,
INPUT_SEAMLESS_MAX DECIMAL(20,4) NOT NULL,
INPUT_SEAMLESS_STCNT varchar(32) NOT NULL,
OUTPUT_SEAMLESS_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_SEAMLESS_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_SEAMLESS_STCNT varchar(32) NOT NULL,
RESOURCE_SHARES_MIN DECIMAL(20,4) NOT NULL,
RESOURCE_SHARES_MAX DECIMAL(20,4) NOT NULL,
RESOURCE_SHARES_STCNT varchar(32) NOT NULL,
TOTAL_SESSION_DURATION_MIN DECIMAL(20,4) NOT NULL,
TOTAL_SESSION_DURATION_MAX DECIMAL(20,4) NOT NULL,
TOTAL_SESSION_DURATION_STCNT varchar(32) NOT NULL,
IDLE_TIME_MEASUREPRD_MIN DECIMAL(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_MAX DECIMAL(20,4) NOT NULL,
IDLE_TIME_MEASUREPRD_STCNT varchar(32) NOT NULL,
IDLE_TIME_DURATION_MIN DECIMAL(20,4) NOT NULL,
IDLE_TIME_DURATION_MAX DECIMAL(20,4) NOT NULL,
IDLE_TIME_DURATION_STCNT varchar(32) NOT NULL,
TOTAL_IDLE_DURATION_MIN DECIMAL(20,4) NOT NULL,
TOTAL_IDLE_DURATION_MAX DECIMAL(20,4) NOT NULL,
TOTAL_IDLE_DURATION_STCNT varchar(32) NOT NULL,
TOTAL_BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
TOTAL_BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
TOTAL_BANDWIDTH_STCNT varchar(32) NOT NULL,
MEMORY_USED_MIN DECIMAL(20,4) NOT NULL,
MEMORY_USED_MAX DECIMAL(20,4) NOT NULL,
MEMORY_USED_STCNT varchar(32) NOT NULL,
PROCESS_COUNT_MIN DECIMAL(20,4) NOT NULL,
PROCESS_COUNT_MAX DECIMAL(20,4) NOT NULL,
PROCESS_COUNT_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxXpUserTest_TREND ADD constraint PK_CtxXpUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxXpUserTest_THRESH;
CREATE TABLE CtxXpUserTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
LATENCY_LAST_MIN	VARCHAR(256)	 NOT NULL,
LATENCY_LAST_MAX	VARCHAR(256)	 NOT NULL,
LATENCY_AVG_MIN	VARCHAR(256)	 NOT NULL,
LATENCY_AVG_MAX	VARCHAR(256)	 NOT NULL,
LATENCY_DEVN_MIN	VARCHAR(256)	 NOT NULL,
LATENCY_DEVN_MAX	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR(256)	 NOT NULL,
INPUT_BANDWIDTH_MIN	VARCHAR(256)	 NOT NULL,
INPUT_BANDWIDTH_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MAX	VARCHAR(256)	 NOT NULL,
INPUT_LINE_SPEED_MIN	VARCHAR(256)	 NOT NULL,
INPUT_LINE_SPEED_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_LINE_SPEED_MAX	VARCHAR(256)	 NOT NULL,
INPUT_COMPRESSION_MIN	VARCHAR(256)	 NOT NULL,
INPUT_COMPRESSION_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_COMPRESSION_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_COMPRESSION_MAX	VARCHAR(256)	 NOT NULL,
IO_READS_MIN varchar(256) NOT NULL,
IO_READS_MAX varchar(256)  NOT NULL,
IO_WRITES_MIN varchar(256) NOT NULL,
IO_WRITES_MAX varchar(256) NOT NULL,
PAGE_FAULTS_MIN varchar(256) NOT NULL,
PAGE_FAULTS_MAX varchar(256) NOT NULL,
VIRTUAL_MEM_MIN varchar(256) NOT NULL,
VIRTUAL_MEM_MAX varchar(256) NOT NULL,
HANDLES_MIN varchar(256) NOT NULL,
HANDLES_MAX varchar(256) NOT NULL,
INPUT_AUDIO_MIN varchar(256) NOT NULL,
INPUT_AUDIO_MAX varchar(256) NOT NULL,
OUTPUT_AUDIO_MIN varchar(256) NOT NULL,
OUTPUT_AUDIO_MAX varchar(256) NOT NULL,
INPUT_COM_MIN varchar(256) NOT NULL,
INPUT_COM_MAX varchar(256) NOT NULL,
OUTPUT_COM_MIN varchar(256) NOT NULL,
OUTPUT_COM_MAX varchar(256) NOT NULL,
INPUT_DRIVE_MIN varchar(256) NOT NULL,
INPUT_DRIVE_MAX varchar(256) NOT NULL,
OUTPUT_DRIVE_MIN varchar(256) NOT NULL,
OUTPUT_DRIVE_MAX varchar(256) NOT NULL,
INPUT_HDX_MIN varchar(256) NOT NULL,
INPUT_HDX_MAX varchar(256) NOT NULL,
OUTPUT_HDX_MIN varchar(256) NOT NULL,
OUTPUT_HDX_MAX varchar(256) NOT NULL,
INPUT_PRINTER_MIN varchar(256) NOT NULL,
INPUT_PRINTER_MAX varchar(256) NOT NULL,
OUTPUT_PRINTER_MIN varchar(256) NOT NULL,
OUTPUT_PRINTER_MAX varchar(256) NOT NULL,
INPUT_DATA_MIN varchar(256) NOT NULL,
INPUT_DATA_MAX varchar(256) NOT NULL,
OUTPUT_DATA_MIN varchar(256) NOT NULL,
OUTPUT_DATA_MAX varchar(256) NOT NULL,
INPUT_MULTI_MIN varchar(256) NOT NULL,
INPUT_MULTI_MAX varchar(256) NOT NULL,
OUTPUT_MULTI_MIN varchar(256) NOT NULL,
OUTPUT_MULTI_MAX varchar(256) NOT NULL,
INPUT_USB_MIN varchar(256) NOT NULL,
INPUT_USB_MAX varchar(256) NOT NULL,
OUTPUT_USB_MIN varchar(256) NOT NULL,
OUTPUT_USB_MAX varchar(256) NOT NULL,
CPU_UTIL_TIME_MIN varchar(256) NOT NULL,
CPU_UTIL_TIME_MAX varchar(256) NOT NULL,
BANDWIDTH_USAGE_MIN varchar(256) NOT NULL,
BANDWIDTH_USAGE_MAX varchar(256) NOT NULL,
INPUT_THINWIRE_MIN varchar(256) NOT NULL,
INPUT_THINWIRE_MAX varchar(256) NOT NULL,
OUTPUT_THINWIRE_MIN varchar(256) NOT NULL,
OUTPUT_THINWIRE_MAX varchar(256) NOT NULL,
INPUT_SEAMLESS_MIN varchar(256) NOT NULL,
INPUT_SEAMLESS_MAX varchar(256) NOT NULL,
OUTPUT_SEAMLESS_MIN varchar(256) NOT NULL,
OUTPUT_SEAMLESS_MAX varchar(256) NOT NULL,
RESOURCE_SHARES_MIN varchar(256) NOT NULL,
RESOURCE_SHARES_MAX varchar(256) NOT NULL,
TOTAL_SESSION_DURATION_MIN VARCHAR(256) NOT NULL,
TOTAL_SESSION_DURATION_MAX VARCHAR(256) NOT NULL,
IDLE_TIME_MEASUREPRD_MIN VARCHAR(256) NOT NULL,
IDLE_TIME_MEASUREPRD_MAX VARCHAR(256) NOT NULL,
IDLE_TIME_DURATION_MIN VARCHAR(256) NOT NULL,
IDLE_TIME_DURATION_MAX VARCHAR(256) NOT NULL,
TOTAL_IDLE_DURATION_MIN VARCHAR(256) NOT NULL,
TOTAL_IDLE_DURATION_MAX VARCHAR(256) NOT NULL,
TOTAL_BANDWIDTH_MIN VARCHAR(256) NOT NULL,
TOTAL_BANDWIDTH_MAX VARCHAR(256) NOT NULL,
MEMORY_USED_MIN VARCHAR(256) NOT NULL,
MEMORY_USED_MAX VARCHAR(256) NOT NULL,
PROCESS_COUNT_MIN VARCHAR(256) NOT NULL,
PROCESS_COUNT_MAX VARCHAR(256) NOT NULL);

ALTER TABLE CtxXpUserTest_THRESH ADD constraint PK_CtxXpUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxXpUserTest_THRESH ON CtxXpUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxMfUserTest;
CREATE TABLE CtxMfUserTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NO_OF_SESSIONS decimal(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar(32) NOT NULL,
USER_PROCESSOR_TIME DECIMAL(20,4) NOT NULL,
USER_PROCESSOR_TIME_ST varchar(32) NOT NULL,
MEM_UTIL DECIMAL(20,4) NOT NULL,
MEM_UTIL_ST varchar(32) NOT NULL,
INPUT_BYTES DECIMAL(20,4) NOT NULL,
INPUT_BYTES_ST varchar(32) NOT NULL,
INPUT_ERRORS DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_ST varchar(32) NOT NULL,
OUTPUT_BYTES DECIMAL(20,4) NOT NULL,
OUTPUT_BYTES_ST varchar(32) NOT NULL,
OUTPUT_ERRORS decimal(20,4) NOT NULL,
OUTPUT_ERRORS_ST varchar(32) NOT NULL);

ALTER TABLE CtxMfUserTest ADD constraint PK_CtxMfUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxMfUserTest ON CtxMfUserTest
(
	 MSMT_TIME
);
DROP TABLE CtxMfUserTest_TREND;
CREATE TABLE CtxMfUserTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_SESSIONS_MIN decimal(20,4) NOT NULL,
NO_OF_SESSIONS_MAX decimal(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar(32) NOT NULL,
USER_PROCESSOR_TIME_MIN DECIMAL(20,4) NOT NULL,
USER_PROCESSOR_TIME_MAX DECIMAL(20,4) NOT NULL,
USER_PROCESSOR_TIME_STCNT varchar(32) NOT NULL,
MEM_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEM_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEM_UTIL_STCNT varchar(32) NOT NULL,
INPUT_BYTES_MIN DECIMAL(20,4) NOT NULL,
INPUT_BYTES_MAX DECIMAL(20,4) NOT NULL,
INPUT_BYTES_STCNT varchar(32) NOT NULL,
INPUT_ERRORS_MIN DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_MAX DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_STCNT varchar(32) NOT NULL,
OUTPUT_BYTES_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_BYTES_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_BYTES_STCNT varchar(32) NOT NULL,
OUTPUT_ERRORS_MIN decimal(20,4) NOT NULL,
OUTPUT_ERRORS_MAX decimal(20,4) NOT NULL,
OUTPUT_ERRORS_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxMfUserTest_TREND ADD constraint PK_CtxMfUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxMfUserTest_THRESH;
CREATE TABLE CtxMfUserTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
USER_PROCESSOR_TIME_MIN	VARCHAR(256)	 NOT NULL,
USER_PROCESSOR_TIME_MAX	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR(256)	 NOT NULL,
INPUT_BYTES_MIN	VARCHAR(256)	 NOT NULL,
INPUT_BYTES_MAX	VARCHAR(256)	 NOT NULL,
INPUT_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
INPUT_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_BYTES_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_BYTES_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_ERRORS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxMfUserTest_THRESH ADD constraint PK_CtxMfUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxMfUserTest_THRESH ON CtxMfUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

CREATE TABLE report_info(rept_id VARCHAR(16) NOT NULL,
rept_name VARCHAR(256) NOT NULL,
rept_type VARCHAR(32) NOT NULL);

ALTER TABLE report_info ADD constraint PK_report_info
 primary key(rept_id);

INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d1','DeepHome','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d2','DeepSegments','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d3','DeepComptypes','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d4','DeepSites','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d5','DeepCompnamesLayers','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d6','DeepLayersTests','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('rept_d7','DeepTestsMeasures','Deep');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErMacroDetails','Detailed Graph of infrastructure health','Macro');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErMacroHome','Details of Infrastructure states','Macro');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('ErQuick','Infrastructure State Quick','Quick');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Measure','Measure Graph','RepoLite');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Summary','Summary Graph','RepoLite');
INSERT INTO report_info(rept_id,rept_name,rept_type) VALUES('Comparison','Comparison Graphs','RepoLite');


DROP table user_rept_info;

DROP table user_report;

CREATE TABLE user_report(
user_rept_id DECIMAL(16) NOT NULL,
user_rept_name VARCHAR(200) NOT NULL,
user_id VARCHAR(256) NOT NULL,
rept_time DATETIME NOT NULL);

ALTER TABLE user_report ADD constraint PK_user_report
primary key(user_rept_id);
CREATE INDEX IDX1_USER_REPORT ON USER_REPORT(USER_ID);

CREATE TABLE  user_rept_info(
user_rept_id DECIMAL(16) NOT NULL,
rept_param VARCHAR(128) NOT NULL,
rept_value VARCHAR(1024));

ALTER TABLE user_rept_info ADD constraint FK_user_rept_info
foreign key(user_rept_id) references user_report(user_rept_id) ON DELETE CASCADE;

CREATE TABLE report_share (user_rept_id DECIMAL(16) NOT NULL,
user_id VARCHAR(256) NOT NULL);

ALTER TABLE report_share ADD constraint FK_report_share_1
foreign key(user_rept_id) references user_report(user_rept_id);

ALTER TABLE report_share ADD constraint FK_report_share_2
foreign key(user_id) references USER_INFO(user_id);

DROP table schedule_detail;

DROP table schedule_info;
 
create table schedule_info(
schedule_id DECIMAL(16) NOT NULL,
user_id VARCHAR(256) NOT NULL,
schedule_name VARCHAR(200) NOT NULL,
mail_frequency VARCHAR(512),
print_frequency VARCHAR(32),
creation_time DATETIME NOT NULL,
mail_id VARCHAR(512),
schedule_booklet_id VARCHAR(256));
 
ALTER TABLE schedule_info ADD constraint PK_Schedule_Info
primary key(schedule_id);
  
create table schedule_detail(
schedule_id DECIMAL(16) NOT NULL,
Schedule_param VARCHAR(128) NOT NULL,
Schedule_value VARCHAR(1024)
);
ALTER TABLE schedule_detail ADD constraint FK_schedule_detail
foreign key(schedule_id) references schedule_info(schedule_id) ON DELETE CASCADE;

DROP TABLE onetime_schedule_detail;
DROP TABLE onetime_schedule_info ;

CREATE TABLE onetime_schedule_info(
onetime_schedule_id VARCHAR(128) NOT NULL,
onetime_user_id VARCHAR(256) NOT NULL,
onetime_bgreport_name VARCHAR(32) NOT NULL,
onetime_bgreport_from VARCHAR(100) NOT NULL,
onetime_status VARCHAR(32) NOT NULL,
onetime_timeline VARCHAR(32) NOT NULL,
onetime_startDate DATETIME,
onetime_endDate DATETIME,
creation_time DATETIME NOT NULL);

ALTER TABLE onetime_schedule_info ADD constraint PK_Onetime_Schedule_info
primary key(onetime_schedule_id);


CREATE TABLE  onetime_schedule_detail(
onetime_schedule_id VARCHAR(128) NOT NULL,
onetime_schedule_param VARCHAR(128) NOT NULL,
onetime_schedule_value VARCHAR(256));

ALTER TABLE onetime_schedule_detail ADD constraint FK_onetime_schedule_detail
foreign key(onetime_schedule_id) references onetime_schedule_info(onetime_schedule_id) ON DELETE CASCADE;

DROP TABLE BOOKLET_GROUP_INFO;

CREATE TABLE BOOKLET_GROUP_INFO(
BOOKLET_ID DECIMAL(16) NOT NULL,
USER_ID VARCHAR(256) NOT NULL,
BOOKLET_NAME VARCHAR(200) NOT NULL,
REPORT_ORDER VARCHAR(100) NOT NULL,
STATUS VARCHAR(32) NOT NULL,
REPORT_FORMATE VARCHAR(32) NOT NULL,
CREATED_DATE DATETIME  NOT NULL,
DESCRIPTION VARCHAR(256));

ALTER TABLE BOOKLET_GROUP_INFO ADD constraint PK_BOOKLET_GROUP_INFO
primary key(BOOKLET_ID);

DROP TABLE BOOKLET_REPORT_INFO;
CREATE TABLE BOOKLET_REPORT_INFO(
REPORT_ID DECIMAL(16) NOT NULL, 
BOOKLET_ID DECIMAL(16) NOT NULL, 
REPORT_NAME VARCHAR(200) NOT NULL);

ALTER TABLE BOOKLET_REPORT_INFO ADD constraint PK_BOOKLET_REPORT_INFO
primary key(REPORT_ID);

DROP TABLE BOOKLET_REPORT_PARAMETER_INFO;
CREATE TABLE BOOKLET_REPORT_PARAMETER_INFO(
REPORT_ID DECIMAL(16) NOT NULL, 
PARAMETER_NAME  VARCHAR(256) NOT NULL,
PARAMETER_VALUE VARCHAR(256));

DROP TABLE SCHEDULE_BOOKLET_INFO;
CREATE TABLE SCHEDULE_BOOKLET_INFO(
	SCHEDULE_BOOKLET_ID DECIMAL(16) NOT NULL,
	USER_ID VARCHAR(256) NOT NULL,
	SCHEDULE_BOOKLET_NAME VARCHAR(200) NOT NULL,
	MAIL_FREQUENCY VARCHAR(512),
	MAIL_ID VARCHAR(256),
	CREATED_DATE DATETIME NOT NULL,
	IS_ANYTIME_SCHEDULE VARCHAR(256),
	NEED_TO_MERGE VARCHAR(256) DEFAULT 'no');

ALTER TABLE SCHEDULE_BOOKLET_INFO ADD constraint PK_SCHEDULE_BOOKLET_INFO
primary key(SCHEDULE_BOOKLET_ID);

DROP TABLE report_state_summary;

CREATE TABLE  report_state_summary(
comp_name VARCHAR(64) NOT NULL,
comp_type VARCHAR(32) NOT NULL,
site_name VARCHAR(64) NOT NULL,
segment_name VARCHAR(64) NOT NULL,
layer_name VARCHAR(64) NOT NULL,
summ_date DATETIME NOT NULL,
component VARCHAR(128) NOT NULL,
durn_good DECIMAL(20,4),
durn_high DECIMAL(20,4),
durn_medium DECIMAL(20,4),
durn_low DECIMAL(20,4),
durn_unknown DECIMAL(20,4),
cnt_high DECIMAL(16) NOT NULL,
cnt_medium DECIMAL(16) NOT NULL,
cnt_low DECIMAL(16) NOT NULL,
cnt_unknown DECIMAL(16) NOT NULL,
dcnt_high DECIMAL(16) NOT NULL,
dcnt_medium DECIMAL(16) NOT NULL,
dcnt_low DECIMAL(16) NOT NULL,
dcnt_unknown DECIMAL(16) NOT NULL);


ALTER TABLE report_state_summary ADD CONSTRAINT pk_report_state_summary 
PRIMARY KEY(comp_name,comp_type,site_name,segment_name,layer_name,summ_date);


create unique index IDX_REPORT_STATE_SUMMMARY  on report_state_summary (component,site_name,segment_name,layer_name,summ_date);
CREATE NONCLUSTERED INDEX IDX1_REPORT_STATE_SUMMARY ON REPORT_STATE_SUMMARY(SITE_NAME, SEGMENT_NAME, LAYER_NAME, COMP_TYPE ) INCLUDE (SUMM_DATE, COMPONENT, DURN_HIGH, DURN_MEDIUM, DURN_LOW, DURN_UNKNOWN, CNT_HIGH ,CNT_MEDIUM, CNT_LOW);

DROP TABLE CiscoBufferTest;
CREATE TABLE CiscoBufferTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	NO_MEM_ERRORS decimal(20,4) NOT NULL,
	NO_MEM_ERRORS_ST varchar(32) NOT NULL,
	SMALL_BUFFER_MISSES decimal(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_ST varchar(32) NOT NULL,
	MEDIUM_BUFFER_MISSES decimal(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_ST varchar(32) NOT NULL,
	BIG_BUFFER_MISSES decimal(20,4) NOT NULL,
	BIG_BUFFER_MISSES_ST varchar(32) NOT NULL,
	LARGE_BUFFER_MISSES decimal(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_ST varchar(32) NOT NULL,
	HUGE_BUFFER_MISSES decimal(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_ST varchar(32) NOT NULL,
	BUFFER_HITS  decimal(20,4) NOT NULL,
	BUFFER_HITS_ST varchar(32) NOT NULL
);

ALTER TABLE CiscoBufferTest ADD constraint PK_CiscoBufferTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CiscoBufferTest ON CiscoBufferTest
(
	 MSMT_TIME
);
DROP TABLE CiscoBufferTest_TREND;
CREATE TABLE CiscoBufferTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	NO_MEM_ERRORS_MIN decimal(20,4) NOT NULL,
	NO_MEM_ERRORS_MAX decimal(20,4) NOT NULL,
	NO_MEM_ERRORS_STCNT varchar(32) NOT NULL,
	SMALL_BUFFER_MISSES_MIN decimal(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_MAX decimal(20,4) NOT NULL,
	SMALL_BUFFER_MISSES_STCNT varchar(32) NOT NULL,
	MEDIUM_BUFFER_MISSES_MIN decimal(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_MAX decimal(20,4) NOT NULL,
	MEDIUM_BUFFER_MISSES_STCNT varchar(32) NOT NULL,
	BIG_BUFFER_MISSES_MIN decimal(20,4) NOT NULL,
	BIG_BUFFER_MISSES_MAX decimal(20,4) NOT NULL,
	BIG_BUFFER_MISSES_STCNT varchar(32) NOT NULL,
	LARGE_BUFFER_MISSES_MIN decimal(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_MAX decimal(20,4) NOT NULL,
	LARGE_BUFFER_MISSES_STCNT varchar(32) NOT NULL,
	HUGE_BUFFER_MISSES_MIN decimal(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_MAX decimal(20,4) NOT NULL,
	HUGE_BUFFER_MISSES_STCNT varchar(32) NOT NULL,
	BUFFER_HITS_MIN decimal(20,4) NOT NULL,
	BUFFER_HITS_MAX decimal(20,4) NOT NULL,
	BUFFER_HITS_STCNT varchar(32) NOT NULL
);

ALTER TABLE CiscoBufferTest_TREND ADD constraint PK_CiscoBufferTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoBufferTest_THRESH;
CREATE TABLE CiscoBufferTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	NO_MEM_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	NO_MEM_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	SMALL_BUFFER_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	SMALL_BUFFER_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	MEDIUM_BUFFER_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	MEDIUM_BUFFER_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	BIG_BUFFER_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	BIG_BUFFER_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	LARGE_BUFFER_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	LARGE_BUFFER_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	HUGE_BUFFER_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	HUGE_BUFFER_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	BUFFER_HITS_MIN	VARCHAR(256)	 NOT NULL,
	BUFFER_HITS_MAX	VARCHAR(256)	 NOT NULL
);

ALTER TABLE CiscoBufferTest_THRESH ADD constraint PK_CiscoBufferTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CiscoBufferTest_THRESH ON CiscoBufferTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CiscoInterfaceTest;
CREATE TABLE CiscoInterfaceTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	RELIABILITY_VALUE decimal(20,4) NOT NULL,
	RELIABILITY_VALUE_ST varchar(32) NOT NULL,
	RELIABILITY_PCT decimal(20,4) NOT NULL,
	RELIABILITY_PCT_ST varchar(32) NOT NULL,
	DELAY decimal(20,4) NOT NULL,
	DELAY_ST varchar(32) NOT NULL,
	LOAD_FACTOR decimal(20,4) NOT NULL,
	LOAD_FACTOR_ST varchar(32) NOT NULL,
	DATA_RECVD_RATE decimal(20,4) NOT NULL,
	DATA_RECVD_RATE_ST varchar(32) NOT NULL,
	DATA_XMIT_RATE decimal(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar(32) NOT NULL,
	IN_QUEUE_DROPS decimal(20,4) NOT NULL,
	IN_QUEUE_DROPS_ST varchar(32) NOT NULL,
	OUT_QUEUE_DROPS decimal(20,4) NOT NULL,
	OUT_QUEUE_DROPS_ST varchar(32) NOT NULL,
	NUM_RESETS decimal(20,4) NOT NULL,
	NUM_RESETS_ST varchar(32) NOT NULL,
	NUM_RESTARTS decimal(20,4) NOT NULL,
	NUM_RESTARTS_ST varchar(32) NOT NULL,
	NUM_CRC_ERRORS decimal(20,4) NOT NULL,
	NUM_CRC_ERRORS_ST varchar(32) NOT NULL,
	NUM_ABORTS decimal(20,4) NOT NULL,
	NUM_ABORTS_ST varchar(32) NOT NULL,
	NUM_COLLISIONS decimal(20,4) NOT NULL,
	NUM_COLLISIONS_ST varchar(32) NOT NULL,
	SLOW_PACKETS_IN decimal(20,4) NOT NULL,
	SLOW_PACKETS_IN_ST varchar(32) NOT NULL,
	SLOW_PACKETS_OUT decimal(20,4) NOT NULL,
	SLOW_PACKETS_OUT_ST varchar(32) NOT NULL,
	LINK_PROTOCOL decimal(20,4) NOT NULL,
	LINK_PROTOCOL_ST varchar(32) NOT NULL);

ALTER TABLE CiscoInterfaceTest ADD constraint PK_CiscoInterfaceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CiscoInterfaceTest ON CiscoInterfaceTest (MSMT_TIME) INCLUDE (RELIABILITY_PCT,LOAD_FACTOR,DATA_RECVD_RATE,DATA_XMIT_RATE,IN_QUEUE_DROPS,OUT_QUEUE_DROPS,NUM_COLLISIONS);

DROP TABLE CiscoInterfaceTest_TREND;
CREATE TABLE CiscoInterfaceTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	RELIABILITY_VALUE_MIN decimal(20,4) NOT NULL,
	RELIABILITY_VALUE_MAX decimal(20,4) NOT NULL,
	RELIABILITY_VALUE_STCNT varchar(32) NOT NULL,
	RELIABILITY_PCT_MIN decimal(20,4) NOT NULL,
	RELIABILITY_PCT_MAX decimal(20,4) NOT NULL,
	RELIABILITY_PCT_STCNT varchar(32) NOT NULL,
	DELAY_MIN decimal(20,4) NOT NULL,
	DELAY_MAX decimal(20,4) NOT NULL,
	DELAY_STCNT varchar(32) NOT NULL,
	LOAD_FACTOR_MIN decimal(20,4) NOT NULL,
	LOAD_FACTOR_MAX decimal(20,4) NOT NULL,
	LOAD_FACTOR_STCNT varchar(32) NOT NULL,
	DATA_RECVD_RATE_MIN decimal(20,4) NOT NULL,
	DATA_RECVD_RATE_MAX decimal(20,4) NOT NULL,
	DATA_RECVD_RATE_STCNT varchar(32) NOT NULL,
	DATA_XMIT_RATE_MIN decimal(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX decimal(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar(32) NOT NULL,
	IN_QUEUE_DROPS_MIN decimal(20,4) NOT NULL,
	IN_QUEUE_DROPS_MAX decimal(20,4) NOT NULL,
	IN_QUEUE_DROPS_STCNT varchar(32) NOT NULL,
	OUT_QUEUE_DROPS_MIN decimal(20,4) NOT NULL,
	OUT_QUEUE_DROPS_MAX decimal(20,4) NOT NULL,
	OUT_QUEUE_DROPS_STCNT varchar(32) NOT NULL,
	NUM_RESETS_MIN decimal(20,4) NOT NULL,
	NUM_RESETS_MAX decimal(20,4) NOT NULL,
	NUM_RESETS_STCNT varchar(32) NOT NULL,
	NUM_RESTARTS_MIN decimal(20,4) NOT NULL,
	NUM_RESTARTS_MAX decimal(20,4) NOT NULL,
	NUM_RESTARTS_STCNT varchar(32) NOT NULL,
	NUM_CRC_ERRORS_MIN decimal(20,4) NOT NULL,
	NUM_CRC_ERRORS_MAX decimal(20,4) NOT NULL,
	NUM_CRC_ERRORS_STCNT varchar(32) NOT NULL,
	NUM_ABORTS_MIN decimal(20,4) NOT NULL,
	NUM_ABORTS_MAX decimal(20,4) NOT NULL,
	NUM_ABORTS_STCNT varchar(32) NOT NULL,
	NUM_COLLISIONS_MIN decimal(20,4) NOT NULL,
	NUM_COLLISIONS_MAX decimal(20,4) NOT NULL,
	NUM_COLLISIONS_STCNT varchar(32) NOT NULL,
	SLOW_PACKETS_IN_MIN decimal(20,4) NOT NULL,
	SLOW_PACKETS_IN_MAX decimal(20,4) NOT NULL,
	SLOW_PACKETS_IN_STCNT varchar(32) NOT NULL,
	SLOW_PACKETS_OUT_MIN decimal(20,4) NOT NULL,
	SLOW_PACKETS_OUT_MAX decimal(20,4) NOT NULL,
	SLOW_PACKETS_OUT_STCNT varchar(32) NOT NULL,
	LINK_PROTOCOL_MIN decimal(20,4) NOT NULL,
	LINK_PROTOCOL_MAX decimal(20,4) NOT NULL,
	LINK_PROTOCOL_STCNT varchar(32) NOT NULL);

ALTER TABLE CiscoInterfaceTest_TREND ADD constraint PK_CiscoInterfaceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CiscoInterfaceTest_THRESH;
CREATE TABLE CiscoInterfaceTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL
	,MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	RELIABILITY_VALUE_MIN	VARCHAR(256)	 NOT NULL,
	RELIABILITY_VALUE_MAX	VARCHAR(256)	 NOT NULL,
	RELIABILITY_PCT_MIN	VARCHAR(256)	 NOT NULL,
	RELIABILITY_PCT_MAX	VARCHAR(256)	 NOT NULL,
	DELAY_MIN	VARCHAR(256)	 NOT NULL,
	DELAY_MAX	VARCHAR(256)	 NOT NULL,
	LOAD_FACTOR_MIN	VARCHAR(256)	 NOT NULL,
	LOAD_FACTOR_MAX	VARCHAR(256)	 NOT NULL,
	DATA_RECVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_RECVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	IN_QUEUE_DROPS_MIN	VARCHAR(256)	 NOT NULL,
	IN_QUEUE_DROPS_MAX	VARCHAR(256)	 NOT NULL,
	OUT_QUEUE_DROPS_MIN	VARCHAR(256)	 NOT NULL,
	OUT_QUEUE_DROPS_MAX	VARCHAR(256)	 NOT NULL,
	NUM_RESETS_MIN	VARCHAR(256)	 NOT NULL,
	NUM_RESETS_MAX	VARCHAR(256)	 NOT NULL,
	NUM_RESTARTS_MIN	VARCHAR(256)	 NOT NULL,
	NUM_RESTARTS_MAX	VARCHAR(256)	 NOT NULL,
	NUM_CRC_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	NUM_CRC_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	NUM_ABORTS_MIN	VARCHAR(256)	 NOT NULL,
	NUM_ABORTS_MAX	VARCHAR(256)	 NOT NULL,
	NUM_COLLISIONS_MIN	VARCHAR(256)	 NOT NULL,
	NUM_COLLISIONS_MAX	VARCHAR(256)	 NOT NULL,
	SLOW_PACKETS_IN_MIN	VARCHAR(256)	 NOT NULL,
	SLOW_PACKETS_IN_MAX	VARCHAR(256)	 NOT NULL,
	SLOW_PACKETS_OUT_MIN	VARCHAR(256)	 NOT NULL,
	SLOW_PACKETS_OUT_MAX	VARCHAR(256)	 NOT NULL,
	LINK_PROTOCOL_MIN	VARCHAR(256)	 NOT NULL,
	LINK_PROTOCOL_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CiscoInterfaceTest_THRESH ADD constraint PK_CiscoInterfaceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CiscoInterfaceTest_THRESH ON CiscoInterfaceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinSessionTest;

CREATE TABLE WinSessionTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	LOGON_RATE DECIMAL(20,4) NOT NULL,
	LOGON_RATE_ST varchar(32) NOT NULL,
	LOGON_ERRORS decimal(20,4) NOT NULL,
	LOGON_ERRORS_ST varchar(32) NOT NULL,
	CURRENT_SESSIONS decimal(20,4) NOT NULL,
	CURRENT_SESSIONS_ST varchar(32) NOT NULL,
	SESSIONS_WITH_ERRORS decimal(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_ST varchar(32) NOT NULL,
	SESSIONS_FORCED_OFF decimal(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_ST varchar(32) NOT NULL,
	SESSIONS_LOGGED_OFF decimal(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_ST varchar(32) NOT NULL,
	SESSIONS_TIMED_OUT decimal(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_ST varchar(32) NOT NULL);

ALTER TABLE WinSessionTest ADD constraint PK_WinSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinSessionTest ON WinSessionTest
(
	 MSMT_TIME
);

DROP TABLE WinSessionTest_TREND;

CREATE TABLE WinSessionTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	LOGON_RATE_MIN DECIMAL(20,4) NOT NULL,
	LOGON_RATE_MAX DECIMAL(20,4) NOT NULL,
	LOGON_RATE_STCNT varchar(32) NOT NULL,
	LOGON_ERRORS_MIN decimal(20,4) NOT NULL,
	LOGON_ERRORS_MAX decimal(20,4) NOT NULL,
	LOGON_ERRORS_STCNT varchar(32) NOT NULL,
	CURRENT_SESSIONS_MIN decimal(20,4) NOT NULL,
	CURRENT_SESSIONS_MAX decimal(20,4) NOT NULL,
	CURRENT_SESSIONS_STCNT varchar(32) NOT NULL,
	SESSIONS_WITH_ERRORS_MIN decimal(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_MAX decimal(20,4) NOT NULL,
	SESSIONS_WITH_ERRORS_STCNT varchar(32) NOT NULL,
	SESSIONS_FORCED_OFF_MIN decimal(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_MAX decimal(20,4) NOT NULL,
	SESSIONS_FORCED_OFF_STCNT varchar(32) NOT NULL,
	SESSIONS_LOGGED_OFF_MIN decimal(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_MAX decimal(20,4) NOT NULL,
	SESSIONS_LOGGED_OFF_STCNT varchar(32) NOT NULL,
	SESSIONS_TIMED_OUT_MIN decimal(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_MAX decimal(20,4) NOT NULL,
	SESSIONS_TIMED_OUT_STCNT varchar(32) NOT NULL);


ALTER TABLE WinSessionTest_TREND ADD constraint PK_WinSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinSessionTest_THRESH;

CREATE TABLE WinSessionTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL
	,MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	LOGON_RATE_MIN	VARCHAR(256)	 NOT NULL,
	LOGON_RATE_MAX	VARCHAR(256)	 NOT NULL,
	LOGON_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	LOGON_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	CURRENT_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
	CURRENT_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
	SESSIONS_WITH_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	SESSIONS_WITH_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	SESSIONS_FORCED_OFF_MIN	VARCHAR(256)	 NOT NULL,
	SESSIONS_FORCED_OFF_MAX	VARCHAR(256)	 NOT NULL,
	SESSIONS_LOGGED_OFF_MIN	VARCHAR(256)	 NOT NULL,
	SESSIONS_LOGGED_OFF_MAX	VARCHAR(256)	 NOT NULL,
	SESSIONS_TIMED_OUT_MIN	VARCHAR(256)	 NOT NULL,
	SESSIONS_TIMED_OUT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinSessionTest_THRESH ADD constraint PK_WinSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WinSessionTest_THRESH ON WinSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinAccessTest;
CREATE TABLE WinAccessTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	BLOCKING_REQ_REJECTS decimal(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_ST varchar(32) NOT NULL,
	PERMISSION_ERRORS decimal(20,4) NOT NULL,
	PERMISSION_ERRORS_ST varchar(32) NOT NULL,
	FILE_ACCESS_DENIED decimal(20,4) NOT NULL,
	FILE_ACCESS_DENIED_ST varchar(32) NOT NULL,
	INTERNAL_SERVER_ERRORS decimal(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_ST varchar(32) NOT NULL,
	DATA_RCVD_RATE DECIMAL(20,4) NOT NULL,
	DATA_RCVD_RATE_ST varchar(32) NOT NULL,
	DATA_XMIT_RATE DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar(32) NOT NULL,
	RESOURCE_SHORT decimal(20,4) NOT NULL,
	RESOURCE_SHORT_ST varchar(32) NOT NULL,
	RESP_TIME DECIMAL(20,4) NOT NULL,
	RESP_TIME_ST varchar(32) NOT NULL);

ALTER TABLE WinAccessTest ADD constraint PK_WinAccessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinAccessTest ON WinAccessTest
(
	 MSMT_TIME
);
DROP TABLE WinAccessTest_TREND;
CREATE TABLE WinAccessTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	BLOCKING_REQ_REJECTS_MIN decimal(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_MAX decimal(20,4) NOT NULL,
	BLOCKING_REQ_REJECTS_STCNT varchar(32) NOT NULL,
	PERMISSION_ERRORS_MIN decimal(20,4) NOT NULL,
	PERMISSION_ERRORS_MAX decimal(20,4) NOT NULL,
	PERMISSION_ERRORS_STCNT varchar(32) NOT NULL,
	FILE_ACCESS_DENIED_MIN decimal(20,4) NOT NULL,
	FILE_ACCESS_DENIED_MAX decimal(20,4) NOT NULL,
	FILE_ACCESS_DENIED_STCNT varchar(32) NOT NULL,
	INTERNAL_SERVER_ERRORS_MIN decimal(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_MAX decimal(20,4) NOT NULL,
	INTERNAL_SERVER_ERRORS_STCNT varchar(32) NOT NULL,
	DATA_RCVD_RATE_MIN DECIMAL(20,4) NOT NULL,
	DATA_RCVD_RATE_MAX DECIMAL(20,4) NOT NULL,
	DATA_RCVD_RATE_STCNT varchar(32) NOT NULL,
	DATA_XMIT_RATE_MIN DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar(32) NOT NULL,
	RESOURCE_SHORT_MIN decimal(20,4) NOT NULL,
	RESOURCE_SHORT_MAX decimal(20,4) NOT NULL,
	RESOURCE_SHORT_STCNT varchar(32) NOT NULL,
	RESP_TIME_MIN DECIMAL(20,4) NOT NULL,
	RESP_TIME_MAX DECIMAL(20,4) NOT NULL,
	RESP_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE WinAccessTest_TREND ADD constraint PK_WinAccessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinAccessTest_THRESH;
CREATE TABLE WinAccessTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL
	,MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	BLOCKING_REQ_REJECTS_MIN	VARCHAR(256)	 NOT NULL,
	BLOCKING_REQ_REJECTS_MAX	VARCHAR(256)	 NOT NULL,
	PERMISSION_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	PERMISSION_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	FILE_ACCESS_DENIED_MIN	VARCHAR(256)	 NOT NULL,
	FILE_ACCESS_DENIED_MAX	VARCHAR(256)	 NOT NULL,
	INTERNAL_SERVER_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
	INTERNAL_SERVER_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
	DATA_RCVD_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_RCVD_RATE_MAX	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	RESOURCE_SHORT_MIN	VARCHAR(256)	 NOT NULL,
	RESOURCE_SHORT_MAX	VARCHAR(256)	 NOT NULL,
	RESP_TIME_MIN	VARCHAR(256)	 NOT NULL,
	RESP_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinAccessTest_THRESH ADD constraint PK_WinAccessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinAccessTest_THRESH ON WinAccessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinDnsTest;

CREATE TABLE WinDnsTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	TOTAL_QUERIES DECIMAL(20,4) NOT NULL,
	TOTAL_QUERIES_ST varchar(32) NOT NULL,
	TOTAL_RESPONSES DECIMAL(20,4) NOT NULL,
	TOTAL_RESPONSES_ST varchar(32) NOT NULL,
	RECURSIVE_QUERIES DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERIES_ST varchar(32) NOT NULL,
	RECURSIVE_QUERY_FAILURES DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_ST varchar(32) NOT NULL,
	RECURSIVE_TIMEOUTS DECIMAL(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_ST varchar(32) NOT NULL,
	ZONE_XFERS_RCVD decimal(20,4) NOT NULL,
	ZONE_XFERS_RCVD_ST varchar(32) NOT NULL,
	ZONE_XFERS_FAILED decimal(20,4) NOT NULL,
	ZONE_XFERS_FAILED_ST varchar(32) NOT NULL);

ALTER TABLE WinDnsTest ADD constraint PK_WinDnsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinDnsTest ON WinDnsTest
(
	 MSMT_TIME
);
DROP TABLE WinDnsTest_TREND;

CREATE TABLE WinDnsTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	TOTAL_QUERIES_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_QUERIES_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_QUERIES_STCNT varchar(32) NOT NULL,
	TOTAL_RESPONSES_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_RESPONSES_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_RESPONSES_STCNT varchar(32) NOT NULL,
	RECURSIVE_QUERIES_MIN DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERIES_MAX DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERIES_STCNT varchar(32) NOT NULL,
	RECURSIVE_QUERY_FAILURES_MIN DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_MAX DECIMAL(20,4) NOT NULL,
	RECURSIVE_QUERY_FAILURES_STCNT varchar(32) NOT NULL,
	RECURSIVE_TIMEOUTS_MIN DECIMAL(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_MAX DECIMAL(20,4) NOT NULL,
	RECURSIVE_TIMEOUTS_STCNT varchar(32) NOT NULL,
	ZONE_XFERS_RCVD_MIN decimal(20,4) NOT NULL,
	ZONE_XFERS_RCVD_MAX decimal(20,4) NOT NULL,
	ZONE_XFERS_RCVD_STCNT varchar(32) NOT NULL,
	ZONE_XFERS_FAILED_MIN decimal(20,4) NOT NULL,
	ZONE_XFERS_FAILED_MAX decimal(20,4) NOT NULL,
	ZONE_XFERS_FAILED_STCNT varchar(32) NOT NULL);

ALTER TABLE WinDnsTest_TREND ADD constraint PK_WinDnsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinDnsTest_THRESH;

CREATE TABLE WinDnsTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL
	,MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	TOTAL_QUERIES_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_QUERIES_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_RESPONSES_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_RESPONSES_MAX	VARCHAR(256)	 NOT NULL,
	RECURSIVE_QUERIES_MIN	VARCHAR(256)	 NOT NULL,
	RECURSIVE_QUERIES_MAX	VARCHAR(256)	 NOT NULL,
	RECURSIVE_QUERY_FAILURES_MIN	VARCHAR(256)	 NOT NULL,
	RECURSIVE_QUERY_FAILURES_MAX	VARCHAR(256)	 NOT NULL,
	RECURSIVE_TIMEOUTS_MIN	VARCHAR(256)	 NOT NULL,
	RECURSIVE_TIMEOUTS_MAX	VARCHAR(256)	 NOT NULL,
	ZONE_XFERS_RCVD_MIN	VARCHAR(256)	 NOT NULL,
	ZONE_XFERS_RCVD_MAX	VARCHAR(256)	 NOT NULL,
	ZONE_XFERS_FAILED_MIN	VARCHAR(256)	 NOT NULL,
	ZONE_XFERS_FAILED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinDnsTest_THRESH ADD constraint PK_WinDnsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WinDnsTest_THRESH ON WinDnsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxLicenseTest;

CREATE TABLE CtxLicenseTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	POOL_LICENSES_IN_USE decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_ST varchar(32) NOT NULL);

ALTER TABLE CtxLicenseTest ADD constraint PK_CtxLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxLicenseTest ON CtxLicenseTest
(
	 MSMT_TIME
);
DROP TABLE CtxLicenseTest_TREND;

CREATE TABLE CtxLicenseTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	POOL_LICENSES_IN_USE_MIN decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_MAX decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_MIN decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_MAX decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxLicenseTest_TREND ADD constraint PK_CtxLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxLicenseTest_THRESH;

CREATE TABLE CtxLicenseTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	POOL_LICENSES_IN_USE_MIN	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_IN_USE_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxLicenseTest_THRESH ADD constraint PK_CtxLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxLicenseTest_THRESH ON CtxLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAuthTest;

CREATE TABLE CtxAuthTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST varchar(32) NOT NULL,
	RESPONSE_TIME DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE CtxAuthTest ADD constraint PK_CtxAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxAuthTest ON CtxAuthTest
(
	 MSMT_TIME
);

DROP TABLE CtxAuthTest_TREND;

CREATE TABLE CtxAuthTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar(32) NOT NULL,
	RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxAuthTest_TREND ADD constraint PK_CtxAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxAuthTest_THRESH;

CREATE TABLE CtxAuthTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxAuthTest_THRESH ADD constraint PK_CtxAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CtxAuthTest_THRESH ON CtxAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxConnectionTest;

CREATE TABLE CtxConnectionTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST varchar(32) NOT NULL,
	PKT_LOSS_PCT DECIMAL(20,4) NOT NULL,
	PKT_LOSS_PCT_ST varchar(32) NOT NULL,
	AVG_RESPONSE_TIME DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_ST varchar(32) NOT NULL,
	MAX_RESPONSE_TIME DECIMAL(20,4) NOT NULL,
	MAX_RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE CtxConnectionTest ADD constraint PK_CtxConnectionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_CtxConnectionTest ON CtxConnectionTest (MSMT_TIME) INCLUDE (AVAILABILITY,PKT_LOSS_PCT);

DROP TABLE CtxConnectionTest_TREND;

CREATE TABLE CtxConnectionTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar(32) NOT NULL,
	PKT_LOSS_PCT_MIN DECIMAL(20,4) NOT NULL,
	PKT_LOSS_PCT_MAX DECIMAL(20,4) NOT NULL,
	PKT_LOSS_PCT_STCNT varchar(32) NOT NULL,
	AVG_RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_STCNT varchar(32) NOT NULL,
	MAX_RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
	MAX_RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
	MAX_RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxConnectionTest_TREND ADD constraint PK_CtxConnectionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE CtxConnectionTest_THRESH;

CREATE TABLE CtxConnectionTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	PKT_LOSS_PCT_MIN	VARCHAR(256)	 NOT NULL,
	PKT_LOSS_PCT_MAX	VARCHAR(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL,
	MAX_RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
	MAX_RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxConnectionTest_THRESH ADD constraint PK_CtxConnectionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_CtxConnectionTest_THRESH ON CtxConnectionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinAuthTest;

CREATE TABLE WinAuthTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	AVAILABILITY DECIMAL(20,4) NOT NULL,
	AVAILABILITY_ST varchar(32) NOT NULL,
	RESPONSE_TIME DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE WinAuthTest ADD constraint PK_WinAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinAuthTest ON WinAuthTest
(
	 MSMT_TIME
);
DROP TABLE WinAuthTest_TREND;

CREATE TABLE WinAuthTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
	AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
	AVAILABILITY_STCNT varchar(32) NOT NULL,
	RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
	RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE WinAuthTest_TREND ADD constraint PK_WinAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE WinAuthTest_THRESH;

CREATE TABLE WinAuthTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
	RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinAuthTest_THRESH ADD constraint PK_WinAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_WinAuthTest_THRESH ON WinAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxFarmLicenseTest;
CREATE TABLE CtxFarmLicenseTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	POOL_LICENSES_IN_USE decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_ST varchar(32) NOT NULL,
	POOL_LICENSES_AVAILABLE decimal(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_ST varchar(32) NOT NULL,
	POOL_LICENSES_USAGE DECIMAL(20,4) NOT NULL,
	POOL_LICENSES_USAGE_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_ST varchar(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_ST varchar(32) NOT NULL);

ALTER TABLE CtxFarmLicenseTest ADD constraint PK_CtxFarmLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxFarmLicenseTest ON CtxFarmLicenseTest
(
	 MSMT_TIME
);
DROP TABLE CtxFarmLicenseTest_TREND;

CREATE TABLE CtxFarmLicenseTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	POOL_LICENSES_IN_USE_MIN decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_MAX decimal(20,4) NOT NULL,
	POOL_LICENSES_IN_USE_STCNT varchar(32) NOT NULL,
	POOL_LICENSES_AVAILABLE_MIN decimal(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_MAX decimal(20,4) NOT NULL,
	POOL_LICENSES_AVAILABLE_STCNT varchar(32) NOT NULL,
	POOL_LICENSES_USAGE_MIN DECIMAL(20,4) NOT NULL,
	POOL_LICENSES_USAGE_MAX DECIMAL(20,4) NOT NULL,
	POOL_LICENSES_USAGE_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_MIN decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_MAX decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX decimal(20,4) NOT NULL,
	ASSIGNED_LICENSES_IN_USE_STCNT varchar(32) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX DECIMAL(20,4) NOT NULL,
	ASSIGNED_LICENSES_USAGE_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxFarmLicenseTest_TREND ADD constraint PK_CtxFarmLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxFarmLicenseTest_THRESH;
CREATE TABLE CtxFarmLicenseTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	POOL_LICENSES_IN_USE_MIN	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_IN_USE_MAX	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_AVAILABLE_MIN	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_AVAILABLE_MAX	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_USAGE_MIN	VARCHAR(256)	 NOT NULL,
	POOL_LICENSES_USAGE_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_IN_USE_MAX	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MIN	VARCHAR(256)	 NOT NULL,
	ASSIGNED_LICENSES_USAGE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxFarmLicenseTest_THRESH ADD constraint PK_CtxFarmLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxFarmLicenseTest_THRESH ON CtxFarmLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxSrvrTest;
CREATE TABLE CtxSrvrTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	DATA_COLLECTION_ENABLED decimal(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_ST varchar(32) NOT NULL,
	SERVER_AVAILABILITY decimal(20,4) NOT NULL,
	SERVER_AVAILABILITY_ST varchar(32) NOT NULL,
	SERVER_LOAD decimal(20,4) NOT NULL,
	SERVER_LOAD_ST varchar(32) NOT NULL);

ALTER TABLE CtxSrvrTest ADD constraint PK_CtxSrvrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxSrvrTest ON CtxSrvrTest
(
	 MSMT_TIME
);
DROP TABLE CtxSrvrTest_TREND;
CREATE TABLE CtxSrvrTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	DATA_COLLECTION_ENABLED_MIN decimal(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_MAX decimal(20,4) NOT NULL,
	DATA_COLLECTION_ENABLED_STCNT varchar(32) NOT NULL,
	SERVER_AVAILABILITY_MIN decimal(20,4) NOT NULL,
	SERVER_AVAILABILITY_MAX decimal(20,4) NOT NULL,
	SERVER_AVAILABILITY_STCNT varchar(32) NOT NULL,
	SERVER_LOAD_MIN decimal(20,4) NOT NULL,
	SERVER_LOAD_MAX decimal(20,4) NOT NULL,
	SERVER_LOAD_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxSrvrTest_TREND ADD constraint PK_CtxSrvrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxSrvrTest_THRESH;
CREATE TABLE CtxSrvrTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	DATA_COLLECTION_ENABLED_MIN	VARCHAR(256)	 NOT NULL,
	DATA_COLLECTION_ENABLED_MAX	VARCHAR(256)	 NOT NULL,
	SERVER_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
	SERVER_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
	SERVER_LOAD_MIN	VARCHAR(256)	 NOT NULL,
	SERVER_LOAD_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxSrvrTest_THRESH ADD constraint PK_CtxSrvrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxSrvrTest_THRESH ON CtxSrvrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraCursorTest;
CREATE TABLE OraCursorTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	CURRENT_OPEN_CURSORS decimal(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_ST varchar(32) NOT NULL,
	PCT_OPEN_CURSORS DECIMAL(20,4) NOT NULL,
	PCT_OPEN_CURSORS_ST varchar(32) NOT NULL);

ALTER TABLE OraCursorTest ADD constraint PK_OraCursorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraCursorTest ON OraCursorTest
(
	 MSMT_TIME
);
DROP TABLE OraCursorTest_TREND;
CREATE TABLE OraCursorTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	CURRENT_OPEN_CURSORS_MIN decimal(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_MAX decimal(20,4) NOT NULL,
	CURRENT_OPEN_CURSORS_STCNT varchar(32) NOT NULL,
	PCT_OPEN_CURSORS_MIN DECIMAL(20,4) NOT NULL,
	PCT_OPEN_CURSORS_MAX DECIMAL(20,4) NOT NULL,
	PCT_OPEN_CURSORS_STCNT varchar(32) NOT NULL);

ALTER TABLE OraCursorTest_TREND ADD constraint PK_OraCursorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraCursorTest_THRESH;
CREATE TABLE OraCursorTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	CURRENT_OPEN_CURSORS_MIN	VARCHAR(256)	 NOT NULL,
	CURRENT_OPEN_CURSORS_MAX	VARCHAR(256)	 NOT NULL,
	PCT_OPEN_CURSORS_MIN	VARCHAR(256)	 NOT NULL,
	PCT_OPEN_CURSORS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE OraCursorTest_THRESH ADD constraint PK_OraCursorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraCursorTest_THRESH ON OraCursorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraLatchTest;
CREATE TABLE OraLatchTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	WILLING_TO_WAIT_MISSES DECIMAL(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_ST varchar(32) NOT NULL,
	IMMEDIATE_MISSES DECIMAL(20,4) NOT NULL,
	IMMEDIATE_MISSES_ST varchar(32) NOT NULL);

ALTER TABLE OraLatchTest ADD constraint PK_OraLatchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraLatchTest ON OraLatchTest
(
	 MSMT_TIME
);
DROP TABLE OraLatchTest_TREND;
CREATE TABLE OraLatchTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	WILLING_TO_WAIT_MISSES_MIN DECIMAL(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_MAX DECIMAL(20,4) NOT NULL,
	WILLING_TO_WAIT_MISSES_STCNT varchar(32) NOT NULL,
	IMMEDIATE_MISSES_MIN DECIMAL(20,4) NOT NULL,
	IMMEDIATE_MISSES_MAX DECIMAL(20,4) NOT NULL,
	IMMEDIATE_MISSES_STCNT varchar(32) NOT NULL);

ALTER TABLE OraLatchTest_TREND ADD constraint PK_OraLatchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraLatchTest_THRESH;
CREATE TABLE OraLatchTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	WILLING_TO_WAIT_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	WILLING_TO_WAIT_MISSES_MAX	VARCHAR(256)	 NOT NULL,
	IMMEDIATE_MISSES_MIN	VARCHAR(256)	 NOT NULL,
	IMMEDIATE_MISSES_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE OraLatchTest_THRESH ADD constraint PK_OraLatchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraLatchTest_THRESH ON OraLatchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraScanTest;
CREATE TABLE OraScanTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	PCT_LONG_TABLE_SCANS DECIMAL(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_ST varchar(32) NOT NULL,
	LONG_TABLE_SCANS decimal(20,4) NOT NULL,
	LONG_TABLE_SCANS_ST varchar(32) NOT NULL,
	SHORT_TABLE_SCANS decimal(20,4) NOT NULL,
	SHORT_TABLE_SCANS_ST varchar(32) NOT NULL,
	FULL_TABLE_SCANS decimal(20,4) NOT NULL,
	FULL_TABLE_SCANS_ST varchar(32) NOT NULL);
ALTER TABLE OraScanTest ADD constraint PK_OraScanTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraScanTest ON OraScanTest
(
	 MSMT_TIME
);
DROP TABLE OraScanTest_TREND;
CREATE TABLE OraScanTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	PCT_LONG_TABLE_SCANS_MIN DECIMAL(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_MAX DECIMAL(20,4) NOT NULL,
	PCT_LONG_TABLE_SCANS_STCNT varchar(32) NOT NULL,
	LONG_TABLE_SCANS_MIN decimal(20,4) NOT NULL,
	LONG_TABLE_SCANS_MAX decimal(20,4) NOT NULL,
	LONG_TABLE_SCANS_STCNT varchar(32) NOT NULL,
	SHORT_TABLE_SCANS_MIN decimal(20,4) NOT NULL,
	SHORT_TABLE_SCANS_MAX decimal(20,4) NOT NULL,
	SHORT_TABLE_SCANS_STCNT varchar(32) NOT NULL,
	FULL_TABLE_SCANS_MIN decimal(20,4) NOT NULL,
	FULL_TABLE_SCANS_MAX decimal(20,4) NOT NULL,
	FULL_TABLE_SCANS_STCNT varchar(32) NOT NULL);
ALTER TABLE OraScanTest_TREND ADD constraint PK_OraScanTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraScanTest_THRESH;
CREATE TABLE OraScanTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	PCT_LONG_TABLE_SCANS_MIN	VARCHAR(256)	 NOT NULL,
	PCT_LONG_TABLE_SCANS_MAX	VARCHAR(256)	 NOT NULL,
	LONG_TABLE_SCANS_MIN	VARCHAR(256)	 NOT NULL,
	LONG_TABLE_SCANS_MAX	VARCHAR(256)	 NOT NULL,
	SHORT_TABLE_SCANS_MIN	VARCHAR(256)	 NOT NULL,
	SHORT_TABLE_SCANS_MAX	VARCHAR(256)	 NOT NULL,
	FULL_TABLE_SCANS_MIN	VARCHAR(256)	 NOT NULL,
	FULL_TABLE_SCANS_MAX	VARCHAR(256)	 NOT NULL);
ALTER TABLE OraScanTest_THRESH ADD constraint PK_OraScanTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraScanTest_THRESH ON OraScanTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraTransTest;
CREATE TABLE OraTransTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	USER_COMMITS decimal(20,4) NOT NULL,
	USER_COMMITS_ST varchar(32) NOT NULL,
	USER_ROLLBACKS decimal(20,4) NOT NULL,
	USER_ROLLBACKS_ST varchar(32) NOT NULL,
	PCT_ROLLBACKS DECIMAL(20,4) NOT NULL,
	PCT_ROLLBACKS_ST varchar(32) NOT NULL);

ALTER TABLE OraTransTest ADD constraint PK_OraTransTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraTransTest ON OraTransTest
(
	 MSMT_TIME
);
DROP TABLE OraTransTest_TREND;
CREATE TABLE OraTransTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	USER_COMMITS_MIN decimal(20,4) NOT NULL,
	USER_COMMITS_MAX decimal(20,4) NOT NULL,
	USER_COMMITS_STCNT varchar(32) NOT NULL,
	USER_ROLLBACKS_MIN decimal(20,4) NOT NULL,
	USER_ROLLBACKS_MAX decimal(20,4) NOT NULL,
	USER_ROLLBACKS_STCNT varchar(32) NOT NULL,
	PCT_ROLLBACKS_MIN DECIMAL(20,4) NOT NULL,
	PCT_ROLLBACKS_MAX DECIMAL(20,4) NOT NULL,
	PCT_ROLLBACKS_STCNT varchar(32) NOT NULL);

ALTER TABLE OraTransTest_TREND ADD constraint PK_OraTransTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraTransTest_THRESH;
CREATE TABLE OraTransTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	USER_COMMITS_MIN	VARCHAR(256)	 NOT NULL,
	USER_COMMITS_MAX	VARCHAR(256)	 NOT NULL,
	USER_ROLLBACKS_MIN	VARCHAR(256)	 NOT NULL,
	USER_ROLLBACKS_MAX	VARCHAR(256)	 NOT NULL,
	PCT_ROLLBACKS_MIN	VARCHAR(256)	 NOT NULL,
	PCT_ROLLBACKS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE OraTransTest_THRESH ADD constraint PK_OraTransTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraTransTest_THRESH ON OraTransTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE CtxAppLoadTest;
CREATE TABLE CtxAppLoadTest(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
NORMAL DECIMAL(20,4) NOT NULL,
NORMAL_ST varchar(32) NOT NULL,
OVERLOAD DECIMAL(20,4) NOT NULL,
OVERLOAD_ST varchar(32) NOT NULL,
OUT_OF_LICENSE DECIMAL(20,4) NOT NULL,
OUT_OF_LICENSE_ST varchar(32) NOT NULL,
DISABLED DECIMAL(20,4) NOT NULL,
DISABLED_ST varchar(32) NOT NULL);

ALTER TABLE CtxAppLoadTest ADD constraint PK_CtxAppLoadTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_CtxAppLoadTest ON CtxAppLoadTest
(
	 MSMT_TIME
);
DROP TABLE CtxAppLoadTest_TREND;
CREATE TABLE CtxAppLoadTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NORMAL_MIN DECIMAL(20,4) NOT NULL,
NORMAL_MAX DECIMAL(20,4) NOT NULL,
NORMAL_STCNT varchar(32) NOT NULL,
OVERLOAD_MIN DECIMAL(20,4) NOT NULL,
OVERLOAD_MAX DECIMAL(20,4) NOT NULL,
OVERLOAD_STCNT varchar(32) NOT NULL,
OUT_OF_LICENSE_MIN DECIMAL(20,4) NOT NULL,
OUT_OF_LICENSE_MAX DECIMAL(20,4) NOT NULL,
OUT_OF_LICENSE_STCNT varchar(32) NOT NULL,
DISABLED_MIN DECIMAL(20,4) NOT NULL,
DISABLED_MAX DECIMAL(20,4) NOT NULL,
DISABLED_STCNT varchar(32) NOT NULL);

ALTER TABLE CtxAppLoadTest_TREND ADD constraint PK_CtxAppLoadTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CtxAppLoadTest_THRESH;
CREATE TABLE CtxAppLoadTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL
,MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NORMAL_MIN	VARCHAR(256)	 NOT NULL,
NORMAL_MAX	VARCHAR(256)	 NOT NULL,
OVERLOAD_MIN	VARCHAR(256)	 NOT NULL,
OVERLOAD_MAX	VARCHAR(256)	 NOT NULL,
OUT_OF_LICENSE_MIN	VARCHAR(256)	 NOT NULL,
OUT_OF_LICENSE_MAX	VARCHAR(256)	 NOT NULL,
DISABLED_MIN	VARCHAR(256)	 NOT NULL,
DISABLED_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE CtxAppLoadTest_THRESH ADD constraint PK_CtxAppLoadTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CtxAppLoadTest_THRESH ON CtxAppLoadTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE OraObjTest;
CREATE TABLE OraObjTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	INVALID_OBJECTS decimal(20,4) NOT NULL,
	INVALID_OBJECTS_ST varchar(32) NOT NULL,
	MODIFIED_OBJECTS decimal(20,4) NOT NULL,
	MODIFIED_OBJECTS_ST varchar(32) NOT NULL);

ALTER TABLE OraObjTest ADD constraint PK_OraObjTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_OraObjTest ON OraObjTest
(
	 MSMT_TIME
);
DROP TABLE OraObjTest_TREND;
CREATE TABLE OraObjTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	INVALID_OBJECTS_MIN decimal(20,4) NOT NULL,
	INVALID_OBJECTS_MAX decimal(20,4) NOT NULL,
	INVALID_OBJECTS_STCNT varchar(32) NOT NULL,
	MODIFIED_OBJECTS_MIN decimal(20,4) NOT NULL,
	MODIFIED_OBJECTS_MAX decimal(20,4) NOT NULL,
	MODIFIED_OBJECTS_STCNT varchar(32) NOT NULL);

ALTER TABLE OraObjTest_TREND ADD constraint PK_OraObjTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraObjTest_THRESH;
CREATE TABLE OraObjTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	INVALID_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	INVALID_OBJECTS_MAX	VARCHAR(256)	 NOT NULL,
	MODIFIED_OBJECTS_MIN	VARCHAR(256)	 NOT NULL,
	MODIFIED_OBJECTS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE OraObjTest_THRESH ADD constraint PK_OraObjTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraObjTest_THRESH ON OraObjTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlAccessTest;
CREATE TABLE MsSqlAccessTest(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
FULL_SCAN_RATE			DECIMAL(20,4) NOT NULL,
FULL_SCAN_RATE_ST		VARCHAR(32) NOT NULL,
PAGE_SPLIT_RATE			DECIMAL(20,4) NOT NULL,
PAGE_SPLIT_RATE_ST		VARCHAR(32) NOT NULL,
SQL_COMPILATION_RATE		DECIMAL(20,4) NOT NULL,
SQL_COMPILATION_RATE_ST		VARCHAR(32) NOT NULL,
SQL_RECOMPILATION_RATE		DECIMAL(20,4) NOT NULL,
SQL_RECOMPILATION_RATE_ST	VARCHAR(32) NOT NULL,
BATCH_REQUEST_RATE		DECIMAL(20,4) NOT NULL,
BATCH_REQUEST_RATE_ST		VARCHAR(32) NOT NULL,
WORKFILES_RATE			DECIMAL(20,4) NOT NULL,
WORKFILES_RATE_ST		VARCHAR(32) NOT NULL,
WORKTABLES_RATE			DECIMAL(20,4) NOT NULL,
WORKTABLES_RATE_ST		VARCHAR(32) NOT NULL,
WORKTABLES_RATIO		DECIMAL(20,4) NOT NULL,
WORKTABLES_RATIO_ST	VARCHAR(32) NOT NULL,
FREESPACE_SCAN_RATE		DECIMAL(20,4) NOT NULL,
FREESPACE_SCAN_RATE_ST		VARCHAR(32) NOT NULL,
SQL_ATTENTION_RATE		DECIMAL(20,4) NOT NULL,
SQL_ATTENTION_RATE_ST		VARCHAR(32) NOT NULL);

CREATE INDEX IDX_MsSqlAccessTest ON MsSqlAccessTest(MSMT_TIME);
ALTER TABLE MsSqlAccessTest ADD constraint PK_MsSqlAccessTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlAccessTest_TREND;
CREATE TABLE MsSqlAccessTest_TREND(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL,
MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	VARCHAR(32) NOT NULL,
FULL_SCAN_RATE_MIN		DECIMAL(20,4) NOT NULL,
FULL_SCAN_RATE_MAX		DECIMAL(20,4) NOT NULL,
FULL_SCAN_RATE_STCNT		VARCHAR(32) NOT NULL,
PAGE_SPLIT_RATE_MIN		DECIMAL(20,4) NOT NULL,
PAGE_SPLIT_RATE_MAX		DECIMAL(20,4) NOT NULL,
PAGE_SPLIT_RATE_STCNT		VARCHAR(32) NOT NULL,
SQL_COMPILATION_RATE_MIN	DECIMAL(20,4) NOT NULL,
SQL_COMPILATION_RATE_MAX	DECIMAL(20,4) NOT NULL,
SQL_COMPILATION_RATE_STCNT	VARCHAR(32) NOT NULL,
SQL_RECOMPILATION_RATE_MIN	DECIMAL(20,4) NOT NULL,
SQL_RECOMPILATION_RATE_MAX	DECIMAL(20,4) NOT NULL,
SQL_RECOMPILATION_RATE_STCNT	VARCHAR(32) NOT NULL,
BATCH_REQUEST_RATE_MIN		DECIMAL(20,4) NOT NULL,
BATCH_REQUEST_RATE_MAX		DECIMAL(20,4) NOT NULL,
BATCH_REQUEST_RATE_STCNT	VARCHAR(32) NOT NULL,
WORKFILES_RATE_MIN		DECIMAL(20,4) NOT NULL,
WORKFILES_RATE_MAX		DECIMAL(20,4) NOT NULL,
WORKFILES_RATE_STCNT		VARCHAR(32) NOT NULL,
WORKTABLES_RATE_MIN		DECIMAL(20,4) NOT NULL,
WORKTABLES_RATE_MAX		DECIMAL(20,4) NOT NULL,
WORKTABLES_RATE_STCNT		VARCHAR(32) NOT NULL,
WORKTABLES_RATIO_MIN	DECIMAL(20,4) NOT NULL,
WORKTABLES_RATIO_MAX	DECIMAL(20,4) NOT NULL,
WORKTABLES_RATIO_STCNT	VARCHAR(32) NOT NULL,
FREESPACE_SCAN_RATE_MIN		DECIMAL(20,4) NOT NULL,
FREESPACE_SCAN_RATE_MAX		DECIMAL(20,4) NOT NULL,
FREESPACE_SCAN_RATE_STCNT	VARCHAR(32) NOT NULL,
SQL_ATTENTION_RATE_MIN		DECIMAL(20,4) NOT NULL,
SQL_ATTENTION_RATE_MAX		DECIMAL(20,4) NOT NULL,
SQL_ATTENTION_RATE_STCNT	VARCHAR(32) NOT NULL);

ALTER TABLE MsSqlAccessTest_TREND ADD constraint PK_MsSqlAccessTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlAccessTest_THRESH;
CREATE TABLE MsSqlAccessTest_THRESH(
TRGT_HOST       VARCHAR(32) NOT NULL,
PORT_NO         VARCHAR(32) NOT NULL,
SITE_NAME       VARCHAR(64) NOT NULL,
INFO            VARCHAR(128) NOT NULL
,MSMT_HOST       VARCHAR(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
FULL_SCAN_RATE_MIN		VARCHAR(256) NOT NULL,
FULL_SCAN_RATE_MAX		VARCHAR(256) NOT NULL,
PAGE_SPLIT_RATE_MIN		VARCHAR(256) NOT NULL,
PAGE_SPLIT_RATE_MAX		VARCHAR(256) NOT NULL,
SQL_COMPILATION_RATE_MIN	VARCHAR(256) NOT NULL,
SQL_COMPILATION_RATE_MAX	VARCHAR(256) NOT NULL,
SQL_RECOMPILATION_RATE_MIN	VARCHAR(256) NOT NULL,
SQL_RECOMPILATION_RATE_MAX	VARCHAR(256) NOT NULL,
BATCH_REQUEST_RATE_MIN		VARCHAR(256) NOT NULL,
BATCH_REQUEST_RATE_MAX		VARCHAR(256) NOT NULL,
WORKFILES_RATE_MIN		VARCHAR(256) NOT NULL,
WORKFILES_RATE_MAX		VARCHAR(256) NOT NULL,
WORKTABLES_RATE_MIN		VARCHAR(256) NOT NULL,
WORKTABLES_RATE_MAX		VARCHAR(256) NOT NULL,
WORKTABLES_RATIO_MIN	VARCHAR(256) NOT NULL,
WORKTABLES_RATIO_MAX	VARCHAR(256) NOT NULL,
FREESPACE_SCAN_RATE_MIN		VARCHAR(256) NOT NULL,
FREESPACE_SCAN_RATE_MAX		VARCHAR(256) NOT NULL,
SQL_ATTENTION_RATE_MIN		VARCHAR(256) NOT NULL,
SQL_ATTENTION_RATE_MAX		VARCHAR(256) NOT NULL);

ALTER TABLE MsSqlAccessTest_THRESH ADD constraint PK_MsSqlAccessTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlAccessTest_THRESH ON MsSqlAccessTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlLatchTest;
CREATE TABLE MsSqlLatchTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	LATCH_WAIT_RATE DECIMAL(20,4) NOT NULL,
	LATCH_WAIT_RATE_ST varchar(32) NOT NULL,
	TOTAL_WAIT_TIME DECIMAL(20,4) NOT NULL,
	TOTAL_WAIT_TIME_ST varchar(32) NOT NULL);

ALTER TABLE MsSqlLatchTest ADD constraint PK_MsSqlLatchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsSqlLatchTest ON MsSqlLatchTest
(
	 MSMT_TIME
);
DROP TABLE MsSqlLatchTest_TREND;
CREATE TABLE MsSqlLatchTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	LATCH_WAIT_RATE_MIN DECIMAL(20,4) NOT NULL,
	LATCH_WAIT_RATE_MAX DECIMAL(20,4) NOT NULL,
	LATCH_WAIT_RATE_STCNT varchar(32) NOT NULL,
	TOTAL_WAIT_TIME_MIN DECIMAL(20,4) NOT NULL,
	TOTAL_WAIT_TIME_MAX DECIMAL(20,4) NOT NULL,
	TOTAL_WAIT_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE MsSqlLatchTest_TREND ADD constraint PK_MsSqlLatchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlLatchTest_THRESH;
CREATE TABLE MsSqlLatchTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	LATCH_WAIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	LATCH_WAIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	TOTAL_WAIT_TIME_MIN	VARCHAR(256)	 NOT NULL,
	TOTAL_WAIT_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MsSqlLatchTest_THRESH ADD constraint PK_MsSqlLatchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlLatchTest_THRESH ON MsSqlLatchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlDatabaseTest;
CREATE TABLE MsSqlDatabaseTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	ACTIVE_TRANSACTIONS		decimal(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_ST		varchar(32) NOT NULL,
	TRANSACTION_RATE		DECIMAL(20,4) NOT NULL,
	TRANSACTION_RATE_ST		varchar(32) NOT NULL,
	REPL_TRANS_RATE			DECIMAL(20,4) NOT NULL,
	REPL_TRANS_RATE_ST		varchar(32) NOT NULL,
	PENDING_REPL_TRANS		decimal(20,4) NOT NULL,
	PENDING_REPL_TRANS_ST		varchar(32) NOT NULL,
	DATA_FILE_SIZE			DECIMAL(20,4) NOT NULL,
	DATA_FILE_SIZE_ST		varchar(32) NOT NULL,
	LOG_FLUSH_WAITS			DECIMAL(20,4) NOT NULL,
	LOG_FLUSH_WAITS_ST		varchar(32) NOT NULL,
	WRITE_TRANSACTION_RATE		DECIMAL(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_ST	varchar(32) NOT NULL);

ALTER TABLE MsSqlDatabaseTest ADD constraint PK_MsSqlDatabaseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_MsSqlDatabaseTest  ON MsSqlDatabaseTest (MSMT_TIME) INCLUDE (ACTIVE_TRANSACTIONS);

DROP TABLE MsSqlDatabaseTest_TREND;
CREATE TABLE MsSqlDatabaseTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	ACTIVE_TRANSACTIONS_MIN			decimal(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_MAX			decimal(20,4) NOT NULL,
	ACTIVE_TRANSACTIONS_STCNT		varchar(32) NOT NULL,
	TRANSACTION_RATE_MIN			DECIMAL(20,4) NOT NULL,
	TRANSACTION_RATE_MAX			DECIMAL(20,4) NOT NULL,
	TRANSACTION_RATE_STCNT			varchar(32) NOT NULL,
	REPL_TRANS_RATE_MIN			DECIMAL(20,4) NOT NULL,
	REPL_TRANS_RATE_MAX			DECIMAL(20,4) NOT NULL,
	REPL_TRANS_RATE_STCNT			varchar(32) NOT NULL,
	PENDING_REPL_TRANS_MIN			decimal(20,4) NOT NULL,
	PENDING_REPL_TRANS_MAX			decimal(20,4) NOT NULL,
	PENDING_REPL_TRANS_STCNT		varchar(32) NOT NULL,
	DATA_FILE_SIZE_MIN			DECIMAL(20,4) NOT NULL,
	DATA_FILE_SIZE_MAX			DECIMAL(20,4) NOT NULL,
	DATA_FILE_SIZE_STCNT			varchar(32) NOT NULL,
	LOG_FLUSH_WAITS_MIN			DECIMAL(20,4) NOT NULL,
	LOG_FLUSH_WAITS_MAX			DECIMAL(20,4) NOT NULL,
	LOG_FLUSH_WAITS_STCNT			varchar(32) NOT NULL,
	WRITE_TRANSACTION_RATE_MIN		DECIMAL(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_MAX		DECIMAL(20,4) NOT NULL,
	WRITE_TRANSACTION_RATE_STCNT		varchar(32) NOT NULL);

ALTER TABLE MsSqlDatabaseTest_TREND ADD constraint PK_MsSqlDatabaseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlDatabaseTest_THRESH;
CREATE TABLE MsSqlDatabaseTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL
	,MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	ACTIVE_TRANSACTIONS_MIN		VARCHAR(256)	 NOT NULL,
	ACTIVE_TRANSACTIONS_MAX		VARCHAR(256)	 NOT NULL,
	TRANSACTION_RATE_MIN		VARCHAR(256)	 NOT NULL,
	TRANSACTION_RATE_MAX		VARCHAR(256)	 NOT NULL,
	REPL_TRANS_RATE_MIN		VARCHAR(256)	 NOT NULL,
	REPL_TRANS_RATE_MAX		VARCHAR(256)	 NOT NULL,
	PENDING_REPL_TRANS_MIN		VARCHAR(256)	 NOT NULL,
	PENDING_REPL_TRANS_MAX		VARCHAR(256)	 NOT NULL,
	DATA_FILE_SIZE_MIN		VARCHAR(256)	 NOT NULL,
	DATA_FILE_SIZE_MAX		VARCHAR(256)	 NOT NULL,
	LOG_FLUSH_WAITS_MIN		VARCHAR(256)	 NOT NULL,
	LOG_FLUSH_WAITS_MAX		VARCHAR(256)	 NOT NULL,
	WRITE_TRANSACTION_RATE_MIN	VARCHAR(256)	 NOT NULL,
	WRITE_TRANSACTION_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MsSqlDatabaseTest_THRESH ADD constraint PK_MsSqlDatabaseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlDatabaseTest_THRESH ON MsSqlDatabaseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlCacheTest;
CREATE TABLE MsSqlCacheTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
	CACHE_OBJECT_COUNT decimal(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_ST varchar(32) NOT NULL,
	LOG_CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_ST varchar(32) NOT NULL);

ALTER TABLE MsSqlCacheTest ADD constraint PK_MsSqlCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsSqlCacheTest ON MsSqlCacheTest
(
	 MSMT_TIME
);
DROP TABLE MsSqlCacheTest_TREND;
CREATE TABLE MsSqlCacheTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
	CACHE_OBJECT_COUNT_MIN decimal(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_MAX decimal(20,4) NOT NULL,
	CACHE_OBJECT_COUNT_STCNT varchar(32) NOT NULL,
	LOG_CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
	LOG_CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL);

ALTER TABLE MsSqlCacheTest_TREND ADD constraint PK_MsSqlCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlCacheTest_THRESH;
CREATE TABLE MsSqlCacheTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	CACHE_HIT_RATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHE_HIT_RATIO_MAX	VARCHAR(256)	 NOT NULL,
	CACHE_OBJECT_COUNT_MIN	VARCHAR(256)	 NOT NULL,
	CACHE_OBJECT_COUNT_MAX	VARCHAR(256)	 NOT NULL,
	LOG_CACHE_HIT_RATIO_MIN	VARCHAR(256)	 NOT NULL,
	LOG_CACHE_HIT_RATIO_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE MsSqlCacheTest_THRESH ADD constraint PK_MsSqlCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlCacheTest_THRESH ON MsSqlCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE MsSqlBufferMgtTest;
CREATE TABLE MsSqlBufferMgtTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	BUFFER_CACHE_HIT_RATIO		DECIMAL(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_ST	varchar(32) NOT NULL,
	PAGE_READS			DECIMAL(20,4) NOT NULL,
	PAGE_READS_ST			varchar(32) NOT NULL,
	PAGE_WRITES			DECIMAL(20,4) NOT NULL,
	PAGE_WRITES_ST			varchar(32) NOT NULL,
	TARGET_PAGES			decimal(20,4) NOT NULL,
	TARGET_PAGES_ST			varchar(32) NOT NULL,
	TOTAL_PAGES			decimal(20,4) NOT NULL,
	TOTAL_PAGES_ST			varchar(32) NOT NULL,
	FREE_PAGES			decimal(20,4) NOT NULL,
	FREE_PAGES_ST			varchar(32) NOT NULL,
	STOLEN_PAGES			decimal(20,4) NOT NULL,
	STOLEN_PAGES_ST			varchar(32) NOT NULL,
	LAZY_WRITES_RATE		decimal(20,4) NOT NULL,
	LAZY_WRITES_RATE_ST		varchar(32) NOT NULL,
	PAGE_LIFE_EXPECTANCY		decimal(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_ST		varchar(32) NOT NULL,
	FREE_LIST_STALLS		decimal(20,4) NOT NULL,
	FREE_LIST_STALLS_ST		varchar(32) NOT NULL);

ALTER TABLE MsSqlBufferMgtTest ADD constraint PK_MsSqlBufferMgtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_MsSqlBufferMgtTest ON MsSqlBufferMgtTest
(
	 MSMT_TIME
);
DROP TABLE MsSqlBufferMgtTest_TREND;
CREATE TABLE MsSqlBufferMgtTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MIN	DECIMAL(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MAX	DECIMAL(20,4) NOT NULL,
	BUFFER_CACHE_HIT_RATIO_STCNT	varchar(32) NOT NULL,
	PAGE_READS_MIN			DECIMAL(20,4) NOT NULL,
	PAGE_READS_MAX			DECIMAL(20,4) NOT NULL,
	PAGE_READS_STCNT		varchar(32) NOT NULL,
	PAGE_WRITES_MIN			DECIMAL(20,4) NOT NULL,
	PAGE_WRITES_MAX			DECIMAL(20,4) NOT NULL,
	PAGE_WRITES_STCNT		varchar(32) NOT NULL,
	TARGET_PAGES_MIN		decimal(20,4) NOT NULL,
	TARGET_PAGES_MAX		decimal(20,4) NOT NULL,
	TARGET_PAGES_STCNT		varchar(32) NOT NULL,
	TOTAL_PAGES_MIN			decimal(20,4) NOT NULL,
	TOTAL_PAGES_MAX			decimal(20,4) NOT NULL,
	TOTAL_PAGES_STCNT		varchar(32) NOT NULL,
	FREE_PAGES_MIN			decimal(20,4) NOT NULL,
	FREE_PAGES_MAX			decimal(20,4) NOT NULL,
	FREE_PAGES_STCNT		varchar(32) NOT NULL,
	STOLEN_PAGES_MIN		decimal(20,4) NOT NULL,
	STOLEN_PAGES_MAX		decimal(20,4) NOT NULL,
	STOLEN_PAGES_STCNT		varchar(32) NOT NULL,
	LAZY_WRITES_RATE_MIN		decimal(20,4) NOT NULL,
	LAZY_WRITES_RATE_MAX		decimal(20,4) NOT NULL,
	LAZY_WRITES_RATE_STCNT		varchar(32) NOT NULL,
	PAGE_LIFE_EXPECTANCY_MIN	decimal(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_MAX	decimal(20,4) NOT NULL,
	PAGE_LIFE_EXPECTANCY_STCNT	varchar(32) NOT NULL,
	FREE_LIST_STALLS_MIN		decimal(20,4) NOT NULL,
	FREE_LIST_STALLS_MAX		decimal(20,4) NOT NULL,
	FREE_LIST_STALLS_STCNT		varchar(32) NOT NULL);

ALTER TABLE MsSqlBufferMgtTest_TREND ADD constraint PK_MsSqlBufferMgtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlBufferMgtTest_THRESH;
CREATE TABLE MsSqlBufferMgtTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MIN	VARCHAR(256)	 NOT NULL,
	BUFFER_CACHE_HIT_RATIO_MAX	VARCHAR(256)	 NOT NULL,
	PAGE_READS_MIN			VARCHAR(256)	 NOT NULL,
	PAGE_READS_MAX			VARCHAR(256)	 NOT NULL,
	PAGE_WRITES_MIN			VARCHAR(256)	 NOT NULL,
	PAGE_WRITES_MAX			VARCHAR(256)	 NOT NULL,
	TARGET_PAGES_MIN		VARCHAR(256)	 NOT NULL,
	TARGET_PAGES_MAX		VARCHAR(256)	 NOT NULL,
	TOTAL_PAGES_MIN			VARCHAR(256)	 NOT NULL,
	TOTAL_PAGES_MAX			VARCHAR(256)	 NOT NULL,
	FREE_PAGES_MIN			VARCHAR(256)	 NOT NULL,
	FREE_PAGES_MAX			VARCHAR(256)	 NOT NULL,
	STOLEN_PAGES_MIN		VARCHAR(256)	 NOT NULL,
	STOLEN_PAGES_MAX		VARCHAR(256)	 NOT NULL,
	LAZY_WRITES_RATE_MIN		VARCHAR(256)	 NOT NULL,
	LAZY_WRITES_RATE_MAX		VARCHAR(256)	 NOT NULL,
	PAGE_LIFE_EXPECTANCY_MIN	VARCHAR(256)	 NOT NULL,
	PAGE_LIFE_EXPECTANCY_MAX	VARCHAR(256)	 NOT NULL,
	FREE_LIST_STALLS_MIN		VARCHAR(256)	 NOT NULL,
	FREE_LIST_STALLS_MAX		VARCHAR(256)	 NOT NULL);

ALTER TABLE MsSqlBufferMgtTest_THRESH ADD constraint PK_MsSqlBufferMgtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlBufferMgtTest_THRESH ON MsSqlBufferMgtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iJvmTest;
CREATE TABLE O9iJvmTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
ACTIVE_THREAD_GROUPS decimal(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_ST varchar(32) NOT NULL,
ACTIVE_THREADS decimal(20,4) NOT NULL,
ACTIVE_THREADS_ST varchar(32) NOT NULL,
FREE_HEAP DECIMAL(20,4) NOT NULL,
FREE_HEAP_ST varchar(32) NOT NULL,
MIN_FREE_HEAP DECIMAL(20,4) NOT NULL,
MIN_FREE_HEAP_ST varchar(32) NOT NULL,
HEAP_USED DECIMAL(20,4) NOT NULL,
HEAP_USED_ST varchar(32) NOT NULL,
MAX_HEAP_USED DECIMAL(20,4) NOT NULL,
MAX_HEAP_USED_ST varchar(32) NOT NULL,
JVM_AVAILABILITY DECIMAL(20,4) NOT NULL,
JVM_AVAILABILITY_ST varchar(32) NOT NULL);

ALTER TABLE O9iJvmTest ADD constraint PK_O9iJvmTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iJvmTest ON O9iJvmTest
(
	 MSMT_TIME
);
DROP TABLE O9iJvmTest_TREND;
CREATE TABLE O9iJvmTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ACTIVE_THREAD_GROUPS_MIN decimal(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_MAX decimal(20,4) NOT NULL,
ACTIVE_THREAD_GROUPS_STCNT varchar(32) NOT NULL,
ACTIVE_THREADS_MIN decimal(20,4) NOT NULL,
ACTIVE_THREADS_MAX decimal(20,4) NOT NULL,
ACTIVE_THREADS_STCNT varchar(32) NOT NULL,
FREE_HEAP_MIN DECIMAL(20,4) NOT NULL,
FREE_HEAP_MAX DECIMAL(20,4) NOT NULL,
FREE_HEAP_STCNT varchar(32) NOT NULL,
MIN_FREE_HEAP_MIN DECIMAL(20,4) NOT NULL,
MIN_FREE_HEAP_MAX DECIMAL(20,4) NOT NULL,
MIN_FREE_HEAP_STCNT varchar(32) NOT NULL,
HEAP_USED_MIN DECIMAL(20,4) NOT NULL,
HEAP_USED_MAX DECIMAL(20,4) NOT NULL,
HEAP_USED_STCNT varchar(32) NOT NULL,
MAX_HEAP_USED_MIN DECIMAL(20,4) NOT NULL,
MAX_HEAP_USED_MAX DECIMAL(20,4) NOT NULL,
MAX_HEAP_USED_STCNT varchar(32) NOT NULL,
JVM_AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
JVM_AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
JVM_AVAILABILITY_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iJvmTest_TREND ADD constraint PK_O9iJvmTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iJvmTest_THRESH;
CREATE TABLE O9iJvmTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ACTIVE_THREAD_GROUPS_MIN	VARCHAR(256)	 NOT NULL,
ACTIVE_THREAD_GROUPS_MAX	VARCHAR(256)	 NOT NULL,
ACTIVE_THREADS_MIN	VARCHAR(256)	 NOT NULL,
ACTIVE_THREADS_MAX	VARCHAR(256)	 NOT NULL,
FREE_HEAP_MIN	VARCHAR(256)	 NOT NULL,
FREE_HEAP_MAX	VARCHAR(256)	 NOT NULL,
MIN_FREE_HEAP_MIN	VARCHAR(256)	 NOT NULL,
MIN_FREE_HEAP_MAX	VARCHAR(256)	 NOT NULL,
HEAP_USED_MIN	VARCHAR(256)	 NOT NULL,
HEAP_USED_MAX	VARCHAR(256)	 NOT NULL,
MAX_HEAP_USED_MIN	VARCHAR(256)	 NOT NULL,
MAX_HEAP_USED_MAX	VARCHAR(256)	 NOT NULL,
JVM_AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
JVM_AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iJvmTest_THRESH ADD constraint PK_O9iJvmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iJvmTest_THRESH ON O9iJvmTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iServletTest;
CREATE TABLE O9iServletTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
THREADS_SERVICING_SERVLT decimal(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_ST varchar(32) NOT NULL,
REQ_COMPLETED DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_ST varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar(32) NOT NULL);

ALTER TABLE O9iServletTest ADD constraint PK_O9iServletTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iServletTest ON O9iServletTest
(
	 MSMT_TIME
); 
DROP TABLE O9iServletTest_TREND;
CREATE TABLE O9iServletTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
THREADS_SERVICING_SERVLT_MIN decimal(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_MAX decimal(20,4) NOT NULL,
THREADS_SERVICING_SERVLT_STCNT varchar(32) NOT NULL,
REQ_COMPLETED_MIN DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_MAX DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iServletTest_TREND ADD constraint PK_O9iServletTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iServletTest_THRESH;
CREATE TABLE O9iServletTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
THREADS_SERVICING_SERVLT_MIN	VARCHAR(256)	 NOT NULL,
THREADS_SERVICING_SERVLT_MAX	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iServletTest_THRESH ADD constraint PK_O9iServletTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iServletTest_THRESH ON O9iServletTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iConnCacheTest;
CREATE TABLE O9iConnCacheTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
FREE_CACHE_SIZE decimal(20,4) NOT NULL,
FREE_CACHE_SIZE_ST varchar(32) NOT NULL,
CACHE_SIZE decimal(20,4) NOT NULL,
CACHE_SIZE_ST varchar(32) NOT NULL,
CACHE_HITS DECIMAL(20,4) NOT NULL,
CACHE_HITS_ST varchar(32) NOT NULL,
CACHE_MISSES DECIMAL(20,4) NOT NULL,
CACHE_MISSES_ST varchar(32) NOT NULL);

ALTER TABLE O9iConnCacheTest ADD constraint PK_O9iConnCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iConnCacheTest ON O9iConnCacheTest
(
	 MSMT_TIME
); 
DROP TABLE O9iConnCacheTest_TREND;
CREATE TABLE O9iConnCacheTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
FREE_CACHE_SIZE_MIN decimal(20,4) NOT NULL,
FREE_CACHE_SIZE_MAX decimal(20,4) NOT NULL,
FREE_CACHE_SIZE_STCNT varchar(32) NOT NULL,
CACHE_SIZE_MIN decimal(20,4) NOT NULL,
CACHE_SIZE_MAX decimal(20,4) NOT NULL,
CACHE_SIZE_STCNT varchar(32) NOT NULL,
CACHE_HITS_MIN DECIMAL(20,4) NOT NULL,
CACHE_HITS_MAX DECIMAL(20,4) NOT NULL,
CACHE_HITS_STCNT varchar(32) NOT NULL,
CACHE_MISSES_MIN DECIMAL(20,4) NOT NULL,
CACHE_MISSES_MAX DECIMAL(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iConnCacheTest_TREND ADD constraint PK_O9iConnCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iConnCacheTest_THRESH;
CREATE TABLE O9iConnCacheTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
FREE_CACHE_SIZE_MIN	VARCHAR(256)	 NOT NULL,
FREE_CACHE_SIZE_MAX	VARCHAR(256)	 NOT NULL,
CACHE_SIZE_MIN	VARCHAR(256)	 NOT NULL,
CACHE_SIZE_MAX	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MIN	VARCHAR(256)	 NOT NULL,
CACHE_HITS_MAX	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MIN	VARCHAR(256)	 NOT NULL,
CACHE_MISSES_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iConnCacheTest_THRESH ADD constraint PK_O9iConnCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iConnCacheTest_THRESH ON O9iConnCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iDriverTest;
CREATE TABLE O9iDriverTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
THREADS_CREATING_CONNS decimal(20,4) NOT NULL,
THREADS_CREATING_CONNS_ST varchar(32) NOT NULL,
AVG_CONN_CREATE_TIME DECIMAL(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_ST varchar(32) NOT NULL,
MAX_CONN_CREATE_TIME DECIMAL(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_ST varchar(32) NOT NULL,
CONNS_OPEN DECIMAL(20,4) NOT NULL,
CONNS_OPEN_ST varchar(32) NOT NULL,
CONNS_CLOSE DECIMAL(20,4) NOT NULL,
CONNS_CLOSE_ST varchar(32) NOT NULL);

ALTER TABLE O9iDriverTest ADD constraint PK_O9iDriverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iDriverTest ON O9iDriverTest
(
	 MSMT_TIME
); 
DROP TABLE O9iDriverTest_TREND;
CREATE TABLE O9iDriverTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
THREADS_CREATING_CONNS_MIN decimal(20,4) NOT NULL,
THREADS_CREATING_CONNS_MAX decimal(20,4) NOT NULL,
THREADS_CREATING_CONNS_STCNT varchar(32) NOT NULL,
AVG_CONN_CREATE_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_CONN_CREATE_TIME_STCNT varchar(32) NOT NULL,
MAX_CONN_CREATE_TIME_MIN DECIMAL(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_MAX DECIMAL(20,4) NOT NULL,
MAX_CONN_CREATE_TIME_STCNT varchar(32) NOT NULL,
CONNS_OPEN_MIN DECIMAL(20,4) NOT NULL,
CONNS_OPEN_MAX DECIMAL(20,4) NOT NULL,
CONNS_OPEN_STCNT varchar(32) NOT NULL,
CONNS_CLOSE_MIN DECIMAL(20,4) NOT NULL,
CONNS_CLOSE_MAX DECIMAL(20,4) NOT NULL,
CONNS_CLOSE_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iDriverTest_TREND ADD constraint PK_O9iDriverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iDriverTest_THRESH;
CREATE TABLE O9iDriverTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
THREADS_CREATING_CONNS_MIN	VARCHAR(256)	 NOT NULL,
THREADS_CREATING_CONNS_MAX	VARCHAR(256)	 NOT NULL,
AVG_CONN_CREATE_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_CONN_CREATE_TIME_MAX	VARCHAR(256)	 NOT NULL,
MAX_CONN_CREATE_TIME_MIN	VARCHAR(256)	 NOT NULL,
MAX_CONN_CREATE_TIME_MAX	VARCHAR(256)	 NOT NULL,
CONNS_OPEN_MIN	VARCHAR(256)	 NOT NULL,
CONNS_OPEN_MAX	VARCHAR(256)	 NOT NULL,
CONNS_CLOSE_MIN	VARCHAR(256)	 NOT NULL,
CONNS_CLOSE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iDriverTest_THRESH ADD constraint PK_O9iDriverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iDriverTest_THRESH ON O9iDriverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iTxTest;
CREATE TABLE O9iTxTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
TX_ACTIVE decimal(20,4) NOT NULL,
TX_ACTIVE_ST varchar(32) NOT NULL,
TX_COMMITS DECIMAL(20,4) NOT NULL,
TX_COMMITS_ST varchar(32) NOT NULL,
TX_ROLLBACKS DECIMAL(20,4) NOT NULL,
TX_ROLLBACKS_ST varchar(32) NOT NULL);

ALTER TABLE O9iTxTest ADD constraint PK_O9iTxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iTxTest ON O9iTxTest
(
	 MSMT_TIME
); 
DROP TABLE O9iTxTest_TREND;
CREATE TABLE O9iTxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
TX_ACTIVE_MIN decimal(20,4) NOT NULL,
TX_ACTIVE_MAX decimal(20,4) NOT NULL,
TX_ACTIVE_STCNT varchar(32) NOT NULL,
TX_COMMITS_MIN DECIMAL(20,4) NOT NULL,
TX_COMMITS_MAX DECIMAL(20,4) NOT NULL,
TX_COMMITS_STCNT varchar(32) NOT NULL,
TX_ROLLBACKS_MIN DECIMAL(20,4) NOT NULL,
TX_ROLLBACKS_MAX DECIMAL(20,4) NOT NULL,
TX_ROLLBACKS_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iTxTest_TREND ADD constraint PK_O9iTxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iTxTest_THRESH;
CREATE TABLE O9iTxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
TX_ACTIVE_MIN	VARCHAR(256)	 NOT NULL,
TX_ACTIVE_MAX	VARCHAR(256)	 NOT NULL,
TX_COMMITS_MIN	VARCHAR(256)	 NOT NULL,
TX_COMMITS_MAX	VARCHAR(256)	 NOT NULL,
TX_ROLLBACKS_MIN	VARCHAR(256)	 NOT NULL,
TX_ROLLBACKS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iTxTest_THRESH ADD constraint PK_O9iTxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iTxTest_THRESH ON O9iTxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iJspTest;
CREATE TABLE O9iJspTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
THREADS_SERVICING_JSP decimal(20,4) NOT NULL,
THREADS_SERVICING_JSP_ST varchar(32) NOT NULL,
REQ_COMPLETED DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_ST varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar(32) NOT NULL);

ALTER TABLE O9iJspTest ADD constraint PK_O9iJspTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iJspTest ON O9iJspTest
(
	 MSMT_TIME,
	 TRGT_HOST,
	 PORT_NO,
	 SITE_NAME,
	 INFO,
	 MSMT_HOST, 
THREADS_SERVICING_JSP,
THREADS_SERVICING_JSP_ST,
REQ_COMPLETED,
REQ_COMPLETED_ST,
AVG_REQ_PROCESS_TIME,
AVG_REQ_PROCESS_TIME_ST,
MAX_REQ_PROCESS_TIME,
MAX_REQ_PROCESS_TIME_ST
); 
DROP TABLE O9iJspTest_TREND;
CREATE TABLE O9iJspTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
THREADS_SERVICING_JSP_MIN decimal(20,4) NOT NULL,
THREADS_SERVICING_JSP_MAX decimal(20,4) NOT NULL,
THREADS_SERVICING_JSP_STCNT varchar(32) NOT NULL,
REQ_COMPLETED_MIN DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_MAX DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iJspTest_TREND ADD constraint PK_O9iJspTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iJspTest_THRESH;
CREATE TABLE O9iJspTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
THREADS_SERVICING_JSP_MIN	VARCHAR(256)	 NOT NULL,
THREADS_SERVICING_JSP_MAX	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iJspTest_THRESH ADD constraint PK_O9iJspTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iJspTest_THRESH ON O9iJspTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iWebCtxTest;
CREATE TABLE O9iWebCtxTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
ACTIVE_SESSIONS decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar(32) NOT NULL,
AVG_SESSION_LIFE_TIME DECIMAL(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_ST varchar(32) NOT NULL,
MAX_SERVLET_RESOLVE_TIME DECIMAL(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_ST varchar(32) NOT NULL,
AVG_SERVLET_RESOLVE_TIME DECIMAL(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE O9iWebCtxTest ADD constraint PK_O9iWebCtxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iWebCtxTest ON O9iWebCtxTest
(
	 MSMT_TIME
); 
DROP TABLE O9iWebCtxTest_TREND;
CREATE TABLE O9iWebCtxTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ACTIVE_SESSIONS_MIN decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar(32) NOT NULL,
AVG_SESSION_LIFE_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_SESSION_LIFE_TIME_STCNT varchar(32) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MIN DECIMAL(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MAX DECIMAL(20,4) NOT NULL,
MAX_SERVLET_RESOLVE_TIME_STCNT varchar(32) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_SERVLET_RESOLVE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iWebCtxTest_TREND ADD constraint PK_O9iWebCtxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iWebCtxTest_THRESH;
CREATE TABLE O9iWebCtxTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ACTIVE_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
ACTIVE_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
AVG_SESSION_LIFE_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_SESSION_LIFE_TIME_MAX	VARCHAR(256)	 NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MIN	VARCHAR(256)	 NOT NULL,
MAX_SERVLET_RESOLVE_TIME_MAX	VARCHAR(256)	 NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_SERVLET_RESOLVE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iWebCtxTest_THRESH ADD constraint PK_O9iWebCtxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iWebCtxTest_THRESH ON O9iWebCtxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE O9iWebModuleTest;
CREATE TABLE O9iWebModuleTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
REQ_ACTIVE decimal(20,4) NOT NULL,
REQ_ACTIVE_ST varchar(32) NOT NULL,
REQ_COMPLETED DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_ST varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_ST varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_ST varchar(32) NOT NULL,
AVG_CTX_RESOLVE_TIME DECIMAL(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_ST varchar(32) NOT NULL,
AVG_REQ_PARSE_TIME DECIMAL(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE O9iWebModuleTest ADD constraint PK_O9iWebModuleTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_O9iWebModuleTest ON O9iWebModuleTest
(
	 MSMT_TIME
); 
DROP TABLE O9iWebModuleTest_TREND;
CREATE TABLE O9iWebModuleTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
REQ_ACTIVE_MIN decimal(20,4) NOT NULL,
REQ_ACTIVE_MAX decimal(20,4) NOT NULL,
REQ_ACTIVE_STCNT varchar(32) NOT NULL,
REQ_COMPLETED_MIN DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_MAX DECIMAL(20,4) NOT NULL,
REQ_COMPLETED_STCNT varchar(32) NOT NULL,
AVG_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL,
MAX_REQ_PROCESS_TIME_MIN DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_MAX DECIMAL(20,4) NOT NULL,
MAX_REQ_PROCESS_TIME_STCNT varchar(32) NOT NULL,
AVG_CTX_RESOLVE_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_CTX_RESOLVE_TIME_STCNT varchar(32) NOT NULL,
AVG_REQ_PARSE_TIME_MIN DECIMAL(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_MAX DECIMAL(20,4) NOT NULL,
AVG_REQ_PARSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE O9iWebModuleTest_TREND ADD constraint PK_O9iWebModuleTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O9iWebModuleTest_THRESH;
CREATE TABLE O9iWebModuleTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
REQ_ACTIVE_MIN	VARCHAR(256)	 NOT NULL,
REQ_ACTIVE_MAX	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MIN	VARCHAR(256)	 NOT NULL,
REQ_COMPLETED_MAX	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MIN	VARCHAR(256)	 NOT NULL,
MAX_REQ_PROCESS_TIME_MAX	VARCHAR(256)	 NOT NULL,
AVG_CTX_RESOLVE_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_CTX_RESOLVE_TIME_MAX	VARCHAR(256)	 NOT NULL,
AVG_REQ_PARSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
AVG_REQ_PARSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE O9iWebModuleTest_THRESH ADD constraint PK_O9iWebModuleTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O9iWebModuleTest_THRESH ON O9iWebModuleTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinsTest;
CREATE TABLE WinsTest(
	TRGT_HOST	varchar(32) NOT NULL,
	PORT_NO	varchar(32) NOT NULL,
	SITE_NAME	varchar(64) NOT NULL,
	INFO		varchar(128) NOT NULL,
	MSMT_HOST	varchar(32) NOT NULL,
	MSMT_TIME	datetime NOT NULL,
	QUERY_RATE DECIMAL(20,4) NOT NULL,
	QUERY_RATE_ST varchar(32) NOT NULL,
	FAILED_QUERY_RATE DECIMAL(20,4) NOT NULL,
	FAILED_QUERY_RATE_ST varchar(32) NOT NULL,
	RELEASE_RATE DECIMAL(20,4) NOT NULL,
	RELEASE_RATE_ST varchar(32) NOT NULL,
	FAILED_RELEASE_RATE DECIMAL(20,4) NOT NULL,
	FAILED_RELEASE_RATE_ST varchar(32) NOT NULL,
	CONFLICT_RATE DECIMAL(20,4) NOT NULL,
	CONFLICT_RATE_ST varchar(32) NOT NULL,
	RENEWAL_RATE DECIMAL(20,4) NOT NULL,
	RENEWAL_RATE_ST varchar(32) NOT NULL);

ALTER TABLE WinsTest ADD constraint PK_WinsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinsTest ON WinsTest
(
	 MSMT_TIME
); 
DROP TABLE WinsTest_TREND;
CREATE TABLE WinsTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	QUERY_RATE_MIN DECIMAL(20,4) NOT NULL,
	QUERY_RATE_MAX DECIMAL(20,4) NOT NULL,
	QUERY_RATE_STCNT varchar(32) NOT NULL,
	FAILED_QUERY_RATE_MIN DECIMAL(20,4) NOT NULL,
	FAILED_QUERY_RATE_MAX DECIMAL(20,4) NOT NULL,
	FAILED_QUERY_RATE_STCNT varchar(32) NOT NULL,
	RELEASE_RATE_MIN DECIMAL(20,4) NOT NULL,
	RELEASE_RATE_MAX DECIMAL(20,4) NOT NULL,
	RELEASE_RATE_STCNT varchar(32) NOT NULL,
	FAILED_RELEASE_RATE_MIN DECIMAL(20,4) NOT NULL,
	FAILED_RELEASE_RATE_MAX DECIMAL(20,4) NOT NULL,
	FAILED_RELEASE_RATE_STCNT varchar(32) NOT NULL,
	CONFLICT_RATE_MIN DECIMAL(20,4) NOT NULL,
	CONFLICT_RATE_MAX DECIMAL(20,4) NOT NULL,
	CONFLICT_RATE_STCNT varchar(32) NOT NULL,
	RENEWAL_RATE_MIN DECIMAL(20,4) NOT NULL,
	RENEWAL_RATE_MAX DECIMAL(20,4) NOT NULL,
	RENEWAL_RATE_STCNT varchar(32) NOT NULL);

ALTER TABLE WinsTest_TREND ADD constraint PK_WinsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinsTest_THRESH;
CREATE TABLE WinsTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	QUERY_RATE_MIN	VARCHAR(256)	 NOT NULL,
	QUERY_RATE_MAX	VARCHAR(256)	 NOT NULL,
	FAILED_QUERY_RATE_MIN	VARCHAR(256)	 NOT NULL,
	FAILED_QUERY_RATE_MAX	VARCHAR(256)	 NOT NULL,
	RELEASE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	RELEASE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	FAILED_RELEASE_RATE_MIN	VARCHAR(256)	 NOT NULL,
	FAILED_RELEASE_RATE_MAX	VARCHAR(256)	 NOT NULL,
	CONFLICT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	CONFLICT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	RENEWAL_RATE_MIN	VARCHAR(256)	 NOT NULL,
	RENEWAL_RATE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinsTest_THRESH ADD constraint PK_WinsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinsTest_THRESH ON WinsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermUserTest;
CREATE TABLE TermUserTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NO_OF_SESSIONS DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_ST varchar(32) NOT NULL,
CPU_UTIL DECIMAL(20,4) NOT NULL,
CPU_UTIL_ST varchar(32) NOT NULL,
MEM_UTIL DECIMAL(20,4) NOT NULL,
MEM_UTIL_ST varchar(32) NOT NULL,
INPUT_BANDWIDTH DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_ST varchar(32) NOT NULL,
INPUT_ERRORS DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_ST varchar(32) NOT NULL,
OUTPUT_BANDWIDTH DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_ST varchar(32) NOT NULL,
OUTPUT_ERRORS DECIMAL(20,4) NOT NULL,
OUTPUT_ERRORS_ST varchar(32) NOT NULL,
IO_READS DECIMAL(20,4) NOT NULL,
IO_READS_ST varchar(32) NOT NULL,
IO_WRITES DECIMAL(20,4) NOT NULL,
IO_WRITES_ST varchar(32) NOT NULL,
PAGE_FAULTS DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_ST varchar(32) NOT NULL,
VIRTUAL_MEM DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_ST varchar(32) NOT NULL,
HANDLES decimal(20,4) NOT NULL,
HANDLES_ST varchar(32) NOT NULL,
CPU_UTIL_TIME DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_ST varchar(32) NOT NULL);

ALTER TABLE TermUserTest ADD constraint PK_TermUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

CREATE NONCLUSTERED INDEX IDX_TermUserTest ON TermUserTest (MSMT_TIME) INCLUDE (CPU_UTIL,MEM_UTIL,IO_READS,IO_WRITES);

DROP TABLE TermUserTest_TREND;
CREATE TABLE TermUserTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NO_OF_SESSIONS_MIN DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_MAX DECIMAL(20,4) NOT NULL,
NO_OF_SESSIONS_STCNT varchar(32) NOT NULL,
CPU_UTIL_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_STCNT varchar(32) NOT NULL,
MEM_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEM_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEM_UTIL_STCNT varchar(32) NOT NULL,
INPUT_BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
INPUT_BANDWIDTH_STCNT varchar(32) NOT NULL,
INPUT_ERRORS_MIN DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_MAX DECIMAL(20,4) NOT NULL,
INPUT_ERRORS_STCNT varchar(32) NOT NULL,
OUTPUT_BANDWIDTH_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_BANDWIDTH_STCNT varchar(32) NOT NULL,
OUTPUT_ERRORS_MIN DECIMAL(20,4) NOT NULL,
OUTPUT_ERRORS_MAX DECIMAL(20,4) NOT NULL,
OUTPUT_ERRORS_STCNT varchar(32) NOT NULL,
IO_READS_MIN DECIMAL(20,4) NOT NULL,
IO_READS_MAX DECIMAL(20,4)  NOT NULL,
IO_READS_STCNT varchar(32) NOT NULL,
IO_WRITES_MIN DECIMAL(20,4) NOT NULL,
IO_WRITES_MAX DECIMAL(20,4) NOT NULL,
IO_WRITES_STCNT varchar(32) NOT NULL,
PAGE_FAULTS_MIN DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_MAX DECIMAL(20,4) NOT NULL,
PAGE_FAULTS_STCNT varchar(32) NOT NULL,
VIRTUAL_MEM_MIN DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_MAX DECIMAL(20,4) NOT NULL,
VIRTUAL_MEM_STCNT varchar(32) NOT NULL,
HANDLES_MIN DECIMAL(20,4) NOT NULL,
HANDLES_MAX DECIMAL(20,4) NOT NULL,
HANDLES_STCNT varchar(32) NOT NULL,
CPU_UTIL_TIME_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TermUserTest_TREND ADD constraint PK_TermUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermUserTest_THRESH;
CREATE TABLE TermUserTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NO_OF_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
NO_OF_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MEM_UTIL_MAX	VARCHAR(256)	 NOT NULL,
INPUT_BANDWIDTH_MIN	VARCHAR(256)	 NOT NULL,
INPUT_BANDWIDTH_MAX	VARCHAR(256)	 NOT NULL,
INPUT_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
INPUT_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_BANDWIDTH_MAX	VARCHAR(256)	 NOT NULL,
OUTPUT_ERRORS_MIN	VARCHAR(256)	 NOT NULL,
OUTPUT_ERRORS_MAX	VARCHAR(256)	 NOT NULL,
IO_READS_MIN varchar(256) NOT NULL,
IO_READS_MAX varchar(256)  NOT NULL,
IO_WRITES_MIN varchar(256) NOT NULL,
IO_WRITES_MAX varchar(256) NOT NULL,
PAGE_FAULTS_MIN varchar(256) NOT NULL,
PAGE_FAULTS_MAX varchar(256) NOT NULL,
VIRTUAL_MEM_MIN varchar(256) NOT NULL,
VIRTUAL_MEM_MAX varchar(256) NOT NULL,
HANDLES_MIN varchar(256) NOT NULL,
HANDLES_MAX varchar(256) NOT NULL,
CPU_UTIL_TIME_MIN varchar(256) NOT NULL,
CPU_UTIL_TIME_MAX varchar(256) NOT NULL);

ALTER TABLE TermUserTest_THRESH ADD constraint PK_TermUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermUserTest_THRESH ON TermUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermAppTest;
CREATE TABLE TermAppTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
NUM_PROCS_RUNNING DECIMAL(20,4) NOT NULL,
NUM_PROCS_RUNNING_ST varchar(32) NOT NULL,
CPU_UTIL DECIMAL(20,4) NOT NULL,
CPU_UTIL_ST varchar(32) NOT NULL,
MEMORY_UTIL DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_ST varchar(32) NOT NULL);

ALTER TABLE TermAppTest ADD constraint PK_TermAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_TermAppTest ON TermAppTest (MSMT_TIME) INCLUDE (NUM_PROCS_RUNNING,CPU_UTIL,MEMORY_UTIL); 
DROP TABLE TermAppTest_TREND;
CREATE TABLE TermAppTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
NUM_PROCS_RUNNING_MIN DECIMAL(20,4) NOT NULL,
NUM_PROCS_RUNNING_MAX DECIMAL(20,4) NOT NULL,
NUM_PROCS_RUNNING_STCNT varchar(32) NOT NULL,
CPU_UTIL_MIN DECIMAL(20,4) NOT NULL,
CPU_UTIL_MAX DECIMAL(20,4) NOT NULL,
CPU_UTIL_STCNT varchar(32) NOT NULL,
MEMORY_UTIL_MIN DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_MAX DECIMAL(20,4) NOT NULL,
MEMORY_UTIL_STCNT varchar(32) NOT NULL);

ALTER TABLE TermAppTest_TREND ADD constraint PK_TermAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermAppTest_THRESH;
CREATE TABLE TermAppTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
NUM_PROCS_RUNNING_MIN	VARCHAR(256)	 NOT NULL,
NUM_PROCS_RUNNING_MAX	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MIN	VARCHAR(256)	 NOT NULL,
CPU_UTIL_MAX	VARCHAR(256)	 NOT NULL,
MEMORY_UTIL_MIN	VARCHAR(256)	 NOT NULL,
MEMORY_UTIL_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TermAppTest_THRESH ADD constraint PK_TermAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermAppTest_THRESH ON TermAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermAuthTest;
CREATE TABLE TermAuthTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
AVAILABILITY DECIMAL(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSE_TIME DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_ST varchar(32) NOT NULL);

ALTER TABLE TermAuthTest ADD constraint PK_TermAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TermAuthTest ON TermAuthTest
(
	 MSMT_TIME
); 
DROP TABLE TermAuthTest_TREND;
CREATE TABLE TermAuthTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TermAuthTest_TREND ADD constraint PK_TermAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermAuthTest_THRESH;
CREATE TABLE TermAuthTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TermAuthTest_THRESH ADD constraint PK_TermAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermAuthTest_THRESH ON TermAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermClientTest;
CREATE TABLE TermClientTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
CURRENT_CONNS DECIMAL(20,4) NOT NULL,
CURRENT_CONNS_ST varchar(32) NOT NULL,
NEW_CONNS_ADDED DECIMAL(20,4) NOT NULL,
NEW_CONNS_ADDED_ST varchar(32) NOT NULL,
OLD_CONNS_REMOVED DECIMAL(20,4) NOT NULL,
OLD_CONNS_REMOVED_ST varchar(32) NOT NULL,
AVG_CONN_DURATION DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_ST varchar(32) NOT NULL);

ALTER TABLE TermClientTest ADD constraint PK_TermClientTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_TermClientTest ON TermClientTest
(
	 MSMT_TIME
); 
DROP TABLE TermClientTest_TREND;
CREATE TABLE TermClientTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
CURRENT_CONNS_MIN DECIMAL(20,4) NOT NULL,
CURRENT_CONNS_MAX DECIMAL(20,4) NOT NULL,
CURRENT_CONNS_STCNT varchar(32) NOT NULL,
NEW_CONNS_ADDED_MIN DECIMAL(20,4) NOT NULL,
NEW_CONNS_ADDED_MAX DECIMAL(20,4) NOT NULL,
NEW_CONNS_ADDED_STCNT varchar(32) NOT NULL,
OLD_CONNS_REMOVED_MIN DECIMAL(20,4) NOT NULL,
OLD_CONNS_REMOVED_MAX DECIMAL(20,4) NOT NULL,
OLD_CONNS_REMOVED_STCNT varchar(32) NOT NULL,
AVG_CONN_DURATION_MIN DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_MAX DECIMAL(20,4) NOT NULL,
AVG_CONN_DURATION_STCNT varchar(32) NOT NULL);

ALTER TABLE TermClientTest_TREND ADD constraint PK_TermClientTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermClientTest_THRESH;
CREATE TABLE TermClientTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
CURRENT_CONNS_MIN	VARCHAR(256)	 NOT NULL,
CURRENT_CONNS_MAX	VARCHAR(256)	 NOT NULL,
NEW_CONNS_ADDED_MIN	VARCHAR(256)	 NOT NULL,
NEW_CONNS_ADDED_MAX	VARCHAR(256)	 NOT NULL,
OLD_CONNS_REMOVED_MIN	VARCHAR(256)	 NOT NULL,
OLD_CONNS_REMOVED_MAX	VARCHAR(256)	 NOT NULL,
AVG_CONN_DURATION_MIN	VARCHAR(256)	 NOT NULL,
AVG_CONN_DURATION_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TermClientTest_THRESH ADD constraint PK_TermClientTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermClientTest_THRESH ON TermClientTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermConnTest;
CREATE TABLE TermConnTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
AVAILABILITY DECIMAL(20,4) NOT NULL,
AVAILABILITY_ST varchar(32) NOT NULL,
RESPONSETIME DECIMAL(20,4) NOT NULL,
RESPONSETIME_ST varchar(32) NOT NULL);

ALTER TABLE TermConnTest ADD constraint PK_TermConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_TermConnTest  ON TermConnTest (MSMT_TIME) INCLUDE (AVAILABILITY);

DROP TABLE TermConnTest_TREND;
CREATE TABLE TermConnTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
AVAILABILITY_MIN DECIMAL(20,4) NOT NULL,
AVAILABILITY_MAX DECIMAL(20,4) NOT NULL,
AVAILABILITY_STCNT varchar(32) NOT NULL,
RESPONSETIME_MIN DECIMAL(20,4) NOT NULL,
RESPONSETIME_MAX DECIMAL(20,4) NOT NULL,
RESPONSETIME_STCNT varchar(32) NOT NULL);

ALTER TABLE TermConnTest_TREND ADD constraint PK_TermConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermConnTest_THRESH;
CREATE TABLE TermConnTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
AVAILABILITY_MIN	VARCHAR(256)	 NOT NULL,
AVAILABILITY_MAX	VARCHAR(256)	 NOT NULL,
RESPONSETIME_MIN	VARCHAR(256)	 NOT NULL,
RESPONSETIME_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE TermConnTest_THRESH ADD constraint PK_TermConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermConnTest_THRESH ON TermConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE TermSessionTest;
CREATE TABLE TermSessionTest(
TRGT_HOST	varchar(32) NOT NULL,
PORT_NO	varchar(32) NOT NULL,
SITE_NAME	varchar(64) NOT NULL,
INFO		varchar(128) NOT NULL,
MSMT_HOST	varchar(32) NOT NULL,
MSMT_TIME	datetime NOT NULL,
ACTIVE_SESSIONS decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_ST varchar(32) NOT NULL,
IDLE_SESSIONS decimal(20,4) NOT NULL,
IDLE_SESSIONS_ST varchar(32) NOT NULL,
CONNECTED_SESSIONS decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_ST varchar(32) NOT NULL,
CONNECTING_SESSIONS decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_ST varchar(32) NOT NULL,
DISCONNECTED_SESSIONS decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_ST varchar(32) NOT NULL,
LISTEN_SESSIONS decimal(20,4) NOT NULL,
LISTEN_SESSIONS_ST varchar(32) NOT NULL,
SHADOW_SESSIONS decimal(20,4) NOT NULL,
SHADOW_SESSIONS_ST varchar(32) NOT NULL,
DOWN_SESSIONS decimal(20,4) NOT NULL,
DOWN_SESSIONS_ST varchar(32) NOT NULL,
INIT_SESSIONS decimal(20,4) NOT NULL,
INIT_SESSIONS_ST varchar(32) NOT NULL);

ALTER TABLE TermSessionTest ADD constraint PK_TermSessionTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE NONCLUSTERED INDEX IDX_TermSessionTest ON TermSessionTest (MSMT_TIME) INCLUDE (ACTIVE_SESSIONS);
DROP TABLE TermSessionTest_TREND;
CREATE TABLE TermSessionTest_TREND(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME       datetime NOT NULL,
PERIOD       	varchar(32) NOT NULL,
ACTIVE_SESSIONS_MIN decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_MAX decimal(20,4) NOT NULL,
ACTIVE_SESSIONS_STCNT varchar(32) NOT NULL,
IDLE_SESSIONS_MIN decimal(20,4) NOT NULL,
IDLE_SESSIONS_MAX decimal(20,4) NOT NULL,
IDLE_SESSIONS_STCNT varchar(32) NOT NULL,
CONNECTED_SESSIONS_MIN decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_MAX decimal(20,4) NOT NULL,
CONNECTED_SESSIONS_STCNT varchar(32) NOT NULL,
CONNECTING_SESSIONS_MIN decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_MAX decimal(20,4) NOT NULL,
CONNECTING_SESSIONS_STCNT varchar(32) NOT NULL,
DISCONNECTED_SESSIONS_MIN decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_MAX decimal(20,4) NOT NULL,
DISCONNECTED_SESSIONS_STCNT varchar(32) NOT NULL,
LISTEN_SESSIONS_MIN decimal(20,4) NOT NULL,
LISTEN_SESSIONS_MAX decimal(20,4) NOT NULL,
LISTEN_SESSIONS_STCNT varchar(32) NOT NULL,
SHADOW_SESSIONS_MIN decimal(20,4) NOT NULL,
SHADOW_SESSIONS_MAX decimal(20,4) NOT NULL,
SHADOW_SESSIONS_STCNT varchar(32) NOT NULL,
DOWN_SESSIONS_MIN decimal(20,4) NOT NULL,
DOWN_SESSIONS_MAX decimal(20,4) NOT NULL,
DOWN_SESSIONS_STCNT varchar(32) NOT NULL,
INIT_SESSIONS_MIN decimal(20,4) NOT NULL,
INIT_SESSIONS_MAX decimal(20,4) NOT NULL,
INIT_SESSIONS_STCNT varchar(32) NOT NULL);

ALTER TABLE TermSessionTest_TREND ADD constraint PK_TermSessionTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TermSessionTest_THRESH;
CREATE TABLE TermSessionTest_THRESH(
TRGT_HOST       varchar(32) NOT NULL,
PORT_NO         varchar(32) NOT NULL,
SITE_NAME       varchar(64) NOT NULL,
INFO            varchar(128) NOT NULL,
MSMT_HOST       varchar(32) NOT NULL,
MSMT_TIME_START datetime NOT NULL,
MSMT_TIME_END   datetime NOT NULL,
ACTIVE_SESSIONS_MIN VARCHAR(256) NOT NULL,
ACTIVE_SESSIONS_MAX VARCHAR(256) NOT NULL,
IDLE_SESSIONS_MIN VARCHAR(256) NOT NULL,
IDLE_SESSIONS_MAX VARCHAR(256) NOT NULL,
CONNECTED_SESSIONS_MIN VARCHAR(256) NOT NULL,
CONNECTED_SESSIONS_MAX VARCHAR(256) NOT NULL,
CONNECTING_SESSIONS_MIN VARCHAR(256) NOT NULL,
CONNECTING_SESSIONS_MAX VARCHAR(256) NOT NULL,
DISCONNECTED_SESSIONS_MIN VARCHAR(256) NOT NULL,
DISCONNECTED_SESSIONS_MAX VARCHAR(256) NOT NULL,
LISTEN_SESSIONS_MIN VARCHAR(256) NOT NULL,
LISTEN_SESSIONS_MAX VARCHAR(256) NOT NULL,
SHADOW_SESSIONS_MIN VARCHAR(256) NOT NULL,
SHADOW_SESSIONS_MAX VARCHAR(256) NOT NULL,
DOWN_SESSIONS_MIN VARCHAR(256) NOT NULL,
DOWN_SESSIONS_MAX VARCHAR(256) NOT NULL,
INIT_SESSIONS_MIN VARCHAR(256) NOT NULL,
INIT_SESSIONS_MAX VARCHAR(256) NOT NULL);

ALTER TABLE TermSessionTest_THRESH ADD constraint PK_TermSessionTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TermSessionTest_THRESH ON TermSessionTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE WinSockTest;
CREATE TABLE WinSockTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	ACEPTING_TCP_CONNECTIONS decimal(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_ST varchar(32) NOT NULL,
	ACTIVE_SESSIONS decimal(20,4) NOT NULL,
	ACTIVE_SESSIONS_ST varchar(32) NOT NULL,
	ACTIVE_TCP_CONNECTIONS decimal(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_ST varchar(32) NOT NULL,
	ACTIVE_UDP_CONNECTIONS decimal(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_ST varchar(32) NOT NULL,
	AVAILABLE_WORKER_THREADS decimal(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_ST varchar(32) NOT NULL,
	DATA_RECV_RATE DECIMAL(20,4) NOT NULL,
	DATA_RECV_RATE_ST varchar(32) NOT NULL,
	DATA_XMIT_RATE DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_ST varchar(32) NOT NULL,
	FAILED_DNS_RESOLUTIONS decimal(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_ST varchar(32) NOT NULL,
	PENDING_DNS_RESOLUTIONS decimal(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_ST varchar(32) NOT NULL,
	WORKER_THREADS decimal(20,4) NOT NULL,
	WORKER_THREADS_ST varchar(32) NOT NULL);

ALTER TABLE WinSockTest ADD constraint PK_WinSockTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_WinSockTest ON WinSockTest
(
	 MSMT_TIME
); 
DROP TABLE WinSockTest_TREND;
CREATE TABLE WinSockTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MIN decimal(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MAX decimal(20,4) NOT NULL,
	ACEPTING_TCP_CONNECTIONS_STCNT varchar(32) NOT NULL,
	ACTIVE_SESSIONS_MIN decimal(20,4) NOT NULL,
	ACTIVE_SESSIONS_MAX decimal(20,4) NOT NULL,
	ACTIVE_SESSIONS_STCNT varchar(32) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MIN decimal(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MAX decimal(20,4) NOT NULL,
	ACTIVE_TCP_CONNECTIONS_STCNT varchar(32) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MIN decimal(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MAX decimal(20,4) NOT NULL,
	ACTIVE_UDP_CONNECTIONS_STCNT varchar(32) NOT NULL,
	AVAILABLE_WORKER_THREADS_MIN decimal(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_MAX decimal(20,4) NOT NULL,
	AVAILABLE_WORKER_THREADS_STCNT varchar(32) NOT NULL,
	DATA_RECV_RATE_MIN DECIMAL(20,4) NOT NULL,
	DATA_RECV_RATE_MAX DECIMAL(20,4) NOT NULL,
	DATA_RECV_RATE_STCNT varchar(32) NOT NULL,
	DATA_XMIT_RATE_MIN DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_MAX DECIMAL(20,4) NOT NULL,
	DATA_XMIT_RATE_STCNT varchar(32) NOT NULL,
	FAILED_DNS_RESOLUTIONS_MIN decimal(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_MAX decimal(20,4) NOT NULL,
	FAILED_DNS_RESOLUTIONS_STCNT varchar(32) NOT NULL,
	PENDING_DNS_RESOLUTIONS_MIN decimal(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_MAX decimal(20,4) NOT NULL,
	PENDING_DNS_RESOLUTIONS_STCNT varchar(32) NOT NULL,
	WORKER_THREADS_MIN decimal(20,4) NOT NULL,
	WORKER_THREADS_MAX decimal(20,4) NOT NULL,
	WORKER_THREADS_STCNT varchar(32) NOT NULL);

ALTER TABLE WinSockTest_TREND ADD constraint PK_WinSockTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WinSockTest_THRESH;
CREATE TABLE WinSockTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MIN	VARCHAR(256)	 NOT NULL,
	ACEPTING_TCP_CONNECTIONS_MAX	VARCHAR(256)	 NOT NULL,
	ACTIVE_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
	ACTIVE_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MIN	VARCHAR(256)	 NOT NULL,
	ACTIVE_TCP_CONNECTIONS_MAX	VARCHAR(256)	 NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MIN	VARCHAR(256)	 NOT NULL,
	ACTIVE_UDP_CONNECTIONS_MAX	VARCHAR(256)	 NOT NULL,
	AVAILABLE_WORKER_THREADS_MIN	VARCHAR(256)	 NOT NULL,
	AVAILABLE_WORKER_THREADS_MAX	VARCHAR(256)	 NOT NULL,
	DATA_RECV_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_RECV_RATE_MAX	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MIN	VARCHAR(256)	 NOT NULL,
	DATA_XMIT_RATE_MAX	VARCHAR(256)	 NOT NULL,
	FAILED_DNS_RESOLUTIONS_MIN	VARCHAR(256)	 NOT NULL,
	FAILED_DNS_RESOLUTIONS_MAX	VARCHAR(256)	 NOT NULL,
	PENDING_DNS_RESOLUTIONS_MIN	VARCHAR(256)	 NOT NULL,
	PENDING_DNS_RESOLUTIONS_MAX	VARCHAR(256)	 NOT NULL,
	WORKER_THREADS_MIN	VARCHAR(256)	 NOT NULL,
	WORKER_THREADS_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE WinSockTest_THRESH ADD constraint PK_WinSockTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WinSockTest_THRESH ON WinSockTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxyCacheTest;
CREATE TABLE ProxyCacheTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	ACTIVE_REFRESH_RATE DECIMAL(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_ST varchar(32) NOT NULL,
	ACTIVE_URL_REFRESH DECIMAL(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_ST varchar(32) NOT NULL,
	CACHE_SIZE decimal(20,4) NOT NULL,
	CACHE_SIZE_ST varchar(32) NOT NULL,
	URL_COMMITS DECIMAL(20,4) NOT NULL,
	URL_COMMITS_ST varchar(32) NOT NULL,
	URL_RETRIEVALS DECIMAL(20,4) NOT NULL,
	URL_RETRIEVALS_ST varchar(32) NOT NULL,
	URLS_IN_CACHE decimal(20,4) NOT NULL,
	URLS_IN_CACHE_ST varchar(32) NOT NULL);

ALTER TABLE ProxyCacheTest ADD constraint PK_ProxyCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ProxyCacheTest ON ProxyCacheTest
(
	 MSMT_TIME
); 
DROP TABLE ProxyCacheTest_TREND;
CREATE TABLE ProxyCacheTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	ACTIVE_REFRESH_RATE_MIN DECIMAL(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_MAX DECIMAL(20,4) NOT NULL,
	ACTIVE_REFRESH_RATE_STCNT varchar(32) NOT NULL,
	ACTIVE_URL_REFRESH_MIN DECIMAL(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_MAX DECIMAL(20,4) NOT NULL,
	ACTIVE_URL_REFRESH_STCNT varchar(32) NOT NULL,
	CACHE_SIZE_MIN decimal(20,4) NOT NULL,
	CACHE_SIZE_MAX decimal(20,4) NOT NULL,
	CACHE_SIZE_STCNT varchar(32) NOT NULL,
	URL_COMMITS_MIN DECIMAL(20,4) NOT NULL,
	URL_COMMITS_MAX DECIMAL(20,4) NOT NULL,
	URL_COMMITS_STCNT varchar(32) NOT NULL,
	URL_RETRIEVALS_MIN DECIMAL(20,4) NOT NULL,
	URL_RETRIEVALS_MAX DECIMAL(20,4) NOT NULL,
	URL_RETRIEVALS_STCNT varchar(32) NOT NULL,
	URLS_IN_CACHE_MIN decimal(20,4) NOT NULL,
	URLS_IN_CACHE_MAX decimal(20,4) NOT NULL,
	URLS_IN_CACHE_STCNT varchar(32) NOT NULL);

ALTER TABLE ProxyCacheTest_TREND ADD constraint PK_ProxyCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ProxyCacheTest_THRESH;
CREATE TABLE ProxyCacheTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	ACTIVE_REFRESH_RATE_MIN	VARCHAR(256)	 NOT NULL,
	ACTIVE_REFRESH_RATE_MAX	VARCHAR(256)	 NOT NULL,
	ACTIVE_URL_REFRESH_MIN	VARCHAR(256)	 NOT NULL,
	ACTIVE_URL_REFRESH_MAX	VARCHAR(256)	 NOT NULL,
	CACHE_SIZE_MIN	VARCHAR(256)	 NOT NULL,
	CACHE_SIZE_MAX	VARCHAR(256)	 NOT NULL,
	URL_COMMITS_MIN	VARCHAR(256)	 NOT NULL,
	URL_COMMITS_MAX	VARCHAR(256)	 NOT NULL,
	URL_RETRIEVALS_MIN	VARCHAR(256)	 NOT NULL,
	URL_RETRIEVALS_MAX	VARCHAR(256)	 NOT NULL,
	URLS_IN_CACHE_MIN	VARCHAR(256)	 NOT NULL,
	URLS_IN_CACHE_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE ProxyCacheTest_THRESH ADD constraint PK_ProxyCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProxyCacheTest_THRESH ON ProxyCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxyServerTest;
CREATE TABLE ProxyServerTest(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	CACHE_HIT_RATIO DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_ST varchar(32) NOT NULL,
	CLIENT_DATA_RECVD DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_RECVD_ST varchar(32) NOT NULL,
	CLIENT_DATA_SENT DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_SENT_ST varchar(32) NOT NULL,
	AVG_RESPONSE_TIME DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_ST varchar(32) NOT NULL,
	CURRENT_USERS decimal(20,4) NOT NULL,
	CURRENT_USERS_ST varchar(32) NOT NULL,
	DNS_CACHE_HITS DECIMAL(20,4) NOT NULL,
	DNS_CACHE_HITS_ST varchar(32) NOT NULL,
	FAILING_REQUESTS decimal(20,4) NOT NULL,
	FAILING_REQUESTS_ST varchar(32) NOT NULL,
	FTP_REQUESTS decimal(20,4) NOT NULL,
	FTP_REQUESTS_ST varchar(32) NOT NULL,
	HTTP_REQUESTS decimal(20,4) NOT NULL,
	HTTP_REQUESTS_ST varchar(32) NOT NULL,
	HTTPS_SESSIONS decimal(20,4) NOT NULL,
	HTTPS_SESSIONS_ST varchar(32) NOT NULL,
	THREAD_POOL_ACTIVE_SESS decimal(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_ST varchar(32) NOT NULL,
	THREAD_POOL_FAILURES decimal(20,4) NOT NULL,
	THREAD_POOL_FAILURES_ST varchar(32) NOT NULL,
	UPSTREAM_DATA_RECVD DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_ST varchar(32) NOT NULL,
	UPSTREAM_DATA_SENT DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_ST varchar(32) NOT NULL);

ALTER TABLE ProxyServerTest ADD constraint PK_ProxyServerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ProxyServerTest ON ProxyServerTest
(
	 MSMT_TIME
); 
DROP TABLE ProxyServerTest_TREND;
CREATE TABLE ProxyServerTest_TREND(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME       datetime NOT NULL,
	PERIOD       	varchar(32) NOT NULL,
	CACHE_HIT_RATIO_MIN DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_MAX DECIMAL(20,4) NOT NULL,
	CACHE_HIT_RATIO_STCNT varchar(32) NOT NULL,
	CLIENT_DATA_RECVD_MIN DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_RECVD_MAX DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_RECVD_STCNT varchar(32) NOT NULL,
	CLIENT_DATA_SENT_MIN DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_SENT_MAX DECIMAL(20,4) NOT NULL,
	CLIENT_DATA_SENT_STCNT varchar(32) NOT NULL,
	AVG_RESPONSE_TIME_MIN DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_MAX DECIMAL(20,4) NOT NULL,
	AVG_RESPONSE_TIME_STCNT varchar(32) NOT NULL,
	CURRENT_USERS_MIN decimal(20,4) NOT NULL,
	CURRENT_USERS_MAX decimal(20,4) NOT NULL,
	CURRENT_USERS_STCNT varchar(32) NOT NULL,
	DNS_CACHE_HITS_MIN DECIMAL(20,4) NOT NULL,
	DNS_CACHE_HITS_MAX DECIMAL(20,4) NOT NULL,
	DNS_CACHE_HITS_STCNT varchar(32) NOT NULL,
	FAILING_REQUESTS_MIN decimal(20,4) NOT NULL,
	FAILING_REQUESTS_MAX decimal(20,4) NOT NULL,
	FAILING_REQUESTS_STCNT varchar(32) NOT NULL,
	FTP_REQUESTS_MIN decimal(20,4) NOT NULL,
	FTP_REQUESTS_MAX decimal(20,4) NOT NULL,
	FTP_REQUESTS_STCNT varchar(32) NOT NULL,
	HTTP_REQUESTS_MIN decimal(20,4) NOT NULL,
	HTTP_REQUESTS_MAX decimal(20,4) NOT NULL,
	HTTP_REQUESTS_STCNT varchar(32) NOT NULL,
	HTTPS_SESSIONS_MIN decimal(20,4) NOT NULL,
	HTTPS_SESSIONS_MAX decimal(20,4) NOT NULL,
	HTTPS_SESSIONS_STCNT varchar(32) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MIN decimal(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MAX decimal(20,4) NOT NULL,
	THREAD_POOL_ACTIVE_SESS_STCNT varchar(32) NOT NULL,
	THREAD_POOL_FAILURES_MIN decimal(20,4) NOT NULL,
	THREAD_POOL_FAILURES_MAX decimal(20,4) NOT NULL,
	THREAD_POOL_FAILURES_STCNT varchar(32) NOT NULL,
	UPSTREAM_DATA_RECVD_MIN DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_MAX DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_RECVD_STCNT varchar(32) NOT NULL,
	UPSTREAM_DATA_SENT_MIN DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_MAX DECIMAL(20,4) NOT NULL,
	UPSTREAM_DATA_SENT_STCNT varchar(32) NOT NULL);

ALTER TABLE ProxyServerTest_TREND ADD constraint PK_ProxyServerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ProxyServerTest_THRESH;
CREATE TABLE ProxyServerTest_THRESH(
	TRGT_HOST       varchar(32) NOT NULL,
	PORT_NO         varchar(32) NOT NULL,
	SITE_NAME       varchar(64) NOT NULL,
	INFO            varchar(128) NOT NULL,
	MSMT_HOST       varchar(32) NOT NULL,
	MSMT_TIME_START datetime NOT NULL,
	MSMT_TIME_END   datetime NOT NULL,
	CACHE_HIT_RATIO_MIN	VARCHAR(256)	 NOT NULL,
	CACHE_HIT_RATIO_MAX	VARCHAR(256)	 NOT NULL,
	CLIENT_DATA_RECVD_MIN	VARCHAR(256)	 NOT NULL,
	CLIENT_DATA_RECVD_MAX	VARCHAR(256)	 NOT NULL,
	CLIENT_DATA_SENT_MIN	VARCHAR(256)	 NOT NULL,
	CLIENT_DATA_SENT_MAX	VARCHAR(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MIN	VARCHAR(256)	 NOT NULL,
	AVG_RESPONSE_TIME_MAX	VARCHAR(256)	 NOT NULL,
	CURRENT_USERS_MIN	VARCHAR(256)	 NOT NULL,
	CURRENT_USERS_MAX	VARCHAR(256)	 NOT NULL,
	DNS_CACHE_HITS_MIN	VARCHAR(256)	 NOT NULL,
	DNS_CACHE_HITS_MAX	VARCHAR(256)	 NOT NULL,
	FAILING_REQUESTS_MIN	VARCHAR(256)	 NOT NULL,
	FAILING_REQUESTS_MAX	VARCHAR(256)	 NOT NULL,
	FTP_REQUESTS_MIN	VARCHAR(256)	 NOT NULL,
	FTP_REQUESTS_MAX	VARCHAR(256)	 NOT NULL,
	HTTP_REQUESTS_MIN	VARCHAR(256)	 NOT NULL,
	HTTP_REQUESTS_MAX	VARCHAR(256)	 NOT NULL,
	HTTPS_SESSIONS_MIN	VARCHAR(256)	 NOT NULL,
	HTTPS_SESSIONS_MAX	VARCHAR(256)	 NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MIN	VARCHAR(256)	 NOT NULL,
	THREAD_POOL_ACTIVE_SESS_MAX	VARCHAR(256)	 NOT NULL,
	THREAD_POOL_FAILURES_MIN	VARCHAR(256)	 NOT NULL,
	THREAD_POOL_FAILURES_MAX	VARCHAR(256)	 NOT NULL,
	UPSTREAM_DATA_RECVD_MIN	VARCHAR(256)	 NOT NULL,
	UPSTREAM_DATA_RECVD_MAX	VARCHAR(256)	 NOT NULL,
	UPSTREAM_DATA_SENT_MIN	VARCHAR(256)	 NOT NULL,
	UPSTREAM_DATA_SENT_MAX	VARCHAR(256)	 NOT NULL);

ALTER TABLE ProxyServerTest_THRESH ADD constraint PK_ProxyServerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ProxyServerTest_THRESH ON ProxyServerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);

DROP TABLE ProxySvcTest;

CREATE TABLE ProxySvcTest 
(
	TRGT_HOST       	varchar(32) NOT NULL,
	PORT_NO         	varchar(32) NOT NULL,
        SITE_NAME               varchar(64) NOT NULL,
        INFO                    varchar(128) NOT NULL,
	MSMT_HOST 		varchar(32) NOT NULL, 
	MSMT_TIME       	datetime NOT NULL,
	AVAILABLE       	decimal(3)     	NOT NULL,
	AVAILABLE_ST       	varchar(32)     	NOT NULL,
	RESP_TIME       	decimal(20,4)  	NOT NULL,
	RESP_TIME_ST    	varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL  	decimal(3)     	NOT NULL,	
        TCP_CONN_AVAIL_ST  	varchar(32)     	NOT NULL,
	TCP_CONN_TIME   	decimal(20,4)  	NOT NULL,
	TCP_CONN_TIME_ST   	varchar(32)  	NOT NULL,
	SVR_RESP_TIME   	decimal(20,4)  	NOT NULL,
	SVR_RESP_TIME_ST   	varchar(32)  	NOT NULL,
	CONTENT_VAL   		decimal(3)  	NOT NULL,
	CONTENT_VAL_ST   	varchar(32)  	NOT NULL,
	RESP_CODE   		decimal(3)  	NOT NULL,
	RESP_CODE_ST   		varchar(32)  	NOT NULL,
	CONTENT_LEN   		decimal(20,4)  	NOT NULL,
	CONTENT_LEN_ST   	varchar(32)  	NOT NULL,
	DATA_XFER_TIME   	decimal(20,4)  	NOT NULL,
	DATA_XFER_TIME_ST   	varchar(32)  	NOT NULL,
	DNS_AVAILABILITY   	decimal(20,4)  	NOT NULL,
	DNS_AVAILABILITY_ST   	varchar(32)  	NOT NULL
);

alter table ProxySvcTest add constraint PK_ProxySvcTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ProxySvcTest ON ProxySvcTest
(
	 MSMT_TIME
); 
DROP TABLE ProxySvcTest_TREND;

CREATE TABLE ProxySvcTest_TREND
(
	TRGT_HOST       		varchar(32) NOT NULL,
	PORT_NO         		varchar(32) NOT NULL,
        SITE_NAME              		varchar(64) NOT NULL,
        INFO                    	varchar(128) NOT NULL,
	MSMT_HOST 			varchar(32) NOT NULL, 
	MSMT_TIME       		datetime NOT NULL,
	PERIOD       			varchar(32) NOT NULL, 
	AVAILABLE_MIN       		decimal(20,4)     	NOT NULL,
	AVAILABLE_MAX       		decimal(20,4)     	NOT NULL,
	AVAILABLE_STCNT       		varchar(32)    NOT NULL,
	RESP_TIME_MIN       		decimal(20,4)  	NOT NULL,
	RESP_TIME_MAX       		decimal(20,4)  	NOT NULL,
	RESP_TIME_STCNT    		varchar(32)  	NOT NULL,
	TCP_CONN_AVAIL_MIN  		decimal(20,4)     	NOT NULL,	
	TCP_CONN_AVAIL_MAX  		decimal(20,4)     	NOT NULL,	
        TCP_CO