;(function(){
    new function() {
        if (!window.EGRUM) {
/*
 Copyright 2010 Google Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 See the source code here:
 http://code.google.com/p/episodes/
 */
String.prototype.trim||!function(){var t=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;String.prototype.trim=function(){return this.replace(t,"");};}();
var EGRUM = EGRUM || {};
EGRUM["beacon-url"] = window["beacon-url"] || "";
EGRUM["site"] = window["Site_Name"] || "";
EGRUM.q = EGRUM.q || [];
EGRUM.error = [];
EGRUM.autorun = ( "undefined" != typeof(EGRUM.autorun) ? EGRUM.autorun : true );
var debug = false;
if (!window.EGRUM)
{
    window.EGRUM = {};
}
var s=window.EGRUM;

EGRUM.init = function() {
    EGRUM.bDone = false;
    EGRUM.marks = {};
    EGRUM.measures = {};
    EGRUM.errors = {};
    EGRUM.errors["errors"] = 0;
    EGRUM.starts = {};
    EGRUM.findStartTime();
    EGRUM.contentLoadFired = false;
    EGRUM.mark("firstbyte",window["egrum-start_time"]);
    EGRUM.addEventListener("beforeunload", EGRUM.beforeUnload, false);
    if ("complete" === document.readyState){
        EGRUM.domContentLoaded();
    }else if ("undefined" !== typeof document.addEventListener){
        document.addEventListener("DOMContentLoaded", EGRUM.domContentLoaded, false);
    }else if ("undefined" !== typeof document.attachEvent){
        document.attachEvent("onreadystatechange", EGRUM.readyStateChange);
    }
    EGRUM.findError();
    EGRUM.AjaxMes();
    EGRUM.addEventListener("load", EGRUM.onload, false);
};

EGRUM.onerror=function(e){
    EGRUM.error.push([e.message,e.filename,e.lineno, e.colno]);
};
EGRUM.findError= function()
{
    var isIE=(EGRUM.getBrowserName().indexOf("Internet Explorer") != -1);
    var isFireFox=(EGRUM.getBrowserName().indexOf("Firefox") != -1);
    if((window.addEventListener || window.attachEvent) && !isFireFox && !isIE){
        EGRUM.addEventListener("error", EGRUM.onerror, false);
    }
    else{
        var oldErr=window.onerror;
        window.onerror=function(msg,url, line, col, e){
            EGRUM.error.push([msg,url, line, col]);
            if(oldErr){
                return oldErr(msg,url, line, col, e);
            }
            return false;
        };
    }
};

EGRUM.AjaxMes = function()
{
    var h = null;
    if(window.XMLHttpRequest){
        var ajaxReq=window.XMLHttpRequest.prototype;
        if(ajaxReq){
            if(ajaxReq.open||ajaxReq.send){
                var firstByte=function(xhr){
                    var r=xhr.s;
                    if(r){
                        var d=(new Date).getTime();
                        2==xhr.readyState?r.firstByteTime=r.firstByteTime||d:4==xhr.readyState&&(r.respAvailTime=r.respAvailTime||d,r.firstByteTime=r.firstByteTime||d)
                    }
                },sendAjax=function(xhr,r){
                    var d=xhr.getAllResponseHeaders(),f=xhr.status;
                    EGRUM.reportAjaxReq(r,d,f,400<=f?xhr.responseText:h);
                },responseProcessTime=function(xhrsc,xhr,d){
                    return EGRUM.findAjax(xhrsc,function(){firstByte(this)},function(){
                            var r=xhr.s;
                            r&&4==xhr.readyState&&(r.respProcTime=r.respProcTime||(new Date).getTime(),
                                    sendAjax(xhr,r),delete xhr.s)},d);
                };
                ajaxReq.open=EGRUM.findAjax(ajaxReq.open,function(){
                    this.s={url:2<=arguments.length?String(arguments[1]):"",sendTime:h,firstByteTime:h,respAvailTime:h,respProcTime:h}
                },h,"ajaxReq.open");
                ajaxReq.send=EGRUM.findAjax(ajaxReq.send,function(){
                    var xhr=this,r=xhr.s;
                    if(r){
                        r.sendTime=r.sendTime||(new Date).getTime();
                        var d=r.url,f=document.createElement("a");
                        f.href=d;d=document.location;
                        if (":"===f.protocol && "" === f.hostname && "" === f.port || f.protocol === d.protocol && f.hostname === d.hostname && f.port === d.port){
                            xhr.setRequestHeader("EGRUM","isAjax:true")
                        }
                        var k = 0,
                            f = function() {
                                if (4 == xhr.readyState) {
                                    setResProTime(xhr);
                                }
                                else{
                                    var h = null;
                                    try {
                                        h = xhr.onreadystatechange
                                    } catch (p) {
                                        setResProTime(xhr);
                                        return;
                                    }
                                    k++;
                                    h ? (EGRUM.isApply(h) ? (xhr.onreadystatechange = responseProcessTime(h,xhr,"ajaxReq.onReadyStateChange"))
                                        : setResProTime(xhr)) : k < 5 ? setTimeout(f,0) : setResProTime(xhr);
                                }
                            };
                        f();
                    }
                },h,"ajaxReq.send");
                var setResProTime=function(xhr){
                    if (xhr.s) {
                        var d = (new Date).getTime() + 3E4,
                            h = function() {
                                firstByte(xhr);
                                var r = xhr.s;
                                if (r) {
                                    var k = (new Date).getTime();
                                    4 == xhr.readyState ? (r.respProcTime = r.respProcTime || k, sendAjax(xhr,r),delete xhr.s) :
                                        (k < d ? setTimeout(h, 50) : (delete xhr.s));
                                }
                            };
                        h();
                    }
                }
                if (ajaxReq.addEventListener&&ajaxReq.removeEventListener){
                    ajaxReq.addEventListener=EGRUM.findAjax(ajaxReq.addEventListener,function(xhr,r){
                        if(this.s){
                            var d=Array.prototype.slice.call(arguments);
                            if (r&&("load"===xhr||"error"===xhr))
                            {
                                r.ajaxReq||(r.ajaxReq=responseProcessTime(r,this,"ajaxReq.invokeEventListener"));
                                d[1]=r.ajaxReq;
                            }
                            return d;
                        }
                    },h,"ajaxReq.addEventListener");
                    ajaxReq.removeEventListener=EGRUM.findAjax(ajaxReq.removeEventListener,function(xhr,r)
                    {
                        if(this.s){
                            var d=Array.prototype.slice.call(arguments);
                            if (r.ajaxReq){
                                d[1]=r.ajaxReq;
                            }
                            return d
                        }
                    },h,"ajaxReq.removeEventListener");
                }
            }
        }
    }
};
EGRUM.isApply= function(a) {
        return !a || "apply" in a;
    };
EGRUM.findAjax = function(xhr,r,d,f)
{
    r=r||function(){};
    xhr=xhr||function(){};
    d=d||function(){};
    return function()
    {
        var g=Array.prototype.slice.call(arguments),l;
        try
        {
            l=r.apply(this,g);
        }catch(m)
        {
            EGRUM.dprint("Failure in interceptor ["+f+"] entry: "+m);
        }
        var p=void 0;
        try
        {
            p=xhr.apply(this,l||g)
        }
        finally
        {
            try
            {
                d.apply(this,g);
            }catch(q){
                EGRUM.dprint("Failure in interceptor ["+f+"] exit:"+q);
            }
        }
        return p;
    }
};

EGRUM.splitXHRURL = function (a) {
    return (a = String(a).replace(/^\s+|\s+$/g, "").match(/^([^:\/?#]+:)?(\/\/(?:[^:@]*(?::[^:@]*)?@)?(([^:\/?#]*)(?::(\d*))?))?([^?#]*)(\?[^#]*)?(#[\s\S]*)?/)) ? {
        href: a[0] || "",
        protocol: a[1] || "",
        I: a[2] || "",
        host: a[3] || "",
        hostname: a[4] || "",
        port: a[5] || "",
        pathname: a[6] || "",
        search: a[7] || "",
        hash: a[8] || ""
    } : null
};

EGRUM.findXHRURL = function (a, b) {
    b = EGRUM.splitXHRURL(b || "");
    a = EGRUM.splitXHRURL(a || "");
    var c;
    if (!b || !a) c = null;
    else {
        c = (b.protocol || a.protocol) + (b.protocol || b.I ? b.I : a.I);
        var f;
        f = b.protocol || b.I || "/" === b.pathname.charAt(0) ? b.pathname : b.pathname ? (a.I && !a.pathname ? "/" : "") + a.pathname.slice(0, a.pathname.lastIndexOf("/") + 1) + b.pathname : a.pathname;
        var g = [];
        f.replace(/^(\.\.?(\/|$))+/, "").replace(/\/(\.(\/|$))+/g, "/").replace(/\/\.\.$/, "/../").replace(/\/?[^\/]*/g, function (a) {
            "/.." ===
            a ? g.pop() : g.push(a)
        });
        f = g.join("").replace(/^\//, "/" === f.charAt(0) ? "/" : "");
        c = c + f + (b.protocol || b.I || b.pathname ? b.search : b.search || a.search) + b.hash
    }
    return c
};

EGRUM.reportAjaxReq = function(a, b, d, f)
{
    var g = b.split("\r\n");
    b = [];
    for (var l = 0; l < g.length; l++)
        if (g[l].indexOf("BTMTIME") > -1) {
            var m = g[l].split(": ");
            2 === m.length && b.push(m[1]);
        }
        else if (g[l].indexOf("EGGUID") > -1)
        {
            var m = g[l].split(": ");
            2 === m.length && b.push(m[1]);
        }
    var FBT = a.firstByteTime - a.sendTime;
    var DDT = a.respAvailTime - a.firstByteTime;
    var DPT = a.respProcTime - a.respAvailTime;
    var ERP = a.respProcTime - a.sendTime;
    var browserDetails = EGRUM.getBrowserName();
    var deviceDetails = EGRUM.getDeviceDetails();
    var OSDetails = EGRUM.getOSDetails();
    var nAgt= navigator.userAgent;
    var strCookies = document.cookie;
    var referrer = document.referrer;
    referrer = referrer.split('?')[0];
    var cookiearray = strCookies.split(';');
    var sid = "";
    for(var i=0; i<cookiearray.length; i++){
        var name = cookiearray[i].split('=')[0];
        var value = cookiearray[i].split('=')[1];
        if(name == 'JSESSIONID')
            sid = value;
    }
    var url = a.url;
    var path = location.pathname;
    if(url.indexOf("http://") == -1 || url.indexOf("https://") == -1)
    {
        try
        {
            url = EGRUM.findXHRURL(document.location.href, url);
        }
        catch (err)
        {
            EGRUM.dprint("Error in getting AJAX absolute URL.");
        }
    }
    var beaconUrl = EGRUM["beacon-url"];
    beaconUrl = beaconUrl + "/rumcollector/rdr";
    var isBeaconUrl=EGRUM.isBeaconUrl(url);
    if(beaconUrl.trim().length !=0 && !isBeaconUrl){
        var serviceName = EGRUM["site"];
        var ajaxMes = "fbt="+FBT+",ddt="+DDT+",dpt="+DPT+",plt="+ERP;
        if(EGRUM.isJSONSupport()){
            var params = {"am":ajaxMes,"aju":url,"isaj":true,"bdt":browserDetails, "sid":sid,"osd":OSDetails,"dvdt":deviceDetails,"srn":serviceName, "agt":nAgt,"ref":referrer,"erc":"","err":""};
			//beaconUrl = beaconUrl +"?q="+ JSON.stringify(params);
			EGRUM.dprint("beaconUrl : " + beaconUrl);
            if (beaconUrl) {
                var xhr = new XMLHttpRequest();
                var paramStr = JSON.stringify(params);
                if (!window.XMLHttpRequest)
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                xhr.open("POST", beaconUrl, true);
                //xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                //xhr.send("q=" + paramStr);
				xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
                xhr.send(paramStr);
            }
        }else{
            var params = "am="+encodeURIComponent(ajaxMes)+"&aju="+encodeURIComponent(url)+"&isaj=true&bdt="+encodeURIComponent(browserDetails)+"&sid="+encodeURIComponent(sid)+"&osd="+encodeURIComponent(OSDetails)+"&dvdt="+encodeURIComponent(deviceDetails)+"&srn="+encodeURIComponent(serviceName)+"&agt="+encodeURIComponent(nAgt)+"&ref="+encodeURIComponent(referrer)+"&erc=&err=";
            beaconUrl = beaconUrl +"?"+ params;
			var i = new Image;
			i.src = beaconUrl;
        }
    }
    EGRUM.dprint(beaconUrl);
};
EGRUM.isJSONSupport=function(){
    if (typeof JSON === 'object' && typeof JSON.parse === 'function' && typeof JSON.stringify === 'function') {
        return true;
    }
    return false;
}

// Process any commands in the queue.
// The command queue is used to store calls to the API before the full script
// has been loaded.
EGRUM.processQ = function() {
    var len = EGRUM.q.length;
    for ( var i = 0; i < len; i++ ) {
        var aParams = EGRUM.q[i];
        var cmd = aParams[0];
        if ( "mark" === cmd ) {
            EGRUM.mark(aParams[1], aParams[2]);
        }
        else if ( "measure" === cmd ) {
            EGRUM.measure(aParams[1], aParams[2], aParams[3]);
        }
        else if ( "done" === cmd ) {
        }
    }
};

// Set a time marker (typically the beginning of an episode).
EGRUM.mark = function(markName, markTime) {
    EGRUM.dprint("EGRUM.mark: " + markName + ", " + markTime);

    if ( ! markName) {
        EGRUM.dprint("Error: markName is undefined in EGRUM.mark.");
        return;
    }

    EGRUM.marks[markName] = parseInt(markTime || new Date().getTime());

    if ( EGRUM.bPostMessage ) {
        window.postMessage("EGRUM:mark:" + markName + ":" + markTime, EGRUM.targetOrigin);
    }

    // Special marks that we look for:
    if ("navtiming" === markName)
    {
        EGRUM.measures = {};
        EGRUM.measure("plt", "starttime", "loadEventEnd");
        EGRUM.measure("fbt", "starttime", "responseStart");
        EGRUM.measure("sct", "starttime", "requestStart");
        EGRUM.measure("rat", "requestStart", "responseStart");
        EGRUM.measure("fet", "responseStart", "loadEventEnd");
        EGRUM.measure("drt", "responseStart", "domContentLoadedEventStart");
        EGRUM.measure("ddt", "responseStart", "responseEnd");
        EGRUM.measure("dpt", "responseEnd", "domContentLoadedEventStart");
        EGRUM.measure("prt", "domContentLoadedEventStart", "loadEventEnd");
        EGRUM.measure("dlt", "domainLookupStart", "domainLookupEnd");
        EGRUM.measure("tct", "connectStart", "connectEnd");
    }
    else
    {
        if ( "firstbyte" === markName ) {
            EGRUM.measure("fbt", "starttime", "firstbyte");
        }
        else if ( "onload" === markName ) {
            EGRUM.measure("fet", "firstbyte", "onload");
        }
        else if ("domContent" === markName)
        {
            EGRUM.measure("drt", "firstbyte", "domContent");
        }
        else if ( "done" === markName ) {
            EGRUM.measure("plt", "starttime", "done");
	    EGRUM.measure("prt", "domContent", "done");
        }
    }
};

// Measure an episode.
EGRUM.measure = function(episodeName, startNameOrTime, endNameOrTime) {
    try
    {
        EGRUM.dprint("EGRUM.measure: " + episodeName + ", " + startNameOrTime + ", " + endNameOrTime);

        if ( ! episodeName) {
            EGRUM.dprint("Error: episodeName is undefined in EGRUM.measure.");
            return;
        }
        var startEpochTime;
        if ( "undefined" === typeof(startNameOrTime) ) {
            if ( "number" === typeof(EGRUM.marks[episodeName]) ) {
                // If no startName is specified, then use the episodeName as the
				// start mark.
                startEpochTime = EGRUM.marks[episodeName];
            }
            else {
                // Create a "measure" that is this exact point in time?
                startEpochTime = new Date().getTime();
            }
        }
        else if ( "number" === typeof(EGRUM.marks[startNameOrTime]) ) {
            // If a mark with this name exists, use that.
            startEpochTime = EGRUM.marks[startNameOrTime];
        }
        else if ( "number" === typeof(startNameOrTime) ) {
            // Assume a specific epoch time is provided.
            startEpochTime = startNameOrTime;
        }
        else {
            EGRUM.dprint("Error: unexpected startNameOrTime in EGRUM.measure: " + startNameOrTime);
            return;
        }

        var endEpochTime;
        if ( "undefined" === typeof(endNameOrTime) ) {
            endEpochTime = new Date().getTime();
        }
        else if ( "number" === typeof(EGRUM.marks[endNameOrTime]) ) {
            // If a mark with this name exists, use that.
            endEpochTime = EGRUM.marks[endNameOrTime];
        }
        else if ( "number" === typeof(endNameOrTime) ) {
            endEpochTime = endNameOrTime;
        }
        else {
            EGRUM.dprint("Error: unexpected endNameOrTime in EGRUM.measure: " + endNameOrTime);
            return;
        }

        EGRUM.starts[episodeName] = parseInt(startEpochTime);
        EGRUM.measures[episodeName] = parseInt(endEpochTime - startEpochTime);
        if ( EGRUM.bPostMessage ) {
            window.postMessage("EGRUM:measure:" + episodeName + ":" + startEpochTime + ":" + endEpochTime, EGRUM.targetOrigin);
        }
    }
    catch (err)
    {
        EGRUM.dprint("Error in Measures "+ err);
    }
};

// In the case of Ajax or post-onload EGRUM, call done to signal the end of
// EGRUM.
EGRUM.done = function(callback) {
    EGRUM.bDone = true;


    EGRUM.mark("done");

    if ( EGRUM.autorun ) {
        EGRUM.sendBeacon();
    }

    if ( EGRUM.bPostMessage ) {
        window.postMessage("EGRUM:done", EGRUM.targetOrigin);
    }

    if ( "function" === typeof(callback) ) {
        callback();
    }
};

// Return an object of mark names and their corresponding times.
EGRUM.getMarks = function() {
    return EGRUM.marks;
};

// Return an object of episode names and their corresponding durations.
EGRUM.getMeasures = function() {
    return EGRUM.measures;
};

// Return an object of episode names and their corresponding durations.
EGRUM.getAjaxMeasures = function() {
    return EGRUM.AjaxMeasures;
};

// Return an object of episode names and their corresponding start times.
// This is needed so that we can determine the start and end time of a duration.
EGRUM.getStarts = function() {
    return EGRUM.starts;
};


// Construct a querystring of episodic time measurements and send it to the
// specified URL.
// url The URL to which to send the beacon request.
// This is the full path including filename, but without querystring params.
// Example: "http://yourdomain.com/gen204"
// A best practice is to return a 204 "No Content" response.
// If not specified then EGRUM.beaconUrl is used.
//
// params - An object of key|value pairs that are added to the URL's
// querystring.
// Example: { "pageType": "login", "dataCenter": "Wash DC" }
// That example would add this to the querystring:
// &pageType=login&dataCenter=Wash%20DC
//
EGRUM.sendBeacon = function(url, params) {

    EGRUM.dprint("sendbeacon called");
    url = url || EGRUM.beaconUrl;
    var perform = EGRUM.getPerformance();
    if ("undefined" != typeof(perform) && "undefined" != typeof(perform.timing))
    {
        if ("undefined" != typeof(perform.timing["requestStart"]))
        {
            EGRUM.mark("requestStart",perform.timing["requestStart"]);
            EGRUM.mark("responseStart",perform.timing["responseStart"]);
            EGRUM.mark("responseEnd",perform.timing["responseEnd"]);
            EGRUM.mark("domContentLoadedEventStart",perform.timing["domContentLoadedEventStart"]);
            EGRUM.mark("loadEventEnd",perform.timing["loadEventEnd"]);
            EGRUM.mark("domainLookupStart",perform.timing["domainLookupStart"]);
            EGRUM.mark("domainLookupEnd",perform.timing["domainLookupEnd"]);
            EGRUM.mark("connectStart",perform.timing["connectStart"]);
            EGRUM.mark("connectEnd",perform.timing["connectEnd"]);
            EGRUM.mark("navtiming");
        }
    }
    var measures = EGRUM.getMeasures();
    var browserDetails = EGRUM.getBrowserName();
    var deviceDetails = EGRUM.getDeviceDetails();
    var OSDetails = EGRUM.getOSDetails();
    var url = document.URL;
    var strCookies = document.cookie;
    var nAgt= navigator.userAgent;
    var referrer = document.referrer;
    referrer = referrer.split('?')[0];
    var cookiearray = strCookies.split(';');
    var errorCount = EGRUM.error.length;
    var errorMsg = "";
    for (var i = 0;i<errorCount;i++ )
    {
        var error=EGRUM.error[i].toString();
        if((errorMsg.length+error.length+3) < 2000 ) {
            errorMsg = errorMsg + "[" + error + "],";
        }
        else{
            break;
        }
    }
    if(errorMsg.lastIndexOf(',') == (errorMsg.length -1))
        errorMsg = errorMsg.substring(0,errorMsg.length-1);
    var iFrame = false;
    if (top == window)
    {
        iFrame = "false";
    }
    else
    {
        iFrame = "true";
    }
    var sid = "";
    for(var i=0; i<cookiearray.length; i++){
        var name = cookiearray[i].split('=')[0];
        var value = cookiearray[i].split('=')[1];
        if(name == 'JSESSIONID')
            sid = value;
    }
    var sTimes = "";
    for ( var key in measures ) {
    	if (EGRUM.isJSONSupport()) {
			sTimes += "," + key + ":" + measures[key];
		} else {
			sTimes += "," + encodeURIComponent(key) + ":" + measures[key];
		}
        EGRUM.dprint(key+"    "+measures[key]);
    }
    if(sTimes)
        sTimes = sTimes.substring(1);

    var beaconUrl = EGRUM["beacon-url"];
    if(beaconUrl.trim().length !=0 ) {
        var serviceName = EGRUM["site"];
        beaconUrl = beaconUrl + "/rumcollector/rdr";

        EGRUM.dprint(sTimes);
        if (EGRUM.isJSONSupport()) {
            var rt = EGRUM.getResourceTiming();
            var params = {
                "sid": sid,
                "prm": sTimes,
                "url": url,
                "bdt": browserDetails,
                "ifr": iFrame,
                "erc": errorCount,
                "err": errorMsg,
                "osd": OSDetails,
                "dvdt": deviceDetails,
                "agt": nAgt,
                "srn": serviceName,
                "ref": referrer,
                "rt": rt
            };
            var url = beaconUrl;
            EGRUM.dprint("beaconUrl : " + beaconUrl);
            if (url) {
                var xhr = new XMLHttpRequest();
                var paramStr = JSON.stringify(params);
                if (!window.XMLHttpRequest)
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                xhr.open("POST", beaconUrl, true);
                //xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
				//xhr.send("q=" + paramStr);
                xhr.setRequestHeader("Content-type", "text/plain; charset=UTF-8");
                xhr.send(paramStr);
            }
        }else{
            var params = "sid="+encodeURIComponent(sid)+"&prm="+sTimes+"&url="+encodeURIComponent(url)+"&bdt="+encodeURIComponent(browserDetails)+"&ifr="+iFrame+"&erc="+errorCount+"&err="+encodeURIComponent(errorMsg)+"&osd="+encodeURIComponent(OSDetails)+"&dvdt="+encodeURIComponent(deviceDetails)+"&agt="+encodeURIComponent(nAgt)+"&srn="+encodeURIComponent(serviceName)+"&ref="+encodeURIComponent(referrer);
            var url = beaconUrl +"?"+ params;
            EGRUM.dprint("beaconUrl : "+beaconUrl);
            if (url)
            {
                var img = new Image();
                img.src = url;
                return img.src;
            }
        }
    }
    return "";
};

EGRUM.getPerformance = function () {
    var perf = window.performance || window.mozPerformance || window.msPerformance || window.webkitPerformance;
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing))
    {
        return perf;
    }
};
// Use various techniques to determine the time at which this page started.
EGRUM.findStartTime = function() {
    var startTime = EGRUM.findStartWebTiming() || EGRUM.findStartGToolbar() || EGRUM.findStartCookie();
    if ( startTime ) {
        EGRUM.mark("starttime", startTime);
    }
};

// Find the start time from the Web Timing "performance" object.
// http://test.w3.org/webperf/specs/NavigationTiming/
// http://blog.chromium.org/2010/07/do-you-know-how-slow-your-web-page-is.html
EGRUM.findStartWebTiming = function() {
    var startTime = undefined;
    var perf = EGRUM.getPerformance();
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing) && "undefined" != typeof(perf.timing["navigationStart"]) ) {
        startTime = perf.timing["navigationStart"];
        EGRUM.dprint("EGRUM.findStartWebTiming: startTime = " + startTime);
    }
    return startTime;
};

// Find the start time from the Google Toolbar.
// http://ecmanaut.blogspot.com/2010/06/google-bom-feature-ms-since-pageload.html
EGRUM.findStartGToolbar = function() {
    var startTime = undefined;

    if ( "undefined" != typeof(window.external) && "undefined" != typeof(window.external.pageT) ) {
        startTime = (new Date().getTime()) - window.external.pageT;
    }
    else if ( "undefined" != typeof(window.gtbExternal) && "undefined" != typeof(window.gtbExternal.pageT) ) {
        startTime = (new Date().getTime()) - window.gtbExternal.pageT();
    }
    else if ( "undefined" != typeof(window.chrome) && "undefined" != typeof(window.chrome.csi) ) {
        startTime = (new Date().getTime()) - window.chrome.csi().pageT;
    }

    if ( startTime ) {
        EGRUM.dprint("EGRUM.findStartGToolbar: startTime = " + startTime);
    }

    return startTime;
};

// Find the start time based on a cookie set by EGRUM in the unload handler.
EGRUM.findStartCookie = function() {
    var aCookies = document.cookie.split(' ');
    for ( var i = 0; i < aCookies.length; i++ ) {
        if ( 0 === aCookies[i].indexOf("EGRUM=") ) {
            var aSubCookies = aCookies[i].substring("EGRUM=".length).split('&');
            var startTime, bReferrerMatch;
            for ( var j = 0; j < aSubCookies.length; j++ ) {
                if ( 0 === aSubCookies[j].indexOf("s=") ) {
                    startTime = aSubCookies[j].substring(2);
                }else if ( 0 === aSubCookies[j].indexOf("r=") ) {
                    var startPage = aSubCookies[j].substring(2);
                    bReferrerMatch = ( encodeURIComponent(document.referrer) == startPage );
                }
                else if (0 === aSubCookies[j].indexOf("BTMTIME="))
                {
                    var btmTime = aSubCookies[j].substring(2);
                }
            }
            if (startTime ) {
                EGRUM.dprint("EGRUM.findStartCookie: startTime = " + startTime);
                return startTime;
            }
        }
    }
    return undefined;
};

EGRUM.getDeviceDetails = function() {
    var nAgt= navigator.userAgent;
    var iphone = false;
    var android = false;
    var windowsPhone = false;
    var androidTablet = false;
    var ipad = false;
    if((nAgt.indexOf("Mobile")) != -1)
    {
        iphone = true;
    }
    if((nAgt.indexOf("Android")) != -1)
    {
        android = true;
        if((nAgt.indexOf("Mobile")) == -1){ // If there is no ''mobile' in
											// user-agent (Android have that on
											// their phones, but not tablets)
            androidTablet = true;
        }
    }
    if((nAgt.indexOf("Phone")) != -1)
    {
        windowsPhone = true;
    }
    if((nAgt.indexOf("iPad")) != -1)
    {
        ipad = true;
    }

    if(androidTablet || ipad){ // If it's a tablet (iPad / Android)
        return 'Tablet';
    }
    else if((iphone && !ipad) || (android && !androidTablet) || windowsPhone){ // If
																				// it's
																				// a
																				// phone
																				// and
																				// NOT
																				// a
																				// tablet
        return "Mobile";
    }
    else{ // If it's not a mobile device
        return 'Desktop';
    }
};

EGRUM.getOSDetails = function()
{
    var navPlatform = navigator.userAgent;
    if((navPlatform.indexOf("iPad")) != -1)
    {
        return 'iOS - iPad';
    }
    else if((navPlatform.indexOf("iPhone")) != -1 || (navPlatform.indexOf("iPod")) != -1)
    {
        return 'iOS - iPhone';
    }
    else if ((navPlatform.indexOf("Android")) != -1)
    {
        return 'Android';
    }
    else if ((navPlatform.indexOf("win")) != -1 || (navPlatform.indexOf("Win")) != -1 || (navPlatform.indexOf("Windows")) != -1)
    {
        return 'Windows';
    }
    else if((navPlatform.indexOf("mac")) != -1 || (navPlatform.indexOf("Mac")) != -1)
    {
        return 'Mac';
    }
};

EGRUM.getBrowserName = function()
{
    var nAgt= navigator.userAgent;
    var nVer = navigator.appVersion;
    var browserName  = navigator.appName;
    var fullVersion  = ''+parseFloat(navigator.appVersion);
    var majorVersion = parseInt(navigator.appVersion,10);
    var nameOffset,verOffset,ix;
    var isIE11=!!navigator.userAgent.match(/Trident.*rv[ :]*11\./);
    var edgeMatched=nAgt.match(/(edge)\/((\d+)?[\w\.]+)/i);
    if(edgeMatched){
        browserName = "Microsoft Edge";
        fullVersion = edgeMatched[3];
    }
    else if(isIE11){
        browserName = "Internet Explorer";
        fullVersion = "11.0";
        var ua = navigator.userAgent;
        var re  = new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})");
        if (re.exec(ua) != null)
            fullVersion = RegExp.$1 ;
    }        
    else if ((verOffset=nAgt.indexOf("Opera"))!=-1 || (verOffset=nAgt.indexOf("OPR"))!=-1)
    {
        browserName = "Opera";
        fullVersion = nAgt.substring(verOffset+6);
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
    }
    // In MSIE, the true version is after "MSIE" in userAgent
    else if ((verOffset=nAgt.indexOf("MSIE"))!=-1)
    {
        browserName = "Internet Explorer";
        fullVersion = nAgt.substring(verOffset+5);
    }
    // In Chrome, the true version is after "Chrome"
    else if ((verOffset=nAgt.indexOf("Chrome"))!=-1)
    {
        browserName = "Chrome";
        fullVersion = nAgt.substring(verOffset+7);
    }
    // In iPhone OS, the true version in after "iPhone OS"
    else if ((verOffset=nAgt.indexOf("iPad")) != -1 || (verOffset=nAgt.indexOf("iPhone")) != -1 || (verOffset=nAgt.indexOf("iPod")) != -1)
    {
        browserName = "iOS Mobile";
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
        // fullVersion =
		// nAgt.substring(nAgt.indexOf("Version")+9,nAgt.indexOf("Version")+12);
    }
    // In Firefox, the true version is after "Firefox"
    else if ((verOffset=nAgt.indexOf("Firefox"))!=-1)
    {
        browserName = "Firefox";
        fullVersion = nAgt.substring(verOffset+8);
    }
    // In Android Browser, the true version in after "Andriod"
    else if ((verOffset=nAgt.indexOf("Android"))!=-1)
    {
        browserName = "Android Mobile";
        fullVersion = nAgt.substring(verOffset+8);
    }
    // In Safari, the true version is after "Safari" or after "Version"
    else if ((verOffset=nAgt.indexOf("Safari"))!=-1)
    {
        browserName = "Safari";
        fullVersion = nAgt.substring(verOffset+7);
        if ((verOffset=nAgt.indexOf("Version"))!=-1)
            fullVersion = nAgt.substring(verOffset+8);
    }
    // In most other browsers, "name/version" is at the end of userAgent
    else if ((nameOffset=nAgt.lastIndexOf(' ')+1) < (verOffset=nAgt.lastIndexOf('/')))
    {
        browserName = "Others";// nAgt.substring(nameOffset,verOffset);
        /*
		 * fullVersion = nAgt.substring(verOffset+1); if
		 * (browserName.toLowerCase()==browserName.toUpperCase()) { browserName =
		 * navigator.appName; }
		 */
    }
    if ((ix=fullVersion.indexOf(";"))!=-1)
        fullVersion=fullVersion.substring(0,ix);
    if ((ix=fullVersion.indexOf(" "))!=-1)
        fullVersion=fullVersion.substring(0,ix);

    majorVersion = parseInt(''+fullVersion,10);
    if (isNaN(majorVersion))
    {
        fullVersion  = ''+parseFloat(navigator.appVersion);
        majorVersion = parseInt(navigator.appVersion,10);
    }
    return browserName + " " + fullVersion;
};

// Set a cookie when the page unloads. Consume this cookie on the next page to
// get a "start time".
// Doesn't work in some browsers (Opera).
EGRUM.beforeUnload = function(e) {
    EGRUM.beforeUnload = function () {};
    EGRUM.setCookie(document.location.href,
        document.domain, "https:" === document.location.protocol, function () {
            return document.cookie
        }, function (a) {
            document.cookie = a
        })

};

EGRUM.setCookie = function (a, b, c, f, g) {
    a = "EGRUM=s=" + Number(new Date) + "&r=" + encodeURIComponent(a);
    var l = a + ";path=/";
    c && (l += ";secure");
    if (!window.EGRUM.useStrictDomainCookies) {
        c = f();
        b = b.split(".");
        for (var k = "", p = b.length - 1; 0 <= p; p--) {
            k = "." + b[p] + k;
            g(l + ";domain=" + k);
            var r = f();
            if (r != c && 0 <= r.indexOf(a)) {
                return
            }
        }
    }
    g(l);
};

EGRUM.domContentLoaded = function () {
    if(!EGRUM.contentLoadFired)
    {
        EGRUM.mark("domContent", (new Date).getTime());
        EGRUM.contentLoadFired = true;
    }
};

EGRUM.readyStateChange = function () {
    "complete" === document.readyState && EGRUM.domContentLoaded();
};

// When the page is done do final wrap-up.
EGRUM.onload = function() {
    var perf = EGRUM.getPerformance();
    if ( "undefined" != typeof(perf) && "undefined" != typeof(perf.timing) && "undefined" != typeof(perf.timing["navigationStart"]) ) {
        setTimeout(function () {
            EGRUM.mark("onload");
            var perform = EGRUM.getPerformance();
            if ( EGRUM.autorun ) {
                EGRUM.done();
            }
        }, 10);
    }
    else
    {
        EGRUM.mark("onload");
        if ( EGRUM.autorun ) {
            EGRUM.done();
        }
    }
};

// Wrapper for addEventListener and attachEvent.
EGRUM.addEventListener = function(sType, callback, bCapture) {
    try
    {
        EGRUM.dprint("window.addEventListener  "+typeof(window.addEventListener));
        if ( "undefined" != typeof(window.attachEvent) ) {
            return window.attachEvent("on" + sType, callback);
        }
        else if ("undefined" != typeof(window.addEventListener)){
            return window.addEventListener(sType, callback, bCapture);
        }
    }
    catch (err)
    {
        EGRUM.dprint("Error in addEventListener "+ err);
    }
};

// Wrapper for debug log function.
if ( "undefined" != typeof(console) && "undefined" != typeof(console.log) ) {
    EGRUM.dprint = function(msg) {
        if(debug == true)
            console.log(msg);
    };
}
else {
    EGRUM.dprint = function(msg) { };
}

EGRUM.getResourceTiming=function(){
    var performance=EGRUM.getPerformance();
    if ("undefined" == typeof(performance.getEntriesByType))
        return {};
    var rsrcArr = performance.getEntriesByType("resource");
    var pageObj=window.performance.timing;
    pageObj.name=document.URL;
    pageObj.initiatorType="other";
    var originTime=pageObj.navigationStart;
    rsrcArr.splice(0,0, pageObj);
    var rsrcData=[];

    for (var i = 0; i < rsrcArr.length; i++) {
        var pfmObj=rsrcArr[i];
        var formatType=EGRUM.getFormatType(pfmObj);
        var rsrcNetworkTime=[0];
        var startTime=pfmObj.startTime || pfmObj.navigationStart;
        var mdata=EGRUM.formatTypes[formatType];
        var isBeacon=EGRUM.isBeaconUrl(pfmObj.name);
        if(!isBeacon) {
            for (var j = 1; j < mdata.length; j++) {
                rsrcNetworkTime.push(Math.max(-1, Math.round(pfmObj[mdata[j]] - startTime)));
            }
            rsrcData.push({
                "tm": rsrcNetworkTime,
                "ofst": Math.round(pfmObj.startTime) || 1,
                "init": EGRUM.getInitiatorType(pfmObj.initiatorType, pfmObj.name),
                "url": EGRUM.urlShortner(pfmObj.name),
                "rsrctyp": EGRUM.getResourceType(pfmObj.name),
                "frmt": formatType
            });
        }
    }
    return {"rsrc":rsrcData, "timeOrigin":originTime, "initType":"", "initTypeCount":EGRUM.initiatorTypeCount,
                "rsrcType":"", "rsrcTypeCount":EGRUM.resourceTypeCount};
};
EGRUM.resourceTypes = {"other": "0", "css": "1", "script": "2", "img": "3", "svg": "4", "html": "5", "font": "6", "video":"0", "audio":"0"};
EGRUM.resourceTypeCount = {};
EGRUM.confConst={
    urlln:"140",
    prtclln:"10",
    hostln:"30",
    portln:"10",
    srchln:"30",
    hashln:"30",
    fileln:"40"
};
EGRUM.shortner=function (str, limit) {
    if (3 >= limit)return "...";
    str.length > limit && (str = str.substring(0, limit - 3) + "...");
    return str;
};
EGRUM.urlMake=function(host, path, file, srch, hash) {
    return 0 == path.length ? (host + file + srch + hash) : (host + path.join("/") + "/" + file + srch + hash);
};
EGRUM.urlShortner=function(url){
    var a=EGRUM.splitXHRURL(url),
    host=EGRUM.urlShortner.host(a.protocol, a.hostname, a.port),
    search = EGRUM.shortner(a.search, this.confConst.srchln),
    hash = EGRUM.shortner(a.hash, this.confConst.hashln),
    pathArr=a.pathname.split("/");
    file=pathArr.length > 0 ? pathArr.pop():"";
    file=EGRUM.urlShortner.file(file, EGRUM.confConst.fileln);

    for(a=EGRUM.urlMake(host, pathArr, file, search, hash); a.length > EGRUM.confConst.urlln;){
        pathArr.pop();
        pathArr.push("...");
        a=EGRUM.urlMake(host, pathArr, file, search, hash);
        pathArr.pop();
    }
    return a;
};
EGRUM.urlShortner.file=function (a, b) {
    if (3 >= b)return "...";
    a.length > b && (a = a.substring(0, (b - 3) / 2) + "..." + a.substring(a.length - (b - 3) / 2, a.length));
    return a
};
EGRUM.urlShortner.host=function(protcl, hostName, port){
    protcl.length <= EGRUM.confConst.prtclln || (protcl = EGRUM.shortner(protcl, EGRUM.confConst.prtclln - 1), protcl += ":");
    hostName = EGRUM.shortner(hostName, EGRUM.confConst.hostln);
    port = EGRUM.shortner(port, EGRUM.confConst.portln);
    return 0 < port.length ? protcl + "//" + hostName + ":" + port : protcl + "//" +hostName;
};
EGRUM.getResourceType=function(url){
    var fontExt=["ttf", "otf", "woff", "woff2", "eot", "cff", "afm", "lwfn", "ffil", "fon", "pfm", "pfb", "std", "pro", "xsf"];

    var imgExt=["jpg", "jpeg", "jpe", "jif", "jfif", "jfi", "jp2", "j2k", "jpf", "jpx", "jpm", "jxr",
                "hdp", "wdp", "mj2", "webp", "gif", "png", "apng", "mng", "tiff", "tif", "xbm", "bmp","dib"];

    var svgExt=["svg", "svgz"];

    var mmVideo=["mpg", "mpeg", "mpeg2", "avi", "wmv", "mov", "rm", "ram", "swf", "flv", "ogg", "webm", "mp4", "ts"];

    var mmAudio=["mid", "midi", "rm", "ram", "wma", "aac", "wav", "ogg", "mp3", "mp4"];

    var htmlExt=["html", "htm", "shtml", "xhtml"];

    var scriptExt=["js"];
    var cssExt=["css"];

    var pathName=EGRUM.splitXHRURL(url).pathname;
    var extension=pathName.split('\\').pop().split('/').pop().split('.').pop().trim();
    var type=EGRUM.resourceTypes[extension];

    if(!type){ type = htmlExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["html"] : ""; }
    if(!type){ type = cssExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["css"] : ""; }
    if(!type){ type = scriptExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["script"] : ""; }
    if(!type){ type = fontExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["font"] : ""; }
    if(!type){ type = imgExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["img"] : ""; }
    if(!type){ type = svgExt.indexOf(extension) >=0 ? EGRUM.resourceTypes["svg"] : ""; }
    if(!type){ type = mmVideo.indexOf(extension) >=0 ? EGRUM.resourceTypes["video"] : ""; }
    if(!type){ type = mmAudio.indexOf(extension) >=0 ? EGRUM.resourceTypes["audio"] : ""; }
    if(!type){ type=EGRUM.resourceTypes["other"];}

    EGRUM.resourceTypeCount[type] = ( EGRUM.resourceTypeCount[type] ? EGRUM.resourceTypeCount[type] : 0 ) + 1;
    return type;
};

EGRUM.initiatorTypes={"other":"0", "link":"1", "css":"2", "script":"3", "img":"4", "object":"5", "frame":"6",
    "iframe":"7", "xmlhttprequest":"8", "embed":"9", "audio":"0", "video":"0", "svg":"12"};
EGRUM.initiatorTypeCount={};
EGRUM.getInitiatorType=function(initType, url){
    var num=EGRUM.initiatorTypes[initType];
    EGRUM.initiatorTypeCount[num] = (EGRUM.initiatorTypeCount[num]?EGRUM.initiatorTypeCount[num]:0) + 1;
    return num;
};

EGRUM.formatTypes={"1":["startTime", "redirectStart", "redirectEnd", "fetchStart", "domainLookupStart", "domainLookupEnd",
                            "connectStart", "connectEnd", "requestStart", "responseStart", "responseEnd"],
                    "2": ["startTime", "fetchStart", "responseEnd"]};
EGRUM.getFormatType=function(perfmObj){
    return perfmObj.fetchStart <= perfmObj.domainLookupStart ? "1" : "2";
};
EGRUM.isBeaconUrl=function(url) {
    var beaconUrl = EGRUM["beacon-url"];
    beaconUrl = beaconUrl + "/rumcollector/rdr";
    var beaconRegex = new RegExp(beaconUrl);
    return url.match(beaconRegex);
}
EGRUM.init();
}
};
})();