#!/bin/sh 
#########################################################################################
# Author: Shashi Bhusan									#
#  Date: 26/09/2001									#
#  Modified on: 28.09.2001								#
# 											#
#This script call EgPerfmonitor class which writes performance data to file to be used 	#
#  be used by the eG Agent	
#########################################################################################
						
# get DB2 instance name attached to user
db2instance=$DB2INSTANCE

#set path for Java

PATH=$PATH:/usr/java/jdk1.3.1/bin
export PATH

# set egurkha home directory 
EG_HOME=/opt/egurkha
export EG_HOME

#Get port
port=$1
export port
#set egurkha agent directory
AGENT_DIR=$EG_HOME/agent/config
export AGENT_DIR

#Remove existing lock file from the agent config directory
rm -f $AGENT_DIR/*.loc
rm -f  $AGENT_DIR/*.dat

#default test period
testPeriod=3

#set classpath for EgPerfmonitor
CLASSPATH=$EG_HOME/lib/eg_agent.jar:$EG_HOME/lib/eg_util.jar:$CLASSPATH
export CLASSPATH
isJRE16=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "1.6" | wc -l`
isJRE17=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "1.7" | wc -l`
if [ $isJRE17 -eq 0 ]
then
	isJRE17=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "1.8" | wc -l`
fi
isJRE10=`/opt/egurkha/jre/bin/java -version 2>&1 | grep "10." | wc -l`

export isJRE16
export isJRE17
export isJRE10

javaCmd="java "
if [ "$isJRE16" -ge "1" ]
then
        javaCmd="java -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null "
fi
if [ "$isJRE17" -ge "1" ]
then
        javaCmd="java -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash "
fi
if [ "$isJRE10" -ge "1" ]
then
        javaCmd="java -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash "
fi

# Sleep for test period and keep on running at this interval
while sleep $testPeriod
do
	$javaCmd EgPerfMonitor $port $db2instance 

	# If test frequency is vailable in file read it else continue with default
	# test period
	if [ -f $AGENT_DIR/db2$port.frq ]
	then
		testPeriod=`cat $AGENT_DIR/db2$port.frq`
	fi
done


 



