// JavaScript Document
Ext.define('utilities.Utilities_builder', {
    extend: 'Ext.toolbar.Toolbar',
    alias: 'widget.utilitiestool_builder',
    id: 'toolbar',
	requires:[
	    'utilities.GroupBooklet',
		],
		// this method Contains 11 inputs 11th inuput for booklet
		// but it shows in 1st
    loadIcon: function (save, printing, mail, data, csv, favorite,
        schedule, diagnosis, arrow, closed,booklet) {
		if (booklet) {
            this.add({
                xtype: 'container',
                //margin : '0 1px 0 1px',
                id: 'bookletTool',
                cls: 'iconBg',
                disabled: true,
                items: [{
                    xtype: 'groupBooklet',
                    iconCls: 'iconCombinedReport',
                    style: {
                        background: 'none',
                        border: '0px'
                    }
                }]
            }, {
                xtype: 'tbseparator',
				id:'bookletSeparator'
            });
        }
        if (save) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                id: 'saveTool',
                cls: 'iconBg',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconSave',
                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: toolSave
                            });
                        }
                    }
                }]
            }/*,{
                xtype: 'tbseparator',
				id:'saveSeparator'
            }*/);
        }
        if (printing) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                id: 'printTool',
                cls: 'iconBg',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconPrinter',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: toolPrint
                            });
                        }
                    }
                }]
            }/*,{
                xtype: 'tbseparator',
				id:'printSeparator'
            }*/);
        }
        if (mail) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                id: 'mailTool',
                cls: 'iconBg',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconMail',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: toolMail
                            });
                        }
                    }
                }]
            }/*, {
                xtype: 'tbseparator',
				id:'mailSeparator'
            }*/);

        }
        if (data) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg',
                id: 'dataTool',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconData',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: toolData
                            });
                        }
                    }
                }]
            }/*, {
                xtype: 'tbseparator',
				id:'DataSeparator'
            }*/);
        }
        if (csv) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg',
                id: 'csvTool',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconCsv',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: toolCSV
                            });
                        }
                    }
                }]
            }/*, {
                xtype: 'tbseparator',
				id: 'csvToolSeparator',
				itemId: 'csvToolSeparator'
            }*/);
        }
        if (favorite) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg',
                id: 'favoriteTool',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconFavorite',
                    id: 'favImg',
                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Save as Favorite'
                            });
                        }
                    }
                }]
            }/*, {
                xtype: 'tbseparator',
				id:'favoriteSeparator'
            }*/);
        }
        if (schedule) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg',
                id: 'scheduleTool',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconSchedule',
                    id: 'scheduleImg',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Schedule this Report'
                            });
                        }
                    }
                }]
            });
        }
        if (diagnosis) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg',
                id: 'diagnosisTool',
                disabled: true,
                items: [{
                    xtype: 'button',
                    iconCls: 'iconDiagnosis',
                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Diagnosis'
                            });
                        }
                    }
                }]
            }/*, {
                xtype: 'tbseparator',
				id:'diagnosisSeparator'
            }*/);
        }
        if (arrow) {
            this.add({
                xtype: 'button',
                itemId: 'upbutton',
                enableToggle: true,
                id: 'upbutton',
                disabled: true,
                iconCls: 'iconPanelDownArrow', //iconArrowTop1
                style: {
                    background: 'none',
                    border: '0px'
                },
				 listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Show Header'
						});
					}
				},
                handler: function () {
                    if (this.pressed == true) {
                        this.setIconCls('iconPanelUpArrow');
						if (!Ext.isEmpty(Ext.getCmp('selectionDetails')))
								Ext.getCmp('selectionDetails').show();
                    } else {
                        this.setIconCls('iconPanelDownArrow');
						if (!Ext.isEmpty(Ext.getCmp('selectionDetails')))
							Ext.getCmp('selectionDetails').hide();
                    }
                }
            });
        }
        if (closed) {
            this.add({
                xtype: 'container',
                margin : '0 5px 0 5px',
                cls: 'iconBg close',
                id: 'closeTool',
                items: [{
                    xtype: 'button',
                    iconCls: 'iconWrong',

                    style: {
                        background: 'none',
                        border: '0px'
                    },
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Close'
                            });
                        }
                    }
                }]
            });
        }
    }
});