<!DOCTYPE html>

<%
/*******************************************************************************
*	File name			:	ErVDIAssessmentPrint.jsp
*	Purpose				:	Print Page For Virtual Desktop Insight - VDI Assessment
*	Author				:	A.MuraliKanth
*	Creation Date		:	27/11/2012 - (dd/mm/yyyy)
********************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.EgSorter" %>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils"%>

<%
String titleToDisplay=request.getParameter("er_RmDispName");					
	String subjectForChart = "Desktop_Insight_Resource_Usage_Chart_Details";
	String subjectForConfig = "Desktop_Insight_Resource_Usage";
	String subjectForApp = "Desktop_Insight_Application_Activity";

	EgReportInfo reportInfo = new EgReportInfo("manager");
	ErUtils erUtils = new ErUtils();
	EgDbInfo dbInfo=new EgDbInfo("manager");

	HashMap chartAttributeMaps=null;
	HashMap MeasureGroupWithUnit=null;	
	HashMap unitForMeasure=null;	
	HashMap HighRangeDesktopCountMap=null;
	ArrayList overAllData=null;
	ArrayList DataAvailableMeasureGroup=null;
	ArrayList MeasureGrup=null;

	String hasShowAllDesktops=reportInfo.getValue(subjectForConfig,"ShowAllDesktopData");
	String measurGroupForSortingFromIni=reportInfo.getValue(subjectForApp,"sortOnTheBasisOf");
	String sortOnForUsage=reportInfo.getValue(subjectForConfig,"sortOnForUsage");
	String doubleByteEnabled=new Boolean(dbInfo.doubleByteEnabled).toString();
	String fontStyleDblSingl = "";
	String reporttype=request.getParameter("reporttype");
	String subtype=request.getParameter("subtype");
	String selectedCompType=request.getParameter("er_componentType");
	String selectedGroup=request.getParameter("er_group");
	String analysis_data=request.getParameter("analyseDataBy");
	String er_mode=request.getParameter("er_mode");
	String s_st_time=request.getParameter("startdate");
	String s_en_time=request.getParameter("enddate");
	String s_st_hr=request.getParameter("starthr");
	String s_en_hr=request.getParameter("endhr");
	String strmin=request.getParameter("startmin");
	String enmin=request.getParameter("endmin");
	String Hourfrom = request.getParameter("timefrom");
	String Minfrom = request.getParameter("minfrom");
	String Hourto = request.getParameter("timeto");
	String Minto = request.getParameter("minto");
	String pdfSave = request.getParameter("pdfSave");
	String pdfPrint = request.getParameter("pdfPrint");
	String dispStartDate=s_st_time+" "+s_st_hr+" Hrs "+strmin+" Mins ";
	String dispEndDate=s_en_time+" "+s_en_hr+" Hrs "+enmin+" Mins ";
	String timfrom=Hourfrom+":"+Minfrom;
	String timto=Hourto+":"+Minto;
	String measurGroupForSorting="";
	Float minusFive = new Float(-5.0f);
	/** result data getting starts **/
	if(reporttype!=null && reporttype.equalsIgnoreCase("vdi_insight"))
	{
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			chartAttributeMaps=(HashMap)session.getAttribute("chartMaps");
			MeasureGroupWithUnit=(HashMap)session.getAttribute("MeasureGroupWithUnit");
			HighRangeDesktopCountMap=(HashMap)session.getAttribute("HighRangeDesktopCountMap");
			overAllData=(ArrayList)session.getAttribute("overAllDataByDesktop");
			DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroup");
			if(HighRangeDesktopCountMap!=null && !HighRangeDesktopCountMap.isEmpty())
			{
				ArrayList max_values=new ArrayList(HighRangeDesktopCountMap.values());
				Integer maxObj=(Integer)Collections.max(max_values);
				Iterator highRangeMapItr=HighRangeDesktopCountMap.keySet().iterator();
				while(highRangeMapItr.hasNext())
				{
					String msureGroup=(String)highRangeMapItr.next();
					Integer highrangeInt=(Integer)HighRangeDesktopCountMap.get(msureGroup);
					if(highrangeInt.equals(maxObj))
					{
						measurGroupForSorting=msureGroup;
						continue;
					}
				}
				int noOfColumn=DataAvailableMeasureGroup.size();
				int columnId=0;
				if(sortOnForUsage!=null)
				{
					columnId=DataAvailableMeasureGroup.indexOf(sortOnForUsage);
				}
				if(columnId==-1 && measurGroupForSorting!=null)
				{
					columnId=DataAvailableMeasureGroup.indexOf(measurGroupForSorting);
				}
				if(columnId==-1)
					columnId=0;
				EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
				columnId+=2;
				overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
			}
		}
		else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
		{
			unitForMeasure = (HashMap)session.getAttribute("unitForMeasure");
			overAllData=(ArrayList)session.getAttribute("overallDataByAppln");
			DataAvailableMeasureGroup=(ArrayList)session.getAttribute("DataAvailableMeasureGroups");
			MeasureGrup =(ArrayList)session.getAttribute("MeasureGrup");
			if(overAllData!=null && overAllData.size()>0)
			{
				//sorting starts
				int noOfColumn=DataAvailableMeasureGroup.size();
				int columnId=0;
				if(measurGroupForSortingFromIni!=null && DataAvailableMeasureGroup!=null && DataAvailableMeasureGroup.size()>0)
				{
					columnId=DataAvailableMeasureGroup.indexOf(measurGroupForSortingFromIni);
				}
				if(columnId==-1)
					columnId=0;
				EgSorter sortObj = new EgSorter(overAllData,noOfColumn);
				columnId+=2;
				overAllData=(ArrayList)sortObj.sort(columnId,"Float","desc");
			}
			//sorting ends
		}
	}
	/**ends**/
	if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && !(pdfSave !=null && pdfSave.equalsIgnoreCase("yes")))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}

		if(throughSchedule!=null && throughSchedule.equalsIgnoreCase("true"))
		{			 
			s_st_time = DateUtil.changeDateFormat(s_st_time.trim(),"dd-MM-yyyy",strUserDateFormat);
			s_en_time = DateUtil.changeDateFormat(s_en_time.trim(),"dd-MM-yyyy",strUserDateFormat);
		}
	EgTimeZoneConverter converterStart =new   EgTimeZoneConverter(s_st_time+" "+s_st_hr+":"+strmin,thisuser);
	String st_dateTime = converterStart.getDateTime()+" "+"hrs ";
	EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(s_en_time+" "+s_en_hr+":"+enmin,thisuser);
	String en_dateTime = converterEnd.getDateTime()+" "+"hrs ";

%>
<html>
	<head>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter"/> &nbsp; &nbsp;</title>

<meta name="Author" content="">
<meta  charset="UTF-8">

	<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />

<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}

.newimg{page-break-inside:avoid}

</style>
		<!--<egui:skin ui="reporter"/>-->
</head>

<!--<body  style="padding:10px;background-color:#ffffff">-->
<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfSave !=null && pdfSave.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}else
		strLogCls = "printPdfHeaderBoxLogo";
%>
		<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0"/></div>

<!--<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;">
	<tr>
		<td width="100%" align="center" valign="top">-->

<%
		/*if((pdfSave!=null && pdfSave.equalsIgnoreCase("yes")) ||( throughSchedule!=null && throughSchedule.equalsIgnoreCase("true")))
		{*/
%>
			<!--<table cellpadding="0" cellspacing="2" border="0" width="100%" align="center">
				<tr>
					<td class="cellbgwhite"><img src="<%=imageName%>" border="0" /></td>
				</tr>
			</table>-->
<%
		//}
%>
			<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px" align="left">-->
				
				<div class="printHeaderBox">

<%
		if (!StringUtils.isNull(titleToDisplay))
		{
%>
						<!--<div style="float:left;" > <header><%=titleToDisplay%></header></div>-->
						<div class="printHeaderBoxTitle"><%=titleToDisplay%></div>
<%
		}
		else
		{
%>

						<!--<div style="float:left;" > <header><egui:intnl text="reporter.common.Virtual Desktop Insight"/> -->
						<div class="printHeaderBoxTitle"><%=titleToDisplay%>- 
<%
			if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
			{
%>
								<egui:intnl text="reporter.common.Resource Usage" />
<%
			}
			else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
			{
%>
								<egui:intnl text="reporter.common.Application Activity" />
<%
			}
%>
						</div>
<%
		}
%>





<%
		if((pdfSave!=null && pdfSave.equalsIgnoreCase("yes")) ||( throughSchedule!=null && throughSchedule.equalsIgnoreCase("true")))
		{
%>
						<!--nothing going here-->
							<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  id="prin tbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
		}
		else
		{
%>
						<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse"  id="prin tbt" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="window.print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
		}
%>
					<!--</td>
				</tr>
			</table>-->
			</div>
			
			<div class="printOuterBoxNoBorder">
			<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
				<tr>
					<td align="left" valign="top" width="50%">-->
						<!--<div style="float:left;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl type="<%=selectedCompType%>"/></div>
						</div>-->
						<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><egui:intnl type="<%=selectedCompType%>" /></span></div>

						<!--<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl text='<%="reporter.common."+selectedGroup%>'/></div>
						</div>-->
						<div class="printSelectionFields"><egui:intnl text="reporter.common.Analysis By" /> - <span class="bold"><egui:intnl text='<%="reporter.common."+selectedGroup%>' /></span></div>

<%
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
%>
						<!--<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis Data By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>-->
							 <div class="printSelectionFields"><egui:intnl text="reporter.common.Analysis Data By" />-
<%
			if(analysis_data!=null && analysis_data.equalsIgnoreCase("user"))
			{
%>
							<!--<div style="float:left;" class="formValue"><egui:intnl text="reporter.common.User"/></div>-->
							<span class="bold"><egui:intnl text="reporter.common.User" /></span>
<%
			}
			else
			{
%>
							<!--<div style="float:left;" class="formValue"><egui:intnl text="reporter.common.Desktop"/></div>-->
							<span class="bold"><egui:intnl text="reporter.common.Desktop" /></span>
<%
			}
%>
						</div>
<%
		}
%>

<%
		if(subtype!=null && subtype.equalsIgnoreCase("application_activity") && DataAvailableMeasureGroup.contains(measurGroupForSortingFromIni))
		{
%>
						<!--<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Data Sorted By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><egui:intnl text='<%="reporter.common."+measurGroupForSortingFromIni%>'/></div>
						</div>-->
						<div class="printSelectionFields"><egui:intnl text="reporter.common.Data Sorted By" /> - <span class="bold"><egui:intnl text='<%="reporter.common."+measurGroupForSortingFromIni%>' /></span></div>

<%
		}
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			String tmp_sort=reportInfo.getValue(subjectForChart,measurGroupForSorting);
%>
						<!--<div style="float:left;clear:both;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Data Sorted By"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%></div>
						</div>-->
						<div class="printSelectionFields"><egui:intnl text="reporter.common.Data Sorted By" /> - <span class="bold"><egui:intnl text='<%=tmp_sort.substring(tmp_sort.indexOf(" on ")+4)%>' /></span></div>
			<%
		}
			%>
					</td>
					<td align="right" valign="top">
						<!--<div style="float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.StartDate"/></div>
							<div style="float:left;width:10px" align="center" >:</div>
							<div style="float:left;" class="formValue"><%=st_dateTime%></div>
						</div>
						<div style="clear:both;float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.EndDate"/></div>
							<div style="float:left;width:10px" align="center">:</div>
							<div style="float:left;" class="formValue"><%=en_dateTime%></div>
						</div>-->
						<div class="printSelectionFields">Timeline - <span class="bold"><%=st_dateTime%> to <%=en_dateTime%></span></div>

						<!--<div style="clear:both;float:right;padding:4px;">
							<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Time Period"/></div>
							<div style="float:left;width:10px" align="center">:</div>
							<div style="float:left;" class="formValue"><%=timfrom%>&nbsp;<egui:intnl text="reporter.common.to"/>&nbsp;<%=timto%></div>
						</div>-->
						<div class="printSelectionFields">Time Period - <span class="bold"><%=timfrom%>&nbsp;<egui:intnl text="reporter.common.hrs" /> to <%=timto%>&nbsp;<egui:intnl text="reporter.common.hrs" /></span></div>

				<!--</td>
				</tr>
			</table>-->
			</div>
		<!--</td>
	</tr>
</table>-->
 <div class="printOuterBox" style="padding-right:0px">	
<%
		if(subtype!=null && subtype.equalsIgnoreCase("resource_usage"))
		{
			//String tmp_sort=reportInfo.getValue(subjectForChart,measurGroupForSorting);
%>
	<table align="center" width="100%" cellspacing="0" cellpadding="0"  border="0" >
<%
			if(DataAvailableMeasureGroup!=null && !DataAvailableMeasureGroup.isEmpty())
			{
%>
<%
				if(DataAvailableMeasureGroup.size()>1)
				{
%>
	<col width="50%"><col width="50%">
<%
				}
				int noOfCharts=DataAvailableMeasureGroup.size();
				int chartCount=0;
				for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
				{
					String queryStrPie="/final/servlet/com.eg.ErVDIAssessmentController;jsessionid=" + session.getId() +"?&er_view=IMAGE&reporttype="+reporttype+"&subtype="+subtype+"&doubleByteEnabled="+doubleByteEnabled+"&er_mode="+er_mode+"&analyseDataBy="+analysis_data;
					String measureGroup=(String)DataAvailableMeasureGroup.get(i);
					HashMap chartAttributes=(HashMap)chartAttributeMaps.get(measureGroup);
					if(chartAttributes == null || chartAttributes.size()==0)
						continue;
					ArrayList sampleLabels=(ArrayList)chartAttributes.get("sampleLabels");
					ArrayList DataSet=(ArrayList)chartAttributes.get("sampleValues");
					ArrayList colorList=(ArrayList)chartAttributes.get("sampleColors");
					String chartTitle=(String)chartAttributes.get("chartTitle");
					String dynamicDivName="chart"+chartCount+"div";
					queryStrPie+="&measureGroup="+measureGroup;
					if(chartCount%2==0)
					{
%>
	<tr class="newimg"> 
<%
					}
					String custom_chartType = reportInfo.getValue("Desktop_Insight_Resource_Usage","chartType");
					String er_width = "200";
					String er_height = "200";
					if(custom_chartType!=null && custom_chartType.equalsIgnoreCase("bar"))
					{
						er_width = "400";
						er_height = "300";
					}
%>
		<td width="50%" style="padding:0px 10px 10px 0px">
		<div class="printOuterBox">
		<div class="printOuterBoxHeader"><%=chartTitle%></div>	
			<table  align="center" width="100%" cellspacing="0" cellpadding="0" >
				<tr>
					<!--<td align="center" class="printTableHeader2"><b><%=chartTitle%></b></td>-->

					
				</tr>
				<tr class="newimg">
						<div>
							<td align="center"><img src="<%=queryStrPie%>&er_width=<%=er_width%>&er_height=<%=er_height%>&chartFor=distribution"scrolling="no" align="center" frameborder="0"></img></td>
						</div>
				</tr>
<%
				if(custom_chartType==null || !custom_chartType.equalsIgnoreCase("bar"))
				{
%>
				<tr>
					<td align="center" width="100%">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<!--<td>-->
									<!--<div style="display:inline-block;margin:auto;border:0px solid red">-->
<%
					for(int jk=0;sampleLabels.size()>jk;jk++)
					{
						String manualLabel=(String)sampleLabels.get(jk);
						String colorForLegend=(String)colorList.get(jk);
						Integer vmCount=(Integer)DataSet.get(jk);
						if(vmCount.intValue()!=0)
						{
%>
									<td> <div><svg height="12" width="12"><circle cx="4" cy="7" r="3" fill="<%=colorForLegend%>" stoke-width="0" /></svg></div> </td>
									<td style="float:left;text-align:left;"><%=manualLabel%>&nbsp;&nbsp;</td>
										<!--<div style="float:left;padding:4px;border :0px solid red">
											<div style="float:left;width:8px;height:8px;border-radius:50px;background-color:<%=colorForLegend%>;margin:5px" class="blankspace"></div>
											<div style="float:left;text-align:left;"><%=manualLabel%></div>
											<div style="float:left;width:5px;">&nbsp;</div>
										</div>-->
<%
						}
					}
%>
									<!--</div>
								</td>-->
							</tr>
						</table>
					</td>
				</tr>
<%
				}
%>
			</table>
		</div></td>
<%
					if(noOfCharts%2>0 && noOfCharts==chartCount+1)
					{
%>
		<td align="center" >&nbsp;</td>
<%
					}
%>
<%
					if(chartCount!=0 && chartCount%2>0)
					{
%>
	</tr>
<%					}
					chartCount++;
				}
%>
</tr>
</table>
<%
				if(DataAvailableMeasureGroup!=null)
				{
%>
<div class="newTable" style="padding-right:10px">
	<table align="center" width="100%" cellspacing="0" cellpadding="0"  border="0">
		<thead>
		<tr align="center">
			<th align ="left" style="width:150px" ><egui:intnl text="reporter.common.Desktop"/></th>
	<%
						for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
						{
								String measures=(String)DataAvailableMeasureGroup.get(i);
								String tmp=reportInfo.getValue(subjectForChart,measures);
								String MappedMeasure=tmp.substring(tmp.indexOf(" on ")+4);
	%>
			<th align="center" > <egui:intnl text='<%="reporter.common."+MappedMeasure%>'/>
	<%
							if(measurGroupForSorting!=null && measurGroupForSorting.equals(measures))
							{
	%>
											<!--<img src="/final/reporter/images/Light/gcircle.gif" align="center"/>-->
	<%
							}
	%>
			</th>
	<%
						}
	%>
		</tr>
		</thead>
	<%
				//	} dataavailablemeasuregroup if loop ends
						if(MeasureGroupWithUnit!=null && DataAvailableMeasureGroup!=null)
						{
	%>
		<thead>
		<tr>
			<th align ="center" class="subHeader">&nbsp;</th>

	<%
							for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
							{
								String measures=(String)DataAvailableMeasureGroup.get(i);
								String unit=(String)MeasureGroupWithUnit.get(measures);
	%>
			<th align="center" class="subHeader"> <%=unit%> </th>
	<%
							}
	%>
		</tr>
		</thead>
		<tbody>
	<%
						}
					}
					if(overAllData!=null && !overAllData.isEmpty())
					{
						int noOfRows=overAllData.size();
						if(hasShowAllDesktops!=null && hasShowAllDesktops.equalsIgnoreCase("No"))
						{
							int maxDesktop=Integer.parseInt(reportInfo.getValue(subjectForConfig,"MaximumDesktops"));
							int noOfRowsToDisplay=Integer.parseInt(reportInfo.getValue(subjectForConfig,"noOfDesktopToDisplay"));
							if(noOfRows>maxDesktop && maxDesktop>noOfRowsToDisplay)
								noOfRows=noOfRowsToDisplay;
						}
						for(int i=0;noOfRows>i;i++)
						{
							ArrayList dataList=(ArrayList)overAllData.get(i);
							String s_desktop=(String)dataList.get(0);
							
	%>

		<tr>
			<td align="left"  class="tdClass"><div style="width:200px;word-wrap: break-word; overflow-x:auto;"><%=s_desktop%></div></td>
	<%
							if(dataList!=null)
							{
								for(int j=1;dataList.size()>j;j++)
								{
									Float data=(Float)dataList.get(j);

									if(data.compareTo(minusFive)>0)
									{
										float f_data=data.floatValue();
	%>
			<td align="center"  class="tdClass"><%=erUtils.round(f_data,4)%></td>
	<%
									}
									else
									{
	%>
			<td align="center"  class="tdClass">-</td>
	<%
									}
								}
							}
	%>
		</tr>
	<%
						}
					}
				}
				else
				{
	%>
		<tr>
			<td height="20" >&nbsp;</td>
		</tr>
		<tr>
			<td height="26" align="center" ><egui:intnl text="reporter.common.No measures available for the current selection"/> </td>
		</tr>
		<tr>
			<td height="20">&nbsp;</td>
		</tr>
	<%
				}
	%>
		
		</tbody>
	</table>
</div>
<%
		}
		else if(subtype!=null && subtype.equalsIgnoreCase("application_activity"))
		{
%>

 <table align="center" width="100%" cellspacing="0" cellpadding="0" style="table-layout:auto" >

<%
			if(MeasureGrup!=null && !MeasureGrup.isEmpty())
			{
%>
<%
				if(MeasureGrup.size()>1)
				{
					System.out.println("coming--->");
%>
	<col width="50%"><col width="50%">
<%
				}
				int noOfCharts=MeasureGrup.size();
				int chartCount=0;
				String title = "";
				for(int i=0;MeasureGrup.size()>i;i++)
				{
					String queryStrBar="/final/servlet/com.eg.ErVDIAssessmentController;jsessionid=" + session.getId() +"?&er_view=IMAGE&reporttype="+reporttype+"&subtype="+subtype+"&doubleByteEnabled="+doubleByteEnabled+"&er_mode="+er_mode+"&analyseDataBy="+analysis_data;
					String measureGroup=(String)MeasureGrup.get(i);
					title =reportInfo.getValue(subjectForApp,measureGroup);
					String dynamicDivName="chart"+chartCount+"div";
					queryStrBar+="&measureGroup="+measureGroup;
					if(chartCount%2==0)
					{
%>
	<tr>
<%
					}
%>
		<td align="center" style="padding:0px 10px 10px 0px" >
			<div class="printOuterBox">
				<div class="printOuterBoxHeader"><%=title%></div>
			<table class="printTable" align="center" width="100%" cellspacing="0" cellpadding="2" style="table-layout:fixed">
				
				<tr>
					<td>
						<div style="width:100%;border : 0px solid red" id="<%=dynamicDivName%>" align="center" >
<%
					if(DataAvailableMeasureGroup!=null && DataAvailableMeasureGroup.contains(measureGroup))
					{
%>
							<img src="<%=queryStrBar%>&er_width=350&er_height=400&chartFor=distribution"scrolling="no" align="center" frameborder="0"></img> 
<%
					}
					else
					{
%>
							<img src='/final/images/Light/nomeasures_custom.png' width="100%"><!--BLANK CELL OR NO GRAPH-->&nbsp;  </div>
<%
					}
%>
						</div>
					</td>
				</tr>
			</table>
			<div>
		</td>
<%
					if(noOfCharts%2>0 && noOfCharts==chartCount+1)
					{
%>
		<td align="center" >&nbsp;</td>
<%
					}
					if(chartCount!=0 && chartCount%2>0)
					{
%>
	</tr>
<%
					}
					chartCount++;
				}
%>
<%
			}
			else
			{
%>
<table align="center" width="100%" cellspacing="0" cellpadding="0" style="table-layout:fixed">
	<tr>
		<td align="center" ><egui:intnl text="reporter.common.No measures available for the current selection"/></td>
	</tr>
</table>
<%
			}
%>	
</table>
<%//data for application activity starts
			if(DataAvailableMeasureGroup!=null && overAllData!=null && overAllData.size()>0)
			{
%>
<div class="newTable" style="padding-right:10px">
<table align="center" width="100%" cellspacing="0" cellpadding="0" class="printTable" border="0" >
	<thead>
	<tr align="center">
		<th align ="left"  ><egui:intnl text="reporter.common.Application"/></th>
<%
				for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
				{
					String measures=(String)DataAvailableMeasureGroup.get(i);
%>
		<th align="center" ><egui:intnl text='<%="reporter.common."+measures%>'/></th>
<%
				}
%>
	</tr>
	</thead>
<%
				if(unitForMeasure!=null)
				{
%>
	<thead>
	<tr>
		<th align ="center" class="subHeader">&nbsp;</th>
<%
					for(int i=0;DataAvailableMeasureGroup.size()>i;i++)
					{
						String measures=(String)DataAvailableMeasureGroup.get(i);
						String unit=(String)unitForMeasure.get(measures);
%>
		<th align="center" class="subHeader">(<%=unit%>)</th>
<%
					}
%>
	</tr>
	</thead>
	<tbody>
<%
				}
				if(overAllData!=null && !overAllData.isEmpty())
				{
					for(int i=0;overAllData.size()>i;i++)
					{
						ArrayList dataList=(ArrayList)overAllData.get(i);
						String s_appln=(String)dataList.get(0);
%>

	<tr>
		<td align="left" class="tdClass"><div style="width:100px;word-wrap: break-word; overflow-x:auto;"><%=s_appln%></div></td>
<%
						if(dataList!=null)
						{
							for(int j=1;dataList.size()>j;j++)
							{
								String highlightClass="";
							/*	if(sortbyColumnhighlight==j)
								{
									highlightClass="tdborder2";
								}*/
								Float data=(Float)dataList.get(j);
								if(data.compareTo(minusFive)>0)
								{
									float f_data=data.floatValue();
%>
		<td align="center" class="tdClass" ><%=erUtils.round(f_data,4)%></td>
<%
								}
								else
								{
%>
		<td align="center" class="tdClass" >-</td>
<%
								}
							}
						}
%>
	</tr>
<%
					}
				}
%>

	</tbody>
</table>
</div>

<%
			}//data for application activity ends
		}
%>
</div>
</body>
</html>
<%@ include file="ErRemoveUser.jsp"%>
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="printFooterText"><%=strPrintFooterText%></div>
<%
	}
%>


<%
			if(titleToDisplay!=null && !titleToDisplay.isEmpty())
	{
	//For Setting the PDf File Name
	String reportFileName=customReplaceAll(titleToDisplay," ","_");
	HashMap paramVal =new HashMap();
	paramVal.put("fileName",reportFileName);
	session.setAttribute("parameters", paramVal);
	}

%>
<%!
	// karthikeyan 
    public  String customReplaceAll(String source,String toReplace,String replacement) {
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) {
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
    //

%>

