<%
/*******************************************************************************
*	File name		:	ErEventLogViewerJSON.jsp
*	Purpose			:	To view Windows Host Event Log Data
*	Author			:	Krishnamurthi.S (Start Date : 02/07/2007)
*	Creation Date	:	
*******************************************************************************/
%>

<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import="java.util.Collection"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Arrays"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.Vector"%>
<%@ page import="java.util.TreeMap"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="egurkha.reporter.ErEventLogViewer"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="egurkha.reporter.ErReportHelper"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import="com.egurkha.util.DateUtil" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="egurkha.reporter.ErTimeLineBean"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.reporter.ErEventLogRequestData"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgName"%>

<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8"%>
<%
try
{
	int systemCount=0;
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd=null;
	
	List aListCompType1 =new ArrayList();

	String queryStringForNewUI = (String)ErUtils.prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	JSONObject selectedObj = new JSONObject();
	JSONObject hiddens = new JSONObject();
	JSONObject selectionDetails = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject backgroundResultObj = new JSONObject();
	JSONObject resultsObj = new JSONObject();
	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start
	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	String datafrom = request.getParameter("er_dataFrom");

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	String backButtonEnable = request.getParameter("back");
	rootJson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("EventLogData",null);
		request.setAttribute("EventLogData_other",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End
	EgCrawler CrawlerBean = new EgCrawler(new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_topology.ini"));
	//For CSV creation
	List lst       = new LinkedList();
	Vector vec     = new Vector();
	List lst_dat   = new LinkedList();
	Vector vec_1   = new Vector();
	List lst_dat_1 = new LinkedList();
	String s_tit_1 = "";
	Vector vec_2   = new Vector();
	List lst_dat_2 = new LinkedList();
	String s_tit_2 = "";
	Vector vec_0   = new Vector();
	List lst_dat_0 = new LinkedList();
	String s_tit_0 = "";
	Hashtable sen  = new Hashtable();
	
%>
<%!
	//String reportfrom=request.getParameter("reportfrom");
	//String[] logServers = {"EventLog_server","Win_generic_server","Windows_server","Client_desktop","Citrix_AG_server"};
	String[] sortOrders = {"Descending","Ascending"};
	long msecsPerHour = (long) 1000 * 60 * 60;
	String[] eventLogTests = {"AppEvtLogTest","SystemEvtLogTest","SecurityLogTest"};

	//Returns only event log components
	private ArrayList getEventLogComponents(List listComponents,List listEventLogServers)
	{
		ArrayList aListComponents = new ArrayList();
		for (int m=0;m<listComponents.size();m++)
		{
			String component = (String)listComponents.get(m);
			String componentType = component.substring(0,component.indexOf(":"));
			if (listEventLogServers.contains(componentType))
			{
				aListComponents.add(component);
			}
		}
		return aListComponents;
	}
	private ArrayList getEventLogComponentType(List listComponents,List listEventLogServers)
	{
		ArrayList aListComponents = new ArrayList();
		for (int m=0;m<listComponents.size();m++)
		{
			String component = (String)listComponents.get(m);
			String componentType = component.substring(0,component.indexOf(":"));
			if (listEventLogServers.contains(componentType))
			{
              if (!aListComponents.contains(componentType))
				aListComponents.add(componentType);
			}
		}
		return aListComponents;
	}

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}
%>
<%
	//Back Button - Start
	//String bggroundStr = (String)request.getAttribute("bggroundStr");
	//String status = (String)request.getAttribute("status");
	//Back Button - End
    EgReportInfo reportInfo=new EgReportInfo("manager");
	String defaultloadmain=request.getParameter("defaultloadd");
	String changecomp=request.getParameter("changecomp");
    String er_componontType = request.getParameter("er_componontType");
	String reportfrom=request.getParameter("reportfrom");
	String er_logType = request.getParameter("er_logType");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	//Declaration Section
	ErUtils erUtils = new ErUtils();
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");

	ErEventLogViewer erEventLogViewer = new ErEventLogViewer();

	ErEventLogRequestData requestData = new ErEventLogRequestData(request);
	
	Hashtable htableRequestData = requestData.populate();
	erEventLogViewer.setRequestData(htableRequestData);

	EgGroupInfo egGroupInfo = new EgGroupInfo();
	EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();
	boolean flagAll = false;
	boolean rowExists=false;
	EgDateInfo egDateInfo = new EgDateInfo();
	ErReportHelper erReportHelper = new ErReportHelper();
	IniUI iniUI = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
	List listEventLogServerTypes = Arrays.asList(egSpecsInfo.getEventLogTypes());
	String er_criteria = request.getParameter("er_criteria");
		if(er_criteria==null||er_criteria.equals(""))
			er_criteria="System";
	String er_subzone = request.getParameter("er_subzone");
	String er_userOption = request.getParameter("er_userOption");
	String[] er_system = request.getParameterValues("er_system");
	String er_categoryType = request.getParameter("er_categoryType");
	String er_descriptor = request.getParameter("er_descriptor");
	String strQry = "";
	String divStatus = request.getParameter("divStatus");
	String srcForImg="";
	if(divStatus==null)
	{
		divStatus="none";
	}

	if(divStatus.equals("none"))
	{
		srcForImg="/final/images/moreoption.png";
	}
	else if(divStatus.equals("block"))
	{
		srcForImg="/final/images/lessoption.png";
	}

	//For Upgrade purpose only -Start
	String requestFrom = request.getHeader("REFERER");
	if (er_descriptor != null && er_descriptor.equals("-1") && requestFrom != null && requestFrom.indexOf("/servlet/ErFavoriteC?cmd=View") != -1)
	{
		er_descriptor = "all";
	}
	else if (er_descriptor == null && er_logType != null && er_logType.equalsIgnoreCase("Security") && requestFrom != null && requestFrom.indexOf("/servlet/ErFavoriteC?cmd=View") != -1)
	{
		er_descriptor = "[all]";
	}
	//For Upgrade purpose only - End

	String er_user = request.getParameter("er_user");
	String er_eventType = request.getParameter("er_eventType");
	String er_eventSource = request.getParameter("er_eventSource");
	String er_sortBy = request.getParameter("er_sortBy");
	if (er_sortBy == null)
	{
		er_sortBy = "EVENT_DATE";
	}
	String er_sortOrder = request.getParameter("er_sortOrder");
	String er_timeline = request.getParameter("er_timeline");
	String er_stdate = request.getParameter("er_stdate");
	String er_enddate = request.getParameter("er_enddate");
	String er_sthr = request.getParameter("er_sthr");
	String er_endhr = request.getParameter("er_endhr");
	String stMin = request.getParameter("startmin");
	String endMin = request.getParameter("endmin");

	//Parameters used in the logic for selecting all items in the system select box
	String er_criteriaPrevious = request.getParameter("er_criteriaPrevious");
	String er_userOptionPrevious = request.getParameter("er_userOptionPrevious");

	String s_treeParam = request.getParameter("treeCompType");
	
	//For getting components related to the user
	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(session.getId());
	Vector vecUserAssociatedComponents = new Vector(user.getServers(false));

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter=new MappingNameSorter(userLanguage);
	//end user language

	//prakash
	String er_descriptorTemp = er_descriptor;
	if(er_descriptor!=null && er_descriptor.equalsIgnoreCase("all"))
	{
		er_descriptorTemp = mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_descriptor);
	} //

	//UI Date format
	String currentDateFormat = strUserDateFormat;
	boolean isClientPrinter = false;
    
	s_tit_0=mappingInfo.getTextDescription("reporter.compliance.eventlog.SELECTION DETAILS");
	vec_0.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Search by"));
    lst_dat_0.add('"'+mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_criteria)+'"');

	//Added to fetch the DDD date format - start
	List aListCompType = getEventLogComponentType(vecUserAssociatedComponents,listEventLogServerTypes);
	
	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		isClientPrinter = true;
		String zonecomps=reportInfo.getTimeFrame("MISC","CtxZoneComponents"); 
		StringTokenizer strtok1 = new StringTokenizer(zonecomps,",");
		while(strtok1.hasMoreTokens())
		{
			String val = strtok1.nextToken();
			if(aListCompType.contains(val))
			{
				aListCompType1.add(val);
			}
		} 
	}
	else
	{
	  aListCompType1.addAll(aListCompType); 
	}
	
	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		List list=new ArrayList();
		list.add("Citrix_server");
		list.add("Citrix_XcXenApp_server");
		aListCompType1=list;
	} 
	listEventLogServerTypes=aListCompType1;
	if(aListCompType1==null || (aListCompType1!=null && aListCompType1.size()==0))
	{
		vecUserAssociatedComponents= new Vector();
	}
	List eventLogAllComps=new ArrayList();
	//Filter event log components from user associated components
	if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
	{
		if(s_treeParam!=null && s_treeParam.length() > -1)
		{
			Vector v_vecUserAssociatedComponents = new Vector();
			for(int vu=0; vu< vecUserAssociatedComponents.size();vu++)
			{
				String thisComp = (String)vecUserAssociatedComponents.get(vu);
				if(thisComp.indexOf(s_treeParam)>-1)
				{
					v_vecUserAssociatedComponents.add(thisComp);
				}
			}
			vecUserAssociatedComponents = new Vector();
			vecUserAssociatedComponents.addAll(v_vecUserAssociatedComponents);
		}

		ArrayList aListComponents=getEventLogComponents(vecUserAssociatedComponents,listEventLogServerTypes);
		eventLogAllComps.addAll(aListComponents);
		 if(er_componontType !=null && !er_componontType.equalsIgnoreCase("-1") && listEventLogServerTypes.contains(er_componontType))
		{
			List compType=new ArrayList();
			compType.add(er_componontType);
			aListComponents=getEventLogComponents(vecUserAssociatedComponents,compType);
		}
		if (!aListComponents.isEmpty())
			vecUserAssociatedComponents = new Vector(aListComponents);
		else
			vecUserAssociatedComponents =  new Vector();
	}
	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();
	Vector vecCriterias = null;
	Vector vecIncludeSubzones = null;
	Vector vecUserOptions = null;
	Vector vecSystems = null;
	Vector vecLogTypes = null;
	Vector vecColumns = null;
	Vector vecDescriptors = null;
	Vector vecUsers = null;
	Vector vecEventTypes = null;
	Vector vecCategoriesTypes = null;
	Vector vecEventSources = null;
	Vector vecSortOrders = null;
	boolean includeSubzoneFlag = true;

	String reqFromSchedule = request.getParameter("fromSchedule");
	Map reqMap = request.getParameterMap();
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String schedule_id = request.getParameter("schedule_id");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	if(favorite_id==null)
	{
		favorite_id = request.getParameter("favorite_id");
	}
	String er_favorite = request.getParameter("er_favorite");

	vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}
	
	ArrayList aListAssociatedComponents = null;
	//Map eventLogZoneCompMap=new HashMap();
		if (er_criteria != null && !er_criteria.equals("-1"))
		{
			if (er_criteria.equalsIgnoreCase(criterias[0]))
			{
				List zoneList = user.getZones();

				// To filter zones not containing eventlog server types
				vecUserOptions = new Vector();
				for (int i=0;i<zoneList.size();i++)
				{
					String zone = (String)zoneList.get(i);
					ArrayList aListZoneComponents = egGroupInfo.getAllComponentsUnderZone(zone,true);
					for (int j=0;j<aListZoneComponents.size();j++)
					{
						String component = (String)aListZoneComponents.get(j);
						String componentType = component.substring(0,component.indexOf(":"));
						if (listEventLogServerTypes.contains(componentType))
						{
							vecUserOptions.add(zone);
							break;
						}
					}
				}
				//To fetch all components from user associated zones
				ArrayList aListComponentsFromZone = new ArrayList();
				for (int i=0;i<vecUserOptions.size();i++)
				{
					String strZone = (String)vecUserOptions.get(i);
					List compList=egGroupInfo.getAllComponentsUnderZone(strZone,true);
					aListComponentsFromZone.addAll(compList);
					//eventLogZoneCompMap.put(strZone,compList);
				}

				if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
				{
					aListComponentsFromZone = getEventLogComponents(aListComponentsFromZone,listEventLogServerTypes);
					if (!aListComponentsFromZone.isEmpty())
					{
						boolean defaultZoneExists = false;
						for (int i=0;i<eventLogAllComps.size();i++)
						{
							String component = (String)eventLogAllComps.get(i);
							if (!aListComponentsFromZone.contains(component))
							{
								defaultZoneExists = true;
								break;
							}
						}
						if (defaultZoneExists)
						{
							vecUserOptions.add(0,"--Default--");
						}
					}
					else
					{
						vecUserOptions.add("--Default--");
					}
				}
				else
				{
					vecUserOptions.add("--Default--");
				}
				if(vecUserOptions!=null && vecUserOptions.size()>0)
				{
					if(er_userOption==null)
					{
						er_userOption=(String)vecUserOptions.get(0);
					}
				}
				if (er_userOption != null && !er_userOption.equals("-1"))
				{
					if (er_subzone != null && er_subzone.equalsIgnoreCase("No"))
						includeSubzoneFlag = false;

					if (!er_userOption.equalsIgnoreCase("--Default--"))
					{
						aListAssociatedComponents = egGroupInfo.getAllComponentsUnderZone(er_userOption,includeSubzoneFlag);
					}
					else
					{
						aListAssociatedComponents = new ArrayList();
						for (int i=0;i<eventLogAllComps.size();i++)
						{
							String userComponent = (String)eventLogAllComps.get(i);
							int index = aListComponentsFromZone.indexOf(userComponent);
							if (index < 0)
								aListAssociatedComponents.add(userComponent);
						}
						List aListAssociatedDefaultComponents=new ArrayList(aListAssociatedComponents);
						//eventLogZoneCompMap.put("--Default--",aListAssociatedDefaultComponents);
					}
					if(aListAssociatedComponents==null || aListAssociatedComponents.size()==0)
					{
						aListCompType1=new ArrayList();
					}
				}
				else
				{
					aListCompType1=new ArrayList();
				}
			}
			else if (er_criteria.equalsIgnoreCase(criterias[1]))
			{
				List serviceList = new ArrayList();
				String userid = UBean.getUserId();
				ErUserData user1=new ErUserData(userid,false);
				serviceList.addAll(user1.getSites());
				//serviceList.addAll(user.getServices());

				// To filter services not containing eventlog server types
				vecUserOptions = new Vector();
				for (int i=0;i<serviceList.size();i++)
				{
					String service = (String)serviceList.get(i);
					Vector vecServiceComponents = CrawlerBean.getAssociates(service);
					for (int j=0;j<vecServiceComponents.size();j++)
					{
						String component = (String)vecServiceComponents.get(j);
						String componentType = component.substring(0,component.indexOf(":"));
						if (listEventLogServerTypes.contains(componentType))
						{
							vecUserOptions.add(service);
							break;
						}
					}
				}
				if(vecUserOptions!=null && vecUserOptions.size()>0)
				{
					if(er_userOption==null)
					{
						er_userOption=(String)vecUserOptions.get(0);
					}
				}
				if (er_userOption != null && !er_userOption.equals("-1"))
				{
					Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(er_userOption);
					if (vecServiceComponents != null)
						aListAssociatedComponents = new ArrayList(vecServiceComponents);
				} 
				else
				{
					aListCompType1=new ArrayList();
				}
			}
			else if (er_criteria.equalsIgnoreCase(criterias[2]))
			{
				List segmentList = user.getSegments();

				// To filter segments not containing eventlog server types
				vecUserOptions = new Vector();
				for (int i=0;i<segmentList.size();i++)
				{
					String segment = (String)segmentList.get(i);
					Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(segment,2,true);
					for (int j=0;j<vecSegmentComponents.size();j++)
					{
						String component = (String)vecSegmentComponents.get(j);
						String componentType = component.substring(0,component.indexOf(":"));
						if (listEventLogServerTypes.contains(componentType))
						{
							vecUserOptions.add(segment);
							break;
						}
					}
				}
				if(vecUserOptions!=null && vecUserOptions.size()>0)
				{
					if(er_userOption==null)
					{
						er_userOption=(String)vecUserOptions.get(0);
					}
				}
				if (er_userOption != null && !er_userOption.equals("-1"))
				{
					Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(er_userOption,2,true);
					if (vecSegmentComponents != null)
						aListAssociatedComponents = new ArrayList(vecSegmentComponents);
				} 
				else
				{
					aListCompType1=new ArrayList();
				}
			}
			else
			{
				if(eventLogAllComps!=null)
					aListAssociatedComponents =new ArrayList(eventLogAllComps);
			}
		}
		else
		{
			vecUserOptions=new Vector();
			aListAssociatedComponents=new ArrayList();
			aListCompType1=new ArrayList();
		}
		if(er_userOption != null)
		{
			selectedObj.put("systemUserOption",er_userOption);
		}
	if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
	{ 
		vecIncludeSubzones = new Vector();
		for (int h=0;h<includeSubzones.length;h++)
		{
			String str = includeSubzones[h];
			vecIncludeSubzones.add(str);
		} 

		if (aListAssociatedComponents != null && !aListAssociatedComponents.isEmpty())
		{
			if (er_criteria != null && !er_criteria.equals("-1") && !er_criteria.equalsIgnoreCase(criterias[3]))
			{
				aListAssociatedComponents = getEventLogComponents(aListAssociatedComponents,listEventLogServerTypes);
			}
			List eventLogAssociatedCompTypesList=new ArrayList();
			for (int z=0;z<aListAssociatedComponents.size();z++)
			{
				String comp = (String)aListAssociatedComponents.get(z);
				String compType=comp.substring(0,comp.indexOf(":"));
				eventLogAssociatedCompTypesList.add(compType);
			}
			Set eventLogAssociatedCompTypesSet=new HashSet(eventLogAssociatedCompTypesList);
			eventLogAssociatedCompTypesList=new ArrayList(eventLogAssociatedCompTypesSet);

		
			if(er_componontType==null)
			{
				List sortedNameList1 = sorter.getSortedCompTypeList(eventLogAssociatedCompTypesList);
				if(sortedNameList1!=null && sortedNameList1.size()>0)
				{
					EgName obj_name2 = (EgName)sortedNameList1.get(0); 
					er_componontType= obj_name2.getActualName(); 
				}
			}
			aListCompType1=eventLogAssociatedCompTypesList;
		
			if(er_componontType !=null && !er_componontType.equalsIgnoreCase("-1") && listEventLogServerTypes.contains(er_componontType))
			{
				List compType=new ArrayList();
				compType.add(er_componontType);
				aListAssociatedComponents=getEventLogComponents(aListAssociatedComponents,compType);
			}
			List aListAssociatedComponents1=new ArrayList();
			List aListAssociatedComponents2=new ArrayList();
			if(aListAssociatedComponents !=null && aListCompType1!=null && aListCompType1.size()>0 &&  reportfrom!=null && reportfrom.equals("Printer Management"))
			{
				for (int z=0;z<aListAssociatedComponents.size();z++)
				{
					String comp = (String)aListAssociatedComponents.get(z);
					String compType=comp.substring(0,comp.indexOf(":"));
					if(aListCompType1.contains(compType))
					{
						aListAssociatedComponents1.add(comp);
					}
				}
				aListAssociatedComponents2.addAll(aListAssociatedComponents1); 
			}
			else
				aListAssociatedComponents2.addAll(aListAssociatedComponents); 

			if (!aListAssociatedComponents.isEmpty())
			{
				EgBoxView boxView = new EgBoxView();
				boxView.setUserComponents(aListAssociatedComponents2);
				Map systemComponentMapping = boxView.getSystemComponentMapping();
				Map ComponentForSystem = boxView.getComponentSystemMapping();
				
				//Obtain Systems
				Object[] obj = systemComponentMapping.keySet().toArray();
				vecSystems = new Vector();
				for (int n=0;n<obj.length;n++)
				{
					String system = (String)obj[n];
					if (!vecSystems.contains(system))
						vecSystems.add(system);
				}
				Collections.sort(vecSystems,String.CASE_INSENSITIVE_ORDER);
				systemCount = vecSystems.size();

				//Logic for selecting all items in the system select box
				if (er_system == null || (er_userOption != null && er_userOptionPrevious != null && !er_userOptionPrevious.equals(er_userOption)) || (er_criteria != null && er_criteriaPrevious != null && !er_criteriaPrevious.equals(er_criteria)))
				{
					er_system = new String[vecSystems.size()];
					for (int z=0;z<vecSystems.size();z++)
					{
						er_system[z] = (String)vecSystems.get(z);
					}
				}
				erEventLogViewer.setSystemComponentmMapping(systemComponentMapping);
			}
		} 
	String defaultLogValue = reportInfo.getValue("EVENT LOG_REPORT","Default_Log_Types");
	String customLogValue  = reportInfo.getValue("EVENT LOG_REPORT",er_componontType);
    
	String logValue = defaultLogValue;
	if(customLogValue!=null && customLogValue.length()>0)
	logValue = logValue+","+customLogValue;
//	String[] logTypes = {"Security","Application","System"};
	String[] logTypes = null;
	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		String[] logTypes1 = {"Application","System"};
		logTypes=logTypes1;
	}
	else
	{
		String[] logTypes1 = logValue.split(",");
		logTypes=logTypes1;
	}
   String dddDateFormat = "";
	if (er_logType != null && !er_logType.equals("-1"))
	{
		IniFile formatIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_format.ini");
		if (er_logType.equals(logTypes[0])) //Security
		{
			dddDateFormat = formatIni.getValue("DDD_DATE",eventLogTests[2]+":EvtDate");
		}
		else if (er_logType.equals(logTypes[1])) //Application
		{
			dddDateFormat = formatIni.getValue("DDD_DATE",eventLogTests[0]+":EvtDate");
		}
		else //System
		{
			dddDateFormat = formatIni.getValue("DDD_DATE",eventLogTests[1]+":EvtDate");
		}
	}
	//Added to fetch the DDD date format - end

    vecLogTypes = new Vector();
	for (int i=0;i<logTypes.length;i++)
	{
		String logType = logTypes[i];
		vecLogTypes.add(logType);
	}
	Collections.sort(vecLogTypes);

	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		if(er_logType==null||er_logType.equals(""))
			er_logType=logTypes[0];
	}
	else
	{
		if((er_logType==null||er_logType.equals("")) && vecLogTypes!=null && vecLogTypes.size()>0)
			er_logType= (String) vecLogTypes.get(0);
	}
		vecColumns = erEventLogViewer.getColumns();

		vecSortOrders = new Vector();
		for (int j=0;j<sortOrders.length;j++)
		{
			String sortOrder = sortOrders[j];
			vecSortOrders.add(sortOrder);
		}
		vecDescriptors = erEventLogViewer.getDescriptor(er_logType,er_system);
		// if (changecomp.equals("true"))
			// vecDescriptors = erEventLogViewer.getDescriptor(er_logType,er_system);

		/*if(vecDescriptors!=null && vecDescriptors.size()>0)
		{
			if(er_descriptor == null || er_descriptor.equals("-1"))
				er_descriptor=(String)vecDescriptors.get(0);
		}*/
			if(defaultloadmain!=null && !defaultloadmain.equals("")&&defaultloadmain.equals("defaultload"))
			{
				er_user="-1";
				er_categoryType="-1";
				er_eventType="-1";
			}
		
			if (vecDescriptors != null)
			{
				int index = vecDescriptors.indexOf("all");
				if (index != -1)
				{
					vecDescriptors.remove("all");
					vecDescriptors.add(0,"all");
					flagAll = true;
				}
			}
			if (defaultloadmain == null)
			{
			vecEventTypes = erEventLogViewer.getEventType(er_logType,er_system,er_descriptor);
			if(er_eventType==null)
				er_eventType="-1";

			vecEventSources = erEventLogViewer.getEventSource(er_logType,er_system,er_descriptor,er_eventType);
			if(er_eventSource==null)
				er_eventSource = "-1";
			vecCategoriesTypes = erEventLogViewer.getCategories(er_logType,er_system,er_descriptor,er_eventType,er_eventSource);

				if(reportfrom!=null && reportfrom.equals("Printer Management"))
				{
					if(er_categoryType==null)
						er_categoryType="Printer Management";
				}
				else
				{
					if(er_categoryType==null )
					{
						er_categoryType="-1";
					}
				}
			vecUsers = erEventLogViewer.getUser(er_logType,er_system,er_descriptor,er_eventType,er_eventSource,er_categoryType); 
		       
			if(er_user==null)
				er_user="-1";
			//if(er_categoryType==null||er_categoryType.equals("Loading ..."))
				//	er_categoryType="-1";			
		}
		else
		{
				System.out.println("Else Part Calling ");
			}
	}
	if (er_sthr != null)
	{
		if (er_sthr.length() == 1)
			er_sthr = "0" + er_sthr;
	}
	else
		er_sthr = "00";

	if (er_endhr != null)
	{
		if (er_endhr.length() == 1)
			er_endhr = "0" + er_endhr;
	}
	else
		er_endhr = "00";

	String startDateTime = "";
	String endDateTime = "";
	String st_dateTime="";
	String en_dateTime="";

	if (er_timeline != null)
	{
		if (er_timeline.equalsIgnoreCase("Any"))
		{
			startDateTime = er_stdate + " " + er_sthr + ":00:00";
			endDateTime = er_enddate + " " + er_endhr + ":00:00";
		}
		else
		{
			String loginName = user.getLoginID();
			Map map = request.getParameterMap();
			map = new HashMap(map);
			map.put("eruserid",loginName);
			ErTimeLineBean timeLineBean = new ErTimeLineBean(map);
			startDateTime = timeLineBean.getStartDateTime();
			endDateTime = timeLineBean.getEndDateTime();

			String tempSDate = startDateTime.substring(0,startDateTime.lastIndexOf(" "));
			String tempSTime = startDateTime.substring(startDateTime.lastIndexOf(" ")+1);
			tempSDate = DateUtil.changeDateFormat(tempSDate,"MM/dd/yyyy",currentDateFormat);
			startDateTime = tempSDate + " " + tempSTime;

			String tempEDate = endDateTime.substring(0,endDateTime.lastIndexOf(" "));
			String tempETime = endDateTime.substring(endDateTime.lastIndexOf(" ")+1);
			tempEDate = DateUtil.changeDateFormat(tempEDate,"MM/dd/yyyy",currentDateFormat);
			endDateTime = tempEDate + " " + tempETime;
		}
		if(er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(startDateTime==null)
		{
			startDateTime=SDate;
		}
		if(endDateTime==null)
		{
			endDateTime=SDate;
		}
		if(er_sthr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			er_sthr=String.valueOf(starthr);
		}
		if(er_endhr==null)
		{
			shour =shour.trim();
			er_endhr =shour;
		}
	}
		if(startDateTime!=null)
		{
			converterStart = new EgTimeZoneConverter(startDateTime,user);
			st_dateTime=converterStart.getDateTime();
		}
		if(endDateTime!=null)
		{
			converterEnd = new EgTimeZoneConverter(endDateTime,user);
			en_dateTime=converterEnd.getDateTime();
		}
	}
	ArrayList aListEventLogData = (ArrayList)request.getAttribute("EventLogData");
	Map otherInfo = (HashMap)request.getAttribute("EventLogData_other");

	if (aListEventLogData != null && !aListEventLogData.isEmpty())
	{
		session.setAttribute("EventLogData",aListEventLogData);
		rowExists = true;
	}
	if (otherInfo != null && !otherInfo.isEmpty())
	{
		session.setAttribute("EventLogData_other",otherInfo);
		rowExists = true;
	}
	StringBuffer printQS = new StringBuffer();
	printQS.append("&er_criteria="+er_criteria);
	printQS.append("&er_subzone="+er_subzone);
	if(er_userOption!= null)
		printQS.append("&er_userOption="+EgURLEncoder.encode(er_userOption,"UTF-8"));
//	if (er_system != null)
//	{
//		String[] systems=new String[er_system.length];
//		for(int k=0;k<er_system.length;k++)
//		{
//				systems[k]=EgURLEncoder.encode(er_system[k],"UTF-8");
//		}
//		printQS.append("&er_system="+Arrays.asList(systems));
//	}
	printQS.append("&er_logType="+er_logType);
	printQS.append("&er_descriptor="+er_descriptor);

	String temp_er_user = er_user;

	if (er_user != null)
	{
		temp_er_user = EgURLEncoder.encode(temp_er_user,"UTF-8");
	}

	String temp_eventType = er_eventType;
	if(er_eventType != null)
	{
		temp_eventType = EgURLEncoder.encode(er_eventType,"UTF-8");
	}
	String temp_eventSource = er_eventSource;
	if(er_eventSource != null)
	{
		temp_eventSource = EgURLEncoder.encode(er_eventSource,"UTF-8");
	}
	printQS.append("&er_user="+temp_er_user);
	printQS.append("&er_timeline="+er_timeline);
	printQS.append("&er_eventType="+temp_eventType);
	printQS.append("&er_eventSource="+temp_eventSource);
	printQS.append("&er_sortBy="+er_sortBy);
	printQS.append("&er_sortOrder="+er_sortOrder);
	if (er_timeline!= null && !er_timeline.equalsIgnoreCase("Any"))
	{
		printQS.append("&startDateTime="+EgURLEncoder.encode(startDateTime,"UTF-8"));
		printQS.append("&endDateTime="+EgURLEncoder.encode(endDateTime,"UTF-8"));
	}
	printQS.append("&er_systemCount="+systemCount);
	printQS.append("&er_stdate="+er_stdate);
	printQS.append("&er_enddate="+er_enddate);
	printQS.append("&er_sthr="+er_sthr);
	printQS.append("&er_endhr="+er_endhr);
	printQS.append("&startmin="+stMin);
	printQS.append("&endmin="+endMin);
	printQS.append("&reporterSkin="+reporter_Skin);
	strQry = printQS.toString();
	String systemVal = "";
	if (er_system != null)
	{
		String[] systems=new String[er_system.length];
		for(int k=0;k<er_system.length;k++)
		{
			systems[k]=EgURLEncoder.encode(er_system[k],"UTF-8");
		}
		systemVal = "&er_system="+Arrays.asList(systems);
	}
        session.setAttribute("systemVal",systemVal);
	rootJson.put("PRINT_URL", "/final/servlet/com.eg.ErEventLogController?er_option=print&call=json&"+strQry+"&pdfPrint=yes");
	rootJson.put("PDF_URL", "../reporter/ErHtmlToSavePdf.jsp?er_option=print"+strQry);
	rootJson.put("MAIL_URL", "../reporter/ErSendMail.jsp?requestFrom=EventLogAggregation");
	rootJson.put("SCHEDULE_URL", "/final/reporter/ErSaveSchedule.jsp?schedule_id="+schedule_id);
	rootJson.put("FAVORITE_URL", "/final/reporter/ErSaveFavorite.jsp?er_option=submit");

	if ( StringUtils.isNull( reqFromSchedule ) )
		reqFromSchedule = "null";

	if ( StringUtils.isNull( schedule_id ) )
		schedule_id = "null";

	hiddens.put("er_rtype", "EventLog");
	if(reportfrom!=null && reportfrom.equals("Printer Management"))	
		hiddens.put("er_trgttype", "PrinterMgt");
	else
		hiddens.put("er_trgttype", "Aggregation Report");
	hiddens.put("fromSchedule", reqFromSchedule);
	if(fromScheduleModify!=null)
		hiddens.put("fromScheduleModify",fromScheduleModify);
	else
		hiddens.put("fromScheduleModify","null");
	if(fromFavoriteModify!=null)
		hiddens.put("fromFavoriteModify",fromFavoriteModify);
	else
		hiddens.put("fromFavoriteModify","null");
	hiddens.put("favorite_id", favorite_id);
	hiddens.put("er_favorite", er_favorite);

	hiddens.put("schedule_id", schedule_id);
	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		hiddens.put("er_ViewName", "ErClientPrinterAnalysis.jsp");
	}
	else
	{
		hiddens.put("er_ViewName", "ErEventLogViewer.jsp");
	}

	hiddens.put("er_gtype", "Summary");
	hiddens.put("er_flagAll", String.valueOf(flagAll));
	hiddens.put("er_systemCount", String.valueOf(systemCount));
	hiddens.put("er_criteriaPrevious", er_criteria);
	hiddens.put("inidate", currentDateFormat);
	hiddens.put("getMaxDaysInMonth", String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddens.put("bgenabled", strbgrepportName);
	hiddens.put("limitforbg", limitforbg);
	hiddens.put("er_bgreportfrom", "Compliance_EventLog");
	hiddens.put("servletName", "com.eg.ErEventLogController");
	hiddens.put("savereport", "save");
	hiddens.put("userID", urs);
	hiddens.put("divStatus", divStatus);
	String fromFavSch = request.getParameter("fromFavSch");
	if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true") && (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))
	{
		//hiddens.put("ID", "backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		rootJson.put("ID", "backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}
%>
<%@ include file="ErSystemViewJSON.jsp" %>
<%
	screenLabels.put("seg_ser_zoneLabel",mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_criteria));
    if(isClientPrinter)
	screenLabels.put("TITLE",mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Details"));
	else
	screenLabels.put("TITLE", mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Log Aggregation And Analysis"));
	screenLabels.put("reporter.compliance.eventlog.System", mappingInfo.getTextDescription("reporter.compliance.eventlog.System"));
	JSONArray componentJSONAray = new JSONArray();
	if (vecSystems != null && !vecSystems.isEmpty())
	{
		JSONArray systemArr = new JSONArray();
		JSONObject systemObj = new JSONObject();
		Collections.sort(vecSystems,String.CASE_INSENSITIVE_ORDER);
		List listSelectedSystems = new ArrayList();
		if (er_system != null)
		{
			listSelectedSystems = Arrays.asList(er_system);
		}
		JSONArray selectedSysArr = new JSONArray();
		for(int i=0; i<vecSystems.size(); i++)
		{
 			String strSystem = (String)vecSystems.get(i);
		
			if(er_componontType !=null && !er_componontType.equalsIgnoreCase("-1"))
			{
				if (listSelectedSystems.contains(strSystem))
				{
					selectedSysArr.add(strSystem);
 				}
			}
			else
			{
				selectedSysArr.add(strSystem);
			}
			v_comp_popup.add(strSystem);
			v_comp_popup_disp.add(strSystem);

			systemObj.put("valueField", strSystem);
			systemObj.put("displayField", strSystem);
			systemArr.add(systemObj);
		}
		if(datafrom!=null && datafrom.equals("Zone"))
		{
			EgGroupInfo gpinfo = new EgGroupInfo();
			List tempComponent = gpinfo.getAllComponentsUnderZone(request.getParameter("er_service"),true);
			Vector y_component = new Vector();
			String compType=request.getParameter("rmComponentType");
			for (int j = 0; j < tempComponent.size(); j++) 
			{
				String tempStr = (String) tempComponent.get(j);
				tempStr = tempStr.substring(tempStr.indexOf(":") + 1)+ ":"+ tempStr.substring(0, tempStr.indexOf(":"));

				String 	sstr=tempStr.substring(tempStr.lastIndexOf(":")+1,tempStr.length());

				if(sstr.equalsIgnoreCase(compType))
				{
					tempStr=tempStr.substring(0,tempStr.lastIndexOf(":"));
					y_component.add(tempStr);

					JSONObject loopJsonObj = new JSONObject();
					loopJsonObj.put("displayField",tempStr);
					loopJsonObj.put("valueField", tempStr);
					componentJSONAray.add(loopJsonObj);
				}
			}
			selectedObj.put("systemSelected",y_component);
			rootJson.put("systemCombo",componentJSONAray);
		}
		else
		{
			selectedObj.put("systemSelected", selectedSysArr);
			if(systemArr!=null && systemArr.size()>0)
			{
				rootJson.put("systemCombo", systemArr);
			}
			else
			{
				JSONObject loopJsonObj = new JSONObject();
				loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
				loopJsonObj.put("valueField", "-1");
				componentJSONAray.add(loopJsonObj);
				selectedObj.put("systemSelected","-1");
				rootJson.put("systemCombo",componentJSONAray);
			}
		}
	}
	else
	{
		v_comp_popup.add("-1");
		v_comp_popup_disp.add("Not Applicable");
		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
		loopJsonObj.put("valueField", "-1");
		componentJSONAray.add(loopJsonObj);
		selectedObj.put("systemSelected","-1");
		rootJson.put("systemCombo",componentJSONAray);
	}
		for(int n=0;n<v_comp_popup.size();n++)
		{
			String s=(String)v_comp_popup.get(n);
			String ss=(String)v_comp_popup_disp.get(n);
		}

	 JSONObject componentTypeComboObject;
	screenLabels.put("reporter.compliance.eventlog.Component Type", mappingInfo.getTextDescription("reporter.compliance.eventlog.Component Type"));
	 JSONArray  componentTypeComboArray=new JSONArray();      
	
	//Collections.sort(aListCompType,String.CASE_INSENSITIVE_ORDER);
 
		List sortedNameList1 = sorter.getSortedCompTypeList(aListCompType1);
		if(sortedNameList1!=null && sortedNameList1.size()>0)
		{
			
			componentTypeComboObject=new JSONObject();

			if(reportfrom==null || !reportfrom.equals("Printer Management"))
			{
				componentTypeComboObject.put("displayField",mappingInfo.getTextDescription("reporter.common.All Component Types"));
				componentTypeComboObject.put("valueField","-1");
				componentTypeComboArray.add(componentTypeComboObject);
			}
			for(int n=0;n<sortedNameList1.size();n++)
			{
				EgName obj_name2 = (EgName)sortedNameList1.get(n);
				String displayType = obj_name2.getLocalName();
				String val = obj_name2.getActualName();
			
				//String sCompType = (String)sortedNameList1.get(n);
				if(er_componontType != null && val.equals(er_componontType))
				{
					selectedObj.put("componontTypeSelected", er_componontType);
				}
				componentTypeComboObject=new JSONObject();
				componentTypeComboObject.put("displayField",displayType);
				componentTypeComboObject.put("valueField",val);
				componentTypeComboArray.add(componentTypeComboObject);
			}                
        }
		else
		{
			componentTypeComboObject=new JSONObject();
			componentTypeComboObject.put("displayField","Not Applicable");//mappingInfo.getTextDescription("reporter.common.Not Applicable"));
			componentTypeComboObject.put("valueField","-1");
			selectedObj.put("componontTypeSelected", "-1");
			componentTypeComboArray.add(componentTypeComboObject);
		}
        rootJson.put("componentTypeCombo",componentTypeComboArray);
	screenLabels.put("reporter.compliance.eventlog.LogType", mappingInfo.getTextDescription("reporter.compliance.eventlog.Log Type"));
	if (vecLogTypes != null && !vecLogTypes.isEmpty())
	{
		JSONArray logTypeArr = new JSONArray();
		JSONObject logTypeObj = new JSONObject();
		logTypeObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.Please select a log type"));
		logTypeObj.put("valueField", "-1");
		logTypeArr.add(logTypeObj);
		for(int i=0; i<vecLogTypes.size(); i++)
		{
			String strLogType = (String)vecLogTypes.get(i);
			logTypeObj = new JSONObject();
			String strDisplogType = mappingInfo.getTestDescription(strLogType);
			logTypeObj.put("displayField", strDisplogType);
			logTypeObj.put("valueField", strLogType);
			logTypeArr.add(logTypeObj);
			if(er_logType != null && strLogType.equals(er_logType))
			{
				selectedObj.put("logTypeSelected", er_logType);
			}
		}
		rootJson.put("logTypeCombo", logTypeArr);
	}else{

        JSONArray logTypeArr = new JSONArray();
		JSONObject logTypeObj = new JSONObject();
		logTypeObj.put("displayField", "Not Applicable");
		logTypeObj.put("valueField", "-1");
		logTypeArr.add(logTypeObj);
        rootJson.put("logTypeCombo", logTypeArr);

	}
	screenLabels.put("reporter.common.Timeline", mappingInfo.getTextDescription("reporter.common.Timeline"));
	screenLabels.put("reporter.common.From", mappingInfo.getTextDescription("reporter.common.From"));
	screenLabels.put("reporter.common.To", mappingInfo.getTextDescription("reporter.common.To"));
	screenLabels.put("reporter.common.Hr", mappingInfo.getTextDescription("reporter.common.Hour"));

%>
<%@ include file="ErTimeLineNewJSON.jsp" %>
<%
	hiddens.put("currTime", time);
	hiddens.put("er_prevtimeline", er_timelineTemp);
	hiddens.put("er_usertimeline", strUsrTimeline);
	String isForceSubmit = request.getParameter("isForceSubmit");
	String er_RmDispName = request.getParameter("er_RmDispName");
	hiddens.put("isForceSubmit", isForceSubmit);
	hiddens.put("er_RmDispName", er_RmDispName);

	rootJson.put("timelineCombo",timelineComboArray);
	rootJson.put("timelineHourCombo",timelineHourComboArray);
 	rootJson.put("selectedTimeline",er_timeline);
	rootJson.put("startDate",startDateJSON);
	rootJson.put("endDate",endDateJSON);
	rootJson.put("startHour",startHourJSON);
	rootJson.put("endHour",endHourJSON);
	rootJson.put("startmin",startMinValue);
	rootJson.put("endmin",endMinValue);
	rootJson.put("startDateForDisplay",startDateForDisplay);
	rootJson.put("startHourForDisplay",startHourForDisplay);
	rootJson.put("startMinForDisplay",startMinForDisplay);
	rootJson.put("endDateForDisplay",endDateForDisplay);
	rootJson.put("endHourForDisplay",endHourForDisplay);
	rootJson.put("endMinForDisplay",endMinForDisplay);
	screenLabels.put("reporter.compliance.eventlog.Descriptor", mappingInfo.getTextDescription("reporter.compliance.eventlog.Descriptor"));

	String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
	if (vecDescriptors != null && !vecDescriptors.isEmpty())
	{
		JSONArray descArr = new JSONArray();
		JSONObject descObj = new JSONObject();
		descObj.put("valueField", "-1");
		descObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.Please select a descriptor"));

		descArr.add(descObj);
		for(int i=0; i<vecDescriptors.size(); i++)
		{
			String selected = "";
			String strDescriptor = (String)vecDescriptors.get(i);
			String strTempDesc = strDescriptor;
			
			if(er_descriptor != null && strDescriptor.equals(er_descriptor))
			{
				selectedObj.put("descSelected", er_descriptor);
				selected = "selected";
			}
			if(strTempDesc!=null && strTempDesc.indexOf("all")>-1)
			{
				strTempDesc = mappingInfo.getTextDescription("reporter.compliance.eventlog."+strTempDesc);
			}
			descObj = new JSONObject();
			//descObj.put("displayField", strDescriptor);
			descObj.put("displayField", strTempDesc);
			descObj.put("valueField", strDescriptor);
			descArr.add(descObj);
		}
		rootJson.put("descCombo", descArr);
	}
	screenLabels.put("reporter.compliance.eventlog.User", mappingInfo.getTextDescription("reporter.compliance.eventlog.User"));
	if (vecUsers != null && !vecUsers.isEmpty())
	{
		JSONArray userArr = new JSONArray();
		JSONObject userObj = new JSONObject();
		userObj.put("valueField", "-1");
		userObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.All Users"));

		userArr.add(userObj);
		for(int i=0; i<vecUsers.size(); i++)
		{
			String strUser = (String)vecUsers.get(i);
			if(er_user != null && strUser.equals(er_user))
			{
				selectedObj.put("userSelected", er_user);
			}
			userObj = new JSONObject();
			userObj.put("valueField", strUser);
			userObj.put("displayField", strUser);
			userArr.add(userObj);
		}
		rootJson.put("userCombo", userArr);
	}
	screenLabels.put("reporter.compliance.eventlog.CategoryType", mappingInfo.getTextDescription("reporter.compliance.eventlog.Category Type"));
	JSONArray categoryArr = new JSONArray();
	if (vecCategoriesTypes != null && vecCategoriesTypes.size()>0)
	{		
		JSONObject categoryObj = new JSONObject();
		ArrayList aList11 = new ArrayList();
		if(reportfrom==null || !reportfrom.equals("Printer Management"))
		{
			categoryObj.put("valueField", "-1");
			categoryObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.All Category Types"));
			categoryArr.add(categoryObj);
		}

		selectedObj.put("categorytSelected", er_categoryType);
		for(int i=0; i<vecCategoriesTypes.size(); i++)
		{
			String strCategoriesType = (String)vecCategoriesTypes.get(i); 
			categoryObj = new JSONObject();
			if(reportfrom==null || !reportfrom.equals("Printer Management"))
			{
				categoryObj.put("valueField", strCategoriesType);
				categoryObj.put("displayField", strCategoriesType);
				categoryArr.add(categoryObj);
			}
			else
			{
				if(!aList11.contains(strCategoriesType))
				{
					if(strCategoriesType!=null && strCategoriesType.equals("Printer Management"))
					{
						aList11.add(strCategoriesType);
						categoryObj.put("valueField", strCategoriesType);
						categoryObj.put("displayField", strCategoriesType);
						categoryArr.add(categoryObj);
					}
				}
			}
		}
		rootJson.put("categoryCombo", categoryArr);
	}
	else
	{
		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
		loopJsonObj.put("valueField", "-1");
		categoryArr.add(loopJsonObj);
		selectedObj.put("categorytSelected","-1");
		rootJson.put("categoryCombo",categoryArr);
	}
	if(reportfrom!=null && reportfrom.equals("Printer Management"))
	{
		if(categoryArr!=null && categoryArr.size()==0)
		{
			JSONObject loopJsonObj = new JSONObject();
			loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
			loopJsonObj.put("valueField", "-1");
			categoryArr.add(loopJsonObj);
			selectedObj.put("categorytSelected","-1");
			rootJson.put("categoryCombo",categoryArr);
		}
	}
	screenLabels.put("reporter.compliance.eventlog.EventType", mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Type"));
	
	JSONArray eventArr = new JSONArray();
	if (vecEventTypes != null && !vecEventTypes.isEmpty())
	{		
		JSONObject eventObj = new JSONObject();
		eventObj.put("valueField", "-1");
		eventObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Types"));

		eventArr.add(eventObj);
		ArrayList er_eventTypeLst = new ArrayList();
		if(er_eventType != null && er_eventType.length()>0)
		{
			er_eventTypeLst = new ArrayList(Arrays.asList(er_eventType.split(",")));
		}
		Vector eventSelected = new Vector();
		for(int i=0; i<vecEventTypes.size(); i++)
		{
			String strEventType = (String)vecEventTypes.get(i);
			if(er_eventTypeLst != null && er_eventTypeLst.contains(strEventType))
			{
				eventSelected.add(strEventType);
			}
			eventObj = new JSONObject();
			eventObj.put("valueField", strEventType);
			eventObj.put("displayField", strEventType);
			eventArr.add(eventObj);
		}
		if(eventSelected.size()>0)
		{
			selectedObj.put("eventSelected", eventSelected);
		}
		rootJson.put("eventCombo", eventArr);
	}
	else
	{
		JSONObject loopJsonObj = new JSONObject();
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
		loopJsonObj.put("valueField", "-1");
		eventArr.add(loopJsonObj);
		selectedObj.put("eventSelected","-1");
		rootJson.put("eventCombo",eventArr);
	}
	screenLabels.put("reporter.compliance.eventlog.EventSource", mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Source"));
	
	JSONArray eventSrcArr = new JSONArray();
	if (vecEventSources != null && !vecEventSources.isEmpty())
	{
		JSONObject eventSrcObj = new JSONObject();
		eventSrcObj.put("valueField", "-1");
		eventSrcObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Sources"));
		eventSrcArr.add(eventSrcObj);
		for(int i=0; i<vecEventSources.size(); i++)
		{ 
			String strEventSource = (String)vecEventSources.get(i);
			if(er_eventSource != null && strEventSource.equals(er_eventSource))
			{
				selectedObj.put("eventSourceSelected", er_eventSource); 
			}
			eventSrcObj = new JSONObject();
			eventSrcObj.put("valueField", strEventSource);
			eventSrcObj.put("displayField", strEventSource);
			eventSrcArr.add(eventSrcObj);
		}
		rootJson.put("eventSourceCombo", eventSrcArr );
	}
	else
	{
		JSONObject loopJsonObj = new JSONObject();
		//loopJsonObj.put("displayField","Not Applicable");
		loopJsonObj.put("displayField",mappingInfo.getTextDescription("reporter.compliance.eventlog.Not Applicable"));
		loopJsonObj.put("valueField", "-1");
		eventSrcArr.add(loopJsonObj);
		selectedObj.put("eventSourceSelected","-1");
		rootJson.put("eventSourceCombo",eventSrcArr);
	}
	screenLabels.put("reporter.compliance.eventlog.Sortby", mappingInfo.getTextDescription("reporter.compliance.eventlog.Sort by"));
	if (vecColumns != null && !vecColumns.isEmpty())
	{
		JSONArray sortByArr = new JSONArray();
		for(int i=0; i<vecColumns.size(); i++)
		{
			String selected = "";
			String strColumn = (String)vecColumns.get(i);
			if(er_sortBy != null && strColumn.equals(er_sortBy))
			{
				selectedObj.put("sortBySelected", strColumn);
				selected = "selected";
			}
			JSONObject sortByObj = new JSONObject();
			sortByObj.put("valueField", strColumn);
			sortByObj.put("displayField", 
			mappingInfo.getTextDescription("reporter.compliance.eventlog."+strColumn));

			sortByArr.add(sortByObj);
		}
		rootJson.put("sortByCombo", sortByArr);
	}
	screenLabels.put("reporter.compliance.eventlog.SortOrder", mappingInfo.getTextDescription("reporter.compliance.eventlog.Sort Order"));
	JSONArray sortOrderArr = new JSONArray();
	if (vecSortOrders != null && !vecSortOrders.isEmpty())
	{
		for(int i=0; i<vecSortOrders.size(); i++)
		{
			JSONObject sortOrderObj = new JSONObject();
			String selected = "";
			String strSortOrder = (String)vecSortOrders.get(i);
			sortOrderObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog."+strSortOrder));
			sortOrderObj.put("valueField", strSortOrder);
			sortOrderArr.add(sortOrderObj);
			if(er_sortOrder != null && strSortOrder.equals(er_sortOrder))
			{
				selectedObj.put("sortOrderSelected", er_sortOrder);
				selected = "selected";
			}
		}
		rootJson.put("sortOrderArr", sortOrderArr);
	}
	JSONArray reportGenArr = new JSONArray();
	JSONObject reportGenObj = new JSONObject();
	reportGenObj.put("valueField", "background");
	reportGenObj.put("displayField", strbackground);
	reportGenArr.add(reportGenObj);

	reportGenObj = new JSONObject();
	reportGenObj.put("displayField", mappingInfo.getTextDescription("reporter.compliance.eventlog.Background Save - CSV"));
	reportGenObj.put("valueField", "background-csv");
	reportGenArr.add(reportGenObj);

	reportGenObj = new JSONObject();
	reportGenObj.put("valueField", "foreground");
	reportGenObj.put("displayField", strforeground);
	reportGenArr.add(reportGenObj);

	rootJson.put("reportGenerationCombo", reportGenArr);
	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		er_background = "selected";
		er_foreground = "";
		selectedObj.put("reportGenSelected", "background");
	}
	else if (er_reportgenration != null && er_reportgenration.equals("background-csv"))
	{
		er_background = "selected";
		er_foreground = "";
		selectedObj.put("reportGenSelected", "background");
	}

	else
	{
		er_background = "";
		er_foreground = "selected";
		selectedObj.put("reportGenSelected", "foreground");
	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	screenLabels.put("reporter.consolidated.ReportGeneration", mappingInfo.getTextDescription("reporter.consolidated.Report Generation"));

	screenLabels.put("reporter.consolidated.SaveByName", mappingInfo.getTextDescription("reporter.consolidated.Save By Name"));


	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
		if (er_reportgenration != null && (er_reportgenration.equals("background") || (er_reportgenration.equals("background-csv"))))
		{
			selectedObj.put("bgReportName", bg_reportname);
		}
	}
	if (reqFromSchedule != null && reqFromSchedule.equalsIgnoreCase("Yes"))
	{
		screenLabels.put("reporter.common.SUBMIT", mappingInfo.getTextDescription("reporter.common.SAVE"));
	}
	else
	{
		screenLabels.put("reporter.common.SUBMIT", mappingInfo.getTextDescription("reporter.common.SUBMIT"));
	}
	if(bggroundStr != null && !bggroundStr.equals(""))
	{
		backgroundResultObj.put("status", status);
	String strreportName ="Compliance_EventLog";
	if(status != null && status.equals("duplicate"))
	{
		strreportName ="All Report Types";
	}
	if(strreportName!=null && strreportName.indexOf(" ") > -1)
	{
		strreportName = EgURLEncoder.encode(strreportName, "UTF-8");
	}
	backgroundResultObj.put("backgroundResponseText", erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
	backgroundResultObj.put("backgroundResponseLink", "/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+urs+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
	backgroundResultObj.put("backgroundResponseLinkText", mappingInfo.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
	}
	screenLabels.put("reporter.compliance.eventlog.Event Description", mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Description"));
	screenLabels.put("reporter.compliance.eventlog.IDs", mappingInfo.getTextDescription("reporter.compliance.eventlog.IDs"));
	screenLabels.put("reporter.compliance.eventlog.From", mappingInfo.getTextDescription("reporter.compliance.eventlog.From"));
	screenLabels.put("reporter.compliance.eventlog.To", mappingInfo.getTextDescription("reporter.compliance.eventlog.To"));
	if (aListEventLogData != null)
	{
		if (!aListEventLogData.isEmpty())
		{
			ArrayList aListPdfData = new ArrayList();
			EgPdfData pdfData = new EgPdfData();
			
			EgReportAttributes reportAttributes = new EgReportAttributes();
			reportAttributes.setMainTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Log Aggregation And Analysis"));
			reportAttributes.setSubTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog.From")+" "+st_dateTime+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.to")+" " +en_dateTime+"\n\n"+mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType)+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.Log"));

			reportAttributes.setReportName("EventLogAggregation");
			reportAttributes.setModule("REPORTER");

			//Table 1
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
			ArrayList fieldWidths = new ArrayList();

			if (er_criteria != null && !er_criteria.equals("-1"))
			{
				if (er_criteria.equalsIgnoreCase(criterias[0]))
				{
					aListColumnNames.add("C0");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SEARCH BY"));
					aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Zone"));
					fieldWidths.add("60");

					aListColumnNames.add("C1");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.ZONE"));
					aListData.add(er_userOption);
					fieldWidths.add("60");
                    vec_0.add('"'+criterias[0]+'"');
					lst_dat_0.add(er_userOption);
					                
					
					if (!er_userOption.equalsIgnoreCase("--Default--"))
					{
						aListColumnNames.add("C2");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.INCLUDE SUBZONES"));
						aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_subzone));
						fieldWidths.add("110");
						fieldWidths.add("600");
						vec_0.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Include Subzones"));
						lst_dat_0.add(er_subzone);
						
					}
					else
					{
						fieldWidths.add("710");
					}
				}
				else if (er_criteria.equalsIgnoreCase(criterias[1]))
				{
					aListColumnNames.add("C0");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SEARCH BY"));
					aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Service"));
					fieldWidths.add("60");

					aListColumnNames.add("C1");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SERVICE"));
					aListData.add(er_userOption);
					fieldWidths.add("60");

					fieldWidths.add("710");
					vec_0.add('"'+criterias[1]+'"');
					lst_dat_0.add(er_userOption);
				}
				else if (er_criteria.equalsIgnoreCase(criterias[2]))
				{
					aListColumnNames.add("C0");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SEARCH BY"));
					aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Segment"));
					fieldWidths.add("60");

					aListColumnNames.add("C1");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SEGMENT"));
					aListData.add(er_userOption);
					fieldWidths.add("60");

					fieldWidths.add("710");
				    vec_0.add('"'+criterias[2]+'"');
					lst_dat_0.add(er_userOption);
				}
				else
				{
					aListColumnNames.add("C0");
					userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SEARCH BY"));
					aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.System"));
					fieldWidths.add("60");

					fieldWidths.add("770");
				}
                vec_0.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.System(s)"));
               // lst_dat_0.add('"'+mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_criteria)+'"');
			    
				String strSystems = "";
				if (er_system.length == vecSystems.size())
				{
					strSystems = mappingInfo.getTextDescription("reporter.compliance.eventlog.All Systems");
					lst_dat_0.add('"'+mappingInfo.getTextDescription("reporter.compliance.eventlog.All Systems")+'"');
				}
				else
				{
					strSystems = Arrays.asList(er_system).toString();
					strSystems = strSystems.substring(1,strSystems.length()-1);
					lst_dat_0.add(er_system);
				}

				aListColumnNames.add("C3");
				userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SYSTEM(S)"));
				aListData.add(strSystems);
			}

			egTableAttributes.setTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog.Selection Details"));
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setFieldWidths(fieldWidths);

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);

			//Table 2
			egTableAttributes = new EgTableAttributes();
			aListColumnNames = new ArrayList();
			aListData = new ArrayList();
			userColumnNames = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");
			aListColumnNames.add("C4");
			aListColumnNames.add("C5");
			aListColumnNames.add("C6");

			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG TYPE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DESCRIPTOR"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.USER"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.EVENT TYPE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.EVENT SOURCE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SORT BY"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SORT ORDER"));

			egTableAttributes.setColumnNames(userColumnNames);

			aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType));
			//For CSV Start
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Log Type"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Descriptor"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.User"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Type"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Source"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Sort by"));
			vec.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.Sort Order"));
		       lst_dat.add(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType));
           //For CSV End
			if (er_descriptor.equals("-1")){
				aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Descriptors"));
			    lst_dat.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Descriptors")); //For CSV
			}
			else{
				aListData.add(er_descriptor);
			    lst_dat.add('"'+er_descriptor+'"');//For CSV
				}

			if (er_user.equals("-1")){
				aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Users"));
			    lst_dat.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Users"));
				}
			else{
				aListData.add(er_user);
			    lst_dat.add('"'+er_user+'"');
			    }

			if (er_eventType.equals("-1")){
				aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Types"));
			    lst_dat.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Types"));
				}
			else{
				aListData.add(er_eventType);
			    lst_dat.add('"'+er_eventType+'"');
				}

			if (er_eventSource.equals("-1")){
				aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Sources"));
			    lst_dat.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Sources"));
				}
			else{
				aListData.add(er_eventSource);
			    lst_dat.add('"'+er_eventSource+'"');
               }
			aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_sortBy));
			aListData.add(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_sortOrder));
			
			lst_dat.add('"'+er_sortBy+'"');
			lst_dat.add('"'+er_sortOrder+'"');

			egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);

			//Summary Table
			egTableAttributes = new EgTableAttributes();
			aListColumnNames = new ArrayList();
			aListData = new ArrayList();
			userColumnNames = new ArrayList();
			fieldWidths = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");

			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.EVENT TYPE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.COUNT"));
			//CSV START
              if(isClientPrinter)
			  s_tit_1= mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Summary");
			  else
			   s_tit_1=mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase()+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT SUMMARY"));
			  vec_1.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.EVENT TYPE"));
			  vec_1.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.COUNT"));
                        //CSV End 
			fieldWidths.add("150");
			fieldWidths.add("60");
            if(isClientPrinter)
			egTableAttributes.setTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Summary"));
			else
			egTableAttributes.setTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase())+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT SUMMARY"));
			
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setFieldWidths(fieldWidths);
			egTableAttributes.setStartX(300);
			String s_groupElement="";
			if (er_userOption != null)
			{
				s_groupElement = " : " + er_userOption;
			}
			rootJson.put("SELECTION_TITLE", mappingInfo.getTextDescription("reporter.common.Selection Details for a ")+er_criteria+" "+s_groupElement);

			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Log Type"), mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType));

			//selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Descriptor"), er_descriptor);
			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Descriptor"), er_descriptorTemp);

			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.User"), (er_user.equals("-1") ? mappingInfo.getTextDescription("reporter.compliance.eventlog.All Users") : er_user));

			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Type"), (er_eventType.equals("-1") ? mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Types") : er_eventType));

			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Event Source"), (er_eventSource.equals("-1") ? mappingInfo.getTextDescription("reporter.compliance.eventlog.All Event Sources") : er_eventSource));

			String selectionTimeline = "<span class='font_bold'> </span>  "+pdfStartDate+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.hrs")+" <span class='font_bold'> "+mappingInfo.getTextDescription("reporter.compliance.eventlog.to")+" </span> "+pdfEndDate+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.hrs");

			selectionDetails.put(mappingInfo.getTextDescription("reporter.compliance.eventlog.Timeline"), selectionTimeline);
			JSONObject tableObj = new JSONObject();
			
            if(isClientPrinter)
			tableObj.put("TITLE",mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Summary"));
			else
             tableObj.put("TITLE", mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase())+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT SUMMARY"));
			
			tableObj.put("EVENT_TYPE", mappingInfo.getTextDescription("reporter.compliance.eventlog.EVENT TYPE"));
			tableObj.put("COUNT", mappingInfo.getTextDescription("reporter.compliance.eventlog.COUNT"));
			TreeMap tmapEvents = erReportHelper.getEventCount(aListEventLogData);
			Iterator eventTypeKeys = tmapEvents.keySet().iterator();
			JSONArray eventTypeArr = new JSONArray();
			while (eventTypeKeys.hasNext())
			{
				String keyEventType = (String)eventTypeKeys.next();
				Integer count = (Integer)tmapEvents.get(keyEventType);
				JSONObject eventTypeObj = new JSONObject();
				eventTypeObj.put("EVENT_TYPE", keyEventType);
				eventTypeObj.put("COUNT", count);
				eventTypeArr.add(eventTypeObj);
				aListData.add(keyEventType);
				aListData.add(""+count);
				lst_dat_1.add('"'+keyEventType+'"');
				lst_dat_1.add(count+"");
			}
			tableObj.put("TABLE_VALUES", eventTypeArr);
			resultsObj.put("TABLE_RESULT", tableObj);
			egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);

			//Details Table
			egTableAttributes = new EgTableAttributes();
			aListColumnNames = new ArrayList();
			aListData = new ArrayList();
			userColumnNames = new ArrayList();
			fieldWidths = new ArrayList();

			aListColumnNames.add("C0");
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");
			aListColumnNames.add("C4");
			aListColumnNames.add("C5");
			aListColumnNames.add("C6");
			aListColumnNames.add("C7");

			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.TYPE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DATE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SOURCE"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.CATEGORY"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.ID"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.USER"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.COMPUTER"));
			userColumnNames.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DESCRIPTION"));
			
			//For CSV start 
     	    if(isClientPrinter)
			s_tit_2=mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Details");
            else
            s_tit_2=mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase())+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT DETAILS");


			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.TYPE"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DATE"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SOURCE"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.CATEGORY"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.ID"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.USER"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.COMPUTER"));
			vec_2.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DESCRIPTION"));
           //For CSV end

			//Landscape - 830
			fieldWidths.add("60");
			fieldWidths.add("60");
			fieldWidths.add("110");
			fieldWidths.add("70");
			fieldWidths.add("40");
			fieldWidths.add("140");
			fieldWidths.add("70");
			fieldWidths.add("280");

			egTableAttributes.setTitle(mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase())+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT DETAILS"));
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setFieldWidths(fieldWidths);

			JSONObject gridObj = new JSONObject();
			if(isClientPrinter)
			gridObj.put("TITLE",mappingInfo.getTextDescription("reporter.compliance.eventlog.Client Printer Analysis Event Details"));
			else
			gridObj.put("TITLE", mappingInfo.getTextDescription("reporter.compliance.eventlog."+er_logType.toUpperCase())+" "+mappingInfo.getTextDescription("reporter.compliance.eventlog.LOG EVENT DETAILS"));
			
			JSONObject gridColsObj = new JSONObject();
			gridColsObj.put("reporter.compliance.eventlog.TYPE", mappingInfo.getTextDescription("reporter.compliance.eventlog.TYPE"));

			gridColsObj.put("reporter.compliance.eventlog.DATE", mappingInfo.getTextDescription("reporter.compliance.eventlog.DATE"));

			gridColsObj.put("reporter.compliance.eventlog.SOURCE", mappingInfo.getTextDescription("reporter.compliance.eventlog.SOURCE"));

			gridColsObj.put("reporter.compliance.eventlog.CATEGORY", mappingInfo.getTextDescription("reporter.compliance.eventlog.CATEGORY"));

			gridColsObj.put("reporter.compliance.eventlog.ID", mappingInfo.getTextDescription("reporter.compliance.eventlog.ID"));

			gridColsObj.put("reporter.compliance.eventlog.USER", mappingInfo.getTextDescription("reporter.compliance.eventlog.USER"));

			gridColsObj.put("reporter.compliance.eventlog.COMPUTER", mappingInfo.getTextDescription("reporter.compliance.eventlog.COMPUTER"));

			gridColsObj.put("reporter.compliance.eventlog.DESCRIPTION", mappingInfo.getTextDescription("reporter.compliance.eventlog.DESCRIPTION"));

			gridObj.put("GRID_COLUMNS", gridObj);
			JSONArray columnNameArr = new JSONArray();
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.TYPE"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DATE"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.SOURCE"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.CATEGORY"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.ID"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.USER"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.COMPUTER"));
			columnNameArr.add(mappingInfo.getTextDescription("reporter.compliance.eventlog.DESCRIPTION"));

			gridObj.put("GRID_COLUMN_NAMES", columnNameArr);
			JSONArray gridValArr = new JSONArray();
			for (int i=0;i<aListEventLogData.size();i=i+8)
			{
				JSONObject gridValObj = new JSONObject();
				String event_date = (String)aListEventLogData.get(i+1);

				//Convert the event_date to DDD date format
				String tempDate = event_date.substring(0,event_date.lastIndexOf(" "));
				String tempTime = event_date.substring(event_date.lastIndexOf(" ")+1);
				tempDate = DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",currentDateFormat);
				event_date = tempDate + " " + tempTime;
				converterStart = new EgTimeZoneConverter(event_date,thisuser);
				String usr_evtDate=converterStart.getDateTime();
				String strEventData = (String)aListEventLogData.get(i);
				lst_dat_2.add('"'+(String)aListEventLogData.get(i)+'"');
                                lst_dat_2.add('"'+usr_evtDate+'"');
				int dataLength = strEventData.length();
				int sizeDec = 12;
				String strClubed = "";
				if(dataLength>sizeDec)
				{
					String strOne =strEventData.substring(0,sizeDec);
					if(strOne.indexOf(" ")>-1)
					{
						strClubed = strEventData;
					}
					else
					{
						String strTwo = strEventData.substring(sizeDec,strEventData.length());
						strClubed = strOne + " " + strTwo;
					}
				}
				else
				{
					strClubed = strEventData;
				}
				gridValObj.put("TYPE", strClubed);
				gridValObj.put("DATE", usr_evtDate);
				String strSource = (String)aListEventLogData.get(i+2);
				ArrayList aListString = new ArrayList();
				aListString = breakString(strSource,20);
				JSONArray sourceArr = new JSONArray();
				String t1="";
				for (int sr=0;sr<aListString.size();sr++)
				{
					String strSrcDisp = (String)aListString.get(sr);
					strSrcDisp = strSrcDisp.trim();
					sourceArr.add(strSrcDisp);
					t1+=strSrcDisp;
				}
				lst_dat_2.add('"'+t1+'"');
				gridValObj.put("SOURCE", sourceArr);
				gridValObj.put("CATEGORY", (String)aListEventLogData.get(i+3));
				gridValObj.put("ID", (String)aListEventLogData.get(i+4));
				
				lst_dat_2.add('"'+(String)aListEventLogData.get(i+3)+'"');
				lst_dat_2.add('"'+(String)aListEventLogData.get(i+4)+'"');
				
				String strUserData = (String)aListEventLogData.get(i+5);
				ArrayList aListUserStr = new ArrayList();
				aListUserStr = breakString(strUserData,18);
				JSONArray userArr = new JSONArray();
				String t2="";
				for (int r=0;r<aListUserStr.size();r++)
				{
					String strUserDisp = (String)aListUserStr.get(r);
					strUserDisp = strUserDisp.trim();
					userArr.add(strUserDisp);
					t2+=strUserDisp;
				}
				gridValObj.put("USER", userArr);
				lst_dat_2.add('"'+t2+'"');

				String t3="";
				for (int r=0;r<aListUserStr.size();r++)
				{
					String strUserDisp = (String)aListUserStr.get(r);
					strUserDisp = strUserDisp.trim();
						t3+=strUserDisp;
				}
				//lst_dat_2.add('"'+t3+'"');
				String strComputer = (String)aListEventLogData.get(i+6);
				ArrayList aListStr = new ArrayList();
				aListStr = breakString(strComputer,10);

				JSONArray computerArr = new JSONArray();
				String t4="";
				for (int cr=0;cr<aListStr.size();cr++)
				{
					String strComputerDisp = (String)aListStr.get(cr);
					strComputerDisp = strComputerDisp.trim();
					computerArr.add(strComputerDisp);
					t4+=strComputerDisp;
				}
				lst_dat_2.add('"'+t4+'"');
				gridValObj.put("COMPUTER", computerArr);
				String strDescription = (String)aListEventLogData.get(i+7);
				ArrayList aListBreakString = new ArrayList();
				aListBreakString = breakString(strDescription,44);
				JSONArray descArr = new JSONArray();
				for (int sw=0;sw<aListBreakString.size();sw++)
				{
					String strDescDisp = (String)aListBreakString.get(sw);
					strDescDisp = strDescDisp.trim();
					descArr.add(strDescDisp);
				}
				lst_dat_2.add("\""+strDescription+"\"");
				gridValObj.put("DESCRIPTION", descArr);
				aListData.add(aListEventLogData.get(i));
				aListData.add(usr_evtDate);
				aListData.add(aListEventLogData.get(i+2));
				aListData.add(aListEventLogData.get(i+3));
				aListData.add(aListEventLogData.get(i+4));
				aListData.add(aListEventLogData.get(i+5));
				aListData.add(aListEventLogData.get(i+6));
				aListData.add(aListEventLogData.get(i+7));
				gridValArr.add(gridValObj);
			}
			gridObj.put("GRID_VALUES", gridValArr);
			resultsObj.put("GRID_RESULTS", gridObj);
			egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);

			pdfData.setAttributes(reportAttributes);
			pdfData.setData(aListPdfData);
			session.setAttribute("pdfData",pdfData);
			
				if (er_RmDispName!=null)
				lst.add(er_RmDispName);
				if(!isClientPrinter)
				lst.add("Event Log Aggregation and Analysis Report");
				lst.add("");
				lst.add('"'+"From:"+er_stdate+"  To:"+er_enddate+'"');
				Hashtable ht=new Hashtable();
				sen = new Hashtable();
			        sen.put(vec_0,lst_dat_0);
				
				ht=new Hashtable();
				ht.put(s_tit_0,sen);
				lst.add(ht);
				
				sen = new Hashtable();
				sen.put(vec,lst_dat);
				ht=new Hashtable();
				ht.put("",sen);
				lst.add(ht);
				
				sen = new Hashtable();
				sen.put(vec_1,lst_dat_1);
				ht=new Hashtable();
				ht.put(s_tit_1,sen);
				lst.add(ht);
				sen = new Hashtable();
				sen.put(vec_2,lst_dat_2);
				ht=new Hashtable();
				ht.put(s_tit_2,sen);
				lst.add(ht);
				
				session.setAttribute("list",lst);
		}
	}
	session.setAttribute("PDF_URL", mngrIProc+"/final/servlet/com.eg.ErEventLogController");
	String systemData ="";
	String sysProces ="";
	String val = "";
	StringBuffer sbb = new StringBuffer();
	if (er_system != null)
	{
		String[] systems=new String[er_system.length];
		for(int k=0;k<er_system.length;k++)
		{
				systems[k]=EgURLEncoder.encode(er_system[k],"UTF-8");
				String name = systems[k];
				sbb.append(name+",");
				//systemData = "&er_system="+systems;
		}
	}
	String sysData = "&er_system=["+sbb.toString()+"]";

	//String dataProcess = mngrIProc+"/final/servlet/com.eg.ErEventLogController;jsessionid="+session.getId()+"?er_option=print"+strQry+sysData;//..
	String dataProcess = mngrIProc+"/final/servlet/com.eg.ErEventLogController;jsessionid="+session.getId()+"?er_option=print"+strQry;//..
	session.setAttribute("MAIL_URL",dataProcess);
	Map parameters = new HashMap();
	parameters= request.getParameterMap();
	String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("er_system"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("currTime") ||reqparam!=null&&reqparam.equals("er_enddate")
				||reqparam.equals("er_stdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if ( reqparam != null && reqparam.equalsIgnoreCase("call") )
			{
				continue;
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}

	//Back button - Start
	ArrayList listbackvar = new  ArrayList();

	if(request.getParameter("isSubmit")!=null)
	{
		session.setAttribute("reportLastAccessedURL","/final/servlet/com.eg.ErEventLogController?"+Qstring);

		listbackvar.add("/servlet/com.eg.ErEventLogController?");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else
	{
		if(reportfrom!=null && reportfrom.equals("Printer Management"))
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErClientPrinterAnalysis.jsp?"+Qstring);
			listbackvar.add("ErClientPrinterAnalysis.jsp"); 
		}
		else
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErEventLogViewer.jsp?"+Qstring);
			listbackvar.add("ErEventLogViewer.jsp"); 
		}
		
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}

	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	//Back button - End

	// otherInfo setting
	// Information for overall page navigation
	if(otherInfo!=null && otherInfo.size()>0)
	{
		JSONObject otherInfoJson = new JSONObject();
		otherInfoJson.put("isRangeNeed", (String)otherInfo.get("isRangeNeed"));
		otherInfoJson.put("overAllRecCount", (String)otherInfo.get("overAllRecCount"));
		otherInfoJson.put("dataPageNo", (String)otherInfo.get("dataPageNo"));
		otherInfoJson.put("recordPerPage", (String)otherInfo.get("recordPerPage"));
		resultsObj.put("OTHER_INFO",otherInfoJson);
	}

	String titleToDisplay = "";
	if(er_RmDispName!=null && er_RmDispName.length()>0){
		titleToDisplay = er_RmDispName.trim();
		rootJson.put("rm_titleDisplay",titleToDisplay);
	}
	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","EventLogReport");
	session.setAttribute("parameters", paramVal);
	rootJson.put("selectedValues", selectedObj);
	rootJson.put("selectionDetails", selectionDetails);
	rootJson.put("screenLabels", screenLabels);
	rootJson.put("hiddens", hiddens);
	rootJson.put("backgroundResults", backgroundResultObj);
	rootJson.put("RESULTS", resultsObj);
	
	out.println(rootJson);
}
catch ( Exception e )
{
	System.err.println("[Exception] @ ErEventLogViewerJSON.jsp "+e);
	e.printStackTrace();
}
%>