<%
/**************************************************************************************************
* File          : ErCtxUserGraph.jsp
* Purpose       : UI for Citrix farm user report
* Creation Date : 05/08/2004
* Author        : S.Solomon.
* Last Modified : 7/12/05 Sri Devi G - Citrix Reports changes - 
*                 Displays the usage details for a paritcular user
*
***************************************************************************************************/
%>
 <%@ page import="java.text.*" %>
<%@ include file="ErReporterTracker.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.net.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "java.text.ParseException" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.eg.ErDbServer"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import="net.sf.json.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%

try
{

	ErInfo erInfo = new ErInfo();
	ErUtils erUtils = new ErUtils();
	EgDateInfo egDate = new EgDateInfo();
	EgGroupInfo gpinfo = new EgGroupInfo();
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgReportInfo reportInfo = new EgReportInfo("manager");
	ErReqData erd = new ErReqData(request);

	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());
	String thisLanguage = ui.getDefaultLanguage();
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	String chartType= null;
	EgMappingInfo mappingInfo=new EgMappingInfo(thisLanguage);
	JSONObject json = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject screenData = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
			JSONArray graphModeArr = new JSONArray();

		JSONObject graphDObj = new JSONObject();
		graphDObj.put("displayField",mappingInfo.getTextDescription("reporter.common.2D"));
		graphDObj.put("valueField","2D");
		graphModeArr.add(graphDObj);
		graphDObj = new JSONObject();
		graphDObj.put("displayField",mappingInfo.getTextDescription("reporter.common.3D"));
		graphDObj.put("valueField","3D");
		graphModeArr.add(graphDObj);

		json.put("graphModeOptions",graphModeArr);
	String mode = request.getParameter("er_mode");
	boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
	String selectedGraphMode="";
	String startDateForHighchart=null;
	String endDateForHighchart=null;
	String chartTypeForUI=null;
	if(mode!=null&&!mode.equals(""))
	{
		if(mode.equals("2D"))
			selectedGraphMode="2D";
		if(mode.equals("3D"))
			selectedGraphMode="3D";
	}
	else
	{
		if(use3DGraphs)
			selectedGraphMode="3D";
		else
			selectedGraphMode="2D";
	}
	pageParams.put("selectedGraphMode",selectedGraphMode);



	String showAllUsers = null;
	String sSearch = null;
	String tmpComponent="";
	boolean getMoreUsers = false;
	Vector v_u = new Vector();
	Vector v_temp = new Vector();
	ArrayList a_compsForFarm = new ArrayList();
	Vector v_compsForFarm = new Vector();
	ArrayList aListSupportComponentType = new ArrayList();
	long msecsPerHour = (long) 1000 * 60 * 60;

	String s_user = "";
	String reqFromSchedule = request.getParameter("fromSchedule");
	String status = (String)request.getAttribute("status");
	String dispStartDate = null;
	String dispEndDate = null;
	String comFormat = null;
	String currentDateFormat =strUserDateFormat;
	String s_st_time= request.getParameter("startdate");
	String s_en_time= request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String s_st_min = request.getParameter("startmin");
	String s_en_min = request.getParameter("endmin");
	String opt=request.getParameter("er_trenddata");
	String strGraph = request.getParameter("er_graph");
	String duration = request.getParameter("er_duration");
	String showFrom = request.getParameter("showFrom");
	String INI_SUBJECT = "CITRIX_USER_REPORT";
	if(showFrom!=null && showFrom.equalsIgnoreCase("Inside view"))
	{
		INI_SUBJECT = "CITRIX_USER_REPORT_INSIDE";
	}
	String disable="";
	s_user = request.getParameter("er_user");
	String searchUser = request.getParameter("er_tuser");

	int countForUser = reportInfo.getMoreUsers(INI_SUBJECT);
	aListSupportComponentType = reportInfo.getComponentsList(INI_SUBJECT,false);
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	 //egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(s_user == null)
	{
		if(searchUser!=null && !searchUser.equals(""))
		{
			s_user = request.getParameter("er_tuser");
		}
	}
	if(s_user == null)
		s_user = "";

	String queryString = ErUtils.prepareQueryString(request.getParameterMap());
	Map temp_paramMap = ErUtils.parseQueryString(queryString);
	String userName = (String)temp_paramMap.get("er_user");
	temp_paramMap.put("er_user",EgURLEncoder.encode(userName,"UTF-8"));
	if(urs!=null)
	{
		temp_paramMap.put("uid",EgURLEncoder.encode(urs,"UTF-8"));
		temp_paramMap.put("us_id",EgURLEncoder.encode(urs,"UTF-8"));
		temp_paramMap.put("userID",EgURLEncoder.encode(urs,"UTF-8"));
	}
	if(temp_paramMap!=null && temp_paramMap.containsKey("er_info"))
	{
		String infoName = (String)temp_paramMap.get("er_info");
		temp_paramMap.put("er_info",EgURLEncoder.encode(infoName,"UTF-8"));
	}
	if(temp_paramMap!=null && temp_paramMap.containsKey("t_user"))
	{
		String infoName11 = (String)temp_paramMap.get("t_user");
		temp_paramMap.put("t_user",EgURLEncoder.encode(infoName11,"UTF-8"));
	}
	if(temp_paramMap!=null && temp_paramMap.containsKey("er_muser"))
	{
		String infoName11 = (String)temp_paramMap.get("er_muser");
		temp_paramMap.put("er_muser",EgURLEncoder.encode(infoName11,"UTF-8"));
	}
	if(temp_paramMap!=null && temp_paramMap.containsKey("er_tuser"))
	{
		String infoName11 = (String)temp_paramMap.get("er_tuser");
		temp_paramMap.put("er_tuser",EgURLEncoder.encode(infoName11,"UTF-8"));
	}
	queryString = ErUtils.prepareQueryString(temp_paramMap);
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	
	String starthour = request.getParameter("starthr");
	String endhour = request.getParameter("endhr");
	String startmin = request.getParameter("startmin");
	String endmin = request.getParameter("endmin");
	String er_timeline=request.getParameter("er_timeline");
		
	Vector v_qryStr = (Vector)request.getAttribute("chartData");
	Vector v_pdf_qryStr = (Vector)request.getAttribute("pdfData");
	int chartCount = -1;
	if (v_qryStr != null) chartCount = v_qryStr.size() / 2;

	if (startmin!=null )
	{
		if (startmin.length()==1)
			startmin="0"+startmin;
	}
	if (endmin!=null)
	{
		if (endmin.length()==1)
			endmin="0"+endmin;
	}
		String[] options=null;
		String[] lstWeeksArr=null;
	if(opt!=null && opt.equals("No"))
	{
		 options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
		 //String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
		lstWeeksArr  = new String[]{"Last week", "Last month"};	
	}
	else 
	{
		if(er_timeline!=null && !er_timeline.equals("Any"))
		{
			String tmp=er_timeline.substring(er_timeline.indexOf(" ")+1,er_timeline.length());
			
			if(tmp.startsWith("h"))
			{
				er_timeline="1 day";
			}

		}
		options =new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
		//String[] lstWeeksArr = new String[]{"Last week", "Last 2 weeks", "Last 3 weeks", "Last 4 weeks", "Last month"};	
		lstWeeksArr  = new String[]{"Last week", "Last month"};	
	}
	ErReportHelper er_rpthelper = new ErReportHelper();
	List alist = Arrays.asList(options);
	String loginName = muser.getLoginID();
	String strUsrTimeline = er_rpthelper.getUserTimeline(loginName);
	int len;
	if(strUsrTimeline == null || strUsrTimeline.length()==0)
		strUsrTimeline = "-1";
	if(strUsrTimeline != null && !strUsrTimeline.equals("") && !strUsrTimeline.equalsIgnoreCase("-1"))
	{
		len = alist.indexOf(strUsrTimeline)+1;
	}
	else
	{
		len = options.length;
	}
	JSONArray timelineJSONArray =  new JSONArray();

	for(int e_ctr=0; e_ctr < len;e_ctr++)
	{
		JSONObject jObj = new JSONObject();
		jObj.put("displayField",mappingInfo.getTextDescription("reporter.measure."+options[e_ctr]));
		jObj.put("valueField",String.valueOf(options[e_ctr]));
		timelineJSONArray.add(jObj);
	}
	List lastDataList = new ArrayList();
	JSONArray lastDataJSON = null;
	int lastWeekCount = 1;		
	if(isLastTimeLine && lstWeeksArr!=null){
		if(strUsrTimeline.equals("-1")){
			for(int i=0;i<lstWeeksArr.length;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 week")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("2 weeks")){
			lastWeekCount = 1;
			for(int i=0; i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}			
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("3 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("4 weeks")){
			lastWeekCount = 1;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}
		}else if(strUsrTimeline.equals("1 month")){
			lastWeekCount = 2;
			for(int i=0;i<lastWeekCount;i++){
				lastDataList.add(lstWeeksArr[i]);
			}
			lastDataJSON = getLastCalenJson(lastDataList);			
			for(int i=0;i<lastDataJSON.size();i++){
				timelineJSONArray.add(lastDataJSON.get(i));
			}		
		}	
	}
	String fontStyleDbl = "";
	String fontStyleDblSingl = "";
	if(dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US"))
	{
		fontStyleDbl = " multi_font";
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDbl = "";
		fontStyleDblSingl = "";
	}

	pageParams.put("fontStyle",fontStyleDblSingl);
	String print_pdfQstring = "";
	//String qStr = ErUtils.prepareQueryString(request.getParameterMap());
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);

			String value = parameter.substring(ind+1);

			if(reqparam!=null && reqparam.startsWith(" "))
			{
				reqparam = reqparam.substring(1,reqparam.length());
			}
			if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null && reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("inidate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userEndDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_stdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userStartDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userCurrTime"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_timeline"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("select_farm"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("showFrom"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}			
			else if(reqparam!=null&&reqparam.equals("deskNameData"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			print_pdfQstring += reqparam.trim()+"="+value.trim()+"&";
		}
	}
	String s_qryString = "../servlet/com.eg.ErRepoLiteC?"+print_pdfQstring+"option=Graph&printGraph=yes";
	pageParams.put("printPageUrl",s_qryString+"&pdfPrint=yes");
	pageParams.put("pdfUrl",s_qryString);



	String s_farmserver = request.getParameter("select_farm");
	String s_comp = request.getParameter("er_component");

	Vector v_comp=UBean.getAllUserComponents(3);
	String zones[] = gpinfo.getZoneNames();
	//This block is not need here at all.
	if(zones!=null && zones.length > 0)
	{
		for(int z=0; z < zones.length; z++)
		{
			String zone = zones[z];
			ArrayList al = gpinfo.getAllComponentsUnderZone(zone);
			for(int m=0;m<al.size();m++)
			{
				String comp = (String)al.get(m);
				StringTokenizer token1 = new StringTokenizer(comp,":");
				String comptype = "";
				String component = "";
				String port = "";
				String sid = "";
				if (token1.hasMoreTokens())
				{
					comptype=token1.nextToken();
					component = token1.nextToken();
					port =token1.nextToken();
					if(token1.hasMoreTokens())
						sid = token1.nextToken();
				}
				if(sid!=null && !sid.equals(""))
					tmpComponent=component+":"+port+":"+comptype + ":" + sid;
				else
					tmpComponent=component+":"+port+":"+comptype;
				if(v_comp.contains(tmpComponent) && !v_temp.contains(zone))
					v_temp.add(zone);
			}
		}
		if(v_temp!=null && v_temp.size() >0)
			Collections.sort(v_temp);
	}

	if(s_farmserver!=null && !(s_farmserver.equals("-1")))
	{
		ArrayList al = gpinfo.getAllComponentsUnderZone(s_farmserver);//zone comps
		if(al!=null && al.size() > 0)
		{
			for(int a=0; a < al.size(); a++)
			{
				String comp = (String)al.get(a);
				StringTokenizer st_c = new StringTokenizer(comp,":");
				String compName = "";
				String portNo = "";
				String compType = "";
				String sid="";
				String startdate="";
				if(st_c.hasMoreTokens())
				{
					compType = (String)st_c.nextToken();
					compName = (String)st_c.nextToken();
					portNo = (String)st_c.nextToken();
					if (st_c.hasMoreTokens())
						sid=st_c.nextToken();
				}
				tmpComponent = compName + ":" + portNo + ":" + compType;

				if(v_comp.contains(tmpComponent) && (tmpComponent.endsWith(":Citrix_MF_XP")|| tmpComponent.endsWith(":Citrix_server")||tmpComponent.endsWith(":Terminal_server") || tmpComponent.endsWith(":Vmware_vdi_server") || tmpComponent.endsWith(":VmVdi_i_server") || aListSupportComponentType.contains(compType)))
				{
					if(!a_compsForFarm.contains(comp))
						a_compsForFarm.add(comp);
					if(!v_compsForFarm.contains(tmpComponent))
						v_compsForFarm.add(tmpComponent.substring(0,tmpComponent.lastIndexOf(":")));
				}
			}
			if(a_compsForFarm!=null && a_compsForFarm.size() > 0)
			{
				String strCompTypeValue = request.getParameter("er_compType");
				if(s_comp!=null && !(s_comp.equals("-1")))
					if(strCompTypeValue!=null && aListSupportComponentType.contains(strCompTypeValue))
					{
						String dddTest = reportInfo.getTestName(INI_SUBJECT,strCompTypeValue,false);
						v_u = erInfo.getUsersInFarm("NULL",dddTest,a_compsForFarm);
					}
					else
						v_u = erInfo.getUsersInFarm("NULL","CtxLoginTest_DDD",a_compsForFarm);
			}
		}
		if(v_compsForFarm!=null && v_compsForFarm.size() > 0)
			Collections.sort(v_compsForFarm);
	}

	sSearch = request.getParameter("showSearch");
	int cntUserForFarm = 0;
	if(v_u!=null)
		cntUserForFarm = v_u.size();
	if(cntUserForFarm > countForUser)
		getMoreUsers = true;
	if(sSearch == null || sSearch.equals(""))
		sSearch = String.valueOf(getMoreUsers);
	if(sSearch.equals("false"))
	{
		if(getMoreUsers)
			sSearch = "true";
	}
	if(s_user!=null && s_user.equals("-1"))
		s_user = "";
	if(v_u!=null && v_u.size() > 0)
	{
		Collections.sort(v_u);
	}

	String dispComp = s_comp;
	if(s_comp!=null && s_comp.endsWith(":NULL"))
	{
		dispComp = s_comp.substring(0,s_comp.indexOf(":"));
	}
	

	// for redirecting same page in reporter Starts
	String query_String=(String)ErUtils.prepareQueryString(request.getParameterMap());
	String q_String="";
	String q_StringBackUrl = "";
	if(query_String!=null)
	{
		StringTokenizer str_tok = new StringTokenizer(query_String,"&");
		while(str_tok.hasMoreTokens())
		{
			String para_meter = str_tok.nextToken();
			int ind = para_meter.indexOf("=");
			if (ind < 0)
				continue;
			String req_param =para_meter.substring(0,ind);
			String value = para_meter.substring(ind+1);
			if(req_param!=null) {
				 if(req_param.equals("starttime") || req_param.equals("endtime") || req_param.equals("startHr") || req_param.equals("endHr") || req_param.equals("startmin") || req_param.equals("endmin") || req_param.equals("inidate"))
				{
					continue;
				} 
				q_String += req_param+"="+value+"&";
			}
		}
	}
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";

	 v_qryStr = (Vector)request.getAttribute("chartData");
	 v_pdf_qryStr = (Vector)request.getAttribute("pdfData");
	 chartCount = -1;
	if (v_qryStr != null) chartCount = v_qryStr.size() / 2;
	String userTBound = request.getParameter("userTBound");
	String userStartDate = request.getParameter("userStartDate");
	String userEndDate = request.getParameter("userEndDate");
	String userStHr = request.getParameter("userStHr");
	String userEndHr = request.getParameter("userEndHr");
	String select_server = request.getParameter("select_server1");
	String userTimeline = request.getParameter("userTimeline");
	String userCurrTime = request.getParameter("userCurrTime");
	String timeTo = request.getParameter("timeto");
	String timeFrom = request.getParameter("timefrom");
	String exc = request.getParameter("er_excwe");
	showAllUsers = request.getParameter("showAll");
	if(showAllUsers == null)
		showAllUsers = "false";
	if(exc == null)
		exc = "No";

	String t_showAllUsers = showAllUsers;
	String minFrom = request.getParameter("minfrom");
	String minTo = request.getParameter("minto");
	String gType = request.getParameter("er_gtype");
	String rType = request.getParameter("er_rtype");
	String tType = request.getParameter("er_trgttype");
	String t_auser = request.getParameter("t_user");
	String compType = request.getParameter("er_compType");
	String period = request.getParameter("er_period");
	String ertuser = request.getParameter("er_tuser");
	String er_info = request.getParameter("er_info");
	String deskNameData = request.getParameter("deskNameData");
	if(ertuser == null)
	{
		ertuser = s_user;
	}
	if(deskNameData == null)
	{
		deskNameData = "";
	}
	if(er_info==null)
	{
		er_info = "*"+t_auser;
	}
	String t_ertuser = ertuser;
	if(compType == null)
		compType = "Citrix_MF_XP";
	String t_tauser = t_auser;
	if((timeTo!=null && timeTo.equals("")) && (timeFrom!=null && timeFrom.equals("")) && (minFrom!=null && minFrom.equals("")) && (minTo!=null && minTo.equals("")))
	{
		String fromTime = reportInfo.getTimeFrame(INI_SUBJECT,"FROM");
		timeFrom = fromTime.substring(0,fromTime.indexOf(":"));
		minFrom = fromTime.substring(fromTime.indexOf(":")+1);
		String toTime = reportInfo.getTimeFrame(INI_SUBJECT,"TO");
		timeTo = toTime.substring(0,toTime.indexOf(":"));
		minTo = toTime.substring(toTime.indexOf(":")+1);
	}
	String temp_user = null;

	StringBuffer sbHiddenQStr = new StringBuffer();
	sbHiddenQStr.append("&er_rtype="+rType);
	sbHiddenQStr.append("&er_trgttype="+tType);
	sbHiddenQStr.append("&er_gtype="+gType);
	sbHiddenQStr.append("&er_period="+period);
	sbHiddenQStr.append("&er_site=");
	sbHiddenQStr.append("&er_compType="+compType);
	sbHiddenQStr.append("&showAll="+showAllUsers);
	sbHiddenQStr.append("&t_user="+t_auser);
	//sbHiddenQStr.append("&starthr="+timeFrom);
	//sbHiddenQStr.append("&endhr="+timeTo);
	sbHiddenQStr.append("&minfrom="+minFrom);
	sbHiddenQStr.append("&minto="+minTo);
	sbHiddenQStr.append("&showSearch="+getMoreUsers);
	sbHiddenQStr.append("&er_muser="+EgURLEncoder.encode(t_ertuser, "UTF-8"));
	sbHiddenQStr.append("&inidate="+currentDateFormat);
	sbHiddenQStr.append("&startmins="+s_st_min);
	sbHiddenQStr.append("&endmins="+s_en_min);
	sbHiddenQStr.append("&er_secs="+request.getParameter("er_secs"));
	sbHiddenQStr.append("&getMaxDaysInMonth="+ErUtils.getMaxDaysInMonth());
	sbHiddenQStr.append("&getTest="+request.getParameter("getTest"));
	sbHiddenQStr.append("&getMeasure="+request.getParameter("getMeasure"));
	sbHiddenQStr.append("&er_user="+request.getParameter("er_user"));
	sbHiddenQStr.append("&er_component="+request.getParameter("er_component"));
//	 sbHiddenQStr.append("&userStartDate="+userStartDate);
//	sbHiddenQStr.append("&userEndDate="+userEndDate);
	sbHiddenQStr.append("&userCurrTime="+userCurrTime);
	sbHiddenQStr.append("&userStHr="+userStHr);
	sbHiddenQStr.append("&userEndHr="+userEndHr);
	sbHiddenQStr.append("&userTBound="+userTBound);
	sbHiddenQStr.append("&thisIs=UserGraph");
	sbHiddenQStr.append("&er_type_proc=Yes");
	sbHiddenQStr.append("&showSearch=false");
	sbHiddenQStr.append("&likeAllUsers=false");
	sbHiddenQStr.append("&er_tbound=Any");
	sbHiddenQStr.append("&onlyThisUser=false");
	sbHiddenQStr.append("&er_tuser="+request.getParameter("er_tuser"));
	sbHiddenQStr.append("&er_excwe=No");
	sbHiddenQStr.append("&er_usertimeline="+userTimeline);
	sbHiddenQStr.append("&select_farm="+s_farmserver);
	sbHiddenQStr.append("&er_info="+request.getParameter("er_info"));
	sbHiddenQStr.append("&deskNameData="+request.getParameter("deskNameData"));

	hiddenParams.put("er_usertimeline",strUsrTimeline);
	String hiddenQStr ="";
	if(sbHiddenQStr!=null)
	{
		hiddenQStr = sbHiddenQStr.toString();
	}
	json.put("hiddenQStr",hiddenQStr);

	if (chartCount == 1)
	{
			String Qstring1="";
			String tmpQS1=(String)v_qryStr.get(1);
			if(tmpQS1!=null)
			{
				StringTokenizer strtok = new StringTokenizer(tmpQS1,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					if(param!=null && param.indexOf("?")>0)
					{
						if((param.substring(param.indexOf("?")+1)).indexOf("=")>0)
						{
							Qstring1 += param.substring(0,param.indexOf("?")+1);
							param = param.substring(param.indexOf("?")+1);
						}
					}
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					if(reqparam.equals("er_component"))
					{
						value=EgURLEncoder.encode(value,"UTF-8") ;
					}
					if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
						if(value!=null)
							value = EgURLEncoder.encode(value,"UTF-8");
					}
					//prakash
					if(reqparam!=null && reqparam.equalsIgnoreCase("er_info"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equalsIgnoreCase("t_user"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equalsIgnoreCase("er_tuser"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equalsIgnoreCase("er_muser"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					//
					Qstring1=Qstring1+reqparam+"="+value+"&";
				}
			}
			pageParams.put("dataPageUrl",Qstring1+"option=data");
			TestBean testBean = new TestBean();
			if(testBean.isDdEnabled(request.getParameter("getTest"),request.getParameter("getMeasure")))
			{
				String componentStr = request.getParameter("er_component");
				String compport = "";
				ArrayList compList = new ArrayList();
				if(componentStr.indexOf(":")>-1)
				{
					compport = componentStr.substring(componentStr.indexOf(":")+1,componentStr.length());
					componentStr = componentStr.substring(0,componentStr.indexOf(":"));
				}
				compList.add(componentStr);
				String user_dd = er_info;
				if(user_dd.startsWith("*"))
				{
					user_dd = user_dd.substring(1);
				}
				Vector vec_infos = erInfo.getInfosForTest(request.getParameter("getTest"),compList);
				//System.out.println("vec_infos____ "+vec_infos);
				//System.out.println("user_dd "+user_dd);
				boolean infoPresent = false;
				if(vec_infos!=null && vec_infos.size()>0)
				{
					if(user_dd.indexOf(":")>-1)
					{
						user_dd = user_dd.substring(0,user_dd.indexOf(":"));
					}
					String strInfo = null;
					for(int i=0;i<vec_infos.size();i++)
					{
						strInfo = (String) vec_infos.get(i);
						if(strInfo!=null && strInfo.indexOf("+")>-1)
						{
							strInfo = strInfo.substring(1);
						}
						if(!strInfo.endsWith(":Summary"))
							continue;
						if(strInfo.startsWith(user_dd))
						{
							infoPresent = true;
							user_dd = strInfo;
							break;
						}
					}
					if(!infoPresent)
					{
						if(!vec_infos.contains("+"+user_dd) && !vec_infos.contains(user_dd))
						{
							user_dd = strInfo;
						}
					}
				}
				er_info = "*"+user_dd;
				String dd_url = "";
				dd_url = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(request.getParameter("er_compType"),"UTF-8")+"&site=&host="+EgURLEncoder.encode(componentStr,"UTF-8")+"&port="+compport+"&info="+EgURLEncoder.encode(er_info,"UTF-8")+"&starttime="+request.getParameter("startdate")+"&endtime="+request.getParameter("enddate")+"&starthr="+request.getParameter("starthr")+"&endhr="+ request.getParameter("endhr")+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&state=&messy="+request.getParameter("getMeasure")+"&msmt_host=&userID="+EgURLEncoder.encode(urs,"UTF-8")+"&test="+request.getParameter("getTest")+"&comptype="+request.getParameter("er_compType")+"&measureDisp="+request.getParameter("getMeasure")+"&from=measurespage&dd=yes&clicked=dd&newWindow=true&fromReporterHis=true&popup=true&fromPage=eveHist";
				pageParams.put("ddPageUrl",dd_url);
			}
			else
			{
				pageParams.put("ddPageUrl","-");
			}
	}
	screenLabels.put("Zone",mappingInfo.getTextDescription("reporter.common.Zone"));
	screenLabels.put("Component",mappingInfo.getTextDescription("reporter.common.Component"));
	screenLabels.put("User",mappingInfo.getTextDescription("reporter.common.User"));

	if(s_farmserver!=null && !s_farmserver.equals("-1"))
	screenData.put("Zone",s_farmserver);
	screenData.put("Component",dispComp);
	screenData.put("User",s_user);

	if(er_timeline!=null)
		pageParams.put("er_timeline",er_timeline);

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispStartDate = DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
	}
	else
	{
		dispStartDate = s_st_time;
	}

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
		}
		else
		{
			comFormat = currentDateFormat;
		}
		dispEndDate = DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
	}
	else
	{
		dispEndDate = s_en_time;
	}
//
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd=null;
	converterStart = new EgTimeZoneConverter(dispStartDate+" "+s_st_hr+":"+s_st_min,thisuser);
	startDateForHighchart=dispStartDate + " "+ s_st_hr + ":" +s_st_min; 
	String startDateForDisplay = (String)converterStart.getDate(false);
	String startHourForDisplay = (String)converterStart.getHour();
	String startMinForDisplay  = (String)converterStart.getMinute();
	converterEnd = new EgTimeZoneConverter(dispEndDate+" "+s_en_hr+":"+s_en_min,thisuser);
	endDateForHighchart=dispEndDate + " "+ s_en_hr + ":" +s_en_min;
	String endDateForDisplay   = (String)converterEnd.getDate(false);
	String endHourForDisplay   = (String)converterEnd.getHour();
	String endMinForDisplay    = (String)converterEnd.getMinute();
	if(dispStartDate!=null)
		pageParams.put("startdate",s_st_time);
	if(s_st_hr!=null)
		pageParams.put("starthr",s_st_hr);
	if(startmin!=null)
		pageParams.put("startmin",s_st_min);
	if(dispEndDate!=null)
		pageParams.put("enddate",s_en_time);
	if(s_en_hr!=null)
		pageParams.put("endhr",s_en_hr);
	if(endmin!=null)
		pageParams.put("endmin",s_en_min);
	pageParams.put("startDateForDisplay",startDateForDisplay);
	pageParams.put("startHourForDisplay",startHourForDisplay);
	pageParams.put("startMinForDisplay",startMinForDisplay);
	pageParams.put("endDateForDisplay",endDateForDisplay);
	pageParams.put("endHourForDisplay",endHourForDisplay);
	pageParams.put("endMinForDisplay",endMinForDisplay);
	//
	chartTypeForUI=ErHighchartUtils.getChartType(startDateForHighchart,endDateForHighchart,currentDateFormat+" HH:mm");
	json.put("chartType",chartTypeForUI);
	//
	if(chartCount > 0)
	{
		String t_gtype = "Citrix";
		String t_trgttype = "User Report";
		String backQuery="../servlet/com.eg.ErCtxServerReportC?select_farm="+ s_farmserver + "&er_timeline=" + userTimeline + "&currTime=" + userCurrTime + "&er_excwe=" + exc + "&minfrom=" + minFrom + "&minto=" + minTo + "&er_gtype=Citrix&er_trgttype=User Report&er_rtype=User&er_tbound=" + userTBound + "&timefrom=" + timeFrom + "&timeto=" + timeTo + "&er_view=&startdate=" + s_st_time + "&enddate=" + s_en_time + "&starthr=" + s_st_hr + "&endhr=" + s_en_hr + "&er_compType=" + compType+"&startmin="+s_st_min+"&endmin="+s_en_min;

		if(select_server!=null && !select_server.equals(""))
			backQuery+= "&select_server1=" + select_server;
		if((t_showAllUsers!=null || !t_showAllUsers.equals("")) && t_showAllUsers.equalsIgnoreCase("true"))
		{
			backQuery+="&er_user=-- All --" + "&t_user=" + t_tauser;
		}
		else if(sSearch.equalsIgnoreCase("true"))
		{
			backQuery+="&showSearch=" + sSearch + "&er_tuser=" + t_ertuser;
		}
		else
			backQuery+="&er_user=" + s_user;
	}
	if(chartCount > 0)
	{
		if(chartCount == 1)
		{
			String s_title=(String)v_qryStr.get(0);
			if(s_title.indexOf("/")>-1)
			{
				String strDispTitle = "";
				strDispTitle = mappingInfo.getTestDescription(s_title.substring(0,s_title.indexOf("/")));
				strDispTitle += "/";
				strDispTitle += mappingInfo.getMeasureDescription(s_title.substring(0,s_title.indexOf("/")),s_title.substring(s_title.indexOf("/")+1));
				pageParams.put("imgTitle",strDispTitle);
			}
			else
			{
				pageParams.put("imgTitle",mappingInfo.getTextDescription("reporter.common."+s_title));
			}
			String Qstring1="";
			String tmpQS1=(String)v_qryStr.get(1);
			if(tmpQS1!=null)
			{
				StringTokenizer strtok = new StringTokenizer(tmpQS1,"&");
				while(strtok.hasMoreTokens())
				{
					String param = strtok.nextToken();
					if(param!=null && param.indexOf("?")>0)
					{
						if((param.substring(param.indexOf("?")+1)).indexOf("=")>0)
						{
							Qstring1 += param.substring(0,param.indexOf("?")+1);
							param = param.substring(param.indexOf("?")+1);
						}
					}
					String reqparam =param.substring(0,param.indexOf("="));
					String value = param.substring(param.indexOf("=")+1,param.length());
					//prakash
					if(reqparam!=null && reqparam.equals("t_user"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equals("er_muser"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equals("er_info"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equals("er_tuser"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					if(reqparam!=null && reqparam.equals("er_muser"))
					{
						value = EgURLEncoder.encode(value, "UTF-8");
					}
					//
					if(reqparam.equals("er_component"))
					{
						value=EgURLEncoder.encode(value,"UTF-8") ;
					}
					if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
						if(value!=null)
							value = EgURLEncoder.encode(value,"UTF-8");
					}
					Qstring1=Qstring1+reqparam+"="+value+"&";
				}
			}
				pageParams.put("imgUrl",Qstring1+"&er_width=970&er_height=300&option=graph");
				pageParams.put("imgWidth","970");
				pageParams.put("imgHeight","400");
				pageParams.put("imgToolTip",v_qryStr.get(0));
		}
		else
		{
			for(int i=0;i<chartCount;i++)
			{
				String s_title =(String)v_qryStr.get(i*2);
				pageParams.put("imgTitle",mappingInfo.getTextDescription(s_title));
				String Qstring="";
				String tmpQS=(String)v_qryStr.get(i*2+1);
				if(tmpQS!=null)
				{
						StringTokenizer strtok = new StringTokenizer(tmpQS,"&");
						while(strtok.hasMoreTokens())
						{
							String param = strtok.nextToken();
							String reqparam =param.substring(0,param.indexOf("="));
							String value = param.substring(param.indexOf("=")+1,param.length());
							//prakash
							if(reqparam!=null && reqparam.equals("t_user"))
							{
								value = EgURLEncoder.encode(value, "UTF-8");
							}
							if(reqparam!=null && reqparam.equals("er_info"))
							{
								value = EgURLEncoder.encode(value, "UTF-8");
							}
							if(reqparam!=null && reqparam.equals("er_tuser"))
							{
								value = EgURLEncoder.encode(value, "UTF-8");
							}
							if(reqparam!=null && reqparam.equals("er_muser"))
							{
								value = EgURLEncoder.encode(value, "UTF-8");
							}
							//
							if(reqparam.equals("er_component"))
							{
								value=EgURLEncoder.encode(value,"UTF-8") ;
							}
							Qstring=Qstring+reqparam+"="+value+"&";
					}
				}
				pageParams.put("imgUrl",Qstring+"&er_width=670&er_height=400&option=graph");
				pageParams.put("imgWidth","670");
				pageParams.put("imgHeight","400");
				pageParams.put("imgToolTip",v_qryStr.get(i));
			}
		}

		HashMap param = new HashMap();
		HashMap m=ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap()));
		m.put("er_timeline",URLEncoder.encode((String)m.get("er_timeline")));
		userName=(String)m.get("er_user");
		m.put("er_user",EgURLEncoder.encode(userName,"UTF-8"));
		param.put("REPORT_PARAM",m);

		Vector v_newPdf_qry=new Vector();
		if(v_pdf_qryStr!=null)
		{
			for(int v=0;v<v_pdf_qryStr.size();v=v+2)
			{
				v_newPdf_qry.add((String)v_pdf_qryStr.get(v));
				String  s_qry=(String)v_pdf_qryStr.get(v+1);
				String SQstring="";
				if(s_qry!=null)
				{
					StringTokenizer strtok = new StringTokenizer(s_qry,"&");
					String surl=s_qry.substring(0,s_qry.indexOf("&"));
					while(strtok.hasMoreTokens())
					{
						String param1 = strtok.nextToken();
						if(param1!=null && param1.indexOf("?")>0)
						{
							if((param1.substring(param1.indexOf("?")+1)).indexOf("=")>0)
							{
								SQstring += param1.substring(0,param1.indexOf("?")+1);
								param1 = param1.substring(param1.indexOf("?")+1);
							}
						}
						if(param1.indexOf("=")>-1)
						{
							String reqparam =param1.substring(0,param1.indexOf("="));
							String stdate_param=param1.substring(param1.indexOf("?")+1,param1.indexOf("="));
							String value=param1.substring(param1.indexOf("=")+1,param1.length());
							if(reqparam.equals("er_component") || reqparam.equals("er_info_list") || reqparam.equals("er_selection"))
							{
								if(value!=null && value.equals("-1"))
									value="";
								if(value!=null  && !value.equals(""))
									value=EgURLEncoder.encode(URLDecoder.decode(value),"UTF-8");
							}
							//if((reqparam.equals("enddate")|| stdate_param.equals("startdate")|| reqparam.equals("inidate"))&& value.indexOf(" ")>-1)
								//value=URLEncoder.encode(value);
							if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
								if(value!=null)
									value = EgURLEncoder.encode(value,"UTF-8");
							}
							SQstring=SQstring+reqparam+"="+value+"&";
						}
					}
					if(SQstring.endsWith("&"))
						SQstring=SQstring.substring(0,SQstring.lastIndexOf("&"));
					v_newPdf_qry.add(SQstring);
				}
			}
		}
		param.put("REPORT_DATA",v_newPdf_qry);
		param.put("fileName","User-Report");
		session.setAttribute("parameters", param);
	}

	String mailQstring = "";
	//String qStr = ErUtils.prepareQueryString(request.getParameterMap());
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);

			String value = parameter.substring(ind+1);

			if(reqparam!=null && reqparam.startsWith(" "))
			{
				reqparam = reqparam.substring(1,reqparam.length());
			}
			if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null && reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("inidate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userEndDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_stdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userStartDate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("userCurrTime"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_timeline"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("select_farm"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("t_user"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam.equals("uid") || reqparam.equals("us_id") || reqparam.equals("userID")) {
				if(value!=null)
					value = EgURLEncoder.encode(value,"UTF-8");
			}
			mailQstring += reqparam.trim()+"="+value.trim()+"&";
		}
	}


	session.setAttribute("DrillDownPage","yes");
//	queryString
	String dataProcess =  mngrIProc+"/final/servlet/com.eg.ErRepoLiteC"+";jsessionid="+session.getId()+"?"+mailQstring+"&print=yes&sample=yes&drillSes=yes&printGraph=yes";
	session.setAttribute("DRILLDOWN_MAIL_URL",dataProcess);
	session.setAttribute("DRILLDOWN_PDF_URL", mngrIProc+"/final/servlet/com.eg.ErRepoLiteC");
	json.put("timelineJSONArray",timelineJSONArray);

	json.put("hiddenQStr",hiddenQStr);
	json.put("pageParams",pageParams);
	json.put("hiddenParams",hiddenParams);
	json.put("screenLabels",screenLabels);
	json.put("selectionDetails",screenData);
	json.put("userID",urs);
	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(json.toString());
	}
	catch(Exception e)
	{
		System.out.println(e);
		e.printStackTrace();
	}
%>
<%! 
	public JSONArray getLastCalenJson(List weekList) {
		JSONArray tmpJsonArr=new JSONArray();
		JSONObject timelineJSON = null;	
		String tmpTimeLine = null;
		String viewField=null;			
		for(int x=0;x<weekList.size();x++){
			tmpTimeLine = (String)weekList.get(x);	
			int spaceCount = 0;	
			for(int y=0; y<tmpTimeLine.length();y++){				
				char ch = tmpTimeLine.charAt(y);
				if(ch== ' '){
				   spaceCount++; 
				}
			}
			if(spaceCount > 1){
				//Last 2 weeks    weeks_last 2
				String countStr = tmpTimeLine.substring(tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
				String end = tmpTimeLine.substring(tmpTimeLine.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1,tmpTimeLine.length());
				String last = tmpTimeLine.substring(0, tmpTimeLine.indexOf(DateTimeTokenizer.BLANK_SPACE));
				viewField = countStr +" "+ end + "_" + last;				
			}else{
				viewField = "1 "+tmpTimeLine.substring(tmpTimeLine.lastIndexOf(" ")+1, tmpTimeLine.length())  + "_" + tmpTimeLine.substring(0, tmpTimeLine.indexOf(" "));				
			}
			timelineJSON = new JSONObject();	
			timelineJSON.put("displayField",tmpTimeLine);
			timelineJSON.put("valueField", viewField.toLowerCase());
			tmpJsonArr.add( timelineJSON );		
		}		
		return tmpJsonArr;
   } 
%>
