<!DOCTYPE html>
<%
/**************************************************************************************************
* File name			: ErAlarmHistoryPrint.jsp
* Purpose			: Genarates History of Alarms Print Report
* Version			: 1.0
* Creation			: 9th June 2011
* Last Modified 	:
* Author			: Sathya Kala Veeraraj
**************************************************************************************************/
%>

<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.JSONArray" %>
<%@ page import = "net.sf.json.JSONObject" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%
	try
	{
//Request Parameter Map
		HashMap param = new HashMap();
		ErAlarmHistoryHelper helper1      = new ErAlarmHistoryHelper();
		param = ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap()));

		
//Request Parameter
		String event                 = request.getParameter("v_event");
		String sub_event             = request.getParameter("subevent");
		if(sub_event!=null)
			sub_event = com.eg.EgURLDecoder.decode(sub_event,"UTF-8");
		String compTypeList             = request.getParameter("compTypeList");
		String pdfPrint              = request.getParameter("pdfPrint");
		String user_id               = request.getParameter("er_userid");
		String unknownStatePrint               = request.getParameter("unknownState");
		String reporterSkin          = "";
		String s_startTime           = request.getParameter("startdate")+" "+ request.getParameter("starthr")+":"+ request.getParameter("startmin");
		String s_endTime             = request.getParameter("enddate")+" "+ request.getParameter("endhr")+":"+ request.getParameter("endmin");
		String fontStyleDbl          = "";
		String fontStyleDblSingl     = "";
		String sHideView             = event;
		String logoImage             = "";

//Class Initialization

		com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
		User user = UserRegistry.getInstance().getUser(request.getSession().getId());
		EgDbInfo dbInfo = new EgDbInfo("manager");

//User Language

		String thisLanguage = ui.getDefaultLanguage();
		if(user_id!=null)
		{
			ErUserData erUserData = new ErUserData(user_id,false);
			user = erUserData.getUser(user_id);
		}
		if (user!=null)
		{
			String userLang = user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage = userLang;
			}
		}

		EgMappingInfo mappinginfo = new EgMappingInfo(thisLanguage);
		compTypeList = (String)mappinginfo.getComponentTypeDescription(compTypeList);
//UI Skin

		if(user!=null)
			reporterSkin = user.getReporterSkin();

//DoubleByte - Other Language Support

		if((dbInfo.doubleByteEnabled || !thisLanguage.equals("en_US")) && !(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes")))
			fontStyleDblSingl = "multi_font";
		else
			fontStyleDblSingl = "";

//Include ErTracker.jsp only when No Measures are available.
//This is because skin is not set in Background & Schedule.

		if(pdfPrint == null || !pdfPrint.equalsIgnoreCase("yes"))
		{
			if(session.getAttribute("NO_OF_ALARMS")==null || session.getAttribute("NO_OF_ALARMS").equals(""))
			{
%>
				<%@ include file = "ErTracker.jsp" %>
<%
			}
		}
		EgTimeZoneConverter ConverterStart = new EgTimeZoneConverter(s_startTime,user);
		EgTimeZoneConverter ConverterEnd = new EgTimeZoneConverter(s_endTime,user);
		String st_dateTime = ConverterStart.getDateTime();
		String en_dateTime = ConverterEnd.getDateTime();
		String er_RmDispName =request.getParameter("er_RmDispName");
%>
<html>
	<head>
		<title> &nbsp; eG Manager </title>

<meta name="Author" content="">
<meta  charset="UTF-8">

<!--<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />-->
	<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />

<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>
</head>

<!--<body  style="padding:10px;background-color:#ffffff">-->
<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">

<!--<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;">
	<tr>
		<td width="100%" align="center" height="100%" valign="top">	 -->
			<!--<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr> -->
<%
				String strLogCls = "printHeaderBoxLogo";
				if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
				{
					strLogCls = "printHeaderBoxLogo";
				}else
					strLogCls = "printPdfHeaderBoxLogo";

				logoImage = ui.getReporterHomeLogo();
				if(user!=null)
				{
					ui.set_userLogo(user.getUserLogo());
					ui.set_loginID(user.getLoginID());
					logoImage = ui.getReporterHomeLogo();
				}
				if(ui.isHKTThemeEnabled())
					logoImage = ui.getHKTReporterLogo();
			/*	if(pdfPrint == null || !pdfPrint.equalsIgnoreCase("yes"))
				{ */
%>
					<!--<td style="padding:5px 10px 10px 10px"><img src='<%=logoImage%>' border="0" /></td>-->
		<div class="<%=strLogCls%>"><img src="<%=logoImage%>" border="0" /></div>
<%
				//}
%>
				<!--</tr>
			</table>-->
		<!--<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:fixed;">
		<tr>
		<td width="100%" align="center" height="100%" valign="top">	 -->

			<!--<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
					<td >-->
	<div class="printHeaderBox">
<%
	if (!StringUtils.isNull(er_RmDispName))
	{
%>
						<!--<div style="float:left" > <header><%= er_RmDispName %></header></div>-->
			<div class="printHeaderBoxTitle" style="float:left"><%= er_RmDispName %></div>
<%
	}
	else
	{
		if(unknownStatePrint !=null && unknownStatePrint.equals("UNKNOWN"))
		{
%>
			<div class="printHeaderBoxTitle" style="float:left"><egui:intnl text="reporter.common.Operation Reports"/> - <egui:intnl text="reporter.alarmHistory.History of Unknowns Report"/></div>
<%
		}
		else
		{
%>
			<div class="printHeaderBoxTitle" style="float:left"><egui:intnl text="reporter.common.Operation Reports"/> - <egui:intnl text="reporter.alarmHistory.History of Alarms Report"/></div>
<%
		}
	}
	%>
<%// Print Image only for Print Page
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
			<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrintPreview mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>					  
		
	</div>

<%
		if(unknownStatePrint !=null && unknownStatePrint.equals("UNKNOWN"))
		{
%>
			<!--<div style="float:left" class="formValue"> <egui:intnl text="reporter.alarmHistory.History of Unknowns Report"/></div>-->
<%
		}
		else
		{
%>
			<!--<div style="float:left" class="formValue"> <egui:intnl text="reporter.alarmHistory.History of Alarms Report"/></div>-->
<%
		}
%>
		<!-- analysis by & ComponentType -->
		<div class="printOuterBoxNoBorder"> 

<%
		if(event!=null && event.equalsIgnoreCase("Component"))
		{
%>
			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis by" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=event%></div>
			</div> -->
			<div class="printSelectionFields" ><egui:intnl text="reporter.common.Analysis by"/> - <span class="bold"><egui:intnl text='<%=event%>' /></span></div>

			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=compTypeList%></div>
			</div>-->
			<div class="printSelectionFields" ><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><egui:intnl text='<%=compTypeList%>' /></span></div>
<%
		}
		else
		{
%>
			<!--<div style="float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Analysis by" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=event%></div>
			</div>-->
			<div class="printSelectionFields" ><egui:intnl text="reporter.common.Analysis by"/> - <span class="bold"><egui:intnl text='<%=event%>' /></span></div>

			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="<%="reporter.history."+event%>"/></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=sub_event%></div>
			</div>-->
			<div class="printSelectionFields" ><egui:intnl text="<%="reporter.history."+event%>"/> - <span class="bold"><egui:intnl text='<%=sub_event%>' /></span></div>

			<!--<div style="clear:both;float:left;padding:4px;">
				<div style="float:left" class="formLabel"><egui:intnl text="reporter.common.Component Type" /></div>
				<div style="float:left;width:10px" align="center" >:</div>
				<div style="float:left;" class="formValue"><%=compTypeList%></div>
			</div> -->
			<div class="printSelectionFields" ><egui:intnl text="reporter.common.Component Type" />- <span class="bold"><egui:intnl text='<%=compTypeList%>' /></span></div>
<%
		}
%>		  
		
			<div class="printSelectionFields"><%=mappinginfo.getTextDescription("reporter.common.Timeline")%> - <span class="bold"><%=st_dateTime%>&nbsp;<egui:intnl text="reporter.common.hrs" /> to <%=en_dateTime%>&nbsp;<egui:intnl text="reporter.common.hrs" /></span></div>
</div>
			
<%
		if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
		{
			if(unknownStatePrint !=null && unknownStatePrint.equals("KNOWN"))
			{
				String controllerURL = "../servlet/com.eg.ErAlarmHistoryC;jsessionid=" + session.getId()+"?";
				JSONObject overViewDataObj = (JSONObject)session.getAttribute("ALARMOVER_VIEW_DATA");
				JSONObject pieChartObj = null;
				JSONObject alaramDistChartObj = null;
				JSONObject tmp = null;
				JSONArray overViewPieLegend = null;
				JSONArray alarmDistLegend = null;
				int alarmDistLegendSize = 0;
				String overViewCharURL = null;
				String distCharURL = null;
				if(session.getAttribute("ALARM_OVER_VIEW_CHART")!=null)
				{
					pieChartObj = (JSONObject)session.getAttribute("ALARM_OVER_VIEW_CHART");
					overViewPieLegend = (JSONArray)pieChartObj.get("overViewLegend");					
					overViewCharURL = controllerURL +"sessionKey=ALARM_OVER_VIEW_CHART&option=print&width=250&height=260";
				}
				if(session.getAttribute("ALARM_DIST_CHART") != null)
				{
					alaramDistChartObj = (JSONObject)session.getAttribute("ALARM_DIST_CHART");
					alarmDistLegend = (JSONArray)alaramDistChartObj.get("AlarmDistLegend");
					alarmDistLegendSize = alarmDistLegend.size();
					distCharURL = controllerURL +"sessionKey=ALARM_DIST_CHART&option=print&width=250&height=260";
				}
				String trendChartURL = controllerURL +"sessionKey=ALARM_TREND_DATA&option=print&width=880&height=300";
				%>
				<table width="100%"  height="100%" border="0" cellspacing="2" >
					<tbody>
						<tr><td colspan="2">
							<div class="printOuterBox">
							<div class="printOuterBoxHeader"><%=mappinginfo.getTextDescription("reporter.common.Overview")%></div>
							<table width = "100%">								
								<tr>
									<td width="25%">
										<table  width="100%" align="center" cellspacing="0" border="0" style="align:center;margin:auto auto;">
											<tr><td colspan="1" rowspan="1">
											<table align="center">
												<tr>
													<td align="right"><div class="summaryOpenProblems"></div></td>
													<td class="newFont_bold28"><%=overViewDataObj.get("totalAlarms")%></td>				
												</tr>
												<tr style="text-align: center;">
													<td colspan="2" rowspan="2" class="newFont_normal13"><%=mappinginfo.getTextDescription("reporter.common.Total Alarms")%></td>
												</tr>	
											</table></td></tr>											
										</table>
									</td>
									<td width="25%">
										<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
											<tr><td colspan="1" rowspan="1">
											<table align="center" style="align:center;margin:auto auto;">
												<tr>
													<td align="right"><div class="summaryMaximumDuration"></div></td>
													<td class="newFont_bold28"><%=overViewDataObj.get("minDuration")%></td>				
												</tr>
												<tr style="text-align: center;">
													<td colspan="2" rowspan="2" class="newFont_normal13"><%=mappinginfo.getTextDescription("reporter.common.Min")%></td>
												</tr>
											</table></td></tr>											
										</table>
									</td>
									<td width="25%">
										<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
											<tr><td colspan="1" rowspan="1">
											<table align="center" style="align:center;margin:auto auto;">
												<tr>
													<td align="right"><div class="summaryMaximumDuration"></div></td>
													<td class="newFont_bold28"><%=overViewDataObj.get("maxDuration")%></td>				
												</tr>
												<tr style="text-align: center;">
													<td colspan="2" rowspan="2" class="newFont_normal13"><%=mappinginfo.getTextDescription("reporter.common.Max")%></td>
												</tr>
											</table></td></tr>											
										</table>
									</td>
									<td width="25%">
										<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
											<tr><td colspan="1" rowspan="1">
											<table align="center" style="align:center;margin:auto auto;">
												<tr>
													<td align="right"><div class="summaryAverageDuration"></div></td>
													<td class="newFont_bold28"><%=overViewDataObj.get("avgDuration")%></td>				
												</tr>
												<tr style="text-align: center;">
													<td colspan="2" rowspan="2" class="newFont_normal13"><%=mappinginfo.getTextDescription("reporter.common.Avg")%></td>
												</tr>
											</table></td></tr>											
										</table>
									</td>																		
								</tr>								
							</table>
							<div>
						</td><tr>
						<tr><td width="50%">
							<div class="printOuterBox" style="margin-top:10px;">
							<div class="printOuterBoxHeader"><%=mappinginfo.getTextDescription("reporter.common.Alarms By Priority")%></div>
							<table width = "100%">		
								<tr>
									<td width="60%">
										<div>
											<img src="<%=overViewCharURL%>"/>
										</div>
									</td>
									<td width="35%" valign="middle">																	
										<table>
										<%
											for(int i=0;i<overViewPieLegend.size();i++)
											{
												tmp = (JSONObject)overViewPieLegend.get(i);
												String legend = (String)tmp.get("LEGEND_LABEL");
												String x = legend.substring(0, legend.indexOf(" "));
												String y = legend.substring(legend.indexOf("("), legend.length());
											%>
											<tr>
												<td>
													<div style="background-color:<%=tmp.get("LEGEND_COLOR")%>;width:6px;height:6px;border-radius:50%;"></div>
												</td>
												<td><%=x%></td>
												<td><%=y%></td>
											</tr>
											<%}
										%>
										</table>
									</td>
								</tr>
							</table>
							</div>
						</td><td width="50%" >
							<div class="printOuterBox" style="margin-top:10px;">
							<div class="printOuterBoxHeader"><%=mappinginfo.getTextDescription("reporter.common.Alarms Distribution By Duration")%></div>
							<table width = "100%">								
								<%
									if(alarmDistLegendSize>0)
									{
								%>
									<tr>
									<td width="60%">
										<div>
											<img src="<%=distCharURL%>"/>
										</div>
									</td>
									<td width="40%" valign="middle">
										<table>
										<%
											for(int i=0;i<alarmDistLegend.size();i++)
											{
												tmp = (JSONObject)alarmDistLegend.get(i);
												String legend = (String)tmp.get("LEGEND_LABEL");
												String x = legend.substring(0, legend.indexOf("("));
												String y = legend.substring(legend.indexOf("("), legend.length());
											%>
												<tr>
													<td>
														<div style="background-color:<%=tmp.get("LEGEND_COLOR")%>;width:6px;height:6px;border-radius:50%;"></div>
													</td>
													<td><%=x%></td>
													<td><%=y%></td>
												</tr>
											<%}
										%>
										</table>
									</td>
									</tr>
									<%
										}
										else
										{
									%>
										<tr align="center" >
										<td align="center" style="height:265px;"><div class="iconExclamation"></div><div class="newFont_normal11"><%=mappinginfo.getTextDescription("reporter.common.No Alarms Distribution")%><div></td>
										</tr>
										<%}%>								
							</table>
							</div>
						</td>
						</tr>
						<tr><td colspan="2">
							<div class="printOuterBox" style="margin-top:10px;margin-bottom:10px;">
							<div class="printOuterBoxHeader"><%=mappinginfo.getTextDescription("reporter.common.Alarms Trend by Start Time")%></div>
							<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">							
								<tr><td>
									<div style="margin-top:30px;margin-left:15px;">
										<img src="<%=trendChartURL%>"/>
									</div>
								</td></tr>			
							</table>
							</div>
						</td></tr>
					</tbody>
				</table>
				
				<%
			}
%>
			<%@ include file ="ErAlarmHistoryResults.jsp"%>
<%
				  LinkedList lst = new LinkedList();
					if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
						lst = helper1.getCsv((List)session.getAttribute("NO_OF_ALARMS"), session);
					if(lst!=null && lst.size()>0)
						session.setAttribute("ScheduleCSVData",lst);
					
		}
		else
		{
%>

<table width="100%" height="100%">
	<tr>
		<td align="center" valign="middle">
			<!--<img src="/images/Light/nomeasures_custom.png" />-->
			<table width="100%" height="100%" style="height:280px"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Alerts found</div></td></tr></table>
		</td>
	</tr>
</table>
<%
		}
%>
 <%
 if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		int currYearPrint = 0;
		Calendar cal = Calendar.getInstance();
		currYearPrint = cal.get(cal.YEAR);
		String strPrintFooterText = "Powered by eG Enterprise </br>"+currYearPrint+" eG Innovations inc. All Rights Reserved.";
 %>
 <div class="printFooterText"><%=strPrintFooterText%></div>

 <%}%>
<!-- Print Window -->
</body>
</html>
<%
	if (!StringUtils.isNull(er_RmDispName)){
		//For Setting the PDf File Name
		er_RmDispName = er_RmDispName.replace(" ","_");
		HashMap paramVal =new HashMap();
		paramVal.put("fileName",er_RmDispName);
		session.setAttribute("parameters", paramVal);
	}
	}
	catch(Throwable aa)
	{
		System.out.println("------------- Error in Alarm Print JSP -- "+aa);
		aa.printStackTrace();

	}
%>
