<%
/************************************************************************************************
* File				:	BTMSnapshotJson.jsp
* Purpose			:	Displays the configured measures and its details for BTM Snapshot Report
* Creation			:	Vengatesan R at 22/12/2017
*
*************************************************************************************************/
%>

<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page import ="com.eg.IniFile"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgReportInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "java.net.*" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.text.*" %>
<%@ page import="net.sf.json.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ include file = "ErReporterTracker.jsp" %>


<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
try
{	
	JSONObject combo=new JSONObject();
	JSONObject urlFields=new JSONObject();
	JSONObject labelFields=new JSONObject();
    JSONObject hiddenFields = new JSONObject();
	JSONObject selectedFields = new JSONObject();
	JSONObject selectionDetails = new JSONObject();
	JSONObject iterateJObject;
	JSONArray iterateJArray;
	JSONArray selectedComboJArray=null;
 	JSONObject rootjson=new JSONObject();
	JSONObject loopJsonObj = new JSONObject();

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	String strTestt="";
	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");
	String reqFromFavorite = request.getParameter("fromFavorite");
	String favorite_id = request.getParameter("FavoriteId");
	ErHelperUtils erhelputils = null;
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();
	String backButtonEnable = request.getParameter("back");
	rootjson.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("htdata",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	IniUI ui = IniUI.getInstance();
	EgDateInfo egDt = new EgDateInfo();
	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;
	String variable;
	StringTokenizer st;
	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	ErUtils erUtils = new ErUtils();
	ErInfo erInfo = new ErInfo();
	EgReportInfo reportInfo=new EgReportInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
	String overAllRecCount = request.getParameter("overAllRecCount");
	EgThresholdInfo hreshholdInfo = new EgThresholdInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	EgDbInfo dbInfo = new EgDbInfo("manager");
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	String loginid = this_user.getLoginID();
	ArrayList subjects = (ArrayList)reportInfo.getVariables("BTM_SNAPSHOT");
	String installDir = EgInstallInfo.getInstallDir();
	//String totalTest = reportInfo.getValue("BTM_SNAPSHOT","BTMTest");
	IniFile testIniFile = new IniFile(installDir +"/manager/config/eg_apm.ini");
	String totalTest = testIniFile.getValue("ALL_TEST_TABLES","TABLES");
	IniFile dbaseUI = new IniFile(installDir +"/manager/config/eg_dbase.ini");
	ArrayList totalTestlst = new ArrayList();
	if(totalTest!=null && totalTest.indexOf(",")>-1)
	{
		StringTokenizer valueTokens = new StringTokenizer(totalTest,",");
		while(valueTokens.hasMoreTokens())
		{
			String testS = valueTokens.nextToken();
			if(!StringUtils.isNull(dbaseUI.getValue("DYN_TABLES",testS)))
				totalTestlst.add(testS);
		}
	}
	int pageWith=1024;
	String er_option =request.getParameter("er_option");
	String er_site = request.getParameter("er_site");
	String er_compType = request.getParameter("er_compType");
	String er_component[] = request.getParameterValues("er_component");
	String durationStart = request.getParameter("durationStart");
	String durationEnd = request.getParameter("durationEnd");
	String guidField = request.getParameter("guidField");
	String viaEntryNode = request.getParameter("viaEntryNode");
	String drillDown = request.getParameter("drillSes");
	String fromRunBtn = request.getParameter("fromRunBtn");
	//list_drilldown

	if(durationStart==null)
	{
		durationStart = "";
	}
	if(durationEnd==null)
	{
		durationEnd = "";
	}
	if(guidField==null)
	{
		guidField = "";
	}	
	String showBy = request.getParameter("showBy");
	if(showBy==null)
	{
		showBy = reportInfo.getValue("BTM_SNAPSHOT","defaultTestGroup");
	}
	if(showBy==null || showBy.trim().length()==0)
	{
		showBy = "auto";
	}
	rootjson.put("durationStart",durationStart);
	rootjson.put("durationEnd",durationEnd);
	rootjson.put("guidField",guidField);
	rootjson.put("showBy",showBy);

	if(er_compType==null)
	{
		er_compType = "All";
	}
	List v_site=new ArrayList();
	ArrayList v_comptype=new ArrayList();
	Vector v_comps = UBean.getAllUserComponents(3);
	for(int i=0; i<v_comps.size(); i++) 
	{
		String loopComponent = (String) v_comps.get(i);
		String loopType = loopComponent.substring(loopComponent.lastIndexOf(":")+1);
		if(!v_comptype.contains(loopType)) 
		{
			boolean isRelevantType = false;
			for(int j=0;j<totalTestlst.size();j++)
			{
				String testS = (String)totalTestlst.get(j);
				if(testS.indexOf("_DDD")>-1)
					testS = testS.substring(0,testS.indexOf("_DDD"));
				if(specsInfo.isTestRelevantForServer(loopType,testS))
				{
					isRelevantType = true;
					break;
				}
			}
			if(isRelevantType)
				v_comptype.add(loopType);
		}
	}
	System.out.println("v_comptype_____ "+v_comptype);
	if(v_comptype==null || v_comptype.size()==0)
	{
		er_compType = "-1";
	}
	Hashtable htAllGroups=erEsxUtils.getGroups(null,v_comptype, thisuser, loginid, "Yes",true);
	ArrayList aListOption = erEsxUtils.getOptions(htAllGroups);
	/*if(aListOption!=null && aListOption.contains("Component"))
	{
		aListOption.remove("Component");
	}*/
	System.out.println("aListOptionaListOption "+aListOption);
	if(er_option == null || (er_option!=null && er_option.isEmpty()) || er_option.equalsIgnoreCase("null"))
	{
		if(aListOption!=null && aListOption.contains("Service"))
			er_option = "Service";
		else if(aListOption!=null && aListOption.size()>0)
			er_option = (String)aListOption.get(0);

	}
	if(er_option!=null && er_option.equalsIgnoreCase("Component"))
	{
		er_site = null;
	}
	List v_option = new ArrayList();
	if(aListOption!=null && aListOption.size()>0)
		v_option.addAll(aListOption);
	JSONArray arr = new JSONArray();
	JSONObject obj1=null;
	if(v_option!=null && v_option.size()>0 )
	{
		selectedFields.put("selectedAnalysisByCombo",er_option);
		for(int i=0; i<v_option.size(); i++)
		{
			String tempStr = (String)v_option.get(i);
			//if(tempStr.equalsIgnoreCase("Component"))
				//continue;
			obj1 = new JSONObject();
			obj1.put("displayField", intlmap.getTextDescription("reporter.common."+tempStr));
			obj1.put("valueField",tempStr);
			arr.add(obj1);
		}
	}
	else
	{
		obj1 = new JSONObject();
		obj1.put("displayField", intlmap.getTextDescription("reporter.common.Not Applicable"));
		obj1.put("valueField","-1");
		arr.add(obj1);
	}
	labelFields.put("analysisComboLabel",intlmap.getTextDescription("reporter.uptime.Analyze by"));
	combo.put("analysisByCombo",arr);
	ArrayList aListComponentTemp = null;
	String headerKeyName = null;
	if(er_option!=null && !er_option.equalsIgnoreCase("Component"))
	{
		v_site = erEsxUtils.getGroupsName(htAllGroups,er_option);
		if(er_site==null)
		{
			if(v_site!=null && v_site.size()>0)
			{
				er_site = (String)v_site.get(0);
			}
			else
			{
				er_site = "";
			}
		}
		if(er_site.equalsIgnoreCase("--Default--"))
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),intlmap.getTextDescription("reporter.common.--Default--"));
		}
		else
		{
			selectionDetails.put(intlmap.getTextDescription("reporter.thin."+er_option),er_site);
		}
		combo.put("siteCombo",getJSONComboFromList(v_site,"",intlmap,false,"",false));
		labelFields.put("siteComboLabel",intlmap.getTextDescription("reporter.common."+er_option));
		selectedFields.put("selectedSiteCombo",er_site);
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,er_site);
		headerKeyName=er_option+" : "+er_site;
	}
	else
	{
		aListComponentTemp = erEsxUtils.getComponentForGroup(htAllGroups,er_option,null);
		headerKeyName=er_option+" : "+er_compType;
	}
	List compList = new ArrayList();
	System.out.println("aListComponentTemp   "+aListComponentTemp);
	v_comptype = new ArrayList();
	if(aListComponentTemp!=null)
	{
		for(int n=0;n<aListComponentTemp.size();n++)
		{
			String comp = (String)aListComponentTemp.get(n);
			int index=comp.lastIndexOf(":");
			if(index>-1)
			{ 
				String  v_componentType = comp.substring(index+1,comp.length()); 
				if(!v_comptype.contains(v_componentType))
				{
					v_comptype.add(v_componentType);
				}
				if(er_compType.equalsIgnoreCase("All") || er_compType.equalsIgnoreCase(v_componentType))
				{
					compList.add(comp);
				}
			}
		}
	}
	combo.put("compTypeCombo",getJSONComboFromList(v_comptype,"",intlmap,true,intlmap.getTextDescription("reporter.thin.All"),true));
	labelFields.put("compTypeComboLabel",intlmap.getTextDescription("reporter.thin.Component Type"));
	selectedFields.put("selectedCompTypeCombo",er_compType);

	combo.put("componentCombo",getJSONComboFromList(compList,"",intlmap,true,intlmap.getTextDescription("reporter.thin.All"),false));
	labelFields.put("componentLabel",intlmap.getTextDescription("reporter.thin.Components"));
	List er_componentList = null;
	if(er_component==null || er_component.length==0)
	{
		er_componentList = new ArrayList();
		if(er_compType.equals("-1"))
		{
			er_componentList.add("-1");
		}
		else
		{
			er_componentList.add("All");
		}
	}
	else
	{
		er_componentList = Arrays.asList(er_component);
	}
	selectedFields.put("componentSelected",er_componentList);

	IniFile inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	String timeline =request.getParameter("er_timeline");
	String rtype =request.getParameter("er_type");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String schedule_id = request.getParameter("schedule_id");
	String isSubmit = request.getParameter("isSubmit");
	String er_zone = request.getParameter("er_zone");

	
	ErReqData erd = new ErReqData(request);
	EgDateInfo egDate = new EgDateInfo();
	long msecsPerHour = (long) 1000 * 60 * 60;

	fromTime = reportInfo.getTimeFrame("BTM_SNAPSHOT","FROM");
	toTime = reportInfo.getTimeFrame("BTM_SNAPSHOT","TO");

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}
	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}
	String Days = reportInfo.getExcludeWeekend("BTM_SNAPSHOT");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;
	
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;//egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String starttimeformat="";	
	String endtimeformat="";
	String dispDate = null;
	String comFormat = null;
	String  s_st_time   = request.getParameter("startdate");
	String s_en_time    = request.getParameter("enddate");
	String s_st_hr      = request.getParameter("starthr");
	String s_en_hr      = request.getParameter("endhr");
	String strmin       = request.getParameter("startmin");
	String enmin        = request.getParameter("endmin");
	String  er_timeline = request.getParameter("er_timeline");
	String start_date   = request.getParameter("startdate");
	String end_date     = request.getParameter("enddate");

	String  pdfStartDate = s_st_time+" "+s_st_hr+":"+strmin;
	String  pdfEndDate   = s_en_time+" "+s_en_hr+":"+enmin;
	String pdfTime = "From "+pdfStartDate+" hrs "+" "+" To "+pdfEndDate+" hrs";

	Vector applnPdfData = new Vector();
	applnPdfData = (Vector)request.getAttribute("applnPdfData");
	pdfTime = "BTM Snapshot "+pdfTime;

	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}
	//Date calculation according to time select
	String[] options = {"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months","3 months"};
	String startDateTime="";
	String endDateTime="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =egDt.egetRealDate();
			endDateTime = sdf.format(today);
			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
			}
			else if (unit.startsWith("mo"))
			{//months
				java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				//cal_temp.add(Calendar.DATE,-1);
				cal_temp.add(Calendar.HOUR_OF_DAY,0);
				java.util.Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				int  totalDays=24*(ErUtils.getMaxDaysInMonth());
				startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
				startDateTime = DateUtil.changeDateFormat(startDateTime,
				"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
			}
			if (unit!=null&&!unit.startsWith("mo"))
			{
				java.util.Date start = egDt.egetRealDate();
				start.setTime(today.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
			strmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_hr = String.valueOf(shr);
			s_en_hr = String.valueOf(en_hr);
		}
	}
	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			////System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
		strmin="00";
		enmin="00";
	}
	
	//if(isSubmit!=null && isSubmit.equalsIgnoreCase("true") && (drillDown==null || !drillDown.equalsIgnoreCase("yes")))
	if(drillDown==null || !drillDown.equalsIgnoreCase("yes"))
	{
		session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/BTMSnapshotPrint.jsp");
		urlFields.put("PDF_URL",mngrIProc+"/final/reporter/BTMSnapshotPrint.jsp");
	}
	else if(drillDown!=null && drillDown.equalsIgnoreCase("yes"))
	{
		session.setAttribute("DrillDownPage","yes");
		session.setAttribute("DRILLDOWN_PDF_URL", mngrIProc+"/final/reporter/BTMSnapshotPrint.jsp");
	}
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null ||	excludeweekend.equals(""))
		excludeweekend="No";

	hiddenFields.put("option","BTMReport");
	hiddenFields.put("inidate",currentDateFormat);
	hiddenFields.put("currTime","");
	hiddenFields.put("er_rtype","BTMSnapshot");
	hiddenFields.put("er_trgttype","BTM Snapshot Report");
	hiddenFields.put("er_gtype","BTMSnapshot");
	hiddenFields.put("pdfTime",pdfTime);
	hiddenFields.put("uid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("userID",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("eruserid",EgURLEncoder.encode(loginid,"UTF-8"));
	hiddenFields.put("er_trenddata","No");
	hiddenFields.put("servers",request.getParameter("servers"));
	hiddenFields.put("er_check",request.getParameter("er_check"));
	hiddenFields.put("schedule_id",schedule_id);
	hiddenFields.put("er_ViewName","BTMSnapshot.jsp");
	hiddenFields.put("getMaxDaysInMonth",ErUtils.getMaxDaysInMonth());
	hiddenFields.put("forwardto","BTMSnapshotJson");
	hiddenFields.put("er_bgreportfrom","BTM_SNAPSHOT");
	hiddenFields.put("bgenabled",strbgrepportName);
	hiddenFields.put("limitforbg",limitforbg);
	hiddenFields.put("savereport","save");
	hiddenFields.put("servletName","com.eg.ErBTMSnapshotC");

	iterateJArray=new JSONArray();
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
	iterateJObject.put("valueField","Yes");
	iterateJArray.add(iterateJObject);
	iterateJObject=new JSONObject();
	iterateJObject.put("displayField",intlmap.getTextDescription("reporter.common.No"));
	iterateJObject.put("valueField","No");
	iterateJArray.add(iterateJObject);
	combo.put("excludeWeekendsCombo",iterateJArray);
	labelFields.put("excludeWeekendsLabel",intlmap.getTextDescription("reporter.thin.Exclude weekends"));
	labelFields.put("excludeDaysLabel",intlmap.getTextDescription("reporter.thin.Excludes")+" "+Days);
	if(excludeweekend.equalsIgnoreCase("Yes") )
	{
		selectedFields.put("excludeWeekendsSelected","Yes");
		//selectionDetails.put(intlmap.getTextDescription("reporter.thin.Exclude weekends"),"Yes");
	}
	else
	{
		selectedFields.put("excludeWeekendsSelected","No");
		//selectionDetails.put(intlmap.getTextDescription("reporter.thin.Exclude weekends"),"No");
	}
 
	selectedFields.put("selectedTimeFrom",Hourfrom);
	selectedFields.put("selectedMinsFrom",Minfrom);
	selectedFields.put("selectedTimeTo",Hourto);
	selectedFields.put("selectedMinsTo",Minto);
%>
	<%@  include file ="ErTimeFormatJSON.jsp"%>
<%
		
	String sdate = request.getParameter("startdate");	
	String edate = request.getParameter("enddate");	
	String shr = request.getParameter("starthr");	
	String ehr = request.getParameter("endhr");	
	String smin = request.getParameter("startmin");	
	String emin = request.getParameter("endmin");
	
	starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
	
	endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
	//Time zone conversion 
	
	pdfStartDate=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
		


	Vector dvec = new Vector();
	String stimefmt = "Start Date : "+pdfStartDate;
	String etimefmt = "End Date : "+pdfEndDate;

	String ssd=stimefmt+"  "+etimefmt;

	hiddenFields.put("userTimeline",strUsrTimeline);
	combo.put("timelineCombo",timelineComboArray);
	labelFields.put("timelineComboLabel",intlmap.getTextDescription("reporter.common.Timeline"));
	selectedFields.put("selectedTimeline",er_timeline);
	selectedFields.put("startDate",startDateJSON);
	selectedFields.put("endDate",endDateJSON);
	selectedFields.put("startHour",startHourJSON);
	selectedFields.put("endHour",endHourJSON);
	selectedFields.put("startmin",startMin);
	selectedFields.put("endmin",endMin);
	selectedFields.put("selectedGraphMode",selectedGraphMode);

	//User TimeZone changes
	selectedFields.put("startDateForDisplay",startDateForDisplay);
	selectedFields.put("startHourForDisplay",startHourForDisplay);
	selectedFields.put("startMinForDisplay",startMinForDisplay);
	selectedFields.put("endDateForDisplay",endDateForDisplay);
	selectedFields.put("endHourForDisplay",endHourForDisplay);
	selectedFields.put("endMinForDisplay",endMinForDisplay);
	
	selectionDetails.put(intlmap.getTextDescription("reporter.common.Time Period"),Hourfrom+":"+Minfrom+"<span class='font_bold'>  "+intlmap.getTextDescription("reporter.common.to")+" </span> "+Hourto+":"+Minto);
		
	selectionDetails.put((String)intlmap.getTextDescription("reporter.common.Timeline"),pdfStartDate+" "+intlmap.getTextDescription("reporter.common.hrs")+" <span class='font_bold'>"+intlmap.getTextDescription("reporter.common.to")+"</span> "+pdfEndDate+" "+intlmap.getTextDescription("reporter.common.hrs"));
 	
	String er_reportgenration = request.getParameter("er_reportgenration");
	String er_background ="";
	String er_foreground ="";
	if (er_reportgenration != null && er_reportgenration.equals("background"))
	{
		selectedFields.put("reportGenerationSelected","background");
		er_background = "selected";
		er_foreground = "";
	}
		else if(er_reportgenration != null && er_reportgenration.equals("background-csv"))
	{
		selectedFields.put("reportGenerationSelected","background-csv");
		er_background = "selected";
		er_foreground = "";
	}
	else
	{
		selectedFields.put("reportGenerationSelected","foreground");
		er_background = "";
		er_foreground = "selected";
	}
	String bg_reportname = request.getParameter("bg_reportname");
	if(bg_reportname == null)
	{
		bg_reportname = "";
	}
	String reportgenColspan = "5";
	if(rtype != null && rtype.equalsIgnoreCase("No"))
	{
		if(er_reportgenration != null && er_reportgenration.equals("background"))
			reportgenColspan = "2";
		else
			reportgenColspan = "3";
	}
	if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
	{
		labelFields.put("reportGenerationLabel",intlmap.getTextDescription("reporter.consolidated.Report Generation"));
		labelFields.put("reportNameLabel",intlmap.getTextDescription("reporter.consolidated.Report Name"));
		iterateJArray=new JSONArray();
		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strbackground);
		iterateJObject.put("valueField","background");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField","Background Save - CSV");
		iterateJObject.put("valueField","background-csv");
		iterateJArray.add(iterateJObject);

		iterateJObject=new JSONObject();
		iterateJObject.put("displayField",strforeground);
		iterateJObject.put("valueField","foreground");
		iterateJArray.add(iterateJObject);
		combo.put("reportGenerationCombo",iterateJArray);

		//||er_reportgenration.equalsIgnoreCase("background-csv")||er_reportgenration.equals("background-xls"))
		if (er_reportgenration != null && (er_reportgenration.equals("background")||er_reportgenration.equalsIgnoreCase("background-csv")||er_reportgenration.equals("background-xls")))
		{
			selectedFields.put("reportNameSelected",bg_reportname);
		}
		
	}
	if((reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes")) || (reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes")))
	{
		labelFields.put("saveButton",intlmap.getTextDescription("reporter.common.SAVE"));
		String fromReq = "schedule";
		if(reqFromFavorite!=null && reqFromFavorite.equalsIgnoreCase("Yes"))
			fromReq = "favorite";
	}
	else
	{
		labelFields.put("submitButton",intlmap.getTextDescription("reporter.common.SUBMIT"));
	}
	if(bggroundStr != null && !bggroundStr.equals(""))
	{
		String strreportName = null;
 		if((status != null && (status.equalsIgnoreCase("duplicate")) || (status != null && (status.equalsIgnoreCase("success"))) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
		{
			strreportName ="All Report Types";
			//labelFields.put("bgStatus","success");
			if(status !=null && status.equalsIgnoreCase("success"))
				labelFields.put("bgStatus","success");
			else if(status !=null && status.equalsIgnoreCase("duplicate"))
				labelFields.put("bgStatus","duplicate");
		}
		if(strreportName!=null && strreportName.indexOf(" ") > -1)
		{
			strreportName = com.eg.EgURLEncoder.encode(strreportName, "UTF-8");
		}

		labelFields.put("bgResponseText",erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
		urlFields.put("bgUrl","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+strreportName+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
		labelFields.put("bgAnchor",intlmap.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
		
	}
	String checkedFilterData = request.getParameter("checkedFilterData");
	HashMap checkedFilterMp = null;
	int totalCheckedCount = 0;
	if(checkedFilterData!=null && checkedFilterData.length()>0)
	{
		checkedFilterData = erUtils.specialCharDecode(checkedFilterData);
		String[] checkedFilterDataAry = checkedFilterData.split("\\|");
		if(checkedFilterDataAry!=null && checkedFilterDataAry.length>0)
		{
			checkedFilterMp = new HashMap();
			for(int i=0;i<checkedFilterDataAry.length;i++)
			{
				String filterStrByMeasure = checkedFilterDataAry[i];
				if(filterStrByMeasure!=null && filterStrByMeasure.length()>0 && filterStrByMeasure.indexOf("#")>-1)
				{
					String columnName = filterStrByMeasure.substring(0,filterStrByMeasure.indexOf("#"));
					String columnVals = filterStrByMeasure.substring(filterStrByMeasure.indexOf("#")+1,filterStrByMeasure.length());
					if(columnVals.length()>0)
					{
						String columnValAry[] = columnVals.split(",");
						List columnValLst = Arrays.asList(columnValAry);
						checkedFilterMp.put(columnName,columnValLst);
						totalCheckedCount = totalCheckedCount+columnValLst.size();
					}
				}
			}
		}
	}
	String forUniqueData = request.getParameter("forUniqueData");
	String requestFor = request.getParameter("requestFor");
	String measures = reportInfo.getValue("BTM_SNAPSHOT","BTMTest_DispMeasure");
	String filterMeasure = reportInfo.getValue("BTM_SNAPSHOT","BTMTest_FilterMeasure");
	String needRequestProcessing = reportInfo.getValue("BTM_SNAPSHOT","needRequestProcessing");
	ArrayList filterDataAry = new ArrayList();
	ArrayList filterByMeasure = new ArrayList();
	HashMap filterMeasureInfo = new HashMap();
	System.out.println("forUniqueData______ "+forUniqueData);
	if(requestFor!=null && requestFor.equalsIgnoreCase("reportSummary"))
	{
		HashMap summaryMap = (HashMap)session.getAttribute("BTM_SNAPSHOT_SUMMARYMAP");
		if(summaryMap==null || summaryMap.size()==0)
		{
			rootjson.put("NO_DATA","Yes");
		}
		else
		{
			HashMap summaryMapUI = new HashMap(summaryMap);
			String totalCountStr = (String)summaryMapUI.get("TOTALCOUNT");
			String responseTimeStr = (String)summaryMapUI.get("RESPONSETIME");
			String urlCountStr = (String)summaryMapUI.get("URLCOUNT");
			String healthyStr = (String)summaryMapUI.get("HEALTHY");
			String slowStr = (String)summaryMapUI.get("SLOW");
			String stalledStr = (String)summaryMapUI.get("STALLED");
			String errorStr = (String)summaryMapUI.get("ERROR");
			
			if(totalCountStr==null || totalCountStr.equalsIgnoreCase("null"))
			{
				totalCountStr = "0";
			}
			if(responseTimeStr==null || responseTimeStr.equalsIgnoreCase("null"))
			{
				responseTimeStr = "0";
			}
			if(urlCountStr==null || urlCountStr.equalsIgnoreCase("null"))
			{
				urlCountStr = "0";
			}
			if(healthyStr==null || healthyStr.equalsIgnoreCase("null"))
			{
				healthyStr = "0";
			}
			if(slowStr==null || slowStr.equalsIgnoreCase("null"))
			{
				slowStr = "0";
			}
			if(stalledStr==null || stalledStr.equalsIgnoreCase("null"))
			{
				stalledStr = "0";
			}
			if(errorStr==null || errorStr.equalsIgnoreCase("null"))
			{
				errorStr = "0";
			}
			
			double totalCount = Double.parseDouble(totalCountStr);
			double responseTime = Double.parseDouble(responseTimeStr);
			double urlCount = Double.parseDouble(urlCountStr);
			double healthy = Double.parseDouble(healthyStr);
			double slow = Double.parseDouble(slowStr);
			double stalled = Double.parseDouble(stalledStr);
			double error = Double.parseDouble(errorStr);

			healthyStr = erUtils.roundOffDigit((healthy/totalCount)*100,1);
			slowStr = erUtils.roundOffDigit((slow/totalCount)*100,1);
			stalledStr = erUtils.roundOffDigit((stalled/totalCount)*100,1);
			errorStr =  erUtils.roundOffDigit((error/totalCount)*100,1);

			summaryMapUI.put("HEALTHY",healthyStr+"#"+healthy);
			summaryMapUI.put("SLOW",slowStr+"#"+slow);
			summaryMapUI.put("STALLED",stalledStr+"#"+stalled);
			summaryMapUI.put("ERROR",errorStr+"#"+error);
			summaryMapUI.put("RESPONSETIME",erUtils.roundOffDigit(responseTime,2));
			
			rootjson.put("Summary",summaryMapUI);
			Map otherInfo = (HashMap)session.getAttribute("BTM_SNAPSHOT_OTHER");
			if(otherInfo == null)
			{
				otherInfo = (HashMap)request.getAttribute("BTM_SNAPSHOT_OTHER");
			}
			if(otherInfo!=null && otherInfo.size()>0)
			{
				JSONObject otherInfoJson = new JSONObject();
				otherInfoJson.put("isRangeNeed", (String)otherInfo.get("isRangeNeed"));
				otherInfoJson.put("overAllRecCount", (String)otherInfo.get("overAllRecCount"));
				otherInfoJson.put("dataPageNo", (String)otherInfo.get("dataPageNo"));
				otherInfoJson.put("recordPerPage", (String)otherInfo.get("recordPerPage"));
				rootjson.put("OTHER_INFO",otherInfoJson);
			}
			rootjson.put("selectionDetails",selectionDetails);
		}
	}
	else if(requestFor!=null && requestFor.equalsIgnoreCase("sqlSummary"))
	{
		HashMap sqlSummaryMap = (HashMap)session.getAttribute("BTM_SNAPSHOT_SQL_SUMMARYMAP");
		if(sqlSummaryMap==null || sqlSummaryMap.size()==0)
		{
			rootjson.put("NO_DATA","Yes");
		}
		else
		{
			HashMap summaryMapUI = new HashMap(sqlSummaryMap);
			String totalSqlCountStr = (String)summaryMapUI.get("TOTALSQLCOUNT");
			String avgSqlTimeStr = (String)summaryMapUI.get("AVGSQLTIME");
			
			if(totalSqlCountStr==null || totalSqlCountStr.equalsIgnoreCase("null"))
			{
				totalSqlCountStr = "0";
			}
			else if(totalSqlCountStr.indexOf(".")>-1)
			{
				totalSqlCountStr = totalSqlCountStr.substring(0,totalSqlCountStr.indexOf("."));
			}
			if(avgSqlTimeStr==null || avgSqlTimeStr.equalsIgnoreCase("null"))
			{
				avgSqlTimeStr = "0";
			}
			double avgSqlTime = Double.parseDouble(avgSqlTimeStr);

			summaryMapUI.put("TOTALSQLCOUNT",totalSqlCountStr);
			summaryMapUI.put("AVGSQLTIME",erUtils.roundOffDigit(avgSqlTime,1));
			summaryMapUI.put("AVGSQLTIME_UNIT",intlmap.getTextDescription("reporter.common.ms"));
			/*if(avgSqlTime>100000)
			{
				summaryMapUI.put("AVGSQLTIME_UNIT","");
				summaryMapUI.put("AVGSQLTIME","<span style='font-size:12px;'>"+erUtils.getDateDifferenceString((new Double(avgSqlTime)).longValue())+"</span>");
			}*/
			rootjson.put("Summary",summaryMapUI);
			rootjson.put("selectionDetails",selectionDetails);
		}
	}
	else if(requestFor!=null && (requestFor.equalsIgnoreCase("tableInfo")||requestFor.equalsIgnoreCase("getFilterInfo")))
	{
		ArrayList resultList = (ArrayList)session.getAttribute("BTM_SNAPSHOT_RESULT_LIST");
		boolean isCustomPaging = true;
		if(resultList!=null && resultList.size()>0)
		{
			Map otherInfo = (HashMap)session.getAttribute("BTM_SNAPSHOT_OTHER_GRID");
			if(otherInfo == null)
			{
				otherInfo = (HashMap)request.getAttribute("BTM_SNAPSHOT_OTHER_GRID");
			}
			if(otherInfo!=null && otherInfo.size()>0)
			{
				JSONObject otherInfoJson = new JSONObject();
				otherInfoJson.put("isRangeNeed", (String)otherInfo.get("isRangeNeed"));
				otherInfoJson.put("overAllRecCount", (String)otherInfo.get("overAllRecCount"));
				otherInfoJson.put("dataPageNo", (String)otherInfo.get("dataPageNo"));
				otherInfoJson.put("recordPerPage", (String)otherInfo.get("recordPerPage"));
				rootjson.put("OTHER_INFO",otherInfoJson);
				if(!(((String)otherInfo.get("isRangeNeed")).equalsIgnoreCase("true")) && ((String)otherInfo.get("dataPageNo")).equalsIgnoreCase("1"))
				{
					isCustomPaging = false;
				}
			}
			Vector v_measure_csv = new Vector();
			String[] measuresValLst = measures.split(",");
			String[] measuresLst = new String[measuresValLst.length];
			String[] measuresDispLst = new String[measuresValLst.length];
			for(int i=0;i<measuresValLst.length;i++)
			{
				String colName = measuresValLst[i];
				String dispCol = colName;
				if(colName!=null && colName.indexOf("#")>-1)
				{
					dispCol = dispCol.substring(dispCol.indexOf("#")+1,dispCol.length());
					colName = colName.substring(0,colName.indexOf("#"));
				}
				else
				{
					dispCol = intlmap.getMeasureDescription((String)totalTestlst.get(0), colName);
				}
				measuresLst[i] = colName;
				measuresDispLst[i] = dispCol;
			}
			if(filterMeasure!=null && filterMeasure.length()>0)
			{
				String filterMeasureAry[] = filterMeasure.split(",");
				if(filterMeasureAry.length>0)
				{
					for(int i=0;i<filterMeasureAry.length;i++)
					{
						String filterMeasureVal = filterMeasureAry[i];
						System.out.println("filterMeasureVal________ "+filterMeasureVal);
						HashMap measureWiseMap = new HashMap();
						String tempMes = filterMeasureVal.substring(0,filterMeasureVal.indexOf("#"));
						String tempDispMes = filterMeasureVal.substring(filterMeasureVal.indexOf("#")+1,filterMeasureVal.length());
						HashMap measureInfoMap = new HashMap();
						measureInfoMap.put("groupHead",intlmap.getTextDescription("reporter.common."+tempDispMes));
						measureInfoMap.put("id",tempMes);
						measureWiseMap.put(tempMes,measureInfoMap);
						filterDataAry.add(measureWiseMap);
						filterByMeasure.add(tempMes);
					}
				}
			}
			if(needRequestProcessing!=null && needRequestProcessing.equalsIgnoreCase("yes"))
			{
				// fill state info i.e., healthy,slow,stalled,error
				HashMap measureInfoMapTemp = new HashMap();
				HashMap measureWiseMapTemp = new HashMap();
				measureInfoMapTemp.put("groupHead",intlmap.getTextDescription("reporter.common.Request processing"));
				measureInfoMapTemp.put("id","Request_Processing");
				measureWiseMapTemp.put("Request_Processing",measureInfoMapTemp);
				if(filterDataAry.size()>0)
				{
					filterDataAry.add(1,measureWiseMapTemp);
				}
				else
				{
					filterDataAry.add(measureWiseMapTemp);
				}
			}
			TreeSet filterValue = new TreeSet();
			filterValue.add("Healthy");
			filterValue.add("Slow");
			filterValue.add("Stalled");
			filterValue.add("Error");
			filterMeasureInfo.put("Request_Processing",filterValue);
			
			JSONObject gridObj = new JSONObject();
			JSONArray gridCol = new JSONArray();
			JSONArray gridColUI = new JSONArray();
			gridCol.add("Request processing");
			gridColUI.add(intlmap.getTextDescription("reporter.common.Request processing"));
			v_measure_csv.add(intlmap.getTextDescription("reporter.common.Request processing"));
			for(int i=0;i<measuresLst.length;i++)
			{
				String colName = measuresLst[i];
				String dispCol = measuresDispLst[i];
				gridCol.add(dispCol);
				gridColUI.add(intlmap.getTextDescription("reporter.common."+dispCol));
				v_measure_csv.add(intlmap.getTextDescription("reporter.common."+dispCol));
			}
			JSONArray dataAry = new JSONArray();
			for(int i=0; i<resultList.size();i++)
			{
				Map dataMap = (HashMap)resultList.get(i);
				JSONArray data = new JSONArray();
				String state = (String)dataMap.get("BTM_EXPERIENCE");
				if(state!=null)
					state = state.toLowerCase();
				// urlQStr  ="/final/monitor/eGBTMd3Topology.jsp?EG_GUID=c22193db-e614-41cd-b66c-7c877d4ca045-1514526680068&testName=BusinessTransTest&fromNodeOrder=1&overallExperience=healthy";
				String ddUrl = "/final/monitor/eGBTMd3Topology.jsp?isReporterRequest=yes&";
				ddUrl+="EG_GUID="+dataMap.get("EG_GUID")+"&testName="+dataMap.get("TEST_NAME")+"&fromNodeOrder=1&overallExperience="+state;
				ddUrl+="#@#"+state;
				data.add(ddUrl);
				for(int j=0;j<measuresLst.length;j++)
				{
					String measure = measuresLst[j];
					String appendMesure = "";
					if(measure.equalsIgnoreCase("REQUEST_TIME"))
					{
						appendMesure = " - "+dataMap.get("TIME_ZONE");
					}
					if(measure.equalsIgnoreCase("TRGT_HOST"))
					{
						appendMesure = ":"+dataMap.get("PORT_NO");
					}
					String gridDataVal = (String)dataMap.get(measure);
					if(gridDataVal!=null)
					{
						data.add(gridDataVal+appendMesure);
						//if(filterByMeasure!=null && filterByMeasure.contains(measure) && !gridDataVal.equals("-"))
						if(filterByMeasure!=null && filterByMeasure.contains(measure))
						{
							if(measure.equalsIgnoreCase("EXCEPTION_NAME") && gridDataVal.equals("-"))
							{
								continue;
							}
							filterValue = (TreeSet)filterMeasureInfo.get(measure);
							if(filterValue!=null)
							{
								filterValue.add(gridDataVal);
							}
							else
							{
								filterValue = new TreeSet();
								filterValue.add(gridDataVal);
								filterMeasureInfo.put(measure,filterValue);
							}
						}
					}
					else
					{
						data.add("-");
					}
				}
				dataAry.add(data);
			}
			if(fromRunBtn!=null && fromRunBtn.equalsIgnoreCase("yes"))
			{
				if(requestFor.equalsIgnoreCase("getFilterInfo") && isCustomPaging && filterByMeasure!=null && filterByMeasure.size()>0)
				{
					// process Server side 
					for(int i=0;i<filterByMeasure.size();i++)
					{
						String filterMes = (String)filterByMeasure.get(i);
						filterValue = (TreeSet)filterMeasureInfo.get(filterMes);
						if(filterValue==null || filterValue.size()<6)
						{
							ErBTMSnapshotReportBean appBean = new ErBTMSnapshotReportBean();
							appBean.initRequest(request);
							Vector distinctData = null;
							distinctData = appBean.getDistinctDataForBtm(filterMes,"7",viaEntryNode);
							if(distinctData!=null && distinctData.size()>0)
							{
								if(filterValue==null || filterValue.size()==0)
								{
									filterValue = new TreeSet();
									filterValue.addAll(distinctData);
								}
								else
								{
									for(int j=0;j<distinctData.size();j++)
									{
										String dbData = (String)distinctData.get(j);
										if(filterValue.size()<6)
										{
											filterValue.add(dbData);
										}
									}
								}
								filterMeasureInfo.put(filterMes,filterValue);
							}
						}
					}
				}
				session.setAttribute("filterMeasureInfo",filterMeasureInfo);
			}
			HashMap filterMeasureInfoTemp = (HashMap)session.getAttribute("filterMeasureInfo");
			if(filterMeasureInfoTemp!=null)
			{
				filterMeasureInfo = filterMeasureInfoTemp;
			}
			else
			{
				session.setAttribute("filterMeasureInfo",filterMeasureInfo);
			}
			JSONArray filterDetails = new JSONArray();
			JSONArray filterDetailsGrid = new JSONArray();
			session.setAttribute("filterDataAry",filterDataAry);
			System.out.println("filterMeasureInfo________ "+filterMeasureInfo);
			if(filterDataAry!=null)
			{
				for(int i=0;i<filterDataAry.size();i++)
				{
					HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
					Iterator itrInfo = measureWiseMap.entrySet().iterator();
					while(itrInfo.hasNext())
					{
						Map.Entry map=(Map.Entry)itrInfo.next();
						String keyVal = (String)map.getKey();
						HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
						String maxView = "yes";
						String clearView = "yes";
						if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
						{
							maxView = "no";
						}
						List columnValLst = new ArrayList();
						if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
						{
							columnValLst = (List)checkedFilterMp.get(keyVal);
						}
						if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
						{
							filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
							if(filterValue.size()==1)
							{
								clearView = "no";
								// If uncomment, single value in filter is not visible.
								//continue;
							}
							if(filterValue.size()<=5)
							{
								maxView = "no";
							}
							Iterator itr = filterValue.iterator(); 
							int count = 0;
							ArrayList childAry = new ArrayList();
							while (itr.hasNext()) 
							{
								if(count==5) // shows only 5 value in UI
								{
									break;
								}
								String filterStr = (String)itr.next();
								JSONObject childObj = new JSONObject();
								if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
								{
									childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
								}
								else
								{
									childObj.put("name",filterStr);
								}
								childObj.put("value",filterStr);
								childObj.put("index",count);
								if(columnValLst.contains(filterStr))
								{
									childObj.put("isChecked",true);
								}
								else
								{
									childObj.put("isChecked",false);
								}
								childAry.add(childObj);
								count++;
							}
							if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing")) // swaping request processing child data
							{
								JSONObject childObj = (JSONObject)childAry.get(0);
								childAry.remove(0);
								childAry.add(childObj);
							}
							measureInfoMap.put("maxView",maxView);
							measureInfoMap.put("checkedList",columnValLst);
							measureInfoMap.put("clear",clearView);
							measureInfoMap.put("child",childAry);
							filterDetails.add(measureInfoMap);
							filterDetailsGrid.add(measureInfoMap);
						}
					}
				}
			}
			if(filterDetails.size()>0)
			{
				rootjson.put("filterDetails",filterDetails);
				rootjson.put("filterDetailsGrid",filterDetailsGrid);
			}
			rootjson.put("totalCheckedCount",totalCheckedCount);
			gridObj.put("gridCol",gridCol);
			gridObj.put("gridColUI",gridColUI);
			gridObj.put("gridData",dataAry);
			rootjson.put("gridObj",gridObj);
			rootjson.put("selectionDetails",selectionDetails);
		}
		else
		{
			rootjson.put("NO_DATA","Yes");
			JSONArray filterDetails = new JSONArray();
			filterDataAry = (ArrayList)session.getAttribute("filterDataAry");
			filterMeasureInfo = (HashMap)session.getAttribute("filterMeasureInfo");
			if(filterDataAry!=null)
			{
				for(int i=0;i<filterDataAry.size();i++)
				{
					HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
					Iterator itrInfo = measureWiseMap.entrySet().iterator();
					while(itrInfo.hasNext())
					{
						Map.Entry map=(Map.Entry)itrInfo.next();
						String keyVal = (String)map.getKey();
						HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
						String maxView = "yes";
						String clearView = "yes";
						if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
						{
							maxView = "no";
						}
						List columnValLst = new ArrayList();
						if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
						{
							columnValLst = (List)checkedFilterMp.get(keyVal);
						}
						if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
						{
							TreeSet filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
							Iterator itr = filterValue.iterator(); 
							int count = 0;
							ArrayList childAry = new ArrayList();
							while (itr.hasNext()) 
							{
								if(count==5) // shows only 5 value in UI
								{
									break;
								}
								String filterStr = (String)itr.next();
								JSONObject childObj = new JSONObject();
								if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
								{
									childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
								}
								else
								{
									childObj.put("name",filterStr);
								}
								childObj.put("value",filterStr);
								if(columnValLst.contains(filterStr))
								{
									childObj.put("isChecked",true);
								}
								else
								{
									childObj.put("isChecked",false);
								}
								childAry.add(childObj);
								count++;
							}
							measureInfoMap.put("maxView",maxView);
							measureInfoMap.put("checkedList",columnValLst);
							measureInfoMap.put("clear",clearView);
							measureInfoMap.put("child",childAry);
							filterDetails.add(measureInfoMap);
						}
					}
				}
			}
			if(filterDetails.size()>0)
			{
				rootjson.put("filterDetails",filterDetails);
			}
			rootjson.put("totalCheckedCount",totalCheckedCount);
		}
	}
	else if (forUniqueData!=null && forUniqueData.equalsIgnoreCase("yes"))
	{
		Vector uniqueData = (Vector)session.getAttribute("BTM_UNIQUE_DATA");
		if(uniqueData!=null && uniqueData.size()>0)
		{
			filterMeasure+=",Request_Processing#Request Processing";
			String filterMeasureAry[] = filterMeasure.split(",");
			String columnName = request.getParameter("columnName");
			if(filterMeasureAry.length>0)
			{
				for(int i=0;i<filterMeasureAry.length;i++)
				{
					String filterMeasureVal = filterMeasureAry[i];
					String tempMes = filterMeasureVal.substring(0,filterMeasureVal.indexOf("#"));
					String tempDispMes = filterMeasureVal.substring(filterMeasureVal.indexOf("#")+1,filterMeasureVal.length());
					if(columnName==null || !columnName.equalsIgnoreCase(tempMes))
					{
						continue;
					}
					HashMap measureWiseMap = new HashMap();
					HashMap measureInfoMap = new HashMap();
					measureInfoMap.put("groupHead",intlmap.getTextDescription("reporter.common."+tempDispMes));
					measureInfoMap.put("id",tempMes);
					measureWiseMap.put(tempMes,measureInfoMap);
					filterDataAry.add(measureWiseMap);
					filterByMeasure.add(tempMes);
				}
			}
			if(filterByMeasure!=null && filterByMeasure.contains(columnName))
			{
				Iterator uni_itr = uniqueData.iterator();
				while(uni_itr.hasNext())
				{
					String vectVal = (String)uni_itr.next();
					TreeSet filterValue = (TreeSet)filterMeasureInfo.get(columnName);
					//if(vectVal!=null && vectVal.length()>0 && !vectVal.equals("-"))
					if(vectVal!=null && vectVal.length()>0)
					{
						if(filterValue!=null)
						{
							filterValue.add(vectVal);
						}
						else
						{
							filterValue = new TreeSet();
							filterValue.add(vectVal);
							filterMeasureInfo.put(columnName,filterValue);
						}
					}
				}
			}
			JSONArray filterDetails = new JSONArray();
			if(filterDataAry!=null)
			{
				for(int i=0;i<filterDataAry.size();i++)
				{
					HashMap measureWiseMap = (HashMap)filterDataAry.get(i);
					Iterator itrInfo = measureWiseMap.entrySet().iterator();
					while(itrInfo.hasNext())
					{
						Map.Entry map=(Map.Entry)itrInfo.next();
						String keyVal = (String)map.getKey();
						HashMap measureInfoMap = (HashMap)measureWiseMap.get(keyVal);
						String maxView = "yes";
						String clearView = "yes";
						if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
						{
							maxView = "no";
						}
						List columnValLst = new ArrayList();
						if(checkedFilterMp!=null && checkedFilterMp.get(keyVal)!=null)
						{
							columnValLst = (List)checkedFilterMp.get(keyVal);
						}
						if(filterMeasureInfo!=null && filterMeasureInfo.get(keyVal)!=null)
						{
							TreeSet filterValue = (TreeSet)filterMeasureInfo.get(keyVal);
							Iterator itr = filterValue.iterator(); 
							int count = 0;
							ArrayList childAry = new ArrayList();
							while (itr.hasNext()) 
							{
								/*if(count==5) // shows only 5 value in UI
								{
									break;
								}*/
								String filterStr = (String)itr.next();
								JSONObject childObj = new JSONObject();
								if(keyVal!=null && keyVal.equalsIgnoreCase("Request_Processing"))
								{
									childObj.put("name",intlmap.getTextDescription("reporter.common."+filterStr));
								}
								else
								{
									childObj.put("name",filterStr);
								}
								childObj.put("value",filterStr);
								if(columnValLst.contains(filterStr))
								{
									childObj.put("isChecked",true);
								}
								else
								{
									childObj.put("isChecked",false);
								}
								childAry.add(childObj);
								count++;
							}
							measureInfoMap.put("maxView",maxView);
							measureInfoMap.put("checkedList",columnValLst);
							measureInfoMap.put("clear",clearView);
							measureInfoMap.put("child",childAry);
							filterDetails.add(measureInfoMap);
						}
					}
				}
			}
			if(filterDetails.size()>0)
			{
				rootjson.put("filterDetails",filterDetails);
				rootjson.put("filterDetailsDummy",filterDetails);
			}
		}
	}

	Map parameters = new HashMap();
	parameters= request.getParameterMap();
	String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
	String Qstring="";
	String lastAccessQstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			 if(reqparam!=null&&reqparam.equals("userID"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			 if(reqparam!=null&&reqparam.equals("uid"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			 if(reqparam!=null && ( reqparam.equals("startdate") || reqparam.equals("enddate") || reqparam.equals("inidate") || reqparam.equals("pdfTime") || reqparam.equals("select_testmes") || reqparam.equals("er_workgrpname") || reqparam.equals("er_trgttype") || reqparam.equals("limitforbg") || reqparam.equals("er_timeline") || reqparam.equals("er_usertimeline")  || reqparam.equals("limitforbg") || reqparam.equals("limitforbg")) )
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam.equals("checkedFilterData"))
			{
				value = erUtils.specialCharEncode(checkedFilterData);
			}
			
				lastAccessQstring=lastAccessQstring+reqparam+"="+value+"&";
					
			if(reqparam!=null&&reqparam.equals("er_component"))
			{
				continue;
			}

			Qstring=Qstring+reqparam+"="+value+"&";
		}
		Qstring=Qstring;
	}
	Qstring+="pageWidthProces="+pageWith;
	String dataProcess = mngrIProc+"/final/reporter/BTMSnapshotPrint.jsp;jsessionid="+ session.getId()+"?"+Qstring;

	if(isSubmit!=null && isSubmit.equalsIgnoreCase("true") && (drillDown==null || !drillDown.equalsIgnoreCase("yes")))
	{
		session.setAttribute("MAIL_URL",dataProcess);
	}
	else if(drillDown!=null && drillDown.equalsIgnoreCase("yes"))
	{
		session.setAttribute("DRILLDOWN_MAIL_URL",dataProcess);
	}
	HashMap hmQry = ErUtils.parseQueryString(Qstring);
	String targetType = "";
	if(hmQry != null && hmQry.get("er_trgttype") instanceof String)
	{
		targetType = (String)hmQry.get("er_trgttype");
	}
	else if(hmQry != null && hmQry.get("er_trgttype") instanceof String[])
	{
		targetType = ((String[])hmQry.get("er_trgttype"))[0];
	}
	String qString = ErUtils.prepareQueryString(hmQry);
	urlFields.put("saveQueryString",qString);
	//
	ArrayList listbackvar = new  ArrayList();
	if(drillDown==null || !drillDown.equalsIgnoreCase("yes"))
	{		
		if(fromRunBtn!=null && fromRunBtn.equalsIgnoreCase("yes"))
		{
			if(overAllRecCount==null)
			{
				listbackvar.add("/servlet/com.eg.ErBTMSnapshotC?");
				listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
				session.setAttribute("favSchBackDisplay","Yes");
			}
		}
		else
		{
			listbackvar.add("BTMSnapshot.jsp");
			listbackvar.add(queryString);
			session.setAttribute("favSchBackDisplay","No");
		}
		session.setAttribute("reportLastAccessedURL","/final/reporter/BTMSnapshot.jsp?"+lastAccessQstring);
	}
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);
	rootjson.put("selectedFields",selectedFields);
	rootjson.put("hiddenFields",hiddenFields);
	rootjson.put("combo",combo);
	rootjson.put("labelFields",labelFields);
	rootjson.put("urlFields",urlFields);
	out.println(rootjson.toString());
}
catch(Exception t)
{
	t.printStackTrace();
}

	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","BTM_SNAPSHOT_Report");
	session.setAttribute("parameters", paramVal);
%>
 <%!
   public synchronized JSONArray getJSONComboFromList(List list,String infoVal,EgMappingInfo intlmap, boolean allSupport, String ui_text,boolean isCompType)
   {
		JSONArray arr=new JSONArray();
		JSONObject obj=null;
		if(list !=null && list.size()>0)
		{
			if(allSupport)
			{
				obj=new JSONObject();
				obj.put("displayField",ui_text);
				obj.put("valueField","All");
				arr.add(obj);
			}
			for (int i=0;i<list.size();i++)
			{
				String text=(String)list.get(i);
				String dispText=text;
				if(dispText.indexOf(":")>-1)
				{
					dispText = dispText.substring(0,dispText.lastIndexOf(":"));
				}
				obj=new JSONObject();
				if(isCompType)
				{
					obj.put("displayField",intlmap.getComponentTypeDescription(dispText));
				}
				else
				{
					if(dispText.equalsIgnoreCase("--Default--"))
					{
						dispText = intlmap.getTextDescription("reporter.common.--Default--");
					}
					obj.put("displayField",dispText);
				}
				obj.put("valueField",text);
				arr.add(obj);
			}	
		}
		else
		{
			obj=new JSONObject();
			obj.put("displayField",intlmap.getTextDescription("reporter.common.Not Applicable"));
			obj.put("valueField","-1");
			arr.add(obj);
		}
		return arr;
	}
    public  String customReplaceAll(String source,String toReplace,String replacement) 
	{
        int idx = source.lastIndexOf(toReplace);
        if (idx != -1) 
		{
            StringBuffer ret = new StringBuffer(source);
            ret.replace(idx, idx + toReplace.length(), replacement);
            while ((idx = source.lastIndexOf(toReplace, idx - 1)) != -1) 
			{
                ret.replace(idx, idx + toReplace.length(), replacement);
            }
            source = ret.toString();
        }
        return source;
    }
%>