<%
/*		Author			:	James Thomas
		Creation Date	:	06th September 2006
		Purpose			:	Displays the current status of the servers being monitored 
		Design Changes	:	Jaiwin
*/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.egurkha.EgMostProbComp"%>
<%@ page import="com.egurkha.monitor.HealthDAO"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import="com.egurkha.monitor.ZoneDashboardResult"%>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.eg.supermanager.*"%>
<%@page import = "java.util.*"%>
<%@ page import="com.fasterxml.jackson.databind.ObjectMapper"%>
<%@ page import="com.fasterxml.jackson.databind.node.ArrayNode"%>
<%@ page import="com.fasterxml.jackson.databind.node.ObjectNode"%>
<%@ page import="com.fasterxml.jackson.databind.JsonNode"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	String thisLanguage="";
	
	
	EgAggregateInfo aggregateInfo =new EgAggregateInfo("manager");
	ZoneDashboardData d = (ZoneDashboardData) session.getAttribute("zoneDashboardData");
	ZoneDashboardResult r = (ZoneDashboardResult) session.getAttribute("zoneDashboardResult");
	EgAggregateInfo aggInfo=new EgAggregateInfo("manager");
	IniUI ui = (IniUI)IniUI.getInstance();
	String aggregateComp = ui.getValue("COMPONENT_METRIC_VIEW","AggregateComp");
	aggregateComp = (aggregateComp == null || aggregateComp.equals("null") || aggregateComp.trim().length()==0 ) ? "layerModel":aggregateComp;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String showHostSystem=egUI.getValue("HOST_SYSTEM","Show_HostSystem");
	showHostSystem=(showHostSystem==null || showHostSystem.trim().length()==0)?"CompType":showHostSystem;

	boolean isShowHostSystemHost = false;
	boolean isShowHostSystemOS = false;
	boolean isShowHostSystemCompType = false;

	if(showHostSystem.equalsIgnoreCase("HostSystem"))
	{
		isShowHostSystemHost=true;
	}
	else if(showHostSystem.equalsIgnoreCase("OS"))
	{
		isShowHostSystemOS=true;
	}
	else
	{
		isShowHostSystemCompType = true;
	}

	long maxDuration;
	long totalDuration;
	long alarmCount = r.alarmCount;
	int measureCount = r.measureCount;


	List list = d.user.getServers(true);	
	EgUserRole userRole = d.user.getUserRole();
	
	try
	{
		thisLanguage = ui.getDefaultLanguage();
		if (d.user!=null)
		{
			String userLang = d.user.getLanguage();
			if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
			{
				thisLanguage=userLang;
			}
		}
	}
	catch(Exception e)
	{
		System.out.println(e);
	}
	
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	
	boolean hasAllComponentAccess=userRole.hasAllComponentAccess();
	Object obj[] = list.toArray();
	Vector usersValidNicks = new Vector();
	for(int i=0;i<obj.length;i++)
	{
		String temp = obj[i].toString();
		String temp1 = temp.toString();
		temp = temp.substring(0,temp.indexOf(":"));
		usersValidNicks.add(temp);
		if(temp1.indexOf(":") != temp1.lastIndexOf(":"))
		{
			usersValidNicks.add(temp1);
		}
	}
	TreeMap problemMap = new TreeMap();
	TreeMap timeMap = new TreeMap();
	TreeMap maxTimeMap = new TreeMap();
	TreeSet sortedSet = new TreeSet();
	DateTimeTokenizer dtt = new DateTimeTokenizer();
	java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	EgDateInfo egDate = new EgDateInfo();
	java.util.Date now = new java.util.Date(egDate.egetDateUS());	
	dtt.setDateFormat(DateTimeTokenizer._YMD);
	dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
	dtt.setTimeFormat(DateTimeTokenizer.HMS);
	//sdf.setTimeZone(egDate.getRealTimeZone());
	dtt.setEndDateTime(sdf.format(now));
	totalDuration = 0l;
	maxDuration = dtt.getDateDifference();
	problemMap.clear();
	for (Iterator i=r.alarms.iterator(); i.hasNext(); )
	{
		String[] row = (String[])i.next();
		dtt.setStartDateTime(row[5]);
		long difference = dtt.getDateDifference();
		maxDuration = Math.max(maxDuration, difference);
		totalDuration += difference;
		String thisLayer = row[2];
		Integer count = (Integer)problemMap.get(thisLayer);
		if (count == null)
		{
			problemMap.put(thisLayer, new Integer(1));
			sortedSet.add("01#"+thisLayer);
		}
		else
		{
			int myVal = count.intValue();
			sortedSet.remove(myVal+"#"+thisLayer);
			sortedSet.remove("0"+myVal+"#"+thisLayer);
			myVal++;
			problemMap.put(thisLayer, new Integer(myVal));
			sortedSet.add(((myVal<10)?"0":"")+myVal+"#"+thisLayer);
		}
		Long layerTimeCount = (Long)timeMap.get(thisLayer);
		if (layerTimeCount == null)
		{
			timeMap.put(thisLayer, new Long(difference));
		}
		else
		{
			long myVal = layerTimeCount.longValue();
			myVal+=difference;
			timeMap.put(thisLayer, new Long(myVal));
		}
		//maxTimeMap
		Long maxDiff = (Long)maxTimeMap.get(thisLayer);
		if (maxDiff == null)
		{
			maxTimeMap.put(thisLayer, new Long(difference));
		}
		else
		{
			long myVal = maxDiff.longValue();
			myVal = Math.max(myVal, difference);
			maxTimeMap.put(thisLayer, new Long(myVal));
		}
	}
	Iterator keyiter = sortedSet.iterator();
	int maxVal = 5;
	int c=0;
	ObjectMapper mapper = new ObjectMapper();
	ObjectNode json  = mapper.createObjectNode();
	ObjectNode problemAnalysis  = mapper.createObjectNode();
	
	if (sortedSet.size()>0)
	{
		ArrayNode  problems = mapper.createArrayNode();
		ObjectNode problem  = mapper.createObjectNode();
		problem.put("layer",mappingInfo.getLayerDescription("zones.zonehome.SUMMARY"));
		problem.put("unresolvedPrblms",String.valueOf(alarmCount));
		problem.put("avgDur",r.averageDuration);
		problem.put("maxDur",r.maximumDuration);
		
		problems.add(problem);
		
		for (int i=0; i<maxVal; i++)
		{
			if (sortedSet.size()==0)
			{
				//add empty space to keep summary at the bottom

			}
			else
			{
				String thisKey = (String)sortedSet.last();
				sortedSet.remove(thisKey);
				thisKey = thisKey.substring(thisKey.indexOf("#")+1);
				Integer thisVal = (Integer)problemMap.get(thisKey);
				if (thisVal==null)
					continue;
				int myCount = thisVal.intValue();
				Long timeVal = (Long)timeMap.get(thisKey);
				Long maxTimeVal = (Long)maxTimeMap.get(thisKey);
				
				problem = mapper.createObjectNode();
				problem.put("layer",mappingInfo.getLayerDescription(thisKey.trim()));
				problem.put("unresolvedPrblms",String.valueOf(myCount));
				problem.put("avgDur",DateTimeTokenizer.getTimeDifference(timeVal.longValue()/myCount));
				problem.put("maxDur",DateTimeTokenizer.getTimeDifference(maxTimeVal.longValue()));
				
				problems.add(problem);
				
			}
		}
		
		problemAnalysis.put("problems",problems);
		
		ArrayNode  components = mapper.createArrayNode();
		
		String selection = request.getParameter("duration");
		String array[]={"1 hour","6 hours","12 hours","18 hours","24 hours"};

			long duration = 0l;
			if (selection != null && !selection.equals(""))
			{
				if(selection.equals("1 hour"))
				{
					duration = 1 * 60 * 60 * 1000;
				}
				else if(selection.equals("6 hours"))
				{
					duration = 6 * 60 * 60 * 1000;
				}
				else if(selection.equals("12 hours"))
				{
					duration = 12 * 60 * 60 * 1000;
				}
				else if(selection.equals("18 hours"))
				{
					duration = 18 * 60 * 60 * 1000;
				}
				else
				{
					duration = 24 * 60 * 60 * 1000;
				}
			}
			else
			{
				duration = 1 * 60 * 60 * 1000;
			}

			String temp = "";
			int rowCount = 0;
			if(hasAllComponentAccess || (d.user.getLoginID()).equalsIgnoreCase("Admin")  || (d.user.getLoginID()).equalsIgnoreCase("supermonitor"))
			 rowCount = 8;
			HealthDAO healthDAO = new HealthDAO();
			Hashtable compListTable = new Hashtable();
			ArrayList validServers = new ArrayList();
			Hashtable keyCompListTable = new Hashtable();
			for(int i=0;i<r.zoneComponentsList.size();i++)
			{
				String name = r.zoneComponentsList.get(i).toString();
				if(name ==null || name.trim().length()==0)
					continue;
				String key = name.substring(0,name.indexOf(":"));
				String value = name.substring(name.indexOf(":")+1);
				compListTable.put(key,value);
				validServers.add(key);
				String newKey = key+":"+value.substring(0,value.indexOf(":"));
				keyCompListTable.put(newKey,name);
			}
			if(EgInstallInfo.isSuperManager)
			{
				ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("zone",d.zoneName);
				if(managerIDs != null && !managerIDs.isEmpty())
				{
					SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
					EgThreadLocal egtl = new EgThreadLocal();
					egtl.set(smsData);
				}
			}
			EgComponentList mostEventsList =  healthDAO.getCompsMostEvents(duration,0);//found using event_hist table
			EgDiscInfo discinfo = new EgDiscInfo("manager");
			boolean valueExists = false;
			if(mostEventsList!=null&&mostEventsList.size()>0)
			{
				EgComponentList result = new EgComponentList();
				if(isShowHostSystemCompType)
				{
					//for(int index=0;index<mostEventsList.size() && (rowCount==0 || index < rowCount);index++)
					for(int index=0;index<mostEventsList.size();index++)
					{
						EgMostProbComp component = (EgMostProbComp) mostEventsList.get(index);
						int count = component.getEventCount();
						String type = component.getType();
						String name = component.getDisplayName();
						List srvTypes;
						if(type.equals("Host_system"))
						{
							if(name.indexOf(":")!=-1)
								srvTypes = discinfo.getServerTypesForNick(name.substring(0,name.indexOf(":")));
							else
								srvTypes = discinfo.getServerTypesForNick(name.trim());

							if(srvTypes !=null && srvTypes.size() >0)
							{
								type=srvTypes.get(0).toString();
							}
							
							if(type!=null && type.trim().length()>0)
							{
								boolean toAdd=true;
								for(int j=0;j<result.size();j++)
								{
									EgMostProbComp componentObj = (EgMostProbComp) result.get(j);
									String temp_type = componentObj.getType();
									String temp_name = componentObj.getName();
									String temp_name1 = name;
									if(temp_name!=null && temp_name.indexOf(":")>-1)
									{
										temp_name=temp_name.substring(0,temp_name.indexOf(":"));
									}
									if(temp_name1!=null && temp_name1.indexOf(":")>-1)
									{
										temp_name1=temp_name1.substring(0,temp_name1.indexOf(":"));
									}
									if(temp_type!=null && temp_type.equalsIgnoreCase(type) && temp_name.equalsIgnoreCase(temp_name1))
									{
										int count_temp = componentObj.getEventCount();
										int total_count = count+count_temp;
										componentObj.setEventCount(total_count);
										toAdd=false;
										break;
									}
								}

								if(toAdd)
								{
									result.add(new EgMostProbComp(type, name, State.GOOD,count));
								}
							}
						}
						else
						{
							if(result!=null && result.size()>0)
							{
								boolean toAdd=true;
								for(int j=0;j<result.size();j++)
								{
									EgMostProbComp componentObj = (EgMostProbComp) result.get(j);
									String temp_type = componentObj.getType();
									String temp_name = componentObj.getName();
									String temp_name1 = name;
									if(temp_name!=null && temp_name.indexOf(":")>-1)
									{
										temp_name=temp_name.substring(0,temp_name.indexOf(":"));
									}
									if(temp_name1!=null && temp_name1.indexOf(":")>-1)
									{
										temp_name1=temp_name1.substring(0,temp_name1.indexOf(":"));
									}
									if(temp_type!=null && temp_type.equalsIgnoreCase(type) && temp_name.equalsIgnoreCase(temp_name1))
									{
										int count_temp = componentObj.getEventCount();
										int total_count = count+count_temp;
										componentObj.setEventCount(total_count);
										toAdd=false;
										break;
									}
								}

								if(toAdd)
								{
									result.add(new EgMostProbComp(type, name, State.GOOD,count));
								}
							}
							else
							{
								result.add((EgMostProbComp)component);
							}
						}
					}
				}
				else
				{
					result = mostEventsList;
				}

				EgExternalInfo externalInfo=new EgExternalInfo("manager");
				AgentConfig agentConfig=AgentConfig.getAgentConfig();
				EgAgentInfo agentInfo=new EgAgentInfo("manager");
				int chInx=0;
				for(int index=0;index<result.size() && (rowCount==0 || chInx < rowCount);index++)
				{
					EgMostProbComp component = (EgMostProbComp) result.get(index);		
					String address="";
					int count = component.getEventCount();
					String type = component.getType();
					String name = component.getDisplayName();
					String name1 = name;
					temp = type;
					String type2=type;
					List srvTypes;
					
					if(type.equals("Host_system"))
					{
						if(name.indexOf(":")!=-1)
							srvTypes = discinfo.getServerTypesForNick(name.substring(0,name.indexOf(":")));
						else
							srvTypes = discinfo.getServerTypesForNick(name.trim());

						if(srvTypes !=null && srvTypes.size() >0)
						{
							type=srvTypes.get(0).toString();
							type2=type;
						}
					}
					
					if(validServers==null || !validServers.contains(type))
						continue;
					String display = "";
					if(type.startsWith("Agg_"))
						display = aggregateComp;
					name = (String) compListTable.get(type);
					String displayValue = "";
					if(name1.indexOf(":")!=-1)
					{
						String kkey = type+":"+name1.substring(0,name1.indexOf(":"));

						if(!keyCompListTable.containsKey(kkey))
							continue;
						displayValue = (String ) keyCompListTable.get(kkey.trim());
					}
					else
					{
						displayValue = (String ) keyCompListTable.get(type+":"+name1.trim());
					}
					if (displayValue == null)
						continue;
					name=displayValue.substring(displayValue.indexOf(":")+1);
					//address="/final/monitor/componentTabSet.jsp?monCmd=componentDashboard&componentName="+displayValue;
					//address="/final/monitor/EgDispLayers.jsp?site=NULL&qctr=0&comptype"+component.getType()+"&host="+component.getName();
					//address="/final/monitor/EgDispLayers.jsp?site=NULL&qctr=0&comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(component.getName(),"UTF-8");
				
					/*if(type.startsWith("Agg_") && aggregateInfo.getView().equalsIgnoreCase("dashboard") && EgInstallInfo.isAggregationSupported())
					{					
						address = "/final/monitor/aggDashboard.jsp?comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8");
					}
					else
					{*/
						address="../servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8")+"&tab=LayerModel&toDashBoardLayer=true";
						if(type!=null && !type.startsWith("Agg"))
						{
							address=address+"&showDashBoardLink=true";
						}
					//}
					//address="/final/monitor/EgSiteInfraView.jsp?site=NULL&fromalarm=NULL&qctr=2&comptype="+component.getType()+"&host="+component.getName()+"&layer="+layer1+"&test="+test1+"&tstate="+state1+"&msmt_host=";
					/*if(type.startsWith("Agg_")&& aggInfo.getView().equalsIgnoreCase("dashboard") 				&&EgInstallInfo.isAggregationSupported())	//Muniraj added on 30/04/2008
					{
						address="/final/monitor/aggDashboard.jsp?comptype="+EgURLEncoder.encode(type,"UTF-8")+"&host="+EgURLEncoder.encode(name,"UTF-8");
					}*/
					if(name1.toUpperCase().endsWith(":NULL"))
					name1 = name1.substring(0,name1.lastIndexOf(":"));
					/*
						address="../servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=search&selTypeString="+type+"&searchNameString="+name;		
					*/
					//type = (type.endsWith("_server"))?type.substring(0,type.indexOf("_server")):type;
					type = (temp.equals("Host_system"))?temp:type;
					/* 
						User might have had this component earlier and deleted. But that component's measures are still present in event_hist table. So we do not show that component.
					*/
					String userCompNick = null;
					if(name1.indexOf(":")>-1)
						userCompNick = name1.substring(0,name1.indexOf(":"));
					else
						userCompNick=name1;

					if(!usersValidNicks.contains(userCompNick))
						continue; 
					
					ObjectNode componentObj  = mapper.createObjectNode();
					
					String osName="";
					if(isShowHostSystemOS && type!=null && type.equals("Host_system"))
					{
						boolean isAgentlessServer=agentInfo.isAgentlessServer(userCompNick,type2);
						
						try
						{
							if(isAgentlessServer)
							{
								osName = externalInfo.getOSNameForAgentlessComp(userCompNick);
							}
							else
							{
								osName = agentConfig.getAgentOS(userCompNick);
							}
						}
						catch(Throwable th)
						{
							th.printStackTrace();
						}

						if(osName!=null && osName.trim().length()>0)
						{
							osName=osName;
						}
						else
						{
							osName=mappingInfo.getComponentTypeDescription(type);
						}
					}
					else
					{
						osName=mappingInfo.getComponentTypeDescription(type);
					}
					componentObj.put("componentType",osName);
					componentObj.put("componentName",name1);
					componentObj.put("events",String.valueOf(count));
					componentObj.put("address",address);
					
					components.add(componentObj);
					valueExists=true;
					chInx++;
					//rowCount++;
					if(chInx>=maxVal)
					break;
				}
			}
			
			problemAnalysis.put("components",components);
			problemAnalysis.put("duration",selection);
	}
	json.put("problemAnalysis",problemAnalysis);
	
	ObjectNode labelObj= mapper.createObjectNode();
	labelObj.put("zones.zonehome.Layer",mappingInfo.getTextDescription("zones.zonehome.Layer"));
	labelObj.put("zones.zonehome.Unresolved Problems",mappingInfo.getTextDescription("zones.zonehome.Unresolved Problems"));
	labelObj.put("zones.zonehome.Average Duration",mappingInfo.getTextDescription("zones.zonehome.Average Duration"));
	labelObj.put("zones.zonehome.Maximum Duration",mappingInfo.getTextDescription("zones.zonehome.Maximum Duration"));
	labelObj.put("zones.zonehome.Type",mappingInfo.getTextDescription("zones.zonehome.Type"));
	labelObj.put("zones.zonehome.Name",mappingInfo.getTextDescription("zones.zonehome.Name"));
	labelObj.put("zones.zonehome.Events",mappingInfo.getTextDescription("zones.zonehome.Events"));
	labelObj.put("monitor.zonehome.Click here for more events",mappingInfo.getTextDescription("monitor.zonehome.Click here for more events"));
	labelObj.put("Event Analysis",mappingInfo.getTextDescription("zones.zonehome.Event Analysis"));
	labelObj.put("zones.segments.noDataMsg",mappingInfo.getTextDescription("zones.info.No events available"));
	
	json.put("screenLabels",labelObj);
	
	response.getWriter().write(json.toString());
	
%>
