<%
/*
	Author			:	James Thomas
	Creation Date	:	06th September 2006
	Purpose			:	To display Measurements Status, Components At-A-Glance, Infrastructure Health, Event Analysis of the all components							
	Design Changes	:	Jaiwin
	Session remove	:	by Saravanan.A on 11/Apr/2012.
*/
%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %> 
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%@ include file = "EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>

<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgStateManager" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "java.util.ArrayList" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.egurkha.monitor.ZoneDashboardData"%>
<%@ page import = "com.egurkha.monitor.ZoneDashboardResult"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	ZoneDashboardData zd = (ZoneDashboardData) request.getAttribute("data");
	ZoneDashboardResult zr = (ZoneDashboardResult) request.getAttribute("result");

	session.setAttribute("zoneDashboardData",zd);
	session.setAttribute("zoneDashboardResult",zr);

	Health aggregateComponentsHealth = (Health) zr.aggregateComponentsHealth;
	long aggregateComponentsTotal = aggregateComponentsHealth.getTotal();
	boolean doTopMeasures = zr.showMinMaxPage;
	String treeFlag=request.getParameter("treeFlag");
	ArrayList zoneDisplayList = zr.zoneDisplayList;
	String selectedZone = zoneDisplayList.get(zoneDisplayList.size()-1).toString();
	String zoneState = EgStateZone.getState("Zone:"+selectedZone+":NULL");

	if(zr.maxDisplayCompMap==null || zr.maxDisplayCompMap.size()== 0 || zr.maxDisplayValueMap ==null && zr.maxDisplayValueMap.size()==0)
	{
		doTopMeasures = false;
	}		

	String address="";
	String currentPage = request.getParameter("currentPage");
	String fromHomepage = request.getParameter("fromHomepage");
	String from = request.getParameter("from");
	if(currentPage==null)
	{	
		if(doTopMeasures==true)
		{
			currentPage="minMax";
			address = "/final/monitor/zoneMinMax.jsp";
		}
		else
		{
			currentPage="eventAnalysis";
			address = "/final/monitor/zoneProblemAnalysis.jsp";
		}
	}
	
	if(currentPage!=null && currentPage.toString().length()>0)
	{
		if(currentPage.equalsIgnoreCase("minMax") && doTopMeasures == false)
		{
			currentPage="eventAnalysis";
			address = "/final/monitor/zoneProblemAnalysis.jsp";
		}
	}

	long refreshFrequency = 1L;
	//String refFreq = IniUI.getInstance().getRefreshTime("EgDashboard");
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;	
	}
	int zone_infra_height=0;
	int zone_comp_height=0;
	if (aggregateComponentsTotal==0)
		{
			zone_infra_height=100;
			zone_comp_height=275;
		}
	else
		{
			zone_infra_height=125;
			zone_comp_height=300;
		}

%>
<html class="content-frame">
<head>
<title>ZONE DASHBOARD</title>
 <egui:skin ui="monitor"/>
<script language="javascript">

	var c=0;
	var displayPage="<%=currentPage%>";
	var httpRequest = false;
	var refreshURL ="";	
	var temp="-1";

function  execute()
{
	if(temp=="-1")
	{
		temp="0";
		return;
	}
	refreshURL = '../servlet/com.eg.EgMonitorController?monCmd=zoneDashboard&zoneName=<%=EgURLEncoder.encode(zd.zoneName,"UTF-8")%>&currentPage='+displayPage;
	if (window.XMLHttpRequest)
	{
		httpRequest = new XMLHttpRequest();
		if (httpRequest.overrideMimeType)
		{
			httpRequest.overrideMimeType('text/xml');
		}

	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}


	}
	if (!httpRequest) {
		alert('<egui:intnl text="monitor.zonehome.Giving up Cannot create an XMLHTTP instance"/>');
		return false;
	}
	httpRequest.onreadystatechange = writeResponse;
	httpRequest.open('GET',refreshURL, true);
	httpRequest.send(null);		
}

function writeResponse()
{

	
	if (httpRequest.readyState == 4 || httpRequest.readyState=="complete")
	{
		if (httpRequest.status == 200)
		{
			//document.getElementById("nothing").innerHTML=xmlHttp.responseText;
		}
		document.getElementById('zcs').src='/final/monitor/zoneCurrentStatus.jsp';
		document.getElementById('zes').src='/final/monitor/zoneElementStatus.jsp';
		document.getElementById('zst').src='/final/monitor/zoneServerTypes.jsp';			
		loadPage();
	}	
}


function loadPage()
{
	if(displayPage=='zoneMinMax')
	{
		document.getElementById('zpa').src='/final/monitor/zoneMinMax.jsp';
	}
	else
	{		
		document.getElementById('zpa').src='/final/monitor/zoneProblemAnalysis.jsp';
	}
}

function swapId(dark, light)
{
	temps = document.getElementById(dark);
	document.getElementById(light).setAttribute("id", dark);
	temps.setAttribute("id", light);
}
var tabControl
function swapPage(a)
{
	if(!<%=doTopMeasures%>)
	{
		var probTab = document.getElementById('probtab');
		if (probTab!=null)
		{
			probTab.setAttribute("id", "tab_light");
		}
		return;
	}
	if(a=='zoneMinMax')
	{
		if (tabControl==a)
			return;
		if(document.getElementById('minmaxtab')== null)
		{
			swapId('inner_headbg', 'inner_tablight');
			swapId('inner_leftdark', 'inner_leftlight');
			swapId('inner_rightdark', 'inner_rightlight');
		}
		else
		{
			var minmaxtab = document.getElementById('minmaxtab');
			if (minmaxtab!=null)
			{
				minmaxtab.setAttribute("id", "inner_headbg");
			}

			var inner_leftdark = document.getElementById('inner_leftdark');
			if (inner_leftdark!=null)
			{
				inner_leftdark.setAttribute("id", "inner_leftdark");
			}

			var probtab = document.getElementById('probtab');
			if (probtab!=null)
			{
				probtab.setAttribute("id", "inner_tablight");
			}

			var inner_leftlight = document.getElementById('inner_leftlight');
			if (inner_leftlight!=null)
			{
				inner_leftlight.setAttribute("id", "inner_leftlight");
			}
		}
		if(document.getElementById('zpa')!=null)
		{
			document.getElementById('zpa').src= "/final/monitor/zoneMinMax.jsp";
		}
		displayPage='zoneMinMax';
	}
	else
	{
		if(!<%=doTopMeasures%>)
		{
			document.getElementById('minmaxtab').setAttribute("id", "tab_light");
			return;
		}	
		if(a=='eventAnalysis')
		{
			if (tabControl==a)
				return;
			if(document.getElementById('probtab') == null)
			{
				swapId('inner_headbg', 'inner_tablight');
				swapId('inner_leftdark', 'inner_leftlight');
				swapId('inner_rightdark', 'inner_rightlight');
			}
			else
			{
				swapId('inner_headbg', 'inner_tablight');
				swapId('inner_leftdark', 'inner_leftlight');
				swapId('inner_rightdark', 'inner_rightlight');
			}
			
			if(document.getElementById('zpa')!=null)
			{
				document.getElementById('zpa').src="/final/monitor/zoneProblemAnalysis.jsp";
			}
			displayPage='eventAnalysis';
		}
	}
	tabControl=a;
}

function callme(a)
{
	if(a)
	{
		swapPage('zoneMinMax');
	}
	else
	{
		swapPage('zoneProblemAnalysis');
	}
}
function refreshPage(duration)
{
	document.getElementById('zpa').src="/final/monitor/zoneProblemAnalysis.jsp?zoneDuration="+duration;
}

var requestParams2=new Object();
if('<%=treeFlag%>' != 'null' && '<%=treeFlag%>' != null && '<%=treeFlag%>' != 'undefined' && '<%=treeFlag%>' != undefined && '<%=treeFlag%>' != '')
{
		requestParams2.treeFlag = '<%=treeFlag%>';
		requestParams2.zoneName = '<%=zd.zoneName%>';
		//alert('requestParams2.treeFlag-zoneDashboard.jsp---->'+requestParams2.treeFlag);

}

setInterval("execute()",<%=refreshFrequency%>);
</script> 
</head>
<body leftmargin="0" topmargin="0" marginheight="0"  marginwidth="0"  style="overflow:hidden" onload="execute()" class="content-frame">
	<!-- OUTER TABLE -->
<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
<%

			//out.print(zoneState.toUpperCase());
			int size = zoneDisplayList.size();
			String zoneName="";
			for(int index = 0; index < size; index++)
			{
				zoneName = zoneDisplayList.get(index).toString();
			}

String thisTitle = "header.jsp?title=Dashboard : "+zoneName+"$zone&state_str="+zoneState;
%>
	<tr>
		<td valign="top">
			<div style="float:left;width:100%;padding:4px" class="bold listPageHeader"><div style="float:left;" class="roundsmall_<%=zoneState%>"></div><div style="padding:2px;float:left;">Zone : <%=zoneName%></div><div 
		</td>
	</tr>
	<tr>
	<td id="main_padding4" valign="top" height="100%">
		<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" >
			<tr>
				<td  valign="top" width="50%" id="ma  in_padding4">
					<table  width="100%"  height="100%" border="0" cellspacing="0" cellpadding="0">
						<tr>
							<td  width="100%" height="140" valign="top">
							<!--MEASUREMENTS TABLE STARTS HERE-->
								<table id="Table_01" width="100%" border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed">
									<tr>
										<td width="8" height="23" id="inner_leftdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
										<td height="19" class="inner_headbg" id="white_text">&nbsp;<egui:intnl text="monitor.zonehome.Current Status"/></td>
										<td width="8" height="23" id="inner_rightdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
									</tr>
									<tr>
										<td class="table_border" colspan="3" width="100%" height="138" style="border-top-width:0px">
										<iframe  id="zcs" name="CurrentStatus" src="/final/monitor/zoneCurrentStatus.jsp" height="139" width="100%" frameborder="0" scrolling="no" cellpadding="0" cellspacing="0" >
										</iframe>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td width="100%" height="11" valign="top"><img src="/final/monitor/eg_images/spacer.gif" height="11" border="0"></td>
						</tr>
						
						<tr>
							<td valign="top" width="100%"  height="<%=zone_infra_height%>" >
							<!-- SERVICES STATUS STARTS HERE -->
								<table id="Table_01" width="100%" border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed">
									<tr>
										<td width="8" height="23" id="inner_leftdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
										<td height="19" class="inner_headbg" id="white_text">&nbsp;<egui:intnl text="monitor.zonehome.Infrastructure Health"/></td>
										<td width="8" height="23" id="inner_rightdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
									</tr>
									<tr>
										<td class="table_border" colspan="3" width="*" height="*" style="border-top-width:0px">
										<iframe id="zes" name="ElementStatus" src="/final/monitor/zoneElementStatus.jsp?treeFlag=<%=treeFlag%>" height="<%=zone_infra_height%>" width="100%" frameborder="0" scrolling="no" cellpadding="0" cellspacing="0">
										</iframe>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
		<!--MEASUREMENTS TABLE ENDS HERE-->
				</td>
				<td  valign="top" width="50%" height="<%=zone_comp_height%>" id="main_padding4" style="padding-top:0px;">
			<!-- COMPONENT STATUS STARTS HERE -->
					<table id="Table_01" width="100%" border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td width="8" height="23" id="inner_leftdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
							<td height="19" width="100%" class="inner_headbg" id="white_text">&nbsp;<egui:intnl text="monitor.zonehome.Components At-A-Glance"/></td>
							<td width="8" height="23" id="inner_rightdark1"><img src="/final/monitor/eg_images/spacer.gif" border="0"/></td>
						</tr>
						<tr>
							<td class="table_border" colspan="3" width="*" height="*" style="border-top-width:0px">
							<iframe id="zst" name="ServerTypes" valign="top"  src="/final/monitor/zoneServerTypes.jsp" height="<%=zone_comp_height%>" width="100%" frameborder="0" scrolling="no" cellpadding="0" cellspacing="0">
							</iframe>
							</td>
						</tr>
					</table>
			<!-- COMPONENT STATUS ENDS HERE -->
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center" valign="top" width="100%" height="100%" id="main_padding4" style="bottom:8px">
				<!--MIN MAX TABLE STARTS HERE-->
					<table id="Table_01" width="100%" border="0" cellpadding="0" cellspacing="0" style="table-layout:fixed" height="100%">
						<tr>
						<td colspan="8">
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
			<%			
						boolean minmax = false;
						int minmaxColspan;
						if(doTopMeasures)
						{
							minmax = true;
							minmaxColspan = 8;
			%>
							<td style="width:3px;padding-left:0px;" height="19" id="inner_leftdark"></td>
							<td height="19" id = "minmaxtab" class="white_text" align="left" nowrap>
							<a id="mouse" onClick="javascript:swapPage('zoneMinMax')" >
							<egui:intnl text="monitor.zonehome.Measures At-A-Glance"/></a></td>
							<td style="width:7px" id="inner_rightdark"></td>
							<td>&nbsp;</td>
			<%
						}
						else
						{
							minmaxColspan = 8;
						}
			%>
							
<% 
	if(doTopMeasures) {

	
%>
							
							<td style="width:6px" height="19" id="inner_leftlight"></td>
							<td height="19" id = "probtab" class="white_text" style="text-align:left" nowrap>
							<a onClick="javascript:swapPage('eventAnalysis')" class="mouse" >
							<egui:intnl text="monitor.zonehome.Event Analysis"/></a>
							</td>
							<td style="width:7px" id="inner_rightlight">&nbsp;</td>
<%
	}else
{
%> 
							<!-- code changed by murugan.t -->
							<td style="width:3px;padding-left:0px;" height="19" id="inner_leftdark"></td>
							<td height="19" id = "minmaxtab" class="white_text" align="left" nowrap>
							<egui:intnl text="monitor.zonehome.Event Analysis"/></td>
							<td style="width:7px" id="inner_rightdark"></td>
							<td>&nbsp;</td>
							<!-- code end by murugan.t -->					 
<%
	}
	if(request.getQueryString()!=null)
	{
		if(from!=null && from.equalsIgnoreCase("ZoneDashboard"))
		{
			String checkParentZone=request.getParameter("parentZone");
			String tempParentZone="";
			if(checkParentZone != null && checkParentZone.trim().length()>0)
			{
				tempParentZone=checkParentZone;
			}
			session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?selectNode=Zone$cap$"+zoneName+"&selectedParam="+zoneName+"&currentTab=details&zoneName="+zoneName+"&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage="+request.getParameter("fromHomepage")+"&parentZone="+tempParentZone);
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?"+request.getQueryString());
			
		}
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp");
	}
%>
							
										</tr>
									</table>
								</td>
							</tr>
						 
							<script language="JavaScript">
							callme('<%=doTopMeasures%>');
							</script>
						<tr>
								<td class="table_border" colspan="<%=minmaxColspan%>"  height="100%" valign="top">
									<iframe style="position:relative" id="zpa" name="minMax" src="<%=address%>" height="100%" width="100%" frameborder="0" scrolling="no" >
									</iframe>
								</td>

						</tr>
					</table>
		<!--MIN MAX TABLE ENDS HERE-->
				</td>
			</tr>
		</table>
<script language="JavaScript">
	callme('<%=doTopMeasures%>');
</script>
<input type="hidden" id="doTopMeasures" value="<%=doTopMeasures%>">
<input type="hidden" id="currentPage" value="<%=currentPage%>">
</body>
</html>