<!DOCTYPE html>
<%
/********************************************************************************************************
*	Name			:	zoneDash.jsp
*	Purpose			:	This is the main jsp which includes different tabs used in the service Dashboard and relevant scripts
*	Version			:	5.6
*	CreationDate	:	Feb 20,2012
*	Author			:	S.Saravanan
	Session remove	:	by Saravanan.A on 11/Apr/2012.
*******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.User"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%@ page import="com.eg.*"%>

<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		if(EgSMDBHelper.paramsOfJSP.containsKey(currentSession))
		{
			EgSMDBHelper.paramsOfJSP.remove(currentSession);
		}
		String zone_frm_zone = request.getParameter("zoneFromZone");
		if(zone_frm_zone != null && (zone_frm_zone=zone_frm_zone.trim()).length()>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("zone",zone_frm_zone);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");

	ZoneListData zonedata = (ZoneListData) request.getAttribute("data");
	ZoneListResult zoneresult = (ZoneListResult) request.getAttribute("result");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String optionalListPage = egUI.getValue("OptionalList_Pages","zonelist");
	boolean isFromMenu = "true".equals(request.getParameter("isFromMenu"))?true:false;

	if(zoneresult!=null && zoneresult.zoneList!=null)
	{
		session.setAttribute("ZoneListData",zonedata);
		session.setAttribute("ZoneListResult",zoneresult);
	}
	
	if(zoneresult==null || zonedata==null)
	{
		zonedata  = (ZoneListData)session.getAttribute("ZoneListData");
		zoneresult=(ZoneListResult)session.getAttribute("ZoneListResult");
	}
	
	String outsideZone=request.getParameter("outsideZone");
	String isfromTopology=request.getParameter("isfromTopology");
	isfromTopology=(isfromTopology==null)?"false":isfromTopology;
	String zoneFromZone=request.getParameter("zoneFromZone");
	zoneFromZone=(zoneFromZone==null)?"":zoneFromZone;
	
	boolean isfromZoneMenu = false;
	String fromZoneMenu=request.getParameter("fromZoneMenu");
	if(fromZoneMenu != null && fromZoneMenu.trim().length()>0 && (fromZoneMenu.equalsIgnoreCase("true") ||fromZoneMenu.equalsIgnoreCase("yes") ))
		isfromZoneMenu = true;

	String fromHomepage = request.getParameter("fromHomepage");
	fromHomepage=(fromHomepage==null)?"":fromHomepage;
	String fromPageView = request.getParameter("fromPageView");
	fromPageView=(fromPageView==null)?"":fromPageView;
	
	String refFrequency = u_ser.getRefreshFrequency();
	long refreshFrequency = 60000L;
	if(refFrequency!=null && refFrequency.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFrequency).longValue() * 1000L;
	}
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	String sessionID = session.getId();
	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);
	EgUserRole userRole = user.getUserRole();
	
	boolean isAllComponentAccess = false;
	if(EgInstallInfo.isClusterSupported)
	{
		EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
		if(mi.isPrimaryManager() && userRole.hasAllComponentAccess())
		{
			isAllComponentAccess = true;
		}
	}
	else if(userRole.hasAllComponentAccess())
	{
		isAllComponentAccess = true;
	}

	boolean isAdminUser= userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String titleText = mappingInfo.getTextDescription("monitor.common.zone");
	String selectNode = request.getParameter("selectNode");
	selectNode = (selectNode==null)?"Zone":selectNode;
	if(selectNode != null)
	{
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"$cap$","^");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"$pipe$","|");
	}
	String treeFlagg=request.getParameter("treeFlag");
	treeFlagg=(treeFlagg==null)?"false":treeFlagg;
	String openNode=request.getParameter("openNode");
	String column=request.getParameter("column");
	String sortOrder=request.getParameter("sortOrder");
	String imageId=request.getParameter("imgId");
	String appcolumn=request.getParameter("appcolumn");
	String appsortOrder=request.getParameter("appsortOrder");
	String appimageId=request.getParameter("appimgId");
	String setAssociate=request.getParameter("setAssociate");
	//String limit=request.getParameter("limit");
	String appCurrentHost = request.getParameter("appCurrentHost");
	String aggregateComp = request.getParameter("aggregateComp");
	String currentTab = request.getParameter("currentTab");
	String topoSegment = request.getParameter("segment");
	//String QueryString=request.getQueryString();
	String insideTab = request.getParameter("insideTab");
	String refresh = request.getParameter("refresh");
	String treeOpen = request.getParameter("treeOpen");
	treeOpen=(treeOpen==null || treeOpen.trim().length()==0 || treeOpen.equalsIgnoreCase("null") || treeOpen.equalsIgnoreCase("undefined"))?"false":treeOpen;
	String selectedTreeNode = request.getParameter("selected");
	selectedTreeNode=(selectedTreeNode==null || selectedTreeNode.trim().length()==0 || selectedTreeNode.equalsIgnoreCase("null") || selectedTreeNode.equalsIgnoreCase("undefined"))?"":selectedTreeNode;
	String backButtonText = mappingInfo.getTextDescription("monitor.common.Back");
	String action = request.getParameter("action");
	String aggregateTab = request.getParameter("aggregateTab");
	String zoneName = request.getParameter("zoneName");
	String parentZone = request.getParameter("parentZone");
	String fromZoneMenu1 = request.getParameter("fromZoneMenu");
	String from = request.getParameter("from");
	String name = zoneName;
	String zoneState="";
	if ((name!=null) && (!name.equals("")))
	{
		if(!zoneName.startsWith("Zone:") && !zoneName.endsWith(":NULL"))
			name = "Zone:"+zoneName+":NULL";
		zoneState=EgStateZone.getState(name);
	}

	//aggregate view
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList aggregateArray = aggregateInfo.getAggregateComponentsOfElement("zone",zoneName);
	if(aggregateArray != null && aggregateArray.size() > 0)
		aggregateTab = "true";

	//global search
	String searchString=request.getParameter("searchString");
   	if( !StringUtils.isNull(action) && ( action.equalsIgnoreCase("globalsearch") || action.equalsIgnoreCase("globalsearchallzone") ) )
	{
            if(searchString!=null)
	    {
	       session.setAttribute("globalSearchLastSessionval","zone "+searchString);
	    } 
	   else
           { 
             session.setAttribute("globalSearchLastSessionval","zone *");
	   }
       } 
	//for timeline in transaction page
	/*
	if(limit==null || limit.length()<0)
	{
		limit=egUI.getValue("TREE_SYSTEM_SETTINGS","Default");
	}
	*/
	if(setAssociate==null)
	{
		setAssociate="";
	}

	String siteName_conf=request.getParameter("siteName_conf");
	
	//ServiceListData servicedata = (ServiceListData) request.getAttribute("data");
	//ServiceListResult serviceresult = (ServiceListResult) request.getAttribute("result");
	String selectedParam = request.getParameter("selectedParam");
	String showDashboard = request.getParameter("showDashboard");
	String selectedSystemCompType = request.getParameter("selectedSystemCompType");
	String tabText = "monitor.zoneDashboard."+ currentTab;
	String treeSession=(String)session.getAttribute("monitorLastSession");
	String thisPageSession=(String)session.getAttribute("thisPageSession");
	String fromPage=request.getParameter("fromPage");
	String myDashboardBackUrl="";
	 if(fromPage!=null && fromPage.equalsIgnoreCase("myDashboard"))
	{
		String myDashboardUrlParams=request.getParameter("backBtnUrl");
		myDashboardUrlParams=StringUtils.decodeSecurityChar(myDashboardUrlParams);
		myDashboardBackUrl="/final/monitor/MyDashboard.jsp?comesFrom=myDashboard&action=showMyDashboard"+myDashboardUrlParams;
	}
	if(strCsrfToken==null||strCsrfToken.trim().length()==0||strCsrfToken.equalsIgnoreCase("null"))
		strCsrfToken = (String)request.getParameter("com.eg.CSRF_NONCE");
	strCsrfToken = (strCsrfToken==null || strCsrfToken.trim().length()==0)?"":strCsrfToken;

	String compLabel = "Components";
	String segLabel = "Segments";
	String serLabel = "Services";
	String aggLabel = "Aggregates";
	String zoneLabel = "Zones";
	compLabel = mappingInfo.getTextDescription("monitor.common."+compLabel);
	segLabel = mappingInfo.getTextDescription("monitor.common."+segLabel);
	serLabel = mappingInfo.getTextDescription("monitor.common."+serLabel);
	aggLabel = mappingInfo.getTextDescription("monitor.common."+aggLabel);
	zoneLabel = mappingInfo.getTextDescription("monitor.common."+zoneLabel);
%>
<jsp:useBean id = "sitebean" scope = "page" class = "egurkha.ConfigSiteBean"/>
<html class="content-frame">
<head>
<title><egui:intnl text="monitor.common.zone Dashboard"/></title>

<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
<egui:skin ui="monitor"/>

<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="zones" appFile="zones.js"/>


<!--  <link rel="stylesheet" type="text/css" href="../monitor/eg_styles/monitor.css" />  -->
<link type="text/css" href="../styles/jscrollpane/jquery.jscrollpane.css" rel="stylesheet" media="all" />
<style>
	span.decimal-align{float: left; text-align: right; width:50%}
	span.decimal-align2{float: right; text-align: left; width:50%}
</style>
<script src="/final/jquery/jquery.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.mousewheel.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/mwheelIntent.js"></script>
<script type="text/javascript" src="../styles/jscrollpane/jquery.jscrollpane.js"></script>
<!-- <script src="../FusionCharts/scripts/FusionCharts.js"></script> -->

<script type="text/javascript" src="../jquery/jquery-ui.js"></script>
<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
<script src="/final/monitor/eg_scripts/EgHighChart.js"></script>
<script src="/final/monitor/eg_scripts/egDashboardHighChart.js"></script>
<script src="/final/Highcharts/js/highcharts-more.js"></script>
<script src="/final/scripts/utilities/EmptyPanel.js"></script>

<script language="javascript">
var fromPage='<%=fromPage%>';
var compLabel='<%=compLabel%>';
var segLabel='<%=segLabel%>';
var serLabel='<%=serLabel%>';
var aggLabel='<%=aggLabel%>';
var zoneLabel='<%=zoneLabel%>';
var myDashboardBackUrl = '<%=myDashboardBackUrl%>';
var csrfToken = '<%=strCsrfToken%>';
var isfromZoneMenu = <%=isfromZoneMenu%>;
var layerLbl = '<egui:intnl text="monitor.home.Layer"/>';
var openAlarmsLbl = '<egui:intnl text="monitor.home.Open Alarms"/>';
var avgDurationLbl = '<egui:intnl text="monitor.home.Average Duration"/>';
var maxDurationLbl = '<egui:intnl text="monitor.home.Maximum Duration"/>';
var CmpTypeLbl = '<egui:intnl text="monitor.home.Component Type"/>';
var CmpNameLbl = '<egui:intnl text="monitor.home.Component Name"/>';
var eventsLbl = '<egui:intnl text="monitor.home.Events"/>';
var hourLbl = '<egui:intnl text="monitor.home.hour"/>';
var hoursLbl = '<egui:intnl text="monitor.home.hours"/>';
var compEnvLbl = '<egui:intnl text="monitor.home.Components with most events in the last"/>';
function parseScript(_source)
{
	var source = _source;
	var scripts = new Array();
	
	// Strip out tags
	while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

		var s = source.indexOf("<script");
		var s_e = source.indexOf(">", s);
		var e = source.indexOf("</script", s);
		var e_e = source.indexOf(">", e);			
		// Add to scripts array
		scripts.push(source.substring(s_e+1, e));
		// Strip from source
		source = source.substring(0, s) + source.substring(e_e+1);
	}
	// Loop through every script collected and eval it
	for(var i=0; i<scripts.length; i++) {
		try {
			eval(scripts[i]);
		}
		catch(ex) {
			return;
		}
	}
	// Return the cleaned source
	return source;
}
Ext.onReady(function(){
	Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	Ext.Ajax.on('requestexception', function (conn, response, options) {
		var errorStr = response.responseText;
		parseScript(errorStr);
		if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
		{
			if (errorStr.indexOf("user-session-invalid") != -1)
			{
				callWindow(1);
			}
			else if (errorStr.indexOf("user-deleted") != -1)
			{
				callWindow(2);
			}
			else if (errorStr.indexOf("user-timedout") != -1)
			{
				callWindow(3);
			}
		}
	});
	initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
});
 var showDashboard = false;
 var optionalListFlag = false;
 var aggregateTab = false;
 var lasInfrastructureMenuSelection = '';
 var hideBackButton = <%=isFromMenu%>;
 var compSelectedValue=null;

 if("<%=optionalListPage%>"=="true" ||"<%=optionalListPage%>"=="True"||"<%=optionalListPage%>"=="TRUE"||"<%=optionalListPage%>"=="yes"||"<%=optionalListPage%>"=="Yes"||"<%=optionalListPage%>"=="YES"){
	 optionalListFlag=true;
 }
 var List_View = "<%=mappingInfo.getTextDescription("monitor.common.List View")%>";
 var Grid_View = "<%=mappingInfo.getTextDescription("monitor.common.Grid View")%>";
 var Associations = "<%=mappingInfo.getTextDescription("monitor.common.Associations")%>";
 var Zones = "<%=mappingInfo.getTextDescription("monitor.common.Zones")%>";
 var currentStatus = "<%=mappingInfo.getTextDescription("monitor.common.Current Status")%>";
 var eventAnalysis = "<%=mappingInfo.getTextDescription("monitor.common.Event Analysis")%>";
 var searchBox = "<%=mappingInfo.getTextDescription("monitor.common.Search")%>";
 var aggregatesTabName = "<%=mappingInfo.getTextDescription("monitor.home.Aggregates")%>";
 var noEventsAvailable = "<%=mappingInfo.getTextDescription("monitor.common.No events available")%>";
 var zoneAssociationsTxt = "<%=mappingInfo.getTextDescription("monitor.zoneDashboard.User and Zone Associations")%>";
 var zoneSettingsTxt = "<%=mappingInfo.getTextDescription("monitor.common.Settings")%>";
 var disptxt = '<egui:intnl text="monitor.common.Displaying"/>';
 var oftxt = '<egui:intnl text="monitor.common.of"/>';
 var requestParams=new Object();
 //requestParams.aggregateTab = false;
 requestParams.aggregateTab = '<%=aggregateTab%>';
 var refreshFrequency=<%=refreshFrequency%>;
 requestParams.selectedTreeNode="<%=selectedTreeNode%>";
 requestParams.treeSession="<%=treeSession%>";
 <%
	if(treeSession!=null && treeSession.indexOf("zoneDash.jsp")>-1)
	{
		session.setAttribute("thisPageSession",treeSession);
	}
	else if(thisPageSession!=null && thisPageSession.indexOf("zoneDash.jsp")>-1)
	{
		session.removeAttribute("thisPageSession");
%>
		requestParams.treeSession='<%=thisPageSession%>';
<%
	}
%>
 requestParams.backButtonText="<%=backButtonText%>";
 requestParams.systemTabText="<%=mappingInfo.getTextDescription("monitor.zoneDashboard.Systems")%>";
 requestParams.componentsTabText="<%=mappingInfo.getTextDescription("monitor.zoneDashboard.Components")%>";
 requestParams.detailsTabText="<%=mappingInfo.getTextDescription("monitor.zoneDashboard.Details")%>";
 requestParams.treeOpen="<%=treeOpen%>";
 if("<%=refresh%>"=="true"){
	requestParams.refresh = true;
	requestParams.insideTab = "<%=insideTab%>";
}
else{
	requestParams.refresh = false;
}
 requestParams.action=('<%=action%>'); 
 var currTab = '<%=currentTab%>';

 if('<%=aggregateTab%>' != 'null' && '<%=aggregateTab%>' != null && '<%=aggregateTab%>' != 'undefined' && '<%=aggregateTab%>' != undefined && '<%=aggregateTab%>' != '')
		requestParams.aggregateTab = '<%=aggregateTab%>';

if('<%=fromHomepage%>' != 'null' && '<%=fromHomepage%>' != null && '<%=fromHomepage%>' != 'undefined' && '<%=fromHomepage%>' != undefined && '<%=fromHomepage%>' != '')
		requestParams.fromHomepage = '<%=fromHomepage%>';


if(currTab == 'system' || currTab == 'components' || currTab == 'aggregates' || currTab == 'details'){
	showDashboard = true;
	requestParams.currentTab = currTab;
}

requestParams.selectNode = '<%=selectNode%>';
requestParams.selectedParam = '<%=selectedParam%>';
requestParams.zoneState = '<%=zoneState%>';
requestParams.openNode = '<%=openNode%>';
requestParams.treeFlag = '<%=treeFlagg%>';
requestParams.appCurrentHost = '<%=appCurrentHost%>';
requestParams.aggregateComp = '<%=aggregateComp%>';
requestParams.insideTab = '<%=insideTab%>';
requestParams.zoneName = '<%=zoneName%>';
requestParams.parentZone = '<%=parentZone%>';
requestParams.from = '<%=from%>';
requestParams.fromPageView = '<%=fromPageView%>';
requestParams.fromZoneMenu = '<%=fromZoneMenu1%>';
var isAllComponentAccess = <%=isAllComponentAccess%>;

var selectedSystemCompType = "<%=selectedSystemCompType%>";
var fromDashboard = '';
if(requestParams.from != null && requestParams.from !=undefined && requestParams.from !='undefined' && requestParams.from !='null' && requestParams.from != '' && requestParams.from == 'ZoneDashboard')
{
	fromDashboard = requestParams.from;
}
requestParams.aggError = '<%=mappingInfo.getTextDescription("monitor.common.No metrics running")%>';

function loadURL(myURL)
{
	window.location.href=myURL;
}
</script>

<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGridPanel.js"></script>
<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresAggregatePanel.js"></script>
<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGrid.js"></script>

</head>
<body style="overflow:hidden" id="body_bg" marginwidth="0" marginheight="0" topmargin="0" leftmargin="0" scroll="no" class="content-frame">
<div id ="zone" style="position:absolute;top:0px;height: 100%; width: 100%;">
<div class="maskLoader" style="font-weight: bold; font-size: 16px; top: 47.2%; left: 45.8%;">
<!-- <div class="maskText">Loading...</div> -->
</div>
</div>
</body>
</html>
<%
try
{
	action=(action==null)?"":action;
    if(action!=null && action.equalsIgnoreCase("globalsearch") ||  action.equalsIgnoreCase("globalsearchallzone")   )
    {  
       if(request.getQueryString()!=null)
       {
	  session.setAttribute("globalSearchLastSessionURL","/final/monitor/zoneDash.jsp?"+request.getQueryString());
       }
       else
       {
	  session.setAttribute("globalSearchLastSessionURL","/final/monitor/zoneDash.jsp");
       }
    }
    else
    {
	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/monitor/zoneDash.jsp");
	}
	}
   }
catch(Exception e)
{
	System.out.println("Exception in zoneDashboard..");
	e.printStackTrace();
}
%>