require.def("tabs/search",["domplate/domplate","core/lib","i18n!nls/search","domplate/toolbar","domplate/popupMenu","core/cookies","core/dragdrop"],function(Domplate,Lib,Strings,Toolbar,Menu,Cookies,DragDrop){with(Domplate){var Search={};var caseSensitiveOption="searchCaseSensitive";Search.Box=domplate({tag:SPAN({"class":"searchBox"},SPAN({"class":"toolbarSeparator resizer"},"&nbsp;"),SPAN({"class":"searchTextBox"},INPUT({"class":"searchInput",type:"text",placeholder:Strings.search,onkeydown:"$onKeyDown"}),SPAN({"class":"arrow",onclick:"$onOpenOptions"},"&nbsp;"))),onKeyDown:function(event){var e=$.event.fix(event||window.event);
var tab=Lib.getAncestorByClass(e.target,"tabBody");var searchInput=Lib.getElementByClass(tab,"searchInput");setTimeout(Lib.bindFixed(this.search,this,tab,e.keyCode,searchInput.value));},initialize:function(element){var searchInput=Lib.getElementByClass(element,"searchInput");var resizer=Lib.getElementByClass(element,"resizer");
Search.Resizer.initialize(searchInput,resizer);},search:function(tab,keyCode,prevText){var searchBox=Lib.getElementByClass(tab,"searchBox");var searchInput=Lib.getElementByClass(tab,"searchInput");searchInput.removeAttribute("status");var text=searchInput.value;if(text==prevText&&keyCode!=13){return;
}if(keyCode!=13&&Lib.isWebkit){return;}var result=tab.repObject.onSearch(text,keyCode);if(!result){searchInput.setAttribute("status","notfound");}},onOpenOptions:function(event){var e=Lib.fixEvent(event);Lib.cancelEvent(event);if(!Lib.isLeftClick(event)){return;}var target=e.target;var items=this.getMenuItems(target);
var menu=new Menu({id:"searchOptions",items:items});menu.showPopup(target);},getMenuItems:function(target){var tab=Lib.getAncestorByClass(target,"tabBody");var items=tab.repObject.getSearchOptions();items.push("-");items.push({label:Strings.caseSensitive,checked:Cookies.getBooleanCookie(caseSensitiveOption),command:Lib.bindFixed(this.onOption,this,caseSensitiveOption)});
return items;},onOption:function(name){Cookies.toggleCookie(name);var searchInput=Lib.getElementByClass(document.documentElement,"searchInput");searchInput.removeAttribute("status");}});Search.ObjectSearch=function(text,object,reverse,caseSensitive){this.text=text;this.reverse=reverse;this.caseSensitive=caseSensitive;
this.stack=[];this.stack.push({object:object,propIndex:0,startOffset:-1});this.matches=[];};Search.ObjectSearch.prototype={findNext:function(text){while(this.stack.length>0){var scope=this.getCurrentScope();var result=this.find(scope);if(result){return result;}}return false;},find:function(scope){var propIndex=0;
for(var p in scope.object){propIndex++;if(scope.propIndex>=propIndex){continue;}var value=scope.object[p];if(!value){continue;}scope.propIndex=propIndex;if(typeof(value)=="object"){this.stack.push({propIndex:0,object:value,startOffset:-1});return false;}var tempText=this.text;var tempValue=value+"";if(!Cookies.getBooleanCookie(caseSensitiveOption)){tempValue=tempValue.toLowerCase();
tempText=tempText.toLowerCase();}var startOffset=(scope.startOffset<0)?0:scope.startOffset;var offset=tempValue.indexOf(tempText,startOffset);if(offset>=0){scope.propIndex+=-1;scope.startOffset=offset+tempText.length;this.matches.push({value:value,startOffset:offset});return true;}}this.stack.pop();return false;
},getCurrentScope:function(){return this.stack[this.stack.length-1];},getCurrentMatch:function(){return this.matches[this.matches.length-1];},selectText:function(textNode){var match=this.getCurrentMatch();Lib.selectElementText(textNode,match.startOffset,match.startOffset+this.text.length);}};Search.Resizer=domplate({initialize:function(searchInput,resizer){this.searchInput=searchInput;
this.tracker=new DragDrop.Tracker(resizer,{onDragStart:Lib.bind(this.onDragStart,this),onDragOver:Lib.bind(this.onDragOver,this),onDrop:Lib.bind(this.onDrop,this)});},onDragStart:function(tracker){var body=Lib.getBody(this.searchInput.ownerDocument);body.setAttribute("vResizing","true");this.startWidth=this.searchInput.clientWidth-20;
},onDragOver:function(newPos,tracker){var newWidth=(this.startWidth-newPos.x);var toolbar=Lib.getAncestorByClass(this.searchInput,"toolbar");if(newWidth>toolbar.clientWidth-40){return;}this.searchInput.style.width=newWidth+"px";},onDrop:function(tracker){var body=Lib.getBody(this.searchInput.ownerDocument);
body.removeAttribute("vResizing");}});return Search;}});