<!DOCTYPE html>
<%
/**
 *	File name		: eGBTMTrace.jsp
 *	Purpose			: This page shows the call graph of a web request in HTML Table Tree view
 *	Version			: eG 6.0
 *	Creation Date	: 30-Apr-2014
 *	Author			: Mr.R and Mr.Balraj
 */
%>

<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page import = "java.math.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgAPMInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>

<%!
	EgAPMInfo apm = new EgAPMInfo("manager");
	private String nodeDelim = "%*%";
	private String nodeDetailsDelim = "#=#";
	DecimalFormat scaleDecimalFormat = new DecimalFormat("#");
	DecimalFormat percentFormat = new DecimalFormat("#.##");
	String clrSapjco = "#b8e6a9";
	String clrException = "#c55c66";
	String clrJms = "#89aeb8";
	String clrSql = "#d2b899";
	String clrRedis = "#00a587";
	String clrWebservice = "#afc8e9";
	String clrHttp = "#2479b6";
	String clrSelf = "#926ac0";
	String clrAsync = "#a4ad92";
	String clrCustomJolt = "#887c65";
	String clrRmi = "#58acb3";
	String clrEjb = "#e69900";
	String clrEmail = "#90b874";
	String clrLdap = "#ff66d9";
	String clrRuntime = "#66b3ff";
	String pointCutException = "EXCEPTION";
	String pointCutHTTP = "HTTP";
	String pointCutWebService = "WEBSERVICE";
	String pointCutJMS = "JMS";
	String pointCutSAP = "SAP JCO";
	String pointCutSQL = "SQL";
	String pointCutMONGO = "MONGODB";
	String pointCutREDIS = "REDIS";
	String pointCutThreadInit = "THREAD_INIT";
	String pointCutCustomJolt = "Custom_JOLT";
	String pointCutSelf = "SELF";
	String pointCutRMI = "RMI";
	String pointCutEMAIL = "EMAIL";
	String pointCutLDAP = "LDAP";
	String pointCutRuntime = "RUNTIME";
	String pointCutEJB = "EJB";
	String fastQueryText = "SQL queries executed within SQL execution cutoff are clubbed under ";
	boolean isSQLPresent = false;

	// Json data preparation for chart
	public JSONObject chartJsonBuild(Hashtable pointcutTimeHolder,EgMappingInfo mappingInfo, String monitor_Skin, String apmType)
	{
		JSONObject rootJson = new JSONObject();

		JSONObject tmpObj = new JSONObject();
		JSONObject tmpObj2 = new JSONObject();
		JSONObject tmpObj3 = new JSONObject();
		JSONObject tmpObj4 = new JSONObject();
		JSONObject tmpObj5 = new JSONObject();
		ArrayList tempArray = new ArrayList();
		ArrayList tempArray2 = new ArrayList();
		
		tmpObj.put("backgroundColor","transparent");
		tmpObj.put("plotBorderWidth",0);
		tmpObj.put("plotShadow",false);
		tempArray.add(3);
		tempArray.add(350);
		tempArray.add(3);
		tempArray.add(10);
		tmpObj.put("margin",tempArray);
		
		tmpObj2.put("load","function () {this.legend.allItems.legendGroup.attr({ translateX: 100});}");
		rootJson.put("chart",tmpObj);
		tmpObj = new JSONObject();
		tmpObj2 = new JSONObject();
		tempArray = new ArrayList();
		tmpObj.put("useHTML",true);
		//tmpObj.put("formatter","function(){return this.point.name + \": <b>\" + this.y + \" ms </b>(\" + Highcharts.numberFormat(this.percentage, 2) + \" %) \";}");
		tmpObj.put("formatter","function(){return '<span style=\"font-family:Arial !important\">'+this.point.name + \": <b style='font-weight:bold !important'>\" + this.y + \" ms </b>(\" + Highcharts.numberFormat(this.percentage, 2) + \" %) \"+'</span>';}");
		rootJson.put("tooltip",tmpObj);
		tmpObj = new JSONObject();

		tmpObj2.put("fontSize","10px");
		tmpObj2.put("fontWeight","none");
		if(monitor_Skin.equals("Dark"))
			tmpObj2.put("color","#c6c6c6");
		tmpObj2.put("font","LucidaGrandeRegular !important");
		tmpObj3.put("enabled",true);
		tmpObj3.put("distance",5);
		tmpObj3.put("connectorWidth",1);
		tmpObj3.put("style",tmpObj2);
		tmpObj4.put("dataLabels",tmpObj3);
		tmpObj2 = new JSONObject();
		tmpObj3 = new JSONObject();
		tmpObj2.put("legendItemClick","function(){this.select();chart.tooltip.refresh(this); return false;}");
		tmpObj3.put("events",tmpObj2);
		tmpObj4.put("point",tmpObj3);
		tmpObj4.put("startAngle",90);
		tmpObj4.put("endAngle",450);
		tmpObj4.put("minSize",160);
		if(monitor_Skin.equals("Dark"))
			tmpObj4.put("borderColor","#444444");
		tmpObj5.put("pie",tmpObj4);
		rootJson.put("plotOptions",tmpObj5);
		tmpObj = new JSONObject();
		tmpObj2 = new JSONObject();
		tmpObj3 = new JSONObject();
		tmpObj4 = new JSONObject();
		tmpObj5 = new JSONObject();

		Double totalResponseTime = (Double) pointcutTimeHolder.get("TOTAL_TIME");

		int percentage=100;
		if(pointcutTimeHolder != null && pointcutTimeHolder.size() > 0)
		{
			tmpObj.put("type","pie");
			tmpObj.put("name","Execution Time");
			tmpObj.put("innerSize","58%");
			tmpObj.put("showInLegend",true); 
			tmpObj.put("allowPointSelect",false);
			tmpObj.put("cursor","pointer");
			Set keySet = pointcutTimeHolder.keySet();
			Iterator it = keySet.iterator();
			while(it.hasNext())
			{
				String key = (String) it.next();
				if(!key.equals("TOTAL_TIME"))
				{
					if(key.equals(pointCutSelf))
					{
						tmpObj3.put("name",apmType);
						tmpObj3.put("color",clrSelf);
						tmpObj3.put("legendIndex",1);
					}
					else if(key.equals(pointCutThreadInit))
					{
						tmpObj3.put("name",mappingInfo.getTextDescription("monitor.apmtopology.Async"));
						tmpObj3.put("color",clrAsync);
						tmpObj3.put("legendIndex",2);
					}
					else
					{
						tmpObj3.put("name",mappingInfo.getTextDescription("monitor.apmtopology."+key));
						if(key.equals(pointCutSAP))
						{
							tmpObj3.put("color",clrSapjco);
							tmpObj3.put("legendIndex",6);
						}else if(key.equals(pointCutREDIS))
						{
							tmpObj3.put("color",clrRedis);
							tmpObj3.put("legendIndex",3);
						}
						/*else if(key.equals(pointCutException))
						{
							tmpObj3.put("color",clrException);
							tmpObj3.put("legendIndex",8);
						}*/
						else if(key.equals(pointCutJMS))
						{
							tmpObj3.put("color",clrJms);
							tmpObj3.put("legendIndex",3);
						}
						else if(key.equals(pointCutHTTP))
						{
							tmpObj3.put("color",clrHttp);
							tmpObj3.put("legendIndex",4);
						}
						else if(key.equals(pointCutWebService))
						{
							tmpObj3.put("color",clrWebservice);
							tmpObj3.put("legendIndex",5);
						}
						else if(key.equals(pointCutSQL) || key.equals(pointCutMONGO))
						{
							tmpObj3.put("color",clrSql);
							tmpObj3.put("legendIndex",7);
						}
						else if(key.equals(pointCutCustomJolt))
						{
							tmpObj3.put("color",clrCustomJolt);
							tmpObj3.put("legendIndex",9);
						}
						else if(key.equals(pointCutRMI))
						{
							tmpObj3.put("color",clrRmi);
							tmpObj3.put("legendIndex",10);
						}
						else if(key.equals(pointCutEMAIL))
						{
							tmpObj3.put("color",clrEmail);
							tmpObj3.put("legendIndex",11);
						}
						else if(key.equals(pointCutLDAP))
						{
							tmpObj3.put("color",clrLdap);
							tmpObj3.put("legendIndex",12);
						}
						else if(key.equals(pointCutRuntime))
						{
							tmpObj3.put("color",clrRuntime);
							tmpObj3.put("legendIndex",13);
						}
						else if(key.equals(pointCutEJB))
						{
							tmpObj3.put("color",clrEjb);
							tmpObj3.put("legendIndex",13);
						}
					}
					tmpObj3.put("y",pointcutTimeHolder.get(key));
					tmpObj2.put("enabled",true);

					//int roundInt = (int) Math.round((Double)pointcutTimeHolder.get(key)/(totalResponseTime)*100);
					/*if(percentage>roundInt)
					{
						tmpObj2.put("formatter","function(){return ((this.point.percentage > 0.9 ?"+roundInt+"  + \" % \" : null) );}");
						percentage = percentage-roundInt;
					}
					else
					{
						tmpObj2.put("formatter","function(){return ((this.point.percentage > 0.9 ?"+percentage+"  + \" % \" : null) );}");
					}*/

					//tmpObj2.put("formatter","function(){return ((this.point.percentage > 0.9 ? Highcharts.numberFormat(this.point.percentage, 1) + \" % \" : null) );}");
					tmpObj2.put("formatter","function(){return '<span style=\"font-family:Arial !important; font-size:11px !important\">'+((this.point.percentage > 0.9 ? Highcharts.numberFormat(this.point.percentage, 1) + \" % \" : \"< 1 %\") )+'</span>';}");
					tmpObj3.put("dataLabels",tmpObj2);
					tempArray.add(tmpObj3);
					tmpObj3 = new JSONObject();
				}
			}
			tmpObj.put("data",tempArray);
			tempArray2.add(tmpObj);

			rootJson.put("series",tempArray2);
			tmpObj = new JSONObject();
			tmpObj2 = new JSONObject();
			tmpObj3 = new JSONObject();
			tmpObj4 = new JSONObject();
			tempArray = new ArrayList();

			tmpObj.put("enabled",false);
			tmpObj.put("href","");
			tmpObj2.put("align","right");
			tmpObj2.put("x",-50);
			tmpObj2.put("verticalAlign","bottom");
			tmpObj.put("position",tmpObj2);
			//tmpObj.put("text",fastQueryText);
			//rootJson.put("exporting",tmpObj);
			rootJson.put("credits",tmpObj);
			tmpObj = new JSONObject();
			tmpObj2 = new JSONObject();

			tmpObj.put("enabled",false);
			rootJson.put("exporting",tmpObj);
			tmpObj = new JSONObject();

			tmpObj.put("text","");
			rootJson.put("title",tmpObj);
			tmpObj = new JSONObject();

			tmpObj.put("width",320);
			tmpObj.put("align","right");
			tmpObj.put("layout","horizontal");
			tmpObj.put("borderWidth",0);
			tmpObj.put("x",0);

			tmpObj.put("itemWidth",150);
			tmpObj.put("maxHeight","100%");
			tmpObj.put("itemDistance",10);
			tmpObj.put("itemMarginTop",4);
			tmpObj.put("itemMarginBottom",4);
			tmpObj.put("verticalAlign","middle");
			tmpObj.put("symbolHeight",11);
			tmpObj.put("symbolWidth",11);
			tmpObj.put("symbolRadius",10); 
			tmpObj.put("symbolPadding",10); 
			//tmpObj2.put("fontSize","12px");
			tmpObj2.put("fontWeight","Normal");
			if(monitor_Skin.equals("Dark"))
			{
				tmpObj2.put("color","#c6c6c6");
				tmpObj.put("itemHoverStyle",tmpObj2);
			}
			tmpObj2.put("font"," 11px Arial !important");
			tmpObj.put("itemStyle",tmpObj2);
			rootJson.put("legend",tmpObj);
			tmpObj = new JSONObject();
			tmpObj2 = new JSONObject();
		}
		return rootJson;
	}
%>
<html>
<head>
<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >
<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>

<script  src="/final/jquery/jquery.js"></script>

<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>

<egui:skin ui="monitor"/>

<style media="all" rel="Stylesheet" type="text/css">
/*.x-tip .x-tip-body,
.x-tip .x-form-invalid-tip-body,
.x-tip.yellowTip .x-tip-body,
.x-tip.yellowTip .x-form-invalid-tip-body {
    white-space: nowrap !important;
	width:auto !important;
}

.x-tip.yellowTip.para .x-tip-body{

}*/

.folder { background:url('/final/images/Light/eG_Icons.png') no-repeat top left; padding-right: 3px; margin-left: 0px; !important; background-position:0 -1340px;width:16px;height:16px;display:block;float:left}

.doc {background:url('/final/images/Light/eG_Icons.png') no-repeat top left; background-position:0 -1360px;width:16px;height:16px;border:0px solid green; padding-right: 3px; margin-left: 0px; ! important;}

.x-splitter-horizontal{
	background:transparent none !important;
	height:8px !important;
	padding:0px;
	margin:0px;
	border:none !important;
}

.x-splitter-horizontal .x-layout-split-top
{
height:8px !important;
width:52px !important;
}
</style>
<title>Call Graph</title>


<script>
var $j = jQuery.noConflict();

function myFunction() {

	var gettingParentId = parent.document.getElementById('centerContentPane');

	var gettingWidth = gettingParentId.clientWidth;
	var gettingHeight = gettingParentId.clientHeight;//-($j('#chart2StackedBar2DContainerBTM').height+40);

	var gettingTopChartId = document.getElementById('chart2StackedBar2DContainerBTM');

	if (gettingTopChartId != null && gettingTopChartId != undefined)
	{
		var minusHeight = gettingTopChartId.clientHeight+72;
	}

	//$j("#callgraph").width(gettingWidth-15);
	//$j("#callgraph").height(gettingHeight-minusHeight);

	//var contentPaneTitle2 = document.getElementById('contentPaneTitleDiv2').innerHTML;

	//if(contentPaneTitle2.length>1)
		//$j("#callGraphNoData").height(gettingHeight-60);
	//else
		//$j("#callGraphNoData").height(gettingHeight-44);

	//$j("#btmExecutionAnalysisTable").freezeHeader({ 'height': (gettingHeight-minusHeight)+"px" });

	$j("#btmExecutionAnalysisTable > tbody > tr").click(function(){
		$j('#btmExecutionAnalysisTable > tbody > tr').removeClass("activeTr");
		$j(this).addClass("activeTr");
	});
}

$j(document).ready(function(){
	myFunction();
});
$j( window ).resize(function() {
	myFunction();
});

/*********** JTM Tree-Table Scripts (Begins) ****************************/ 

function array_contains(obj)
{
	for (var i = 0; i < this.length; i++){
		if (this[i] == obj) return i;
	}
	return -1;
}
Array.prototype.contains = array_contains;

function array_remove(obj)
{
	var index = this.contains(obj);
	if(index > -1)
		this.splice(index, 1);
}
Array.prototype.remove = array_remove;

// using this function ensure that you won't add an element which already exists in the array
function array_add(obj)
{
	var index = this.contains(obj);
	if(index == -1)
		this.push(obj);
}
Array.prototype.add = array_add;

function array_to_string()
{
	var result = '';
	for (var i = 0; i < this.length; i++)
	{
		result += this[i] + " ; ";
	}
	return result;
}
Array.prototype.to_string = array_to_string;

var open_nodes = new Array();
var FOLDER_CLSD_PIC = "/final/images/Light/eG_Icons.png";
var FOLDER_OPEN_PIC = "/final/images/Light/eG_Icons.png";
//var DOC_PIC = "/final/images/icon_doc_sml.gif";
var normalColor = 'eg_whitebg';
var highlightColor = 'eg_lightlight';
var RE_PATH = "[0-9]+"; 
var TREE_PATH_SEP  = '.';

// This method should be called when a click occurs on the folder icon (or something equivalent!)
// e is the event and elm is the element on which the event occured
function toggleRows(e, elm, rowid)
{
	// first we check if we moved the mouse during the click as it signifies that it is a dnd and not a click
	if(mouseMoved(e))
		return;
	var id = rowid; // the id of the row we are toggling (it contains the path)
	var toggledRow = document.getElementById(rowid);
	if(toggledRow == null)
		return;
	var name = toggledRow.getAttribute('name');
	var parentTable = document.getElementById("btmExecutionAnalysisTable");
	var rows = parentTable.rows;
	// regular expression representing the id of the children of toggledRow
	var idToggledRE = id.slice(0, id.length) + RE_PATH;
	if(open_nodes.contains(name) > -1) // the element was opened -> closing
	{
		//elm.style.className = "url("+FOLDER_CLSD_PIC+")";
		//$j(elm).attr("class", "doc");
		$j(elm).addClass('doc');
		for (var i = 0; i < rows.length; i++)
		{
			var currentRow = rows[i];
			if (matchStart(currentRow.id, idToggledRE, false)) // if currentRow is a child of toggledRow
			{
				currentRow.style.display = "none";
			}
		}
		open_nodes.remove(name);
	}
	else // opening
	{
		$j(elm).removeClass('doc');
		// trick to avoid a problem of display after a restore when a folder become a doc as he is empty
		if(elm.getAttribute("class") !=null && elm.getAttribute("class") != 'folder'){
			open_nodes.remove(name);
			return;
		}
		//elm.style.backgroundImage = "url("+FOLDER_OPEN_PIC+")";
		//elm.style.className = "url("+FOLDER_OPEN_PIC+")";
		for (var i = 0; i < rows.length; i++)
		{
			var currentRow = rows[i];
			var currentIconLink = currentRow.getElementsByTagName("A")[0];
			if (matchStart(currentRow.id, idToggledRE, true)) // if currentRow is a child of toggledRow
			{
				//if (document.all)
				currentRow.style.display = "block"; //IE4+ specific code
				//else
				currentRow.style.display = "table-row";

				// this is just to be sure that we have the right icon (maybe not necessary)
				//if(currentIconLink.getAttribute("class") != 'folder')
				//currentIconLink.style.backgroundImage = "url("+DOC_PIC+")";

				// reopen the rows which where already opened 
				if (open_nodes.contains(currentRow.getAttribute('name')) > -1)
				{
					open_nodes.remove(currentRow.getAttribute('name'));
					toggleRows(null, currentIconLink , currentRow.id);
				}
			}
		}
		open_nodes.add(name);
	//	$j(elm).removeClass('doc').addClass('folder')
	}
	// ignore the selectRow event as it was a toggling event
	ignoreSelectRowEvt = true;
}

// pattern is a string containing a regular expression without the '/' at the beginning and the end
// returns true if target begin with pattern, false else. Moreover if matchDirectChildrenOnly=true
// we return false if the target is not a direct child.
function matchStart(target, pattern, matchDirectChildrenOnly)
{
	var patternObj = eval("/^"+pattern+"/");
	if (!target.match(patternObj)) return false;
	if (!matchDirectChildrenOnly) return true;
	var extendedPattern = eval("/^"+pattern+"["+TREE_PATH_SEP+"]"+RE_PATH+"/");
	if (target.match(extendedPattern)) return false;
	return true;
}

function collapseAllRows()
{
	var rows = document.getElementsByTagName("TR");
	var pattern = eval("/^[0-9]+["+TREE_PATH_SEP+"]"+RE_PATH+"/");
	var patternFirstLevel = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
	for (var j = 0; j < rows.length; j++)
	{
		var r = rows[j];
		if (r.id.match(pattern))
		{
			r.style.display = "none";
			if(r.getElementsByTagName("A")[0].getAttribute('class')=='folder')
				r.getElementsByTagName("A")[0].style.backgroundImage = "url("+FOLDER_CLSD_PIC+")";
		//	else 
			//	r.getElementsByTagName("A")[0].style.backgroundImage = "url("+DOC_PIC+")";

		}
		else if (r.id.match(patternFirstLevel))
		{
			r.getElementsByTagName("A")[0].style.backgroundImage = "url("+FOLDER_CLSD_PIC+")";
		}
	}
	open_nodes = new Array();
}


function highLightRows(methodname)
{
	var divObj = document.getElementById("btmExecutionAnalysisTable");
	var rows = divObj.getElementsByTagName("TR");
	if(methodname!=null)
	{
		var first = 0;
		for (var i = 0; i < rows.length; i++)
		{
			var r = rows[i];
			var title = r.title;
			if(title.length > 0 && title == methodname)
			{
				r.className = 'trhover';
				if(first == 0)
				{
					var rowName = $j(rows[i]).attr('name');
					var rowno = parseInt(rowName.substring(1));
					var topvalue = rowno * r.offsetHeight; 
					first = 1;
				}
			}
		}
	}
}

function openAllRows(methodname)
{
	var divObj = document.getElementById("btmExecutionAnalysisTable");
	if(divObj != null){
		var rows = divObj.getElementsByTagName("TR");
		var pattern = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]/");
		var patternFirstLevel = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
		var firstLevelRows = new Array();
		open_nodes = new Array();
		for (var i = 0; i < rows.length; i++)
		{
			var r = rows[i];
			
			if (r.id.match(patternFirstLevel))
			{
				firstLevelRows.push(r);
				open_nodes.add(r.getAttribute('name'));
			}
			else if (r.id.match(pattern))
			{
				open_nodes.add(r.getAttribute('name'));
			}
		}
		for (var j = 0; j < firstLevelRows.length; j++)
			toggleRows(null,firstLevelRows[j].getElementsByTagName("A")[0], firstLevelRows.id);
		highLightRows(methodname);
	}
}

// restore the state of the tree depending on open_nodes
// take all the nodes of first level and for each reopen or close it depending on 
// the open_nodes list. Moreover we call toggleRows to restore the state of the children nodes.
function restore()
{
	var rows = document.getElementsByTagName("TR");
	var pattern = eval("/^"+RE_PATH+"["+TREE_PATH_SEP+"]$/");
	for (var j = 0; j < rows.length; j++)
	{
		var r = rows[j];
		if (r.id.match(pattern)) // first level 
		{
			// as toggleRows() will check open_nodes to know wheter it has to open or close the node, 
			// we have to do the opposite before because we just want to restore the state and not to really toggle it
			if (open_nodes.contains(r.getAttribute('name')) > -1)
				open_nodes.remove(r.getAttribute('name'));
			else
				open_nodes.add(r.getAttribute('name'));
			toggleRows(null, r.getElementsByTagName("A")[0]);
		}
	}
}

// This method should be used with an onclick event for your tables rows (TR)
// in order to have them visually selected
var selectedRow;
var ignoreSelectRowEvt = false; // set this variable to true if you want to ignore the next selectRow event
function selectRow(row , method)
{
	if(ignoreSelectRowEvt)
	{
		ignoreSelectRowEvt = false;
		return;
	}
	if(selectedRow)
		selectedRow.className = normalColor;
	// if we are deselecting
	if(selectedRow && selectedRow.id == row.id)
	{
		selectedRow = null;
	}
	else
	{
		selectedRow = row;
		row.className = highlightColor;
	}
	if(row.title == method)
		row.className = 'trhover';
}

var clicX = 0;
var clicY = 0;
function storeMouseXY(e)
{
	if (!e) var e = window.event; 
	if (e.pageX || e.pageY)
	{
		clicX = e.pageX;
		clicY = e.pageY;
	}
	else if (e.clientX || e.clientY)
	{
		clicX = e.clientX + document.body.scrollLeft;
		clicY = e.clientY + document.body.scrollTop;
	}
}

// return true if the mouse moved more than 3 pixels in one direction between the beginning
// of the event and the end of the envent
// WARNING : in order to use this method you should use onmousedown="storeMouseXY(event); in the 
// element where is called mouseMoved...
function mouseMoved(e)
{
	if(e)
	{
		var oldx = clicX, oldy = clicY;
		storeMouseXY(e);
		if(Math.abs(clicX-oldx) > 3 || Math.abs(clicY-oldy) > 3)
			return true;
	}
	return false;
}
/*********** JTM Tree-Table Scripts (Begins) ****************************/ 

// Pop Up div for SQL and EXCEPTION starts here
function showQueryDiv(index , subCompType, me)
{
	if(index == null) 	index = '-1';
	//var containerTop = $j('#callGraphDetails').offset().top;
	//var containerLeft = $j('#callGraphDetails').offset().left;
	var containerTop = $j('#callGraphDetailsPanelId').offset().top;
	var containerLeft = $j('#callGraphDetailsPanelId').offset().left;
	var pos = $j(me).offset();
	//console.log(pos);
	//var bottom = pos.top + containerTop - 260;
	var bottom = pos.top - 270;
	var left = pos.left + 150;
	if(subCompType == 'sql' || subCompType == 'mongodb')
	{
		window.parent.showQueryDiv(index, subCompType, left, bottom);
	}
	else if(subCompType == 'exception')
	{
		window.parent.showErrorDiv(index, subCompType, left, bottom);
	}
}
// Pop Up div for SQL and EXCEPTION ends here

// Pop up div for HTTP, WEBSERVICE, JMS, SAP + Other PointCuts(RMI) starts here
function showWebDiv(nodeIndex, type, nodeCount, me){
	//var pos = $j(me).position();
	//var containerTop = $j('#callGraphDetails').offset().top;
	//var containerLeft = $j('#callGraphDetails').offset().left;
	var containerTop = $j('#callGraphDetailsPanelId').offset().top;
	var containerLeft = $j('#callGraphDetailsPanelId').offset().left;
	var pos = $j(me).offset();
	//console.log(pos);
	//var bottom = pos.top + containerTop - 260;
	var bottom = pos.top - 120;
	var left = pos.left + 150;
	if(type == 'http')
	{
		window.parent.showHttpDiv(nodeIndex, type, nodeCount, left, bottom);
	}
	else if(type == 'webservice')
	{
		window.parent.showWebserviceDiv(nodeIndex, type, nodeCount, left, bottom);
	}
	else if(type == 'jms')
	{
		window.parent.showJmsDiv(nodeIndex, type, nodeCount, left, bottom);
	}
	else if(type == 'ejb')
	{
		window.parent.showEjbDiv(nodeIndex, type, nodeCount, left, bottom);
	}
	//else if(type == 'rmi')
	else if((type.indexOf("_OtherPointCut") > -1)) // For RMI,Email, Runtime
	{
		type = type.substring(0, (type.indexOf('_')));
		window.parent.showOtherPointCutDiv(nodeIndex, type, nodeCount, left, bottom);
	}
	else if(type == 'sap jco')
	{
		bottom = pos.top - 150;
		window.parent.showSapDiv(nodeIndex, type, nodeCount, left, bottom);
	}else if(type == 'redis')
	{
	
		window.parent.showRedisDiv(nodeIndex, type, nodeCount, left, bottom);
	}
}
// Pop up div for HTTP, WEBSERVICE, JMS, SAP ends here

// New Async window function starts here
function showAsyncDiv(asynGuid,timeString){
	window.parent.showAsyncDiv(asynGuid);
}
// New Async window function ends here

// This function is to set title for the call graph page
function callGraphTitleSet(title){
	window.parent.callGraphTitleSet(title);
}
window.document.onclick=function()
{
	window.parent.framebodyClickCall('<%=request.getParameter("currentWindowId")%>');
}

</script>
</head>
<%
	response.setContentType("text/html;charset=UTF-8");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	JSONObject rootJson = new JSONObject();
	JSONArray gridArr = new JSONArray();
	Hashtable pointcutTimeHolder = new Hashtable();
	//ArrayList connectedNodes = new ArrayList();
	String testName = request.getParameter("testName");
	String apmType = apm.getAPMType(testName);
	String nodeOrder = request.getParameter("nodeOrder");
	nodeOrder = StringUtils.decodeSecurityChar(nodeOrder);
	ArrayList TraceList = (ArrayList) session.getAttribute("TraceData"+"#"+nodeOrder);
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	boolean isPartialGraph = false;
	if(TraceList != null && TraceList.size()>0)
	{
		String rootNode = (String) TraceList.get(0);
		if(rootNode.startsWith("0#="))
		{
			isPartialGraph = false;
		}
		else
		{
			isPartialGraph = true;
		}
	}
	ArrayList DataListDetails = (ArrayList) session.getAttribute("SummaryData");
	Hashtable externalTableDetails = (Hashtable) session.getAttribute("ExternalData");
	//Hashtable nodeConnectionDetails = (Hashtable) session.getAttribute("NodeConnectionDetails");

	//if(nodeConnectionDetails != null)
		//connectedNodes = (ArrayList) nodeConnectionDetails.get(nodeOrder);
	
	String externalTableKey = null;

	Hashtable nodeTable = (Hashtable) DataListDetails.get(0);
	boolean asyncTrace = false;

	boolean isThreadRequest = false;
	if(nodeOrder.indexOf(".")>-1)
	{
		if(nodeOrder.indexOf(".A")>0)
		{
			String nodeOrderCheck = nodeOrder.substring(0,nodeOrder.lastIndexOf("."));
			if(nodeOrderCheck.endsWith(".A"))
				isThreadRequest = true;
		}
	}

	String egGuid = null;

	ArrayList DataList = new ArrayList();
	if(nodeTable != null)
	{
		egGuid = request.getParameter("EG_GUID");
		DataList = (ArrayList) nodeTable.get(egGuid+"#"+nodeOrder);
	}
	
	if(isThreadRequest){
		externalTableKey = egGuid+"#"+nodeOrder+"#Thread";
		asyncTrace = true;
	} else {
		externalTableKey = egGuid+"#"+nodeOrder+"#Web";
	}
	
	String methodName= request.getParameter("mname");

	if(methodName!=null && methodName.trim().length() >0)
		methodName = com.egurkha.util.StringUtils.encodeSecurityChar(methodName);

	if(methodName == null)
		methodName = "";

	boolean isOtherPointCut = false;
	String requestedURI = null;
	double responseTime = 0.0;
	String timeString = "";
	ArrayList idexList = new ArrayList();

	String contentPaneTitle1 = mappingInfo.getTextDescription("monitor.apmtopology.Call Graph");
	String contentPaneTitle2 = ""; 
	//System.out.println("DataList result is : "+DataList);
	if(DataList != null && DataList.size()>0)
	{
		String targetHost = (String) DataList.get(0);
		String portNo = (String) DataList.get(1);
		Object requestedTime = DataList.get(7);
		Object targetServerTimeZone = DataList.get(8);
		requestedURI = (String)DataList.get(9);
		responseTime = ((BigDecimal)DataList.get(11)).doubleValue();
		String compTypeFromNickPort = discInfo.getServerTypesForComponentNamePort(targetHost+":"+portNo);
		String managerTimeFormat = DateUtil.changeDateFormat(requestedTime.toString(),"yyyy-MM-dd HH:mm:ss",currentDateFormat+" HH:mm:ss")+" "+targetServerTimeZone;

		
		contentPaneTitle2 = "for the request "+requestedURI+ " on "+targetHost+":"+portNo+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")  at "+managerTimeFormat;
		if(portNo != null && portNo.equals("NULL"))
			contentPaneTitle2 = "for the request "+requestedURI+ " on "+targetHost+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")  at "+managerTimeFormat;
		if(asyncTrace)
		{
			contentPaneTitle1 = mappingInfo.getTextDescription("monitor.apmtopology.Async Call");
			contentPaneTitle2 = "from "+requestedURI+ " on "+targetHost+":"+portNo+" at "+managerTimeFormat;
			if(portNo != null && portNo.equals("NULL"))
				contentPaneTitle2 = "from "+requestedURI+ " on "+targetHost+" at "+managerTimeFormat;
		}
		
		//pointcutTimeHolder.put("OTHER_DETAILS",targetHost+":"+portNo);
		pointcutTimeHolder.put("TOTAL_TIME",responseTime);
		for(int k=0;k<TraceList.size();k++)
		{
			String nodeToken = (String)TraceList.get(k);
			ArrayList nodeDetailsList = StringUtils.egTokenizer(nodeToken, nodeDetailsDelim, false,false,true);

			int countTokens = nodeDetailsList.size();
			if(countTokens == 5)
			{
				String idxStr = (String)nodeDetailsList.get(0);
				int idexLength = idxStr.length();
				if(idexLength > 1){
					String subidexStr = idxStr.substring(0, idxStr.lastIndexOf("."));
					idexList.add(subidexStr);
				}

				// Data compute for bar chart - START
				String pointcut = (String) nodeDetailsList.get(4);
				if(pointcut.equals("HTTPStream") || pointcut.equals("HttpConn")){
					pointcut = pointCutHTTP;
				}
				String childPointCut = apm.changeChildPointcutTime(pointcut);
				if (childPointCut != null && childPointCut.length() > 0) {
					pointcut = childPointCut;
				}
				
				isOtherPointCut = apm.isPointCutInIni(testName,pointcut);

				if(!pointcut.equals(pointCutWebService) && !pointcut.equals(pointCutHTTP) && !pointcut.equals(pointCutSQL) && !pointcut.equals(pointCutJMS) && !pointcut.equals(pointCutSAP) && !pointcut.equals(pointCutThreadInit) && !pointcut.equals(pointCutCustomJolt) && !pointcut.equals(pointCutRuntime) && !isOtherPointCut && !pointcut.equals(pointCutEJB) && !pointcut.equals(pointCutMONGO) && !pointcut.equals(pointCutREDIS)&&!pointcut.startsWith("Custom_"))
					pointcut = pointCutSelf;
				double selfExecTime = Double.parseDouble((String) nodeDetailsList.get(2));
				if(pointcut.startsWith("Custom_"))
				{
					pointcut =pointcut.substring(pointcut.indexOf("_")+1);
				}
				if(pointcutTimeHolder.containsKey(pointcut))
				{
					double previousTime = (Double)pointcutTimeHolder.get(pointcut);
					double cumulativeTime = previousTime+selfExecTime;
					pointcutTimeHolder.put(pointcut,cumulativeTime);
				}
				else
				{
					pointcutTimeHolder.put(pointcut,selfExecTime);
				}
				// Data compute for bar chart - END
			}
		}
		timeString = nodeOrder+"-"+pointcutTimeHolder.get(pointCutSelf);
%>

<body>


<%
	}
	boolean dataPresent = false;
	if(TraceList!=null && TraceList.size() > 0 && !isPartialGraph)
	{
		String first = (String) TraceList.get(0);
		if(first.equals("-")){
			dataPresent = false;
		}
		else{
			dataPresent = true;
		}
	}

	
%>
<div id="headerDivId">
	<div class="btmExecutionAnalysisHeader" style="padding:3px 0px 0px 5px"><%=contentPaneTitle1%></div>
	<div class="btmExecutionAnalysisSubHeadDiv" id="contentPaneTitleDiv2" data-qclass='yellowTip para' data-qtip="<%=contentPaneTitle2%>"><%=contentPaneTitle2%></div> 
</div>
<%
	// If data for stacktrace exists, then if loop executes
	if(dataPresent)
	{
		
%>
<div id="donutChartContainer" class="" style="">
	<div id="chart2StackedBar2DContainerBTM" class="" style="width:670px; height: 154px;margin:0px auto"></div>
	<script type="text/javascript">
		var jsonData = <%=chartJsonBuild(pointcutTimeHolder, mappingInfo, monitor_Skin, mappingInfo.getTextDescription("monitor.apmtopology."+apmType))%> ;
		$j('#chart2StackedBar2DContainerBTM').highcharts(jsonData); 
	</script>
</div>


<div id="callGraphDetails"  class="" style="height:100%;width:100%;float:left;display:block;">
	<table name="mainTable" id="btmExecutionAnalysisTable" cellpadding="0px" cellspacing="0px" style="table-layout:auto;width:100%">
	<thead>
		<tr>
			<th class="btmCallType" id="btmCallType"><div><egui:intnl text='monitor.apmtopology.Call Type'/></div></th>
			<th class="btmRequestProcessing" id="btmRequestProcessing"><div><egui:intnl text='monitor.apmtopology.Request Processing'/></div></th>
			<th class="btmSelfExecutionTime" id="btmSelfExecutionTime"><div><egui:intnl text='monitor.apmtopology.Self Execution Time'/><span style='text-transform:none'> (ms)</span></div></th>
			<th class="btmTotalExecutionTime" id="btmTotalExecutionTime"><div><egui:intnl text='monitor.apmtopology.Total Execution Time'/><span style='text-transform:none'> (ms)</span></div></th> 
			<th class="btmTraceDetails" id="btmTraceDetails"><div><egui:intnl text='monitor.apmtopology.Trace Details'/></div></th> 
		</tr>
	</thead>
	<tbody >
<%

		int nodeCount = 0;
		String grayImage = "/final/monitor/eg_images/cpu_usuage.gif";

		// This loop prepares stacktrace table data.
		for(int k=0;k<TraceList.size();k++)
		{
			String nodeToken = (String)TraceList.get(k);
			ArrayList nodeDetailsList = StringUtils.egTokenizer(nodeToken, nodeDetailsDelim, false,false,true);
			int countTokens = nodeDetailsList.size();
			if(countTokens == 5)
			{
				String idxStr = (String)nodeDetailsList.get(0);
				String execTimeStr = (String)nodeDetailsList.get(1);
				String exclTimeStr = (String)nodeDetailsList.get(2);
				String nodeMethod = (String)nodeDetailsList.get(3);
				String subCompType = (String)nodeDetailsList.get(4);
				String orgSubCompType = subCompType;
				subCompType = subCompType.toLowerCase();
				isOtherPointCut = apm.isPointCutInIni(testName,subCompType);
				
				boolean isEjbPointCutHavePopupDetails = false;
				if (subCompType.startsWith("ejb")) {
					if (externalTableDetails != null) {
						Hashtable exitPointcutDetails = (Hashtable) externalTableDetails.get(externalTableKey);
						if (exitPointcutDetails != null &&  exitPointcutDetails.containsKey(idxStr)) {
							isEjbPointCutHavePopupDetails = true;
						}
					}
				}

				// Async Call Link
				String asyncGUID = "";
				int asyncIndex = nodeMethod.indexOf("[ASYNC]-");
				if(subCompType.equals("thread_init") && asyncIndex > 0){
					asyncGUID = nodeMethod.substring(asyncIndex + 8);
					nodeMethod = nodeMethod.substring(0, asyncIndex);
				}
				double exec_time = Double.parseDouble(execTimeStr);
				double excl_time = Double.parseDouble(exclTimeStr);

				// Gray bar Calculation
				double percentage = 0.0;
				try{
					percentage = (excl_time / responseTime) * 100.0;
				}
				catch(Exception exc)
				{
					System.err.println("Exception occured in eGBTMTrace Page "+exc.getMessage());
				}

				//Formatting of Double Values
				if(Double.isNaN(percentage) || Double.isInfinite(percentage))
				{
					percentage = 0.0;
				}
				String grayImgWidth = Math.round(percentage)+"%";

				String rowName = "r"+(k+1);
				String dispIdx = idxStr + ".";
				StringTokenizer mytokenizer = new StringTokenizer(idxStr, ".");
				int countTok = mytokenizer.countTokens();
				int tierClass = countTok - 1;
				int margin_left  = tierClass * 1 * 20;

				String aClass = "folder";
				if(idexList.contains(idxStr))
					aClass = "folder";
				else
					aClass = "doc";

%>
	<tr id="<%=dispIdx%>" name="<%=rowName%>">
			<td align="left" wrap headers="btmCallType">
<%
				String iconType = subCompType;
				if(subCompType.equalsIgnoreCase("custom_jolt"))
					iconType = "custom";
				else if(subCompType.indexOf("custom_")>-1){
					iconType = "custom";
				}
				else if(subCompType.indexOf("thread_init")>-1){
					iconType = "thread";
				}
				else if(subCompType.indexOf("thread_join")>-1){
					iconType = "thread";
					subCompType = iconType;
				}
				else if(subCompType.indexOf("httpservlet")>-1){
					iconType = "genericservlet";
					subCompType = iconType;
				}
				else if(subCompType.indexOf("springdispatcher")>-1 || subCompType.indexOf("springrender")>-1){
					iconType = "spring";
					subCompType = iconType;
				}
				else if(subCompType.indexOf("jsfrender")>-1){
					iconType = "jsf";
					subCompType = iconType;
				}else if(subCompType.equalsIgnoreCase("mule") || subCompType.equalsIgnoreCase("webservice_entry"))
				{
					iconType = "pojo";
				}else if(subCompType.equalsIgnoreCase("sql"))
				{
					isSQLPresent = true  ;
				}

				if(subCompType.equalsIgnoreCase("sql") || subCompType.equalsIgnoreCase("mongodb"))
				{ 
%>
				<span style="background:<%=clrSql%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showQueryDiv('<%=idxStr%>','<%=subCompType%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}else if(subCompType.equalsIgnoreCase("redis"))
				{
%>
				<span style="background:<%=clrSapjco%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}
				else if(subCompType.equalsIgnoreCase("exception"))
				{
%>
				<span style="background:<%=clrException%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showQueryDiv('<%=idxStr%>','<%=subCompType%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}
				else if(subCompType.equalsIgnoreCase("sap jco"))
				{
%>
				<span style="background:<%=clrSapjco%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}
				else if(subCompType.equalsIgnoreCase("http") || subCompType.equalsIgnoreCase("webservice") || subCompType.equalsIgnoreCase("jms") )
				{
					if(subCompType.equalsIgnoreCase("http"))
					{
						/*int nodeToSend = 0;
						try
						{
							if(connectedNodes != null && connectedNodes.size()>nodeCount)
							{
								String node = (String) connectedNodes.get(nodeCount);
								nodeToSend = Integer.parseInt(node.substring(node.lastIndexOf(".")+1));
							}
						}
						catch(Exception e)
						{
							e.printStackTrace();
							System.out.println("Error while computing the connected node");
						}
						nodeCount++;*/
					
%>
				<span style="background:<%=clrHttp%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
					else if(subCompType.equalsIgnoreCase("webservice"))
					{
%>
				<span style="background:<%=clrWebservice%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>

<%
					}
					else if(subCompType.equalsIgnoreCase("jms"))
					{
%>
				<span style="background:<%=clrJms%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
				}
				else if(subCompType.equalsIgnoreCase("thread_init") && asyncGUID.length() > 0)
				{
%>
				<span style="background:<%=clrAsync%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showAsyncDiv('<%=asyncGUID%>','<%=timeString%>');"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology.Async")%>"> <egui:intnl text='monitor.apmtopology.Async'/></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}
				else if (subCompType.equalsIgnoreCase("custom_jolt"))
				{
%>
				<span style="background:<%=clrCustomJolt%>;padding:7px 3px 7px 4px"></span><span style="padding:3px 5px 0px 5px"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology.Custom_JOLT")%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology.Custom_JOLT")%></span></span>
<%
				}
				else if (subCompType.equalsIgnoreCase("runtime")) {
%>
					<span style="background:<%=clrRuntime%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType+"_OtherPointCut"%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
				}
				else if (subCompType.equalsIgnoreCase("EJB"))
				{
					if (isEjbPointCutHavePopupDetails) {
%>
						<span style="background:<%=clrEjb%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
					else {
%>
						<span style="background:<%=clrEjb%>;padding:7px 3px 7px 4px"></span><span style="padding:3px 5px 0px 5px"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span></span>
<%
					}
				}
				else if (isOtherPointCut)
				{
					if (subCompType.equalsIgnoreCase("rmi")) {
%>
					<span style="background:<%=clrRmi%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType+"_OtherPointCut"%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
					else if (subCompType.equalsIgnoreCase("Email")) {
%>
					<span style="background:<%=clrEmail%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType+"_OtherPointCut"%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
					else if (subCompType.equalsIgnoreCase("LDAP")) {
%>
					<span style="background:<%=clrLdap%>;padding:9px 3px 5px 4px"></span><span style="padding:3px 5px 0px 5px"><a href="javascript:void(0);" class="qin_link" onclick="javascript:showWebDiv('<%=idxStr%>' , '<%=subCompType+"_OtherPointCut"%>','<%=nodeCount%>',this);"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%></span><span style="display:inline-block;position:relative;top:4px;left:4px" class='iconDiagnosis'></span></a></span>
<%
					}
				}
				else if(subCompType.equalsIgnoreCase("HTTPStream") || subCompType.equalsIgnoreCase("HttpConn"))
				{
%>
				<span style="background:<%=clrSelf%>;padding:7px 3px 7px 4px"></span><span style="padding:3px 5px 0px 5px"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())%> 
<%				
				}else if(subCompType.startsWith("custom_"))
				{
					String subCompTypeTmp = orgSubCompType.substring(orgSubCompType.indexOf("_")+1);
%>
				<span style="background:<%=clrSelf%>;padding:7px 3px 7px 4px"></span><span style="padding:3px 5px 0px 5px"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+apmType)+" ("+mappingInfo.getTextDescription("monitor.apmtopology."+subCompTypeTmp)+")"%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+apmType)+" ("+mappingInfo.getTextDescription("monitor.apmtopology."+subCompTypeTmp)+")"%></span></span>
<%
				}
				else 
				{
%>
				<span style="background:<%=clrSelf%>;padding:7px 3px 7px 4px"></span><span style="padding:3px 5px 0px 5px"><span data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+apmType)+" ("+mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())+")"%>"> <%=mappingInfo.getTextDescription("monitor.apmtopology."+apmType)+" ("+mappingInfo.getTextDescription("monitor.apmtopology."+subCompType.toUpperCase())+")"%></span></span>
<%
				}

%>
		</td>
		<td align="center" headers="btmRequestProcessing">
			<script>
			var themeColor='<%=monitor_Skin%>';
			/*Ext.onReady(function(){
				new Ext.ToolTip({
					target: '<%=dispIdx%>',
					width:'auto',
					shadow:"sides",
					html: '<%=nodeMethod%>'
				});
				});*/
			</script>
			<div class='btmGraphBg' > 
				<div class="btmGraph" align="center" width="" height="14" style="position:absolute;top:0px;left:0px;text-align:center;width:<%=grayImgWidth%>;height:14px;margin-left:0px;border:0px solid red;" ></div>
				<span style="position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;color:#ffffff" data-qclass='yellowTip para' data-qtip="<%=percentFormat.format(percentage)%>&nbsp;%"><%=percentFormat.format(percentage)%>&nbsp;%</span> 
			</div>
		</td> 
		<td align="left" wrap headers="btmSelfExecutionTime" data-qclass='yellowTip para' data-qtip="<%=scaleDecimalFormat.format(excl_time)%>"><%=scaleDecimalFormat.format(excl_time)%></td>
		<td align="left" wrap headers="btmTotalExecutionTime" data-qclass='yellowTip para' data-qtip="<%=scaleDecimalFormat.format(exec_time)%>"><%=scaleDecimalFormat.format(exec_time)%></td>
		<td align="left" headers="btmTraceDetails">
				<div style='margin-left:<%=margin_left+"px"%>;white-space: nowrap;' nowrap>
					<div style="margin-right:20px;white-space:nowrap">
						<table width="100%" border="0" cellpadding="0" cellspacing="0" >
						<tr>
								<td ><div style="width:20px;height:20px" class="icon_jtm_<%=iconType%>" data-qclass='yellowTip para' data-qtip="<%=mappingInfo.getTextDescription("monitor.apmtopology."+iconType.toUpperCase())%>"></div></td>
								<td width="100%">
<%
				if(aClass.equals("folder"))
				{
%>
									<a href="javascript:void(0);" onclick="toggleRows(event, this, '<%=dispIdx%>');" onmousedown="storeMouseXY(event); return false;" class="<%=aClass%>"> </a><span data-qclass='yellowTip para' data-qtip="<%=nodeMethod%>"> <%=nodeMethod%></span>
<%
				}
				else{
%>
									<a href="javascript:void(0);" class="<%//=aClass%>" style="text-decoration:none"></a><span style="margin-left:4px;" data-qclass='yellowTip para' data-qtip="<%=nodeMethod%>"> <%=nodeMethod%></span>
<%
				}
%>
								</td>
						</tr>
					</table>
					</div>
				</div>
		</td>
	</tr>
<%
			}
		}
%>
	</tbody>
</table>
</div>
<%
	}
	// If data does not exists, then else loop executes.
	else
	{
%>
		<div id="callGraphNoData" style="margin:0px 10px 10px 5px !important;height:100%;width:100%;">
		<table height="100%" width="100%" border="0" class="white_bg">
			<tr>
				<td align="center" valign="middle" class="commonErrorMsgText" > 
					<img src="/final/images/clear.png" align="center" border="0" class="iconInformation"/><br>
					<egui:intnl text='monitor.layermodel.No Call Graph details captured in this transaction! '/>
				</td>
			</tr>
		</table>
	</div>
<%
	}
%>

<script>
	Ext.tip.QuickTipManager.init();

	var t=setTimeout('openAllRows("<%=methodName%>")',0);

	if(!Ext.isEmpty(Ext.get('donutChartContainer')))
	{
		Ext.onReady(function(){
			Ext.create('Ext.container.Viewport', {
			layout: 'fit',
			items: [{
				xtype:'panel',
				flex:1,
				layout:{
					type:'vbox',
					align:'stretch'
				},
				items:[
				{
					xtype:'container',
					height:40,
					contentEl:'headerDivId',
				},{
					xtype:'panel',
					flex:1,
					layout:{
						type:'border'
					},
					items:[
					{
						region: 'north',
						contentEl:'donutChartContainer',
						collapsible: true,
						collapseMode:'mini',
						cls:'btmAppDashboardsTopPanel',
						split: true,
						border: false,
						header:false,
						margin:'0 10 0 5'
					},{
						region: 'center',
						layout:{
							type:'vbox',
							align:'stretch'
						},
						items:[
						{
							xtype:'panel',
							id:'callGraphDetailsPanelId',
							flex:1,
							layout:{
								type:'fit',
								align:'stretch'
							},
							contentEl:'callGraphDetails',
							cls:'btmAppDashboardsTopPanel',
							scroll:true,
							autoScroll:true,
							listeners:{
								afterrender:function(){
									Element.prototype.remove = function() {
										this.parentElement.removeChild(this);
									}
									NodeList.prototype.remove = HTMLCollection.prototype.remove = function() {
										for(var i = this.length - 1; i >= 0; i--) {
											if(this[i] && this[i].parentElement) {
												this[i].parentElement.removeChild(this[i]);
											}
										}
									}
									Ext.get(this.body.id).on('scroll',function(){
										var tooltip = window.parent.document.getElementById('otherDetailsData');
										if(!Ext.isEmpty(tooltip)){
											tooltip.remove();
										}
										var tooltipEjb = window.parent.document.getElementById('ejbData');
										if(!Ext.isEmpty(tooltipEjb)){
											tooltipEjb.remove();
										}

										var tooltipJms = window.parent.document.getElementById('jmsData');
										if(!Ext.isEmpty(tooltipJms)){
											tooltipJms.remove();
										}

										var tooltipHttp = window.parent.document.getElementById('httpData');
										if(!Ext.isEmpty(tooltipHttp)){
											tooltipHttp.remove();
										}

										var tooltipError = window.parent.document.getElementById('errorData');
										if(!Ext.isEmpty(tooltipError)){
											tooltipError.remove();
										}

										var tooltipWebservice = window.parent.document.getElementById('webserviceData');
										if(!Ext.isEmpty(tooltipWebservice)){
											tooltipWebservice.remove();
										}

										var tooltipPreview = window.parent.document.getElementById('previewData');
										if(!Ext.isEmpty(tooltipPreview)){
											tooltipPreview.remove();
										}

										var tooltipSap = window.parent.document.getElementById('sapData');
										if(!Ext.isEmpty(tooltipSap)){
											tooltipSap.remove();
										}
									})
								}
							}
						},
						<%
							if(isSQLPresent){
						%>
						{
							xtype:'container',
							html:'<div class="" style="font-size:10px;padding:3px 10px">* <%=fastQueryText%> <%=mappingInfo.getTextDescription("monitor.apmtopology."+apmType)%>.</div>'
							}
						<%
						}
						%>
						],
						
						padding:0,
						margin:'3 10 10 5',
						
					}]
				}]
			}]
		});
	});
}
else
{
	Ext.onReady(function(){
		Ext.create('Ext.container.Viewport', {
			layout:'fit',
			items: [{
				xtype:'panel',
				layout:{
					type:'vbox',
					align:'stretch'
				},
				items:[
				{
					xtype:'container',
					height:40,
					contentEl:'headerDivId',
				},
				{
					xtype:'panel',
					flex:1,
					margin:'3 10 10 5',
					id:'noDataId',
					contentEl:'callGraphNoData',
					cls:'btmAppDashboardsTopPanel'
				}]
			}]
		});
	});
}


</script>

</body>
</html>
