<%
/**
 *	File name		: eGBTMBase.jsp
 *	Purpose			: This page shows the call graph of a web request in HTML Table Tree view
 *	Version			: eG 6.0
 *	Creation Date	: 30-Apr-2014
 *	Author			: Mr.R and Mr.Balraj
 */
%>
<!DOCTYPE html>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.BTMHelper"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	EgAPMInfo apm = new EgAPMInfo("manager");
	//EgDbaseInfo egDbaseInfo = new EgDbaseInfo("manager");
	public String getTransactionQuery(boolean isAsyncThread, String guidString, String asyncGuid, String nodeFromAsyncOrNodeOrder, EgDbaseInfo egDbaseInfo,ArrayList enabledTests)
	{
		String result = null;
		boolean isAsyncThreadSuccess = false;
		String allTestNames = apm.getAPMTestTables();
		StringTokenizer strToken = new StringTokenizer(allTestNames,",");
		StringBuffer sbf = new StringBuffer();
		while (strToken.hasMoreTokens())
		{
			String tableName = strToken.nextToken();
			//tableName = tableName+"_DDD";
			boolean isTableExistsInDB = egDbaseInfo.isTableExistInDB(tableName);
			if(isTableExistsInDB && (enabledTests.contains(tableName) || enabledTests.contains(tableName.toUpperCase()))) 
			{
				String testQuery = null;
				if(isAsyncThread)
				{
					testQuery  = "select TRACE_DETAILS , RESPONSE_TIME from "+tableName+" where EG_GUID = '"+guidString+"' and THREAD_GUID = '"+asyncGuid+"' and NODE_ORDER='"+nodeFromAsyncOrNodeOrder+"'";// ORDER BY NODE_ORDER asc , SEQ_NO asc";
					sbf.append(testQuery).append(" UNION ALL ");
					isAsyncThreadSuccess = true;
				}
				else
				{
					testQuery  = "select TRACE_DETAILS , RESPONSE_TIME from "+tableName+" where EG_GUID ='"+guidString+"' and NODE_ORDER= '"+nodeFromAsyncOrNodeOrder+"'"; 
					sbf.append(testQuery).append(" UNION ALL ");
					isAsyncThreadSuccess = false;
				}
			}
		}
		String allQuery = sbf.toString();
		int lastIndexOfUnionAll=allQuery.lastIndexOf("UNION ALL");
		if(allQuery!=null &&allQuery.length()>1 && lastIndexOfUnionAll != -1)
			allQuery = allQuery.substring(0, allQuery.lastIndexOf("UNION ALL"));
		/*if (isAsyncThreadSuccess)
			allQuery = allQuery.substring(0, allQuery.lastIndexOf("UNION ALL"))+ " ORDER BY NODE_ORDER asc , SEQ_NO asc";
		else
			allQuery = allQuery.substring(0, allQuery.lastIndexOf("UNION ALL"));*/
		return allQuery;
	}

	public boolean isThreadRequestType(String nodeOrder)
	{
		boolean result = false;
		if(nodeOrder != null && nodeOrder.indexOf(".A")>-1)
		{ 
			String temp = nodeOrder.substring(0,nodeOrder.lastIndexOf("."));
			if(temp.endsWith(".A"))
				result = true;
		}
		return result;
	}
%>
<%
	response.setHeader("Cache-Control","no-Store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);

	String fromPage = request.getParameter("fromPage");
	String guidString = request.getParameter("EG_GUID");
	String asyncGuid = request.getParameter("asyncGUID");
	String threadRequest = request.getParameter("threadRequest");
	String targetHost  = request.getParameter("TRGT_HOST");
	String portNO  = request.getParameter("PORT_NO");
	String nodeOrder  = request.getParameter("nodeOrder");
	nodeOrder = StringUtils.decodeSecurityChar(nodeOrder);
	String nodeCount = request.getParameter("nodeCount");
	String redirectPage = request.getParameter("redirectPage");
	String prevWindowId = request.getParameter("prevWindowId");
	String timeString = request.getParameter("timeString");
	ArrayList enabledTests= (ArrayList)request.getSession().getAttribute("enabledTests");

	/*
			TimeString contains special symbol . Tomcat rejects the special symbols in query param So we have to encode the value to provide in query string 
	*/
	timeString = BTMHelper.getEncodedURI(timeString);
	String testName = request.getParameter("testName");
	ArrayList summaryData = (ArrayList) session.getAttribute("SummaryData");
	boolean isAsyncThread = false;

	String isReporterRequest = request.getParameter("isReporterRequest");
	if(isReporterRequest == null || isReporterRequest.trim().equals("")){
		isReporterRequest = "no";
	}
	
	// Test for the relevant node - code Starts 
	if(summaryData != null)
	{
		Hashtable nodeTable = (Hashtable) summaryData.get(0);
		if(nodeTable != null)
		{
			ArrayList dataList = (ArrayList) nodeTable.get(guidString+"#"+nodeOrder);
			if(dataList != null)
			{
				testName = (String) dataList.get(26);
			}
		}
	}
	// Test for the relevant node - code end 

	String apmType = apm.getAPMType(testName);
	EgDbaseInfo egDbaseInfo = new EgDbaseInfo("manager");
	if(threadRequest != null && threadRequest.equals("asyncThread"))
	{
		isAsyncThread = true;
		Hashtable asyncGuidTable = (Hashtable) summaryData.get(3);
		String nodeFromAsync = "";
		if(asyncGuidTable != null && asyncGuidTable.size()>0)
		{
			nodeFromAsync = (String) asyncGuidTable.get(asyncGuid);
		}
		nodeOrder = nodeFromAsync;
		//String sqlquery = "select TRACE_DETAILS , RESPONSE_TIME from "+testName+"_DDD where EG_GUID = '"+guidString+"' and THREAD_GUID = '"+asyncGuid+"' and NODE_ORDER='"+nodeFromAsync+"' ORDER BY NODE_ORDER asc , SEQ_NO asc";
	}
	else
	{
		isAsyncThread = false;
		//String query = "select TRACE_DETAILS , RESPONSE_TIME from "+testName+"_DDD where EG_GUID ='"+guidString+"' and NODE_ORDER= '"+nodeOrder+"'"; 
	}
	String sqlquery = getTransactionQuery(isAsyncThread, guidString, asyncGuid, nodeOrder, egDbaseInfo,enabledTests);
	Hashtable dataTable = BTMHelper.processData(sqlquery, guidString, nodeOrder, apmType);
	if(dataTable != null && dataTable.size()>0)
	{
		ArrayList hotSpotDetails = (ArrayList) dataTable.get("HotSpotData");
		ArrayList TraceList = (ArrayList) dataTable.get("TraceData");
		session.setAttribute("HotSpotData"+"#"+nodeOrder, hotSpotDetails);
		session.setAttribute("TraceData"+"#"+nodeOrder, TraceList);
	}
	
	String id = guidString+"#"+nodeOrder;
	String requestType = "Web";

	boolean isThreadRequest = isThreadRequestType(nodeOrder);
	if(isThreadRequest)
		requestType = "Thread";

	/*
		Node Order contains special symbol . Tomcat rejects the special symbols in query param So we have to encode the value to provide in query string 
	*/
	nodeOrder = StringUtils.encodeSecurityChar(nodeOrder);
	nodeOrder = BTMHelper.getEncodedURI(nodeOrder);
%>

<html>
<head>
	<link rel="stylesheet" href="/final/resources/css/ext-eg.css" />
	<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
	<script  src="/final/jquery/jquery.js"></script>
	<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
	<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>

	<egui:skin ui="monitor"/>
	<script type="text/javascript" src="/final/monitor/eg_scripts/eGBTMBase/app.js"></script>

<style>
	/*.x-tip ,
	.x-tip .x-tip-body,
	.x-tip .x-form-invalid-tip-body,
	.x-tip.yellowTip .x-tip-body,
	.x-tip.yellowTip .x-form-invalid-tip-body {
		word-break: break-all !important;
		white-space: nowrap !important;
		width:auto !important;
}*/

.btmDatapanel div.x-panel-header {
    padding: 5px 10px 0px 5px !important;
}
.x-tip.yellowTip.para .x-tip-body{
	height:auto !important;
	white-space: pre-wrap !important;
	word-wrap:break-word !important;
	white-space: normal;
}
.x-tip-btmToolTipUi #noSQLData_header-body, .x-tip-btmToolTipUi #noSQLData_header-innerCt.x-box-inner{
	text-transform:none;
}


</style>

<script  src="/final/scripts/bubble.js"></script>

	<script language="javascript">
		var strSkin='<%=monitor_Skin%>';
		var guidString = '<%=guidString%>';
		var nodeOrder = '<%=nodeOrder%>';
		var targetHost = '<%=targetHost%>';
		var portNO = '<%=portNO%>';
		var id = '<%=id%>';
		var redirectPage = '<%=redirectPage%>';
		var fromPage = '<%=fromPage%>';
		var requestType = '<%=requestType%>';
		var threadRequest = '<%=threadRequest%>';
		var nodeCount = '<%=nodeCount%>';
		var asyncGuid = '<%=asyncGuid%>';
		var prevWindowId = '<%=prevWindowId%>';
		var timeString = '<%=timeString%>';
		var testName = '<%=testName%>';
		var title = '';

		
		var on= '<egui:intnl text="monitor.apmtopology.on"/>';
		var thisTransaction= '<egui:intnl text="monitor.apmtopology.this transaction"/>';
		var noErrorDetail= '<egui:intnl text="monitor.apmtopology.No errors Details capured for"/>';
		var noHotSpot= '<egui:intnl text="monitor.apmtopology.No hot spots captured for"/>';
		var noSqlCalls= '<egui:intnl text="monitor.apmtopology.No SQL calls captured for"/>';
		var noRemoteDetails= '<egui:intnl text="monitor.apmtopology.No Remote details captured for"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var lbl_Summary = '<egui:intnl text="monitor.apmtopology.Summary"/>';
		var lbl_CallGraph = '<egui:intnl text="monitor.apmtopology.Call Graph"/>';
		var lbl_HotSpot = '<egui:intnl text="monitor.apmtopology.Hot Spots"/>';
		var lbl_SQlCalls = '<egui:intnl text="monitor.apmtopology.SQL Calls"/>';
		var lbl_sqlQueries = '<egui:intnl text="monitor.apmtopology.SQL queries"/>';
		var lbl_sqlQuery = '<egui:intnl text="monitor.apmtopology.SQL query"/>';
		var multipleQueryProblem = '<egui:intnl text="monitor.apmtopology.Multiple query problem detected"/>';
		var queryProblem = '<egui:intnl text="monitor.apmtopology.Query problem detected"/>';

		var lbl_fastQueryInfo1 = '<egui:intnl text="monitor.apmtopology.SQL query(s) are executed within slow cutoff which is"/>';
		var lbl_fastQueryInfo2 = '<egui:intnl text="monitor.apmtopology.ms, hence the SQL query(s) are not captured and displayed."/>';
		var lbl_DownloadCsv = '<egui:intnl text="monitor.apmtopology.Download Csv"/>';
		var lbl_ErrorDetails = '<egui:intnl text="monitor.apmtopology.Error Details"/>';
		var lbl_SingleErrorDetails = '<egui:intnl text="monitor.apmtopology.Error Details - Total number of exception : 1"/>';
		var lbl_MoreErrorDetails = '<egui:intnl text="monitor.apmtopology.Error Details - Total number of exception(s) : #n"/>';

		var lbl_ExternalDetails = '<egui:intnl text="monitor.apmtopology.External Details"/>';
		var lbl_MethodDetails = '<egui:intnl text="monitor.apmtopology.Method details"/>';
		var lbl_Count = '<egui:intnl text="monitor.apmtopology.Count"/>';
		var lbl_Duration = '<egui:intnl text="monitor.apmtopology.Time"/>';
		var lbl_ms = '<egui:intnl text="monitor.apmtopology.ms"/>';
		var lbl_TimePercentage = '<egui:intnl text="monitor.apmtopology.% Time"/>';
		var lbl_SqlQueryDetails = '<egui:intnl text="monitor.apmtopology.SQL Query details"/>';
		var lbl_Warning = '<egui:intnl text="monitor.apmtopology.Warning"/>';
		var lbl_AvgExecuteTime = '<egui:intnl text="monitor.apmtopology.Avg Execution Time"/>';
		var lbl_TotalExecuteTime = '<egui:intnl text="monitor.apmtopology.Total Execution Time"/>';
		var lbl_Count= '<egui:intnl text="monitor.apmtopology.Count"/>';
		var lbl_QueryType = '<egui:intnl text="monitor.apmtopology.Query Type"/>';
		var lbl_ResponseTime = '<egui:intnl text="monitor.apmtopology.Response time"/>';
		var lbl_QueryDetails = '<egui:intnl text="monitor.apmtopology.Query Details"/>';
		var lbl_Error = '<egui:intnl text="monitor.apmtopology.Error"/>';
		var lbl_DatabaseDetails = '<egui:intnl text="monitor.apmtopology.Database"/>';
		var lbl_ExceptionDetails = '<egui:intnl text="monitor.apmtopology.Exception Details"/>';
		var lbl_Method = '<egui:intnl text="monitor.apmtopology.Method"/>';
		var lbl_Operation = '<egui:intnl text="monitor.apmtopology.Operation"/>';
		var lbl_Url = '<egui:intnl text="monitor.apmtopology.URL"/>';
		var lbl_Ip = '<egui:intnl text="monitor.apmtopology.IP"/>';
		var lbl_Details = '<egui:intnl text="monitor.apmtopology.Details"/>';
		var lbl_Provider = '<egui:intnl text="monitor.apmtopology.Provider"/>';
		var lbl_TopicOrQueue = '<egui:intnl text="monitor.apmtopology.Topic or Queue"/>';
		var lbl_HttpUrl = '<egui:intnl text="monitor.apmtopology.Http URL"/>';
		var lbl_WebServiceUrl = '<egui:intnl text="monitor.apmtopology.Webservice URL"/>';
		var lbl_ExecutionTime = '<egui:intnl text="monitor.apmtopology.Execution Time"/>';
		var lbl_HttpCallDetails = '<egui:intnl text="monitor.apmtopology.Http call details"/>';
		var lbl_WebServiceCallDetails = '<egui:intnl text="monitor.apmtopology.Webservice call details"/>';
		var lbl_JmsCallDetails = '<egui:intnl text="monitor.apmtopology.Jms call details"/>';
		var lbl_StatusCode = '<egui:intnl text="monitor.apmtopology.Status Code"/>';
		
		//Used for Forthcoming pointcuts
		var lbl_OtherPointCut = '<egui:intnl text="monitor.apmtopology.RMI call details"/>';
		var lbl_RmiCallDetails = '<egui:intnl text="monitor.apmtopology.RMI call details"/>';
		var lbl_RmiProtocol = '<egui:intnl text="monitor.apmtopology.RMI Protocol"/>';
		var lbl_EmailCallDetails = '<egui:intnl text="monitor.apmtopology.EMAIL call details"/>';
		var lbl_RuntimeCallDetails = '<egui:intnl text="monitor.apmtopology.RUNTIME call details"/>';
		var lbl_RuntimeCommandUsed = '<egui:intnl text="monitor.apmtopology.Command Used"/>';
		var lbl_LdapCallDetails = '<egui:intnl text="monitor.apmtopology.LDAP call details"/>';
		var lbl_EjbCallDetails = '<egui:intnl text="monitor.apmtopology.EJB call details"/>';
		var lbl_EHCacheCallDetails = '<egui:intnl text="monitor.apmtopology.Cache call details"/>';

		var lbl_SapCallDetails = '<egui:intnl text="monitor.apmtopology.Sap JCO call details"/>';
		var lbl_jcoFunctionName = '<egui:intnl text="monitor.apmtopology.JCO function name"/>';
		var lbl_ashost = '<egui:intnl text="monitor.apmtopology.AS Host"/>';
		var lbl_systemId = '<egui:intnl text="monitor.apmtopology.System ID"/>';
		var lbl_systemNo = '<egui:intnl text="monitor.apmtopology.System No"/>';
		var lbl_username = '<egui:intnl text="monitor.apmtopology.Username"/>';
		var lbl_client = '<egui:intnl text="monitor.apmtopology.Client"/>';
		var lbl_NoDataHotSpot = '<egui:intnl text="monitor.apmtopology.No hot spots in this transaction"/>';
		var lbl_NoDataErrorDetail = '<egui:intnl text="monitor.apmtopology.No error details captured in this transaction"/>';
		var lbl_NoDataExternalDetail = '<egui:intnl text="monitor.apmtopology.No external details captured in this transaction"/>';
		var lbl_NoDataSql = '<egui:intnl text="monitor.apmtopology.No SQL calls captured in this transaction"/>';
		var lbl_NoDataSummary = '<egui:intnl text="monitor.apmtopology.No summary details captured in this transaction"/>';
		var lbl_TotalSqlCalls = '<egui:intnl text="monitor.apmtopology.slow SQL Queries"/>';
		var lbl_OneSqlCall = '<egui:intnl text="monitor.apmtopology.slow SQL Query"/>';
		var lbl_ExecuteTime = '<egui:intnl text="monitor.apmtopology.Execution Time"/>';
		var lbl_TotalProcessingTime = '<egui:intnl text="monitor.apmtopology.Total Processing Time"/>';
		var lbl_Component = '<egui:intnl text="monitor.apmtopology.Component"/>';
		var lbl_BreakupProcessTime = '<egui:intnl text="monitor.apmtopology.Breakup of Processing Time"/>';
		var lbl_DrillDown = '<egui:intnl text="monitor.apmtopology.Drill Down into Downstream Call"/>';
		var lbl_Total = '<egui:intnl text="monitor.apmtopology.Total"/>';

		var lbl_TotalTime = '<egui:intnl text="monitor.apmtopology.Total time"/>';
		var lbl_SlowSqlQueries = '<egui:intnl text="monitor.apmtopology.SQL queries are slow/error"/>';
		var lbl_SlowSqlQuery = '<egui:intnl text="monitor.apmtopology.SQL query is slow/error"/>';

		// Intermediate Modal Window labels
		var lbl_CalledFrom = '<egui:intnl text="monitor.apmtopology.Called From"/>';
		var lbl_ExitCalls = '<egui:intnl text="monitor.apmtopology.Exit Calls"/>';
		var lbl_StartTime = '<egui:intnl text="monitor.apmtopology.Start Time"/>';
		var lbl_UserExp = '<egui:intnl text="monitor.apmtopology.User Experience"/>';

		var lbl_command = '<egui:intnl text="monitor.apmtopology.Command"/>';
		var lbl_dbUrl = '<egui:intnl text="monitor.apmtopology.IPandPort"/>';
		var lbl_dbName = '<egui:intnl text="monitor.apmtopology.DataBaseName"/>';
		var lbl_NoSqlCallDetails='<egui:intnl text="monitor.apmtopology.Redis Details Window"/>';
		var isReporterRequest = '<%=isReporterRequest%>';

		Ext.onReady(function(){
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : Ext.MessageBox.ERROR
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : Ext.MessageBox.ERROR
						});
					}
				}
			});
		});
	</script>
	<script type="text/javascript">
	</script>
</head>
<body onclick="framebodyClickCall('<%=prevWindowId%>')">
<div  class="div_scroll" style="width:50%;height:auto;border:0px solid balck;visibility:hidden;display:none;z-Index:10000;" id="alarmsListDiv"></div>
<script>
function closeDiv(){
	var divId = document.getElementById("alarmsListDiv");
	divId.style.visibility='hidden';
}

function showDiv(){
	var divId = document.getElementById("alarmsListDiv");
	divId.style.visibility='block';
}

function loadPopup(qUrl)
{	
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?")+1);
		tmpUrl = "componentMeasureTabSet.jsp?"+tmpUrl;
		window.open(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}

function OpenLayerModel(url){
	if(!Ext.isEmpty(url))
	{
		parent.location.href=url;
	}
}

</script>
</body>
</html>




