<%
/**************************************************************************************************	
*	Name			:	EgServiceTopologyD3JS.jsp
*	Version			:	eG 6.1
*	Purpose			:	To display the service topology using JSON and D3JS
*	Creation Date	:	01-04-2015
*	Last Modified	:	
*--- *      Author   : ---Prantish A
******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld" %> 
<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.eg.*"%>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%


	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String site=request.getParameter("site");
	
	String thisLanguage = "";
	String userName = "";
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	if(user!=null)
	{
		thisLanguage = user.getLanguage();	
		userName = user.getLoginID();
	}
	
	String treeFlag=request.getParameter("treeFlag");
	String zoneName=request.getParameter("zoneName");
	String currentTab=request.getParameter("currentTab");
	String aggregateTab=request.getParameter("aggregateTab");
	String openNode=request.getParameter("openNode");
	
	String fromHomepage=request.getParameter("fromHomepage");
	//String transactionsFlag=request.getParameter("transactionsFlag");
	String action=request.getParameter("action");
	String serviceGroup=request.getParameter("serviceGroup");
	String iszoneName = request.getParameter("iszoneName");
	String isFromZone = request.getParameter("isFromZone"); 
	String parentZone = request.getParameter("parentZone");
	String serviceState = request.getParameter("serviceState");
	String service = request.getParameter("service");
	String segment = request.getParameter("segment");
	String isSerComboNeed = request.getParameter("isSerComboNeed");

	String newSegstate=null;
	if(segment!=null && service!=null)
	{
		newSegstate = getStateForSegment(service,segment);
		if(newSegstate==null || newSegstate.trim().length()==0)
			newSegstate="GOOD";
		serviceState = "service20New_"+newSegstate;
	}

	String filter = request.getParameter("filter");
	String filterBy = request.getParameter("filterBy");
	String activeView = request.getParameter("activeView");
	String isFromServiceMenu = request.getParameter("isFromServiceMenu");
	String isFromZoneMain = request.getParameter("isFromZoneMain");
	String isFromZoneMenu = request.getParameter("isFromZoneMenu");
	String isFromServiceGroup = request.getParameter("isFromServiceGroup");

	String selectedRum = request.getParameter("selectedRum");
	String isfromRum = request.getParameter("isfromRum");
	String isfromCitrix = request.getParameter("isfromCitrix");
	String dashboard_name = request.getParameter("dashboard_name");
	String dashboard_mapping = request.getParameter("dashboard_mapping");
	String user_name = request.getParameter("user_name");
	String fromMyDashboard = request.getParameter("fromMyDashboard");
	String anonymousUser="no";
	String profileName="";
	boolean isFromMyDashboard=false;
	String setMyDashboardAsHome="no";
	String isMyDashboardPopout="no";
	if(fromMyDashboard!=null && fromMyDashboard.equalsIgnoreCase("true"))
	{
		isFromMyDashboard=true;
		String myDashboardTheme = request.getParameter("myDashboardTheme");
		anonymousUser = request.getParameter("anonymousUser");
		profileName = request.getParameter("profileName");
		setMyDashboardAsHome=request.getParameter("setMonitorHome");
		isMyDashboardPopout=request.getParameter("isDisablePopupOption");
		if(!com.egurkha.util.StringUtils.isNull(myDashboardTheme) && !myDashboardTheme.equalsIgnoreCase(monitor_Skin))
		{
			monitor_Skin=myDashboardTheme;
		}
	}
	String widgetWidth=request.getParameter("widgetWidth");
	String widgetHeight=request.getParameter("widgetHeight");
	
	//TopologyRenderingMode
	String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini";
	IniFile iniFile = new IniFile(iniFilePath);
	String topologyRenderingMode = iniFile.getValue("TOPOLOGY_OPTIONS","TopologyRenderingMode");

	if(topologyRenderingMode == null){
		System.out.println("topologyRenderingMode == null");
		topologyRenderingMode = "manual";
	}
	/**
	String topologyPosition = iniFile.getValue("TOPOLOGY_OPTIONS","TopologyPosition");
	if(topologyPosition == null){
		System.out.println("topologyPosition == null");
		topologyPosition = "left";
	}
	*/
	
	StringBuffer topoUrl = new StringBuffer();
	topoUrl.append("/final/monitor/EgServiceTopologyJSON.jsp?physical_topology=0&type=monitor&treeFlag=" + treeFlag);
	topoUrl.append("&zoneName=" + zoneName);
	topoUrl.append("&currentTab=" + currentTab);
	topoUrl.append("&aggregateTab=" + aggregateTab);
	topoUrl.append("&openNode=" + openNode);
	topoUrl.append("&fromHomepage=" + fromHomepage);
	topoUrl.append("&serviceGroup=" + serviceGroup);
	topoUrl.append("&iszoneName=" + iszoneName);
	topoUrl.append("&isFromZone=" + isFromZone);
	topoUrl.append("&parentZone=" + parentZone);
	topoUrl.append("&action=" + action);
	topoUrl.append("&serviceState=" + EgURLEncoder.encode(serviceState, "UTF-8"));
	topoUrl.append("&site=" + site);
	topoUrl.append("&service=" + EgURLEncoder.encode(service, "UTF-8"));
	topoUrl.append("&segment=" + EgURLEncoder.encode(segment, "UTF-8"));
	topoUrl.append("&topologyRenderingMode=" + topologyRenderingMode);
	topoUrl.append("&autoPosition=false");
	topoUrl.append("&filter="+filter);
	topoUrl.append("&filterBy="+filterBy);
	topoUrl.append("&activeView="+activeView);
	topoUrl.append("&isFromServiceMenu="+isFromServiceMenu);
	topoUrl.append("&isFromZoneMain="+isFromZoneMain);
	topoUrl.append("&isFromZoneMenu="+isFromZoneMenu);
	topoUrl.append("&isFromServiceGroup="+isFromServiceGroup);
	topoUrl.append("&selectedRum="+selectedRum);
	topoUrl.append("&isfromRum="+isfromRum);
	topoUrl.append("&isfromCitrix="+isfromCitrix);
	topoUrl.append("&dashboard_name="+dashboard_name);
	topoUrl.append("&dashboard_mapping="+dashboard_mapping);
	topoUrl.append("&user_name="+user_name);

	if(isFromMyDashboard)
	{
		topoUrl.append("&profileName="+profileName);
		topoUrl.append("&fromMyDashboard="+fromMyDashboard);
		topoUrl.append("&myDashboardTheme="+monitor_Skin);
		topoUrl.append("&anonymousUser="+anonymousUser);
		topoUrl.append("&setMyDashboardAsHome="+setMyDashboardAsHome);
		topoUrl.append("&isMyDashboardPopout="+isMyDashboardPopout);
		topoUrl.append("&widgetWidth="+widgetWidth);
		topoUrl.append("&widgetHeight="+widgetHeight);
	}

	if(u_rs!=null && !u_rs.trim().equals(""))
	{
		topoUrl.append("&loginID="+EgURLEncoder.encode(u_rs.trim(),"UTF-8"));
	}
	String link = topoUrl.toString(); 
	StringBuffer metaRefreshUrl = new StringBuffer(64);

	metaRefreshUrl.append(request.getRequestURI());
	String queryString = request.getQueryString();
	if (queryString != null && !queryString.equals("null"))
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}
	String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
	IniFile iniTopoFile = new IniFile(iniFileName);
	String subjname = userName+"~|#|~"+site+"~|#|~"+segment+"~|#|~Service~Monitor";
	
	String zoomLevelTopo = iniTopoFile.getValue(subjname,"zoom");
	String translateTopo = iniTopoFile.getValue(subjname,"translate");
	double zoomLevelTopoVal = 0;
	if(zoomLevelTopo != null && zoomLevelTopo.trim().length() > 0)
		zoomLevelTopoVal = Double.parseDouble(zoomLevelTopo);	
	
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	//String servlbl = "Service";
	String servlbl = "Segment";
	String searchlbl = "Search";
	String fitlbl = "Fit";
	servlbl = mappingInfo.getTextDescription("monitor.common."+servlbl);
	searchlbl = mappingInfo.getTextDescription("monitor.common."+searchlbl);
	fitlbl = mappingInfo.getTextDescription("monitor.common."+fitlbl);

	if(segment!=null && segment.equals("Independent_servers"))
	{
		servlbl="";
	}

%>
<!doctype html>
<html>
<head>
<title></title>
<meta charset="utf-8">
<link rel="stylesheet" href="/final/styles/jquery-ui.min.css">
<script>

	var fromMyDashboard='<%=isFromMyDashboard%>';
	if(fromMyDashboard!=null && fromMyDashboard=="true")
	{
		var strSkin='<%=monitor_Skin%>';
		if(strSkin!=null && strSkin=='Dark')
		{
			document.write('<link rel="stylesheet" href="/final/resources/css/ext-eg.css"  media="all"/>');
			document.write('<link rel="stylesheet" href="/final/styles/eGDarkTheme.css" media="all" />');
			document.write('<link rel="stylesheet" href="/final/styles/eGDarkThemeIcons.css"  media="all" />');
		}
		else
		{
			document.write('<link rel="stylesheet" href="/final/resources/css/ext-eg.css"  media="all"/>');
			document.write('<link rel="stylesheet" href="/final/styles/eGLightTheme.css" media="all" />');
			document.write('<link rel="stylesheet" href="/final/styles/eGLightThemeIcons.css"  media="all" />');
		}
	}
	else
	{	
		document.write('<egui:skin ui="monitor"/>');
	}
</script>

<script src="/final/jquery/jquery.js"></script>
<script src="/final/scripts/d3.min.js" charset="utf-8"></script>
<script src="/final/scripts/lodash.core.min.js"></script>
<script src="/final/jquery/jquery-ui.js"></script>
<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
<script type="text/javascript" src="/final/scripts/monitord3Topology.js"></script>
</head>
<body>
<div id="diagram"></div>
<div  class="div_scroll" style="width:50%;height:auto;border:0px solid black;" id="alarmsListDiv">
</div>

<script>
var newSegstate = '<%=newSegstate%>';
var widgetWidth='<%=widgetWidth%>';
var widgetHeight='<%=widgetHeight%>';
var isMyDashboardTopology=false;
if(fromMyDashboard!=null && fromMyDashboard=="true")
{
	widgetWidth=parseInt(widgetWidth);
	widgetHeight=parseInt(widgetHeight)-30;
	isMyDashboardTopology=true;
}
var width = (isMyDashboardTopology)?widgetWidth:916;
var height = (isMyDashboardTopology)?widgetHeight:500;
var tip = null;
function closeDiv(){
	var divId = document.getElementById("alarmsListDiv");
	//divId.style.visibility='hidden';
	var alarmPopupDivId = document.getElementById("alarmPopup");
	alarmPopupDivId.style.visibility='hidden';
}

function showDiv(){
	var divId = document.getElementById("alarmsListDiv");
	//divId.style.visibility='block';
	var alarmPopupDivId = document.getElementById("alarmPopup");
	alarmPopupDivId.style.visibility='block';
}
function saveGroupOpenforMonitor(groupCompId,pageNo)
{
	parent.topoGroupSaveSer = groupCompId+"~~"+pageNo;
}
function saveZoomPositionsforMonitor(str,zoomVal,translateVal,groupCompId,pageNo)
{
	var segmentname ='<%=segment%>';
	//if(segmentname == 'Independent_servers')
	{
		var siteName = '<%=site%>';
		var userName = '<%=userName%>';
		segmentname = userName+"~|#|~"+siteName+"~|#|~"+segmentname+"~|#|~Service~Monitor";
	}
	var url = "/final/servlet/com.eg.SegmentPositionServlet";
	//var zoomHidden = document.getElementById("zoom").value;
	var zoomHidden = zoomVal;
	var translateHidden = translateVal;
	var params;
	if (str == 'zoom')
	{
		params = "action="+str+"&segment="+segmentname+"&zoom="+zoomHidden;
		params += "&translate="+translateHidden;		
	}
		
	xmlhttp = new getXMLObject();
	if(xmlhttp)
	{
		xmlhttp.open("POST",url,true);
		xmlhttp.onreadystatechange  = function()
		{
			if (xmlhttp.readyState == 4) 
			{
				if(xmlhttp.status != 200) 
				{
					//alert("Error occured while saving. Please try again ...."+xmlhttp.status);
				}
				else
				{					
				}
			}
		}
		xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlhttp.send(params);
	}
}
function getXMLObject()  //XML OBJECT
{
	var xmlHttp = false;
	try 
	{
		xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
	}
	catch (e) 
	{
		try 
		{
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch (e2) 
		{
			xmlHttp = false;
		}
	}
	if (!xmlHttp && typeof XMLHttpRequest != 'undefined') 
	{
		xmlHttp = new XMLHttpRequest();
	}
	return xmlHttp;
}
function loadPopup(qUrl)
{	
	if(!Ext.isEmpty(qUrl))
	{
		var tmpUrl = qUrl.substring(qUrl.indexOf("?")+1);
		tmpUrl = 'componentMeasureTabSet.jsp?'+tmpUrl;
		window.open(tmpUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
}
function OpenLayerModel(url){

	if(!Ext.isEmpty(url))
	{
		if(isMyDashboardTopology)
		{
			var dashboardName=encodeURIComponent('<%=profileName%>');
			var backBtnPrms="&profileName="+dashboardName;
			var setMyDashboardAsHome='<%=setMyDashboardAsHome%>';
			var isMyDashboardPopout='<%=isMyDashboardPopout%>';
			if(setMyDashboardAsHome!=null && setMyDashboardAsHome=="true")
			{
				backBtnPrms+="&setMonitorHome=true";
			}
			if(isMyDashboardPopout!=null && isMyDashboardPopout=="true")
			{
				backBtnPrms+="&isDisablePopupOption=true";
			}
			url=url+"&fromPage=myDashboard&backBtnUrl="+encodeURIComponent(backBtnPrms);
		}
		parent.location.href=url;
	}
}
function showAlarmListOnHover(paramVal, title, pagex, pagey){
	
	if( !event ) event = window.event; 

	var tipX=event.clientX-65;
	var tipY=event.clientY-150;
	if(tip!=null && tip!=undefined)
	{
		tip.close();
		tip=null;
	}

	var url_value = '/final/monitor/alarmsList.jsp?compName=' + paramVal + '&site=<%=segment%>';
	if(isMyDashboardTopology)
	{
		var dashboardName=encodeURIComponent('<%=profileName%>');
		url_value = url_value+'&fromMyDashboard='+fromMyDashboard+'&anonymousUser=<%=anonymousUser%>&profileName='+dashboardName+'&widgetWidth='+widgetWidth+'&widgetHeight='+widgetHeight;
	}
	Ext.Ajax.request({
		url:url_value,
		success:function(respons)
		{
			var response = respons.responseText;
			var jsonData = Ext.decode(response);
			var gridData = jsonData.tableData;
			if(gridData != "NO_DATA"){
				/*if (tip) {
					tip.destroy();
					tip = null;
				}
				var tip = new Ext.ToolTip({
						//title: title,
						closeAction: 'destroy',
						cls: 'x-tip-whitethemes d3popup',
						width: '40%',
						layout:'fit',
						autoHide: false,
						closable:true,
						mouseOffset: [pagex, pagey],
						html: gridData,
						anchorToTarget: true,
						listeners: {
							
							 'render': function(tt){
								 timeout = window.setTimeout(function(){
											tt.hide();
										}, 2000);

								tt.body.on('mouseout', function(e){
									if(!e.within(tt.body, true)){
										timeout = window.setTimeout(function(){
											tt.hide();
										}, 500);
									}
								}, this);
								
								tt.body.on('mouseover', function(){
											
											//window.clearTimeout(timeout);
										});
							},
							hide: function () {
								this.destroy();
								//this = null;
							}
						}
					}).show();*/
						

						tip = Ext.create('Ext.tip.ToolTip',{
						//width:'40%',
						maxWidth:550,
						//height:105,
						trackMouse: true,
						anchor:'bottom',
						border:false,
						//closable:true,
						id:'alarmPopup',
						closeAction: 'destroy',
						//cls:'uxLogonTooltip',
						//cls: 'x-tip-whitethemes d3popup',
						ui:'newTooltipPopup',
						frame:false,
						//modal:true,
						anchorOffset:30,
						tools:[
								{
									xtype:'button',
									border:0,
									cls:'iconClosePopup',
									width:16,
									height:16,
									handler:closeDiv

								}

						],
						dismissDelay:1111144000,
						bodyPadding:'5 5 0 5',
						constrainPosition : true,
						//renderTo: Ext.getBody(),
						autoScroll:false,
						padding:0,
						scroll:false,
						//header:false,
						title:"<div><span style='text-transform: uppercase;padding:0px' >Alerts for Component - "+title+"</span></div>",
						//title:"<div style='border:1px solid red;width:100% !important;text-transform: uppercase;margin-left:4px !important'>Alerts for Component - "+title+"</div>",
						//html:"<div class='alarmTooltipHeaderfont' style='width:100%;padding: 0px !important;'><div style='padding:5px;float:left;text-transform: uppercase;'>Alerts for Component - "+title+"</div><div class=\"iconClosePopup\" onclick=\"closeDiv()\" style='margin-top:3px;float:right'></div></div><div class='crl'/><div>"+gridData+"</div>",
						//<div style='border:0px solid red;height:92px;overflow:auto;margin-top:3px'>
						html:gridData
						
				});

				if(tip!=null && tip!=undefined)
				{
					//win.destroy();
					tip.showAt([tipX+30,tipY]);
				}
			}
		},
		failure: function(){
			/**Ext.Msg.show({
					title: 'Topology',
					msg: 'Request failed',
					icon: 'iconExclamation',
					buttons: Ext.Msg.OK
				});
				**/
		}
	});
}
function getPaperHeight(paperHeight)
{	
	var winHeight = $( window ).height();
	if(paperHeight < winHeight || isAutoFit === true){
		paperHeight = winHeight;
	}
	return paperHeight;
}
function getPaperWidth(paperWidth)
{	
	var winWidth = $( window ).width();
	if(paperWidth < winWidth || isAutoFit === true){
		paperWidth = winWidth;
	}
	return paperWidth;
}
$(window).ready(function(){

	var url = '<%=link%>';
	isAutoFit = ('<%=topologyRenderingMode%>' == 'auto') ? true : false;
	//console.log("topo url",url);
	if(isMyDashboardTopology)
	{
		var anonymousUser='<%=anonymousUser%>';
		if(anonymousUser!=null && anonymousUser=='true')
		{
			url=encodeURI(url);
		}
	}
	Ext.Ajax.request({
			url: url,
			success: function(respons)
			{
				var response = respons.responseText;
				var jsonData = Ext.decode(response);
				var rootJson = jsonData['rootJson'];

				var paperHeight = jsonData.rootJson.paper['height'];
				var paperWidth = jsonData.rootJson.paper['width'];
				
				//var topologyPosition = jsonData.rootJson.paper['layoutAlign'];
				var zoomLevel = jsonData.rootJson.paper['zoomLevel'];
				var pan_X = jsonData.rootJson.paper['pan_X'];
				var pan_Y = jsonData.rootJson.paper['pan_Y'];
				
				paperHeight = getPaperHeight(paperHeight);
				paperWidth = getPaperWidth(paperWidth);

				if(zoomLevel == null || zoomLevel.length == 0 || zoomLevel == 100){
					zoomLevel = 1;// default zoom value is 1
				}
				if(pan_X == null || pan_X.length == 0 ) {
					pan_X = -8;// default pan X value is -8
					//pan_X = $( window ).width()/2;// default pan X value is -8
				}
				if( pan_Y == null ||  pan_Y.length == 0) {
					pan_Y = -8;// default pan Y value is -8
					//pan_Y = $( window ).height()/2;// default pan Y value is -8
				}
				var zoomLevelTopoValSet = -1;
				var translateTopoValSet = "";
				var zoomLevelTopoValt= <%=zoomLevelTopoVal%>;
				var translateTopoValt= '<%=translateTopo%>';

				if(zoomLevelTopoValt != null && zoomLevelTopoValt > 0)
					zoomLevelTopoValSet = zoomLevelTopoValt;
				if(translateTopoValt != undefined && translateTopoValt != null && translateTopoValt.trim().length > 0)
					translateTopoValSet = translateTopoValt;
				
				var groupOpenIdTopoValt= "";
				var pageNoTopoValt= "";

				if(parent.topoGroupSaveSer != null && parent.topoGroupSaveSer.trim().length > 0)
				{
					groupOpenIdTopoValt = parent.topoGroupSaveSer.substring(0,parent.topoGroupSaveSer.indexOf("~~"));
					pageNoTopoValt = parent.topoGroupSaveSer.substring(parent.topoGroupSaveSer.indexOf("~~")+2);
				}
				
				/*var segemntName = '<%=segment%>';
				if(segemntName.toLowerCase() == "independent_servers")
					segemntName = "Independent Servers";*/

				$('#diagram').renderSvg({
					renderTo: '#diagram',
					//segmentName: segemntName,
					//segmentStateCls: segmentStateCls, 
					//fromPage: servlbl,
					searchlbl: '<%=searchlbl%>',
					fitlbl: '<%=fitlbl%>',
					initialX: pan_X,
					initialY: pan_Y,
					enableFitLayout: true,
					zoomLevelTopoValSet:zoomLevelTopoValSet,
					translateTopoValSet:translateTopoValSet,
					groupOpenIdTopoValt:groupOpenIdTopoValt,
					pageNoTopoValt:pageNoTopoValt,
					//layoutAlign: topologyPosition,
					collideLayout: isAutoFit,
					zoom: true,
					draggable: false,
					//width: paperWidth,
					//height: paperHeight,
					width: Ext.getBody().getViewSize().width+15,
					height: Ext.getBody().getViewSize().height+15,
					isShowSegmenrServiceHeader : isMyDashboardTopology?false:true,
					//default_zoom:zoomLevel,
					data: jsonData
					}); 

				},
			failure: function(){
			/*	Ext.Msg.show({
						title: 'Topology',
						msg: 'Request failed',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});*/
			}
		}); 
	
			Ext.defer(function(){
			//TV MODE AUTO SCROLL FUNCTION
		if(!Ext.isEmpty(window.parent.isTvMode)){
			$.fn.hasScrollBar = function() {
					return $("body").height() > $(window).height();
			}
			if(window.parent.isTvMode){

					var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
					window.parent.Ext.getCmp('playBtn').ifScroll = false;
					var ifPageHasScroll = $('#indexmain-body').hasScrollBar();
						var count = 0;
					var ClickActionPause=false;
					var getTvModePlayAction = function () {

							var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
							if(silderAction == "pause"){
								//Ext.get('indexmain-body').getActiveAnimation().paused = false;
								ClickActionPause = true;
								
								}
								else{

								clearTimeout( clearTimeOut );
								//Ext.get('indexmain-body').getActiveAnimation().paused = true;
								window.parent.Ext.getCmp('tvmode').sliderObj.pause();
								ClickActionPause = false;
								}
								
					}
					var runner = new Ext.util.TaskRunner();
					 var task = runner.start({
										 run: getTvModePlayAction,
										 interval: 1000
									 });
					var totalScrollLength = $("body").height() - $(window).height();
					var scrollHeightx = totalScrollLength * 100;
					var scrollHeightDurationx = totalScrollLength * 70;
					
					if(ifPageHasScroll){
						Ext.get('indexmain-body').getActiveAnimation().paused = true;
						
						window.parent.Ext.getCmp('playBtn').ifScroll = true;
					}else{
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						if(ClickActionPause == true){
							//console.log('ClickActionPause',ClickActionPause)
							clearTimeout( clearTimeOut );
							window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						}
						else{
							//console.log('ClickActionPause',ClickActionPause)
							
							var clearTimeOut = Ext.defer(function(){
									window.parent.Ext.getCmp('tvmode').sliderObj.play();  
							},window.parent.Ext.getCmp('tvmode').getTimeFrequency)  
						}
					}
					
						$('body').scroll("b",
					scrollHeightx, 
					{
					duration:scrollHeightDurationx,
					listeners: {
							beforeanimate:function( el, eOpts ){		},
							afteranimate:function(el, startTime, eOpts ){
								Ext.get('indexmain-body').stopAnimation( );
								window.parent.Ext.getCmp('playBtn').ifScroll = false;				
								Ext.defer(function(){
									var runnerdestory =window.parent.Ext.getCmp('tvmode').sliderObj.play();
									runner.destroy();
									//console.log('runnerdestory',runnerdestory)
								},1000);
							}
						}
					},
					{
						scope: Ext.get('indexmain-body')
					});
					// end of scroll	
				
			}	
			}
			//end TV MODE AUTO SCROLL FUNCTION	
			else{
				try
				{
					$('#indexmain-body').scrollTop(val)	
				}
				catch (e1)
				{
				}				
			}
			},500);
})
/**
$('#diagram').renderSvg({
		renderTo: '#diagram',
		height:1500,
		zoom:true,
		draggable:false,
		width:$('#diagram').width(),
		url:url
	});
	**/

</script>

</body>
</html>


<%!

	public String getStateForSegment(String serviceName, String segmentName)
	{
		ServiceDAO dao = MonitorDAOFactory.getInstance().getServiceDAO();
		return dao.getStateForSegment(serviceName.trim(),"SEG:"+segmentName);
	}

%>