<%
/**
 *	File name	:	EgMoreInfos.jsp
 *	Purpose		:	Shows all infos of a test whose info count exceed a specified number
 *	Version		:	eG 3.1
 *	Created on	:	25-03-2004
 *	Modified	:	26-03-2004	Vijaykumar	GUI Changes
 *					05/05/2004	Arun		Modified to enable anchoring of links for DispMeasures if 
 *											the count exceeds 24.
 *					20/05/2004	Arun		Clubbed alarms with more infos now display correctly.
 *
 *	Author		:	Arun Jayaprakash
 */
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgMetaThread"%>
<%@ page import = "com.eg.EgMaintenanceInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.egurkha.admin.EgMaintenanceUtility"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.egurkha.*" %>
<%!
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo dateInfo = new EgDateInfo();
	EgTablesInfo tableInfo = new EgTablesInfo("manager");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%
	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject infoObject = null;
	JSONArray infoArray = new JSONArray();

	String queryString = request.getQueryString();
	IniUI ui = (IniUI)IniUI.getInstance();
	UserRegistry userReg = UserRegistry.getInstance();
	User user = userReg.getUser(session.getId());

	String refresh = user.getRefreshFrequency();
	long refreshRate = Long.valueOf(refresh);
	json.put("refreshRate",String.valueOf(refreshRate * 1000));

	int minInfos = EgConstants.MIN_SERVERS_FOR_SEARCH;

	String thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgMaintenanceInfo egM=new EgMaintenanceInfo("manager");
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgMaintenanceUtility maintenanceUtil=new EgMaintenanceUtility();
	EgTestInfo tokInfo = new EgTestInfo("manager");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String subTreeTests=(String)egUI.getValue("TEST_PANEL_SUBTREE","SubTreeTestList");
	ArrayList subTreeTestsList=new ArrayList();
	if(subTreeTests!=null && subTreeTests.trim().length()>0)
	{
		subTreeTestsList =  com.egurkha.util.StringUtils.egTokenizer(subTreeTests,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}
	String measureDisplay=request.getParameter("measure");
	if (measureDisplay == null)
	{
		measureDisplay = "";
	}
	if(measureDisplay!=null)
		measureDisplay=ui.getReverseLookupAll(measureDisplay);

	// -- For get the real info's from metetest db table...
	// by Saravanan.A on 21-Jun-2012
	Hashtable metaTest=(Hashtable)EgMetaThread.metaTest;
	if(metaTest == null)
		metaTest=new Hashtable();
	//---end---
%>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<jsp:useBean id="trans1" scope="page" class="egurkha.TransactionBean" />
<%
try
{
	String qctr = request.getParameter("qctr");
	String searchKey = request.getParameter("searchBox");
	List keyWords = new LinkedList();

	if (!StringUtils.isNull(searchKey))
	{
		String[] searchTokens = StringUtils.getTokens(searchKey,",");
		for (int a=0; a<searchTokens.length; a++)
		{
			if (!searchTokens[a].equalsIgnoreCase("and"))
			{
				String serTokVal=(String)searchTokens[a].toLowerCase();
				if(serTokVal!=null && serTokVal.trim().length()>0)
				{
					serTokVal=com.egurkha.util.StringUtils.replace(serTokVal,"|plus|","+");
					serTokVal=com.egurkha.util.StringUtils.replace(serTokVal,"|amp|","&");
					serTokVal=com.egurkha.util.StringUtils.replace(serTokVal,"|pct|","%");
					serTokVal=com.egurkha.util.StringUtils.replace(serTokVal,"|hash|","#");
				}
				keyWords.add(serTokVal);
			}
		}
	}
	else
	{
		searchKey = "";
	}

	String test = request.getParameter("test");
	if (test == null || test.equalsIgnoreCase("null"))
	{
		test = request.getParameter("testName");
		if (test == null || test.equalsIgnoreCase("null"))
		{
			test = "";
		}
	}


	String measure = null;
	int index = test.indexOf("-");
	if (index > -1)
	{
		measure = test.substring(index + 2);
		test = test.substring(0, index);
	}
	else if (qctr != null && qctr.equals("2"))
	{
		measure = request.getParameter("measure");

		if (measure == null)
		{
			measure = "";
		}

		measure=ui.getReverseLookupAll(measure);

	}
	else
	{
		measure = "";
	}


	
	
	String fromAlarm = request.getParameter("fromalarm");

	Map parameters = new HashMap();

	String str_site = request.getParameter("site");
	String str_host = request.getParameter("host");

	String str_layer = request.getParameter("layer");
	String s_flagalarm = request.getParameter("fromalarm");

	String str_host_type = null;
	String s_fake_type = request.getParameter("faketype");

	str_host_type = request.getParameter("comptype");

	String isInterface = request.getParameter("isInterface");
	isInterface = (isInterface==null)?"":isInterface;
	String selectedInterface = request.getParameter("selectedInterface");
	selectedInterface=(selectedInterface==null)?"":selectedInterface;

	String str_hosttype = str_host_type;
	Hashtable ht_testInfo = new Hashtable();
	Vector v_test = new Vector();
	Vector v_rept = new Vector();

	Hashtable testsForLayer = new Hashtable();

	// -- For get the real info's from metetest db table...
	// by Saravanan.A on 21-Jun-2012
	String org_comp_type=str_host_type;
	String org_host_name=str_host;
	ArrayList layersForComp = tableInfo.getLayersForComponent(org_comp_type);
	ArrayList layersForHostSystem = tableInfo.getLayersForComponent("Host_system");
	if(str_layer!=null && layersForHostSystem!=null && layersForHostSystem.contains(str_layer) && layersForComp!=null && layersForComp.contains(str_layer))
	{
		org_comp_type = "Host_system";
		StringTokenizer st = new StringTokenizer(str_host,":");
		if(st.countTokens()>0)
		{
			org_host_name = st.nextToken()+":NULL";
		}
	}
	//Hashtable testDetails =(Hashtable) metaTest.get(org_comp_type+":"+org_host_name);
	Hashtable testDetails = new Hashtable();
	boolean isCheckTestData=false;
	if(org_host_name!=null && org_host_name.trim().length()>0)
	{
		String tmp_host_name=org_host_name;
		if(tmp_host_name.indexOf(":")>-1)
			tmp_host_name = tmp_host_name.substring(0,tmp_host_name.indexOf(":"));

		List temp_type_list=(List)discInfo.getServerTypesForNick(tmp_host_name);

		if(temp_type_list!=null && temp_type_list.size()>1)
		{
			testDetails =(Hashtable) metaTest.get(org_comp_type+":"+org_host_name);
			isCheckTestData=true;
		}
	}
	if(testDetails == null)
		testDetails = new Hashtable();
	//---end---

	EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
	String str_conn=egDb.setConnection();
	ResultSet rs_report = null;
	boolean b_state1 = false,
			b_isTestRelevantForServer = false,
			b_timeOut = false;
			boolean isPortRelevant =  false;
	// To retrieve infos from measure_last table instead of metatest table.
	// by Saravanan.A changed on 14-12-2011.
	ArrayList testsFromML = new ArrayList();
	ArrayList infosFromML = new ArrayList();
	ArrayList msmtFromML = new ArrayList();
	Hashtable testWithMsmtHostHash = new Hashtable();
	try
	{
		String s_tempIp = null;
		String s_port = null;
		String compSid = "";

		if (str_host != null && (str_host.indexOf(EgConstants.COLON) > -1))
		{
			String temp[] = StringUtils.split(str_host, EgConstants.COLON);
			s_tempIp = temp[0];
			s_port = temp[1];

			if (s_port != null && (s_port.indexOf(EgConstants.COLON) > -1))
			{
				String s_port_temp[] = StringUtils.split(s_port, EgConstants.COLON);
				if(s_port_temp!=null && s_port_temp.length>0)
				{
					s_port = s_port_temp[0];
					compSid = s_port_temp[1];
				}
			}
		}
		else
		{
			if (str_host != null)
			{
				s_tempIp = str_host;
				s_port = EgConstants.BLANK_STRING;
			}
			else
			{
				s_tempIp = EgConstants.BLANK_STRING;
				s_port = EgConstants.BLANK_STRING;
			}
		}


		//new code for infos populate bug fix for multiple msmt_host 
		//String s_msmtHostQuery = "Select distinct(msmt_host),test_name from measure_last where trgt_host='" +s_tempIp+ "' and test_name not like '%_cf' ";
		String s_msmtHostQuery = "Select distinct(msmt_host),test_name from measure_last where trgt_host='" +s_tempIp+ "'";
		Vector v_msmtHost = new Vector();
		ResultSet rs_msmtHost=null;
		ResultSet rs_lastMeasure = null;
		try
		{
			rs_msmtHost = egDb.dbselect(s_msmtHostQuery);
			if(rs_msmtHost != null)
			{
				while(rs_msmtHost != null && rs_msmtHost.next())
				{
					String ss = rs_msmtHost.getString("msmt_host");
					String t_name = rs_msmtHost.getString("test_name");
					if (ss == null)
						continue;
					if(t_name != null && t_name.endsWith("_cf"))
						continue;
					if (!v_msmtHost.contains(ss))
						v_msmtHost.addElement(ss);

					if(testWithMsmtHostHash.size()==0)
					{
						ArrayList temp_mlist=new ArrayList();
						temp_mlist.add(ss);
						testWithMsmtHostHash.put(t_name,(ArrayList)temp_mlist);
					}
					else if(testWithMsmtHostHash.size()>0)
					{
						if(testWithMsmtHostHash.containsKey(t_name))
						{
							ArrayList temp_mlist=(ArrayList)testWithMsmtHostHash.get(t_name);
							temp_mlist.add(ss);
							testWithMsmtHostHash.put(t_name,(ArrayList)temp_mlist);
						}
						else
						{
							ArrayList temp_mlist=new ArrayList();
							temp_mlist.add(ss);
							testWithMsmtHostHash.put(t_name,(ArrayList)temp_mlist);
						}
					}
				}
				if (rs_msmtHost != null)
					rs_msmtHost.close();
			}

			if(v_msmtHost.size()==0)
				v_msmtHost.addElement("Test");
		}
		catch(Exception rss)
		{
			if (rs_msmtHost != null)
				try { rs_msmtHost.close(); } catch (Exception grr) {}
			rss.printStackTrace();
		}


		//new code for infos populate bug fix
		String s_temp = null;
		for(int i=0; i<v_msmtHost.size();i++)
		{
			String s_tempmsmtHost = (String) v_msmtHost.get(i);
			if(s_tempmsmtHost != null && s_tempmsmtHost.equalsIgnoreCase("Test"))
				s_tempmsmtHost=null;

			rs_lastMeasure = egDb.SelectLastMeasTimeInfo(s_tempIp, s_port, str_site, str_layer, s_tempmsmtHost,str_host_type);
			if (rs_lastMeasure != null)
			{
				try
				{
					while(rs_lastMeasure != null && rs_lastMeasure.next())
					{
						s_temp = rs_lastMeasure.getString("INFO");
						String port_number = rs_lastMeasure.getString("PORT_NO");
						if (s_temp!=null && s_temp.trim().equals(""))
							continue;

						// To retrieve infos from measure_last table instead of metatest table.
						// by Saravanan.A changed on 14-12-2011.

						String test_Name= rs_lastMeasure.getString("TEST_NAME");
						// -- Check whether the info have in metatest table
						// by Saravanan.A on 21-Jun-2012.
						//ArrayList testData = (ArrayList)testDetails.get(test_Name);
						ArrayList testData = new ArrayList();
						if(isCheckTestData)
						{
							testData = (ArrayList)testDetails.get(test_Name);
						}

						String temp_info=s_temp;
						if(!temp_info.startsWith("+") && str_host_type.equals("Oracle_server") && compSid.trim().length()>0)
						{
							String temp_sid=temp_info.substring(0,temp_info.indexOf("+"));
							if(temp_sid==null || (!compSid.trim().equals(temp_sid)))
								continue;
							temp_info=temp_info.substring(temp_info.indexOf("+"));
						}

						boolean isAddEntry=true;
						if(isCheckTestData && testData!=null && testData.size()>0)
						{
							isAddEntry=false;
							for(int z=0;z<testData.size();z=z+3)
							{
								String meta_info=(String)testData.get(z+1);
								if(meta_info!=null && temp_info!=null && meta_info.equals(temp_info))
								{
									isAddEntry=true;
									break;
								}
							}
						}

						//if(testData!=null && (testData.size()==0 || testData.contains(temp_info)))
						if(testData!=null && isAddEntry)
						{
							isPortRelevant = specsInfo.isPortRelevantForTest(test_Name, false);
							if(isPortRelevant)
							{
								if(s_port!=null && port_number!=null && port_number.equalsIgnoreCase(s_port))
								{
									ht_testInfo.put((test_Name+ "||" +s_temp+"||"+s_tempmsmtHost), rs_lastMeasure.getString("MSMT_TIME"));
									testsFromML.add(test_Name);
									infosFromML.add(temp_info);
									msmtFromML.add(s_tempmsmtHost);
								}
							}
							else
							{
								if(port_number!=null && (port_number.equalsIgnoreCase("NULL") || port_number.equalsIgnoreCase("NONE")))
								{
									ht_testInfo.put((test_Name+ "||" +s_temp+"||"+s_tempmsmtHost), rs_lastMeasure.getString("MSMT_TIME"));
									testsFromML.add(test_Name);
									infosFromML.add(s_temp);
									msmtFromML.add(s_tempmsmtHost);
								}
							}
						}
					}
					if (rs_lastMeasure != null)
						rs_lastMeasure.close();
					rs_lastMeasure = null;
				}
				catch (Exception grr)
				{
					if (rs_lastMeasure != null)
					{
						try
						{
							rs_lastMeasure.close();
							rs_lastMeasure = null;
						}
						catch (Exception g2)
						{
						}
					}
				}
			}
		}//for loop iteration for msmt_host
	}
	catch(Exception ex)
	{
		System.out.println("During last measurement time info from db "+ex);
		ex.printStackTrace();
	}
	Vector v_dummy = new Vector();
	try
	{
		// To get the disabled tests list.
		// by Saravanan.A changed on 14-12-2011.

		String disable = EgInstallInfo.getInstallDir()+"/manager/config/eg_disable.ini";
		IniFile disableIniObj = new IniFile(disable);
		
		if(str_host_type!=null)
			str_host_type=str_host_type.trim();

		if(str_host!=null)
			str_host=str_host.trim();

		boolean isAppLayer = tableInfo.isPortRelevantForLayer(str_host_type,str_layer.trim());
		String disp_value=null;
		String onlyHostName = str_host.substring(0,str_host.indexOf(":")).trim();
		if(isAppLayer)
			disp_value=disableIniObj.getValue(str_host_type,str_host_type+":"+str_host);
		else
			disp_value=disableIniObj.getValue("Default_server","Default_server:"+onlyHostName);

		if(disp_value!=null)
			disp_value=disp_value.trim();

		ArrayList dispTestList=new ArrayList();
		if(disp_value!=null && disp_value.length()>0)
		{
			StringTokenizer st=new StringTokenizer(disp_value,",");
			while(st.hasMoreTokens())
			{
				String value=st.nextToken();
				if(value!=null && value.trim().length()>0 && !dispTestList.contains(value))
				{
					dispTestList.add(value);
				}
			}
		}

		trans.createFile("eg_services.ini");
		boolean agentsOpened = false;
		long l_mgrTime = dateInfo.egetUTCDate(false);
		Hashtable timeoutCache = new Hashtable();
		Hashtable cutoffs = new Hashtable();
		Hashtable cache2 = new Hashtable();
		int countTests = testsFromML.size();
		int disableTestCount = 0;
		for(int r=0; r<countTests; r++)
		{
			b_timeOut = false;
			String s_test = (String)testsFromML.get(r);
			if(s_test!=null && s_test.trim().length()>0 && !dispTestList.contains(s_test))
			{
				if (s_test.equals(test))
				{
					b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
					if(s_flagalarm !=null && s_flagalarm.equals("1"))
					{
						if (s_fake_type != null && s_fake_type.length() > 0)
						{
							b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
						}
						else
							b_isTestRelevantForServer = true;
					}

					//dynamic infos code starts
					String s_info = (String) infosFromML.get(r);
					if(subTreeTestsList!=null && subTreeTestsList.size()>0 && test!=null && subTreeTestsList.contains(test) && (isInterface!=null && isInterface.equalsIgnoreCase("yes") || isInterface.equalsIgnoreCase("true")))
					{
						if(s_info!=null && s_info.trim().length()>0 && selectedInterface!=null && selectedInterface.trim().length()>0)
						{
							//String temp_InF_Info=s_info.substring(1,s_info.indexOf(":"));

							String test_seprater=(String)egUI.getValue("TEST_PANEL_SUBTREE",s_test);
							test_seprater=(test_seprater==null || test_seprater.trim().length()==0)?":":test_seprater;

							String temp_InF_Info=s_info;
							if(temp_InF_Info!=null && temp_InF_Info.indexOf(test_seprater)>-1)
							{
								temp_InF_Info=s_info.substring(1,s_info.indexOf(test_seprater));
								if(temp_InF_Info!=null)
									temp_InF_Info=temp_InF_Info.trim();
							}

							if(temp_InF_Info!=null)
							{
								if(!temp_InF_Info.equals(selectedInterface))
									continue;
							}
						}
					}

					String s_multiple = (String) cutoffs.get(s_test);
					//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
					if(s_multiple == null)
					{
						if(s_test != null && (s_test.endsWith("_ag") || s_test.endsWith("_agx")))
						{
							s_multiple = trans.getStrValue("CUT_OFF_FACTOR", s_test);

							if(s_multiple==null || s_multiple.trim().length()==0)
							{
								s_multiple = trans.getStrValue("CUT_OFF_FACTOR", "Default_AggregateTest");
							}
						}
						else if(s_test != null && s_test.endsWith("_rx"))
						{
							s_multiple = trans.getStrValue("CUT_OFF_FACTOR", s_test);
							if(StringUtils.isNull(s_multiple))
							{
								s_multiple = trans.getStrValue("CUT_OFF_FACTOR", "Default_CompositeTest");
							}
						}
						else
						{
							if(s_test!=null)
								s_multiple = trans.getStrValue("CUT_OFF_FACTOR", s_test);
						
							if(s_multiple==null || s_multiple.trim().length()==0)
							{
								s_multiple = trans.getStrValue("CUT_OFF_FACTOR", "Default");
							}
						}

						// -- if CUT_OFF_FACTOR null or empty then need to show all descriptors.
						if(s_multiple == null || s_multiple.trim().length()==0)
						{
							s_multiple="-1";
						}
						//---end---

						if(s_multiple!=null)
							cutoffs.put(s_test, s_multiple);
					}
					//ended here..
					if((s_multiple != null) && !(s_multiple.trim().equals("-1") &&  (s_multiple.trim().length() != 0)))
					{
						String s_temp = "";
						String s_testFreq = "";
						String s_msmtTime = "";
						String s_msmtHost = (String) msmtFromML.get(r);
						long l_multiple, l_testFreq, l_msmtTime= 0l;
						String s_ip = str_host.substring(0, str_host.indexOf(':'));
						String s_port = "";
						String s_tempStr = "";
						String s_tempStr1 = "";

						if (!agentsOpened)
						{
							trans1.createFile("eg_agents.ini");
							agentsOpened = true;
						}

						if(specsInfo.isPortRelevantForTest(s_test))
						{
							s_tempStr = s_test +":"+str_host_type+":"+ str_host;
							s_tempStr1 = s_test +"::"+ str_host;
						}
						else
						{
							s_tempStr = s_test +"::"+ s_ip;
							s_tempStr1 = s_test +":"+str_host_type+":"+ s_ip;
						}
						String ind2 = s_msmtHost+'~'+s_tempStr;
						s_temp = (String) cache2.get(ind2);
						if (s_temp == null)
						{
							s_temp = trans1.getStrValue(s_msmtHost, s_tempStr);
							if(s_temp == null || s_temp.trim().equals(""))
							{
								s_temp = trans1.getStrValue(s_msmtHost, s_tempStr1);
							}
							if (s_temp != null)
								cache2.put(ind2, s_temp);
						}
						
						s_testFreq = (s_temp.substring(s_temp.lastIndexOf(",")+1)).trim();
						if((s_testFreq != null) && s_testFreq.trim().length() != 0)
						{
							l_multiple = 0l;
							l_testFreq = 0l;
							try
							{
								l_multiple = Long.parseLong(s_multiple);
								l_testFreq = Long.parseLong(s_testFreq);
							}
							catch(Exception we)
							{
								we.printStackTrace();
							}

							if(str_hosttype != null && str_hosttype.equalsIgnoreCase("Oracle_server"))
							{
								s_msmtTime = (String)ht_testInfo.get(s_test + "||" + str_host.substring(str_host.lastIndexOf(":")+1)+ s_info+"||"+s_msmtHost);

								if(s_msmtTime==null || s_msmtTime.trim().length()==0)
								{
									s_msmtTime = (String)ht_testInfo.get(s_test + "||" + s_info+"||"+s_msmtHost);
								}
							}
							else
							{
								s_msmtTime = (String)ht_testInfo.get(s_test + "||" + s_info+"||"+s_msmtHost);
							}
							String ind3 = ind2+'~'+s_msmtTime;
							Boolean cc = (Boolean)timeoutCache.get(ind3);
							if (cc == null)
							{
								if(s_msmtTime != null && s_msmtTime.length() != 0)
								{
									String msmtTimeStrDate=s_msmtTime.substring(0,s_msmtTime.indexOf(" "));
									String msmtTimeStrTime=s_msmtTime.substring(s_msmtTime.indexOf(" ")+1);
									msmtTimeStrDate=com.egurkha.util.DateUtil.changeDateFormat(msmtTimeStrDate,"MM/dd/yyyy","dd/MM/yyyy");
									l_msmtTime = dateInfo.egetUTCDate(msmtTimeStrDate+" "+msmtTimeStrTime);
									
									if((l_mgrTime - l_msmtTime) > (l_multiple * l_testFreq * 1000l))
									{
										b_timeOut = true; 
										timeoutCache.put(ind3, new Boolean (true));
									} else 
										timeoutCache.put(ind3, new Boolean (false));
								}
								else if(s_msmtTime==null || s_msmtTime.trim().length()==0)
								{
									b_timeOut = true;
								}
							}
							else
							{
								if (cc.booleanValue())
									b_timeOut = true;
							}
						}
						else
						{
							b_timeOut = true;
						}
					}
					//dynamic infos code ends

					if(b_isTestRelevantForServer && (!b_timeOut))
					{
						v_test.addElement(s_test);
						String testName = s_test + "-" + s_info;
						String s_msmtHost = (String) msmtFromML.get(r);
						ArrayList al = (ArrayList) testsForLayer.get(testName);
						if (al == null)
						{
							al = new ArrayList();
							al.add(AlarmPriorities.GOOD_STATE);
							al.add(s_msmtHost);

							testsForLayer.put(testName, al);

						} else {
							al.add(AlarmPriorities.GOOD_STATE);
							al.add(s_msmtHost);
						}
					}
				}
			}
			else
			{
				disableTestCount++;
			}
		}

		if(countTests==disableTestCount)
		{
			b_timeOut = true;
		}

		rs_report = null;
		if((v_test.size() < 1) && (!b_timeOut))
		{
			ArrayList arr = tableInfo.getTestsForLayer(str_layer);
			ArrayList addedTest=new ArrayList();
			if(arr!=null && arr.size()>0)
			{
				for (int i=0;i<arr.size();i++)
				{
					String s_test=(String)arr.get(i);
					if(s_test!=null && s_test.trim().length()>0 && s_test.equals(test) && !dispTestList.contains(s_test) && !addedTest.contains(s_test) )
					{
						addedTest.add(s_test);
						//To check if the test is relevant for this type of server
						b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
						if(s_flagalarm !=null && s_flagalarm.equals("1"))
						{
							if (s_fake_type != null && s_fake_type.length() > 0)
								b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
							else
								b_isTestRelevantForServer = true;
						}

						if(b_isTestRelevantForServer && !b_timeOut)
						{
							v_test.addElement(s_test);

							String testName = s_test + "-+";

							ArrayList al = (ArrayList) testsForLayer.get(testName);
							if (al == null)
							{
								al = new ArrayList();
								al.add(AlarmPriorities.GOOD_STATE);
								al.add("");

								testsForLayer.put(testName, al);

							} else {
								al.add(AlarmPriorities.GOOD_STATE);
								al.add("");
							}
						}
					}
				}
			}
		}

		rs_report=egDb.SelectDispTest_2(str_site,s_flagalarm,str_host_type,str_host,str_layer,str_hosttype);
		boolean b_state2=egDb.getState();

		String s_dummy = "";
		while(rs_report != null && rs_report.next())
		{
			String s_test = rs_report.getString("test_name");
			if (s_test.equals(test))
			{
				b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
				if(s_flagalarm !=null && s_flagalarm.equals("1"))
				{
					if (s_fake_type != null && s_fake_type.length() > 0)
						b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
					else
						b_isTestRelevantForServer = true;
				}

				if(b_isTestRelevantForServer)
				{
					String rep_table_info=(String)rs_report.getString("info");

					if(subTreeTestsList!=null && subTreeTestsList.size()>0 && s_test!=null && subTreeTestsList.contains(s_test) && (isInterface!=null && isInterface.equalsIgnoreCase("yes") || isInterface.equalsIgnoreCase("true")))
					{
						if(rep_table_info!=null && rep_table_info.trim().length()>0 && selectedInterface!=null && selectedInterface.trim().length()>0)
						{
							String test_seprater=(String)egUI.getValue("TEST_PANEL_SUBTREE",s_test);
							test_seprater=(test_seprater==null || test_seprater.trim().length()==0)?":":test_seprater;

							String temp_InF_Info=rep_table_info;
							if(temp_InF_Info!=null && temp_InF_Info.indexOf(test_seprater)>-1)
							{
								temp_InF_Info=rep_table_info.substring(1,rep_table_info.indexOf(test_seprater));
								if(temp_InF_Info!=null)
									temp_InF_Info=temp_InF_Info.trim();
							}

							if(temp_InF_Info!=null)
							{
								if(!temp_InF_Info.equals(selectedInterface))
									continue;
							}
						}
					}

					v_rept.addElement(rs_report.getString("test_name")+ "-" +rep_table_info);
					v_rept.addElement(rs_report.getString("state"));
					v_rept.addElement(rs_report.getString("msmt_host"));
					s_dummy = (String)v_rept.get(v_rept.size()-3);

					if(s_dummy.endsWith("-+"))
					{
						v_dummy.addElement(s_dummy);
						v_dummy.addElement(v_rept.get(v_rept.size()-2));
						v_dummy.addElement(v_rept.get(v_rept.size()-1));
					}
				}
			}
		}

		if (rs_report != null)
			rs_report.close();
		rs_report = null;
		egDb.releaseConnection(false);
		AlarmPriorities ap = AlarmPriorities.getInstance();
		for(int jj =0; jj < v_dummy.size() ; jj= jj+3)
		{
				String sickStr = (String) v_dummy.get(jj);
				String overallstate = (String) v_dummy.get(jj+1);
				String chk1 = (String) v_dummy.get(jj+2);
				boolean fs = false;
				
				Enumeration ee3 = testsForLayer.keys();
				while (ee3.hasMoreElements())
				{
					String reallysick = (String) ee3.nextElement();
					// There is a state change irrespective of the info
					if (reallysick.startsWith(sickStr))
					{
						//Check for msmt_host
						ArrayList al = (ArrayList) testsForLayer.get(reallysick);
						if (al == null)
							continue;
						for (int r=0; r<al.size(); r=r+2)
						{
						   // Check for msmt_host
							String chk2 = (String) al.get(r+1);
							if(chk1!=null && chk2!=null && chk1.equals(chk2))
							{
								//change state only if not bad
								chk2 = (String) al.get(r);
								overallstate = ap.getHigherPriority(chk2, overallstate);
								al.set(r,overallstate);
							}
							else if(chk2!=null && chk2.equals(""))
							{
								al.set(r,v_dummy.get(jj+1));
							}
						}
					}
				}
		}

		String s_tmp =null;
		String s_tmp2 =null;
		for(int i =0;i< v_rept.size();i=i+3)
		{
			String stateFromAlarmTable = null;
			boolean sameMHosts= false;
			s_tmp =(String) v_rept.get(i);
			s_tmp = s_tmp.trim();
			String chk1 = (String) v_rept.get(i+2);
			String  MHost1 = chk1;
			String stateForInfo = null;
			int x;
			//fix starts 
			ArrayList al = (ArrayList) testsForLayer.get(s_tmp);
			int foundIndex = -1;
			if (al != null)
			{
				for (int r=0; r<al.size(); r= r+2)
				{
					String MHost2 = (String) al.get(r+1);
					stateForInfo = (String)al.get(r);
					if (MHost2.equals(MHost1))
					{
						sameMHosts = true;
						foundIndex = r;
						break;
					}
				}
			}

			String testInfo = s_tmp.substring(s_tmp.indexOf("+"));
			String testComp = s_tmp.substring(0,s_tmp.indexOf("-"));
			String check="yes";
			stateFromAlarmTable = EgAlarmTable.getTestPriority(str_host,str_host_type,str_layer,testInfo,testComp,chk1,"",check);		
			if (EgConfigInfo.isBad(stateForInfo))
			{
				if(stateFromAlarmTable!=null&&!stateFromAlarmTable.equals(""))
				{
					stateForInfo=stateFromAlarmTable;
				}
			}
			if (EgConfigInfo.isBad((String) v_rept.get(i+1)))
			{
				if(stateFromAlarmTable!=null&&!stateFromAlarmTable.equals(""))
				{
					v_rept.set(i+1,stateFromAlarmTable);
				}
			}
			if(sameMHosts)
			{
				if (EgConfigInfo.isBad(stateForInfo))
				{
					al.set(foundIndex, stateForInfo);
				}
				else
				{
					String s = ap.getHigherPriority(stateForInfo, (String) v_rept.get(i+1));
					al.set(foundIndex, s);
				}
			}
			else
			{
				//Hot fix - 14/04/2001 
				//To eliminate inconsistent display caused due to inconsistent Data
				
				boolean addreportData = true;
				Enumeration ee4 = testsForLayer.keys();
				boolean isMHost1Empty = (MHost1.length() == 0);
				int index2 = -1;
				while (ee4.hasMoreElements())
				{
					String realCompTest = (String) ee4.nextElement();
					if (realCompTest.startsWith(s_tmp))
					{
						String compTest = realCompTest.substring(0,realCompTest.indexOf("-+")+2);
						boolean equal = s_tmp.equals(compTest);
						if (!equal)
							continue;
						ArrayList cl = (ArrayList) testsForLayer.get(realCompTest);
						if (cl == null)
							continue;
						boolean found = false;
						for (int r=0; r<cl.size(); r= r+2)
						{
							String Mhost = (String) cl.get(r+1);
							if (!isMHost1Empty && Mhost.equals(""))
								addreportData = false;
							if (MHost1.equals(Mhost))
							{
								found = true;
								index2 = r;
								break;
							}
						}
						if (index2 >= 0)
							break;
					}
				}

				if (index2 < 0 && addreportData)
				{  // not equals match - lets do startsWith
					Enumeration ee = testsForLayer.keys();
					int ind = -1;
					String matchedKey = "";
					while (ee.hasMoreElements())
					{
						String realCompTest = (String) ee.nextElement();
						String compTest = realCompTest.substring(0,realCompTest.indexOf("-+")+2);
						if (s_tmp.startsWith(compTest))
						{
							ArrayList al4 = (ArrayList) testsForLayer.get(realCompTest);
							if (al4 == null)
								continue;
							for (int r=0; r<al4.size(); r=r+2)
							{
								String Mhost = (String) al4.get(r+1);
								if (MHost1.equals(Mhost))
								{
									ind = r;
									matchedKey = realCompTest;
									break;
								}
							}
							if (ind >= 0)
								break;
						}
					}
					if (ind >= 0)
					{
						ArrayList al5 = (ArrayList) testsForLayer.get(matchedKey);
						String chk2 = (String) al5.get(ind+1);
						//To check if both measurement hosts are same
						if (MHost1.equals(chk2) || chk2.length() == 0)
						{
							String pain = (String) al5.get(ind);
							String s = ap.getHigherPriority(pain.trim(),(String) v_rept.get(i+1));

							ArrayList bl = (ArrayList) testsForLayer.get((String) v_rept.get(i));
							if (bl == null)
							{
								bl = new ArrayList();
								bl.add(s);
								bl.add(v_rept.get(i+2));

								testsForLayer.put((String) v_rept.get(i),bl);

							} else {
								bl.add(s);
								bl.add(v_rept.get(i+2));
							}
							if (al5.size() == 2)
							{
								testsForLayer.remove(matchedKey);
							} else {
								al5.remove(ind);
								al5.remove(ind); // remove state and mhost
							}
						}
					}
					else {
						ArrayList al6 = (ArrayList) testsForLayer.get(s_tmp);
						if (al6 == null)
						{
							al6 = new ArrayList();
							al6.add((String) v_rept.get(i+1));
							al6.add((String) v_rept.get(i+2));
							testsForLayer.put(s_tmp,al6);
						} else {
							al6.add((String) v_rept.get(i+1));
							al6.add((String) v_rept.get(i+2));
						}
					}
				}
			}
		}
	}
	catch(Exception e)
	{
		if(!str_conn.equals("CONNECTED"))
		{
			out.println("Connection could not be established");
		}
		else if(!b_state1==true)
		{
			out.println("Error in Sql Query");
		}
		else
		{
			out.println(e.toString());
		}
		if (rs_report != null)
		{
			try
			{
				rs_report.close();
				rs_report = null;
			} catch (Exception bug123) {}
		}
		try
		{
			egDb.releaseConnection(true);
		}
		catch(Exception e2)
		{
		}
	}

	EgDbAdapterTypeUI.releaseObject(egDb);
	
	Enumeration ee1 = testsForLayer.keys();
	List finalTestsForLayer = new LinkedList();
	while (ee1.hasMoreElements())
	{
		String key = (String) ee1.nextElement();

		int key_inx=key.indexOf("-");
		String temp_test=key.substring(0,key_inx);
		if(temp_test!=null)
			temp_test=temp_test.trim();

		ArrayList al = (ArrayList) testsForLayer.get(key);
		if (al == null)
			continue;

		ArrayList temp_m_list=(ArrayList)testWithMsmtHostHash.get(temp_test);

		if(temp_m_list==null || (temp_m_list!=null && temp_m_list.size()==1))
		{
			if (al.size() == 2)
				al.set(1,"");
		}
		else if(temp_m_list!=null && temp_m_list.size()>1 && !v_dummy.contains(temp_test+"-+"))
		{
			if (al.size() == 2)
				al.set(1,"");
		}

		for (int r=0; r<al.size(); r=r+2)
		{
			String prior = (String) al.get(r);
			finalTestsForLayer.add(key);
			finalTestsForLayer.add(prior);
			finalTestsForLayer.add((String) al.get(r+1));
		}
	}

	LayerModel lm = new LayerModel(finalTestsForLayer, request);
	com.egurkha.monitor.Test[] infos = lm.getTests();
	int size = infos.length;

	String[] keys = {
						"site",		"host",		"layer",
						"comptype",	"faketype",	"fromalarm",
						"showAll",	"searchBox"
					};

	parameters.put("test",EgURLEncoder.encode((test==null?"":test),"UTF-8"));

	for (int a=0; a<keys.length; a++)
	{
		parameters.put(keys[a],EgURLEncoder.encode((request.getParameter(keys[a])==null?"":request.getParameter(keys[a])),"UTF-8"));
	}


	/*
	 * If the number of infos exceed EgConstants.MIN_SERVERS_FOR_SEARCH, which is 25,
	 * show the SEARCH option.
	 */
	if (size >= minInfos)
	{
		screenLabels.put("testDescriptor",mappingInfo.getTextDescription("monitor.moreinfo.Test Descriptor"));
		screenLabels.put("search",mappingInfo.getTextDescription("monitor.moreinfo.SEARCH"));
		screenLabels.put("pageInfo",mappingInfo.getTextDescription("monitor.layermodel.You can search using any character present in the descriptor. Multiple search strings should be separated using a blank space."));
	}

	int infosDisplayed = 0;
	boolean foundInfo = false;
	boolean hasKeyWords = (keyWords.size() > 0);
	if (!hasKeyWords)
	{
		foundInfo = true;
	}

	if (size > 0)
	{
		int count = 0;					//Counts number of cells drawn so far
		int maxPerRow = 3;				//Maximum cells per row
		int maxRows = 8;				//Maximum rows that will be displayed before the scrollbar appears
		
		int rows = size/maxPerRow;		//Minimum number of rows in the table
		if (size % maxPerRow > 0)
		{
			rows++;						//If empty cells have to be drawn, that means an extra row
		}

		int emptyCount = Math.abs(size - (maxPerRow * rows));
		int width = 100/maxPerRow;		//By default width = 25
		if (size < maxPerRow)
		{
			width = 100 / size;
		}

		for (int a=0; a<infos.length; a++)
		{
			infoObject = new JSONObject();
			com.egurkha.monitor.Test info = infos[a];
			String state = info.getTestState();
			
			String infoStr = info.getTestInfo();

			infoStr = ui.getReverseLookupAll(infoStr);

			infoStr = ui.getLookupAll(infoStr);

			String testNameForMaintenance=info.getTestName();
			if(testNameForMaintenance!=null && testNameForMaintenance.length()>0)
					testNameForMaintenance=testNameForMaintenance.trim();

			String curDatTime=dateInfo.egetDate();
			String descript=info.getTestLabel(false);
			if(descript!=null && descript.length()>0)
			{
				descript=ui.getReverseLookupAll(descript);
				descript=descript.trim();
			}
			String compName = request.getParameter("host");
			String hostName="";
			String portNo="";
			String sid="";

			if(!StringUtils.isNull(compName) && compName.indexOf(":")>0)
			{
				StringTokenizer stkHostStr=new StringTokenizer(compName,":");
				if(stkHostStr.hasMoreTokens())
					hostName=stkHostStr.nextToken();
				if(stkHostStr.hasMoreTokens())
					portNo=stkHostStr.nextToken();
				if(stkHostStr.hasMoreTokens())
					sid=stkHostStr.nextToken();
			}

			boolean isDescriptorMaintenanceForTest=egM.isItMaintenanceTime(testNameForMaintenance, curDatTime,descript);
			boolean isDescriptorMaintenanceForComponentTest=egM.isItMaintenanceTime(testNameForMaintenance, curDatTime, hostName, portNo,sid,descript);
			
			boolean isItMaintenace = false;
			List maintenancePeriodVec=new ArrayList();
			List maintenaceTimePeriod=new ArrayList();
			if(isDescriptorMaintenanceForTest)
			{
				isItMaintenace = true;
				maintenancePeriodVec=egM.getMaintenancePeriods(testNameForMaintenance,descript);
				if(maintenancePeriodVec!=null)
				{
					maintenaceTimePeriod.addAll(maintenancePeriodVec);
				}
				maintenancePeriodVec=egM.getUnplannedMaintenancePeriods(testNameForMaintenance,descript);
				if(maintenancePeriodVec!=null)
					maintenaceTimePeriod.addAll(maintenancePeriodVec);
			}
			if(isDescriptorMaintenanceForComponentTest)
			{
				isItMaintenace = true;
				maintenancePeriodVec=egM.getMaintenancePeriods(testNameForMaintenance, hostName, portNo, sid,descript);
				if(maintenancePeriodVec!=null)
				{
					maintenaceTimePeriod.addAll(maintenancePeriodVec);
				}
				maintenancePeriodVec=egM.getUnplannedMaintenancePeriods(testNameForMaintenance, hostName, portNo, sid,descript);
				if(maintenancePeriodVec!=null)
					maintenaceTimePeriod.addAll(maintenancePeriodVec);
			}
			int noOfLines=maintenaceTimePeriod.size();
			String descriptorMaintenaceTimePeriodStr=maintenanceUtil.convertMaintenacevectorToString(maintenaceTimePeriod,user);
		
			if (hasKeyWords)
			{
				for (Iterator i=keyWords.iterator(); i.hasNext(); )
				{
					String value = (String)i.next();
					if (infoStr.toLowerCase().indexOf(value) > -1)
					{
						foundInfo = true;
						break;
					}
				}
			}
			if (foundInfo)
			{
				infosDisplayed++;
				StringBuffer text = new StringBuffer(32);
				text.append(ui.getReverseLookupAll(infoStr));
				if (!StringUtils.isNull(info.getMsmtHost()))
				{
					text.append(" (");
					text.append(info.getMsmtHost());
					text.append(") ");
				}
				String infoText = text.toString();
				if(infoText!=null && infoText.trim().length()==0)
				{
					infoText="&nbsp;";
				}
				String displayText = null;

				// for symbols replace with images work start
				String testLabel_for_display=infoText;
				String test_name_value=test;
				String isSymbol=(String)egUI.getValue("Tests_For_LayerModel_Images",test_name_value);
				boolean flageInside=false;
				String skipInfos=(String)egUI.getValue("MISC_ARGS","FINAL_INFO");
									
				boolean symbolBlock=true;
				ArrayList exclude_info_list = new ArrayList();
				if(skipInfos!=null && skipInfos.trim().length()>0)
					exclude_info_list = tokInfo.egTokenizer(skipInfos, ",");
				
				if(exclude_info_list!=null && testLabel_for_display!=null && exclude_info_list.contains(testLabel_for_display.trim()))
					symbolBlock=false;

				if(symbolBlock && isSymbol!=null && isSymbol.trim().equalsIgnoreCase("::") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
				{
					String temp_testLabel="";
					ArrayList token_list = tokInfo.egTokenizer(testLabel_for_display, "::");
					
					if(token_list!=null && token_list.size()>0)
					{
						String end_image_name_value="";
						String tooltip_value="";
						for(int ind_no=0;ind_no<token_list.size();ind_no++)
						{
							String path=(String)token_list.get(ind_no);

							if(ind_no==0)
							{
								if(test_name_value!=null && test_name_value.equals("RHEVMDataCenTest") || test_name_value.equals("RHEVMStorageTest") || test_name_value.equals("RHEVMClusterTest"))
								{
									end_image_name_value="descriptor_rhev_datacenter";
									tooltip_value="monitor.layermodel.Datacenter";
								}
								else
								{
									end_image_name_value="descriptor_vsphere_datacenter";
									tooltip_value="monitor.layermodel.Datacenter";
								}
							}
							else if(ind_no==1)
							{
								if(test_name_value!=null && test_name_value.equals("RHEVMStorageTest"))
								{
									end_image_name_value="descriptor_rhev_datastore";
									tooltip_value="monitor.layermodel.Data&nbsp;Storage";
								}
								else if(test_name_value!=null && test_name_value.equals("RHEVMClusterTest"))
								{
									end_image_name_value="descriptor_rhev_cluster";
									tooltip_value="monitor.layermodel.Cluster";
								}
								else
								{
									end_image_name_value="descriptor_vsphere_cluster";
									tooltip_value="monitor.layermodel.Cluster";
								}
							}
							else if(ind_no==2)
							{
								end_image_name_value="descriptor_vsphere_resourcepool";
								tooltip_value="monitor.layermodel.monitor.layermodel.Resource&nbsp;pool";
							}

							if(path!=null && path.trim().length()>0)
							{
								ArrayList path_list = tokInfo.egTokenizer(path, "->");
								if(path_list!=null && path_list.size()==2)
								{
									String folder_part=(String)path_list.get(0);
									if(folder_part!=null && folder_part.trim().length()>0)
									{
										ArrayList folder_list = tokInfo.egTokenizer(folder_part, "\\");
										if(folder_list!=null && folder_list.size()>0)
										{
											for(int w=0;w<folder_list.size();w++)
											{
												String folder_name=(String)folder_list.get(w);
												temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+folder_name.trim();
											}
										}
									}

									String dc_or_cl_rp_path=(String)path_list.get(1);
									if(dc_or_cl_rp_path!=null && dc_or_cl_rp_path.trim().length()>0)
									{
										ArrayList dc_or_cl_rp_list = tokInfo.egTokenizer(dc_or_cl_rp_path,"/");
							
										if(dc_or_cl_rp_list!=null && dc_or_cl_rp_list.size()>0)
										{
											for(int w=0;w<dc_or_cl_rp_list.size();w++)
											{
												String dc_or_cl_rp_name=(String)dc_or_cl_rp_list.get(w);

												temp_testLabel=temp_testLabel+" <img class='"+end_image_name_value+"' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value)+"' /> "+dc_or_cl_rp_name.trim();
											}
										}
									}
								}
								else if(path_list!=null && path_list.size()==1)
								{
									String dc_or_cl_rp_path=(String)path_list.get(0);
									if(dc_or_cl_rp_path!=null && dc_or_cl_rp_path.trim().length()>0)
									{
										ArrayList dc_or_cl_rp_list = tokInfo.egTokenizer(dc_or_cl_rp_path,"/");
							
										if(dc_or_cl_rp_list!=null && dc_or_cl_rp_list.size()>0)
										{
											for(int w=0;w<dc_or_cl_rp_list.size();w++)
											{
												String dc_or_cl_rp_name=(String)dc_or_cl_rp_list.get(w);

												temp_testLabel=temp_testLabel+" <img class='"+end_image_name_value+"' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value)+"' /> "+dc_or_cl_rp_name.trim();
											}
										}
									}
								}
							}
						}
						if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
						{
							testLabel_for_display=temp_testLabel;
							flageInside=true;
						}
					}
				}
				else if(symbolBlock && isSymbol!=null && isSymbol.trim().equalsIgnoreCase("/") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
				{
					String temp_testLabel="";
					ArrayList resourcepool_list = tokInfo.egTokenizer(testLabel_for_display,"/");
					if(resourcepool_list!=null && resourcepool_list.size()>0)
					{
						for(int w=0;w<resourcepool_list.size();w++)
						{
							String resourcepool_name=(String)resourcepool_list.get(w);
							temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_resourcepool' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Resource pool")+"' /> "+resourcepool_name.trim();
						}
					}
					if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
					{
						testLabel_for_display=temp_testLabel;
						flageInside=true;
					}
				}
				//code added here
				else if(symbolBlock && isSymbol!=null && isSymbol.trim().equalsIgnoreCase("$eg^") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
				{
					String temp_testLabel="";
					if(test_name_value.equals("MsSqlDatabaseTest") || test_name_value.equals("MsSqlDBStatusTest") || test_name_value.equals("MsSqlLongRunQryTest") || test_name_value.equals("MsSqlMissingIdxTest") || test_name_value.equals("MsSqlNetTest") || test_name_value.equals("MsSqlSpaceTest") || test_name_value.equals("MsSqlTabSizeTest") || test_name_value.equals("MsSqlTransSpaceTest") || test_name_value.equals("MsSqlUnusedIdxTest"))
					{
						temp_testLabel=temp_testLabel+" <img class='descriptor_database' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.DB")+"'/> "+testLabel_for_display.trim();
					}
					else if(test_name_value.equals("MsSqlAppsTest") || test_name_value.equals("MsSqlSessionStTest"))
					{
						temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+testLabel_for_display.trim();
					}
					else if(test_name_value.equals("CtxAppTest")|| test_name_value.equals("CtxXcXAAppTest"))
					{
						String testLabel_for_display_name=testLabel_for_display.trim();
						if(testLabel_for_display_name.indexOf(':') != -1)
						{
							StringTokenizer strToken = new StringTokenizer(testLabel_for_display_name,":");
							String firstString=strToken.nextToken();
							String secondString=strToken.nextToken();
							if(firstString!=null && firstString.indexOf('\\') != -1)
							{
								String folderName=firstString.substring(0,firstString.lastIndexOf('\\'));
								StringTokenizer stringToken = new StringTokenizer(folderName,"\\");
								while (stringToken.hasMoreElements())
								{
									temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
								}
								String workGroup=firstString.substring(firstString.lastIndexOf('\\')+1);
								temp_testLabel=temp_testLabel+" <img class='descriptor_workgroup' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.WorkerGroup")+"'/> "+workGroup;
							}
							else
							{
								if(firstString!=null && firstString.indexOf('/') != -1)
								{
									String folderName=firstString.substring(0,firstString.lastIndexOf('/'));
									StringTokenizer stringToken = new StringTokenizer(folderName,"/");
									while (stringToken.hasMoreElements())
									{
										temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
									}
									String workGroup=firstString.substring(firstString.lastIndexOf('/')+1);
									temp_testLabel=temp_testLabel+" <img class='descriptor_workgroup' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.WorkerGroup")+"'/> "+workGroup;
								}
								else
								{
									temp_testLabel=temp_testLabel+" <img class='descriptor_workgroup' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.WorkerGroup")+"'/> "+firstString;
								}
							}
							if(secondString!=null && secondString.indexOf('\\') != -1)
							{
								String folderName=secondString.substring(0,secondString.lastIndexOf('\\'));
								StringTokenizer stringToken = new StringTokenizer(folderName,"\\");
								while (stringToken.hasMoreElements())
								{
									temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
								}
								String applicationName=secondString.substring(secondString.lastIndexOf('\\')+1);
								temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+applicationName;
							}
							else
							{	
								if(secondString!=null && secondString.indexOf('/') != -1)
								{
									String folderName=secondString.substring(0,secondString.lastIndexOf('/'));
									StringTokenizer stringToken = new StringTokenizer(folderName,"/");
									while(stringToken.hasMoreElements())
									{
										temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
									}
									String applicationName=secondString.substring(secondString.lastIndexOf('/')+1);
									temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+applicationName;
								}
								else
								{
									temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+secondString;
								}
							}
						}//end if :
						else if(testLabel_for_display_name.indexOf('\\') != -1)
						{
							String folderName=testLabel_for_display_name.substring(0,testLabel_for_display_name.lastIndexOf('\\'));
							StringTokenizer stringToken = new StringTokenizer(folderName,"\\");
							while(stringToken.hasMoreElements())
							{
								temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
							}
							String applicationName=testLabel_for_display_name.substring(testLabel_for_display_name.lastIndexOf('\\')+1);
							temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+applicationName;
							
						}
						else if(testLabel_for_display_name.indexOf('/') != -1)
						{
							String folderName=testLabel_for_display_name.substring(0,testLabel_for_display_name.lastIndexOf('/'));
							StringTokenizer stringToken = new StringTokenizer(folderName,"/");
							while(stringToken.hasMoreElements())
							{
								temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+stringToken.nextElement();
							}
							String applicationName=testLabel_for_display_name.substring(testLabel_for_display_name.lastIndexOf('/')+1);
							temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+applicationName;
						}
						else
						{
							temp_testLabel=temp_testLabel+" <img class='descriptor_application' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Application")+"'/> "+testLabel_for_display.trim();
						}
					} //end if for citrix
					else
					{
						temp_testLabel=temp_testLabel+" <img class='descriptor_user' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.User")+"'/> "+testLabel_for_display.trim();
					}
					if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
						testLabel_for_display=temp_testLabel;
				}
				//code end here
				else if(symbolBlock && isSymbol!=null && isSymbol.trim().equalsIgnoreCase(":") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
				{
					String temp_testLabel="";
					ArrayList token_list = tokInfo.egTokenizer(testLabel_for_display, ":");
					if(token_list!=null && token_list.size()>0)
					{
						String end_image_name_value="";
						String image_name_value2="";
						String tooltip_value="";
						String tooltip_value2="";
						for(int ind_no=0;ind_no<token_list.size();ind_no++)
						{
							String path=(String)token_list.get(ind_no);

							if(ind_no==0)
							{
								end_image_name_value="descriptor_xen_desktop_controller";
								tooltip_value="monitor.layermodel.Controller";

								image_name_value2="descriptor_xen_desktop_group";
								tooltip_value2="monitor.layermodel.Desktop&nbsp;Groups";
							}
							else if(ind_no==1)
							{
								end_image_name_value="descriptor_xen_desktop";
								tooltip_value="monitor.layermodel.Desktop";
							}

							if(path!=null && path.trim().length()>0)
							{
								if(ind_no==0)
								{
									ArrayList path_list = tokInfo.egTokenizer(path, "->");
									if(path_list!=null && path_list.size()==2)
									{
										String controller=(String)path_list.get(0);
										
										temp_testLabel=temp_testLabel+" <img class='"+end_image_name_value+"' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value)+"'/> "+controller.trim();
										
										String folder_and_groupName=(String)path_list.get(1);

										if(folder_and_groupName!=null && folder_and_groupName.trim().length()>0)
										{
											ArrayList f_and_g_list = tokInfo.egTokenizer(folder_and_groupName, "\\");

											if(f_and_g_list!=null && f_and_g_list.size()>0)
											{
												if(f_and_g_list.size()==2)
												{
													String  folder_name=(String)f_and_g_list.get(0);
													temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' style='margin-top:2px' src ='/final/images/clear.png'  border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+folder_name.trim();

													String group_name=(String)f_and_g_list.get(1);
													temp_testLabel=temp_testLabel+" <img class='"+image_name_value2+"' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value2)+"'/> "+group_name.trim();
												}
												else if(f_and_g_list.size()==1)
												{
													String groupName=(String)f_and_g_list.get(0);
													temp_testLabel=temp_testLabel+" <img class='"+image_name_value2+"' style='margin-top:2px' src ='/final/images/clear.png' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value2)+"'/> "+groupName.trim();
												}
											}
										}
									}
									else if(path_list!=null && path_list.size()==1)
									{
										String folder_and_groupName=(String)path_list.get(0);

										if(folder_and_groupName!=null && folder_and_groupName.trim().length()>0)
										{
											ArrayList f_and_g_list = tokInfo.egTokenizer(folder_and_groupName, "\\");

											if(f_and_g_list!=null && f_and_g_list.size()>0)
											{
												if(f_and_g_list.size()==2)
												{
													String  folder_name=(String)f_and_g_list.get(0);
													temp_testLabel=temp_testLabel+" <img class='descriptor_vsphere_folder' src ='/final/images/clear.png' style='margin-top:2px' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+folder_name.trim();
													
													String group_name=(String)f_and_g_list.get(1);
													temp_testLabel=temp_testLabel+" <img class='"+image_name_value2+"' src ='/final/images/clear.png' style='margin-top:2px' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value2)+"'/> "+group_name.trim();
												}
												else if(f_and_g_list.size()==1)
												{
													String groupName=(String)f_and_g_list.get(0);
													temp_testLabel=temp_testLabel+" <img class='"+image_name_value2+"' src ='/final/images/clear.png' style='margin-top:2px' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value2)+"'/> "+groupName.trim();
												}
											}
										}
									}
								}
								else if(ind_no==1)
								{
									ArrayList path_list = tokInfo.egTokenizer(path, "\\");
									if(path_list!=null && path_list.size()==2)
									{
										String  domain_name=(String)path_list.get(0);
										
										temp_testLabel=temp_testLabel+" <img class='descriptor_domain_name' src ='/final/images/clear.png' style='margin-top:2px' border = '0' title='"+mappingInfo.getTextDescription("monitor.layermodel.Domain")+"'/> "+domain_name.trim();
										
										String deskTopName=(String)path_list.get(1);

										temp_testLabel=temp_testLabel+" <img class='"+end_image_name_value+"' src ='/final/images/clear.png' style='margin-top:2px' border = '0' title='"+mappingInfo.getTextDescription(tooltip_value)+"'/> "+deskTopName.trim();
									}
									else if(path_list!=null && path_list.size()==1)
									{
										String deskTopName=(String)path_list.get(0);

										temp_testLabel=temp_testLabel+" <img class='"+end_image_name_value+"' src ='/final/images/clear.png' style='margin-top:2px'  border = '0' title='"+mappingInfo.getTextDescription(tooltip_value)+"'/> "+deskTopName.trim();
									
									}
								}
							}
						}
					}
					if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
							testLabel_for_display=temp_testLabel;
				}

				if(testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
				{
					displayText=testLabel_for_display;
					if(subTreeTestsList!=null && subTreeTestsList.size()>0 && test!=null && subTreeTestsList.contains(test)  && (isInterface!=null && isInterface.equalsIgnoreCase("yes") || isInterface.equalsIgnoreCase("true")))
					{
						if(displayText!=null && displayText.trim().length()>0 && selectedInterface!=null && selectedInterface.trim().length()>0)
						{
							//String temp_InF_Info=displayText.substring(0,displayText.indexOf(":"));

							String test_seprater=(String)egUI.getValue("TEST_PANEL_SUBTREE",test);
							test_seprater=(test_seprater==null || test_seprater.trim().length()==0)?":":test_seprater;

							String temp_InF_Info=displayText;
							if(temp_InF_Info!=null && temp_InF_Info.indexOf(test_seprater)>-1)
							{
								temp_InF_Info=displayText.substring(0,displayText.indexOf(test_seprater));
								if(temp_InF_Info!=null)
									temp_InF_Info=temp_InF_Info.trim();
							}

							if(temp_InF_Info!=null)
							{
								if(temp_InF_Info.equals(selectedInterface))
								{
									//displayText=displayText.substring(displayText.indexOf(":")+1);
									displayText=displayText.substring(displayText.indexOf(test_seprater)+1);
								}
							}
						}
					}
					flageInside=true;
				}
				// for symbols replace with images work end
				
				if(!flageInside)
				{
					if(subTreeTestsList!=null && subTreeTestsList.size()>0 && test!=null && subTreeTestsList.contains(test) && (isInterface!=null && isInterface.equalsIgnoreCase("yes") || isInterface.equalsIgnoreCase("true")))
					{
						if(infoText!=null && infoText.trim().length()>0 && selectedInterface!=null && selectedInterface.trim().length()>0)
						{
							//String temp_InF_Info=infoText.substring(0,infoText.indexOf(":"));

							String test_seprater=(String)egUI.getValue("TEST_PANEL_SUBTREE",test);
							test_seprater=(test_seprater==null || test_seprater.trim().length()==0)?":":test_seprater;

							String temp_InF_Info=infoText;
							if(temp_InF_Info!=null && temp_InF_Info.indexOf(test_seprater)>-1)
							{
								temp_InF_Info=infoText.substring(0,infoText.indexOf(test_seprater));
								if(temp_InF_Info!=null)
									temp_InF_Info=temp_InF_Info.trim();
							}

							if(temp_InF_Info!=null)
							{
								if(temp_InF_Info.equals(selectedInterface))
								{
									//infoText=infoText.substring(infoText.indexOf(":")+1);
									infoText=infoText.substring(infoText.indexOf(test_seprater)+1);
								}
							}
						}
					}

					if (infoText.length() <= 42)
					{
						displayText = infoText;
					}
					else
					{
						displayText = StringUtils.elipsis(infoText, 42);
					}
				}

				infoObject.put("infoText",infoText);
				infoObject.put("testState",info.getTestState());
				infoObject.put("labelDescription",mappingInfo.getLabelDescription(info.getTestState()));
				String en_infoStr=com.egurkha.util.StringUtils.encodeSecurityChar(infoStr);
				if(isDescriptorMaintenanceForTest || isDescriptorMaintenanceForComponentTest)
				{
					infoObject.put("link",this.getUrl(parameters, (size > (maxPerRow * maxRows)))+"&measure="+EgURLEncoder.encode(en_infoStr,"UTF-8")+"&qctr=2&msmt_host="+info.getMsmtHost()+"&tstate="+info.getTestState()+"&moreinfos=yes&isInterface="+isInterface+"&selectedInterface="+selectedInterface);

					infoObject.put("infoText",displayText);

					if (infoText.length() > 42)
					{
						//out.print("title=\"");
						//out.print(infoText);
						//out.print("\"");
					}

					if(measureDisplay!=null && measureDisplay.equalsIgnoreCase(infoText))
					{
						infoObject.put("selection","true");
					}
					else
					{
						infoObject.put("selection","false");
					}

					//JSONObject maintenanceDetails = new JSONObject();
					infoObject.put("maintanaceTimePeriod",descriptorMaintenaceTimePeriodStr);
					infoObject.put("numberOfLines",noOfLines);
					//infoObject.put("maintenance",maintenanceDetails);
					infoObject.put("isItMaintenace",isItMaintenace);
				}
				else
				{
					infoObject.put("link",this.getUrl(parameters, (size > (maxPerRow * maxRows)))+"&measure="+EgURLEncoder.encode(en_infoStr,"UTF-8")+"&qctr=2&msmt_host="+info.getMsmtHost()+"&tstate="+info.getTestState()+"&moreinfos=yes&isInterface="+isInterface+"&selectedInterface="+selectedInterface);

					infoObject.put("infoText",displayText);

					if (infoText.length() > 42)
					{
						//out.print("title=\"");
						//out.print(infoText);
						//out.print("\"");
					}

					if(measureDisplay!=null && measureDisplay.equalsIgnoreCase(infoText))
					{
						infoObject.put("selection","true");
					}
					else
					{
						infoObject.put("selection","false");
					}
				}

				count++;
				size--;
				if ((maxPerRow == count) || (size == 0))
				{//End of the row
					if ((rows > 1) && (size == 0))
					{//Only if rows are more than 1. Otherwise the cells will be center-aligned by default
						for (int z=0; z<emptyCount; z++)
						{
							//out.print("<td id=\"cell_border6\" class=\"lineright\" nowrap=\"nowrap\" width=\"");
							//out.print(width);
							//out.println("%\">&nbsp;</td>");
						}
					}
					//out.print("</tr>"); Commented by Premkumar

					//out.print("<tr>");
					//out.print("<td colspan=\"4\" id=\"eg_blankspace\" height='10' style=\"padding:0px\">");
					//out.print("&nbsp;</td>");
					//out.println("</tr>");
					count = 0;
				}
			}

			/*
			 * Set variable to false again, so that 
			 * 1. all infos can be displayed if no search key is specified
			 * 2. only those infos can be displayed that match the search key
			 */
			if (hasKeyWords)
			{
				foundInfo = false;
			}
			if(!infoObject.isEmpty())
				infoArray.add(infoObject);
		}//End of for (Iterator...)
	}
	if (infosDisplayed == 0)
	{
		/*
		 * No infos matched queryString
		 */
		json.put("error",mappingInfo.getTextDescription("monitor.moreinfo.No infos found matching search criteria."));
	}

	screenLabels.put("component",mappingInfo.getTextDescription("monitor.moreinfo.Component"));
	screenLabels.put("layer",mappingInfo.getTextDescription("monitor.moreinfo.Layer"));
	screenLabels.put("test",mappingInfo.getTextDescription("monitor.moreinfo.Test"));

	if(str_host.indexOf(":NULL") > -1)
	{
		str_host = str_host.substring(0,str_host.indexOf(":NULL"));
	}

	json.put("qctr",qctr);
	json.put("site",str_site);
	json.put("component",str_host);
	json.put("layer",mappingInfo.getLayerDescription(str_layer));
	json.put("componentType",mappingInfo.getComponentTypeDescription(str_host_type));
	json.put("layerPriority",request.getParameter("layerPriority"));
	json.put("test",mappingInfo.getTestDescription(test));
	json.put("faketype",request.getParameter("faketype"));
	json.put("showAll","yes");
	json.put("searchKey",searchKey);

	json.put("screenLabels",screenLabels);
	json.put("infoArray",infoArray);

	response.getWriter().write(json.toString());
}
catch(Exception e)
{
	System.out.println("Exception "+e);
}
%>
<%!
	public String getUrl(Map map, boolean requireAnchor)
	{
		Object[] keySet = map.keySet().toArray();
		
		StringBuffer url = new StringBuffer(64);
		url.append("EgMoreInfosView.jsp?");

		for (int a=0; a<keySet.length; a++)
		{
			if (a > 0)
			{
				url.append("&");
			}

			url.append(keySet[a]);
			url.append("=");

			Object value = map.get(keySet[a]);
			if (value != null)
			{
				url.append(value);
			}
		}

		if (requireAnchor)
		{
			url.append("&requireAnchor=true");
		}

		return url.toString();
	}
%>