<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "java.util.*"%>
<%@ page import = "java.sql.*"%>
<%@ page import = "java.text.*" %>
<%@ page import = "java.io.*" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.monitor.MonitorUtility"%>
<%@ page import = "com.egurkha.monitor.MonitorUtilities"%>
<%@ page import = "org.joda.time.*"%>
<%@ page import = "java.util.Map.Entry"%>
<%
	response.setContentType("text/html;charset=UTF-8");
%>

<%!
	DecimalFormat percentFormat = new DecimalFormat("#.##");

	public Hashtable getMeasuresData(String rumQuery, User user, String dateFormatForDatePicker) { 
		com.eg.EgDateInfo egDate = new com.eg.EgDateInfo();
		ResultSet rs = null;
		Hashtable resultData = new Hashtable();
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		try{
			String s_status = egDb.setConnection();
			if(s_status.equals("CONNECTED")){
				rs = egDb.dbselect(rumQuery);
			}
			ResultSetMetaData metaData = rs.getMetaData();
			int noOfColumns = metaData.getColumnCount();
			while(rs.next()){
				for (int i = 1; i <=noOfColumns ; i++ ) {
					String columnName = metaData.getColumnName(i);
					if(columnName != null && columnName.equalsIgnoreCase("MSMT_TIME")){
						String time = rs.getString(i);
						try{
							SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							java.util.Date date = sdf.parse(time);
							long millis = date.getTime();
							java.util.Date local_date = new java.util.Date(millis);
							TimeZone tz = egDate.getRealTimeZone();
							String tzName = tz.getDisplayName(tz.inDaylightTime(local_date), TimeZone.SHORT);
							time = DateUtil.changeDateFormat(time,"yyyy-MM-dd HH:mm:ss",dateFormatForDatePicker+" HH:mm:ss");
							EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(time,user);
							time = time+" "+tzName;
						}
						catch(Exception ex){
							ex.printStackTrace();
						}
						resultData.put(columnName,time);
					}
					else
						resultData.put(columnName,rs.getString(i));
				}
			}
			if(rs != null)
				rs.close();
		}
		catch (Exception e){
			e.printStackTrace();
		}
		finally{
			if(rs != null){
				try{
					rs.close();
				}catch(Exception ex){}
			}
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		return resultData;
	}

	public JSONObject buildJSON(String testName, String monitor_Skin, Hashtable measureDataMap,  EgMappingInfo mappingInfo, HashMap orderMap, Hashtable stateMeasure, User user){

		JSONObject rootJson = new JSONObject();
		JSONObject allJson = new JSONObject();
		JSONObject userJson = new JSONObject();
		JSONObject networkJson = new JSONObject();
		JSONObject backendJson = new JSONObject();
		JSONObject contentDownloadJson = new JSONObject();
		JSONObject browserJson = new JSONObject();
		JSONObject headerJson = new JSONObject();
		JSONObject gridData = new JSONObject();

		MonitorUtilities monUtilities = new MonitorUtilities(user);
		MonitorUtility monUtil = new MonitorUtility();
		com.eg.IniFile egDashConfig = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_dashboardConfig.ini", false);
		HashMap testMeasureConversionMap = new HashMap();
		String[] testMeasureCon = egDashConfig.getVariables("ExtTestDashboard_Unit_Convert");
		Vector testMeasureConVal = egDashConfig.getAllValues("ExtTestDashboard_Unit_Convert");
		if(testMeasureCon != null && testMeasureCon.length > 0){
			for(int k=0;k<testMeasureCon.length;k++)
				testMeasureConversionMap.put(testMeasureCon[k],(String)testMeasureConVal.get(k));
		}
		if(orderMap != null && orderMap.size() > 0){
			ArrayList measureOrderList = (ArrayList)orderMap.get("TopoGraph");
			userJson.put("USER_NAME","");
			if(measureOrderList != null && measureOrderList.size() > 0){
				String meas = (String)measureOrderList.get(0);
				if(stateMeasure.containsKey(meas))
				{
					String infoData = (String) measureDataMap.get("INFO");
					networkJson.put("MeasureState",(String)stateMeasure.get(infoData+":"+meas));
					//networkJson.put("MeasureState",(String)stateMeasure.get(meas));
				}
				else
					networkJson.put("MeasureState","GOOD");
				String value = (String)measureDataMap.get((String)measureOrderList.get(1));
				String unit = (String)measureOrderList.get(3);
				if(value != null && value.trim().length() > 0 && !value.equals("-") && !value.equals("-5") && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
					value = monUtilities.convertValue(String.valueOf(value),unit,(String)testMeasureConversionMap.get(testName+":"+meas));
					value = monUtil.formatDbValue(value,2);
					unit = (String)testMeasureConversionMap.get(testName+":"+meas);
					networkJson.put("MeasureVal",Double.parseDouble(value));
				}
				else if(value.equals("-5"))
				{
					networkJson.put("MeasureVal","-");
				}
				else
					networkJson.put("MeasureVal",Double.parseDouble(value));

				networkJson.put("MeasureVal",Double.parseDouble(value));
				networkJson.put("MeasureDispName",(String)measureOrderList.get(2));
				networkJson.put("MeasureUnit",unit);

				meas = (String)measureOrderList.get(4);
				unit = (String)measureOrderList.get(7);
				if(stateMeasure.containsKey(meas))
				{
					String infoData = (String) measureDataMap.get("INFO");
					backendJson.put("MeasureState",(String)stateMeasure.get(infoData+":"+meas));
					//backendJson.put("MeasureState",(String)stateMeasure.get(meas));
				}
				else
					backendJson.put("MeasureState","GOOD");
				value = (String)measureDataMap.get((String)measureOrderList.get(5));
				if(value != null && value.trim().length() > 0 && !value.equals("-") && !value.equals("-5") && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
					value = monUtilities.convertValue(String.valueOf(value),unit,(String)testMeasureConversionMap.get(testName+":"+meas));
					value = monUtil.formatDbValue(value,2);
					unit = (String)testMeasureConversionMap.get(testName+":"+meas);
					backendJson.put("MeasureVal",Double.parseDouble(value));
				}
				else if(value.equals("-5"))
				{
					backendJson.put("MeasureVal","-");
				}
				else
					backendJson.put("MeasureVal",Double.parseDouble(value));
				
				backendJson.put("MeasureDispName",(String)measureOrderList.get(6));
				backendJson.put("MeasureUnit",unit);

				meas = (String)measureOrderList.get(8);
				unit = (String)measureOrderList.get(11);
				if(stateMeasure.containsKey(meas))
				{
					String infoData = (String) measureDataMap.get("INFO");
					contentDownloadJson.put("MeasureState",(String)stateMeasure.get(infoData+":"+meas));
					//contentDownloadJson.put("MeasureState",(String)stateMeasure.get(meas));
				}
				else
					contentDownloadJson.put("MeasureState","GOOD");
				value = (String)measureDataMap.get((String)measureOrderList.get(9));
				if(value != null && value.trim().length() > 0 && !value.equals("-") && !value.equals("-5") && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
					value = monUtilities.convertValue(String.valueOf(value),unit,(String)testMeasureConversionMap.get(testName+":"+meas));
					value = monUtil.formatDbValue(value,2);
					unit = (String)testMeasureConversionMap.get(testName+":"+meas);
					contentDownloadJson.put("MeasureVal",Double.parseDouble(value));
				}
				else if(value.equals("-5"))
				{
					contentDownloadJson.put("MeasureVal","-");
				}
				else
					contentDownloadJson.put("MeasureVal",Double.parseDouble(value));
				
				contentDownloadJson.put("MeasureDispName",(String)measureOrderList.get(10));
				contentDownloadJson.put("MeasureUnit",unit);

				if((measureOrderList.size()/4) == 4){
					meas = (String)measureOrderList.get(12);
					unit = (String)measureOrderList.get(15);
					if(stateMeasure.containsKey(meas))
					{
						String infoData = (String) measureDataMap.get("INFO");
						browserJson.put("MeasureState",(String)stateMeasure.get(infoData+":"+meas));
						//browserJson.put("MeasureState",(String)stateMeasure.get(meas));
					}
					else
						browserJson.put("MeasureState","GOOD");
					value = (String)measureDataMap.get((String)measureOrderList.get(13));
					if(value != null && value.trim().length() > 0 && !value.equals("-") && !value.equals("-5") && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
						value = monUtilities.convertValue(String.valueOf(value),unit,(String)testMeasureConversionMap.get(testName+":"+meas));
						value = monUtil.formatDbValue(value,2);
						unit = (String)testMeasureConversionMap.get(testName+":"+meas);
						browserJson.put("MeasureVal",Double.parseDouble(value));
					}
					else if(value.equals("-5"))
					{
						browserJson.put("MeasureVal","-");
					}
					else
						browserJson.put("MeasureVal",Double.parseDouble(value));
					
					browserJson.put("MeasureDispName",(String)measureOrderList.get(14));
					browserJson.put("MeasureUnit",unit);
				}
			}

			if(orderMap.containsKey("Grid")){
				measureOrderList = (ArrayList)orderMap.get("Grid");
				if(measureOrderList != null && measureOrderList.size() > 0){
					JSONArray dataArr = new JSONArray();
					String unit = "";
					String meas = (String)measureOrderList.get(0);
					if(meas != null && meas.trim().length() > 0 && !meas.equals("null")){
						gridData.put("Title",mappingInfo.getTextDescription("monitor.Topology."+meas));
						dataArr.add(gridData);
					}
					for(int k=1;k<measureOrderList.size();k=k+4){
						gridData = new JSONObject();
						meas = (String)measureOrderList.get(k);
						if(stateMeasure.containsKey(meas))
						{
							String infoData = (String) measureDataMap.get("INFO");
							gridData.put("MeasureState",(String)stateMeasure.get(infoData+":"+meas));
						}
						else
							gridData.put("MeasureState","GOOD");
						unit = (String)measureOrderList.get(k+3);
						String value = (String)measureDataMap.get((String)measureOrderList.get(k+1));
						if(value != null && value.trim().length() > 0 && !value.equals("-") && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
							value = monUtilities.convertValue(String.valueOf(value),unit,(String)testMeasureConversionMap.get(testName+":"+meas));
							value = monUtil.formatDbValue(value,2);
							unit = (String)testMeasureConversionMap.get(testName+":"+meas);
							gridData.put("MeasureVal",Double.parseDouble(value));
						}
						else if(value != null && value.trim().length() > 0 && !value.equals("-") && (value.equals("-5") || value.equals("-1")) && testMeasureConversionMap != null && testMeasureConversionMap.size() > 0 && testMeasureConversionMap.containsKey(testName+":"+meas)){
							unit = (String)testMeasureConversionMap.get(testName+":"+meas);
							gridData.put("MeasureVal","-");
						}
						else
							gridData.put("MeasureVal",Double.parseDouble(value));
						
						gridData.put("MeasureDispName",(String)measureOrderList.get(k+2));
						gridData.put("MeasureUnit",unit);
						dataArr.add(gridData);
					}
					rootJson.put("gridData",dataArr);
				}
			}
			if(orderMap.containsKey("HeaderSubData")){
				com.eg.IniFile extMonIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_extmondash.ini", false);
				measureOrderList = (ArrayList)orderMap.get("HeaderSubData");
				if(measureOrderList != null && measureOrderList.size() > 0){
					gridData = new JSONObject();
					for(int k=0;k<measureOrderList.size();k=k+2){
						String key = (String)measureOrderList.get(k);
						String value = (String)measureDataMap.get(key);
						String icon = "";
						String dispName = (String)measureOrderList.get(k+1);
						if(dispName != null && dispName.trim().length() >0 && dispName.indexOf("~") != -1){
							icon = dispName.substring(dispName.indexOf("~")+1);
							dispName = dispName.substring(0,dispName.indexOf("~"));
							gridData.put(dispName+"_icon",icon);
						}
						if(key != null && key.equalsIgnoreCase("Component")){
							value = (value.endsWith(EgConstants.NULL_PORT) && (value.indexOf(EgConstants.NULL_PORT) > -1))?Server.getServerNameWithoutPort(value, false):value;
						}
						else if(key != null && key.equalsIgnoreCase("Location")){
							String loc = extMonIni.getValue("Eg_External_Agents_Locations",(String)measureDataMap.get("MSMT_HOST"));
							if(loc != null && loc.trim().length() > 0){
								gridData.put(dispName,loc);
								continue;
							}
							else
								gridData.remove(dispName+"_icon");
						}
						gridData.put(dispName,value);
					}
					rootJson.put("HeaderSubData",gridData);
				}
			}
		}

		String info = (String)measureDataMap.get("INFO");
		info = (info != null && info.startsWith("+"))?info.substring(1):info;
		headerJson.put("MeasureTime",measureDataMap.get("MSMT_TIME"));
		headerJson.put("INFO",info);
		headerJson.put("Test",measureDataMap.get("Test"));
		headerJson.put("title",mappingInfo.getTextDescription("monitor.common."+measureDataMap.get("Test")+" Response Breakdown"));

		allJson.put("skin",monitor_Skin);
		allJson.put("user_Info",userJson);
		allJson.put("network_Info",networkJson);
		allJson.put("backend_Info",backendJson);
		allJson.put("contentDownload_Info",contentDownloadJson);
		if(browserJson != null && browserJson.size() > 0)
			allJson.put("browser_Info",browserJson);
		allJson.put("header_Info",headerJson);
		//allJson.put("mappingName_Info",mappingNameObj);
		rootJson.put("topology",allJson);

		return rootJson;
	}

%>
<!DOCTYPE html>
<!--<html id="rumBTM">-->
<html id="externalMonitors">
	<head>
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width"/>
		<title>Topology</title>
	
<script>
	document.write('<egui:skin ui="monitor"/>');
</script>

<%
	if(monitor_Skin!=null && monitor_Skin.equals("Dark"))
	{
%>
<link type="text/css" href="/final/monitor/eg_scripts/comparisonDashboard/css/eGDarkThemeEMDTopology.css" rel="stylesheet" media="all" />
<%
	}
	else if(monitor_Skin!=null && monitor_Skin.equals("Light"))
	{
%>
<link type="text/css" href="/final/monitor/eg_scripts/comparisonDashboard/css/eGLightThemeEMDTopology.css" rel="stylesheet" media="all" />
<%
	}
%>

		<script type="text/javascript" src="/final/extjs/ext-all.js"></script>
		<script type="text/javascript" src="/final/jquery/jquery.js"></script>
		<!-- script src="/final/scripts/d3.min.js" script -->
		<script src="/final/Highcharts/js/highstock.js"></script>
		<script src="/final/Highcharts/js/modules/exporting.js"></script>
	</head>
	<body>
<%
	com.eg.EgDbInfo dbInfo = new com.eg.EgDbInfo("manager");
	com.eg.EgTablesInfo tablesInfo = new com.eg.EgTablesInfo("manager");
	com.eg.EgDiscInfo discInfo = new com.eg.EgDiscInfo("manager");
	HashMap orderMap = new HashMap();
	ArrayList measureOrderList = new ArrayList();
	ArrayList gridMeasureOrderList = new ArrayList();
	ArrayList toggleOrderList = new ArrayList();
	List compTypeList = new ArrayList();
	List compNameList = new ArrayList();
	List testList = new ArrayList();
	String host = request.getParameter("host");
	String port = request.getParameter("port");
	String testName = request.getParameter("testName");
	String measures = request.getParameter("measures");
	String info = request.getParameter("info");
	String keyMeasure = request.getParameter("keyMeasure");
	String measure = "";
	String dbMeasure = "";
	String unitMeasure = "";
	if(keyMeasure != null && keyMeasure.trim().length() > 0){
		gridMeasureOrderList.add("null"); //to add title in the list
		if(keyMeasure.indexOf("~") != -1){
			gridMeasureOrderList.add(keyMeasure.substring(0,keyMeasure.indexOf("~")));
			dbMeasure =  dbInfo.getColumnForMeasure(testName,keyMeasure.substring(0,keyMeasure.indexOf("~")));
			if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
				dbMeasure = keyMeasure.substring(0,keyMeasure.indexOf("~"));
			measure += ","+dbMeasure;
			gridMeasureOrderList.add(dbMeasure);
			gridMeasureOrderList.add(mappingInfo.getTextDescription("monitor.Topology."+keyMeasure.substring(keyMeasure.indexOf("~")+1)));
			unitMeasure = (tablesInfo.getUnitForMeasure(testName,keyMeasure.substring(0,keyMeasure.indexOf("~")))).toLowerCase();
			unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"secs":unitMeasure;
			gridMeasureOrderList.add(unitMeasure);
		}
		else{
			gridMeasureOrderList.add(keyMeasure);
			dbMeasure =  dbInfo.getColumnForMeasure(testName,keyMeasure);
			if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
				dbMeasure = keyMeasure;
			String dispName = mappingInfo.getMeasureDescription(testName,keyMeasure);
			measure += ","+dbMeasure;
			gridMeasureOrderList.add(dbMeasure);
			gridMeasureOrderList.add(dispName);
			unitMeasure = (tablesInfo.getUnitForMeasure(testName,keyMeasure)).toLowerCase();
			unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"secs":unitMeasure;
			gridMeasureOrderList.add(unitMeasure);
		}
	}
	
	if(measures != null && measures.trim().length() > 0){
		StringTokenizer st = new StringTokenizer(measures,"^$^");
		while(st.hasMoreTokens()){
			dbMeasure = "";
			unitMeasure = "";
			String param = (String)st.nextToken();
			if(param != null && param.trim().length() > 0){
				if(param.startsWith("HeaderSubData")){
					StringTokenizer st1 = new StringTokenizer(param,"#");
					while(st1.hasMoreTokens()){
						dbMeasure = "";
						String toggleParam = (String)st1.nextToken();
						if(toggleParam != null && toggleParam.trim().length() > 0 && !toggleParam.equalsIgnoreCase("HeaderSubData")){
							if(toggleParam.indexOf("~") != -1){
								dbMeasure = toggleParam.substring(0,toggleParam.indexOf("~"));
								if(dbMeasure != null && !dbMeasure.equalsIgnoreCase("Component") && !dbMeasure.equalsIgnoreCase("INFO") && !dbMeasure.equalsIgnoreCase("URL") && !dbMeasure.equalsIgnoreCase("Location"))
									measure += ","+dbMeasure;
								toggleOrderList.add(dbMeasure);
								toggleOrderList.add(toggleParam.substring(toggleParam.indexOf("~")+1));
							}
							else{
								if(toggleParam != null && !toggleParam.equalsIgnoreCase("Component") && !toggleParam.equalsIgnoreCase("INFO") && !toggleParam.equalsIgnoreCase("URL") && !toggleParam.equalsIgnoreCase("Location"))
									measure += ","+toggleParam;
								toggleOrderList.add(toggleParam);
								toggleOrderList.add(mappingInfo.getTextDescription("monitor.Topology."+toggleParam));
							}
						}
					}
				}
				else if(param.startsWith("Grid")){
					StringTokenizer st1 = new StringTokenizer(param,"#");
					while(st1.hasMoreTokens()){
						dbMeasure = "";
						unitMeasure = "";
						String gridParam = (String)st1.nextToken();
						if(gridParam != null && gridParam.trim().length() > 0){
							if(gridParam.startsWith("Grid")){
								gridMeasureOrderList.set(0,gridParam.substring(gridParam.indexOf("~")+1));
								continue;
							}
							else if(gridParam.indexOf("~") != -1){
								gridMeasureOrderList.add(gridParam.substring(0,gridParam.indexOf("~")));
								dbMeasure =  dbInfo.getColumnForMeasure(testName,gridParam.substring(0,gridParam.indexOf("~")));
								if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
									dbMeasure = gridParam.substring(0,gridParam.indexOf("~"));
								measure += ","+dbMeasure;
								gridMeasureOrderList.add(dbMeasure);
								unitMeasure = tablesInfo.getUnitForMeasure(testName,gridParam.substring(0,gridParam.indexOf("~")));
								unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"Secs":unitMeasure;
								gridMeasureOrderList.add(mappingInfo.getTextDescription("monitor.Topology."+gridParam.substring(gridParam.indexOf("~")+1)));
								gridMeasureOrderList.add(unitMeasure);
							}
							else{
								gridMeasureOrderList.add(gridParam);
								dbMeasure =  dbInfo.getColumnForMeasure(testName,gridParam);
								if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
									dbMeasure = gridParam;
								String dispName = mappingInfo.getMeasureDescription(testName,gridParam);
								measure += ","+dbMeasure;
								gridMeasureOrderList.add(dbMeasure);
								unitMeasure = tablesInfo.getUnitForMeasure(testName,gridParam);
								unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"Secs":unitMeasure;
								gridMeasureOrderList.add(dispName);
								gridMeasureOrderList.add(unitMeasure);
							}
						}
					}
				}
				else{
					if(param.indexOf("~") != -1){
						measureOrderList.add(param.substring(0,param.indexOf("~")));
						dbMeasure =  dbInfo.getColumnForMeasure(testName,param.substring(0,param.indexOf("~")));
						if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
							dbMeasure = param.substring(0,param.indexOf("~"));
						measure += ","+dbMeasure;
						measureOrderList.add(dbMeasure);
						measureOrderList.add(mappingInfo.getTextDescription("monitor.Topology."+param.substring(param.indexOf("~")+1)));
						unitMeasure = tablesInfo.getUnitForMeasure(testName,param.substring(0,param.indexOf("~")));
						unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"Secs":unitMeasure;
						measureOrderList.add(unitMeasure);
					}
					else{
						measureOrderList.add(param);
						dbMeasure =  dbInfo.getColumnForMeasure(testName,param);
						if(dbMeasure == null || dbMeasure.equals("") || dbMeasure.trim().length() == 0)
							dbMeasure = param;
						String dispName = mappingInfo.getMeasureDescription(testName,param);
						measure += ","+dbMeasure;
						measureOrderList.add(dbMeasure);
						measureOrderList.add(dispName);
						unitMeasure = tablesInfo.getUnitForMeasure(testName,param);
						unitMeasure = (unitMeasure != null && unitMeasure.equalsIgnoreCase("seconds"))?"secs":unitMeasure;
						measureOrderList.add(unitMeasure);
					}
				}
			}
		}
	}
	if(toggleOrderList != null && toggleOrderList.size() > 0)
		orderMap.put("HeaderSubData",toggleOrderList);

	if(gridMeasureOrderList != null && gridMeasureOrderList.size() > 0)
		orderMap.put("Grid",gridMeasureOrderList);

	if(measureOrderList != null && measureOrderList.size() > 0)
		orderMap.put("TopoGraph",measureOrderList);

	if(measure != null && measure.startsWith(","))
		measure = measure.substring(1);

	String lockVar = "";
	if(!EgDbInfo.isOraAdapter)
		lockVar = "with (NOLOCK)";

	String query  = "SELECT "+measure+",a.INFO,a.MSMT_TIME,a.trgt_host,a.port_no FROM "+testName +" a "+lockVar+", (select max(msmt_time) msmt_time,trgt_host,port_no,info from measure_last "+lockVar;

	String condition = "";
	if(host != null && host.trim().length() > 0)
		condition += " trgt_host='"+host+"'";

	if(port != null && port.trim().length() > 0)
		condition += " and port_no='"+port+"'";

	if(info != null && info.trim().length() > 0)
		condition += " and info='"+info+"'";

	if(condition != null && condition.trim().length() > 0)
		query += " where "+condition;
	
	query += "group by trgt_host,port_no,info) b where a.trgt_host=b.trgt_host and a.port_no=b.port_no and a.info=b.info and a.msmt_time=b.msmt_time";

	MonitorUtility monUtil = new MonitorUtility();
	String compTy = discInfo.getServerTypesForComponentNamePort(host + ":" + port);
	compTypeList.add(compTy);
	compNameList.add(host + ":" + port);
	testList.add(testName);
	Hashtable stateMap = new Hashtable();
	Hashtable stateMeasure = monUtil.getComponentState(null,compTypeList,compNameList,null,testList,null,null,null);
	if(stateMeasure != null && stateMeasure.size() > 0){
		Iterator itreator = stateMeasure.entrySet().iterator();
		while(itreator.hasNext())
		{
			Entry entry = (Entry) itreator.next();
			String stateKey = (String)entry.getKey();
			String stateValue = (String) entry.getValue();
			ArrayList temp_data_list =  com.egurkha.util.StringUtils.egTokenizer(stateKey.trim(), "^eg^",true,false,true);//param 3-->includeEmpty,4-->unique,5-->trim

			if(temp_data_list.size() == 8){
				String measureName =(String) temp_data_list.get(7);
				String temInfo =(String) temp_data_list.get(6);
				stateMap.put(temInfo+":"+measureName,stateValue);
			}
		}
	}
	
	Hashtable measureDataMap = getMeasuresData(query,u_ser,dateFormatForDatePicker);
	measureDataMap.put("Test",mappingInfo.getTestDescription(testName));
	measureDataMap.put("Component",host+":"+port);
	if(toggleOrderList != null && toggleOrderList.contains("URL")){
		com.eg.EgSpecsInfo specsInfo = new com.eg.EgSpecsInfo("manager");
		egurkha.TestStatusInfo teststatus = new egurkha.TestStatusInfo();
		String pat = specsInfo.getTestInfoPattern(testName);
		String del = specsInfo.getTestInfoDelimiter(testName);
		String tmpInfo = (info != null && info.startsWith("+"))?info.substring(1):info;
		String pattern = teststatus.getPatternForInfo(testName.trim(), compTy.trim(), host.trim()+ ":" + port.trim() ,null, tmpInfo.trim(), "-" + pat, del);
		pattern = (pattern != null && pattern.endsWith("\""))?pattern.substring(0,pattern.length()-1):pattern;
		measureDataMap.put("URL",pattern);
	}
	JSONObject jsonResult = buildJSON(testName, monitor_Skin, measureDataMap, mappingInfo, orderMap, stateMap,u_ser);
	%>
	
	<script>
		var data = <%=jsonResult%>;
		var extMonLbl = '<egui:intnl text="monitor.Topology.Synthetic Monitoring for"/>';
		var atLbl = '<egui:intnl text="monitor.common.at"/>';
		var extagent='<egui:intnl text="monitor.common.External Agent"/>';
		var urlLbl = '<egui:intnl text="monitor.Topology.URL Accessed"/>';
		var compLbl = '<egui:intnl text="monitor.common.Component"/>';
		var footerLbl = '<egui:intnl text="monitor.common.Times shown are in Seconds"/>';
	</script>
	<script src="/final/monitor/eg_scripts/BuildTopologyGraph.js"></script>
	</body>
<html>