<%
/*********************************************************************************************************
*	File name			:	EgIndependentServers.jsp
*	Purpose				:	Shows independent servers associated to the currently logged in user.
*	Version				:	eG 4.0
*	Author				:	Sandhya Kollath
*	Creation Date	:	05/12/2001
*	Last Date			:	03/03/2003	Arun	Reflect priorities of BAD states 
*							21/03/2003	Arun	Redid server-layout code. Fixed bug in the layout
*							17/06/2003	Arun	Changed search mechanism to follow that in EgMonitorOperations
*							10/09/2003	Arun	Server names do not show :NULL
*							13/10/2003	Arun	Modified to use User/UserRegistry
*							28/10/2003	John	Fixed the description cell width
*							04/10/2003	Arun	Fixed the compName truncation bug
*							05/12/2003	Arun	Fixed state inconsistency for Site-associated servers 
*							31/05/2006  James Thomas modified this file to display selected servers of a user
*********************************************************************************************************/
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage = "EgErrorSmall.jsp" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.io.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "egurkha.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);

	String showAllComponents = request.getParameter("showAllComponents");
	EgTablesInfo tablesInfo=null;
%>
<html>
<head>
<title> &nbsp; eG Manager &nbsp; ? &nbsp; Independent Components &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<meta name="Author" content="John Williams" />
<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />
<meta http-equiv="refresh" content="100;url=EgIndependentServers.jsp?<%=request.getQueryString()%>">
<script language="JavaScript1.2" src="eg_scripts/eg_validate.js"></script>
<script language="JavaScript1.2">
function valform()
{
	var thisForm = document.showservers;
	var servertype = thisForm.servertype.options[thisForm.servertype.options.selectedIndex].value;
	var servername = thisForm.servername.value;

	var sub = checkspecial(thisForm.servername,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
	if(sub)
	{
		//when servername is '192.168.10.12 and 192.168.10.13', replace space by '*'
		for(var x=0;x<servername.length;x++)
		{
			if(servername.charAt(x) == ' ')
			{
				servername = servername.replace(' ','*');
			}
		}
		if(servername == "")
		{
			window.location.href = "EgIndependentServers.jsp?stype=" + servertype + "&flag=type&segment="+seg+"&service="+ser+"&showAllComponents=<%=showAllComponents%>";
		}
		else
		{
			window.location.href = "EgIndependentServers.jsp?stype=" + servertype + "&sname=" + servername + "&flag=both&segment="+seg+"&service="+ser+"&showAllComponents=<%=showAllComponents%>"
		}
	}
	else
	{
		thisForm.servername.focus();
	}
}
</script>
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" id="eg_innerbg">
<!-- <jsp:useBean id="egasp" scope="page" class="egurkha.EgAspLite" /> -->
<jsp:useBean id="sitebean" scope="page" class="egurkha.ConfigSiteBean" />
<%
	boolean excludeCompSeg = showAllComponents==null || showAllComponents.equals("false");

	int minServers = EgConstants.MIN_SERVERS_FOR_SEARCH;

	AlarmPriorities ap = AlarmPriorities.getInstance();
	List v_comp_type_name = new Vector();
	List indServers = new Vector();
	Vector v_comp_type = new Vector();

	//String s_userid = (String) session.getAttribute("sess_userid");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String s_userid = user.getLoginID();

	String s_org_sname = "";
	String s_qry = "";
	String s_conn = "";
	boolean showservers = true;
	boolean checkflag = true;
	ResultSet rs = null;

	//Variables declared for CA change
	StringTokenizer st = null;
	String comp_type = "";
	String comp_name = "";
	String server = null;
	String state = "";
	String s_tmp_state = "";
	String box_name = "";
	String val = "";
	String hostName = "";
	String portNo = "";
	String sid = "";

	//New code : Box_name from UniCenter
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	Hashtable ipmap = discInfo.getNickIpMap();
	box_name = request.getParameter("box");

	if(box_name != null && !box_name.equals("null") && !box_name.equals(""))
	{
		v_comp_type_name.clear();
		Vector v_allServers = discInfo.getAllManagedComponents();
		for(int i=0; i<v_allServers.size(); i++)
		{
			val = (String)v_allServers.get(i);
			st = new StringTokenizer(val,",");
			int tokCount = st.countTokens();

			comp_type = st.nextToken();
			st.nextToken();
			comp_name = st.nextToken();
			portNo = st.nextToken();
			if(tokCount > 4)
			{
				sid = st.nextToken();
				hostName = comp_name + ":" + portNo + ":" + sid;
				server = comp_type + ":" + comp_name + ":" + portNo + ":" + sid;
			}
			else
			{
				hostName = comp_name + ":" + portNo;
				server = comp_type + ":" + comp_name + ":" + portNo;
			}

			if(box_name.equals(comp_name))
			{
				if(!v_comp_type_name.contains(server))
					v_comp_type_name.add(server);
			}
		}
	}
	else
	{
		v_comp_type_name.clear();
		//v_comp_type_name.addAll(user.getIndServers());
		//out.println("user.getIndServers():"+user.getIndServers());
		//out.println("<br>user.getServers(true):"+user.getServers(false));
		//add components from associated services, segments and zones
//		v_comp_type_name.addAll(user.getServers(false));

		String selected_segments = request.getParameter("selected_segments");

		if(selected_segments!=null && selected_segments.length() > 0 )
		{
			v_comp_type_name.clear();
	
			if(selected_segments.indexOf("[") >= 0)
			selected_segments=selected_segments.substring(1,selected_segments.length()-1);

			StringTokenizer stt=new StringTokenizer(selected_segments,",");

			while(stt.hasMoreTokens())
			v_comp_type_name.add((String)stt.nextToken().trim());	
		}
		else
		{
			v_comp_type_name.addAll(user.getServers(false));
		}
		if (excludeCompSeg)
		{
			/*
			List segList = user.getSegments();
			Iterator segI = segList.iterator();
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			while (segI.hasNext())
			{
				String thisSegment = (String)segI.next();
				String [] thisVar = topoInfo.getVariables(thisSegment);
				if (thisVar!=null)
					v_comp_type_name.addAll(Arrays.asList(thisVar));
			}
			*/
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			String [] segCmps = topoInfo.getVariables("PHYSICAL_TOPOLOGY");
			if (segCmps!=null)
				v_comp_type_name.removeAll(Arrays.asList(segCmps));
		}else
		{
			List segs = user.getSegments();
			Iterator segsI = segs.iterator();
			EgGroupInfo groupInfo = new EgGroupInfo();
			EgTopoInfo topoInfo = new EgTopoInfo("manager");
			while (segsI.hasNext())
			{
				String thisSeg = (String) segsI.next();
				Vector segAss = topoInfo.getAssociatesForSegment(thisSeg, 2);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}

			List sers =  user.getServices();
			Iterator sersI = sers.iterator();
			while (sersI.hasNext())
			{
				String thisSeg = (String) sersI.next();
				Vector segAss = topoInfo.getAssociatesForSite(thisSeg);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}

			List sites = user.getSites();
			Iterator sitesI = sites.iterator();
			while (sitesI.hasNext())
			{
				String thisSeg = (String) sitesI.next();
				Vector segAss = topoInfo.getAssociatesForSite(thisSeg);
				if (segAss!=null)
				{
					Iterator assI = segAss.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}


			List zones = user.getZones();
			Iterator zonesI = zones.iterator();
			while (zonesI.hasNext())
			{
				String thisZone = (String) zonesI.next();
				ArrayList segCmps = groupInfo.getAllSegmentComponentsUnderZone(thisZone);
				if (segCmps!=null)
				{
					Iterator assI = segCmps.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}

				ArrayList serCmps = groupInfo.getAllServiceComponentsUnderZone(thisZone);
				if (serCmps!=null)
				{
					Iterator assI = serCmps.iterator();
					while (assI.hasNext())
					{
						String thisCmp = (String)assI.next();
						if (!v_comp_type_name.contains(thisCmp))
							v_comp_type_name.add(thisCmp);
					}
				}
			}
		}

//		if(s_userid.equals("supermonitor"))
//		{
//			UserScope us = new UserScope();
//			v_comp_type_name = us.getIndependentServers();
//		}
//		else
//		{
//			v_comp_type_name = egasp.userServerInfo(s_userid,true);
//
//			//New code
//			Vector v_user_segs = egasp.getUserSegments(s_userid);
//			ArrayList a_user_all_seg_servs = sitebean.getServersForSegments(v_user_segs,2);
//			String s_seg_serv = "";
//			for(int k=0;k < a_user_all_seg_servs.size();k++)
//			{
//				s_seg_serv = (String)a_user_all_seg_servs.get(k);
//				if(v_comp_type_name.contains(s_seg_serv))
//				{
//					int idx = v_comp_type_name.indexOf(s_seg_serv);
//					if(idx > -1)
//					{
//						v_comp_type_name.remove(idx);
//					}
//				}
//			}
//			//End of new code
//			egasp.releaseConnection(false);
//		}
	}

	String s_flag = request.getParameter("flag");
	String s_sname = request.getParameter("sname");
	String s_stype = request.getParameter("stype");
	if (StringUtils.isNull(s_flag))
	{
		/*
		 * Direct entry into the page
		 */
		indServers.addAll(v_comp_type_name);
	}
	else
	{
		/*
		 * Entry through search button in the page
		 */
		boolean allServers = s_stype.equals("AllServers");
		if (s_flag.equalsIgnoreCase("both"))
		{
			List searchKey = Arrays.asList(StringUtils.getTokens(s_sname, "*"));
			for (Iterator i=v_comp_type_name.iterator(); i.hasNext(); )
			{
				server = (String)i.next();
				String serverType = Server.getServerType(server);
				String serverName = StringUtils.replace(Server.getServerName(server),":NULL","");

				for (int a=0; a<searchKey.size(); a++)
				{
					String key = (String)searchKey.get(a);
					String thisHostName = serverName.indexOf(":")==-1?serverName:serverName.substring(0, serverName.indexOf(":"));
					
					String thisIp=(String)ipmap.get(thisHostName);
					System.out.println("&"+serverName+"\t"+thisIp);
					if (thisIp==null)
						thisIp="";
					//if (serverName.indexOf(key) > -1)
					if (serverName.toLowerCase().indexOf(key) > -1 || thisIp.indexOf(key) > -1)
					{
						if (allServers)
						{
							indServers.add(server);
						}
						else
						{
							if (serverType.equals(s_stype))
							{
								indServers.add(server);
							}
						}
					}
				}
			}
		}
		else //if (s_flag.equalsIgnoreCase("type"))
		{
			if (allServers)
			{
				indServers.addAll(v_comp_type_name);
			}
			else
			{
				for (Iterator i=v_comp_type_name.iterator(); i.hasNext(); )
				{
					server = (String)i.next();
					String serverType = Server.getServerType(server);
					if (serverType.equals(s_stype))
					{
						indServers.add(server);
					}
				}
			}
		}
	}

	// Remove Duplicate Entries from indServers - new fix kk
	String s_tmp1 = "";
	String s_tmp2 = "";
	for(int i=0;i < indServers.size();i++)
	{
		s_tmp1 = (String)indServers.get(i);
		for(int j=i+1;j < indServers.size();j++)
		{
			s_tmp2 = (String)indServers.get(j);
			if(s_tmp1.equals(s_tmp2))
			{
				indServers.remove(j);
				i=0;
			}
		}
	}

	//if(indServers.size() > 12)
	if(indServers.size() > minServers)
	{
		showservers = false;
	}
	else if(s_flag != null)
	{
		showservers = false;
	}

	List serversWithState = new LinkedList();
	tablesInfo = new EgTablesInfo("manager");
	ArrayList siteServers = discInfo.getSiteServers();
	for (Iterator i=indServers.iterator(); i.hasNext(); )
	{
		server = (String)i.next();

		List row = new LinkedList();
		row.add(server);

		String serverType = Server.getServerType(server);
		/*
		 * The state of the WEB_TRANSACTIONS and WEB_SITE layers should not be considered for 
		 * Site-associated servers when coming through the segments or independent servers pages.
		 */
		if (siteServers.indexOf(serverType) > -1)
		{
			ArrayList layers = tablesInfo.getLayersForComponent(serverType);
			if ((layers.indexOf("WEB_SITE") > -1) || (layers.indexOf("WEB_TRANSACTIONS") > -1))
			{
				row.add(ap.getAlarmPriority(Server.getServerName(server), serverType, "NULL"));
			}
			else
			{
				row.add(ap.getAlarmPriority(Server.getServerName(server), serverType));
			}
		}
		else
		{
			row.add(ap.getAlarmPriority(Server.getServerName(server), serverType));
		}

		serversWithState.add(row);
	}

	Collections.sort(serversWithState, new Sorter(AlarmPriorities.getStatesOrder(), true));
%>
<form name="showservers" method="post" action="javascript:valform();">
<%
	if(!showservers)
	{
%>
		<table align="center" cellspacing="6" cellpadding="2" border="0"><tr><td align="center">
		<table align="center" cellspacing="0" cellpadding="2" border="0">
			<tr>
				<td id="eg_cellbgmedium">
					<table align="center" cellspacing="0" cellpadding="2" height="32" border="0">
						<tr>
							<th class="eg_bodybg" id="eg_darktextbold" nowrap="nowrap"><font id="eg_color3">&nbsp;Type</font></th>
							<td class="eg_bodybg" nowrap="nowrap">
								<select name="servertype">
<%
								if(s_stype != null && (s_stype.equals("AllServers")))
								{
%>
									<option value="AllServers" selected>All Components</option>
<%
								}
								else
								{
%>
									<option value="AllServers">All Components</option>
<%
								}
								v_comp_type.clear();
								Collections.sort(v_comp_type_name,String.CASE_INSENSITIVE_ORDER);
								for(int i=0;i< v_comp_type_name.size();i++)
								{
									String s_serv_type_name = (String)v_comp_type_name.get(i);	
									String s_serv_type = s_serv_type_name.substring(0,s_serv_type_name.indexOf(":"));
									if(!v_comp_type.contains(s_serv_type))
									{
										v_comp_type.add(s_serv_type);
									}
								}
								for(int i=0; i<v_comp_type.size(); i++)
								{
									if(s_stype != null && (!s_stype.equals("")))
									{
										if(s_stype.equals((String)v_comp_type.get(i)))
										{
%>
											<option value="<%=(String)v_comp_type.get(i)%>" selected><%=(String)v_comp_type.get(i)%></option>
<%
										}
										else
										{
%>
											<option value="<%=(String)v_comp_type.get(i)%>"><%=(String)v_comp_type.get(i)%></option>
<%
										}
									}
									else
									{
%>
										<option value="<%=(String)v_comp_type.get(i)%>"><%=(String)v_comp_type.get(i)%></option>
<%
									}
								}
%>
								</select>
							</td>
							<th class="eg_bodybg" id="eg_darktextbold" nowrap="nowrap"><font id="eg_color3">&nbsp; IP/Hostname</font></th>
							<td class="eg_bodybg"><input type="text" name="servername" size="12" style="width: 180px;" value="<%=s_org_sname%>" maxlength="128" class="eg_11"></td>
							<td class="eg_bodybg"><input type="button" onClick="javascript:valform();" value="SEARCH" name="searchbutton" id="eg_darkbutton"></td>
							<td class="eg_bodybg" id="eg_blankspace" width="2" nowrap="nowrap">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		</td>
		<td><p style="line-height:16px; font-size: 10px;"><sup>* </sup>You can search using any character of your component.&nbsp; Multiple search strings should be separated using a blank space.</p></td></tr></table>
	<br />
<%
	}
%>
	<table align="center" cellspacing="2" cellpadding="3" width="100%" border="0">
<!--JSP BACKGROUND/IMAGE FOR SERVER STARTS HERE-->
<%
		int size = serversWithState.size();
		if(size > 0)
		{
			if(showservers | checkflag)
			{
				int count = 0;					//Counts number of cells drawn so far
				int maxPerRow = 5;				//Maximum cells per row
				
				int rows = size/maxPerRow;		//Minimum number of rows in the table
				if (size % maxPerRow > 0)
				{
					rows++;						//If empty cells have to be drawn, that means an extra row
				}
				int emptyCount = Math.abs(size - (maxPerRow * rows));
				int width = 100/maxPerRow;		//By default width = 20
				if (size < maxPerRow)
				{
					width = 100 / size;
				}
				for (Iterator i=serversWithState.iterator(); i.hasNext(); )
				{
					if (count == 0)
					{//Start new row
						out.print("<tr>");
					}

					List row = (List)i.next();
					server = (String)row.get(0);
					state = (String)row.get(1);

					comp_type = Server.getServerType(server);
					comp_name = Server.getServerName(server);

					String compName = null;
					if (comp_name!=null)
					{
						if (comp_name.endsWith(EgConstants.NULL_PORT))
						{
							compName = Server.getServerNameWithoutPort(comp_name, false);
						}
						else
						{
							compName = comp_name;
						}
					}else
					{
						continue;
					}
%>
		<td width="<%=width%>%" align="center" height="90" valign="top" nowrap="nowrap" id="eg_blackcontent">
			<table align="center" cellspacing="0" cellpadding="0" width="36" height="36" border="0">
				<tr>
					<td id="<%=state%>border" align="center" valign="middle" width="36" height="36" nowrap background="eg_images/eg_layout/<%=state%>big.gif">
						<a href="/final/servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&host=<%=comp_name%>&comptype=<%=comp_type%>" target="eg_operations"><img src="eg_images/eg_layout/eg_icons/<%=comp_type%>.gif" border="0" alt="<%=comp_type%>" align="center" width="30" height="30" hspace="0" vspace="0"></a>
					</td>
				</tr>
			</table>
<%
					while (compName.length() > 20)
					{
						out.print(compName.substring(0, 20));
						out.print("<br>");
						compName = compName.substring(20);
					}
					if (compName.length() <= 20)
					{
						out.print(compName);
					}
%>
		</td>
<%
					count++;
					size--;

					if ((maxPerRow == count) || (size == 0))
					{//End of the row
						if ((rows > 1) && (size == 0))
						{//Only if rows are more than 1. Otherwise the cells will be center-aligned by default
							for (int a=0; a<emptyCount; a++)
							{
								out.print("<td nowrap=\"nowrap\" width=\"");
								out.print(width);
								out.println("%\">&nbsp;</td>");
							}
						}
						out.print("</tr>");
						count = 0;
					}
				}//End of for (Iterator...)
			}
		}
		else
		{
%>
	<table cellspacing="0" cellpadding="50" align='center' height="60%" border="0">
<%
			if(s_flag != null && s_org_sname.equals(""))
			{
%>
		<tr>
			<th id="eg_alert">
<%
				out.println("No matching independent components found for the above search.");
%>
			</th>
		</tr>
<%
			}
			else if(s_flag != null && !s_org_sname.equals(""))
			{
%>
		<tr>
			<th id="eg_alert">
<%
				out.println("No matching independent components found for the above ");
				if(s_org_sname.length() > 20)
				{
					out.println("<br>");
				}
				out.println(" \""); 
				while(s_org_sname.length() > 60)
				{
					out.println(s_org_sname.substring(0,60) + "<br>");
					s_org_sname = s_org_sname.substring(60,s_org_sname.length());
				}
				if(s_org_sname.length() <= 60)
				{
					out.println(s_org_sname);
				}
				out.println("\" search.");
%>
			</th>
		</tr>
<%
			}
			else
			{
%>
		<tr>
			<th id="eg_alert">
<%
				IniUI ui = (IniUI)IniUI.getInstance();
				out.println(ui.getConfigMessage(s_userid, IniUI.NO_SERVERS));
%>
			</th>
		</tr>
	</table>
<%
			}
		}

	v_comp_type_name.clear();
	v_comp_type.clear();
	indServers.clear();
%>
</table>
</form>
</body>
</html>






