<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgUtils"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
String defaultABAPDashboardParams="loadSAPCombo=true&action=loadSAPDashboard";
long refreshFrequency = 60 * 1000L;
try
{
	response.setHeader("Cache-Control", "no-store");
	response.setHeader("Pragma", "no-cache");
	response.setDateHeader("Expires", -1);
	User usr=null;

	String queryString = request.getQueryString();
	String profName = request.getParameter("profileName");

	
	String refFreq = u_ser.getRefreshFrequency();
	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}
		
	if(!StringUtils.isNull(queryString))
	{
		queryString = queryString.substring(queryString.indexOf("?")+1);
		StringTokenizer stkqStr=new StringTokenizer(queryString,"&");
		String selectedCompName="";
		while(stkqStr.hasMoreTokens())
		{
			String paramWithValue = stkqStr.nextToken();
			if(!StringUtils.isNull(paramWithValue))
			{
				int eqIdx = paramWithValue.indexOf("=");
				String parm = paramWithValue.substring(0,eqIdx);
				if(parm!=null && parm.equals("selectedComp"))
				{
					selectedCompName = paramWithValue.substring(eqIdx+1);
					break;
				}
			}
		}
		defaultABAPDashboardParams=defaultABAPDashboardParams+"&selectedComp="+selectedCompName;
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>


<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>eG Manager- SAP</title>
<style>
.avil-bg {
    background: #60a55a;
    color: #fff;
    text-align: center;
}
.highcharts-background {
    fill: transparent;
}


</style>

<egui:skin ui="monitor"/>
<script type="text/javascript" src="/final/jquery/jquery.js"></script>
<script src="/final/scripts/d3.min.js"></script>
<script src="/final/scripts/eg_DateUtil.js" ></script>
<script src="/final/Highcharts/js/highcharts.js"></script>
<script src="/final/Highcharts/js/modules/exporting.js"></script>
<script src="/final/Highcharts/js/highcharts-more.js"></script>
<script src="/final/Highcharts/js/solid-gauge.src.js"></script>
<script  src="/final/extjs/ext-all.js"></script>
<script src="/final/monitor/eg_scripts/EgHighChart.js"></script>
<script  src="/final/monitor/eg_scripts/EgCitrixDashboardHighChart.js"></script>
<script  src="/final/monitor/eg_scripts/ABAPDashboard/app.js"></script>

<script>
	var mgrDateFormat ='<%=mgrDateFormat%>';
	var timeZoneOffsetVal='<%=timezoneOffsetValue%>';
	var defaultABAPDashboardParams='<%=defaultABAPDashboardParams%>';
	var strSkin='<%=monitor_Skin%>';
	var strRumSkin='<%=monitor_Skin%>';
	var refreshFrequency='<%=refreshFrequency%>';
	var selectedInfo='';

	var titleForABAP='<egui:intnl text="monitor.common.SAP Monitoring Dashboard" />';
	var layerModel='<egui:intnl text="monitor.egNewAlert.Layer Model" />';
	var instanceStatusLbl='<egui:intnl text="monitor.common.Instance Status" />';
	var uptimeLbl='<egui:intnl text="reporter.esx.Uptime" />';
	var noMeasuresFoundMsg='<egui:intnl text="monitor.common.No measures available" />!';
	var noDataFoundMsg='<egui:intnl text="monitor.common.No data found" />!';
	var noCompFoundMsg='<egui:intnl text="monitor.common.No SAP components configured" />!';
	var DumpMessagesLbl='<egui:intnl text="monitor.dashboard.Dump messages" />';
	var responseTimeBreakupLbl='<egui:intnl text="monitor.dashboard.Response Time Breakup" />';
	var slowestStepsLbl='<egui:intnl text="monitor.dashboard.Slowest Steps" />';
	var workProcessesLbl='<egui:intnl text="monitor.dashboard.Work Processes" />';
	var runningLbl='<egui:intnl text="monitor.dashboard.Running" />';
	var freeLbl='<egui:intnl text="monitor.dashboard.Free" />';
	var holdLbl='<egui:intnl text="monitor.dashboard.Hold" />';
	var PRIVLbl='<egui:intnl text="monitor.dashboard.PRIV" />';
	var stoppedLbl='<egui:intnl text="monitor.dashboard.Stopped" />';
	var loggedAndActiveLbl='<egui:intnl text="monitor.dashboard.Logged in vs Active users" />';
	var lastHourLbl='<egui:intnl text="monitor.dashboard.Last 1 hour" />';
	var jobStatisticsLbl='<egui:intnl text="monitor.dashboard.Job Statistics" />';
	var SAPMemoryLbl='<egui:intnl text="monitor.dashboard.SAP Memory" />';
	var TopAvgReponseTimeLbl='<egui:intnl text="monitor.dashboard.Top 5 transaction by average response time" />';
	var TopUsersLbl='<egui:intnl text="monitor.dashboard.Top 5 user by average response time" />';
	var TopApplicationLbl='<egui:intnl text="monitor.dashboard.Top 5 application by average response time" />';
	var SAPProcessStatusLbl='<egui:intnl text="monitor.dashboard.SAP Process Status" />';
	var userDistributionLbl='<egui:intnl text="monitor.dashboard.User Distribution" />';
	var dialogActivityLbl='<egui:intnl text="monitor.dashboard.Dialog Activity" />';
	var dialogResponseTimeLbl='<egui:intnl text="monitor.dashboard.Dialog Response Time" />';
	var dumpsLbl='<egui:intnl text="monitor.dashboard.Dumps" />';
	var bufferSwapsLbl='<egui:intnl text="monitor.dashboard.Buffer Swaps" />';
	var diskActivityLbl='<egui:intnl text="monitor.dashboard.Disk Activity" />';
	var NOLbl='<egui:intnl text="monitor.dashboard.NO" />';
	var slowStepsTitleLbl='<egui:intnl text="monitor.dashboard.Top 10 slowest steps" />';

	function GetXmlHttpObject()
	{
		var xmlHttp=null;
		try
		{
			// Firefox, Opera 8.0+, Safari
			xmlHttp=new XMLHttpRequest();
		}
		catch (e)
		{
			// Internet Explorer
			try
			{
				xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
			}
			catch (e)
			{
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
		}
		return xmlHttp;
	}

	function goToLayerModel(url)
	{
		if(url!=null && url=='-')
			return;

		if(url!=null && url.indexOf("?")>0)
		{
			url=encodeURI(url);
			var backBtnPrms=defaultABAPDashboardParams;

			backBtnPrms= filterEncode(backBtnPrms);
			url=url+"&backBtnUrl="+encodeURIComponent(backBtnPrms);
		}
		var xmlhttp=GetXmlHttpObject();

		if(xmlhttp==null)
			return;
		
		xmlhttp.onreadystatechange=function()
		{
			if(xmlhttp.readyState==4)
			{
				if(xmlhttp.status == 200)
				{
					try
					{
						document.location=(url);
					}
					catch (error)
					{
						window.open(encodeURI(url)); 
					}
				}
			}
		}
		var sessionDelURL = '/final/monitor/EgAlarmSessionDel.jsp';
		xmlhttp.open('POST',sessionDelURL, true);
		xmlhttp.setRequestHeader("Content-Type","text/html;charset=UTF-8");
		
		if(window.parent.opener!=null)
			window.parent.opener.focus();

		xmlhttp.send(null);
	}

	function filterEncode(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\'','&',';'];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|','|ampsnd|','|scol|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(encode_char,decode_char);
					}
					while (text.indexOf(encode_char)>-1);
				}
			}
		}
		catch (e)
		{
		} 
		return text;
	} 

	var pubJson=null;	

	function getHighchartsForArea(container_Id,chartHeight,chartWidth,maxURL){
	var drawChart = true;
	var resizeObj;
	var idSelect = false;
	var showLegs = false;
	var HighStockChart = {
		highchart: null,
		defaults: {
			chart: {
				plotBorderWidth: 0,
				plotBorderColor : '#e1e1e1',
				backgroundColor:null,
				plotBackgroundColor: null,
				ignoreHiddenSeries:false,
				plotShadow: false,
				shadow: false,
				zoomType:'x',
				width:chartWidth,
				height:chartHeight,
				backgroundColor: 'transparent',
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').css({"height": "6px", "width": "6px"});
					}
				}
			},
			rangeSelector: {
				enabled: false
			},
			global: {
				useUTC: true,
				timezoneOffset:timeZoneOffsetVal
			},
			lang:{
				contextButtonTitle:'Print/Download Chart'
			},
			navigator: {
				enabled: false
			},
			yAxis: {
				border :0,
				lineWidth: 0,
				gridLineWidth: 1,
				tickPixelInterval: 50,
				labels: {
					
					formatter: function() {
						return (this.value > 0 ? ' ' : '') + this.value ;
					},
					style: {
						color : '#969696',
						fontFamily: 'Arial',
						fontSize: '11px',
						textDecoration: 'none',
						whiteSpace: 'normal',
					},
				},
				showLastLabel: true,
			},
			plotOptions: {
				series: {
					fillOpacity: 0.9,
					states: {
					hover: {
						enabled: true,
						lineWidth: 1,
					}
				},
				connectNulls : false,
				smoothed: true,
				lineWidth: 0,
				marker: {
						enabled: false
					}
				},
				line: {
					shadow: false,
					linewidth :10
				}
			},
			scrollbar: {
				enabled: false
			},
			legend: {
				enabled: true,
				verticalAlign: 'top',
				align:'center',
				navigation: {
					arrowSize: 5
				},
				itemStyle: {
					color : '#707070',
					fontFamily: 'Arial',
					fontSize: '12px',
				},
				symbolWidth: 15
			},
			labels :{
				itemStyle: {
					color : 'black',
					fontFamily: 'Calibri',
					fontSize: '12px',
				}
			},
			tooltip: {
				shared: true,
				borderColor: 'black',
				valueDecimals: 4,
				style: {
						color : 'black',
						fontFamily: 'Arial',
						fontSize: '11px',
					},
			},
			exporting: {
				enabled: false,
				chartOptions:{
					title:{
						text:''
					}
				}
			},
			credits: {
				enabled: false
			},
			xAxis: {
				border :1,
				lineWidth: 0,
				minPadding:0.02,
				maxPadding:0.02,
				type: 'datetime',
				ordinal: false,
				labels: {
					rotation:270,
					style: {
						color : '#969696',
						fontFamily: 'Arial',
						fontSize: '11px',
					},
					overflow: 'justify',
					showLastLabel: true,
					endOnTick: true,
					showFirstLabel: false,
					startOnTick: false,
					useHTML: false,
					tickPixelInterval: 75,
				},
				title: {
					enabled: true,
					offset: ''
				}
			},
			series: {
				marker: {
                enabled: false,
				 states: {
                    hover: {
                        enabled: true,
						lineWidthPlus:0,
                    }
                }},
				dataGrouping:{
					enabled: false
				}
			}
		},
		setData: function(jsonData,currentDateFormat,maxURL,isAxisTimeReq,legendPos) {
			var axisDefaultFamily = "Arial";
			var axisDefaultColor = "#969696";
			var axisDefaultSize = "11px";
			var axisDefaultWeight = "bold";
			var toolTipFmt = '';
			var chartType = 'line';
			var contextBtnColor = (strSkin == 'Light')?"#f7f7f7":'#828282';
			var lineChartStyleAttrbs=new Object();
			lineChartStyleAttrbs['titleFontFamily']='Arial';
			lineChartStyleAttrbs['titleFontSize']='11px';
			lineChartStyleAttrbs['titleFontClr']=(strSkin == 'Light')?'#969696':'#c0c0c0';
			lineChartStyleAttrbs['titleFontWgt']='normal';
			//For (x & y) axis labels
			lineChartStyleAttrbs['axisFontFamily'] = 'Arial';
			lineChartStyleAttrbs['axisFontClr'] = (strSkin == 'Light')?'#969696':'#c0c0c0';
			lineChartStyleAttrbs['axisFontSize'] = '11px';
			lineChartStyleAttrbs['axisFontWgt'] = 'normal';
			//For legend labels
			lineChartStyleAttrbs['legFontFamily'] = 'Arial';
			lineChartStyleAttrbs['legFontClr'] = (strSkin == 'Light')?'#707070':'#c0c0c0';
			lineChartStyleAttrbs['legFontSize'] = '12px';
			lineChartStyleAttrbs['legFontWgt'] = 'normal';

			var chartFileName = jsonData['chartFileName'];
			var legalignfrVdash = jsonData['legalignfrVdash'];
			var mgrDateObj = new Date();
			var currentMgrDate = Ext.Date.format(mgrDateObj,'m.d.Y.H.i.s');
			toolTipFmt = tooltipDateFormate(currentDateFormat);
			var timeline_out_format = '';
			ymax = jsonData['max'];
			ymin = 0;
			var isHtmlTooltip = (Ext.isEmpty(jsonData['useHtml']))?false:jsonData['useHtml'];
			fontFamily = jsonData['fontName'];
			fontSize = jsonData['fontsize'];
			startTime = jsonData['xmin'];
			LegendPosition = jsonData['legendPosition'];
			xLabel = jsonData['axislabel'];
			var yAxisLabel = jsonData['yAxisLabel'];
			LegendFont = jsonData['LegendFont'];
			xAxisDisplay = jsonData['xAxisDisplay'];
			var s_time_fout = jsonData['fmts'];
			fontFamily="Arial";
			LegendFont="Arial";
			xLabel =(xLabel == null || xLabel == '' || xLabel == undefined)?'':xLabel;
			yAxisLabel =(yAxisLabel == null || yAxisLabel == '')?'':yAxisLabel;
			fontFamily =(fontFamily == null || fontFamily == '')?"Arial":fontFamily;
			fontSize =(fontSize == null || fontSize == '')?'11px':fontFamily+"px";
			startTime =(startTime == null || startTime == '')?null:startTime;
			LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
			LegendFont =(LegendFont == null || LegendFont == '')?"Arial":LegendFont;
			s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
			timeline_out_format = getTimeLineOutputFormat(s_time_fout);
			legendWidth = (LegendPosition == 'right')?150:300;
			maxLegendHeight = (LegendPosition == 'right')?null:50;
			valign = (LegendPosition == 'right')?'middle':'top';
			legendLayout = (LegendPosition == 'right')?'vertical':'horizontal';
			isThresholdLine = ( !Ext.isEmpty( jsonData['isThresholdComparison'] ))?jsonData['isThresholdComparison']:false;
			chartTitle = jsonData['title'];
			var isAxisTimeReqJ = jsonData['isAxisTimeReq'];
			if(isAxisTimeReqJ != undefined)
				isAxisTimeReq = isAxisTimeReqJ;
			enableExport = true;
			lessWidth = 55;
			isHtmlTooltip = ( jsonData['DataSet'].length > 10 )?true:false;
			var isServiceBusDash = jsonData['isServiceBusDash'];
			var fromVirtual = jsonData['fromVirtual'];
			
			var axisNameFamily = "",axisNameColor="",axisNameSize = "",axisNameWeight="",timeNameFamily="",timeNameColor="",timeNameSize="",timeNameWeight="";
			if( !Ext.isEmpty(jsonData['styles']) )
			{
				 var stylesJson = jsonData['styles'];
				if(!Ext.isEmpty(stylesJson['axisLabelStyle']))
				{
					axisNameFamily = stylesJson['axisLabelStyle'].FAMILY;
					axisNameColor = stylesJson['axisLabelStyle'].COLOR;
					axisNameSize = stylesJson['axisLabelStyle'].SIZE;
					axisNameWeight = stylesJson['axisLabelStyle'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['timeLabelStyle'] ))
				{
					lineChartStyleAttrbs['axisFontFamily'] = stylesJson['timeLabelStyle'].FAMILY;
					lineChartStyleAttrbs['axisFontClr'] = stylesJson['timeLabelStyle'].COLOR;
					lineChartStyleAttrbs['axisFontSize'] = stylesJson['timeLabelStyle'].SIZE;
					lineChartStyleAttrbs['axisFontWgt'] = stylesJson['timeLabelStyle'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['titleSty'] ))
				{
					lineChartStyleAttrbs['titleFontClr'] = stylesJson['titleSty'].COLOR;
					lineChartStyleAttrbs['titleFontFamily'] = stylesJson['titleSty'].FAMILY;
					lineChartStyleAttrbs['titleFontSize'] = stylesJson['titleSty'].SIZE;
					lineChartStyleAttrbs['titleFontWgt'] = stylesJson['titleSty'].WEIGHT;
				}
				if( !Ext.isEmpty( stylesJson['legendSty'] ))
				{
					lineChartStyleAttrbs['legFontFamily'] = stylesJson['legendSty'].FAMILY;
					lineChartStyleAttrbs['legFontClr'] = stylesJson['legendSty'].COLOR;
					lineChartStyleAttrbs['legFontSize'] = stylesJson['legendSty'].SIZE;
					lineChartStyleAttrbs['legFontWgt'] = stylesJson['legendSty'].WEIGHT;
				}
				plotPanelColor = (strSkin == 'Light')?'#C0C0C0':'#666666';
			}
			else
			{
				plotPanelColor=(strSkin == 'Light')?'#C0C0C0':'#666666';
			}
			
			xlineWidth = 0;
			xGridLineWidth = 0;
			ylineWidth = 1;
			yGridLineWidth = 0;
			if (isThresholdLine)
			{
				ylineWidth = 1;
				yGridLineWidth = 0;
				xlineWidth = 1;
				xGridLineWidth = 1;
			}
			else
			{
				ylineWidth = 1;
				yGridLineWidth = 0;
				xlineWidth = 1;
				xGridLineWidth = 1;
			}
			axisNameFamily = ( Ext.isEmpty( axisNameFamily ) )?axisDefaultFamily:axisNameFamily;
			axisNameColor = ( Ext.isEmpty( axisNameColor ) )?axisDefaultColor:axisNameColor;
			axisNameSize = ( Ext.isEmpty( axisNameSize ) )?axisDefaultSize:axisNameSize;
			axisNameWeight = ( Ext.isEmpty( axisNameWeight ) )?axisDefaultWeight:axisNameWeight;

			var bgcolor='rgba(255, 255, 255, 0.85)';
			var legendSize = jsonData['DataSet'].length;
			var seriesCounter = jsonData['DataSet'].length;
			var xVal = (legendSize<=2)?200:0;
			var exportTitle = jsonData['exportTitle'];
			var enableTitle = false;
			enableTitle = jsonData['enableTitle'];
			chartTitle = (enableTitle)?jsonData['title']:'';
			var fromPageVal = '';
			if(!Ext.isEmpty(jsonData['fromPage']))
				fromPageVal = jsonData['fromPage'];
			var seumLegend = ( fromPageVal == 'seum' )?true:false;
			if(legendPos == "bottom")
			{
				valign = 'middle';
				y=5;
				legendWidth = 100
				enableExport = false;
				legendLayout = "right";
				LegendPosition = "center";
				maxLegendHeight = 20;
				var splitStr = chartTitle.split(":");
				if(splitStr!=null && splitStr!=undefined && splitStr.length>0)
				{
					chartTitle = chartTitle.substring(chartTitle.lastIndexOf(":")+1);
				}
			}
			if(Ext.isEmpty(exportTitle))
				exportTitle = chartTitle;
			chartFileName = (Ext.isEmpty(chartFileName))?exportTitle:chartFileName;
			chartFileName = chartFileName+" "+currentMgrDate;
			
			if(legendSize <= 3)
			{
				valign = 'top';
				y=(Ext.isEmpty(jsonData['smallGraph']))?20:0;
				if(legendPos == "bottom")
				{
					legendWidth = 200;
					 xVal = (legendSize<=2)?100:0;
				}
				else
				{
					legendWidth = 500;
					xVal = 200;
				}

				LegendPosition = '';
				legendLayout = 'horizontal';
				maxLegendHeight = 40;
				y=(Ext.isEmpty(jsonData['smallGraph']) && seumLegend )?2:y;
		
				if(isServiceBusDash!=null && isServiceBusDash=='true')
				{	
					y=5;
				}
				if(legalignfrVdash != undefined && legalignfrVdash != null && (legalignfrVdash == 'true' || legalignfrVdash) )
				{	
					y=-20;
				}
				
			}
			else
			{
				y=5;
				valign = 'middle';
				legendWidth = 150;
				LegendPosition = 'right';
				legendLayout = 'vertical';
				maxLegendHeight = null;
			}
			if(isAxisTimeReq != undefined && !isAxisTimeReq ){
				xLabel = "";
				if((isServiceBusDash != undefined && isServiceBusDash) || (fromVirtual != undefined && fromVirtual))
					yAxisLabel = "";
			}
			var xType = 'datetime';
			var stacked = null;
			var line_width=3;
			var marker_enabled =false;
			var tooltipObj =null;
			var isLegendEnabled = true;
			var tmpEnabled =jsonData['legendEnabled'];
			var isSysDashboard = jsonData['isSysDashboard'];
			isLegendEnabled = tmpEnabled;
			var yVal = "";
			var offSets = "";
			var showLegends = true;
			var marginbtm = 90;
			var showLegendChkObj = Ext.ComponentQuery.query('#showLegend').length;
			var showLegendChk = Ext.ComponentQuery.query('#showLegend')[(showLegendChkObj -1)];
		
				if(!Ext.isEmpty(Ext.getCmp('showLegend')))
				{
					showLegends = Ext.getCmp('showLegend').getValue();
					idSelect = true;
				}
				if (showLegendChk != 'undefined' && showLegendChk != undefined )
				{
					showLegends = showLegendChk.getValue();
				}
				showLegends = (seumLegend)?true:showLegends;
				isLegendEnabled = (seumLegend)?true:isLegendEnabled;
				showLegs = showLegends;
				if (isSysDashboard!=null && isSysDashboard)
				{
					showLegends = true;	
					maxLegendHeight = '200px';
					legendWidth = 100;
				}
				if((isServiceBusDash!=null && isServiceBusDash=='true') && (!tmpEnabled))
				{
					showLegends = false;
					idSelect = true;
				}
			
			if(isServiceBusDash!=null && isServiceBusDash=='true')
			{
				marginbtm = 25;
			}
			if(s_time_fout == "%H:%M")
			{
				yVal = 20;
				offSets = 60;
			}
			else
			{
				yVal = 20;
				offSets = 60; // For time format more than 24 hours in Measure Graph
			}

			rotVal=270;

			if(xAxisDisplay=='horizontal')
			{
				yVal=13;
				offSets=5;
				rotVal=2;
			}

			var minPad = null;

			if(ymin!=null && ymax!=null && (ymin == ymax))
				ymax = ymin+1;

			var toShowLastLabel = ( !Ext.isEmpty( jsonData['showLastLabel'] ) )?jsonData['showLastLabel']:true;
			var isLookBackChart = ( Ext.isEmpty( jsonData['isLookBack'] ))?false:jsonData['isLookBack'];
			var legendEnabledFlag = ( Ext.isEmpty( jsonData['legendEnabled'] ))?false:jsonData['legendEnabled'];
			if(legendEnabledFlag)
				showLegends = true;
			else
				showLegends = false;	

			legendWidth = (isLookBackChart)?200:legendWidth;
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset:timeZoneOffsetVal
				}
			});
			var chartingOptions = {
				chart:{
					plotBorderColor : plotPanelColor,
					backgroundColor:null,
					plotBackgroundColor: null,
					events: {
							selection: function (event) {
							var text,label;
							if (event.xAxis) {
								if(Highcharts.numberFormat(event.xAxis[0].min, 2)>0){
									isZoomMeasureGraph=true;
								}
							} else {
								isZoomMeasureGraph=false;
							}
						},
						click: function(e) {
							if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
							{
								if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
									loadMaximizedView(maxURL);
								else if(maxURL == 'close')
									closeMaximizedView();
							}
						},
						load:function() {
							$('.highcharts-legend-item rect').css({"height": "6px", "width": "6px"});
						}
					}
				},
				tooltip: {
					xDateFormat:toolTipFmt,
					valueDecimals: 4,
					backgroundColor :(strSkin == 'Light')?"rgba(255,255,255,1.0)":"rgba(46,46,46,1.0)",
					borderWidth: 1,
					borderColor:null,
					shared: true,
					useHTML:true,
					formatter: function() {
						var s ='';
						if(legendSize==1 || (strSkin=='Dark' || strSkin=='dark') )
							s = '<span style="font-family:Arial;">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
						else
							s = '<span style="font-family:Arial">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>'
						jQuery.each(this.points, function(i, point) {
							var val = Highcharts.numberFormat (point.y,4, '.','');
							var val_ar = val.split('.');
							if(val_ar.length>1)
							{
								if(val_ar[1]=='0000')
									val = val_ar[0];
							}
							if (point.series.name != '' && point.series.name != undefined && isLegendEnabled) {
								if(legendSize==1)
									s += '<b><span>'+ point.series.name +' :  '+val+'</span></b><br/>';
								else
									s += '<b><span style="font-family:Arial;color:' + this.series.color + '">'+ point.series.name +'  :  '+val+'</span></b><br/>';
							}
							else
							{
								s += '<br/> <b><span style="font-family:Arial;color:' + this.series.color + '">'+val+'</span></b><br/>';
							}
						});
						return s;
					}
					
				},
				title:{
					text:chartTitle,
					style: {
						color : lineChartStyleAttrbs['titleFontClr'],
						fontFamily:lineChartStyleAttrbs['titleFontFamily'],
						fontSize: lineChartStyleAttrbs['titleFontSize']
					}
				},
				yAxis:{
					max:ymax,
					min : ymin,
					minPadding:minPad,
					lineWidth: 1,
					lineColor: plotPanelColor,
					tickWidth: 0,
					gridLineWidth: 0,
					gridLineColor: plotPanelColor,
					labels: {
						align: 'right',
						x: -20,
						y: 5,
						 formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								var val_ar = val.split('.');
								if(val_ar != null && val_ar.length>1)
								{
									if(parseInt(val_ar[1])>=parseInt('0001'))
									{
										val = Highcharts.numberFormat (this.value,5, '.','');
										val = (parseFloat(val));
									}
									else
									{
										// Fix to roundoff final value
										val = (parseFloat(val));
									}
								}
								else
									val = (parseFloat(val));
								return val;
							},
						style: {
							color : lineChartStyleAttrbs['axisFontClr'],
							fontFamily:lineChartStyleAttrbs['axisFontFamily'],
							fontSize: lineChartStyleAttrbs['axisFontSize']
						}
					},
					title: {
						text: yAxisLabel,
						style: {
							color : axisNameColor,
							fontFamily:axisNameFamily,
							fontSize: axisNameSize+"px"
						}
					}
				},
				xAxis: {
					type : xType,
					lineWidth: 1,
					gridLineWidth: 1,
					gridLineColor: plotPanelColor,
					lineColor: plotPanelColor,
					tickWidth : 0,
					trackByArea : true,
					//endOnTick: true,
					//startOnTick: true,
					showLastLabel:toShowLastLabel,
					labels: {
						x:4,
						y:yVal,
						rotation:rotVal,
						style: {
							color : lineChartStyleAttrbs['axisFontClr'],
							fontFamily:lineChartStyleAttrbs['axisFontFamily'],
							fontSize: lineChartStyleAttrbs['axisFontSize']
						},
						formatter: function() {
							Highcharts.dateFormat(s_time_fout,this.value);
							return  Highcharts.dateFormat(s_time_fout, this.value);
						}
					},
					title: {
						text: xLabel,
						offset:offSets,
						style: {
							color : axisNameColor,
							fontFamily:axisNameFamily,
							fontSize: axisNameSize+"px"
						}
					}
				},
				plotOptions: {
					series: {
						animation:true,
						threshold: null,
						borderWidth:0,
						marker: {
							enabled: marker_enabled,
							states: {
								hover: {
									enabled: true,
									lineWidthPlus:0
								}
							}
						},
						stacking: stacked,
						pointStart:startTime,
						 point: {
							events: {
								click: function(e) {
									//if( !Ext.isEmpty( e.srcElement ) && ( e.srcElement.firstChild == null || e.srcElement.firstChild == undefined))
									{
										if(maxURL != 'null' && maxURL != 'undefined' && maxURL !='' && maxURL != undefined && maxURL != 'close')
											loadMaximizedView(maxURL);
										else if(maxURL == 'close')
											closeMaximizedView();
									}
								}
							}
						}
					},
					scatter: {
						tooltip: tooltipObj,
					},
				  borderWidth: 0
				},
				legend: {
					enabled:showLegends,
					verticalAlign: 'top',
					symbolRadius: 4,
					symbolWidth:15,
					symbolHeight:10,
					symbolPadding:6,
					useHTML:true,
					align:'center',
					y:-5,
					itemStyle: {
						color : lineChartStyleAttrbs['legFontClr'],
						fontWeight: lineChartStyleAttrbs['legFontWgt'],
						fontFamily:lineChartStyleAttrbs['legFontFamily'],
						fontSize: lineChartStyleAttrbs['legFontSize']
					},
					labelFormatter: function() {
						var retrunvar = this.name;
						if (retrunvar != '' && retrunvar !='undefined' && retrunvar !='infinity') {
							retrunvar = this.name;
						}
						else {
							retrunvar = 'null';
						}
						var str = retrunvar;
						if(valign =="middle" && !isLookBackChart)
						{
							var toolTextStr = '';
							if(str.length >=20)
							{
								toolTextStr=str.substring(0,20);
								var tempToolTextStr=str.substring(20);
								tempToolTextStr = tempToolTextStr.trim();
								while(tempToolTextStr.length >20)
								{
									toolTextStr=toolTextStr+"<br>"+tempToolTextStr.substring(0,20);
									tempToolTextStr=tempToolTextStr.substring(20);
								}
								if(tempToolTextStr.length > 2 )
								{
									var tmpStr = tempToolTextStr.substring(0,2);
									if(tmpStr.indexOf(" ") > -1)
									{
										toolTextStr = str.substring(0,22);
									}
								}
								toolTextStr=toolTextStr+"<br>"+tempToolTextStr;
							}
							else
								toolTextStr = str;
						}
						else
							toolTextStr = retrunvar;

						return toolTextStr;
					}
				},
				navigation: {
					 buttonOptions: {
						x:3
					}
				},
				exporting: {
					enabled: false,
					filename:chartFileName,
					chartOptions:{
						title:{
							text:exportTitle
						}
					},
					buttons: {
						contextButton: {
							theme: {
								fill:contextBtnColor,
								states: {
								hover: {
									fill: contextBtnColor
									}
								}
							}
						}
					}
				}
			};

			var chartContObj=document.getElementById(container_Id);
			if(chartContObj == null || chartContObj == undefined)
				chartContObj = Ext.getCmp(container_Id);
			
			this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
			var chartData=[];
			var seriesCounter = 0;
			if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined )
			{
				drawChart = false;
				if(chartContObj!=null)
				{
					var measHChartObj=document.getElementById('measHighChart');
					var measHChartObjHeight=null;
					if(measHChartObj == null || measHChartObj == undefined){
						measHChartObj = Ext.getCmp(container_Id);
						if(measHChartObj != undefined && measHChartObj != null){
							measHChartObjHeight = measHChartObj.getHeight();
							measHChartObjHeight = (measHChartObjHeight/2) - 40;
						}
					}

					if(measHChartObj != undefined && measHChartObj != null){
						if(measHChartObjHeight != undefined && measHChartObjHeight != null)
							chartContObj.innerHTML='<center><div style="text-align:center;margin-top:'+measHChartObjHeight+';border:0px solid red;"><img class="iconInformation" src="/final/images/clear.png" border="0" /></div><div >'+noMeasuresFoundMsg+'</div></center>';
						else
							chartContObj.innerHTML='<center><div style="text-align:center;margin-top:150px;border:0px solid red;"><img class="iconInformation" src="/final/images/clear.png" border="0" /></div><div >'+noMeasuresFoundMsg+'</div></center>';
					}else{
						chartContObj.innerHTML='<center><div style="margin:12% 0 auto 0%"><img class="iconInformation" src="/final/images/clear.png" border="0" /></div><div >'+noMeasuresFoundMsg+'</div></center>';
					}
				}
			}else{
				this.highchart.series=jsonData['DataSet'];
				this.highchart.chart.renderTo = container_Id;
			}
		},
		drawChart: function() {
			if(drawChart)
			{
				//new Highcharts.Chart(this.highchart);
				Highcharts.setOptions({
					lang: {
						thousandsSep: ''
					}
				});
				Highcharts.setOptions({
					global: {
						useUTC: true,
						timezoneOffset:timeZoneOffsetVal
					}
				});
				 Highcharts.seriesTypes.line.prototype.drawLegendSymbol = Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
				this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
				new Highcharts.Chart(this.highchart,function(chart){
					
					if(!idSelect)
					{
						jQuery('.showLegend').click(function () {

							if(!Ext.isEmpty(Ext.getCmp('er_chart_checkbox')) && Ext.getCmp('er_chart_checkbox') != null && Ext.getCmp('er_chart_checkbox') != undefined)
							{
								var checkedValues = Ext.getCmp('er_chart_checkbox').getChecked();
								if(checkedValues!=null && checkedValues.length>0)
								{
									chart.legendShow();
								}
								else
								{
									chart.legendHide();
								}
							}
							else
							{
								chart.legendToggle();
							}
						});
					}
					else
					{
						jQuery('#showLegend').click(function () {
							if(!Ext.isEmpty(Ext.getCmp('er_chart_checkbox')) && Ext.getCmp('er_chart_checkbox') != null && Ext.getCmp('er_chart_checkbox') != undefined)
							{
								var checkedValues = Ext.getCmp('er_chart_checkbox').getChecked();
								if(checkedValues!=null && checkedValues.length>0)
								{
									chart.legendShow();
								}
								else
								{
									chart.legendHide();
								}
							}
							else
							{
								chart.legendToggle();
							}
						});
						//jQuery('.showLegend').click(function () { chart.legendToggle(); });
					}
				});
			}
		}
	};
	return HighStockChart;
}


	</script>

</head>
<body>
	<div id="ABAPDashboardMask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"><div class="x-mask-loading" style="position:relative">Loading...</div></div>
</body>

</html>