
<%@ include file = "EcTrackerJson.jsp"%>
<%
/*
 *   File			:	ecCompareComponentConfig.jsp
 *   Purpose		:	Displays configuration changes in a component wrt reference component
 *   Creation Date	:	03/10/2009
 *   Author			:	Krishnamurthi
 *   UI Design		:	Krishnamurthi
 */
%>

<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="egurkha.config.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	//Browser check added by Vijay - 4.10.2009
	String ua = request.getHeader("User-Agent");
	boolean isFirefox = (ua != null && ua.indexOf("Firefox/") != -1);
	boolean isMSIE6 = (ua != null && ua.indexOf("MSIE 6.0") != -1);
	boolean isMSIE7 = (ua != null && ua.indexOf("MSIE 7.0") != -1);
	boolean isMSIE8 = (ua != null && ua.indexOf("MSIE 8.0") != -1);
	boolean isChrome = (ua != null && ua.indexOf("Chrome") != -1);
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EcUtils ecUtils = new EcUtils();
	EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	String componentType = (String)session.getAttribute("componentType");
	String tempCompType = mappingInfo.getComponentTypeDescription(componentType);

	String[] tests = (String[])session.getAttribute("tests");

	String referenceComponent = (String)session.getAttribute("referenceComponent");
	String tempReferenceComponent = referenceComponent.substring(0,referenceComponent.lastIndexOf(":"));
	if (tempReferenceComponent.endsWith(":NULL"))
	{
		tempReferenceComponent = tempReferenceComponent.substring(0,tempReferenceComponent.indexOf(":"));
	}

	String componentName = request.getParameter("componentName");
	String tempComponentName = componentName.substring(0,componentName.lastIndexOf(":"));
	if (tempComponentName.endsWith(":NULL"))
	{
		tempComponentName = tempComponentName.substring(0,tempComponentName.indexOf(":"));
	}

	ArrayList aListComponents = new ArrayList();
	aListComponents.add(componentName);

	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

	EcCompareConfigurationBean compareBean = new EcCompareConfigurationBean();
	compareBean.setHostAgentsMapping(hostAgentsMapping);
	compareBean.setComponentType(componentType);
	compareBean.setTest(tests);
	compareBean.setReferenceComponent(referenceComponent);
	compareBean.setComponents(aListComponents);
	compareBean.compareData("Detailed");

	TreeMap tmapComponentConfiguration = compareBean.getComponentConfiguration();
	TreeMap tmapComponentChangeConfiguration = compareBean.getComponentChangeConfiguration();

	TreeMap tmapRefConfig = (TreeMap)tmapComponentConfiguration.get(referenceComponent);
	TreeMap tmapOtherConfig = (TreeMap)tmapComponentConfiguration.get(componentName);
	TreeMap tmapChangeConfig = (TreeMap)tmapComponentChangeConfiguration.get(componentName);

	int i_configDataColumnCount = 10;
	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
%>

<html>
<head>
<title><egui:intnl text="configmgmt.changes.detailed.eG Change Management" /></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="configindex"/>
<script type="text/javascript" src="/final/jquery/jquery.js"></script>
<script language="JavaScript1.2">
function scrollFunction_S()
{
	var _id_s = document.getElementById("leftDiv");
	var _id_d = document.getElementById("rightDiv");
	_id_d.scrollTop = _id_s.scrollTop;
	_id_d.scrollLeft = _id_s.scrollLeft;
}

function scrollFunction_D()
{
	var _id_s = document.getElementById("leftDiv");
	var _id_d = document.getElementById("rightDiv");
	_id_s.scrollTop = _id_d.scrollTop;
	_id_s.scrollLeft = _id_d.scrollLeft;
}
$(document).ready(function(){
	$('#leftDiv') .css({'height': (($(window).height()) - 65)+'px'});
	$('#rightDiv') .css({'height': (($(window).height()) - 65)+'px'});

	$('#leftDiv') .css({'width': (($(window).width()/2) - 28)+'px'});
	$('#rightDiv') .css({'width': (($(window).width()/2) - 28)+'px'});
});

$(window).resize(function(){
	$('#leftDiv') .css({'height': (($(window).height()) - 65)+'px'});
	$('#rightDiv') .css({'height': (($(window).height()) - 65)+'px'});

	$('#leftDiv') .css({'width': (($(window).width()/2) - 28)+'px'});
	$('#rightDiv') .css({'width': (($(window).width()/2) - 28)+'px'});
});

</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" scrolling="no" style="overflow:hidden;">

<form name="showComparison" method="post" style="margin:0px;padding:0px">
	<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" valign="top" height="100%" >
		<tr>
			<!--<td valign="top" height="100%" id="padding5">-->
			<td valign="top" height="100%">
				<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
					<tr>
						<td align="center" valign="top" class="compareConfigCellbglight">
							<table width="100%" cellpadding="6" cellspacing="0" border="0" class="">
								<tr>
									<td class="compareConfigHeaderText" style="padding:7px"><egui:intnl text="configmgmt.compare.REFERENCE COMPONENT" /> : <%=tempReferenceComponent+" ["+tempCompType+"]"%></td>
									<td class="compareConfigHeaderText"><egui:intnl text="configmgmt.compare.COMPARED COMPONENT" /> : <%=tempComponentName+" ["+tempCompType+"]"%></td>
								</tr>

								<tr>
									<td valign="top" align="center" class="compareConfigCellbglight">
										<div id="leftDiv" class="compareConfig_div_scroll" style="padding:5px;border:0px solid orange;" onscroll="javascript:scrollFunction_S()">
<%
	//LEFT SIDE PANEL

	Iterator testname_keys = tmapChangeConfig.keySet().iterator();
	while (testname_keys.hasNext())
	{
		String key_testname = (String)testname_keys.next();
		if (key_testname.endsWith("_Measure")) continue;

		TreeMap tmapTestData_A = (TreeMap)tmapRefConfig.get(key_testname);

		int i_size = 2;
		int col_size = 0;
		String firstKey = "";
		if (tmapTestData_A.isEmpty())
		{
			TreeMap tmapTestData_B = (TreeMap)tmapOtherConfig.get(key_testname);
			if (tmapTestData_B.isEmpty()) continue;
			firstKey = (String)tmapTestData_B.firstKey();
			if (!firstKey.equals("+"))
			{
				ArrayList aListTemp = (ArrayList)tmapTestData_B.get(firstKey);
				col_size = aListTemp.size();
				if (col_size <= i_configDataColumnCount)
				{
					i_size = 1;
				}
			}
		}
		else
		{
			firstKey = (String)tmapTestData_A.firstKey();
			if (!firstKey.equals("+"))
			{
				ArrayList aListTemp = (ArrayList)tmapTestData_A.get(firstKey);
				col_size = aListTemp.size();
				if (col_size <= i_configDataColumnCount)
				{
					i_size = 1;
				}
			}
		}

		boolean isDynamicMeasureTest = false;
		int idx_M = firstKey.indexOf("~M~");
		if (idx_M != -1)
		{
			isDynamicMeasureTest = true;
		}

		ArrayList aListTestChanges = (ArrayList)tmapChangeConfig.get(key_testname);
		ArrayList aListDeletedItems = (ArrayList)aListTestChanges.get(0);
		ArrayList aListNewItems = (ArrayList)aListTestChanges.get(1);
		TreeMap tmapChangedItems = (TreeMap)aListTestChanges.get(2);
		ArrayList aListEqualItems = (ArrayList)aListTestChanges.get(3);

		ArrayList aListInfoHeadings = null;
		List testMeasureList = null;
		ArrayList aList_A_Measures = null;
		if (!isDynamicMeasureTest)
		{
			String[] testMeasuresValues = thresholdInfo.getMeasurementsForTest(key_testname);
			if (!firstKey.equals("+"))
			{
				String[] tmpStrArray = new String[testMeasuresValues.length-1];
				for (int i=0;i<testMeasuresValues.length-1;i++)
				{
					tmpStrArray[i] = testMeasuresValues[i];
				}
				testMeasuresValues = tmpStrArray;
				if (col_size <= i_configDataColumnCount)
				{
					i_size += testMeasuresValues.length;
				}
			}
			String[] testMeasuresNames = mappingInfo.getMeasureDescription(key_testname,testMeasuresValues);
			testMeasureList = Arrays.asList(testMeasuresNames);
		}
		else
		{
			testMeasureList = new ArrayList();
			aList_A_Measures = (ArrayList)tmapRefConfig.get(key_testname+"_Measure");
			ArrayList aList_B_Measures = (ArrayList)tmapOtherConfig.get(key_testname+"_Measure");
			if (aList_A_Measures.size() > aList_B_Measures.size())
			{
				testMeasureList.addAll(aList_A_Measures);
			}
			else
			{
				testMeasureList.addAll(aList_B_Measures);
			}

			if (!firstKey.equals("+"))
			{
				if (col_size <= i_configDataColumnCount)
				{
					i_size += testMeasureList.size();
				}
			}

			aListInfoHeadings = new ArrayList();
			String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
			if (infoHeadings != null && infoHeadings.length() > 0)
			{
				StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
				while (strTokensTemp.hasMoreTokens())
				{
					String str_temp = strTokensTemp.nextToken();
					aListInfoHeadings.add(str_temp);
				}
			}
		}
%>
													<table border="0" width="100%" cellspacing="0" cellpadding="0" style="margin-bottom:10px">
														<tr>
															<td class="compareConfigBgdarkimg" height="20" colspan="<%=i_size%>"><%=mappingInfo.getTestDescription(key_testname)%></td>
														</tr>
<%
		//EQUAL
		boolean colHeading_flag = false;
		for (int i=0;i<aListEqualItems.size();i++)
		{
			String key_info = (String)aListEqualItems.get(i);
			ArrayList al2 = (ArrayList)tmapTestData_A.get(key_info);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<al2.size();x++)
				{
					String measureName = (String)testMeasureList.get(x);
					String strValue = (String)al2.get(x);
					strValue = EcUtils.replaceTags(strValue);
					
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=strValue%>&nbsp;</td>
														</tr>
<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" align="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" align="top" nowrap><%=strData%></td>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
															<td style="background-color:#ffffff;padding-left:2px" class="compareConfigBodyText" id="cell_bg1" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=strData%></td>
														</tr>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						String measureName = (String)testMeasureList.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=s_value%>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//DELETED
		for (int j=0;j<aListDeletedItems.size();j++)
		{
			String key_info = (String)aListDeletedItems.get(j);
			ArrayList al2 = (ArrayList)tmapTestData_A.get(key_info);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<al2.size();x++)
				{
					String measureName = (String)testMeasureList.get(x);
					String strValue = (String)al2.get(x);
					strValue = EcUtils.replaceTags(strValue);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" nowrap><%=strValue%>&nbsp;</td>
														</tr>
<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigDeleted" valign="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigDeleted" valign="top" nowrap><%=strData%></td>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightBlue" class="compareConfigDeleted" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightBlue" class="compareConfigDeleted" nowrap><%=strData%></td>
														</tr>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						String measureName = (String)testMeasureList.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" nowrap><%=s_value%>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//NEW
		for (int k=0;k<aListNewItems.size();k++)
		{
			String key_info = (String)aListNewItems.get(k);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<testMeasureList.size();x++)
				{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBlankText" valign="top" nowrap>&nbsp;</td>
<%
					for (int x=0;x<testMeasureList.size();x++)
					{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" valign="top" nowrap>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
					for (int x=0;x<testMeasureList.size();x++)
					{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//CHANGED
		Iterator iter = tmapChangedItems.keySet().iterator();
		while (iter.hasNext())
		{
			System.out.println("-------------- change left side ---------------");
			String key_info = (String)iter.next();
			ArrayList aListMeasureChanges = (ArrayList)tmapChangedItems.get(key_info);
			ArrayList al2 = (ArrayList)tmapTestData_A.get(key_info);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				if (!isDynamicMeasureTest)
				{
					System.out.println("dynamic test");
					for (int x=0;x<al2.size();x++)
					{
						String measureName = (String)testMeasureList.get(x);
						String strValue = (String)al2.get(x);
						strValue = EcUtils.replaceTags(strValue);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=strValue%>&nbsp;</td>
														</tr>
<%
					}
				}
				else
				{
					System.out.println("non-dynamic test");
					for (int x=0;x<aListMeasureChanges.size();x++)
					{
						String strData = (String)aListMeasureChanges.get(x);
						String strMeasure = strData.substring(0,strData.indexOf("#"));
						String strStatus = strData.substring(strData.indexOf("#")+1);
						strStatus = strStatus.substring(0,strStatus.indexOf("-"));
						if (strStatus.equals("NOTEXIST"))
						{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
						}
						else
						{
							int idx_A = aList_A_Measures.indexOf(strMeasure);
							String measureValue_A = (String)al2.get(idx_A);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=strMeasure%></td>
<%
							if (strStatus.equals("EXIST"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" nowrap><%=measureValue_A%>&nbsp;</td>
<%
							}
							else
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_A%>&nbsp;</td>
<%
							}
%>
														</tr>
<%
						}
					}
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						if (!isDynamicMeasureTest)
						{
							for (int y=0;y<testMeasureList.size();y++)
							{
								String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
							}
						}
						else
						{
							for (int y=0;y<aListMeasureChanges.size();y++)
							{
								String strData = (String)aListMeasureChanges.get(y);
								String strMeasure = strData.substring(0,strData.indexOf("#"));
%>
															<td id="compareConfigCell_header" nowrap><%=strMeasure%></td>
<%
							}
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
						for (int x=0;x<al2.size();x++)
						{
							String s_value = (String)al2.get(x);
							if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
							s_value = EcUtils.replaceTags(s_value);
%>
															<td style="background-color:#ffffff" id="cell_bg1" valign="top" class="compareConfigBodyText" nowrap><%=s_value%>&nbsp;</td>
<%
						}
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=strData%></td>
<%
						for (int x=0;x<aListMeasureChanges.size();x++)
						{
							String strData_A = (String)aListMeasureChanges.get(x);
							String strMeasure = strData_A.substring(0,strData_A.indexOf("#"));
							String strStatus = strData_A.substring(strData_A.indexOf("#")+1);
							strStatus = strStatus.substring(0,strStatus.indexOf("-"));
							if (strStatus.equals("NOTEXIST"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" valign="top" class="compareConfigBlankText" nowrap>&nbsp;</td>
<%
							}
							else
							{
								int idx_A = aList_A_Measures.indexOf(strMeasure);
								String measureValue_A = (String)al2.get(idx_A);
								//measureValue_A = EcUtils.replaceTags(measureValue_A);
								if (strStatus.equals("EXIST"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" nowrap><%=measureValue_A%>&nbsp;</td>
<%
								}
								else
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_A%>&nbsp;</td>
<%
								}
							}
						}
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
						for (int x=0;x<al2.size();x++)
						{
							String s_value = (String)al2.get(x);
							String measureName = (String)testMeasureList.get(x);
							if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
							s_value = EcUtils.replaceTags(s_value);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=s_value%>&nbsp;</td>
														</tr>
<%
						}
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=strData%></td>
														</tr>
<%
						for (int x=0;x<aListMeasureChanges.size();x++)
						{
							String strData_A = (String)aListMeasureChanges.get(x);
							String strMeasure = strData_A.substring(0,strData_A.indexOf("#"));
							String strStatus = strData_A.substring(strData_A.indexOf("#")+1);
							strStatus = strStatus.substring(0,strStatus.indexOf("-"));
							if (strStatus.equals("NOTEXIST"))
							{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
							}
							else
							{
								int idx_A = aList_A_Measures.indexOf(strMeasure);
								String measureValue_A = (String)al2.get(idx_A);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=strMeasure%></td>
<%
								if (strStatus.equals("EXIST"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigDeleted" nowrap><%=measureValue_A%>&nbsp;</td>
<%
								}
								else
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_A%>&nbsp;</td>
<%
								}
%>
														</tr>
<%
							}
						}
					}
				}
			}
		}
%>
													</table>
													<!-- <table>
														<tr>
															<td id="bgwhite"><img src="/final/config/images/spacer.gif" height="5"></td>
														</tr>
													</table> -->
<%
	}
%>
										</div>
									</td>

									<td valign="top" align="left" class="compareConfigCellbglight">
										<div id="rightDiv" class="compareConfig_div_scroll" style="padding:5px;border:0px solid orange;" onscroll="javascript:scrollFunction_D()">
<%

	//RIGHT SIDE PANEL
	testname_keys = tmapChangeConfig.keySet().iterator();
	while (testname_keys.hasNext())
	{
		String key_testname = (String)testname_keys.next();
		if (key_testname.endsWith("_Measure")) continue;

		TreeMap tmapTestData_B = (TreeMap)tmapOtherConfig.get(key_testname);

		int i_size = 2;
		int col_size = 0;
		String firstKey = "";
		if (tmapTestData_B.isEmpty())
		{
			TreeMap tmapTestData_A = (TreeMap)tmapRefConfig.get(key_testname);
			if (tmapTestData_A.isEmpty()) continue;
			firstKey = (String)tmapTestData_A.firstKey();
			if (!firstKey.equals("+"))
			{
				ArrayList aListTemp = (ArrayList)tmapTestData_A.get(firstKey);
				col_size = aListTemp.size();
				if (col_size <= i_configDataColumnCount)
				{
					i_size = 1;
				}
			}
		}
		else
		{
			firstKey = (String)tmapTestData_B.firstKey();
			if (!firstKey.equals("+"))
			{
				ArrayList aListTemp = (ArrayList)tmapTestData_B.get(firstKey);
				col_size = aListTemp.size();
				if (col_size <= i_configDataColumnCount)
				{
					i_size = 1;
				}
			}
		}

		boolean isDynamicMeasureTest = false;
		int idx_M = firstKey.indexOf("~M~");
		if (idx_M != -1)
		{
			isDynamicMeasureTest = true;
		}

		ArrayList aListTestChanges = (ArrayList)tmapChangeConfig.get(key_testname);
		ArrayList aListDeletedItems = (ArrayList)aListTestChanges.get(0);
		ArrayList aListNewItems = (ArrayList)aListTestChanges.get(1);
		TreeMap tmapChangedItems = (TreeMap)aListTestChanges.get(2);
		ArrayList aListEqualItems = (ArrayList)aListTestChanges.get(3);

		ArrayList aListInfoHeadings = null;
		List testMeasureList = null;
		ArrayList aList_B_Measures = null;
		if (!isDynamicMeasureTest)
		{
			String[] testMeasuresValues = thresholdInfo.getMeasurementsForTest(key_testname);
			if (!firstKey.equals("+"))
			{
				String[] tmpStrArray = new String[testMeasuresValues.length-1];
				for (int i=0;i<testMeasuresValues.length-1;i++)
				{
					tmpStrArray[i] = testMeasuresValues[i];
				}
				testMeasuresValues = tmpStrArray;
				if (col_size <= i_configDataColumnCount)
				{
					i_size += testMeasuresValues.length;
				}
			}
			String[] testMeasuresNames = mappingInfo.getMeasureDescription(key_testname,testMeasuresValues);
			testMeasureList = Arrays.asList(testMeasuresNames);
		}
		else
		{
			testMeasureList = new ArrayList();
			ArrayList aList_A_Measures = (ArrayList)tmapRefConfig.get(key_testname+"_Measure");
			aList_B_Measures = (ArrayList)tmapOtherConfig.get(key_testname+"_Measure");
			if (aList_A_Measures.size() > aList_B_Measures.size())
			{
				testMeasureList.addAll(aList_A_Measures);
			}
			else
			{
				testMeasureList.addAll(aList_B_Measures);
			}

			if (!firstKey.equals("+"))
			{
				if (col_size <= i_configDataColumnCount)
				{
					i_size += testMeasureList.size();
				}
			}

			aListInfoHeadings = new ArrayList();
			String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
			if (infoHeadings != null && infoHeadings.length() > 0)
			{
				StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
				while (strTokensTemp.hasMoreTokens())
				{
					String str_temp = strTokensTemp.nextToken();
					aListInfoHeadings.add(str_temp);
				}
			}
		}
%>
													<table border="0"  cellspacing="0" cellpadding="0" bordercolor="red" width="100%" style="margin-bottom:10px">
														<tr>
															<td class="compareConfigBgdarkimg" height="20" colspan="<%=i_size%>"><%=mappingInfo.getTestDescription(key_testname)%></td>
														</tr>
<%
		//EQUAL
		boolean colHeading_flag = false;
		for (int i=0;i<aListEqualItems.size();i++)
		{
			String key_info = (String)aListEqualItems.get(i);
			ArrayList al2 = (ArrayList)tmapTestData_B.get(key_info);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<al2.size();x++)
				{
					String measureName = (String)testMeasureList.get(x);
					String strValue = (String)al2.get(x);
					strValue = EcUtils.replaceTags(strValue);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=strValue%>&nbsp;</td>
														</tr>
<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=strData%></td>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBodyText" nowrap><%=strData%></td>
														</tr>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						String measureName = (String)testMeasureList.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=s_value%>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//DELETED
		for (int j=0;j<aListDeletedItems.size();j++)
		{
			String key_info = (String)aListDeletedItems.get(j);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<testMeasureList.size();x++)
				{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>

<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigBlankText" valign="top" nowrap>&nbsp;</td>
<%
					for (int x=0;x<testMeasureList.size();x++)
					{
%>
															<td style="background-color:#ffffff" id="cell_bg1" valign="top" class="compareConfigBlankText" nowrap>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="compareConfigBglightimg" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
					for (int x=0;x<testMeasureList.size();x++)
					{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//NEW
		for (int k=0;k<aListNewItems.size();k++)
		{
			String key_info = (String)aListNewItems.get(k);
			ArrayList al2 = (ArrayList)tmapTestData_B.get(key_info);
			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				for (int x=0;x<al2.size();x++)
				{
					String measureName = (String)testMeasureList.get(x);
					String strValue = (String)al2.get(x);
					strValue = EcUtils.replaceTags(strValue);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew"  nowrap><%=strValue%>&nbsp;</td>
														</tr>
<%
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						for (int y=0;y<testMeasureList.size();y++)
						{
							String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigNew" valign="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigNew" valign="top" nowrap><%=strData%></td>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightViolet" class="compareConfigNew" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightViolet" class="compareConfigNew" nowrap><%=strData%></td>
														</tr>
<%
					}

					for (int x=0;x<al2.size();x++)
					{
						String s_value = (String)al2.get(x);
						String measureName = (String)testMeasureList.get(x);
						if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
						s_value = EcUtils.replaceTags(s_value);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew" nowrap><%=s_value%>&nbsp;</td>
														</tr>
<%
					}
				}
			}
		}
%>

<%
		//CHANGED
		Iterator iter = tmapChangedItems.keySet().iterator();
		while (iter.hasNext())
		{
			String key_info = (String)iter.next();
			ArrayList aListMeasureChanges = (ArrayList)tmapChangedItems.get(key_info);
			ArrayList al2 = (ArrayList)tmapTestData_B.get(key_info);

			if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
			{
				if (!isDynamicMeasureTest)
				{
					for (int x=0;x<al2.size();x++)
					{
						String measureName = (String)testMeasureList.get(x);
						String strStatus = (String)aListMeasureChanges.get(x);
						strStatus = strStatus.substring(strStatus.indexOf("-")+1);
						String strValue = (String)al2.get(x);
						strValue = EcUtils.replaceTags(strValue);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
<%
						if (strStatus.equals("NOTEQUAL"))
						{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" nowrap><%=strValue%>&nbsp;</td>
<%
						}
						else
						{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=strValue%>&nbsp;</td>
<%
						}
%>
														</tr>
<%
					}
				}
				else
				{
					for (int x=0;x<aListMeasureChanges.size();x++)
					{
						String strData = (String)aListMeasureChanges.get(x);
						String strMeasure = strData.substring(0,strData.indexOf("#"));
						String strStatus = strData.substring(strData.indexOf("#")+1);
						strStatus = strStatus.substring(strStatus.indexOf("-")+1);
						if (strStatus.equals("NOTEXIST"))
						{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
						}
						else
						{
							int idx_B = aList_B_Measures.indexOf(strMeasure);
							String measureValue_B = (String)al2.get(idx_B);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=strMeasure%></td>
<%
							if (strStatus.equals("EQUAL"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_B%>&nbsp;</td>
<%
							}
							else if (strStatus.equals("NOTEQUAL"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" nowrap><%=measureValue_B%>&nbsp;</td>
<%
							}
							else
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew" nowrap><%=measureValue_B%>&nbsp;</td>
<%
							}
%>
														</tr>
<%
						}
					}
				}
			}
			else
			{
				if (col_size <= i_configDataColumnCount)
				{
					if (!colHeading_flag)
					{
%>
														<tr>
															<td id="compareConfigCell_header" style="border-left-width:1px" nowrap><egui:intnl text="configmgmt.compare.Descriptor" /></td>
<%
						if (!isDynamicMeasureTest)
						{
							for (int y=0;y<testMeasureList.size();y++)
							{
								String measureName = (String)testMeasureList.get(y);
%>
															<td id="compareConfigCell_header" nowrap><%=measureName%></td>
<%
							}
						}
						else
						{
							for (int y=0;y<aListMeasureChanges.size();y++)
							{
								String strData = (String)aListMeasureChanges.get(y);
								String strMeasure = strData.substring(0,strData.indexOf("#"));
%>
															<td id="compareConfigCell_header" nowrap><%=strMeasure%></td>
<%
							}
						}
						colHeading_flag = true;
%>
														</tr>
<%
					}
%>
														<tr>
<%
					if (!isDynamicMeasureTest)
					{
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigChange" valign="top" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
						for (int x=0;x<al2.size();x++)
						{
							String s_value = (String)al2.get(x);
							if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
							s_value = EcUtils.replaceTags(s_value);
							String strStatus = (String)aListMeasureChanges.get(x);
							strStatus = strStatus.substring(strStatus.indexOf("-")+1);
							if (strStatus.equals("NOTEQUAL"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
							}
							else
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" valign="top" nowrap><%=s_value%>&nbsp;</td>
<%
							}
						}
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
															<td style="background-color:#ffffff;border-left-width:1px" id="cell_bg1" class="compareConfigChange" valign="top" nowrap><%=strData%></td>
<%
						for (int x=0;x<aListMeasureChanges.size();x++)
						{
							String strData_A = (String)aListMeasureChanges.get(x);
							String strMeasure = strData_A.substring(0,strData_A.indexOf("#"));
							String strStatus = strData_A.substring(strData_A.indexOf("#")+1);
							strStatus = strStatus.substring(strStatus.indexOf("-")+1);
							if (strStatus.equals("NOTEXIST"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
<%
							}
							else
							{
								int idx_B = aList_B_Measures.indexOf(strMeasure);
								String measureValue_B = (String)al2.get(idx_B);
								if (strStatus.equals("EQUAL"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
								else if (strStatus.equals("NOTEQUAL"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
								else
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
							}
						}
					}
%>
														</tr>
<%
				}
				else
				{
					if (!isDynamicMeasureTest)
					{
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightRed" class="compareConfigChange" nowrap><%=ecUtils.getInfoForDisplay(key_info)%></td>
														</tr>
<%
						for (int x=0;x<al2.size();x++)
						{
							String s_value = (String)al2.get(x);
							String measureName = (String)testMeasureList.get(x);
							if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES)) continue;
							s_value = EcUtils.replaceTags(s_value);
							String strStatus = (String)aListMeasureChanges.get(x);
							strStatus = strStatus.substring(strStatus.indexOf("-")+1);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=measureName%></td>
<%
							if (strStatus.equals("NOTEQUAL"))
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" nowrap><%=s_value%>&nbsp;</td>
<%
							}
							else
							{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=s_value%>&nbsp;</td>
<%
							}
%>
														</tr>
<%
						}
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
														<tr>
															<td height="20" colspan="2" style="border-left-width:1px" id="bglightRed" class="compareConfigChange" nowrap><%=strData%></td>
														</tr>
<%
						for (int x=0;x<aListMeasureChanges.size();x++)
						{
							String strData_A = (String)aListMeasureChanges.get(x);
							String strMeasure = strData_A.substring(0,strData_A.indexOf("#"));
							String strStatus = strData_A.substring(strData_A.indexOf("#")+1);
							strStatus = strStatus.substring(strStatus.indexOf("-")+1);
							if (strStatus.equals("NOTEXIST"))
							{
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap>&nbsp;</td>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBlankText" nowrap>&nbsp;</td>
														</tr>
<%
							}
							else
							{
								int idx_B = aList_B_Measures.indexOf(strMeasure);
								String measureValue_B = (String)al2.get(idx_B);
%>
														<tr>
															<td id="cell_header_single" style="border-left-width:1px" nowrap><%=strMeasure%></td>
<%
								if (strStatus.equals("EQUAL"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigBodyText" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
								else if (strStatus.equals("NOTEQUAL"))
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigChange" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
								else
								{
%>
															<td style="background-color:#ffffff" id="cell_bg1" class="compareConfigNew" nowrap><%=measureValue_B%>&nbsp;</td>
<%
								}
%>
														</tr>
<%
							}
						}
					}
				}
			}
		}
%>
													</table>
													<!-- <table>
														<tr>
															<td  id="bgwhite"><img src="/final/config/images/spacer.gif" height="5"></td>
														</tr>
													</table> -->
<%
	}
%>
										</div>
									</td>
								</tr>
							</table>
							<table border="0" cellspacing="0" cellpadding="2" height="15" style="margin-top:5px" class="configLegend">
								<tr>
									<td>
										<table border="0" cellspacing="0" cellpadding="0" align="right" height="10" class="configLegendBlue configLegendBox">
											<tr>
												<td width="10" title='<egui:intnl text="configmgmt.compare.Present in reference component" />' height="10"><img src="/final/config/images/spacer.gif" width="10" height="10" border="0"></td></td>
											</tr>
										</table> 
									</td>
									<td><egui:intnl text="configmgmt.compare.Present in reference component" /></td>
									<td>&nbsp;</td>
									<td width="10" height="10">
										<table border="0" cellspacing="0" cellpadding="0" align="right" height="10" class="configLegendViolet configLegendBox">
											<tr>
												<td width="10" title='<egui:intnl text="configmgmt.compare.Present in compared component" />' height="10"><img src="/final/config/images/spacer.gif" width="10" height="10" border="0"></td></td>
											</tr>
										</table>
									</td>
									<td><egui:intnl text="configmgmt.compare.Present in compared component" /></td>
									<td>&nbsp;</td>
									<td width="10" height="10">
										<table border="0" cellspacing="0" cellpadding="0" align="right" height="10" class="configLegendRed configLegendBox">
											<tr>
												<td width="10" title='<egui:intnl text="configmgmt.compare.Present in both with differences" />' height="10"><img src="/final/config/images/spacer.gif" width="10" height="10" border="0"></td></td>
											</tr>
										</table>
									</td>
									<td><egui:intnl text="configmgmt.compare.Present in both with differences" /></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</form>
</body>
</html>






