<%
/*
 *   File				:	EcPrintDataReport.jsp
 *   Purpose			:	Prints selected configuration details
 *   Creation Date		:	20/06/2006
 *   Author				:	Krishnamurthi, Balasigamani
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@page import="com.eg.EgConfigTestsInfo"%>
<%@page import="com.eg.EgConfigConstants"%>
<%@page import="egurkha.config.EcProcessChangeData"%>
<%@page import="egurkha.config.EcPrintData"%>
<%@page import="egurkha.config.EcUserData"%>
<%@page import="java.util.*"%>
<%@page import="java.text.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.eg.EgStringToXmlFormatter"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] userOptions = {"Component Name","Component Type","All Components"};

	String[] criterias = {"Zone","Service","Segment","Component"};

	public String decodeString(String s)
	{
		StringBuffer sb = new StringBuffer();
		int len = s.length();
		for(int i=0; i<len; i++)
		{
			char c = s.charAt(i);
			switch (c)
			{
				case '%':
					try
					{
						sb.append((char)Integer.parseInt(s.substring(i+1,i+3),16));
					}
					catch (NumberFormatException e) 
					{
						throw new IllegalArgumentException();
					}
					i += 2;
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}

	private String[] getValues(String str,String delimiter)
	{
		StringTokenizer strTokens = new StringTokenizer(str,delimiter);
		int i_count = strTokens.countTokens();
		String[] tempValues = new String[i_count];
		for (int i=0;i<tempValues.length;i++)
		{
			String s1 = strTokens.nextToken();
			tempValues[i] = s1;
		}
		return tempValues;
	}

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}

	//For e.g., str can be OS=Microsoft Windows XP Professional#Service=eG##Mon#Installed=All##All
	//Note : delimiter should be a single character
	private ArrayList getParameters(String str,String delimiter)
	{
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		int delimiterIdx = str.indexOf(delimiter);
		while (delimiterIdx != -1)
		{
			String cutString = str.substring(0,delimiterIdx);

			if (cutString.length() == 0)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(1);
			}
			else if (cutString.trim().indexOf("=") == -1)
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + cutString;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);

				str = str.substring(cutString.length()+1);
			}
			else
			{
				String key = cutString.substring(0,cutString.indexOf("="));
				String value = cutString.substring(cutString.indexOf("=")+1);
				aListResultant.add(key.trim());
				aListResultant.add(value.trim());
				prevKey = key.trim();
				str = str.substring(delimiterIdx+1);
			}

			delimiterIdx = str.indexOf(delimiter);
		}

		if (str.length() > 0)
		{
			if (str.indexOf("=") != -1)
			{
				String lastKey = str.substring(0,str.indexOf("="));
				String lastValue = str.substring(str.indexOf("=")+1);
				aListResultant.add(lastKey.trim());
				aListResultant.add(lastValue.trim());
			}
			else
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + delimiter + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
		}

		ArrayList aListTemp = new ArrayList();
		for (int i=0;i<aListResultant.size();i=i+2)
		{
			aListTemp.add((String)aListResultant.get(i)+"="+(String)aListResultant.get(i+1));
		}

		return aListTemp;
	}
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	String startDateAndTime = null;
	String endDateAndTime = null;
	String ec_userName = request.getParameter("userName");
	String ec_user_language = request.getParameter("user_language");

	//user language
	String userLanguage = null;
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	else if (user == null)
	{
		EcUserData ecUserData = new EcUserData(ec_userName,false);
		user = ecUserData.getUser(ec_userName);
		userLanguage = ec_user_language;
	}

	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgConfigTestsInfo configtestsinfo = new EgConfigTestsInfo("manager");
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EcUtils ecUtils = new EcUtils();

	String ec_component = "";
	String ec_option1 = "";
	String ec_option2 = "";
	String ec_timeline = "";
	String s_start_time = "";
	String s_end_time = "";
	String ec_stdate = "";
	String sHour = "";
	String sMinute = "";
	String ec_enddate = "";
	String eHour = "";
	String eMinute = "";
	String ec_changetype = "";
	String s_viewchange = "";
	String ec_maxPageItems = "";
	String displayNameForChangeType = "";
	String selectedTests = "";
	String selectedDate = null;
	String selectedHour = null;
	TreeMap tmap_changeConfigDetails = null;
	ArrayList aListComponents = null;
	boolean requestHomePage = false;
	int topN = 10;
	String chartColorForChangeConfig = null;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_userOption = (String)session.getAttribute("ec_userOption");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_type = request.getParameter("ec_type");
	String ec_trgttype = request.getParameter("ec_trgttype");
	String ec_forPDF = request.getParameter("ec_forPDF");
	String requestFrom = request.getParameter("requestFrom");
	String searchCompValue = request.getParameter("searchCompValue");
	String searchTestValue = request.getParameter("searchTestValue");
	String searchDescValue = request.getParameter("searchDescValue");

	if (ec_type != null)
	{
		if (ec_type.equalsIgnoreCase("Current"))
		{
			ec_component = request.getParameter("ec_component");
		}

		if (ec_type.equalsIgnoreCase("Change") || ec_type.equalsIgnoreCase("ShowComponentChanges"))
		{
			if (requestFrom != null && requestFrom.equals("Schedule"))
			{
				ec_option1 = (String)request.getAttribute("option1");
				ec_option2 = (String)request.getAttribute("option2");

				ec_timeline = (String)request.getAttribute("timeline");

				s_start_time = (String)request.getAttribute("startDateAndTime");
				s_end_time = (String)request.getAttribute("endDateAndtime");

				String tempDateTime = s_start_time.substring(0,s_start_time.lastIndexOf(':'));
				String tempSDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempSTime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempSDate = DateUtil.changeDateFormat(tempSDate,"MM/dd/yyyy",currentDateFormat);
				s_start_time = tempSDate + " " + tempSTime;

				tempDateTime = s_end_time.substring(0,s_end_time.lastIndexOf(':'));
				String tempEDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempETime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempEDate = DateUtil.changeDateFormat(tempEDate,"MM/dd/yyyy",currentDateFormat);
				s_end_time = tempEDate + " " + tempETime;

				ec_changetype = (String)request.getAttribute("changeType");

				s_viewchange = (String)request.getAttribute("viewChange");

				String strTopN = (String)request.getAttribute("topN");
				if (strTopN != null && !strTopN.equals("null"))
				{
					topN = Integer.parseInt(strTopN);
				}

				tmap_changeConfigDetails = (TreeMap)request.getAttribute("CHANGE_DATA");
				chartColorForChangeConfig = (String)request.getAttribute("chartColor");
			}
			else
			{
				EcPrintData ecData = (EcPrintData)session.getAttribute("CHANGE_COMPONENT_DATA");

				ec_option1 = ecData.getOptionOne();
				ec_option2 = ecData.getOptionTwo();

				ec_timeline = ecData.getTimeLine();

				s_start_time = ecData.getStartTime();
				s_end_time = ecData.getEndTime();

				ec_stdate = ecData.getStartDate();

				String ec_sthr = ecData.getStartHour();
				if (ec_sthr != null)
				{
					if (ec_sthr.length() == 1)
						sHour = "0" + ec_sthr;
					else
						sHour = ec_sthr;
				}

				String ec_startmin = ecData.getStartMinute();
				if (ec_startmin != null)
				{
					if (ec_startmin.length() == 1)
						sMinute = "0" + ec_startmin;
					else
						sMinute = ec_startmin;
				}

				ec_enddate = ecData.getEndDate();

				String ec_endhr = ecData.getEndHour();
				if (ec_endhr != null)
				{
					if (ec_endhr.length() == 1)
						eHour = "0" + ec_endhr;
					else
						eHour = ec_endhr;
				}

				String ec_endmin = ecData.getEndMinute();
				if (ec_endmin != null)
				{
					if (ec_endmin.length() == 1)
						eMinute = "0" + ec_endmin;
					else
						eMinute = ec_endmin;
				}

				ec_changetype = ecData.getChangeType();

				s_viewchange = ecData.getViewChange();

				selectedDate = ecData.getSelectedDate();
				if (selectedDate != null) requestHomePage = true;
				selectedHour = ecData.getSelectedHour();

				topN = ecData.getTopNChanges();

				ec_component = request.getParameter("componentName");

				tmap_changeConfigDetails = ecData.getChangeData();
				chartColorForChangeConfig = ecData.getSampleColor();
			}

			if (ec_changetype != null)
			{
				if (ec_changetype.equalsIgnoreCase("Latest"))
				{
					displayNameForChangeType = "Recent";
				}
				else
				{
					displayNameForChangeType = "All";
				}
			}

			if (ec_type.equalsIgnoreCase("Change"))
			{
				aListComponents = new ArrayList();
				Iterator component_keys = tmap_changeConfigDetails.keySet().iterator();
				while (component_keys.hasNext())
				{
					String key_component = (String)component_keys.next();
					if (!key_component.equalsIgnoreCase("Change By Date"))
					{
						aListComponents.add(key_component);
					}
				}
			}

			tmap_changeConfigDetails = processChangeData.getChangeSummary(tmap_changeConfigDetails,searchCompValue,searchTestValue,searchDescValue,userLanguage);
		}
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = (String)timeZoneConverter.getDateTime();
	/* Added by Prakash.K ends */
	
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}

	String reportTitle = ec_type;
	if (ec_type != null && ec_type.equalsIgnoreCase("Current"))
	{
		reportTitle = "CURRENT";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Application_Users"))
	{
		reportTitle = "THIN CLIENT APPLICATIONS";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("User_Applications"))
	{
		if (requestFrom != null && requestFrom.equalsIgnoreCase("currentConfigThinClient"))
			reportTitle = "USERS AND THEIR ASSOCIATED APPLICATIONS";
		else
			reportTitle = "THIN CLIENT USERS";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ShowComponentChanges"))
	{
		reportTitle = "CHANGE";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Change"))
	{
		reportTitle = "CHANGE";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentType"))
	{
		reportTitle = "COMPONENT TYPE CHANGE SUMMARY";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentName"))
	{
		reportTitle = "COMPONENT NAME CHANGE SUMMARY";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Consolidated_View"))
	{
		reportTitle = "CONSOLIDATED VIEW";
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Search"))
	{
		reportTitle = "SEARCH";
	}

	String fontStyle = "";
	if ((dbInfo.doubleByteEnabled || !userLanguage.equals("en_US")) && 
		(ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes")))
	{
		fontStyle = "multi_font";
	}

	boolean isLangCHJPKR = false;
	boolean isSingleByte = false;
	if (userLanguage.equals("ch_CH") || 
		userLanguage.equals("ja_JP") || 
		userLanguage.equals("ko_KR"))
	{
		isLangCHJPKR = true;
	}
	else if (userLanguage.equals("pt_BR") || 
		userLanguage.equals("it_IT") || 
		userLanguage.equals("fr_FR") || 
		userLanguage.equals("es_ES") || 
		userLanguage.equals("de_DE"))
	{
		isSingleByte = true;
	}

	String result1 = "<LINK href=\"../";

	String result2 = "config/styles/ec_style_" + user.getConfigSkin();
	if (isLangCHJPKR)
	{
		result2 = result2 + "_multi";
	}
	else if (isSingleByte)
	{
		result2 = result2 + "_singlebyte";
	}

	String result3 = ".css\" type=\"text/css\" rel=\"stylesheet\">";

	String strStyleSheet = result1 + result2 + result3;
%>

<html style="background:#ffffff!important">
<head>
	<title><egui:intnl text="configmgmt.common.eG Configuration Report" /></title>
	<%//=strStyleSheet%>
	<egui:skin ui="config"/>
	<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />

<style>
@media print {body {-webkit-print-color-adjust: exact;}}

header {font-size: 13px; font-weight: 500;}
.iconPrinter {background-position: 0 -1080px;width: 16px;height: 16px;}
/*#noprint b i{ font-size:25px;font-style:italic}*/
</style>



	<script language="Javascript">
		//window.print();
	</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" bgcolor="#FFFFFF" onLoad="javascript:void(0);" onUnLoad="javascript:void(0)">
<form name="EcPrint" method="post" onSubmit="return false;">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

	<table width="99%" align="center" cellspacing="0" cellpadding="0" border="0">
<%
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
	{
%>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="5">
			</td>
		</tr>
		<tr>
			<td align="center">
				<table align="center" cellspacing="0" cellpadding="0" height="24" border="0" width="100%" class="body_text">
					<tr>
						<td align="center">
							<b><egui:intnl text="configmgmt.common.Generated on" />&nbsp;<%=dateString%></b>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td align="center" height="24">
				<table align="center" cellspacing="0" cellpadding="5" height="24" border="0" width="100%" id="pageHeader">
					<tr>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1") && !ec_criteria.equalsIgnoreCase("null"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
						<td align="left" width="100%"><div style="float:left"><header><egui:intnl text='<%="configmgmt.common."+reportTitle%>' />&nbsp;<egui:intnl text='<%="configmgmt.common."+ec_trgttype.toUpperCase()%>' />&nbsp;<egui:intnl text="configmgmt.common.OF" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></header></div>
<%
		}
		else
		{
%>
						<td align="left" width="100%"><div style="float:left"><header><egui:intnl text='<%="configmgmt.common."+reportTitle%>' />&nbsp;<egui:intnl text='<%="configmgmt.common."+ec_trgttype.toUpperCase()%>' /></header></div>
<%
		}
%>
						
							<div style="float:right"><img class="mouse iconPrinter" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()"></div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
	else if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		//String imageName = iniUI.getConfigHomeLogo();
		String imageName = user.getConfigLogo();
%>
		<tr>
			<td>
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td align="left" width="30%" valign="bottom"><img src="<%=imageName%>" border="0"></td>
						<td width="70%" align="right" valign="bottom">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1") && !ec_criteria.equalsIgnoreCase("null"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common."+reportTitle)%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common."+ec_trgttype.toUpperCase())%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.OF")%>&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></td>
								<tr>
<%
		}
		else
		{
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common."+reportTitle)%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common."+ec_trgttype.toUpperCase())%></b></td>
								</tr>
<%
		}
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
<%
	}

	if (ec_type!=null && ec_type.equalsIgnoreCase("CURRENT"))
	{
		String component = ec_component.substring(0,ec_component.lastIndexOf(':'));
		if (component.endsWith(":NULL"))
			component = component.substring(0,component.lastIndexOf(':'));

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
		{
%>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="5">
			</td>
		</tr>
<%
		}

		int i_configDataColumnCountout = configtestsinfo.getConfigurationDataColumnCount();
		ArrayList al_configDetails = (ArrayList)session.getAttribute("CURRENT_DATA");

		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			al_configDetails = (ArrayList)request.getAttribute("CURRENT_DATA");
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
			String strComponentType = ec_component.substring(ec_component.lastIndexOf(":")+1);
			strComponentType = mappingInfo.getComponentTypeDescription(strComponentType);
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.configuration.Configuration Details for")%>&nbsp;<%=component%>&nbsp;[<%=strComponentType%>]</b></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.configuration.as on")%>&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}

		if (al_configDetails!=null && !al_configDetails.isEmpty())
		{
			ArrayList a_title = (ArrayList)al_configDetails.get(0);//ArrayList for Title
			String title = (String) a_title.get(0);
%>
		<tr>
			<td align="center">
				<table width="100%" border="0" cellspacing="0" cellpadding="5" class="body_text" >
			
<%
			if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
			{
%>
					<tr>
						<td width="70%" id="main_head" align="center"><b><egui:intnl text="configmgmt.configuration.Configuration Details for" />&nbsp;<%=component%>&nbsp;[<%=title%>]</b></td>
					</tr>
<%
			}
			String gpoConfigTestDisplayName = mappingInfo.getTestDescription("GPOConfigTest_cf");
			for(int m=1;m<al_configDetails.size();m++)
			{
				//Change identifier: 'SkipGPOconfigMsrs'
				//Change description: Skipping to show the GPO config XML measures for all the policies in print/pdf/email. 
				//                    Print/pdf/email options will be added in the view GPO pop up screen.
				String  testDisplayName= (String)((ArrayList)((ArrayList)al_configDetails.get(m)).get(0)).get(0);
				if( (gpoConfigTestDisplayName != null) && (gpoConfigTestDisplayName.equals(testDisplayName)) )
				{
					%>
					<tr>
						<td align="center" >
							<table cellspacing="0" cellpadding="0" border="0"><tr><td colspan="2" height="3"><img src="/final/config/images/spacer.gif" height="5"></td></tr></table>
								
							<table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-bottom-width:0px">
								<tr>
									<td colspan="2" height="24" class="<%=fontStyle%>">
										<b>&nbsp;<%=gpoConfigTestDisplayName%></b>
									</td>
								</tr>
								<tr>
									<td colspan="2" height="24" class="<%=fontStyle%>">
										<table border="0" width="100%" cellspacing="0" cellpadding="5" class="body_text">
											<tbody>
												<tr>
													<td><b>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.configuration.The configuration for GPO policies is not supported in this report. Please select the GPO policy and export it")%></b></td>
												</tr>
											</tbody>
									</td>
								</tr>								
							</table>
						</td>
					</tr>					
					<%
					continue;
				}
				//Change ends for the change identifier 'SkipGPOconfigMsrs'
				ArrayList a = (ArrayList)al_configDetails.get(m); //ArrayList for each test

				ArrayList al_heading = (ArrayList)a.get(0); //Heading
				String heading = (String)al_heading.get(0);

				ArrayList al_flags_both = (ArrayList)a.get(1); //Rows and Column Display Flags 
				ArrayList al_flags_row = (ArrayList)al_flags_both.get(0); //Row Display Flags
				ArrayList al_flags_column = (ArrayList)al_flags_both.get(1); //Column Display Flags

				ArrayList al_columnNames = (ArrayList)a.get(2); //Column Names
				int colCount = al_columnNames.size();
				TreeMap tmap_data = (TreeMap)a.get(3); //Values - TreeMap

				ArrayList aListInfoHeadings = (ArrayList)a.get(4); //Info Headings - ArrayList

				boolean isDynamicMeasureTest = false;
				String firstKey = (String)tmap_data.firstKey();
				int idx_M = firstKey.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}
%>
					<tr>
						<td align="center" >
							<table cellspacing="0" cellpadding="0" border="0"><tr><td colspan="2" height="3"><img src="/final/config/images/spacer.gif" height="5"></td></tr></table>
								
							<table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-bottom-width:0px">
								<tr>
									<td colspan="2" height="24" id="linebottom" class="<%=fontStyle%>">
										<b>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.configuration."+heading)%></b>
									</td>
								</tr>

								<tr>
									<td width="100%">
										<table border="0" width="100%" cellspacing="0" cellpadding="5" class="body_text" border="0">
<%
				Iterator iter = tmap_data.keySet().iterator();
				boolean colHeading_flag = false;
				int trueFlagColCount = 0;
				int f = 0;
				while(iter.hasNext())
				{
					String key_info = (String)iter.next();
					ArrayList al2 = (ArrayList)tmap_data.get(key_info);
					if (al2.size() != (colCount - 1)) continue;
					if (key_info.equals("+") || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY))
					{
						//Show row-wise data - Non-Info based - Don't show Descriptor
						for (int x=1; x<colCount; x++)
						{
							String display_flag = (String)al_flags_column.get(x);
							if (display_flag.equals("true"))
							{
								String columnName = (String)al_columnNames.get(x);
								String strValue = (String)al2.get(x-1);

								if (strValue.startsWith("<?xml") && strValue.lastIndexOf("?>") != -1) // row wise
								{
%>
										<tr>
											<td width="50%" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>"><%=columnName%></td>
										</tr>
										<tr>
											<td id="linebottomright" width="50%" style="border-left-width:1px" class="<%=fontStyle%>">
<%
									if(strValue == null || strValue.trim().length() == 0)
									{
										strValue = "-";
									}
									//removing BOM Character begin
									byte[] bytes = strValue.getBytes(EcUtils.UTF8_ENCODING);
									if (EcUtils.isUTF8(bytes))
									{
										strValue = EcUtils.printSkippedBomString(bytes);
									}
									//end

									if (strValue.length() <= 100)
									{
										strValue = EcUtils.replaceTags(strValue);
										out.println(strValue);
									}
									else
									{
										strValue = EgStringToXmlFormatter.formatXMLData(strValue);
										strValue = EcUtils.replaceTags(strValue);
										if (strValue.contains("\n"))
										{
											StringTokenizer tkns = new StringTokenizer(strValue,"\n");
											while(tkns.hasMoreTokens())
											{
												String val = tkns.nextToken();
												if(val.length() <= 155)
												{
%>
													<div><pre style="font-family:Courier New !important; font-size:11px"><%=val%></pre></div>
<%
												}
												else
												{
%>
													<div><pre style="font-family:Courier New !important; font-size:11px">
<%
													ArrayList aListStrValues = breakString(val,155);
													for (int r=0;r<aListStrValues.size();r++)
													{
														String valStr = (String)aListStrValues.get(r);
														out.println(valStr+"<br>");
													}
%>
													</pre></div>
<%
												}
											}
										}
									}
%>
											</td>
										</tr>
<%
								}
								else if (strValue.startsWith("<?configuration?>"))
								{
%>
										<tr>
											<td width="50%" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>"><%=columnName%></td>
										</tr>
										<tr>
											<td id="linebottomright" width="50%" style="border-left-width:1px" class="<%=fontStyle%>">
<%
												if(strValue == null || strValue.trim().length() == 0)
												{
													strValue = "-";
												}
%>
												<div><pre style="font-family:Courier New !important; font-size:11px"><%=strValue%></pre></div>
											</td>
										</tr>
<%
								}
								else
								{
%>
											<tr>
												<td width="50%" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>"><b><%=columnName%></b></td>
												<td id="linebottomright" width="50%" class="<%=fontStyle%>">
<%
									if(strValue == null || strValue.trim().length() == 0)
									{
										strValue = "-";
									}
									//removing BOM Character begin
									byte[] bytes = strValue.getBytes(EcUtils.UTF8_ENCODING);
									if (EcUtils.isUTF8(bytes))
									{
										strValue = EcUtils.printSkippedBomString(bytes);
									}
									//end

									if (strValue.length() <= 100)
									{
										out.println(strValue);
									}
									else
									{
										ArrayList aListStrValues = null;
										if (columnName.equalsIgnoreCase("VM Arguments"))
										{
											aListStrValues = breakString(strValue,68);
										}
										else
										{
											aListStrValues = breakString(strValue,70);
										}
										for (int r=0;r<aListStrValues.size();r++)
										{
											String str_value = (String)aListStrValues.get(r);
											str_value = EcUtils.replaceTags(str_value);
											out.println(str_value+"<br>");
										}
									}
%>
												</td>
											</tr>
<%
								}
							}
						}
					}
					else
					{
						//Info-Based
						if (colCount <= i_configDataColumnCountout)
						{
							//Column-wise
							if (!colHeading_flag)
							{
%>
											<tr>
<%
								if (colCount == 2)
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" width="50%" class="<%=fontStyle%>">
<%
								}
								else if (colCount == 3)
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" width="33%" class="<%=fontStyle%>">
<%
								}
								else if (colCount == 4)
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" width="25%" class="<%=fontStyle%>">
<%
								}
								else if (colCount == 5)
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" width="20%" class="<%=fontStyle%>">
<%
								}
								else if (colCount == 6)
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" width="16%" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
												<td wrap valign="top" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
<%
								}
%>
													<b><%=(String)al_columnNames.get(0)%></b>
												</td>
<%
								for (int n=1; n<colCount; n++)
								{
									String display_flag = (String)al_flags_column.get(n);
									if(display_flag!=null && display_flag.equals("true"))
									{
										trueFlagColCount++;
										if (colCount == 2)
										{
%>
												<td wrap valign="top" id="linebottomright" width="50%" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
										else if (colCount == 3)
										{
%>
												<td wrap valign="top" id="linebottomright" width="33%" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
										else if (colCount == 4)
										{
%>
												<td wrap valign="top" id="linebottomright" width="25%" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
										else if (colCount == 5)
										{
%>
												<td wrap valign="top" id="linebottomright" width="20%" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
										else if (colCount == 6)
										{
%>
												<td wrap valign="top" id="linebottomright" width="16%" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
										else
										{
%>
												<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
													<b><%=(String)al_columnNames.get(n)%></b>
												</td>
<%
										}
									}
								}
%>
											</tr>
<%
								colHeading_flag = true;
							}

							//if (key_info.indexOf('>') != -1) //Present... Tree form
							//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);

							String row_flag = (String)al_flags_row.get(f);
							if (row_flag.equals("true"))
							{
%>
											<tr>
<%
								if (!isDynamicMeasureTest)
								{
									String strInfo = ecUtils.getInfoForDisplay(key_info);
									if (strInfo.startsWith("<?configuration?>"))
									{
										out.print(strInfo);
									}
									else
									{
										if (strInfo.length() <= 50)
										{
%>
																					<td valign="top" id="linebottomright"  style="border-left-width:1px" class="<%=fontStyle%>"><%=strInfo%></td>
<%
										}
										else
										{
%>
																					<td valign="top" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
<%
											ArrayList aListStrValues = breakString(strInfo,50);
											for (int r=0;r<aListStrValues.size();r++)
											{
												String str_value = (String)aListStrValues.get(r);
												out.print(str_value+"<br>");
											}
%>
																					</td>
<%
										}
									}
								}
								else
								{
%>
																				<td valign="top" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
<%
									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
										}
									}
									out.println(strData);
%>
																				</td>
<%
								}

								for (int z=0; z<colCount-1; z++)
								{
									String display_flag = (String)al_flags_column.get(z+1);
									if (display_flag.equals("true"))
									{
										String s_value = (String)al2.get(z);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{
%>
												<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
													<%=mappingInfo.getTextDescription("configmgmt.common.Yes")%>
												</td>
<%
										}
										else
										{
											if(s_value == null || s_value.trim().length() == 0)
											{
												s_value = "-";
											}

											if (!s_value.startsWith("<?configuration?>"))
											{
												//removing BOM Character begin
												byte[] bytesArr = s_value.getBytes(EcUtils.UTF8_ENCODING);
												if (EcUtils.isUTF8(bytesArr))
												{
													s_value = EcUtils.printSkippedBomString(bytesArr);
												}
												//end

												if (s_value.length()<=25)
												{
													s_value = EcUtils.replaceTags(s_value);
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
												}
												else
												{
													if (colCount == 3)
													{
														if (s_value.length()<=33)
														{
															s_value = EcUtils.replaceTags(s_value);
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
														}
														else
														{
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
															ArrayList aListStrValues = breakString(s_value,33);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}
%>
													</td>
<%
														}
													}
													else if (colCount == 2)
													{
														if (s_value.length()<=100)
														{
															s_value = EcUtils.replaceTags(s_value);
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
														}
														else
														{
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
															ArrayList aListStrValues = breakString(s_value,100);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}
%>
													</td>
<%
														}
													}
													else if (colCount == 5 || colCount == 6 || colCount == 7)
													{
														if (s_value.length()<=35)
														{
															s_value = EcUtils.replaceTags(s_value);
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
														}
														else
														{
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
															ArrayList aListStrValues = breakString(s_value,35);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}
%>
													</td>
<%
														}
													}
													else
													{
														s_value = EcUtils.replaceTags(s_value);
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
													}
												}
											}
											else
											{
												s_value = StringUtils.replace(s_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
													<td wrap valign="top" id="linebottomright" class="<%=fontStyle%>">
														<%=s_value%>
													</td>
<%
											}
										}
									}
								}
							}
							else
							{
%>
												<td id="linebottomright" style="border-left-width:1px" valign="top" colspan="<%=trueFlagColCount+1%>" class="<%=fontStyle%>"><%=ecUtils.getInfoForDisplay(key_info)%></td>
<%
							}
%>
											</tr>
<%
						}
						else
						{
							//Row-wise
							String row_flag = (String)al_flags_row.get(f);
							if (row_flag.equals("true"))
							{
								//if (key_info.indexOf('>') != -1) //Present... Tree form
								//	key_info = key_info.substring(key_info.lastIndexOf('>')+1);
								if (!isDynamicMeasureTest)
								{
%>
											<tr>
												<td height="20" colspan="2" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
													<b><%=ecUtils.getInfoForDisplay(key_info)%></b>
												</td>
											</tr>
<%
								}
								else
								{
%>
											<tr>
												<td height="20" colspan="2" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
<%
									ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
									int aListTokensSize = aListTokens.size();
									String strData = "";
									for (int x=0;x<aListTokensSize;x++)
									{
										String infoHeading = (String)aListInfoHeadings.get(x);
										String strTemp = (String)aListTokens.get(x);
										if (x == aListTokensSize-1)
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
										}
										else
										{
											strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
										}
									}
									out.println(strData);
%>
												</td>
											</tr>
<%
								}

								for (int p=1; p<colCount; p++)
								{
									String display_flag = (String)al_flags_column.get(p);
									if (display_flag.equals("true"))
									{
%>
											<tr>
												<td width="50%" id="linebottomright" style="border-left-width:1px" class="<%=fontStyle%>">
													<%=(String)al_columnNames.get(p)%>
												</td>
<%
										String s_value = (String)al2.get(p-1);
										if (s_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
										{
%>
												<td width="50%" id="linebottomright" class="<%=fontStyle%>">
													<%=mappingInfo.getTextDescription("configmgmt.common.Yes")%>&nbsp;
												</td>
<%
										}
										else
										{
											if(s_value == null || s_value.trim().length() == 0)
											{
												s_value = "-";
											}
											//removing BOM Character begin
											byte[] bytesArr = s_value.getBytes(EcUtils.UTF8_ENCODING);
											if (EcUtils.isUTF8(bytesArr))
											{
												s_value = EcUtils.printSkippedBomString(bytesArr);
											}
											//end

											if (s_value.length() <= 100)
											{
												s_value = EcUtils.replaceTags(s_value);
%>
																				<td id="linebottomright" width="50%" class="<%=fontStyle%>"><%=s_value%>&nbsp;</td>
<%
											}
											else
											{
%>
																				<td id="linebottomright" width="50%" class="<%=fontStyle%>">
<%
												ArrayList aListStrValues = breakString(s_value,100);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}
%>
																				</td>
<%
											}
										}
%>
											</tr>
<%
									}
								}
							}
							else
							{
%>
											<tr>
												<td height="20" colspan="2" id="linebottomright"  style="border-left-width:1px" class="<%=fontStyle%>"><%=ecUtils.getInfoForDisplay(key_info)%></td>
											</tr>
<%
							}
						}
					}
					f++;
				}
%>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
			}
%>
				</table>
			</td>
		</tr>
<%
		}
		else
		{
%>
		<tr>
			<td align="center">
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
			</td>
		</tr>
		<tr>
			<td align="center">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
					<tr>
						<td width="100%" height="100%">
							<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
								<tr>
									<td align="center" height="100%">
										<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
											<tr>
												<td align="center">
													<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
														<tr>
															<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
														</tr>
														<tr>
															<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
		}
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Application_Users"))
	{
		String component = "";
		String heading = "";
		String farmName = "";
		String serverName = "";
		String applicationName = "";
		TreeMap tmapCitrixApplicationsAndUsers = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			component = (String)request.getAttribute("ec_component");
			heading = (String)request.getAttribute("heading");
			farmName = (String)request.getAttribute("farmName");
			serverName = (String)request.getAttribute("serverName");
			applicationName = (String)request.getAttribute("applicationName");

			tmapCitrixApplicationsAndUsers = (TreeMap)request.getAttribute("CitrixApplicationUsers");

		}
		else
		{
			component = (String)session.getAttribute("ec_component");
			heading = (String)session.getAttribute("heading");
			farmName = (String)session.getAttribute("farmName");
			serverName = (String)session.getAttribute("serverName");
			applicationName = (String)session.getAttribute("applicationName");

			tmapCitrixApplicationsAndUsers = (TreeMap)session.getAttribute("CitrixApplicationUsers");
		}
		ArrayList aListCitrixApplicationUsers = null;
		if (applicationName != null && !(applicationName.equalsIgnoreCase("All") || applicationName.equals("-1")))
		{
			aListCitrixApplicationUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationName);
		}

		String componentName = component.substring(0,component.lastIndexOf(":"));
		String componentType = component.substring(component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td align="center">
				<table border="0" width="100%" cellspacing="5" cellpadding="0" height="25" class="body_text">
					<tr>
						<td align="left" width="40%" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.common.Component" /></b> : <%=componentName+":"+componentType%>
						</td>

<%
		if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		{
%>

						<td align="left" width="30%" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Farm name" /></b> : <%=farmName%>
						</td>
<%
		}
		else
		{
%>
						<td align="left" width="30%" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Server name" /></b> : <%=serverName%>
						</td>
<%
		}
%>
						<td align="left" width="20%" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Application" /></b> : <%=applicationName%>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr><td><img src="/final/config/images/spacer.gif" height="5" border="0"></td></tr>

		<tr>
			<td align="center">
				<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text" style="border-bottom-width:0px">
<%
		if (aListCitrixApplicationUsers != null)
		{
			ArrayList aList = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer((String)aListCitrixApplicationUsers.get(0),",");
%>
					<tr>
						<td width="31%" height="20" colspan="4" id="linebottom" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Total users for" /> &nbsp;<%=applicationName%>&nbsp;:&nbsp;<%=strTokens.countTokens()%></b>
						</td>
					</tr>
					<tr>
						<td align="center" colspan="2">

<%
			while (strTokens.hasMoreTokens())
			{
				String token = strTokens.nextToken();
				aList.add(token);
			}
%>
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
							<tr>
								<td width="50%" height="20" colspan="4" id="linebottom" class="<%=fontStyle%>" style= "padding:4px;">
									<b><egui:intnl text="configmgmt.configuration.List of users" /></b>
								</td>
							</tr>
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
			for (int d=0; d<aList.size(); d=d+4)
			{
%>
										<tr>
<%
				for (int e=d; e<d+4; e++)
				{
					if (e<aList.size())
					{
						String userKey = (String)aList.get(e);
						if (e == d+4-1)
						{
%>
											<td id="linebottom" width="25%" height="20" class="<%=fontStyle%>" style= "padding:4px;">
<%
						}
						else
						{
%>
											<td id="linebottomright" width="25%" height="20" class="<%=fontStyle%>" style= "padding:4px;">
<%
						}
%>
							<%=userKey%>
											</td>
<%
					}
					else
					{
						if (e == d+4-1)
						{
%>
											<td id="linebottom" width="25%" height="20" style= "padding:4px;">
<%
						}
						else
						{
%>
											<td id="linebottomright" width="25%" height="20" style= "padding:4px;">
<%
						}
%>
											&nbsp;
											</td>
<%
					}
				}
%>
										</tr>
<%
			}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
		else
		{
%>
					<tr>
						<td width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.configuration.List of applications with their associated users" /></b></td>
					</tr>

					<tr>
						<td align="center">
							<table width="100%" class="body_text" cellspacing="0" cellpadding="5" border="0" align="center" id="bottomtable" style="border-bottom-width:0px;table-layout:fixed">
								<tr>
									<td width="25%" id="linebottomright" align="left" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.configuration.Application" /></b></td>
									<td width="75%" id="linebottom" align="center" height="20" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.Users" /></b></td>
								</tr>

<%
			Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
			while (applicationAsKeys.hasNext())
			{
				String applicationKey = (String)applicationAsKeys.next();
				ArrayList aListUsers = (ArrayList)tmapCitrixApplicationsAndUsers.get(applicationKey);
				ArrayList aList = new ArrayList();
				StringTokenizer strTokens = new StringTokenizer((String)aListUsers.get(0),",");
				while (strTokens.hasMoreTokens())
				{
					String token = strTokens.nextToken();
					aList.add(token);
				}
%>
									<tr>
									<td valign="top" style="padding:0px" colspan="2">
										<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text" style="table-layout:fixed">
											<tr>
												<td width="25%" align="left" valign="top" id="linebottomright" style="padding:4px 4px 4px 4px" height="20" class="<%=fontStyle%>"><%=applicationKey%></td>
												<td width="75%" height="20" style="padding:0px">
													<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
				for (int d=0; d<aList.size(); d=d+3)
				{
%>
														<tr>
<%
					for (int e=d; e<d+3; e++)
					{
						if (e<aList.size())
						{
							String userKey = (String)aList.get(e);
							if (e == d+3-1)
							{
%>
															<td id="linebottom" width="25%" style="padding:4px 4px 4px 4px" class="<%=fontStyle%>">
<%
							}
							else
							{
%>
															<td id="linebottomright" width="25%" style="padding:4px 4px 4px 4px" class="<%=fontStyle%>">
<%
							}
%>
												<%=userKey%>
															</td>
<%
						}
						else
						{
							if (e == d+3-1)
							{
%>
															<td id="linebottom" width="25%" style="padding:4px 4px 4px 4px">
<%
							}
							else
							{
%>
															<td id="linebottomright" width="25%" style="padding:4px 4px 4px 4px">
<%
							}
%>
															&nbsp;</td>
<%
						}
					}
%>
														</tr>
<%
				}
%>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
			}
		}
%>
						</table>
					</td>
				</tr>
<%
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("User_Applications"))
	{
		String component = "";
		String heading = "";
		String farmName = "";
		String serverName = "";
		String userName = "";
		TreeMap tmapCitrixUsersAndApplications = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			component = (String)request.getAttribute("ec_component");
			heading = (String)request.getAttribute("heading");
			farmName = (String)request.getAttribute("farmName");
			serverName = (String)request.getAttribute("serverName");
			userName = (String)request.getAttribute("userName");

			tmapCitrixUsersAndApplications = (TreeMap)request.getAttribute("CitrixUserApplications");

		}
		else
		{
			component = (String)session.getAttribute("ec_component");
			heading = (String)session.getAttribute("heading");
			farmName = (String)session.getAttribute("farmName");
			serverName = (String)session.getAttribute("serverName");
			userName = (String)session.getAttribute("userName");

			tmapCitrixUsersAndApplications = (TreeMap)session.getAttribute("CitrixUserApplications");
		}
		ArrayList aListCitrixUserApplications = null;
		if (userName != null && !(userName.equalsIgnoreCase("All") || userName.equals("-1")))
		{
			aListCitrixUserApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userName);
		}

		String componentName = component.substring(0,component.lastIndexOf(":"));
		String componentType = component.substring(component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td align="center">
				<table border="0" width="100%" cellspacing="5" cellpadding="0" height="25" class="body_text">
					<tr>
						<td align="center" width="40%" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.common.Component" /></b> : <%=componentName+":"+componentType%>
						</td>
<%
		//if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		//{
%>

						<!--<td align="left" width="30%" height="20" class="<%//=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Farm name" /></b> : <%//=farmName%>
						</td>-->
<%
		//}
		//else
		//{
%>
						<!--<td align="left" width="30%" height="20" class="<%//=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Server name" /></b> : <%//=serverName%>
						</td>-->
<%
		//}
%>
						<!--<td align="left" width="30%" height="20" class="<%//=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.User" /></b> : <%//=userName%>
						</td>-->
					</tr>
				</table>
			</td>
		</tr>

		<tr><td><img src="/final/config/images/spacer.gif" height="5" border="0"></td></tr>

		<tr>
			<td align="center">
				<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text" style="border-bottom-width:0px">
<%
		if (aListCitrixUserApplications != null)
		{
			int applicationSize = aListCitrixUserApplications.size();
%>
					<tr>
						<td width="31%" height="20" colspan="4" id="linebottom" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.configuration.Total applications for" /> &nbsp;<%=userName%>&nbsp;:&nbsp;<%=applicationSize%></b>
						</td>
					</tr>
					<tr>
						<td align="center" colspan="2">
							<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">
							<tr>
								<td width="50%" height="20" colspan="4" id="linebottom" class="<%=fontStyle%>" style= "padding:4px;">
									<b><egui:intnl text="configmgmt.configuration.List of applications" /></b>
								</td>
							</tr>
							<tr>
								<td align="left" width="100%">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
			for (int d=0; d<applicationSize; d=d+4)
			{
%>
										<tr>
<%
				for (int e=d; e<d+4; e++)
				{
					if (e<applicationSize)
					{
						if (e == d+4-1)
						{
%>
											<td id="linebottom" width="25%" height="20" class="<%=fontStyle%>" style= "padding:4px;">
<%
						}
						else
						{
%>
											<td id="linebottomright" width="25%" height="20" class="<%=fontStyle%>" style= "padding:4px;">
<%
						}
%>
							<%=aListCitrixUserApplications.get(e)%>
											</td>
<%
					}
					else
					{
						if (e == d+4-1)
						{
%>
											<td id="linebottom" width="25%" height="20" style= "padding:4px;">
<%
						}
						else
						{
%>
											<td id="linebottomright" width="25%" height="20" style= "padding:4px;">
<%
						}
%>
											&nbsp;
											</td>
<%
					}
				}
%>
										</tr>
<%
			}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
		else
		{
%>
					<tr>
						<td width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.configuration.List of users with their associated applications" /></b></td>
					</tr>

					<tr>
						<td align="center">
							<table width="100%" class="body_text" cellspacing="0" cellpadding="5" border="0" align="center" id="bottomtable" style="border-bottom-width:0px;table-layout:fixed">
								<tr>
									<td width="25%" id="linebottomright" align="left" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.configuration.User" /></b></td>
									<td width="75%" id="linebottom" align="center" height="20" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.Applications" /></b></td>
								</tr>
<%
			Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
			while (userAsKeys.hasNext())
			{
				String userKey = (String)userAsKeys.next();
				ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userKey);
%>
								<tr>
									<td valign="top" style="padding:0px" colspan="2">
										<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text" style="table-layout:fixed">
											<tr>
												<td width="25%" align="left" valign="top" id="linebottomright" style="padding:4px 4px 4px 4px" height="20" class="<%=fontStyle%>"><%=userKey%></td>
												<td width="75%" height="20" style="padding:0px">
													<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
				for (int d=0; d<aListApplications.size(); d=d+3)
				{
%>
														<tr>
<%
					for (int e=d; e<d+3; e++)
					{
						if (e<aListApplications.size())
						{
							String applicationKey = (String)aListApplications.get(e);
							if (e == d+3-1)
							{
%>
															<td id="linebottom" width="25%" style="padding:4px 4px 4px 4px" class="<%=fontStyle%>">
<%
							}
							else
							{
%>
															<td id="linebottomright" width="25%" style="padding:4px 4px 4px 4px" class="<%=fontStyle%>">
<%
							}
%>
																<%=applicationKey%>
															</td>
<%
						}
						else
						{
							if (e == d+3-1)
							{
%>
															<td id="linebottom" width="25%" style="padding:4px 4px 4px 4px">
<%
							}
							else
							{
%>
															<td id="linebottomright" width="25%" style="padding:4px 4px 4px 4px">
<%
							}
%>
															&nbsp;</td>
<%
						}
					}
%>
														</tr>
<%
				}
%>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
			}
		}
%>
				</table>
			</td>
		</tr>
<%
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Change"))
	{
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGE")%>&nbsp;:&nbsp;<%=mappingInfo.getTextDescription("configmgmt.changes.detailed.DETAILED")%></b></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" class="<%=fontStyle%>">
<%
			if (ec_option1.equalsIgnoreCase(userOptions[0]))
			{
%>
				<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.COMPONENT NAME")%></b>
<%
			}
			else if (ec_option1.equalsIgnoreCase(userOptions[1]))
			{
%>
				<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.COMPONENT TYPE")%></b>
<%
			}
			else
			{
%>
				<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.ALL COMPONENTS")%></b>
<%
			}
%>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td>
<%
		if (tmap_changeConfigDetails!=null && !tmap_changeConfigDetails.isEmpty())
		{
			String chartColor=chartColorForChangeConfig;
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
			if (ec_option1.equalsIgnoreCase(userOptions[2])) //Only for All Components
			{
%>
				<table border="0" align="center" width="99%" cellpadding="5" cellspacing="0" style="font-size:8pt;" >
					<tr>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+ec_option1)%></b></td>
						<td align="right" class="<%=fontStyle%>">
<%
				if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
				}
				else
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
				}
%>
						</td>
					</tr>
<%
				if (requestHomePage)
				{
					String displayDate = DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",userDateFormat);
%>
					<tr>
						<td align="right" colspan="2" class="<%=fontStyle%>">
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date")%> : </b><%=displayDate%>
<%
					if (!selectedHour.equals(""))
					{
%>
							&nbsp;&nbsp;<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour")%> : </b><%=selectedHour%>
<%
					}
%>
						</td>
					</tr>
<%
				}
%>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
				TreeMap tmapAllComponentChanges = processChangeData.getAllComponentSummary(tmap_changeConfigDetails,selectedDate,selectedHour);

				Iterator changeCountKeys = tmapAllComponentChanges.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					if (changeCount.intValue() == -1) continue;
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				StringBuffer strBufferChangedComponentsTypes = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				ArrayList aListChangedComponentTypes = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();

				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapAllComponentChanges.get(changeCount);
					aListChangedComponentTypes.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}

				//Build graph for TopN items
				boolean topNFlag = false;
				int indexCount = 0;
				if (aListChangedComponentTypes.size() < topN)
				{
					indexCount = aListChangedComponentTypes.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				for (int b=0; b<indexCount; b++)
				{
					String componentType = (String)aListChangedComponentTypes.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);

					count = count + changeCount.intValue();

					if (b==0)
					{
						strBufferChangedComponentsTypes.append(mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(changeCount.intValue());
					}
					else
					{
						strBufferChangedComponentsTypes.append(","+mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(","+changeCount.intValue());
					}
				}

				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
				String maximumRange = ""+maxCount;

				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.component types with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				}
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="5">
					<tr>
						<td colspan="2" height="20" align="center">
							<img src="../servlet/com.eg.EcChartController?chartColor=<%=chartColor%>&view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=750&range=<%=maximumRange%>&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(strBufferChangedComponentsTypes.toString(),"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
				</table>
<%
				TreeMap tmapChangedComponentsUnderType = (TreeMap)tmapAllComponentChanges.get(new Integer("-1"));
%>
				<table border="0" width="99%" cellspacing="0" cellpadding="2" style="padding:0px 0px 5px 5px;font-size:8pt;">
					<tr>
						<td colspan="3" class="<%=fontStyle%>">
							<div style="float:left">
								<b>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes by component type")%></b>
							</div>
							<div style="float:right">
								<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed component types")%> : <%=aListChangedComponentTypes.size()%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")%> : <%=totalCount%>&nbsp;</b>
							</div>
						</td>
					</tr>
				</table>
				<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="5" id="bottomtable" style="border-bottom-width:0px">
					<tr>
						<td width="20%" id="linebottomright" class="<%=fontStyle%>">&nbsp;<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type")%></b></td>
						<td width="5%" id="linebottomright" align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes")%></b></td>
						<td width="75%" id="linebottom" class="<%=fontStyle%>">&nbsp;<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components")%></b></td>
					</tr>
<%
				ArrayList aListChangedComponents = new ArrayList();

				for (int g=0; g<aListChangedComponentTypes.size(); g++)
				{
					String componentType = (String)aListChangedComponentTypes.get(g);
					Integer changes = (Integer)aListChangeCount.get(g);
%>
					<tr>
						<td id="linebottomright" valign="top" class="<%=fontStyle%>">&nbsp;<%=mappingInfo.getComponentTypeDescription(componentType)%></td>
						<td id="linebottomright" valign="top" align="center"><%=changes%></td>
						<td align="left" style="padding:0px">
							<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="5">
<%
					ArrayList aListTemp = (ArrayList)tmapChangedComponentsUnderType.get(componentType);
					for (int m=0; m<aListTemp.size(); m=m+2)
					{
%>
								<tr>
<%
						for (int n=m; n<m+2; n++)
						{
							if (n<aListTemp.size())
							{
								String s1 = (String)aListTemp.get(n);

								String comp = s1.substring(0,s1.indexOf('@'));
								String changeCount = s1.substring(s1.indexOf('@')+1);

								aListChangedComponents.add(comp);
								String s_comp = new String(comp);
								s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));
								if (s_comp.endsWith(":NULL"))
									s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));

								String tmpStr = s_comp;
								int displayLength = 28;
								String strCName = StringUtils.egSubString(tmpStr,displayLength);

								if (n == m+2-1)
								{
%>
									<td width="50%" valign="top" id="linebottom" class="<%=fontStyle%>">
<%
								}
								else
								{
%>
									<td width="50%" valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
								}
%>
										&nbsp;<%=strCName%> [<%=changeCount%>]
									</td>
<%
							}
							else
							{
								if (n == m+2-1)
								{
%>
									<td width="50%" valign="top" id="linebottom">
<%
								}
								else
								{
%>
									<td width="50%" valign="top" id="linebottomright">
<%
								}
%>
										&nbsp;
									</td>
<%
							}
						}
%>
								</tr>
<%
					}
%>
							</table>
						</td>
					</tr>
<%
				}

				aListComponents = aListChangedComponents;
%>
				</table>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
			}

			if (ec_option1.equalsIgnoreCase(userOptions[1])) //Only for Component Type
			{
				String componentType = ec_option2;
%>
				<table border="0" align="center" width="99%" cellpadding="5" cellspacing="0" style="font-size:8pt;" >
					<tr>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type")%> : <%=mappingInfo.getComponentTypeDescription(componentType)%></b></td>
						<td align="right" class="<%=fontStyle%>">
<%
				if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
				}
				else
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
					startDateAndTime = (String)timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
					endDateAndTime = (String)timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
				}
%>
						</td>
					</tr>
<%
				if (requestHomePage)
				{
					String displayDate = DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",userDateFormat);
%>
					<tr>
						<td align="right" colspan="2" class="<%=fontStyle%>">
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date")%> : </b><%=displayDate%>
<%
					if (!selectedHour.equals(""))
					{
%>
							&nbsp;&nbsp;<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour")%> : </b><%=selectedHour%>
<%
					}
%>
						</td>
					</tr>
<%
				}
%>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
				TreeMap tmapChangedComponents = processChangeData.getSummary(tmap_changeConfigDetails,selectedDate,selectedHour);
				Iterator changeCountKeys = tmapChangedComponents.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				StringBuffer strBufferChangedComponents = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				ArrayList aListChangedComponents = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();

				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapChangedComponents.get(changeCount);
					aListChangedComponents.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}

				//Build graph for TopN items
				boolean topNFlag = false;
				int indexCount = 0;
				if (aListChangedComponents.size() < topN)
				{
					indexCount = aListChangedComponents.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				for (int b=0; b<indexCount; b++)
				{
					String comp = (String)aListChangedComponents.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);
					count = count + changeCount.intValue();

					comp = comp.substring(0,comp.lastIndexOf(':'));
					if (comp.endsWith(":NULL"))
						comp = comp.substring(0,comp.lastIndexOf(':'));

					if (b==0)
					{
						strBufferChangedComponents.append(comp);
						strBufferChangeCounts.append(changeCount.intValue());
					}
					else
					{
						strBufferChangedComponents.append(","+comp);
						strBufferChangeCounts.append(","+changeCount.intValue());
					}
				}

				aListComponents = aListChangedComponents;

				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
				String maximumRange = ""+maxCount;

				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.components with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				}
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="5">
					<tr>
						<td colspan="2" height="20" align="center">
							<img src="../servlet/com.eg.EcChartController?chartColor=<%=chartColor%>&view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=750&range=<%=maximumRange%>&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(strBufferChangedComponents.toString(),"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" width="99%" cellspacing="0" cellpadding="5" align="center" class="bottomtable" style="border-bottom-width:0px" >
					<tr>
						<td id="linebottom" colspan="3" class="<%=fontStyle%>">
							<div style="float:left"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components")%></b></div>
							<div style="float:right"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed components")%> : <%=aListChangedComponents.size()%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")%> : <%=totalCount%>&nbsp;</b></div>
						</td>
					</tr>
<%
				for (int d=0; d<aListChangedComponents.size(); d=d+3)
				{
%>
					<tr>
<%
					for (int e=d; e<d+3; e++)
					{
						if (e<aListChangedComponents.size())
						{
							String strComp = (String)aListChangedComponents.get(e);
							strComp = strComp.substring(0,strComp.lastIndexOf(':'));
							if (strComp.endsWith(":NULL"))
								strComp = strComp.substring(0,strComp.lastIndexOf(':'));

							if (e == d+3-1)
							{
%>
						<td id="linebottom" width="20%" class="<%=fontStyle%>">
<%
							}
							else
							{
%>
						<td id="linebottomright" width="20%" class="<%=fontStyle%>">
<%
							}
%>
							&nbsp;<%=strComp%> [<%=aListChangeCount.get(e)%>]
						</td>
<%
						}
						else
						{
							if (e == d+3-1)
							{
%>
						<td id="linebottom" width="20%">
<%
							}
							else
							{
%>
						<td id="linebottomright" width="20%">
<%
							}
%>
							&nbsp;
						</td>
<%
						}
					}
%>
					</tr>
<%
				}
%>
				</table>
				<table border="0" cellspacing="5" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="8"></td></tr></table>
<%
			}
			if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byDate"))
			{
				if (ec_option1.equalsIgnoreCase(userOptions[0]))
				{
					String key_component = (String)aListComponents.get(0);

					String component = key_component.substring(0,key_component.lastIndexOf(':'));
					if (component.endsWith(":NULL"))
						component = component.substring(0,component.lastIndexOf(':'));

					String component_type = key_component.substring(key_component.lastIndexOf(':')+1);
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>

				<!--<table border="0" align="center" width="99%" style="font-size:8pt;font-family:Verdana">-->
				<table border="0" align="center" width="99%" style="font-size:11pt;">
					<tr>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name")%> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(component_type)%>]</b></td>
						<td align="right" class="<%=fontStyle%>">
<%
					if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
						startDateAndTime = (String)timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
						endDateAndTime = (String)timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
					}
					else
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
						startDateAndTime = (String)timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
						endDateAndTime = (String)timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
					}
%>
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>

<%
					TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,selectedHour);
					Iterator changeCountKeys = tmapChanges.keySet().iterator();
					int totalCount=0;
					int maxCount=0;
					ArrayList aList = new ArrayList();
					while (changeCountKeys.hasNext())
					{
						Integer changeCount = (Integer)changeCountKeys.next();
						aList.add(changeCount);
						maxCount=Math.max(maxCount,changeCount.intValue());
					}
					Collections.reverse(aList);

					ArrayList aListTestnames = new ArrayList();
					ArrayList aListChangeCount = new ArrayList();

					StringBuffer strBufferTestnames = new StringBuffer();
					StringBuffer strBufferChangeCounts = new StringBuffer();

					int i_totalChangeCount = 0;
					for (int a=0; a<aList.size(); a++)
					{
						Integer changeCount = (Integer)aList.get(a);
						ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

						aListTestnames.addAll(aListTemp);

						for (int i=0; i<aListTemp.size(); i++)
						{
							aListChangeCount.add(changeCount);
							i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
						}
					}

					//Build graph for TopN items
					boolean topNFlag = false;
					int indexCount = 0;
					if (aListTestnames.size() < topN)
					{
						indexCount = aListTestnames.size();
					}
					else
					{
						indexCount = topN;
						topNFlag = true;
					}

					for (int b=0; b<indexCount; b++)
					{
						String testname = (String)aListTestnames.get(b);
						Integer changeCount = (Integer)aListChangeCount.get(b);
						if (b == 0)
						{
							strBufferTestnames.append(mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(changeCount.intValue());
						}
						else
						{
							strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(","+changeCount.intValue());
						}
						totalCount = totalCount + changeCount.intValue();
					}

					String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
					maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
					String maximumRange = ""+maxCount;

					if (topNFlag)
					{
						titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
					}
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="5">
					<tr>
						<td colspan="2" height="20" align="center">
							<img src="../servlet/com.eg.EcChartController?chartColor=<%=chartColor%>&view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=750&range=<%=maximumRange%>&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
				}

				ArrayList aListChangesDatewise = null;
				aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

				aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,searchCompValue,searchTestValue,searchDescValue,userLanguage);

				if (requestHomePage)
				{
					//Add the code here for restricting the data to the selected date
					aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,selectedHour);
				}
				int aListChangesDatewiseSize = aListChangesDatewise.size();
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable" style="border-bottom-width:0px; border-right-width:0px">
					<tr>
						<td>
							<table border="0" cellspacing="0" cellpadding="5" align="center" width="100%" class="body_text">
<%
				String strInformationWidth = "15%";
				String strDescriptionWidth = "20%";

				boolean heading_flag = false;
				for(int i=0; i<aListChangesDatewiseSize; i++)
				{
					ArrayList al = (ArrayList)aListChangesDatewise.get(i);
					if (!heading_flag)
					{
%>
								<tr>
									<td id="linebottomright" width="5%" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Change Date")%></b>
									</td>
<%
						if (!ec_option1.equalsIgnoreCase(userOptions[0]))
						{
%>
									<td id="linebottomright" width="10%" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component")%></b>
									</td>
<%
							strInformationWidth = "10%";
							strDescriptionWidth = "15%";
						}
%>
									<td id="linebottomright" width="<%=strInformationWidth%>" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Information")%></b>
									</td>
									<td id="linebottomright" width="<%=strDescriptionWidth%>" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor")%></b>
									</td>
									<td width="20%" id="linebottomright" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure")%></b>
									</td>
									<td width="20%" id="linebottomright" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value")%></b>
									</td>
									<td width="20%" id="linebottomright" class="<%=fontStyle%>">
										<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value")%></b>
									</td>
								</tr>
<%
						heading_flag = true;
					}

					String strDateTime = (String)al.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
					String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
					String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",userDateFormat);

					String component = (String)al.get(1);
					String cname = component.substring(0,component.lastIndexOf(':'));
					if (cname.endsWith(":NULL"))
						cname = cname.substring(0,cname.lastIndexOf(':'));
					String ctype = component.substring(component.lastIndexOf(':')+1);
					String displayComponent = cname + ":" + mappingInfo.getComponentTypeDescription(ctype);

					String testname = (String)al.get(2);
					String info = (String)al.get(3);
					Object measure_obj = al.get(4);
					Object previous_obj = al.get(5);
					Object present_obj = al.get(6);

					boolean isDynamicMeasureTest = false;
					int idx_M = info.indexOf("~M~");
					if (idx_M != -1)
					{
						isDynamicMeasureTest = true;
					}

					ArrayList aListInfoHeadings = null;
					if (isDynamicMeasureTest)
					{
						aListInfoHeadings = new ArrayList();
						String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
						if (infoHeadings != null && infoHeadings.length() > 0)
						{
							StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
							while (strTokensTemp.hasMoreTokens())
							{
								String str_temp = strTokensTemp.nextToken();
								aListInfoHeadings.add(str_temp);
							}
						}
					}

					boolean newInfoFlag = false;
					if (measure_obj instanceof ArrayList)
					{
						newInfoFlag = true;
					}
%>
								<tr>
									<td id="linebottomright" wrap valign="top" width="5%" class="<%=fontStyle%>">
										<%=displayDate + " " + strTime%>
									</td>
<%
					if (!ec_option1.equalsIgnoreCase(userOptions[0]))
					{
%>
									<td id="linebottomright" wrap valign="top" width="10%" class="<%=fontStyle%>">
										<%=displayComponent%>
									</td>
<%
					}
%>
									<td id="linebottomright" wrap valign="top" width="<%=strInformationWidth%>" class="<%=fontStyle%>">
										<%=mappingInfo.getTestDescription(testname)%>
									</td>
									<td valign="top" width="<%=strDescriptionWidth%>" id="linebottomright" class="<%=fontStyle%>">
<%
					if (!isDynamicMeasureTest)
					{
						info = ecUtils.getInfoForDisplay(info);
						if (!info.equals("+"))
						{
							if (info.length()<=25)
							{
								out.println(info);
							}
							else
							{
								ArrayList aListStrValues = breakString(info,25);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									out.println(str_value+"<br>");
								}
							}
						}
						else
						{
							out.println("&nbsp;");
						}
					}
					else
					{
						if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
						{
							out.println("&nbsp;");
						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strData = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								}
								else
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								}
							}
							out.println(strData);
						}
					}

					if (newInfoFlag)
					{
%>
						<img src="/final/config/images/new_info.gif" border="0">
<%
					}
%>
									</td>
<%
					if (measure_obj instanceof String)
					{
						String previous_value = (String)previous_obj;
						String present_value = (String)present_obj;

						if(previous_value == null || previous_value.trim().length() == 0)
						{
							previous_value = "-";
						}
						if(present_value == null || present_value.trim().length() == 0)
						{
							present_value = "-";
						}

						if (EcUtils.isUTF8(previous_value.getBytes()))
						{
							previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
						}
						if (EcUtils.isUTF8(present_value.getBytes()))
						{
							present_value = EcUtils.printSkippedBomString(present_value.getBytes());
						}

						boolean newMeasureFlag = false;
						boolean deletedMeasureFlag = false;
						if (isDynamicMeasureTest && !newInfoFlag)
						{
							if (previous_value.equalsIgnoreCase("##NEW##") || 
								previous_value.equalsIgnoreCase("##NEW-INFO##") || 
								previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								newMeasureFlag = true;
							}
							else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								deletedMeasureFlag = true;
							}
						}

						if (newMeasureFlag)
						{
%>
									<td width="20%" valign="top" wrap id="linebottomright" class="<%=fontStyle%>"><%=measure_obj%><br><img src="/final/config/images/new_info.png" border="0"></td>
<%
						}
						else if (deletedMeasureFlag)
						{
%>
									<td width="20%" valign="top" wrap id="linebottomright" class="<%=fontStyle%>"><%=measure_obj%><br><img src="/final/config/images/removed_info.png" border="0"></td>
<%
						}
						else
						{
%>
									<td width="20%" valign="top" wrap id="linebottomright" class="<%=fontStyle%>"><%=measure_obj%></td>
<%
						}

						if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
						{
							previous_value = "[N/PV]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							previous_value = "[N/A]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (previous_value.length()<=18)
						{
							previous_value = EcUtils.replaceTags(previous_value);
%>
									<td width="20%" valign="top" id="linebottomright" class="<%=fontStyle%>"><%=previous_value%>&nbsp;</td>
<%
						}
						else
						{
%>
									<td valign="top" id="linebottomright" width="20%" class="<%=fontStyle%>">
<%
							ArrayList aListStrValues = breakString(previous_value,18);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}
%>
									</td>
<%
						}

						if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							present_value = "[N/A]";
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (present_value.length()<=18)
						{
							present_value = EcUtils.replaceTags(present_value);
%>
									<td width="20%" valign="top" id="linebottomright" class="<%=fontStyle%>"><%=present_value%>&nbsp;</td>
<%
						}
						else
						{
%>
									<td valign="top" id="linebottomright" width="20%" class="<%=fontStyle%>">
<%
							ArrayList aListStrValues = breakString(present_value,18);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}
%>
									</td>
<%
						}
					}
					else
					{
						ArrayList mn = (ArrayList)measure_obj;
						ArrayList prev = (ArrayList)previous_obj;
						ArrayList pres = (ArrayList)present_obj;
%>
									<td valign="top" width="60%" height="100%" style="padding:0px" colspan="3">
										<table border="0" cellspacing="0" cellpadding="5" height="100%" align="center" width="100%" class="body_text">
<%
						for (int z=0;z<mn.size();z++)
						{
							String measure = (String)mn.get(z);
							String prevValue = (String)prev.get(z);
							String presValue = (String)pres.get(z);

							if(prevValue == null || prevValue.trim().length() == 0)
							{
								prevValue = "-";
							}
							if(presValue == null || presValue.trim().length() == 0)
							{
								presValue = "-";
							}

							if (EcUtils.isUTF8(prevValue.getBytes()))
							{
								prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
							}
							if (EcUtils.isUTF8(presValue.getBytes()))
							{
								presValue = EcUtils.printSkippedBomString(presValue.getBytes());
							}
%>
											<tr>
												<td width="33%" valign="top" id="linebottomright" class="<%=fontStyle%>"><%=measure%></td>
<%
							if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
							{
								prevValue = "[N/PV]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								prevValue = "[N/A]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (prevValue.length()<=18)
							{
								prevValue = EcUtils.replaceTags(prevValue);
%>
												<td width="33%" valign="top" id="linebottomright" class="<%=fontStyle%>"><%=prevValue%>&nbsp;</td>
<%
							}
							else
							{
%>
												<td valign="top" id="linebottomright" width="33%" class="<%=fontStyle%>">
<%
								ArrayList aListStrValues = breakString(prevValue,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}
%>
												</td>
<%
							}

							if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								presValue = "[N/A]";
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (presValue.length()<=18)
							{
								presValue = EcUtils.replaceTags(presValue);
%>
												<td width="33%" valign="top" id="linebottomright" class="<%=fontStyle%>"><%=presValue%>&nbsp;</td>
<%
							}
							else
							{
%>
												<td valign="top" id="linebottomright" width="33%" class="<%=fontStyle%>">
<%
								ArrayList aListStrValues = breakString(presValue,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}
%>
												</td>
<%
							}
%>
											</tr>
<%
						}
%>
										</table>
									</td>
<%
					}
%>
								</tr>
<%
				}
%>
							</table>
						</td>
					</tr>
				</table>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
			}
			else
			{
				if(!(ec_option1.equalsIgnoreCase(userOptions[0]))) // comp name
				{
%>
					<table border="0" cellspacing="0" cellpadding="0" width="100%" id="pageHeader" style="border-color:#777777"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
					<table border="0" cellspacing="5" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
				}
				//Display changes information-wise(testname)
				//if (ec_option1.equalsIgnoreCase(userOptions[0]))
				//{
					for (int g=0; g<aListComponents.size(); g++)
					{
						String key_component = (String)aListComponents.get(g);
						TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(key_component);

						String component = key_component.substring(0,key_component.lastIndexOf(':'));
						if (component.endsWith(":NULL"))
							component = component.substring(0,component.lastIndexOf(':'));

						String component_type = key_component.substring(key_component.lastIndexOf(':')+1);
%>
				<table border="0" align="center" width="99%" class="body_text" style="font-size:11pt;" cellspacing="0" cellpadding="5">
					<tr>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name")%> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(component_type)%>]</b></td>
						<td align="right" class="<%=fontStyle%>">
<%
						if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
							startDateAndTime = (String)timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
							endDateAndTime = (String)timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
						}
						else
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
							startDateAndTime = (String)timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
							endDateAndTime = (String)timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */
%>
							<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.between")%>&nbsp;<%=startDateAndTime%>&nbsp;<%=mappingInfo.getTextDescription("configmgmt.common.and")%>&nbsp;<%=endDateAndTime%></b>
<%
						}
%>
						</td>
					</tr>
				</table>
<%
						TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,selectedHour);
						Iterator changeCountKeys = tmapChanges.keySet().iterator();
						int totalCount=0;
						int maxCount=0;
						ArrayList aList = new ArrayList();
						while (changeCountKeys.hasNext())
						{
							Integer changeCount = (Integer)changeCountKeys.next();
							aList.add(changeCount);
							maxCount=Math.max(maxCount,changeCount.intValue());
						}
						Collections.reverse(aList);

						StringBuffer strBufferTestnames = new StringBuffer();
						StringBuffer strBufferChangeCounts = new StringBuffer();
						ArrayList aListTestnames = new ArrayList();
						ArrayList aListChangeCount = new ArrayList();

						int i_totalChangeCount = 0;
						for (int a=0; a<aList.size(); a++)
						{
							Integer changeCount = (Integer)aList.get(a);
							ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

							aListTestnames.addAll(aListTemp);

							for (int i=0; i<aListTemp.size(); i++)
							{
								aListChangeCount.add(changeCount);
								i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
							}
						}

						//Build graph for TopN items
						boolean topNFlag = false;
						int indexCount = 0;
						if (aListTestnames.size() < topN)
						{
							indexCount = aListTestnames.size();
						}
						else
						{
							indexCount = topN;
							topNFlag = true;
						}

						for (int b=0; b<indexCount; b++)
						{
							String testname = (String)aListTestnames.get(b);
							Integer changeCount = (Integer)aListChangeCount.get(b);
							if (b == 0)
							{
								strBufferTestnames.append(mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(changeCount.intValue());
							}
							else
							{
								strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(","+changeCount.intValue());
							}
							totalCount = totalCount + changeCount.intValue();
						}

						String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
						maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
						String maximumRange = ""+maxCount;

						if (topNFlag)
						{
							titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
						}
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="5">
					<tr>
						<td colspan="2" height="20" align="center">
							<img src="../servlet/com.eg.EcChartController?chartColor=<%=chartColor%>&view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=750&range=<%=maximumRange%>&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
						tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,selectedHour);

						for (int c=0; c<aListTestnames.size(); c++)
						{
							String key_testname = (String)aListTestnames.get(c);
							Integer changeCount = (Integer)aListChangeCount.get(c);
							TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
							Iterator info_keys = temp_tmap_Data.keySet().iterator();

							boolean isDynamicMeasureTest = false;
							String firstKey = (String)temp_tmap_Data.firstKey();
							int idx_M = firstKey.indexOf("~M~");
							if (idx_M != -1)
							{
								isDynamicMeasureTest = true;
							}

							ArrayList aListInfoHeadings = null;
							if (isDynamicMeasureTest)
							{
								aListInfoHeadings = new ArrayList();
								String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
								if (infoHeadings != null && infoHeadings.length() > 0)
								{
									StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
									while (strTokensTemp.hasMoreTokens())
									{
										String str_temp = strTokensTemp.nextToken();
										aListInfoHeadings.add(str_temp);
									}
								}
							}
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" style="border-bottom-width:0px;font-size:8pt;">
					<tr>
						<td style="padding:5px" colspan="4" id="linebottom" class="<%=fontStyle%>">
							<b><%=mappingInfo.getTestDescription(key_testname)%>&nbsp;&nbsp;(<%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes")%> : <%=changeCount%>)</b>
						</td>
					</tr>
					<tr>
						<td>
							<table cellspacing="0" cellpadding="5" border="0" align="center" width="100%" class="bottomtable" style="border-top-width:0px;border-bottom-width:0px">
<%
							boolean heading_flag = false;
							while (info_keys.hasNext())
							{
%>
								<tr>
<%
								String key_info = (String)info_keys.next();
								if (!heading_flag)
								{
									if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
									{
%>
									<td width="20%" id="linebottomright" height="20" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor")%></b></td>
<%
									}
%>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure")%></b></td>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Date")%></b></td>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value")%></b></td>
									<td width="20%" id="linebottom" nowrap class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value")%></b></td>
								</tr>
<%
									heading_flag = true;
								}

								TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
								Iterator measure_keys = tmap_Data.keySet().iterator();

								boolean newInfoFlag = false;
								int idx_NI = key_info.indexOf("~NEW-INFO~");
								if (idx_NI != -1)
								{
									newInfoFlag = true;
									key_info = key_info.substring(idx_NI+10);
								}

								if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
								{
%>
								<tr>
									<td colspan="5" id="linebottom">
										<table cellspacing="0" cellpadding="2" border="0" class="body_text"  width="100%">
											<tr>
												<td align="left" class="<%=fontStyle%>" id="noprint" style="font-style:italic">
<%
									if (!isDynamicMeasureTest)
									{
%>
													<b><i><%=ecUtils.getInfoForDisplay(key_info)%></i></b>
<%
									}
									else
									{
										ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
										int aListTokensSize = aListTokens.size();
										String strData = "";
										for (int x=0;x<aListTokensSize;x++)
										{
											String infoHeading = (String)aListInfoHeadings.get(x);
											String strTemp = (String)aListTokens.get(x);
											if (x == aListTokensSize-1)
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
											}
											else
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
											}
										}
										out.println(strData);
									}

									if (newInfoFlag)
									{
%>
										<img src="/final/config/images/new_info.gif" border="0">
<%
									}
%>
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
								}

								measure_keys = tmap_Data.keySet().iterator();
								while (measure_keys.hasNext())
								{
									String key_measure = (String)measure_keys.next();
									ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);
									boolean measureFlag = false;

									for(int y=0;y<al_data.size();y++)
									{
										ArrayList arraylist_temp = (ArrayList)al_data.get(y);

										String previous_measurevalue = (String)arraylist_temp.get(1);
										String present_measurevalue = (String)arraylist_temp.get(2);

										if (!isDynamicMeasureTest)
										{
											if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase("##R##") && !present_measurevalue.equalsIgnoreCase("##R##"))
											{
%>
								<tr>
<%
												if (!key_info.equals("+"))
												{
%>
									<td width="20%" id="linebottomright">&nbsp;</td>
<%
												}

												if (!measureFlag)
												{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%></td>
<%
													measureFlag = true;
												}
												else
												{
%>
									<td width="20%" nowrap id="linebottomright">&nbsp;</td>
<%
												}

												String strDateTime = (String)arraylist_temp.get(0);
												String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
												String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
												String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

												/* Added by Prakash.K starts */
												timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
												startDateAndTime = (String)timeZoneConverter.getDateTime();
												/* Added by Prakash.K ends */
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=startDateAndTime%>
									</td>
<%
												if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=mappingInfo.getTextDescription("configmgmt.common.Yes")%></td>
<%
												}
												else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=mappingInfo.getTextDescription("configmgmt.common.No")%></td>
<%
												}
												else
												{
													if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
													{
														previous_measurevalue = "[N/PV]";
													}
													if (previous_measurevalue.startsWith("<?configuration?>"))
													{
														previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
										<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
													}
													else
													{
														if (previous_measurevalue.length()<=28)
														{
															previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
										<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
														}
														else
														{
%>
										<td width="20%" valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
															ArrayList aListStrValues = breakString(previous_measurevalue,28);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.println(str_value+"<br>");
															}
%>
										</td>
<%
														}
													}
												}

												if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
										<%=mappingInfo.getTextDescription("configmgmt.common.Yes")%>
									</td>
<%
												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
										<%=mappingInfo.getTextDescription("configmgmt.common.No")%>
									</td>
<%
												}
												else
												{
													if (present_measurevalue.startsWith("<?configuration?>"))
													{
														present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
										<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
											<%=present_measurevalue%>&nbsp;
										</td>
<%
													}
													else
													{
														if (present_measurevalue.length()<=28)
														{
															present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
										<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
											<%=present_measurevalue%>&nbsp;
										</td>
<%
														}
														else
														{
%>
										<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
<%
															ArrayList aListStrValues = breakString(present_measurevalue,28);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.println(str_value+"<br>");
															}
%>
										</td>
<%
														}
													}
												}
%>
								</tr>
<%
											}
										}
										else
										{
%>
								<tr>
<%
											if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
											{
%>
									<td width="20%" id="linebottomright">&nbsp;</td>
<%
											}

											boolean newMeasureFlag = false;
											boolean deletedMeasureFlag = false;
											if (!newInfoFlag)
											{
												if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
													previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
													previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													newMeasureFlag = true;
												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													deletedMeasureFlag = true;
												}
											}

											if (newMeasureFlag)
											{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%>&nbsp;<img src="/final/config/images/new_info.png" border="0"></td>
<%
											}
											else if (deletedMeasureFlag)
											{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%>&nbsp;<img src="/final/config/images/removed_info.png" border="0"></td>
<%
											}
											else
											{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%></td>
<%
											}

											String strDateTime = (String)arraylist_temp.get(0);
											String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
											String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
											String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

											/* Added by Prakash.K starts */
											timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
											startDateAndTime = (String)timeZoneConverter.getDateTime();
											/* Added by Prakash.K ends */
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>">
										<%=startDateAndTime%>
									</td>
<%
											if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
											{
												previous_measurevalue = "[N/PV]";
											}
											else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												previous_measurevalue = "[N/A]";
											}

											if (previous_measurevalue.length()<=28)
											{
												previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
											}
											else
											{
%>
									<td width="20%" id="linebottomright" class="<%=fontStyle%>">
<%
												ArrayList aListStrValues = breakString(previous_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}
%>
									</td>
<%
											}

											if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												present_measurevalue = "[N/A]";
											}

											if (present_measurevalue.length()<=28)
											{
												present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>"><%=present_measurevalue%>&nbsp;</td>
<%
											}
											else
											{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
<%
												ArrayList aListStrValues = breakString(present_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}
%>
									</td>
<%
											}
%>
								</tr>
<%
										}
									}
								}
							}
%>
							</table>
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
						}

						if (g < aListComponents.size()-1)
						{
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
						}
					}
				//}
			}
		}
		else
		{
%>
				<table border="0" align="center" width="100%" id="bottomtable" cellpadding="2" cellspacing="0">
					<tr>
<%
			if (ec_option1.equalsIgnoreCase(userOptions[2])) //Only for All Components
			{
%>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+ec_option1)%></b></td>
<%
			}
			else if (ec_option1.equalsIgnoreCase(userOptions[1])) //Only for Component Type
			{
				String componentType = ec_option2;
%>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type")%> : <%=mappingInfo.getComponentTypeDescription(componentType)%></b></td>
<%
			}
			else if (ec_option1.equalsIgnoreCase(userOptions[0]))
			{
				String key_component = ec_option2;

				String component = key_component.substring(0,key_component.lastIndexOf(':'));
				if (component.endsWith(":NULL"))
				{
					component = component.substring(0,component.lastIndexOf(':'));
				}

				String component_type = key_component.substring(key_component.lastIndexOf(':')+1);
%>
						<td align="left" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name")%> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(component_type)%>]</b></td>
<%
			}
%>
						<td align="right" class="<%=fontStyle%>">
<%
			if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
			{
%>
				<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%> <%=mappingInfo.getTextDescription("configmgmt.common.between")%> <%=s_start_time%> <%=mappingInfo.getTextDescription("configmgmt.common.and")%> <%=s_end_time%></b>
<%
			}
			else
			{
%>
				<b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes")%> <%=mappingInfo.getTextDescription("configmgmt.common.between")%> <%=ec_stdate%> <%=sHour%>:<%=sMinute%> <%=mappingInfo.getTextDescription("configmgmt.common.and")%> <%=ec_enddate%> <%=eHour%>:<%=eMinute%></b>
<%
			}
%>
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>

				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
					<tr>
						<td width="100%" height="100%">
							<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0" height="100%">
								<tr>
									<td align="center" height="100%" >
										<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
											<tr>
												<td align="center">
													<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0">
														<tr>
															<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
														</tr>
														<tr>
															<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.changes.detailed.There were no configuration changes in the selected timeline")%></b></td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
		}
%>
			</td>
		</tr>
<%
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ShowComponentChanges"))
	{
		String chartColor=chartColorForChangeConfig;
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td align="right" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE " />&nbsp;:&nbsp;<egui:intnl text="configmgmt.changes.detailed.DETAILED" /></b></td>
								</tr>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.COMPONENT NAME" /></b>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td>
<%
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
		{
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
		}

		String component = ec_component.substring(0,ec_component.lastIndexOf(':'));
		if (component.endsWith(":NULL"))
			component = component.substring(0,component.lastIndexOf(':'));

		String component_type = ec_component.substring(ec_component.lastIndexOf(':')+1);
%>
				<table border="0" align="center" width="99%" class="body_text">
					<tr>
						<td align="left" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Component Name" /> : <%=component%> [<egui:intnl type="<%=component_type%>" />]</b></td>
						<td align="right" class="<%=fontStyle%>">
<%
		if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
		{
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
			startDateAndTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
			endDateAndTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
%>
							<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp; <egui:intnl text="configmgmt.common.between" /> &nbsp;<%=startDateAndTime%> &nbsp;<egui:intnl text="configmgmt.common.and" /> &nbsp; <%=endDateAndTime%></b>
<%
		}
		else
		{
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
			startDateAndTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
			endDateAndTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
%>
							<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp; <egui:intnl text="configmgmt.common.between" />&nbsp; <%=startDateAndTime%>&nbsp; <egui:intnl text="configmgmt.common.and" />&nbsp; <%=endDateAndTime%></b>
<%
		}
%>
						</td>
					</tr>
				</table>
<%
		TreeMap tmapChanges = processChangeData.getComponentSummary(ec_component,tmap_changeConfigDetails,selectedDate,selectedHour);
		Iterator changeCountKeys = tmapChanges.keySet().iterator();
		int totalCount=0;
		int maxCount=0;
		ArrayList aList = new ArrayList();
		while (changeCountKeys.hasNext())
		{
			Integer changeCount = (Integer)changeCountKeys.next();
			aList.add(changeCount);
			maxCount=Math.max(maxCount,changeCount.intValue());
		}
		Collections.reverse(aList);

		StringBuffer strBufferTestnames = new StringBuffer();
		StringBuffer strBufferChangeCounts = new StringBuffer();
		ArrayList aListTestnames = new ArrayList();
		ArrayList aListChangeCount = new ArrayList();
		int i_totalChangeCount = 0;

		for (int a=0; a<aList.size(); a++)
		{
			Integer changeCount = (Integer)aList.get(a);
			ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

			aListTestnames.addAll(aListTemp);

			for (int i=0; i<aListTemp.size(); i++)
			{
				aListChangeCount.add(changeCount);
				i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
			}
		}

		//Build graph for TopN items
		boolean topNFlag = false;
		int indexCount = 0;
		if (aListTestnames.size() < topN)
		{
			indexCount = aListTestnames.size();
		}
		else
		{
			indexCount = topN;
			topNFlag = true;
		}

		for (int b=0; b<indexCount; b++)
		{
			String testname = (String)aListTestnames.get(b);
			Integer changeCount = (Integer)aListChangeCount.get(b);
			if (b == 0)
			{
				strBufferTestnames.append(mappingInfo.getTestDescription(testname));
				strBufferChangeCounts.append(changeCount.intValue());
			}
			else
			{
				strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
				strBufferChangeCounts.append(","+changeCount.intValue());
			}
			totalCount = totalCount + changeCount.intValue();
		}

		String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + totalCount;
		maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
		String maximumRange = ""+maxCount;

		if (topNFlag)
		{
			titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "    " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;
		}
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text">
					<tr>
						<td colspan="2" height="20" align="center" >
							<img src="../servlet/com.eg.EcChartController?chartColor=<%=chartColor%>&view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=750&range=<%=maximumRange%>&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(strBufferChangeCounts.toString(),"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
		//Display changes information-wise(testname)
		if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byInformation"))
		{
			TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(ec_component);
			tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,selectedHour);
			for (int c=0; c<aListTestnames.size(); c++)
			{
				String key_testname = (String)aListTestnames.get(c);
				Integer changeCount = (Integer)aListChangeCount.get(c);
				TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
				Iterator info_keys = temp_tmap_Data.keySet().iterator();
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" style="border-bottom-width:0px" class="body_text">
					<tr>
						<td id="linebottom" style="padding:3px" colspan="4" class="<%=fontStyle%>">
							<b><egui:intnl test="<%=key_testname%>" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.changes.detailed.Changes" /> : <%=changeCount%>)</b>
						</td>
					</tr>
					<tr>
						<td>
							<table cellspacing="0" cellpadding="5" border="0" align="center" width="100%" class="bottomtable" style="border-bottom-width:0px;border-top-width:0px">
<%
				boolean isDynamicMeasureTest = false;
				String firstKey = (String)temp_tmap_Data.firstKey();
				int idx_M = firstKey.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

				ArrayList aListInfoHeadings = null;
				if (isDynamicMeasureTest)
				{
					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

				boolean heading_flag = false;
				while (info_keys.hasNext())
				{
%>
								<tr>
<%
					String key_info = (String)info_keys.next();
					if (!heading_flag)
					{
						if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
						{
%>
									<td width="20%" id="linebottomright" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Descriptor" /></b></td>
<%
						}
%>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Measure" /></b></td>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Date" /></b></td>
									<td width="20%" id="linebottomright" nowrap class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Previous Value" /></b></td>
									<td width="20%" id="linebottom" nowrap class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.detailed.Present Value" /></b></td>
								</tr>
<%
						heading_flag = true;
					}

					TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
					Iterator measure_keys = tmap_Data.keySet().iterator();

					boolean newInfoFlag = false;
					int idx_NI = key_info.indexOf("~NEW-INFO~");
					if (idx_NI != -1)
					{
						newInfoFlag = true;
						key_info = key_info.substring(idx_NI+10);
					}

					if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
					{
%>
								<tr>
									<td colspan="5" id="linebottom">
										<table cellspacing="0" cellpadding="0" border="0" class="body_text"  height="18" width="100%">
											<tr>
												<td align="left" class="<%=fontStyle%>">
<%
						if (!isDynamicMeasureTest)
						{
%>
													<b style="font-size:7.5pt">&nbsp;<%=ecUtils.getInfoForDisplay(key_info)%></b>
<%
						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strData = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								}
								else
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								}
							}
							out.println("&nbsp;"+strData);
						}

						if (newInfoFlag)
						{
%>
													<img src="/final/config/images/new_info.gif" border="0">
<%
						}
%>
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
					}

					measure_keys = tmap_Data.keySet().iterator();
					while (measure_keys.hasNext())
					{
						String key_measure = (String)measure_keys.next();
						ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);
						boolean measureFlag = false;
						for(int y=0;y<al_data.size();y++)
						{
							ArrayList arraylist_temp = (ArrayList)al_data.get(y);
							String previous_measurevalue = (String)arraylist_temp.get(1);
							String present_measurevalue = (String)arraylist_temp.get(2);

							if (!isDynamicMeasureTest)
							{
								if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase("##R##") && !present_measurevalue.equalsIgnoreCase("##R##"))
								{
%>
								<tr>
<%
									if (!key_info.equals("+"))
									{
%>
									<td width="20%" id="linebottomright">&nbsp;</td>
<%
									}

									if (!measureFlag)
									{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%></td>
<%
										measureFlag = true;
									}
									else
									{
%>
									<td width="20%" nowrap id="linebottomright">&nbsp;</td>
<%
									}

									String strDateTime = (String)arraylist_temp.get(0);
									String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
									String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
									String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

									/* Added by Prakash.K starts */
									timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
									startDateAndTime = (String)timeZoneConverter.getDateTime();
									/* Added by Prakash.K ends */
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>">
										<%=startDateAndTime%> 
									</td>
<%
									if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
									{
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
									}
									else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
									{
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><egui:intnl text="configmgmt.common.No" /></td>
<%
									}
									else
									{
										if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
										{
											previous_measurevalue = "[N/PV]";
										}

										if (previous_measurevalue.startsWith("<?configuration?>"))
										{
											previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
											<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
										}
										else
										{
											if (previous_measurevalue.length()<=28)
											{
												previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
										<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
											}
											else
											{
%>
										<td width="20%" valign="top" id="linebottomright" class="<%=fontStyle%>">
<%
												ArrayList aListStrValues = breakString(previous_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}
%>
										</td>
<%
											}
										}
									}

									if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
									{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
										<egui:intnl text="configmgmt.common.Yes" />
									</td>
<%
									}
									else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
									{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
										<egui:intnl text="configmgmt.common.No" />
									</td>
<%
									}
									else
									{
										if (present_measurevalue.startsWith("<?configuration?>"))
										{
											present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
											<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=present_measurevalue%>&nbsp;</td>
<%
										}
										else
										{
											if (present_measurevalue.length()<=28)
											{
												present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
										<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
											<%=present_measurevalue%>&nbsp;
										</td>
<%
											}
											else
											{
%>
										<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
<%
												ArrayList aListStrValues = breakString(present_measurevalue,28);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.print(str_value+"<br>");
												}
%>
										</td>
<%
											}
										}
									}
%>
								</tr>
<%
								}
							}
							else
							{
%>
								<tr>
<%
								if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
								{
%>
									<td width="20%" id="linebottomright">&nbsp;</td>
<%
								}

								boolean newMeasureFlag = false;
								boolean deletedMeasureFlag = false;
								if (!newInfoFlag)
								{
									if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
										previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
										previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
									{
										newMeasureFlag = true;
									}
									else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
									{
										deletedMeasureFlag = true;
									}
								}

								if (newMeasureFlag)
								{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%>&nbsp;<img src="/final/config/images/new_info.png" border="0"></td>
<%
								}
								else if (deletedMeasureFlag)
								{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%>&nbsp;<img src="/final/config/images/removed_info.png" border="0"></td>
<%
								}
								else
								{
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_measure%></td>
<%
								}

								String strDateTime = (String)arraylist_temp.get(0);
								String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
								String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
								String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

								/* Added by Prakash.K starts */
								timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
								startDateAndTime = (String)timeZoneConverter.getDateTime();
								/* Added by Prakash.K ends */
%>
									<td width="20%" nowrap id="linebottomright" valign="top" class="<%=fontStyle%>">
										<%=startDateAndTime%>
									</td>
<%
								if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
								{
									previous_measurevalue = "[N/PV]";
								}
								else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									previous_measurevalue = "[N/A]";
								}

								if (previous_measurevalue.length()<=28)
								{
									previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=previous_measurevalue%>&nbsp;</td>
<%
								}
								else
								{
%>
									<td width="20%" id="linebottomright" valign="top" class="<%=fontStyle%>">
<%
									ArrayList aListStrValues = breakString(previous_measurevalue,28);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.print(str_value+"<br>");
									}
%>
									</td>
<%
								}

								if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									present_measurevalue = "[N/A]";
								}

								if (present_measurevalue.length()<=28)
								{
									present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>"><%=present_measurevalue%>&nbsp;</td>
<%
								}
								else
								{
%>
									<td width="20%" id="linebottom" valign="top" class="<%=fontStyle%>">
<%
									ArrayList aListStrValues = breakString(present_measurevalue,28);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.print(str_value+"<br>");
									}
%>
									</td>
<%
								}
%>
								</tr>
<%
							}
						}
					}
				}
%>
							</table>
						</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table>
<%
			}
		}
		else
		{
			ArrayList aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

			if ((searchCompValue != null && !searchCompValue.equals("")) || 
				(searchTestValue != null && !searchTestValue.equals("")) || 
				(searchDescValue != null && !searchDescValue.equals("")))
			{
				aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,ec_component,searchCompValue,searchTestValue,searchDescValue,userLanguage);
			}
			else
			{
				aListChangesDatewise = processChangeData.getDatewiseChangeDataForComponent(aListChangesDatewise,ec_component,selectedDate,selectedHour);
			}

			if (requestHomePage)
			{
				//Code for restricting the data to the selected date
				aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,selectedHour);
			}

			int aListChangesDatewiseSize = aListChangesDatewise.size();
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable" class="body_text">
					<tr>
						<td>
							<table border="0" cellspacing="0" cellpadding="5" align="center" width="100%" class="body_text">
<%
			boolean heading_flag = false;
			for(int i=0; i<aListChangesDatewiseSize; i++)
			{
				ArrayList al = (ArrayList)aListChangesDatewise.get(i);
				if (!heading_flag)
				{
%>
								<tr>
									<td id="linebottomright" height="20" width="5%" style="padding-left:4px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Change Date" /></b>
									</td>
									<td id="linebottomright" height="20" width="15%" style="padding-left:4px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Information" /></b>
									</td>
									<td id="linebottomright" height="20" width="20%" style="padding-left:4px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Descriptor" /></b>
									</td>
									<td width="20%" id="linebottomright" style="padding-left:2px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Measure" /></b>
									</td>
									<td width="20%" id="linebottomright" style="padding-left:2px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Previous Value" /></b>
									</td>
									<td width="20%" id="linebottom" style="padding-left:2px" class="<%=fontStyle%>">
										<b><egui:intnl text="configmgmt.changes.detailed.Present Value" /></b>
									</td>
								</tr>
<%
					heading_flag = true;
				}

				String strDateTime = (String)al.get(0);
				String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
				String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
				String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

				/* Added by Prakash.K starts */
				timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
				startDateAndTime = (String)timeZoneConverter.getDateTime();
				/* Added by Prakash.K ends */

				String testname = (String)al.get(2);
				String info = (String)al.get(3);
				Object measure_obj = al.get(4);
				Object previous_obj = al.get(5);
				Object present_obj = al.get(6);

				String styleID = "linebottomright";
				String styleIDForPresent = "linebottom";
				if (i == aListChangesDatewiseSize-1)
				{
					styleID = "lineright";
					styleIDForPresent = "line";
				}
%>
								<tr>
									<td id="<%=styleID%>" valign="top" wrap width="5%" style="padding-left:4px" class="<%=fontStyle%>">
										<%=startDateAndTime%>
									</td>
									<td id="<%=styleID%>" valign="top" wrap width="15%" style="padding-left:4px" class="<%=fontStyle%>">
										<%=mappingInfo.getTestDescription(testname)%>
									</td>
<%
				boolean isDynamicMeasureTest = false;
				int idx_M = info.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;
				}

				ArrayList aListInfoHeadings = null;
				if (isDynamicMeasureTest)
				{
					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

				boolean newInfoFlag = false;
				if (measure_obj instanceof ArrayList)
				{
					newInfoFlag = true;
				}
%>
									<td width="20%" id="<%=styleID%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>">
<%
				if (!isDynamicMeasureTest)
				{
					info = ecUtils.getInfoForDisplay(info);
					if (!info.equals("+"))
					{
						if (info.length()<=29)
						{
							out.println(info);
						}
						else
						{
							ArrayList aListStrValues = breakString(info,29);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								out.println(str_value+"<br>");
							}
						}
					}
					else
					{
						out.println("");
					}
				}
				else
				{
					if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
					{
						out.println("");
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
						out.println(strData);
					}
				}

				if (newInfoFlag)
				{
%>
				<img src="/final/config/images/new_info.gif" border="0">
<%
				}
%>
									&nbsp;</td>
<%
				if (measure_obj instanceof String)
				{
					String previous_value = (String)previous_obj;
					String present_value = (String)present_obj;

					if(previous_value == null || previous_value.trim().length() == 0)
					{
						previous_value = "-";
					}
					if(present_value == null || present_value.trim().length() == 0)
					{
						present_value = "-";
					}

					if (EcUtils.isUTF8(previous_value.getBytes()))
					{
						previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
					}
					if (EcUtils.isUTF8(present_value.getBytes()))
					{
						present_value = EcUtils.printSkippedBomString(present_value.getBytes());
					}

					boolean newMeasureFlag = false;
					boolean deletedMeasureFlag = false;
					if (isDynamicMeasureTest && !newInfoFlag)
					{
						if (previous_value.equalsIgnoreCase("##NEW##") || 
							previous_value.equalsIgnoreCase("##NEW-INFO##") || 
							previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							newMeasureFlag = true;
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							deletedMeasureFlag = true;
						}
					}

					if (newMeasureFlag)
					{
%>
									<td width="20%" id="<%=styleID%>" valign="top" wrap style="padding-left:4px" class="<%=fontStyle%>"><%=measure_obj%><br><img src="/final/config/images/new_info.png" border="0"></td>
<%
					}
					else if (deletedMeasureFlag)
					{
%>
									<td width="20%" id="<%=styleID%>" valign="top" wrap style="padding-left:4px" class="<%=fontStyle%>"><%=measure_obj%><br><img src="/final/config/images/removed_info.png" border="0"></td>
<%
					}
					else
					{
%>
									<td width="20%" id="<%=styleID%>" valign="top" wrap style="padding-left:4px" class="<%=fontStyle%>"><%=measure_obj%></td>
<%
					}

					if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
					{
						previous_value = "[N/PV]";
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						previous_value = "[N/A]";
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (previous_value.length()<=29)
					{
						previous_value = EcUtils.replaceTags(previous_value);
%>
									<td width="20%" id="<%=styleID%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>"><%=previous_value%>&nbsp;</td>
<%
					}
					else
					{
%>
									<td width="20%" valign="top" id="<%=styleID%>" style="padding-left:4px" class="<%=fontStyle%>">
<%
						ArrayList aListStrValues = breakString(previous_value,24);
						for (int r=0;r<aListStrValues.size();r++)
						{
							String str_value = (String)aListStrValues.get(r);
							str_value = EcUtils.replaceTags(str_value);
							out.println(str_value+"<br>");
						}
%>
									</td>
<%
					}

					if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						present_value = "[N/A]";
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						present_value = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (present_value.length()<=29)
					{
						present_value = EcUtils.replaceTags(present_value);
%>
									<td width="20%" id="<%=styleIDForPresent%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>"><%=present_value%>&nbsp;</td>
<%
					}
					else
					{
%>
									<td width="20%" valign="top" id="<%=styleIDForPresent%>" style="padding-left:4px" class="<%=fontStyle%>">
<%
						ArrayList aListStrValues = breakString(present_value,24);
						for (int r=0;r<aListStrValues.size();r++)
						{
							String str_value = (String)aListStrValues.get(r);
							str_value = EcUtils.replaceTags(str_value);
							out.println(str_value+"<br>");
						}
%>
									</td>
<%
					}
				}
				else
				{
					ArrayList mn = (ArrayList)measure_obj;
					ArrayList prev = (ArrayList)previous_obj;
					ArrayList pres = (ArrayList)present_obj;
%>
									<td valign="top" width="60%" height="100%" style="padding:0px" colspan="3">
										<table border="0" cellspacing="0" cellpadding="3" height="100%" align="center" width="100%" class="body_text">
<%
					for (int z=0;z<mn.size();z++)
					{
						String measure = (String)mn.get(z);
						String prevValue = (String)prev.get(z);
						String presValue = (String)pres.get(z);

						if(prevValue == null || prevValue.trim().length() == 0)
						{
							prevValue = "-";
						}
						if(presValue == null || presValue.trim().length() == 0)
						{
							presValue = "-";
						}

						if (EcUtils.isUTF8(prevValue.getBytes()))
						{
							prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
						}
						if (EcUtils.isUTF8(presValue.getBytes()))
						{
							presValue = EcUtils.printSkippedBomString(presValue.getBytes());
						}

						String styleIDTemp = "linebottomright";
						String styleIDTempForPresent = "linebottom";
						if ((z == mn.size()-1) && (i == aListChangesDatewiseSize-1))
						{
							styleIDTemp = "lineright";
							styleIDTempForPresent = "line";
						}
%>
											<tr>
												<td width="33%" id="<%=styleIDTemp%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>"><%=measure%></td>
<%
						if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
						{
							prevValue = "[N/PV]";
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							prevValue = "[N/A]";
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (prevValue.length()<=29)
						{
							prevValue = EcUtils.replaceTags(prevValue);
%>
												<td width="33%" id="<%=styleIDTemp%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>"><%=prevValue%>&nbsp;</td>
<%
						}
						else
						{
%>
												<td width="33%" valign="top" id="<%=styleIDTemp%>" style="padding-left:4px" class="<%=fontStyle%>">
<%
							ArrayList aListStrValues = breakString(prevValue,24);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}
%>
												</td>
<%
						}

						if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							presValue = "[N/A]";
						}
						else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							presValue = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (presValue.length()<=29)
						{
							presValue = EcUtils.replaceTags(presValue);
%>
												<td width="33%" id="<%=styleIDTempForPresent%>" valign="top" style="padding-left:4px" class="<%=fontStyle%>"><%=presValue%>&nbsp;</td>
<%
						}
						else
						{
%>
												<td width="33%" valign="top" id="<%=styleIDTempForPresent%>" style="padding-left:4px" class="<%=fontStyle%>">
<%
							ArrayList aListStrValues = breakString(presValue,24);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}
%>
												</td>
<%
						}
%>
											</tr>
<%
					}
%>
										</table>
									</td>
<%
				}
%>
								</tr>
<%
			}
%>
							</table>
						</td>
					</tr>
				</table>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
		}
%>
			</td>
		</tr>
<%
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("Search"))
	{
		ArrayList aListSearchDetails = (ArrayList)session.getAttribute("SEARCH_DATA");
		ArrayList aListQueryDisplayValues = (ArrayList)session.getAttribute("INTNL_QUERIES");

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td>
<%
		if (aListSearchDetails != null)
		{
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" class="body_text">
					<tr>
						<td height="6"><img src="/final/config/images/spacer.gif" border="0" height="0"></td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" class="body_text">
					<tr>
						<td height="6"><img src="/final/config/images/spacer.gif" border="0" height="0"></td>
					</tr>
				</table>
<%
			for (int i=0; i<aListSearchDetails.size(); i++)
			{
				ArrayList aList = (ArrayList)aListSearchDetails.get(i);

				//String aListQuery = (String)aList.get(0);
				String aListQuery = (String)aListQueryDisplayValues.get(i);
				ArrayList aListColumnHeading = (ArrayList)aList.get(1);
				ArrayList aListData = (ArrayList)aList.get(2);

				int count = aListColumnHeading.size();

				String[] userOption = getValues(aListQuery,"|");
				String[] searchOption1 = getValues(userOption[0],":");
				List list = getParameters(userOption[1],"#");
				StringBuffer strBuffer = new StringBuffer();
				for (int y=0; y<list.size(); y++)
				{
					String tmpStr = (String)list.get(y);
					if (tmpStr.startsWith("Networkadapter=") && tmpStr.indexOf("@@@") > 0)
					{
						String strId = tmpStr.substring(tmpStr.indexOf("@@@")+3);
						tmpStr = tmpStr.substring(0,tmpStr.indexOf("@@@"));
						if (!strId.equals("-"))
						{
							tmpStr += " {"+strId+"}";
						}
					}
					strBuffer.append(tmpStr+", ");
				}
				String searchCondition = strBuffer.substring(0,strBuffer.length()-2);
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" style="border-bottom-width:0px" class="body_text">
					<tr>
						<td id="linebottom" height="24" colspan="<%=((count == 0)?"1":""+(count-1))%>" style="padding-left:6px;padding-top:2px;padding-bottom:2px;padding-right:2px"  class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.inventory.search.Search for"/>=<%=searchOption1[0]%>, <egui:intnl text="configmgmt.inventory.search.Search by"/>=<%=searchOption1[1]%>, <%=searchCondition%>
						</td>
					</tr>
					<tr><td><table border="0" width="100%" cellspacing="0" cellpadding="3" class="bottomtable" style="border-top-width:0px;border-bottom-width:0px;">

<%
				if (count == 0)
				{
%>
					<tr>
						<td align="center" id="linebottom" height="20" class="<%=fontStyle%>">
							<b><egui:intnl text="configmgmt.inventory.search.No result found for the current selection"/></b>
						</td>
					</tr>
<%
				}
				else
				{
					ArrayList a = (ArrayList)aListData.get(0);
					String strInfo = (String)a.get(0);
%>
					<tr>
<%
					for (int j=1; j<aListColumnHeading.size(); j++)
					{
						if (j == aListColumnHeading.size()-1)
						{
%>
						<td align="left" id="linebottom" height="20" class="<%=fontStyle%>">
<%
						}
						else
						{
%>
						<td align="left" id="linebottomright" height="20" class="<%=fontStyle%>">
<%
						}
%>
							&nbsp;<b><%=(String)aListColumnHeading.get(j)%></b>
						</td>
<%
					}
%>
					</tr>
<%
					boolean displayFlag = false;
					String oldInfo = "";

					for (int x=0; x<aListData.size(); x++)
					{
						ArrayList aListTemp = (ArrayList)aListData.get(x);
						String info = (String)aListTemp.get(0);
						String system = (String)aListTemp.get(1);
						String ip = (String)aListTemp.get(2);
						ArrayList aListValues = (ArrayList)aListTemp.get(3);

						if (!info.equals("+"))
						{
							if (!oldInfo.equalsIgnoreCase(info) && !oldInfo.equalsIgnoreCase(""))
								displayFlag = false;

							if (!displayFlag)
							{
								String strColHead = (String)aListColumnHeading.get(0);
								String tmpInfo = info;
								if (strColHead.equalsIgnoreCase("Network Adapter"))
								{
									if (tmpInfo.indexOf("@@@") > 0)
									{
										String tmpId = strInfo.substring(tmpInfo.indexOf("@@@")+3);
										tmpInfo = strInfo.substring(0,tmpInfo.indexOf("@@@"));
										if (!tmpId.equals("-"))
										{
											tmpInfo += " {"+tmpId+"}";
										}
									}
								}
%>
					<tr>
						<td align="left" id="linebottom" height="20" colspan="<%=count-1%>" class="<%=fontStyle%>">
							&nbsp;<b><%=(String)aListColumnHeading.get(0)%></b>: <%=tmpInfo%>
						</td>
					</tr>
<%
								displayFlag = true;
							}

							oldInfo = info;
						}
%>

					<tr>
						<td align="left" id="linebottomright" valign="top" height="20" wrap class="<%=fontStyle%>">&nbsp;<%=system%></td>
						
						<td align="left" id="linebottomright" height="20" valign="top" wrap class="<%=fontStyle%>">&nbsp;<%=ip%></td>

<%
						for (int k=0; k<aListValues.size(); k++)
						{
							String value = (String)aListValues.get(k);

							int m = value.indexOf('=');
							if (m != -1)
								value = value.substring(m+1,value.length());
					
							value = decodeString(value);

							/* Added by Prakash.K for TimeZone - Starts*/
							boolean isDate = DateUtil.validDate(value,currentDateFormat);
							if (isDate)
							{
								int idx_colon = value.indexOf(':');
								if (idx_colon != -1)
								{
									if (value.indexOf("AM") != -1 || value.indexOf("PM") != -1)
									{
										boolean isPM = (value.substring(value.lastIndexOf(" ")+1)).equalsIgnoreCase("PM");

										value = value.substring(0,value.lastIndexOf(" "));
										String timeDate = value.substring(0,value.lastIndexOf(" "));
										String timeVal  = value.substring(value.lastIndexOf(" ")+1);

										String timeHour = null;
										String timeMin = null;
										String timeSec = null;

										ArrayList aListTokens = StringUtils.egTokenizer(timeVal,":");
										if (aListTokens != null)
										{
											timeHour = (String)aListTokens.get(0);
											timeMin = (String)aListTokens.get(1);
											timeSec = (String)aListTokens.get(2);
										}

										if (isPM)
										{
											if (!timeHour.equals("12"))
											{
												int timeHourInt = Integer.parseInt(timeHour) + 12;
												timeHour = Integer.toString(timeHourInt);
											}
										}

										timeVal = timeHour + ":" + timeMin + ":" + timeSec;
										value = timeDate + " " + timeVal;
									}

									timeZoneConverter = new EgTimeZoneConverter(value,user);
									value = (String)timeZoneConverter.getDateTime();
								}
								//else
								//{
									//value = DateUtil.changeDateFormat(value,currentDateFormat,userDateFormat);
								//}
							}
							/* Added by Prakash.K for TimeZone - Ends*/

							if (k == aListValues.size()-1)
							{
%>
						<td align="left" id="linebottom" valign="top" height="20" wrap class="<%=fontStyle%>">&nbsp;
<%
							}
							else
							{
%>
						<td align="left" id="linebottomright" valign="top" height="20" wrap class="<%=fontStyle%>">&nbsp;
<%
							}

							if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								out.println(mappingInfo.getTextDescription("configmgmt.common.Yes"));
							}
							else
							{
								out.println(value);
							}
%>
						</td>
<%
						}
%>
					</tr>
<%
					}
				}
%>
				</table></td></tr>
				</table>

				<table>
					<tr>
						<td height="20"><img src="/final/config/images/spacer.gif" border="0" height="0"></td>
					</tr>
				</table>
<%
			}
		}
%>
			</td>
		</tr>
<%
	}
	else if(request.getParameter("selection_check")!=null && request.getParameter("selection_check").equalsIgnoreCase("System"))
	{
		String system = "";
		if(requestFrom != null && requestFrom.equals("Schedule"))
		{
			system = request.getParameter("systemName");
		}
		else
		{
			system = (String)session.getAttribute("systemName");
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
		else
		{
%>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="10">
			</td>
		</tr>
<%
		}

		if (system != null && system.length() > 0 && !system.equalsIgnoreCase("All"))
		{
%>
		<tr>
			<td align="center">
				<table align="center" width="99%" cellspacing="0" cellpadding="0" border="0" class="body_text">
					<tr>
						<td width="100%" nowrap align="center" height="24" class="<%=fontStyle%>">
							<!--<b><egui:intnl text="configmgmt.inventory.view.System" /></b> : <%=request.getParameter("ec_system")%>-->
							<b><egui:intnl text="configmgmt.inventory.view.System" /></b> : <%=system%>
						</td>
					</tr>
				</table>
			</td>
		<tr>
<%
		}
%>

		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="5">
			</td>
		</tr>
<%
		if(system!=null && system.length()>0)
		{
			if (system.equalsIgnoreCase("All"))
			{
				ArrayList aListTestnames = null;
				TreeMap testMeasureMapping = null;
				int measureCount = 0;
				TreeMap tmapSystemInformationDetails = null;
				if (requestFrom != null && requestFrom.equals("Schedule"))
				{
					aListTestnames = (ArrayList)request.getAttribute("Testnames");
					testMeasureMapping = (TreeMap)request.getAttribute("TestMeasureMap");
					measureCount = ((Integer)request.getAttribute("measureCount")).intValue();
					tmapSystemInformationDetails = (TreeMap)request.getAttribute("SystemInformationDetails");
				}
				else
				{
					aListTestnames = (ArrayList)session.getAttribute("Testnames");
					testMeasureMapping = (TreeMap)session.getAttribute("TestMeasureMap");
					measureCount = ((Integer)session.getAttribute("measureCount")).intValue();
					tmapSystemInformationDetails = (TreeMap)session.getAttribute("SystemInformationDetails");
				}
%>
		<tr>
			<td align="center">
				<table width="100%" align="center" cellspacing="0" cellpadding="2" border="0" class="body_text">
					<tr>
						<td colspan="<%=measureCount+1%>" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.System Information" /></b></td>
					</tr>
					<tr><td><table border="0" width="100%" cellspacing="0" cellpadding="5" class="bottomtable" style="border-bottom-width:0px;">

					<tr>
						<td height="20" id="linebottomright" style="text-align:center" valign="top" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.inventory.view.System" /><b></td>
<%
				int tempCount = 0;
				for (int k=0; k<aListTestnames.size(); k++)
				{
					String testname = (String)aListTestnames.get(k);
					ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
					for (int m=0; m<aListMeasures.size(); m++)
					{
						String measure = (String)aListMeasures.get(m);
						tempCount++;
						if (tempCount == measureCount)
						{
%>
						<td height="20" id="linebottom" style="text-align:center" valign="top" class="<%=fontStyle%>">
<%
						}
						else
						{
%>
						<td height="20" id="linebottomright" style="text-align:center" valign="top" class="<%=fontStyle%>">
<%
						}
%>
							<b><egui:intnl measure='<%=testname+":"+measure%>' /></b>
						</td>
<%
					}
				}
%>
					</tr>
<%
				Iterator system_keys = tmapSystemInformationDetails.keySet().iterator();
				while (system_keys.hasNext())
				{
%>
					<tr>
<%
					String key_system = (String)system_keys.next();
%>
						<td id="linebottomright" valign="top" class="<%=fontStyle%>"><%=key_system%></td>
<%
					tempCount = 0;
					TreeMap tmapTestDetails = (TreeMap)tmapSystemInformationDetails.get(key_system);
					for (int i=0; i<aListTestnames.size(); i++)
					{
						String testname = (String)aListTestnames.get(i);
						ArrayList aListMeasures = (ArrayList)testMeasureMapping.get(testname);
						TreeMap tmapMeasureDetails = (TreeMap)tmapTestDetails.get(testname);
						if (tmapMeasureDetails == null)
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								tempCount++;
								if (tempCount == measureCount)
								{
%>
						<td id="linebottom" style="text-align:center" valign="top">&nbsp;-&nbsp;</td>
<%
								}
								else
								{
%>
						<td id="linebottomright" style="text-align:center" valign="top">&nbsp;-&nbsp;</td>
<%
								}
							}
						}
						else
						{
							for (int j=0; j<aListMeasures.size(); j++)
							{
								String measure = (String)aListMeasures.get(j);
								ArrayList aListMeasureValue = (ArrayList)tmapMeasureDetails.get(measure);
								String measureValue = "-";
								if (aListMeasureValue != null)
								{
									if (testname.equalsIgnoreCase("DiskCapacity_cf") && measure.equalsIgnoreCase("Capacity"))
									{
										int i_size = aListMeasureValue.size()-1;
										measureValue = (String)aListMeasureValue.get(i_size);
									}
									else
									{
										measureValue = aListMeasureValue.toString();
										measureValue = measureValue.substring(1,measureValue.length()-1);
									}
								}
								tempCount++;
								if (tempCount == measureCount)
								{
%>
						<td id="linebottom" valign="top" class="<%=fontStyle%>"><%=measureValue%></td>
<%
								}
								else
								{
%>
						<td id="linebottomright" valign="top" class="<%=fontStyle%>"><%=measureValue%></td>
<%
								}
							}
						}
					}
%>
					</tr>
<%
				}
%>
				</table></td></tr>
				</table>
			</td>
		</tr>
<%
			}
			else
			{
				Map systemData = new TreeMap();
				Map commonInformation = new TreeMap();
				ArrayList systemDetailData = new ArrayList();
				if (requestFrom != null && requestFrom.equals("Schedule"))
				{
					systemDetailData = (ArrayList)request.getAttribute("SpecificData");
					commonInformation = (TreeMap)request.getAttribute("CommonData");
				}
				else
				{
					systemDetailData = (ArrayList)session.getAttribute("SpecificData");
					commonInformation = (TreeMap)session.getAttribute("CommonData");
				}
%>
		<tr>
			<td align="center" width="100%">
<%
				if (commonInformation!=null && commonInformation.size()>0)
				{
					ArrayList details=null;
					String serverName="";
					int count=0;
					String boxName=system+":NULL:Win_generic_server";
					ArrayList alist=new ArrayList();

					Iterator iterat = commonInformation.keySet().iterator();
					while(iterat.hasNext())
					{
						String svalue=(String)iterat.next();
						details=(ArrayList)commonInformation.get(svalue);
						if(details==null || details.size()==0)
							continue;
						alist.add(svalue);
					}
					details=new ArrayList();

					ArrayList comDetails=(ArrayList)commonInformation.get(boxName);
					if (comDetails==null)
					{
						boxName=system+":NULL:Generic_server";
						details=(ArrayList)commonInformation.get(boxName);
						if(details==null || details.size()==0)
						{
							if(alist!=null && alist.size()>0)
							{
								boxName=(String)alist.get(0);
								details=(ArrayList)commonInformation.get(boxName);
							}
						}
					}
					else
						details=comDetails;

					//commonInformation.remove(boxName);
					int loopCount=commonInformation.size();

					Iterator iteration = commonInformation.keySet().iterator();
					do
					{
						if(count==0)
						{
							serverName=boxName;
						}
						else
						{
							serverName=(String)iteration.next();
							details=(ArrayList)commonInformation.get(serverName);
						}

						if (details==null || details.size()==0)
							continue;

						ArrayList title= (ArrayList)details.get(0);
%>
				<table align="center" cellspacing="0" cellpadding="0"><tr><td><img src="/final/config/images/spacer.gif" height="10" border="0"></td></tr></table>

				<table width="100%" border="0" cellspacing="0" cellpadding="0" class="body_text">
					<tr>
						<td>
							<table width="99%" border="0" cellspacing="0" cellpadding="0" class="body_text" style="padding:0px 0px 2px 4px">

								<!-- <tr><td colspan="3" bgColor="white"><table cellspacing="0" cellpadding="0" border="0"><tr><td><img src="/final/config/images/spacer.gif" height="5"></td></tr></table></td></tr> -->

								<tr>
									<td width="20%" height="20" align="left" class="<%=fontStyle%>">
										&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Basic Configuration for" />&nbsp;<%=system%></b>
									</td>
									<td style="background-color:#ffffff" width="3%" align="left"><!-- <img src="/final/config/images/cell_corner_dark.gif"> --></td>
									<td align="left" style="background-color:#ffffff" width="50%">&nbsp;
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
						for(int m=1;m<details.size();m++)
						{
							if (m >= 2) continue;
							ArrayList testWiseInfo = (ArrayList)details.get(m); 

							ArrayList testName = (ArrayList)testWiseInfo.get(0);
							ArrayList flag= (ArrayList)testWiseInfo.get(1);
							ArrayList columnNames = (ArrayList)testWiseInfo.get(2);
							TreeMap data = (TreeMap)testWiseInfo.get(3);
			
							ArrayList flagRow = (ArrayList)flag.get(0);
							ArrayList flagColumn = (ArrayList)flag.get(1);

							int columnCount = columnNames.size();
%>
					<tr>
						<td align="center">
							<!-- <table cellspacing="0"  align="center"cellpadding="0" border="0"><tr><td colspan="2" height="3"><img src="/final/config/images/spacer.gif" height="5"></td></tr></table> -->
							
							<table width="99%" border="0" cellspacing="0" cellpadding="0" id="bottomtable" style="border-bottom-width:0px; border-right-width:0px">
<%
							if(count!=0)
							{
%>

								<tr>
									<td colspan="2" height="20" class="<%=fontStyle%>"><b>&nbsp;<%=testName.get(0)%></b></td>
								</tr>
<%
							}
%>
								<tr>
									<td width="100%" >
										<table border="0" width="100%" cellspacing="0" cellpadding="2" class="body_text">
<%
							Iterator iterate =data.keySet().iterator();
							boolean colHeading_flag = false;
							int f = 0;
							while(iterate.hasNext())
							{
								String info = (String)iterate.next();
								ArrayList infoDetails = (ArrayList)data.get(info);
								if (info.equals("+"))//Show row-wise data - Non-Info based - Don't show Descriptor
								{
%>
											<tr>
												<td width="100%" style="padding:0px">
													<table border="0" align="center" cellspacing="0" cellpadding="2" class="body_text" width="100%">
<%
									for(int x=1;x<columnCount;x++)
									{
										String flagValue = (String)flagColumn.get(x);
										if (flagValue.equals("true"))
										{
%>
														<tr>
															<td id="linebottomright" width="50%" height="20" class="<%=fontStyle%>">&nbsp;
																<%=(String)columnNames.get(x)%>
															</td>
															<td id="linebottomright" height="20" width="50%" class="<%=fontStyle%>">&nbsp;<%=infoDetails.get(x-1)%></td>
														</tr>
<%
										}
									}
%>
													</table>
												</td>
											</tr>
<%
								}
								else //Info-Based
								{
									if (columnCount <=5) //Column-wise
									{
										if (!colHeading_flag)
										{
%>
											<tr>
<%
											for(int n=0;n<columnCount;n++)
											{
												String flagValue = (String)flagColumn.get(n);
												if(flagValue!=null && flagValue.equals("true"))
												{
													if (columnCount == 2)
													{
%>
												<td id="linebottomright" width="50%" class="<%=fontStyle%>">
													<b><%=(String)columnNames.get(n)%></b>
												</td>
<%
													}
													else if (columnCount == 3)
													{
%>
												<td id="linebottomright" width="33%" class="<%=fontStyle%>">
													<b><%=(String)columnNames.get(n)%></b>
												</td>
<%
													}
													else if (columnCount == 4)
													{
%>
												<td id="linebottomright" width="25%" class="<%=fontStyle%>">
													<b><%=(String)columnNames.get(n)%></b>
												</td>
<%
													}
													else if (columnCount == 5)
													{
%>
												<td id="linebottomright" width="20%" class="<%=fontStyle%>">
													<b><%=(String)columnNames.get(n)%></b>
												</td>
<%
													}
												}
											}
%>
											</tr>
<%
											colHeading_flag = true;
										}

										String flagValue = (String)flagRow.get(f);
										if (flagValue.equals("true"))
										{
											if (info.indexOf('>') != -1) //Present... Tree form
												info = info.substring(info.lastIndexOf('>')+1);
%>
											<tr>
												<td id="linebottomright" class="<%=fontStyle%>"><%=info.trim()%></td>
<%
											for(int z=0;z<columnCount-1;z++)
											{
												String displayName= (String)flagColumn.get(z+1);
												if (displayName.equals("true"))
												{
													String value = (String)infoDetails.get(z);
													if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
													{
%>
												<td id="linebottomright" wrap class="<%=fontStyle%>"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
													}
													else
													{
%>
												<td id="linebottomright" wrap class="<%=fontStyle%>"><%=value%>&nbsp;</td>
<%
													}
												}
											}
										}
%>
											</tr>
<%
									}
									else
									{
										//Row-wise
										String flagValue = (String)flagRow.get(f);
										if (flagValue.equals("true"))
										{
											if (info.indexOf('>') != -1) //Present... Tree form
												info = info.substring(info.lastIndexOf('>')+1);
%>
											<tr>
												<td  height="20" colspan="2" id="linebottomright" class="<%=fontStyle%>">
													<b><%=info.trim()%></b>
												</td>
											</tr>

											<tr>
												<td width="100%" style="padding:0px">
													<table border="0" cellspacing="0" align="center" cellpadding="2" class="body_text" width="100%">
<%
											for(int p=1;p<columnCount;p++)
											{
												flagValue = (String)flagColumn.get(p);
												if (flagValue.equals("true"))
												{
%>
														<tr>
															<td id="linebottomright" width="50%" class="<%=fontStyle%>">
																<%=(String)columnNames.get(p)%>
															</td>
<%
													String value = (String)infoDetails.get(p-1);
													if (value.equalsIgnoreCase(EgConfigConstants.CF_YES))
													{
%>
															<td id="linebottomright" width="50%" class="<%=fontStyle%>"><egui:intnl text="configmgmt.common.Yes" />&nbsp;</td>
<%
													}
													else
													{
%>
															<td id="linebottomright" width="50%" class="<%=fontStyle%>"><%=value%>&nbsp;</td>
														</tr>
<%
													}
												}
											}
%>
													</table>
												</td>
											</tr>
<%
										}
									}
								}
								f++;
							}
%>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>

					<tr>
						<td colspan="2"><img src="/final/config/images/spacer.gif" height="5"></td>
					</tr>
<%
						}
%>
				</table>
<%
						count++;
					}
					while (false);
				}
%>
			</td>
		</tr>

		<tr><td height="10"><img src="/final/config/images/spacer.gif"  border="0"></td></tr>

		<tr>
			<td align="center">
				<table border="0" align="center" cellspacing="0" cellpadding="0" width="99%" class="body_text" id="bottomtable">
<%
				if (systemDetailData!= null && systemDetailData.size()>0)
				{
%>
					<tr>
						<td colspan="3" height="20" id="linebottom" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Components managed on" />&nbsp;<%=system%></b></td>
					</tr>
<%
					int count = systemDetailData.size();
					int j=0;
					if (count <=3)
					{
						count = 3;
					}
					else if(count % 3 != 0)
					{
						count = count+3 - count % 3;
					}

					for (j=0; (j<systemDetailData.size() || j < count); j++)
					{
						if (j%3 == 0)
						{
%>
					<tr>
<%
						}
						if ( j <systemDetailData.size())
						{
							String componentName=(String)systemDetailData.get(j);
							StringTokenizer st=new StringTokenizer(componentName,":");
							String subNickName=st.nextToken();
							String displayName="";
							String port=st.nextToken();
							if(componentName.endsWith("Oracle_server"))
								port+=":"+st.nextToken();
							String type=st.nextToken();

							//String port=cName.substring(cName.lastIndexOf(':')+1);
							if(!port.equalsIgnoreCase("NULL"))
								displayName=subNickName+":"+port;
							else
								displayName=subNickName;

							String compType = mappingInfo.getComponentTypeDescription(type);

							String strComp = displayName;

							if (j%3 == 2)
							{
%>
						<td width="30%" id="line" height="20" style="padding-left:4px;padding-right:4px" class="<%=fontStyle%>">
<%
							}
							else
							{
%>
						<td width="30%" id="lineright" height="20" style="padding-left:4px;padding-right:4px" class="<%=fontStyle%>">
<%
							}
%>
							<%=strComp%>
						</td>
<%
						}
						else
						{
							if (j%3 == 2)
							{
%>
						<td width="30%" height="20">&nbsp;</td>
<%
							}
							else
							{
%>
						<td width="30%" id="lineright" height="20">&nbsp;</td>
<%
							}
						}

						if (j%3 == 2)
						{
%>
					</tr>
<%
						}
					}
				}
%>
				</table>
			</td>
		</tr>
<%
			}
		}
	}   // end-if system information
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentType"))
	{
		String totalChanges = "";
		ArrayList aListChangedComponentTypes = null;
		ArrayList aListChangeCount = null;
		TreeMap tmapFinal = null;
		String startDateTime = "";
		String endDateTime = "";
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			totalChanges = (String)request.getAttribute("TOTAL_CHANGES");
			aListChangedComponentTypes = (ArrayList)request.getAttribute("CHANGED_COMPONENT_TYPES");
			aListChangeCount = (ArrayList)request.getAttribute("CHANGED_COMPONENT_TYPES_CHANGE_COUNT");
			tmapFinal = (TreeMap)request.getAttribute("CHANGED_COMPONENTS_UNDER_EACH_COMPONENT_TYPE");
			startDateTime = (String)request.getAttribute("START_DATETIME");
			endDateTime = (String)request.getAttribute("END_DATETIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */	
		}
		else
		{
			totalChanges = (String)session.getAttribute("TOTAL_CHANGES");
			aListChangedComponentTypes = (ArrayList)session.getAttribute("CHANGED_COMPONENT_TYPES");
			aListChangeCount = (ArrayList)session.getAttribute("CHANGED_COMPONENT_TYPES_CHANGE_COUNT");
			tmapFinal = (TreeMap)session.getAttribute("CHANGED_COMPONENTS_UNDER_EACH_COMPONENT_TYPE");
			startDateTime = (String)session.getAttribute("START_DATETIME");
			endDateTime = (String)session.getAttribute("END_DATETIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
		}
		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
		if (aListChangedComponentTypes != null && !aListChangedComponentTypes.isEmpty())
		{
%>

		<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>

		<tr>
			<td align="center">
				<table width="100%" class="body_text" cellspacing="0" cellpadding="2" border="0" style="border-bottom-width:0px">
					<tr>
						<td height="20" align="left" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Total Changes" />&nbsp;:&nbsp;<%=totalChanges%></b></td>
						<td height="20" align="right" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.summary.Between" /></b>&nbsp;<b><%=startDateTime%></b>&nbsp;<b><egui:intnl text="configmgmt.common.and" /></b>&nbsp;<b><%=endDateTime%></b>&nbsp;&nbsp;</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td align="center">
				<table width="100%" class="body_text" cellspacing="0" cellpadding="3" border="0" align="center" id="bottomtable" style="border-bottom-width:0px;table-layout:fixed">
					<tr>
						<td width="19%" id="linebottomright" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Type" /></b></td>
						<td width="8%" id="linebottomright" align="center" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.summary.Changes" /></b></td>
						<td width="73%" id="linebottom" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.summary.Changed components" /></b></td>
					</tr>
<%
			for (int g=0; g<aListChangedComponentTypes.size(); g++)
			{
				String componentType = (String)aListChangedComponentTypes.get(g);
				Integer changes = (Integer)aListChangeCount.get(g);
%>
					<tr>
						<td colspan="3" valign="top" style="padding:0px">
							<table cellspacing="0" cellpadding="4" align="center" border="0" width="100%" id="body_text">
								<tr>
									<td nowrap width="19%" id="linebottomright" valign="top" class="<%=fontStyle%>">&nbsp;<egui:intnl type="<%=componentType%>"/></td>
									<td width="8%" align="center" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=changes%></td>
									<td width="73%" align="left" valign="top" style="padding:0px">
										<table border="0" width="100%" cellspacing="0" cellpadding="4" class="body_text">
<%
				ArrayList aListChangedComponents = (ArrayList)tmapFinal.get(componentType);
				int size = aListChangedComponents.size();
				for (int d=size-1; d>=0; d=d-2)
				{
%>
											<tr>
<%
					for (int e=d; e>d-2; e--)
					{
						if (e >= 0)
						{
							String component = (String)aListChangedComponents.get(e);
							String componentName = component.substring(0,component.lastIndexOf(":"));
							String strCount = component.substring(component.indexOf("@")+1);
							if (componentName.endsWith(":NULL"))
							{
								componentName= componentName.substring(0,componentName.lastIndexOf(':'));
							}

							//String tmpStr = componentName;
							//int displayLength = 19;
							//String strCName = StringUtils.egSubString(tmpStr,displayLength);

							if (e == d-2+1)
							{
%>
												<td id="linebottom" width="50%" valign="top" class="<%=fontStyle%>">&nbsp;<%=componentName%> [<%=strCount%>]</td>
<%
							}
							else
							{
%>
												<td id="linebottomright" width="50%" valign="top" class="<%=fontStyle%>">&nbsp;<%=componentName%> [<%=strCount%>]</td>
<%
							}
						}
						else
						{
							if (e == d-2+1)
							{
%>
												<td id="linebottom" width="50%" valign="top">&nbsp;</td>
<%
							}
							else
							{
%>
												<td id="linebottomright" width="50%" valign="top">&nbsp;</td>
<%
							}
						}
					}
%>
											</tr>
<%
				}
%>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
			}
		}
		else
		{
%>
					<tr>
						<td align="center">
							<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
						</td>
					</tr>
					<tr>
						<td align="center">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
								<tr>
									<td width="100%" height="100%">
										<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
											<tr>
												<td align="center" height="100%">
													<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
														<tr>
															<td align="center">
																<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																	<tr>
																		<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																	</tr>
																	<tr>
																		<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.There were no configuration changes in the selected timeline")%></b></td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
		}
%>
				</table>
			</td>
		</tr>
<%
	}
	else if (ec_type!=null && ec_type.equalsIgnoreCase("ChangeSummaryForComponentName"))
	{
		String totalChanges = "";
		ArrayList aListChangeCount = null;
		TreeMap tmapTemp = null;
		TreeMap tmapChangedTestnames = null;
		String startDateTime = "";
		String endDateTime = "";
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			totalChanges = (String)request.getAttribute("TOTAL_CHANGES_COUNT");
			aListChangeCount = (ArrayList)request.getAttribute("CHANGED_COMPONENT_NAMES_CHANGE_COUNT");
			tmapTemp = (TreeMap)request.getAttribute("CHANGED_COMPONENT_NAMES");
			tmapChangedTestnames = (TreeMap)request.getAttribute("CHANGED_TESTNAMES_UNDER_EACH_COMPONENT_NAME");
			startDateTime = (String)request.getAttribute("START_DATE_TIME");
			endDateTime = (String)request.getAttribute("END_DATE_TIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */		
		}
		else
		{
			totalChanges = (String)session.getAttribute("TOTAL_CHANGES_COUNT");
			aListChangeCount = (ArrayList)session.getAttribute("CHANGED_COMPONENT_NAMES_CHANGE_COUNT");
			tmapTemp = (TreeMap)session.getAttribute("CHANGED_COMPONENT_NAMES");
			tmapChangedTestnames = (TreeMap)session.getAttribute("CHANGED_TESTNAMES_UNDER_EACH_COMPONENT_NAME");
			startDateTime = (String)session.getAttribute("START_DATE_TIME");
			endDateTime = (String)session.getAttribute("END_DATE_TIME");
			
			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(startDateTime,user);
			startDateTime = (String)timeZoneConverter.getDateTime();
			timeZoneConverter = new EgTimeZoneConverter(endDateTime,user);
			endDateTime = (String)timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
		if (aListChangeCount != null && !aListChangeCount.isEmpty())
		{
%>

		<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>

		<tr>
			<td align="center">
				<table width="100%" class="body_text" cellspacing="0" cellpadding="2" border="0" style="border-bottom-width:0px">
					<tr>
						<td height="20" align="left" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Total Changes" />&nbsp;:&nbsp;<%=totalChanges%></b></td>
						<td height="20" align="right" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.summary.Between" /></b>&nbsp;<b><%=startDateTime%></b>&nbsp;<b><egui:intnl text="configmgmt.common.and" /></b>&nbsp;<b><%=endDateTime%></b>&nbsp;&nbsp;</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td align="center">
				<table width="100%" class="body_text" cellspacing="0" cellpadding="5" border="0" align="center" id="bottomtable" style="border-bottom-width:0px;table-layout:fixed">
					<tr>
						<td width="32%" id="linebottomright" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Name" /></b></td>
						<td width="8%" id="linebottomright" align="center" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.summary.Changes" /></b></td>
						<td width="60%" id="linebottom" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.summary.Changes in" /></b></td>
					</tr>
<%
			for (int i=0; i<aListChangeCount.size(); i++)
			{
				Integer changeCount = (Integer)aListChangeCount.get(i);

				ArrayList aListComponentsTemp = (ArrayList)tmapTemp.get(changeCount);
				Collections.sort(aListComponentsTemp);

				for (int j=0; j<aListComponentsTemp.size(); j++)
				{
					String component = (String)aListComponentsTemp.get(j);

					String temp1 = component.substring(0,component.lastIndexOf(":"));
					if (temp1.endsWith(":NULL"))
						temp1 = temp1.substring(0,temp1.indexOf(":"));
					String temp2 = component.substring(component.lastIndexOf(":")+1);
					temp2 = mappingInfo.getComponentTypeDescription(temp2);
					temp1 = temp1 + ":"+ temp2;

					ArrayList aListTestnames = (ArrayList)tmapChangedTestnames.get(component);

					//String tmpStr = temp1;
					//int displayLength = 28;
					//String strCName = StringUtils.egSubString(tmpStr,displayLength);
%>
					<tr>
						<td colspan="3" valign="top" style="padding:0px">
							<table cellspacing="0" cellpadding="4" align="center" border="0" width="100%" id="body_text" style="table-layout:fixed">
							<col width="32%"><col width="8%"><col width="60%">
								<tr>
									<td wrap width="32%" id="linebottomright" valign="top" class="<%=fontStyle%>"><%=temp1%></td>
									<td  width="8%" align="center" id="linebottomright" valign="top" class="<%=fontStyle%>">&nbsp;&nbsp;<%=changeCount%></td>
									<td width="60%" align="left" valign="top" style="padding:0px" height="100%">
										<table border="0" width="100%" cellspacing="0" cellpadding="4" class="body_text" height="100%">
<%
					int size = aListTestnames.size();
					for (int d=0; d<size; d=d+3)
					{
%>
											<tr>
<%
						for (int e=d; e<d+3; e++)
						{
							if (e < size)
							{
								String testname = (String)aListTestnames.get(e);

								if (e == d+3-1)
								{
%>
												<td id="linebottom" width="33%" valign="top" height="100%" class="<%=fontStyle%>"><egui:intnl test="<%=testname%>" /></td>
<%
								}
								else
								{
%>
												<td id="linebottomright" width="33%" valign="top" height="100%" class="<%=fontStyle%>"><egui:intnl test="<%=testname%>" /></td>
<%
								}
							}
							else
							{
								if (e == d+3-1)
								{
%>
												<td id="linebottom" width="33%" valign="top" height="100%">&nbsp;</td>
<%
								}
								else
								{
%>
												<td id="linebottomright" width="33%" valign="top" height="100%">&nbsp;</td>
<%
								}
							}
						}
%>
											</tr>
<%
					}
%>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
				}
			}
%>
				</table>
			</td>
		</tr>
<%
		}
		else
		{
%>
		<tr>
			<td align="center">
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
			</td>
		</tr>
		<tr>
			<td align="center">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
					<tr>
						<td width="100%" height="100%">
							<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
								<tr>
									<td align="center" height="100%">
										<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
											<tr>
												<td align="center">
													<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
														<tr>
															<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
														</tr>
														<tr>
															<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.There were no configuration changes in the selected timeline")%></b></td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
		}
	}
	else if (ec_type != null && ec_type.equalsIgnoreCase("Consolidated_View"))
	{
		String componentType = "";
		String testName = "";
		ArrayList aListConsolidatedData = null;
		if (requestFrom != null && requestFrom.equalsIgnoreCase("Schedule"))
		{
			componentType = (String)request.getAttribute("componentType");
			testName = (String)request.getAttribute("testName");
			aListConsolidatedData = (ArrayList)request.getAttribute("ConsolidatedViewData");
		}
		else
		{
			componentType = (String)session.getAttribute("componentType");
			testName = (String)session.getAttribute("testName");
			aListConsolidatedData = (ArrayList)session.getAttribute("ConsolidatedViewData");
		}

		if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
		{
%>
								<tr>
									<td>
										<img src="/final/config/images/spacer.gif" border="0">
									</td>
								</tr>
								<tr>
									<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5">
				<img src="/final/config/images/spacer.gif" border="0" height="30">
			</td>
		</tr>
<%
		}
%>

		<tr>
			<td align="center">
				<table>
					<tr>
						<td height="5" id="blank">&nbsp;</td>
					</tr>
				</table>
				<table  width="100%" cellspacing="0" cellpadding="5" border="0" class="body_text">
					<tr>
						<td height="20" align="left" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.consolidated.Component Type" />&nbsp;:&nbsp;<%=mappingInfo.getComponentTypeDescription(componentType)%></b></td>
						<td height="20" align="right" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.consolidated.Report Type" />&nbsp;:&nbsp;<b><%=mappingInfo.getTestDescription(testName)%></b>&nbsp;&nbsp;</td>
					</tr>
				</table>
				<table>
					<tr>
						<td height="5" id="blank">&nbsp;</td>
					</tr>
				</table>
<%
		if (aListConsolidatedData != null && !aListConsolidatedData.isEmpty())
		{
			ArrayList aListDistinctDescriptors = (ArrayList)aListConsolidatedData.get(0);
			ArrayList aListAllMeasures = (ArrayList)aListConsolidatedData.get(1);
			TreeMap tmapData = (TreeMap)aListConsolidatedData.get(2);
			int idx_msize = aListAllMeasures.size();
%>
				<table border="0" align="center" width="100%" cellspacing="0" cellpadding="5" class="body_text">
					
<%
			int widthForACell = 100/idx_msize;
			String widthForACellStr = Integer.toString(widthForACell)+"%";
			for (int i=0;i<aListDistinctDescriptors.size();i++)
			{
				String strDescriptor = (String)aListDistinctDescriptors.get(i);
				ArrayList aListData = (ArrayList)tmapData.get(strDescriptor);
				int idx_dataSize = aListData.size();

				ArrayList aListInfoHeadings = null;
				boolean isDynamicMeasureTest = false;
				int idx_M = strDescriptor.indexOf("~M~");
				if (idx_M != -1)
				{
					isDynamicMeasureTest = true;

					aListInfoHeadings = new ArrayList();
					String infoHeadings = configtestsinfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testName);
					if (infoHeadings != null && infoHeadings.length() > 0)
					{
						StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
						while (strTokensTemp.hasMoreTokens())
						{
							String str_temp = strTokensTemp.nextToken();
							aListInfoHeadings.add(str_temp);
						}
					}
				}

				if (!strDescriptor.equals("+") && 
					!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) && 
					!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY))
				{
					if (!isDynamicMeasureTest)
					{
%>
								<tr>
									<td colspan="<%=idx_msize%>" style="font-weight:bold;padding:5px" class="<%=fontStyle%>"><%=ecUtils.getInfoForDisplay(strDescriptor)%></td>
								</tr>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(strDescriptor),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
							}
						}
%>
								<tr>
									<td colspan="<%=idx_msize%>" style="font-weight:bold;padding:5px" class="<%=fontStyle%>"><%=strData%></td>
								</tr>
<%
					}
				}
%>
								 <tr>
									<td width="100%">
										<table border="0" width="100%" cellspacing="0" cellpadding="5" class="bottomtable" style="border-bottom-width:0px;">
											<tr>
<%
				for (int j=0;j<idx_msize;j++)
				{
					if (j == idx_msize-1)
					{
%>
												<td id="linebottom" width=<%=widthForACellStr%> style="font-weight:bold;padding:5px" class="<%=fontStyle%>"><%=(String)aListAllMeasures.get(j)%></td>

<%
					}
					else
					{
%>
												<td id="linebottomright" width=<%=widthForACellStr%> style="font-weight:bold;padding:5px" class="<%=fontStyle%>"><%=(String)aListAllMeasures.get(j)%></td>
<%
					}
				}
%>
											</tr>
<%
				for (int m=0;m<idx_dataSize;m=m+idx_msize)
				{
%>
											<tr>
<%
					for (int n=m;n<m+idx_msize;n++)
					{
						String strData = (String)aListData.get(n);

						if(strData == null || strData.trim().length() == 0)
						{
							strData = "-";
						}

						if (strData.startsWith("<?configuration?>"))
						{
							strData = StringUtils.replace(strData,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
						}
						else
						{
							//removing BOM Character begin
							byte[] bytes = strData.getBytes(EcUtils.UTF8_ENCODING);
							if (EcUtils.isUTF8(bytes))
							{
								strData = EcUtils.printSkippedBomString(bytes);
							}
							//end

							strData = EcUtils.replaceTags(strData);
						}
						if (n == m+idx_msize-1)
						{
%>
												<td id="linebottom" class="<%=fontStyle%>"><%=strData%></td>
<%
						}
						else
						{
%>
												<td id="linebottomright" class="<%=fontStyle%>"><%=strData%></td>
<%
						}
					}
%>
											</tr>
<%
				}
%>
										</table>
									</td>
								</tr>
								<tr>
									<td height="15" id="blank" colspan="<%=idx_msize%>">&nbsp;</td>
								</tr>
<%
			}
%>
				</table>
<%
		}
%>
			</td>
		</tr>
<%
	}
%>
	</table>
</form>

</body>
</html>



