<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page errorPage= "EcProbs.jsp"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.config.ConfigDbSetting"%>
<%@ page import="egurkha.config.EcProcessData"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.eg.*" %>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenFields = new JSONObject();

	rootJson.put("success","true");


	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String userName = user.getLoginID();

	IniUI iniUI = IniUI.getInstance();
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String viewBy = "";
	Map data = (Hashtable)ConfigDbSetting.getDbSettingData(userName,EgConfigConstants.DASHBOARD_SETTING);
	if (data != null && !data.isEmpty())
	{
		viewBy = (String)data.get(EgConfigConstants.VIEW_BY);
	}

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String strViewBy = configTestsInfo.getServerDisplayValue("MISC_ARGS","ViewBy");

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (viewBy == null || viewBy.length() == 0)
	{
		if (strViewBy == null || strViewBy.length() == 0)
		{
			ec_criteria = "Component";
		}
		else if (ec_criteria == null)
		{
			ec_criteria = strViewBy; //INI value
		}
	}
	else
	{
		if (ec_criteria == null)
		{
			ec_criteria = viewBy; //DB value
		}
	}

	String ec_userOption = request.getParameter("ec_userOption");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserAssociatedComponents = new Vector(user.getServers(false));

	Vector vecUserOptions = null;
	ArrayList aListAssociatedComponents = new ArrayList();
	if (ec_criteria != null)
	{
		EgGroupInfo egGroupInfo = new EgGroupInfo();
		EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();

		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			ArrayList aListComponentsFromZone = new ArrayList();
			List zoneList = user.getZones();
			if (zoneList != null && !zoneList.isEmpty())
			{
				vecUserOptions = new Vector(zoneList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

				//To fetch all components from user associated zones
				for (int i=0;i<vecUserOptions.size();i++)
				{
					String strZone = (String)vecUserOptions.get(i);
					aListComponentsFromZone.addAll(egGroupInfo.getAllComponentsUnderZone(strZone,true));
				}
			}

			if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
			{
				boolean defaultZoneExists = false;
				for (int i=0;i<vecUserAssociatedComponents.size();i++)
				{
					String component = (String)vecUserAssociatedComponents.get(i);
					if (!aListComponentsFromZone.contains(component))
					{
						defaultZoneExists = true;
						break;
					}
				}
				if (defaultZoneExists)
				{
					vecUserOptions.add(0,"--Default--");
				}
			}
			else
			{
				if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
				{
					vecUserOptions = new Vector();
					vecUserOptions.add("--Default--");
				}
			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
				if (!ec_userOption.equalsIgnoreCase("--Default--"))
				{
					aListAssociatedComponents = egGroupInfo.getAllComponentsUnderZone(ec_userOption,true);
				}
				else
				{
					aListAssociatedComponents = new ArrayList();
					for (int i=0;i<vecUserAssociatedComponents.size();i++)
					{
						String userComponent = (String)vecUserAssociatedComponents.get(i);
						int index = aListComponentsFromZone.indexOf(userComponent);
						if (index == -1)
						{
							aListAssociatedComponents.add(userComponent);
						}
					}
				}
			}
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			List serviceList = new ArrayList();
			serviceList.addAll(user.getServices());
			ArrayList aListSites = new ArrayList();
			aListSites.addAll(user.getSites());
			aListSites.removeAll(serviceList);
			serviceList.addAll(aListSites);
			if (serviceList != null && !serviceList.isEmpty())
			{
				vecUserOptions = new Vector(serviceList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);
			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ec_userOption);
				if (vecServiceComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecServiceComponents);
				}
			}
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[2]))
		{
			List segmentList = user.getSegments();

			if (segmentList != null && !segmentList.isEmpty())
			{
				vecUserOptions = new Vector(segmentList);
				Collections.sort(vecUserOptions,String.CASE_INSENSITIVE_ORDER);

			}

			if (ec_userOption == null && vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				ec_userOption = (String)vecUserOptions.get(0);
			}

			if (ec_userOption != null)
			{
//				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ec_userOption,2,true);
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ec_userOption,2);
				if (vecSegmentComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecSegmentComponents);
				}
			}
		}
		else
		{
			aListAssociatedComponents = new ArrayList(vecUserAssociatedComponents);
		}
	}

	EcUtils ecUtils = new EcUtils();
	EcProcessData processData = new EcProcessData();
	processData.setUserObject(user);
	processData.setAssociatedComponents(aListAssociatedComponents);
	processData.getOSDetails();
	Vector osListTmp = processData.getAllOsName();
	Vector osList = new Vector();
	for(int n=0;n<osListTmp.size();n++)
	{
		String os=(String)osListTmp.get(n);
		if (os.equalsIgnoreCase("HP-UX") || 
			os.equalsIgnoreCase("AIX") || 
			os.equalsIgnoreCase("SunOs") || 
			os.equalsIgnoreCase("Unknown"))
		{
			continue;
		}
		osList.add(os);
	}

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String osNameSetting = (String)dashboardSetting.get(EgConfigConstants.SERVICE_STATUS_OS_NAME);
	String osName = "";
	if (osNameSetting != null && osNameSetting.length() > 0)
	{
		osName = osNameSetting;
	}
	else
	{
		if (osList.size() > 0)
		{
			osName = (String)osList.get(0);
		}
	}

	
	StringBuffer printQS = new StringBuffer();
	printQS.append("printType=Config Dashboard");
	printQS.append("&printPageTitle=CONFIGURATION_DASHBOARD_REPORT");
	printQS.append("&Page=Config_Dashboard");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+ec_userOption);
	printQS.append("&printData=yes");
	String s_qryString = "../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No";
	rootJson.put("printQueryStr",s_qryString);

	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ConfigurationDashboardReport");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");

	StringBuffer sch_printQS = new StringBuffer();
	sch_printQS.append("ec_rtype=Configuration_Dashboard");
	sch_printQS.append("&id=");
	sch_printQS.append("&userName="+userName);
	sch_printQS.append("&ec_criteria="+ec_criteria);
	sch_printQS.append("&ec_userOption="+ec_userOption);
	sch_printQS.append("&showWindow=yes");
	String sch_queryString = "/final/config/EcSaveScheduleNew.jsp?"+sch_printQS.toString();

	rootJson.put("schQueryStr",sch_queryString);

	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	rootJson.put("hiddenFields",hiddenFields);

	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();

	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				rootJson.put("selectedEcOpt",ec_criteria);
			}
			viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
			viewByObj.put("valueField",strCriteria);
			viewByArr.add(viewByObj);
		}
	}
	else
	{
		rootJson.put("selectedEcOpt","-1");
		viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
		viewByObj.put("valueField","-1");
		viewByArr.add(viewByObj);
	}
	rootJson.put("viewByList",viewByArr);

	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
		}
		else
		{
			rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
		}

		JSONObject specviewByObj = new JSONObject();
		JSONArray specviewByArr = new JSONArray();

		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					rootJson.put("selectedUserOption",ec_userOption);
				}
				specviewByObj.put("displayField",strUserOption);
				specviewByObj.put("valueField",strUserOption);
				specviewByArr.add(specviewByObj);
			}
		}
		else
		{
			rootJson.put("selectedUserOption","-1");
			specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.system.Not Applicable"));
			specviewByObj.put("valueField","-1");
			specviewByArr.add(specviewByObj);
		}
		rootJson.put("specViewByList",specviewByArr);
	}
	else
	{
	}

	if (aListAssociatedComponents == null || aListAssociatedComponents.isEmpty())
	{
		rootJson.put("hasRecords",false);
		if (ec_criteria.equalsIgnoreCase("Zone"))
		{
			rootJson.put("errorText",_mapping.getTextDescription("configmgmt.dashboard.No zones have been configured"));
		}
		else if (ec_criteria.equalsIgnoreCase("Service"))
		{
			rootJson.put("errorText",_mapping.getTextDescription("configmgmt.dashboard.No services have been configured"));
		}
		else if (ec_criteria.equalsIgnoreCase("Segment"))
		{
			rootJson.put("errorText",_mapping.getTextDescription("configmgmt.dashboard.No segment have been configured"));
		}
		else
		{
			rootJson.put("errorText",_mapping.getTextDescription("configmgmt.dashboard.No components have been managed"));
		}
	}
	else
	{
		rootJson.put("hasRecords",true);
	}

	if(queryString !=null)
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcDashboardIndex.jsp?"+queryString);
	}
	else
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcDashboardIndex.jsp?cmd=Home");
	}
	out.println(rootJson);

%>


 
 