<%
/*************************************************************************************************/
/*                 Name          : validateWebServiceURL.jsp                                     */
/*                 Purpose       : To validate WSDL url's configured for WebserviceTest          */
/*                 Version       : 5.7                                                           */
/*                 Created On    : 20-12-2012                                                    */
/*************************************************************************************************/
%>

<%@ include file = "EgTrackerA.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.SMClusterHelper"%>
<%@ page import = "com.eg.PMClusterHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgStateManager" %>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo" %>
<%@ page import="com.eg.EgServerList" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgLicenseInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgControlInfo"%>
<%@ page import = "com.eg.PollingServlet"%>
<%@ page import="com.eg.webservice.*"%>
<%@ page import="com.eg.XenMDMUrlTest"%>
<%@ page import = "com.eg.webservice.EgWebServiceBase"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	boolean isAgentRunningOnWindows = false;
	boolean agentReporting = true;
	boolean fileNotCreated = true;
	boolean isSNMPValidation=false;
	String test = request.getParameter("test");
	String selectedAgent=request.getParameter("selectedAgent");
	String validation=request.getParameter("validation");
	String action=request.getParameter("action");
	String taskName = request.getParameter("taskName");
	String valForValidation=request.getParameter("valForValidation");
	String compName=request.getParameter("compName");
	String componentType=request.getParameter("componentType");
	String configurationType=request.getParameter("configurationType");
	String allowHostName=request.getParameter("allowHostName");
	String multiUserMode=request.getParameter("multiUserMode");
	String isSNMP=request.getParameter("isSNMP");
	String oidTextObjValue=request.getParameter("oidTextObjValue");
	String fromPage=request.getParameter("fromPage");
	String selectedValue = request.getParameter("selectedValue");
	String credentialValue = request.getParameter("credentialValue");

	if(credentialValue!=null && !credentialValue.equals(""))
	{
		if(credentialValue.startsWith(","))
			credentialValue = credentialValue.substring(credentialValue.indexOf(",")+1);
	}

	String wsdlUrl = request.getParameter("wsdlUrl");
	String usernameXen = request.getParameter("xenMobileUserName");
	String passwordXen = request.getParameter("xenMobilePassword");
	boolean isWSDL=false;
	EgSpecsInfo spec = new EgSpecsInfo("manager");
	String egServer = spec.getEGServer();
	
	if(wsdlUrl!=null && !wsdlUrl.equals(""))
	{
		isWSDL = true;
	}
	if(fromPage!=null && fromPage.equals("descovery"))
	{
		fromPage="descovery";
	}
	else 
	{
		fromPage="testConfig";
	}

	boolean isXDMGetDevicesInfo = false;
	if (componentType != null && componentType.equalsIgnoreCase("XenMobileMDM"))
	{
		if (test != null && test.equalsIgnoreCase("WebServiceTest"))
		{
			isXDMGetDevicesInfo = false;
		}
		else
		{
			isXDMGetDevicesInfo = true;
		}
	}

	EgLicenseInfo licInfo = new EgLicenseInfo();
	EgServerList serverList = new EgServerList();
	List runningAgents = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	ArrayList allAgents=new ArrayList();
	ArrayList validationMsgs=new ArrayList();

	if(runningAgents!=null && !runningAgents.isEmpty())
		allAgents.addAll(runningAgents);

	if(agentsNotRunning!=null && !agentsNotRunning.isEmpty())
		allAgents.addAll(agentsNotRunning);

	//below condition checked to filter the agentsList for limited user

	EgUserRole userRoleObject = EgUserRole.getRoleObject(_user.getLoginType());
	if((userRoleObject!=null && !userRoleObject.hasAllComponentAccess()) && (allAgents!=null && !allAgents.isEmpty()))
	{
		//tells information about the corresponding authenticated user
		EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
		EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

		Vector allServersWithoutTypeForUser=ri.getAllServersWithoutType();
		ArrayList agentListForUser=new ArrayList();
		if(allServersWithoutTypeForUser!=null && !allServersWithoutTypeForUser.isEmpty())
		{
			Iterator itrServs=allServersWithoutTypeForUser.iterator();
			while(itrServs.hasNext())
			{
				String serv=(String)itrServs.next();
				String nick=serv.substring(0,serv.indexOf(":"));
				List agentList=egExternalInfo.getAgentsForHost(nick);
				agentListForUser.addAll(agentList);
			}		
		}
		ArrayList tempAgents=new ArrayList();
		Iterator itrAllAgents=allAgents.iterator();
		while(itrAllAgents.hasNext())
		{
			String agent=(String)itrAllAgents.next();
			if(agentListForUser!=null && agentListForUser.contains(agent))
				tempAgents.add(agent);
		}
		allAgents=tempAgents;
	}

	ArrayList totalAgents=serverList.getAgentList(allAgents);

	String sep = System.getProperty("file.separator");
	String agentID =compName;
	if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
	{
		agentID = agentID.substring(0,agentID.indexOf(":"));
	}
	if(selectedAgent!=null && (!selectedAgent.equals("") && !selectedAgent.equalsIgnoreCase("null")))
		agentID=selectedAgent;
	boolean isAgentInstalled=true;
	if(agentsNotRunning!=null && agentsNotRunning.contains(agentID))
		agentReporting=false;

	if(totalAgents!=null && !totalAgents.isEmpty())
	{
		int agentIdx=totalAgents.indexOf(agentID);
		String agentState=(String)totalAgents.get(agentIdx+1);
		if(agentState!=null && agentState.equalsIgnoreCase("Not Installed-Not Running"))
		{
			isAgentInstalled=false;
		}
	}

	IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	String defaultValidationFieldsForComponent=egTestParamIni.getValue("VALIDATIONS_FIELDS",componentType+":Default");
	String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",test);
	if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
	{
		defaultValidationFieldsForComponent=defaultValidationFieldsForComponent+","+specificValidationFieldsForTest;
	}
	StringBuffer sbreqValsForValidation=new StringBuffer(256);
	ArrayList defaultValidationFieldList=new ArrayList();
	if(defaultValidationFieldsForComponent!=null && !defaultValidationFieldsForComponent.equals(""))
	{
		StringTokenizer stkvFields=new StringTokenizer(defaultValidationFieldsForComponent,",");
		while(stkvFields.hasMoreTokens())
		{
			String fieldName=stkvFields.nextToken();
			fieldName=fieldName.toLowerCase();
			sbreqValsForValidation.append(fieldName+",");
			defaultValidationFieldList.add(fieldName);
		}
	}
	String requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
	if(requiredParamNames!=null && requiredParamNames.endsWith(","))
		requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));
	String validationURL="/final/admin/validateWebServiceURL.jsp";
	String paramsForURL="&test="+test+"&validation="+validation+"&taskName="+taskName+"&compName="+compName+"&action=validate&componentType="+componentType+"&isSNMP="+isSNMP;
	ArrayList allExternalAndRemoteAgents=new ArrayList();
	ArrayList externalAgents=licInfo.getExternalAgents();
	ArrayList remoteAgents=licInfo.getRemoteAgents();
	if(externalAgents!=null && !externalAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(externalAgents);
	if(remoteAgents!=null && !remoteAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(remoteAgents);
	Vector finalAgents=new Vector();
	if(totalAgents!=null && totalAgents.size()>0)
	{
		for(int s=0;s<totalAgents.size();s=s+4)
		{
			String agentIPAdd=(String)totalAgents.get(s);
			if((agentIPAdd!=null && !agentIPAdd.equalsIgnoreCase(agentID)) && (allExternalAndRemoteAgents!=null && !allExternalAndRemoteAgents.contains(agentIPAdd)))
					continue;
			String agentState=(String)totalAgents.get(s+1);
			if(agentState!=null && agentState.equalsIgnoreCase("installed-running"))
			{
				finalAgents.add(agentIPAdd);
			}
		}
	}
	boolean isAgentsAvailable=true;
	boolean singleEntry=false;
	int index=0;
	if(finalAgents!=null)
	{
		if(finalAgents.isEmpty())
		{
			isAgentsAvailable=false;
		}
		else if(finalAgents.size()==1)
		{
			singleEntry=true;
			index=1;
		}
	}
	if(action!=null && action.equals("pickAgentToValidate"))
	{
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" height="150" border="0">
	<tr>
		<td id="inner_top_left" align="center" valign="middle">
			<table border="0" cellspacing="0" cellpadding="0">
<%
			String defaultAgentMsg="";
			if(isAgentsAvailable)
			{
				defaultAgentMsg="Please choose agent or manager and press go button to start validation";
%>
				<tr>
					<td align="left">
						<table border="0" cellspacing="0" cellpadding="4" width="100%">
							<tr>
								<td>
									<egui:intnl text="admin.common.Please choose an agent or manager for validation"/>
								</td>
								<td>:</td>
								<td align="left">
									<select id="agentListObj" style="width:120px">
										<option value="-1"><egui:intnl text="admin.common.Please choose an agent or manager"/></option>
<%
									String optionValue = "eG Manager-"+egServer;
%>									<option value="EgManager"><%=optionValue%></option>
<%									for(int t=index;t<finalAgents.size();t=t+1)
									{
										String s=(String)finalAgents.get(t);
										String selected="";
										if(s!=null && s.equalsIgnoreCase(agentID))
										{
											//selected="selected";
%>											<option value="<%=s%>"><%=s%></option>
<%										}
									}
%>
									</select>
								</td>

<%								paramsForURL=paramsForURL+
												"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
%>
								<td><input type="button" value="Go" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>','<%=fromPage%>',event);"> </td>

							</tr>
						</table>
					</td>
				</tr>
<%
			}
			else
			{
				
				paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
				String optionValue = "eG Manager-"+egServer;
				defaultAgentMsg="No agents available to validate";
%>
				<tr>
					<td align="left">
						<table border="0" cellspacing="0" cellpadding="4" width="100%">
							<tr>
								<td><egui:intnl text="admin.common.Please choose Manager for validation"/></td>
								<td>:</td>
								<td align="left">
									<select id="mgrListObj" style="width:120px">
										<option value="EgManager" selected ><%=optionValue%></option>
									</select>
								</td>
								<td>
								<input type="button" value="Go" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>','<%=fromPage%>',event);">
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%				
			}
			if(defaultAgentMsg.length()>0){
%>
				<tr>
					<td id="inner_top_left" align="center" valign="middle" class="eg_darktextbold">
						<br>
						<br>
						<center><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"></center><br><egui:intnl text='<%="admin.common."+defaultAgentMsg%>'/><br><br>
					</td>
				</tr>
<%			}
%>
			</table>
		</td>
	</tr>
</table>

<%
	}
	else if(action!=null && action.equals("validate"))
	{	
		boolean fromMgr = false;
		boolean fromAgent=false;
		if(isWSDL && selectedValue!=null && !selectedValue.equals(""))
		{
			if(selectedValue.indexOf("EgManager")>-1)
				fromMgr = true;
			else
				fromAgent = true;
		}

		if(!fromMgr){
		if (isXDMGetDevicesInfo)
		{
			if (wsdlUrl.indexOf("XenMobileMDM") == -1)
			{
				wsdlUrl = componentType+":"+wsdlUrl;
			}
		}
		String filePath = EgInstallInfo.getInstallDir()+sep+"tmp"+sep+agentID+"_"+session.getId()+"."+taskName;
		File f = new File(filePath);
		if(f != null && f.exists())
			f.delete();
		if(isAgentInstalled && agentReporting)
		{

			boolean controlModeCheckNeeded = true;
			IniFile controlsDotIni_1 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
			String idlePeriod = controlsDotIni_1.getValue("CONTROL_DEFAULTS","IdlePeriod");
			if(StringUtils.isNull(idlePeriod))
			{
				idlePeriod="300";//seconds
			}
			long idlePeriodMS = Integer.parseInt(idlePeriod) * 1000;
			String variables[] = controlsDotIni_1.getVariables("CURRENT_CONTROLS");
			if(variables != null && variables.length>0)
			{
				ArrayList controlModeComponents = new ArrayList(java.util.Arrays.asList(variables));
				if(controlModeComponents.contains(agentID))
				{
					for(int i=0;i<controlModeComponents.size();i++)
					{
						String tmp_agentID = (String) controlModeComponents.get(i);
						if(tmp_agentID.equals(agentID))
						{
							String tmp_agentID_value = controlsDotIni_1.getValue("CURRENT_CONTROLS",agentID);
							if(!StringUtils.isNull(tmp_agentID_value) && tmp_agentID_value.equals("false"))
							{
								controlModeCheckNeeded = false;
								break;
							}
						}
					}
				}
			}
			if(controlModeCheckNeeded)
			{
				controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
			}
			controlsDotIni_1.saveFile();
			String val = "";
			IniFile controlsDotIni_3 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
			String timeout = controlsDotIni_3.getValue("CONTROL_DEFAULTS","TimeOut");
			if(valForValidation!=null && valForValidation.endsWith("|#|"))
				valForValidation=valForValidation.substring(0,(valForValidation.length()-3));
			
			Vector ipVec = null;
			boolean checkIni = false;
			String key="none";
			if(PollingServlet.agentID != null && PollingServlet.agentID.size() > 0)
			{
				EgControlInfo ctrlInfo = new EgControlInfo("manager");
				Enumeration e = PollingServlet.agentID.keys();
				//Get the valid IPSTR for this agent IP
				while(e.hasMoreElements())
				{
					String ip = (String) e.nextElement();
					ArrayList ipAddrs=ctrlInfo.getAllNamesOf(ip);
					if(ipAddrs!=null && !ipAddrs.isEmpty())
					{
						ipVec=new Vector();
						ipVec.addAll(ipAddrs);
					}

					if(ipVec!=null && ipVec.contains(agentID))
					{
						checkIni = true;
						break;
					}
				}
				if(checkIni)
				{
					IniFile controlsIni = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini");
					String ipArr[] = controlsIni.getVariables("CURRENT_CONTROLS");
					if(ipArr != null)
					{
						for(int i=0;i<ipArr.length;i++)
						{
							if(ipVec.contains(ipArr[i]) )
							{
								String flag = controlsIni.getValue("CURRENT_CONTROLS",ipArr[i]);
								if(flag != null )
								{
									if(flag.equals("false"))
									{
										key="control";
										break;
									}
									else if(flag.equals("true"))
									{
										key="waiting";
									}
									else
									{
										key="normal";
									}
								}
							}
						}
					}
					else
					{
						key="normal";
					}
				}
			}
			IniFile controlsIniWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini");
			if(key.equalsIgnoreCase("control"))
			{
				controlsIniWr.setValue("CURRENT_CONTROLS",agentID,"false");
			}
			else
			{
				controlsIniWr.setValue("CURRENT_CONTROLS",agentID,"true");
			}
			controlsIniWr.saveFile();
			EgConfigFilesSync.releaseInstance(controlsIniWr);

			boolean idleBreak = false;
			if(controlModeCheckNeeded)
			{
				long startTime = System.currentTimeMillis();
				long elapsedTime = 0;
				while(true)
				{
					IniFile controlsDotIni_2 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini");
					String temp = controlsDotIni_2.getValue("CURRENT_CONTROLS",agentID);
					if(elapsedTime>=idlePeriodMS || StringUtils.isNull(temp))
					{
						idleBreak = true;
						break;
					}
					else if(temp.equals("false"))
					{
						break;
					}
					Thread.sleep(5000);
					elapsedTime =  System.currentTimeMillis() - startTime;
				}
			}
			
			String iniFileName = EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini";
			IniFile controlsDotIni_4  = EgConfigFilesSync.getInstance(iniFileName,true);
			if(!idleBreak)
			{
				wsdlUrl = wsdlUrl.trim();
				controlsDotIni_4.setValue(agentID,taskName+":"+session.getId(),EgURLEncoder.encode(wsdlUrl,"UTF-8")+"|#|"+EgURLEncoder.encode(credentialValue,"UTF-8"));
			}
			controlsDotIni_4.saveFile();
			EgConfigFilesSync.releaseInstance(controlsDotIni_4);
		

			long timeLapse=0;
			long totSleepTime=0;
			long sleepTime=1000;
			timeout = (timeout != null && !timeout.equals(""))? timeout : "60";
			if(timeout == null || timeout.equals(""))
			{
				totSleepTime = 10000;
			}
			else
			{
				try
				{
					totSleepTime = Long.parseLong(timeout)*1000;
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
			while(true)
			{
				//f = new File(filePath);
				if(f != null && f.exists())
				{
					fileNotCreated = false;
					BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f),"UTF-8"));
					String line = null;
					while((line=br.readLine()) != null)
					{
						validationMsgs.add(line);
					}
					br.close();
					f.delete();
					Thread.currentThread().sleep(100);
					break;
				}
				else
				{
					if(timeLapse < totSleepTime)
					{
						timeLapse += sleepTime;
						Thread.currentThread().sleep(sleepTime);
					}
					else
					{
						//Agent is not responding
						agentReporting = false;
						break;
					}
				}
			}
		}

		if(!agentReporting || fileNotCreated || !isAgentInstalled)
		{
			String defaultMsg="";
			if(!agentReporting || fileNotCreated)
				defaultMsg="Failed to get required validation information from agent";
			else if(!isAgentInstalled)
				defaultMsg="Agent not installed or not running";
			if(isAgentsAvailable)
			{
%>
	<table align="center" cellspacing="0" cellpadding="0" width="100%" height="150" border="0">
		<tr>
			<td id="inner_top_left" align="center" valign="middle">
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td>
							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr>
									<td nowrap>
										<egui:intnl text="admin.common.Please choose an agent or manager for validation"/>&nbsp;:
									</td>
									<td>
										&nbsp;
									</td>
									<td>
										<select id="agentListObj" style="width:120px">
											<option value="-1"><egui:intnl text="admin.common.Please choose an agent or manager"/></option>
<%
										String optionValue = "eG Manager-"+egServer;
%>										<option value="EgManager"><%=optionValue%></option>
<%										for(int t=index;t<finalAgents.size();t=t+1)
										{
											String s=(String)finalAgents.get(t);
											String selected="";
											if(s!=null && s.equalsIgnoreCase(agentID))
											{
												selected="selected";
%>											<option value="<%=s%>" <%=selected%>><%=s%></option>
<%											}
										}
%>
										</select>
									</td>
<%
									paramsForURL=paramsForURL+
												"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
									
%>
									<td>
										<input type="button" value="Go" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>','<%=fromPage%>',event);">
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
			}
			else
			{
				paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8");
				String optionValue = "eG Manager-"+egServer;
				defaultMsg="No agents available to validate";
%>
					<tr>
						<td align="left">
							<table border="0" cellspacing="0" cellpadding="4" width="100%">
								<tr>
									<td><egui:intnl text="admin.common.Please choose Manager for validation"/></td>
									<td>:</td>
									<td align="left">
										<select id="mgrListObj" style="width:120px">
											<option value="EgManager" selected ><%=optionValue%></option>
										</select>
									</td>
									<td>
									<input type="button" value="Go" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>','<%=fromPage%>',event);">
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%				
			}
%>
					<tr>
						<td id="inner_top_left" align="center" valign="middle" class="eg_darktextbold">
							<br>
							<br>
							<center><img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"></center><br><egui:intnl text='<%="admin.common."+defaultMsg%>'/><br><br>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
<%
		}
		else
		{
			if(validationMsgs!=null && !validationMsgs.isEmpty())
			{
				if(f != null && f.exists())
					f.delete();
%>
				<table id="cell_border1" border="0" cellspacing="0" cellpadding="2" width="100%">
					<col width="7%"><col width="40%"><col width="60%"><col width="40%">
					<thead>
						<tr>
							<th id="cell_border3" valign="middle">&nbsp;</th>
<%
				if (!isXDMGetDevicesInfo)
				{
%>
							<th id="cell_border3" class="space3 eg_darktextbold" valign="middle"><egui:intnl text="admin.common.Name"/></th>
<%
				}
%>
							<th id="cell_border3" class="space3 eg_darktextbold" valign="middle"><egui:intnl text="admin.common.WSDL URL"/></th>
							<th id="cell_border3" valign="middle" class="space3 eg_darktextbold"><egui:intnl text="admin.common.Results"/></th>
						</tr>
					</thead>
					<tbody>
<%
					boolean resVForAgent = false;
					String validUserName = "";
					String validPassword = "";
					String validFlag = "User credentials";
					StringTokenizer strToken=null;
					if(wsdlUrl.indexOf(",")>-1)
						strToken = new StringTokenizer(wsdlUrl,",");
					else if(wsdlUrl.indexOf("|")>-1)
						strToken = new StringTokenizer(wsdlUrl,"|");
					else
						strToken = new StringTokenizer(wsdlUrl,"");
					while(strToken.hasMoreTokens())
					{
						String token = (String)strToken.nextToken();
						String pattern = null;
						String urlOnly;
						if (isXDMGetDevicesInfo)
						{
							urlOnly = token;
							if(usernameXen !=null && usernameXen.length()!=0)
							{
								validUserName=usernameXen;
								validPassword= passwordXen;
							}
							urlOnly = urlOnly.substring(urlOnly.indexOf(":")+1);
							resVForAgent = XenMDMUrlTest.urlTest(urlOnly, validUserName, validPassword);
						}
						else
						{
							pattern = token.substring(0,token.indexOf(":"));
							urlOnly = token.substring(token.indexOf(":")+1);
						}
						if(validationMsgs.contains(token))
						{
%>
							<tr>
								<td id="cell_border4" valign="middle"><div class="tick"></div></td>
<%
							if (!isXDMGetDevicesInfo)
							{
%>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=pattern%></td>
<%
							}
%>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=urlOnly%></td>
								<td id="cell_border4" class="space3" valign="middle">
									&nbsp;<egui:intnl text="admin.common.Valid"/>&nbsp;
								</td>
							</tr>
<%
							if (isXDMGetDevicesInfo)
							{
								if (resVForAgent)
								{
%>
								<tr>
								<td id="cell_border4" valign="middle"><div class="tick"></div></td>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=validFlag%></td>
								<td id="cell_border4" class="space3" valign="middle">
										&nbsp;<egui:intnl text="admin.common.Valid"/>&nbsp;
									</td>
								</tr>
<%
								}
								else
								{
%>
									<td id="cell_border4" valign="middle"><div class="fault"></div></td>
									<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=validFlag%></td>
									<td id="cell_border4" class="space3" valign="middle">
													&nbsp;<egui:intnl text="admin.common.InValid"/>&nbsp;
												</td>
<%
								}
							}
						}
						else
						{
%>
							<tr>
								<td id="cell_border4" valign="middle"><div class="fault"></div></td>
<%
							if (!isXDMGetDevicesInfo)
							{
%>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=pattern%></td>
<%
							}
							if(resVForAgent )
							{
%>
								<tr>
								<td id="cell_border4" valign="middle"><div class="tick"></div></td>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=validFlag%></td>
								<td id="cell_border4" class="space3" valign="middle">
										&nbsp;<egui:intnl text="admin.common.Valid"/>&nbsp;
									</td>
								</tr>
<%
							}
							else
							{
%>
									<td id="cell_border4" valign="middle"><div class="fault"></div></td>
									<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=validFlag%></td>
									<td id="cell_border4" class="space3" valign="middle">
										&nbsp;<egui:intnl text="admin.common.InValid"/>&nbsp;
									</td>
								</tr>
<%
							}
						}
					}
%>
						</tbody>
					</table>
<%
					paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8")+"&selectedValue="+selectedValue+"&credentialValue="+credentialValue;
%>
					<table align="center">
						<tr>
							<td>
								<input type="button" value="Retry" style="width:60px;" class="eg_back" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>',
								'<%=fromPage%>',event);">
							</td>
						</tr>
					</table>
<%
			}
			else
			{
%>
					<table id="cell_border1" border="0" cellspacing="0" cellpadding="2" width="100%">
						<col width="7%"><col width="40%"><col width="60%"><col width="40%">
						<thead>
							<tr>
								<th id="cell_border3" valign="middle">&nbsp;</th>
<%
				if (!isXDMGetDevicesInfo)
				{
%>
								<th id="cell_border3" class="space3 eg_darktextbold" valign="middle"><egui:intnl text="admin.common.Name"/></th>
<%
				}
%>
								<th id="cell_border3" class="space3 eg_darktextbold" valign="middle" ><egui:intnl text="admin.common.WSDL URL"/></th>
								<th id="cell_border3" valign="middle" class="space3 eg_darktextbold"><egui:intnl text="admin.common.Results"/></th>
							</tr>
						</thead>
						<tbody>
<%
						StringTokenizer strToken=null;
						if(wsdlUrl.indexOf(",")>-1)
							strToken = new StringTokenizer(wsdlUrl,",");
						else if(wsdlUrl.indexOf("|")>-1)
							strToken = new StringTokenizer(wsdlUrl,"|");
						else
							strToken = new StringTokenizer(wsdlUrl,"");
						while(strToken.hasMoreTokens())
						{
							String token = (String)strToken.nextToken();
							String urlOnly = null;
							String pattern = null;
							if (!isXDMGetDevicesInfo)
							{
								pattern = token.substring(0,token.indexOf(":"));
								urlOnly = token.substring(token.indexOf(":")+1);
							}
							else
							{
								 urlOnly = token.substring(token.indexOf(":")+1);
								
							}
%>
							<tr>
								<td id="cell_border4" valign="middle"><div class="fault"></div></td>
<%
							if (!isXDMGetDevicesInfo)
							{
%>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=pattern%></td>
<%
							}
%>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=urlOnly%></td>
								<td id="cell_border4" class="space3" valign="middle">&nbsp;<egui:intnl text="admin.common.Invalid"/>&nbsp;
								</td>
							</tr>
<%
							String xenStr = "User credentials";
							String strRes = "-";
							if (isXDMGetDevicesInfo)
							{
%>
								<tr>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=xenStr%></td>
								<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=strRes%></td>
								<td id="cell_border4" class="space3" valign="middle">&nbsp;<egui:intnl text="admin.common.Invalid"/>&nbsp;
								</td>
							</tr>
<%
							}
						}
%>
						</tbody>
					</table>
<%
					paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8")+"&selectedValue="+selectedValue+"&credentialValue="+credentialValue;
%>
					<table align="center">
						<tr>
							<td>
								<input type="button" value="Retry" style="width:60px;" class="eg_back" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>',				'<%=fromPage%>',event);">
							</td>
						</tr>
					</table>
<%
			}
		}
	}
	else if(fromMgr)
	{
			ArrayList operations = null;
			HashMap services=null;
			ArrayList wdslList = new ArrayList();
			ArrayList credentialList = new ArrayList();
		
			if(credentialValue!=null && !credentialValue.equals(""))
			{
				StringTokenizer credenTok = new StringTokenizer(credentialValue,",");
				while(credenTok.hasMoreTokens())
				{
					String credentialToken = (String)credenTok.nextToken();
					credentialList.add(credentialToken);
				}
			}

			StringTokenizer strTok=null;
			if(wsdlUrl.indexOf(",")>-1)
				strTok = new StringTokenizer(wsdlUrl,",");
			else if(wsdlUrl.indexOf("|")>-1)
				strTok = new StringTokenizer(wsdlUrl,"|");
			else
				strTok = new StringTokenizer(wsdlUrl,"");
			
			int count = strTok.countTokens();

%>			<table id="cell_border1" border="0" cellspacing="0" cellpadding="2" width="100%">
				 <col width="7%"><col width="40%"><col width="60%"><col width="40%"> 
				<thead>
					<tr>
						<th id="cell_border3" valign="middle">&nbsp;</th>
<%
			if(!isXDMGetDevicesInfo)
			{
%>
						<th id="cell_border3" class="space3 eg_darktextbold" valign="middle"><egui:intnl text="admin.common.Name"/></th>
<%
			}
%>
						<th id="cell_border3" class="space3 eg_darktextbold" valign="middle" ><egui:intnl text="admin.common.WSDL URL"/></th>
						<th id="cell_border3" valign="middle" class="space3 eg_darktextbold"><egui:intnl text="admin.common.Results"/></th>
					</tr>
				</thead>
				<tbody>
<%
	
			int cnt = 0;
			String username="";
			String password="";

			while(strTok.hasMoreTokens())
			{
				String token = (String)strTok.nextToken();
				
				String urlOnly = null;
				String pattern = null;
				if (!isXDMGetDevicesInfo)
				{
					pattern = token.substring(0,token.indexOf(":"));
					urlOnly = token.substring(token.indexOf(":")+1);
				}
				else{
					// urlOnly = token.substring(token.indexOf(":")+1);
					urlOnly = token;
				}
				
				String credentials="";
				if(credentialList!=null && credentialList.size()>0)
				{
					credentials = (String)credentialList.get(cnt);
					username = credentials.substring(0,credentials.indexOf(":"));
					password = credentials.substring(credentials.indexOf(":")+1);
				}
				if (isXDMGetDevicesInfo)
				{
					if(usernameXen !=null && usernameXen.length()!=0)
					{
						username=usernameXen;
						password= passwordXen;
					}
				}
				EgWebServiceBase wsclient = new EgWebServiceBase(urlOnly, username, password);
				services = wsclient.getWsdlServices();
				boolean resV = false;
				
				if(isXDMGetDevicesInfo)
				{
					 resV = XenMDMUrlTest.urlTest(urlOnly, username, password);
				}
				String userValidRes = "User credentials";
				String userInValidRes = "Incorrect credentials";
				if(services!=null && services.size()>0)
				{
%>
					<tr>
						<td id="cell_border4" valign="middle"><div class="tick"></div></td>
<%
					if (!isXDMGetDevicesInfo)
					{
%>
							<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=pattern%></td>
<%
					}
%>
							<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=urlOnly%></td>
							<td id="cell_border4" class="space3" valign="middle">
							&nbsp;<egui:intnl text="admin.common.Valid"/>&nbsp;
						</td>
						
						</tr>
<%
					if (isXDMGetDevicesInfo)
					{
						if(resV)
						{
%>
							<tr>
							<td id="cell_border4" class="space3" valign="middle">
								<div class="tick"></div>
								</td>
							<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=userValidRes%></td>
								
								<td id="cell_border4" class="space3" valign="middle">
								&nbsp;<egui:intnl text="admin.common.Valid"/>&nbsp;</td>
								</tr>
<%
						}
						else
						{
%>
							<tr>
							<td id="cell_border4" class="space3" valign="middle">
							<div class="fault"></div>
							</td>
							<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=userInValidRes%></td>
							
							<td id="cell_border4" class="space3" valign="middle">
							&nbsp;<egui:intnl text="admin.common.InValid"/>&nbsp;</td></tr>
<%
						}
					}
				}
				else
				{
					String notReq = "-";
%>
					<tr>
						<td id="cell_border4" valign="middle"><div class="fault"></div></td>
<%
					
					if (!isXDMGetDevicesInfo)
					{
%>
						<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=pattern%></td>
<%
					}
%>
						<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=urlOnly%></td>
						<td id="cell_border4" class="space3" valign="middle">&nbsp;<egui:intnl text="admin.common.Invalid"/>&nbsp;
						</td>
						</tr>
<%
					if (isXDMGetDevicesInfo)
					{
%>
						<tr>
						<td id="cell_border4" class="space3" valign="middle" style="text-wrap;word-wrap:break-word;"><%=userValidRes%></td>
							<td id="cell_border4" class="space3" valign="middle"><%=notReq%></td>
							<td id="cell_border4" class="space3" valign="middle">
							&nbsp;<egui:intnl text="admin.common.InValid"/>&nbsp;</td></tr>
<%
					}
				}
				cnt++;
			}
%>
				</tbody>
			</table>
<%
			paramsForURL=paramsForURL+"&wsdlUrl="+EgURLEncoder.encode(wsdlUrl,"UTF-8")+"&selectedValue="+selectedValue+"&credentialValue="+credentialValue;
%>
			<table align="center">
				<tr>
					<td>
						<input type="button" value="Retry" style="width:60px;" class="eg_back" onclick="javascript:validateAppServerCredentails('<%=configurationType%>','<%=validationURL%>','<%=paramsForURL%>','validate','<%=componentType%>','<%=test%>','<%=multiUserMode%>','<%=allowHostName%>','<%=requiredParamNames%>','<%=fromPage%>',event);">
					</td>
				</tr>
			</table>
<%
	}
	}//validate end
}
catch(Exception e)
{
	e.printStackTrace();
}

%>


