<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import="net.sf.json.*"%>


<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;

	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename");

			String targetPageURL = null;
			auditLogThread.setValue("Module","Services Group");
			oldNameExist = Rename.doesOldnameExist(new EgGroupInfo().getVariables("LIST_OF_SERVICEGROUPS"),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a service group with a name which is already assigned to another service group";
			auditlogLabel=old_name + " service group can not be renamed to "+new_name +" as this name is already assigned to some other service group";
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
					Rename renameObj = new Rename(u_rs,"Service Group",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Service group",old_name);
						auditLogThread.setCurrentValue("Service group",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new service group name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables with new service group name")+".";
					}
					if(renameStatus)
					{
						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						groupSync.setValue("LIST_OF_SERVICEGROUPS",new_name,new_name);
						groupSync.deleteValue("LIST_OF_SERVICEGROUPS",old_name);
						Vector vars = groupsIni.getVariables("SERVICEGROUPS_DETAILS",true);
						Vector vals = groupsIni.getAllValues("SERVICEGROUPS_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vals.size();i++)
							{
								String var = (String)vars.get(i);
								String val = (String)vals.get(i);
								if(!StringUtils.isNull(var) && !StringUtils.isNull(val) && var.equals(old_name))
								{
									groupSync.setValue("SERVICEGROUPS_DETAILS",new_name,val);
									groupSync.deleteValue("SERVICEGROUPS_DETAILS",old_name);
									break;
								}
							}
						}
						groupsIni=null;
						groupSync.saveFile();
						EgConfigFilesSync.releaseInstance(groupSync);
						groupSync.saveFile();
						EgConfigFilesSync.releaseInstance(groupSync);

						auditLogThread.setPreviousValue("Service group name",old_name);
						auditLogThread.setCurrentValue("Service group name",new_name);
						auditLogThread.setValue("Description","Service group has been renamed");
						auditLogThread.sendItToDB();
						String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
						message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
					}
				
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
