<%
/*****************************************************************************
*	Name			:	EgVmLogDisplay.jsp
*	Purpose			:	To view the Log Files from the selected Agent 
******************************************************************************/
%>
<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.EgControlInfo"%>
<%@ page import = "com.eg.PollingServlet"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.EgVmLogDataModel"%>
<%@ page import = "com.eg.EgUtils"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import= "net.sf.json.*"%>

<%
	//System.out.println("first : "+new java.util.Date());

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	session.setAttribute("EgVmLogdisplay","true");

	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgVmLogDataModel model = new EgVmLogDataModel();
	boolean agentNotReporting = false;
	boolean fileNotCreated = true;
	Vector lines = new Vector();
	String agentID = EgURLDecoder.decode(request.getParameter("componentName"),"UTF-8");
	String fileNameToRead = request.getParameter("file");
	String showVmTable = request.getParameter("vmtable");
	fileNameToRead="eg_vm.ini";

	rootJson.put("showVmTable",showVmTable);
	rootJson.put("fileNameToRead",fileNameToRead);
	if(!StringUtils.isNull(fileNameToRead))
	{
		String sep = System.getProperty("file.separator");
		if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
		{
			agentID = agentID.substring(0,agentID.indexOf(":"));
			rootJson.put("agentID",agentID);

		}
		boolean controlModeCheckNeeded = true;
		//IniFile controlsDotIni_1 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		IniFile controlsDotIni_1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		String idlePeriod = controlsDotIni_1.getValue("CONTROL_DEFAULTS","IdlePeriod");
		if(StringUtils.isNull(idlePeriod))
		{
			idlePeriod="300";//seconds
		}
		long idlePeriodMS = Integer.parseInt(idlePeriod) * 1000;
		// PLEASE REFER final/monitor/ConfigureControlAction.jsp PAGE IF ANY CLARIFICATION IS NEEDED.
		//set agent's CONTROL_SETTINGS to "true" in eg_controls.ini and wait until it is restet to false
		//get the hash from PollingServlet, parser the key if match found write value = false, else true
		Vector ipVec = null;
		boolean checkIni = false;
		String key="none";
		if(PollingServlet.agentID != null && PollingServlet.agentID.size() > 0)
		{
			EgControlInfo ctrlInfo = new EgControlInfo("manager");
			Enumeration e = PollingServlet.agentID.keys();
			//Get the valid IPSTR for this agent IP
			while(e.hasMoreElements())
			{
				String ip = (String) e.nextElement();
				/*ip = ctrlInfo.getAllNamesOf(ip);
				StringTokenizer st = new StringTokenizer(ip,":");
				ipVec = new Vector();
				while(st.hasMoreTokens())
				{
					ipVec.add(st.nextToken());
				}*/
				ArrayList ipAddrs=ctrlInfo.getAllNamesOf(ip);
				if(ipAddrs!=null && !ipAddrs.isEmpty())
				{
					ipVec=new Vector();
					ipVec.addAll(ipAddrs);
				}
				if(ipVec!=null && ipVec.contains(agentID))
				{
					checkIni = true;
					break;
				}
			}
			if(checkIni)
			{
				String ipArr[] = controlsDotIni_1.getVariables("CURRENT_CONTROLS");
				if(ipArr != null)
				{
					for(int i=0;i<ipArr.length;i++)
					{
						if(ipVec.contains(ipArr[i]) )
						{
							String flag = controlsDotIni_1.getValue("CURRENT_CONTROLS",ipArr[i]);
							if(flag != null )
							{
								if( flag.equals("false") )
								{
									key="control";
									break;
								}
								else if( flag.equals("true") )
								{
									key="waiting";
								}
								else
								{
									key="normal";
								}
							}
						}
					}
				}
				else
				{
					key="normal";
				}
				if(key.equalsIgnoreCase("control"))
				{
					controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"false");
				}
				else
				{
					controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
				}
			}
			else
			{
				controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
			}
		}
		else
		{
			controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
		}
		controlsDotIni_1.saveFile();
		EgConfigFilesSync.releaseInstance(controlsDotIni_1);

		boolean idleBreak = false;
		if(controlModeCheckNeeded)
		{
			long startTime = System.currentTimeMillis();
			long elapsedTime = 0;
			while(true)
			{
				IniFile controlsDotIni_2 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini");
				String temp = controlsDotIni_2.getValue("CURRENT_CONTROLS",agentID);
				if(elapsedTime>=idlePeriodMS || StringUtils.isNull(temp))
				{
					idleBreak = true;
					break;
				}
				else if(temp.equals("false"))
				{
					break;
				}
				Thread.sleep(5000);
				elapsedTime =  System.currentTimeMillis() - startTime;
			}
		}
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		Hashtable nickIpMap = discInfo.getNickIpMap();
		String agentIp =(String) nickIpMap.get(agentID);
		String taskName = "ReadFile";
		String val = fileNameToRead + "@#@Y";
		//IniFile controlsDotIni_3 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		IniFile controlsDotIni_3 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		String timeout = controlsDotIni_3.getValue("CONTROL_DEFAULTS","TimeOut");
		if(!idleBreak)
		{
			controlsDotIni_3.setValue(agentID,taskName+":"+session.getId(),val);
		}
		controlsDotIni_3.saveFile();
		EgConfigFilesSync.releaseInstance(controlsDotIni_3);

		//If the file is already Exists delete it ,
		String tmpFilePath = EgInstallInfo.getInstallDir()+sep+"tmp"+sep+agentID+"_"+session.getId()+"."+taskName;
		try
			{
			File tmpFile = new File(tmpFilePath);
			if(tmpFile!=null && tmpFile.exists())
			{
				tmpFile.delete();
			}
		}
		catch(Exception e){
		}

		long timeLapse=0;
		long totSleepTime=0;
		long sleepTime=1000;
		timeout = (timeout != null && !timeout.equals(""))? timeout : "60";
		if(timeout == null || timeout.equals(""))
		{
			totSleepTime = 10000;
		}
		else
		{
			try
			{
				totSleepTime = Long.parseLong(timeout)*1000;
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		while(!idleBreak)
		{
			File f = new File(tmpFilePath);
			if(f != null && f.exists())
			{
				lines = new Vector();
				fileNotCreated = false;
				BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f),"UTF-8"));
				String line = null;
				while((line=br.readLine()) != null)
				{
					if(!StringUtils.isNull(line))
					{
						lines.add(line.trim());
					}
				}
				br.close();
				f.delete();
				break;
			}
			else
			{
				if(timeLapse < totSleepTime)
				{
					timeLapse += sleepTime;
					Thread.currentThread().sleep(sleepTime);
				}
				else
				{
					agentNotReporting = true;
					break;
				}
			}
		}
	}
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	EgMappingInfo mapping = new EgMappingInfo(userLanguage);
	Hashtable map =  (Hashtable)model.getVmLogDatas(lines);

	ArrayList list  = model.getVmsList();

	if(showVmTable!=null && showVmTable.equals("false"))
	{
		if (map!=null && !map.isEmpty())
		{
			Iterator itr = map.entrySet().iterator();
			HashMap phyServerAndType = new HashMap();
			JSONArray phyServerVmsPoweredonGridArr = new JSONArray();
			JSONArray vmsValidUserGridArr = new JSONArray();
			JSONArray insideViewFailedVmsGridArr = new JSONArray();
			JSONArray vmagentFailedVmsGridArr = new JSONArray();
			while(itr.hasNext())
			{
				Map.Entry keyValue = (Map.Entry)itr.next();
				String key = (String) keyValue.getKey();
				ArrayList value = (ArrayList)keyValue.getValue();
				if (value!=null && value.size()>0)
				{
					ArrayList headers =model.getTableHeaders(key,"");
					ArrayList tableValue = model.getTableValuesAsList(value);
					String tbaName = "";
					String strHeader = "";
					String strHeader1 = "";
					String strHeader2 = "";
					String strHeader3 = "";
					String strHeader4 = "";
					if(key.equalsIgnoreCase("Physical_server_VMs_poweredOn"))
					{
						tbaName="Physical Servers monitored and their VMs";
						rootJson.put("phyServerTitle",tbaName);

						if(headers != null && headers.size() > 0)
						{
							JSONArray powerGridHeaders = new JSONArray();
							for (int i=0; i<headers.size();i++)
							{
								String tempVal = "admin.agents."+ (String)headers.get(i);
								powerGridHeaders.add(_mapping.getTextDescription(tempVal));
							}
							rootJson.put(tbaName,powerGridHeaders);
							//fields: ['Hypervisor', 'physicalServer', 'registeredVMs', 'poweredOnVMs'],
							strHeader1 = (String) headers.get(0);
							strHeader2 = "physicalServer";
							strHeader3 = "registeredVMs";
							strHeader4 = "poweredOnVMs";
						}
					}
					else if(key.equalsIgnoreCase("Insideview_failed_vms"))
					{
						tbaName="VMs for which inside view is not working [Using Remote Agent]";
						rootJson.put("insideViewTitle",tbaName);

						if(headers != null && headers.size() > 0)
						{
							//fields: ['physicalServer', 'vm', 'vmIp', 'error'],
							JSONArray insideViewHeaders = new JSONArray();
							for (int i=0; i<headers.size();i++)
							{
								String tempVal = "admin.agents."+ (String)headers.get(i);
								insideViewHeaders.add(_mapping.getTextDescription(tempVal));
							}
							rootJson.put(tbaName,insideViewHeaders);
							strHeader1 = "physicalServer";
							strHeader2 = "vm";
							strHeader3 = "vmIp";
							strHeader4 = "error";
						}
					}
					else if(key.equalsIgnoreCase("Vmagent_failed_vms"))
					{
						tbaName="VMs for which inside view is not working [Using eG VM Agent]";
						rootJson.put("agentViewTitle",tbaName);
						if(headers != null && headers.size() > 0)
						{
							//fields: ['physicalServer', 'vm', 'vmIp', 'error'],

							JSONArray agentViewHeaders = new JSONArray();
							for (int i=0; i<headers.size();i++)
							{
								String tempVal = "admin.agents."+ (String)headers.get(i);
								agentViewHeaders.add(_mapping.getTextDescription(tempVal));
							}
							rootJson.put(tbaName,agentViewHeaders);
							strHeader1 = "physicalServer";
							strHeader2 = "vm";
							strHeader3 = "vmIp";
							strHeader4 = "error";
						}
					}
					else if(key.equalsIgnoreCase("VMs_valid_user"))
					{
						if(headers != null && headers.size() > 0)
						{
							//fields: ['physicalServer', 'vm', 'vmIp', 'validUser'],
							JSONArray validUserHeaders = new JSONArray();
							for (int i=0; i<headers.size();i++)
							{
								String tempVal = "admin.agents."+ (String)headers.get(i);
								validUserHeaders.add(_mapping.getTextDescription(tempVal));
							}
							rootJson.put("validUserTitle","VMs and its valid users");
							rootJson.put("VMs and its valid users",validUserHeaders);
							strHeader1 = "physicalServer";
							strHeader2 = "vm";
							strHeader3 = "vmIp";
							strHeader4 = "validUser";
						}
					}
					if(headers!=null && headers.size()>0)
					{
						for(int i=0;i<headers.size();i++)
						{
							String header = (String)headers.get(i);
							String className="";
							String idName="eg_subheadbg";
						}
					}

					if(tableValue!=null && tableValue.size()>0)
					{
							Iterator itr_table = tableValue.iterator(); 
							int j=0;
							while(itr_table.hasNext())
							{
								JSONObject phyServerVmsPoweredonGridObj = new JSONObject();
								JSONObject vmsValidUserGridObj = new JSONObject();
								JSONObject insideViewFailedVmsGridObj = new JSONObject();
								JSONObject vmagentFailedVmsGridObj = new JSONObject();

								ArrayList row = (ArrayList) itr_table.next();

								ArrayList tmpRow =new ArrayList();
								if(row!=null && row.size()>0)
								{
									for(int i=0;i<row.size();i++)
									{
										String val = (String)row.get(i);
										tmpRow.add(val);
										if(i==1 && key.equals("Physical_server_VMs_poweredOn"))
										{
											Integer reg = model.getVmsListCount(val);
											tmpRow.add(reg.toString());
										}
									}
								}
								String temVal = "";
								if(tmpRow!=null && tmpRow.size()>0)
								{
									for(int i=0;i<tmpRow.size();i++)
									{
										String val = (String)tmpRow.get(i);
										if(key.equals("Physical Servers monitored and their VMs") && i==6)
										{

										}
										else
										{
											if(tmpRow.contains("ESX") && tmpRow.contains("VMware") && key.equals("Physical_server_VMs_poweredOn"))
											{
												val="VMware ESX";
											}
											if(key.equals("Physical_server_VMs_poweredOn") && i==1)
											{
												phyServerAndType.put(val,temVal);
												phyServerVmsPoweredonGridObj.put(strHeader2,val);

											}
											else if(key.equals("Insideview_failed_vms") && i==0)
											{
												if ( phyServerAndType.containsKey(val))
													temVal = (String)phyServerAndType.get(val);
												insideViewFailedVmsGridObj.put(strHeader1,"Physical server : "+val);
											}
											else if((key.equals("Vmagent_failed_vms") && i==0) )
											{
												if ( phyServerAndType.containsKey(val))
												{
													temVal = (String)phyServerAndType.get(val);
												}
												vmagentFailedVmsGridObj.put(strHeader1,"Physical server : "+val);

											}
											else
											{
												if (key.equals("Physical_server_VMs_poweredOn"))
												{
													if(i == 0)
													{
														phyServerVmsPoweredonGridObj.put(strHeader1,strHeader1+" : "+val);
													}
													else if (i == 2)
													{
														phyServerVmsPoweredonGridObj.put(strHeader3,Integer.parseInt(val));
													}
													else if (i == 3)
													{
														phyServerVmsPoweredonGridObj.put(strHeader4,Integer.parseInt(val));
													}
												}
												else if (key.equals("VMs_valid_user"))
												{
													if(i == 0)
													{
														vmsValidUserGridObj.put(strHeader1,"Physical server : "+val);
													}
													else if (i == 1)
													{
														vmsValidUserGridObj.put(strHeader2,val);
													}
													else if (i == 2)
													{
														vmsValidUserGridObj.put(strHeader3,val);
													}
													else if (i == 3)
													{
														vmsValidUserGridObj.put(strHeader4,val);
													}
												}
												else if (key.equals("Insideview_failed_vms"))
												{
													if (i == 1)
													{
														insideViewFailedVmsGridObj.put(strHeader2,val);
													}
													else if (i == 2)
													{
														insideViewFailedVmsGridObj.put(strHeader3,val);
													}
													else if (i == 3)
													{
														insideViewFailedVmsGridObj.put(strHeader4,val);
													}
												}
												else if (key.equals("Vmagent_failed_vms"))
												{
													if (i == 1)
													{
														vmagentFailedVmsGridObj.put(strHeader2,val);
													}
													else if (i == 2)
													{
														vmagentFailedVmsGridObj.put(strHeader3,val);
													}
													else if (i == 3)
													{
														vmagentFailedVmsGridObj.put(strHeader4,val);
													}
												}
												if(key.equals("Physical_server_VMs_poweredOn") && i==0)
												{
													if (val.equals("VMware"))
														temVal = "esx";
													if (val.equals("Citrix XenServer"))
														temVal = "Xen";
													if (val.equals("Hyper-V"))
														temVal = "hyper";
												}
												else
												{

												}

											}
										}
									}
								}
								j++;

								if (key.equals("Physical_server_VMs_poweredOn"))
								{
									phyServerVmsPoweredonGridArr.add(phyServerVmsPoweredonGridObj);
								}
								else if (key.equals("VMs_valid_user"))
								{
									vmsValidUserGridArr.add(vmsValidUserGridObj);
								}
								else if (key.equals("Insideview_failed_vms"))
								{
									insideViewFailedVmsGridArr.add(insideViewFailedVmsGridObj);
								}
								else if (key.equals("Vmagent_failed_vms"))
								{
									vmagentFailedVmsGridArr.add(vmagentFailedVmsGridObj);
								}
							}
					}
				}
			}
			if(phyServerAndType != null && phyServerAndType.size() > 0)
			{
				JSONObject phyServerwithTypeObj = new JSONObject();
				Iterator it =  phyServerAndType.keySet().iterator();
				ArrayList tmpList = new ArrayList();
				while(it.hasNext())
				{
					tmpList.add(it.next());
				}
				for(int i=0;i<tmpList.size();i++)
				{
					String strKey = (String) tmpList.get(i);
					if(phyServerAndType.containsKey(strKey))
					{
						String strValue = (String) phyServerAndType.get(strKey);
						phyServerwithTypeObj.put(strKey,strValue);
					}
				}
				rootJson.put("phyServerwithTypeObj",phyServerwithTypeObj);
			}
			rootJson.put("phyServerVmsPoweredonGridArr",phyServerVmsPoweredonGridArr);
			rootJson.put("vmsValidUserGridArr",vmsValidUserGridArr);
			rootJson.put("insideViewFailedVmsGridArr",insideViewFailedVmsGridArr);
			rootJson.put("vmagentFailedVmsGridArr",vmagentFailedVmsGridArr);
			rootJson.put("isNoData",false);
		}
		else
		{
			rootJson.put("isNoData",true);
			String noDataMsg = "<div class='egFlexCenterByColumnWise' style='height:100%'><div class='iconInformation'></div><div class='commonErrorMsgText' >"+_mapping.getTextDescription("admin.agent.No Data Available")+".</div></div>";

			rootJson.put("NoDataMsg",noDataMsg);
		}
	}
	else if(showVmTable!=null && showVmTable.equals("true"))
	{
		String phyServer = request.getParameter("phyServer");
		String type = request.getParameter("type");
		String from  = request.getParameter("from");
		HashMap vmsMap = (HashMap)model.getVmsMappingData("");
		rootJson.put("from",from);
		if(vmsMap!=null && !vmsMap.isEmpty())
		{

			String strHeader1 = "";
			String strHeader2 = "";
			String strHeader3 = "";
			String strHeader4 = "";
			String strHeader5 = "";
			String strHeader6 = "";
			String strHeader7 = "";
			if(phyServer!=null)
			{
				rootJson.put("phyServer",phyServer);
				rootJson.put("componentViewGridTitle","VM Details for "+phyServer);
				rootJson.put("type",type);

				ArrayList listData = (ArrayList)vmsMap.get(phyServer);
				ArrayList headers = model.getTableHeaders("VMs",type); 

				headers.remove(1);
				JSONObject columnObj = new JSONObject();
				if(headers!=null && headers.size()>0)
				{
					headers.remove(0);
					for(int i=0;i<headers.size();i++)
					{
						String header = (String)headers.get(i);
						columnObj.put(header,_mapping.getTextDescription("admin.agents."+header));
						String className="";
					}
				}
				rootJson.put("columnObj",columnObj);
				if (type != null && type.equalsIgnoreCase("esx"))
				{
					strHeader1 = "vm";
					strHeader2 = "vmIp";
					strHeader3 = "dns";
					strHeader4 = "connectionState";
					strHeader5 = "powerState";
					strHeader6 = "os";
					strHeader7 = "vmToolsState";
					JSONArray esxVmDetailsHeaders = new JSONArray();
					for (int i=0; i<headers.size();i++)
					{
						String tempVal = "admin.agents."+ (String)headers.get(i);
						esxVmDetailsHeaders.add(_mapping.getTextDescription(tempVal));
					}
					rootJson.put(type,esxVmDetailsHeaders);
				}
				else if (type != null && type.equalsIgnoreCase("xen"))
				{
					strHeader1 = "vm";
					strHeader2 = "vmIp";
					strHeader3 = "os";
					strHeader4 = "powerState";
					strHeader5 = "xenToolsState";
					JSONArray xenVmDetailsHeaders = new JSONArray();
					for (int i=0; i<headers.size();i++)
					{
						String tempVal = "admin.agents."+ (String)headers.get(i);
						xenVmDetailsHeaders.add(_mapping.getTextDescription(tempVal));
					}
					rootJson.put(type,xenVmDetailsHeaders);
				}
				else if (type != null && type.equalsIgnoreCase("hyper"))
				{
					strHeader1 = "vm";
					strHeader2 = "vmIp";
					strHeader4 = "powerState";
					strHeader3 = "os";
					JSONArray hyperVmDetailsHeaders = new JSONArray();
					for (int i=0; i<headers.size();i++)
					{
						String tempVal = "admin.agents."+ (String)headers.get(i);
						hyperVmDetailsHeaders.add(_mapping.getTextDescription(tempVal));
					}
					rootJson.put(type,hyperVmDetailsHeaders);
				}
				if(from!=null && !from.equals("testconfig"))
				{
					rootJson.put("isBack",true);
				}
				else
				{
					rootJson.put("isBack",false);
				}
				


				if(listData!=null && listData.size()>0)
				{
					JSONArray componentViewGridArr = new JSONArray();
					for(int i=0;i<listData.size();i++)
					{
						ArrayList rowData = (ArrayList)listData.get(i);

						JSONObject componentViewGridObj  = new JSONObject();
						componentViewGridObj.put(strHeader1,(String)rowData.get(1));
						componentViewGridObj.put(strHeader2,(String)rowData.get(2));
						componentViewGridObj.put(strHeader3,(String)rowData.get(3));
						componentViewGridObj.put(strHeader4,(String)rowData.get(4));
						if(!StringUtils.isNull(type)  && !type.equalsIgnoreCase("hyper"))
						{
							componentViewGridObj.put(strHeader5,(String)rowData.get(5));
						}
						if (type != null && type.equals("esx"))
						{
							componentViewGridObj.put(strHeader6,(String)rowData.get(6));
							String tempVal = (String)rowData.get(7);
							if(tempVal.indexOf("tools")>-1)
							{
								String name = "tools";
								int len = name.length();
								tempVal = tempVal.substring(len);
							}
							componentViewGridObj.put(strHeader7,tempVal);
						}
						componentViewGridArr.add(componentViewGridObj);
						//for(int j=0;j<rowData.size();j++)
						//{
							//String val = (String)rowData.get(j);
							//if(val.indexOf("VM_EXECUTION_STATE")>-1 || val.indexOf("tools")>-1)
							//{
								//if(val.indexOf("tools")>-1)
								//{
									//String name = "tools";
									//int len = name.length();
									//val = val.substring(len);
								//}
							//}
							////else
							////{
								////if(j==0)
								////{
								////}
								////else
								////{
									////if(j==1)
									////{

									////}
									////else
									////{

									////}
								////}
							////}
						//}
					}
					rootJson.put("componentViewGridArr",componentViewGridArr);
					rootJson.put("isNoData",false);
				}
				else
				{
					rootJson.put("isNoData",true);
					rootJson.put("NoDataMsg",_mapping.getTextDescription("admin.agents.No Data Available"));
				}
			}
		}
		else
		{
			rootJson.put("isNoData",true);
			rootJson.put("NoDataMsg",_mapping.getTextDescription("admin.agents.No Data Available"));
		}
	}
	else if(agentNotReporting || fileNotCreated)
	{
		rootJson.put("isNoData",true);
		rootJson.put("agentNotReporting",agentNotReporting);
		rootJson.put("fileNotCreated",fileNotCreated);
		rootJson.put("NoDataMsg",_mapping.getTextDescription("admin.agents.Timed out"));
	}
	else
	{
		rootJson.put("isNoData",true);
		rootJson.put("NoDataMsg",_mapping.getTextDescription("admin.agents.There is no ")+ fileNameToRead +" "+_mapping.getTextDescription("admin.agents.file (or) data is empty"));
	}
	out.println(rootJson.toString());

%>




