<%
/**
 *	File name		:	EgNewServerJson.jsp
 *	Purpose			:	This page is used to add new components into the eG system
 *	Navigation		:	Infrastructure > Add / Modify component	> [Add New Component]
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "egurkha.ServerBean"%>
<%@ page import = "egurkha.reporter.ErUserData"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	JSONObject hiddens = new JSONObject();

	JSONArray microsoftSuffixNameValues = new JSONArray();
	JSONArray microsoftDisplyNames = new JSONArray();
	JSONArray microsoftComponentkeys = new JSONArray();
	IniFile mgrmiscIni =  new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String serverType = request.getParameter("serverType");
	String microsoftComponents[] = mgrmiscIni.getVariables("Microsoft_Components");
	Vector microsoftSuffixVal = mgrmiscIni.getAllValues("Microsoft_Components");
	int microsoftComponentsLength = microsoftComponents.length;
	for (int i=0;i<microsoftComponentsLength;i++)
	{
		String microsoftComponentkey = microsoftComponents[i];
		microsoftComponentkeys.add(microsoftComponentkey);
		String microsoftSuffixName = (String) microsoftSuffixVal.get(i);
		microsoftSuffixNameValues.add(microsoftSuffixName);
		String displyName = _mapping.getComponentTypeDescription(microsoftComponentkey);
		microsoftDisplyNames.add(displyName);
	}
	rootJSON.put("microsoftComponentkeys",microsoftComponentkeys);
	rootJSON.put("microsoftSuffixNameValues",microsoftSuffixNameValues);
	rootJSON.put("microsoftDisplyNames",microsoftDisplyNames);
	boolean isMicrosoftType = false;
	for(int j=0; j<microsoftComponentsLength; j++)
	{
		String microsoftComponentkey = microsoftComponents[j];
		isMicrosoftType = microsoftComponentkey.equals(serverType);
		if(isMicrosoftType)
		{
			String microsoftsuffixNameVal = mgrmiscIni.getValue("Microsoft_Components",microsoftComponentkey);
			rootJSON.put("microsofthostSuffixName",microsoftsuffixNameVal);
			break;
		}		
	}
	rootJSON.put("jsonisMicrosoftType",isMicrosoftType);

	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
	EgMappingInfo mapping = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String isExistingAggType = "true";
	EgGroupInfo groupInfo = new EgGroupInfo();
	String normalServerType = null;
	String aggComponent = null;
	String fromResultPage=request.getParameter("fromResultPage");
	String operation = request.getParameter("operation");
	String elementType = request.getParameter("elementType");
	String elementName = request.getParameter("elementName");
	String treeViewSrc = request.getParameter("treeViewSrc");
	String selectedServerGroup = request.getParameter("selectedServerGroup");
	String server = request.getParameter("server");
	if (serverType == null) serverType ="";
	if (server == null) server = "";
	rootJSON.put("serverType",serverType);
	rootJSON.put("serverTypeDisp",mapping.getComponentTypeDescription(serverType));
	if (selectedServerGroup == null)
	{
		selectedServerGroup = "-1";
	}
	if(!StringUtils.isNull(operation) && operation.equals("modify"))
	{
		aggComponent = serverType + ":" + server;
	}
	String modifyserver = request.getParameter("modifyserver");
	IniFile externalIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_external.ini");
	IniFile virCompIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_virtualcomponents.ini");
	//Combo - Category
	ArrayList serverGrps = getAllServerGroups();
	JSONArray categoryArr = new JSONArray();
	JSONObject tempObj = new JSONObject();
	tempObj.put("valueField","-1");
	tempObj.put("displayField",mapping.getTextDescription("admin.server.All"));
	categoryArr.add(tempObj);
	for(int i=0; i<serverGrps.size(); i++)
	{
		String serverGrp = (String)serverGrps.get(i);
		JSONObject obj = new JSONObject();
		obj.put("valueField",serverGrp);
		obj.put("displayField",_mapping.getTextDescription("admin.category."+serverGrp));
		categoryArr.add(obj);
	}
	rootJSON.put("category",categoryArr);
	rootJSON.put("selectedServerGroup",selectedServerGroup);
	if(selectedServerGroup != null && selectedServerGroup.equals("-1"))
	{
		rootJSON.put("selectedServerGroupDisp",_mapping.getTextDescription("admin.server.All"));
	}
	else
	{
		rootJSON.put("selectedServerGroupDisp",_mapping.getTextDescription("admin.category."+selectedServerGroup));
	}
	//Combo  - Components types
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	ArrayList serverList  = new ArrayList();
	String[] servertypes = discInfo.getComponentTypes();
	for(int i=0; i<servertypes.length; i++)
	{
		if (!servertypes[i].equals("Site_servers"))
		{
			serverList.add(servertypes[i]);
		}
	}
	serverList = sorter.getSortedCompTypeList(serverList);

	if (selectedServerGroup != null && !selectedServerGroup.equals("null") && !selectedServerGroup.equals("-1") && selectedServerGroup.length() > 0)
	{
		if (selectedServerGroup.equalsIgnoreCase("Others"))
		{
			ArrayList serversGrpList = getOtherServers();
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
		else if (selectedServerGroup.equalsIgnoreCase("CUSTOM COMPONENTS"))
		{
			ArrayList serversGrpList = getAllUserDefinedServers();
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
		else
		{
			ArrayList serversGrpList = getCategorizedComponents(selectedServerGroup);
			serverList = sorter.getSortedCompTypeList(serversGrpList);
		}
	}
	if (selectedServerGroup != null && selectedServerGroup.equalsIgnoreCase("Others"))
	{
		serverList = removeAggServers(serverList);
	}
	
	JSONArray compTypesArray = new JSONArray();
	JSONObject tmpObj1 = new JSONObject();
	tmpObj1.put("valueField","-1");
	tmpObj1.put("displayField",mapping.getTextDescription("admin.server.Choose a component type"));
	compTypesArray.add(tmpObj1);
	String selectedCompType = "-1";
	for(int i=0; i<serverList.size(); i++)
	{
		EgName nameObj = (EgName)serverList.get(i);
		//searchItemFound=true;
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		if(tmpVal.startsWith("Agg_"))
		{
			continue;
		}
		if (tmpVal.equals(serverType)) 
			selectedCompType = serverType;
		JSONObject obj = new JSONObject();
		obj.put("valueField",tmpVal);
		obj.put("displayField",tmpDis);
		compTypesArray.add(obj);
	}
	rootJSON.put("componentTypes",compTypesArray);

	String[] nickAloneTypes = externalIni.getVariables("NickName_Alone_Servers");
	List nickAloneTypesList = new ArrayList();
	if (nickAloneTypes != null)
	{
		nickAloneTypesList = Arrays.asList(nickAloneTypes);
	}
	boolean hideHostIPField = false;
	if (nickAloneTypesList.contains(serverType))
	{
		hideHostIPField = true;
	}
	rootJSON.put("hideHostIPField",hideHostIPField);

	/*....... For Auto Topology .... (Start)*/
	String frmTopology = request.getParameter("frmTopology");
	String topoSegName = request.getParameter("topoSegName");
	String comptitle = request.getParameter("comptitle");
	String compstatus = request.getParameter("compstatus");
	String nickNameStr ="";
	String portNoStr="";
	boolean isFromTopology = false;
	boolean isCompStatusUnManage = false;
	if(frmTopology!=null && frmTopology.equals("yes"))
	{
		isFromTopology = true;
		if(compstatus!=null)
		{
			if(compstatus.equals("UNMANAGE"))
				isCompStatusUnManage = true;
		}
	}
	if(isFromTopology)
	{
		if(comptitle!=null && comptitle.length() > 0)
		{
			if(comptitle.indexOf(":") < 0)
			{
				nickNameStr = comptitle;
				portNoStr = "NULL";
			}
			else
			{
				nickNameStr = comptitle.substring(0,comptitle.indexOf(":"));
				portNoStr = comptitle.substring(comptitle.indexOf(":")+1);
			}
		}
	}
	/*....... For Auto Topology .... (End)*/
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	boolean singleTypeMapping = aggregateInfo.isSingleComponentTypeAssociation();
	boolean isAggregateLink = serverType.startsWith("Agg_");
	String elements[] = null;
	if(isAggregateLink && StringUtils.isNull(operation))
	{
		if(!server.equals("new"))
		{
			aggComponent = serverType + ":" + server;
			elements = aggregateInfo.getElementsOfAggregateComponent(aggComponent);
			if(elements != null && elements.length==2)
			{
				elementType = elements[0];
				elementName = elements[1];
				operation="modify";
			}
		}
	}
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	String initialAgentAuto = "";
	String initialPortNo="";
	String previousSID="";
	String isPassiveValue="";
	String initVirtualEnv="";
	String initCloudEnv="";
	String initVirtualServer="-1";
	String initCloudServer="-1";
	EgDbInfo dbinfo=new EgDbInfo("manager");
	String strname = "";
	String mtshostname = "";
	String strVar[];
	String strMTS[];
	String enablemts = "";
	String disablemts = "";

	String strVal = "";
	String strTok = "";
	StringTokenizer st = null;
	int stCount = 0;
	String hostPort = "";
	String varPass = "";
	String hostIp = "";
	String strhostName = "";
	String portNo = "";
	String sid = "";
	int oraSidFlag = 0;
	boolean check = false;
	boolean noport = false;
	String aluser = "";
	String alpwd = "";
	String almode = "";
	String alos="";
	String sshPort="";
	String alencrypt="";
	String alkeyfile="";

	String agentMap = "";
	String intAgentSelected = "";
	String agentlessflag="false";

	String isPassive = request.getParameter("isPassive");
	String disablePassive = "";
	String enablePassive = "";
	if(isPassive != null && (isPassive.equals("Yes") || isPassive.equals("true")))
	{
		enablePassive = "checked";
	}
	if(isPassive == null || isPassive.equals("No") || isPassive.equals("false"))
	{
		disablePassive = "checked";
	}

	IniFile serIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String defalutAgentlessServerTypes[] = serIni.getVariables("DEFAULT_AGENTLESS_SETTINGS");
	ArrayList defaultAgentlessServers = null; // contains the list of default agentless servers 
	if (defalutAgentlessServerTypes != null)
	{
		defaultAgentlessServers = new ArrayList(Arrays.asList(defalutAgentlessServerTypes));
	}

	String servers[] = serIni.getVariables("AGENTLESS_SERVERS");
	ArrayList agentlessServers = null; // contains the list of agentless servers
	if (servers != null)
	{
		agentlessServers = new ArrayList(Arrays.asList(servers));
	}

	
	//String server = request.getParameter("server");
	String remote_vmware = request.getParameter("remote_vmware");
	String vmwarehosts = request.getParameter("vmwarehosts");
	boolean isAggregateType = false;
	if(serverType.startsWith("Agg_"))
	{
		isAggregateType = true;
		normalServerType = serverType.substring(serverType.indexOf("_")+1);
	}
	boolean isValidServerType = true;//check the serverType whether it is valid or not. if the ServerType is not valid means its value may be -1 or NULL [Useful only if moreServerInBox is enabled]
	if(serverType != null)
	{
		if(serverType.equalsIgnoreCase("NULL") || serverType.equalsIgnoreCase("-1"))
		{
			isValidServerType = false;
		}
	}
	else
	{
		isValidServerType = false;
	}

	remote_vmware = (remote_vmware==null)?"Yes":remote_vmware;


	//serverTypes.createFile("eg_discover.ini");

	String siteFlag = request.getParameter("siteSupport");      // added by Ramesh (12-06-2008)
	if(siteFlag == null)
		siteFlag = "false";
	//*******T.Thirumal  2/14/2006********
	String Ip = (String) session.getAttribute("Ip");
	String nick = (String) session.getAttribute("nick");
	String from = request.getParameter("from");
	if (from != null && from.equalsIgnoreCase("inventory"))
		session.setAttribute("from",from);
	//************************************
	
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	boolean allExternalTests = true;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	
	String [] srvTypes = discInfo.getServerTypes();
	//String[] testsForServer = specsInfo.getTestsForServer(serverType);
	if (srvTypes != null)
	{
		JSONArray srvTypeArr = new JSONArray();
		for (int s=0;s<srvTypes.length; s++)
		{
			srvTypeArr.add(srvTypes[s]);
		}
		rootJSON.put("servTypes",srvTypeArr);
	}
	String[] testsForServer = null;
	if(serverType.startsWith("Agg_"))
	{
		isExistingAggType="false";
		for(int i=0;i<srvTypes.length;i++)
		{
			if(srvTypes[i].equals(serverType))
			{
				isExistingAggType="true";
				break;
			}
		}
		testsForServer = specsInfo.getTestsForServer(normalServerType);
	}
	else
	{
		testsForServer = specsInfo.getTestsForServer(serverType);
	}
	if (testsForServer != null)
	{
		for (int a=0; a<testsForServer.length; a++)
		{
			if (!specsInfo.isTestExternal(testsForServer[a],serverType))
			{
				allExternalTests = false;
				break;
			}
		}
	}
	if(isValidServerType == false)
	{
		allExternalTests = false; 
	}
	//aluser = request.getParameter("aluser");
	//alpwd = request.getParameter("alpwd");
	//almode = request.getParameter("almode");
	String prevRemAgent = null;
	String remoteAgent = request.getParameter("remoteAgent");
	
	String enableRemoteAgent = request.getParameter("enableRemoteAgent");

	if (modifyserver == null && enableRemoteAgent == null && defaultAgentlessServers != null && defaultAgentlessServers.contains(serverType))
	{
		enableRemoteAgent = "true";
	}
	if (enableRemoteAgent == null)
	{
		enableRemoteAgent = EgConstants.BLANK_STRING;
	}
	if(isAggregateType)
		enableRemoteAgent = "true";
	// New fix to deal with Host Name validity check.
	String s_hostcheck = request.getParameter("hostcheck");
	String moreServersInBox = request.getParameter("moreServersInBox");
	if(moreServersInBox != null && moreServersInBox.equalsIgnoreCase("true"))
	{
		if(remoteAgent == null || remoteAgent.equalsIgnoreCase("null"))
			remoteAgent = request.getParameter("remoteAgent1");
	}
	String s_host_ip = "";
	String s_host_name = "";
	String s_port_no = "";
	String s_ora_sid = "";
	String s_mts_check = "";
	
	if(s_hostcheck != null && s_hostcheck.equals("true"))
	{
		s_host_ip = request.getParameter("hostip");
		s_host_name = request.getParameter("hostname");
		s_port_no = request.getParameter("sportno");
		
		if(serverType.equals("Oracle_server"))
		{
			s_ora_sid = request.getParameter("sid");
		}
		else if(serverType.equals("IIS_web_server") || serverType.equals("IIS_ssl_server"))
		{
			s_mts_check = request.getParameter("mts");
		}
	}
	else if(moreServersInBox != null && moreServersInBox.equals("true"))
	{
		s_host_ip = request.getParameter("hostip");
		s_host_name = request.getParameter("hostname");
		aluser = request.getParameter("aluser");
		alpwd = request.getParameter("alpwd");
		almode = request.getParameter("almode");
		alencrypt = request.getParameter("alencrypt");
		alkeyfile = request.getParameter("alkeyfile");		
	}

	//EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	boolean flag=false;
	if(serverType != null)
	{
		if(serverType.startsWith("Agg_"))
		{
			flag = true;
		}
		else
		{
			flag = specsInfo.isAgentlessServer(serverType);
		}
	}
	boolean flag1 = false;

	/* for user-comp mapping - START*/
	int usrLicStatus = 0;
	String userExtAgent = "";
	String user_id = _user.getLoginID();
	String userCompMap = EgConfigInfo.egMgrConfigDir + "eg_usercompmapping.ini";
	EgUuidInfo uuidInfo = new EgUuidInfo();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgCertUsage user = new EgCertUsage();
	ArrayList usersList = user.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList != null && usersList.contains(user_id));
	//UserAssociateComponent uacObj = new UserAssociateComponent(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId());
	/* for user-comp mapping - END*/

	String defExtAgent = specsInfo.getEGServer();

	EgUserElementsInfo userElemInfoObj = new EgUserElementsInfo();
	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] remoteAgents = extInfo.getAllRemoteAgents();
	if (remoteAgents != null)
	{
		Arrays.sort(remoteAgents,String.CASE_INSENSITIVE_ORDER);
		
		List tmpList = new ArrayList();
		String defaultRemAgent = "";
		for (int j=0; j <remoteAgents.length;j++)
		{
			String tmpRemAgent = remoteAgents[j];
			if (specsInfo.getEGServer().equals(tmpRemAgent))
			{
				defaultRemAgent = tmpRemAgent;
			}
			else
			{
				tmpList.add(tmpRemAgent);
			}
		}
		if (!defaultRemAgent.equals(""))
		{
			tmpList.add(0,defaultRemAgent);
		}
		remoteAgents = (String[])tmpList.toArray(new String[0]);
	}
	
	if(serverType != null && agentlessServers.contains(serverType))
	{
		if(remoteAgents == null || remoteAgents.length < 1)
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",mapping.getTextDescription("admin.server.Add/Modify Component"));
			String msg = mapping.getTextDescription("admin.server.Currently, there are no remote agents configured")+".";
			msg += mapping.getTextDescription("admin.server.This component type can only be monitored by remote agents")+".";
			rootJSON.put("AlertMsg",msg);
			out.println(rootJSON);
			return;			
		}
		else
		{
			if (enableRemoteAgent.equals(EgConstants.BLANK_STRING))
				enableRemoteAgent = "true";
		}
	}
	String[] extAgents = null;
	boolean clientEmuComps = false;
	boolean isModifyServer = (server != null && !server.equals("new"))?true:false;
	ArrayList emulatedList = extInfo.getEmulatedTypes();
	ArrayList usersCliEmuExtAgents = new ArrayList();
	ArrayList tempCliEmuExtAgents = new ArrayList();
	Object [] emuClient = extInfo.getClientEmulatingAgents();
	if(isLimitedAdmin)
	{
		if(emuClient != null && emuClient.length > 0)
		{
			usersCliEmuExtAgents = userElemInfoObj.getExternalAgentsForUser(user_id);
			tempCliEmuExtAgents = new ArrayList(Arrays.asList(emuClient));
			ArrayList otherCliExtAgents = nonUsersAgentList(user_id,"external");
			usersCliEmuExtAgents.retainAll(tempCliEmuExtAgents);
			if (otherCliExtAgents != null && isModifyServer)
			{
				otherCliExtAgents.retainAll(tempCliEmuExtAgents);
				usersCliEmuExtAgents.addAll(otherCliExtAgents);
			}
			tempCliEmuExtAgents.removeAll(usersCliEmuExtAgents);
			tempCliEmuExtAgents = egRoleInfo.removeDulpicates(tempCliEmuExtAgents);
			emuClient = (String[])usersCliEmuExtAgents.toArray(new String[0]);
		}
	}
	if(emulatedList.contains(serverType))
	{
		clientEmuComps = true;
		//Object [] emuClient = extInfo.getClientEmulatingAgents();
		if(emuClient != null && emuClient.length > 0)
		{
			extAgents = new String[emuClient.length];
			System.arraycopy(emuClient,0,extAgents,0,emuClient.length);
			//for(int i=0;i<emuClient.length;i++)
			//	extAgents[i] = (String)emuClient[i];
		}
		else
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",mapping.getTextDescription("admin.server.Add/Modify Component"));
			String msg = mapping.getTextDescription("admin.server.Currently, there are no external agents with client emulation capability enabled")+".";
			msg += mapping.getTextDescription("admin.server.This component can be managed only after an external agent with client emulation capability is added")+".";
			rootJSON.put("AlertMsg",msg);
			out.println(rootJSON);
			return;			
		}
	}
	else
	{	
		extAgents = extInfo.getAllExternalAgents();
		//Client Emulation enabled external agents will not execute normal external tests, so we are filtering here.
		//Object [] emuClient = extInfo.getClientEmulatingAgents();
		if(extInfo.isEmulationExclusiveExtAgents() && extAgents != null && emuClient != null)
		{
			ArrayList extAgentsList = new ArrayList(Arrays.asList(extAgents));
			ArrayList clEmuAgents = new ArrayList(Arrays.asList(emuClient));
			extAgentsList.removeAll(clEmuAgents);
			extAgents = (String[])extAgentsList.toArray(new String[0]);
		}
	}
	
	if(extAgents != null)
	{
		Arrays.sort(extAgents, String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultExtAgent = "";
		for (int j=0; j <extAgents.length;j++)
		{
			String tmpExtagent = extAgents[j];
			if (specsInfo.getEGServer().equals(tmpExtagent))
			{
				defaultExtAgent = tmpExtagent;
			}
			else
			{
				tmpList.add(tmpExtagent);
			}
		}
		if (!defaultExtAgent.equals(""))
		{
			tmpList.add(0,defaultExtAgent);
		}
		extAgents = (String[])tmpList.toArray(new String[0]);
	}
	
	/*
	 * Limited admin external and remote agents - STARTS
	 * by Meena.V
	 */
	if (isLimitedAdmin)
	{
		ArrayList tempRemoteAgents = userElemInfoObj.getRemoteAgentsForUser(user_id);
		ArrayList tempExternalAgents = userElemInfoObj.getExternalAgentsForUser(user_id);
		ArrayList otherExtAgents = nonUsersAgentList(user_id,"external");
		ArrayList otherRemAgents = nonUsersAgentList(user_id,"remote");
		String agentName = "";
		String usr_id = _user.getLoginID();
		boolean isDefOrgDirectUserWithShareRole = (uuidInfo.isUser(usr_id) && uuidInfo.hasOURole(usr_id) && uuidInfo.getDirectDependentOU(usr_id).equalsIgnoreCase("egenterprise"));

		if((tempRemoteAgents == null || tempRemoteAgents.size() == 0) && remoteAgents != null && remoteAgents.length > 0)
		{
			/* If the login user is direct user of default organization(egenterprise) then show the default remote agents to the user to add component.
			 * otherwise throw an alert to install or add new remote agent to the user to add component.
			 */
			//if (isDefOrgDirectUserWithShareRole)
			//{
				//tempRemoteAgents.addAll(uuidInfo.getDefaultOrganizationAgentList("RemoteAgent"));
			//}
			//else 
			if (flag)//if the comp type is agentless
			{
				tempRemoteAgents = new ArrayList();
				tempRemoteAgents.add("Not Applicable");
			}
		}
		else 
		{
			tempRemoteAgents.addAll(otherRemAgents);
			tempRemoteAgents = egRoleInfo.removeDulpicates(tempRemoteAgents);
		}
		if(!clientEmuComps)
		{
			if (otherExtAgents != null && isModifyServer)
			{
				tempExternalAgents.addAll(otherExtAgents);
			}
			if(tempExternalAgents != null && tempExternalAgents.size()>0)
			{
				tempExternalAgents = egRoleInfo.removeDulpicates(tempExternalAgents);
				
				if(usersCliEmuExtAgents != null && usersCliEmuExtAgents.size()>0)
				{
					tempExternalAgents.removeAll(usersCliEmuExtAgents);
				}
				if(tempCliEmuExtAgents != null && tempCliEmuExtAgents.size()>0)
				{
					tempExternalAgents.removeAll(tempCliEmuExtAgents);
				}
			}
			if((tempExternalAgents == null || tempExternalAgents.size() == 0) && extAgents != null && extAgents.length > 0)
			{
				/* If the login user is direct user of default organization(egenterprise) then show the default external agent to the user to add component.
				 * otherwise throw an alert to install or add new external agent to the user to add component.
				 */
				//if (isDefOrgDirectUserWithShareRole)
				//{
					//tempExternalAgents.addAll(uuidInfo.getDefaultOrganizationAgentList("ExternalAgent"));
				//}
				//else
				{
					tempExternalAgents = new ArrayList();
					tempExternalAgents.add("Not Applicable");
				}
			}
		}
		else
		{
			if(usersCliEmuExtAgents != null)
			{
				tempExternalAgents = usersCliEmuExtAgents;
			}
			tempExternalAgents = egRoleInfo.removeDulpicates(tempExternalAgents);
		}
		remoteAgents = (String[])tempRemoteAgents.toArray(new String[0]);
		extAgents = (String[])tempExternalAgents.toArray(new String[0]);
	}
	/* Limited admin external and remote agents - ENDS */
	
	//This variable is used in the process page to delete server(s) from
	//eg_disable.ini.'type' can be either "new" or a "server name". 
	//New line
	session.setAttribute("type",server);
	String associatedComponents = "";
	String selectedComponentTypes = "";
	String serverWithOutPort = "";
	if(server != null && server.indexOf(":")>0)
		serverWithOutPort = server.substring(0,server.indexOf(":"));
	String fromPage = request.getParameter("fromPage");
	if (fromPage != null && fromPage.equalsIgnoreCase("infrastructureView"))
	{
		String strQuery = "";
		String ea_criteria = request.getParameter("ea_criteria");
		if (ea_criteria != null)
		{
			strQuery = "ea_criteria="+ea_criteria;
		}

		String ea_userOption = request.getParameter("ea_userOption");
		if (ea_userOption != null)
		{
			strQuery = strQuery + "&ea_userOption=" + ea_userOption;
		}

		String viewAs = request.getParameter("viewAs");
		if (viewAs != null)
		{
			strQuery = strQuery + "&viewAs=" + viewAs;
		}

		String viewIn = request.getParameter("viewIn");
		if (viewIn != null)
		{
			strQuery = strQuery + "&viewIn=" + viewIn;
		}

		String scrollPosition_back = request.getParameter("scrollPosition_back");
		if (scrollPosition_back != null)
		{
			strQuery = strQuery + "&scrollPosition_back=" + scrollPosition_back;
		}
	}

	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	String zoneStr = null;
	String serviceStr = null;
	String segmentStr = null;
	String groupStr = null;
	boolean filtersFound = false;
	if(StringUtils.isNull(operation) || (!operation.equals("modify") && !operation.equals("add")))
	{
		if(serverType.startsWith("Agg_"))
		{
			String[] groupsArray = groupInfo.getGroupNames();
			String[] segmentsArray = topoInfo.getSegmentNames();
			String[] servicesArray = topoInfo.getVariables("SERVICE");
			String[] zonesArray = groupInfo.getZoneNames();

			//if(!serverType.equals("Agg_Generic_server"))
			if(singleTypeMapping)
			{
				if(groupsArray != null && groupsArray.length>0)
				{
					for(int i=0;i<groupsArray.length;i++)
					{
						ArrayList typesInGroup = groupInfo.getAllElementsTypeUnderGroup(groupsArray[i]);
						if(typesInGroup != null && typesInGroup.contains(normalServerType))
						{
							if(groupStr == null)
								groupStr = groupsArray[i];
							else
								groupStr += "," + groupsArray[i];
						}
					}
				}
				if(zonesArray != null && zonesArray.length>0)
				{
					for(int i=0;i<zonesArray.length;i++)
					{
						ArrayList typesInZone = groupInfo.getAllComponentsTypeUnderZone(zonesArray[i]);
						if(typesInZone != null && typesInZone.contains(normalServerType))
						{
							if(zoneStr == null)
								zoneStr = zonesArray[i];
							else
								zoneStr += "," + zonesArray[i];
						}
					}
				}
				if(servicesArray != null && servicesArray.length>0)
				{
					for(int i=0;i<servicesArray.length;i++)
					{
						TreeSet typesInService = topoInfo.getAllElementsTypeUnderService(servicesArray[i]);
						if(typesInService != null && typesInService.contains(normalServerType))
						{
							if(serviceStr == null)
								serviceStr = servicesArray[i];
							else
								serviceStr += "," + servicesArray[i];
						}
					}
				}
				if(segmentsArray != null && segmentsArray.length>0)
				{
					for(int i=0;i<segmentsArray.length;i++)
					{
						TreeSet typesInSegment = topoInfo.getAllElementsTypeUnderSegment(segmentsArray[i]);
						if(typesInSegment != null && typesInSegment.contains(normalServerType))
						{
							if(segmentStr == null)
								segmentStr = segmentsArray[i];
							else
								segmentStr += "," + segmentsArray[i];
						}
					}
				}
			}
			else
			{
				if(groupsArray != null && groupsArray.length>0)
				{
					for(int i=0;i<groupsArray.length;i++)
					{
						if(groupStr == null)
							groupStr = groupsArray[i];
						else
							groupStr += "," + groupsArray[i];
					}
				}
				if(zonesArray != null && zonesArray.length>0)
				{
					for(int i=0;i<zonesArray.length;i++)
					{
						if(zoneStr == null)
							zoneStr = zonesArray[i];
						else
							zoneStr += "," + zonesArray[i];
					}
				}
				if(servicesArray != null && servicesArray.length>0)
				{
					for(int i=0;i<servicesArray.length;i++)
					{
						if(serviceStr == null)
							serviceStr = servicesArray[i];
						else
							serviceStr += "," + servicesArray[i];
					}
				}
				if(segmentsArray != null && segmentsArray.length>0)
				{
					for(int i=0;i<segmentsArray.length;i++)
					{
						if(segmentStr == null)
							segmentStr = segmentsArray[i];
						else
							segmentStr += "," + segmentsArray[i];
					}
				}
			}
			filtersFound = (groupStr != null || segmentStr != null || serviceStr != null || zoneStr != null);
		}
	}
	boolean createdViaUI=false;
	String uiElementType = "";
	String uiElementName = "";
	String variables2[] = aggregateInfo.getVariables("UI_COMPONENT_ASSOCIATION");
	if(variables2 != null && variables2.length>0)
	{
		for(int c=0;c<variables2.length; c++)
		{
			if(variables2[c].startsWith(aggComponent+"#"))
			{
				String value = aggregateInfo.getValue("UI_COMPONENT_ASSOCIATION",variables2[c]);
				uiElementType = value.substring(0,value.indexOf("#"));
				uiElementName = value.substring(value.indexOf("#")+1);
				createdViaUI=true;
				break;
			}
		}
	}
	if(!createdViaUI)
	{
		if(StringUtils.isNull(elementType) || elementType.equals("-1") || StringUtils.isNull(elementName) || elementName.equals("-1"))
		{
			createdViaUI=true;
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	IniFile servicesIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
	//EgConfigTopo.createFile("eg_services.ini");
	//gets a list of servers with no port
	String noportservers[] = servicesIni.getVariables("NOPORT_SERVERS");
	String portServers_arr[] = servicesIni.getVariables("PORT_MAP");
	ArrayList aListFindPortForServ = new ArrayList(Arrays.asList(portServers_arr));
	//for getting default portno for servertypes
	//EgServicesInfo egs= new EgServicesInfo("manager");
	String pno = servicesInfo.getPortForServerTypes(serverType);
	if(pno == null || pno.length()==0)
		pno=servicesInfo.getPortForServerTypes("#"+serverType);
	
	if (aListFindPortForServ != null && aListFindPortForServ.contains(serverType))
	{
		String strservType = servicesIni.getValue("PORT_MAP",serverType);
		pno = servicesInfo.getPortForServerTypes(strservType);
		if(pno == null || pno.length()==0)
		{
			pno=servicesInfo.getPortForServerTypes("#"+strservType);
		}
	}

	if (from != null && from.equalsIgnoreCase("inventory"))
	{
		String discoveredPort = request.getParameter("discPort");
		if (!StringUtils.isNull(discoveredPort))
		{
			pno = discoveredPort;
		}
	}

	boolean isAllowIPModify = servicesInfo.isAllowIPModification();
	boolean isModify = (server != null && !server.equals("new"))?true:false;
	if(isFromTopology)
		isAllowIPModify = false;
	ArrayList passiveServers = servicesInfo.getPassiveServers();
	String ss = "No";
	//EgConfigTopo.createFile("eg_discover.ini");
	IniFile discoverIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_discover.ini");
	if(server != null && !server.equals("new"))
	{
		strVar = discoverIni.getVariables(serverType);

		for(int i=0; i<strVar.length; i++)
		{
			if(strVar[i].startsWith("Format:") 
				|| strVar[i].startsWith("#Unmanage|"))
			{
				continue;
			}
			else
			{
				st = new StringTokenizer(strVar[i],":");
				stCount = st.countTokens();
				for(int j=0; j<stCount; j++)
				{
					strTok = st.nextToken();
					if(j==1 || j==2)
					{
						hostPort = hostPort + strTok + ":";
					}//end of if
				}//end of for j

				hostPort = hostPort.substring(0,hostPort.lastIndexOf(":"));
				String hostlog=hostPort.substring(0,hostPort.indexOf(":"));
				session.setAttribute("hostval",hostlog);
				if(hostPort.equals(server))
				{
					strVal = discoverIni.getValue(serverType,strVar[i]);
					varPass = strVar[i];
					varPass = varPass.trim();
					if(strVar[i].startsWith("Oracle_server"))
					{
						st = new StringTokenizer(strVal,",");
						stCount = st.countTokens();

						if(stCount==6)
						{
							serverType = st.nextToken();
							hostIp = st.nextToken();
							strhostName = st.nextToken();
							portNo =  st.nextToken();
							ss = st.nextToken();
							sid = sid + st.nextToken() + ",";
							oraSidFlag = 1;
						}
						else if(stCount==5)
						{
							oraSidFlag = 0;
						}
					}
				}
				hostPort = "";
			}//end of else
		}//end of for i
		//if((serverType.equals("Oracle_server")==false || serverType.equals("Oracle_server")) && oraSidFlag==0)
		if(oraSidFlag==0)
		{
			st = new StringTokenizer(strVal,",");
			stCount = st.countTokens();
			if(stCount==5)
			{
				serverType = st.nextToken();
				hostIp = st.nextToken();
				strhostName = st.nextToken();
				portNo =  st.nextToken();
				ss = st.nextToken();
			}
		}
		
		if(isPassive == null) // To get isPassive value from the Ini file of server type
		{
			enablePassive = "";
			disablePassive = "";
			if(ss != null && (ss.equalsIgnoreCase("Yes") || ss.equalsIgnoreCase("true")))
				enablePassive = "checked";
			if(ss == null || ss.equalsIgnoreCase("No") || ss.equalsIgnoreCase("false"))
				disablePassive = "checked";
		}
	}

	//skm
	//EgDiscInfo discInfo = new EgDiscInfo("manager");
	ArrayList siteServers = discInfo.getSiteServers();
	boolean siteSupport = false;
	if(isAggregateType)
	{
		siteSupport = siteServers!= null && siteServers.size() >0 && siteServers.contains(serverType.substring(serverType.indexOf("_")+1));
	}
	//skm (29/12/2005)

	//skm (20/12/2005) For checking hostname in the client-side
	String temp_str_comp = "";
	if (isAggregateType)
	{
		String discInfoServerTypes[] = discInfo.getComponentTypes();
		for(int j=0;j<discInfoServerTypes.length;j++)
		{
			if(discInfoServerTypes[j].startsWith("Agg_"))
			{
				String[] temp_components = discInfo.getAllServersOfType(discInfoServerTypes[j]);
				for(int i=0;i<temp_components.length;i++)
				{
					if(temp_str_comp.equals(""))
					{
						temp_str_comp = temp_components[i].substring(temp_components[i].indexOf(':')+1,temp_components[i].lastIndexOf(':')); 
					}
					else
					{
						temp_str_comp = temp_str_comp +","+temp_components[i].substring(temp_components[i].indexOf(':')+1,temp_components[i].lastIndexOf(':')); 
					}
				}
			}
		}
	}

	//(server,serverType,hostip) not considered
	String hostname = request.getParameter("hostname");
	String extAgent = request.getParameter("ext_agents");
	String compType = request.getParameter("comp_types");

	ArrayList alExtAgents = null;
	String[] tmpExtAgents = null;
	boolean tmpExtAgentPopulated = false;
	boolean compFlag = true;

	if(!StringUtils.isNull(hostname) && !StringUtils.isNull(extAgent) && !StringUtils.isNull(compType))
	{
		StringTokenizer extAgentToken = new StringTokenizer(extAgent,",");
		StringTokenizer compTypeToken = new StringTokenizer(compType,",");

		alExtAgents = new ArrayList();
		//alCompTypes = new ArrayList();

		while(extAgentToken.hasMoreTokens())
			alExtAgents.add(extAgentToken.nextToken().trim());
		
		/*while(compTypeToken.hasMoreTokens())
			alCompTypes.add(compTypeToken.nextToken().trim());
		*/
		tmpExtAgents = new String[extAgents.length];
		//tmpCompTypes = new String[strServerTypes.length];

		for(int i=0;i<extAgents.length;i++)
			if(alExtAgents.contains(extAgents[i]))
			{
				tmpExtAgents[i] = "selected";
				tmpExtAgentPopulated = true;
			}

		/*for(int i=0;i<strServerTypes.length;i++)
			if(alCompTypes.contains(strServerTypes[i]))
				tmpCompTypes[i] = "selected";

		alComps = new ArrayList();

		for(int i=0;i<alCompTypes.size();i++)
		{
			String[] components = discInfo.getAllServersOfType(((String)alCompTypes.get(i)).trim());
			for(int j=0;j<components.length;j++)
			{
				alComps.add(components[j]);
			}
		}

		if(alComps.size() == 0)
			compFlag = false;
		*/

	}
	//skm

//form name="addserver" method="post" action="EgHostCheck.jsp?siteSupport="+siteFlag+"&isAggregateLink="+isAggregateLink+"&selectedServerGroup="+selectedServerGroup
	//Hidden variables
	rootJSON.put("isExistingAggType",isExistingAggType);
	rootJSON.put("from",from);
	rootJSON.put("treeViewSrc",treeViewSrc);
	rootJSON.put("fromResultPage",fromResultPage);
	//Auto Topology (Begin)
	rootJSON.put("frmTopology",isFromTopology?frmTopology:"");
	rootJSON.put("comptitle",isFromTopology?comptitle:"");
	rootJSON.put("topoSegName",isFromTopology?topoSegName:"");
	rootJSON.put("compstatus",isFromTopology?compstatus:"");
	//Auto Topology (End)
	String tmpStr = "";
	//tmpStr = request.getParameter("allExternalTests");
	rootJSON.put("allExternalTests",allExternalTests);
	tmpStr = request.getParameter("fromHomePopup");
	rootJSON.put("fromHomePopup",tmpStr);
			
	String pageTitle = "";		

	if(from != null && (server.equals("new") || from.equals("inventory") || from.equals("resultpage")))
	{
		if(isAggregateLink)
			pageTitle = mapping.getTextDescription("admin.server.NEW AGGREGATE COMPONENT DETAILS");
		else
			pageTitle = mapping.getTextDescription("admin.server.NEW COMPONENT DETAILS");
	}
	else
	{
		if(isAggregateLink)
			pageTitle = mapping.getTextDescription("admin.server.MODIFY AGGREGATE COMPONENT DETAILS");
		else
			pageTitle = mapping.getTextDescription("admin.server.MODIFY COMPONENT DETAILS");
	}
	rootJSON.put("pageTitle",pageTitle);

	if(isAggregateLink)
	{
		rootJSON.put("componentTypeLabel",mapping.getTextDescription("admin.server.Aggregate component type"));
	}
	else
	{	
		rootJSON.put("componentTypeLabel",mapping.getTextDescription("admin.server.Component type"));
	}
	if((moreServersInBox != null && moreServersInBox.equals("true")) || serverType != null && serverType.equals("-1"))
	{
		rootJSON.put("componentTypeElement","select");
		JSONArray cTypeArr = new JSONArray();
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("actualValue","-1");
		tmpObj.put("displayValue",mapping.getTextDescription("admin.common.Choose a component type"));
		cTypeArr.add(tmpObj);
		String [] allServerTypes = discInfo.getComponentTypes(); //skm
		/*
		showing only aggregate components, when clicked on aggregates menu item of Agg/Modify servers.
		code starts
		*/
		if(EgInstallInfo.isAggregationSupported())
		{
			Vector aggregateTypes = aggregateInfo.getAggregateTypes();
			if(isAggregateLink)
			{
				allServerTypes = (String[]) aggregateTypes.toArray(new String[aggregateTypes.size()]);
			}
			else
			{
				if(aggregateTypes != null && aggregateTypes.size()>0)
				{
					Set set = new HashSet(Arrays.asList(allServerTypes));
					if(aggregateTypes != null && aggregateTypes.size()>0)
						set.removeAll(aggregateTypes);
					allServerTypes = (String[]) set.toArray(new String[set.size()]);
				}
			}
		}
		/*
		code ends
		*/
		//For sorting
		ArrayList serverList2 = new ArrayList();
		
		for(int e=0; e<allServerTypes.length; e++)
		{
			if(allServerTypes[e].equals("Site_servers"))
				continue;
			serverList2.add(allServerTypes[e]);
		}

		
		serverList2 = sorter.getSortedCompTypeList(serverList2 );
		for(int j=0;j<serverList2.size();j++)
		{
			EgName nameObj = (EgName)serverList2 .get(j);
			String tmpVal = nameObj.getActualName();	
			String tmpDis = nameObj.getLocalName();	
			JSONObject obj = new JSONObject();
			obj.put("actualValue",tmpVal);
			obj.put("displayValue",tmpDis);
			cTypeArr.add(obj);
			if(tmpVal.equals(serverType))
			{
				rootJSON.put("componentTypeSelected",tmpVal);
			}
		}
		rootJSON.put("componentTypeList",cTypeArr);

	}
	else
	{
		rootJSON.put("componentTypeElement","text");
		rootJSON.put("componentTypeValue",mapping.getComponentTypeDescription(serverType));
		//rootJSON.put("stype",serverType); //Hidden
		hiddens.put("stype",serverType);
	}

	if (vmwarehosts==null && !server.equals("new"))
	{
		//new request
		if ((s_hostcheck != null && s_hostcheck.equals("true")) || 
			(moreServersInBox != null && moreServersInBox.equals("true")))
		{
			vmwarehosts = externalIni.getValue("VIRTUALmapping", serverType+":"+s_host_name+":"+s_port_no);
		}
		else
		{
			vmwarehosts = externalIni.getValue("VIRTUALmapping", serverType+":"+strhostName+":"+portNo);
		}
	}
	vmwarehosts = (vmwarehosts==null)?"-1":vmwarehosts;

	if(from!=null && from.equals("addnew"))
	{
		Ip="";
		nick="";
	}
	String tmpHostIp = "";
	String tmpHostNick = "";
	boolean isHostCheck = false;
	boolean isIPAndNickAreSame = false;

	// Auto Topology (Begin)
	if(isFromTopology)
	{
		nick = nickNameStr;
		Hashtable ht = discInfo.getAllNicksIpMap();
		hostIp = (String) ht.get(nick);		
	}
	// Auto Topology (End)

	if((s_hostcheck != null && s_hostcheck.equals("true")) || (moreServersInBox != null && moreServersInBox.equals("true")))
	{
		isHostCheck = true;
		tmpHostNick = s_host_name;
		tmpHostIp = s_host_ip;
	}
	else
	{
		tmpHostNick = strhostName;
		tmpHostIp = hostIp;
	}
	if (tmpHostNick.equals(tmpHostIp))
	{
		isIPAndNickAreSame = true;
	}
	if (!isAggregateType)
	{
		if (isAllowHostName)
		{
			rootJSON.put("hostIPLabel",mapping.getTextDescription("admin.server.Host IP/Name"));
		}
		else
		{
			rootJSON.put("hostIPLabel",mapping.getTextDescription("admin.server.Host IP"));
		}
		if((s_hostcheck != null && s_hostcheck.equals("true")) || (moreServersInBox != null && moreServersInBox.equals("true")))
		{
			rootJSON.put("hostIPValue",s_host_ip);
		}
		else if (Ip != null && Ip.length() > 0 && server != null && server.equalsIgnoreCase("new"))//thirumal 2/14/2006
		{
			rootJSON.put("hostIPValue",Ip);
		}
		else
		{
			rootJSON.put("hostIPValue",hostIp);
		}
		rootJSON.put("tmpHostName",tmpHostNick); // Hidden

		if (isModify && isAllowIPModify)// && !isIPAndNickAreSame)
		{
			if (isAllowHostName)
			{
				rootJSON.put("changeIPLabel",mapping.getTextDescription("admin.server.Change IP/Name"));

			}
			else
			{
				rootJSON.put("changeIPLabel",mapping.getTextDescription("admin.server.Change IP"));
			}
		}
	}
	else
	{
		//rootJSON.put("hostip","0.0.0.0");//Hidden
		hiddens.put("hostip","0.0.0.0");
	}

	String host_for_RemoteAgent = "";
	String hostNameForTestInfo = request.getParameter("server");
	if (!StringUtils.isNull(hostNameForTestInfo) && hostNameForTestInfo.indexOf(":") != -1)
	{
		host_for_RemoteAgent = hostNameForTestInfo.substring(0,hostNameForTestInfo.indexOf(":"));
		String olderRemoteAgentNameForTestInfo = extInfo.getRemoteAgentForHost(host_for_RemoteAgent);
		if(StringUtils.isNull(olderRemoteAgentNameForTestInfo))
		{
			olderRemoteAgentNameForTestInfo = "";
		}
		hiddens.put("olderRmtAgtForTestInfo",olderRemoteAgentNameForTestInfo);
	}

	if(!StringUtils.isNull(operation) && operation.equalsIgnoreCase("modify"))
	{
		String variables[] = aggregateInfo.getVariables("COMPONENT_ASSOCIATION");
		String[] managedAggComps = discInfo.getAllServersOfType(serverType);
		ArrayList managedAggCompList = new ArrayList();
		if(managedAggComps != null && managedAggComps.length>0)
		{
			managedAggCompList.addAll(Arrays.asList(managedAggComps));
		}
		if(variables != null && variables.length>0)
		{
			Hashtable ht = new Hashtable();
			for(int c=0;c<variables.length; c++)
			{
				if(variables[c].startsWith(serverType+":") && variables[c].endsWith("#"+elementType+"#"+elementName))
				{
					String cue = variables[c].substring(0,variables[c].indexOf("#"));
					String displayName = cue.substring(cue.indexOf(":")+1);
					if(managedAggCompList.contains(cue))
					{
						ht.put(displayName.substring(0,displayName.indexOf(":")),cue);
					}
				}
			}
			rootJSON.put("aggCompLabel",mapping.getTextDescription("admin.server.Aggregate component"));
			JSONArray aggCTypesArr = new JSONArray();

			ArrayList nickList = new ArrayList(ht.keySet());
			Collections.sort(nickList,String.CASE_INSENSITIVE_ORDER);
			Iterator itr = nickList.iterator();
			while(itr.hasNext())
			{
				String displayName = (String)itr.next();
				String cue = (String) ht.get(displayName);
				JSONObject obj = new JSONObject();
				obj.put("actualValue",cue.substring(cue.indexOf(":")+1));
				obj.put("displayValue",displayName);
				aggCTypesArr.add(obj);
				if (cue.equals(aggComponent))
				{
					rootJSON.put("aggComponentTypeSelected",cue.substring(cue.indexOf(":")+1));
				}
			}
			rootJSON.put("aggComponentTypeList",aggCTypesArr);
			//rootJSON.put("hostname",strhostName);//Hidden
			//rootJSON.put("oldhostname",strhostName);//Hidden
			hiddens.put("hostname",strhostName);
			hiddens.put("oldhostname",strhostName);
		}
	}
	else
	{

		// Auto Topology (Begin)
			String readOnly = isCompStatusUnManage?"readonly onfocus=this.blur()":""; // If this comp. is unmanaged in the auto topology. D'nt allow to change nick
		// Auto Topology (End)
		if(!StringUtils.isNull(operation) && operation.equals("add"))
		{
			//rootJSON.put("oldhostname","");//Hidden
			hiddens.put("oldhostname","");
			rootJSON.put("hostname","");
		}
		else if( (moreServersInBox != null && moreServersInBox.equals("true")))
		{
			//rootJSON.put("oldhostname",s_host_name);//Hidden
			hiddens.put("oldhostname",s_host_name);
			rootJSON.put("nickNameValue",s_host_name);
			rootJSON.put("hostname",s_host_name);
		}
		else if(s_hostcheck != null && s_hostcheck.equals("true"))
		{
			//rootJSON.put("oldhostname",s_host_name);//Hidden
			hiddens.put("oldhostname",s_host_name);
			rootJSON.put("nickNameValue",s_host_name);
			rootJSON.put("hostname",s_host_name);
		}
		else if(hostname != null) //skm
		{
			//rootJSON.put("oldhostname",strhostName);//Hidden
			hiddens.put("oldhostname",strhostName);
			rootJSON.put("nickNameValue",hostname);
			rootJSON.put("hostname",hostname);
		}//skm
		else if (nick != null && nick.length() > 0 && server != null && server.equalsIgnoreCase("new"))//thirumal 2/14/2006
		{
			//rootJSON.put("oldhostname",nick);//Hidden
			hiddens.put("oldhostname",nick);
			rootJSON.put("nickNameValue",nick);
			rootJSON.put("hostname",nick);
		}
		else
		{
			//rootJSON.put("oldhostname",strhostName);//Hidden
			hiddens.put("oldhostname",strhostName);
			rootJSON.put("nickNameValue",strhostName);
			rootJSON.put("hostname",strhostName);
		}
	}
	noport = ArrayUtils.contains(noportservers, serverType);
	if(isValidServerType == false)
	{
		noport = true;
	}
	if(serverType.startsWith("Agg_"))
	{
		noport = true;
	}
	if(!noport)
	{
		rootJSON.put("portParam",true);
		if(server.equals("new"))
		{
			portNo = pno;
		}

		// Auto Topology (Begin)
		String portReadOnly="";
		if(isFromTopology)
		{
			portNo = portNoStr;
			if(isCompStatusUnManage)
				portReadOnly = " readonly onfocus=this.blur() ";
		}
		// Auto Topology (End)
		if(s_hostcheck != null && s_hostcheck.equals("true") && s_port_no != null && !s_port_no.equals(""))
		{
			initialPortNo = s_port_no;
			rootJSON.put("portValue",s_port_no);
		}
		else
		{
			initialPortNo = portNo;
			rootJSON.put("portValue",portNo);
		}
		//rootJSON.put("hportno",portNo);//Hidden
		//rootJSON.put("portnumber",initialPortNo);//Hidden
		hiddens.put("hportno",portNo);
		hiddens.put("portnumber",initialPortNo);
	}
	if(serverType.equals("Oracle_server") && server.equals("new")==false && oraSidFlag==1)
	{
		sid = sid.substring(0,sid.lastIndexOf(","));
	}
	else if(serverType.equals("Oracle_server") && server.equals("new"))
	{
		sid = "";
	}

	if(serverType.equals("Oracle_server"))
	{
		rootJSON.put("sidParam",true);
		if(s_ora_sid != null && !s_ora_sid.equals(""))
		{
			previousSID = s_ora_sid;
			rootJSON.put("sidValue",s_ora_sid);
		}
		else
		{
			previousSID = sid;
			rootJSON.put("sidValue",sid);
		}
		//rootJSON.put("hsid",sid);//Hidden
		hiddens.put("hsid",sid);
	}
	if(passiveServers.contains(serverType))
	{
		isPassiveValue = enablePassive.equalsIgnoreCase("checked")?"Yes":"No";
		rootJSON.put("isPassiveParam",true);
		rootJSON.put("isPassiveEnabled",enablePassive);
		rootJSON.put("isPassiveDisabled",disablePassive);
	}
	//To display radio button for enabling MTS //Modify server details
	//trans.createFile("eg_disable.ini");
	IniFile disableIniR = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
	String [] s_del_servers = disableIniR.getVariables("Deleted_Servers");
	if(!server.equals("new") && ((serverType.equals("IIS_web_server") || serverType.equals("IIS_ssl_server"))))
	{
		strMTS = discoverIni.getVariables("MTS_server");
		//Always use only HOSTNAME and not HOSTIP
		strname = strhostName;
		//trans.createSyncFile("eg_disable.ini","save");
		IniFile disableIniW = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_disable.ini");
		for(int k=0;k < s_del_servers.length;k++)
		{
			if(s_del_servers[k].equals("MTS_server:" + strname + ":NULL"))
			{
				//trans.createFile("eg_disable.ini","save");
				disableIniW.deleteValue("Deleted_Servers","MTS_server:" + strname + ":NULL");
				//trans.saveFile();
			}
		}
		disableIniW.saveFile();
		EgConfigFilesSync.releaseInstance(disableIniW);
		//Gets a list of MTS_server variables
		if(strMTS.length > 1)
		{
			for(int j=0; j<strMTS.length; j++)
			{
				if(strMTS[j].startsWith("Format:"))
				{
					continue;
				}
				if(strMTS[j].startsWith("#Unmanage|"))
				{
					check = false;
				}
				else
				{
					check = true;
				}
				if(check)
				{
					mtshostname = strMTS[j].substring(strMTS[j].indexOf(":") + 1,strMTS[j].lastIndexOf(":")); 
					if(strname.equals(mtshostname))
					{
						enablemts = "checked";
						disablemts = "";
						break;
					}
					else
					{
						enablemts = "";
						disablemts = "checked";
					}
				}
			}
		}
		//when there are no variables,disable MTS 
		else
		{
			disablemts = "checked";
		}
		//when check is false i.e when no managed MTS servers exist,MTS should be disabled	
		if(!check)
		{
			disablemts = "checked";
		}
		rootJSON.put("mts",true);
		rootJSON.put("mtsEnabled",enablemts);
		rootJSON.put("mtsDisabled",disablemts);
		//Clean up
		enablemts = "";
		disablemts = "";
	}
	else if((serverType.equals("IIS_web_server") || serverType.equals("IIS_ssl_server")) && (server.equals("new")))//Add new server details //Here, MTS should always be disabled
	{
		disablemts = "checked";

		if(s_hostcheck != null && s_hostcheck.equals("true"))
		{
			if(s_mts_check != null && s_mts_check.equals("Yes"))
			{
				enablemts = "checked";
				disablemts = "";
			}
			else if(s_mts_check != null && s_mts_check.equals("No"))
			{
				disablemts = "checked";
				enablemts="";
			}
		}

		rootJSON.put("mts",true);
		rootJSON.put("mtsEnabled",enablemts);
		rootJSON.put("mtsDisabled",disablemts);
		//Clean up
		disablemts = ""; 
	}
	//for vmware esx servers
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	String esxServerHost[] =externalInfo.getVirtualServerHosts();
	Vector v_virtualServres =externalInfo.getvmWareHosts();
	Vector virtualServers =externalInfo.getVirtualServers();
	Vector virtualdesktops =externalInfo.getVirtualDesktops();
	//karthika for cloud servers
	String cloudServerHost[] = externalInfo.getCloudServerHosts();
	Vector v_cloudServers = externalInfo.getCloudHosts();
	Vector cloudServers = externalInfo.getCloudServers();
	String underCloud =request.getParameter("underCloud");
	String cloudServer = request.getParameter("cloudServer");
	String cloudEnvCheckTrue="",cloudEnvCheckFalse="";
	if (cloudServer==null && !server.equals("new"))
	{
		//trans.createFile("eg_external.ini");
		if (sid!=null && sid.length()>0)
		{
			cloudServer=externalIni.getValue("Cloud_Components",serverType+":"+strhostName+":"+portNo+":"+sid);
		}
		else
		{
			cloudServer = externalIni.getValue("Cloud_Components", serverType+":"+strhostName+":"+portNo);
		}
	}
	else
	{
		String prevSelectedCloudServ = (String)session.getAttribute("prevSelectedCloudServ");
		if (prevSelectedCloudServ != null && prevSelectedCloudServ != "")
		{
			cloudServer = (cloudServer==null)?prevSelectedCloudServ:"-1";
		}
	}//cloud ends here 

	String underVmware =request.getParameter("underVmware");
	String esxServer = request.getParameter("esxServer");

	String vmwareEnvCheckTrue="",vmwareEnvCheckFalse="";
	if (esxServer==null && !server.equals("new"))
	{
		//trans.createFile("eg_external.ini");
		if (sid!=null && sid.length()>0)
		{
			esxServer=virCompIni.getValue("Virtual_Components",serverType+":"+strhostName+":"+portNo+":"+sid);
		}
		else
		{
			esxServer = virCompIni.getValue("Virtual_Components", serverType+":"+strhostName+":"+portNo);
		}
	}
	else
	{
		String prevSelectedVirtualHost = (String)session.getAttribute("prevSelectedVirtualHost");
		if (prevSelectedVirtualHost != null && prevSelectedVirtualHost != "")
		{
			esxServer = (esxServer==null)?prevSelectedVirtualHost:"-1";
		}
	}

	String checkyesno =esxServer;
	checkyesno = (checkyesno==null)?"":checkyesno;
	esxServer = (esxServer==null)?"-1":esxServer;
	if(underVmware==null)
	{
		if(server.equals("new"))
		{
			vmwareEnvCheckFalse="checked";
			vmwareEnvCheckTrue="";
		}
		else
		{
			if(checkyesno.equals(""))
			{
				vmwareEnvCheckFalse="checked";
				vmwareEnvCheckTrue="";
			}
			else
			{	
				vmwareEnvCheckFalse="";
				vmwareEnvCheckTrue="checked";
			}
		}
		
	}
	else if(underVmware.trim().equalsIgnoreCase("true"))
	{
		vmwareEnvCheckTrue = "checked";
		vmwareEnvCheckFalse = "";
	}
	else if(underVmware.trim().equalsIgnoreCase("false"))
	{
		vmwareEnvCheckFalse = "checked";
		vmwareEnvCheckTrue = "";
	}

	if(esxServerHost!=null && esxServerHost.length>0  && !virtualServers.contains(serverType) && !virtualdesktops.contains(serverType) && !allExternalTests && !externalInfo.isAutoVirtualMapping())
	{
		initVirtualEnv = vmwareEnvCheckTrue.equalsIgnoreCase("checked")?"Yes":"No";
		rootJSON.put("virtualEnv",true);
		rootJSON.put("virtualEnvEnabled",initVirtualEnv);
	}

	if(!externalInfo.isAutoVirtualMapping() && underVmware!=null && underVmware.equalsIgnoreCase("true") || (!server.equals("new") && vmwareEnvCheckTrue.equalsIgnoreCase("checked")&& !externalInfo.isAutoVirtualMapping()))
	{
		Vector v_virtualHosts=new Vector();
		JSONArray virServsArr = new JSONArray();
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("valueField","-1");
		tmpObj.put("displayField",mapping.getTextDescription("admin.server.Select virtual server Host"));
		virServsArr.add(tmpObj);
		for(int ii=0; ii<esxServerHost.length; ii++)
		{
			String virtualhost=esxServerHost[ii];
			virtualhost=virtualhost.substring(virtualhost.indexOf(":")+1);
			if(virtualhost.endsWith(":NULL"))
			{
				virtualhost = virtualhost.substring(0,virtualhost.indexOf(":NULL"));
				if (v_virtualHosts.contains(virtualhost))
					continue;
				v_virtualHosts.add(virtualhost);
			}
			JSONObject obj = new JSONObject();
			obj.put("valueField",esxServerHost[ii]);
			obj.put("displayField",virtualhost);
			virServsArr.add(obj);
			if (esxServer!=null && esxServer.equals((String)v_virtualServres.get(ii)))
			{
				initVirtualServer = (String)v_virtualServres.get(ii);				
			}			
		}
		rootJSON.put("virtualServers",virServsArr);
		rootJSON.put("virtualServerSelected",initVirtualServer);
	}
	//end

	// karthika for cloud component
	String checkyesnoForCloud =cloudServer;
	checkyesnoForCloud = (checkyesnoForCloud==null)?"":checkyesnoForCloud;
	cloudServer = (cloudServer==null)?"-1":cloudServer;
	if(underCloud==null)
	{
		if(server.equals("new"))
		{
			cloudEnvCheckFalse="checked";
			cloudEnvCheckTrue="";
		}
		else
		{
			if(checkyesnoForCloud.equals(""))
			{
				cloudEnvCheckFalse="checked";
				cloudEnvCheckTrue="";
			}
			else
			{	
				cloudEnvCheckFalse="";
				cloudEnvCheckTrue="checked";
			}
		}
		
	}
	else if(underCloud.trim().equalsIgnoreCase("true"))
	{
		cloudEnvCheckTrue = "checked";
		cloudEnvCheckFalse = "";
	}
	else if(underCloud.trim().equalsIgnoreCase("false"))
	{
		cloudEnvCheckFalse = "checked";
		cloudEnvCheckTrue = "";
	}
	if(cloudServerHost!=null && cloudServerHost.length>0  && !cloudServers.contains(serverType) && !allExternalTests && !externalInfo.isAutoCloudMapping())
	{
		initCloudEnv = cloudEnvCheckTrue.equalsIgnoreCase("checked")?"Yes":"No";
		rootJSON.put("cloudEnv",true);
		rootJSON.put("cloudEnvEnabled",initCloudEnv);
	}
	//karthika for cloud component
	if(!externalInfo.isAutoCloudMapping() && underCloud!=null && underCloud.equalsIgnoreCase("true") || (!server.equals("new") && cloudEnvCheckTrue.equalsIgnoreCase("checked")&& !externalInfo.isAutoCloudMapping()))
	{
		Vector v_cloudHosts=new Vector();
		JSONArray cluServsArr = new JSONArray();
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("valueField","-1");
		tmpObj.put("displayField",mapping.getTextDescription("admin.server.Select the cloud server"));
		cluServsArr.add(tmpObj);
		for(int ii=0; ii<cloudServerHost.length; ii++)
		{
			String cloudhost=cloudServerHost[ii];
			cloudhost=cloudhost.substring(cloudhost.indexOf(":")+1);
			if(cloudhost.endsWith(":NULL"))
			{
				cloudhost = cloudhost.substring(0,cloudhost.indexOf(":NULL"));
				if (v_cloudHosts.contains(cloudhost))
					continue;
				v_cloudHosts.add(cloudhost);
			}
			JSONObject obj = new JSONObject();
			obj.put("valueField",cloudServerHost[ii]);
			obj.put("displayField",cloudhost);
			cluServsArr.add(obj);
			if (cloudServer!=null && cloudServer.equals((String)v_cloudServers.get(ii)))
			{
				initCloudServer = (String)v_cloudServers.get(ii);				
			}			
		}
		rootJSON.put("cloudServerSelected",initCloudServer);
		rootJSON.put("cloudServers",cluServsArr);
	}// cloud ends here
	boolean isLocal = false;
	for(int arrLen=0; arrLen < remoteAgents.length; arrLen++)
	{
		if(s_host_name != null && s_host_name.equals(remoteAgents[arrLen]))
		{
			isLocal = true;
			break;
		}
		if(strhostName != null && strhostName.equals(remoteAgents[arrLen]))
		{
			isLocal = true;
			break;
		}
	}
	rootJSON.put("isLocal",isLocal);
	//trans.createFile("eg_external.ini");
	if(!isLocal)
	{
		String externalVals = null;
		if(s_host_name != null && !s_host_name.equals(""))
		{
			externalVals = externalIni.getValue("Agentless_Infos_Section", s_host_name);
		}
		else
		{
			externalVals = externalIni.getValue("Agentless_Infos_Section", strhostName);
		}

		StringTokenizer st_ext = new StringTokenizer(externalVals, ",");
		if(modifyserver != null && modifyserver.equals("true"))
		{
			if (enableRemoteAgent.equals(EgConstants.BLANK_STRING))
			{
				if(st_ext.countTokens() == 0)
				{
					enableRemoteAgent = "false";
				}
				else
				{
					enableRemoteAgent = "true";
				}
			}						
		}
		else if(st_ext.countTokens() > 0 && enableRemoteAgent.length() == 0)
			enableRemoteAgent = "true";
		else if(enableRemoteAgent.trim().equalsIgnoreCase("false"))
			enableRemoteAgent = "false";
		else if(enableRemoteAgent.trim().equalsIgnoreCase("true"))
			enableRemoteAgent = "true";
		else
		enableRemoteAgent = "false";
		if(st_ext.countTokens() >= 5) 
		{
			aluser = st_ext.nextToken();
			alpwd = st_ext.nextToken();
			almode = st_ext.nextToken();
			alos = st_ext.nextToken();
			sshPort = st_ext.nextToken();
			if (st_ext.hasMoreTokens())
			{
				alencrypt = st_ext.nextToken();
				alkeyfile = st_ext.nextToken();
			}
		}
		if(!server.equals("new"))
		{
			if(remoteAgents.length > 0)
				flag1 = true;
		}
		else if(server.equals("new"))
		{
			if(strhostName.length() == 0 && remoteAgents.length == 0)
			{
				flag1 = false;
			}
			else
			{
				flag1 = true;
			}
		}

		String s_remoteAgentCheckTrue ="",s_remoteAgentCheckFalse ="";
		if(flag && flag1 && !allExternalTests)
		{
			if(enableRemoteAgent.trim().equalsIgnoreCase("true"))
			{
				s_remoteAgentCheckTrue = "checked";
				s_remoteAgentCheckFalse = "";
			}
			else if(enableRemoteAgent.trim().equalsIgnoreCase("false"))
			{
				s_remoteAgentCheckFalse = "checked";
				s_remoteAgentCheckTrue = "";
			}
			else
			{
				if (flag1 && !server.equals("new"))
				{
					s_remoteAgentCheckTrue = "checked";
					enableRemoteAgent = "true";
					s_remoteAgentCheckFalse="";
				}
				else if(server.equals("new") && flag1)
				{
					s_remoteAgentCheckFalse="checked";
				}
			}
			if(!isAggregateType)
			{
				rootJSON.put("agentlessOption",true);
				String[] defaultAgentlessDetails = servicesInfo.getDefaultAgentlessServerDetails(serverType);
				if(agentlessServers != null && agentlessServers.contains(serverType))
				{
					rootJSON.put("agentlessElement","label");
					if(defaultAgentlessDetails != null && defaultAgentlessDetails.length >= 4 && from != null && from.equals("addnew"))
					{
						aluser = defaultAgentlessDetails[0];
						alpwd = defaultAgentlessDetails[1];
						alos = defaultAgentlessDetails[2];
						almode = defaultAgentlessDetails[3];
						if (defaultAgentlessDetails.length == 6)
						{
							if(almode != null && almode.equalsIgnoreCase("SSH"))
							{
								alencrypt = "Password";
							}
							else
							{
								alencrypt = defaultAgentlessDetails[4];
							}
							alkeyfile = defaultAgentlessDetails[5];
						}
					}
				}
				else
				{
					rootJSON.put("agentlessElement","radio");
					if(s_remoteAgentCheckTrue.equals("checked"))
					{
						agentlessflag="true";
						if(defaultAgentlessDetails != null && defaultAgentlessDetails.length >= 4 && defaultAgentlessServers != null && defaultAgentlessServers.contains(serverType) && from != null && from.equals("addnew"))
						{
							aluser = defaultAgentlessDetails[0];
							alpwd = defaultAgentlessDetails[1];
							alos = defaultAgentlessDetails[2];
							almode = defaultAgentlessDetails[3];
							if (defaultAgentlessDetails.length == 6)
							{
								if(almode != null && almode.equalsIgnoreCase("SSH"))
								{
									alencrypt = "Password";
								}
								else
								{
									alencrypt = defaultAgentlessDetails[4];
								}
								alkeyfile = defaultAgentlessDetails[5];
							}
						}
						rootJSON.put("agentlessEnabled",s_remoteAgentCheckTrue);
						rootJSON.put("agentlessDisbled",s_remoteAgentCheckFalse);
						//rootJSON.put("previousEnableRemoteAgent","true"); // Hidden
						hiddens.put("previousEnableRemoteAgent","true");
					}
					else
					{
						rootJSON.put("agentlessEnabled",s_remoteAgentCheckTrue);
						rootJSON.put("agentlessDisbled",s_remoteAgentCheckFalse);
						//rootJSON.put("previousEnableRemoteAgent","false"); // Hidden
						hiddens.put("previousEnableRemoteAgent","false");
					}
				}
			}
		}
		else
		{
			rootJSON.put("agentlessOption",false);
		}
		/*
		 * New code : Does the internal agent have to be assigned
		 * manually or automatically?
		 *
		 * The OR condition is required if remote agents are not configured.
		 */


		if(isValidServerType == false)
		{
			s_remoteAgentCheckFalse = "";
			s_remoteAgentCheckTrue = "checked";
		}

		agentMap = request.getParameter("agentmap");
		intAgentSelected = request.getParameter("intAgentSelected");
	
		if (s_remoteAgentCheckFalse.equalsIgnoreCase("checked") || s_remoteAgentCheckTrue.equals(EgConstants.BLANK_STRING))
		{
			String selectedCurrAgent = null;

			String intAgentAuto = null;
			String intAgentManual = null;

			if (agentMap == null)
			{
				if(s_hostcheck != null && s_hostcheck.equals("true"))
				{
					selectedCurrAgent = externalIni.getValue("Internal_Agent_Mapping", s_host_name);
				}
				else
				{
					selectedCurrAgent = externalIni.getValue("Internal_Agent_Mapping", strhostName.trim());
				}
				if (StringUtils.isNull(selectedCurrAgent))
				{
					agentMap = "auto";
				}
				else
				{
					agentMap = "manual";
				}
			}
			else
			{
				agentMap = agentMap.trim();
				if(intAgentSelected != null && !intAgentSelected.equals(""))
					selectedCurrAgent = intAgentSelected;
			}

			if (agentMap.equalsIgnoreCase("manual"))
			{
				intAgentManual = "checked";
				intAgentAuto = "";
			}
			else
			{
				intAgentManual = "";
				intAgentAuto = "checked";
			}

			IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_agents.ini");
			String[] currAgents = agentsIni.getSubjects();
			if (currAgents == null || currAgents.length == 0)
			{
				currAgents = new String[0];
			}
			else
			{
				ArrayList aListTemp = new ArrayList(Arrays.asList(currAgents));
				if (aListTemp.contains(s_host_name))
				{
					aListTemp.remove(s_host_name);
				}
				List agentList = new ArrayList();
				if(isLimitedAdmin)
				{
					ArrayList userTotalAgents = egRoleInfo.getTotalAgents();
					userTotalAgents.addAll(egRoleInfo.getRemoteAgents());
					userTotalAgents = egRoleInfo.removeDulpicates(userTotalAgents);
					aListTemp.retainAll(userTotalAgents);
				}
				currAgents = (String[])aListTemp.toArray(new String[0]);
				Arrays.sort(currAgents,String.CASE_INSENSITIVE_ORDER);
			}
			boolean discUniqueTargets = servicesInfo.getDiscUniqueTargets();

			boolean agentPerSystem = EgInstallInfo.isAgentPerSystemEnabled;
			boolean restrictServer = serverType.equalsIgnoreCase("AS400_server") ||serverType.equalsIgnoreCase("Netware_server") ||serverType.equalsIgnoreCase("Snmp_generic_server");
			if (currAgents.length > 0 && !discUniqueTargets && agentPerSystem && !allExternalTests && !restrictServer)
			{
				if (StringUtils.isNull(selectedCurrAgent))
				{
					if(s_hostcheck != null && s_hostcheck.equals("true"))
					{
						selectedCurrAgent = externalIni.getValue("Internal_Agentmapping", s_host_name);
					}
					else
					{
						selectedCurrAgent = externalIni.getValue("Internal_Agentmapping", strhostName);
					}
				}
				rootJSON.put("internalAgentOption",true);
				if (noport)
				{
					initialAgentAuto = (intAgentAuto.equalsIgnoreCase("checked")? "auto":"manual");
					rootJSON.put("intenalAgentNoPort",true);
					rootJSON.put("internalAgentAuto",intAgentAuto);
					rootJSON.put("internalAgentManual",intAgentManual);
				}
				else
				{
					initialAgentAuto = (intAgentAuto.equalsIgnoreCase("checked")? "auto":"manual");
					rootJSON.put("intenalAgentNoPort",false);
					rootJSON.put("internalAgentAuto",intAgentAuto);
					rootJSON.put("internalAgentManual",intAgentManual);
				}
				if (intAgentManual.equals("checked"))
				{
					JSONArray intAgnetsArr = new JSONArray();
					for (int c=0;c<currAgents.length;c++)
					{
						JSONObject obj = new JSONObject();
						obj.put("valueField",currAgents[c]);
						obj.put("displayField",currAgents[c]);
						intAgnetsArr.add(obj);
					}
					if(selectedCurrAgent.trim().equals(""))
					{
						selectedCurrAgent = currAgents[0];
					}
					rootJSON.put("internalAgents",intAgnetsArr);
					rootJSON.put("internalAgentSelected",selectedCurrAgent);
					//rootJSON.put("prevAgents",selectedCurrAgent); // Hidden
					hiddens.put("prevAgents",selectedCurrAgent); // Hidden
				}
			}
		}

		if(s_remoteAgentCheckTrue.equalsIgnoreCase("checked"))
		{
			if(aluser==null || aluser.equalsIgnoreCase("null") || aluser=="")
				aluser="None";
			if(alpwd==null || alpwd.equalsIgnoreCase("null") || alpwd=="")
				alpwd="None";
			if(alos==null || alos.equalsIgnoreCase("null") || alos == "")
				alos = "None";
			if(sshPort==null || sshPort.equalsIgnoreCase("null") || sshPort == "")
				sshPort = "22";
			if(almode==null || almode.equalsIgnoreCase("null") || almode == "")
				almode = "None";
			if(alencrypt==null || alencrypt.equalsIgnoreCase("null")|| alencrypt=="")
				alencrypt="Password";
			if(alkeyfile==null || alkeyfile.equalsIgnoreCase("null") || alkeyfile=="")
				alkeyfile="None";
		}
		if(!flag )//&& allExternalTests)
		{
			enableRemoteAgent = "false";
		}
		//priya

		if((remoteAgents.length > 0) && (enableRemoteAgent!= null && enableRemoteAgent.trim().equalsIgnoreCase("true")))
		{
			//IniFile externalIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
			String variables[] = externalIni.getVariables("Default_Operating_Systems");
			Vector values = externalIni.getAllValues("Default_Operating_Systems");
			String specificVars[] = externalIni.getVariables("Specific_Operating_Systems");
			List specificTypeList = new ArrayList(Arrays.asList(specificVars));

			String osValStr = "";
			String osNameStr ="";
			for(int index=0;index<variables.length;index++)
			{
				if(osValStr.length()==0)
				{
					osValStr = variables[index];
					osNameStr = (String) values.get(index);
				}
				else
				{
					osValStr += "," + variables[index];
					osNameStr += "," + (String) values.get(index);
				}
			}
			ArrayList tmpOSValList = new ArrayList();
			ArrayList tmpOSNameList = new ArrayList();
			ArrayList tmpModeOpList= new ArrayList();
			//String osValStr  = "None,aix,hpux,linux,solaris,tru64,w2k,2003,2008,nt,xp";
			//String osNameStr = "None,AIX,HP-UX,Linux,Solaris,Tru64,Windows 2000,Windows 2003,Windows 2008,Windows NT,Windows XP";
			String modeOpStr = "None,Perfmon,Rexec,SSH,SNMP,Web Service"; //web service for AWS_EC2_Cloud & AWS_EC2_Region components
			
			if (specificTypeList.contains(serverType))
			{
				String iniEntry = externalIni.getValue("Specific_Operating_Systems",serverType);
				osValStr += ","+iniEntry.substring(0,iniEntry.indexOf(":"));
				osNameStr += ","+iniEntry.substring(iniEntry.indexOf(":")+1);
			}
			modeOpStr += ",CLI,Other";
			osValStr += ",other";
			osNameStr += ",Other";
		
/*			
			if (serverType.equals("VmEsx_i_server") || serverType.equals("VmVdi_i_server"))
			{
				osValStr += ",vmware,other";
				osNameStr += ",VMware,Other";
				modeOpStr += ",Other";
			}else if (serverType.equals("Xen_virtual_server"))
			{
				osValStr += ",xen,other";
				osNameStr += ",Xen,Other";
				modeOpStr += ",Other";
			}
			else
			{
				osValStr += ",other";
				osNameStr += ",Other";
			}
*/
			StringTokenizer stt = new StringTokenizer(osValStr,",");
			while (stt.hasMoreTokens())
			{
				tmpOSValList.add(stt.nextToken());
			}
			stt = new StringTokenizer(osNameStr,",");
			while(stt.hasMoreTokens())
			{
				tmpOSNameList.add(stt.nextToken());
			}
			stt = new StringTokenizer(modeOpStr,",");
			while(stt.hasMoreTokens())
			{
				tmpModeOpList.add(stt.nextToken());
			}

			String[] osValues = (String[])tmpOSValList.toArray(new String[0]);
			String[] osNames = (String[])tmpOSNameList.toArray(new String[0]);
			String[] modeOptions = (String[])tmpModeOpList.toArray(new String[0]);
			String[] encryptOptions =  new String[] {"Password","Keybased"};

			/*
			 * Get remote agent mapping from eg_external.ini
			 */
			if (StringUtils.isNull(remoteAgent))
			{
				prevRemAgent = EgConstants.BLANK_STRING;
				if(s_hostcheck != null && s_hostcheck.equals("true"))
				{
					remoteAgent = extInfo.getRemoteAgentForHost(s_host_name);
				}
				else
				{
					remoteAgent = extInfo.getRemoteAgentForHost(strhostName);
				}
			}
			else
			{
				prevRemAgent = remoteAgent;
			}

			/*
			 * If the user wants to change the agentless monitoring information,
			 * older configuration has to be discarded and the newer configuration
			 * has to be considered
			 */
			String showFieldsForSsh = request.getParameter("showFieldsForSsh");
			if (showFieldsForSsh != null)
			{
				almode = request.getParameter("almode");
				alos = request.getParameter("alos");
				aluser = request.getParameter("aluser");
				alpwd = request.getParameter("alpwd");
				sshPort = request.getParameter("sshPort");
				alencrypt = request.getParameter("alencrypt");
				alkeyfile = request.getParameter("alkeyfile");
			}

			if(!isAggregateType)
			{
				JSONArray rmtOSArr = new JSONArray();
				for (int os=0;os < osValues.length; os++)
				{
					JSONObject obj = new JSONObject();
					obj.put("displayField",osNames[os]);
					obj.put("valueField",osValues[os]);
					rmtOSArr.add(obj);
				}
				rootJSON.put("rmtOSSelected",alos);
				rootJSON.put("rmtOS",rmtOSArr);
				//rootJSON.put("$_alos",alos);//Hidden
				hiddens.put("$_alos",alos);
				JSONArray rmtModeArr = new JSONArray();
				for (int m=0; m < modeOptions.length; m++)
				{
					JSONObject obj = new JSONObject();
					obj.put("valueField",modeOptions[m]);
					obj.put("displayField",mapping.getTextDescription("admin.server."+modeOptions[m]));
					rmtModeArr.add(obj);
				}

				rootJSON.put("rmtModeSelected",almode);
				rootJSON.put("rmtMode",rmtModeArr);
				//rootJSON.put("$_almode",almode); // Hidden
				hiddens.put("$_almode",almode);

			}
			rootJSON.put("rmtEncryptSelected",encryptOptions[0]);
			JSONArray encArr = new JSONArray();
			for (int i=0; i<encryptOptions.length; i++)
			{
				JSONObject obj = new JSONObject();
				obj.put("valueField",encryptOptions[i]);
				obj.put("displayField",mapping.getTextDescription("admin.server."+encryptOptions[i]));
				encArr.add(obj);
			}
			rootJSON.put("rmtEncryptOpts",encArr);
			if ((almode != null && almode.equals("SSH")) || (almode != null && almode.equals("Rexec")))
			{
				if (almode.equals("SSH"))
				{
					rootJSON.put("rmtEncryptionType",true);
					rootJSON.put("rmtEncryptSelected",alencrypt);
					hiddens.put("$_alencrypt",alencrypt);
				}
				if (alencrypt != null && alencrypt.equalsIgnoreCase("Keybased"))
				{
					rootJSON.put("rmtKeyFile",true);
					rootJSON.put("rmtKeyFileValue",alkeyfile);
					hiddens.put("$_alkeyfile",alkeyfile);
				}
				rootJSON.put("rmtPortOption",true);
				rootJSON.put("rmtPortValue",sshPort);
				rootJSON.put("rmtUser",true);
				rootJSON.put("rmtUserValue",aluser);
				rootJSON.put("rmtPwd",true);
				rootJSON.put("rmtPwdValue",EgCrypt.decrypt(alpwd));
				//rootJSON.put("$_sshPort",sshPort); // Hidden
				//rootJSON.put("$_aluser",aluser);   // Hidden
				//rootJSON.put("$_alpwd",EgCrypt.decrypt(alpwd)); // Hidden
				hiddens.put("$_sshPort",sshPort);
				hiddens.put("$_aluser",aluser);
				hiddens.put("$_alpwd",EgCrypt.decrypt(alpwd));
			}
			
			JSONArray rmtAgentsArr = new JSONArray();
			if (remoteAgent != null && remoteAgent.trim().length() ==0 && remoteAgents.length > 0)
			{
				remoteAgent = remoteAgents[0];
			}
			for (int r=0; r<remoteAgents.length; r++)
			{
				JSONObject obj = new JSONObject();
				obj.put("valueField",remoteAgents[r]);
				obj.put("displayField",remoteAgents[r]);
				rmtAgentsArr.add(obj);
			}
			hiddens.put("$_remoteAgent",remoteAgent);
			if(!isModify)
			{
				String prevSelectedRemAgent = (String) session.getAttribute("prevSelectedRemAgents");
				if(prevSelectedRemAgent != null && prevSelectedRemAgent.length() != 0)
				{
					List remoteList = Arrays.asList(remoteAgents);
					if (remoteList.contains(prevSelectedRemAgent))
					{
						remoteAgent = prevSelectedRemAgent;
					}
				}
			}
			rootJSON.put("remoteAgentsList",rmtAgentsArr);
			rootJSON.put("remoteAgentSelected",remoteAgent);
			//rootJSON.put("$_remoteAgent",remoteAgent); //Hidden
			
		}
		else
		{
			prevRemAgent = EgConstants.BLANK_STRING;
		}
	}

	String hostName = null;
	if (StringUtils.isNull(s_host_name))
	{
		hostName = strhostName;
	}
	else
	{
		hostName = s_host_name;
	}

	String prevExtAgent = externalIni.getValue("Test_Mapping_Section", hostName);
	if (prevExtAgent == null || prevExtAgent.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		prevExtAgent = EgConstants.BLANK_STRING;
	}
	EgExternalInfo e = new EgExternalInfo("manager");
	String[] eAgents = e.getAllExternalAgents();
	if (eAgents != null)
	{
		Arrays.sort(eAgents, String.CASE_INSENSITIVE_ORDER);
		List tmpList = new ArrayList();
		String defaultExtAgent = "";
		for (int j=0; j <eAgents.length;j++)
		{
			String tmpExtagent = eAgents[j];
			if (specsInfo.getEGServer().equals(tmpExtagent))
			{
				defaultExtAgent = tmpExtagent;
			}
			else
			{
				tmpList.add(tmpExtagent);
			}
		}
		if (!defaultExtAgent.equals(""))
		{
			tmpList.add(0,defaultExtAgent);
		}
		eAgents = (String[])tmpList.toArray(new String[0]);
	}

	if(prevExtAgent.length()==0 && eAgents.length > 0)
	{
		prevExtAgent = eAgents[0];
	}
	String selectedExtAgent = null;
	if (StringUtils.isNull(prevExtAgent))
	{
		if (StringUtils.isNull(defExtAgent))
		{
			selectedExtAgent = eAgents[0];
		}
		else
		{
			/*
			 * Get the default external agent as specified in eg_specs.ini
			 */
			selectedExtAgent = defExtAgent;
		}
	}
	else
	{
		selectedExtAgent = prevExtAgent;
	}

	String[] allSelExtAgents = StringUtils.getTokens(selectedExtAgent, EgConstants.COMMA);
	if(!isModify)
	{
		String prevSelectedExtAgent = (String) session.getAttribute("prevSelectedExtAgents");
		String[] prevSelExtAgents = StringUtils.getTokens(prevSelectedExtAgent,EgConstants.COMMA);
		if(prevSelExtAgents != null && prevSelExtAgents.length != 0)
		{
			allSelExtAgents = prevSelExtAgents;
		}
	}
	session.setAttribute("selectedExtAgent",selectedExtAgent);
	String multipleStr = "multiple";
	if(isAggregateType)
		multipleStr = "";
	if(!isAggregateType)
	{
		rootJSON.put("externalAgentsOption",true);
		String selectedAgent =  "";
		if(!tmpExtAgentPopulated)
		{
			JSONArray extAgentsArr = new JSONArray();
			JSONArray extAgentsSelArr = new JSONArray();
			for (int a=0; a<extAgents.length; a++)
			{
				JSONObject obj = new JSONObject();
				obj.put("displayField",extAgents[a]);
				obj.put("valueField",extAgents[a]);				
				extAgentsArr.add(obj);
				if (ArrayUtils.contains(allSelExtAgents, extAgents[a]))
				{
					selectedAgent = extAgents[a];
					extAgentsSelArr.add(selectedAgent);
				}				
			}
			if (extAgentsSelArr.size() == 0)
			{
				ArrayList extAgentsList = new ArrayList(Arrays.asList(extAgents));
				if (extAgentsList.contains(defExtAgent))
				{
					extAgentsSelArr.add(defExtAgent);
				}
				else
				{
					extAgentsSelArr.add(extAgents[0]);
				}
			}
			rootJSON.put("externalAgents",extAgentsArr);
			rootJSON.put("externalAgentsSelected",extAgentsSelArr);
		}
		else //skm
		{
			JSONArray extAgentsArr = new JSONArray();
			JSONArray extAgentsSelArr = new JSONArray();
			for(int i=0;i<extAgents.length;i++)
			{
				JSONObject obj = new JSONObject();
				obj.put("displayField",extAgents[i]);
				obj.put("valueField",extAgents[i]);				
				extAgentsArr.add(obj);
				if(tmpExtAgents[i].equals("selected"))
				{
					extAgentsSelArr.add(extAgents[i]);
				}
			}
			rootJSON.put("externalAgents",extAgentsArr);
			rootJSON.put("externalAgentsSelected",extAgentsSelArr);
		}//skm

	}
		
	String serverval="";
	String agentlessServer="false";
	if(agentlessServers != null && agentlessServers.contains(serverType))
	{
		agentlessServer = "true";
	}
	if(server.equals("new"))
	{
		serverval="new";
		rootJSON.put("addButton",true);
	}
	else
	{
		serverval="old";
		rootJSON.put("updateButton",true);
	}

	//Hidden - starts
	//rootJSON.put("previous",""); //Empty hidden 
//	rootJSON.put("serval",serverval);
//	rootJSON.put("strPass",varPass);
//	rootJSON.put("sidFlag",oraSidFlag);
//	rootJSON.put("flag",noport);
//	rootJSON.put("server",server);
//	rootJSON.put("prevExtAgents",prevExtAgent);
//	rootJSON.put("prevRemAgent",prevRemAgent);
//	rootJSON.put("allExtAgents",StringUtils.getArrayAsString(extAgents));
//	rootJSON.put("allRemAgents",StringUtils.getArrayAsString(remoteAgents));
//	rootJSON.put("intAgentSelected",intAgentSelected);
//	rootJSON.put("agentmap",agentMap);
//	rootJSON.put("vmwarehostentry","NULL");
//	rootJSON.put("remoteAgent1",remoteAgent);
//	rootJSON.put("moreServersInBox",moreServersInBox);
//	rootJSON.put("agflag",agentlessflag);
//	rootJSON.put("serverType",serverType);
//	rootJSON.put("comps_associated_client",temp_str_comp);
//	rootJSON.put("isAggregateType",isAggregateType);
	hiddens.put("serval",serverval);
	hiddens.put("strPass",varPass);
	hiddens.put("sidFlag",oraSidFlag);
	hiddens.put("flag",noport);
	hiddens.put("server",server);
	hiddens.put("prevExtAgents",prevExtAgent);
	hiddens.put("prevRemAgent",prevRemAgent);
	hiddens.put("allExtAgents",StringUtils.getArrayAsString(extAgents));
	hiddens.put("allRemAgents",StringUtils.getArrayAsString(remoteAgents));
	hiddens.put("intAgentSelected",intAgentSelected);
	//hiddens.put("agentmap",agentMap);
	hiddens.put("vmwarehostentry","NULL");
	hiddens.put("remoteAgent1",remoteAgent);
	hiddens.put("moreServersInBox",moreServersInBox);
	hiddens.put("agflag",agentlessflag);
	hiddens.put("serverType",serverType);
	hiddens.put("comps_associated_client",temp_str_comp);
	hiddens.put("isAggregateType",isAggregateType);
			
	String olderhostname = request.getParameter("olderhostname");
	if(olderhostname != null && !olderhostname.equalsIgnoreCase("null"))
	{
		hiddens.put("olderhostname",olderhostname);
	}

	String olderOSName = request.getParameter("olderosname");
	if(olderOSName == null || olderOSName.equalsIgnoreCase("null"))
		olderOSName = alos;
	hiddens.put("olderosname",olderOSName);

	String olderModeName = request.getParameter("oldermodename");
	if(olderModeName == null || olderModeName.equalsIgnoreCase("null"))
		olderModeName = almode;
	hiddens.put("oldermodename",olderModeName);

	String olderRemoteAgentName = request.getParameter("olderremoteagentname");
	if(olderRemoteAgentName == null || olderRemoteAgentName.equalsIgnoreCase("null"))
		olderRemoteAgentName = remoteAgent;
	hiddens.put("olderremoteagentname",olderRemoteAgentName);
	
	String previousIntAgentMode = "";//request.getParameter("previousintagentmode");
	Hashtable intAgentMap = extInfo.getInternalAgentMap();
	String intAgent = (String)intAgentMap.get(strhostName);
	if(intAgent == null) //|| previousIntAgentMode.equalsIgnoreCase("null"))
		previousIntAgentMode = "auto";
	else
		previousIntAgentMode = "manual";
	hiddens.put("previousintagentmode",previousIntAgentMode);
	hiddens.put("previousIntAgent",intAgent);

	String previousPortNumber = request.getParameter("previousportnumber");
	if(previousPortNumber == null || previousPortNumber.equalsIgnoreCase("null"))
		previousPortNumber = initialPortNo;
	hiddens.put("previousportnumber",previousPortNumber);

	String previousSIDValue = request.getParameter("previoussid");
	if(previousSIDValue == null || previousSIDValue.equalsIgnoreCase("null"))
		previousSIDValue = previousSID;
	hiddens.put("previoussid",previousSIDValue);

	String previousIsPassive = request.getParameter("previousispassive");
	if(previousIsPassive == null || previousIsPassive.equalsIgnoreCase("null"))
		previousIsPassive = isPassiveValue;
	hiddens.put("previousispassive",previousIsPassive);

	String previousVirtualEnv = request.getParameter("previousvirtualenvironment");
	if(previousVirtualEnv == null || previousVirtualEnv.equalsIgnoreCase("null"))
		previousVirtualEnv = initVirtualEnv;
	hiddens.put("previousvirtualenvironment",previousVirtualEnv);


	String previousCloudEnv = request.getParameter("previouscloudenvironment");
	if(previousCloudEnv == null || previousCloudEnv.equalsIgnoreCase("null"))
		previousCloudEnv = initCloudEnv;
	hiddens.put("previouscloudenvironment",previousCloudEnv);

	String previousVirtualServer = request.getParameter("previousvirtualserver");
	if(previousVirtualServer == null || previousVirtualServer.equalsIgnoreCase("null"))
		previousVirtualServer = initVirtualServer;
	hiddens.put("previousvirtualserver",previousVirtualServer);

	String previousCloudServer = request.getParameter("previouscloudserver");
	if(previousCloudServer == null || previousCloudServer.equalsIgnoreCase("null"))
		previousCloudServer = initCloudServer;
	hiddens.put("previouscloudserver",previousCloudServer);

	String previousEncryptionType = request.getParameter("previousencryptiontype");
	if(previousEncryptionType == null || previousEncryptionType.equalsIgnoreCase("null"))
		previousEncryptionType = alencrypt;
	hiddens.put("previousencryptiontype",previousEncryptionType);

	String previousAlkeyFile = request.getParameter("previousalkeyfile");
	if(previousAlkeyFile == null || previousAlkeyFile.equalsIgnoreCase("null"))
		previousAlkeyFile = alkeyfile;
	hiddens.put("previousalkeyfile",previousAlkeyFile);

	String tempo = request.getParameter("oldenableRemoteAgent");
	if(tempo ==null || tempo.equalsIgnoreCase("null"))
	{
		hiddens.put("oldenableRemoteAgent",agentlessflag);
	}
	else
	{
		hiddens.put("oldenableRemoteAgent",tempo);
	}

	if(modifyserver != null && !modifyserver.equals("true"))
	{
		modifyserver = "false";
	}
	hiddens.put("modifyserver",modifyserver);
	//Hidden - ends
	rootJSON.put("hiddenVals",hiddens);
	out.println(rootJSON.toString());
%>
<%
//	if(!isAggregateLink)
//	{
//		if(request.getQueryString()!=null)
//		{
//			session.setAttribute("adminLastAccessedURL","/final/admin/EgNewServer.jsp?"+request.getQueryString()+"&showtree=discoverytree");
//		}
//		else
//		{
//			session.setAttribute("adminLastAccessedURL","/final/admin/EgNewServer.jsp?showtree=discoverytree");
//		}
//	}
%>


<%!
	public ArrayList tempServers = new ArrayList();
	public ServerBean serverBean = new ServerBean();
	public ArrayList getAllServerGroups()
	{
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				grp.add(Subjects[i]);
			}
			ArrayList icTypes = getAllUserDefinedServers();
			if (com.eg.EgMemInfo.icEnabled && icTypes != null && icTypes.size()>0)
			{
				grp.add("CUSTOM COMPONENTS");
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			ArrayList otherServers = getOtherServers();
			if (otherServers.size() > 0)
			{
				grp.add("OTHERS");
			}
			grp.remove("AGGREGATES");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}

	private ArrayList removeAggServers(ArrayList serverList)
	{
		ArrayList tmpList = new ArrayList();
		for(int i=0; i<serverList.size(); i++)
		{
			EgName nameObj1 = (EgName)serverList.get(i);
			String tmpVal = nameObj1.getActualName();
			String tmpDis = nameObj1.getLocalName();
			if(tmpVal.startsWith("Agg_"))
			{
				continue;
			}
			tmpList.add(serverList.get(i));
		}

		return tmpList;
	}
	public ArrayList getOtherServers()
	{
		getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}
		for(int i=0; i<otherServers.length; i++)
		{
			if (!otherServers[i].equals("Site_servers") && !otherServers[i].toLowerCase().endsWith("_ex"))
			{
				if (!tempServers.contains(otherServers[i]))
				{
					serverList.add(otherServers[i]);
				}
			}
		}
		return serverList;
	}
	public void getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
	}
	public ArrayList getAllUserDefinedServers()
	{
		Map serverList = new HashMap();
		Hashtable allSrvMap = serverBean.getAllServerMap();
		ArrayList udServers = (ArrayList)allSrvMap.get("UDSERVERS");	//userdefined servers
		if(udServers != null && udServers.size()>0)
		{
			for(int i=udServers.size()-1;i>=0;i--)
			{
				String ud_server = (String)udServers.get(i);
				if(udServers.get(i).toString().startsWith("Agg_"))
				{
					udServers.remove(i);
				}
			}
		}
		return udServers;
	}
	public ArrayList getCategorizedComponents(String compGroup)
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();

			String [] variables = iniFile.getVariables(compGroup);
			for (int j = 0;j<variables.length;j++)
			{
				comGroups.add(variables[j]);
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		return comGroups;
	}
	public ArrayList nonUsersAgentList(String userID, String agentType)
	{
		ArrayList agentList = new ArrayList();
		if (userID != null && !userID.equals(""))
		{
			String sectionName = (agentType != null && agentType.equalsIgnoreCase("external")) ? "Test_Mapping_Section" : "Remote_Agent_Mapping_Section";
			String extIniFile = EgConfigInfo.egMgrConfigDir + "eg_external.ini";
			IniFile extIniObj = new IniFile(extIniFile);	
			ArrayList compMapList = getUserCompsNick(userID);
			if (compMapList != null)
			{
				int compListLen = compMapList.size();
				for(int i=0; i<compListLen; i++)
				{
					String tempTestMapVal = extIniObj.getValue(sectionName,compMapList.get(i).toString());
					if(tempTestMapVal != null && tempTestMapVal.length()>0)
					{
						ArrayList tempList = StringUtils.egTokenizer(tempTestMapVal, ",", false, true, true);
						agentList.addAll(tempList);
					}
				}
			}
		}
		return agentList;
	}
	
	public ArrayList getUserCompsNick(String userID)
	{
		ErUserData erUser = new ErUserData(userID,false);
		ArrayList compMapNickList = new ArrayList(erUser.getAllUserComponents(1));
		ArrayList resultList = new ArrayList();
		if(compMapNickList != null)
		{
			int compListLen = compMapNickList.size();
			for (int x=0; x<compListLen; x++)
			{
				String tempCompMapVal = compMapNickList.get(x).toString();
				tempCompMapVal = tempCompMapVal.substring(0,tempCompMapVal.indexOf(":"));
				resultList.add(tempCompMapVal);
			}
		}
		return resultList;
	}
%>