<%
/*****************************************************************************
*  File			: 	EgFileUpload.jsp
*  Purpose		: 	Uploading files to server
*  Version		: 	1.0
*  Creation Date: 	03/02/2005
*
*  Author		: 	Solomon.S, Murugapandian R
******************************************************************************/
%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.util.multipart.*" %>
<%@ page import="javax.servlet.*" %>
<%@ page import="javax.servlet.http.*" %>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%!
	//Stack page(EgStack.jsp) file uploading...(Start)
	public String installDir = EgInstallInfo.getInstallDir();
	String mgrFlag = "";
	ArrayList uploadedFilesList = null;
	String fileInUse = "";

	//this redirect() method shows the uploaded file information in UI
	public void redirect(PrintWriter pw, HttpServletRequest request)
	{
		HttpSession session = request.getSession();
		String sessionid = session.getId();
		User user=null;
		String adminSkin=null;
		try
		{
			user = UserRegistry.getInstance().getUser(sessionid);
			adminSkin = user.getAdminSkin();
		}
		catch(Exception e)
		{
			adminSkin ="blue";
		}
		pw.println("<html><head><title>Files Uploaded</title><link rel='stylesheet' href='/final/admin/eg_styles/adminstyle_"+adminSkin+".css' />");
		pw.println("<script type=\"text/javascript\">");
		if(mgrFlag != null && mgrFlag.equals("true"))
			pw.println("function myfunction() { window.close();}");
		else if(mgrFlag != null && mgrFlag.equals("startDiscovery"))
		{
			pw.println("function myfunction() { window.opener.startDiscovery('2'); window.close();}");
		}
		else
		{
			pw.println("function myfunction() { window.close(); window.open(\"/final/misc/EgStack.jsp?whoami=egurkha&pwd=admin&fromToolKit=fromToolKit&from=file&xml="+fileInUse+"\",\"oldwin\"); }");
		}
		pw.println("</script></head>");
		pw.println("<body leftmargin='10' topmargin='10' marginwidth='0' marginheight='0' class='body_text'>");
		pw.println("<form name='fileupload'>");
		pw.println("<center><br><br><font face='verdana' size='1'><b>Request has been processed successfully</b>.</font><br><br>");
			pw.println("<input type='button' name='closewin' class='eg_back' value='Close' style='width: 80px;' onClick='javascript:myfunction()'>");
		pw.println("</center></form></body></html>");
	}

	//this uploadFile() method for reading and writing of a file into specified directory
	public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		Hashtable ht_parampart=new Hashtable();
		Hashtable ht_filepart=new Hashtable();
		PrintWriter out=response.getWriter();
		String fileName="";
		String fileSep = System.getProperty("file.separator");

		try
		{
			MultipartParser mp = new MultipartParser(request, 10*1024*1024); // 10MB
			com.egurkha.util.multipart.Part part;
			String folder="";
			
			while ((part = mp.readNextPart()) != null)
			{
				String name = part.getName();
				if (part.isParam())
				{
					ParamPart paramPart=(ParamPart)part;
					ht_parampart.put(name,paramPart.getStringValue());
				}
				else if (part.isFile())
				{
					FilePart filePart=(FilePart)part;
					ht_parampart.put("#"+name, name);
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					filePart.writeTo(baos);
					byte[] fileContent = baos.toByteArray();
					baos.close();
					if(fileContent.length>0)
					{
						ht_parampart.put(name+"_name", filePart.getFileName());
						ht_filepart.put(name, fileContent);
					}
				}
			}

			Iterator itr = ht_filepart.keySet().iterator();
			byte[] thisFileContent=null;
			String s_dstFile="";
			while(itr.hasNext())
			{
				String key = (String)itr.next();
				fileName=(String)ht_parampart.get(key+"_name");
				s_dstFile = ((String)ht_parampart.get(key + "_dstFile"));
				thisFileContent = (byte[])ht_filepart.get(key);
				File thisFile=null;
				if(s_dstFile==null)
				{
					thisFile=new File(installDir+"/tmp/"+fileName);
				}else
				{
					File targetFile = new File(installDir+"/"+s_dstFile);
	
					if (targetFile.isDirectory())
					{
						thisFile=new File(installDir+"/"+s_dstFile+"/"+fileName);
					}else
					{
						thisFile=new File(installDir+"/"+s_dstFile);
					}
				}

				if (thisFile != null)
				{
					String strFilePath = thisFile.getPath();
					if (strFilePath.indexOf(".."+fileSep) != -1)
					{
						fileName = "";
						break;
					}
					else if (!strFilePath.startsWith(installDir+fileSep+"tmp"+fileSep))
					{
						fileName = "";
						break;
					}
				}

				FileOutputStream fos = new FileOutputStream(thisFile);
				fos.write(thisFileContent);
				fos.close();
			}
			if(EgInstallInfo.isClusterSupported)
			{
				//If clustering is supported inform other managers about the new Image.
				UploadCustomImage customImage = new UploadCustomImage();
				customImage.getCustomImage(s_dstFile,thisFileContent);
				customImage = null;
			}
			fileInUse = fileName;

			//this.redirect(out,request);
		}
		catch (IOException lEx)
		{
			this.getServletContext().log(lEx, "error reading or saving file");
			lEx.printStackTrace();
		}catch (Exception e)
		{
			e.printStackTrace();
		}
	}
%>

<%
	JSONObject labels = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
	JSONObject jsonobj = new JSONObject();
	jsonobj.put("success","true");

	/* Store the uploaded files information into eg_udtests.ini file ... Start*/
	mgrFlag=request.getParameter("mgrLog");
	String test=request.getParameter("test");
	String mbeanFile=request.getParameter("mbeanFile");
	if(mbeanFile != null && mbeanFile.length() > 0 && test != null)
	{
		IniFile egUDTestFile = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_udtests.ini");
		String val = egUDTestFile.getValue("UPLOADED_FILES",test);
		ArrayList tokList = new ArrayList();
		if(val != null && val.length() > 0)
		{
			StringTokenizer str= new StringTokenizer(val,",");
			while(str.hasMoreTokens())
			{
				String tok = str.nextToken();
				tokList.add(tok);
			}
			if(!tokList.contains(mbeanFile))
				val = val+","+mbeanFile;
		}
		else
			val = mbeanFile;

		egUDTestFile.setValue("UPLOADED_FILES",test,val);
		egUDTestFile.saveFile();
		EgConfigFilesSync.releaseInstance(egUDTestFile);
	}
	/* Store the uploaded files information into eg_udtests.ini file ... Eng*/

	String fileToUpload=request.getParameter("fileUpload");
	if(fileToUpload != null && fileToUpload.equals("yes"))
	{
		uploadFile(request, response);
		jsonobj.put("uploadStatus",true);
		jsonobj.put("fileInUse",fileInUse);
		jsonobj.put("mgrFlag",mgrFlag);
		response.getWriter().write(jsonobj.toString());
		return;
	}
	//Stack page(EgStack.jsp) file uploading...(End)

	String windowTitle=request.getParameter("title");
	if(windowTitle==null)
		windowTitle="File Upload";
	String captions=request.getParameter("dispCaption");
	String uploadfiles=request.getParameter("uploadDir");
	String fileExt=request.getParameter("fileExt");
	StringUtils stringutil=new StringUtils();
	String [] caption_array=stringutil.getTokens(captions, ":");
	String [] file_array=stringutil.getTokens(uploadfiles, ":");
	int captions_length=caption_array.length;
	int uploadfiles_length=file_array.length;

	//Only for upload logo and alert sound settings (EgConfigLogoMsg.jsp) starts - Anand
	String fromPage = request.getParameter("requestFrom");
	String from=request.getParameter("from");
	from=(from==null)?"":from;
	String uploadFor = request.getParameter("uploadFor");
	fromPage = (fromPage != null)?fromPage:"";
	uploadFor = (uploadFor != null)?uploadFor:"";
	EgDbInfo egdbInfo=new EgDbInfo("manager");
	boolean isDouble=egdbInfo.isDoubleByteEnabled();
	File ff = new File(installDir+"/tmp");
	File []fileList = ff.listFiles();
	uploadedFilesList = new ArrayList();
	String uploadFilesStr = "";
	for(int x=0;x<fileList.length;x++)
	{
		if(fileList[x].isFile())
		{
			String name = fileList[x].getName();
			uploadedFilesList.add(name);
			uploadFilesStr += name+",";
		}
	}
	if (uploadFilesStr.endsWith(","))
	{
		uploadFilesStr = uploadFilesStr.substring(0,uploadFilesStr.length()-1);
	}
	jsonobj.put("caption_array", caption_array);
	jsonobj.put("uploadedFilesList", uploadedFilesList);
	jsonobj.put("uploadedFilesString", uploadFilesStr);
	jsonobj.put("test", test);
	jsonobj.put("installDir", installDir);
	jsonobj.put("isDouble", isDouble);
	labels.put("admin.logo.Files to be uploaded", _mapping.getTextDescription("admin.logo.Files to be uploaded"));
	int ctrl = 0;
	for (ctrl = 0; ctrl < caption_array.length; ctrl++)
	{
		String adminLogo="admin.logo.";
		jsonobj.put("adminLogo", adminLogo + caption_array[ctrl]);
		if (ctrl < uploadfiles_length)
		{
			hiddenParams.put("FILE_0_dstFile", file_array[ctrl]);
		}
		String addlogo = (from.equals("addlogo") ? "accept=image/gif" : "");
		jsonobj.put("FILE", addlogo);
	}
	if(from.equals("addlogo"))
	{
		String resolution=uploadFor.equals("login")?"200x100":"120x40";
		int size=uploadFor.equals("login")?15:10;
		labels.put("admin.common.Specifications", _mapping.getTextDescription("admin.common.Specifications"));
		labels.put("admin.common.Type", _mapping.getTextDescription("admin.common.Type"));
		labels.put("admin.common.GIF", _mapping.getTextDescription("admin.common.GIF"));
		labels.put("admin.common.Size", _mapping.getTextDescription("admin.common.Size"));
		jsonobj.put("size", size);
		labels.put("admin.common.Resolution", _mapping.getTextDescription("admin.common.Resolution"));
		jsonobj.put("resolution", resolution);
		labels.put("admin.common.pixels", _mapping.getTextDescription("admin.common.pixels"));
		jsonobj.put("labels", labels);
		jsonobj.put("hiddenParams", hiddenParams);		
	}
	response.getWriter().write(jsonobj.toString());
%>
