<%
/*******************************************************************************
*	Name            :       LockedAccountsJSON.jsp
*	Purpose         :       Display Locked Accounts
*******************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	JSONArray groupArr = new JSONArray();
	JSONObject groupObj = new JSONObject();
	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniFile lck_read = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_acclock.ini");
	String lockoutStrategy = lck_read.getValue("ALS","AL");
	String[] userVars = lck_read.getVariables("ALU");
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr!=null && egTitleSearchStr!="");
	ArrayList searchList = new ArrayList();
	int count = 0;
	if (lockoutStrategy.equalsIgnoreCase("yes") || lockoutStrategy.equalsIgnoreCase("true") )
	{
		if(userVars.length > 0)
		{
			for(int i=0;i<userVars.length;i++)
			{
				String userVals = lck_read.getValue("ALU",userVars[i]);
				userVals = EgCrypt.decrypt(userVals);
				String lock_status = userVals.substring(userVals.indexOf('|')+1,userVals.lastIndexOf('|'));
				if (lock_status.equalsIgnoreCase("L"))
				{
					count++;
				}
			}
		}
		if (isSearchResult)
		{
			StringTokenizer st = new StringTokenizer(egTitleSearchStr);
			while (st.hasMoreTokens())
			{
				String thisToken = st.nextToken().trim();
				if (thisToken.equals(""))
					continue;
				searchList.add(thisToken);
			}
		}
	}

	session.setAttribute("egPageDesc","EgLockedAccounts.jsp");
	
	EgUserRole userRole = _user.getUserRole();
	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
	
	IniFile ServicesIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String eGMgrModel = ServicesIni.getValue("MISC_ARGS","eGMgrModel");

	EgUuidInfo egUuidInfo = new EgUuidInfo();

	Vector orgSpecificUserList = new Vector();
	if(!hasAllComponentAccess)
	{
		String sess_userid = (String)session.getAttribute("sess_userid");
		String orgname = "";
		boolean isSuperOrg = egUuidInfo.isSuperOrg(sess_userid);
		boolean isOrg = egUuidInfo.isOrg(sess_userid);
		if (isSuperOrg)
		{
			orgname = sess_userid;
		}
		else if (isOrg)
		{
			orgname = sess_userid;
		}
		else
		{
			orgname = egUuidInfo.getDirectDependentOU(sess_userid);
		}
		orgSpecificUserList.addAll(egUuidInfo.getAllUsersUnderOrg(orgname));
	}
	else
	{
		if (eGMgrModel != null && eGMgrModel.equalsIgnoreCase("enterprise"))
		{
			orgSpecificUserList.addAll(egUuidInfo.getAllUsersUnderOrg("egenterprise"));
		}
	}

	// converting username list to lowercase
	Vector orgSpecificUserVec = new Vector();
	int specUserSize = orgSpecificUserList.size();
	for (int x=0; x<specUserSize; x++)
	{
		String orgUserName = (String) orgSpecificUserList.get(x);
		orgSpecificUserVec.add(orgUserName.toLowerCase());
	}

	String lastvalue="";
	Vector searchVec=new Vector();
	if(count > 0)
	{
		boolean searchItemFound = false;
		String thisGroup="";
		for(int i=0;i<userVars.length;i++)
		{
			String userVals = lck_read.getValue("ALU",userVars[i]);
			userVals = EgCrypt.decrypt(userVals);
			String lock_status = userVals.substring(userVals.indexOf('|')+1,userVals.lastIndexOf('|'));
			if(lock_status.equalsIgnoreCase("L"))
			{
				thisGroup = EgCrypt.decrypt(userVars[i]);
			}
			else
			{
				continue;
			}
			if(isSearchResult && !doesExist(searchList, thisGroup))
			{
				continue;
			}
			else
			{
				searchVec.add(thisGroup);
			}
			searchItemFound=true;
		}
		int x=searchVec.size();
		if(x!=0)
		{
			lastvalue=(String)searchVec.get(x-1);
		}
		if(searchVec.size()!=0)
		{
			screenLabels.put("SelectAll",_mapping.getTextDescription("admin.common.Select all"));
			screenLabels.put("DeSelectAll",_mapping.getTextDescription("admin.common.Deselect all"));
			screenLabels.put("DeleteSelected",_mapping.getTextDescription("admin.common.Delete selected"));
		}
		List resultList = new ArrayList();
		for(int i=0;i<userVars.length;i++)
		{
			String userVals = lck_read.getValue("ALU",userVars[i]);
			userVals = EgCrypt.decrypt(userVals);
			String lock_status = userVals.substring(userVals.indexOf('|')+1,userVals.lastIndexOf('|'));
			if(lock_status.equalsIgnoreCase("L"))
			{
				thisGroup = EgCrypt.decrypt(userVars[i]);
			}
			else
			{
				continue;
			}
			resultList.add(thisGroup);
		}
		Collections.sort(resultList,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<resultList.size();i++)
		{
			thisGroup = (String) resultList.get(i);
			if(!hasAllComponentAccess)
			{
				if (!orgSpecificUserVec.contains(thisGroup))
				{
					continue;
				}
			}
			else
			{
				if (eGMgrModel != null && eGMgrModel.equalsIgnoreCase("enterprise") && !orgSpecificUserVec.contains(thisGroup))
				{
					continue;
				}
			}
			if (isSearchResult && !doesExist(searchList,thisGroup))
			{
				continue;
			}
			searchItemFound=true;
			groupObj.put("Username",thisGroup);
			groupArr.add(groupObj);

			screenLabels.put("deleteConfirmMessage",_mapping.getTextDescription("admin.group.Are you sure you want to unlock the selected users(s)?"));
		}
		if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
		{
			screenLabels.put("searchResult",_mapping.getTextDescription("admin.group.No locked accounts found for your search")+".");
			screenLabels.put("searchKey",egTitleSearchStr);
		}
		rootJson.put("NoExtFound","false");
	}
	else
	{
		screenLabels.put("noGroup",_mapping.getTextDescription("admin.group.There are no locked accounts available currently"));		
		rootJson.put("NoExtFound","true");
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgLockedAccounts.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgLockedAccounts.jsp");
	}

	screenLabels.put("deleteforSelectedMessage",_mapping.getTextDescription("admin.group.Are you sure you want to unlock the selected user(s)?"));
	screenLabels.put("no accounts selected",_mapping.getTextDescription("admin.group.No locked account(s) have been selected"));
	screenLabels.put("deleteiconMsg1",_mapping.getTextDescription("admin.group.Are you sure you want to unlock "));
	screenLabels.put("deleteiconMsg2",_mapping.getTextDescription("admin.group.account?"));
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("gridValues",groupArr);
	out.println(rootJson.toString());
%>





