<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.json.simple.*"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONArray jsonArr = new JSONArray();

	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");

	String agentType = request.getParameter("agentType");
	String monitors = request.getParameter("monitors");
	String versionName = request.getParameter("agentVersion");
	ArrayList serverList = new ArrayList();
	if (agentType != null && agentType.equalsIgnoreCase("Internal"))
	{
		if (monitors != null)
		{
			String agentBasedStr = mgrIni.getValue("AgentBased_Mappings",monitors);
			String var [] = mgrIni.getVariables(agentBasedStr);
			ArrayList varList = var==null?new ArrayList():new ArrayList(Arrays.asList(var));
			serverList.addAll(varList);
		}
	}

	TreeSet platformSpecificList = new TreeSet();
	for (int i=0;i<serverList.size();i++)
	{
		String serverName = (String)serverList.get(i);
		String platformNames = mgrIni.getValue("COMPONENT_TYPE_OS_MAPPING",serverName);
		if (platformNames != null && platformNames.trim().length() > 0)
		{
			if (platformNames.indexOf(",") != -1)
			{
				ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(platformNames,",")));
				platformSpecificList.addAll(valueList);
			}
			else
			{
				platformSpecificList.add(platformNames);
			}
		}
	}

	ArrayList finalAgentList = new ArrayList();
	if(platformSpecificList.size()!=0)
	{
		Iterator platformI = platformSpecificList.iterator();
		while (platformI.hasNext())
		{
			String os = (String) platformI.next();
			os = os.toLowerCase();
			String agentNames = mgrIni.getValue("OS_AGENT_MAPPING",os);
			if (agentNames != null && agentNames.trim().length() > 0)
			{
				if (agentNames.indexOf(",") != -1)
				{
					ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(agentNames,",")));
					finalAgentList.addAll(valueList);
				}
				else
				{
					finalAgentList.add(agentNames);
				}
			}
		}
	}

	if (versionName == null || versionName.equals("null"))
	{
		versionName = "Latest";
	}
	
	String defaultAgents = mgrIni.getValue("MISC_ARGS","DefaultAgentFolders");
	String ShowVersionSpecificAgents = mgrIni.getValue("MISC_ARGS","ShowVersionSpecificAgents");
	
	JSONArray verArr = new JSONArray();
	String agentVersion []  = mgrIni.getVariables("AGENT_VERSION");
	ArrayList agentVersionList = agentVersion==null?new ArrayList():new ArrayList(Arrays.asList(agentVersion));
	Collections.sort(agentVersionList, Collections.reverseOrder());
	JSONObject verObj = new JSONObject();
	verObj.put("displayField","Latest");
	verObj.put("valueField","Latest");
	verArr.add(verObj);
	for (int i=0;i<agentVersionList.size()-1;i++)
	{
		verObj = new JSONObject();
		verObj.put("displayField",(String)agentVersionList.get(i));
		verObj.put("valueField",(String)agentVersionList.get(i));
		verArr.add(verObj);
	}

	rootJson.put("agentVersion",verArr);
	rootJson.put("selectedAgentVersion",versionName);

	String sep = System.getProperty("file.separator");

	if (defaultAgents != null && defaultAgents.length() > 0)
	{
		StringTokenizer st = new StringTokenizer(defaultAgents,",");
		ArrayList defaultAgentFolders = new ArrayList();
		while (st.hasMoreTokens())
		{
			defaultAgentFolders.add(st.nextToken());
		}

		String unix [] = mgrIni.getVariables("UNIX_AGENT_FOLDER_NAMES");
		String win [] = mgrIni.getVariables("WINDOWS_AGENT_FOLDER_NAMES");

		ArrayList unixList = new ArrayList();
		ArrayList winList = new ArrayList();

		if (finalAgentList != null && finalAgentList.size() > 0)
		{
			if (unix != null && unix.length > 0)
			{
				for (int i=0;i<unix.length;i++)
				{
					String unixAgent = unix[i];
					if (finalAgentList.contains(unixAgent))
					{
						unixList.add(unixAgent);
					}
				}
			}
			if (win != null && win.length > 0)
			{
				for (int i=0;i<win.length;i++)
				{
					String winAgent = win[i];
					if (finalAgentList.contains(winAgent))
					{
						winList.add(winAgent);
					}
				}
			}
		}
		else
		{
			if (!agentType.equalsIgnoreCase("internal"))
			{
				unixList = unix==null?new ArrayList():new ArrayList(Arrays.asList(unix));
				winList = win==null?new ArrayList():new ArrayList(Arrays.asList(win));
			}
		}

		for (int j = 0; j < defaultAgentFolders.size(); j++)
		{
			String folderName = (String)defaultAgentFolders.get(j);
			
			File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderName+sep+versionName);
			File[] listOfFiles = folder.listFiles();
			
			if (listOfFiles != null && listOfFiles.length > 0)
			{
				for (int k = 0; k < listOfFiles.length; k++)
				{
					JSONObject jsonObj = new JSONObject();
					if (listOfFiles[k].getName().endsWith(".zip"))
					{
						String dirName = listOfFiles[k].getName();
						String imageName = mgrIni.getValue("AGENT_IMAGE_CLASS",dirName);
						if (unixList.contains(dirName))
						{
							String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Unix");

							if (dirName.indexOf("Linux") != -1)
							{
								if (dirName.indexOf("x64") != -1)
								{
									jsonObj.put("bit","64-bit");
								}
								else
								{
									jsonObj.put("bit","32-bit");
								}
							}

							jsonObj.put("version",displayName);

							jsonArr.add(jsonObj);
						}
						else if (winList.contains(dirName))
						{
							String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
							if (displayName == null || displayName.length() <= 0)
							{
								displayName = dirName;
							}
							jsonObj.put("displayField",displayName);
							jsonObj.put("valueField",dirName);
							jsonObj.put("className",imageName);
							jsonObj.put("folder",folderName);
							jsonObj.put("agentVersion",versionName);
							jsonObj.put("category","Windows");
							
							if (dirName.indexOf("x64")!= -1)
							{
								jsonObj.put("bit","64-bit");
							}
							else
							{
								jsonObj.put("bit","32-bit");
							}

							String version = mgrIni.getValue("WINDOWS_AGENT_VERSION",displayName);
							if (version != null && version.length() > 0)
							{
								jsonObj.put("version",version);
							}
							else
							{
								jsonObj.put("version",displayName);
							}

							jsonArr.add(jsonObj);
						}
					}
				}
			}
		}
	}

	rootJson.put("listOfOS",jsonArr);
	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootJson);
%>




