<%
	/*
	 *		Name		:	EgDispServerJson.jsp
	 *		Purpose		:	To view components under a type.
	 *		Navigation	:	Infrastructure > Add / Modify Components
	 */
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.ServerBean"%>
<%@ page import="java.util.Vector"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import="com.egurkha.admin.EgTestSpecification" %>

<%@ page import="org.json.simple.JSONObject"%>
<%@ page import="org.json.simple.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	//tell whether _cf test enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRoleObj = _user.getUserRole();
		isConfigSupported = userRoleObj.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	String classify = request.getParameter("classify");
	if (StringUtils.isNull(classify))
	{
		classify = "all";
	}

	boolean isShowOnlyConfigured = false;
	if (!StringUtils.isNull(classify) && classify.equalsIgnoreCase("configured"))
	{
		isShowOnlyConfigured = true;
	}
	rootJSON.put("isShowOnlyConfigured",isShowOnlyConfigured);

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean allCompAccess = roleInfo.hasAllComponentAccess();
	ArrayList allAgents = roleInfo.getTotalAgents();


	EgDiscInfo egDisc = new EgDiscInfo("manager");

	//Component type
	ArrayList serverList  = new ArrayList();
	String[] servertypes = egDisc.getComponentTypes();
	for(int i=0; i<servertypes.length; i++)
	{
		if (!servertypes[i].equals("Site_servers"))
		{
			serverList.add(servertypes[i]);
		}
	}

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = _user.getLanguage();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	serverList = sorter.getSortedCompTypeList(serverList);

	String strServer = request.getParameter("server");
	if (strServer==null || strServer.equalsIgnoreCase("null"))
		strServer="";

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	boolean isAllowIPModify = servicesInfo.isAllowIPModification();
	boolean autoIpNameCheck = servicesInfo.autoIpNameCheck();
	rootJSON.put("isAllowIPModify",isAllowIPModify);
	rootJSON.put("isAllowHostName",isAllowHostName);
	rootJSON.put("autoIpNameCheck",autoIpNameCheck);

	// get permisssion for action column starts...
	EgUserRole userRole = _user.getUserRole();
	String roleName     = userRole.getRoleName();
	EgUserPermission sas = EgUserPermission.getInstance();
	long perValue = userRole.getAdminPerm();
	ArrayList adminPermCheckList = sas.getPrivilegeList(roleName,perValue,0);//admin role privilege list.
	String[][] allGroupNames = sas.getAdminDesc();//all admin groups.
	boolean hasMaintenancePolicyEnabled = false;
	boolean hasAgentTestEnabled = false;
	boolean hasAgentThreshEnabled = false;
	boolean hasGlobalThreshEnabled = false;
	boolean hasGlobalTestEnabled = false;
	boolean hasComponentMangamentEnabled = false;

	for (int i=0;i<allGroupNames.length;i++)
	{
		String temp = allGroupNames[i][0];
		if (!adminPermCheckList.contains(temp))
		{
			continue;
		}
		
		if (temp.equalsIgnoreCase("Maintenance Policy Configuration"))
		{
			hasMaintenancePolicyEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Agent Test Configuration"))
		{
			hasAgentTestEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Agent Threshold Configuration"))
		{
			hasAgentThreshEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Global Threshold Configuration"))
		{
			hasGlobalThreshEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Global Agent Test Configuration"))
		{
			hasGlobalTestEnabled = true;
		}
		else if (temp.equalsIgnoreCase("Component Management"))
		{
			hasComponentMangamentEnabled = true;
		}
	}

	IniFile clsIni = new IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_ls_portal.ini");
	String cloudModel = clsIni.getValue("LS_TRIAL_SETTINGS","cloudModel");
	if (!allCompAccess && cloudModel != null && cloudModel.equalsIgnoreCase("phoenix"))
	{
		hasComponentMangamentEnabled = false;
	}
	
	boolean hasTestEnabled = false;
	if (hasGlobalTestEnabled || hasAgentTestEnabled)
	{
		hasTestEnabled = true;
	}
	rootJSON.put("hasTestEnabled",hasTestEnabled);


	boolean hasThreshEnabled = false;
	if (hasGlobalThreshEnabled || hasAgentThreshEnabled)
	{
		hasThreshEnabled = true;
	}
	rootJSON.put("hasThreshEnabled",hasThreshEnabled);

	rootJSON.put("hasMaintenancePolicyEnabled",hasMaintenancePolicyEnabled);
	rootJSON.put("hasComponentMangamentEnabled",hasComponentMangamentEnabled);
// get permisssion for action column ends...

	//Components listing
	String egTitleSearchStr=request.getParameter("searchStr");
	boolean isSearchResult =(egTitleSearchStr!=null);
	if (egTitleSearchStr==null)
		egTitleSearchStr="";
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}

	String temp = "";
	String[] serversArray = roleInfo.getAllServersOfType(strServer);
	ArrayList servers = (serversArray == null) ? new ArrayList() : new ArrayList(Arrays.asList(serversArray));
	boolean serversFound = false;
	List minusList = new ArrayList();
	for(int j=0; j<servers.size(); j++)
	{
		String thisSrv = (String) servers.get(j);
		if(thisSrv.startsWith("Format:") || thisSrv.startsWith("#"))
		{
			minusList.add(thisSrv);
			continue;
		}
		temp=thisSrv.substring(thisSrv.indexOf(":")+1);
		if(strServer.equals("Oracle_server") && (temp.indexOf(":") != temp.lastIndexOf(":")))
		{
			temp = temp.substring(0,temp.lastIndexOf(":"));
		}

		String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);
		if (isSearchResult && !doesExist(searchList,ipWithoutPort))
		{
				minusList.add(thisSrv);
				continue;
		}
		serversFound=true;
	}

	servers.removeAll(minusList);
	Collections.sort(servers,String.CASE_INSENSITIVE_ORDER);
	Vector vecStore = new Vector();
	JSONArray objArray = new JSONArray();
	JSONArray componentDataArr = new JSONArray();
	com.eg.EgExternalInfo extInfo = new com.eg.EgExternalInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	String[] extTypes = specsInfo.getAllExternalServerTypes();
	List extCompTypes = new ArrayList();
	if (extTypes != null)
	{
		extCompTypes = new ArrayList(Arrays.asList(extTypes));
	}

	ArrayList uncofiguredCompList = new ArrayList();
	TreeMap compSpecificUncofigTestList = new TreeMap();
	if (!StringUtils.isNull(classify) && classify.equalsIgnoreCase("all"))
	{
		uncofiguredCompList = getUnconfiguredComponents(strServer, servers, isConfigSupported);
	}


	TreeMap unconfiguredTestData = new TreeMap();
	servers = getClassificationOfServers(strServer, servers, isShowOnlyConfigured, isConfigSupported, classify, unconfiguredTestData);

	if (unconfiguredTestData != null && !unconfiguredTestData.isEmpty())
	{
		compSpecificUncofigTestList = (TreeMap) unconfiguredTestData.get(strServer);
	}
	
	if (servers == null || servers.isEmpty())
	{
		rootJSON.put("emptyMesssage",_mapping.getTextDescription("admin.common.No data found"));
	}

	rootJSON.put("serverTitleLbl","<div style='float:left;padding:2px 5px 0px 0px;height:18px' class='aLabelFont'>"+_mapping.getComponentTypeDescription(strServer)+" </div>");

	if (!strServer.equals("null") && servers.size() > 0)
	{
		String compLbl = " Components";
		if (servers.size() == 1)
		{
			compLbl = " Component";
		}

		rootJSON.put("serverTitleLbl","<div style='float:left;padding:2px 5px 0px 0px;height:18px' class='aLabelFont'>"+_mapping.getComponentTypeDescription(strServer)+" <span class='aNormalFont'>("+servers.size()+" "+compLbl+")</span></div>");

		TreeMap tmapAgentsDetailsForAllComps = getAgentsDetailForAllComps(servers,allAgents);
		for(int j=0; j<servers.size(); j++)
		{
			JSONObject componentDataObj = new JSONObject();
			String thisSrv = (String) servers.get(j);
			String serverType = (thisSrv.substring(0,thisSrv.indexOf(":"))).trim();
			temp=thisSrv.substring(thisSrv.indexOf(":")+1);
			componentDataObj.put("Entity",_mapping.getComponentTypeDescription(serverType));
			componentDataObj.put("CompVariable",thisSrv);
			componentDataObj.put("CompType",serverType);
			componentDataObj.put("Managed","Yes");
			componentDataObj.put("Discovered","Yes");
			String ip = egDisc.getComponentIP(strServer,temp);
			String nickAlone = temp.substring(0,temp.indexOf(":"));

			componentDataObj.put("ComponentName",temp);

			ArrayList agentsDetailsList = (ArrayList) tmapAgentsDetailsForAllComps.get(temp);

			if (!isShowOnlyConfigured)
			{
				componentDataObj.put("Configured","No");
				componentDataObj.put("UnConfigTestType","PerformanceTest");

				ArrayList testsList = (ArrayList) compSpecificUncofigTestList.get(temp);
				if (testsList != null && !testsList.isEmpty())
				{
					ArrayList aListPerTest = (ArrayList) testsList.get(0);
					ArrayList aListConTest = (ArrayList) testsList.get(1);

					if (aListPerTest == null || aListPerTest.isEmpty())
					{
						if (aListConTest != null && !aListConTest.isEmpty())
						{
							componentDataObj.put("UnConfigTestType","ConfigurationTest");
						}
					}
				}

				if (classify.equalsIgnoreCase("all"))
				{
					if (uncofiguredCompList != null && !uncofiguredCompList.contains(thisSrv))
					{
						componentDataObj.put("Configured","Yes");
						componentDataObj.put("UnConfigTestType","PerformanceTest");
					}
				}
			}
			else
			{
				componentDataObj.put("UnConfigTestType","PerformanceTest");
				componentDataObj.put("Configured","Yes");
			}

			componentDataObj.put("MonitorStatus","ANI");  //AgentNotInstalled
			if (agentsDetailsList != null)
			{
				String strNsAgent = (String) agentsDetailsList.get(1);
				String agentInstall = (strNsAgent.indexOf("Not Installed") != -1)?"No": "Yes";
				String agentStatus = (strNsAgent.indexOf("Not Running") != -1)?"No": "Yes";
				if (!StringUtils.isNull(agentInstall) && agentInstall.equalsIgnoreCase("No"))
				{
					componentDataObj.put("MonitorStatus","ANI");
				}
				else
				{
					if (!StringUtils.isNull(agentStatus))
					{
						if (agentStatus.equalsIgnoreCase("No"))
						{
							componentDataObj.put("MonitorStatus","ANR"); //AgentNotRunning
						}
						else 
						{
							componentDataObj.put("MonitorStatus","AR"); //AgentRunning
						}
					}
				}
			}
			
			
			if(strServer.equals("Oracle_server") && (temp.indexOf(":") != temp.lastIndexOf(":")))
			{
				temp = temp.substring(0,temp.lastIndexOf(":"));
			}


			if(!vecStore.contains(temp))
			{
				vecStore.addElement(temp);
				String ipWithoutPort = Server.getServerNameWithoutPort(temp, false);

				String agentType = "Agent";
				if(serverType.equals("Real_user_monitor"))
				{
					agentType = "Agentless";
					//ip = "Not Applicable";
				}
				if(extInfo.isRemoteBased(nickAlone))
				{
					agentType = "Agentless";
				}
				//else if (extCompTypes.contains(strServer))
				//{
					//agentType = "External Agent";
				//}
				componentDataObj.put("Agent/Agentless",agentType);

				String compToShow = ipWithoutPort;
				if (serverType.equals("Oracle_server"))
				{
					List li = egDisc.getAllSIDs(ipWithoutPort);
					if (li != null && li.size() > 0)
					{
						compToShow += ":";
						for (int l=0; l < li.size(); l++)
						{
							if(l!=0)
							{
								compToShow += ",";
							}
							compToShow += li.get(l).toString();
						}
					}
					componentDataObj.put("ComponentName",compToShow);
				}
				componentDataObj.put("DispCompName",compToShow);
				componentDataObj.put("DispIpName",ip);
				componentDataArr.add(componentDataObj);
			}
		}
		rootJSON.put("components",componentDataArr);
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootJSON);
%>


<%!

	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");

	private boolean doesExist(List searchList, String server)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (server.indexOf(nextStr)!=-1||(server.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
			{
				return true;
			}
		}
		return false;
	}

	private ArrayList removeAggServers(ArrayList serverList)
	{
		ArrayList tmpList = new ArrayList();
		for(int i=0; i<serverList.size(); i++)
		{
			EgName nameObj1 = (EgName)serverList.get(i);
			String tmpVal = nameObj1.getActualName();
			String tmpDis = nameObj1.getLocalName();
			if(tmpVal.startsWith("Agg_"))
			{
				continue;
			}
			tmpList.add(serverList.get(i));
		}

		return tmpList;
	}

	public ArrayList getAllServerGroups()
	{
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				grp.add(Subjects[i]);
			}
			ArrayList icTypes = getAllUserDefinedServers();
			if (com.eg.EgMemInfo.icEnabled && icTypes != null && icTypes.size()>0)
			{
				grp.add("CUSTOM COMPONENTS");
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			ArrayList otherServers = getOtherServers();
			if (otherServers.size() > 0)
			{
				grp.add("OTHERS");
			}
			grp.remove("AGGREGATES");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}
	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					initial = initial + sub;
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}

	public ArrayList getOtherServers()
	{
		ArrayList tempServers = getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}
		for(int i=0; i<otherServers.length; i++)
		{
			if (!otherServers[i].equals("Site_servers") && !otherServers[i].toLowerCase().endsWith("_ex"))
			{
				if (!tempServers.contains(otherServers[i]))
				{
					serverList.add(otherServers[i]);
				}
			}
		}
		return serverList;
	}

	public ArrayList getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					comGroups.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
		return comGroups;
	}

	public ArrayList getAllUserDefinedServers()
	{
		ServerBean serverBean = new ServerBean();
		Map serverList = new HashMap();
		Hashtable allSrvMap = serverBean.getAllServerMap();
		ArrayList udServers = (ArrayList)allSrvMap.get("UDSERVERS");	//userdefined servers
		if(udServers != null && udServers.size()>0)
		{
			for(int i=udServers.size()-1;i>=0;i--)
			{
				String ud_server = (String)udServers.get(i);
				if(udServers.get(i).toString().startsWith("Agg_"))
				{
					udServers.remove(i);
				}
			}
		}
		return udServers;
	}
	public ArrayList getCategorizedComponents(String compGroup)
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();

			String [] variables = iniFile.getVariables(compGroup);
			for (int j = 0;j<variables.length;j++)
			{
				comGroups.add(variables[j]);
			}
		}
		catch (Exception e)
		{
			return new ArrayList();
		}
		if (!EgInstallInfo.isnamedUserLicense && !EgInstallInfo.isconcurrentUserLicense) //server based license, then remove Cloud_VMs type
		{
			comGroups.removeAll(EgInstallInfo.getUserCertSpecificTypes());
		}
		return comGroups;
	}
	public String getCategoryForCompononetType(String compType)
	{
		IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		String[] subs = iniFile.getSubjects();
		String res ="";
		if(subs!=null)
		{
			for (int s=0; s<subs.length; s++)
			{
				String sub = subs[s];
				String[] vars = iniFile.getVariables(sub);
				if (vars!=null)
				{
					List compTypes = Arrays.asList(vars);
					if (compTypes.contains(compType))
					{
						res = sub;
					}
				}
			}
		}
		return res;
	}

	/*public ArrayList getClassificationOfServers(String componentType, ArrayList servers, boolean isShowOnlyConfigured, MappingNameSorter sorter, boolean isConfigSupported)
	{
		ArrayList resultSet = new ArrayList();
		if (servers == null || servers.isEmpty())
			return resultSet;

		for (int s=0; s<servers.size();s++)
		{
			String server = servers.get(s).toString();
			String strGetUnconfigComps = getUnconfiguredTests(server, isConfigSupported, sorter);
			
			if (!isShowOnlyConfigured)
			{
				if (!StringUtils.isNull(strGetUnconfigComps))
				{
					resultSet.add(server);
				}
			}
			else
			{
				if (StringUtils.isNull(strGetUnconfigComps))
				{
					resultSet.add(server);
				}
			}
		}
		return resultSet;
	}*/

	public ArrayList getClassificationOfServers(String componentType, ArrayList servers, boolean isShowOnlyConfigured, boolean isConfigSupported, String classify, TreeMap unconfiguredTestData)
	{
		ArrayList resultSet = new ArrayList();
		if (servers == null || servers.isEmpty())
			return resultSet;

		if (!StringUtils.isNull(classify))
		{
			if (!classify.equalsIgnoreCase("all"))
			{
				resultSet = getUnconfiguredComponents(componentType, servers, isConfigSupported,unconfiguredTestData);
				if (isShowOnlyConfigured)
				{
					servers.removeAll(resultSet);
					resultSet = new ArrayList();
					resultSet.addAll(servers);
				}
			}
			else
			{
				resultSet.addAll(servers);
			}
		}

		return resultSet;
	}


	public ArrayList getUnconfiguredComponents(String componentType, List listOfComponents, boolean isConfigSupported, TreeMap unconfiguredTestData)
	{
		boolean hasUnConfiguredTests = false;
		TreeMap tmapUnConfigTests = null;

		ArrayList resultSet = new ArrayList();

		EgTestSpecification egTestSpecification = new EgTestSpecification(listOfComponents);
		
		//ensure whether the user is configuration management enabled
		if (isConfigSupported)
		{
			egTestSpecification.setConfigSupported(isConfigSupported);
		}

		tmapUnConfigTests = egTestSpecification.getUnconfiguredComponents(componentType);

		ArrayList tmapCompUnconfigComps = (ArrayList) tmapUnConfigTests.get(componentType);
		hasUnConfiguredTests = (tmapCompUnconfigComps != null && tmapCompUnconfigComps.size() > 0) ? true : false;

		if (hasUnConfiguredTests)
		{
			TreeMap tmpMap = (TreeMap) egTestSpecification.getUnconfiguredTests(componentType,listOfComponents);
			unconfiguredTestData.putAll(tmpMap);

			resultSet.addAll(tmapCompUnconfigComps);
		}

		return resultSet;
	}

	public ArrayList getUnconfiguredComponents(String componentType, List listOfComponents, boolean isConfigSupported)
	{
		boolean hasUnConfiguredTests = false;
		TreeMap tmapUnConfigTests = null;

		ArrayList resultSet = new ArrayList();

		EgTestSpecification egTestSpecification = new EgTestSpecification(listOfComponents);
		
		//ensure whether the user is configuration management enabled
		if (isConfigSupported)
		{
			egTestSpecification.setConfigSupported(isConfigSupported);
		}

		tmapUnConfigTests = egTestSpecification.getUnconfiguredComponents(componentType);

		ArrayList tmapCompUnconfigComps = (ArrayList) tmapUnConfigTests.get(componentType);
		hasUnConfiguredTests = (tmapCompUnconfigComps != null && tmapCompUnconfigComps.size() > 0) ? true : false;

		if (hasUnConfiguredTests)
		{
			resultSet.addAll(tmapCompUnconfigComps);
		}

		return resultSet;
	}


	public String getUnconfiguredTests(String listUnconfiguredComponents, boolean isConfigSupported, MappingNameSorter sorter)
	{
		String componentType = listUnconfiguredComponents.substring(0,listUnconfiguredComponents.indexOf(":")); 

		ArrayList dataList = new ArrayList();
		dataList.add(listUnconfiguredComponents);

		boolean hasUnConfiguredTests = false;
		int unConfiguredTestsCount = 0;
		ArrayList aListCount = null;
		TreeMap tmapUnconfigTestCount = null;
		TreeMap tmapTemp = null;
		TreeMap unconfiguredComponentSummary = new TreeMap();
		int totalUnconfiguredComponents = 0;
		TreeMap tmapUnConfigTests = null;

		String result = "";

		EgTestSpecification egTestSpecification = new EgTestSpecification(dataList);
		
		//ensure whether the user is configuration management enabled
		if (isConfigSupported)
		{
			egTestSpecification.setConfigSupported(isConfigSupported);
		}

		tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
		unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount();
		hasUnConfiguredTests = (unConfiguredTestsCount > 0)?true:false;


		int totalTestCount = egTestSpecification.getTotalUnconfiguredTestsCount();
		TreeMap tmapResultant = getSortedData(tmapUnConfigTests,sorter,componentType);
		tmapUnConfigTests = (TreeMap)tmapResultant.get("resultantUnconfigTest");
		ArrayList aListOrderedCompType = (ArrayList)tmapResultant.get("aListOrderedCompTypes");


		if (hasUnConfiguredTests)
		{
			result = "";
			ArrayList aListUnconfigTestCount = new ArrayList();
			tmapTemp = new TreeMap();
			Iterator itrUnConfigTests = tmapUnConfigTests.keySet().iterator();
			for(int i=0; i<tmapUnConfigTests.size(); i++)
			{
				String tempCompType=(String)itrUnConfigTests.next();
				TreeMap tmapTempCompUnconfigTests = (TreeMap)tmapUnConfigTests.get(tempCompType);
				totalUnconfiguredComponents = totalUnconfiguredComponents + tmapTempCompUnconfigTests.size();
				int unConfigTestsCount = 0;
				int unConfigPerTestsCount = 0;
				int unConfigConTestsCount = 0;
				Iterator itr_tempCompUnconfigTests = tmapTempCompUnconfigTests.keySet().iterator();
				for(int j=0; j<tmapTempCompUnconfigTests.size(); j++)
				{
					String tempComponentName=(String)itr_tempCompUnconfigTests.next();
					ArrayList aListResultantTests = (ArrayList)tmapTempCompUnconfigTests.get(tempComponentName);

					ArrayList aListTempPerTests = (ArrayList)aListResultantTests.get(0);
					ArrayList aListTempConTests = (ArrayList)aListResultantTests.get(1);

					unConfigPerTestsCount = unConfigPerTestsCount + aListTempPerTests.size();
					unConfigConTestsCount = unConfigConTestsCount + aListTempConTests.size();
					unConfigTestsCount = unConfigTestsCount + aListTempPerTests.size() + aListTempConTests.size();

					if (aListTempPerTests != null && !aListTempPerTests.isEmpty())
					{
						String strTempTest = (String)aListTempPerTests.get(0);
						strTempTest = strTempTest.substring(0,strTempTest.indexOf("#"));
						result = strTempTest;
						//break;
					}
				}
				aListUnconfigTestCount.add(tempCompType + "#" +tmapTempCompUnconfigTests.size());
				//tmapTemp.put(tempCompType,unConfigTestsCount + "#" + unConfigPerTestsCount + "#" + unConfigConTestsCount);
			}

			tmapUnconfigTestCount = new TreeMap();
			aListCount = new ArrayList();
			for (int i=0;i<aListUnconfigTestCount.size();i++)
			{
				String strUnConfigTestCount = (String)aListUnconfigTestCount.get(i);
				String tempCompType = strUnConfigTestCount.substring(0,strUnConfigTestCount.indexOf("#"));
				String testCountPattern = strUnConfigTestCount.substring(strUnConfigTestCount.indexOf("#")+1);
				testCountPattern = testCountPattern.trim();
				Integer testCount = new Integer(testCountPattern);

				ArrayList aListTemp = (ArrayList)tmapUnconfigTestCount.get(testCount);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(tempCompType);
					tmapUnconfigTestCount.put(testCount,aListTemp);
					aListCount.add(testCount);
				}
				else
				{
					aListTemp.add(tempCompType);
				}
			}

			Collections.sort(aListCount);
			Collections.reverse(aListCount);
		}

		return result;
	}

	public TreeMap getSortedData(TreeMap tmap,MappingNameSorter sorter,String componentType)
	{
		//will contain tests in treemap in sorted order
		TreeMap tmapResultantUnconfigTest = new TreeMap();
		//contains unconfigured tests count as key and corresponding componentType as value.
		TreeMap tmapTestCount = new TreeMap(Collections.reverseOrder());

		Iterator itrCompTypeUnConfigTests = tmap.keySet().iterator();
		while (itrCompTypeUnConfigTests.hasNext())
		{
			String tempCompType = (String)itrCompTypeUnConfigTests.next();
			TreeMap tmapUnConfigComp = (TreeMap)tmap.get(tempCompType);
			Iterator itrUnConfigComp = tmapUnConfigComp.keySet().iterator();
			TreeMap tmapOrderedComponents = new TreeMap();
			int tempTestCount = 0;
			while (itrUnConfigComp.hasNext())
			{
				String tempCompName = (String)itrUnConfigComp.next();
				ArrayList aListUnConfigTests = (ArrayList)tmapUnConfigComp.get(tempCompName);
				ArrayList aListUnConfigPerTest = (ArrayList)aListUnConfigTests.get(0);
				if (!aListUnConfigPerTest.isEmpty())
				{
					tempTestCount = tempTestCount + aListUnConfigPerTest.size();
					aListUnConfigPerTest = sortTestList(aListUnConfigPerTest,sorter);
				}
				ArrayList aListUnConfigConTest = (ArrayList)aListUnConfigTests.get(1);
				if (!aListUnConfigConTest.isEmpty())
				{
					tempTestCount = tempTestCount + aListUnConfigConTest.size();
					aListUnConfigConTest = sortTestList(aListUnConfigConTest,sorter);
				}
				ArrayList aListOrderedTest = new ArrayList();
				aListOrderedTest.add(aListUnConfigPerTest);
				aListOrderedTest.add(aListUnConfigConTest);
				tmapOrderedComponents.put(tempCompName,aListOrderedTest);
			}
			tmapResultantUnconfigTest.put(tempCompType,tmapOrderedComponents);

			Integer intCountObj = new Integer(tempTestCount);
			ArrayList aListTempCompType = (ArrayList)tmapTestCount.get(intCountObj);
			if (aListTempCompType == null)
			{
				aListTempCompType = new ArrayList();
				aListTempCompType.add(tempCompType);
				tmapTestCount.put(intCountObj,aListTempCompType);
			}
			else
			{
				aListTempCompType.add(tempCompType);
			}
		}

		ArrayList aListOrderedCompTypes = new ArrayList();
		if (!componentType.equals(""))
		{
			aListOrderedCompTypes.add(componentType);
		}

		boolean isCompTypeFound = false;
		Iterator itrTestCount = tmapTestCount.keySet().iterator();
		while (itrTestCount.hasNext())
		{
			Integer tempCount = (Integer)itrTestCount.next();
			ArrayList aListTempCompTypes = (ArrayList)tmapTestCount.get(tempCount);

			if (!isCompTypeFound && !componentType.equals(""))
			{
				if (aListTempCompTypes.contains(componentType))
				{
					aListTempCompTypes.remove(componentType);
					isCompTypeFound = true;
				}
			}

			aListOrderedCompTypes.addAll(aListTempCompTypes);
		}

		TreeMap tmapResultant = new TreeMap();
		tmapResultant.put("aListOrderedCompTypes",aListOrderedCompTypes);
		tmapResultant.put("resultantUnconfigTest",tmapResultantUnconfigTest);
		return tmapResultant;
	}

	public ArrayList sortTestList(ArrayList aList,MappingNameSorter sorter)
	{
		ArrayList aListSortedTest = new ArrayList();
		TreeMap tmapTestCount = new TreeMap(Collections.reverseOrder());
		for (int i=0;i<aList.size();i++)
		{
			String str = ((String)aList.get(i)).trim();
			String strTest = str.substring(0,str.indexOf("#"));
			String strCount = str.substring(str.indexOf("#")+1,str.length());
			Integer tempIntObj = new Integer(strCount.trim());
			ArrayList aListStrTemp = (ArrayList)tmapTestCount.get(tempIntObj);
			if (aListStrTemp == null)
			{
				aListStrTemp = new ArrayList();
				aListStrTemp.add(strTest);
				tmapTestCount.put(tempIntObj,aListStrTemp);
			}
			else
			{
				aListStrTemp.add(strTest);
			}
		}

		Iterator itrTestCount = tmapTestCount.keySet().iterator();
		int tempCount = 0;
		int[] nums = new int[tmapTestCount.size()];
		while (itrTestCount.hasNext())
		{
			Integer tempInteger = (Integer)itrTestCount.next();
			nums[tempCount] = tempInteger.intValue();
			tempCount++;
		}

		for (int i=0;i<nums.length;i++)
		{
			Integer tempInteger = new Integer(nums[i]);
			ArrayList aListTempTest = (ArrayList)tmapTestCount.get(tempInteger);
			boolean isSorterNeeded = (aListTempTest.size() > 1);
			if (isSorterNeeded)
			{
				aListTempTest = sorter.getSortedTestList(aListTempTest);
				for (int j=0;j<aListTempTest.size();j++)
				{
					EgName nameObj = (EgName)aListTempTest.get(j);
					String strTest = nameObj.getActualName();
					aListSortedTest.add(strTest + "#" + nums[i]);
				}
			}
			else
			{
				String strTest = (String)aListTempTest.get(0);
				aListSortedTest.add(strTest + "#" + nums[i]);
			}
		}

		return aListSortedTest;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);

			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private TreeMap getAgentsDetailForAllComps(List componentNameList, ArrayList agentList)
	{
		IniFile testsIni = new IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
		EgServerList serverList = new EgServerList();

		TreeMap tmapComponentsAgentList = new TreeMap();
		if (componentNameList.isEmpty() || agentList.isEmpty())
		{
			return tmapComponentsAgentList;
		}

		ArrayList aList = serverList.getAgentListFromDB();
		String currList[] = serverList.getTargetNames();
		ArrayList totalAgents=serverList.getAgentList(agentList,aList,currList);

		int count = componentNameList.size();
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String[] externalServTypesArr = egSpecsInfo.getAllExternalServerTypes();
		ArrayList extenalCompNicks = egDiscInfo.getAllHostsOfTypes(Arrays.asList(externalServTypesArr));
		for (int a=0;a<count;a++)
		{
			List agentsList = new ArrayList();
			String thisSrv = componentNameList.get(a).toString();
			String serverType = (thisSrv.substring(0,thisSrv.indexOf(":"))).trim();
			String componentName = thisSrv.substring(thisSrv.indexOf(":")+1);

			String componentNickName = componentName.substring(0,componentName.indexOf(":"));
			String agentNickName = "";
			boolean isRemote = false;
			
			//To fetch the exact agent for the selected component - start
			isRemote = egExternalInfo.isRemoteBased(componentNickName);
			boolean isExternal = extenalCompNicks != null && extenalCompNicks.contains(componentNickName);

			if (serverType != null && serverType.startsWith("Agg_"))
			{
				String externalAgent =  testsIni.getValue("AGENTS_FOR_AGGREGATE_COMPONENTS","ExternalAgentRunsAllAggTests");

				if(!StringUtils.isNull(externalAgent) && externalAgent.length() > 0)
				{
					if (externalAgent.equalsIgnoreCase("yes") || externalAgent.equalsIgnoreCase("true") || externalAgent.equalsIgnoreCase("y") || externalAgent.equalsIgnoreCase("t"))
					{
						isExternal = true;
					}
				}
			}

			if (isRemote)
			{
				//Agentless
				agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
			}
			else if (isExternal)
			{
				String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
				//adding one or more external agent(s)
				agentsList.addAll(Arrays.asList(extAgents));
			}
			else
			{
				//Auto or Manual
				String agentName = egExternalInfo.getAgentFor(componentNickName);

				if (agentName != null) //Manual
				{
					if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
					{
						agentNickName = (String)internalAgentMap.get(agentName);
					}
					else
					{
						agentNickName = agentName;
					}
				}
				else //Auto
				{
					agentNickName = componentNickName;
				}
			}

			//adding an internal agent (or) a remote agent
			if(!StringUtils.isNull(agentNickName) && agentNickName.length() > 0)
			{
				agentsList.add(agentNickName);
			}
			//To fetch the exact agent for the selected component - end

			//To fetch the external agent for the selected component type - starts
			boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
			if (!isExternal && hasExternalAgent)
			{
				String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
				//adding one or more external agent(s)
				agentsList.addAll(Arrays.asList(extAgents));
			}
			//To fetch the external agent for the selected component type - ends

			//ArrayList tmpAgtList = new ArrayList();
			//tmpAgtList.add(agentsList.get(0));
			//ArrayList agentsDetailsList = serverList.getAgentList(tmpAgtList);

			ArrayList agentsDetailsList = new ArrayList();
			String strAgent = agentsList.get(0).toString();
			if(totalAgents.size() > 0)
			{
				for(int j=0;j<totalAgents.size();j=j+4)
				{
					String agentName = (String)totalAgents.get(j);
					String message = (String)totalAgents.get(j+1);

					if(agentName.equalsIgnoreCase(strAgent))
					{
						agentsDetailsList.add(agentName);
						agentsDetailsList.add(message);
						break;
					}
				}
			}

			if (agentsDetailsList != null && !agentsDetailsList.isEmpty())
			{
				tmapComponentsAgentList.put(componentName,agentsDetailsList);
			}
		}

		return tmapComponentsAgentList;
	}
%>