<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "org.json.simple.*"%>
<%@ page import = "com.eg.eGComponentCategory"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	JSONObject rootObj = new JSONObject();
	
	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String office365Model = mgrIni.getValue("MISC_ARGS","office365Model");
	if (office365Model == null || office365Model.trim().length() == 0)
	{
		office365Model = "standard";
	}

	eGComponentCategory egComCategory = eGComponentCategory.getInstance();
	String comGroupName = "";

	JSONArray jsonArr = new JSONArray();

	JSONObject jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Citrix"));
	jsonObj.put("valueField","Citrix");
	jsonObj.put("content","XenApp, XenDesktop, NetScaler, StoreFront, etc.");
	jsonObj.put("image","gen-citrix");
	jsonArr.add(jsonObj);

	jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.VMware Horizon"));
	jsonObj.put("valueField","VMware Horizon");
	jsonObj.put("content","Connection Server, App Volumes, Composer, etc.");
	jsonObj.put("image","gen-vm-logo");
	jsonArr.add(jsonObj);

	jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Hypervisors"));
	jsonObj.put("valueField","Hypervisors");
	jsonObj.put("content","VMware, Hyper-V, XenServer, etc. (virtual servers and virtual desktops)");

	comGroupName = egComCategory.getCategoryforCompType("VmEsx_i_server");
	comGroupName = comGroupName.toLowerCase();
	comGroupName = StringUtils.replace(comGroupName,"_","-");
	comGroupName = "comp-"+comGroupName;

	jsonObj.put("image",comGroupName);
	jsonArr.add(jsonObj);

	jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Cloud Infrastructures"));
	jsonObj.put("valueField","PublicCloud");
	jsonObj.put("content","AWS, Azure");
	jsonObj.put("image","comp-cloud");
	jsonArr.add(jsonObj);

	jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.SaaS Applications"));
	jsonObj.put("valueField","SaaSApp");
	if (office365Model.equalsIgnoreCase("basic"))
	{
		jsonObj.put("content","Salesforce");
	}
	else
	{
		jsonObj.put("content","O365, Salesforce");
	}
	jsonObj.put("image","comp-saas-applications");
	jsonArr.add(jsonObj);

	if (office365Model.equalsIgnoreCase("basic"))
	{
		jsonObj = new JSONObject();
		jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Microsoft Office 365"));
		jsonObj.put("valueField","Office365");
		jsonObj.put("content","O365");
		jsonObj.put("image","comp-office365");
		jsonArr.add(jsonObj);
	}

	boolean isClientEmulation = EgInstallInfo.isClientEmulationEnabled;
	
	if (isClientEmulation)
	{
		jsonObj = new JSONObject();
		jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Logon Simulators"));
		jsonObj.put("valueField","LogonSimulator");
		jsonObj.put("content","Citrix, VMware Horizon, Microsoft Exchange");
		jsonObj.put("image","comp-logon-simulator");
		jsonArr.add(jsonObj);
	}

	jsonObj = new JSONObject();
	jsonObj.put("displayField",_mapping.getTextDescription("admin.la.Containers"));
	jsonObj.put("valueField","Containers");
	jsonObj.put("content","Docker, Kubernetes");
	jsonObj.put("image","comp-containers");
	jsonArr.add(jsonObj);

	rootObj.put("MonitorsList",jsonArr);

	IniFile mgrMiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_mgrmisc.ini");

	JSONArray monitorTypesArr = new JSONArray();
	JSONObject monitorTypesObj = new JSONObject();

	String monitors = request.getParameter("monitors");

	if (monitors != null && monitors.trim().length() > 0)
	{
		if (monitors.equalsIgnoreCase("Citrix"))
		{
			String [] var = mgrMiscIni.getVariables("Citrix_AgentBased");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesArr.add(monitorTypesObj);
			}

			if (var.length%3 == 1 && var.length >= 3)
			{
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField","&nbsp;");
				monitorTypesObj.put("valueField","&nbsp;");
				monitorTypesArr.add(monitorTypesObj);

				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField","&nbsp;");
				monitorTypesObj.put("valueField","&nbsp;");
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("VMware Horizon"))
		{
			String [] var = mgrMiscIni.getVariables("VMware_AgentBased");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesArr.add(monitorTypesObj);
			}

			if (var.length%3 == 1 && var.length >= 3)
			{
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField","&nbsp;");
				monitorTypesObj.put("valueField","&nbsp;");
				monitorTypesArr.add(monitorTypesObj);

				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField","&nbsp;");
				monitorTypesObj.put("valueField","&nbsp;");
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("VMwareHorizonAgentLess"))
		{
			String [] var = mgrMiscIni.getVariables("VMware_AgentLess");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("CitrixAgentLess"))
		{
			String [] var = mgrMiscIni.getVariables("Citrix_AgentLess");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("CitrixAgentLessDisc"))
		{
			String [] var = mgrMiscIni.getVariables("Citrix_AgentLess_Discovery");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				String serverValue = mgrMiscIni.getValue("Citrix_AgentLess_Discovery",server);
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",serverValue);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("Hypervisors"))
		{
			String [] var = mgrMiscIni.getVariables("Hypervisors_AgentLess_Discovery");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				String value = mgrMiscIni.getValue("Hypervisors_AgentLess_Discovery",server);
				String serverValue = value.substring(0,value.indexOf("#"));
				String image = value.substring(value.indexOf("#")+1);
				monitorTypesObj= new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getTextDescription("admin.discovery."+server)); 
				monitorTypesObj.put("valueField",serverValue);
				monitorTypesObj.put("content","");
				monitorTypesObj.put("image",image);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("PublicCloud"))
		{
			String [] var = mgrMiscIni.getVariables("Cloud_AgentLess");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("Containers"))
		{
			String [] var = mgrMiscIni.getVariables("Containers_AgentLess");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("SaaSApp"))
		{
			String [] var = mgrMiscIni.getVariables("SaaSApp_AgentLess");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}

			if (office365Model.equalsIgnoreCase("standard"))
			{
				monitorTypesObj = new JSONObject();
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getTextDescription("admin.la.Microsoft Office 365"));
				monitorTypesObj.put("valueField","Office365");
				monitorTypesObj.put("content","");
				monitorTypesObj.put("image","comp-office365");
				monitorTypesArr.add(monitorTypesObj);
			}
		}
		else if (monitors.equalsIgnoreCase("LogonSimulator"))
		{
			String [] var = mgrMiscIni.getVariables("LogonSimulator_ClientEmulation_External");
			for (int i=0; i<var.length; i++)
			{
				String server = var[i];
				monitorTypesObj = new JSONObject();
				monitorTypesObj.put("displayField",_mapping.getComponentTypeDescription(server));
				monitorTypesObj.put("valueField",server);
				monitorTypesObj.put("content","");
				comGroupName = egComCategory.getCategoryforCompType(server);
				comGroupName = comGroupName.toLowerCase();
				comGroupName = StringUtils.replace(comGroupName,"_","-");
				comGroupName = "comp-"+comGroupName;
				monitorTypesObj.put("image",comGroupName);
				monitorTypesArr.add(monitorTypesObj);
			}
		}
	}
	rootObj.put("monitorsCategory",monitorTypesArr);

	String citrixAgentlessServers = "";
	String citrixAgentlessServersForDisc = "";
	String vmwareAgentlessServers = "";
	String hypervisorsagentbasedServers = "";
	String containeragentbasedServers = "";

	String [] ctxvar = mgrMiscIni.getVariables("Citrix_AgentLess");
	for (int a=0; a<ctxvar.length; a++)
	{
		String server = ctxvar[a];
		if (a == 0)
		{
			citrixAgentlessServers = _mapping.getComponentTypeDescription(server);
		}
		else if (a == ctxvar.length-1)
		{
			citrixAgentlessServers += " and "+_mapping.getComponentTypeDescription(server);
		}
		else
		{
			citrixAgentlessServers += ", "+_mapping.getComponentTypeDescription(server);
		}
	}

	String [] ctxdiscvar = mgrMiscIni.getVariables("Citrix_AgentLess_Discovery");
	for (int b=0; b<ctxdiscvar.length; b++)
	{
		String server = ctxdiscvar[b];
		if (b == 0)
		{
			citrixAgentlessServersForDisc = _mapping.getComponentTypeDescription(server);
		}
		else if (b == ctxdiscvar.length-1)
		{
			citrixAgentlessServersForDisc += " and "+_mapping.getComponentTypeDescription(server);
		}
		else
		{
			citrixAgentlessServersForDisc += ", "+_mapping.getComponentTypeDescription(server);
		}
	}

	String [] vmvar = mgrMiscIni.getVariables("VMware_AgentLess");
	for (int c=0; c<vmvar.length; c++)
	{
		String server = vmvar[c];
		if (c == 0)
		{
			vmwareAgentlessServers = _mapping.getComponentTypeDescription(server);
		}
		else if (c == vmvar.length-1)
		{
			vmwareAgentlessServers += " and "+_mapping.getComponentTypeDescription(server);
		}
		else
		{
			vmwareAgentlessServers += ", "+_mapping.getComponentTypeDescription(server);
		}
	}

	String [] hypervar = mgrMiscIni.getVariables("Hypervisors_AgentBased");
	for (int i=0; i<hypervar.length; i++)
	{
		String server = hypervar[i];
		if (i == 0)
		{
			hypervisorsagentbasedServers = _mapping.getComponentTypeDescription(server);
		}
		else if (i == hypervar.length-1)
		{
			hypervisorsagentbasedServers += " and "+_mapping.getComponentTypeDescription(server);
		}
		else
		{
			hypervisorsagentbasedServers += ", "+_mapping.getComponentTypeDescription(server);
		}
	}

	String [] contvar = mgrMiscIni.getVariables("Containers_AgentBased");
	for (int k=0; k<contvar.length; k++)
	{
		String server = contvar[k];
		if (k == 0)
		{
			containeragentbasedServers = _mapping.getComponentTypeDescription(server);
		}
		else if (k == contvar.length-1)
		{
			containeragentbasedServers += " and "+_mapping.getComponentTypeDescription(server);
		}
		else
		{
			containeragentbasedServers += ", "+_mapping.getComponentTypeDescription(server);
		}
	}

	rootObj.put("citrixAgentlessServers",citrixAgentlessServers);
	rootObj.put("citrixAgentlessServersForDisc",citrixAgentlessServersForDisc);
	rootObj.put("vmwareAgentlessServers",vmwareAgentlessServers);
	rootObj.put("hypervisorsagentbasedServers",hypervisorsagentbasedServers);
	rootObj.put("containeragentbasedServers",containeragentbasedServers);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
	out.println(rootObj.toString());

%>



