<%@ include file="../../EgTrackerAJSON.jsp" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.ComponentAdd"%>
<%@ page import = "com.egurkha.admin.UserAssociateComponent"%>
<%@ page import = "egurkha.ServiceBean" %>
<%@ page import="com.egurkha.admin.CompTypeUnconfigParams"%>
<%@ page import= "egurkha.EgUIUtils"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();

	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);
	String userId = user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean allCompAccess = egRoleInfo.hasAllComponentAccess();

	String compType = request.getParameter("compType");
	String hostip = request.getParameter("hostipparam");
	String hostname = request.getParameter("nickparam");
	String port = request.getParameter("portparam");
	String remAgent = request.getParameter("remoteAgent");
	String extAgent = "";

	rootJson.put("compTypeDisplay",_mapping.getComponentTypeDescription(compType));
	
	EgUserElementsInfo userElmentsObj = new EgUserElementsInfo();
	ArrayList extagentsList = new ArrayList();

	if (allCompAccess)
	{
		IniFile extIniObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
		String[] s_eagents = extIniObj.getVariables("Eg_External_Agents");
		extagentsList = new ArrayList(Arrays.asList(s_eagents));
	}
	else
	{
		extagentsList = userElmentsObj.getExternalAgentsForUser(userId);
	}

	if (extagentsList != null && extagentsList.size() > 0)
	{
		if (extagentsList.contains(remAgent))
		{
			extAgent = remAgent;
		}
		else
		{
			extAgent = (String)extagentsList.get(0);
		}
	}
	else
	{
		rootJson.put("errorMsg","The component could not be created. External agent is not available for external monitoring.");
		rootJson.put("success","false");

		session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());
		out.println(rootJson.toString());
		return;
	}

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discover/Monitor");
	/* code for auditlog ends */

	ComponentAdd addcomp = new ComponentAdd(userId,hostname,sessionID);
	UserAssociateComponent addcomptouser = new UserAssociateComponent(userId,hostname,sessionID);

	Hashtable compdata = new Hashtable();
	compdata.put("componenttype",compType);
	if (hostip != null && hostip.trim().length() > 0)
	{
		compdata.put("hostip",hostip);
	}
	compdata.put("componentname",hostname);
	if (port != null && port.trim().length() > 0)
	{
		compdata.put("port",port);
	}
	compdata.put("remoteagent",remAgent);
	compdata.put("externalagent",extAgent);
	compdata.put("os","Other");
	compdata.put("mode","Other");
	compdata.put("agentless","yes");
	compdata.put("CompUserMapping","yes");
	compdata.put("uuiduser",userId); 
	String compStatus = addcomp.compValidation(compdata);
	if (port == null || port.trim().length() == 0)
	{ 
		port = "NULL";
	}

	if (compStatus != null && compStatus.equalsIgnoreCase("eG_CLI_0030"))
	{
		ServiceBean serbean = new ServiceBean();
		serbean.stopDiscovery();

		String compResult = addcomp.add(compdata);

		if (compResult != null && compResult.equalsIgnoreCase("eG_CLI_0030"))
		{
			/* code for auditlog starts */
			auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Discover/Monitor");
			
			auditLogThread.setValue("Description","Component "+hostname + " of type " +"$ctype$:"+compType + " has been created");
			auditLogThread.setValue("Activity","Add Component");

			auditLogThread.setCurrentValue("01~~Component Type","$ctype$:"+compType);
			auditLogThread.setCurrentValue("02~~Nick Name",hostname);
			auditLogThread.setCurrentValue("Agentless","Yes");
			auditLogThread.setCurrentValue("Remote Agent",remAgent);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			String compName = hostname + ":" + port;

			Hashtable usercompdata = new Hashtable();
			usercompdata.put("userid",userId);
			usercompdata.put("componenttype",compType);
			usercompdata.put("components",compName);
			String userCompStatus = addcomptouser.AssociateComponent(usercompdata);

			boolean autoCreateZoneForUser = EgUuidInfo.autoCreateZone();
			if (autoCreateZoneForUser && userCompStatus != null && userCompStatus.equalsIgnoreCase("eG_CLI_Res_0286"))
			{
				Hashtable argsMap = new Hashtable();
				argsMap.put("userid",userId);
				argsMap.put("stype",compType);
				argsMap.put("compname",compName);
				Hashtable resultStr2 = addcomptouser.AutoAssociateComponentToZone(argsMap);

				boolean allowZoneAssociation = (resultStr2.size() > 0);
				//for zone audit log
				String descMsg = "Zone "+ userId +" could not be added and associated to the user "+userId;
				AuditLogThread auditLogThread2 = new AuditLogThread();
				auditLogThread2.setValue("Category","Admin");
				auditLogThread2.setValue("User_id",_user.getLoginID());
				auditLogThread2.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditLogThread2.setValue("Session_id",session.getId());
				auditLogThread2.setValue("Module","Zones");
				auditLogThread2.setValue("Activity","Zone Configuration");
				if (allowZoneAssociation)
				{
					descMsg = "Zone "+ userId +" has been added and associated to the user "+userId+" successfully";
				}
				auditLogThread2.setValue("Description", descMsg);
				auditLogThread2.sendItToDB();
			}

			String testConfigParamsEntry = "";
			CompTypeUnconfigParams unconfigparams = new CompTypeUnconfigParams();
			ArrayList unconfiguredList = unconfigparams.getParameters(compType);
			if (unconfiguredList != null && unconfiguredList.size() > 0)
			{
				JSONArray testNameArray = new JSONArray();
				JSONArray encodeParamList = new JSONArray();
				if(session.getAttribute("encodeParamJsonList") != null)
				{
					encodeParamList = (JSONArray)session.getAttribute("encodeParamJsonList");
				}

				for (int i=0;i<unconfiguredList.size();i=i+2)
				{
					JSONObject testNameObj = new JSONObject();
					String name = (String)unconfiguredList.get(i);
					String strtestName = name.substring(1);
					ArrayList testDetails = (ArrayList)unconfiguredList.get(i+1);
					String testParamControl = (String)testDetails.get(0);
					String value = request.getParameter(strtestName);
					if(encodeParamList != null && encodeParamList.contains(strtestName))
					{
						value = EgUIUtils.decodeSecurityChar(value);
					}

					if (testParamControl.equalsIgnoreCase("password"))
					{
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (compType.equalsIgnoreCase("CitrixXenMobile"))
					{
						if (strtestName.equalsIgnoreCase("snmpCommunity"))
						{
							String[] testConfigParams = {"-snmpPort","-snmpversion","-snmpCommunity","-context","-username","-authpass","-authtype","-encryptflag","-encrypttype","-encryptpassword"};
							ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));
							String[] testConfigParamsControl = {"text","select","text","text","text","password","select","radio","select","password"};
							ArrayList testConfigParamsControlList = new ArrayList(Arrays.asList(testConfigParamsControl));
							for (int j=0;j<testConfigParamsList.size();j++)
							{
								String snmpParamName = (String)testConfigParamsList.get(j);
								String strSnmpParamName = snmpParamName.substring(1);
								String dispSnmpParamName = _mapping.getTextDescription("admin.test."+strSnmpParamName.toUpperCase());
								String snmpTestParamControl = (String)testConfigParamsControlList.get(j);
								String snmpValue = request.getParameter(strSnmpParamName);
								if(encodeParamList != null && encodeParamList.contains(strSnmpParamName))
								{
									snmpValue = EgUIUtils.decodeSecurityChar(snmpValue);
								}
								if (snmpValue != null && snmpValue.trim().length() > 0 && !snmpValue.equalsIgnoreCase("null"))
								{
									if (snmpTestParamControl.equalsIgnoreCase("password"))
									{
										snmpValue = EgCrypt.encrypt(snmpValue);
									}
									else
									{
										if (snmpValue.indexOf(" -") > -1)
										{
											if (!snmpValue.startsWith("\"") && !snmpValue.endsWith("\""))
											{
												snmpValue = "\"" + snmpValue + "\"";
											}
										}
									}
									testConfigParamsEntry +=" -"+strSnmpParamName+" "+snmpValue;
								}
							}
						}
						else
						{
							testConfigParamsEntry +=" -"+strtestName+" "+value;
						}
					}
					else
					{
						testConfigParamsEntry +=" -"+strtestName+" "+value;
					}
				}
			}

			if (testConfigParamsEntry != null && testConfigParamsEntry.trim().length() > 0)
			{
				IniFile discoverParamObj = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
				String key = compType+":"+hostname + ":" + port;
				discoverParamObj.setValue(compType,key,testConfigParamsEntry);
				discoverParamObj.saveFile();
				EgConfigFilesSync.releaseInstance(discoverParamObj);
			}

			rootJson.put("success","true");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0344"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the total monitors permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0345"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the premium monitors permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0346"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the network devices permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0347"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the named/concurrent users permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else
		{
			rootJson.put("success","false");
			rootJson.put("errorMsg","The component could not be created. Please contact the eG administrator.");
		}
		serbean.startDiscovery("1",true);
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0014"))
	{
		rootJson.put("errorMsg","The component could not be created. The nick name you are trying to add already exists. Please use another nick name");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0015"))
	{
		rootJson.put("errorMsg","The component could not be created. The nick name you are trying to add already exists in some other case. As the nick name is case insensitive, please use the old nick name.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0036"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the total number of applications permitted by your license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0035"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the total number of agents permitted by your license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0336"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of Total/Basic license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0337"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of Premium license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0338"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of User based license for named user. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0339"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of User based license for concurrent user. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0033"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of agentless components permitted by your license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}

	session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp?"+request.getQueryString());

	out.println(rootJson.toString());
%>



