<%
/*
 *	Name            :	EgconfigtestmeasurepJson.jsp
 *	Purpose         :	Processing page for EgConfigTestMeasure.jsp
 *	CreationDate	:	01/10/2001
 */
%>

<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "egurkha.ServiceBean"%>
<%@ page import = "egurkha.TestBean"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.JSONObject"%>

<%!
	private int getDbSize(int s)
	{
		int size=-1;
		switch(s)
		{
			case 1:size=32;break;
			case 2:size=64;break;
			case 3:size=128;break;
			case 4:size=256;break;
			case 5:size=512;break;
			case 6:size=1024;break;
		}
		return size;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	ServiceBean serviceBean = new ServiceBean();
	Hashtable factorsMapping = new Hashtable();
	//factorsMapping = (Hashtable) session.getAttribute("factorsMapping");
	//session.removeAttribute("factorsMapping");
	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String factors [] = iniUI.getVariables("CONVERSION_FACTORS");
	if(factors != null && factors.length > 0)
	{
		for (int i=0;i<factors.length;i++)
		{
			String var = (String) factors[i];
			String val = iniUI.getValue("CONVERSION_FACTORS", var);
			factorsMapping.put(val, var);
		}		
	}

	String add = request.getParameter("add");
	String test = request.getParameter("test");
	String measure = request.getParameter("measure");
	String factor = request.getParameter("factor");
	String dbSize = request.getParameter("dbsize");
	String unitA = request.getParameter("otherunit");
	String unitB = request.getParameter("un");
	String exceptionMsg = request.getParameter("alarmdescription");

	String path = request.getParameter("path");
	String loadPath = request.getParameter("loadPath");
	String loadLib = request.getParameter("loadLib");
	String lib = request.getParameter("lib");
	String index = request.getParameter("index");

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	int fileUploadSize = servicesInfo.maxFileUploadSizeForIC();

	TestBean testBean = new TestBean(true);
	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo(); //clustering
	String errorCode= null;//clustering

	boolean isConfigTest=EgInstallInfo.isConfigTest(test);
	boolean bDescriptorBasedTest=false;
	if(isConfigTest)
	{
		String strDescriptorBasedTest=request.getParameter("isDescriptorBasedTest");
		if(strDescriptorBasedTest!=null)
		{
			strDescriptorBasedTest=strDescriptorBasedTest.trim();
			if(strDescriptorBasedTest.equalsIgnoreCase("yes"))
				bDescriptorBasedTest=true;
		}
	}

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Configure Test");
	/* code for auditlog ends */
	if(add.equals("add"))
	{
		if(testBean.doesMeasureExistFor(measure, test))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Add Measure To Test"));
			String msg = _mapping.getTextDescription("admin.ic.You are trying to add a measure/db column name which is already existing for this test")+". ";
			msg += _mapping.getTextDescription("admin.ic.Please enter a new measure/db column name pair");
			rootJSON.put("AlertMsg",msg);
			
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","You are trying to add a measure/db column name " + measure + " which is already existing for the test " + test);
			else
				auditLogThread.setValue("Description","You are trying to add a measure/db column name " + measure + " which is already existing for the test " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
		else if(testBean.doesIndexExist(test, index))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Add Measure To Test"));
			String msg = _mapping.getTextDescription("admin.ic.You are trying to add an index which is already existing")+". ";
			msg += _mapping.getTextDescription("admin.ic.Please select a new index value");
			rootJSON.put("AlertMsg",msg);
			
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","You are trying to add an index " + index +" which is already existing " + test);
			else
			auditLogThread.setValue("Description","You are trying to add an index " + index +" which is already existing " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
		}
		else
		{
	
			String unit = null;
			if(unitA == null || unitA.length() == 0)
				unit = unitB;
			else
				unit = unitA;

			if(isConfigTest && (unit==null) )
				unit="NONE";
			
			/* code for auditlog starts */
			String myDbSize = "";
			if(dbSize != null && dbSize.equals("1"))
				myDbSize = "Number(7,4)";
			else if(dbSize != null && dbSize.equals("2"))
				myDbSize = "Number(20,4)";
			else if(dbSize != null && dbSize.equals("3"))
				myDbSize = "Number(16)";
		
			if(test.endsWith("_ex"))
				auditLogThread.setCurrentValue("01~~Test",test);
			else
				auditLogThread.setCurrentValue("01~~Test","$test$:"+test);
			auditLogThread.setCurrentValue("02~~Measure index",index);
			auditLogThread.setCurrentValue("03~~Measure name",measure);
			auditLogThread.setCurrentValue("04~~Database column size",myDbSize);
			auditLogThread.setCurrentValue("05~~Unit",unit);
			if(factor != null && factor.trim().length()>0 && !factor.equalsIgnoreCase("null") && !factor.equalsIgnoreCase("none"))
				auditLogThread.setCurrentValue("06~~Conversion factor",(String)factorsMapping.get(factor));

			/* code for auditlog ends */
			//testBean.addMeasureForTest(test, measure,dbSize, unit, index);
			if(exceptionMsg != null && exceptionMsg.trim().length()>0)
			{
				testBean.addMeasureForTestWithAlarm(test, measure,dbSize, unit, index, factor, exceptionMsg);
				auditLogThread.setCurrentValue("Alarm display string", exceptionMsg); 
			}
			else
			{
				if(!isConfigTest)
				{
					testBean.addMeasureForTest(test, measure,dbSize, unit, index, factor);
				}
				else
				{
					egurkha.MeasureInfo mi=new egurkha.MeasureInfo();
					mi.strTest = test;
					mi.strMeasure = measure;
					mi.strDbSize = dbSize;
					mi.strUnit = unit;
					mi.strIndex = index;
					mi.strFactor = factor;
					mi.bDescriptorBasedTest = bDescriptorBasedTest;
					testBean.addMeasureForTest(mi);
					auditLogThread.setCurrentValue("Is Descriptor Based Test", new Boolean(bDescriptorBasedTest).toString());
				}
			}
			//response.sendRedirect("EgConfigTestMeasure.jsp?" + "test=" + test);
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Measure " + measure + " has been added for the test " + test);
			else
				auditLogThread.setValue("Description","Measure " + measure + "has been added for the test " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
			//String ur = "EgConfigTestMeasure.jsp?test=" + test + "&unit=" + unit;
			String ur = "EgConfigTestMeasureJson.jsp?test=" + test + "&unit=" + "";

			rootJSON.put("AlertType","Result");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Add Measure To Test"));
			rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Measure has been added successfully"));
			rootJSON.put("forwardURL",ur);
		}
	}
	else if(add.equals("del"))
	{
		testBean.deleteMeasure(test, measure);

		//new code for checking measure index using reviseMeasureIndex method written in TestBean
		testBean.reviseMeasureIndex(test);
		//response.sendRedirect("EgConfigTestMeasure.jsp?" +"test=" + test);
		//String ur = "EgConfigTestMeasure.jsp?" +"test=" + test;
		String ur = "EgConfigTestMeasureJson.jsp?&test="+test+"&measure="+"";
		/* code for auditlog starts */
		if(test.endsWith("_ex"))
			auditLogThread.setValue("Description",measure + " measure for the test " + test +" has been deleted");
		else
			auditLogThread.setValue("Description",measure + " measure for the test " + "$test$:"+test +" has been deleted");
		auditLogThread.sendItToDB();
		/* code for auditlog ends */

		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Add Measure To Test"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Measure has been deleted successfully"));
		rootJSON.put("forwardURL",ur);
	}
	else if(add.equals("gen"))
	{
		testBean.deleteExistingTest(test);//added by James Thomas to remove records from measure_last and metatest tables for the given test if rows to the test exists.

		if(EgInstallInfo.isConfigTest(test))
		{
			testBean.setConfigTestFieldSize(test,getDbSize(Integer.parseInt(dbSize)));
			testBean.checkConfigMeasuresFor(test,bDescriptorBasedTest);
		}
		testBean.setThresholds(test);
		EgThresholdInfo.setUpdated();
		testBean.deleteEntries(test);
		//DbBean dbBean = new DbBean(true); //clustering
		if(loadPath != null && loadPath.equalsIgnoreCase("yes") && !testBean.loadClass(path, test))
		{
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Unable to load the class file " + path + " for the test "+ test);
			else
				auditLogThread.setValue("Description","Unable to load the class file " + path + " for the test "+ "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Generate a Test"));
			String msg = _mapping.getTextDescription("admin.ic.Unable to load the class file from")+" " + path+". ";
			msg += _mapping.getTextDescription("admin.ic.Please check if the class file is available in the specified path")+".";
			rootJSON.put("AlertMsg",msg);
		}
		else if(loadLib != null && loadLib.equalsIgnoreCase("yes") && !testBean.loadFile(lib, test))
		{
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Unable to load the library file " + lib + " for the test "+ test);
			else
				auditLogThread.setValue("Description","Unable to load the library file " + lib + " for the test "+ "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */
			
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Generate a Test"));
			String msg = _mapping.getTextDescription("admin.ic.Unable to load the library file")+" " + lib+". ";
			msg += _mapping.getTextDescription("admin.ic.Please check if the file is available in the specified path")+" ";
			msg += _mapping.getTextDescription("admin.user.and")+" <br>";
			msg += _mapping.getTextDescription("admin.ic.the file size should be lesser than ")+fileUploadSize+" MB";
			//msg += _mapping.getTextDescription("admin.ic.Please note files of size more than 0*5 MB may not be loaded")+". ";
			//msg += _mapping.getTextDescription("admin.ic.These files have to be added manually")+". <br>";
			//msg += _mapping.getTextDescription("admin.ic.Please refer User Manual on where to add these library files")+".";
			rootJSON.put("AlertMsg",msg);
		}
		else if(!testBean.checkIndices(test))
		{
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Inconsistent Measure Indices for the test " + test);
			else
				auditLogThread.setValue("Description","Inconsistent Measure Indices for the test " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Generate a Test"));
			String msg = _mapping.getTextDescription("admin.ic.Inconsistent Measure Indices")+". ";
			msg += _mapping.getTextDescription("admin.ic.Please update the measure indices correctly")+".";
			rootJSON.put("AlertMsg",msg);
		}
		else  if(updateICInfo.getConnection())   //if(dbBean.getConnection()) //clustering
		{
			//serviceBean.stopDiscovery(); //clustering
			String error = updateICInfo.setMeasures("custom",test);   //dbBean.setMeasuresFor(test);

			if(error != null && error.length() > 0)
			{
				//dbBean.releaseConnection(); //clustering
			
				/* code for auditlog starts */
				auditLogThread.setValue("Description","One or more database keywords are being used as test or measure names/The tablespace allocated to eG manager has no more space left to create tables");
				auditLogThread.sendItToDB();
				/* code for auditlog ends */

				rootJSON.put("AlertType","Error");
				rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Generate a Test"));
				String msg = _mapping.getTextDescription("admin.ic.eG manager failed to create the required tables and indices for the new test")+"."+"<br>";
				msg += _mapping.getTextDescription("admin.ic.Possible Reasons")+" :"+"<br>";
				msg += " 1) "+_mapping.getTextDescription("admin.ic.One or more database keywords are being used as test or measure names")+". ";
				msg += _mapping.getTextDescription("admin.ic.For Eg* \"varchar\", \"number\", \"offline\" e*t*c are database keywords")+". ";
				msg += _mapping.getTextDescription("admin.ic.One workaround is to use prefixes to existing test name/measure names")+". ";
				msg += _mapping.getTextDescription("admin.ic.Please change these appropriately and try again")+"<br>";
				msg += " 2) "+_mapping.getTextDescription("admin.ic.The tablespace allocated to eG manager has no more space left to create tables")+". ";
				msg += _mapping.getTextDescription("admin.ic.Please increase the tablespace size and try again")+". ";
				msg += _mapping.getTextDescription("admin.ic.For more information you can check /manager/logs/error_log in the installation directory")+".";
				rootJSON.put("AlertMsg",msg);
			}
			else
			{
				String ur = null;
				String ddForMeasure = request.getParameter("ddForMeasure");
				if (ddForMeasure != null && ddForMeasure.equalsIgnoreCase("yes"))
				{
					ur = "EgDiagnosisFormatJson.jsp?page=true&measure=&test="+test;
				}
				else
				{
					if(!EgInstallInfo.isConfigTest(test))
						ur = "EgDefaultJson.jsp?" + "t_name=" + test + "&server=null&qctr=0&page=true";
						//ur = "EgDefault.jsp?server=null&qctr=0&page=true&t_name=" + test;
					else
					{
						rootJSON.put("AlertType","Result");
						rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Add new tests"));
						rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.The test has been generated successfully")+".");
						//rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Changes have been updated successfully for the test")+" "+test);
					}
				}
				rootJSON.put("forwardURL",ur);
				/* code for auditlog starts */
				if(test.endsWith("_ex"))
					auditLogThread.setValue("Description","Changes have been updated for the test " + test);
				else
					auditLogThread.setValue("Description","Changes have been updated for the test " + "$test$:"+ test);
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
		}
		else
		{
			/* code for auditlog starts */
			if(test.endsWith("_ex"))
				auditLogThread.setValue("Description","Database connection failed while generating measures for the test " + test);
			else
				auditLogThread.setValue("Description","Database connection failed while generating measures for the test " + "$test$:"+test);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Generate a Test"));
			String msg = _mapping.getTextDescription("admin.ic.Database connection failed")+". ";
			msg += _mapping.getTextDescription("admin.ic.Please check if the database is up and try again")+".";
			rootJSON.put("AlertMsg",msg);
		}
	}
	out.println(rootJSON);
%>





