<%
/*
 *		Name			:		EgConfigJmxMeasureJson.jsp
 *		Purpose			:		IC Test - JMX Type - Configure
 */
%>

<%@ include file = "../../EgTrackerAJSON.jsp"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="egurkha.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	private int getConfigTestSizeIndex(int dbsize)
	{
		int val=-1;
		switch(dbsize)
		{
			case 32: val=1;break;
			case 64: val=2;break;
			case 128: val=3;break;
			case 256: val=4;break;
			case 512: val=5;break;
			case 1024: val=6;break;
		}
		return val;
	}

	private String [] processes = {"UNALTERED",
					"PERCENT_INCREASE",
					"PERCENT_DECREASE",
					"PERCENT_CHANGE",
					"RATIO",
					"RATE",
					"DIFFERENCE"
						};
%>

<%
	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	JSONObject obj = new JSONObject();

	String helpuploadDir=EgInstallInfo.getInstallDir()+	"/manager/tomcat/webapps/final/eghelp";
	helpuploadDir=StringUtils.replace(helpuploadDir,"\\","/");
	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String factors [] = iniUI.getVariables("CONVERSION_FACTORS");
	Hashtable factorsMapping = new Hashtable();
	if(factors != null && factors.length > 0)
	{
		for (int i=0;i<factors.length;i++)
		{
			String var = (String) factors[i];
			String val = iniUI.getValue("CONVERSION_FACTORS", var);
			factorsMapping.put(val, var);
		}
	}

	TestBean testBean = new TestBean(true);
	String test = request.getParameter("test");
	String mname = request.getParameter("measure");
	String dbsize = request.getParameter("dbsize");
	String unitValue = request.getParameter("unit");
	String otherUnitValue = request.getParameter("otherunit");
	String index = request.getParameter("index");
	String process = request.getParameter("process");
	String factor = request.getParameter("factor");
	String counter = request.getParameter("counter");
	String ctr = "";
	String mbeanValue ="";
	String mbeanOrgValue ="";
	boolean isMBeanSelected = false;
	String domainName = request.getParameter("domain");
	String selectedMbean = request.getParameter("mbean");
	String mbeanDispVal = request.getParameter("mbeanDispVal");
	String fromPage = request.getParameter("fromPage");

	if(domainName != null && domainName.length() > 0 && !domainName.equals(""))
	{
		session.setAttribute("domainName", domainName);
	}
	else
	{
		String tmpObj1 = testBean.getObject(test);
		domainName = tmpObj1;
	}
	if(selectedMbean != null && selectedMbean.length() > 0 && !selectedMbean.equals(""))
		session.setAttribute("selectedMbean", selectedMbean);
	
	if(mbeanDispVal != null && mbeanDispVal.length() > 0 && !mbeanDispVal.equals(""))
		session.setAttribute("mbeanDispVal", mbeanDispVal);
	

	Hashtable MBeanDetails = (Hashtable) session.getAttribute("MBeanDetails");
	Hashtable MBeans = new Hashtable();
	Hashtable attributeTable = new Hashtable();
	ArrayList attributes = new ArrayList();
	
	if((MBeanDetails != null && MBeanDetails.size() > 0) && domainName != null)
	{
		MBeans = (Hashtable) MBeanDetails.get(domainName);
		String tmpObj = testBean.getObject(test);
		if(!tmpObj.equals(domainName))
			testBean.setObject(test, domainName);
		MBeanDetails = null;
	}
	if(selectedMbean != null && selectedMbean.length() > 0 && !selectedMbean.equals("null") && !selectedMbean.equals("-1"))
	{
		attributeTable = (Hashtable) MBeans.get(selectedMbean);
		Set attributeSet = attributeTable.keySet();
		if(attributeSet != null)
		{
			Iterator itr = attributeSet.iterator();
			while(itr.hasNext())
			{
				String attribute = (String) itr.next();
				String value = (String) attributeTable.get(attribute);
				if(value != null)
				{
					if(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))
					{
						attributes.add(attribute);
					}
					else
					{
						try
						{
							double dd = Double.parseDouble(value);
						}
						catch(Exception e)
						{
							continue;
						}
						attributes.add(attribute);
					}
				}
			}
		}
	}
	Hashtable beanName = new Hashtable();

	if(selectedMbean == null)
		selectedMbean = "";

	List lst = new ArrayList();

	if(MBeans != null && MBeans.size() > 0)
	{
		Set keys = MBeans.keySet();
		Iterator itr = keys.iterator();
		while(itr.hasNext())
		{
			StringBuffer sb = new StringBuffer();
			String mBean = (String) itr.next();
			StringTokenizer st = new StringTokenizer(mBean, ",");
			while(st.hasMoreTokens())
			{
				String str = st.nextToken();
				if(str != null && str.indexOf("=") > -1)
				{
					sb.append(str.substring(str.indexOf("=")+1));
					if(st.hasMoreTokens())
						sb.append(":");
				}
			}
			lst.add(sb.toString());
			beanName.put(sb.toString(), mBean);
		}
	}

	Collections.sort(lst);
	Collections.sort(attributes);

	String scrollPosition = request.getParameter("position");
	scrollPosition = scrollPosition == null?"0":scrollPosition;

	//session.setAttribute("factorsMapping", factorsMapping);

	boolean isConfigTest = EgInstallInfo.isConfigTest(test);
	int iConfigFieldSize=new EgTesterInfo("manager").getConfigTestFieldSize(test);

	
	ArrayList measures = testBean.getMeasuresForTest(test);

	if(factor == null || factor.length() == 0 || factor.equals("null"))
		factor = "1";

	if(counter == null )
		counter = "";
	else
	{
		counter = counter.replace('*',' ');
		counter = counter.replace('|','%');
		counter = counter.trim();
	}

	String object = testBean.getObject(test);

	if(object == null)
		object = "";
//	if (domainName != null)
//		object = domainName;

	String instances = testBean.getInstances(test);
	if(instances == null )
		instances = "";

	String instances_neg = testBean.getInstancesNeg(test);
	if(instances_neg == null )
		instances_neg = "";
	ArrayList units = testBean.getAllUnits();
		Collections.sort(units);
	
	ArrayList measures_list = testBean.getMeasuresForTest(test);
	int i_mes_count = 0;
	if(measures_list != null)
	{
		i_mes_count = measures_list.size();
	}

	String size1 = "";
	String size2 = "";
	String size3 = "";
	String size4 = "";
	String size5 = "";

	if(mname == null || mname.length() == 0)
		mname = "";

	if(dbsize != null && dbsize.length() != 0)
	{
		if(dbsize.equals("1"))
			size1 = "selected";
		else if(dbsize.equals("2"))
			size2 = "selected";
		else if(dbsize.equals("3"))
			size3 = "selected";
	}

	String [] factorSel = new String[factors.length];
	for(int i=0; i<factorSel.length; i++)
	{
		if(iniUI.getValue("CONVERSION_FACTORS",(String)factors[i]).equals(factor))
			factorSel[i] = "selected";
		else
			factorSel[i] = "";
	}

	boolean isFactorEnabled = false;
	if(process == null)
	{
		isFactorEnabled = true;
	}
	else if(process.equals("UNALTERED") || process.equals("DIFFERENCE"))
	{
		isFactorEnabled = true;
	}
	String [] procSel = new String[processes.length];
	for(int i=0; i<procSel.length; i++)
	{
		if(processes[i].equals(process))
		{
			procSel[i] = "selected";
			
		}
		else
			procSel[i] = "";
	}

	Hashtable mbeanVals = testBean.getMbean(test);
	Hashtable procVals = testBean.getProcesses(test);
	Hashtable factVals = testBean.getFactors(test);

	IniFile iniUdtests = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_udtests.ini");
	String testType = iniUdtests.getValue("TYPE",test);
	String strJmxObject = "";
	if (testType != null && testType.equalsIgnoreCase("Jmx"))
	{
		strJmxObject = iniUdtests.getValue("OBJECTS",test);
	}
	rootJSON.put("existingJmxObj",strJmxObject);
	boolean bDescriptorBasedTest=false;
	if(isConfigTest)
	{
		bDescriptorBasedTest=testBean.isThisDescriptorBasedTest(test);
	}

	if(measures == null || measures.size() == 0)
	{
		rootJSON.put("noMeasuresAdded",true);
	}
	else
	{
		rootJSON.put("noMeasuresAdded",false);
		String key = null;
		String value = null;
		String unit = null;
		String tmpInd = null;
		String alarm_msg = null;
		Integer idx;
		String temp = null;
		String procVal = null;
		String factVal = null;
		String org_factor = null;
		String org_measure = null;
		String org_process = null;
		String org_counter = null;
		String ctr1 = null;
		String ctr2 = null;
		String tmpUnit = null;
		int ind = 0;
		int count = 0;
		JSONArray measureList = new JSONArray();
		for(int i=0; i<measures.size(); i++)
		{
			obj = new JSONObject();
			temp = (String) measures.get(i);
			ind = temp.indexOf(":");
			if(ind < 0)
				continue;
			if(!isConfigTest)
			{
				key = temp.substring(0, ind);
				temp = temp.substring(ind+1);
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;
				value = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;
				unit = temp.substring(0, ind);
				temp = temp.substring(ind + 1);
				//new code to effect alarm display string starts
				ind = temp.indexOf(":");
				if(ind < 0)
					continue;
				if(ind == 0)
				{
					alarm_msg = "";
					idx = new Integer(temp.substring(ind + 1));
				}
				else
				{
					alarm_msg = temp.substring(0, ind);//alarm msg
					idx = new Integer(temp.substring(ind + 1));
				}
				tmpInd = idx.toString();
				//new code to effect alarm display string ends
			}
			else
			{
				key = temp.substring(0, ind);       // measure name
				temp=temp.substring(ind+1);
				ind=temp.indexOf(":");
				if(ind < 0)
					continue;

				unit = temp.substring(0, ind);
				temp = temp.substring(ind + 1);

				idx = new Integer(temp.substring(0));
				tmpInd = idx.toString();
			}
			tmpUnit = "";

			if(unit.equals("%"))
			{
				tmpUnit = unit;
				for(int x=0;x<tmpUnit.length();x++)
				{
					if(tmpUnit.charAt(x) == '%')
						tmpUnit = tmpUnit.replace('%','|');
					else
						continue;
				}
			}
			else
			{
				tmpUnit = unit;
			}
			count++;

			if(procVals.containsKey(key))
				procVal = (String) procVals.get(key);

			if(factVals.containsKey(key))
				factVal = (String) factVals.get(key);

			ctr = testBean.getCounterOrOID(test,key,"counter");
			if(mbeanVals.containsKey(key))
			{
				mbeanValue = (String) mbeanVals.get(key);
				if(lst != null && lst.size() > 0)
				{
					for(int j=0; j<lst.size(); j++)
					{
						String mBean = (String) lst.get(j);
						String mapStr = (String) beanName.get(mBean);
						if(mBean.equals(mbeanValue))
						{
							mbeanOrgValue = mapStr;
						}
					}
				}
				obj.put("mbean",mbeanValue);
			}
			ctr1 = ctr;
			if(ctr1 != null && ctr1.length() > 0)
			{
				for(int x=0;x<ctr1.length();x++)
				{
					if(ctr1.charAt(x) == ' ')
						ctr1 = ctr1.replace(' ','*');
					else if(ctr1.charAt(x) == '%')
						ctr1 = ctr1.replace('%','|');
					else
						continue;
				}
			}
			boolean doesMbeanExist = testBean.doesMbeanExist(test,key);
			obj.put("doesMbeanExist",doesMbeanExist);
			String s_tmpInd = "";
			if(alarm_msg != null)
				s_tmpInd = alarm_msg+":"+tmpInd;
			else
				s_tmpInd = tmpInd;

			if(!isConfigTest)
			{
				if(tmpUnit.equals("|"))
					org_measure = key+":"+value+":"+tmpUnit+":"+ s_tmpInd;
				else
					org_measure = key+":"+value+":"+unit+":"+ s_tmpInd;
			}
			else
			{
				if(tmpUnit.equals("|"))
					org_measure = key+":"+tmpUnit+":"+ s_tmpInd;
				else
					org_measure = key+":"+unit+":"+ s_tmpInd;
			}
			org_process = key+":"+procVal;
			org_factor = key+":"+factVal;
			org_counter = key+":"+ctr;
			ctr2 = org_counter;
			for(int x=0;x<ctr2.length();x++)
			{
				if(ctr2.charAt(x) == ' ')
					ctr2 = ctr2.replace(' ','*');
				else if(ctr2.charAt(x) == '%')
					ctr2 = ctr2.replace('%','|');
				else
					continue;
			}
			obj.put("measureIndex",tmpInd);
			obj.put("measureName",key);
			String alrmMsg = (alarm_msg!=null)?EgURLEncoder.encode(alarm_msg,"UTF-8"):"";
			String modifyURL = "";
			String org_mbean = iniUdtests.getValue("MBEAN",test);
			if(fromPage != null && fromPage.equalsIgnoreCase("Modify"))
			{
				value = request.getParameter("dbsize");
				tmpUnit = request.getParameter("unit");
				procVal = request.getParameter("process");
				factVal = request.getParameter("factor");
				String selectedMbeanVal = "";
				if(mname.equals(key))
				{
					selectedMbeanVal = request.getParameter("mbean");
				}
				else
				{
					selectedMbeanVal = "";
				}
				
				if(factVal == null || factVal.equalsIgnoreCase("null") )
				{
					factVal = "";
				}
				Hashtable mbeanMeasure = testBean.getMbean(test);
				Enumeration enumVal = mbeanMeasure.keys();
				while(enumVal.hasMoreElements())
				{
					String mKey = (String) enumVal.nextElement();
					String mValue = (String) mbeanMeasure.get(mKey);
					if(mKey.equalsIgnoreCase(mname))
					{
						rootJSON.put("previousMBeanSelected",mValue);
					}
				}
				modifyURL = "EgModifyMeasuresJson.jsp?org_measure="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(org_measure),"UTF-8")+"&org_process="+org_process+"&org_factor="+org_factor+"&org_counter="+ctr2+"&test="+test+"&measure="+key+"&dbsize="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(value),"UTF-8")+"&unit="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(tmpUnit),"UTF-8")+"&index="+tmpInd+"&process="+procVal+"&factor="+factVal+"&counterVal="+ctr1+"&from=EgConfigJmxMeasure.jsp&alarmdescription="+alrmMsg+"&mbeanVal="+EgURLEncoder.encode(selectedMbeanVal,"UTF-8")+"&mbeanDispVal="+mbeanDispVal;
			}
			else
			{
				modifyURL = "EgModifyMeasuresJson.jsp?org_measure="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(org_measure),"UTF-8")+"&org_process="+org_process+"&org_factor="+org_factor+"&org_counter="+ctr2+"&test="+test+"&measure="+key+"&dbsize="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(value),"UTF-8")+"&unit="+EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(tmpUnit),"UTF-8")+"&index="+tmpInd+"&process="+procVal+"&factor="+factVal+"&counterVal="+ctr1+"&from=EgConfigJmxMeasure.jsp&alarmdescription="+alrmMsg+"&suriya=suriya&mbeanVal="+EgURLEncoder.encode(mbeanOrgValue,"UTF-8");//+"&org_mbean="+org_mbean;//mbeanOrgValue
			}//"&counter="+ctr1+
			String deleteURL = "EgconfigjmxmeasurepJson.jsp?add=del&test="+test+"&measure="+key;
			obj.put("modifyURL",modifyURL);
			obj.put("deleteURL",deleteURL);

			if(!isConfigTest)
			{
				String tempVal;
				tempVal = _mapping.getTextDescription("admin.ic."+value.substring(0,value.indexOf("(")));
				value=tempVal+value.substring(value.indexOf("("),value.length());
				obj.put("hideDatabaseColumnSize",false);
				obj.put("databaseColumnSize",value);
			}
			else
			{
				obj.put("hideDatabaseColumnSize",true);
			}
			obj.put("unit",unit);
			obj.put("processMethod",procVal);

			if(factVal != null && factVal.length() > 0 && !factVal.equals("none"))
			{
				obj.put("hideConversionFactor",false);
				obj.put("conversionFactor",factorsMapping.get(factVal).toString());
			}
			else
			{
				obj.put("hideConversionFactor",true);
			}
			if(!isConfigTest)
			{
				if((alarm_msg != null && alarm_msg.length()>0) )
				{
					obj.put("hideAlarmDispStr",false);
					obj.put("alarmDispString",alarm_msg);
				}
				else
				{
					obj.put("hideAlarmDispStr",true);
				}
			}
			obj.put("attributeName",ctr);
			measureList.add(obj);
		}
		rootJSON.put("measuresList",measureList);
		rootJSON.put("domainName",object);
		rootJSON.put("mBeansIncluded",instances);
		rootJSON.put("mBeansExcluded",instances_neg);

		if(isConfigTest)
		{
			int ss=getConfigTestSizeIndex(iConfigFieldSize);
			JSONArray dbCols = new JSONArray();
			String[] dbColsDisp = new String[]{"32","64","128","256","512","1024"};
			String[] dbColsVal = new String[]{"1","2","3","4","5","6"};
			for (int i=0; i<dbColsDisp.length; i++)
			{
				obj = new JSONObject();
				obj.put("displayField",dbColsDisp[i]);
				obj.put("valueField",dbColsVal[i]);
				dbCols.add(obj);
			}
			rootJSON.put("dbColSizeList",dbCols);
			rootJSON.put("dbColSizeSelected",ss+"");
			rootJSON.put("descriptorBasedTestCheck",bDescriptorBasedTest?"checked":"");
		}
		hiddens.put("add","gen");
		hiddens.put("test",test);
	}
	hiddens.put("configtestflag",(isConfigTest?"true":""));
	hiddens.put("domain",domainName);
	hiddens.put("mbean",selectedMbean);

	rootJSON.put("measIndex",(++i_mes_count)+"");
	rootJSON.put("measNameValue",mname);

	if(!isConfigTest)
	{
		JSONArray dbCols = new JSONArray();
		String num = _mapping.getTextDescription("admin.ic.Number");
		String[] dbColsDisp = new String[]{num+"(20,4)",num+"(7,4)",num+"(16)"};
		String[] dbColsVal = new String[]{"2","1","3"};
		for (int i=0; i<dbColsDisp.length; i++)
		{
			obj = new JSONObject();
			obj.put("displayField",dbColsDisp[i]);
			obj.put("valueField",dbColsVal[i]);
			dbCols.add(obj);
		}
		rootJSON.put("dbColSizeList",dbCols);
		if (dbsize == null)
			dbsize = "2";
		rootJSON.put("dbColSizeSelected",dbsize);
	}
	if(unitValue == null || unitValue.length() == 0 || unitValue.equals("-1"))
	{
		JSONArray unitsArr = new JSONArray();
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
		obj.put("valueField","-1");
		unitsArr.add(obj);

		if(units != null && units.size() > 0)
		{
			for(int i=0; i<units.size(); i++)
			{
				String un = (String) units.get(i);
			//	if(un.equals("%"))
			//		continue;
				obj = new JSONObject();
				obj.put("displayField",un);
				obj.put("valueField",un);
				unitsArr.add(obj);
			}
		}
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
		obj.put("valueField","other");
		unitsArr.add(obj);
		rootJSON.put("unitsList",unitsArr);
		rootJSON.put("unitSelected","-1");
	}
	else if(!unitValue.equals("other") && !unitValue.equals("-1"))
	{
		JSONArray unitsArr = new JSONArray();
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
		obj.put("valueField","-1");
		unitsArr.add(obj);

		if(units != null && units.size() > 0)
		{
			for(int i=0; i<units.size(); i++)
			{
				String selected = "";
				String un = (String) units.get(i);
			//	if(un.equals("%"))
			//		continue;
				if(un.equals(unitValue))
				{
					rootJSON.put("unitSelected",un);
				}
				obj = new JSONObject();
				obj.put("displayField",un);
				obj.put("valueField",un);
				unitsArr.add(obj);
			}
		}
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
		obj.put("valueField","other");
		unitsArr.add(obj);
		rootJSON.put("unitsList",unitsArr);
	}
	else
	{
		JSONArray unitsArr = new JSONArray();
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a unit"));
		obj.put("valueField","-1");
		unitsArr.add(obj);

		if(units != null && units.size() > 0)
		{
			for(int i=0; i<units.size(); i++)
			{
				String un = (String) units.get(i);
			//	if(un.equals("%"))
			//		continue;
				obj = new JSONObject();
				obj.put("displayField",un);
				obj.put("valueField",un);
				unitsArr.add(obj);
			}
		}
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Other"));
		obj.put("valueField","other");
		unitsArr.add(obj);
		rootJSON.put("unitSelected","other");
		rootJSON.put("unitsList",unitsArr);
		rootJSON.put("showOtherTextBox",true);
		if (otherUnitValue != null && !otherUnitValue.equals(""))
			rootJSON.put("otherUnitValue",otherUnitValue);
	}

	JSONArray processArr = new JSONArray();
	rootJSON.put("selectedProcessMethod",processes[0]);
	for(int i=0; i<processes.length; i++)
	{
		String tmpProc = processes[i];
		String tmpSel = procSel[i];
		obj = new JSONObject();
		obj.put("displayField",tmpProc);
		obj.put("valueField",tmpProc);
		if (tmpSel.equals("selected"))
		{
			rootJSON.put("selectedProcessMethod",tmpProc);
		}
		processArr.add(obj);
	}
	rootJSON.put("processMethodList",processArr);

	if(isFactorEnabled)
	{
		rootJSON.put("hideConvFactor",false);
		JSONArray convFacts = new JSONArray();

		String tmpFact = "none";
		for(int i=0; i<factors.length; i++)
		{
			String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
			String tmpSel = factorSel[i];
			if(tmpSel.equals("selected"))
			{
				tmpFact = fact;
				rootJSON.put("convFactorSelected",fact);
			}
			obj = new JSONObject();
			obj.put("valueField",fact);
			obj.put("displayField",factors[i].toString());
			convFacts.add(obj);
		}
		rootJSON.put("convFactorList",convFacts);
		hiddens.put("factor",tmpFact);
	}
	else
	{
		rootJSON.put("hideConvFactor",true);
	}
	if(!isConfigTest)
	{
		rootJSON.put("hideAlarmDispStr",false);
		String alarmDisplay= request.getParameter("alarmDisplay");
		if (alarmDisplay == null)
		{
			alarmDisplay = "";
		}
		rootJSON.put("alarmDispStrValue",alarmDisplay);
	}
	rootJSON.put("mBeansListShow",false);
	obj.put("hidembean",true);
	if(lst != null && lst.size() > 0)
	{
		rootJSON.put("mBeansListShow",true);
		obj.put("hidembean",false);
		JSONArray mBeansArr = new JSONArray();
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select an MBean"));
		obj.put("valueField","-1");
		mBeansArr.add(obj);
		rootJSON.put("mBeanSelected","-1");
		String tmpSelect = "";
		for(int i=0; i<lst.size(); i++)
		{
			String mBean = (String) lst.get(i);
			String mapStr = (String) beanName.get(mBean);
			if(mapStr.equals(selectedMbean))
			{
				rootJSON.put("mBeanSelected",mapStr);
			}
			obj = new JSONObject();
			obj.put("displayField",mBean);
			obj.put("valueField",mapStr);
			mBeansArr.add(obj);
		}
		rootJSON.put("mBeansList",mBeansArr);
	}
	if(attributes != null && attributes.size() > 0)
	{
		rootJSON.put("attributesInputType","combo");
		JSONArray attrArr = new JSONArray();
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select an attribute"));
		obj.put("valueField","-1");
		attrArr.add(obj);
		rootJSON.put("attributeSelected","-1");
		//String tmpSelect = "";
		for(int i=0; i<attributes.size(); i++)
		{
			String attr = (String) attributes.get(i);
			obj = new JSONObject();
			obj.put("displayField",attr);
			obj.put("valueField",attr);
			attrArr.add(obj);
		}
		rootJSON.put("attributesList",attrArr);
		//hiddens.put("counter","");
	}
	else
	{
		rootJSON.put("attributesInputType","text");
		rootJSON.put("attributeValue",counter);
	}
	hiddens.put("add","add");
	hiddens.put("test",test);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>


